# regress.sh
# rserv regression test script
# (c) 2000 Thomas Lockhart, PostgreSQL Inc.
# Some parts adapted by Justin Clift
# to eRServer 1.2

dropdb master
dropdb slave

createdb master
createdb slave

#MasterInit master
#SlaveInit slave

psql -c "create table t1 (i int, t text, d timestamp default text 'now');" master
#MasterAddTable master t1 d

psql -c "create table t1 (i int, t text, d timestamp default text 'now');" slave
#SlaveAddTable slave t1 d

ers_setup --masterdb=master --slavedb=slave

# Start eRServer
ers_ctl start

# Wait for eRServer to be operating
sleep 10

psql -c "insert into t1 values (1, 'one');" master
psql -c "insert into t1 values (2, 'two');" master

#Replicate master slave
MasterSync master `GetSyncID --noverbose slave`

psql -c "insert into t1 values (3, 'three');" master
psql -c "insert into t1 values (4, 'four');" master

#Replicate master slave
MasterSync master `GetSyncID --noverbose slave`

# Stop eRServer
ers_ctl stop

exit
