/*
 * $Source: /opt/cvsroot/erserver/src/com/postgres/replic/util/AbstractInitializable.java,v $
 * $Author: ronz $ $Revision: 1.1.1.1 $ $Date: 2003/10/21 13:01:38 $
 *
 */
package com.postgres.replic.util;

import com.postgres.util.Logger.*;

/**
 *  
 *
 */
public abstract class AbstractInitializable {
	public final static int T_NO = -1;
	public final static int T_NULL = 0;
	private boolean debug = false;
	private boolean initialized = false;
	private boolean verbose = false;

	/**
	 *  Gets the debug attribute
	 *
	 * @return    The debug value
	 */
	public boolean getDebug() {
		return debug;
	}

	/**
	 *  Gets the verbose attribute
	 *
	 * @return    The verbose value
	 */
	public boolean getVerbose() {
		return verbose;
	}

	/**
	 *  Description of the Method
	 *
	 * @return    Return Value
	 */
	public boolean initialized() {
		return initialized;
	}

	/**
	 *  Sets the debug attribute
	 *
	 * @param  debug  The new debug value
	 */
	public void setDebug(boolean debug) {
		this.debug = debug;
	}

	/**
	 *  Sets the verbose attribute
	 *
	 * @param  verbose  The new verbose value
	 */
	public void setVerbose(boolean verbose) {
		this.verbose = verbose;
	}


	/**
	 *  Gets the logger attribute
	 *
	 * @return    The logger value
	 */
	protected Logger getLogger() {
		return LogRepl.getInstance();
	}

	/**
	 *  Sets the initialized attribute
	 *
	 * @param  initialized  The new initialized value
	 */
	protected void setInitialized(boolean initialized) {
		this.initialized = initialized;
	}
}

