#!/usr/bin/env python

""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

import SocketServer
from qmlservhandler import *
from pgmlgraph import *
import sys
import getopt
from object import *
from log import *
from common import *

class QmlServ(SocketServer.ForkingTCPServer):
	
	def __init__(self, server_address, RequestHandlerClass):
		SocketServer.ForkingTCPServer.__init__(self, server_address, RequestHandlerClass)
		
def main():

	"""
	qmlserv : the qml server

	usage: qmlserv -f <pgmlfile> -u <dbuser> [ -p <dbpassword> ] -d <target db> -l <log file> [-h] 
	-h : this help
	-f : pgml file
	-l : log file
	-u : db user
	-p : db password
	-d : dbname@dbhost
	"""
	try:
		opts, args = getopt.getopt(sys.argv[1:], 'f:hu:p:d:tl:')
	except getopt.error, msg:
		usage(msg)

	debug = PYTHONDEBUG
	DBNAME, DBHOST, DBPORT, DBUSER, DBPWD = '', 'localhost', 5432, '', ''
	pgmlFilename = ''
	targetDb = ''
	logFilename = 'qmlserv.log'
	
	for o, a in opts:
		if o == '-f': pgmlFilename = a
		if o == '-h': usage(main.__doc__)
		if o == '-t': debug = 1
		if o == '-u': DBUSER = a
		if o == '-p': DBPWD = a
		if o == '-d': targetDb = a
		if o == '-l': logFilename = a
		
	if not pgmlFilename: usage(main.__doc__,'error : missing pgml file')
	
	if targetDb: 
		l = split(targetDb, '@')
		if len(l) == 1:
			DBNAME = l[0]
			DBHOST = 'localhost'
		elif len(l) == 2:
			DBNAME,DBHOST = l
			
#	else:
#		usage(main.__doc__,'error : missing target db')

#	if not DBUSER: usage(main.__doc__,'error : missing db user')

	log = LOG(logFilename)
	
	pgmlgraph = PgmlGraph('PgmlGraph',debug,'uid',1,0,'0',1);

	log.message("reading pgml file")
	pgmlgraph.read(pgmlFilename)
	log.message("simplifying pgml graph")	
	pgmlgraph.simplify()
	
	QmlServHandler.pgmlgraph = pgmlgraph
	QmlServHandler.DBNAME = DBNAME
	QmlServHandler.DBHOST = DBHOST
	QmlServHandler.DBUSER = DBUSER
	QmlServHandler.DBPWD = DBPWD
	QmlServHandler.DBPORT = DBPORT
	QmlServHandler.log = log
	QmlServHandler.debug = debug
	
	while 1:
		try:
			log.message("trying to start QmlServ ...\n")
			log.flush()
			qmlServer = QmlServ(("",5000),QmlServHandler)
			qmlServer.serve_forever()
		except:
			log.message("trying to start QmlServ again ...\n")
			sleep(5)
			pass
		
	log.flush()
	
if __name__ == '__main__':
	main()
