""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

from xml.parsers.xmlproc import xmlproc
from pgmlgraph import *

class DtdGraph(PgmlGraph):
	"the PgmlGraph builded from a dtd"

	class DtdHandler(xmlproc.DTDConsumer):

		def __init__(self, parser, graph):
			xmlproc.DTDConsumer.__init__(self,parser)
			self.graph = graph
			
		def new_attribute(self,elem,attr,a_type,a_decl,a_def):
			self.graph.insert(Table(elem)).object.insert_attribute(attr,'type','text')

		def new_element_type(self,elem_name,elem_cont):
			table = self.graph.insert(Table(elem_name)).object
			if elem_cont != 'EMPTY':
				for sons in elem_cont[1]:
					sonTableName = sons[0]

					if sonTableName == '#PCDATA':
						table.insert_attribute('PCDATA','type','text')
					else:
						sonTable = self.graph.insert(Table(sonTableName)).object
						relation = self.graph.insert(Relation("%s_to_%s" % (str(sonTable), str(table)))).object
						self.graph.insert_edge(relation,'0,1,1',sonTable)
						self.graph.insert_edge(relation,'0,n,0',table)
					
	def __init__(self, name = 'DtdGraph', debug = None):
		PgmlGraph.__init__(self, name, debug)

	def read(self, filename):
		p=xmlproc.DTDParser()
		p.set_dtd_consumer(self.DtdHandler(p, self))
		p.parse_resource(filename)
		p.close()

