/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.largeobject;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.postgresql.fastpath.Fastpath;
import org.postgresql.fastpath.FastpathArg;
import org.postgresql.largeobject.BlobInputStream;
import org.postgresql.largeobject.BlobOutputStream;

public class LargeObject {
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;
    private Fastpath fp;
    private int oid;
    private int fd;
    private BlobOutputStream os;
    private boolean closed = false;

    protected LargeObject(Fastpath fastpath, int n, int n2) throws SQLException {
        this.fp = fastpath;
        this.oid = n;
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(n), new FastpathArg(n2)};
        this.fd = fastpath.getInteger("lo_open", fastpathArgArray);
    }

    public void close() throws SQLException {
        if (!this.closed) {
            if (this.os != null) {
                try {
                    try {
                        this.os.flush();
                    }
                    catch (IOException iOException) {
                        throw new SQLException(iOException.getMessage());
                    }
                    Object var2_2 = null;
                    this.os = null;
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    this.os = null;
                    throw throwable;
                }
            }
            FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd)};
            this.fp.fastpath("lo_close", false, fastpathArgArray);
            this.closed = true;
        }
    }

    protected void finalize() throws SQLException {
        this.close();
    }

    public InputStream getInputStream() throws SQLException {
        return new BlobInputStream(this);
    }

    public int getOID() {
        return this.oid;
    }

    public OutputStream getOutputStream() throws SQLException {
        if (this.os == null) {
            this.os = new BlobOutputStream(this);
        }
        return this.os;
    }

    public byte[] read(int n) throws SQLException {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(n)};
        return this.fp.getData("loread", fastpathArgArray);
    }

    public int read(byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2 = this.read(n2);
        if (byArray2.length < n2) {
            n2 = byArray2.length;
        }
        System.arraycopy(byArray2, 0, byArray, n, n2);
        return n2;
    }

    public void seek(int n) throws SQLException {
        this.seek(n, 0);
    }

    public void seek(int n, int n2) throws SQLException {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(n), new FastpathArg(n2)};
        this.fp.fastpath("lo_lseek", false, fastpathArgArray);
    }

    public int size() throws SQLException {
        int n = this.tell();
        this.seek(0, 2);
        int n2 = this.tell();
        this.seek(n, 0);
        return n2;
    }

    public int tell() throws SQLException {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd)};
        return this.fp.getInteger("lo_tell", fastpathArgArray);
    }

    public void write(byte[] byArray) throws SQLException {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(byArray)};
        this.fp.fastpath("lowrite", false, fastpathArgArray);
    }

    public void write(byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.write(byArray2);
    }
}

