<?php
///////////////////////////////////////////////////////////////////////
// --------------------------------------------------------------------
// DATA VALIDATION AND MANIPULATION FUNCTIONS
// --------------------------------------------------------------------
///////////////////////////////////////////////////////////////////////
// DEBUG MODE
$VALIDATE=TRUE;
$debug_mode = 1;	// SET TO 1 TO DISPLAY DEBUG MESSAGES
// GENERAL
$blank = 0;		// FLAG: SET TO 1 IF OPERATION FAILS
$i = 0;			// COUNTER
$msg = "";		// MESSAGES
$nl = "\r\n";		// NEW LINE
$rs = "Rs. ";		// CURRENCY PREFIX
$numValue = 0;		// NUMERICAL VALUE PASSED BETWEEN FUNCTIONS
$variables;             // GET OR POST FORM VARIABLES
$result;
$iso_dte;
$ind_dte;
$max_cur = 999999999;
$min_cur = -999999999;
$white_space='&nbsp;';
if ($debug_mode==1){
    $reasons[]="Debug Mode:";
    } else {
    $reasons[] = "Reasoning:";
}

// data validation functions:
// is_long(); is_double(); is_string(); is_array(); is_object() are standard functions
// is_email() @ is_eml(); is_date() @ is_dte() functions are defined here

// data manipulation functions:
// stripCharsInBag($txt, $bag); stripCharsNotInBag($txt, $bag)

function get_variables(){
    // GET FORM DATA
    global $HTTP_GET_VARS;
    global $HTTP_POST_VARS;
    global $REQUEST_METHOD;
    global $variables;
    global $reasons;
    $variables = strtolower($REQUEST_METHOD) == 'get' ? $HTTP_GET_VARS : $HTTP_POST_VARS;
    $reasons[] = "starting get_variables()...";
    while(list($key, $value)=each($variables)){
        if (is_array($value)){
        } else {         
	    $variables[$key]=trim($value);
            $GLOBALS[$key]=$variables[$key];
	    $reasons[]=$white_space . $whitespace . $key . ":" . $value;
	}
    }
    $reasons[] = "get_variables() done and returned array";
    return $variables;
}

function make_double($txt){
    // FORCES $txt INTO A NUMBER BY CAST FUNCTION
    global $reasons;
    $result = stripCharsNotInBag($txt, "e1234567890.-");
    $result = (double) $result;
    $reasons[] = "make_double(" . $txt . ") returned " . $result;
    return $result;
}

function make_cur($txt){ 
    // FORCES $txt INTO A CURRENCY BY CAST FUNCTION
    global $reasons;
    $result = str_replace("/", ".", $txt);
    $result = stripCharsNotInBag($result, "1234567890.-");
    $result = (double) $result;
    $result = round_cur($result);
    $reasons[] = "make_cur(" . $txt . ") returned " . $result;
    return $result;
}

function make_integer($txt){
    // FORCES $txt INTO AN INTEGER BY ROUNDING
    global $reasons;
    $result = stripCharsNotInBag($txt, "1234567890.-");
    $result = (double) $result;
    $result = round($result);
    $reasons[] = "make_integer(" . $txt . ") returned " . $result;
    return $result;
}
/*
function is_numeric($num){
    // TODO: *NOT WORKING*
    // RETURNS 1 IF $num IS A NUMBER AND 0 IF NOT A NUMBER
    global $reasons;
    // valid numbers;
    // 0       1      0.1      -2       -2.34       +34.534	
    //if (is_double($num) || is_long($num)){ //bug in is_double() and is_long()//
    //if (eregi("^([0-9]+|[0-9]{1,3}(,[0-9]{3})*)(\.[0-9]{1,2})?$", $num)){  //currencies//
    if (eregi("^([0-9]|\\+|\\-])[0-9].*", $num)){
	$reasons[] = "Valid $key : $value : Reg Exp Result: $num_result<br>";
	$result=1;
	} else {
	$result=0;
	$reasons[] = "Invalid $key : $value : Reg Exp Result: $num_result<br>";
    }
    $reasons[] = "is_numeric(" . $num . ") returned " . $result;
    return $result;
}
*/ 

function is_true_integer($txt){
    // RETURNS 1 IF $txt IS AN INTEGER AND 0 IF FALSE
    global $reasons;
    //TODO
}

function is_pln($txt){
    // RETURNS 1 IF $txt IS A POSITIVE INTEGER AND 0 IF FALSE
    global $reasons;
    $num = make_integer($txt);
    if($num >= 0){
	    $result = 1;
	    } else {
	    $result = 0;
    }
    $reasons[]="is_pln(" . $txt . ") returned " . $result;
    return $result;
}

function is_nln($txt){
    // RETURNS 1 IF $txt IS A NEGATIVE INTEGER AND 0 IF FALSE
    global $reasons;
    $num = make_integer($txt);
    if($num <= 0){
	    $result = 1;
	    } else {
	    $result = 0;
    }
    $reasons[]="is_nln(" . $txt . ") returned " . $result;
    return $result;
}


function is_pft($txt){
    // RETURNS 1 IF $txt IS A POSITIVE FLOAT AND 0 IF FALSE
    global $reasons;
    $num = make_double($txt);
    if($num >= 0){
	    $result = 1;
	    } else {
	    $result = 0;
    }
    $reasons[]="is_pft(" . $txt . ") returned " . $result;
    return $result;
}

function is_nft($txt){
    // RETURNS 1 IF $txt IS A NEGATIVE FLOAT AND 0 IF FALSE
    global $reasons;
    $num = make_double($txt);
    if($num <= 0){
	    $result = 1;
	    } else {
	    $result = 0;
    }
    $reasons[]="is_nft(" . $txt . ") returned " . $result;
    return $result;
}

function is_ngz($txt){
    // RETURNS 1 IF $txt IS A NUMBER GREATER THAN ZERO
    global $reasons;
    $num = make_double($txt);
    if($num > 0){
	    $result = 1;
	    } else {
	    $result = 0;
    }
    $reasons[]="is_ngz(" . $txt . ") returned " . $result;
    return $result;
}

function is_pcr($txt){
    //RETURNS 1 IF $txt IS A VALID POSITIVE CURRENCY AND 0 IF FALSE
    global $reasons;
    $numValue = make_cur($txt);
    if ($numValue >= 0){
	$result = 1;
	} else {
	$result = 0;
    }
    $reasons[] = "is_pcr(" . $txt . ") returned " . $result;
    return $result;	
}

function is_ncr($txt){
    //RETURNS 1 IF $txt IS A VALID NEGATIVE CURRENCY AND 0 IF FALSE
    global $reasons;
    $numValue = make_cur($txt);
    if ($numValue <= 0){
	$result = 1;
	} else {
	$result = 0;
    }
    $reasons[] = "is_ncr(" . $txt . ") returned " . $result;
    return $result;	
}

function is_email($txt){
    // RETURNS 1 IF $txt IS A VALID EMAIL ADDRESS AND 0 IF FALSE
    global $reasons;
    if (eregi("^([a-z0-9_]|\\-|\\.)+@(([a-z0-9_]|\\-)+\\.)+[a-z]{2,4}$", $txt)) {		
	$result = 1;
	} else {
	$result = 0;
    }
    $reasons[]="is_email(" . $txt . ") returned " . $result;
    return $result;
}

function is_eml($txt){
    // ALIAS FOR is_email FUNCTION
    $result = is_email($txt);
    return $result;
}

function is_url($txt){
    //  RETURNS 1 IF $txt IS A VALID URL AND 0 IF FALSE 
    global $reasons;
    $not_url=0;
    $reasons[]="is_url() started ...";
    $url_parts = parse_url($txt);
	if((empty($url_parts)) or (!$url_parts)){
		$result = 0;
		} else {
		if (empty($url_parts[scheme])){
			$reasons[]="Input $txt devoid of scheme";
			$result=0;
			$not_url=1;
		}
		if (empty($url_parts[host])){
			$reasons[]="Input $txt devoid of host";
			$result=0;
			$not_url=1;
		}
		if ($not_url != 1){ 
			$result = 1;
		}
	}
	$reasons[]="is_url(" . $txt . ") returned " . $result;
	return $result;
}

function is_date($txt){
    //  RETURNS 1 IF $txt IS A VALID DATE AND 0 IF FALSE 
    //  iso_dte SET TO ISO-8601 FORMAT YYYY-MM-DD DATE SUITABLE FOR POSTGRES
    //  ind_dte SET TO INDIAN DATE FORMAT DD-MM-YYYY WITH - AS DELIMITER
    global $reasons;
    global $iso_dte;
    global $ind_dte;
    list( $day, $month, $year ) = split( '[/.-]', $txt );
    // CHECK USING CHECKDATE FUNCTION
    if (checkdate($month, $day, $year)==1){
	$result = 1;
	$iso_dte = $year . "-" . $month . "-" . $day;
	$ind_dte = $day . "-". $month . "-" . $year;
    } else {
	$result = 0;
	$iso_dte = "";
	$ind_dte = "";
    }
    // RULE OUT EMPTY VALUES
    if (empty($day) || empty($month) || empty($year)){
	$result = 0;
	$iso_dte = "";
	$ind_dte = "";
    }
    $reasons[]="is_date(" . $txt . ") returned " . $result . " ; iso_dte = " . $iso_dte . " ; ind_dte = " . $ind_dte;
    return $result;
}

function is_dte($txt){
    // ALIAS FOR is_date FUNCTION
    $result = is_date($txt);
    return $result;
}

function is_required_filled(){
    // RETURNS 0 IF REQUIRED FIELDS ARE FILLED AND 1 IF NOT FILLED
    // CHECKS IF THE FOURTH CHAR OF AN INPUT ELEMENT NAME IS "R"
    global $reasons;
    global $variables;
    get_variables();
    $form_filled=1;
    if (!empty($variables)){	
     reset($variables);		
   	while (list($key, $value)=each($variables)) {
    	    $test_key = substr($key, 3, 1);
	    $test_key = strtoupper($test_key);
    	    if ($test_key=="R"){
		$test = trim($value);
		if ($test == ""){
		   $reasons[] = "$key is empty";
                   if ($form_filled == 1){
                      $form_filled = 0;
                   }
                }
            }
	}
    }
    $reasons[] = "is_required_filled() returned  $form_filled";
    return $form_filled;    
}

function is_valid_form_data(){
    // RETURN 1 IF VALID FORM DATA AND 0 IF FALSE
    // CHECK_1: CHECK IF REQUIRED DATA IS FILLED
    // CHECK_2: CHECK VALIDITY OF DATA
    // CHECK_3: RANGE VALIDATION : *NOT* DONE HERE.
    global $reasons;
    global $variables;
    get_variables(); 
    $reasons[] = "starting is_valid_form_data() ...";
    $reasons[] = count($variables);
    $check_1 = is_required_filled();
    if (($check_1) == 0){
	// Check 1 FAILED.
        $reasons[] = "Required particulars not furnished.";
        return 0;
    }   
    if (!empty($variables)){
        reset($variables);
	$result = 0;				
	while (list($key, $value)=each($variables)) {
	    if (!is_array($value)){	    
		$test_key = substr($key, 0, 3);
		$test = 1;	
		if ($test_key=="int") {
		    $value = make_integer($value);
			
		    } elseif ($test_key=="pln"){
		    $test = is_pln($value);
			
		    } elseif ($test_key=="nln"){
		    $test = is_nln($value);

		    } elseif ($test_key=="flt") {
		    $value = make_double($value);

		    } elseif ($test_key=="pft") {
		    $test = is_pft($value);

		    } elseif ($test_key=="nft") {
		    $test = is_nft($value);			

		    } elseif ($test_key=="dte") {
		    $test = is_date($value);

		    } elseif ($test_key=="cur") {
		    $value = make_cur($value);

		    } elseif ($test_key=="pcr") {
		    $test = is_pcr($value);

		    } elseif ($test_key=="ncr") {
		    $test = is_ncr($value);

		    } elseif (($test_key=="drt") || ($test_key=="crt")) {
		    $test = is_ngz($value);

		    } elseif ($test_key=="eml") {
		    $test = is_email($value);

		    } elseif ($test_key=="url") {
		    $test = is_url($value);	

		    } elseif ($test_key=="tau") {
		    $getVal = getTextAreaUnit($value);
		    $getVal = convertToSqFt($value);
		    $getVal = convertSqFtToOU($value);

		    } elseif ($test_key=="aur") {
		    $getVal = convertRateToSqFt($value);
		    $getVal = convertRateSqFtToOU($value);
			
		    } elseif ($test_key=="tlu") {
		    $getVal = getTextLengthUnit($value);
		    $getVal = convertToM($value);
		    $getVal = convertMToOU($value);

		    } elseif ($test_key=="lur"){
		    $getVal = convertRateToM($value);
		    $getVal = convertRateMToOU($value);

		    } elseif ($test_key=="twu"){
		    $getVal = convertToG($value);
		    $getVal = convertGToOU($value);

		    } elseif ($test_key=="wur"){
		    $getVal = convertRateToG($value);
		    $getVal = convertRateGToOU($value);

		    } elseif ($test_key=="tvu"){
		    $getVal = convertToL($value);
		    $getVal = convertLToOU($value);

		    } elseif ($test_key=="vur"){
		    $getVal = convertRateToL($value);
		    $getVal = convertRateLToOU($value);

		    } elseif ($test_key=="tnu"){
		    $getVal = convertToU($value);
		    $getVal = convertUToOU($value);

		    } elseif ($test_key=="nur"){
		    $getVal = convertRateToU($value);
		    $getVal = convertRateUToOU($value);

		    } elseif ($test_key=="ttu"){
		    $getVal = convertToS($value);
		    $getVal = convertSToOU($value);

		    } elseif ($test_key=="tur"){
		    echo "<p>tur ...";
		    $getVal = convertRateToS($value);
		    $getVal = convertRateSToOU($value);

		    } elseif ($test_key=="lst"){
		    split_list($value);

		}
		// FLAG BLANK IF INVALID DATA FOUND
		if ($test == 0){
		    if ($result == 0){
			$result = 1;
		    }
		}
            }
	}	
    }
    $result = !$result;
    $reasons[]="is_valid_form_data() returned $result";
    return $result;
}

function round_cur($flt){
    // ROUNDS $flt TO TWO DECIMAL PLACES
    global $reasons;
    $result = $flt * 100;
    $result = round($result);
    $result = $result / 100;
    $reasons[] = "round_cur(" . $flt . ") returned " . $result;
    return $result;
}

function format_cur($flt){
     // FORMATS $flt TO TWO DECIMAL PLACES WITH COMMAS
    global $reasons;
    $flt = round_cur($flt);
    $result = number_format($flt, 2);
    $reasons[] = "format_cur(" . $flt . ") returned " . $result;
    return $result;
}

function stripCharsInBag($txt, $bag){
    // RETURN ONLY CHARS IN $txt FOUND IN $bag 
    // SEARCH THROUGH STRING'S CHARACTERS ONE BY ONE.
    // IF CHARACTER IS NOT IN BAG, APPEND TO RETURN STRING.	
    for ($i = 0; $i < strlen($txt); $i++){
	    $c = $txt[$i];
	    if (ereg($c, $bag) == 0){
		    $result = $result . $c;
	    }
    }
    return $result;
}

function stripCharsNotInBag($txt, $bag){ 
    // RETURN ONLY CHARS IN $txt *NOT* FOUND IN $bag   
    // SEARCH THROUGH STRING'S CHARACTERS ONE BY ONE.
    // IF CHARACTER IS IN BAG, APPEND TO RETURN STRING.
    for ($i = 0; $i < strlen($txt); $i++){
	 $c = $txt[$i];
	 if (ereg($c, $bag) == 1){
	      $result = $result . $c;
	 }
    }
    return $result;
}

function give_reasons(){
    // RETURNS REASONS
    global $reasons;
    while (list($key, $value) = each($reasons)){
	$result = $result . $value . "<br>";
    }
    return $result;
}

function get_reasons(){
    // ALIAS FOR give_reasons()
    give_reasons();
}

function get_globals(){
    $result = get_array($GLOBALS);
    return $result;
}

function get_array($array_name){
    // return contents of array
    // note: get_array recursively calls itself if arrays are nested
    if (!is_array($array_name)){
	 return;
    }
    while(list($key, $value)=each($array_name)){
	 if (is_array($value)==true){
	      $result .= get_array($value);
	 } else {
	      $result .= "<p><b>$key:</b>$value</p>";
	 }
    }
    return $result;
}

function getAlphaNum($txt){
    // STRIP CHARS OTHER THAN NUMERALS, ALPHABETS, SIGNS .-
    global $reasons;
    $wk_txt = stripslashes($txt);
    for ($i = 0; $i < strlen($wk_txt); $i++){
	 $c = $wk_txt[$i];
         $ascii_c = ord($c);
	 if (($ascii_c > 44) && ($ascii_c < 123)) {            
	      $result = $result . $c;
	 }
    }
    $reasons[] = "getAlphaNum(" . $txt . ") returned " . $result;
    return $result;
}
 
function getTextAreaUnit($txt){
    // GETS WHAT AREA UNIT IS USED IN $txt
    // RETURNS GROUNDS, ACRES, SQFT, CENTS, SQM, SQY
    global $reasons;
    global $numValue;
    $txtuc = strtoupper($txt);
    $txtuc = getAlphaNum($txt);
    // DEFAULT PRESUMPTION
    $result = "SQFT";	
    $numValue = stripCharsNotInBag($txtuc, "1234567890.");
    $numValue = (double)$numValue;
    // FIND AREA UNIT
    if (eregi("G", $txtuc)){
	 $result = "GROUNDS";
	 list($gPart, $fPart) = split('G', $txtuc);
	 $gPart = stripCharsNotInBag($gPart, "1234567890.");
	 $fPart = stripCharsNotInBag($fPart, "1234567890.");
	 $gPart = (double)$gPart;
	 $fPart = (double)$fPart;
	 $numValue = ($gPart * 2400) + $fPart;
    }
    if (eregi("M", $txtuc)){$result = "SQM";}
    if (eregi("ACRE", $txtuc)){$result = "ACRES";	}
    if (eregi("CENT", $txtuc)){$result = "CENTS";	}	
    if (eregi("Y", $txtuc)){$result = "SQY";}
    $reasons[] = "getTextAreaUnit(" . $txt . ") returned " . $result;
    return $result;
}

function getTextLengthUnit($txt){
    // GETS WHAT LENGTH UNIT IS USED IN $txt
    // RETURNS  MM, CM, DM, M, KM, INCHES, FEET, YARDS, FURLONGS, MILES
    global $reasons;
    global $numValue;
    $txtuc = getAlphaNum($txt);
    $txtuc = strtoupper($txtuc);
    // DEFAULT PRESUMPTION
    $result = "M";	
    $numValue = stripCharsNotInBag($txtuc, "1234567890.");
    $numValue = (double)$numValue;
    // FIND LENGTH UNIT    
    if (eregi("MM", $txtuc)){$result = "MM";}
    if (eregi("CM", $txtuc)){$result = "CM";}
    if (eregi("DM", $txtuc)){$result = "DM";}
    if (eregi("KM", $txtuc)){$result = "KM";}
    if (eregi("IN", $txtuc)){$result = "INCHES";}
    if (eregi("FT", $txtuc)){$result = "FEET";}
    if (eregi("FEET", $txtuc)){$result = "FEET";}
    if (eregi("Y", $txtuc)){$result = "YARDS";}
    if (eregi("FU", $txtuc)){$result = "FURLONGS";}
    if (eregi("MILE", $txtuc)){$result = "MILES";}
    if (eregi("LINK", $txtuc)){$result = "LINKS";}
    $reasons[] = "getTextLengthUnit(" . $txt . ") returned " . $result;
    return $result;
}

function getTextWeightUnit($txt){
    // GETS WHAT WEIGHT UNIT IS USED IN $txt
    // RETURNS  MG, CG, DG, G, DAG, KG, MT, OZ, LB, CWT, TON
    global $reasons;
    global $numValue;
    $txtuc = getAlphaNum($txt);
    $txtuc = strtoupper($txtuc);
    // DEFAULT PRESUMPTION
    $result = "G";	
    $numValue = stripCharsNotInBag($txtuc, "1234567890.");
    $numValue = (double)$numValue;
    // FIND WEIGHT UNIT    
    if (eregi("MG", $txtuc)){$result = "MG";}
    if (eregi("MILLI", $txtuc)){$result = "MG";}
    if (eregi("CG", $txtuc)){$result = "CG";}
    if (eregi("CENTI", $txtuc)){$result = "CG";}
    if (eregi("DG", $txtuc)){$result = "DG";}
    if (eregi("DECI", $txtuc)){$result = "DG";}
    if (eregi("DAG", $txtuc)){$result = "DAG";}
    if (eregi("DECA", $txtuc)){$result = "DAG";}
    if (eregi("KG", $txtuc)){$result = "KG";}
    if (eregi("KILO", $txtuc)){$result = "KG";}
    if (eregi("M.T", $txtuc)){$result = "MT";}
    if (eregi("Q", $txtuc)){$result = "Q";}
    if (eregi("OZ", $txtuc)){$result = "OZ";}
    if (eregi("OUNCE", $txtuc)){$result = "OZ";}
    if (eregi("LB", $txtuc)){$result = "LB";}
    if (eregi("POUND", $txtuc)){$result = "LB";}
    if (eregi("CWT", $txtuc)){$result = "CWT";}
    if (eregi("HUNDRED-WEIGHT", $txtuc)){$result = "CWT";}
    if (eregi("TON", $txtuc)){$result = "TON";}
    $reasons[] = "getTextWeightUnit(" . $txt . ") returned " . $result;
    return $result;
}

function getTextVolumeUnit($txt){
    // GETS WHAT VOLUME UNIT IS USED IN $txt
    // RETURNS  ML, CL, DL, L, DAL, HL, KL, 
    //          CUMM,  CUCL, CUCM, CUDM, CUM,
    //          UKGAL, USGAL
    global $reasons;
    global $numValue;
    $txtuc = getAlphaNum($txt);
    $txtuc = strtoupper($txtuc);
    // DEFAULT PRESUMPTION
    $result = "L";	
    $numValue = stripCharsNotInBag($txtuc, "1234567890.");
    $numValue = (double)$numValue;
    // FIND VOLUME UNIT    
    if (eregi("ML", $txtuc)){$result = "ML";}   
    if (eregi("CL", $txtuc)){$result = "CL";}   
    if (eregi("DL", $txtuc)){$result = "DL";}   
    if (eregi("DAL", $txtuc)){$result = "DAL";}   
    if (eregi("HL", $txtuc)){$result = "HL";}   
    if (eregi("KL", $txtuc)){$result = "KL";}   
    if (eregi("CU.M.M", $txtuc)){$result = "CUMM";}   
    if (eregi("CU.C.L", $txtuc)){$result = "CUCL";}   
    if (eregi("CU.D.M", $txtuc)){$result = "CUDM";}   
    if (eregi("CU.[^L]M", $txtuc)){$result = "CUMT";}   
    if (eregi("GAL", $txtuc)){$result = "USGAL";}
    if (eregi("UK.GAL", $txtuc)){$result = "UKGAL";}   
    if (eregi("IMP.GAL", $txtuc)){$result = "UKGAL";}   
    if (eregi("US.GAL", $txtuc)){$result = "USGAL";}    
    $reasons[] = "getTextVolumeUnit(" . $txt . ") returned " . $result;
    return $result;
}

function getTextNumberUnit($txt){
    // RETURNS NUMBER UNIT IN $txt AS UNITS, DOZEN, GROSS, SCORE, QUIRE, REAM
    global $reasons;
    global $numValue;
    $txtuc = getAlphaNum($txt);
    $txtuc = strtoupper($txtuc);
    // DEFAULT PRESUMPTION
    $result = "UNITS";	
    $numValue = stripCharsNotInBag($txtuc, "1234567890.");
    $numValue = (double)$numValue;
    // FIND NUMBER UNIT    
    if (eregi("D", $txtuc)){$result = "DOZEN";}  
    if (eregi("G", $txtuc)){$result = "GROSS";}
    if (eregi("SC", $txtuc)){$result = "SCORE";}
    if (eregi("Q", $txtuc)){$result = "QUIRE";}    
    if (eregi("REAM", $txtuc)){$result = "REAM";}
    $reasons[] = "getTextNumberUnit(" . $txt . ") returned " . $result;
    return $result;
}

function convertToU($txt){
    // CONVERT NUMBER UNIT TO UNITS 
    global $reasons;
    global $numValue;
    $txtuc = getAlphaNum($txt);
    $numUnit = getTextNumberUnit($txtuc);
    // CALLING getTextNumberUnit() LOADS $numValue WITH NUMERICAL VALUE OF $txt
    switch ($numUnit){
	case "UNITS": $result = $numValue; break;
        case "DOZEN": $result = $numValue * 12; break;
        case "GROSS": $result = $numValue * 144; break;
	case "SCORE": $result = $numValue * 20; break;
	case "QUIRE": $result = $numValue * 24; break;
	case "REAM":  $result = $numValue * 480; break;
    }
    $reasons[] = "convertToU(" . $txt . ") returned " . $result;
    return $result;
}

function convertUToOU($txt){
    // CONVERT NUMBER UNITS TO OTHER UNITS OF NUMBER
    global $reasons;
    $numUnits = convertToU($txt);
    $result_ar["UNITS"] = $numUnits;
    $result_ar["DOZEN"] = $numUnits / 12;
    $result_ar["GROSS"] = $numUnits / 144;
    $result_ar["SCORE"] = $numUnits / 20;
    $result_ar["QUIRE"] = $numUnits / 24;
    $result_ar["REAM"]  = $numUnits / 480;
    $reasons[] = "starting convertUToOU(" . $txt . ") ...";
     while (list($key, $value)=each($result_ar)){
	$reasons[] = $numUnits . "  = " . $value . " " . $key;
    }
    $reasons[] = "convertUToOU() done. returned array.";
    return $result_ar;
}

function convertRateToU($txt){
    // CONVERT RATE TO SINGLE UNIT RATE
    global $reasons;
    global $numValue;
    $numUnit = getTextNumberUnit($txt);
    //  CALLING getTextNumberUnit() LOADS $numValue WITH NUMERICAL VALUE OF $txt
    switch($numUnit){
	case "UNITS": $result = $numValue; break;
	case "DOZEN": $result = $numValue / 12; break;
	case "GROSS": $result = $numValue / 144; break;
	case "SCORE": $result = $numValue / 20; break;
	case "QUIRE": $result = $numValue / 24; break;
	case "REAM":  $result = $numVAlue / 480; break;
    }
    $reasons[]= "convertRateToU(" . $txt . ") returned " . $result;
    return $result;    
}

function convertRateUToOU($txt){
    // CONVERT UNIT RATE TO RATE OF OTHER UNITS
    global $reasons;
    global $numValue;
    $unitRate = convertRateToU($txt);    
    $result_ar["UNITS"] = $unitRate;
    $result_ar["DOZEN"] = $unitRate * 12;
    $result_ar["GROSS"] = $unitRate * 144;
    $result_ar["SCORE"] = $unitRate * 20;
    $result_ar["QUIRE"] = $unitRate * 24;
    $result_ar["REAM"]  = $unitRate * 480;
    $reasons[] = "starting convertRateUToOU(" . $txt . ") ...";
    while (list($key, $value)=each($result_ar)){
	$reasons[] = $unitRate . " per unit = " . $value . " per " . $key;
    }
    $reasons[] = "convertRateUToOU() done. returned array.";
    return $result_ar;
}

function getTextTimeUnit($txt){
    // RETURNS TIME UNIT IN $txt AS SECONDS, MINUTES, HOURS, DAYS
    global $reasons;
    global $numValue;
    $txtuc = getAlphaNum($txt);
    $txtuc = strtoupper($txtuc);
    // DEFAULT PRESUMPTION
    $result = "SECONDS";	
    $numValue = stripCharsNotInBag($txtuc, "1234567890.");
    $numValue = (double)$numValue;
    // FIND NUMBER UNIT    
    if (eregi("SEC", $txtuc)){$result = "SECONDS";}  
    if (eregi("M", $txtuc)){$result = "MINUTES";}
    if (eregi("H", $txtuc)){$result = "HOURS";}
    if (eregi("D", $txtuc)){$result = "DAYS";}   
    $reasons[] = "getTextTimeUnit(" . $txt . ") returned " . $result;
    return $result;
}

function convertToS($txt){
    // CONVERT TIME UNIT TO SECONDS 
    global $reasons;
    global $numValue;
    $timeUnit = getTextTimeUnit($txt);
    // CALLING getTextTimeUnit() LOADS $numValue WITH NUMERICAL VALUE OF $txt
    switch ($timeUnit){
	case "SECONDS": $result = $numValue; break;
        case "MINUTES": $result = $numValue * 60; break;
        case "HOURS": $result = $numValue * 3600; break;
	case "DAYS": $result = $numValue * 86400; break;
    }
    $reasons[] = "convertToS(" . $txt . ") returned " . $result;
    return $result;
}

function convertSToOU($txt){
    // CONVERT TIME UNITS IN SECONDS TO OTHER UNITS OF TIME
    global $reasons;
    $secs = convertToS($txt);
    $result_ar["SECONDS"] = $secs;
    $result_ar["MINUTES"] = $secs / 60;
    $result_ar["HOURS"] = $secs / 3600;
    $result_ar["DAYS"] = $secs / 86400;
    $reasons[] = "starting convertSToOU(" . $txt . ") ...";
     while (list($key, $value)=each($result_ar)){
	$reasons[] = $secs . "  = " . $value . " " . $key;
    }
    $reasons[] = "convertSToOU() done. returned array.";
    return $result_ar;
}

function convertRateToS($txt){
    // CONVERT RATE PER TIME UNIT TO RATE PER SECOND
    global $reasons;
    global $numValue;
    $timeUnit = getTextTimeUnit($txt);
    //  CALLING getTextTimeUnit() LOADS $numValue WITH NUMERICAL VALUE OF $txt
    switch($timeUnit){
	case "SECONDS": $result = $numValue; break;
	case "MINUTES": $result = $numValue / 60; break;
	case "HOURS": $result = $numValue / 3600; break;
	case "DAYS": $result = $numValue / 86400; break;
    }
    $reasons[]= "convertRateToS(" . $txt . ") returned " . $result;
    return $result;    
}

function convertRateSToOU($txt){
    // CONVERT SECOND UNIT RATE TO RATE OF OTHER TIME UNITS
    global $reasons;
    global $numValue;
    $secondRate = convertRateToS($txt);    
    $result_ar["SECONDS"] = $secondRate;
    $result_ar["MINUTES"] = $secondRate * 60;
    $result_ar["HOURS"] = $secondRate * 3600;
    $result_ar["DAYS"] = $secondRate * 86400;
    $reasons[] = "starting convertRateSToOU(" . $txt . ") ...";
    while (list($key, $value)=each($result_ar)){
	$reasons[] = $secondRate . " per second = " . $value . " per " . $key;
    }
    $reasons[] = "convertRateSToOU() done. returned array.";
    return $result_ar;
}

function convertToL($txt){
    // CONVERT VOLUME TO LITRE
    global $reasons;
    global $numValue;
    $volumeUnit = getTextVolumeUnit($txt);
    // CALLING getTextVolumeUnit() LOADS $numValue WITH NUMERICAL VALUE OF $txt
    switch ($volumeUnit){
	case "ML": $result = $numValue * 0.001; break;
	case "CL": $result = $numValue * 0.01; break;
	case "DL": $result = $numValue * 0.1; break;
	case "L": $result = $numValue; break;
	case "DAL": $result = $numValue * 10; break;
	case "HL": $result = $numValue * 100; break;
	case "KL": $result = $numValue * 1000; break;
	case "CUMM": $result = $numValue * 1e-06; break;
	case "CUCM": $result = $numValue * 0.001; break;
	case "CUDM": $result = $numValue * 1; break;
	case "CUMT": $result = $numValue * 1000; break;
	case "UKGAL": $result = $numValue * 4.54609; break;
	case "USGAL": $result =  $numValue * 3.7854118; break;
    }
    $reasons[] = "convertToL(" . $txt . ") returned " . $result;
    return $result;
}

function convertLToOU($txt){
    // CONVERT VOLUME IN LITRE TO OTHER UNITS OF VOLUME
    global $reasons;
    $litreVolume = convertToL($txt);
    $result_ar["ML"] = $litreVolume * 1000;
    $result_ar["CL"] = $litreVolume * 100;
    $result_ar["DL"] = $litreVolume * 10;
    $result_ar["L"] = $litreVolume;
    $result_ar["DAL"] = $litreVolume * 0.1;
    $result_ar["HL"] = $litreVolume * 0.01;
    $result_ar["KL"] = $litreVolume * 0.001;
    $result_ar["CUMM"] = $litreVolume * 1000000;
    $result_ar["CUCM"] = $litreVolume * 1000;
    $result_ar["CUDM"] = $litreVolume * 1;
    $result_ar["CUMT"] = $litreVolume * 0.001;
    $result_ar["UKGAL"] = $litreVolume * 0.21996925;
    $result_ar["USGAL"] =  $litreVolume * 0.26417205;
    $reasons[] = "starting convertLToOU(" . $txt . ") ...";
    while (list($key, $value)=each($result_ar)){
	$reasons[] = $litreVolume . " L = " . $value . " " . $key;
    }
    $reasons[] = "convertLToOU() done. returned array.";
    return $result_ar;
}

function convertRateToL($txt){
    // CONVERTS RATE PER LITRE FROM OTHER UNITS OF VOLUME
    global $reasons;
    $numValue = make_double($txt);
    $txtUnit = getTextVolumeUnit($txt);
    switch ($txtUnit){
	case "ML": $result = $numValue * 1000; break;
	case "CL": $result = $numValue * 100; break;
	case "DL": $result = $numValue * 10; break;
	case "L": $result = $numValue; break;
	case "DAL": $result = $numValue * 0.1; break;
	case "HL": $result = $numValue * 0.01; break;
	case "KL": $result = $numValue * 0.001; break;
	case "CUMM": $result = $numValue * 1000000; break;
	case "CUCM": $result = $numValue * 1000; break;
	case "CUDM": $result = $numValue * 1; break;
	case "CUMT": $result = $numValue * 0.001; break;
	case "UKGAL": $result = $numValue * 0.21996925; break;
	case "USGAL": $result =  $numValue * 0.26417205; break;
    }
    $reasons[]="convertRateToL(" . $txt . ") returned " . $result;
    return $result;
}

function convertRateLToOU($txt){
    // CONVERT VOLUME IN LITRE TO OTHER UNITS OF VOLUME
    global $reasons;
    $litreRate = convertToL($txt);
    $result_ar["ML"] = $litreRate / 1000;
    $result_ar["CL"] = $litreRate / 100;
    $result_ar["DL"] = $litreRate / 10;
    $result_ar["L"] = $litreRate;
    $result_ar["DAL"] = $litreRate / 0.1;
    $result_ar["HL"] = $litreRate / 0.01;
    $result_ar["KL"] = $litreRate / 0.001;
    $result_ar["CUMM"] = $litreRate / 1000000;
    $result_ar["CUCM"] = $litreRate / 1000;
    $result_ar["CUDM"] = $litreRate / 1;
    $result_ar["CUMT"] = $litreRate / 0.001;
    $result_ar["UKGAL"] = $litreRate / 0.21996925;
    $result_ar["USGAL"] =  $litreRate / 0.26417205;
    $reasons[] = "starting convertLToOU(" . $txt . ") ...";
    while (list($key, $value)=each($result_ar)){
	$reasons[] = $litreRate . " per Litre = " . $value . " " . $key;
    }
    $reasons[] = "convertLToOU() done. returned array.";
    return $result_ar;
}

function convertToG($txt){
    // CONVERT WEIGHT TO GRAMS
    global $reasons;
    global $numValue;
    $weightUnit = getTextWeightUnit($txt);
    // CALLING getTextWeightUnit() LOADS $numValue WITH NUMERICAL VALUE OF $txt
    switch ($weightUnit){
	case "MG": $result = $numValue * 0.001; break;
	case "CG": $result = $numValue * 0.01; break;
	case "DG": $result = $numValue * 0.1; break;
	case "G": $result = $numValue; break;
	case "DAG": $result = $numValue * 10; break;
	case "KG": $result = $numValue * 1000; break;
	case "Q": $result = $numValue * 100000; break;
	case "MT": $result = $numValue * 1000000; break;	
	case "OZ": $result = $numValue * 28.349523; break;
	case "LB": $result = $numValue * 453.59237; break;
	case "CWT": $result = $numValue * 45359.237; break;
	case "TON": $result = $numValue * 907184.74; break;
    }
    $reasons[] = "convertToG(" . $txt . ") returned " . $result;
    return $result;
}

function convertGToOU($txt){
    // CONVERT WEIGHT IN GRAMS TO OTHER UNITS OF WEIGHT
    global $reasons;
    global $numValue;
    $numValue = convertToG($txt);
    $result_ar["MG"] = $numValue * 1000;
    $result_ar["CG"] = $numValue * 100;
    $result_ar["DG"] = $numValue * 10;
    $result_ar["G"] = $numValue;
    $result_ar["DAG"] = $numValue * 0.1;
    $result_ar["KG"] = $numValue * 0.001;
    $result_ar["Q"] = $numValue * 1e-05;
    $result_ar["MT"] = $numValue * 0.0000001;
    $result_ar["OZ"] = $numValue * 0.035273962;
    $result_ar["LB"] = $numValue * 0.0022046226;
    $result_ar["CWT"] = $numValue * 2.2046226e-05;
    $result_ar["TON"] = $numValue * 1.1023113e-06;
    $reasons[] = "starting convertGToOU(" . $txt . ") ...";
    while (list($key, $value)=each($result_ar)){
	$reasons[] = $numValue . " G = " . $value . " " . $key;
    }
    $reasons[] = "convertGToOU() done. returned array.";
    return $result_ar;
}

function convertRateToG($txt){
    // CONVERT RATE PER UNIT OF WEIGHT TO RATE PER GRAM
    global $reasons;
    global $numValue;
    $weightUnit = getTextWeightUnit($txt);
    switch ($weightUnit){
	case "MG": $result = $numValue * 1000; break;
   	case "CG": $result = $numValue * 100; break;
   	case "DG": $result = $numValue * 10; break;
   	case "G": $result = $numValue; break;
    	case "DAG": $result = $numValue * 0.1; break;
    	case "KG": $result = $numValue * 0.001; break;
        case "Q": $result = $numValue *  1e-05; break;
    	case "MT": $result = $numValue * 0.0000001; break;
    	case "OZ": $result = $numValue * 0.035273962; break;
    	case "LB": $result = $numValue * 0.0022046226; break;
    	case "CWT": $result = $numValue * 2.2046226e-05; break;
    	case "TON": $result = $numValue * 1.1023113e-06; break;
   }
   $reasons[] = "convertRateToG(" . $txt . ") returned " . $result;
   return $result; 
}

function convertRateGToOU($txt){
    // CONVERT RATE PER GRAM TO RATE IN OTHER UNITS
    global $reasons;
    $numRate = convertRateToG($txt);
    $result_ar["MG"] = $numRate * 0.001;
    $result_ar["CG"] = $numRate * 0.01;
    $result_ar["DG"] = $numRate * 0.1;
    $result_ar["G"] = $numRate;
    $result_ar["DAG"] = $numRate * 10;
    $result_ar["KG"] = $numRate * 1000;
    $result_ar["Q"] = $numRate * 100000;
    $result_ar["MT"] = $numRate * 1000000;
    $result_ar["OZ"] = $numRate * 28.349523;
    $result_ar["LB"] = $numRate * 453.59237;
    $result_ar["CWT"] = $numRate * 45359.237;
    $result_ar["TON"] = $numRate * 907184.74;
    $reasons[] = "starting convertRateGToOU(" . $txt . ") ...";
    while (list($key, $value)=each($result_ar)){
	$reasons[] = $numRate . " per GRAM = " . $value . " per " . $key;
    }
    $reasons[] = "convertRateGToOU() done. returned array.";
    return $result_ar;
}

function convertToM($txt){
    // CONVERT LENGTH TO METRES
    global $reasons;
    global $numValue;
    $lengthUnit = getTextLengthUnit($txt);
    //  CALLING getTextLengthUnit() LOADS $numValue WITH NUMERICAL VALUE
    switch ($lengthUnit){
	case "MM": $result = $numValue * 0.001; break;
	case "CM": $result = $numValue * 0.01; break;
	case "DM": $result = $numValue * 0.1; break;
	case "M": $result = $numValue; break;
	case "KM": $result = $numValue * 1000; break;
	case "INCHES": $result = $numValue * 0.0254; break;
	case "FEET": $result = $numValue * 0.3048; break;
	case "YARDS": $result = $numValue * 0.9144; break;
	case "FURLONGS": $result = $numValue * 201.1684; break;
	case "MILES": $result = $numValue * 1609.344; break;
	case "LINKS": $result = $numValue * 0.2011684; break;
    }
    $reasons[]= "convertToM(" . $txt . ") returned " . $result;
    return $result;
}

function convertMToOU($txt){
    // CONVERT $txt TO OTHER LENGTH UNITS AND RETURN ARRAY
    global $reasons;
    global $numValue;
    $numValue = convertToM($txt);
    $result_ar["MM"] = $numValue * 1000;
    $result_ar["CM"] = $numValue * 100;
    $result_ar["DM"] = $numValue * 10;
    $result_ar["M"] = $numValue;
    $result_ar["KM"] = $numValue * 0.001;
    $result_ar["INCHES"] = $numValue * 39.370079;
    $result_ar["FEET"] = $numValue * 3.2808399;
    $result_ar["YARDS"] = $numValue * 1.0936133;
    $result_ar["FURLONGS"] = $numValue * 0.0049709596;
    $result_ar["MILES"] = $numValue * 0.00062137119;
    $result_ar["LINKS"] = $numValue * 4.9709596 ;
    while (list($key, $value)=each($result_ar)){
	$reasons[] = $numValue . " M = " . $value . " " . $key;
    }
    reset ($result_ar);
    return $result_ar;
}

function convertRateToM($txt){
    // CONVERTS RATE PER LENGTH OF UNIT TO RATE PER METRE
    global $reasons;   
    $txtUnit = getTextLengthUnit($txt);
    $numValue = make_double($txt);
    switch ($txtUnit){
        case "MM": $result = $numValue * 1000; break;
    	case "CM": $result = $numValue * 100; break;
    	case "DM": $result = $numValue * 10; break;
    	case "M": $result = $numValue; break;
    	case "KM": $result = $numValue * 0.001; break;
    	case "INCHES": $result = $numValue * 39.370079; break;
    	case "FEET": $result = $numValue * 3.2808399; break;
    	case "YARDS": $result = $numValue * 1.0936133; break;
    	case "FURLONGS": $result = $numValue * 0.0049709596; break;
    	case "MILES": $result = $numValue * 0.00062137119; break;
    	case "LINKS": $result = $numValue * 4.9709596; break; 
    }
    $reasons[]="convertRateToM(" . $txt . ") returned " . $result;
    return $result;
}

function convertRateMToOU($txt){
    // CONVERTS RATE PER METRE TO OTHER UNITS AND RETURNS ARRAY
    global $reasons;
    $numRate = convertRateToM($txt);
    // CONVERT RATE TO OTHER UNITS
    $result_ar["MM"] = $numRate / 1000;
    $result_ar["CM"] = $numRate / 100;
    $result_ar["DM"] = $numRate / 10;
    $result_ar["M"] = $numValue;
    $result_ar["KM"] = $numRate / 0.001;
    $result_ar["INCHES"] = $numRate / 39.370079;
    $result_ar["FEET"] = $numRate / 3.2808399;
    $result_ar["YARDS"] = $numRate / 1.0936133;
    $result_ar["FURLONGS"] = $numRate / 0.0049709596;
    $result_ar["MILES"] = $numRate / 0.00062137119;
    $result_ar["LINKS"] = $numRate / 4.9709596 ;
    $reasons[] = "starting convertRateMToOU(" . $txt . ")...";
    while (list($key, $value) = each($result_ar)){
	$reasons[]= $numRate . " per metre = " . $value . " per " . $key;
    }
    $reasons[] = "convertRateMToOU() done. returned array.";
    return $result_ar; 
}
function convertToSqFt($txt){
    // CONVERT GROUNDS, ACRES, SQM, SQY, CENTS TO SQFT
    // calling getTextAreaUnit() returns numerical value of $txt in $numValue
    global $reasons;
    global $numValue;
    $txtUnit = getTextAreaUnit($txt);
    // DEFAULT PRESUMPTION THAT AREA IS IN SQFT
    $result = $numValue;	
    switch ($txtUnit){
	    case "SQY": $result = $numValue * 9; break;
	    case "SQM": $result = $numValue * 10.76; break;
	    case "ACRES": $result = $numValue * 43560; break;
	    case "CENTS": $result = $numValue * 435.6; break;
    }
    $reasons[]="convertToSqFt(" . $txt . ") returned " .  $result;
    return $result;
}  

function convertSqFtToOU($txt){
    // CONVERTS SQUARE FEET TO OTHER SQUARE UNITS
    global $reasons;
    $numValue = convertToSqFt($txt);
    $result_ar["SQY"] = $numValue / 9;
    $result_ar["SQM"] = $numValue / 10.76;
    $result_ar["ACRES"] = $numValue / 43560;
    $result_ar["CENTS"] = $numValue / 435.6;
    $result_ar["SQFT"] = $numValue;
     $reasons[] = "starting convertSqFtToOU(" . $txt . ")...";
    while (list($key, $value)=each($result_ar)){
	$reasons[]= $numValue . " sq.ft. = " . $value . " "  . $key;
    }
    $reasons[] = "convertSqFtToOU() done. returned array.";
    return $result_ar;
}

function convertRateToSqFt($txt){
    // CONVERTS RATE PER GROUND, SQM, SQY, CENT TO SQFT
    global $reasons;
    $numValue = make_double($txt);
    $txtUnit = getTextAreaUnit($txt);
    switch ($txtUnit){
	    case "SQFT": $result = $numValue; break;
	    case "SQY": $result = $numValue / 9; break;
	    case "SQM": $result = $numValue / 10.76; break;
	    case "GROUNDS": $result = $numValue / 2400; break;
	    case "ACRES": $result = $numValue / 43560; break;
	    case "CENTS": $result = $numValue / 435.6; break;
    }
    $reasons[]="convertRateToSqFt(" . $txt . ") returned " . $result;
    return $result;
}

function convertRateSqFtToOU($txt){
    // CONVERTS RATE PER SQUARE FEET TO OTHER RATES IN OTHER UNITS
    global $reasons;
    $numRate = convertRateToSqFt($txt);
    $result_ar["SQFT"]= $numRate;
    $result_ar["SQY"] = $numRate * 9;
    $result_ar["SQM"] = $numRate * 10.76;
    $result_ar["GROUNDS"] = $numRate * 2400;
    $result_ar["ACRES"] = $numRate * 43560;
    $result_ar["CENTS"] = $numRate * 435.6;
    $reasons[] = "starting convertRateSqFtToOU(" . $txt . ")...";
    while (list($key, $value)=each($result_ar)){
	$reasons[]= $numRate . " per sq.ft. = " . $value . " per " . $key;
    }
    $reasons[] = "convertRateSqFtToOU() done. returned array.";
    return $result_ar;
}

function convert_dmy_to_ymd($dmy_date){
    /* convert indian date to postgresql format*/
   
    if ($dmy_date!=''){
	 list( $day1, $month1, $year1 ) = split( '[\/.-]', $dmy_date );
	 $result=$year1 . "-" . $month1 . "-" . $day1;
	 $test = is_date($dmy_date);
	 if ($test==0){
	      $result="NULL";
	 }
    } else {
	 $result="NULL";
    }
    return $result;
}

function convert_ymd_to_dmy($ymd_date){
    /* convert indian date to postgresql format*/
    if ($ymd_date!=''){
	 list( $year1, $month1, $day1 ) = split( '[\/.-]', $ymd_date );
	 $result=$day1 . "-" . $month1 . "-" . $year1; 
    } else {
	 $result="NULL";
    }
    return $result;
}

function split_list($txt){
    //array split_list($txt)
    //$txt = apples;oranges;bananas
    //$txt = AP:apples;OG:oranges;BN:bananas
    //split_list returns an associative array for use in forms
    //$ret_ar[AP]=apples;$ret_ar[OG]=oranges;$ret_ar[BN]=bananas
    // sample: $txt = "1:apples; 2:oranges; 3:grapes;" 
    // sample: $txt = "select contact_id, name from contacts";
    // sample: $txt = "select current_date";
    global $reasons;
    if (eregi("^sql:", $txt)){
	$txt = ereg_replace("^sql:", "", $txt);
        $result = Retn_Key_Value_Array($txt);
        //echo "<p>txt: $txt<br>result: $result</p>";  //debug
        //while (list($key, $value)=each($result)){    //
	//      echo "<br>$key: $value";               //
        //}                                            //  
    } else {
        $txt = ereg_replace( ';$', '', $txt);
        $data_array=explode(';', $txt);
        while (list($key, $value) = each($data_array)){
            $is_index=ereg(':', $value);
	    if ($is_index==0){
	        $result[] = $value;
	        } else {
	        $option_values=explode(':', $value);
	        if ($option_values[0]==''){
	            $option_values[0]=$option_values[1];
	        }
	        $result_key = $option_values[0];
	        $result[$result_key]=$option_values[1];
	    }
        }
    }
    $reasons[]="starting split_list(" . $txt . ") ...";
    while(list($key, $value)=each($result)){
	$reasons[]= $white_space . $white_space . $key . "=" . $value;
    }
    $reasons[]="split_list() done.";
    reset($result);
    return $result;
}

function join_list($ar_list){
    // RETURNS A STRING IN 0:apples;1:oranges;2:bananas FORMAT OF ALL ITEMS IN $ar_list
    global $reasons;
    while(list($key, $value) = each($ar_list)){
	$result = $result . $key . ":" . $value . ';' ;
    }
   $reasons[] = "join_list(array) returned $result";
   return $result;
}

?>
