#!/usr/local/bin/perl
#
# SchedRt.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

package SchedRt;


#use vars qw(@ISA, @INC);
use Schedule::Cron;
use Time::ParseDate;

@ISA = ('Schedule::Cron');

use strict;
our $classVars;
#my $pidfile = "/tmp/cafeterra.pid";

sub ClassVars {
	return $classVars;
}

sub _init {
	my $self = shift;
	my $cfg = shift;

	if ($classVars and ref($classVars)) { return $classVars; }

	$classVars = { cfg => $cfg };
	bless $classVars, (ref($self) || $self);
}

sub new {
	my $class = shift;
	my $dispatcher = shift || die "No dispatching sub provided";
	return $classVars if ($classVars and ref($classVars));
	die "Dispatcher not a ref to a subroutine" unless ref($dispatcher) eq "CODE";
	my $cfg = ref($_[0]) eq "HASH" ? $_[0] : { @_ };

	$classVars = {
		cfg => $cfg,
		myId => $cfg->{flowId},
		dispatcher => $dispatcher,
		queue => [ ],
		map => { }
	};

	if ($cfg->{flowId} < 0) {
		my $pidfile = $cfg->{pid_file} = $class->MyPidFileName(); # $pidfile;
		$classVars->{pid_file} = $class->MyPidFileName(); # $pidfile;
		unless (-f $pidfile) { 
			open (PID, "> $pidfile") || die "Unable to write to $pidfile file ($!)";
			close PID;
		}
		my $line;
		{
			open (PID, "< $pidfile") || die "Unable to read $pidfile file ($!)";
			local $/ = undef;
			$line = <PID>;
			close PID;
		}
		$line =~ s/[^0-9]//g;
#		print "PROCESS FOUND $line\n";
		if ($line and ($line > 50)) {
			if (kill(0, $line)) { die "Cafeterra monitor already running $line\n"; }
		}
		$! = undef;
#		open (PID, "> $pidfile");
#		die "Unable to write to $pidfile file ($!)" if ($!);
#		print PID $$;
#		close PID;
	}
	bless $classVars,(ref($class) || $class);

	$classVars->MyId($classVars->MyFlowId());
 
	$classVars->load_crontab() if ($classVars->Mode() eq "daemon");
	$classVars;
}

sub execute {

	my $self = shift;
	my $index = shift;

	my $args = $self->{args}->[$index];
	my $dispatcher = $args->[0];
	$args = $args->[1];
	my $pid;
 
=cut
	print "Execute called with ", join (" - ", @$args), "\n";
	my $m = "CALLED WITH : ";
	$m .= $self->{cfg}{FlowId} if ($self->{cfg}{FlowId});
	$m .= " args 0 = $args->[0];" if ($args->[0]);
	$m .= " args 1 = $args->[1]" if ($args->[1]);
	system ("echo '$m' >> /tmp/coco");
=cut

	if ($self->MyFlowId() > 0) {
		$self->MyFlowId($args->[1]);
		$self->MyId($args->[1]);
		$self->MySchedulerId($args->[4]);
		$self->Mode("daemon");
		$self->ProcessFlow();
	}
	else {
		if ($args->[0] eq "execute") {
			if ($pid = fork()) {
				#Parent
				return;
			}
			else { # child;
				#if ($args->[2] and (-w $args->[2])) { open STDOUT, ">> $args->[2]"; }
				#if ($args->[3] and (-w $args->[3])) { open STDERR, ">> $args->[3]"; }
				if ($args->[2]) { open STDOUT, ">> $args->[2]"; }
				if ($args->[3]) {
					if ($args->[2] ne $args->[3]) { open STDERR, ">> $args->[3]"; }
					else { open STDERR, ">&STDOUT"; }
				}
				elsif ($args->[2]) { open STDERR, ">&STDOUT"; }
				$self->MyFlowId($args->[1]);
				$self->MyId($args->[1]);
				$self->MySchedulerId($args->[4]);
				$self->Mode("once");
				$self->timeLastRun(cafUtils->datetime1(1));
				print STDERR cafUtils->datetime1() . " $$ Execute  $args->[1] $args->[4]\n";
				my $pLabel = "CAFETERRA Run " . $args->[1];
				$pLabel .= " " . $args->[2] if ($args->[2]);
				$0 = $pLabel;
				$self->ProcessFlow();
				exit;
			}
		}
		elsif ($args->[0] eq "monitor") {
			$self->MySchedulerId($args->[4]);
			$self->CheckFlowIsRunning($args);
		}
		elsif ($args->[0] eq "archiver") {
			$self->MySchedulerId($args->[4]);
			$self->ArchiveQueue($args);
		}
	}
}

sub run {
	my $self = shift;
	my $class = ref($self) || $self;
	my $cfg = ref($_[0]) eq "HASH" ? $_[0] : { @_ };
 
	if ($classVars->{myId} < 0) { $cfg->{pid_file} = $self->MyPidFileName(); $0 = "CAFETERRA MONITOR"; }

	if ($self->Mode() eq "daemon") {
		$self->build_initial_queue if ($self->Mode() eq "daemon");
		die "Nothing in schedule queue" unless @{$self->{queue}};
	}
 
	my $mainloop = sub {
		while (42) {
			my ($index,$time) = @{shift @{$self->{queue}}};
			my $plabel = $self->MyId();
			$plabel = "MONITOR" unless ($plabel > 0);
			$0 = "CAFETERRA $plabel / MainLoop - next: ". cafUtils->datetime1($time); #scalar(localtime($time));
			die "No time found" unless $time;
			my $now = time;
	
#			dbg "R: ",scalar(localtime($time))," (",scalar(localtime($now)),")";
			print STDERR "\n\n", cafUtils->datetime1(), " $$ Next execution time ", cafUtils->datetime1($time), "\n";
			$self->UpdateMyStatus({ next_exectime => cafUtils->datetime1($time) });
			while ($time > $now) {
				local $SIG{USR1} = sub { $classVars->Terminate(); };
				local $SIG{USR2} = sub { $classVars->TerminateUSR2(); };
				sleep($time-$now);
				$SIG{USR1} = 'IGNORE';
				$SIG{USR2} = 'IGNORE';
				$now = time;
			}
			$self->execute($index);
			my $update = $self->load_crontab();
			if ($update > 0) { $self->build_initial_queue(); }
			else { $self->update_queue($index); }
		}
	};
	if ($cfg->{detach}) {
		defined(my $pid = fork) or die "Can't fork: $!";
		if ($pid) {
			# Parent:
			if ($cfg->{pid_file}) {
				if (open(PID,">".$cfg->{pid_file})) {
					print PID $pid,"\n";
					close PID;
				} else {
					warn "Warning: Cannot open ",$cfg->{pid_file}," : $!";
				}
 
			}
			return $pid;
		} else {
			# Child:
			# Try to detach from terminal:
#			chdir '/';
			my $traceFile = $self->TraceFile();
			my $errorFile = $self->ErrorFile();
			print "detachin to $traceFile, $errorFile\n";
			$traceFile = "/dev/null" unless ($traceFile); # and (-w $traceFile));
			$errorFile = "/dev/null" unless ($errorFile); # and (-w $errorFile));
			open STDIN, '</dev/null' or die "Can't read /dev/null: $!";
			open STDOUT, ">>$traceFile" or die "Can't write to $traceFile: $!";
			if ($errorFile ne $traceFile) { open STDERR, ">>$errorFile" or die "Can't write to $errorFile: $!"; }
			else { open STDERR, '>&STDOUT' }
#			die "detachin to $traceFile, $errorFile\n";
 
			eval { require POSIX; };
			if ($@) {
				if (open(T,"/dev/tty")) {
					eval { require 'ioctl.ph'; };
					if ($@) {
						eval { require 'sys/ioctl.ph'; };
						if ($@) {
							die "No 'ioctl.ph'. Probably you have to run h2ph (Error: $@)";
						}
					}
					my $notty = &TIOCNOTTY;
					die "No TIOCNOTTY !" if $@ || !$notty;
					ioctl(T,$notty,0) || die "Cannot issue ioctl(..,TIOCNOTTY) : $!";
					close(T);
				};
			} else {
				&POSIX::setsid() || die "Can't start a new session: $!";
			}
			#open STDERR, '>&STDOUT' or die "Can't dup stdout: $!";
 
			#$0 = "Schedule::Cron MainLoop";

			my $plabel = $self->MyId();
			$plabel = "MONITOR" unless ($plabel > 0);
			$0 = "CAFETERRA $class $plabel ";
			$self->UpdateMyStatus ();

			if ($self->Mode() eq "once") { $self->ProcessFlow(); }
			elsif ($self->Mode() eq "webservice") { $self->ProcessFlow(); }
			elsif ($self->Mode() eq "xmlsocket") { $self->ProcessFlow(); }
			else { &$mainloop(); }
		}
	} else {
			if ($self->Mode() eq "once") { $self->ProcessFlow(); }
			elsif ($self->Mode() eq "webservice") { $self->ProcessFlow(); }
			elsif ($self->Mode() eq "xmlsocket") { $self->ProcessFlow(); }
			else { &$mainloop(); }
	}
}

sub MySchedulerId {
	my $self = shift;

	if (@_) {
		$classVars->{cfg}{schedulerId} = shift;
	}
	$classVars->{cfg}{schedulerId};
}

sub TerminateUSR2 {
	my $self = shift;

	$self->LogSysTrace("Received Signal USR2");
	return 1 unless ($self->MyId() == -1);
	$self->UpdateMyStatus ({ rt_status => 'paused' });
	exit;
}

sub Terminate {
	my $self = shift;

	$self->LogSysTrace("Received Signal USR1");
	$self->UpdateMyStatus ({ rt_status => 'stopped' });
	exit;
}
	
sub UpdateMyStatus {
	my $self = shift;
	my $params = shift || {};

	my $disconnect = 0;
	my $qDbh = $self->QueueDbhAutocommit();
	if (! $qDbh) { $self->QueueConnect(); $disconnect = 1; }
	my $qDbh = $self->QueueDbhAutocommit();
	my $qAttr = {
		object_id       => $self->MyId(),
		rt_status       => $params->{rt_status} || "online",
		system_pid      => $self->MyPid(),
		sched_id        => $self->MySchedulerId(),
		next_exectime   => $params->{next_exectime},
		rt_status_cond  => $params->{rt_status_cond}
	};
	
#	$query = $qDbh->newquery({ object_id=>$self->MyId(), rt_status=>"running", system_pid=>$self->MyPid(), sched_id=>$self->MySchedulerId() });
	my $query = $qDbh->newquery($qAttr);
	my $ret;
	if ($params->{next_exectime}) {
		$query->uwflowsstatusnextexec();
		$ret = $qDbh->executefinish($query);
		if ($ret < 1) {
			$query->iwflowsstatus();
			$ret = $qDbh->executefinish($query);
			$query->uwflowsstatusnextexec();
			$ret = $qDbh->executefinish($query);
		}
	}
	else {
		$query->uwflowsstatus();
		eval {
			$ret = $qDbh->executefinish($query);
		};
		if ($ret < 1) {
			$query->iwflowsstatus();
			$ret = $qDbh->executefinish($query);
		}
	}
	$self->QueueDisconnect() if ($disconnect);
}

sub ForkNewProcess {
	my $self = shift;
	my $sched = shift;

	no strict;
	$SIG{CHLD} = "IGNORE";
	use strict;
	print STDERR cafUtils->datetime1() . " $$ Fork $sched->{sched_id} $sched->{system_pid}\n";
	my $pid;
	if ($pid = fork()) {
		#Parent
		sleep(1);
		return;
	}
	else { # child;
		$sched->{tracefile} = "/dev/null" unless ($sched->{tracefile}); # and (-w $sched->{tracefile}));
		$sched->{errorfile} = "/dev/null" unless ($sched->{errorfile}); # and (-w $sched->{errorfile}));
		open STDIN, "</dev/null";
		#if ($sched->{tracefile} and (-w $sched->{tracefile})) { open STDOUT, ">> $sched->{tracefile}"; }
		#if ($sched->{errorfile} and (-w $sched->{errorfile})) { open STDERR, ">> $sched->{errorfile}"; }
		if ($sched->{tracefile}) { open STDOUT, ">> $sched->{tracefile}"; }
		if ($sched->{errorfile} ne $sched->{tracefile}) { open STDERR, ">> $sched->{errorfile}"; }
		else { open STDERR, ">&STDOUT"; }
		$self->MyFlowId($sched->{object_id});
		$self->MyId($sched->{object_id});
		$self->MySchedulerId($sched->{sched_id});
		print STDERR cafUtils->datetime1() . " $$ Fork $sched->{sched_id} " . $self->MyId() , "\n";
#		$self->Mode("daemon");
		$self->Mode($sched->{sched_mode}||"once");
		my $pLabel = "CAFETERRA Run $sched->{sched_id} $sched->{object_id}";
		$0 = $pLabel;
		$self->timeLastRun(cafUtils->datetime1(1));
		eval { 
			$self->UpdateMyStatus();
			$self->load_crontab();
		};
		if ($@) {
			print STDERR cafUtils->datetime1() . " $$ Fork $sched->{sched_id} " . $self->MyId() , " $@\n";
		}
		$self->run();
#		$self->ProcessFlow();
	}
}
	

#Just for monitor process to check that a flow is running and doesn't need to be restarted

sub CheckFlowIsRunning {
	my $self = shift;
	my $args = shift;

	$self->UpdateMyStatus();
	my $disconnect = 0;
	my $qDbh = $self->QueueDbhAutocommit();
	if (! $qDbh) { $self->QueueConnect(); $disconnect = 1; }
	my $qDbh = $self->QueueDbhAutocommit();
	
	my $qParams = {};

#	print STDERR "CheckFlowIsRunning $qDbh Connected\n";
	my $query = $qDbh->newquery({});
	$query->swschedulescheck();
	my $scheds;
	eval {
		$scheds = $qDbh->hexecfetchall($query);
	};
	if ($@) {
		cafDbg->printstack();
		cafDbg->pusherror($@);
		cafDbg->printerror();
		die $@;
	}
	$self->QueueDisconnect() if ($disconnect);;

	foreach my $sched (@$scheds) {
		print STDERR cafUtils->datetime1(), " SCANNING ", join (' - ', %$sched), "\n";
		if (($sched->{rt_status} eq "running") or ($sched->{rt_status} eq "online")) {
			$sched->{system_pid} = undef unless ($sched->{system_pid} =~ /^[[:digit:]]+$/);
			$sched->{system_pid} = undef unless ($sched->{system_pid} > 50);
			next if ($sched->{system_pid} and kill(0, $sched->{system_pid}));
			$self->ForkNewProcess($sched);
		}
	}
	return 1;
}

#This the process which will archive the queue when needed and possible
sub ArchiveQueue {
	my $self = shift;

	eval {
		require mains::Archiver;
		return $self->ArchiveCafeterra();
	}
}

sub timeLastRun {
	my $self = shift;

	unless ($classVars->{cfg}{timeLastRun}) {
		$classVars->{cfg}{timeLastRun} = cafUtils->datetime1(1);
		$classVars->{cfg}{epochLastRun} = 1;
	}

	if (@_) {
		my $time = $classVars->{cfg}{timeLastRun} = shift;
		$classVars->{cfg}{epochLastRun} = Time::ParseDate::parsedate($time, UK => 1);
	}

	$classVars->{cfg}{timeLastRun};
}

sub epochLastRun {
	my $self = shift;

	unless ($classVars->{cfg}{timeLastRun}) {
		$classVars->{cfg}{timeLastRun} = cafUtils->datetime1(1);
		$classVars->{cfg}{epochLastRun} = 1;
	}

	if (@_) {
		my $time = $classVars->{cfg}{epochLastRun} = shift;
		$classVars->{cfg}{epochLastRun} = cafUtils->datetime1($time);
	}

	$classVars->{cfg}{epochLastRun};
}

sub MyId {
	my $self = shift;

	if (@_) {
		$self->{myId} = shift;
	}
	$self->{myId};
}

sub MyFlowDir {
	my $self = shift;

	if (@_) {
		$classVars->{cfg}{flowDir} = shift;
	}
	$classVars->{cfg}{flowDir};
}

sub MyFlowId {
	my $self = shift;

	if (@_) {
		$classVars->{cfg}{flowId} = shift;
	}
	$classVars->{cfg}{flowId};
}

sub MyPidFileName {
	my $self = shift;

	my $config = $classVars->{ cfg };
	File::Spec->catfile($config->{basedir}, $config->{contextId}, "cafeterra.pid");
}

sub MyBaseDir {
	my $self = shift;

	return $classVars->{cfg}{basedir};
}

sub MyContextId {
	my $self = shift;

	if (@_) {
		$classVars->{cfg}{contextId} = shift;
	}
	$classVars->{cfg}{contextId};
}

sub MyContext {
	my $self = shift;

	if (@_) {
		$classVars->{cfg}{contexthash} = shift;
	}
	$classVars->{cfg}{contexthash};
}

sub Mode {
	my $self = shift;

	if (@_) {
		$classVars->{cfg}{mode} = shift;
	}
	$classVars->{cfg}{mode};
}

sub TraceFile {
	my $self = shift;
	if (@_) { $classVars->{cfg}{traceFile} = shift; print "Trace File called with value : $classVars->{cfg}{traceFile}\n"; }
	$classVars->{cfg}{traceFile};
}

sub ErrorFile {
	my $self = shift;
	if (@_) { $classVars->{cfg}{errorFile} = shift; print "Error File called with value : $classVars->{cfg}{errorFile}\n"; }
	$classVars->{cfg}{errorFile};
}

sub load_crontab {
	my $self = shift;

	require connectors::refDBI;

	#my $qDbh = refDBI->NewConnection(CTXTCFG->db());
	my $disconnect = 0;
	my $qDbh = $self->QueueDbhAutocommit();
	if (! $qDbh) { $self->QueueConnect(); $disconnect = 1; }
	$qDbh = $self->QueueDbhAutocommit();

	my $qParams = {};

	print STDERR cafUtils->datetime1(), " $$ Searching modified schedules since ", $self->timeLastRun(), "\n";
	$qParams = { object_id => $self->MyFlowId(), sched_modified => $self->timeLastRun(), };

	my $query = $qDbh->newquery($qParams);
	$query->swrecentschedule();
	my $count = $qDbh->hexecfetchrow($query, 1);
	$count = $count || {};
	my $scheds;
	print STDERR cafUtils->datetime1(), " $$ Scanning $count->{countschedules} modified schedules since ", $self->timeLastRun(), "\n";
	#print STDERR cafUtils->datetime1(), " $$ The query is ", $query->query(), "\n";
	if ($count->{countschedules} > 0) {
		$query = $qDbh->newquery($qParams);
		$query->swschedulerlist();
		$scheds = $qDbh->hexecfetchall($query);
	}

	my $now = $qDbh->now("DD/MM/YYYY HH24:MI:SS");
	if ($now) { $self->timeLastRun($now); }
	#$qDbh->disconnect();

	my $schedcount = 0;
	my @asap;
	if ($count->{countschedules} > 0) {

		$self->clean_timetable();
		foreach my $sched (@$scheds) {
			next unless ($sched->{sched_id});
			$schedcount++;
			my $time = "$sched->{sched_min} $sched->{sched_hour} $sched->{sched_mday} $sched->{sched_month} $sched->{sched_wday}";
			my @args = ("", $sched->{object_id}, $sched->{tracefile}, $sched->{errorfile}, $sched->{sched_id});
			print STDERR cafUtils->datetime1(), " $$ ADDING ENTRY $sched->{sched_id} $sched->{sched_mode} $sched->{object_id} \n";
			if ($sched->{sched_mode} eq 'asap') {
				$args[0] = "asap";
				push @asap, \@args;
				$query->clear({sched_id => $sched->{sched_id}});
				$query->dwscheduler();
				$qDbh->executefinish($query);
				next;
			}
			if ($sched->{sched_mode} eq 'once') {
				$args[0] = "execute";
			}
			elsif ($sched->{sched_id} eq "archiver") {
				$args[0] = "archiver";
			}
			elsif ($sched->{sched_id} eq "monitor") {
				$args[0] = "monitor";
				$self->TraceFile($sched->{tracefile}) unless ($self->TraceFile());
				$self->ErrorFile($sched->{errorfile}) unless ($self->ErrorFile());
			}
			else {
				if ($sched->{object_id} > 0) {
					$self->TraceFile($sched->{tracefile}) unless ($self->TraceFile());
					$self->ErrorFile($sched->{errorfile}) unless ($self->ErrorFile());
				}
				$args[0] = "daemon";
			}
	
			print STDERR cafUtils->datetime1(), " $$ ADD ENTRY ", join (" ", @args), "\n";
			$self->add_entry($time, { arguments => \@args });
		}
	
		unless ($schedcount) {
			if ($self->MyFlowId() > 0) {
				$self->UpdateMyStatus({ rt_status_cond => "online", rt_status => "paused" });
				print STDERR cafUtils->datetime1(), " $$ Exiting No Entry in the Cron Table \n";
				exit;
			}
			else { $self->add_entry ("0-59/5 * * * *", { arguments => [ "monitor",undef, undef, undef, "monitor" ] }); }
		}

	} #if ($count->{countschedules} > 0) 

	$self->QueueDisconnect() if ($disconnect);
	foreach my $sched (@asap) {
		next unless ($sched);
		$self->ForkNewProcess($sched);
	}
	return $count->{countschedules};
}

sub LogSysTrace {
	my $self = shift;
	my $msg = shift;

	my $id = $self->MyId();
	my $pid = $$;
	use IO::Handle;
	STDERR->autoflush(1);
	print STDERR cafUtils->datetime1(), " $pid-$id $msg\n";
	
}

1;

