#!/usr/local/bin/perl

#use strict refs;
use CGI;
no utf8;

my $cgi = new CGI;
my $pageid;

my $varnum = 0;

%funcarray = (
"quote"    => 1,
"nltobr"    => 1,
"totextarea"    => 1,
"escape"    => 1,
"eval"    => 1,
"inline"    => 1,
"month"    => 1,
"weekday"    => 1,
"comment" => 1,
"endcomment" => 1,
"endif" => 1,
"NO else" => 1,
"NO endelse" => 1,
"endloop" => 1,
"NOW IS OPERATOR eq" => 1,
"if" => 1,
"loop" => 1,
"isa" => 1,
"use" => 1,
"pagelabel" => 1,
"pageid" => 1,
"translate" => 1,
"alias"     => 1,
"sflistline" => 1,
"include" => 1,
"includeifinstall" => 1,
);

%operators = (
"exists" => 1,
"defined" => 1,
"value" => 1,
"novalue" => 1,
"eq" => 2,
"ne" => 2,
"gt" => 2,
"ge" => 2,
"lt" => 2,
"le" => 2,
"=="  => 2,
"!="  => 2,
">"  => 2,
"<"  => 2,
">="  => 2,
"<="  => 2,
"in"  => -1,
"notin"  => -1,
);

$tab = 0;
$incomment = 0;


sub genvarname {
	my $str = shift;
	$varnum++;
	return "__$str$varnum";
}

sub parseparam {
	local *E = shift;
	my $p = shift;
	my $l = shift;

	if ($p =~ /^[_[:alpha:]]/) {
		my @var = split(/(\.|\/)/, $p);
		my $varname = $var[0];
		if ($#var > 0) {
			my $deref = "->";
    	for (my $i = 1; defined($var[$i]); $i++) {
				if ($var[$i] eq ".") { $varname .= $deref . "{" . $var[$i + 1] . "}"; }
				elsif ($var[$i] eq "/") { $varname .= $deref . "[" . $var[$i + 1] . "]"; }
				$deref = "";
			}
		}
		print E "Check variable : $varname : $l\n";
		return "\$$varname";
	}
	elsif ($p =~ /^["'[:digit:]]/) { return $p; }
	die "$pageid : invalid parameter near $l $1 ($p)";
}

sub processquote {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l =shift;
 
	my $varname = parseparam (*E, $p, $l);
	print O "\n", " " x $tab, "print \$self->checkquotes ($varname);\n";
}

sub processtotextarea {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l =shift;
 
	my $varname = parseparam (*E, $p, $l);
	print O "\n", " " x $tab, "print \$self->totextarea ($varname);\n";
}

sub processnltobr {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l =shift;
 
	my $varname = parseparam (*E, $p, $l);
	print O "\n", " " x $tab, "print \$self->nltobr ($varname);\n";
}

sub processescape {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l =shift;
 
	my $varname = parseparam (*E, $p, $l);
	print O "\n", " " x $tab, "print \$self->{_system}{_cgi}->cgisub ('escape', $varname);\n";
 
}

sub processinline {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l =shift;

	print O "\n", "	" x $tab, "$p;\n";

}

sub processeval {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l =shift;

	print O "\n", "	" x $tab, "print eval \"$p\";\n";

}

sub processsflistline {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l =shift;

	my @pars = split(/;/, $p);
	my $var1 = parseparam(*E, $pars[0], $l);
	my $var2 = parseparam(*E, $pars[1], $l);
	
	print O "\n", "	" x $tab, "print substr($var1, 0, 10), '( ';";
	print O "\n", "	" x $tab, "if ($var2) { print $var2, ' )'; }";
	print O "\n", "	" x $tab, "else { print \$self->_translate('-NEW-)'); }\n";
}

sub processincludeifinstall {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l =shift;

	if($pageid eq "install") {
		my @pars = split(/;/, $p);
		open I, $pars[0];
		print O "\n", " " x $tabi, "my \$$pars[1]=<<$pars[2]\n";
		while ($l = <I>) { print O $l; }
		print O "\n\n", "$pars[2]\n;\n";
		print O "\n", "	" x $tab, "print \$$pars[1];";
		close I;
	}
}

sub processinclude {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l =shift;

	my @pars = split(/;/, $p);
	open I, $pars[0];
	print O "\n", " " x $tabi, "my \$$pars[1]=<<$pars[2]\n";
	while ($l = <I>) { print O $l; }
	print O "\n\n", "$pars[2]\n;\n";
	print O "\n", "	" x $tab, "print \$$pars[1];";
	close I;
}


sub processcomment {
	$incomment = 1;
}

sub processendcomment {
	$incomment = 0;
}

sub processloop () {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l =shift;

	my %hpars = ();
	my @pars = split(/ /, $p);
#	my @var = split(/\./, shift @pars);
#	my $varname = $var[0];
#	if ($#var > 0) {
#		$varname .= "->{" . $var[1] . "}";
#		for (my $i = 2; defined($var[$i]); $i++) { $varname .= "{" . $var[$i] . "}"; }
#	}

	my $varname = parseparam (*E, $pars[0], $l);

	foreach $ip (@pars) {
		if ($ip =~ /(.*)=(.*)/) { $hpars{$1} = $2; }
	}

	die "$pageid : U must declare an alias for this var " . join ('.', @var) . " loop" unless ($hpars{alias});
	if ($hpars{index}) {
		$hpars{start} = 0 unless $hpars{start};
		print O "\n", "	" x $tab, "for (my \$", $hpars{index}, " = ", $hpars{start}, "; (", $varname, "[\$", $hpars{index}, "])";
		if (defined($hpars{end})) {
			my $op = " < ";
			if ($hpars{end} >= $hpars{start}) { $op = " > "; }
			print O " && (\$", $hpars{index}, $op, $hpars{end}, ")";
		}

		print O "; \$", $hpars{index};
		if (defined($hpars{end}) && ($hpars{end} < $hpars{start})) { print O "--"; }
		else { print O "++"; }
		print O ") {\n";
		$tab++;
		print O "	" x $tab, "my \$", $hpars{alias}, " = ", $varname, "[\$", $hpars{index}, "];\n";

	}
	elsif ($hpars{key}) {
		print O "\n", "	" x $tab, "foreach my \$", $hpars{key}, " (keys \%{", $varname, "}) {\n";
		$tab++;
		print O "	" x $tab, "my \$", $hpars{alias}, " = ", $varname, ";\n";
	}
	else { die "$pageid : Invalide loop syntaxe"; }
		
#   foreach $k (keys %hpars) { print "KEY $k VALUE $hpars{$k} \t"; } 
}

sub processendloop () {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l = shift;

	$tab--;
	print O "	" x $tab, "} #\n"
}

sub processaloop () {
	local *O = shift;
	local *E = shift;
	my $l = shift;
}

sub processelse {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l = shift;

	print O "\n", "	" x $tab, "else {\n";
	$tab++;
}
	


sub processif () {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l = shift;

	my @pars = split(/;/, $p);

	my $func = "processif" . $pars[0];
	my $op = $pars[0];
	my $op1 = parseparam(*E, $pars[1], $l);
	my $cond;
	if (!$op || ($op eq "value")) { $cond = "($op1)" }
	elsif (!$op || ($op eq "novalue")) { $cond = "! ($op1)" }
	elsif (($op eq "in") || ($op eq "notin")) {
		my $myvar = genvarname("set");
		print O "\n", "	" x $tab, "my \%$myvar = ( $pars[2] => 1, ";
		my $i = 3;
		while ($pars[$i]) { print O "$pars[$i] => 1, "; $i++}
		print O ");\n";
		$cond = "\$$myvar" . "{$op1}";
		if ($op eq "notin") { $cond = "! ($cond)"; }
	}
	elsif ($operators{$op} eq 2) {
		my $op2 = parseparam(*E, $pars[2], $l);
		$cond = "($op1 $op $op2)";
	}
	elsif ($operators{$op} eq 1) { $cond = "$op($op1)"; }
	else { die "$pageid : unkown operator $op near $l"; }

	print O "\n", "	" x $tab, "if ($cond) {\n";
	$tab++;
}

sub processalias {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l = shift;

	my @pars = split(/;/, $p);
	my $globvar = parseparam(*E, $pars[0], $l);
	my $alias = parseparam(*E, $pars[1], $l);
	print O "	" x $tab, "my $alias = $globvar;\n";
}

sub processtranslate {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l = shift;

	my $pars = parseparam(*E, $p, $l);
	print O "	" x $tab, "print \$self->_translate($pars);\n";
}

sub processmonth {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l = shift;

	my $pars = "month_" . parseparam(*E, $p, $l);
	print O "	" x $tab, "print \$self->_translate(\"$pars\");\n";
}

sub processweekday {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l = shift;

	my $pars = "weekday_" . parseparam(*E, $p, $l);
	print O "	" x $tab, "print \$self->_translate(\"$pars\");\n";
}

sub processendif () {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l = shift;

	$tab--;
	print O "	" x $tab, "}\n"
}

sub processendelse () {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l = shift;

	$tab--;
	print O "	" x $tab, "}\n"
}

sub processeq () {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l = shift;

	my @pars = split(/;/, $p);

	print O "# $l\n";
	my $op1 = parseparam(*E, $pars[0], $l);
	my $op2 = parseparam(*E, $pars[1], $l);
	my $op3 = parseparam(*E, $pars[2], $l);
	my $cond = "($op1 eq $op2)";

	print O "\n", "	" x $tab, "if ($cond) { print $op3; }\n";

}

sub processop1 {
}

sub processop {
        local *O = shift;
        local *E = shift;
        my $p = shift;
        my $l = shift;
	my $op = shift;
 
        my @pars = split(/;/, $p);
 
        print O "# $l\n";
        my $op1 = parseparam(*E, $pars[0], $l);
	my $iftrue;
	my $iffalse;
	if ($operators{$op} eq 2) {
		my $op2 = parseparam(*E, $pars[1], $l);
		$cond = "($op1 $op $op2)";
#		$iftrue = $pars[2];
#		$iffalse = $pars[3];
		$iftrue = parseparam(*E, $pars[2], $l);
		$iffalse = parseparam(*E, $pars[3], $l) if ($pars[3]);
	}
	elsif ($operators{$op} eq 1) {
		if ($op eq "value") { $cond = "($op1)"; }
		elsif ($op eq "novalue") { $cond = "! ($op1)"; }
		else { $cond = "$op($op1)"; }
#		$iftrue = $pars[1];
#		$iffalse = $pars[2];
		$iftrue = parseparam(*E, $pars[1], $l);
		$iffalse = parseparam(*E, $pars[2], $l) if ($pars[2]);
	}
	else { die "$pageid : unkown operator $op near $l"; }
 
        print O "\n", " " x $tab, "if ($cond) { print $iftrue; }\n";
	if ($iffalse) { print O "\n", " " x $tab, "else { print $iffalse; }\n"; }
}

sub processuse {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l = shift;

	my @pars = split(/;/, $p);

	$use = "\n# $l\n";

	foreach my $m (@pars) { $use .= "use $m;\n"; }

	return $use;
}

sub processisa {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l = shift;

	my @pars = split(/;/, $p);

	$result = "# $l\n";
	$isa = '@ISA = (';

	foreach my $m (@pars) { $result .= $isa . "'" . $m . "'"; $isa = ","; }
	$result .= ");\n";

	return $result;
}

sub processpagelabel {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l = shift;


#	$label = "($pageid)";
#	if (exists ($cafetrans::translation{"_$pageid"})) { $label = $cafetrans::translation{"_$pageid"} . " ($pageid)"; }
	print O "	" x $tab, "print \$self->_translate('_$pageid') . ' ($pageid)';\n";
	
#	$label = $cgi->escape($label);
#	$label =~ s/'/\\'/g;
#	print O "\n# $l\n";
#	print O "	" x $tab, "print '$label';\n";
}

sub processpageid {
	local *O = shift;
	local *E = shift;
	my $p = shift;
	my $l = shift;


	$label = "$pageid";
	print O "	" x $tab, "print '$label';\n";
}

sub processvar {
	local *O = shift;
	local *E = shift;
	my $l = shift;
	my $varname = parseparam(*E, $l, $l);
	print O "# $l\n", "	" x $tab, "print $varname;\n";
}

sub processtag {
	local *O = shift;
	local *E = shift;
	my $l = shift;

	if (substr($l, 0, 1) eq "_") {
		my $word = substr($l, 1);
		$word =~ s/'/\\'/g;
		print O "# SELF.TRANSLATE <" . $word . ">\n";
		print O "	" x $tab, "print \$self->_translate('$word');\n";
#		if (exists ($cafetrans::translation{$word})) {
#			$wordt = $cafetrans::translation{$word};
#		}
#		else {
#			print E "# SELF.TRANSLATE unable to translate <" . $word . ">\n";
#			$wordt = $word;
#		}
#		$wordt = $cgi->escape($wordt);
#		$wordt =~ s/'/\\'/g;
#		print O "	" x $tab, "print '$wordt';\n";
	}
	else {
		(my $firstatom = $l) =~ s/\s*([a-z]*)\s*(.*)/$1/;
		my $p = $2;
		if (! $firstatom) {
			($firstatom = $l) =~ s/\s*([<=>!]*)\s*(.*)/$1/;
			$p = $2;
			die "$pageid : wrong function call near $l" unless ($firstatom && ($operators{$firstatom}));
		}
		if (exists $funcarray{$firstatom}) { $f = "process$firstatom"; &{$f} (*O, *E, $p, $l); }
		elsif (exists $operators{$firstatom}) { processop(*O, *E, $p, $l, $firstatom); }
		else { processvar (*O, *E, $l); }
	}
}

sub process {
	my $a = shift;
	local *O = shift;
	local *E = shift;
	my $beg=shift;
	my $end=shift;
	my $i=0;
	#&{$beg}($a->[$i]);
	if ($beg) {
		while (defined($a->[$i]) && ($a->[$i] !~ /$beg/)) {$i++}
		$i += 4;
		print O "# BEGINING $beg\n";
	}

	my $cont=1;
	while ($cont && defined ($a->[$i])) {

		if ($incomment) {
			if ($a->[$i+3] =~ /endcomment/) {
				for (my $x = 0; $i <= 6; $x++) {
					$i++;
					$a->[$i] =~ s/\n|\r/\n# /g;
					print O "#  $a->[$i]";
				}
				processendcomment();
				print O "\n";
			}
			else {
				$a->[$i] =~ s/\n|\r/\n# /g;
				print O "#  $a->[$i]";
				$i++
			}
		}
    elsif (($end) && ($a->[$i+3] =~ /$end/)) {
			$cont = 0;
			print O "# END $end\n";
		}
		else {
			if (($a->[$i] =~ /<!--\s*/) && ($a->[$i + 2] eq '#?') && ($a->[$i + 4] eq '?#') && ($a->[$i + 6] =~ /\s*-->/)) {
					my $s = $a->[$i] . $a->[$i + 1] . $a->[$i + 2] . $a->[$i + 3] . $a->[$i + 4] . $a->[$i + 5] . $a->[$i + 6];
					$s =~ s/'/\\'/g;
					print O "\n# $s;\n";
				processtag (*O, *E, $a->[$i+3], $tab);
				$i += 6;
			}
			elsif (($a->[$i] eq '#?') && ($a->[$i + 2] eq '?#')) {
				processtag (*O, *E, $a->[$i+1], $tab);
				$i += 2;
			}
			else {
				if (! $incomment) {
					$a->[$i] =~ s/'/\\'/g;
					print O "\n", "	" x $tab, "print '$a->[$i]';\n";
				}
				else {
					$a->[$i] =~ s/\n|\r/\n#	/g;
					print O "#	$a->[$i]\n";
				}
			}
			$i++
		}
	}
}

sub findisa {
	local *O = shift;
	local *E = shift;
	my $a = shift;
	my $done = 0;
	my $func = undef;
	my $ret = "";


	foreach my $l (@{$a}) {
		if ($l =~ /^isa .*/) { $func = "processisa"; }
		elsif ($l =~ /^use .*/) { $func = "processuse"; }
		if ($func) {
			(my $firstatom = $l) =~ s/\s*([a-z]*)\s*(.*)/$1/;
			my $p = $2;
			$ret .= &{$func}(*O, *E, $p, $l);
			$done++;
		}
		$func = undef;
#		last unless ($done < 2);
	}
	return $ret;
}

sub head {
	local *O = shift;
	local *E = shift;
	my $a = shift;
	my $fname = shift;

	my $isa;

	my @d = localtime (time());
	$d[4] += 1;
	$d[5] += 1900;
	$d[3] = "0" . $d[3] unless ($d[3] > 9);
	$d[4] = "0" . $d[4] unless ($d[4] > 9);
	$d[0] = "0" . $d[0] unless ($d[0] > 9);
	$d[1] = "0" . $d[1] unless ($d[1] > 9);
	$d[2] = "0" . $d[2] unless ($d[2] > 9);

	die "$pageid : ISA not defined" unless ($isa = findisa (*O, *E, $a));
	print O "#!/usr/local/bin/perl
#
# $fname.pm $d[3]/$d[4]/$d[5] at $d[2]:$d[1]:$d[0] - generated by tplparse.pl
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
";

print O "use 5.005;\n";

print O "package $fname;\n";

print O "$isa\n";

print O "sub displaypage {\n\n";

$tab++;

print O "	" x $tab, 'my $self = shift;', "\n\n";

}

sub tail {
	local *O = shift;

	print O "} # page\n\n1;\n";

	$tab--;
}

sub main {

#	die "usage :\n\ttplparse bodytemplate language\n" unless ($#ARGV == 1);
#	chdir "..";

	local $/;
	undef $/;                                                                                                                                     
#	my $tplb = $ARGV[0];
	my $tplb = shift;
	my $pkname = (split (/\./, $tplb))[0];
	$pageid    = $pkname;
	my $lang = $ARGV[1];
	print "processing $tplb, $lang ..\n";
	my $tplh = "site/models/headmodel.html";
	my $tplt = "site/models/tailmodel.html";
	my $errors = "site/models/control/$pkname.$lang.lst";
#	my $outfile = "cgi/$lang/$pkname.pm";
	my $outfile = "cgi/PM/$pkname.pm";

#	require "cgi/$lang/translate.pm";

	open (B, "site/models/$tplb") || open (B, "site/models/$tplb.html") || die "\n\t$pageid : Unable to open site/models/$tplb\n";
	open (H, $tplh) || die "\n\t$pageid : Unable to open Head model $tplh\n";
	open (T, $tplt) || die "\n\t$pageid : Unable to open Tail model $tplt\n";
	open (O,"> $outfile") || die "\n\$pageid : tUnable to open output file $outfile\n";;
	open (E,"> $errors") || die "\n\t$pageid : Unable to open error file $errors\n";;

	@c=split(/(<!--|#\?|\?#|-->)/,<B>);
	head (*O, *E, \@c, $pkname);
	my @a=split(/(<!--|#\?|\?#|-->)/,<H>);
	my $b = \@a;
	process($b, *O, *E, undef, "endhead");
	close (H);

	$b = \@c;
	process($b, *O, *E, "beginbody", "endbody");
	close (B);

	@a=split(/(<!--|#\?|\?#|-->)/,<T>);
	$b = \@a;
	process($b, *O, *E, "begintail", undef);
	close (T);
	tail (*O, $pkname);
	close (E);
	close (O);

}

die "usage :\n\ttplparse bodytemplate language\n" unless ($#ARGV >= 0);

my $CAFDIR;
my $DEFHOME = '/home/app/cafeterra';
if ((-d 'cgi') and (-d 'site') and (-d 'site/models') and (-d 'cgi/PM')) { $CAFDIR = "."; }
elsif ((-d '../cgi') and (-d '../site') and (-d '../site/models') and (-d '../cgi/PM')) { $CAFDIR = ".."; }
elsif ((-d '../../cgi') and (-d '../../site') and (-d '../../site/models') and (-d '../../cgi/PM')) { $CAFDIR = "../.."; }
elsif ((-d '$DEFHOME/cgi') and (-d '$DEFHOME/site') and (-d '$DEFHOME/site/models') and (-d '$DEFHOME/cgi/PM')) {
	$CAFDIR = '$DEFHOME';
}

die "No cafeterra home found" unless ($CAFDIR and -d $CAFDIR);

chdir $CAFDIR;
my @FILES;
opendir (D, 'site/models');
my @ALLFILES = readdir(D);
close D;
if ($ARGV[0] eq '-ALL') {
	foreach my $f (@ALLFILES) {
		if (($f !~ /^headmodel|^tailmodel/) and ($f =~ /(.*)\.html$/)) { push @FILES, $1; }
	}
}
else {
	my %DONE;
	foreach my $p (@ARGV) {
		next if (($p eq 'FR') or ($p eq 'EN'));
		$p =~ s/\*/.*/;
		$p =~ s/\?/./;
		foreach my $f (@ALLFILES) {
			if (($f !~ /^headmodel|^tailmodel/) and ($f =~ /^$p/) and ($f =~ /(.*)\.html$/)) {
				push @FILES, $1 unless ($DONE{$1});
				$DONE{$1} = 1;
			}
		}
	}
}

$ENV{LANG} ='C';
foreach my $f (@FILES) { eval { main($f); }; print "$@\n" if ($@); }
