#!/usr/local/bin/perl
#
# Flow.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package Flow;

@Flow::ISA = ('cafPage');

# fName => "userid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [
#??	{ fName => "id" },
	{ fName => "type" },
	{ fName => "name", fType => "atom", fMand => 1, fMin => 3, dMax => 30 }, 
	{ fName => "objectlabel", },
	{ fName => "parent_id" },
	{ fName => "created" },
	{ fName => "modified" },
	{ fName => "deleted" },
	{ fName => "comments" },
	{ fName => "status" },
	{ fName => "createdby" },
	{ fName => "modifiedby" },
	{ fName => "object_id" },
	{ fName => "flowtype"},
	{ fName => "flowmethod"},
	{ fName => "incomrel", default => "independant", },
	{ fName => "bufferedflow", default => "yes", },
	{ fName => "commitinterv", default => "1", },
	{ fName => "currentuser" },
	];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $currpage = $self->_hiddenvar ("_currpage");
	if (($currpage eq 'sflowl') and ($curraction eq 'search')) { $curraction = 'searchs'; }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->$meth_name($cgi, $dbh, $conf);

}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	($self->{search1} = $cgi->param("search1")) =~ s/ *//g;
	($self->{search2} = $cgi->param("search2")) =~ s/ *//g;

	my $cond = [];
	my $icond = -1;
	if ($self->{search1}) {
		$cond->[++$icond] = [ [ "objects.name" ], "like", $self->{search1} ];
	}
	if ($self->{search2}) { $cond->[++$icond] = [ "objects.status", "like", $self->{search2} ]; }

	my ($rowscount, $lastrow, $maxlistdisplay) = $self->_getnavinfo ("flow", $cond, "isobject");
	
	my $query = $dbh->newquery({ name => $self->{search1}, status => $self->{search2} });
	$query->sflowlist();

	$self->{_list1} = $dbh->hexecfetchset($query, $lastrow - 1, $maxlistdisplay);
	$self->{list1count} = $query->hrowcount();

	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_lastrow",  $lastrow + $self->{list1count});
	$self->_hiddenvar ("_objectid", "");
	$self->_setnavinfo("list1");
}

sub meth_searchs {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	($self->{search1} = $cgi->param("search1")) =~ s/ *//g;
	($self->{search2} = $cgi->param("search2")) =~ s/ *//g;

	my $cond = [];
	my $icond = -1;
	if ($self->{search1}) {
		$cond->[++$icond] = [ [ "objects.name" ], "like", $self->{search1} ];
		$cond->[++$icond] = [ [ "objects.label" ], "like", $self->{search1} ];
	}
	if ($self->{search2}) { $cond->[++$icond] = [ "objects.status", "like", $self->{search2} ]; }

	my ($rowscount, $lastrow, $maxlistdisplay) = $self->_getnavinfo ("subflow", $cond, "isobject");
	
	my $query = $dbh->newquery({ name => $self->{search1}, status => $self->{search2} });
	$query->ssubflowlist();

	$self->{_list1} = $dbh->hexecfetchset($query, $lastrow - 1, $maxlistdisplay);
	$self->{list1count} = $query->hrowcount();

	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_lastrow",  $lastrow + $self->{list1count});
	$self->_hiddenvar ("_objectid", "");
	$self->_setnavinfo("list1");
}

sub meth_edit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_systemvar("_miscinfo_", '_miscinfo_');
	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	$self->_getcheckfields ($cgi, $editfields);
	$self->_datavar("type", 'flow');
	$self->_hiddenvar ("search1", $cgi->param("search1"));
	$self->_hiddenvar ("search2", $cgi->param("search2"));

	if ($actiondetail =~ /^v/) { $self->_initmeth_edit($cgi, $dbh, $conf); }
	elsif ($actiondetail eq 'new') { $self->{_system}{noselect} = 1; }
	else { $self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id")); }

	$actiondetail = $self->_hiddenvar ("_actiondetail");

	unless ($self->{_system}{noselect}) {
		my $query = $dbh->newquery({ object_id => $self->_datavar("object_id") });
		$query->sflowlist ();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_data} = {};
		foreach my $field (%{$row}) { $self->{_data}{$field} = $row->{$field}; }
	}
	if ($actiondetail eq 'copy') { $self->_datavar("object_id", undef); }
	$self->_hiddenvar ("_objectid", $self->_datavar("object_id"));

	$self->_datavar("incomrel", "independant") unless ($self->_datavar("incomrel"));
	$self->_datavar("bufferedflow", "no") unless ($self->_datavar("bufferedflow"));
	$self->_datavar("commitinterv", "1") unless ($self->_datavar("commitinterv"));

	$self->{_attributeslist} = $self->_getmyattributes($dbh);
	$self->{_envvarslist} = $self->_getmyenvvars($dbh);
	$self->{_envvarslist} = [] unless ($self->{_envvarslist});
	push @{$self->{_envvarslist}}, ({vartype => 'env'}, {vartype => 'env'});
}

sub meth_vnew () {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_datavar("object_id", $dbh->nextseq("objects"));

	my $bindvars = $self->_getmyfields();
	my $query = $dbh->newquery($bindvars);

	$query->iobject();
	my $ret;
	if ($ret = $dbh->executefinish($query)) {
		$query->iflow();
		if (($ret = $dbh->executefinish($query)) > 0) {
			$self->_updateattributes();
			$self->_updateenvvars();
			$dbh->commit();
		}
		else { $dbh->rollback(); }
	}
	else { $dbh->rollback(); }


	return ($ret);
}

sub meth_vedit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

        $self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id"));
        my $query = $dbh->newquery($self->_getmyfields());
        my $ret;
 
        $query->uobject();

	if (($ret = $dbh->executefinish($query)) > 0) {

		$query->uflow();

		if (($ret = $dbh->executefinish($query)) > 0) {
			$self->_updateattributes();
			$self->_updateenvvars();
			$dbh->commit();
		}
		else { $dbh->rollback(); }
	}
	else { $dbh->rollback(); }

	$dbh->commit();
	return ($ret);
}

sub meth_edits {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

#	$self->_systemvar("_miscinfo_", '_miscinfo_');
	
	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	$self->_getcheckfields ($cgi, $editfields);
	$self->_datavar("type", 'flow');
	$self->_hiddenvar ("search1", $cgi->param("search1"));
	$self->_hiddenvar ("search2", $cgi->param("search2"));

	if ($actiondetail =~ /^v/) { $self->_initmeth_edit($cgi, $dbh, $conf); }
	elsif ($actiondetail eq 'new') { $self->{_system}{noselect} = 1; }
	else { $self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id")); }

	$actiondetail = $self->_hiddenvar ("_actiondetail");

	my $object_id = $self->_datavar("object_id");
	unless ($self->{_system}{noselect}) {
		my $query = $dbh->newquery({ object_id => $object_id });
		$query->sflowlist ();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_data} = {};
		foreach my $field (%{$row}) { $self->{_data}{$field} = $row->{$field}; }
	}
	my $incomflow = $dbh->getsubflow($object_id, 'incom') || [];
	my $mxsflow = ($#$incomflow >= 0) ? $incomflow->[$#$incomflow]{floworder} : 0;
	$mxsflow += 10;
	push @$incomflow, ({floworder => $mxsflow, flowmethod => "normal"},{floworder => $mxsflow + 10, flowmethod => "normal"});
	
	my $outgoflow = $dbh->getsubflow($object_id, 'outgo') || [];
	my $mxsflow = ($#$outgoflow >= 0) ? $outgoflow->[$#$outgoflow]{floworder} : 0;
	$mxsflow += 10;
	push @$outgoflow, ({floworder => $mxsflow},{floworder => $mxsflow + 10});

	if ($actiondetail eq 'copy') { $self->_datavar("object_id", undef); }
	$self->_hiddenvar ("_objectid", $self->_datavar("object_id"));
	$self->{_incomlist} = $incomflow;
	$self->{_outgolist} = $outgoflow;
}

sub meth_vedits {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

        $self->_datavar("object_id", $cgi->param("object_id")) unless ($self->_datavar("object_id"));
	my $object_id = $self->_datavar("object_id");

	my $query = $dbh->newquery({ object_id => $object_id });
	$query->sflowlist();
	my $flow = $dbh->hexecfetchrownop($query);

	my $ret;
	eval {
	my $subflows = $self->getmysubflows($cgi, $dbh);
	if ($ret = $dbh->updatemysubflows($subflows)) { $dbh->commit(); }
	else { $dbh->rollback(); }
	};
	print $@;

	return ($ret);
}

sub meth_edite {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

#	$self->_systemvar("_miscinfo_", '_miscinfo_');
	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	$self->_getcheckfields ($cgi, $editfields);
	$self->_datavar("type", 'flow');
	$self->_hiddenvar ("search1", $cgi->param("search1"));
	$self->_hiddenvar ("search2", $cgi->param("search2"));

	if ($actiondetail =~ /^v/) { $self->_initmeth_edit($cgi, $dbh, $conf); }
	elsif ($actiondetail eq 'new') { $self->{_system}{noselect} = 1; }
	else { $self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id")); }

	$actiondetail = $self->_hiddenvar ("_actiondetail");

	my $object_id = $self->_datavar("object_id");
	unless ($self->{_system}{noselect}) {
		my $query = $dbh->newquery({ object_id => $object_id });
		$query->sflowlist ();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_data} = {};
		foreach my $field (%{$row}) { $self->{_data}{$field} = $row->{$field}; }
	}
	my $subflowid = $cgi->param("subflow_id");
	my $query = $dbh->newquery({ object_id => $subflowid, });
	$query->ssubflowlist();
	my $subflow = $dbh->hexecfetchrownop($query, 1) || [];

	$query = $dbh->newquery({ object_id => $subflowid });
	$query->sscriptobject();
	my $_sflowscripts = $dbh->hexecfetchall($query) || [];
	my $scrcount = $#$_sflowscripts;
	my $sflowscripts;

	my $steps = "select,insert,update,delete,rename,truncate,drop,create,sbconnect,saconnect,sbopen,saopen,sbclose,saclose,sbdiscon,sadiscon,sbread,saread,sbwrite,sawrite,sbtransf,satransf,stransform,onerror";
	
	if ($subflow->{flowdirection} eq 'incom') { 
		$steps = "select,insert,update,delete,rename,truncate,drop,create,sbconnect,saconnect,sbopen,saopen,sbclose,saclose,sbdiscon,sadiscon,sbread,saread,sbtransf,satransf,stransform,onerror";
	}
	my $scr;
	foreach my $step (split(/,/, $steps)) {
		my $done = "";
		foreach (my $i = 0; $i <= $scrcount; $i++) {
			$scr = $_sflowscripts->[$i];
			if ($scr->{step} eq $step) {
				push @$sflowscripts, $scr;
				$_sflowscripts->[$i] = {};
				$done = "yes";
				last;
			}
		}
		my $lang;
		if ($step =~ /select|insert|update|delete|rename|truncate|drop|create/) { $lang = "sql"; }
		else { $lang = "perl"; }
		if (! $done) { push @$sflowscripts, {step => $step, scriptlang => $lang }; }
		@$sflowscripts->[$#$sflowscripts]->{scriptlang} = $lang;
	}

	foreach $scr (@$_sflowscripts) { push (@$sflowscripts, $scr) if ($scr->{script_id}); }

	my $usedforlist;
	if ($subflow->{flowdirection} eq 'incom') { #usedforlist = "getmsg,ackmsg,globalack"
		$usedforlist->{getmsg}=0;
		$usedforlist->{ackmsg}=2;
		$usedforlist->{globalack}=4;
	}
	elsif ($subflow->{flowdirection} eq 'outgo') { #usedforlist = "cleartarget,sendmsg,sendmsgbis,readrbinfo"
		$usedforlist->{getrbinfo}=0;
		if ($subflow->{flowmethod} eq 'update') {
			$usedforlist->{sendmsg}=2;
		}
		if ($subflow->{flowmethod} eq 'insert') {
			$usedforlist->{sendmsg}=1;
		}
		if ($subflow->{flowmethod} eq 'delete') {
			$usedforlist->{sendmsg}=3;
		}
		if ($subflow->{flowmethod} eq 'updins') {
			$usedforlist->{sendmsg}=2;
			$usedforlist->{sendmsgbis}=1;
		}
		if ($subflow->{flowmethod} eq 'delins') {
			$usedforlist->{sendmsg}=3;
			$usedforlist->{sendmsgbis}=1;
		}
		if ($subflow->{flowmethod} eq 'insupd') {
			$usedforlist->{sendmsg}=1;
			$usedforlist->{sendmsgbis}=2;
		}
		if ($subflow->{flowmethod} eq 'truncate') {
			$usedforlist->{cleartarget}=4;
			$usedforlist->{sendmsg}=1;
		}
	}

	ACTION: foreach my $action (keys %$usedforlist) {
		foreach $scr (@$sflowscripts) {
			if ($scr->{usedfor} eq $action) { next ACTION; }
		}
		$sflowscripts->[$usedforlist->{$action}]->{usedfor} = $action;
	}

	push @$sflowscripts, ({step => 'user'}, {step => 'user'});

	$self->{_scriptlist} = $sflowscripts;
	$self->{_subflow} = $subflow;
	$self->{_usedforlist} = $usedforlist;

	if ($actiondetail eq 'copy') { $self->_datavar("object_id", undef); }
	$self->_hiddenvar ("_objectid", $self->_datavar("object_id"));
}

sub meth_vedite {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

        $self->_datavar("object_id", $cgi->param("object_id")) unless ($self->_datavar("object_id"));
	my $object_id = $self->_datavar("object_id");

	my $ret;
	my $scripts = $self->getmyscripts($cgi->param("subflow_id"), $cgi, $dbh);
=over ? bizarre
	my $subflow = {
		object_id => $cgi->param("subflow_id"),
		flow_id => $object_id,
		parent_id => $object_id,
		name => $cgi->param("subflowname"),
		objectlabel => $cgi->param("subflowlabel"),
		container_id => $cgi->param("container_id"),
		flowdirection => $cgi->param("flowdirection"),
		floworder => $cgi->param("floworder"),
		flowmethod => $cgi->param("flowmethod"),
		dependant => $cgi->param("dependant"),
		direct => $cgi->param("direct"),
		currentuser   => $self->_hiddenvar("_userid"),
		status   => $cgi->param("subflowstatus"),
	};
=cut # bizarre

	my $subflow = {
		object_id => $cgi->param("subflow_id"),
		name => $cgi->param("subflowname"),
		objectlabel => $cgi->param("subflowlabel"),
		type        => 'subflow',
		status   => $cgi->param("subflowstatus"),
		flow_id => $object_id,
		parent_id => $object_id,
		container_id => $cgi->param("container_id"),
		floworder => $cgi->param("floworder"),
		flowdirection => $cgi->param("flowdirection"),
		flowmethod => $cgi->param("flowmethod"),
		dependant => $cgi->param("dependant"),
		direct => $cgi->param("direct"),
		onoutgoerr      => $cgi->param("onoutgoerr"),
		keepalive       => $cgi->param("keepalive") || 'no',
		mailonerr       => $cgi->param("mailonerr"),
		mailonsucc      => $cgi->param("mailonsucc"),
		currentuser   => $self->_hiddenvar("_userid"),
	};

	#my $scripts = $self->getmyscripts($subflow->{object_id}, $cgi, $dbh);
	if ($ret = $dbh->updatemysubflows({ $subflow->{flowdirection} => [$subflow] }) > 0) {
		if ($scripts) {
			$ret = $dbh->updatemyscripts($subflow->{object_id}, $scripts);
		}
	}
	if ($ret > 0) { $dbh->commit(); }
	else { $dbh->rollback(); }

	return ($ret);
}


sub meth_editp {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

#	$self->_systemvar("_miscinfo_", '_miscinfo_');
	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	$self->_getcheckfields ($cgi, $editfields);
	$self->_datavar("type", 'flow');
	$self->_hiddenvar ("search1", $cgi->param("search1"));
	$self->_hiddenvar ("search2", $cgi->param("search2"));

	if ($actiondetail =~ /^v/) { $self->_initmeth_edit($cgi, $dbh, $conf); }
	elsif ($actiondetail eq 'new') { $self->{_system}{noselect} = 1; }
	else { $self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id")); }

	$actiondetail = $self->_hiddenvar ("_actiondetail");

	my $object_id = $self->_datavar("object_id");
	my $query;
	unless ($self->{_system}{noselect}) {
		$query = $dbh->newquery({ object_id => $object_id });
		$query->sflowlist ();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_data} = {};
		foreach my $field (%{$row}) { $self->{_data}{$field} = $row->{$field}; }
	}

	$query = $dbh->newquery({ object_id => $object_id });
	$query->sscriptobject();
	my $_flowscripts = $dbh->hexecfetchall($query) || [];
	my $scrcount = $#$_flowscripts;
	my $flowscripts;

	my $steps = "bstart,astart,bstop,astop,onerror";
	
	my $scr;
	foreach my $step (split(/,/, $steps)) {
		my $done = "";
		for (my $i = 0; $i <= $scrcount; $i++) {
			$scr = $_flowscripts->[$i];
			if ($scr->{step} eq $step) {
				push @$flowscripts, $scr;
				$_flowscripts->[$i] = {};
				$done = "yes";
				last;
			}
		}
		my $lang;
		$lang = "perl";
		if (! $done) { push @$flowscripts, {step => $step, scriptlang => $lang }; }
		@$flowscripts->[$#$flowscripts]->{scriptlang} = $lang;
	}


	for (my $i = 0; $scr = $_flowscripts->[$i]; $i++) {
		if ($scr->{step} eq 'user') {
			push @$flowscripts, $scr;
			$_flowscripts->[$i] = {};
		}
	}
	push @$flowscripts, ({step => 'user'}, {step => 'user'});

	$query = $dbh->newquery({ parent_id => $object_id , type => 'connector' });
	$query->sotherobject();
	my $otherconnectors = $dbh->hexecfetchall($query) || [];
	
	$query = $dbh->newquery({ parent_id => $object_id , type => 'container' });
	$query->sotherobject();
	my $othercontainers = $dbh->hexecfetchall($query) || [];
	
#	for (my $i = 0; $scr = $_flowscripts->[$i]; $i++) {
#		if ($scr->{step} eq 'connector') {
#			push @$otherconnectors, $scr;
#			delete $_flowscripts->[$i];
#		}
#	}

	push @$otherconnectors, ({}, {});
	push @$othercontainers, ({}, {});

	$self->{_scriptlist} = $flowscripts;
	$self->{_connectorslist} = $otherconnectors;
	$self->{_containerslist} = $othercontainers;

	if ($actiondetail eq 'copy') { $self->_datavar("object_id", undef); }
	$self->_hiddenvar ("_objectid", $self->_datavar("object_id"));
}

sub meth_veditp {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

        $self->_datavar("object_id", $cgi->param("object_id")) unless ($self->_datavar("object_id"));
	my $object_id = $self->_datavar("object_id");

	my $ret;
	my $scripts = $self->getmyscripts($object_id, $cgi, $dbh);
	my $connectors = $self->getmyconnectors($object_id, $cgi, $dbh);
#	foreach my $conn (@$connectors) {
#		$conn->{step} = 'connector';
#		push @$scripts, $conn;
#	}

	#my $scripts = $self->getmyscripts($subflow->{object_id}, $cgi, $dbh);
	$ret = 1;
#	if ($scripts) {
		$ret = $dbh->updatemyscripts($object_id, $scripts);
#	}
#	if ($connectors) {
		if ($ret >= 0) {
			$ret = $dbh->updatemyobjects($object_id, $connectors);
		}
#	}
	if ($ret > 0) { $dbh->commit(); }
	else { $dbh->rollback(); }

	return ($ret);
}


sub meth_editm {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

#	$self->_systemvar("_miscinfo_", '_miscinfo_');
	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	$self->_getcheckfields ($cgi, $editfields);
	$self->_datavar("type", 'flow');
	$self->_hiddenvar ("search1", $cgi->param("search1"));
	$self->_hiddenvar ("search2", $cgi->param("search2"));

	if ($actiondetail =~ /^v/) { $self->_initmeth_edit($cgi, $dbh, $conf); }
	elsif ($actiondetail eq 'new') { $self->{_system}{noselect} = 1; }
	else { $self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id")); }

	$actiondetail = $self->_hiddenvar ("_actiondetail");

	my $object_id = $self->_datavar("object_id");
	unless ($self->{_system}{noselect}) {
		my $query = $dbh->newquery({ object_id => $object_id });
		$query->sflowlist ();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_data} = {};
		foreach my $field (%{$row}) { $self->{_data}{$field} = $row->{$field}; }
	}
	my $subflowid = $cgi->param("subflow_id");
	my $query = $dbh->newquery({ object_id => $subflowid, });
	$query->ssubflowlist();
	my $subflow = $dbh->hexecfetchrownop($query, 1) || [];

	$query = $dbh->newquery({ parent_id => $subflow->{container_id} });
	$query->sfieldlist();
	my $subflowfields = $dbh->hexecfetchall($query);

	$query = $dbh->newquery({ subflow_id => $subflowid });
	$query->smappinglist();
	my $_mapping = $dbh->hexecfetchall($query) || [];

	my $outgofields;
	my $incomfields;
	my $mapping;

	if ($subflow->{flowdirection} eq 'outgo') {
		
		my $outgofields = $subflowfields;

		$query = $dbh->newquery({ flow_id => $subflow->{parent_id}, incomrel => $self->{_data}{incomrel} });
		$query->sflowincomfields();
		$incomfields = $dbh->hexecfetchall($query);

		my $i;
		my $j;
		foreach ($j = 0; my $ofld = $outgofields->[$j]; $j++) {
			my $found = "";
			for ($i = 0; my $map = $_mapping->[$i]; $i++) {
				if ($map->{outgofield_id} == $ofld->{object_id}) {
					$found = "yes";
					$map->{outgofield_name} = $ofld->{name};
					if ($map->{incomfield_id}) {
						foreach my $if (@$incomfields) {
							if ($map->{incomfield_id} == $if->{object_id}) { $map->{incomfield_name} = $if->{name}; }
						}
					}
					push @$mapping, $map;
					last;
				}
			}
			if (! $found) {
				$found = "";
				my $oname = $ofld->{name};
				$oname =~ s/[^[:alnum:]]//g;
				for ($i = 0; my $ifld = $incomfields->[$i]; $i++) {
					my $iname = $ifld->{name};
					$iname =~ s/[^[:alnum:]]//g;
					if (lc($iname) eq lc($oname)) {
						$found = "yes";
						push @$mapping, {
							incomfield_id => $ifld->{object_id},
							incomfield_name => $ifld->{name},
							outgofield_id => $ofld->{object_id},
							outgofield_name => $ofld->{name},
						};
						last;
					}
				}
				if (! $found) {
					push @$mapping, {
							incomfield_id => $incomfields->[$j]->{object_id},
							incomfield_name => $incomfields->[$j]->{name},
							outgofield_id => $ofld->{object_id},
							outgofield_name => $ofld->{name},
					};
				}
			}
		}
		$self->{_incomfields} = $incomfields;
		$self->{_outgofields} = $outgofields;
		use Data::Dumper;
		unshift @$incomfields, {object_id => -1, name => "______________", objectlabel => "_____________" };
	}
	else {
		$incomfields = $subflowfields;
		$self->{_outgofields} = $incomfields;
		foreach (my $j = 0; my $fld = $incomfields->[$j]; $j++) {
			my $found = "";

			foreach (my $i = 0; my $map = $_mapping->[$i]; $i++) {
				if ($map->{outgofield_id} == $fld->{object_id}) {
					$found = "yes";
					$map->{outgofield_name} = $fld->{name};
					push @$mapping, $map;
				}
			}
			if (! $found) {
				push @$mapping, {
						outgofield_id => $fld->{object_id},
						outgofield_name => $fld->{name},
				};
			}
		}
	}

	my @myobjects;
	foreach my $map (@$mapping) {
		if ($map->{script_id}) { push @myobjects, $map->{script_id}; }
		else { $map->{script_id} = undef; }
		$map->{incomfield_id} = undef unless ($map->{incomfield_id});
	}
	if ($#myobjects >= 0) {
		$query = $dbh->newquery({ id => \@myobjects });
		$query->sobjectlist();
		my $scripts = $dbh->hexecfetchall($query);
		foreach my $scr (@$scripts) {
			foreach my $map (@$mapping) {
				if ($map->{script_id} == $scr->{id}) { $map->{script_name} = $scr->{name}; last; }
			}
		}
	}
	$self->{_maplist} = $mapping;
	$self->{_subflow} = $subflow;

	$self->_hiddenvar ("_objectid", $self->_datavar("object_id"));
}

sub meth_veditm {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_datavar("object_id", $cgi->param("object_id")) unless ($self->_datavar("object_id"));
	my $object_id = $self->_datavar("object_id");

	my $ret;
	my $mapping = $self->getmymapping($cgi->param("subflow_id"), $cgi, $dbh);
	my $subflow = {
		object_id => $cgi->param("subflow_id"),
		name => $cgi->param("subflowname"),
		objectlabel => $cgi->param("subflowlabel"),
		type        => 'subflow',
		status   => $cgi->param("subflowstatus"),
		flow_id => $object_id,
		parent_id => $object_id,
		container_id => $cgi->param("container_id"),
		floworder => $cgi->param("floworder"),
		flowdirection => $cgi->param("flowdirection"),
		flowmethod => $cgi->param("flowmethod"),
		dependant => $cgi->param("dependant"),
		direct => $cgi->param("direct"),
		onoutgoerr      => $cgi->param("onoutgoerr"),
		keepalive       => $cgi->param("keepalive") || 'no',
		mailonerr       => $cgi->param("mailonerr"),
		mailonsucc      => $cgi->param("mailonsucc"),
		currentuser   => $self->_hiddenvar("_userid"),
	};

	#my $scripts = $self->getmyscripts($subflow->{object_id}, $cgi, $dbh);
	if ($ret = $dbh->updatemysubflows({ $subflow->{flowdirection} => [$subflow] }) > 0) {
		if ($mapping) {
			$ret = $dbh->updatemymapping($subflow->{object_id}, $mapping);
		}
	}
	if ($ret > 0) { $dbh->commit(); }
	else { $dbh->rollback(); }

	return ($ret);
}


sub meth_vdocument {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;


	my @selectedObjects;

        $self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id"));
	my $object_id = $self->_datavar("object_id");

#	for (my $i = 0; my $objectid=cafCGI->param("object_id_$i"); $i++) {
#		if (cafCGI->param("update_$i") or cafCGI->param("deploy_$i")) { push @selectedObjects, $objectid; }
#	}
	push @selectedObjects, $object_id;

	require connectors::ObjHier;
	my $refrep = ObjHier->new($dbh, "DOCUMENTATION", "DOCUMENTATION", "DOCUMENTATION");
	$refrep->gethierarchy(\@selectedObjects);
#	my $ptext = $refrep->dumpall();

#	print "<TEXTAREA rows=10 cols=100>$ptext</TEXTAREA>";

	my %doc = ();
	$doc{flow} = $refrep->getobject($object_id);
	$doc{flow}{attributes} = $refrep->attributelist($object_id);
	$doc{flow}{events} = $refrep->eventslist($object_id);
	$doc{flow}{vars} = $refrep->varslist($object_id);
	$doc{flow}{scripts} = $refrep->objectscripts($object_id);

	my $isf = $refrep->subflows($object_id, "INCOM");
	my $osf = $refrep->subflows($object_id, "OUTGO");
	my @sf = $isf ? @$isf : ();
	push @sf, @$osf if ($osf);
	$doc{incoming} = [];
	$doc{outgoing} = [];
	$doc{subflows} = [];
	my %alltables = ();
	my %allscripts;
#	foreach my $obid (@{$doc{incoming}}, @{$doc{outgoing}}) {
	foreach my $obid (@sf) {
		next unless ($obid and ($obid > 0));
		my $ob = $refrep->getobject($obid);
		push @{$doc{incoming}}, $ob if ($ob->{flowdirection} eq "incom");
		push @{$doc{outgoing}}, $ob if ($ob->{flowdirection} eq "outgo");
		push @{$doc{subflows}}, $ob;
		if ($ob->{container_id} > 0) {
			my $c = $refrep->getobject($ob->{container_id});
			if (($c) && ! ($alltables{$ob->{container_id}})) {
				$c->{_fields} = $refrep->myfields($c->{object_id});
				$c->{attributes} = $refrep->attributelist($c->{object_id});
				$c->{vars} = $refrep->varslist($c->{object_id});
				$alltables{$ob->{container_id}} = $c;
			}
			$ob->{container_name} = $c->{name};
			$ob->{container_extname} = $c->{externalname};
			$ob->{container_label} = $c->{objectlabel};
		}
		else { $ob->{container_id} = undef; }
		$ob->{mapping} = $refrep->mappfieldlist($ob->{object_id});
		$ob->{attributes} = $refrep->attributelist($ob->{object_id});
		$ob->{events} = $refrep->eventslist($ob->{object_id});
		$ob->{vars} = $refrep->varslist($ob->{object_id});
		$ob->{scripts} = $refrep->objectscripts($ob->{object_id});
		if ($ob->{scripts}) {
			foreach my $s (@{$ob->{scripts}}) {
				if ($s->{script_id} > 0) {
					my $o = $refrep->getobject($s->{script_id});
					if ($o) { $allscripts{$s->{script_id}} = $o; }
					$s->{script_name} = $o->{name};
					$s->{scriptlang} = $o->{type};
					$s->{script_label} = $o->{objectlabel};
				}
			}
		}
		else { $ob->{scripts} = undef; }
		next unless ($ob->{mapping});
		foreach my $m (@{$ob->{mapping}}) {
			if ($m->{incomfield_id} > 0) {
				my $o = $refrep->getobject($m->{incomfield_id});
				$m->{incomfield_name} = $o->{name};
				$m->{incomfield_extname} = $o->{externalname};
			}
			else { $m->{incomfield_id} = undef; }
			if ($m->{outgofield_id} > 0) {
				my $o = $refrep->getobject($m->{outgofield_id});
				$m->{outgofield_name} = $o->{name};
				$m->{outgofield_extname} = $o->{externalname};
			}
			else { $m->{outgofield_id} = undef; }
			if ($m->{script_id} > 0) {
				my $o = $refrep->getobject($m->{script_id});
				if ($o) { $allscripts{$m->{script_id}} = $o; }
				$m->{script_name} = $o->{name};
				$m->{scriptlang} = $o->{type};
				$m->{script_label} = $o->{objectlabel};
			}
			else { $m->{script_id} = undef; }
			
		}
	}

	my @otherconn;
	foreach my $oid (@{$refrep->allobjects()}) {
		my $o = $refrep->getobject($oid);
		next unless ($o);
		if ($o->{type} eq 'connetcor') { push @otherconn, $o }
		if ($o->{type} eq 'container') {
			if (! ($alltables{$o->{object_id}})) {
				$o->{_fields} = $refrep->myfields($o->{object_id});
				$o->{attributes} = $refrep->attributelist($o->{object_id});
				$o->{vars} = $refrep->varslist($o->{object_id});
				$alltables{$o->{object_id}} = $o;
			}
		}
	}
	my @a = values %alltables;
			
	$doc{containers} = \@a;

	if ($doc{flow}{scripts}) {
		foreach my $s (@{$doc{flow}{scripts}}) {
			next if ($allscripts{$s->{script_id}});
			if ($s->{script_id} > 0) {
				my $o = $refrep->getobject($s->{script_id});
				$s->{script_name} = $o->{name};
				$s->{script_label} = $o->{objectlabel};
				$s->{scriptlang} = $o->{type};
				$allscripts{$s->{script_id}} = $o;
			}
		}
	}
	{ my @s = values %allscripts; $doc{scripts} = \@s; }

	my %allconnectors;
	my %allservers;
	my %allusers;
	my %allproxies;
	push @otherconn, @a;
	foreach my $ob (@otherconn) {
		if (($ob->{parent_id} > 0) || ($ob->{type} eq 'connetcor')) {
			my $c;
			if ($ob->{type} eq 'connetcor') { $c = $ob; }
			elsif ($ob->{parent_id}) { $c = $refrep->getobject($ob->{parent_id}); }
			if ($c) {
				$ob->{parent_id_name} = $c->{name} unless ($ob->{type} eq 'connetcor');
				if (! $allconnectors{$c->{object_id}}) {
					$allconnectors{$c->{parent_id}} = $c;
					$c->{attributes} = $refrep->attributelist($c->{object_id});
					$c->{vars} = $refrep->varslist($c->{object_id});
					$c->{parent_id} = undef unless ($c->{parent_id} > 0);
					my $s = $refrep->getobject($c->{parent_id}) if ($c->{parent_id});
					if ($s) {
						$c->{parent_id_name} = $s->{name};
						$allservers{$c->{parent_id}} = $s unless ($allservers{$c->{parent_id}});
					}

					$c->{userid} = undef unless ($c->{userid} > 0);
					my $u = $refrep->getobject($c->{userid}) if ($c->{userid});
					if ($u) {
						$c->{userid_name} = $u->{name};
						$allusers{$c->{userid}} = $u unless ($allusers{$c->{userid}});
					}

					$c->{proxy_id} = undef unless ($c->{proxy_id} > 0);
					my $p = $refrep->getobject($c->{proxy_id}) if ($c->{proxy_id});
					if ($p) {
						$c->{proxy_id_name} = $p->{name};
						$allproxies{$c->{proxy_id}} = $p unless ($allproxies{$c->{proxy_id}});
					}

					if ($c->{ismaster} ne "master") {
						$c->{master_id} = undef unless ($c->{master_id} > 0);
						my $m = $refrep->getobject($c->{master_id}) if ($c->{master_id});
						if ($m) {
							$c->{master_id_name} = $m->{name};
							$allconnectors{$c->{master_id}} = $m unless ($allconnectors{$c->{master_id}});
						}
					}
				}
			}
		}
		else { $ob->{parent_id} = undef; }
	}

	{ my @b = values %allconnectors; $doc{connectors} = \@b; }

	{ my @s = values %allservers; $doc{servers} = \@s; }

	{ my @u = values %allusers; $doc{users} = \@u; }

	{ my @p = values %allproxies; $doc{proxies} = \@p; }

	$self->{_documentation} = \%doc;
=cut
        require Data::Dumper;
        my $dump = Data::Dumper->new([\%doc], ["DOCUMENTATION"]);
        $dump->Indent(1);
	$self->{_doc_string} = $dump->Dump;
#$refrep->dumpall();
=cut

}

sub meth_viiidrope {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id"));
	my $query = $dbh->newquery($self->_getmyfields());
	$query->dflow();

	my $ret = $dbh->executefinish($query);
	return ($ret);
}


1;
