#!/usr/local/bin/perl
#
# stopMonitor.pl 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

#Main program

use Schedule::Cron;
use Getopt::Long;
use Time::ParseDate;
use Cwd;
use File::Spec;

use strict;

package launcher;

sub CronDispatcher {
	my $self = shift;

	return;

}

sub _PrintUsage {
	my $errMsg = shift;

	$errMsg .= "\nUsage : perl stopMonitor.pl --context=contextid --basedir=/path/to/base/dir \n";

	$errMsg .="Example time perl stopMonitor.pl  --context=default --basedir=/home/app/cafeterra\n";
	die $errMsg;
}

sub _ProcessOptions {
	my %config;

	Getopt::Long::GetOptions(\%config, "context=s", "basedir=s", "mode=s", "flow=s", "detach=s");

	_PrintUsage ("") unless ($config{context} and $config{basedir});

	$config{contextId} = $config{context};

	_PrintUsage("Can't change to basedir $config{basedir}\n") unless ($config{basedir} and (chdir $config{basedir}));

	my $cwd = Cwd::getcwd;

	_PrintUsage("Can't change to basedir $config{context}\n") unless ($config{context} and (chdir $config{context}));

	chdir $cwd;

	require mains::SchedRt;
	require mains::FlowTls;
	require mains::FlowRt;
	require mains::SFlowRt;
	require mains::FlowSubs;
#	require mains::FlowScrs;

	require connectors::cafDBI;
	require connectors::refDBI;
	require connectors::cafQry;
	require connectors::refQry;

	my $found;
	my $usermodfound = undef;
	my $usermod = "$config{basedir}/usermod";
	$usermod =~ s/\/\//\//g;

	foreach my $dir (@INC) {
		if ($dir eq $config{basedir}) { $found = "yes" }
		if ($dir eq $usermod) { $usermodfound = "yes" }
		last if ($found and $usermodfound);
	} 

	push @INC, $config{basedir} unless ($found);
	push @INC, $usermod unless ($usermodfound);

	my $confpkg = $config{context} . "::conf";
	eval "require $confpkg";

	_PrintUsage("Can't load $confpkg\n$@") if ($@);


	require tools::cafUtils;
	require tools::cafDbg;

	my $flowDir = $config{flowDir} = File::Spec->catdir($config{basedir}, $config{contextId}, $config{flowId});
	unless (-d $flowDir) {
		mkdir $flowDir;
	}

	chdir $flowDir;

	mkdir File::Spec->catdir($flowDir, "tmp") unless (-d "tmp");
	mkdir File::Spec->catdir($flowDir, "ftp") unless (-d "ftp");
	mkdir File::Spec->catdir($flowDir, "smtp") unless (-d "smtp");
	mkdir File::Spec->catdir($flowDir, "pop3") unless (-d "pop3");
	mkdir File::Spec->catdir($flowDir, "ldap") unless (-d "ldap");
	mkdir File::Spec->catdir($flowDir, "lfs") unless (-d "lfs");
	mkdir File::Spec->catdir($flowDir, "http") unless (-d "http");
	mkdir File::Spec->catdir($flowDir, "https") unless (-d "https");
	chdir $cwd;

	\%config;

}

sub StopMonitor {

	my $cronCfg = _ProcessOptions();

	my $CtxtDir = File::Spec->catdir($cronCfg->{basedir}, $cronCfg->{contextId});
	chdir $CtxtDir || die "cant change to $CtxtDir\n";
	open (PID, "<cafeterra.pid") || die "Can't open pidfile cafeterra.pid";

	my $line = <PID>;
	$line =~ s/[^0-9]//g;

	kill (0, $line);
	print "Killing $line\n";
	if (kill (10, $line)) { "Monitor Stopped\n"; }
	else { die "Monitor didn't stopped reason $!(" . $! + 0 . ")\n"; }

}

#Instance variables
#Running subflows
#Running 

StopMonitor();
