#!/usr/local/bin/perl
#
# Archiver.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

package SchedRt;



sub InitArchiver {
	my $self = shift;
	my $dbh = shift;

	$self->ObjectHierarchy(undef);
	$self->GetHierarchy("force");
	my $objHier = $self->ObjectHierarchy();
	my $context = $self->MyContext();

	my $archiveDbId = $context->{archconnector_id};
	my $archDb = $objHier->getobject($archiveDbId);
	my $archDbh;
	if ($archDb) {
			$archDbh = $self->OpenExternalConnector($archiveDbId);
	}

#	$self->UpdateMyStatus({ rt_status => "archiving" });

	return ($archDbh);
}

sub ArchiveQueue {
	my $self = shift;
	my $qDbh = shift;
	my $archDbh = shift;
	my $limit = shift || 7;

	
=over
	my $dumpfile = File::Spec->catdir($config->{basedir}, "BACKUPS");
	mkdir $dumpfile unless (-d $dumpfile);
	die "cant't create BACUP directory" unless (-d $dumpfile);
	$dumpfile = substr($self->MyContextId(),0,4) . "_" . cafUtils->fatetime("MDHm") . ".dmp.Z"
	$dumpfile = File::Spec->catfile($dumpdir, $dumpfile);
	my $dumpopt = "--attribute-inserts --no-quotes --no-owner --no-reconnect";
	system ("pg_dump $dumpopt --table=$obj --file=$dumpfile");
=cut



	my $tablepref = 'z' . substr($self->MyContextId(),0,4);
	my $datelim = cafUtils->dfatetime("D/M/Y");
	my %datekeys = ( wrunhisto => 'started', wevents => 'eventdate', wwaitevents => 'received', wrunerrors => 'error_date', wvars => undef);
#	foreach my $table (qw(wrunhisto wvars wevents wwaitevents wrunerrors)) {

	my $sysdatefunc = $qDbh->sysdatefunc();
	my $iq = $archDbh->newquery();
	my $uq = $archDbh->newquery();
	my $sq = $qDbh->newquery( { tablename => "$tab" });
	my $cq = $archDbh->newquery();
	my $sqt = $qDbh->newquery({ dbobjtype => "TABLE" });
	foreach $tab (keys %datekeys) {
		my $crit;
		if ($tab ne 'wvars') { $crit = [ [ "($sysdatefunc - $datekeys{$tab})", ">", $limit ] ]; }
		else { $crit = []; }
		$sq->stablerow([ [ "($sysdatefunc - $datekeys{$tab})", ">", $limit ] ]);

		my $ret;
		while ($row = $qDbh->hexecfetchrownop($sq)) {
			$ret = 0;
			my $qfunc;
			if ($tab eq 'wvars' || $tab eq 'wwaitevents') {
				$uq->clear($row);
				$qfunc = "u$tab";
				$uq->$qfunc();
				eval { $ret = $archDbh->executefinish($iq); };
				$ret = 0 if ($@);
			}
			if ($ret <= 0) {
				$iq->clear($row);
				$qfunc = "i$tab";
				$ip->$qfunc();
				eval { $ret = $archDbh->executefinish($iq); }
			}
		}
	}


	$sq = $qDbh->clear();
	my $sqt = $qDbh->newquery({ dbobjtype => "TABLE", tableprefix => "$tablepref%" });
	$sqt->sdbobject();
#	$sqt->query("SELECT tablename as object_name FROM pg_tables WHERE tablename like '$tablepref'");

	my $tablist = $qDbh->execfetchall($sqt);

	$sqt = $archDbh->newquery({ dbobjtype => "TABLE", tableprefix => "$tablepref%" });
	$sqt->sdbobject();
	my $archtablist = $qDbh->execfetchall($sqt);
	my %archtablist = map { $_->[0] => 1 } @$archtablist;

	foreach my $table (@$tablist) {
		$table = $table->[0];
		$table =~ /.*_([io][dr]{0,1}$)/;
		my $tabsuff = $1;
		next unless ($tabsuff);
		@suffixes = ("_i", "_id", "_o", "_od", "_or");
		unless ($archtablist{$table}) { # Create the arched table if not exist
			my $qfunc = "cobject_$suff";
			$cq->clear();
			$cq->$qfunc();
			$archDbh->executefinish($cq);
		}

		if (($tablesuff eq "i") or ($tablesuff eq "o")) { # archive the master tables
			$sq->clear({ tablename => $table });
			$sq->stablerow([ [ "($sysdatefunc - msgdate)", ">", $limit ] ]);
		}
		else { # archive the data/rollback tables 
			$table =~ /(.*).$/;
			my $mastertable = $1;
			
			$sq->clear({ tablename => "$table, $mastertable" });
			my @crit = ( [ "($sysdatefunc - $mastertable.msgdate)", ">", $limit ] );
			push @crit, [ "$table.msgseq = $mastertable.msgseq" ];
			$sq->stablerow(\@crit);
		}
		while ($row = $qDbh->hexefcetchrownop($sq)) {
			$iq->clear($row);
			$archDbh->executefinish($iq);
		}
	}

}

sub CleanQueues {
	my $self = shift;
	my $qDbh = shift;
	my $limit = shift || 7;

	
=over
	my $dumpfile = File::Spec->catdir($config->{basedir}, "BACKUPS");
	mkdir $dumpfile unless (-d $dumpfile);
	die "cant't create BACUP directory" unless (-d $dumpfile);
	$dumpfile = substr($self->MyContextId(),0,4) . "_" . cafUtils->fatetime("MDHm") . ".dmp.Z"
	$dumpfile = File::Spec->catfile($dumpdir, $dumpfile);
	my $dumpopt = "--attribute-inserts --no-quotes --no-owner --no-reconnect";
	system ("pg_dump $dumpopt --table=$obj --file=$dumpfile");
=cut



	my $tablepref = 'z' . substr($self->MyContextId(),0,4);
	my $datelim = cafUtils->dfatetime("D/M/Y");
	my %datekeys = ( wrunhisto => 'started', wevents => 'eventdate', wwaitevents => 'received', wrunerrors => 'error_date');
#	foreach my $table (qw(wrunhisto wvars wevents wwaitevents wrunerrors)) 

	my $dq = $qDbh->newquery();
	my $sysdatefunc = $qDbh->sysdatefunc();
	foreach $tab (keys %datekeys) {
		$dq = $qDbh->clear( { tablename => "$tab" });
		my $crit;
		$crit = [ [ "($sysdatefunc - $datekeys{$tab})", ">", $limit ] ];
		$dq->delfromtable([ [ "($sysdatefunc - $datekeys{$tab})", ">", $limit ] ]);

		my $ret = $qDbh->executefinish($sq);
	}


	my $sqt = $qDbh->newquery({ dbobjtype => "TABLE", tableprefix => "$tablepref%" });
	$sqt->sdbobject();
#	$sqt->query("SELECT tablename as object_name FROM pg_tables WHERE tablename like '$tablepref'");

	my $tablist = $qDbh->execfetchall($sqt);
	my @tablist; # Master table list
	my @dtablist; # Data table list
	foreach my $tab (@$tablist) {
		if ($tab->[0] =~ /.*[io]$/) { push @tablist, $tab->[0]; }
		elsif ($tab->[0] =~ /.*[io][rd]$/) { push @dtablist, $tab->[0]; }
	}

	$dq = $qDbh->newquery();
	foreach my $table (@dtablist, @tablist) {
		$table =~ /.*_([io][dr]{0,1}$)/;
		my $tabsuff = $1;
		next unless ($tabsuff);

		if (($tablesuff eq "i") or ($tablesuff eq "o")) {
			$dq->clear({ tablename => $table });
			$dq->delfromtable([ [ "($sysdatefunc - msgdate)", ">", $limit ] ]);
		}
		else {
			$table =~ /(.*).$/;
			my $mastertable = $1;
			
			$dq->clear({ tablename => "$table, $mastertable" });
			my @crit = ( [ "($sysdatefunc - $mastertable.msgdate)", ">", $limit ] );
			push @crit, [ "$table.msgseq = $mastertable.msgseq" ];
			$dq->delfromtable(\@crit);
		}
		$qDbh->executefinish($dq);
	}

}

sub OptimizeQueue {
	my $self = shift;
	my $qDbh = shift;

	my $query = $qDbh->newquery();
	$query->optimizeall();
	$qDbh->executefinish($query);
}

sub ArchiveCafeterra {
	my $self = shift;

	my ($disconnect, $qDbh, $archDbh);
	eval {
		$disconnect = 0;
		$qDbh = $self->QueueDbhAutocommit();
		if (! $qDbh) { $self->QueueConnect(); $disconnect = 1; }
		$qDbh = $self->QueueDbhAutocommit();
	};
	if ($@) { $self->RegisterError($@); return undef; }
	

	eval {
		$archDbh = $self->InitArchiver();
	};
	if ($@) { $self->RegisterError($@); $self->QueueDisconnect() if ($disconnect); return undef; }

	eval {
		$self->ArchiveQueue($qDbh, $archDbh);

		$self->CleanQueues($qDbh);
		$self->OptimizeQueue($qDbh);
	};
	if ($@) { $self->RegisterError($@); $self->QueueDisconnect() if ($disconnect); return undef; }

	$self->QueueDisconnect() if ($disconnect);;

	return 1;
}

1;

