#!/usr/local/bin/perl
# qryPg.pm 01/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

use 5.005;
use strict;

use connectors::refQry;

package qryPg;

@qryPg::ISA = ('refQry');

sub snow {
	my $p = shift; # self

	$p->{_attr}{mylabel} = "snextseq";
	$p->{_attr}{columns} = [ "thedatetime" ];
	$p->{_attr}{bindvars} = [ $p->{format} ];
	$p->{_attr}{query} = "select to_char (now(), ?) as thedatetime"; 
}

sub snextseq {
	my $p = shift; # self
 
	$p->{_attr}{mylabel} = "snextseq";
	$p->{_attr}{columns} = [ $p->{seqname} . "_seq" ];
	$p->{_attr}{query} = "select nextval('" . $p->{seqname} . "_seq') as " . $p->{seqname} . "_seq";
}

1;
