#!/usr/local/bin/perl
#
# cafXML 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;

package cafdXML;
 
#@ISA = (cafDBI);
use strict;
use connectors::cafQry;


=cut
	_tempdir => Flowdir/temp
	_mailqueue => FLOWDIR/_mailq
	_smtpqueue => FLOWDIR/_smtpq
	_imapqueue => FLOWDIR/_imapq/folder
	_ftpqueue  => FLOWDIR/_ftpq
=cut

sub NewConnection {
	my $class = shift;
	my $db = shift;

	$class = ref($class) || $class;

	my $proto = "cafp" . $db->{connector}{protocolid};

	eval { require $proto };

        eval "require connectors::$proto";
        my $e = $@;
        if ($@) { cafDbg->pushstackdump(1); }
 
        die "$e" if ($e);
 
        @cafdXML::ISA = ($proto);

	my $self = $class->NewProtocol($db);

	
	my %xml_attrs = (
		record_tag       => $db->{_ATTRS}{RECORD_TAG},
		rootname         => $db->{_ATTRS}{ROOTNAME},
	);
	foreach my $a (keys %xml_attrs) {
		if (($xml_attrs{$a} !~ /^\\$/) and defined($xml_attrs{$a})) { eval "\$xml_attrs{$a} = \"$xml_attrs{$a}\""; }
	}
	$self->{_XML_ATTRS} = \%xml_attrs;
	$self->{dbh}       = DBI->connect("dbi:AnyData(RaiseError=>1):");
	$! = "";
	$self;
}

sub xmlattrib {
	my $self = shift;
	my $attrib = shift;

	if (@_) { $self->{_XML_ATTRS}{$attrib} = shift; }
	$self->{_XML_ATTRS}{$attrib};
}
		
sub xmlinfo {
	my $self = shift;
	my $infolabel = shift;

	if (@_) { $self->{_XMLINFO}{$infolabel} = shift; }
	$self->{_XMLINFO}{$infolabel};
}

sub clearxmlinfo {
	my $self = shift;

	$self->{_XMLINFO} = undef;
	delete $self->{_XMLINFO};
}

sub preprepare {
	my $self = shift;
	my $q = shift;

	my ($cmd, $mode, $ad_mode);
	my $qText = $q->query();
	if ($qText =~ /\s*select/i) { $cmd = "select"; $mode = "r" }
	elsif ($qText =~ /\s*insert/i) { $cmd = "insert"; $mode = "w" }
	elsif ($qText =~ /\s*update/i) { $cmd = "update"; $mode = "w" }
	elsif ($qText =~ /\s*delete/i) { $cmd = "delete"; $mode = "w" }
	else { die "Unsuported sql command"; }

	$q->_attribute("command", $cmd);
	my $container = $self->{db}{container};


	my @col_map;
	my %map_col;
	my $colpos = 0;
	my %col_pos;
	foreach my $col (@{$container->{_FIELDS}}) {
		push @col_map, { $col->{externalname} => $col->{name} };
		my @split = split("/", $col->{externalname});
		shift @split unless($split[0]);
		$self->xmlattrib("rootname", $split[0]) unless ($self->xmlattrib("rootname"));
		my $realname = $split[$#split];
		$realname =~ s/^[*]//;
		$map_col{$col->{name}} = [ $col->{externalname}, \@split, $realname ];
		$col_pos{$col->{externalname}} = $colpos;
		$colpos++;
	}

	my @acol_names = map { $_->{name} }  @{$container->{_FIELDS}};
	my $scol_names = join(',', @acol_names);

	my $name = $container->{name};
	my $externalname = $container->{externalname};

	$self->xmlinfo("_NAME", $name);
	$self->xmlinfo("_MODE", $mode);
	$self->xmlinfo("_CMD", $cmd);
	$self->xmlinfo("_EXTERNALNAME", $externalname);
	$self->xmlinfo("_SCOLNAMES", $scol_names);
	$self->xmlinfo("_ACOLNAMES", \@acol_names);
	$self->xmlinfo("_COLMAP", \@col_map);
	$self->xmlinfo("_MAPCOL", \%map_col);
	$self->xmlinfo("_COLPOS", \%col_pos);
	$self->xmlinfo("_RECORD_TAG", $container->{_ATTRS}{RECORD_TAG});
}

sub prepare {
	my $self = shift;
	my $q = shift;

#	return $self->SUPER::prepare($q) if ($self->{_NAME});

	unless ($self->xmlinfo("_NAME")) {

		$self->preprepare($q);
		my ($cmd, $mode) = ($self->xmlinfo("_CMD"),$self->xmlinfo("_MODE"));
		my $dbh = $self->{dbh};

		if ($cmd eq "select") {
			my $tempfile = $self->getfile({ fname => $self->xmlinfo("_EXTERNALNAME"), mode => "r" });
			$self->xmlinfo("_TEMPFILE", $tempfile);
			$self->xmlinfo("_DATA", $self->readdata());
		}
		else {
			$self->xmlinfo("_DATA", [[]]);
		}
		$dbh->func($self->xmlinfo("_NAME"), 'ARRAY', $self->xmlinfo("_DATA"), {col_names => $self->xmlinfo("_SCOLNAMES")}, 'ad_catalog'); 
	}
	return $self->SUPER::prepare($q);
}

sub read_eltdata {
	my $self = shift;
	my ($c, $k, $data, $eltdata) = @_;

	$eltdata =~ s/^\s*$//g;
	if ($eltdata and (my $colpos = $data->{colpos}{$c})) {
		$data->{currrow}{row}[$colpos] = $eltdata;
		$data->{currrow}{nfield} += 1;
	}
}

sub read_tags {
	my $self = shift;
	my $tree = shift;
	my $data = shift;
	my $chemin = "";

	for (my $i = 1; $tree->[$i];) {
	        my $el= $tree->[$i];
	        $self->read_tags2($el, "$chemin/$tree->[0]", $data, $tree->[0]) if (ref($el));
	        $i += 2;
	}

	if ($data->{currrow}{nfield}) { push @{$data->{data}}, $data->{currrow}{row}; }

}

sub read_tags2 {
	my $self = shift;
	my $tree = shift;
	my $chemin = shift;
	my $data = shift;
	my $lasttag = shift;

	if ($lasttag eq $self->xmlinfo("_RECORD_TAG")) {
		if ($data->{currrow}{nfield}) { push @{$data->{data}}, $data->{currrow}{row}; }
		$data->{currrow} = { visited => {}, row => [], nfield => 0 };
	}

	my $attr = $tree->[0];
	foreach my $el  (keys %{$attr}) {
	        $self->read_eltdata("$chemin", "\*$el", $data, $attr->{$el} );
	}

	for (my $i = 1; defined($tree->[$i]);) {
		my $el = $tree->[$i];
	        if ($el and ref($tree->[$i + 1])) {
	                if ($el and ref($tree->[$i + 1])) { $self->read_tags2($tree->[$i + 1], "$chemin/$el", $data, $el); }
	        }
		else { $self->read_eltdata("$chemin", $el, $data, $tree->[$i + 1]); }
	        $i+=2;
	}
}

sub readdata {
	my $self = shift;

	my $rows =  [$self->xmlinfo("_ACOLNAMES")];
	my $data = {
		data => $rows,
		colpos => $self->xmlinfo("_COLPOS"),
		currrow => { visited => {}, row => [], nfield => 0 }
	};

	require XML::Parser;

	my $xml = XML::Parser->new(Style=>'Tree', ErrorContext => 5);
 
	my $tree = $xml->parsefile($self->xmlinfo("_TEMPFILE"));

	$self->read_tags($tree, $data);
	use Data::Dumper;
	return $rows;
}

sub xmlarraytohash {
	my $self = shift;
	my $ahash = [];

	my $lines = $self->xmlinfo("_DATA");
	my $colnames = $self->xmlinfo("_ACOLNAMES");
	my $mapcol = $self->xmlinfo("_MAPCOL");

	foreach my $line (@$lines) {
		my %hash = ();
		for (my $ifld = 0; $ifld <$#$line; $ifld++) {
			my $elt = \%hash;
			my $parentkey;
			my $parent = undef;

			my $fldname = $colnames->[$ifld];
			my $realname = $mapcol->{$fldname}[2];
			my $path = $mapcol->{$fldname}[1];

			for (my $i = 1; $i < $#$path; $i++) {
				my $key = $path->[$i];
				if (ref($elt) eq "ARRAY") { $elt = {} };
				$elt->{$key} = undef unless($elt->{$key});
				if ($parentkey) { $parent->{$parentkey} = $elt; }
				$parentkey = $key;
				$parent = $elt;
				$elt = $elt->{$key}
			}
			
			if (ref($elt) eq "ARRAY") { $elt = {} };
			$elt->{$realname} = [] unless ($elt->{$realname});
			push @{$elt->{$realname}}, $line->[$ifld];
			$parent->{$parentkey} = $elt;
		}
		push @{$ahash}, \%hash;
	}
	$ahash
}

sub setexternalname {
        my $self = shift;
        my $filename = shift;
        $self->xmlinfo("_EXTERNALNAME", $filename);
}

sub getexternalname {
        my $self = shift;
        my $filename = shift;
        $self->xmlinfo("_EXTERNALNAME");
}


sub finalcommit {
	my $self = shift;

	return 1 unless $self->xmlinfo("_NAME");
	if ($self->xmlinfo("_CMD") ne "select") {
		require XML::Simple;

		#print "final Commit ", $self->xmlinfo("_EXTERNALNAME"), "\n";
		my $xs = XML::Simple->new(keyattr => [], noattr => 0, rootname => $self->xmlattrib("rootname"));

		#use Data::Dumper;
		#print Dumper $self->xmlinfo("_DATA");
		my $str = $xs->XMLout($self->xmlarraytohash());
		my $rootname = $self->xmlattrib("rootname");
		#$str =~ s/<$rootname>\s*<anon>/<$rootname>/;
		#$str =~ s/[ \t]*<\/anon>\s*<\/$rootname>/<\/$rootname>/;
		$str =~ s/\s*<[\/]*anon><\/$rootname>/<\/$rootname>/;

		my $tempfile = $self->getfile({ fname => $self->xmlinfo("_EXTERNALNAME"), mode => "w" });
		my $tempioh = IO::File->new($tempfile, "w");

		my $strioh = IO::Scalar->new(\$str);
		binmode $tempioh;
#		binmode $strioh;
		$tempioh->autoflush(1);
 
		my $nreads;
		my $nwrite = 0;
		my $in;
		while ($nreads = $strioh->read($in, 1024)) { $nwrite = $tempioh->write($in, $nreads); }
		$tempioh->close();
		$strioh->close();
#		system("cat $tempfile");
		$self->protocommit($tempfile, $self->xmlinfo("_EXTERNALNAME"));
	}
	$self->clearxmlinfo();
}

sub finalrollback {
	my $self = shift;

	return 1 unless $self->xmlinfo("_NAME");
	if ($self->xmlinfo("_CMD") eq "select") {
		my $tempfile = $self->xmlinfo("_TEMPFILE");
		$self->protorollbaclk($tempfile);
	}
	$self->clearxmlinfo();
}

sub desc_addkel {
	my ($c, $k, $elements, $kel, $ksort) = @_;
	return if ($elements->{"$c/$k"});
	my $oldk = $k;
	if ($kel->{$k}) { my $i = $kel->{$k}; $kel->{$k} = $i+1; $k="$k$i"; }
	else {$kel->{$k} = 1;}
	push @{$ksort}, "$c/$oldk";
	$elements->{"$c/$oldk"} = $k;
}

sub desc_gettags {
	my $a = shift;
	my $elements = shift;
	my $kel = shift;
	my $ksort = shift;
	my $chemin = "";

	$elements->{ "$chemin/$a->[0]" } = $a->[0];
	$kel->{ $a->[0] } = 1;
	for (my $i = 1; $a->[$i];) {
	        my $el= $a->[$i];
	        desc_gettags2($el, "$chemin/$a->[0]", $elements, $kel, $ksort) if (ref($el));
	        $i += 2;
	}
}

#my $tab = 0;
sub desc_gettags2 {
	my $a = shift;
	my $chemin = shift;
	my $elements = shift;
	my $kel = shift;
	my $ksort = shift;

	#$tab++;
	my $attr = $a->[0];
	foreach my $el  (keys %{$attr}) {
	        desc_addkel("$chemin", "\*$el", $elements, $kel, $ksort);
	}
	for (my $i = 1; defined($a->[$i]);) {
	        if (my $el = $a->[$i]) {
	                desc_addkel("$chemin", $el, $elements, $kel, $ksort);
	                if (ref($a->[$i + 1])) { desc_gettags2($a->[$i + 1], "$chemin/$el", $elements, $kel, $ksort); }
	        }
	        $i+=2;
	}
	#$tab--;
}

sub describe {
	my $self = shift;
	my $table_name = shift;

	return undef unless $self->connected();
	my $tempfile;
	return undef unless ($tempfile = $self->getfile({ fname => $table_name, mode => "r" }));

	my $dbh = $self->{dbh};
	my $record_tag = $self->{_XML_ATTRS}{record_tag};

#	$record_tag = "head";
	require XML::Parser;

	my $xml = XML::Parser->new(Style=>'Tree');
	
	my (%elements, %kel, @ksort) = ((), (), ());
	my $tree = $xml->parsefile($tempfile);
	
	desc_gettags($tree, \%elements, \%kel, \@ksort);

	my @ret;
	my $i = 0;
	#foreach my $e (keys %elements) {
	foreach my $e (@ksort) {
		if ($record_tag) { next unless ($e =~ /$record_tag/); }
		$i++;
		$elements{$e} =~ s/^\*//;
		my $chemin = $e;
		#if ($record_tag) { $chemin =~ s/.*$record_tag/$record_tag/; }
		push @ret, {
				name => $elements{$e},
				externalname => $chemin,
				datatypeid => 'VARCHAR',
				datalength => 100,
				fieldorder => $i*10,
				keyposition  => ($i > 3) ? undef : $i,
		};
	}
	unlink $tempfile;

	\@ret;
}

=over
sub generateselect {
	my $self = shift;

	@cafdXML::ISA = ('refDBI') unless ($self->isa('refDBI');
	return $self->SUPER::generateselect(@_);

	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $class = ref($self) || $self;

	my $query = "#select statement generated by $class\n\nSELECT ";
	my $sep = "";
	my $where = "WHERE ";
	my $chunk;
	my $wsep = "";
	my $qlen = 0;
	my $wlen = 0;

	foreach my $col (@$fields) {
		next if ($col->{localfield} eq "yes");
		$chunk = "$sep" . $self->generatedatetochar($col) . " " . $self->gencolalias("\@c_$col->{name}");

		$qlen += length($chunk);
		if ($qlen > 50) { $query .= "\n\t\t"; $qlen = 10; }

		$query .= $chunk;
		$sep = ", ";

		if ($col->{keyposition}) {
			$chunk = "$wsep$col->{externalname} = " . $self->generatechartodate($col);
			$where .= $chunk;
			$wlen += length($chunk);
			if ($wlen > 50) { $where .= "\n\t\t"; $wlen = 10; }
			$wsep = " and ";
		}
	}

	return "$query\n\tFROM $container->{externalname}\n\t$where";
}

sub generateupdate {
	my $self = shift;

	@cafdXML::ISA = ('refDBI') unless ($self->isa('refDBI');
	return $self->SUPER::generateupdate(@_);

	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $class = ref($self) || $self;

	my $query = "#update statement generated by $class\n\nUPDATE $container->{externalname} SET ";
	my $sep = "";
	my $where = "";
	my $chunk;
	my $wsep = " WHERE ";
	my $qlen = 0;
	my $wlen = 0;

	foreach my $col (@$fields) {
		next if ($col->{localfield} eq "yes");
		$chunk = "$sep$col->{externalname} = " . $self->generatechartodate($col);

		$qlen += length($chunk);
		if ($qlen > 50) { $query .= "\n\t\t"; $qlen = 10; }

		$query .= $chunk;
		$sep = ", ";

		if ($col->{keyposition}) {
			$chunk = "$wsep$col->{externalname} = " . $self->generatechartodate($col);
			$wlen += length($chunk);
			if ($wlen > 50) { $where .= "\n\t\t"; $wlen = 10; }
			$where .= $chunk;
			$wsep = " and ";
		}
	}

	return "$query\n\t$where";
}

sub generatedelete {
	my $self = shift;

	@cafdXML::ISA = ('refDBI') unless ($self->isa('refDBI');
	return $self->SUPER::generatedelete(@_);

	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $class = ref($self) || $self;

	my $query = "#delete statement generated by $class\n\nDELETE from $container->{externalname}";
	my $sep = "";
	my $where = "";
	my $chunk;
	my $wsep = "WHERE ";
	my $qlen = 0;
	my $wlen = 0;

	foreach my $col (@$fields) {
		next if ($col->{localfield} eq "yes");

		if ($col->{keyposition}) {
			$chunk = "$wsep$col->{externalname} = " . $self->generatechartodate($col);
			$wlen += length($chunk);
			if ($wlen > 50) { $where .= "\n\t\t"; $wlen = 10; }
			$where .= $chunk;
			$wsep = " and ";
		}
	}

	return "$query\n\t$where";
}

sub generateinsert {
	my $self = shift;

	@cafdXML::ISA = ('refDBI') unless ($self->isa('refDBI');
	return $self->SUPER::generateinsert(@_);

	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $class = ref($self) || $self;

	my $query = "#insert statement generated by $class\n\nINSERT INTO $container->{externalname} (";
	my $sep = "";
	my $values = " VALUES (";
	my $chunk;
	my $vsep = "";
	my $qlen = 0;
	my $vlen = 0;

	foreach my $col (@$fields) {
		next if ($col->{localfield} eq "yes");
		$chunk = "$sep$col->{externalname}";

		$qlen += length($chunk);
		if ($qlen > 50) { $query .= "\n\t\t"; $qlen = 10; }

		$query .= $chunk;
		$sep = ", ";

		$chunk = "$vsep" . $self->generatechartodate($col);
		$vlen += length($chunk);
		if ($vlen > 50) { $values .= "\n\t\t"; $vlen = 10; }
		$values .= $chunk;
		$vsep = ", ";
	}

	return "$query)\n\t$values)";
}


sub generatecreate {
	my $self = shift;

	@cafdXML::ISA = ('refDBI') unless ($self->isa('refDBI');
	return $self->SUPER::generatecreate(@_);

	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $datatypes = shift;
	my $class = ref($self) || $self;

	my %datatypeconv = map { $_->{stdname} => $_->{datatypeid} } @$datatypes;

	my $query = "#WARNING THIS IS A DDL STATEMENT - SEE WITH YOUR DBA BEFORE USING SUCH COMMAND
#CREATE TABLE statement generated by $class\n\nCREATE TABLE $container->{externalname} (";


	my $sep = "";
	my $keys = "";
	my $ksep = "";
	my $chunk = "";

	foreach my $col (@$fields) {
		my $datatype = $datatypeconv{$col->{datatypeid}};
		$query .= "\n\t$col->{externalname} $datatype";
		if (($datatype =~ /VARCHAR|CHAR/i) and ($col->{datalength})) { $query .= "($col->{datalength})"; }
		elsif (($datatype =~ /NUMBER/i) and ($col->{datalength})) {
			$query .= "($col->{datalength}";
			$query .=  ", $col->{datascale}" if ($col->{datascale});
			$query .= ")";
		}
		$sep = ", ";

		if ($col->{allownull} eq 'no') { $query .= " NOT NULL"; }

		if ($col->{keyposition}) {
			$keys .= "$ksep$col->{externalname}";
			$ksep = ", ";
		}

	}
	$keys = "$keys\n\tCONSTRAINT $container->{externalname}_pkey PRIMARY KEY ($keys)" if ($ksep);
	return "$query) $keys";
}

sub generatedrop {
	my $self = shift;

	@cafdXML::ISA = ('refDBI') unless ($self->isa('refDBI');
	return $self->SUPER::generatedrop(@_);

	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $datatypes = shift;
	my $class = ref($self) || $self;

	my $query = "#WARNING THIS IS A DDL STATEMENT - SEE WITH YOUR DBA BEFORE USING SUCH COMMAND
#DROP TABLE statement generated by $class

DROP TABLE $container->{externalname}";
	return $query;
}

sub generatetruncate {
	my $self = shift;

	@cafdXML::ISA = ('refDBI') unless ($self->isa('refDBI');
	return $self->SUPER::generatetruncate(@_);

	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $datatypes = shift;
	my $class = ref($self) || $self;

	my $query = "#WARNING THIS IS A DDL STATEMENT - SEE WITH YOUR DBA BEFORE USING SUCH COMMAND
#TRUNCATE TABLE statement generated by $class

TRUNCATE TABLE $container->{externalname}";
	return $query;
}
=cut

sub generatequery {
	my $self = shift;

	@cafdXML::ISA = ('refDBI') unless ($self->isa('refDBI'));
	return $self->SUPER::generatequery(@_);

	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $datatypes = shift;

	my $sub = "generate$command";
	return $self->$sub($command, $connector, $container, $fields, $datatypes);
}


sub columnnameformat {
	my $self = shift;
	my $col = shift;
	return $col->{name};
}

sub tablenameformat {
	my $self = shift;
	my $container = shift;
return $container->{name};
}


sub generatechartodate {
	my $self = shift;
	my $col = shift;

	return ":c_$col->{name}";
}
		
sub generatedatetochar {
	my $self = shift;
	my $col = shift;

	return $col->{name};
}

1;
