.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER AGGREGATE" "" "2006-10-07" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER AGGREGATE \- change the definition of an aggregate function

.SH SYNOPSIS
.sp
.nf
ALTER AGGREGATE \fIname\fR ( \fItype\fR [ , ... ] ) RENAME TO \fInew_name\fR
ALTER AGGREGATE \fIname\fR ( \fItype\fR [ , ... ] ) OWNER TO \fInew_owner\fR
ALTER AGGREGATE \fIname\fR ( \fItype\fR [ , ... ] ) SET SCHEMA \fInew_schema\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER AGGREGATE\fR changes the definition of an
aggregate function.
.PP
You must own the aggregate function to use \fBALTER AGGREGATE\fR.
To change the schema of an aggregate function, you must also have
CREATE privilege on the new schema.
To alter the owner, you must also be a direct or indirect member of the new
owning role, and that role must have CREATE privilege on
the aggregate function's schema. (These restrictions enforce that altering
the owner doesn't do anything you couldn't do by dropping and recreating
the aggregate function. However, a superuser can alter ownership of any
aggregate function anyway.)
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing aggregate function.
.TP
\fB\fItype\fB\fR
An input data type on which the aggregate function operates.
To reference a zero-argument aggregate function, write *
in place of the list of input data types.
.TP
\fB\fInew_name\fB\fR
The new name of the aggregate function.
.TP
\fB\fInew_owner\fB\fR
The new owner of the aggregate function.
.TP
\fB\fInew_schema\fB\fR
The new schema for the aggregate function.
.SH "EXAMPLES"
.PP
To rename the aggregate function myavg for type
\fBinteger\fR to my_average:
.sp
.nf
ALTER AGGREGATE myavg(integer) RENAME TO my_average;
.sp
.fi
.PP
To change the owner of the aggregate function myavg for type
\fBinteger\fR to joe:
.sp
.nf
ALTER AGGREGATE myavg(integer) OWNER TO joe;
.sp
.fi
.PP
To move the aggregate function myavg for type
\fBinteger\fR into schema myschema:
.sp
.nf
ALTER AGGREGATE myavg(integer) SET SCHEMA myschema;
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBALTER AGGREGATE\fR statement in the SQL
standard.
.SH "SEE ALSO"
CREATE AGGREGATE [\fBcreate_aggregate\fR(l)], DROP AGGREGATE [\fBdrop_aggregate\fR(l)]
