/*
 * $Header: /home/t-ishii/repository/strtohex/strtohex.c,v 1.1.1.1 2004/01/07 09:14:57 t-ishii Exp $
 *
 * Copyright (c) 2004	Tatsuo Ishii
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose, without fee, and without a
 * written agreement is hereby granted, provided that the above
 * copyright notice and this paragraph and the following two
 * paragraphs appear in all copies.
 *
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING
 * LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS
 * DOCUMENTATION, EVEN IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS
 * IS" BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#include "postgres.h"

#include "fmgr.h"
#include "funcapi.h"
#include "utils/builtins.h"

PG_FUNCTION_INFO_V1(strtohex);

extern Datum strtohex(PG_FUNCTION_ARGS);

/* ----------
 * strtohex:
 * convert a string to hex representation
 *
 * C FUNCTION definition
 * strtohex(text) returns text
 * ----------
 */

Datum
strtohex(PG_FUNCTION_ARGS)
{
	char *src;
	unsigned char c;
	int	len;
	text *result;
	char buf[3];
	char *p;

	src = DatumGetCString(DirectFunctionCall1(textout, (Datum)PG_GETARG_TEXT_P(0)));
	len = strlen(src)*2;
	result = (text *) palloc(len + VARHDRSZ);
	VARATT_SIZEP(result) = len + VARHDRSZ;

	p = VARDATA(result);

	while ((c = *src++))
	{
		snprintf(buf, sizeof(buf), "%02x", c);
		*p++ = buf[0];
		*p++ = buf[1];
	}

	PG_RETURN_TEXT_P(result);
}
