/*
 * $Header: /home/t-ishii/repository/pgnmzsrch/pgnmzsrch.c,v 1.1.1.1 2001/05/06 11:52:26 t-ishii Exp $
 *
 * pgnmzsrch: namazuθ̤set of tuple֤PostgreSQL Cؿ
 *
 * Copyright (c) 2001  Tatsuo Ishii
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose, without fee, and without a
 * written agreement is hereby granted, provided that the above
 * copyright notice and this paragraph and the following two
 * paragraphs appear in all copies.
 */

#include "postgres.h"
#include "fmgr.h"
#include "nodes/execnodes.h"

#include <namazu/libnamazu.h>
#include <namazu/search.h>
#include <namazu/hlist.h>
#include <namazu/idxname.h>

PG_FUNCTION_INFO_V1(pgnmzsrch);

extern Datum pgnmzsrch(PG_FUNCTION_ARGS);

#define MAXKEY 1024	/* κĹ */
#ifndef MAXPATHLEN
#define MAXPATHLEN	1024	/* ե̾Ĺ */
#endif

#define MALLOC(size)	MemoryContextAlloc(fcinfo->flinfo->fn_mcxt, (size))

/* namazu */
typedef struct {
    int num;	/* ̷ */
    int cnt;	/* ץ(set֤Ȥ˻) */
    char **path;	/* ե̾ */
} pg_namazu_result;

/* ----------
 * pgnmzsrcht: 
 * C FUNCTION
 * pgnmzsrch(TEXT, TEXT) returns TEXT
 * ----------
 */
Datum
pgnmzsrch(PG_FUNCTION_ARGS)
{

    text *key;		/* :  */
    text *index;	/* : namazuǥå */
    char keybuf[MAXKEY+1];	/* (NULLߥ͡Ȥ) */
    char indexbuf[MAXPATHLEN+1];	/* mamazuǥå(NULLߥ͡Ȥ) */
    char uri[MAXPATHLEN+1];	/* mamazu URIեѥ̾ */
    NmzResult rlist;		/* namazu */
    FILE	*fd;		/* namazuѥ̾ե */
    char buf[MAXPATHLEN+1];	/* namazuѥ̾եɤ߹ߥХåե */

    text	*data;	/* ؿ TEXT  */

    unsigned int size;		/* ꥢ󥵥 */
    pg_namazu_result *result;	/* ̳Ǽꥢ */
    int i,j;

    /* ƤӽФ? */
    if (fcinfo->flinfo->fn_extra == NULL)
    {
        /* ϸɡμ¤NULLߥ͡Ȥ */
	key = PG_GETARG_TEXT_P(0);
	memset(keybuf,0,sizeof(keybuf));
        memcpy(keybuf,VARDATA(key),Min(VARSIZE(key)-VARHDRSZ,MAXKEY));

        /* namazuǥåѥ̾ */
        index = PG_GETARG_TEXT_P(1);
        memset(indexbuf,0,sizeof(indexbuf));
        memcpy(indexbuf,VARDATA(index),Min(VARSIZE(index)-VARHDRSZ,MAXPATHLEN));

	/* namazuǥåɲ */
	if (*indexbuf != '\0')
	    nmz_add_index(indexbuf);

	rlist = nmz_search(keybuf);	/* namazuǸ */

	if (rlist.stat == SUCCESS)	/* ? */
	{
	    /* ̤򥳥ԡ */
	    size = sizeof(pg_namazu_result);
	    result = fcinfo->flinfo->fn_extra = MALLOC(size);
	    result->num = rlist.num;
	    result->cnt = 0;
	    size = sizeof(char *)*rlist.num;
	    if (size > 0)
		result->path = MALLOC(size);

	    /* ɥIDѥ̾Ѵ */
	    snprintf(uri, sizeof(uri), "%s/NMZ.field.uri", indexbuf);
	    fd = fopen(uri, "r");
	    if (fd == NULL)
	    {
		elog(ERROR,"cannot open namazu index file: %s", uri);
	    }
	    for (i = 0; fgets(buf, BUFSIZE, fd); i++)
	    {
		for (j=0;j<rlist.num;j++)
		{
		    if (rlist.data[j].docid == i)
		    {
			result->path[j] = MALLOC(strlen(buf)+1);
			StrNCpy(result->path[j],buf,strlen(buf));
			break;
		    }
		}
	    }
	    fclose(fd);
	}
	else
	{
	    result = NULL;
	}
	nmz_free_hlist(rlist);
	nmz_free_internal();
    }

    /* 2ܰʹߤθƤӽФǤ fcinfo->flinfo->fn_extra åȺ */
    else
    {
	result = fcinfo->flinfo->fn_extra;
    }

    /* ֵ̤Ѥη̤? */
    if (result != NULL && result->num > result->cnt)
    {
	/* ֵΥơ򥻥å */
	((ReturnSetInfo*)fcinfo->resultinfo)->isDone = ExprMultipleResult;

	/* ѥ̾TEXTѴ */
	data = MALLOC(strlen(result->path[result->cnt]) + VARHDRSZ);
	VARATT_SIZEP(data) = strlen(result->path[result->cnt]) + VARHDRSZ;
	memcpy(VARDATA(data),result->path[result->cnt],
	       VARSIZE(data) - VARHDRSZ);
	result->cnt++;
	PG_RETURN_TEXT_P(data);
    }
    else
    {
	/* λ*/
	((ReturnSetInfo*)fcinfo->resultinfo)->isDone = ExprEndResult;
	PG_RETURN_NULL();
    }
}
