<?php
/*
 * Session Management for PHP3
 *
 * Copyright (c) 1998,1999 SH Online Dienst GmbH
 *                    Boris Erdmann, Kristian Koehntopp
 *
 * $Id: pgimage_local.inc,v 1.1.1.1 2003/01/23 08:03:46 t-ishii Exp $
 *
 */ 

class DB_Pgimage extends DB_Sql {
  var $Host = DBHOST;
  var $Database = DBNAME;	
  var $User     = DBUSER;
  var $Password = DBPASSWD;
  var $Port = DBPORT;

  // persistent connectionѤʤ褦˥С饤
  // ޤpg_connect()Υ顼Ϥʤ
  function connect() {
	  if ( 0 == $this->Link_ID ) {
		  $cstr = "dbname=".$this->Database.
		  $this->ifadd($this->Host, "host=").
		  $this->ifadd($this->Port, "port=").
		  $this->ifadd($this->User, "user=").
		  $this->ifadd($this->Password, "password=");
		  $this->Link_ID=pg_connect($cstr); // persistent connectionѤʤ
	  
		  if (!$this->Link_ID) {
			  $this->halt("Link-ID == false, pconnect failed");
		  }
	  }
  }

  // SQL顼haltʤ
  function no_error_query($Query_String) {
    /* No empty queries, please, since PHP4 chokes on them. */
    if ($Query_String == "")
      /* The empty query string is passed on from the constructor,
       * when calling the class without a query, e.g. in situations
       * like these: '$db = new DB_Sql_Subclass;'
       */
      return 0;

    $this->connect();
    
    if ($this->Debug) 
      printf("<br>Debug: query = %s<br>\n", $Query_String);

    @$this->Query_ID = pg_Exec($this->Link_ID, $Query_String);
    $this->Row   = 0;

    $this->Error = pg_ErrorMessage($this->Link_ID);
    $this->Errno = ($this->Error == "")?0:1;
    return $this->Query_ID;
  }

  // DB顼
  function halt($msg) {
    print <<<EOF
ǡ١顼ȯޤ
³Ǥޤ
EOF;
    exit();
  }

}

class Pgimage_CT_Sql extends CT_Sql {
  var $database_class = "DB_Pgimage";          ## Which database to connect...
  var $database_table = "active_sessions"; ## and find our session data in this table.
}

class Pgimage_Session extends Session {
  var $classname = "Pgimage_Session";

  var $cookiename     = "";                ## defaults to classname
  var $magic          = "Hocuspocus";      ## ID seed
  var $mode           = "cookie";          ## We propagate session IDs with cookies
  var $fallback_mode  = "get";
  var $lifetime       = 0;                 ## 0 = do session cookies, else minutes
  var $that_class     = "Pgimage_CT_Sql"; ## name of data storage container
  var $gc_probability = 5;  
  var $allowcache = "no";        ## "passive", "no", "private", "public"

  // ʬȤURL(query stringʤ)+åID
  function myurl() {
    global $HTTP_SERVER_VARS;
    return $this->url($HTTP_SERVER_VARS["PHP_SELF"]);
  }
}

##
## Example_Challenge_Crypt_Auth: Keep passwords in md5 hashes rather 
##                           than cleartext in database
## Author: Jim Zajkowski <jim@jimz.com>

class Pgimage_Auth extends Auth {
  var $classname      = "Pgimage_Auth";

  var $lifetime       =  0;	// ǧڤͭ(ʬ)

  var $magic          = "Frobozzica";  ## Challenge seed
  var $database_class = "DB_Pgimage";
  var $database_table = "auth_user_md5";

  function auth_loginform() {
    global $sess;
    global $challenge;
    
    $challenge = md5(uniqid($this->magic));
    $sess->register("challenge");
    
    include("pgimage_login.ihtml");
  }
  
  function auth_validatelogin() {
    $username = isset($_REQUEST["username"])?$_REQUEST["username"]:"";
    $password = isset($_REQUEST["password"])?$_REQUEST["password"]:"";
    $challenge = isset($_REQUEST["challenge"])?$_REQUEST["challenge"]:"";
    $response = isset($_REQUEST["response"])?$_REQUEST["response"]:"";
    $pass = isset($_REQUEST["pass"])?$_REQUEST["pass"]:"";

    $this->auth["uname"]=$username;        ## This provides access for "loginform.ihtml"
    
    $this->db->query(sprintf("select user_id,perms,password ".
                "from %s where username = '%s'",
                          $this->database_table,
                          addslashes($username)));

    while($this->db->next_record()) {
      $uid   = $this->db->f("user_id");
      $perm  = $this->db->f("perms");
      $pass  = $this->db->f("password");   ## Password is stored as a md5 hash
    }
    //print("== $username == $password == $pass == $challenge");
    $expected_response = md5("$username:$pass:$challenge");

    ## True when JS is disabled
    if ($response == "") {
      if (md5($password) != $pass) {       ## md5 hash for non-JavaScript browsers
        return false;
      } else {
        $this->auth["perm"] = $perm;
        return $uid;
      }
    }
    
    ## Response is set, JS is enabled
    if ($expected_response != $response) {
	  //print ("=== $expected_response === === $response ===");
      return false;
    } else {
      $this->auth["perm"] = $perm;
      return $uid;
    }
  }
}

// ʤǧڤ륲ȥ桼Τǧڥ饹
class Pgimage_Default_Auth extends Pgimage_Auth {
  var $classname = "Pgimage_Default_Auth";
  
  var $nobody    = true;
}

class Pgimage_Perm extends Perm {
  var $classname = "Pgimage_Perm";
  
  // ޥ:桼ʬuseradminΤ
  var $permissions = array(
                            "user"       => 1,
                            "admin"      => 3
                          );

  function perm_invalid($does_have, $must_have) {
    global $perm, $auth, $sess;
    global $_PHPLIB;
    
    include($_PHPLIB["libdir"] . "perminvalid.ihtml");
  }
}
?>
