/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 1

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse base_yyparse
#define yylex   base_yylex
#define yyerror base_yyerror
#define yylval  base_yylval
#define yychar  base_yychar
#define yydebug base_yydebug
#define yynerrs base_yynerrs
#define yylloc base_yylloc

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_COUNT = 265,
     SQL_DATETIME_INTERVAL_CODE = 266,
     SQL_DATETIME_INTERVAL_PRECISION = 267,
     SQL_DESCRIBE = 268,
     SQL_DESCRIPTOR = 269,
     SQL_DISCONNECT = 270,
     SQL_FOUND = 271,
     SQL_FREE = 272,
     SQL_GET = 273,
     SQL_GO = 274,
     SQL_GOTO = 275,
     SQL_IDENTIFIED = 276,
     SQL_INDICATOR = 277,
     SQL_KEY_MEMBER = 278,
     SQL_LENGTH = 279,
     SQL_LONG = 280,
     SQL_NULLABLE = 281,
     SQL_OCTET_LENGTH = 282,
     SQL_OPEN = 283,
     SQL_OUTPUT = 284,
     SQL_REFERENCE = 285,
     SQL_RETURNED_LENGTH = 286,
     SQL_RETURNED_OCTET_LENGTH = 287,
     SQL_SCALE = 288,
     SQL_SECTION = 289,
     SQL_SHORT = 290,
     SQL_SIGNED = 291,
     SQL_SQL = 292,
     SQL_SQLERROR = 293,
     SQL_SQLPRINT = 294,
     SQL_SQLWARNING = 295,
     SQL_START = 296,
     SQL_STOP = 297,
     SQL_STRUCT = 298,
     SQL_UNSIGNED = 299,
     SQL_VAR = 300,
     SQL_WHENEVER = 301,
     S_ADD = 302,
     S_AND = 303,
     S_ANYTHING = 304,
     S_AUTO = 305,
     S_CONST = 306,
     S_DEC = 307,
     S_DIV = 308,
     S_DOTPOINT = 309,
     S_EQUAL = 310,
     S_EXTERN = 311,
     S_INC = 312,
     S_LSHIFT = 313,
     S_MEMPOINT = 314,
     S_MEMBER = 315,
     S_MOD = 316,
     S_MUL = 317,
     S_NEQUAL = 318,
     S_OR = 319,
     S_REGISTER = 320,
     S_RSHIFT = 321,
     S_STATIC = 322,
     S_SUB = 323,
     S_VOLATILE = 324,
     S_TYPEDEF = 325,
     CSTRING = 326,
     CVARIABLE = 327,
     CPP_LINE = 328,
     IP = 329,
     DOLCONST = 330,
     ECONST = 331,
     NCONST = 332,
     UCONST = 333,
     UIDENT = 334,
     IDENT = 335,
     FCONST = 336,
     SCONST = 337,
     BCONST = 338,
     XCONST = 339,
     Op = 340,
     ICONST = 341,
     PARAM = 342,
     TYPECAST = 343,
     DOT_DOT = 344,
     COLON_EQUALS = 345,
     ABORT_P = 346,
     ABSOLUTE_P = 347,
     ACCESS = 348,
     ACTION = 349,
     ADD_P = 350,
     ADMIN = 351,
     AFTER = 352,
     AGGREGATE = 353,
     ALL = 354,
     ALSO = 355,
     ALTER = 356,
     ALWAYS = 357,
     ANALYSE = 358,
     ANALYZE = 359,
     AND = 360,
     ANY = 361,
     ARRAY = 362,
     AS = 363,
     ASC = 364,
     ASSERTION = 365,
     ASSIGNMENT = 366,
     ASYMMETRIC = 367,
     AT = 368,
     AUTHORIZATION = 369,
     BACKWARD = 370,
     BEFORE = 371,
     BEGIN_P = 372,
     BETWEEN = 373,
     BIGINT = 374,
     BINARY = 375,
     BIT = 376,
     BOOLEAN_P = 377,
     BOTH = 378,
     BY = 379,
     CACHE = 380,
     CALLED = 381,
     CASCADE = 382,
     CASCADED = 383,
     CASE = 384,
     CAST = 385,
     CATALOG_P = 386,
     CHAIN = 387,
     CHAR_P = 388,
     CHARACTER = 389,
     CHARACTERISTICS = 390,
     CHECK = 391,
     CHECKPOINT = 392,
     CLASS = 393,
     CLOSE = 394,
     CLUSTER = 395,
     COALESCE = 396,
     COLLATE = 397,
     COLUMN = 398,
     COMMENT = 399,
     COMMENTS = 400,
     COMMIT = 401,
     COMMITTED = 402,
     CONCURRENTLY = 403,
     CONFIGURATION = 404,
     CONNECTION = 405,
     CONSTRAINT = 406,
     CONSTRAINTS = 407,
     CONTENT_P = 408,
     CONTINUE_P = 409,
     CONVERSION_P = 410,
     COPY = 411,
     COST = 412,
     CREATE = 413,
     CREATEDB = 414,
     CREATEROLE = 415,
     CREATEUSER = 416,
     CROSS = 417,
     CSV = 418,
     CURRENT_P = 419,
     CURRENT_CATALOG = 420,
     CURRENT_DATE = 421,
     CURRENT_ROLE = 422,
     CURRENT_SCHEMA = 423,
     CURRENT_TIME = 424,
     CURRENT_TIMESTAMP = 425,
     CURRENT_USER = 426,
     CURSOR = 427,
     CYCLE = 428,
     DATA_P = 429,
     DATABASE = 430,
     DAY_P = 431,
     DEALLOCATE = 432,
     DEC = 433,
     DECIMAL_P = 434,
     DECLARE = 435,
     DEFAULT = 436,
     DEFAULTS = 437,
     DEFERRABLE = 438,
     DEFERRED = 439,
     DEFINER = 440,
     DELETE_P = 441,
     DELIMITER = 442,
     DELIMITERS = 443,
     DESC = 444,
     DICTIONARY = 445,
     DISABLE_P = 446,
     DISCARD = 447,
     DISTINCT = 448,
     DO = 449,
     DOCUMENT_P = 450,
     DOMAIN_P = 451,
     DOUBLE_P = 452,
     DROP = 453,
     EACH = 454,
     ELSE = 455,
     ENABLE_P = 456,
     ENCODING = 457,
     ENCRYPTED = 458,
     END_P = 459,
     ENUM_P = 460,
     ESCAPE = 461,
     EXCEPT = 462,
     EXCLUDE = 463,
     EXCLUDING = 464,
     EXCLUSIVE = 465,
     EXECUTE = 466,
     EXISTS = 467,
     EXPLAIN = 468,
     EXTERNAL = 469,
     EXTRACT = 470,
     FALSE_P = 471,
     FAMILY = 472,
     FETCH = 473,
     FIRST_P = 474,
     FLOAT_P = 475,
     FOLLOWING = 476,
     FOR = 477,
     FORCE = 478,
     FOREIGN = 479,
     FORWARD = 480,
     FREEZE = 481,
     FROM = 482,
     FULL = 483,
     FUNCTION = 484,
     FUNCTIONS = 485,
     GLOBAL = 486,
     GRANT = 487,
     GRANTED = 488,
     GREATEST = 489,
     GROUP_P = 490,
     HANDLER = 491,
     HAVING = 492,
     HEADER_P = 493,
     HOLD = 494,
     HOUR_P = 495,
     IDENTITY_P = 496,
     IF_P = 497,
     ILIKE = 498,
     IMMEDIATE = 499,
     IMMUTABLE = 500,
     IMPLICIT_P = 501,
     IN_P = 502,
     INCLUDING = 503,
     INCREMENT = 504,
     INDEX = 505,
     INDEXES = 506,
     INHERIT = 507,
     INHERITS = 508,
     INITIALLY = 509,
     INLINE_P = 510,
     INNER_P = 511,
     INOUT = 512,
     INPUT_P = 513,
     INSENSITIVE = 514,
     INSERT = 515,
     INSTEAD = 516,
     INT_P = 517,
     INTEGER = 518,
     INTERSECT = 519,
     INTERVAL = 520,
     INTO = 521,
     INVOKER = 522,
     IS = 523,
     ISNULL = 524,
     ISOLATION = 525,
     JOIN = 526,
     KEY = 527,
     LANGUAGE = 528,
     LARGE_P = 529,
     LAST_P = 530,
     LC_COLLATE_P = 531,
     LC_CTYPE_P = 532,
     LEADING = 533,
     LEAST = 534,
     LEFT = 535,
     LEVEL = 536,
     LIKE = 537,
     LIMIT = 538,
     LISTEN = 539,
     LOAD = 540,
     LOCAL = 541,
     LOCALTIME = 542,
     LOCALTIMESTAMP = 543,
     LOCATION = 544,
     LOCK_P = 545,
     LOGIN_P = 546,
     MAPPING = 547,
     MATCH = 548,
     MAXVALUE = 549,
     MINUTE_P = 550,
     MINVALUE = 551,
     MODE = 552,
     MONTH_P = 553,
     MOVE = 554,
     NAME_P = 555,
     NAMES = 556,
     NATIONAL = 557,
     NATURAL = 558,
     NCHAR = 559,
     NEXT = 560,
     NO = 561,
     NOCREATEDB = 562,
     NOCREATEROLE = 563,
     NOCREATEUSER = 564,
     NOINHERIT = 565,
     NOLOGIN_P = 566,
     NONE = 567,
     NOSUPERUSER = 568,
     NOT = 569,
     NOTHING = 570,
     NOTIFY = 571,
     NOTNULL = 572,
     NOWAIT = 573,
     NULL_P = 574,
     NULLIF = 575,
     NULLS_P = 576,
     NUMERIC = 577,
     OBJECT_P = 578,
     OF = 579,
     OFF = 580,
     OFFSET = 581,
     OIDS = 582,
     ON = 583,
     ONLY = 584,
     OPERATOR = 585,
     OPTION = 586,
     OPTIONS = 587,
     OR = 588,
     ORDER = 589,
     OUT_P = 590,
     OUTER_P = 591,
     OVER = 592,
     OVERLAPS = 593,
     OVERLAY = 594,
     OWNED = 595,
     OWNER = 596,
     PARSER = 597,
     PARTIAL = 598,
     PARTITION = 599,
     PASSWORD = 600,
     PLACING = 601,
     PLANS = 602,
     POSITION = 603,
     PRECEDING = 604,
     PRECISION = 605,
     PRESERVE = 606,
     PREPARE = 607,
     PREPARED = 608,
     PRIMARY = 609,
     PRIOR = 610,
     PRIVILEGES = 611,
     PROCEDURAL = 612,
     PROCEDURE = 613,
     QUOTE = 614,
     RANGE = 615,
     READ = 616,
     REAL = 617,
     REASSIGN = 618,
     RECHECK = 619,
     RECURSIVE = 620,
     REFERENCES = 621,
     REINDEX = 622,
     RELATIVE_P = 623,
     RELEASE = 624,
     RENAME = 625,
     REPEATABLE = 626,
     REPLACE = 627,
     REPLICA = 628,
     RESET = 629,
     RESTART = 630,
     RESTRICT = 631,
     RETURNING = 632,
     RETURNS = 633,
     REVOKE = 634,
     RIGHT = 635,
     ROLE = 636,
     ROLLBACK = 637,
     ROW = 638,
     ROWS = 639,
     RULE = 640,
     SAVEPOINT = 641,
     SCHEMA = 642,
     SCROLL = 643,
     SEARCH = 644,
     SECOND_P = 645,
     SECURITY = 646,
     SELECT = 647,
     SEQUENCE = 648,
     SEQUENCES = 649,
     SERIALIZABLE = 650,
     SERVER = 651,
     SESSION = 652,
     SESSION_USER = 653,
     SET = 654,
     SETOF = 655,
     SHARE = 656,
     SHOW = 657,
     SIMILAR = 658,
     SIMPLE = 659,
     SMALLINT = 660,
     SOME = 661,
     STABLE = 662,
     STANDALONE_P = 663,
     START = 664,
     STATEMENT = 665,
     STATISTICS = 666,
     STDIN = 667,
     STDOUT = 668,
     STORAGE = 669,
     STRICT_P = 670,
     STRIP_P = 671,
     SUBSTRING = 672,
     SUPERUSER_P = 673,
     SYMMETRIC = 674,
     SYSID = 675,
     SYSTEM_P = 676,
     TABLE = 677,
     TABLES = 678,
     TABLESPACE = 679,
     TEMP = 680,
     TEMPLATE = 681,
     TEMPORARY = 682,
     TEXT_P = 683,
     THEN = 684,
     TIME = 685,
     TIMESTAMP = 686,
     TO = 687,
     TRAILING = 688,
     TRANSACTION = 689,
     TREAT = 690,
     TRIGGER = 691,
     TRIM = 692,
     TRUE_P = 693,
     TRUNCATE = 694,
     TRUSTED = 695,
     TYPE_P = 696,
     UNBOUNDED = 697,
     UNCOMMITTED = 698,
     UNENCRYPTED = 699,
     UNION = 700,
     UNIQUE = 701,
     UNKNOWN = 702,
     UNLISTEN = 703,
     UNTIL = 704,
     UPDATE = 705,
     USER = 706,
     USING = 707,
     VACUUM = 708,
     VALID = 709,
     VALIDATOR = 710,
     VALUE_P = 711,
     VALUES = 712,
     VARCHAR = 713,
     VARIADIC = 714,
     VARYING = 715,
     VERBOSE = 716,
     VERSION_P = 717,
     VIEW = 718,
     VOLATILE = 719,
     WHEN = 720,
     WHERE = 721,
     WHITESPACE_P = 722,
     WINDOW = 723,
     WITH = 724,
     WITHOUT = 725,
     WORK = 726,
     WRAPPER = 727,
     WRITE = 728,
     XML_P = 729,
     XMLATTRIBUTES = 730,
     XMLCONCAT = 731,
     XMLELEMENT = 732,
     XMLFOREST = 733,
     XMLPARSE = 734,
     XMLPI = 735,
     XMLROOT = 736,
     XMLSERIALIZE = 737,
     YEAR_P = 738,
     YES_P = 739,
     ZONE = 740,
     NULLS_FIRST = 741,
     NULLS_LAST = 742,
     WITH_TIME = 743,
     POSTFIXOP = 744,
     UMINUS = 745
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_COUNT 265
#define SQL_DATETIME_INTERVAL_CODE 266
#define SQL_DATETIME_INTERVAL_PRECISION 267
#define SQL_DESCRIBE 268
#define SQL_DESCRIPTOR 269
#define SQL_DISCONNECT 270
#define SQL_FOUND 271
#define SQL_FREE 272
#define SQL_GET 273
#define SQL_GO 274
#define SQL_GOTO 275
#define SQL_IDENTIFIED 276
#define SQL_INDICATOR 277
#define SQL_KEY_MEMBER 278
#define SQL_LENGTH 279
#define SQL_LONG 280
#define SQL_NULLABLE 281
#define SQL_OCTET_LENGTH 282
#define SQL_OPEN 283
#define SQL_OUTPUT 284
#define SQL_REFERENCE 285
#define SQL_RETURNED_LENGTH 286
#define SQL_RETURNED_OCTET_LENGTH 287
#define SQL_SCALE 288
#define SQL_SECTION 289
#define SQL_SHORT 290
#define SQL_SIGNED 291
#define SQL_SQL 292
#define SQL_SQLERROR 293
#define SQL_SQLPRINT 294
#define SQL_SQLWARNING 295
#define SQL_START 296
#define SQL_STOP 297
#define SQL_STRUCT 298
#define SQL_UNSIGNED 299
#define SQL_VAR 300
#define SQL_WHENEVER 301
#define S_ADD 302
#define S_AND 303
#define S_ANYTHING 304
#define S_AUTO 305
#define S_CONST 306
#define S_DEC 307
#define S_DIV 308
#define S_DOTPOINT 309
#define S_EQUAL 310
#define S_EXTERN 311
#define S_INC 312
#define S_LSHIFT 313
#define S_MEMPOINT 314
#define S_MEMBER 315
#define S_MOD 316
#define S_MUL 317
#define S_NEQUAL 318
#define S_OR 319
#define S_REGISTER 320
#define S_RSHIFT 321
#define S_STATIC 322
#define S_SUB 323
#define S_VOLATILE 324
#define S_TYPEDEF 325
#define CSTRING 326
#define CVARIABLE 327
#define CPP_LINE 328
#define IP 329
#define DOLCONST 330
#define ECONST 331
#define NCONST 332
#define UCONST 333
#define UIDENT 334
#define IDENT 335
#define FCONST 336
#define SCONST 337
#define BCONST 338
#define XCONST 339
#define Op 340
#define ICONST 341
#define PARAM 342
#define TYPECAST 343
#define DOT_DOT 344
#define COLON_EQUALS 345
#define ABORT_P 346
#define ABSOLUTE_P 347
#define ACCESS 348
#define ACTION 349
#define ADD_P 350
#define ADMIN 351
#define AFTER 352
#define AGGREGATE 353
#define ALL 354
#define ALSO 355
#define ALTER 356
#define ALWAYS 357
#define ANALYSE 358
#define ANALYZE 359
#define AND 360
#define ANY 361
#define ARRAY 362
#define AS 363
#define ASC 364
#define ASSERTION 365
#define ASSIGNMENT 366
#define ASYMMETRIC 367
#define AT 368
#define AUTHORIZATION 369
#define BACKWARD 370
#define BEFORE 371
#define BEGIN_P 372
#define BETWEEN 373
#define BIGINT 374
#define BINARY 375
#define BIT 376
#define BOOLEAN_P 377
#define BOTH 378
#define BY 379
#define CACHE 380
#define CALLED 381
#define CASCADE 382
#define CASCADED 383
#define CASE 384
#define CAST 385
#define CATALOG_P 386
#define CHAIN 387
#define CHAR_P 388
#define CHARACTER 389
#define CHARACTERISTICS 390
#define CHECK 391
#define CHECKPOINT 392
#define CLASS 393
#define CLOSE 394
#define CLUSTER 395
#define COALESCE 396
#define COLLATE 397
#define COLUMN 398
#define COMMENT 399
#define COMMENTS 400
#define COMMIT 401
#define COMMITTED 402
#define CONCURRENTLY 403
#define CONFIGURATION 404
#define CONNECTION 405
#define CONSTRAINT 406
#define CONSTRAINTS 407
#define CONTENT_P 408
#define CONTINUE_P 409
#define CONVERSION_P 410
#define COPY 411
#define COST 412
#define CREATE 413
#define CREATEDB 414
#define CREATEROLE 415
#define CREATEUSER 416
#define CROSS 417
#define CSV 418
#define CURRENT_P 419
#define CURRENT_CATALOG 420
#define CURRENT_DATE 421
#define CURRENT_ROLE 422
#define CURRENT_SCHEMA 423
#define CURRENT_TIME 424
#define CURRENT_TIMESTAMP 425
#define CURRENT_USER 426
#define CURSOR 427
#define CYCLE 428
#define DATA_P 429
#define DATABASE 430
#define DAY_P 431
#define DEALLOCATE 432
#define DEC 433
#define DECIMAL_P 434
#define DECLARE 435
#define DEFAULT 436
#define DEFAULTS 437
#define DEFERRABLE 438
#define DEFERRED 439
#define DEFINER 440
#define DELETE_P 441
#define DELIMITER 442
#define DELIMITERS 443
#define DESC 444
#define DICTIONARY 445
#define DISABLE_P 446
#define DISCARD 447
#define DISTINCT 448
#define DO 449
#define DOCUMENT_P 450
#define DOMAIN_P 451
#define DOUBLE_P 452
#define DROP 453
#define EACH 454
#define ELSE 455
#define ENABLE_P 456
#define ENCODING 457
#define ENCRYPTED 458
#define END_P 459
#define ENUM_P 460
#define ESCAPE 461
#define EXCEPT 462
#define EXCLUDE 463
#define EXCLUDING 464
#define EXCLUSIVE 465
#define EXECUTE 466
#define EXISTS 467
#define EXPLAIN 468
#define EXTERNAL 469
#define EXTRACT 470
#define FALSE_P 471
#define FAMILY 472
#define FETCH 473
#define FIRST_P 474
#define FLOAT_P 475
#define FOLLOWING 476
#define FOR 477
#define FORCE 478
#define FOREIGN 479
#define FORWARD 480
#define FREEZE 481
#define FROM 482
#define FULL 483
#define FUNCTION 484
#define FUNCTIONS 485
#define GLOBAL 486
#define GRANT 487
#define GRANTED 488
#define GREATEST 489
#define GROUP_P 490
#define HANDLER 491
#define HAVING 492
#define HEADER_P 493
#define HOLD 494
#define HOUR_P 495
#define IDENTITY_P 496
#define IF_P 497
#define ILIKE 498
#define IMMEDIATE 499
#define IMMUTABLE 500
#define IMPLICIT_P 501
#define IN_P 502
#define INCLUDING 503
#define INCREMENT 504
#define INDEX 505
#define INDEXES 506
#define INHERIT 507
#define INHERITS 508
#define INITIALLY 509
#define INLINE_P 510
#define INNER_P 511
#define INOUT 512
#define INPUT_P 513
#define INSENSITIVE 514
#define INSERT 515
#define INSTEAD 516
#define INT_P 517
#define INTEGER 518
#define INTERSECT 519
#define INTERVAL 520
#define INTO 521
#define INVOKER 522
#define IS 523
#define ISNULL 524
#define ISOLATION 525
#define JOIN 526
#define KEY 527
#define LANGUAGE 528
#define LARGE_P 529
#define LAST_P 530
#define LC_COLLATE_P 531
#define LC_CTYPE_P 532
#define LEADING 533
#define LEAST 534
#define LEFT 535
#define LEVEL 536
#define LIKE 537
#define LIMIT 538
#define LISTEN 539
#define LOAD 540
#define LOCAL 541
#define LOCALTIME 542
#define LOCALTIMESTAMP 543
#define LOCATION 544
#define LOCK_P 545
#define LOGIN_P 546
#define MAPPING 547
#define MATCH 548
#define MAXVALUE 549
#define MINUTE_P 550
#define MINVALUE 551
#define MODE 552
#define MONTH_P 553
#define MOVE 554
#define NAME_P 555
#define NAMES 556
#define NATIONAL 557
#define NATURAL 558
#define NCHAR 559
#define NEXT 560
#define NO 561
#define NOCREATEDB 562
#define NOCREATEROLE 563
#define NOCREATEUSER 564
#define NOINHERIT 565
#define NOLOGIN_P 566
#define NONE 567
#define NOSUPERUSER 568
#define NOT 569
#define NOTHING 570
#define NOTIFY 571
#define NOTNULL 572
#define NOWAIT 573
#define NULL_P 574
#define NULLIF 575
#define NULLS_P 576
#define NUMERIC 577
#define OBJECT_P 578
#define OF 579
#define OFF 580
#define OFFSET 581
#define OIDS 582
#define ON 583
#define ONLY 584
#define OPERATOR 585
#define OPTION 586
#define OPTIONS 587
#define OR 588
#define ORDER 589
#define OUT_P 590
#define OUTER_P 591
#define OVER 592
#define OVERLAPS 593
#define OVERLAY 594
#define OWNED 595
#define OWNER 596
#define PARSER 597
#define PARTIAL 598
#define PARTITION 599
#define PASSWORD 600
#define PLACING 601
#define PLANS 602
#define POSITION 603
#define PRECEDING 604
#define PRECISION 605
#define PRESERVE 606
#define PREPARE 607
#define PREPARED 608
#define PRIMARY 609
#define PRIOR 610
#define PRIVILEGES 611
#define PROCEDURAL 612
#define PROCEDURE 613
#define QUOTE 614
#define RANGE 615
#define READ 616
#define REAL 617
#define REASSIGN 618
#define RECHECK 619
#define RECURSIVE 620
#define REFERENCES 621
#define REINDEX 622
#define RELATIVE_P 623
#define RELEASE 624
#define RENAME 625
#define REPEATABLE 626
#define REPLACE 627
#define REPLICA 628
#define RESET 629
#define RESTART 630
#define RESTRICT 631
#define RETURNING 632
#define RETURNS 633
#define REVOKE 634
#define RIGHT 635
#define ROLE 636
#define ROLLBACK 637
#define ROW 638
#define ROWS 639
#define RULE 640
#define SAVEPOINT 641
#define SCHEMA 642
#define SCROLL 643
#define SEARCH 644
#define SECOND_P 645
#define SECURITY 646
#define SELECT 647
#define SEQUENCE 648
#define SEQUENCES 649
#define SERIALIZABLE 650
#define SERVER 651
#define SESSION 652
#define SESSION_USER 653
#define SET 654
#define SETOF 655
#define SHARE 656
#define SHOW 657
#define SIMILAR 658
#define SIMPLE 659
#define SMALLINT 660
#define SOME 661
#define STABLE 662
#define STANDALONE_P 663
#define START 664
#define STATEMENT 665
#define STATISTICS 666
#define STDIN 667
#define STDOUT 668
#define STORAGE 669
#define STRICT_P 670
#define STRIP_P 671
#define SUBSTRING 672
#define SUPERUSER_P 673
#define SYMMETRIC 674
#define SYSID 675
#define SYSTEM_P 676
#define TABLE 677
#define TABLES 678
#define TABLESPACE 679
#define TEMP 680
#define TEMPLATE 681
#define TEMPORARY 682
#define TEXT_P 683
#define THEN 684
#define TIME 685
#define TIMESTAMP 686
#define TO 687
#define TRAILING 688
#define TRANSACTION 689
#define TREAT 690
#define TRIGGER 691
#define TRIM 692
#define TRUE_P 693
#define TRUNCATE 694
#define TRUSTED 695
#define TYPE_P 696
#define UNBOUNDED 697
#define UNCOMMITTED 698
#define UNENCRYPTED 699
#define UNION 700
#define UNIQUE 701
#define UNKNOWN 702
#define UNLISTEN 703
#define UNTIL 704
#define UPDATE 705
#define USER 706
#define USING 707
#define VACUUM 708
#define VALID 709
#define VALIDATOR 710
#define VALUE_P 711
#define VALUES 712
#define VARCHAR 713
#define VARIADIC 714
#define VARYING 715
#define VERBOSE 716
#define VERSION_P 717
#define VIEW 718
#define VOLATILE 719
#define WHEN 720
#define WHERE 721
#define WHITESPACE_P 722
#define WINDOW 723
#define WITH 724
#define WITHOUT 725
#define WORK 726
#define WRAPPER 727
#define WRITE 728
#define XML_P 729
#define XMLATTRIBUTES 730
#define XMLCONCAT 731
#define XMLELEMENT 732
#define XMLFOREST 733
#define XMLPARSE 734
#define XMLPI 735
#define XMLROOT 736
#define XMLSERIALIZE 737
#define YEAR_P 738
#define YES_P 739
#define ZONE 740
#define NULLS_FIRST 741
#define NULLS_LAST 742
#define WITH_TIME 743
#define POSTFIXOP 744
#define UMINUS 745




/* Copy the first part of user declarations.  */
#line 5 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int 	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (yyin)
				fclose(yyin);
			if (yyout)
				fclose(yyout);
			
			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
			        fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), make_str(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in other functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn's cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = make_str("");
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char temp[20];
			char *original_var;
			bool skip_set_var = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(temp, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable) && (!strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement"))))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char && ptr->variable->type->type != ECPGt_string) && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1"), ptr->variable->type->u.element->counter), ptr->variable->type->size), 0);
				sprintf(temp, "%d, (", ecpg_internal_var++);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char || ptr->variable->type->type == ECPGt_string) && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->counter), 0);
				if (ptr->variable->type->type == ECPGt_varchar)
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				else
					sprintf(temp, "%d, (", ecpg_internal_var++);
			}
			else if (ptr->variable->type->type == ECPGt_struct || ptr->variable->type->type == ECPGt_union)
			{
				sprintf(temp, "%d)))", ecpg_internal_var);
				newvar = new_variable(cat_str(4, make_str("(*("), mm_strdup(ptr->variable->type->type_name), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->variable->type->u.members, ptr->variable->type->type, ptr->variable->type->type_name, ptr->variable->type->struct_sizeof), 0);
				sprintf(temp, "%d, &(", ecpg_internal_var++);
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct || ptr->variable->type->u.element->type == ECPGt_union)
				{
					sprintf(temp, "%d)))", ecpg_internal_var);
					newvar = new_variable(cat_str(4, make_str("(*("), mm_strdup(ptr->variable->type->u.element->type_name), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->variable->type->u.element->u.members, ptr->variable->type->u.element->type, ptr->variable->type->u.element->type_name, ptr->variable->type->u.element->struct_sizeof), 0);
					sprintf(temp, "%d, (", ecpg_internal_var++);
				}
				else
				{
					newvar = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, ptr->variable->type->u.element->size, ptr->variable->type->u.element->counter), ptr->variable->type->size), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->counter), 0);
				sprintf(temp, "%d, &(", ecpg_internal_var++);
			}

			/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
			if (!skip_set_var)
				result = cat_str(5, result, make_str("ECPGset_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(temp, "%d))", ecpg_internal_var);

				if (ptr->indicator->type->type == ECPGt_struct || ptr->indicator->type->type == ECPGt_union)
				{
					sprintf(temp, "%d)))", ecpg_internal_var);
					newind = new_variable(cat_str(4, make_str("(*("), mm_strdup(ptr->indicator->type->type_name), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->indicator->type->u.members, ptr->indicator->type->type, ptr->indicator->type->type_name, ptr->indicator->type->struct_sizeof), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct || ptr->indicator->type->u.element->type == ECPGt_union)
					{
						sprintf(temp, "%d)))", ecpg_internal_var);
						newind = new_variable(cat_str(4, make_str("(*("), mm_strdup(ptr->indicator->type->u.element->type_name), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->indicator->type->u.element->u.members, ptr->indicator->type->u.element->type, ptr->indicator->type->u.element->type_name, ptr->indicator->type->u.element->struct_sizeof), 0);
						sprintf(temp, "%d, (", ecpg_internal_var++);
					}
					else
					{
						newind = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type, ptr->indicator->type->u.element->size, ptr->indicator->type->u.element->counter), ptr->indicator->type->size), 0);
						sprintf(temp, "%d, &(", ecpg_internal_var++);
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->counter), 0);
					sprintf(temp, "%d, (", ecpg_internal_var++);
				}
				else
				{
					newind = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->counter), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				result = cat_str(5, result, make_str("ECPGset_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && !strcmp(cur->function, current_function)))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 470 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1540 "preproc.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1564 "preproc.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   93830

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  510
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  657
/* YYNRULES -- Number of rules. */
#define YYNRULES  2565
/* YYNRULES -- Number of states. */
#define YYNSTATES  4490

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   745

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   497,     2,     2,
     502,   503,   495,   493,   505,   494,   504,   496,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   507,   506,
     490,   489,   491,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   500,     2,   501,   498,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   508,     2,   509,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   492,   499
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    29,    31,    33,    35,    37,
      39,    41,    43,    45,    47,    49,    51,    53,    55,    57,
      59,    61,    63,    65,    67,    69,    71,    73,    75,    77,
      79,    81,    83,    85,    87,    89,    91,    93,    95,    97,
      99,   101,   103,   105,   107,   109,   111,   113,   115,   117,
     119,   121,   123,   125,   127,   129,   131,   133,   135,   137,
     139,   141,   143,   145,   147,   149,   151,   153,   155,   157,
     159,   161,   163,   165,   167,   169,   171,   173,   175,   177,
     179,   181,   183,   185,   187,   189,   191,   193,   195,   197,
     199,   201,   203,   205,   207,   209,   211,   213,   215,   217,
     219,   221,   223,   225,   227,   229,   231,   233,   235,   237,
     239,   241,   243,   245,   247,   248,   254,   256,   257,   260,
     261,   264,   265,   268,   271,   275,   279,   281,   283,   285,
     287,   289,   291,   293,   295,   297,   299,   301,   303,   307,
     311,   314,   316,   319,   322,   325,   329,   333,   339,   345,
     346,   350,   356,   362,   367,   371,   377,   381,   387,   393,
     400,   402,   404,   408,   414,   421,   426,   428,   429,   432,
     433,   435,   437,   439,   441,   443,   445,   448,   452,   456,
     460,   464,   468,   472,   476,   480,   483,   489,   492,   495,
     498,   501,   505,   509,   513,   515,   519,   521,   525,   527,
     529,   531,   534,   537,   540,   542,   544,   546,   548,   550,
     552,   554,   558,   565,   567,   569,   571,   573,   575,   576,
     578,   580,   583,   587,   592,   596,   599,   602,   604,   608,
     613,   619,   624,   627,   632,   634,   636,   638,   640,   642,
     645,   648,   651,   654,   659,   664,   669,   674,   676,   680,
     683,   687,   692,   699,   706,   713,   719,   725,   732,   739,
     744,   752,   755,   762,   767,   771,   775,   779,   783,   787,
     792,   797,   801,   805,   809,   813,   817,   821,   826,   831,
     835,   838,   842,   846,   850,   853,   856,   860,   863,   865,
     867,   868,   871,   872,   876,   879,   880,   882,   886,   890,
     892,   898,   902,   905,   908,   919,   926,   928,   930,   932,
     934,   936,   938,   942,   945,   946,   948,   950,   954,   958,
     960,   962,   966,   970,   974,   978,   983,   985,   986,   989,
     990,   994,   995,   997,   998,  1000,  1004,  1007,  1009,  1011,
    1013,  1015,  1019,  1020,  1022,  1026,  1028,  1030,  1042,  1053,
    1055,  1057,  1060,  1063,  1066,  1069,  1070,  1072,  1073,  1077,
    1078,  1080,  1084,  1086,  1090,  1092,  1094,  1096,  1098,  1100,
    1104,  1109,  1112,  1113,  1117,  1119,  1121,  1124,  1126,  1130,
    1135,  1140,  1143,  1149,  1151,  1154,  1157,  1160,  1164,  1168,
    1172,  1173,  1175,  1177,  1179,  1181,  1183,  1185,  1189,  1191,
    1197,  1205,  1214,  1224,  1236,  1240,  1241,  1243,  1247,  1249,
    1252,  1255,  1258,  1259,  1261,  1265,  1269,  1276,  1281,  1282,
    1284,  1286,  1289,  1292,  1293,  1297,  1301,  1304,  1306,  1308,
    1311,  1314,  1319,  1320,  1323,  1326,  1329,  1330,  1334,  1339,
    1344,  1345,  1348,  1349,  1354,  1355,  1361,  1365,  1366,  1368,
    1372,  1374,  1377,  1381,  1382,  1388,  1393,  1395,  1396,  1398,
    1401,  1404,  1406,  1409,  1413,  1416,  1419,  1422,  1425,  1429,
    1433,  1435,  1439,  1441,  1442,  1444,  1447,  1449,  1456,  1467,
    1469,  1470,  1472,  1475,  1478,  1479,  1482,  1485,  1487,  1488,
    1494,  1502,  1504,  1505,  1512,  1515,  1516,  1520,  1526,  1534,
    1541,  1550,  1558,  1565,  1572,  1577,  1578,  1580,  1584,  1589,
    1591,  1595,  1597,  1600,  1603,  1606,  1609,  1611,  1613,  1624,
    1627,  1628,  1631,  1634,  1636,  1637,  1642,  1649,  1655,  1660,
    1665,  1674,  1676,  1678,  1680,  1688,  1698,  1707,  1723,  1744,
    1746,  1748,  1750,  1754,  1756,  1758,  1760,  1764,  1766,  1770,
    1771,  1773,  1774,  1776,  1778,  1783,  1784,  1786,  1790,  1791,
    1793,  1795,  1797,  1799,  1801,  1803,  1806,  1807,  1809,  1812,
    1814,  1817,  1818,  1821,  1823,  1826,  1829,  1836,  1845,  1854,
    1859,  1865,  1870,  1875,  1880,  1884,  1892,  1901,  1908,  1915,
    1922,  1929,  1933,  1935,  1939,  1943,  1945,  1947,  1949,  1951,
    1953,  1955,  1959,  1963,  1967,  1969,  1973,  1977,  1979,  1980,
    1982,  1986,  2000,  2002,  2006,  2011,  2017,  2022,  2030,  2033,
    2035,  2036,  2039,  2040,  2042,  2043,  2050,  2059,  2068,  2070,
    2074,  2080,  2086,  2094,  2104,  2112,  2122,  2128,  2135,  2142,
    2147,  2149,  2151,  2153,  2155,  2157,  2159,  2161,  2163,  2167,
    2171,  2175,  2179,  2181,  2185,  2187,  2190,  2193,  2197,  2203,
    2206,  2209,  2210,  2217,  2225,  2233,  2241,  2250,  2259,  2266,
    2275,  2285,  2295,  2303,  2314,  2322,  2331,  2340,  2349,  2358,
    2360,  2362,  2364,  2366,  2368,  2370,  2372,  2374,  2376,  2378,
    2380,  2382,  2384,  2386,  2389,  2392,  2396,  2401,  2407,  2412,
    2418,  2422,  2427,  2431,  2436,  2438,  2441,  2445,  2449,  2453,
    2457,  2462,  2467,  2471,  2475,  2480,  2485,  2490,  2495,  2497,
    2499,  2501,  2502,  2510,  2518,  2529,  2531,  2533,  2536,  2541,
    2547,  2549,  2553,  2556,  2559,  2562,  2565,  2567,  2570,  2573,
    2578,  2582,  2585,  2588,  2591,  2595,  2598,  2601,  2607,  2613,
    2619,  2621,  2625,  2627,  2630,  2634,  2635,  2637,  2641,  2644,
    2651,  2658,  2668,  2672,  2673,  2677,  2678,  2684,  2687,  2688,
    2692,  2696,  2700,  2708,  2716,  2727,  2729,  2731,  2733,  2748,
    2750,  2751,  2753,  2754,  2756,  2757,  2760,  2761,  2763,  2767,
    2772,  2777,  2784,  2786,  2789,  2790,  2792,  2794,  2795,  2797,
    2799,  2800,  2810,  2823,  2831,  2834,  2835,  2839,  2842,  2844,
    2848,  2852,  2855,  2857,  2861,  2865,  2869,  2872,  2875,  2877,
    2879,  2881,  2883,  2886,  2888,  2890,  2892,  2894,  2899,  2905,
    2907,  2911,  2915,  2917,  2920,  2925,  2931,  2933,  2935,  2937,
    2939,  2943,  2947,  2950,  2953,  2956,  2959,  2961,  2964,  2967,
    2969,  2971,  2973,  2977,  2980,  2981,  2984,  2986,  2990,  2996,
    2998,  3001,  3003,  3004,  3010,  3018,  3024,  3032,  3038,  3046,
    3050,  3056,  3062,  3068,  3070,  3074,  3077,  3079,  3082,  3084,
    3087,  3099,  3110,  3121,  3124,  3127,  3128,  3138,  3141,  3142,
    3147,  3152,  3157,  3159,  3161,  3163,  3164,  3172,  3179,  3186,
    3193,  3200,  3208,  3218,  3228,  3235,  3242,  3249,  3256,  3263,
    3272,  3281,  3288,  3295,  3302,  3308,  3314,  3323,  3332,  3341,
    3350,  3357,  3359,  3360,  3363,  3364,  3372,  3379,  3386,  3393,
    3400,  3407,  3414,  3422,  3429,  3436,  3443,  3450,  3458,  3466,
    3474,  3484,  3494,  3501,  3508,  3515,  3524,  3533,  3542,  3549,
    3563,  3565,  3567,  3571,  3575,  3577,  3579,  3581,  3583,  3585,
    3587,  3589,  3590,  3592,  3594,  3596,  3598,  3600,  3602,  3603,
    3610,  3619,  3623,  3626,  3627,  3630,  3633,  3636,  3639,  3643,
    3647,  3650,  3653,  3656,  3659,  3663,  3666,  3672,  3677,  3681,
    3685,  3689,  3691,  3693,  3694,  3698,  3701,  3704,  3706,  3710,
    3713,  3715,  3716,  3725,  3736,  3740,  3745,  3750,  3751,  3754,
    3760,  3763,  3764,  3768,  3772,  3776,  3780,  3784,  3788,  3792,
    3796,  3800,  3804,  3808,  3812,  3816,  3821,  3825,  3829,  3831,
    3832,  3838,  3845,  3850,  3853,  3854,  3859,  3863,  3869,  3876,
    3881,  3888,  3895,  3901,  3909,  3911,  3912,  3919,  3931,  3943,
    3955,  3969,  3979,  3991,  4002,  4007,  4010,  4016,  4019,  4020,
    4025,  4031,  4037,  4042,  4049,  4051,  4055,  4057,  4059,  4061,
    4063,  4066,  4071,  4073,  4075,  4077,  4078,  4080,  4081,  4083,
    4084,  4088,  4089,  4092,  4097,  4101,  4107,  4109,  4111,  4113,
    4115,  4117,  4119,  4121,  4123,  4127,  4130,  4132,  4134,  4136,
    4138,  4140,  4142,  4143,  4149,  4154,  4158,  4159,  4161,  4163,
    4165,  4167,  4172,  4181,  4185,  4186,  4192,  4194,  4199,  4202,
    4204,  4208,  4211,  4214,  4215,  4222,  4225,  4226,  4232,  4236,
    4237,  4240,  4243,  4246,  4250,  4252,  4256,  4258,  4261,  4263,
    4264,  4272,  4274,  4278,  4280,  4282,  4286,  4292,  4295,  4297,
    4301,  4309,  4311,  4313,  4314,  4318,  4321,  4324,  4327,  4328,
    4331,  4334,  4336,  4338,  4342,  4346,  4348,  4351,  4356,  4361,
    4364,  4368,  4374,  4380,  4382,  4384,  4394,  4396,  4399,  4404,
    4409,  4414,  4417,  4421,  4423,  4427,  4432,  4435,  4437,  4438,
    4442,  4446,  4451,  4456,  4461,  4466,  4469,  4471,  4473,  4474,
    4476,  4478,  4479,  4481,  4487,  4489,  4490,  4492,  4493,  4497,
    4499,  4503,  4508,  4512,  4515,  4518,  4520,  4522,  4524,  4525,
    4528,  4533,  4539,  4542,  4546,  4548,  4550,  4552,  4554,  4558,
    4559,  4561,  4563,  4565,  4567,  4569,  4573,  4574,  4577,  4578,
    4580,  4584,  4586,  4587,  4589,  4592,  4597,  4602,  4605,  4606,
    4609,  4613,  4616,  4617,  4619,  4623,  4625,  4628,  4630,  4633,
    4639,  4646,  4652,  4654,  4657,  4659,  4664,  4668,  4673,  4679,
    4684,  4690,  4695,  4701,  4704,  4709,  4711,  4714,  4717,  4720,
    4722,  4724,  4725,  4730,  4733,  4735,  4738,  4741,  4746,  4748,
    4752,  4754,  4757,  4761,  4763,  4766,  4767,  4770,  4775,  4776,
    4778,  4782,  4785,  4788,  4792,  4798,  4805,  4808,  4812,  4816,
    4821,  4822,  4824,  4826,  4828,  4830,  4832,  4835,  4841,  4843,
    4845,  4847,  4849,  4852,  4856,  4860,  4861,  4863,  4865,  4867,
    4869,  4871,  4874,  4877,  4880,  4883,  4886,  4888,  4892,  4893,
    4895,  4897,  4899,  4901,  4907,  4910,  4912,  4914,  4916,  4918,
    4924,  4927,  4930,  4933,  4935,  4939,  4943,  4946,  4948,  4949,
    4953,  4954,  4960,  4963,  4969,  4972,  4974,  4977,  4981,  4982,
    4984,  4986,  4988,  4990,  4992,  4994,  4998,  5002,  5006,  5010,
    5014,  5018,  5022,  5023,  5025,  5030,  5032,  5036,  5042,  5045,
    5048,  5052,  5056,  5060,  5064,  5068,  5072,  5076,  5080,  5084,
    5088,  5091,  5094,  5098,  5102,  5105,  5109,  5115,  5120,  5127,
    5131,  5137,  5142,  5149,  5154,  5161,  5167,  5175,  5179,  5182,
    5187,  5190,  5194,  5198,  5203,  5207,  5212,  5216,  5221,  5227,
    5234,  5241,  5249,  5256,  5264,  5271,  5279,  5283,  5288,  5293,
    5300,  5303,  5307,  5312,  5314,  5318,  5321,  5324,  5328,  5332,
    5336,  5340,  5344,  5348,  5352,  5356,  5360,  5364,  5367,  5370,
    5376,  5383,  5390,  5398,  5402,  5407,  5409,  5411,  5414,  5419,
    5421,  5423,  5425,  5428,  5431,  5434,  5436,  5441,  5447,  5454,
    5463,  5470,  5478,  5486,  5492,  5494,  5496,  5501,  5503,  5508,
    5510,  5515,  5517,  5522,  5524,  5526,  5528,  5530,  5532,  5534,
    5541,  5546,  5551,  5556,  5561,  5568,  5574,  5580,  5586,  5591,
    5598,  5603,  5608,  5613,  5618,  5624,  5632,  5640,  5650,  5655,
    5662,  5668,  5676,  5684,  5692,  5695,  5699,  5703,  5707,  5712,
    5713,  5718,  5720,  5724,  5728,  5730,  5732,  5734,  5737,  5740,
    5741,  5744,  5745,  5747,  5751,  5755,  5758,  5761,  5762,  5769,
    5771,  5772,  5776,  5777,  5780,  5783,  5784,  5786,  5791,  5794,
    5797,  5800,  5803,  5806,  5811,  5815,  5821,  5823,  5825,  5827,
    5829,  5831,  5833,  5835,  5837,  5839,  5841,  5843,  5845,  5847,
    5849,  5851,  5856,  5858,  5863,  5865,  5870,  5872,  5875,  5877,
    5880,  5882,  5886,  5888,  5892,  5894,  5898,  5900,  5904,  5908,
    5912,  5915,  5917,  5921,  5925,  5926,  5928,  5930,  5932,  5934,
    5936,  5938,  5940,  5942,  5947,  5951,  5954,  5958,  5959,  5963,
    5967,  5970,  5973,  5975,  5976,  5979,  5982,  5986,  5989,  5991,
    5993,  5997,  6003,  6005,  6008,  6013,  6016,  6017,  6019,  6020,
    6022,  6025,  6028,  6031,  6035,  6041,  6043,  6046,  6047,  6050,
    6052,  6053,  6055,  6057,  6059,  6063,  6067,  6069,  6073,  6077,
    6080,  6082,  6084,  6086,  6090,  6092,  6095,  6097,  6101,  6103,
    6105,  6107,  6109,  6111,  6113,  6115,  6118,  6120,  6122,  6124,
    6126,  6128,  6131,  6137,  6140,  6144,  6151,  6153,  6155,  6157,
    6159,  6161,  6163,  6165,  6167,  6169,  6172,  6175,  6177,  6181,
    6183,  6185,  6187,  6189,  6191,  6193,  6195,  6197,  6199,  6201,
    6203,  6205,  6207,  6209,  6211,  6213,  6215,  6217,  6219,  6221,
    6223,  6225,  6227,  6229,  6231,  6233,  6235,  6237,  6239,  6241,
    6243,  6245,  6247,  6249,  6251,  6253,  6255,  6257,  6259,  6261,
    6263,  6265,  6267,  6269,  6271,  6273,  6275,  6277,  6279,  6281,
    6283,  6285,  6287,  6289,  6291,  6293,  6295,  6297,  6299,  6301,
    6303,  6305,  6307,  6309,  6311,  6313,  6315,  6317,  6319,  6321,
    6323,  6325,  6327,  6329,  6331,  6333,  6335,  6337,  6339,  6341,
    6343,  6345,  6347,  6349,  6351,  6353,  6355,  6357,  6359,  6361,
    6363,  6365,  6367,  6369,  6371,  6373,  6375,  6377,  6379,  6381,
    6383,  6385,  6387,  6389,  6391,  6393,  6395,  6397,  6399,  6401,
    6403,  6405,  6407,  6409,  6411,  6413,  6415,  6417,  6419,  6421,
    6423,  6425,  6427,  6429,  6431,  6433,  6435,  6437,  6439,  6441,
    6443,  6445,  6447,  6449,  6451,  6453,  6455,  6457,  6459,  6461,
    6463,  6465,  6467,  6469,  6471,  6473,  6475,  6477,  6479,  6481,
    6483,  6485,  6487,  6489,  6491,  6493,  6495,  6497,  6499,  6501,
    6503,  6505,  6507,  6509,  6511,  6513,  6515,  6517,  6519,  6521,
    6523,  6525,  6527,  6529,  6531,  6533,  6535,  6537,  6539,  6541,
    6543,  6545,  6547,  6549,  6551,  6553,  6555,  6557,  6559,  6561,
    6563,  6565,  6567,  6569,  6571,  6573,  6575,  6577,  6579,  6581,
    6583,  6585,  6587,  6589,  6591,  6593,  6595,  6597,  6599,  6601,
    6603,  6605,  6607,  6609,  6611,  6613,  6615,  6617,  6619,  6621,
    6623,  6625,  6627,  6629,  6631,  6633,  6635,  6637,  6639,  6641,
    6643,  6645,  6647,  6649,  6651,  6653,  6655,  6657,  6659,  6661,
    6663,  6665,  6667,  6669,  6671,  6673,  6675,  6677,  6679,  6681,
    6683,  6685,  6687,  6689,  6691,  6693,  6695,  6697,  6699,  6701,
    6703,  6705,  6707,  6709,  6711,  6713,  6715,  6717,  6719,  6721,
    6723,  6725,  6727,  6729,  6731,  6733,  6735,  6737,  6739,  6741,
    6743,  6745,  6747,  6749,  6751,  6753,  6755,  6757,  6759,  6761,
    6763,  6765,  6767,  6769,  6771,  6773,  6775,  6777,  6779,  6781,
    6783,  6785,  6787,  6789,  6791,  6793,  6795,  6797,  6799,  6801,
    6803,  6805,  6807,  6809,  6811,  6813,  6815,  6817,  6819,  6821,
    6823,  6825,  6827,  6829,  6831,  6833,  6835,  6837,  6839,  6841,
    6843,  6845,  6847,  6849,  6851,  6853,  6855,  6857,  6859,  6861,
    6863,  6865,  6867,  6869,  6871,  6873,  6875,  6877,  6879,  6881,
    6883,  6885,  6887,  6889,  6891,  6893,  6895,  6897,  6899,  6901,
    6903,  6905,  6907,  6909,  6911,  6913,  6915,  6917,  6919,  6921,
    6923,  6925,  6927,  6929,  6931,  6933,  6935,  6937,  6939,  6941,
    6943,  6944,  6947,  6952,  6956,  6959,  6961,  6963,  6965,  6967,
    6969,  6970,  6979,  6982,  6988,  6992,  6995,  6998,  7002,  7010,
    7012,  7014,  7016,  7017,  7020,  7023,  7025,  7026,  7028,  7032,
    7034,  7037,  7038,  7041,  7042,  7045,  7046,  7048,  7052,  7057,
    7061,  7063,  7065,  7067,  7069,  7072,  7073,  7076,  7081,  7082,
    7085,  7088,  7091,  7093,  7095,  7103,  7107,  7109,  7111,  7113,
    7115,  7118,  7119,  7121,  7125,  7129,  7133,  7137,  7138,  7143,
    7149,  7155,  7156,  7158,  7160,  7162,  7165,  7168,  7170,  7173,
    7174,  7182,  7183,  7189,  7190,  7195,  7198,  7201,  7202,  7205,
    7207,  7209,  7211,  7213,  7215,  7217,  7219,  7221,  7223,  7225,
    7227,  7233,  7236,  7238,  7242,  7245,  7248,  7252,  7253,  7259,
    7261,  7262,  7268,  7271,  7274,  7276,  7278,  7280,  7283,  7286,
    7290,  7292,  7295,  7298,  7302,  7306,  7311,  7314,  7316,  7319,
    7321,  7323,  7326,  7329,  7333,  7335,  7337,  7339,  7341,  7342,
    7344,  7348,  7354,  7355,  7358,  7359,  7361,  7364,  7368,  7371,
    7373,  7375,  7377,  7378,  7380,  7382,  7384,  7386,  7388,  7391,
    7394,  7398,  7399,  7401,  7404,  7406,  7411,  7415,  7420,  7424,
    7427,  7429,  7433,  7435,  7437,  7439,  7441,  7444,  7447,  7449,
    7452,  7455,  7457,  7459,  7461,  7466,  7471,  7476,  7481,  7486,
    7488,  7489,  7493,  7497,  7502,  7504,  7508,  7512,  7517,  7519,
    7523,  7527,  7529,  7531,  7533,  7540,  7542,  7546,  7550,  7557,
    7559,  7563,  7567,  7569,  7571,  7574,  7577,  7579,  7581,  7583,
    7585,  7587,  7589,  7591,  7593,  7595,  7597,  7599,  7601,  7603,
    7605,  7607,  7609,  7614,  7619,  7621,  7623,  7628,  7633,  7637,
    7638,  7646,  7648,  7649,  7650,  7658,  7662,  7667,  7671,  7673,
    7675,  7677,  7680,  7684,  7690,  7693,  7699,  7702,  7704,  7706,
    7708,  7710,  7712,  7714,  7716,  7718,  7720,  7722,  7724,  7726,
    7728,  7730,  7732,  7734,  7736,  7738,  7740,  7742,  7744,  7746,
    7748,  7750,  7752,  7754,  7756,  7758,  7760,  7762,  7764,  7766,
    7768,  7770,  7772,  7774,  7776,  7778,  7780,  7782,  7784,  7786,
    7788,  7790,  7792,  7794,  7796,  7798,  7800,  7802,  7804,  7806,
    7808,  7810,  7812,  7814,  7816,  7818,  7820,  7822,  7824,  7826,
    7828,  7830,  7832,  7834,  7836,  7838,  7840,  7842,  7844,  7846,
    7848,  7850,  7852,  7854,  7856,  7858,  7860,  7862,  7864,  7866,
    7868,  7870,  7872,  7874,  7876,  7878,  7880,  7882,  7884,  7886,
    7888,  7890,  7892,  7894,  7896,  7898,  7902,  7904,  7905,  7907,
    7910,  7912,  7915,  7917,  7919,  7921,  7924,  7927,  7929,  7931,
    7933,  7935,  7937,  7939,  7941,  7943,  7945,  7947,  7949,  7951,
    7953,  7955,  7957,  7959,  7962,  7966,  7968,  7971,  7973,  7977,
    7979,  7983,  7985,  7987,  7989,  7991,  7993,  7995,  7997,  7999,
    8001,  8003,  8005,  8007,  8009,  8011,  8013,  8015,  8017,  8019,
    8021,  8023,  8025,  8027,  8029,  8031,  8033,  8035,  8037,  8039,
    8041,  8043,  8045,  8047,  8049,  8051,  8053,  8055,  8057,  8059,
    8061,  8063,  8065,  8067,  8069,  8071,  8073,  8075,  8077,  8079,
    8081,  8083,  8085,  8087,  8089,  8091,  8093,  8095,  8097,  8099,
    8101,  8103,  8105,  8108,  8112,  8115,  8119,  8121,  8125,  8129,
    8133,  8137,  8141,  8145,  8147,  8149,  8150,  8153,  8156,  8158,
    8160,  8163,  8165,  8167,  8169,  8170
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     511,     0,    -1,  1018,    -1,   810,    -1,   811,    -1,   729,
      -1,   816,    -1,   639,    -1,   653,    -1,   763,    -1,   528,
      -1,   784,    -1,   785,    -1,   620,    -1,   553,    -1,   522,
      -1,   520,    -1,   819,    -1,   818,    -1,   657,    -1,   524,
      -1,   523,    -1,   826,    -1,   551,    -1,   563,    -1,   821,
      -1,   707,    -1,   548,    -1,   564,    -1,  1020,    -1,   673,
      -1,   774,    -1,   820,    -1,   815,    -1,   637,    -1,   648,
      -1,   744,    -1,   527,    -1,   686,    -1,   692,    -1,   693,
      -1,   626,    -1,   531,    -1,   619,    -1,   579,    -1,   634,
      -1,   658,    -1,   513,    -1,   519,    -1,   654,    -1,   806,
      -1,  1161,    -1,   861,    -1,   675,    -1,   848,    -1,   552,
      -1,   771,    -1,   674,    -1,   776,    -1,   638,    -1,   652,
      -1,   530,    -1,   696,    -1,   697,    -1,   698,    -1,   632,
      -1,   793,    -1,   700,    -1,   636,    -1,   672,    -1,   525,
      -1,   526,    -1,   656,    -1,   814,    -1,   841,    -1,   832,
      -1,   710,    -1,   714,    -1,   725,    -1,   734,    -1,   843,
      -1,   796,    -1,   805,    -1,   850,    -1,   794,    -1,   838,
      -1,   699,    -1,   778,    -1,   767,    -1,   766,    -1,   768,
      -1,   781,    -1,   715,    -1,   726,    -1,   786,    -1,   865,
      -1,   798,    -1,   705,    -1,   797,    -1,   854,    -1,   823,
      -1,   545,    -1,   535,    -1,   547,    -1,   803,    -1,  1097,
      -1,  1023,    -1,  1040,    -1,  1098,    -1,  1080,    -1,  1095,
      -1,  1081,    -1,  1041,    -1,  1085,    -1,  1107,    -1,  1099,
      -1,  1086,    -1,  1115,    -1,  1117,    -1,  1110,    -1,  1102,
      -1,  1118,    -1,  1121,    -1,  1123,    -1,    -1,   158,   381,
    1011,   514,   515,    -1,   469,    -1,    -1,   515,   518,    -1,
      -1,   516,   517,    -1,    -1,   345,  1151,    -1,   345,   319,
      -1,   203,   345,  1151,    -1,   444,   345,  1151,    -1,   418,
      -1,   313,    -1,   252,    -1,   310,    -1,   159,    -1,   307,
      -1,   160,    -1,   308,    -1,   161,    -1,   309,    -1,   291,
      -1,   311,    -1,   150,   283,  1012,    -1,   454,   449,  1151,
      -1,   451,  1001,    -1,   517,    -1,   420,  1010,    -1,    96,
    1001,    -1,   381,  1001,    -1,   247,   381,  1001,    -1,   247,
     235,  1001,    -1,   158,   451,  1011,   514,   515,    -1,   101,
     381,  1011,   514,   516,    -1,    -1,   247,   175,  1003,    -1,
     101,   381,  1011,   521,   546,    -1,   101,   451,  1011,   514,
     516,    -1,   101,   451,  1011,   546,    -1,   198,   381,  1001,
      -1,   198,   381,   242,   212,  1001,    -1,   198,   451,  1001,
      -1,   198,   451,   242,   212,  1001,    -1,   158,   235,  1011,
     514,   515,    -1,   101,   235,  1011,   529,   451,  1001,    -1,
      95,    -1,   198,    -1,   198,   235,  1001,    -1,   198,   235,
     242,   212,  1001,    -1,   158,   387,   532,   114,  1011,   533,
      -1,   158,   387,  1131,   533,    -1,  1131,    -1,    -1,   533,
     534,    -1,    -1,   579,    -1,   734,    -1,   619,    -1,   658,
      -1,   714,    -1,   803,    -1,   399,   536,    -1,   399,   286,
     536,    -1,   399,   397,   536,    -1,   537,   432,   538,    -1,
     537,   489,   538,    -1,   537,   432,   181,    -1,   537,   489,
     181,    -1,   537,   227,   164,    -1,   430,   485,   542,    -1,
     434,   801,    -1,   397,   135,   108,   434,   801,    -1,   131,
    1151,    -1,   387,  1151,    -1,   301,   543,    -1,   381,   544,
      -1,   397,   114,   544,    -1,   397,   114,   181,    -1,   474,
     331,   949,    -1,  1130,    -1,   537,   504,  1131,    -1,   539,
      -1,   538,   505,   539,    -1,   541,    -1,   544,    -1,   625,
      -1,   361,   443,    -1,   361,   147,    -1,   371,   361,    -1,
     395,    -1,   438,    -1,   216,    -1,   328,    -1,   325,    -1,
    1151,    -1,  1153,    -1,   936,  1151,   938,    -1,   936,   502,
    1010,   503,  1151,   938,    -1,   625,    -1,   181,    -1,   286,
      -1,  1151,    -1,   181,    -1,    -1,  1131,    -1,  1151,    -1,
     374,   537,    -1,   374,   430,   485,    -1,   374,   434,   270,
     281,    -1,   374,   397,   114,    -1,   374,    99,    -1,   399,
     536,    -1,   545,    -1,   402,   537,  1164,    -1,   402,   430,
     485,  1164,    -1,   402,   434,   270,   281,  1164,    -1,   402,
     397,   114,  1164,    -1,   402,    99,    -1,   399,   152,   549,
     550,    -1,    99,    -1,   999,    -1,   184,    -1,   244,    -1,
     137,    -1,   192,    99,    -1,   192,   425,    -1,   192,   427,
      -1,   192,   347,    -1,   101,   422,   908,   554,    -1,   101,
     250,  1000,   554,    -1,   101,   393,  1000,   554,    -1,   101,
     463,  1000,   554,    -1,   555,    -1,   554,   505,   555,    -1,
      95,   587,    -1,    95,   143,   587,    -1,   101,   782,  1131,
     556,    -1,   101,   782,  1131,   198,   314,   319,    -1,   101,
     782,  1131,   399,   314,   319,    -1,   101,   782,  1131,   399,
     411,  1012,    -1,   101,   782,  1131,   399,   559,    -1,   101,
     782,  1131,   374,   559,    -1,   101,   782,  1131,   399,   414,
    1131,    -1,   198,   782,   242,   212,  1131,   557,    -1,   198,
     782,  1131,   557,    -1,   101,   782,  1131,   783,   441,   916,
     558,    -1,    95,   596,    -1,   198,   151,   242,   212,  1002,
     557,    -1,   198,   151,  1002,   557,    -1,   399,   469,   327,
      -1,   399,   470,   327,    -1,   140,   328,  1002,    -1,   399,
     470,   140,    -1,   201,   436,  1002,    -1,   201,   102,   436,
    1002,    -1,   201,   373,   436,  1002,    -1,   201,   436,    99,
      -1,   201,   436,   451,    -1,   191,   436,  1002,    -1,   191,
     436,    99,    -1,   191,   436,   451,    -1,   201,   385,  1002,
      -1,   201,   102,   385,  1002,    -1,   201,   373,   385,  1002,
      -1,   191,   385,  1002,    -1,   252,  1000,    -1,   306,   252,
    1000,    -1,   341,   432,  1011,    -1,   399,   424,  1002,    -1,
     399,   559,    -1,   374,   559,    -1,   399,   181,   940,    -1,
     198,   181,    -1,   127,    -1,   376,    -1,    -1,   452,   940,
      -1,    -1,   502,   561,   503,    -1,   469,   559,    -1,    -1,
     562,    -1,   561,   505,   562,    -1,  1133,   489,   679,    -1,
    1133,    -1,  1133,   504,  1133,   489,   679,    -1,  1133,   504,
    1133,    -1,   139,   862,    -1,   139,    99,    -1,   156,   570,
    1000,   598,   571,   565,   566,   572,   514,   567,    -1,   156,
     866,   432,   566,   514,   567,    -1,   227,    -1,   432,    -1,
    1151,    -1,   412,    -1,   413,    -1,   568,    -1,   502,   574,
     503,    -1,   568,   569,    -1,    -1,   120,    -1,   327,    -1,
     187,   817,  1151,    -1,   319,   817,  1151,    -1,   163,    -1,
     238,    -1,   359,   817,  1151,    -1,   206,   817,  1151,    -1,
     223,   359,   599,    -1,   223,   359,   495,    -1,   223,   314,
     319,   599,    -1,   120,    -1,    -1,   469,   327,    -1,    -1,
     573,   188,  1151,    -1,    -1,   452,    -1,    -1,   575,    -1,
     574,   505,   575,    -1,  1133,   576,    -1,   541,    -1,   544,
      -1,   625,    -1,   495,    -1,   502,   577,   503,    -1,    -1,
     578,    -1,   577,   505,   578,    -1,   541,    -1,   544,    -1,
     158,   580,   422,  1000,   502,   581,   503,   609,   610,   611,
     612,    -1,   158,   580,   422,  1000,   324,   703,   582,   610,
     611,   612,    -1,   427,    -1,   425,    -1,   286,   427,    -1,
     286,   425,    -1,   231,   427,    -1,   231,   425,    -1,    -1,
     583,    -1,    -1,   502,   584,   503,    -1,    -1,   585,    -1,
     583,   505,   585,    -1,   586,    -1,   584,   505,   586,    -1,
     587,    -1,   593,    -1,   596,    -1,   588,    -1,   596,    -1,
    1131,   916,   589,    -1,  1131,   469,   332,   589,    -1,   589,
     590,    -1,    -1,   151,  1002,   591,    -1,   591,    -1,   592,
      -1,   314,   319,    -1,   319,    -1,   446,   760,   613,    -1,
     354,   272,   760,   613,    -1,   136,   502,   940,   503,    -1,
     181,   941,    -1,   366,  1000,   598,   601,   605,    -1,   183,
      -1,   314,   183,    -1,   254,   184,    -1,   254,   244,    -1,
     282,  1000,   594,    -1,   594,   248,   595,    -1,   594,   209,
     595,    -1,    -1,   182,    -1,   152,    -1,   251,    -1,   414,
      -1,   145,    -1,    99,    -1,   151,  1002,   597,    -1,   597,
      -1,   136,   502,   940,   503,   669,    -1,   446,   502,   599,
     503,   760,   613,   669,    -1,   354,   272,   502,   599,   503,
     760,   613,   669,    -1,   208,   738,   502,   602,   503,   760,
     613,   604,   669,    -1,   224,   272,   502,   599,   503,   366,
    1000,   598,   601,   605,   669,    -1,   502,   599,   503,    -1,
      -1,   600,    -1,   599,   505,   600,    -1,  1131,    -1,   293,
     228,    -1,   293,   343,    -1,   293,   404,    -1,    -1,   603,
      -1,   602,   505,   603,    -1,   740,   469,   770,    -1,   740,
     469,   330,   502,   770,   503,    -1,   466,   502,   940,   503,
      -1,    -1,   606,    -1,   607,    -1,   606,   607,    -1,   607,
     606,    -1,    -1,   328,   450,   608,    -1,   328,   186,   608,
      -1,   306,    94,    -1,   376,    -1,   127,    -1,   399,   319,
      -1,   399,   181,    -1,   253,   502,   999,   503,    -1,    -1,
     469,   559,    -1,   469,   327,    -1,   470,   327,    -1,    -1,
     328,   146,   198,    -1,   328,   146,   186,   384,    -1,   328,
     146,   351,   384,    -1,    -1,   424,  1002,    -1,    -1,   452,
     250,   424,  1002,    -1,    -1,  1000,   615,   610,   611,   612,
      -1,   502,   616,   503,    -1,    -1,   617,    -1,   616,   505,
     617,    -1,  1131,    -1,   469,   174,    -1,   469,   306,   174,
      -1,    -1,   158,   580,   393,  1000,   621,    -1,   101,   393,
    1000,   622,    -1,   622,    -1,    -1,   623,    -1,   622,   623,
      -1,   125,   625,    -1,   173,    -1,   306,   173,    -1,   249,
     624,   625,    -1,   294,   625,    -1,   296,   625,    -1,   306,
     294,    -1,   306,   296,    -1,   340,   124,   703,    -1,   409,
     514,   625,    -1,   375,    -1,   375,   514,   625,    -1,   124,
      -1,    -1,  1150,    -1,   494,  1150,    -1,  1012,    -1,   158,
     745,   627,   633,   273,   544,    -1,   158,   745,   627,   633,
     273,   544,   236,   628,   629,   631,    -1,   440,    -1,    -1,
    1002,    -1,  1002,   704,    -1,   255,   628,    -1,    -1,   455,
     628,    -1,   306,   455,    -1,   630,    -1,    -1,   198,   633,
     273,   544,   557,    -1,   198,   633,   273,   242,   212,   544,
     557,    -1,   357,    -1,    -1,   158,   424,  1002,   635,   289,
    1151,    -1,   341,  1002,    -1,    -1,   198,   424,  1002,    -1,
     198,   424,   242,   212,  1002,    -1,   158,   224,   174,   472,
    1002,   631,   640,    -1,   198,   224,   174,   472,  1002,   557,
      -1,   198,   224,   174,   472,   242,   212,  1002,   557,    -1,
     101,   224,   174,   472,  1002,   630,   642,    -1,   101,   224,
     174,   472,  1002,   630,    -1,   101,   224,   174,   472,  1002,
     642,    -1,   332,   502,   641,   503,    -1,    -1,   645,    -1,
     641,   505,   645,    -1,   332,   502,   643,   503,    -1,   644,
      -1,   643,   505,   644,    -1,   645,    -1,   399,   645,    -1,
      95,   645,    -1,   198,   646,    -1,   646,   647,    -1,  1133,
      -1,  1151,    -1,   158,   396,  1002,   649,   651,   224,   174,
     472,  1002,   640,    -1,   441,  1151,    -1,    -1,   462,  1151,
      -1,   462,   319,    -1,   650,    -1,    -1,   198,   396,  1002,
     557,    -1,   198,   396,   242,   212,  1002,   557,    -1,   101,
     396,  1002,   650,   642,    -1,   101,   396,  1002,   650,    -1,
     101,   396,  1002,   642,    -1,   158,   451,   292,   222,   655,
     396,  1002,   640,    -1,   171,    -1,   451,    -1,  1011,    -1,
     198,   451,   292,   222,   655,   396,  1002,    -1,   198,   451,
     292,   242,   212,   222,   655,   396,  1002,    -1,   101,   451,
     292,   222,   655,   396,  1002,   642,    -1,   158,   436,  1002,
     659,   660,   328,  1000,   662,   665,   211,   358,  1008,   502,
     666,   503,    -1,   158,   151,   436,  1002,    97,   660,   328,
    1000,   668,   669,   222,   199,   383,   665,   211,   358,  1008,
     502,   666,   503,    -1,   116,    -1,    97,    -1,   661,    -1,
     660,   333,   661,    -1,   260,    -1,   186,    -1,   450,    -1,
     450,   324,   599,    -1,   439,    -1,   222,   663,   664,    -1,
      -1,   199,    -1,    -1,   383,    -1,   410,    -1,   465,   502,
     940,   503,    -1,    -1,   667,    -1,   666,   505,   667,    -1,
      -1,  1010,    -1,  1150,    -1,  1151,    -1,  1149,    -1,    84,
      -1,  1131,    -1,   227,  1000,    -1,    -1,   670,    -1,   670,
     671,    -1,   671,    -1,   671,   670,    -1,    -1,   314,   183,
      -1,   183,    -1,   254,   244,    -1,   254,   184,    -1,   198,
     436,  1002,   328,  1000,   557,    -1,   198,   436,   242,   212,
    1002,   328,  1000,   557,    -1,   158,   110,  1002,   136,   502,
     940,   503,   669,    -1,   198,   110,  1002,   557,    -1,   158,
      98,  1008,   680,   676,    -1,   158,    98,  1008,   681,    -1,
     158,   330,   770,   676,    -1,   158,   441,   703,   676,    -1,
     158,   441,   703,    -1,   158,   441,   703,   108,   502,   914,
     503,    -1,   158,   441,   703,   108,   205,   502,   684,   503,
      -1,   158,   428,   389,   342,   703,   676,    -1,   158,   428,
     389,   190,   703,   676,    -1,   158,   428,   389,   426,   703,
     676,    -1,   158,   428,   389,   149,   703,   676,    -1,   502,
     677,   503,    -1,   678,    -1,   677,   505,   678,    -1,  1133,
     489,   679,    -1,  1133,    -1,   754,    -1,  1017,    -1,   966,
      -1,   625,    -1,  1151,    -1,   502,   971,   503,    -1,   502,
     495,   503,    -1,   502,   682,   503,    -1,   683,    -1,   682,
     505,   683,    -1,  1153,   489,   679,    -1,   685,    -1,    -1,
    1151,    -1,   685,   505,  1151,    -1,   158,   330,   138,   703,
     689,   222,   441,   916,   452,  1004,   690,   108,   687,    -1,
     688,    -1,   687,   505,   688,    -1,   330,  1010,   770,   691,
      -1,   330,  1010,   770,   769,   691,    -1,   229,  1010,  1008,
     746,    -1,   229,  1010,   502,   971,   503,  1008,   746,    -1,
     414,   916,    -1,   181,    -1,    -1,   217,   703,    -1,    -1,
     364,    -1,    -1,   158,   330,   217,   703,   452,  1004,    -1,
     101,   330,   217,   703,   452,  1004,    95,   687,    -1,   101,
     330,   217,   703,   452,  1004,   198,   694,    -1,   695,    -1,
     694,   505,   695,    -1,   330,  1010,   502,   971,   503,    -1,
     229,  1010,   502,   971,   503,    -1,   198,   330,   138,   703,
     452,  1004,   557,    -1,   198,   330,   138,   242,   212,   703,
     452,  1004,   557,    -1,   198,   330,   217,   703,   452,  1004,
     557,    -1,   198,   330,   217,   242,   212,   703,   452,  1004,
     557,    -1,   198,   340,   124,  1001,   557,    -1,   363,   340,
     124,  1001,   432,  1002,    -1,   198,   701,   242,   212,   702,
     557,    -1,   198,   701,   702,   557,    -1,   422,    -1,   393,
      -1,   463,    -1,   250,    -1,   441,    -1,   196,    -1,   155,
      -1,   387,    -1,   428,   389,   342,    -1,   428,   389,   190,
      -1,   428,   389,   426,    -1,   428,   389,   149,    -1,   703,
      -1,   702,   505,   703,    -1,  1131,    -1,  1131,   704,    -1,
     504,  1005,    -1,   704,   504,  1005,    -1,   439,   875,   909,
     706,   557,    -1,   154,   241,    -1,   375,   241,    -1,    -1,
     144,   328,   708,   703,   268,   709,    -1,   144,   328,    98,
    1008,   680,   268,   709,    -1,   144,   328,   229,  1008,   746,
     268,   709,    -1,   144,   328,   330,   770,   769,   268,   709,
      -1,   144,   328,   151,  1002,   328,   703,   268,   709,    -1,
     144,   328,   385,  1002,   328,   703,   268,   709,    -1,   144,
     328,   385,  1002,   268,   709,    -1,   144,   328,   436,  1002,
     328,   703,   268,   709,    -1,   144,   328,   330,   138,   703,
     452,  1004,   268,   709,    -1,   144,   328,   330,   217,   703,
     452,  1004,   268,   709,    -1,   144,   328,   274,   323,   625,
     268,   709,    -1,   144,   328,   130,   502,   916,   108,   916,
     503,   268,   709,    -1,   144,   328,   633,   273,   703,   268,
     709,    -1,   144,   328,   428,   389,   342,   703,   268,   709,
      -1,   144,   328,   428,   389,   190,   703,   268,   709,    -1,
     144,   328,   428,   389,   426,   703,   268,   709,    -1,   144,
     328,   428,   389,   149,   703,   268,   709,    -1,   143,    -1,
     175,    -1,   387,    -1,   250,    -1,   393,    -1,   422,    -1,
     196,    -1,   441,    -1,   463,    -1,   155,    -1,   424,    -1,
     381,    -1,  1151,    -1,   319,    -1,   218,   711,    -1,   299,
     711,    -1,   218,   711,  1165,    -1,   218,   225,   862,  1166,
      -1,   218,   225,   712,   862,  1166,    -1,   218,   115,   862,
    1166,    -1,   218,   115,   712,   862,  1166,    -1,   299,   225,
     862,    -1,   299,   225,   712,   862,    -1,   299,   115,   862,
      -1,   299,   115,   712,   862,    -1,   862,    -1,   712,   862,
      -1,   305,   713,   862,    -1,   355,   713,   862,    -1,   219,
     713,   862,    -1,   275,   713,   862,    -1,    92,  1012,   713,
     862,    -1,   368,  1012,   713,   862,    -1,  1012,   713,   862,
      -1,    99,   713,   862,    -1,   225,  1012,   713,   862,    -1,
     225,    99,   713,   862,    -1,   115,  1012,   713,   862,    -1,
     115,    99,   713,   862,    -1,   227,    -1,   247,    -1,   712,
      -1,    -1,   232,   716,   328,   719,   432,   720,   722,    -1,
     379,   716,   328,   719,   227,   720,   557,    -1,   379,   232,
     331,   222,   716,   328,   719,   227,   720,   557,    -1,   717,
      -1,    99,    -1,    99,   356,    -1,    99,   502,   599,   503,
      -1,    99,   356,   502,   599,   503,    -1,   718,    -1,   717,
     505,   718,    -1,   392,   598,    -1,   366,   598,    -1,   158,
     598,    -1,  1131,   598,    -1,   999,    -1,   422,   999,    -1,
     393,   999,    -1,   224,   174,   472,  1001,    -1,   224,   396,
    1001,    -1,   229,   723,    -1,   175,  1001,    -1,   273,  1001,
      -1,   274,   323,  1013,    -1,   387,  1001,    -1,   424,  1001,
      -1,    99,   423,   247,   387,  1001,    -1,    99,   394,   247,
     387,  1001,    -1,    99,   230,   247,   387,  1001,    -1,   721,
      -1,   720,   505,   721,    -1,  1011,    -1,   235,  1011,    -1,
     469,   232,   331,    -1,    -1,   724,    -1,   723,   505,   724,
      -1,  1008,   746,    -1,   232,   717,   432,  1001,   727,   728,
      -1,   379,   717,   227,  1001,   728,   557,    -1,   379,    96,
     331,   222,   717,   227,  1001,   728,   557,    -1,   469,    96,
     331,    -1,    -1,   233,   124,  1011,    -1,    -1,   101,   181,
     356,   730,   732,    -1,   730,   731,    -1,    -1,   247,   387,
    1001,    -1,   222,   381,  1001,    -1,   222,   451,  1001,    -1,
     232,   716,   328,   733,   432,   720,   722,    -1,   379,   716,
     328,   733,   227,   720,   557,    -1,   379,   232,   331,   222,
     716,   328,   733,   227,   720,   557,    -1,   423,    -1,   230,
      -1,   394,    -1,   158,   735,   250,   736,   737,   328,  1000,
     738,   502,   739,   503,   560,   612,   912,    -1,   446,    -1,
      -1,   148,    -1,    -1,  1006,    -1,    -1,   452,  1004,    -1,
      -1,   740,    -1,   739,   505,   740,    -1,  1131,   741,   742,
     743,    -1,   943,   741,   742,   743,    -1,   502,   940,   503,
     741,   742,   743,    -1,   703,    -1,   452,   703,    -1,    -1,
     109,    -1,   189,    -1,    -1,   486,    -1,   487,    -1,    -1,
     158,   745,   229,  1008,   748,   378,   753,   756,   760,    -1,
     158,   745,   229,  1008,   748,   378,   422,   502,   762,   503,
     756,   760,    -1,   158,   745,   229,  1008,   748,   756,   760,
      -1,   333,   372,    -1,    -1,   502,   747,   503,    -1,   502,
     503,    -1,   750,    -1,   747,   505,   750,    -1,   502,   749,
     503,    -1,   502,   503,    -1,   755,    -1,   749,   505,   755,
      -1,   751,   752,   754,    -1,   752,   751,   754,    -1,   752,
     754,    -1,   751,   754,    -1,   754,    -1,   247,    -1,   335,
      -1,   257,    -1,   247,   335,    -1,   459,    -1,  1132,    -1,
     754,    -1,   916,    -1,  1132,   704,   497,   441,    -1,   400,
    1132,   704,   497,   441,    -1,   750,    -1,   750,   181,   940,
      -1,   750,   489,   940,    -1,   758,    -1,   756,   758,    -1,
     126,   328,   319,   258,    -1,   378,   319,   328,   319,   258,
      -1,   415,    -1,   245,    -1,   407,    -1,   464,    -1,   214,
     391,   185,    -1,   214,   391,   267,    -1,   391,   185,    -1,
     391,   267,    -1,   157,   625,    -1,   384,   625,    -1,   546,
      -1,   108,   759,    -1,   273,   544,    -1,   468,    -1,   757,
      -1,  1151,    -1,  1151,   505,  1151,    -1,   469,   676,    -1,
      -1,   752,   754,    -1,   761,    -1,   762,   505,   761,    -1,
     101,   229,   724,   764,   765,    -1,   757,    -1,   764,   757,
      -1,   376,    -1,    -1,   198,   229,  1008,   746,   557,    -1,
     198,   229,   242,   212,  1008,   746,   557,    -1,   198,    98,
    1008,   680,   557,    -1,   198,    98,   242,   212,  1008,   680,
     557,    -1,   198,   330,   770,   769,   557,    -1,   198,   330,
     242,   212,   770,   769,   557,    -1,   502,   916,   503,    -1,
     502,   916,   505,   916,   503,    -1,   502,   312,   505,   916,
     503,    -1,   502,   916,   505,   312,   503,    -1,   963,    -1,
    1131,   504,   770,    -1,   194,   772,    -1,   773,    -1,   772,
     773,    -1,  1151,    -1,   273,   544,    -1,   158,   130,   502,
     916,   108,   916,   503,   469,   229,   724,   775,    -1,   158,
     130,   502,   916,   108,   916,   503,   470,   229,   775,    -1,
     158,   130,   502,   916,   108,   916,   503,   469,   257,   775,
      -1,   108,   246,    -1,   108,   111,    -1,    -1,   198,   130,
     777,   502,   916,   108,   916,   503,   557,    -1,   242,   212,
      -1,    -1,   367,   779,  1000,   780,    -1,   367,   421,  1002,
     780,    -1,   367,   175,  1002,   780,    -1,   250,    -1,   422,
      -1,   223,    -1,    -1,   101,    98,  1008,   680,   370,   432,
    1002,    -1,   101,   155,   703,   370,   432,  1002,    -1,   101,
     175,  1003,   370,   432,  1003,    -1,   101,   229,   724,   370,
     432,  1002,    -1,   101,   235,  1011,   370,   432,  1011,    -1,
     101,   633,   273,  1002,   370,   432,  1002,    -1,   101,   330,
     138,   703,   452,  1004,   370,   432,  1002,    -1,   101,   330,
     217,   703,   452,  1004,   370,   432,  1002,    -1,   101,   387,
    1002,   370,   432,  1002,    -1,   101,   422,   908,   370,   432,
    1002,    -1,   101,   393,  1000,   370,   432,  1002,    -1,   101,
     463,  1000,   370,   432,  1002,    -1,   101,   250,  1000,   370,
     432,  1002,    -1,   101,   422,   908,   370,   782,  1002,   432,
    1002,    -1,   101,   436,  1002,   328,  1000,   370,   432,  1002,
      -1,   101,   381,  1011,   370,   432,  1011,    -1,   101,   451,
    1011,   370,   432,  1011,    -1,   101,   424,  1002,   370,   432,
    1002,    -1,   101,   424,  1002,   399,   559,    -1,   101,   424,
    1002,   374,   559,    -1,   101,   428,   389,   342,   703,   370,
     432,  1002,    -1,   101,   428,   389,   190,   703,   370,   432,
    1002,    -1,   101,   428,   389,   426,   703,   370,   432,  1002,
      -1,   101,   428,   389,   149,   703,   370,   432,  1002,    -1,
     101,   441,   703,   370,   432,  1002,    -1,   143,    -1,    -1,
     399,   174,    -1,    -1,   101,    98,  1008,   680,   399,   387,
    1002,    -1,   101,   196,   703,   399,   387,  1002,    -1,   101,
     229,   724,   399,   387,  1002,    -1,   101,   422,   908,   399,
     387,  1002,    -1,   101,   393,  1000,   399,   387,  1002,    -1,
     101,   463,  1000,   399,   387,  1002,    -1,   101,   441,   703,
     399,   387,  1002,    -1,   101,    98,  1008,   680,   341,   432,
    1011,    -1,   101,   155,   703,   341,   432,  1011,    -1,   101,
     175,  1003,   341,   432,  1011,    -1,   101,   196,   703,   341,
     432,  1011,    -1,   101,   229,   724,   341,   432,  1011,    -1,
     101,   633,   273,  1002,   341,   432,  1011,    -1,   101,   274,
     323,  1010,   341,   432,  1011,    -1,   101,   330,   770,   769,
     341,   432,  1011,    -1,   101,   330,   138,   703,   452,  1004,
     341,   432,  1011,    -1,   101,   330,   217,   703,   452,  1004,
     341,   432,  1011,    -1,   101,   387,  1002,   341,   432,  1011,
      -1,   101,   441,   703,   341,   432,  1011,    -1,   101,   424,
    1002,   341,   432,  1011,    -1,   101,   428,   389,   190,   703,
     341,   432,  1011,    -1,   101,   428,   389,   149,   703,   341,
     432,  1011,    -1,   101,   224,   174,   472,  1002,   341,   432,
    1011,    -1,   101,   396,  1002,   341,   432,  1011,    -1,   158,
     745,   385,  1002,   108,   328,   791,   432,  1000,   912,   194,
     792,   787,    -1,   315,    -1,   789,    -1,   502,   788,   503,
      -1,   788,   506,   790,    -1,   790,    -1,   865,    -1,   843,
      -1,   854,    -1,   848,    -1,   794,    -1,   789,    -1,    -1,
     392,    -1,   450,    -1,   186,    -1,   260,    -1,   261,    -1,
     100,    -1,    -1,   198,   385,  1002,   328,  1000,   557,    -1,
     198,   385,   242,   212,  1002,   328,  1000,   557,    -1,   316,
    1131,   795,    -1,   505,  1151,    -1,    -1,   284,  1131,    -1,
     448,  1131,    -1,   448,   495,    -1,    91,   799,    -1,   117,
     799,   802,    -1,   409,   434,   802,    -1,   146,   799,    -1,
     204,   799,    -1,   382,   799,    -1,   386,  1131,    -1,   369,
     386,  1131,    -1,   369,  1131,    -1,   382,   799,   432,   386,
    1131,    -1,   382,   799,   432,  1131,    -1,   352,   434,  1151,
      -1,   146,   353,  1151,    -1,   382,   353,  1151,    -1,   471,
      -1,   434,    -1,    -1,   270,   281,   540,    -1,   361,   329,
      -1,   361,   473,    -1,   800,    -1,   801,   505,   800,    -1,
     801,   800,    -1,   801,    -1,    -1,   158,   580,   463,  1000,
     598,   108,   865,   804,    -1,   158,   333,   372,   580,   463,
    1000,   598,   108,   865,   804,    -1,   469,   136,   331,    -1,
     469,   128,   136,   331,    -1,   469,   286,   136,   331,    -1,
      -1,   285,  1007,    -1,   158,   175,  1003,   514,   807,    -1,
     807,   808,    -1,    -1,   424,   809,  1002,    -1,   424,   809,
     181,    -1,   289,   809,  1151,    -1,   289,   809,   181,    -1,
     426,   809,  1002,    -1,   426,   809,   181,    -1,   202,   809,
    1151,    -1,   202,   809,  1010,    -1,   202,   809,   181,    -1,
     276,   809,  1151,    -1,   276,   809,   181,    -1,   277,   809,
    1151,    -1,   277,   809,   181,    -1,   150,   283,   809,  1012,
      -1,   341,   809,  1002,    -1,   341,   809,   181,    -1,   489,
      -1,    -1,   101,   175,  1003,   514,   812,    -1,   101,   175,
    1003,   399,   424,  1002,    -1,   101,   175,  1003,   546,    -1,
     812,   813,    -1,    -1,   150,   283,   809,  1012,    -1,   198,
     175,  1003,    -1,   198,   175,   242,   212,  1003,    -1,   158,
     196,   703,   817,   916,   589,    -1,   101,   196,   703,   556,
      -1,   101,   196,   703,   198,   314,   319,    -1,   101,   196,
     703,   399,   314,   319,    -1,   101,   196,   703,    95,   596,
      -1,   101,   196,   703,   198,   151,  1002,   557,    -1,   108,
      -1,    -1,   101,   428,   389,   190,   703,   676,    -1,   101,
     428,   389,   149,   703,    95,   292,   222,  1001,   469,   702,
      -1,   101,   428,   389,   149,   703,   101,   292,   222,  1001,
     469,   702,    -1,   101,   428,   389,   149,   703,   101,   292,
     372,   703,   469,   703,    -1,   101,   428,   389,   149,   703,
     101,   292,   222,  1001,   372,   703,   469,   703,    -1,   101,
     428,   389,   149,   703,   198,   292,   222,  1001,    -1,   101,
     428,   389,   149,   703,   198,   292,   242,   212,   222,  1001,
      -1,   158,   689,   155,   703,   222,  1151,   432,  1151,   227,
     703,    -1,   140,   828,  1000,   822,    -1,   140,   828,    -1,
     140,   828,  1006,   328,  1000,    -1,   452,  1006,    -1,    -1,
     453,   829,   830,   828,    -1,   453,   829,   830,   828,  1000,
      -1,   453,   829,   830,   828,   826,    -1,   453,   502,   824,
     503,    -1,   453,   502,   824,   503,  1000,   831,    -1,   825,
      -1,   824,   505,   825,    -1,   827,    -1,   461,    -1,   226,
      -1,   228,    -1,   827,   828,    -1,   827,   828,  1000,   831,
      -1,   104,    -1,   103,    -1,   461,    -1,    -1,   228,    -1,
      -1,   226,    -1,    -1,   502,  1001,   503,    -1,    -1,   213,
     833,    -1,   213,   827,   828,   833,    -1,   213,   461,   833,
      -1,   213,   502,   834,   503,   833,    -1,   865,    -1,   843,
      -1,   854,    -1,   848,    -1,   861,    -1,  1020,    -1,   841,
      -1,   835,    -1,   834,   505,   835,    -1,   836,   837,    -1,
    1131,    -1,   827,    -1,   461,    -1,   541,    -1,   544,    -1,
     625,    -1,    -1,   352,  1039,   839,   108,   840,    -1,   352,
    1039,   227,  1084,    -1,   502,   971,   503,    -1,    -1,   865,
      -1,   843,    -1,   854,    -1,   848,    -1,   211,  1039,   842,
    1163,    -1,   158,   580,   422,   614,   108,   211,  1039,   842,
      -1,   502,   968,   503,    -1,    -1,   260,   266,  1000,   844,
     847,    -1,   865,    -1,   502,   845,   503,   865,    -1,   181,
     457,    -1,   846,    -1,   845,   505,   846,    -1,  1131,   992,
      -1,   377,   997,    -1,    -1,   186,   227,   910,   849,   913,
     847,    -1,   452,   901,    -1,    -1,   290,   875,   909,   851,
     853,    -1,   247,   852,   297,    -1,    -1,    93,   401,    -1,
     383,   401,    -1,   383,   210,    -1,   401,   450,   210,    -1,
     401,    -1,   401,   383,   210,    -1,   210,    -1,    93,   210,
      -1,   318,    -1,    -1,   450,   910,   399,   855,   900,   913,
     847,    -1,   856,    -1,   855,   505,   856,    -1,   857,    -1,
     858,    -1,   859,   489,   994,    -1,   502,   860,   503,   489,
     996,    -1,  1131,   992,    -1,   859,    -1,   860,   505,   859,
      -1,   180,   862,   863,   172,   864,   222,   865,    -1,  1002,
      -1,  1144,    -1,    -1,   863,   306,   388,    -1,   863,   388,
      -1,   863,   120,    -1,   863,   259,    -1,    -1,   469,   239,
      -1,   470,   239,    -1,   867,    -1,   866,    -1,   502,   867,
     503,    -1,   502,   866,   503,    -1,   869,    -1,   868,   879,
      -1,   868,   878,   894,   883,    -1,   868,   878,   882,   895,
      -1,   870,   868,    -1,   870,   868,   879,    -1,   870,   868,
     878,   894,   883,    -1,   870,   868,   878,   882,   895,    -1,
     869,    -1,   866,    -1,   392,   877,   997,   873,   900,   912,
     892,   893,   951,    -1,   899,    -1,   422,   908,    -1,   868,
     445,   876,   868,    -1,   868,   264,   876,   868,    -1,   868,
     207,   876,   868,    -1,   469,   871,    -1,   469,   365,   871,
      -1,   872,    -1,   871,   505,   872,    -1,  1002,   831,   108,
     866,    -1,   266,   874,    -1,  1164,    -1,    -1,   427,   875,
    1000,    -1,   425,   875,  1000,    -1,   286,   427,   875,  1000,
      -1,   286,   425,   875,  1000,    -1,   231,   427,   875,  1000,
      -1,   231,   425,   875,  1000,    -1,   422,  1000,    -1,  1000,
      -1,   422,    -1,    -1,    99,    -1,   193,    -1,    -1,   193,
      -1,   193,   328,   502,   968,   503,    -1,    99,    -1,    -1,
     879,    -1,    -1,   334,   124,   880,    -1,   881,    -1,   880,
     505,   881,    -1,   940,   452,   966,   743,    -1,   940,   742,
     743,    -1,   884,   885,    -1,   885,   884,    -1,   884,    -1,
     885,    -1,   882,    -1,    -1,   283,   886,    -1,   283,   886,
     505,   887,    -1,   218,   891,   888,   890,   329,    -1,   326,
     887,    -1,   326,   889,   890,    -1,   940,    -1,    99,    -1,
     940,    -1,  1012,    -1,   502,   940,   503,    -1,    -1,   942,
      -1,   383,    -1,   384,    -1,   219,    -1,   305,    -1,   235,
     124,   968,    -1,    -1,   237,   940,    -1,    -1,   896,    -1,
     222,   361,   329,    -1,   894,    -1,    -1,   897,    -1,   896,
     897,    -1,   222,   450,   898,   853,    -1,   222,   401,   898,
     853,    -1,   324,   999,    -1,    -1,   457,   996,    -1,   899,
     505,   996,    -1,   227,   901,    -1,    -1,   902,    -1,   901,
     505,   902,    -1,   908,    -1,   908,   904,    -1,   911,    -1,
     911,   904,    -1,   911,   108,   502,   914,   503,    -1,   911,
     108,  1131,   502,   914,   503,    -1,   911,  1131,   502,   914,
     503,    -1,   866,    -1,   866,   904,    -1,   903,    -1,   502,
     903,   503,   904,    -1,   502,   903,   503,    -1,   902,   162,
     271,   902,    -1,   902,   905,   271,   902,   907,    -1,   902,
     271,   902,   907,    -1,   902,   303,   905,   271,   902,    -1,
     902,   303,   271,   902,    -1,   108,  1131,   502,  1001,   503,
      -1,   108,  1131,    -1,  1131,   502,  1001,   503,    -1,  1131,
      -1,   228,   906,    -1,   280,   906,    -1,   380,   906,    -1,
     256,    -1,   336,    -1,    -1,   452,   502,  1001,   503,    -1,
     328,   940,    -1,  1000,    -1,  1000,   495,    -1,   329,  1000,
      -1,   329,   502,  1000,   503,    -1,   908,    -1,   909,   505,
     908,    -1,   908,    -1,   908,  1131,    -1,   908,   108,  1131,
      -1,   943,    -1,   466,   940,    -1,    -1,   466,   940,    -1,
     466,   164,   324,  1002,    -1,    -1,   915,    -1,   914,   505,
     915,    -1,  1131,   916,    -1,   918,   917,    -1,   400,   918,
     917,    -1,   918,   107,   500,  1010,   501,    -1,   400,   918,
     107,   500,  1010,   501,    -1,   918,   107,    -1,   400,   918,
     107,    -1,   917,   500,   501,    -1,   917,   500,  1162,   501,
      -1,    -1,   920,    -1,   922,    -1,   924,    -1,   928,    -1,
     935,    -1,   936,   938,    -1,   936,   502,  1010,   503,   938,
      -1,   922,    -1,   925,    -1,   929,    -1,   935,    -1,  1132,
     921,    -1,  1132,   704,   921,    -1,   502,   968,   503,    -1,
      -1,   262,    -1,   263,    -1,   405,    -1,   119,    -1,   362,
      -1,   220,   923,    -1,   197,   350,    -1,   179,   921,    -1,
     178,   921,    -1,   322,   921,    -1,   122,    -1,   502,  1010,
     503,    -1,    -1,   926,    -1,   927,    -1,   926,    -1,   927,
      -1,   121,   933,   502,   968,   503,    -1,   121,   933,    -1,
     930,    -1,   931,    -1,   930,    -1,   931,    -1,   932,   502,
    1010,   503,   934,    -1,   932,   934,    -1,   134,   933,    -1,
     133,   933,    -1,   458,    -1,   302,   134,   933,    -1,   302,
     133,   933,    -1,   304,   933,    -1,   460,    -1,    -1,   134,
     399,  1131,    -1,    -1,   431,   502,  1010,   503,   937,    -1,
     431,   937,    -1,   430,   502,  1010,   503,   937,    -1,   430,
     937,    -1,   265,    -1,   488,   485,    -1,   470,   430,   485,
      -1,    -1,   483,    -1,   298,    -1,   176,    -1,   240,    -1,
     295,    -1,   939,    -1,   483,   432,   298,    -1,   176,   432,
     240,    -1,   176,   432,   295,    -1,   176,   432,   939,    -1,
     240,   432,   295,    -1,   240,   432,   939,    -1,   295,   432,
     939,    -1,    -1,   390,    -1,   390,   502,  1010,   503,    -1,
     942,    -1,   940,    88,   916,    -1,   940,   113,   430,   485,
     940,    -1,   493,   940,    -1,   494,   940,    -1,   940,   493,
     940,    -1,   940,   494,   940,    -1,   940,   495,   940,    -1,
     940,   496,   940,    -1,   940,   497,   940,    -1,   940,   498,
     940,    -1,   940,   490,   940,    -1,   940,   491,   940,    -1,
     940,   489,   940,    -1,   940,   965,   940,    -1,   965,   940,
      -1,   940,   965,    -1,   940,   105,   940,    -1,   940,   333,
     940,    -1,   314,   940,    -1,   940,   282,   940,    -1,   940,
     282,   940,   206,   940,    -1,   940,   314,   282,   940,    -1,
     940,   314,   282,   940,   206,   940,    -1,   940,   243,   940,
      -1,   940,   243,   940,   206,   940,    -1,   940,   314,   243,
     940,    -1,   940,   314,   243,   940,   206,   940,    -1,   940,
     403,   432,   940,    -1,   940,   403,   432,   940,   206,   940,
      -1,   940,   314,   403,   432,   940,    -1,   940,   314,   403,
     432,   940,   206,   940,    -1,   940,   268,   319,    -1,   940,
     269,    -1,   940,   268,   314,   319,    -1,   940,   317,    -1,
     961,   338,   961,    -1,   940,   268,   438,    -1,   940,   268,
     314,   438,    -1,   940,   268,   216,    -1,   940,   268,   314,
     216,    -1,   940,   268,   447,    -1,   940,   268,   314,   447,
      -1,   940,   268,   193,   227,   940,    -1,   940,   268,   314,
     193,   227,   940,    -1,   940,   268,   324,   502,   971,   503,
      -1,   940,   268,   314,   324,   502,   971,   503,    -1,   940,
     118,   993,   941,   105,   941,    -1,   940,   314,   118,   993,
     941,   105,   941,    -1,   940,   118,   419,   941,   105,   941,
      -1,   940,   314,   118,   419,   941,   105,   941,    -1,   940,
     247,   983,    -1,   940,   314,   247,   983,    -1,   940,   967,
     962,   866,    -1,   940,   967,   962,   502,   940,   503,    -1,
     446,   866,    -1,   940,   268,   195,    -1,   940,   268,   314,
     195,    -1,   942,    -1,   941,    88,   916,    -1,   493,   941,
      -1,   494,   941,    -1,   941,   493,   941,    -1,   941,   494,
     941,    -1,   941,   495,   941,    -1,   941,   496,   941,    -1,
     941,   497,   941,    -1,   941,   498,   941,    -1,   941,   490,
     941,    -1,   941,   491,   941,    -1,   941,   489,   941,    -1,
     941,   965,   941,    -1,   965,   941,    -1,   941,   965,    -1,
     941,   268,   193,   227,   941,    -1,   941,   268,   314,   193,
     227,   941,    -1,   941,   268,   324,   502,   971,   503,    -1,
     941,   268,   314,   324,   502,   971,   503,    -1,   941,   268,
     195,    -1,   941,   268,   314,   195,    -1,   989,    -1,  1009,
      -1,  1148,   992,    -1,   502,   940,   503,   992,    -1,   984,
      -1,   943,    -1,   866,    -1,   212,   866,    -1,   107,   866,
      -1,   107,   972,    -1,   961,    -1,  1008,   502,   503,   954,
      -1,  1008,   502,   969,   503,   954,    -1,  1008,   502,   459,
     970,   503,   954,    -1,  1008,   502,   969,   505,   459,   970,
     503,   954,    -1,  1008,   502,   969,   879,   503,   954,    -1,
    1008,   502,    99,   969,   878,   503,   954,    -1,  1008,   502,
     193,   969,   878,   503,   954,    -1,  1008,   502,   495,   503,
     954,    -1,   166,    -1,   169,    -1,   169,   502,  1010,   503,
      -1,   170,    -1,   170,   502,  1010,   503,    -1,   287,    -1,
     287,   502,  1010,   503,    -1,   288,    -1,   288,   502,  1010,
     503,    -1,   167,    -1,   171,    -1,   398,    -1,   451,    -1,
     165,    -1,   168,    -1,   130,   502,   940,   108,   916,   503,
      -1,   215,   502,   974,   503,    -1,   339,   502,   976,   503,
      -1,   348,   502,   978,   503,    -1,   417,   502,   979,   503,
      -1,   435,   502,   940,   108,   916,   503,    -1,   437,   502,
     123,   982,   503,    -1,   437,   502,   278,   982,   503,    -1,
     437,   502,   433,   982,   503,    -1,   437,   502,   982,   503,
      -1,   320,   502,   940,   505,   940,   503,    -1,   141,   502,
     968,   503,    -1,   234,   502,   968,   503,    -1,   279,   502,
     968,   503,    -1,   476,   502,   968,   503,    -1,   477,   502,
     300,  1133,   503,    -1,   477,   502,   300,  1133,   505,   946,
     503,    -1,   477,   502,   300,  1133,   505,   968,   503,    -1,
     477,   502,   300,  1133,   505,   946,   505,   968,   503,    -1,
     478,   502,   947,   503,    -1,   479,   502,   949,   940,   950,
     503,    -1,   480,   502,   300,  1133,   503,    -1,   480,   502,
     300,  1133,   505,   940,   503,    -1,   481,   502,   940,   505,
     944,   945,   503,    -1,   482,   502,   949,   940,   108,   918,
     503,    -1,   462,   940,    -1,   462,   306,   456,    -1,   505,
     408,   484,    -1,   505,   408,   306,    -1,   505,   408,   306,
     456,    -1,    -1,   475,   502,   947,   503,    -1,   948,    -1,
     947,   505,   948,    -1,   940,   108,  1133,    -1,   940,    -1,
     195,    -1,   153,    -1,   351,   467,    -1,   416,   467,    -1,
      -1,   468,   952,    -1,    -1,   953,    -1,   952,   505,   953,
      -1,  1131,   108,   955,    -1,   337,   955,    -1,   337,  1131,
      -1,    -1,   502,   956,   957,   878,   958,   503,    -1,  1131,
      -1,    -1,   344,   124,   968,    -1,    -1,   360,   959,    -1,
     384,   959,    -1,    -1,   960,    -1,   118,   960,   105,   960,
      -1,   442,   349,    -1,   442,   221,    -1,   164,   383,    -1,
     940,   349,    -1,   940,   221,    -1,   383,   502,   968,   503,
      -1,   383,   502,   503,    -1,   502,   968,   505,   940,   503,
      -1,   106,    -1,   406,    -1,    99,    -1,    85,    -1,   964,
      -1,   493,    -1,   494,    -1,   495,    -1,   496,    -1,   497,
      -1,   498,    -1,   490,    -1,   491,    -1,   489,    -1,    85,
      -1,   330,   502,   770,   503,    -1,   963,    -1,   330,   502,
     770,   503,    -1,   963,    -1,   330,   502,   770,   503,    -1,
     282,    -1,   314,   282,    -1,   243,    -1,   314,   243,    -1,
     940,    -1,   968,   505,   940,    -1,   970,    -1,   969,   505,
     970,    -1,   940,    -1,   940,   108,   752,    -1,   916,    -1,
     971,   505,   916,    -1,   500,   968,   501,    -1,   500,   973,
     501,    -1,   500,   501,    -1,   972,    -1,   973,   505,   972,
      -1,   975,   227,   940,    -1,    -1,  1153,    -1,   483,    -1,
     298,    -1,   176,    -1,   240,    -1,   295,    -1,   390,    -1,
    1151,    -1,   940,   977,   980,   981,    -1,   940,   977,   980,
      -1,   346,   940,    -1,   941,   247,   941,    -1,    -1,   940,
     980,   981,    -1,   940,   981,   980,    -1,   940,   980,    -1,
     940,   981,    -1,   968,    -1,    -1,   227,   940,    -1,   222,
     940,    -1,   940,   227,   968,    -1,   227,   968,    -1,   968,
      -1,   866,    -1,   502,   968,   503,    -1,   129,   988,   985,
     987,   204,    -1,   986,    -1,   985,   986,    -1,   465,   940,
     429,   940,    -1,   200,   940,    -1,    -1,   940,    -1,    -1,
    1131,    -1,  1131,   991,    -1,   504,  1005,    -1,   504,   495,
      -1,   500,   940,   501,    -1,   500,   940,   507,   940,   501,
      -1,   990,    -1,   991,   990,    -1,    -1,   992,   990,    -1,
     112,    -1,    -1,   940,    -1,   181,    -1,   994,    -1,   995,
     505,   994,    -1,   502,   995,   503,    -1,   998,    -1,   997,
     505,   998,    -1,   940,   108,  1133,    -1,   940,  1153,    -1,
     940,    -1,   495,    -1,  1000,    -1,   999,   505,  1000,    -1,
    1131,    -1,  1131,   991,    -1,  1002,    -1,  1001,   505,  1002,
      -1,  1131,    -1,  1131,    -1,  1131,    -1,  1133,    -1,  1131,
      -1,  1151,    -1,  1132,    -1,  1131,   991,    -1,  1010,    -1,
    1150,    -1,  1151,    -1,  1149,    -1,    84,    -1,  1008,  1151,
      -1,  1008,   502,   969,   503,  1151,    -1,   919,  1151,    -1,
     936,  1151,   938,    -1,   936,   502,  1010,   503,  1151,   938,
      -1,   438,    -1,   216,    -1,   319,    -1,  1145,    -1,  1143,
      -1,    86,    -1,  1131,    -1,  1010,    -1,  1145,    -1,   493,
    1010,    -1,   494,  1010,    -1,  1010,    -1,  1013,   505,  1010,
      -1,    91,    -1,    92,    -1,    93,    -1,    94,    -1,    95,
      -1,    96,    -1,    97,    -1,    98,    -1,   100,    -1,   101,
      -1,   102,    -1,   110,    -1,   111,    -1,   113,    -1,   115,
      -1,   116,    -1,   117,    -1,   124,    -1,   125,    -1,   126,
      -1,   127,    -1,   128,    -1,   131,    -1,   132,    -1,   135,
      -1,   137,    -1,   138,    -1,   139,    -1,   140,    -1,   144,
      -1,   145,    -1,   146,    -1,   147,    -1,   149,    -1,   152,
      -1,   153,    -1,   154,    -1,   155,    -1,   156,    -1,   157,
      -1,   159,    -1,   160,    -1,   161,    -1,   163,    -1,   172,
      -1,   173,    -1,   174,    -1,   175,    -1,   177,    -1,   180,
      -1,   182,    -1,   184,    -1,   185,    -1,   186,    -1,   187,
      -1,   188,    -1,   190,    -1,   191,    -1,   192,    -1,   195,
      -1,   196,    -1,   197,    -1,   198,    -1,   199,    -1,   201,
      -1,   202,    -1,   203,    -1,   205,    -1,   206,    -1,   208,
      -1,   209,    -1,   210,    -1,   211,    -1,   213,    -1,   214,
      -1,   217,    -1,   219,    -1,   221,    -1,   223,    -1,   225,
      -1,   229,    -1,   230,    -1,   231,    -1,   233,    -1,   236,
      -1,   238,    -1,   239,    -1,   241,    -1,   242,    -1,   244,
      -1,   245,    -1,   246,    -1,   248,    -1,   249,    -1,   250,
      -1,   251,    -1,   252,    -1,   253,    -1,   255,    -1,   259,
      -1,   260,    -1,   261,    -1,   267,    -1,   270,    -1,   272,
      -1,   273,    -1,   274,    -1,   275,    -1,   276,    -1,   277,
      -1,   281,    -1,   284,    -1,   285,    -1,   286,    -1,   289,
      -1,   290,    -1,   291,    -1,   292,    -1,   293,    -1,   294,
      -1,   296,    -1,   297,    -1,   299,    -1,   300,    -1,   301,
      -1,   305,    -1,   306,    -1,   307,    -1,   308,    -1,   309,
      -1,   310,    -1,   311,    -1,   313,    -1,   315,    -1,   316,
      -1,   318,    -1,   321,    -1,   323,    -1,   324,    -1,   327,
      -1,   330,    -1,   331,    -1,   332,    -1,   340,    -1,   341,
      -1,   342,    -1,   343,    -1,   344,    -1,   345,    -1,   347,
      -1,   349,    -1,   352,    -1,   353,    -1,   351,    -1,   355,
      -1,   356,    -1,   357,    -1,   358,    -1,   359,    -1,   360,
      -1,   361,    -1,   363,    -1,   364,    -1,   365,    -1,   367,
      -1,   368,    -1,   369,    -1,   370,    -1,   371,    -1,   372,
      -1,   373,    -1,   374,    -1,   375,    -1,   376,    -1,   378,
      -1,   379,    -1,   381,    -1,   382,    -1,   384,    -1,   385,
      -1,   386,    -1,   387,    -1,   388,    -1,   389,    -1,   391,
      -1,   393,    -1,   394,    -1,   395,    -1,   396,    -1,   397,
      -1,   399,    -1,   401,    -1,   402,    -1,   404,    -1,   407,
      -1,   408,    -1,   409,    -1,   410,    -1,   411,    -1,   412,
      -1,   413,    -1,   414,    -1,   415,    -1,   416,    -1,   418,
      -1,   420,    -1,   421,    -1,   423,    -1,   424,    -1,   425,
      -1,   426,    -1,   427,    -1,   428,    -1,   434,    -1,   436,
      -1,   439,    -1,   440,    -1,   441,    -1,   442,    -1,   443,
      -1,   444,    -1,   447,    -1,   448,    -1,   449,    -1,   450,
      -1,   453,    -1,   454,    -1,   455,    -1,   456,    -1,   460,
      -1,   462,    -1,   463,    -1,   464,    -1,   467,    -1,   470,
      -1,   471,    -1,   472,    -1,   473,    -1,   474,    -1,   484,
      -1,   485,    -1,   118,    -1,   119,    -1,   121,    -1,   122,
      -1,   134,    -1,   141,    -1,   178,    -1,   179,    -1,   212,
      -1,   215,    -1,   220,    -1,   234,    -1,   257,    -1,   263,
      -1,   265,    -1,   279,    -1,   302,    -1,   304,    -1,   312,
      -1,   320,    -1,   322,    -1,   335,    -1,   339,    -1,   348,
      -1,   350,    -1,   362,    -1,   383,    -1,   400,    -1,   405,
      -1,   417,    -1,   430,    -1,   431,    -1,   435,    -1,   437,
      -1,   458,    -1,   475,    -1,   476,    -1,   477,    -1,   478,
      -1,   479,    -1,   480,    -1,   481,    -1,   482,    -1,   114,
      -1,   120,    -1,   148,    -1,   162,    -1,   168,    -1,   226,
      -1,   228,    -1,   243,    -1,   256,    -1,   268,    -1,   269,
      -1,   271,    -1,   280,    -1,   282,    -1,   303,    -1,   317,
      -1,   336,    -1,   337,    -1,   338,    -1,   380,    -1,   403,
      -1,   461,    -1,    99,    -1,   103,    -1,   104,    -1,   105,
      -1,   106,    -1,   107,    -1,   108,    -1,   109,    -1,   112,
      -1,   123,    -1,   129,    -1,   130,    -1,   136,    -1,   142,
      -1,   143,    -1,   151,    -1,   158,    -1,   165,    -1,   166,
      -1,   167,    -1,   169,    -1,   170,    -1,   171,    -1,   181,
      -1,   183,    -1,   189,    -1,   193,    -1,   194,    -1,   200,
      -1,   204,    -1,   207,    -1,   216,    -1,   218,    -1,   222,
      -1,   224,    -1,   227,    -1,   232,    -1,   235,    -1,   237,
      -1,   247,    -1,   254,    -1,   264,    -1,   266,    -1,   278,
      -1,   283,    -1,   287,    -1,   288,    -1,   314,    -1,   319,
      -1,   325,    -1,   326,    -1,   328,    -1,   329,    -1,   333,
      -1,   334,    -1,   346,    -1,   354,    -1,   366,    -1,   377,
      -1,   392,    -1,   398,    -1,   406,    -1,   419,    -1,   422,
      -1,   429,    -1,   433,    -1,   438,    -1,   446,    -1,   451,
      -1,   452,    -1,   459,    -1,   465,    -1,   466,    -1,   468,
      -1,   469,    -1,    -1,  1018,  1019,    -1,  1140,  1022,   512,
     506,    -1,  1140,   512,   506,    -1,  1140,  1042,    -1,  1047,
      -1,  1159,    -1,    73,    -1,   508,    -1,   509,    -1,    -1,
     158,   580,   422,   614,   108,  1021,   865,   618,    -1,   113,
    1083,    -1,     9,   432,  1024,  1031,  1032,    -1,     9,   432,
     181,    -1,     9,  1033,    -1,   175,  1024,    -1,  1025,  1028,
    1030,    -1,  1026,   507,  1027,  1030,   496,  1025,  1036,    -1,
    1035,    -1,  1151,    -1,  1003,    -1,    -1,  1153,  1147,    -1,
      85,  1029,    -1,  1027,    -1,    -1,  1131,    -1,  1131,   504,
    1029,    -1,    74,    -1,   507,  1010,    -1,    -1,   108,  1083,
      -1,    -1,   451,  1033,    -1,    -1,  1034,    -1,  1034,   496,
    1034,    -1,  1034,    21,   124,  1034,    -1,  1034,   452,  1034,
      -1,  1011,    -1,  1151,    -1,  1145,    -1,  1147,    -1,    85,
    1037,    -1,    -1,  1131,  1038,    -1,  1131,  1038,    85,  1037,
      -1,    -1,   489,  1010,    -1,   489,  1153,    -1,   489,  1145,
      -1,  1002,    -1,  1035,    -1,   180,   862,   863,   172,   864,
     222,  1039,    -1,   211,   244,  1084,    -1,  1043,    -1,  1054,
      -1,  1056,    -1,   625,    -1,   505,   625,    -1,    -1,   938,
      -1,   483,   432,   295,    -1,   483,   432,   390,    -1,   176,
     432,   176,    -1,   298,   432,   298,    -1,    -1,  1049,  1048,
    1051,  1050,    -1,  1140,   117,   180,    34,   506,    -1,  1140,
     204,   180,    34,   506,    -1,    -1,  1052,    -1,  1043,    -1,
      73,    -1,  1052,  1043,    -1,  1052,    73,    -1,  1056,    -1,
    1053,  1056,    -1,    -1,    70,  1055,  1063,  1079,  1135,   917,
     506,    -1,    -1,  1060,  1063,  1057,  1076,   506,    -1,    -1,
    1063,  1058,  1076,   506,    -1,  1066,   506,    -1,   507,  1010,
      -1,    -1,  1061,  1062,    -1,  1061,    -1,  1062,    -1,    56,
      -1,    67,    -1,    65,    -1,    50,    -1,    51,    -1,    69,
      -1,  1072,    -1,  1068,    -1,  1064,    -1,  1135,   502,  1044,
    1045,   503,    -1,  1135,  1046,    -1,  1070,    -1,   205,  1129,
    1065,    -1,   205,  1065,    -1,   205,  1129,    -1,   508,  1157,
     509,    -1,    -1,  1070,  1067,   508,  1053,   509,    -1,  1066,
      -1,    -1,  1071,  1069,   508,  1053,   509,    -1,    43,  1129,
      -1,   445,  1129,    -1,    43,    -1,   445,    -1,  1073,    -1,
    1075,  1074,    -1,    44,    35,    -1,    44,    35,   262,    -1,
      44,    -1,    44,   262,    -1,    44,    25,    -1,    44,    25,
     262,    -1,    44,    25,    25,    -1,    44,    25,    25,   262,
      -1,    44,   133,    -1,    35,    -1,    35,   262,    -1,   262,
      -1,    25,    -1,    25,   262,    -1,    25,    25,    -1,    25,
      25,   262,    -1,     5,    -1,   133,    -1,   197,    -1,    36,
      -1,    -1,  1077,    -1,  1076,   505,  1077,    -1,  1079,  1134,
     917,  1059,  1078,    -1,    -1,   489,  1158,    -1,    -1,   495,
      -1,   495,   495,    -1,   180,   410,  1153,    -1,    15,  1082,
      -1,  1083,    -1,   164,    -1,    99,    -1,    -1,  1003,    -1,
     181,    -1,  1035,    -1,  1035,    -1,    71,    -1,    17,   862,
      -1,    17,    99,    -1,    28,   862,  1087,    -1,    -1,  1088,
      -1,   452,  1092,    -1,  1089,    -1,   452,    37,    14,  1154,
      -1,   452,    14,  1002,    -1,   266,    37,    14,  1154,    -1,
     266,    14,  1002,    -1,   266,  1002,    -1,  1093,    -1,  1093,
     505,  1092,    -1,  1094,    -1,  1145,    -1,  1143,    -1,  1010,
      -1,   493,  1010,    -1,   494,  1010,    -1,  1150,    -1,   493,
    1150,    -1,   494,  1150,    -1,  1151,    -1,  1149,    -1,  1152,
      -1,    13,   258,  1039,  1089,    -1,    13,  1096,  1039,  1089,
      -1,    13,  1096,  1039,  1090,    -1,    13,   258,  1039,  1091,
      -1,    13,  1096,  1039,  1091,    -1,    29,    -1,    -1,     3,
      14,  1154,    -1,   177,    14,  1154,    -1,    18,    14,  1154,
    1100,    -1,  1101,    -1,  1100,   505,  1101,    -1,  1147,   489,
    1106,    -1,   399,    14,  1154,  1103,    -1,  1104,    -1,  1103,
     505,  1104,    -1,  1106,   489,  1105,    -1,  1010,    -1,  1147,
      -1,    10,    -1,    18,    14,  1154,   456,  1105,  1108,    -1,
    1109,    -1,  1108,   505,  1109,    -1,  1147,   489,  1114,    -1,
     399,    14,  1154,   456,  1105,  1111,    -1,  1112,    -1,  1111,
     505,  1112,    -1,  1114,   489,  1113,    -1,  1150,    -1,  1105,
      -1,   494,  1150,    -1,   494,  1010,    -1,  1151,    -1,     8,
      -1,   174,    -1,    11,    -1,    12,    -1,    22,    -1,    23,
      -1,    24,    -1,   300,    -1,    26,    -1,    27,    -1,   350,
      -1,    31,    -1,    32,    -1,    33,    -1,   441,    -1,   399,
       4,   489,  1116,    -1,   399,     4,   432,  1116,    -1,   328,
      -1,   325,    -1,   399,   150,   432,  1083,    -1,   399,   150,
     489,  1083,    -1,   399,   150,  1083,    -1,    -1,   441,  1119,
    1135,   268,  1063,   917,  1120,    -1,    30,    -1,    -1,    -1,
      45,  1122,  1133,   268,  1063,   917,  1120,    -1,    46,    38,
    1124,    -1,    46,   314,    16,  1124,    -1,    46,    40,  1124,
      -1,   154,    -1,    39,    -1,    42,    -1,    20,  1002,    -1,
      19,   432,  1002,    -1,   194,  1002,   502,  1141,   503,    -1,
     194,     6,    -1,     7,  1002,   502,  1141,   503,    -1,     7,
    1002,    -1,  1126,    -1,  1127,    -1,     6,    -1,     7,    -1,
       8,    -1,    10,    -1,    11,    -1,    12,    -1,    16,    -1,
      19,    -1,    20,    -1,    21,    -1,    22,    -1,    23,    -1,
      24,    -1,    26,    -1,    27,    -1,    31,    -1,    32,    -1,
      33,    -1,    34,    -1,    37,    -1,    38,    -1,    39,    -1,
      40,    -1,    42,    -1,     9,    -1,    13,    -1,    15,    -1,
      28,    -1,    45,    -1,    46,    -1,     5,    -1,    25,    -1,
      29,    -1,    35,    -1,    43,    -1,    36,    -1,    44,    -1,
    1133,    -1,  1153,    -1,  1014,    -1,  1015,    -1,  1138,    -1,
    1125,    -1,  1136,    -1,   133,    -1,   457,    -1,  1153,    -1,
    1137,    -1,  1015,    -1,  1125,    -1,  1136,    -1,   133,    -1,
     457,    -1,  1153,    -1,  1137,    -1,  1016,    -1,  1125,    -1,
    1136,    -1,  1128,    -1,  1134,    -1,  1128,    -1,   133,    -1,
     164,    -1,   258,    -1,   262,    -1,   432,    -1,   445,    -1,
     457,    -1,  1136,    -1,  1138,    -1,  1135,    -1,  1014,    -1,
    1017,    -1,  1127,    -1,   150,    -1,  1153,    -1,  1015,    -1,
    1016,    -1,  1126,    -1,    50,    -1,    51,    -1,    56,    -1,
      65,    -1,    67,    -1,    70,    -1,    69,    -1,  1014,    -1,
    1138,    -1,   150,    -1,   176,    -1,   240,    -1,   295,    -1,
     298,    -1,   390,    -1,   483,    -1,  1142,    -1,  1139,   505,
    1142,    -1,    41,    -1,    -1,  1157,    -1,  1147,  1146,    -1,
    1147,    -1,  1147,  1146,    -1,  1035,    -1,  1147,    -1,  1147,
      -1,    22,  1147,    -1,    22,  1002,    -1,    72,    -1,    87,
      -1,    83,    -1,    81,    -1,    82,    -1,    76,    -1,    77,
      -1,    78,    -1,    75,    -1,    84,    -1,    80,    -1,    71,
      -1,    79,    -1,  1002,    -1,  1035,    -1,  1160,    -1,   502,
     503,    -1,   502,  1156,   503,    -1,  1155,    -1,  1156,  1155,
      -1,  1158,    -1,  1157,   505,  1158,    -1,  1156,    -1,   508,
    1157,   509,    -1,  1160,    -1,   502,    -1,   503,    -1,   505,
      -1,   506,    -1,  1153,    -1,  1010,    -1,  1150,    -1,  1151,
      -1,   495,    -1,   493,    -1,   494,    -1,   496,    -1,   497,
      -1,   319,    -1,    47,    -1,    48,    -1,    49,    -1,    50,
      -1,    51,    -1,    52,    -1,    53,    -1,    54,    -1,    55,
      -1,    56,    -1,    57,    -1,    58,    -1,    60,    -1,    59,
      -1,    61,    -1,    62,    -1,    63,    -1,    64,    -1,    65,
      -1,    66,    -1,    67,    -1,    68,    -1,    70,    -1,    69,
      -1,     5,    -1,   205,    -1,   240,    -1,   262,    -1,    25,
      -1,   295,    -1,   298,    -1,   390,    -1,    35,    -1,    36,
      -1,    43,    -1,    44,    -1,   483,    -1,   133,    -1,   220,
      -1,   432,    -1,   445,    -1,   458,    -1,   500,    -1,   501,
      -1,   489,    -1,   507,    -1,   177,  1039,    -1,   177,   352,
    1039,    -1,   177,    99,    -1,   177,   352,    99,    -1,  1010,
      -1,   502,  1162,   503,    -1,  1162,   493,  1162,    -1,  1162,
     494,  1162,    -1,  1162,   495,  1162,    -1,  1162,   496,  1162,
      -1,  1162,   497,  1162,    -1,  1151,    -1,  1131,    -1,    -1,
    1088,  1164,    -1,  1164,  1088,    -1,  1088,    -1,  1164,    -1,
     266,  1139,    -1,  1090,    -1,  1164,    -1,  1089,    -1,    -1,
    1165,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1339,  1339,  1342,  1344,  1346,  1348,  1350,  1352,  1354,
    1356,  1358,  1360,  1362,  1364,  1366,  1368,  1370,  1372,  1374,
    1376,  1378,  1380,  1382,  1384,  1402,  1404,  1406,  1408,  1410,
    1412,  1414,  1416,  1418,  1420,  1422,  1424,  1426,  1428,  1430,
    1432,  1434,  1436,  1438,  1440,  1442,  1444,  1446,  1448,  1450,
    1452,  1454,  1461,  1463,  1465,  1467,  1469,  1471,  1473,  1475,
    1477,  1479,  1481,  1483,  1485,  1487,  1489,  1491,  1493,  1495,
    1497,  1499,  1501,  1503,  1505,  1507,  1509,  1511,  1513,  1515,
    1517,  1519,  1521,  1523,  1525,  1527,  1534,  1536,  1538,  1540,
    1542,  1544,  1546,  1548,  1550,  1552,  1554,  1560,  1562,  1564,
    1566,  1568,  1570,  1572,  1574,  1576,  1582,  1592,  1596,  1604,
    1608,  1618,  1628,  1629,  1643,  1650,  1656,  1667,  1673,  1682,
    1689,  1695,  1704,  1711,  1719,  1724,  1732,  1737,  1743,  1748,
    1754,  1759,  1765,  1769,  1773,  1777,  1781,  1785,  1789,  1793,
    1797,  1801,  1805,  1809,  1813,  1817,  1821,  1825,  1829,  1833,
    1837,  1845,  1849,  1853,  1857,  1861,  1865,  1873,  1881,  1890,
    1892,  1900,  1908,  1916,  1924,  1928,  1936,  1940,  1948,  1956,
    1964,  1968,  1976,  1980,  1988,  1992,  2000,  2005,  2011,  2016,
    2022,  2026,  2030,  2034,  2038,  2042,  2050,  2054,  2058,  2066,
    2070,  2074,  2078,  2082,  2086,  2090,  2094,  2098,  2103,  2107,
    2111,  2115,  2119,  2123,  2131,  2135,  2143,  2147,  2155,  2159,
    2163,  2177,  2181,  2185,  2189,  2197,  2201,  2205,  2209,  2217,
    2221,  2225,  2229,  2233,  2237,  2241,  2249,  2253,  2258,  2264,
    2268,  2276,  2280,  2284,  2288,  2292,  2300,  2304,  2312,  2316,
    2320,  2324,  2328,  2337,  2345,  2349,  2357,  2361,  2369,  2377,
    2381,  2385,  2389,  2397,  2401,  2405,  2409,  2417,  2421,  2429,
    2433,  2437,  2441,  2445,  2449,  2453,  2457,  2461,  2465,  2469,
    2473,  2477,  2481,  2485,  2489,  2493,  2497,  2501,  2505,  2509,
    2513,  2517,  2521,  2525,  2529,  2533,  2537,  2541,  2545,  2549,
    2553,  2557,  2561,  2565,  2569,  2573,  2581,  2585,  2593,  2597,
    2602,  2608,  2613,  2619,  2627,  2632,  2638,  2642,  2650,  2654,
    2658,  2662,  2670,  2675,  2683,  2694,  2705,  2709,  2717,  2721,
    2725,  2733,  2737,  2745,  2750,  2756,  2760,  2764,  2768,  2772,
    2776,  2780,  2784,  2788,  2792,  2796,  2804,  2809,  2815,  2820,
    2826,  2831,  2837,  2842,  2848,  2852,  2860,  2868,  2872,  2876,
    2880,  2884,  2889,  2895,  2899,  2907,  2911,  2919,  2923,  2931,
    2935,  2939,  2943,  2947,  2951,  2956,  2962,  2967,  2973,  2978,
    2984,  2988,  2996,  3000,  3008,  3012,  3016,  3024,  3028,  3036,
    3044,  3052,  3057,  3063,  3067,  3071,  3079,  3083,  3087,  3091,
    3095,  3099,  3103,  3111,  3115,  3119,  3123,  3131,  3139,  3143,
    3148,  3154,  3158,  3162,  3166,  3170,  3174,  3182,  3186,  3194,
    3199,  3203,  3207,  3211,  3219,  3224,  3230,  3234,  3242,  3250,
    3254,  3259,  3264,  3270,  3274,  3282,  3286,  3294,  3299,  3305,
    3309,  3313,  3317,  3322,  3328,  3336,  3344,  3348,  3352,  3356,
    3360,  3368,  3373,  3379,  3383,  3387,  3392,  3398,  3402,  3406,
    3411,  3417,  3422,  3428,  3433,  3439,  3447,  3452,  3458,  3462,
    3470,  3478,  3482,  3487,  3493,  3501,  3509,  3514,  3520,  3524,
    3532,  3536,  3540,  3544,  3548,  3552,  3556,  3560,  3564,  3568,
    3572,  3576,  3584,  3589,  3595,  3599,  3603,  3611,  3615,  3623,
    3628,  3634,  3638,  3646,  3651,  3657,  3661,  3669,  3674,  3680,
    3684,  3692,  3697,  3703,  3711,  3716,  3722,  3726,  3734,  3742,
    3746,  3754,  3758,  3762,  3770,  3775,  3781,  3785,  3793,  3801,
    3805,  3813,  3817,  3821,  3825,  3833,  3841,  3849,  3857,  3865,
    3870,  3876,  3880,  3888,  3893,  3899,  3903,  3911,  3915,  3919,
    3927,  3935,  3939,  3943,  3951,  3955,  3963,  3971,  3975,  3983,
    3987,  3995,  3999,  4007,  4011,  4015,  4019,  4023,  4031,  4036,
    4042,  4047,  4053,  4057,  4065,  4070,  4076,  4080,  4085,  4091,
    4095,  4099,  4103,  4107,  4111,  4119,  4124,  4130,  4134,  4141,
    4145,  4153,  4159,  4163,  4171,  4175,  4183,  4187,  4195,  4204,
    4213,  4217,  4221,  4225,  4229,  4233,  4237,  4241,  4245,  4249,
    4253,  4261,  4269,  4273,  4281,  4285,  4293,  4297,  4301,  4305,
    4309,  4317,  4321,  4329,  4337,  4341,  4349,  4357,  4362,  4368,
    4372,  4380,  4388,  4392,  4400,  4404,  4408,  4412,  4416,  4424,
    4429,  4435,  4440,  4446,  4452,  4458,  4466,  4470,  4478,  4482,
    4490,  4494,  4502,  4506,  4514,  4518,  4526,  4534,  4542,  4546,
    4554,  4558,  4562,  4566,  4570,  4574,  4578,  4582,  4586,  4590,
    4594,  4598,  4606,  4610,  4618,  4622,  4630,  4634,  4642,  4650,
    4654,  4659,  4665,  4669,  4673,  4677,  4681,  4685,  4689,  4693,
    4697,  4701,  4705,  4709,  4713,  4717,  4721,  4725,  4729,  4737,
    4741,  4745,  4749,  4753,  4757,  4761,  4765,  4769,  4773,  4777,
    4781,  4789,  4793,  4801,  4805,  4809,  4813,  4819,  4825,  4831,
    4837,  4843,  4849,  4855,  4865,  4876,  4887,  4898,  4909,  4920,
    4931,  4947,  4963,  4979,  4990,  5006,  5017,  5033,  5048,  5052,
    5060,  5065,  5071,  5079,  5083,  5091,  5095,  5099,  5103,  5107,
    5115,  5119,  5127,  5131,  5135,  5139,  5147,  5151,  5155,  5159,
    5163,  5167,  5171,  5175,  5179,  5183,  5187,  5191,  5195,  5199,
    5207,  5211,  5219,  5223,  5231,  5236,  5242,  5246,  5254,  5262,
    5270,  5274,  5282,  5287,  5293,  5298,  5304,  5312,  5317,  5323,
    5327,  5331,  5339,  5343,  5347,  5355,  5359,  5363,  5371,  5379,
    5384,  5390,  5395,  5401,  5406,  5412,  5417,  5423,  5427,  5435,
    5439,  5443,  5451,  5455,  5460,  5466,  5470,  5475,  5481,  5485,
    5490,  5496,  5500,  5504,  5512,  5517,  5523,  5527,  5535,  5539,
    5547,  5551,  5559,  5563,  5571,  5575,  5579,  5583,  5587,  5595,
    5599,  5603,  5607,  5611,  5619,  5627,  5635,  5639,  5643,  5651,
    5655,  5659,  5667,  5671,  5679,  5683,  5687,  5691,  5695,  5699,
    5703,  5707,  5711,  5715,  5719,  5723,  5727,  5735,  5739,  5743,
    5747,  5755,  5759,  5767,  5772,  5778,  5786,  5790,  5798,  5806,
    5810,  5818,  5823,  5829,  5833,  5841,  5845,  5853,  5857,  5865,
    5869,  5873,  5877,  5885,  5889,  5897,  5905,  5909,  5917,  5921,
    5929,  5933,  5937,  5945,  5949,  5954,  5960,  5968,  5973,  5979,
    5983,  5987,  5995,  5999,  6007,  6012,  6018,  6022,  6026,  6030,
    6034,  6038,  6042,  6046,  6050,  6054,  6058,  6062,  6066,  6070,
    6074,  6078,  6082,  6086,  6090,  6094,  6098,  6102,  6106,  6110,
    6114,  6122,  6127,  6133,  6138,  6144,  6148,  6152,  6156,  6160,
    6164,  6168,  6176,  6180,  6184,  6188,  6192,  6196,  6200,  6204,
    6208,  6212,  6216,  6220,  6224,  6228,  6232,  6236,  6240,  6248,
    6256,  6260,  6264,  6272,  6276,  6284,  6288,  6292,  6296,  6300,
    6308,  6313,  6319,  6323,  6327,  6331,  6339,  6343,  6348,  6354,
    6358,  6366,  6374,  6379,  6385,  6393,  6397,  6405,  6409,  6413,
    6417,  6421,  6425,  6429,  6433,  6437,  6441,  6445,  6449,  6453,
    6457,  6465,  6469,  6474,  6480,  6484,  6488,  6496,  6500,  6504,
    6512,  6517,  6523,  6527,  6535,  6540,  6545,  6551,  6557,  6565,
    6573,  6578,  6584,  6588,  6592,  6596,  6600,  6604,  6608,  6612,
    6616,  6620,  6624,  6628,  6632,  6636,  6640,  6644,  6652,  6657,
    6663,  6667,  6675,  6683,  6688,  6694,  6702,  6706,  6714,  6722,
    6726,  6730,  6734,  6738,  6746,  6751,  6757,  6765,  6769,  6773,
    6777,  6781,  6785,  6793,  6801,  6805,  6809,  6817,  6822,  6828,
    6832,  6836,  6840,  6844,  6852,  6856,  6864,  6868,  6872,  6876,
    6884,  6888,  6896,  6900,  6908,  6913,  6919,  6924,  6930,  6935,
    6941,  6946,  6952,  6956,  6960,  6964,  6972,  6976,  6980,  6984,
    6988,  6992,  6996,  7004,  7008,  7016,  7024,  7028,  7032,  7040,
    7044,  7048,  7053,  7059,  7065,  7075,  7080,  7086,  7090,  7094,
    7098,  7106,  7108,  7116,  7121,  7127,  7135,  7139,  7143,  7151,
    7155,  7163,  7171,  7176,  7182,  7190,  7195,  7201,  7209,  7214,
    7220,  7224,  7228,  7232,  7236,  7240,  7244,  7248,  7256,  7261,
    7267,  7275,  7279,  7287,  7291,  7299,  7307,  7315,  7323,  7327,
    7335,  7387,  7391,  7404,  7406,  7410,  7414,  7418,  7427,  7433,
    7437,  7445,  7449,  7457,  7461,  7469,  7473,  7477,  7481,  7485,
    7489,  7493,  7497,  7505,  7509,  7517,  7521,  7525,  7529,  7533,
    7537,  7545,  7549,  7557,  7561,  7569,  7577,  7582,  7584,  7590,
    7594,  7598,  7602,  7606,  7610,  7614,  7618,  7626,  7631,  7637,
    7641,  7646,  7652,  7656,  7660,  7665,  7671,  7676,  7682,  7690,
    7694,  7702,  7706,  7714,  7718,  7722,  7726,  7734,  7739,  7745,
    7749,  7754,  7762,  7766,  7774,  7778,  7786,  7794,  7798,  7803,
    7809,  7817,  7821,  7829,  7833,  7841,  7846,  7852,  7857,  7863,
    7867,  7875,  7880,  7886,  7890,  7898,  7902,  7910,  7915,  7921,
    7925,  7933,  7938,  7944,  7948,  7956,  7960,  7964,  7968,  7972,
    7976,  7980,  7984,  7990,  7994,  7998,  8006,  8010,  8014,  8018,
    8022,  8026,  8034,  8038,  8042,  8046,  8054,  8058,  8062,  8066,
    8074,  8079,  8085,  8089,  8097,  8101,  8105,  8109,  8117,  8121,
    8129,  8133,  8137,  8145,  8153,  8158,  8164,  8168,  8173,  8179,
    8183,  8191,  8199,  8201,  8203,  8207,  8211,  8215,  8223,  8233,
    8244,  8253,  8257,  8261,  8265,  8269,  8273,  8277,  8285,  8289,
    8293,  8297,  8305,  8309,  8317,  8322,  8328,  8332,  8336,  8340,
    8344,  8348,  8352,  8356,  8360,  8364,  8368,  8376,  8381,  8387,
    8391,  8399,  8403,  8411,  8419,  8427,  8431,  8439,  8443,  8451,
    8459,  8467,  8471,  8475,  8479,  8483,  8487,  8495,  8500,  8506,
    8511,  8517,  8521,  8525,  8529,  8537,  8545,  8549,  8554,  8560,
    8564,  8568,  8572,  8576,  8580,  8584,  8588,  8592,  8596,  8600,
    8604,  8608,  8613,  8619,  8623,  8631,  8635,  8639,  8643,  8647,
    8651,  8655,  8659,  8663,  8667,  8671,  8675,  8679,  8683,  8687,
    8691,  8695,  8699,  8703,  8707,  8711,  8715,  8719,  8723,  8727,
    8731,  8735,  8739,  8743,  8747,  8751,  8755,  8759,  8763,  8767,
    8771,  8775,  8779,  8783,  8787,  8791,  8795,  8799,  8803,  8807,
    8811,  8815,  8819,  8823,  8827,  8831,  8835,  8839,  8843,  8847,
    8851,  8856,  8860,  8868,  8872,  8876,  8880,  8884,  8888,  8892,
    8896,  8900,  8904,  8908,  8912,  8916,  8920,  8924,  8928,  8932,
    8936,  8940,  8944,  8948,  8952,  8960,  8964,  8968,  8972,  8976,
    8980,  8984,  8988,  8992,  8996,  9000,  9008,  9012,  9016,  9020,
    9024,  9028,  9032,  9036,  9040,  9044,  9048,  9052,  9056,  9060,
    9064,  9068,  9072,  9076,  9080,  9084,  9088,  9092,  9096,  9100,
    9104,  9108,  9112,  9116,  9120,  9124,  9128,  9132,  9136,  9140,
    9144,  9148,  9152,  9156,  9160,  9164,  9168,  9172,  9176,  9180,
    9184,  9188,  9192,  9196,  9204,  9208,  9216,  9220,  9224,  9229,
    9235,  9243,  9247,  9255,  9259,  9267,  9271,  9279,  9283,  9288,
    9294,  9299,  9305,  9309,  9317,  9325,  9329,  9334,  9340,  9348,
    9352,  9359,  9364,  9370,  9375,  9380,  9386,  9390,  9398,  9402,
    9406,  9410,  9414,  9422,  9426,  9430,  9438,  9442,  9446,  9454,
    9458,  9466,  9470,  9474,  9478,  9482,  9486,  9490,  9494,  9498,
    9506,  9510,  9518,  9522,  9530,  9534,  9538,  9542,  9546,  9550,
    9558,  9562,  9570,  9574,  9582,  9586,  9594,  9598,  9606,  9610,
    9614,  9622,  9626,  9634,  9639,  9645,  9649,  9653,  9657,  9661,
    9665,  9669,  9673,  9681,  9685,  9693,  9701,  9706,  9712,  9716,
    9720,  9724,  9728,  9733,  9739,  9747,  9755,  9759,  9763,  9771,
    9775,  9783,  9791,  9795,  9803,  9811,  9816,  9822,  9827,  9833,
    9837,  9845,  9849,  9853,  9857,  9865,  9869,  9878,  9880,  9888,
    9893,  9899,  9903,  9911,  9915,  9923,  9931,  9935,  9943,  9947,
    9951,  9955,  9963,  9967,  9975,  9979,  9987,  9991,  9999, 10007,
   10015, 10023, 10031, 10039, 10047, 10051, 10059, 10063, 10067, 10071,
   10075, 10079, 10083, 10087, 10091, 10095, 10099, 10103, 10107, 10111,
   10112, 10117, 10123, 10131, 10135, 10136, 10140, 10148, 10152, 10160,
   10164, 10168, 10172, 10176, 10180, 10184, 10188, 10192, 10196, 10200,
   10204, 10208, 10212, 10216, 10220, 10224, 10228, 10232, 10236, 10240,
   10244, 10248, 10252, 10256, 10260, 10264, 10268, 10272, 10276, 10280,
   10284, 10288, 10292, 10296, 10300, 10304, 10308, 10312, 10316, 10320,
   10324, 10328, 10332, 10336, 10340, 10344, 10348, 10352, 10356, 10360,
   10364, 10368, 10372, 10376, 10380, 10384, 10388, 10392, 10396, 10400,
   10404, 10408, 10412, 10416, 10420, 10424, 10428, 10432, 10436, 10440,
   10444, 10448, 10452, 10456, 10460, 10464, 10468, 10472, 10476, 10480,
   10484, 10488, 10492, 10496, 10500, 10504, 10508, 10512, 10516, 10520,
   10524, 10528, 10532, 10536, 10540, 10544, 10548, 10552, 10556, 10560,
   10564, 10568, 10572, 10576, 10580, 10584, 10588, 10592, 10596, 10600,
   10604, 10608, 10612, 10616, 10620, 10624, 10628, 10632, 10636, 10640,
   10644, 10648, 10652, 10656, 10660, 10664, 10668, 10672, 10676, 10680,
   10684, 10688, 10692, 10696, 10700, 10704, 10708, 10712, 10716, 10720,
   10724, 10728, 10732, 10736, 10740, 10744, 10748, 10752, 10756, 10760,
   10764, 10768, 10772, 10776, 10780, 10784, 10788, 10792, 10796, 10800,
   10804, 10808, 10812, 10816, 10820, 10824, 10828, 10832, 10836, 10840,
   10844, 10848, 10852, 10856, 10860, 10864, 10868, 10872, 10876, 10880,
   10884, 10888, 10892, 10896, 10900, 10904, 10908, 10912, 10916, 10920,
   10924, 10928, 10932, 10936, 10940, 10944, 10948, 10952, 10956, 10960,
   10964, 10968, 10972, 10976, 10980, 10984, 10988, 10992, 10996, 11000,
   11004, 11008, 11012, 11016, 11020, 11024, 11028, 11032, 11036, 11040,
   11044, 11048, 11052, 11056, 11060, 11064, 11068, 11072, 11076, 11080,
   11084, 11088, 11092, 11096, 11100, 11104, 11108, 11112, 11116, 11120,
   11128, 11132, 11136, 11140, 11144, 11148, 11152, 11156, 11160, 11164,
   11168, 11172, 11176, 11180, 11184, 11188, 11192, 11196, 11200, 11204,
   11208, 11212, 11216, 11220, 11224, 11228, 11232, 11236, 11240, 11244,
   11248, 11252, 11256, 11260, 11264, 11268, 11272, 11276, 11280, 11284,
   11288, 11292, 11296, 11304, 11308, 11312, 11316, 11320, 11324, 11328,
   11332, 11336, 11340, 11344, 11348, 11352, 11356, 11360, 11364, 11368,
   11372, 11376, 11380, 11384, 11388, 11396, 11400, 11404, 11408, 11412,
   11416, 11420, 11424, 11428, 11432, 11436, 11440, 11444, 11448, 11452,
   11456, 11460, 11464, 11468, 11472, 11476, 11480, 11484, 11488, 11492,
   11496, 11500, 11504, 11508, 11512, 11516, 11520, 11524, 11528, 11532,
   11536, 11540, 11544, 11548, 11552, 11556, 11560, 11564, 11568, 11572,
   11576, 11580, 11584, 11588, 11592, 11596, 11600, 11604, 11608, 11612,
   11616, 11620, 11624, 11628, 11632, 11636, 11640, 11644, 11648, 11652,
   11656, 11660, 11664, 11668, 11672, 11676, 11680, 11684, 11688, 11692,
   11702, 11703, 11706, 11707, 11708, 11714, 11715, 11716, 11717, 11718,
   11731, 11731, 11740, 11756, 11758, 11761, 11763, 11767, 11779, 11795,
   11799, 11810, 11811, 11814, 11826, 11835, 11836, 11839, 11840, 11841,
   11844, 11845, 11848, 11849, 11852, 11853, 11856, 11858, 11860, 11862,
   11866, 11873, 11880, 11896, 11930, 11940, 11943, 11945, 11958, 11959,
   11961, 11963, 11967, 11980, 11987, 12047, 12056, 12058, 12059, 12062,
   12064, 12065, 12068, 12069, 12070, 12071, 12072, 12079, 12078, 12088,
   12090, 12092, 12093, 12096, 12097, 12098, 12099, 12102, 12103, 12107,
   12106, 12123, 12121, 12137, 12136, 12150, 12156, 12157, 12160, 12162,
   12163, 12166, 12167, 12168, 12169, 12172, 12173, 12176, 12184, 12201,
   12209, 12232, 12338, 12372, 12374, 12376, 12380, 12384, 12383, 12434,
   12436, 12435, 12450, 12456, 12463, 12468, 12471, 12472, 12475, 12476,
   12477, 12478, 12479, 12480, 12481, 12489, 12497, 12500, 12501, 12502,
   12503, 12504, 12505, 12513, 12521, 12522, 12523, 12526, 12527, 12530,
   12532, 12536, 12624, 12625, 12632, 12633, 12634, 12640, 12649, 12652,
   12653, 12654, 12655, 12658, 12659, 12660, 12663, 12665, 12673, 12674,
   12680, 12688, 12689, 12692, 12693, 12696, 12701, 12708, 12713, 12720,
   12727, 12727, 12729, 12736, 12737, 12740, 12741, 12742, 12743, 12744,
   12745, 12746, 12747, 12748, 12754, 12761, 12773, 12779, 12786, 12794,
   12795, 12807, 12818, 12829, 12833, 12834, 12837, 12842, 12846, 12847,
   12850, 12856, 12864, 12867, 12874, 12878, 12879, 12882, 12885, 12889,
   12890, 12893, 12899, 12907, 12908, 12917, 12926, 12938, 12939, 12940,
   12941, 12942, 12943, 12944, 12945, 12946, 12947, 12948, 12949, 12950,
   12951, 12952, 12959, 12960, 12963, 12964, 12971, 12972, 12973, 12980,
   12979, 12996, 12997, 13004, 13003, 13073, 13079, 13085, 13093, 13099,
   13105, 13111, 13117, 13123, 13129, 13135, 13141, 13152, 13153, 13156,
   13157, 13158, 13159, 13160, 13161, 13162, 13163, 13164, 13165, 13166,
   13167, 13168, 13169, 13170, 13171, 13172, 13173, 13174, 13175, 13176,
   13177, 13178, 13179, 13182, 13183, 13184, 13185, 13186, 13187, 13191,
   13192, 13193, 13194, 13195, 13196, 13197, 13200, 13203, 13204, 13205,
   13206, 13207, 13208, 13209, 13210, 13223, 13224, 13225, 13226, 13227,
   13228, 13229, 13234, 13235, 13236, 13237, 13238, 13239, 13245, 13246,
   13247, 13248, 13249, 13250, 13251, 13252, 13253, 13254, 13255, 13258,
   13259, 13260, 13261, 13262, 13265, 13266, 13267, 13268, 13271, 13272,
   13273, 13274, 13275, 13276, 13277, 13294, 13295, 13296, 13299, 13300,
   13301, 13302, 13303, 13304, 13308, 13308, 13311, 13317, 13318, 13321,
   13323, 13328, 13338, 13349, 13356, 13357, 13358, 13361, 13394, 13396,
   13398, 13401, 13411, 13421, 13431, 13432, 13435, 13437, 13438, 13439,
   13442, 13444, 13452, 13453, 13454, 13458, 13459, 13463, 13464, 13467,
   13468, 13471, 13472, 13473, 13474, 13475, 13478, 13479, 13480, 13481,
   13482, 13483, 13484, 13485, 13486, 13487, 13488, 13489, 13490, 13491,
   13492, 13493, 13494, 13495, 13496, 13497, 13498, 13499, 13500, 13501,
   13502, 13503, 13504, 13505, 13506, 13507, 13508, 13509, 13510, 13511,
   13512, 13513, 13514, 13515, 13516, 13517, 13518, 13519, 13520, 13521,
   13522, 13523, 13524, 13525, 13526, 13527, 13528, 13529, 13530, 13531,
   13532, 13533, 13536, 13537, 13538, 13539, 13542, 13543, 13544, 13545,
   13546, 13547, 13548, 13549, 13550, 13553, 13554, 13555, 13556, 13557,
   13560, 13561, 13564, 13565, 13576, 13577
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", 
  "SQL_OPEN", "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH", 
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", 
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT", 
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", 
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", 
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", 
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", 
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", 
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP", 
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST", 
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST", 
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", 
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", 
  "ALWAYS", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", 
  "ASSERTION", "ASSIGNMENT", "ASYMMETRIC", "AT", "AUTHORIZATION", 
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT", 
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASCADED", 
  "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", "CHARACTER", 
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", 
  "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMENTS", "COMMIT", 
  "COMMITTED", "CONCURRENTLY", "CONFIGURATION", "CONNECTION", 
  "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P", "CONVERSION_P", 
  "COPY", "COST", "CREATE", "CREATEDB", "CREATEROLE", "CREATEUSER", 
  "CROSS", "CSV", "CURRENT_P", "CURRENT_CATALOG", "CURRENT_DATE", 
  "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", 
  "CURRENT_USER", "CURSOR", "CYCLE", "DATA_P", "DATABASE", "DAY_P", 
  "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", 
  "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P", "DELIMITER", 
  "DELIMITERS", "DESC", "DICTIONARY", "DISABLE_P", "DISCARD", "DISTINCT", 
  "DO", "DOCUMENT_P", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", 
  "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE", 
  "EXCEPT", "EXCLUDE", "EXCLUDING", "EXCLUSIVE", "EXECUTE", "EXISTS", 
  "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P", "FAMILY", "FETCH", 
  "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE", "FOREIGN", "FORWARD", 
  "FREEZE", "FROM", "FULL", "FUNCTION", "FUNCTIONS", "GLOBAL", "GRANT", 
  "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING", "HEADER_P", 
  "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", "IMMEDIATE", 
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX", 
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INLINE_P", "INNER_P", 
  "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P", 
  "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", 
  "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LARGE_P", "LAST_P", 
  "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAST", "LEFT", "LEVEL", 
  "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME", 
  "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "LOGIN_P", "MAPPING", "MATCH", 
  "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAME_P", 
  "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NOCREATEDB", 
  "NOCREATEROLE", "NOCREATEUSER", "NOINHERIT", "NOLOGIN_P", "NONE", 
  "NOSUPERUSER", "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", 
  "NULL_P", "NULLIF", "NULLS_P", "NUMERIC", "OBJECT_P", "OF", "OFF", 
  "OFFSET", "OIDS", "ON", "ONLY", "OPERATOR", "OPTION", "OPTIONS", "OR", 
  "ORDER", "OUT_P", "OUTER_P", "OVER", "OVERLAPS", "OVERLAY", "OWNED", 
  "OWNER", "PARSER", "PARTIAL", "PARTITION", "PASSWORD", "PLACING", 
  "PLANS", "POSITION", "PRECEDING", "PRECISION", "PRESERVE", "PREPARE", 
  "PREPARED", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", 
  "QUOTE", "RANGE", "READ", "REAL", "REASSIGN", "RECHECK", "RECURSIVE", 
  "REFERENCES", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME", 
  "REPEATABLE", "REPLACE", "REPLICA", "RESET", "RESTART", "RESTRICT", 
  "RETURNING", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROW", 
  "ROWS", "RULE", "SAVEPOINT", "SCHEMA", "SCROLL", "SEARCH", "SECOND_P", 
  "SECURITY", "SELECT", "SEQUENCE", "SEQUENCES", "SERIALIZABLE", "SERVER", 
  "SESSION", "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR", 
  "SIMPLE", "SMALLINT", "SOME", "STABLE", "STANDALONE_P", "START", 
  "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE", "STRICT_P", 
  "STRIP_P", "SUBSTRING", "SUPERUSER_P", "SYMMETRIC", "SYSID", "SYSTEM_P", 
  "TABLE", "TABLES", "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY", 
  "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING", "TRANSACTION", 
  "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P", 
  "UNBOUNDED", "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", 
  "UNLISTEN", "UNTIL", "UPDATE", "USER", "USING", "VACUUM", "VALID", 
  "VALIDATOR", "VALUE_P", "VALUES", "VARCHAR", "VARIADIC", "VARYING", 
  "VERBOSE", "VERSION_P", "VIEW", "VOLATILE", "WHEN", "WHERE", 
  "WHITESPACE_P", "WINDOW", "WITH", "WITHOUT", "WORK", "WRAPPER", "WRITE", 
  "XML_P", "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLFOREST", 
  "XMLPARSE", "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P", "YES_P", 
  "ZONE", "NULLS_FIRST", "NULLS_LAST", "WITH_TIME", "'='", "'<'", "'>'", 
  "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'", "'^'", "UMINUS", "'['", 
  "']'", "'('", "')'", "'.'", "','", "';'", "':'", "'{'", "'}'", 
  "$accept", "prog", "stmt", "CreateRoleStmt", "opt_with", "OptRoleList", 
  "AlterOptRoleList", "AlterOptRoleElem", "CreateOptRoleElem", 
  "CreateUserStmt", "AlterRoleStmt", "opt_in_database", 
  "AlterRoleSetStmt", "AlterUserStmt", "AlterUserSetStmt", "DropRoleStmt", 
  "DropUserStmt", "CreateGroupStmt", "AlterGroupStmt", "add_drop", 
  "DropGroupStmt", "CreateSchemaStmt", "OptSchemaName", 
  "OptSchemaEltList", "schema_stmt", "VariableSetStmt", "set_rest", 
  "var_name", "var_list", "var_value", "iso_level", "opt_boolean", 
  "zone_value", "opt_encoding", "ColId_or_Sconst", "VariableResetStmt", 
  "SetResetClause", "VariableShowStmt", "ConstraintsSetStmt", 
  "constraints_set_list", "constraints_set_mode", "CheckPointStmt", 
  "DiscardStmt", "AlterTableStmt", "alter_table_cmds", "alter_table_cmd", 
  "alter_column_default", "opt_drop_behavior", "alter_using", 
  "reloptions", "opt_reloptions", "reloption_list", "reloption_elem", 
  "ClosePortalStmt", "CopyStmt", "copy_from", "copy_file_name", 
  "copy_options", "copy_opt_list", "copy_opt_item", "opt_binary", 
  "opt_oids", "copy_delimiter", "opt_using", "copy_generic_opt_list", 
  "copy_generic_opt_elem", "copy_generic_opt_arg", 
  "copy_generic_opt_arg_list", "copy_generic_opt_arg_list_item", 
  "CreateStmt", "OptTemp", "OptTableElementList", 
  "OptTypedTableElementList", "TableElementList", "TypedTableElementList", 
  "TableElement", "TypedTableElement", "columnDef", "columnOptions", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption", 
  "TableConstraint", "ConstraintElem", "opt_column_list", "columnList", 
  "columnElem", "key_match", "ExclusionConstraintList", 
  "ExclusionConstraintElem", "ExclusionWhereClause", "key_actions", 
  "key_update", "key_delete", "key_action", "OptInherit", "OptWith", 
  "OnCommitOption", "OptTableSpace", "OptConsTableSpace", 
  "create_as_target", "OptCreateAs", "CreateAsList", "CreateAsElement", 
  "opt_with_data", "CreateSeqStmt", "AlterSeqStmt", "OptSeqOptList", 
  "SeqOptList", "SeqOptElem", "opt_by", "NumericOnly", "CreatePLangStmt", 
  "opt_trusted", "handler_name", "opt_inline_handler", "validator_clause", 
  "opt_validator", "DropPLangStmt", "opt_procedural", 
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt", 
  "CreateFdwStmt", "DropFdwStmt", "AlterFdwStmt", 
  "create_generic_options", "generic_option_list", 
  "alter_generic_options", "alter_generic_option_list", 
  "alter_generic_option_elem", "generic_option_elem", 
  "generic_option_name", "generic_option_arg", "CreateForeignServerStmt", 
  "opt_type", "foreign_server_version", "opt_foreign_server_version", 
  "DropForeignServerStmt", "AlterForeignServerStmt", 
  "CreateUserMappingStmt", "auth_ident", "DropUserMappingStmt", 
  "AlterUserMappingStmt", "CreateTrigStmt", "TriggerActionTime", 
  "TriggerEvents", "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", 
  "TriggerForType", "TriggerWhen", "TriggerFuncArgs", "TriggerFuncArg", 
  "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition", 
  "def_list", "def_elem", "def_arg", "aggr_args", "old_aggr_definition", 
  "old_aggr_list", "old_aggr_elem", "opt_enum_val_list", "enum_val_list", 
  "CreateOpClassStmt", "opclass_item_list", "opclass_item", "opt_default", 
  "opt_opfamily", "opt_recheck", "CreateOpFamilyStmt", 
  "AlterOpFamilyStmt", "opclass_drop_list", "opclass_drop", 
  "DropOpClassStmt", "DropOpFamilyStmt", "DropOwnedStmt", 
  "ReassignOwnedStmt", "DropStmt", "drop_type", "any_name_list", 
  "any_name", "attrs", "TruncateStmt", "opt_restart_seqs", "CommentStmt", 
  "comment_type", "comment_text", "FetchStmt", "fetch_args", "from_in", 
  "opt_from_in", "GrantStmt", "RevokeStmt", "privileges", 
  "privilege_list", "privilege", "privilege_target", "grantee_list", 
  "grantee", "opt_grant_grant_option", "function_with_argtypes_list", 
  "function_with_argtypes", "GrantRoleStmt", "RevokeRoleStmt", 
  "opt_grant_admin_option", "opt_granted_by", 
  "AlterDefaultPrivilegesStmt", "DefACLOptionList", "DefACLOption", 
  "DefACLAction", "defacl_privilege_target", "IndexStmt", "opt_unique", 
  "opt_concurrently", "opt_index_name", "access_method_clause", 
  "index_params", "index_elem", "opt_class", "opt_asc_desc", 
  "opt_nulls_order", "CreateFunctionStmt", "opt_or_replace", "func_args", 
  "func_args_list", "func_args_with_defaults", 
  "func_args_with_defaults_list", "func_arg", "arg_class", "param_name", 
  "func_return", "func_type", "func_arg_with_default", 
  "createfunc_opt_list", "common_func_opt_item", "createfunc_opt_item", 
  "func_as", "opt_definition", "table_func_column", 
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list", 
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt", 
  "oper_argtypes", "any_operator", "DoStmt", "dostmt_opt_list", 
  "dostmt_opt_item", "CreateCastStmt", "cast_context", "DropCastStmt", 
  "opt_if_exists", "ReindexStmt", "reindex_type", "opt_force", 
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt", 
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti", 
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead", 
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt", 
  "UnlistenStmt", "TransactionStmt", "opt_transaction", 
  "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", 
  "AlterTSDictionaryStmt", "AlterTSConfigurationStmt", 
  "CreateConversionStmt", "ClusterStmt", "cluster_index_specification", 
  "VacuumStmt", "vacuum_option_list", "vacuum_option_elem", "AnalyzeStmt", 
  "analyze_keyword", "opt_verbose", "opt_full", "opt_freeze", 
  "opt_name_list", "ExplainStmt", "ExplainableStmt", 
  "explain_option_list", "explain_option_elem", "explain_option_name", 
  "explain_option_arg", "PrepareStmt", "prep_type_clause", 
  "PreparableStmt", "ExecuteStmt", "execute_param_clause", "InsertStmt", 
  "insert_rest", "insert_column_list", "insert_column_item", 
  "returning_clause", "DeleteStmt", "using_clause", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", "set_clause_list", 
  "set_clause", "single_set_clause", "multiple_set_clause", "set_target", 
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options", 
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens", 
  "select_clause", "simple_select", "with_clause", "cte_list", 
  "common_table_expr", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "limit_clause", "offset_clause", "select_limit_value", 
  "select_offset_value", "opt_select_fetch_first_value", 
  "select_offset_value2", "row_or_rows", "first_or_next", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "for_locking_items", "for_locking_item", "locked_rels_list", 
  "values_clause", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "relation_expr_list", "relation_expr_opt_alias", 
  "func_table", "where_clause", "where_or_current_clause", 
  "TableFuncElementList", "TableFuncElement", "Typename", 
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType", 
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr", 
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone", 
  "xml_attributes", "xml_attribute_list", "xml_attribute_el", 
  "document_or_content", "xml_whitespace_option", "window_clause", 
  "window_definition_list", "window_definition", "over_clause", 
  "window_specification", "opt_existing_window_name", 
  "opt_partition_clause", "opt_frame_clause", "frame_extent", 
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list", 
  "func_arg_expr", "type_list", "array_expr", "array_expr_list", 
  "extract_list", "extract_arg", "overlay_list", "overlay_placing", 
  "position_list", "substr_list", "substr_from", "substr_for", 
  "trim_list", "in_expr", "case_expr", "when_clause_list", "when_clause", 
  "case_default", "case_arg", "columnref", "indirection_el", 
  "indirection", "opt_indirection", "opt_asymmetric", "ctext_expr", 
  "ctext_expr_list", "ctext_row", "target_list", "target_el", 
  "qualified_name_list", "qualified_name", "name_list", "name", 
  "database_name", "access_method", "attr_name", "index_name", 
  "file_name", "func_name", "AexprConst", "Iconst", "RoleId", 
  "SignedIconst", "Iconst_list", "unreserved_keyword", "col_name_keyword", 
  "type_func_name_keyword", "reserved_keyword", "statements", "statement", 
  "CreateAsStmt", "@1", "at", "ECPGConnect", "connection_target", 
  "opt_database_name", "db_prefix", "server", "opt_server", "server_name", 
  "opt_port", "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "connect_options", "opt_opt_value", 
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt", 
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale", 
  "ecpg_interval", "ECPGDeclaration", "@2", "sql_startdeclare", 
  "sql_enddeclare", "var_type_declarations", "vt_declarations", 
  "variable_declarations", "type_declaration", "@3", "var_declaration", 
  "@4", "@5", "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@6", "struct_union_type", "@7", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "execstring", 
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using", 
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list", 
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item", 
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem", 
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem", 
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off", 
  "ECPGSetConnection", "ECPGTypedef", "@8", "opt_reference", "ECPGVar", 
  "@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames", 
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId", 
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon", 
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval", 
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind", 
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param", 
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", 
  "ecpg_ident", "quoted_ident_stringvar", "c_stuff_item", "c_stuff", 
  "c_list", "c_term", "c_thing", "c_anything", "DeallocateStmt", 
  "Iresult", "execute_rest", "ecpg_into", "ecpg_fetch_into", 
  "opt_ecpg_fetch_into", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,    61,
      60,    62,   744,    43,    45,    42,    47,    37,    94,   745,
      91,    93,    40,    41,    46,    44,    59,    58,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   510,   511,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   513,   514,   514,   515,   515,
     516,   516,   517,   517,   517,   517,   517,   517,   517,   517,
     517,   517,   517,   517,   517,   517,   517,   517,   517,   517,
     517,   518,   518,   518,   518,   518,   518,   519,   520,   521,
     521,   522,   523,   524,   525,   525,   526,   526,   527,   528,
     529,   529,   530,   530,   531,   531,   532,   532,   533,   533,
     534,   534,   534,   534,   534,   534,   535,   535,   535,   536,
     536,   536,   536,   536,   536,   536,   536,   536,   536,   536,
     536,   536,   536,   536,   537,   537,   538,   538,   539,   539,
     539,   540,   540,   540,   540,   541,   541,   541,   541,   542,
     542,   542,   542,   542,   542,   542,   543,   543,   543,   544,
     544,   545,   545,   545,   545,   545,   546,   546,   547,   547,
     547,   547,   547,   548,   549,   549,   550,   550,   551,   552,
     552,   552,   552,   553,   553,   553,   553,   554,   554,   555,
     555,   555,   555,   555,   555,   555,   555,   555,   555,   555,
     555,   555,   555,   555,   555,   555,   555,   555,   555,   555,
     555,   555,   555,   555,   555,   555,   555,   555,   555,   555,
     555,   555,   555,   555,   555,   555,   556,   556,   557,   557,
     557,   558,   558,   559,   560,   560,   561,   561,   562,   562,
     562,   562,   563,   563,   564,   564,   565,   565,   566,   566,
     566,   567,   567,   568,   568,   569,   569,   569,   569,   569,
     569,   569,   569,   569,   569,   569,   570,   570,   571,   571,
     572,   572,   573,   573,   574,   574,   575,   576,   576,   576,
     576,   576,   576,   577,   577,   578,   578,   579,   579,   580,
     580,   580,   580,   580,   580,   580,   581,   581,   582,   582,
     583,   583,   584,   584,   585,   585,   585,   586,   586,   587,
     588,   589,   589,   590,   590,   590,   591,   591,   591,   591,
     591,   591,   591,   592,   592,   592,   592,   593,   594,   594,
     594,   595,   595,   595,   595,   595,   595,   596,   596,   597,
     597,   597,   597,   597,   598,   598,   599,   599,   600,   601,
     601,   601,   601,   602,   602,   603,   603,   604,   604,   605,
     605,   605,   605,   605,   606,   607,   608,   608,   608,   608,
     608,   609,   609,   610,   610,   610,   610,   611,   611,   611,
     611,   612,   612,   613,   613,   614,   615,   615,   616,   616,
     617,   618,   618,   618,   619,   620,   621,   621,   622,   622,
     623,   623,   623,   623,   623,   623,   623,   623,   623,   623,
     623,   623,   624,   624,   625,   625,   625,   626,   626,   627,
     627,   628,   628,   629,   629,   630,   630,   631,   631,   632,
     632,   633,   633,   634,   635,   635,   636,   636,   637,   638,
     638,   639,   639,   639,   640,   640,   641,   641,   642,   643,
     643,   644,   644,   644,   644,   645,   646,   647,   648,   649,
     649,   650,   650,   651,   651,   652,   652,   653,   653,   653,
     654,   655,   655,   655,   656,   656,   657,   658,   658,   659,
     659,   660,   660,   661,   661,   661,   661,   661,   662,   662,
     663,   663,   664,   664,   665,   665,   666,   666,   666,   667,
     667,   667,   667,   667,   667,   668,   668,   669,   669,   669,
     669,   669,   670,   670,   671,   671,   672,   672,   673,   674,
     675,   675,   675,   675,   675,   675,   675,   675,   675,   675,
     675,   676,   677,   677,   678,   678,   679,   679,   679,   679,
     679,   680,   680,   681,   682,   682,   683,   684,   684,   685,
     685,   686,   687,   687,   688,   688,   688,   688,   688,   689,
     689,   690,   690,   691,   691,   692,   693,   693,   694,   694,
     695,   695,   696,   696,   697,   697,   698,   699,   700,   700,
     701,   701,   701,   701,   701,   701,   701,   701,   701,   701,
     701,   701,   702,   702,   703,   703,   704,   704,   705,   706,
     706,   706,   707,   707,   707,   707,   707,   707,   707,   707,
     707,   707,   707,   707,   707,   707,   707,   707,   707,   708,
     708,   708,   708,   708,   708,   708,   708,   708,   708,   708,
     708,   709,   709,   710,   710,   710,   710,   710,   710,   710,
     710,   710,   710,   710,   711,   711,   711,   711,   711,   711,
     711,   711,   711,   711,   711,   711,   711,   711,   712,   712,
     713,   713,   714,   715,   715,   716,   716,   716,   716,   716,
     717,   717,   718,   718,   718,   718,   719,   719,   719,   719,
     719,   719,   719,   719,   719,   719,   719,   719,   719,   719,
     720,   720,   721,   721,   722,   722,   723,   723,   724,   725,
     726,   726,   727,   727,   728,   728,   729,   730,   730,   731,
     731,   731,   732,   732,   732,   733,   733,   733,   734,   735,
     735,   736,   736,   737,   737,   738,   738,   739,   739,   740,
     740,   740,   741,   741,   741,   742,   742,   742,   743,   743,
     743,   744,   744,   744,   745,   745,   746,   746,   747,   747,
     748,   748,   749,   749,   750,   750,   750,   750,   750,   751,
     751,   751,   751,   751,   752,   753,   754,   754,   754,   755,
     755,   755,   756,   756,   757,   757,   757,   757,   757,   757,
     757,   757,   757,   757,   757,   757,   757,   758,   758,   758,
     758,   759,   759,   760,   760,   761,   762,   762,   763,   764,
     764,   765,   765,   766,   766,   767,   767,   768,   768,   769,
     769,   769,   769,   770,   770,   771,   772,   772,   773,   773,
     774,   774,   774,   775,   775,   775,   776,   777,   777,   778,
     778,   778,   779,   779,   780,   780,   781,   781,   781,   781,
     781,   781,   781,   781,   781,   781,   781,   781,   781,   781,
     781,   781,   781,   781,   781,   781,   781,   781,   781,   781,
     781,   782,   782,   783,   783,   784,   784,   784,   784,   784,
     784,   784,   785,   785,   785,   785,   785,   785,   785,   785,
     785,   785,   785,   785,   785,   785,   785,   785,   785,   786,
     787,   787,   787,   788,   788,   789,   789,   789,   789,   789,
     790,   790,   791,   791,   791,   791,   792,   792,   792,   793,
     793,   794,   795,   795,   796,   797,   797,   798,   798,   798,
     798,   798,   798,   798,   798,   798,   798,   798,   798,   798,
     798,   799,   799,   799,   800,   800,   800,   801,   801,   801,
     802,   802,   803,   803,   804,   804,   804,   804,   805,   806,
     807,   807,   808,   808,   808,   808,   808,   808,   808,   808,
     808,   808,   808,   808,   808,   808,   808,   808,   809,   809,
     810,   810,   811,   812,   812,   813,   814,   814,   815,   816,
     816,   816,   816,   816,   817,   817,   818,   819,   819,   819,
     819,   819,   819,   820,   821,   821,   821,   822,   822,   823,
     823,   823,   823,   823,   824,   824,   825,   825,   825,   825,
     826,   826,   827,   827,   828,   828,   829,   829,   830,   830,
     831,   831,   832,   832,   832,   832,   833,   833,   833,   833,
     833,   833,   833,   834,   834,   835,   836,   836,   836,   837,
     837,   837,   837,   838,   838,   839,   839,   840,   840,   840,
     840,   841,   841,   842,   842,   843,   844,   844,   844,   845,
     845,   846,   847,   847,   848,   849,   849,   850,   851,   851,
     852,   852,   852,   852,   852,   852,   852,   852,   853,   853,
     854,   855,   855,   856,   856,   857,   858,   859,   860,   860,
     861,   862,   862,   863,   863,   863,   863,   863,   864,   864,
     864,   865,   865,   866,   866,   867,   867,   867,   867,   867,
     867,   867,   867,   868,   868,   869,   869,   869,   869,   869,
     869,   870,   870,   871,   871,   872,   873,   873,   873,   874,
     874,   874,   874,   874,   874,   874,   874,   875,   875,   876,
     876,   876,   877,   877,   877,   877,   878,   878,   879,   880,
     880,   881,   881,   882,   882,   882,   882,   883,   883,   884,
     884,   884,   885,   885,   886,   886,   887,   888,   888,   888,
     889,   890,   890,   891,   891,   892,   892,   893,   893,   894,
     894,   895,   895,   896,   896,   897,   897,   898,   898,   899,
     899,   900,   900,   901,   901,   902,   902,   902,   902,   902,
     902,   902,   902,   902,   902,   902,   903,   903,   903,   903,
     903,   903,   904,   904,   904,   904,   905,   905,   905,   905,
     906,   906,   907,   907,   908,   908,   908,   908,   909,   909,
     910,   910,   910,   911,   912,   912,   913,   913,   913,   914,
     914,   915,   916,   916,   916,   916,   916,   916,   917,   917,
     917,   918,   918,   918,   918,   918,   918,   918,   919,   919,
     919,   919,   920,   920,   921,   921,   922,   922,   922,   922,
     922,   922,   922,   922,   922,   922,   922,   923,   923,   924,
     924,   925,   925,   926,   927,   928,   928,   929,   929,   930,
     931,   932,   932,   932,   932,   932,   932,   933,   933,   934,
     934,   935,   935,   935,   935,   936,   937,   937,   937,   938,
     938,   938,   938,   938,   938,   938,   938,   938,   938,   938,
     938,   938,   938,   939,   939,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   941,   941,   941,   941,   941,   941,   941,
     941,   941,   941,   941,   941,   941,   941,   941,   941,   941,
     941,   941,   941,   941,   941,   942,   942,   942,   942,   942,
     942,   942,   942,   942,   942,   942,   943,   943,   943,   943,
     943,   943,   943,   943,   943,   943,   943,   943,   943,   943,
     943,   943,   943,   943,   943,   943,   943,   943,   943,   943,
     943,   943,   943,   943,   943,   943,   943,   943,   943,   943,
     943,   943,   943,   943,   943,   943,   943,   943,   943,   943,
     943,   943,   943,   943,   944,   944,   945,   945,   945,   945,
     946,   947,   947,   948,   948,   949,   949,   950,   950,   950,
     951,   951,   952,   952,   953,   954,   954,   954,   955,   956,
     956,   957,   957,   958,   958,   958,   959,   959,   960,   960,
     960,   960,   960,   961,   961,   961,   962,   962,   962,   963,
     963,   964,   964,   964,   964,   964,   964,   964,   964,   964,
     965,   965,   966,   966,   967,   967,   967,   967,   967,   967,
     968,   968,   969,   969,   970,   970,   971,   971,   972,   972,
     972,   973,   973,   974,   974,   975,   975,   975,   975,   975,
     975,   975,   975,   976,   976,   977,   978,   978,   979,   979,
     979,   979,   979,   979,   980,   981,   982,   982,   982,   983,
     983,   984,   985,   985,   986,   987,   987,   988,   988,   989,
     989,   990,   990,   990,   990,   991,   991,   992,   992,   993,
     993,   994,   994,   995,   995,   996,   997,   997,   998,   998,
     998,   998,   999,   999,  1000,  1000,  1001,  1001,  1002,  1003,
    1004,  1005,  1006,  1007,  1008,  1008,  1009,  1009,  1009,  1009,
    1009,  1009,  1009,  1009,  1009,  1009,  1009,  1009,  1009,  1009,
    1009,  1010,  1011,  1012,  1012,  1012,  1012,  1013,  1013,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,
    1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,
    1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,
    1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,
    1015,  1015,  1015,  1016,  1016,  1016,  1016,  1016,  1016,  1016,
    1016,  1016,  1016,  1016,  1016,  1016,  1016,  1016,  1016,  1016,
    1016,  1016,  1016,  1016,  1016,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1018,  1018,  1019,  1019,  1019,  1019,  1019,  1019,  1019,  1019,
    1021,  1020,  1022,  1023,  1023,  1023,  1023,  1024,  1024,  1024,
    1024,  1025,  1025,  1026,  1027,  1028,  1028,  1029,  1029,  1029,
    1030,  1030,  1031,  1031,  1032,  1032,  1033,  1033,  1033,  1033,
    1034,  1034,  1034,  1035,  1036,  1036,  1037,  1037,  1038,  1038,
    1038,  1038,  1039,  1039,  1040,  1041,  1042,  1043,  1043,  1044,
    1045,  1045,  1046,  1046,  1046,  1046,  1046,  1048,  1047,  1049,
    1050,  1051,  1051,  1052,  1052,  1052,  1052,  1053,  1053,  1055,
    1054,  1057,  1056,  1058,  1056,  1056,  1059,  1059,  1060,  1060,
    1060,  1061,  1061,  1061,  1061,  1062,  1062,  1063,  1063,  1063,
    1063,  1063,  1063,  1064,  1064,  1064,  1065,  1067,  1066,  1068,
    1069,  1068,  1070,  1070,  1071,  1071,  1072,  1072,  1073,  1073,
    1073,  1073,  1073,  1073,  1073,  1073,  1073,  1074,  1074,  1074,
    1074,  1074,  1074,  1074,  1074,  1074,  1074,  1075,  1075,  1076,
    1076,  1077,  1078,  1078,  1079,  1079,  1079,  1080,  1081,  1082,
    1082,  1082,  1082,  1083,  1083,  1083,  1084,  1084,  1085,  1085,
    1086,  1087,  1087,  1088,  1088,  1089,  1089,  1090,  1090,  1091,
    1092,  1092,  1093,  1093,  1093,  1094,  1094,  1094,  1094,  1094,
    1094,  1094,  1094,  1094,  1095,  1095,  1095,  1095,  1095,  1096,
    1096,  1097,  1098,  1099,  1100,  1100,  1101,  1102,  1103,  1103,
    1104,  1105,  1105,  1106,  1107,  1108,  1108,  1109,  1110,  1111,
    1111,  1112,  1113,  1113,  1113,  1113,  1113,  1114,  1114,  1114,
    1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,
    1114,  1114,  1115,  1115,  1116,  1116,  1117,  1117,  1117,  1119,
    1118,  1120,  1120,  1122,  1121,  1123,  1123,  1123,  1124,  1124,
    1124,  1124,  1124,  1124,  1124,  1124,  1124,  1125,  1125,  1126,
    1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,
    1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,
    1126,  1126,  1126,  1127,  1127,  1127,  1127,  1127,  1127,  1128,
    1128,  1128,  1128,  1128,  1128,  1128,  1129,  1130,  1130,  1130,
    1130,  1130,  1130,  1130,  1130,  1131,  1131,  1131,  1131,  1131,
    1131,  1131,  1132,  1132,  1132,  1132,  1132,  1132,  1133,  1133,
    1133,  1133,  1133,  1133,  1133,  1133,  1133,  1133,  1133,  1134,
    1134,  1134,  1134,  1134,  1135,  1135,  1135,  1135,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1137,  1137,  1137,  1138,  1138,
    1138,  1138,  1138,  1138,  1139,  1139,  1140,  1141,  1141,  1142,
    1142,  1143,  1144,  1145,  1146,  1146,  1146,  1147,  1148,  1149,
    1150,  1151,  1151,  1151,  1151,  1151,  1152,  1153,  1153,  1153,
    1154,  1154,  1155,  1155,  1155,  1156,  1156,  1157,  1157,  1158,
    1158,  1159,  1159,  1159,  1159,  1159,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1161,  1161,  1161,  1161,  1162,  1162,  1162,  1162,
    1162,  1162,  1162,  1162,  1162,  1163,  1163,  1163,  1163,  1163,
    1164,  1164,  1165,  1165,  1166,  1166
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     5,     1,     0,     2,     0,
       2,     0,     2,     2,     3,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     3,
       2,     1,     2,     2,     2,     3,     3,     5,     5,     0,
       3,     5,     5,     4,     3,     5,     3,     5,     5,     6,
       1,     1,     3,     5,     6,     4,     1,     0,     2,     0,
       1,     1,     1,     1,     1,     1,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     5,     2,     2,     2,
       2,     3,     3,     3,     1,     3,     1,     3,     1,     1,
       1,     2,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     3,     6,     1,     1,     1,     1,     1,     0,     1,
       1,     2,     3,     4,     3,     2,     2,     1,     3,     4,
       5,     4,     2,     4,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     4,     4,     4,     4,     1,     3,     2,
       3,     4,     6,     6,     6,     5,     5,     6,     6,     4,
       7,     2,     6,     4,     3,     3,     3,     3,     3,     4,
       4,     3,     3,     3,     3,     3,     3,     4,     4,     3,
       2,     3,     3,     3,     2,     2,     3,     2,     1,     1,
       0,     2,     0,     3,     2,     0,     1,     3,     3,     1,
       5,     3,     2,     2,    10,     6,     1,     1,     1,     1,
       1,     1,     3,     2,     0,     1,     1,     3,     3,     1,
       1,     3,     3,     3,     3,     4,     1,     0,     2,     0,
       3,     0,     1,     0,     1,     3,     2,     1,     1,     1,
       1,     3,     0,     1,     3,     1,     1,    11,    10,     1,
       1,     2,     2,     2,     2,     0,     1,     0,     3,     0,
       1,     3,     1,     3,     1,     1,     1,     1,     1,     3,
       4,     2,     0,     3,     1,     1,     2,     1,     3,     4,
       4,     2,     5,     1,     2,     2,     2,     3,     3,     3,
       0,     1,     1,     1,     1,     1,     1,     3,     1,     5,
       7,     8,     9,    11,     3,     0,     1,     3,     1,     2,
       2,     2,     0,     1,     3,     3,     6,     4,     0,     1,
       1,     2,     2,     0,     3,     3,     2,     1,     1,     2,
       2,     4,     0,     2,     2,     2,     0,     3,     4,     4,
       0,     2,     0,     4,     0,     5,     3,     0,     1,     3,
       1,     2,     3,     0,     5,     4,     1,     0,     1,     2,
       2,     1,     2,     3,     2,     2,     2,     2,     3,     3,
       1,     3,     1,     0,     1,     2,     1,     6,    10,     1,
       0,     1,     2,     2,     0,     2,     2,     1,     0,     5,
       7,     1,     0,     6,     2,     0,     3,     5,     7,     6,
       8,     7,     6,     6,     4,     0,     1,     3,     4,     1,
       3,     1,     2,     2,     2,     2,     1,     1,    10,     2,
       0,     2,     2,     1,     0,     4,     6,     5,     4,     4,
       8,     1,     1,     1,     7,     9,     8,    15,    20,     1,
       1,     1,     3,     1,     1,     1,     3,     1,     3,     0,
       1,     0,     1,     1,     4,     0,     1,     3,     0,     1,
       1,     1,     1,     1,     1,     2,     0,     1,     2,     1,
       2,     0,     2,     1,     2,     2,     6,     8,     8,     4,
       5,     4,     4,     4,     3,     7,     8,     6,     6,     6,
       6,     3,     1,     3,     3,     1,     1,     1,     1,     1,
       1,     3,     3,     3,     1,     3,     3,     1,     0,     1,
       3,    13,     1,     3,     4,     5,     4,     7,     2,     1,
       0,     2,     0,     1,     0,     6,     8,     8,     1,     3,
       5,     5,     7,     9,     7,     9,     5,     6,     6,     4,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     3,
       3,     3,     1,     3,     1,     2,     2,     3,     5,     2,
       2,     0,     6,     7,     7,     7,     8,     8,     6,     8,
       9,     9,     7,    10,     7,     8,     8,     8,     8,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     3,     4,     5,     4,     5,
       3,     4,     3,     4,     1,     2,     3,     3,     3,     3,
       4,     4,     3,     3,     4,     4,     4,     4,     1,     1,
       1,     0,     7,     7,    10,     1,     1,     2,     4,     5,
       1,     3,     2,     2,     2,     2,     1,     2,     2,     4,
       3,     2,     2,     2,     3,     2,     2,     5,     5,     5,
       1,     3,     1,     2,     3,     0,     1,     3,     2,     6,
       6,     9,     3,     0,     3,     0,     5,     2,     0,     3,
       3,     3,     7,     7,    10,     1,     1,     1,    14,     1,
       0,     1,     0,     1,     0,     2,     0,     1,     3,     4,
       4,     6,     1,     2,     0,     1,     1,     0,     1,     1,
       0,     9,    12,     7,     2,     0,     3,     2,     1,     3,
       3,     2,     1,     3,     3,     3,     2,     2,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     4,     5,     1,
       3,     3,     1,     2,     4,     5,     1,     1,     1,     1,
       3,     3,     2,     2,     2,     2,     1,     2,     2,     1,
       1,     1,     3,     2,     0,     2,     1,     3,     5,     1,
       2,     1,     0,     5,     7,     5,     7,     5,     7,     3,
       5,     5,     5,     1,     3,     2,     1,     2,     1,     2,
      11,    10,    10,     2,     2,     0,     9,     2,     0,     4,
       4,     4,     1,     1,     1,     0,     7,     6,     6,     6,
       6,     7,     9,     9,     6,     6,     6,     6,     6,     8,
       8,     6,     6,     6,     5,     5,     8,     8,     8,     8,
       6,     1,     0,     2,     0,     7,     6,     6,     6,     6,
       6,     6,     7,     6,     6,     6,     6,     7,     7,     7,
       9,     9,     6,     6,     6,     8,     8,     8,     6,    13,
       1,     1,     3,     3,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     1,     1,     1,     1,     1,     0,     6,
       8,     3,     2,     0,     2,     2,     2,     2,     3,     3,
       2,     2,     2,     2,     3,     2,     5,     4,     3,     3,
       3,     1,     1,     0,     3,     2,     2,     1,     3,     2,
       1,     0,     8,    10,     3,     4,     4,     0,     2,     5,
       2,     0,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     4,     3,     3,     1,     0,
       5,     6,     4,     2,     0,     4,     3,     5,     6,     4,
       6,     6,     5,     7,     1,     0,     6,    11,    11,    11,
      13,     9,    11,    10,     4,     2,     5,     2,     0,     4,
       5,     5,     4,     6,     1,     3,     1,     1,     1,     1,
       2,     4,     1,     1,     1,     0,     1,     0,     1,     0,
       3,     0,     2,     4,     3,     5,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     2,     1,     1,     1,     1,
       1,     1,     0,     5,     4,     3,     0,     1,     1,     1,
       1,     4,     8,     3,     0,     5,     1,     4,     2,     1,
       3,     2,     2,     0,     6,     2,     0,     5,     3,     0,
       2,     2,     2,     3,     1,     3,     1,     2,     1,     0,
       7,     1,     3,     1,     1,     3,     5,     2,     1,     3,
       7,     1,     1,     0,     3,     2,     2,     2,     0,     2,
       2,     1,     1,     3,     3,     1,     2,     4,     4,     2,
       3,     5,     5,     1,     1,     9,     1,     2,     4,     4,
       4,     2,     3,     1,     3,     4,     2,     1,     0,     3,
       3,     4,     4,     4,     4,     2,     1,     1,     0,     1,
       1,     0,     1,     5,     1,     0,     1,     0,     3,     1,
       3,     4,     3,     2,     2,     1,     1,     1,     0,     2,
       4,     5,     2,     3,     1,     1,     1,     1,     3,     0,
       1,     1,     1,     1,     1,     3,     0,     2,     0,     1,
       3,     1,     0,     1,     2,     4,     4,     2,     0,     2,
       3,     2,     0,     1,     3,     1,     2,     1,     2,     5,
       6,     5,     1,     2,     1,     4,     3,     4,     5,     4,
       5,     4,     5,     2,     4,     1,     2,     2,     2,     1,
       1,     0,     4,     2,     1,     2,     2,     4,     1,     3,
       1,     2,     3,     1,     2,     0,     2,     4,     0,     1,
       3,     2,     2,     3,     5,     6,     2,     3,     3,     4,
       0,     1,     1,     1,     1,     1,     2,     5,     1,     1,
       1,     1,     2,     3,     3,     0,     1,     1,     1,     1,
       1,     2,     2,     2,     2,     2,     1,     3,     0,     1,
       1,     1,     1,     5,     2,     1,     1,     1,     1,     5,
       2,     2,     2,     1,     3,     3,     2,     1,     0,     3,
       0,     5,     2,     5,     2,     1,     2,     3,     0,     1,
       1,     1,     1,     1,     1,     3,     3,     3,     3,     3,
       3,     3,     0,     1,     4,     1,     3,     5,     2,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       2,     2,     3,     3,     2,     3,     5,     4,     6,     3,
       5,     4,     6,     4,     6,     5,     7,     3,     2,     4,
       2,     3,     3,     4,     3,     4,     3,     4,     5,     6,
       6,     7,     6,     7,     6,     7,     3,     4,     4,     6,
       2,     3,     4,     1,     3,     2,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     2,     2,     5,
       6,     6,     7,     3,     4,     1,     1,     2,     4,     1,
       1,     1,     2,     2,     2,     1,     4,     5,     6,     8,
       6,     7,     7,     5,     1,     1,     4,     1,     4,     1,
       4,     1,     4,     1,     1,     1,     1,     1,     1,     6,
       4,     4,     4,     4,     6,     5,     5,     5,     4,     6,
       4,     4,     4,     4,     5,     7,     7,     9,     4,     6,
       5,     7,     7,     7,     2,     3,     3,     3,     4,     0,
       4,     1,     3,     3,     1,     1,     1,     2,     2,     0,
       2,     0,     1,     3,     3,     2,     2,     0,     6,     1,
       0,     3,     0,     2,     2,     0,     1,     4,     2,     2,
       2,     2,     2,     4,     3,     5,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     1,     4,     1,     4,     1,     2,     1,     2,
       1,     3,     1,     3,     1,     3,     1,     3,     3,     3,
       2,     1,     3,     3,     0,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     3,     2,     3,     0,     3,     3,
       2,     2,     1,     0,     2,     2,     3,     2,     1,     1,
       3,     5,     1,     2,     4,     2,     0,     1,     0,     1,
       2,     2,     2,     3,     5,     1,     2,     0,     2,     1,
       0,     1,     1,     1,     3,     3,     1,     3,     3,     2,
       1,     1,     1,     3,     1,     2,     1,     3,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     1,     1,
       1,     2,     5,     2,     3,     6,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     2,     4,     3,     2,     1,     1,     1,     1,     1,
       0,     8,     2,     5,     3,     2,     2,     3,     7,     1,
       1,     1,     0,     2,     2,     1,     0,     1,     3,     1,
       2,     0,     2,     0,     2,     0,     1,     3,     4,     3,
       1,     1,     1,     1,     2,     0,     2,     4,     0,     2,
       2,     2,     1,     1,     7,     3,     1,     1,     1,     1,
       2,     0,     1,     3,     3,     3,     3,     0,     4,     5,
       5,     0,     1,     1,     1,     2,     2,     1,     2,     0,
       7,     0,     5,     0,     4,     2,     2,     0,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       5,     2,     1,     3,     2,     2,     3,     0,     5,     1,
       0,     5,     2,     2,     1,     1,     1,     2,     2,     3,
       1,     2,     2,     3,     3,     4,     2,     1,     2,     1,
       1,     2,     2,     3,     1,     1,     1,     1,     0,     1,
       3,     5,     0,     2,     0,     1,     2,     3,     2,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     2,     2,
       3,     0,     1,     2,     1,     4,     3,     4,     3,     2,
       1,     3,     1,     1,     1,     1,     2,     2,     1,     2,
       2,     1,     1,     1,     4,     4,     4,     4,     4,     1,
       0,     3,     3,     4,     1,     3,     3,     4,     1,     3,
       3,     1,     1,     1,     6,     1,     3,     3,     6,     1,
       3,     3,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     4,     4,     1,     1,     4,     4,     3,     0,
       7,     1,     0,     0,     7,     3,     4,     3,     1,     1,
       1,     2,     3,     5,     2,     5,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     0,     1,     2,
       1,     2,     1,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     3,     1,     2,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     3,     2,     3,     1,     3,     3,     3,
       3,     3,     3,     1,     1,     0,     2,     2,     1,     1,
       2,     1,     1,     1,     0,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
    2090,     0,     2,     1,  2520,  2524,  2528,  2529,  2446,  2530,
    2531,  2496,  2497,  2498,  2499,  2500,  2501,  2502,  2503,  2504,
    2505,  2506,  2507,  2509,  2508,  2510,  2511,  2512,  2513,  2514,
    2515,  2516,  2517,  2519,  2518,  2468,  2097,  2465,  2462,  2463,
    2464,  2469,  2467,  2460,  2461,  1701,  2533,  2521,  2534,  2522,
    2523,  2525,  2526,  2495,  2527,  2535,  2536,  2537,  2532,  2540,
    2491,  2492,  2490,  2493,  2494,  2538,  2539,  2482,  2483,  2484,
    2485,  2541,  2098,  2099,  2487,  2091,  2095,  2157,  2228,  2488,
    2489,  2486,  2096,  2481,  2228,     0,  2349,  2350,  2351,     0,
    2352,  2353,  2354,  2280,  2242,  2355,     0,     0,  2356,  2357,
    2358,  2359,  2360,  2361,  2362,  2363,     0,  2364,  2365,  2366,
    2367,  2227,  2368,  2369,  2370,  2371,  2372,  2204,  2210,  2333,
       0,  2184,  2185,  2181,  2183,  2182,  2186,  2169,  1003,   502,
    1083,  1082,     0,  1993,  1003,  1950,  1951,  1994,  1952,  1953,
    1954,   248,     0,  1085,  1955,     0,  1003,  1995,   337,   815,
    1996,  1997,  2112,     0,  1956,  1957,     0,     0,     0,     0,
     502,  1003,     0,     0,  1958,     0,  1959,     0,  1960,  1998,
    1999,     0,  1961,  2000,  2001,  1962,     0,  1963,  1964,  2002,
    2003,  2004,  1965,  2005,  2006,     0,     0,  1208,     0,  1966,
    2007,  1967,  1968,     0,  2008,  1969,  1970,  1971,  2009,  2010,
    2011,  1972,  1973,  1974,     0,  1975,     0,     0,     0,     0,
       0,  2012,  1003,  1976,     0,  1215,     0,  1977,     0,  2013,
    1978,     0,  1979,     0,  1980,  1981,  1982,  1983,  1208,  2329,
    2205,     0,     0,  1087,     0,  1984,  2014,     0,  1985,  1986,
    1987,  1988,  1989,  1990,  1991,  1992,     0,     0,    47,    48,
      16,    15,    21,    20,    70,    71,    37,    10,    61,    42,
     102,   101,   103,    27,    23,    55,    14,    24,    28,    44,
      43,    13,    41,    65,    45,    68,    34,    59,     7,    35,
      60,     8,    49,    72,    19,    46,    69,    30,    57,    53,
      38,    39,    40,    62,    63,    64,    86,    67,    97,    26,
      76,    77,    92,    78,    93,     5,    79,    36,     9,    89,
      88,    90,    56,    31,    58,    87,    91,    11,    12,    94,
      66,    84,    81,    98,    96,   104,    82,    50,     3,     4,
      73,    33,     6,    18,    17,    32,    25,   100,    22,  1085,
      75,    85,    74,    80,    54,    83,    99,    52,    95,  1184,
    1171,  1217,  1183,     0,  1186,  2425,  2426,    29,   124,   106,
     107,   112,  2094,  2146,  2147,  2148,  2228,  2179,  2180,  2173,
    2189,  2199,  2188,  2192,  2200,  2187,  2206,     0,   109,   111,
     113,   116,   110,   105,   108,   115,   120,   114,   119,   117,
     118,   121,   122,   123,  2427,  1392,  2424,    51,  2164,  2163,
       0,  2228,     0,  2373,  2374,  2375,  2376,  2377,  2378,  2428,
    2429,  2430,  2431,  2432,  2434,  2433,  2457,  1709,  1710,  1711,
    1712,  1713,  1714,  1715,  1716,  1717,  1718,  1719,  1720,  1721,
    1722,  1723,  1724,  1725,  1726,  1727,  1728,  1729,  1730,  1731,
    1732,  2400,  1733,  1734,  1735,  1736,  1737,  1738,  1739,  1740,
    1741,  1742,  2437,  1743,  1744,  1745,  1746,  1747,  1748,  1749,
    1750,  1751,  1752,  1753,  1754,  1755,  1756,  2438,  1757,  1758,
    1759,  1760,  1761,  1762,  1763,  1764,  1765,  1766,  1767,  1768,
    1769,  1770,  1771,  1772,  1773,  1774,  1775,  1776,  1777,  1778,
    1779,  1780,  1781,  1782,  1783,  1784,  1785,  1786,  1787,  1788,
    1789,  1790,  1791,  1792,  1793,  1794,  1795,  2439,  1796,  1797,
    1798,  1799,  1800,  1801,  1802,  1803,  1804,  1805,  1806,  1807,
    1808,  1809,  1810,  1811,  1812,  1813,  1814,  1815,  1816,  1817,
    1818,  1819,  1820,  1821,  1822,  1823,  1824,  1825,  1826,  1827,
    1828,  2440,  1829,  1830,  2441,  1831,  1832,  1833,  1834,  1835,
    1836,  1837,  1838,  1839,  1840,  1841,  1842,  1843,  1844,  1845,
    1846,  1847,  1848,  1849,  1850,  1851,  1852,  1853,  1854,  1855,
    1856,  1857,  1858,  1859,  1862,  1860,  1861,  1863,  1864,  1865,
    1866,  1867,  1868,  1869,  1870,  1871,  1872,  1873,  1874,  1875,
    1876,  1877,  1878,  1879,  1880,  1881,  1882,  1883,  1884,  1885,
    1886,  1887,  1888,  1889,  1890,  1891,  1892,  2442,  1893,  1894,
    1895,  1896,  1897,  1898,  1899,  1900,  1901,  1902,  1903,  1904,
    1905,  1906,  1907,  1908,  1909,  1910,  1911,  1912,  1913,  1914,
    1915,  1916,  1917,  1918,  1919,  1920,  1921,  2112,  1922,  1923,
    1924,  1925,  1926,  1927,  1928,  1929,  1930,  1931,  1932,  1933,
    1934,  1935,  1936,  1937,  2401,  1938,  1939,  1940,  1941,  1942,
    1943,  1944,  1945,  1946,  1947,  2443,  1948,  1949,  2130,  2435,
    2397,  2105,  2126,  2398,  2347,  2348,  1702,  2399,  2396,  2436,
    2132,  2453,  2131,  2395,  2279,     0,     0,  2241,  2240,  2244,
    2243,  2245,  2238,  2239,  1679,  2133,  2249,  2248,  1161,  2452,
    1678,  1162,     0,  2251,  2379,  2380,  2381,  2382,  2384,  2383,
    2385,  2015,  2016,  2017,  2018,  2019,  2020,  2021,  2022,  2023,
    2024,  2025,  2026,  2410,  2027,  2028,  2029,  2423,  2030,  2031,
    2411,  2032,  2033,  2034,  2035,  2036,  2037,  2038,  2039,  2040,
    2041,  2042,  2043,  2044,  2045,  2046,  2047,  2048,  2049,  2050,
    2051,  2052,  2053,  2054,  2055,  2412,  2413,  2056,  2057,  2058,
    2059,  2060,  2061,  2062,  2063,  2064,  2065,  2066,  2067,  2068,
    2069,  2070,  2071,  2072,  2073,  2074,  2075,  2076,  2077,  2078,
    2079,  2414,  2080,  2081,  2415,  2082,  2083,  2084,  2416,  2085,
    2086,  2087,  2088,  2089,  2420,  2421,  2422,  2409,  2202,  2386,
    2408,  2419,  2417,  2418,  2212,  2208,  2216,  2211,     0,     0,
       0,     0,  2228,  1002,  1001,   987,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   501,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2102,     0,  1011,   313,   312,  1084,  1065,   502,     0,   990,
     336,     0,     0,     0,     0,     0,     0,     0,   629,     0,
       0,     0,     0,     0,     0,     0,     0,   177,     0,     0,
     360,   359,     0,     0,     0,   789,     0,     0,     0,     0,
     490,  2111,  2106,  2116,     0,  2109,  2110,  2395,     0,  2544,
    1860,  2142,  2143,  2542,  1906,  1163,     0,   249,   252,   250,
     251,     0,   885,   886,   888,     0,     0,   898,   656,     0,
     655,     0,     0,     0,   653,     0,     0,     0,     0,   657,
     651,     0,   650,     0,     0,     0,   654,     0,   652,     0,
       0,   991,     0,  2194,  2195,  1798,  1124,   365,     0,     0,
       0,     0,  1085,  1092,  1102,  1097,  1099,  1098,  1100,  1096,
    1101,  1710,   731,  1723,   731,  1788,   728,   729,   731,   731,
     731,  1874,     0,     0,   703,     0,   714,  1703,   731,  1704,
    2453,   736,   415,   415,   415,     0,   735,   740,   415,     0,
     984,  1018,  1683,  1207,     0,  1723,  1788,   704,   983,  1922,
    1116,     0,     0,   902,     0,   903,     0,  1889,   995,   235,
    2393,  1898,  1980,  1922,  2394,   231,  2388,  2389,  2391,   204,
    2392,  2390,  2387,  1714,     0,     0,   735,     0,   992,   993,
    1214,  1212,     0,     0,     0,  1731,     0,  1743,  1822,   228,
    1885,  1890,  1898,  1980,  1922,  1947,   186,     0,   242,  1898,
    1980,  1922,     0,  1011,     0,  1187,  1294,  1674,     0,     0,
    2203,   986,   985,  1300,     0,  1086,     0,  1089,     0,  1259,
    1872,  1191,  1193,  1091,  1184,     0,  2093,  1080,  1211,  1211,
       0,  1211,     0,  1176,  1184,  1179,  1183,     0,  1003,     0,
    2171,  2199,  2178,  2234,  2175,     0,     0,  2224,  2220,  2217,
    2225,  2226,  2219,  2207,  1381,  1382,  1383,  1380,  1393,  1379,
       0,  2152,  1384,  2191,  2158,     0,  2166,  2165,  2470,  2471,
    2281,  2104,  2123,     0,     0,     0,     0,     0,     0,     0,
    2250,  2252,  2254,  2214,  2213,  2209,     0,     0,     0,     0,
    2339,  2340,  2338,     0,  2335,  2337,     0,  2234,     0,  2404,
    2398,  2407,     0,  1684,  2399,  2396,  2395,     0,   664,   127,
     778,     0,     0,     0,     0,     0,     0,     0,  1579,  1735,
    1784,  1589,  1587,  1588,  1581,  1582,  1583,  1584,  1585,  1586,
       0,   883,  1580,     0,   127,     0,     0,     0,     0,     0,
       0,     0,     0,  1826,   127,     0,     0,     0,     0,     0,
    1007,  1010,   988,  1068,     0,  1674,     0,     0,   689,     0,
     698,   690,   695,     0,   692,     0,     0,   700,     0,   691,
     693,   694,   699,     0,     0,   696,   697,     0,     0,   999,
     415,     0,     0,     0,     0,     0,   127,  1055,     0,   364,
     363,   127,   362,   361,  1735,  1784,     0,   814,   127,     0,
     179,   530,   505,     0,     0,   594,  1826,   127,     0,     0,
       0,     0,   792,     0,     0,   489,   502,     0,  2115,  2121,
       0,  2113,  2282,  2545,  2543,  2237,     0,  1136,   889,   229,
     230,   887,  1797,     0,   300,     0,     0,  1797,  1046,     0,
    1797,     0,  1797,   172,  1676,  1735,  1784,  1797,     0,     0,
    1797,   164,  1797,     0,  1797,   300,  1797,   506,     0,  1797,
       0,  1797,  1826,   166,     0,  1797,   300,   662,     0,     0,
    2475,  2479,     0,  2477,  2472,  2193,  2247,  2246,  2145,     0,
    2555,     0,  1163,  1094,  2401,  1108,  1107,     0,  1103,  1112,
    1106,     0,   731,   730,     0,   731,     0,  2564,   731,     0,
     731,     0,  2564,   731,     0,     0,     0,   731,  1705,  1706,
       0,     0,  2563,  2561,  2562,   705,   715,     0,   737,     0,
       0,   744,   743,   742,     0,     0,     0,   745,     0,  1298,
    1139,     0,   712,     0,   710,     0,   981,   998,     0,     0,
       0,     0,   905,   905,   905,   994,   234,   232,     0,     0,
       0,     0,     0,     0,  1000,     0,     0,  2459,  1690,  1590,
    2458,     0,  1951,  1952,  1953,  1648,     0,  2400,  1954,  1955,
    1507,  1494,  1503,  1508,  1495,  1497,  1504,  1956,  1957,  1770,
    1958,  1959,  1697,  1960,  1961,  1336,  1963,  1964,  1965,  1499,
    1501,  1966,  1967,     0,  1698,  1969,  1970,  1849,  1972,  1973,
    1975,  1976,  1505,  1978,  1979,  1980,  1981,  1982,  1983,  1696,
       0,  1506,  1984,  1986,  1987,  1988,  1989,  1990,  1991,  1992,
       0,     0,  1671,     0,  1481,     0,  1328,  1329,  1351,  1352,
    1330,  1357,  1358,  1370,  1331,     0,  1670,  1395,  1480,  1485,
       0,  1479,  1475,  1198,  1666,     0,  1476,  1686,  1649,  1700,
    1699,  2453,  1657,  1689,  1687,  1688,     0,     0,     0,   197,
       0,     0,  2328,   244,     0,   245,  1672,  1898,   187,   227,
     199,   226,   200,   198,     0,  1733,   188,     0,   195,     0,
       0,     0,     0,     0,     0,     0,   238,   989,     0,  1296,
    1295,     0,     0,  1655,  1675,   671,     0,     0,  1301,     0,
    1078,  1079,  1077,     0,  1074,  1076,  1088,  1085,  1662,  1661,
    1663,     0,  1192,     0,     0,     0,  1174,  1173,  1091,  1209,
    1210,     0,     0,     0,     0,     0,     0,     0,     0,  1252,
    1225,  1226,  1228,  1249,  1253,     0,  1180,  1260,  2092,  2234,
    2235,     0,  2229,     0,  2228,  2228,  2222,  2221,  2218,     0,
       0,     0,     0,     0,     0,     0,  2149,   486,  2151,   484,
       0,     0,  2125,     0,  2129,  2127,     0,  2274,  2277,     0,
    2275,  2276,  2278,     0,  2283,  2284,     0,     0,     0,  2466,
       0,     0,  2265,  2253,  2260,  2262,  2264,  2263,  2272,  2268,
    2271,  2273,  2215,  2228,  2346,     0,  2341,  2344,     0,  2336,
       0,     0,     0,  1685,     0,     0,     0,   665,     0,     0,
       0,   126,  1044,   237,  1042,     0,     0,     0,     0,     0,
    1049,     0,     0,     0,     0,   847,     0,     0,     0,     0,
       0,     0,   848,   846,   849,   856,   869,   872,     0,   768,
     170,   171,     0,     0,     0,   932,     0,     0,   932,     0,
       0,     0,     0,     0,     0,     0,   254,   257,     0,     0,
       0,     0,     0,     0,     0,     0,   131,     0,     0,     0,
       0,   471,   483,     0,     0,     0,     0,     0,   480,     0,
     127,   255,   465,   468,     0,     0,     0,   539,   538,   932,
       0,   253,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   131,   163,     0,
       0,   256,     0,  2159,     0,  1005,  1006,     0,  1009,     0,
    1064,     0,     0,     0,     0,     0,     0,  1735,  1784,     0,
       0,     0,     0,     0,     0,   339,   319,   320,   127,   318,
       0,     0,   591,     0,  1339,  1368,  1346,  1368,  1368,  1335,
    1335,  1348,  1337,  1375,     0,  1368,  1335,  1340,     0,  1338,
    1378,  1378,  1363,     0,  1320,  1321,  1322,  1323,  1349,  1350,
    1324,  1355,  1356,  1325,  1392,  2405,  1335,  2406,  2403,  2402,
       0,  1021,  1054,     0,     0,   129,   630,     0,     0,   592,
       0,   129,     0,   175,     0,   534,     0,     0,     0,     0,
       0,     0,   550,   549,     0,     0,   593,     0,   129,   467,
       0,   457,   415,     0,   791,   794,     0,     0,     0,  2119,
    2114,  2117,     0,  2107,  2121,  1166,  1168,  1167,     0,  1165,
       0,  1308,     0,   300,   298,   299,   589,   897,     0,     0,
       0,     0,   300,     0,     0,  1797,     0,  1797,     0,     0,
     300,   300,     0,     0,     0,     0,   535,     0,   661,   659,
     658,   660,     0,     0,     0,     0,     0,  1797,   300,     0,
       0,   649,  2473,     0,     0,  2476,     0,  2196,  1600,     0,
    2558,  1121,  2559,     0,     0,     0,     0,   216,   218,   217,
     215,  1109,  1110,  1111,  1105,  1093,     0,   723,     0,  2564,
    2565,   708,     0,   718,     0,  2564,   706,     0,   719,   716,
     717,     0,     0,     0,  2560,  2444,  2450,   722,     0,     0,
     416,   418,     0,     0,  1756,     0,  1789,  1814,  1815,  1890,
    1894,     0,  1917,     0,   746,   773,   741,     0,     0,  1133,
    1126,     0,     0,  1149,   713,   711,   982,  1114,  1606,     0,
       0,     0,   904,   901,   900,   899,   233,   205,     0,     0,
       0,   775,  1889,   997,     0,     0,  1483,  1484,  1367,  1354,
    1647,     0,     0,  1362,  1361,     0,     0,     0,     0,  1344,
    1343,  1342,  1482,  1614,     0,  1341,     0,     0,     0,     0,
    1368,  1368,  1366,  1414,     0,  1345,     0,     0,  1627,     0,
    1633,     0,     0,     0,  1374,     0,  1372,     0,     0,  1450,
       0,     0,     0,     0,     0,     0,     0,  1398,  1399,  1481,
    1600,     0,  1693,     0,     0,  1360,     0,  1392,  1590,     0,
       0,     0,     0,  1660,  1598,     0,     0,  1428,  1596,     0,
    1430,     0,     0,     0,  1589,  1587,  1588,  1581,  1582,  1583,
    1584,  1585,  1586,  1594,  1411,     0,  1669,     0,  1410,     0,
       0,  1262,  1197,     0,  1691,  1650,     0,  2451,  2454,  1477,
    2325,  2324,  2323,  2322,  2293,     0,  2287,  2288,     0,  2326,
    2327,   246,   247,   243,     0,     0,   202,   201,     0,   224,
     225,   194,   223,     0,   219,   220,  1546,  1545,   203,   193,
     191,   189,   206,   208,   209,   210,   192,   190,   241,   239,
       0,     0,     0,  1652,  1651,  1681,  1656,     0,     0,   300,
    2228,  1302,     0,  1262,  1151,  1153,  1154,     0,  1657,  1072,
       0,  1069,  1665,     0,  1194,     0,     0,  1081,  1190,  1189,
    1218,  1219,   807,  1188,  1243,  1244,  1239,     0,  1258,  1258,
    1235,  1229,  1234,  1232,     0,  1236,  1395,  1251,  1178,  1223,
    1224,  1227,  1177,     0,  1254,  1252,  1228,     0,  2236,  2234,
    2174,  1320,  2228,  2167,  2228,  2223,  2155,  1386,  1387,  1388,
    1389,  1390,  1391,  2156,     0,  2153,  1385,  2154,   485,     0,
       0,     0,  2122,     0,  2103,  2128,  2259,  2368,  2291,     0,
    2292,     0,     0,  2256,     0,  2266,  2269,  2267,  2270,     0,
    1320,  2447,  2342,  2447,  1320,     0,     0,     0,     0,     0,
       0,     0,   666,     0,     0,     0,  1917,   236,  1040,     0,
       0,     0,     0,   777,   776,     0,     0,   796,     0,     0,
       0,  1052,   408,     0,   297,     0,     0,     0,     0,     0,
       0,     0,   854,     0,     0,     0,     0,   855,   852,   853,
    1890,   871,   870,   868,   829,   831,   830,     0,   833,   817,
       0,   818,     0,     0,   828,   836,   834,     0,     0,     0,
    1778,   259,   271,     0,   931,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   290,     0,     0,     0,     0,
     295,     0,     0,     0,   294,     0,     0,     0,     0,     0,
       0,     0,   884,     0,     0,   158,   161,     0,     0,   470,
     482,     0,   474,   475,   472,   476,   477,     0,     0,     0,
       0,     0,     0,   469,     0,     0,   532,   531,   537,     0,
       0,     0,     0,     0,   925,   924,     0,     0,     0,     0,
       0,     0,     0,     0,   541,   542,     0,   543,     0,   162,
       0,     0,     0,     0,     0,     0,   214,  1004,  1008,  1067,
    1682,  1066,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,     0,   614,  2402,   590,     0,  1320,     0,  1316,
    1312,  1381,  1380,  1379,     0,  1326,  1335,  1332,     0,  1019,
     382,   498,   168,     0,     0,     0,   602,   605,     0,   125,
     179,   365,     0,   178,   180,   182,   183,   184,   181,   185,
     529,   533,     0,   504,     0,     0,     0,     0,     0,   554,
     553,   557,   555,     0,   551,     0,     0,     0,   157,   464,
     466,  2100,     0,   367,   446,     0,     0,     0,   793,     0,
       0,     0,     0,     0,  2120,     0,     0,     0,     0,  1164,
       0,  1272,  1135,  1263,  1274,  1265,  1267,  1303,     0,  1674,
       0,  1133,     0,   875,     0,  1047,  1797,   300,     0,   873,
     173,  1677,     0,     0,     0,     0,     0,   877,   646,   165,
       0,   300,   300,   507,     0,   300,   167,     0,     0,     0,
     499,   300,   663,  2474,  2480,  2478,  1123,     0,  2556,  2557,
     457,  1168,  1095,  1104,   720,   727,   709,   726,   725,   707,
     724,   721,  2258,     0,     0,  2449,     0,   738,     0,   414,
       0,     0,     0,   752,     0,     0,   751,   766,   753,     0,
     755,   748,   747,   756,     0,     0,   775,  1128,     0,  1129,
    1657,     0,  1125,     0,  1146,     0,  1144,     0,  1299,  1148,
    1137,  1115,     0,  1113,  1118,  1120,  1119,  1117,     0,     0,
       0,   735,     0,     0,   300,   996,     0,  1610,     0,  1611,
       0,     0,     0,  1646,  1642,     0,     0,     0,     0,     0,
    1618,  1619,  1620,  1617,  1621,  1616,     0,     0,  1622,  1615,
       0,     0,     0,     0,     0,  1365,  1364,     0,     0,     0,
       0,     0,     0,     0,  1453,  1485,     0,     0,  1574,     0,
    1600,  1632,     0,     0,  1376,     0,     0,     0,     0,     0,
       0,     0,  1600,  1638,     0,     0,     0,  1544,     0,  1541,
       0,     0,     0,     0,  1657,     0,     0,     0,     0,  1694,
    1396,  1412,  1668,     0,  1659,     0,     0,  1419,     0,  1639,
    1446,     0,  1451,  1434,     0,  1427,     0,  1432,  1436,  1415,
    1660,  1599,     0,  1597,     0,     0,  1413,     0,  1408,  1406,
    1407,  1400,  1401,  1402,  1403,  1404,  1405,  1409,  1578,  1576,
    1577,     0,     0,     0,  1431,  1791,  1822,     0,  1208,  1208,
    1196,  1206,  1667,     0,  1305,     0,     0,     0,     0,  1557,
    1604,     0,  1602,  2456,  2455,  1658,     0,     0,     0,  1673,
       0,     0,  1392,     0,   240,  1297,  1653,     0,   669,   670,
     668,  1320,  1158,     0,     0,  1308,     0,  1157,  1091,  1075,
    1071,  1070,  1664,  1090,  1195,     0,   805,   806,     0,   810,
       0,     0,  1237,  1250,     0,  1149,  1149,     0,  1241,  1242,
    1233,  1182,  1181,  2172,  2230,  2177,  2198,  2168,  2201,  1394,
    2150,  2190,     0,  2124,  2294,  2295,     0,  2285,  2286,  2255,
    2261,  2332,     0,  2448,     0,     0,   612,   611,     0,     0,
       0,   943,   907,   667,   944,   908,  1041,     0,  1043,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   300,  1050,   945,   296,  1051,   936,     0,     0,
       0,   512,   513,     0,   850,   851,   946,   909,     0,   937,
     832,  1335,   816,     0,     0,   827,     0,   826,  1335,  1335,
     910,   169,   260,   382,   934,   276,   289,   284,   285,   283,
    1797,   300,  1797,   300,     0,     0,     0,     0,   286,   281,
     282,   278,   291,   292,   918,     0,   306,   309,   293,   274,
     277,   275,   258,     0,     0,  1680,     0,     0,   879,     0,
       0,   160,   921,     0,   140,   142,   144,     0,   138,   146,
     141,   143,   145,   139,   147,   137,     0,   136,     0,     0,
       0,   130,   952,   914,   473,   478,   916,   481,   939,   479,
    1713,  1771,  1899,     0,   519,   521,     0,   526,   958,   915,
       0,   938,   954,   923,     0,     0,     0,     0,     0,     0,
       0,  1056,     0,     0,     0,   953,   930,   941,     0,   922,
     917,   940,     0,     0,   212,   211,   213,     0,     0,     0,
       0,     0,     0,     0,     0,   702,   678,   701,     0,     0,
       0,     0,     0,     0,     0,   672,   338,   316,   317,     0,
       0,   315,   321,   613,     0,     0,     0,  1317,  1313,     0,
       0,     0,     0,     0,     0,  1333,     0,     0,  1039,  1039,
    1039,  1039,  1039,  1039,  1039,  1020,  1048,   497,   515,     0,
       0,     0,     0,   151,   128,     0,   635,   601,     0,     0,
     415,   174,     0,     0,     0,   503,   600,   598,   597,   599,
       0,     0,     0,   618,     0,  1309,     0,     0,     0,     0,
     369,     0,     0,   366,   370,   374,   375,   376,     0,   458,
     460,     0,     0,   450,     0,     0,     0,   821,     0,   839,
     822,     0,     0,     0,   859,   864,   860,   842,     0,   487,
    2118,  2112,  1169,  1170,     0,  1184,     0,  1274,     0,  1273,
    1285,     0,     0,  1291,  1289,     0,  1291,     0,  1291,     0,
    1266,     0,  1268,  1285,     0,  1675,     0,  1306,  1134,   300,
       0,     0,   509,   300,     0,   300,     0,   300,   300,     0,
     979,   536,     0,   586,     0,     0,   300,   648,  1601,     0,
       0,  2257,  2445,   739,   417,     0,     0,     0,     0,   750,
       0,  1707,   754,     0,   765,   760,   762,     0,   769,     0,
       0,  1131,  1132,  1147,  1140,  1142,  1141,     0,     0,  1138,
    1607,   647,     0,     0,   300,     0,   770,  1213,  1608,  1609,
       0,     0,     0,     0,  1643,     0,     0,  1520,  1496,  1498,
    1334,  1510,     0,  1347,  1521,  1522,  1500,  1502,     0,  1591,
       0,     0,  1511,  1455,  1456,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1468,  1467,
    1512,  1573,     0,     0,  1630,  1631,  1513,  1377,  1378,  1378,
       0,     0,  1637,     0,     0,     0,  1518,  1523,     0,     0,
    1528,     0,  1549,     0,     0,     0,  1478,  1601,  1369,  1370,
       0,     0,     0,     0,     0,     0,     0,     0,  1452,  1435,
    1429,     0,  1433,  1437,     0,     0,     0,     0,  1421,  1447,
    1417,     0,     0,  1423,     0,  1448,  1208,  1208,  1208,  1208,
    1205,     0,     0,  1261,     0,  1246,  1217,  1217,     0,  1557,
       0,  1486,     0,  1557,     0,     0,  2307,  2309,  2310,  2311,
    2312,  2313,  2315,  2316,  2318,  2319,  2320,  2308,  2314,  2317,
    2321,  2298,  2299,     0,  2289,  2290,   196,     0,   221,   207,
       0,  2332,     0,     0,  1152,  1133,  1155,  1073,  1220,     0,
    1592,   810,   808,   809,  1222,     0,     0,  1257,  1256,  1255,
    1230,     0,  2232,  2160,     0,     0,  2331,  2334,  2345,  2343,
    2170,   942,   906,   935,  1039,   780,   781,     0,   779,     0,
       0,     0,   407,   795,     0,     0,     0,     0,  1053,   496,
       0,   495,   491,   511,   844,     0,  1335,   819,   824,   825,
       0,   379,     0,     0,     0,   261,     0,     0,   273,     0,
     269,   287,   279,   288,   280,   303,     0,     0,     0,   948,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   949,
       0,     0,   133,   132,     0,   150,     0,   523,   524,   522,
     518,     0,   525,   527,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   947,   911,   673,     0,
       0,   674,   682,     0,     0,   675,     0,     0,     0,     0,
       0,     0,   684,   341,     0,   344,   352,   325,   329,  1055,
    1055,     0,   330,  1055,   326,  1055,   323,   615,     0,  1849,
    1581,  1582,   609,   616,   606,   608,   607,   610,   581,     0,
       0,     0,  1318,     0,  2546,  2554,  2553,     0,  1392,     0,
    1039,  1038,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   393,     0,     0,   387,     0,     0,   864,   381,
     384,   385,     0,   508,   153,     0,     0,   154,   152,     0,
     603,   604,     0,   365,     0,     0,   556,   559,   552,     0,
     617,   619,   595,     0,  1311,   515,  1124,   463,     0,   446,
     400,   442,     0,   456,     0,   444,   443,   445,     0,   452,
    1017,     0,   796,   820,     0,     0,     0,   857,   861,   858,
       0,     0,   835,     0,   843,   813,   974,   975,   972,   973,
       0,     0,  2135,  1160,  2144,  1276,  1283,     0,  1264,     0,
    1290,  1286,     0,  1287,     0,     0,  1288,     0,     0,  1283,
       0,     0,     0,   876,     0,   300,   874,     0,   642,     0,
     644,   878,   300,   300,   544,     0,   500,   460,     0,     0,
       0,     0,   749,   767,     0,   763,     0,     0,   732,   772,
    1127,  1130,  1145,  1143,   775,     0,   733,   774,  1612,  1353,
       0,  1645,  1641,     0,  1613,     0,  1625,  1624,  1454,  1626,
       0,  1473,     0,     0,  1465,  1463,  1464,  1457,  1458,  1459,
    1460,  1461,  1462,  1466,  1635,  1634,  1628,  1629,  1373,  1371,
       0,  1515,  1516,  1517,  1636,  1524,     0,  1543,  1542,     0,
       0,     0,  1530,     0,     0,  1539,     0,  1575,  1359,  1392,
    1397,     0,     0,  1420,  1640,  1438,     0,     0,     0,  1416,
       0,     0,     0,     0,  1425,  1591,     0,     0,     0,     0,
       0,     0,  1200,  1199,  1304,     0,  1248,     0,     0,  1216,
       0,  1557,  1493,  1560,  1555,  1556,  1605,   834,  1487,  1692,
       0,  1603,  1557,     0,     0,     0,  1654,  2330,     0,  1159,
    1150,     0,  1221,  1238,  1231,  2176,     0,  2231,  2296,  2297,
       0,   786,   787,   785,     0,     0,     0,   581,     0,     0,
     423,     0,   804,   804,     0,     0,   864,   957,   492,   845,
       0,   837,     0,   266,   933,     0,     0,     0,   265,     0,
     300,   300,   307,   308,   311,     0,     0,     0,     0,     0,
     636,   622,     0,     0,   637,   638,     0,     0,   881,   882,
     880,   148,   134,   135,   149,   520,   919,     0,     0,     0,
       0,     0,   956,   929,   955,   927,   926,   928,   920,   546,
       0,   676,     0,     0,   677,   688,   686,   685,   687,   679,
     342,   127,     0,   322,     0,   350,     0,   347,   348,   346,
     349,     0,     0,     0,     0,     0,     0,   583,     0,     0,
     588,   577,   579,     0,     0,     0,  1314,     0,     0,     0,
       0,     0,     0,  1319,  1327,   576,     0,  1030,  1029,  1028,
    1032,  1031,  1034,  1033,  1025,  1024,  1037,  1036,  1023,  1022,
    1027,  1026,     0,     0,   391,   395,   396,   394,   386,   864,
     415,   454,     0,   156,   155,     0,     0,     0,     0,   561,
     565,   596,     0,  1310,   540,  1122,     0,  2101,     0,   372,
     377,   378,     0,   450,   397,     0,   446,   371,   459,     0,
       0,   455,     0,  1012,     0,     0,   823,   840,   841,     0,
       0,   864,   863,     0,   494,     0,  2108,  1275,     0,     0,
    1277,     0,     0,  1279,  1281,     0,     0,     0,     0,     0,
    1678,  1557,  1307,   300,   510,   300,   300,   980,   587,     0,
     759,   758,   757,  1708,     0,   761,   300,     0,  1644,  1509,
    1519,  1623,     0,     0,  1474,     0,     0,  1514,  1985,     0,
       0,  1547,  1548,  1529,     0,  1835,  1534,     0,     0,     0,
    1695,  1444,  1442,  1439,     0,  1440,     0,     0,  1422,  1418,
       0,  1424,  1449,  1204,  1203,  1202,  1201,     0,     0,  1551,
    1557,  1557,  1488,  1562,  1559,     0,  1490,  2300,     0,  2303,
    2301,  2302,  2306,  1392,  1156,     0,  2233,  1045,     0,     0,
       0,   409,     0,   864,     0,     0,     0,   802,   807,   807,
       0,   864,   454,   838,   262,   263,   264,   267,   302,   272,
     268,     0,   950,   912,     0,     0,   628,     0,     0,     0,
       0,   951,   913,     0,     0,     0,  1061,     0,     0,   680,
     681,   324,     0,   345,   355,   356,     0,   353,   327,   332,
       0,   334,   333,   328,   331,   585,   584,   582,   578,   580,
    1315,     0,   895,   895,  2547,  2548,  2549,  2550,  2551,  2552,
       0,   581,  1035,     0,     0,   383,   454,   422,     0,   388,
       0,   516,     0,  1017,   367,   515,   560,     0,     0,     0,
     620,   461,     0,   368,     0,     0,   452,     0,     0,     0,
     450,     0,   447,     0,   451,     0,     0,     0,     0,     0,
     862,     0,   866,     0,   811,  1305,     0,   498,  2134,  2138,
       0,  1284,  1293,     0,  1280,  1278,  1269,     0,  1271,   896,
     643,   645,   545,   764,   771,   300,  1469,     0,     0,     0,
       0,  1525,     0,  1526,  1531,  1535,     0,  1532,  1533,  1441,
    1445,  1443,  1426,  1245,  1247,     0,  1185,  1491,  1492,     0,
    1217,  1557,  2305,  2304,   222,  1593,   765,     0,   300,   804,
     454,   424,  1849,   425,   803,   810,   810,     0,   454,   581,
       0,   270,   310,     0,     0,   634,   623,     0,     0,   639,
       0,     0,     0,     0,     0,   683,   314,   340,   351,     0,
     335,   895,     0,   892,   891,   575,     0,   390,   389,     0,
     433,     0,   514,     0,   632,  1013,   528,   562,   563,   558,
       0,     0,   462,   373,   382,   358,   406,   405,   402,   401,
     403,   404,   399,   398,     0,   452,   448,   449,     0,  1014,
       0,  1063,     0,   797,   865,     0,     0,     0,   493,   488,
       0,  2136,  1282,     0,  1270,   734,  1470,     0,  1471,     0,
       0,  1537,  1536,  1550,  1552,     0,     0,  1565,  1489,   782,
       0,   783,   807,   428,     0,   800,   799,   415,   581,   410,
     301,     0,   626,   633,   624,   634,     0,     0,  1057,     0,
    1058,  1059,  1062,   354,   890,   894,   893,     0,   419,   420,
     421,     0,   392,   429,   430,     0,   517,     0,     0,     0,
       0,   380,   441,   357,  1015,  1016,   305,     0,   864,   867,
     978,  2139,  2141,  2140,     0,  1292,  1472,  1540,  1527,  1538,
       0,     0,  1561,     0,     0,     0,     0,   810,     0,   581,
       0,   422,   411,     0,   625,   641,   640,     0,     0,     0,
       0,     0,   431,     0,   432,   453,   631,     0,   564,     0,
       0,   452,   798,   812,   977,   976,     0,  2137,  1553,  1554,
    1950,     0,  1927,     0,  1563,  1566,  1564,  1558,   300,   801,
       0,   412,   426,   433,     0,  1060,   565,   438,     0,   437,
       0,   435,   434,   621,   568,   304,  1305,   960,   971,   959,
     961,   969,   966,   968,   967,   965,     0,  1570,  1569,  1568,
    1572,  1571,   784,     0,   581,   627,     0,   436,   440,   439,
     573,     0,   566,   569,   574,   572,   570,   571,   788,     0,
     970,   964,  1184,  1171,     0,   427,   413,     0,   547,     0,
     962,   971,  1567,     0,   567,   963,     0,   568,     0,   548
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,   247,   248,  1652,  2452,  2355,  3053,  3054,   249,
     250,  1707,   251,   252,   253,   254,   255,   256,   257,  1683,
     258,   259,  1239,  1833,  2463,   260,  2267,  1037,  2141,  2142,
    2407,  2143,  2131,  1510,  2144,  1653,  1675,   262,   263,  1504,
    2123,   264,   265,   266,  1696,  1697,  1660,  1876,  4221,  2344,
    4401,  2915,  2916,   267,   268,  3019,  1778,  3021,  3022,  3486,
     851,  2430,  3841,  3842,  3474,  3475,  3849,  4086,  4087,   269,
    1830,  3082,  3559,  3083,  3918,  3084,  3919,  3085,  3920,  3046,
    3529,  3530,  3531,  3086,  3924,  4272,  3087,  2282,  1361,  1959,
    1960,  4250,  3769,  3770,  4379,  4342,  4343,  4344,  4431,  3926,
    3093,  3569,  3931,  4119,  1850,  2494,  3088,  3089,  3917,   270,
     271,  2489,  1722,  1723,  2361,  3492,   272,  1256,  3391,  4157,
    3047,  3048,   273,   839,   274,  1837,   275,   276,   277,   278,
    3533,  4120,  1727,  2963,  2964,  2965,  2966,  3442,   279,  1835,
    1728,  2472,   280,   281,   282,  2396,   283,   284,   285,  1844,
    2483,  2484,  3910,  4127,  4259,  4129,  4461,  4462,  4111,  3860,
    3861,  3862,   286,   287,   288,   289,  1829,  2455,  2456,  3493,
    1642,  1782,  2432,  2433,  3549,  3550,   290,  3800,  3801,   878,
    4348,  4324,   291,   292,  3804,  3805,   293,   294,   295,   296,
     297,   930,  1306,  1307,  2889,   298,  2159,   299,  1218,  3006,
     300,   964,  1333,  1334,   301,   302,   975,  2621,   977,  1973,
    3174,  3175,  3638,  2586,  1153,   303,   304,  2596,  2624,   305,
    1655,  2273,  2274,  3764,   306,   879,  1855,  2497,  2858,  4282,
    3771,  4048,  2799,  3354,   307,   880,  1679,  2310,  2500,  3098,
    3099,  2312,  2313,  3581,  2314,  3100,  3105,  3106,  3107,  3577,
    3585,  4152,  4153,   308,  1677,  2303,   309,   310,   311,  1702,
    1170,   312,   902,   903,   313,  4243,   314,  1276,   315,   996,
    1993,   316,  2325,  3406,   317,   318,   319,  4439,  4469,  4470,
    4471,  3590,  4406,   320,  4441,  1376,   322,   323,   324,   842,
    1190,  1191,  1192,   325,  3933,   326,   327,  2449,  3045,  3512,
     328,   329,  2268,  2848,   330,   331,   332,  1823,   333,   334,
     335,   336,  1760,   337,  1543,  1544,   338,   339,   846,  1057,
    1547,  1555,   340,   943,  1327,  1328,  1329,  1934,   341,  1380,
    2613,   944,  1320,   945,  1979,  2598,  2599,  2602,   946,  1871,
     345,  1983,  2607,  2610,   947,  2163,  2164,  2165,  2166,  2167,
    2783,   948,   966,  1266,  2508,   949,  1464,   350,   351,   352,
     353,  1061,  1062,  2101,  2750,   984,  1561,  1022,  1072,  3729,
    2180,  2181,  2201,  2202,  1570,  1571,  2191,  2193,  2801,  2194,
    2810,  2186,  3726,  4019,  2197,  2198,  1573,  1574,  2805,   354,
    2754,  2512,  2513,  2514,  3119,  3129,  3601,  3953,  2515,  1370,
    1054,  2516,  3305,  2521,  3074,  3075,  2315,  2440,  1804,  1465,
    1805,  2447,  1466,  2025,  1807,  1467,  1468,  1469,  1810,  1470,
    1471,  1472,  1473,  2009,  2065,  1474,  1475,  2044,  1101,  1102,
    1918,  2663,  1477,  1478,  3695,  3998,  3989,  2688,  2689,  2138,
    3691,  4196,  4303,  4304,  3738,  3734,  4023,  4200,  4375,  4414,
    4415,  1479,  2741,  2093,  1172,  1480,  3495,  2095,  2683,  2761,
    2762,  2256,  2007,  2630,  2646,  2647,  2660,  3221,  2667,  2672,
    3244,  3245,  2684,  2710,  1481,  2633,  2634,  3205,  2011,  1482,
    1533,  1534,  2109,  2706,  1550,  1551,  1059,  1483,  1484,  1974,
    1046,  3949,  1284,   690,  2924,  2154,  1194,   981,  1485,  1486,
    1487,  3176,  1597,  3172,   669,   670,  1139,   795,     2,    75,
     950,  3079,   358,   359,   882,   883,   884,  1258,  1259,  1860,
    1863,  1602,  2234,   671,   672,   699,  3946,  4158,  4291,   936,
     360,   361,   362,   363,  1598,  2230,  1103,    76,    84,    77,
    1104,   400,   401,  2212,   364,   812,   365,  1579,  1083,  3362,
     366,   367,   368,   369,   370,   933,   371,  1085,   372,  1086,
     373,   374,   375,   376,  1093,   377,  1581,  1582,  3757,  1583,
     378,   379,   692,   693,  1318,   380,   381,  1120,  1121,  1352,
    1353,  1608,  1623,  1624,  1625,   382,   686,   383,   384,   385,
    1614,  1615,   386,  2116,  2117,  2239,  2118,   387,  2824,  2825,
     388,  3331,  3332,  4030,  3333,   389,  2112,   390,   391,  1049,
    3367,   392,   808,   393,  1134,   673,   674,   675,  1141,   798,
    1009,   700,  1143,  2967,   800,   801,   677,   678,   679,  1954,
      78,  2832,  1955,  1489,   701,  1490,  2107,  1491,  1492,  1493,
    1494,  1495,  1631,   683,  1110,  1310,  1311,  2833,  1313,    82,
    1314,   397,  3507,  1921,  1354,  1940,  1941
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3894
static const int yypact[] =
{
   -3894,   713,  8218, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, 20144, -3894,
   -3894, -3894, -3894, -3894, 91440,   901, -3894, -3894, -3894, 57840,
   -3894, -3894, -3894,   431, 63120, -3894, 66480,  1138, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, 70320, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, 50148,  1560, -3894,
     263, -3894, -3894, -3894, -3894, -3894, -3894, -3894,  1190,  8220,
   -3894, -3894, 66960, -3894,    53, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, 67440,   441, -3894,   539,  1107, -3894,    88,  8006,
   -3894, -3894, 58800, 64080, -3894, -3894, 70800,   845,   122,  2051,
   10957,  1190, 19661, 71280, -3894,  3648, -3894, 47227, -3894, -3894,
   -3894, 63600, -3894, -3894, -3894, -3894,  1109, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, 77520,  2553,   913, 47716, -3894,
   -3894, -3894, -3894, 77520, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, 71760, -3894,  1112,   742, 78000, 78480,
   60720, -3894,  1392, -3894, 77520,   281, 49667, -3894, 78960, -3894,
   -3894,  1165, -3894, 72240, -3894, -3894, -3894, -3894,   913, -3894,
   50148, 44798, 72240,   132,  1143, -3894, -3894, 79440, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894,  1942,  1279, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,   441,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,   707,
   -3894,   555,   943,  1310,  1108, -3894, -3894, -3894, 21237, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, 92871,  1878, -3894, -3894,
   -3894,  1360, -3894,  1350, -3894, -3894, -3894,  1715, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894,  1110, -3894, -3894, -3894, -3894,
    1869, 91917, 70320, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, 58320, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894,   159, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, 70320, 70320, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, 70320,  1496, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894,   428,  1707, -3894, -3894, 50148,  2152,
    2152,  1982, 92871, -3894, -3894, -3894, 51110, 77520, 77520,  1631,
   77520,  1837, 51110, 77520, 77520,  1703, 40877, -3894, 77520, 77520,
   77520, 77520, 72240, 77520,  1670, 77520, 77520, 79920, 77520,  1758,
   -3894,  2015,   860, -3894, -3894, -3894, 77520, 11120,  2553, -3894,
   -3894, 77520,  1680, 51110, 77520,  1567,  1712, 77520, -3894, 77520,
    1922,  1276, 77520,  1497, 41370,  1760, 77520, 77520, 77520, 77520,
   -3894, -3894,  1750, 77520, 77520, -3894, 80400,  1169,  1997,  1916,
     759, -3894, -3894,  2088,  1685, -3894, -3894,  2132, 70320, -3894,
   67920, -3894, -3894, -3894,  1874, -3894, 72240, -3894, -3894, -3894,
   -3894, 61200,  2051, -3894, -3894, 51591, 77520,  1975, -3894, 80880,
   -3894,  2036, 52072, 81360, -3894, 41863,  2097, 81840, 82320, -3894,
   -3894, 82800, -3894, 83280,  1851, 83760, -3894, 84240, -3894,  1954,
   84720, -3894, 12635, -3894,  1738,  1687,  1765,   824, 70320, 70320,
    2917, 36512,   441, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894,   143,  1017, 48205,   717, 48694, -3894, -3894,  1001,  1264,
    1440,   143,  2193,  2193,   516, 70320, -3894, -3894,  1017, -3894,
     480,   -13,  1793,  1793,  1793,  1932,   667, -3894,  1793, 77520,
   -3894, -3894, -3894, -3894, 72240, 48205, 48694, -3894,  1794,  2553,
      13,  2194, 77520, -3894, 77520, -3894, 77520, 77520, -3894, -3894,
   -3894,  2218,  1844,  2074, -3894,  1850, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894,  2030,  2041,  2053,    56,  2553,  1969, -3894,
   -3894,  2065, 25640,   -42, 70320,  2553, 49183, 72720, 89520,   141,
   61200,  2553, 85200,  1890,   860,  2081, -3894,   477, -3894,  2303,
    1939,  2161,    34,   860, 38448, -3894,  1948,   750, 72240, 93348,
   -3894, -3894, -3894, 85680,  2056, -3894,   616,  2237, 26138, -3894,
   77520,  1962, -3894,  1966,  1978,  1979, -3894, 77520,   955,   955,
    2361,   955,  1576,  1838, -3894,  1828, -3894,  1143,  1190,  2004,
   -3894, -3894, -3894,  1993, -3894,  1990,  1994, -3894,   445,  2249,
   -3894, -3894, -3894, -3894,  2091,  2095,  2100,  2108,  2017,  2131,
     150, -3894, -3894, -3894, -3894,  2331, -3894, -3894, -3894, -3894,
   -3894, -3894,  2458,  2446, 58800, 58800,   628,   645,   116,   167,
   -3894, -3894, -3894,  2309, -3894, -3894,  2306, 77520,  2150, 77520,
   -3894, -3894, -3894, 86160, -3894, -3894,  2152,  1993,  2089, -3894,
     239, -3894,   750, -3894,   262,   279,   355,    35,  2082,  1806,
   -3894,   151,  2126,  4811,  2101,   362,  2817,  2193, -3894, 77520,
   77520, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
    2110, -3894, -3894,  2098,  1361,  1233,  5798,  1173,  3147,  1477,
    1069,  2295,  1629,  2395,  1764,  4056, 77520,  2145,  2356,   -11,
   -3894,   490, -3894,  2186,  2316,   729, 51110,  2148, -3894, 77520,
   -3894, -3894, -3894, 51110, -3894,  2332, 42356, -3894, 77520, -3894,
   -3894, -3894, -3894,  2276, 77520, -3894, -3894,  2389, 77520, -3894,
    1793,  1119,  2164,  2540, 54477, 77520,  2217,  2596,  2250, -3894,
   -3894,  2217, -3894, -3894, 77520, 77520,  2213,  1409,  2217,  2603,
    2607,  2290,  2404,  1083,   285,    85,  2508,  2217, 77520, 77520,
   77520, 77520,  2600, 51110, 77520, -3894,  2393, 73200, -3894,  2257,
    2088, -3894, -3894, -3894, -3894, -3894,  1191,  2304, -3894, -3894,
   -3894, -3894,  2545,  2089,   316,  2558,  2281,  2579, -3894,  2328,
    2592,  2101,  2597,  2307, -3894, 86640, 87120,  2599,  2110, 77520,
    2601,  2307,  2604,  2480,  2608,   316,  2613, -3894,  1272,  2617,
    2487,  2619,  1468,  2307, 61680,  2621,    74, -3894, 18332, 12635,
   -3894, 21084,  1483, -3894, -3894, -3894, -3894, -3894, -3894, 29624,
     684,  2413, -3894, -3894,  1143, -3894, -3894,  1596, -3894, 46738,
   -3894,  2917,  1017, -3894, 70320,  1017, 70320,   516,  1017, 70320,
    1017, 70320,   516,  1017, 70320, 70320, 70320,  1017, -3894, -3894,
    1583,   776, -3894, -3894, -3894, -3894, -3894, 70320,  2334, 77520,
   77520, -3894, -3894, -3894, 64560, 77520, 65040, -3894,   515, -3894,
      64, 70320, -3894, 70320, -3894,  2553, -3894, -3894,  1687, 54477,
    2734, 77520,  2620,  2620,  2620, -3894, -3894, -3894,  2563, 77520,
    2627,  2638, 64560, 77520, -3894, 87600,  2359, -3894, -3894, -3894,
   -3894,  1622,  2697,   389,  2746, 29624,  2365,   179,   179,  2368,
   -3894, -3894, -3894,   406,  2369,  2370, -3894,   426,   426,  2523,
    2373,  2374, -3894,   450,  2376, -3894,  2763,   506,  2396,  2397,
    2400,  1957,   179, 29624, -3894,  2401,   426,  2405,  2408,  2409,
    2781,  2411, -3894,  2809,  2414,   252,   336,  2415,  2418, -3894,
    2373, -3894,   270,  2421,  2423,  2424,  2425,  2426,  2427,  2428,
   29624, 29624, -3894, 24644, -3894,  2553, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894,    68, -3894,   571,  4222, -3894, -3894,  2577,
   29624, -3894, -3894,   -14, -3894,   732, -3894, -3894,   750, -3894,
   -3894,  1081, -3894, -3894, -3894, -3894,    69,    69,   172, -3894,
   66960, 66960, -3894, -3894,   608,  2429, -3894,  1627, -3894, -3894,
   -3894, -3894, -3894, -3894, 59280,  2793, -3894,  1010,   490,  1424,
    2768, 45760, 46249,  2667,  2667,  2654, -3894, -3894, 77520, -3894,
   -3894, 29624, 43836, -3894,   750,   145,  2670, 77520, -3894, 38932,
   -3894, -3894, -3894,  1632, -3894, -3894, -3894,   441, -3894, 10679,
   -3894,  1664,  1962, 77520, 77520,  2833, -3894, -3894,  1966, -3894,
   -3894,  1310,  1310, 29624,  1310,   105,  1075, 26636, 29624,  2720,
    2623,   133,  1370,  2721, -3894,  1576,  1838, -3894, -3894,  1993,
    2450,  1655, -3894, 56400, 92394, 92394,  2684, -3894, -3894,   533,
     703,  2557,  2652,  2193,    71,  1570, -3894, -3894,  2448, -3894,
    2774, 66960,  2504, 58800, -3894, -3894, 77520, -3894, -3894, 73680,
   -3894, -3894, -3894,  1174,  2453, -3894,  2472, 77520,  2951, -3894,
    1570,  1570, -3894, -3894,  2461, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, 92871,  2465, 77520, -3894,  2466,  2467, -3894,
   93348, 44317,  1637,   750,  2539,  2542, 50148,  2468,  2543,  2544,
   90000, -3894, -3894, -3894, -3894,   990,  1193,   853,  2546,   688,
   -3894, 77520,  2651,   150,  2589, -3894,  2549,  2551,  2665,   150,
     108, 90480, -3894, -3894, -3894, -3894, -3894,  2419, 22690, -3894,
   -3894, -3894,  2555,  2537, 59760,  2842,  2661,   857,  1825,   178,
   77520,  2738,  2559,  2560,  2492,  1249,  2495, -3894,  2656,  2552,
    2554, 53515,  2660, 42849,  2828,  2575, -3894,  1111,  2581,  2582,
     150, -3894,  2885,   150,   150,  1544,  2887,  2587,   354,  1628,
    2217,  2495,  2243, -3894,  2520,  2593,  1043, -3894,  2689,    77,
    1647,  2495,  2594,  2595,  2492,  2492, 77520, 77520, 77520, 77520,
   77520,  2598,  2606,  2637, 68400,  2609, 89520, -3894, -3894,  2610,
    1727,  2495,  1474, -3894,   895, -3894, -3894,   860, -3894, 77520,
   -3894, 77520,  2089, 54477,  2700,  2101,   150, 77520, 77520,  2110,
     743,  1326,  2704, 77520,  2765,  2570, -3894, -3894,  2217, -3894,
   44317,  2213, -3894,  2541, -3894,  2584, -3894,  2584,  2584,  2547,
    2547,  2548, -3894, -3894,  1957,  2584,  2547, -3894, 55439, -3894,
    1351,  1418, -3894,  2938,  2940, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894,  1179, -3894,  1682, -3894, -3894, -3894,
    2956, -3894, -3894, 54477, 77520, -3894,  2873,  2611, 50148, -3894,
    2605, -3894, 77520,   174,  2553,  2602, 77520,  2767, 77520, 77520,
   77520, 77520, -3894, -3894,   308,    27, -3894, 68400, -3894,  2243,
    2953,   -12,  1793,  2837, -3894, 77520,  2564,  2959,  2797, -3894,
   -3894,  2572,  2193, -3894,  2257, -3894,  1428, -3894,  2690, -3894,
   33594,  2615, 51110,   316, -3894, -3894, -3894, -3894, 54477, 77520,
   88080, 51110,   316, 77520, 77520,  2867,  2631,  2874,  2635, 42849,
     316,    80, 77520, 77520, 77520, 77520, -3894, 77520, -3894, -3894,
   -3894, -3894, 77520, 77520, 77520, 68400,  2876,  2884,   316, 77520,
   77520, -3894, -3894, 19021,  1528, -3894, 12635, -3894, 10679,  1684,
    2667, -3894,  1496, 77520,  1283,  2917, 65520, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, 70320, -3894, 70320,   516,
   -3894, -3894, 70320, -3894, 70320,   516, -3894, 70320, -3894, -3894,
   -3894, 70320, 77520,  3084,  2614, -3894,  1081, -3894, 77520,  1696,
   -3894, -3894,  1697,   636, 77520,   225, 51110, 77520,  2785, 77520,
   77520, 77520, 77520,  2677,  2429,  -102, -3894,  2653, 37964,  2735,
   -3894,   175, 72240,  2795, -3894, -3894, -3894, -3894, -3894,  1720,
    1582,   991, -3894, -3894, -3894, -3894, -3894, -3894, 65040, 63600,
    2888,    41, 77520, -3894, 29624, 25142, -3894, -3894, -3894,  2612,
   10679,  2659, 29624, -3894, -3894, 29624,  2193,  2193, 29624, -3894,
   -3894, -3894, -3894,  1390,  2193, -3894, 29624, 29624,  2193,  2193,
    2584,  2584, -3894,  3506, 29624, -3894, 42849, 29624, 31118, 22191,
   29624,  2691,  2640,  2193, -3894,  2193, -3894, 29624, 24146, -3894,
   29624,  2826, 29624,  1424,  2827, 29624,  1424,  3041,  3041,  1507,
    4660,  2625, -3894,  2732,  2193, -3894,  2193,  1352,   165, 54477,
   29624, 50148,  2705,   115, 29624,  2632,  1879, -3894, 29624,   879,
   -3894,  2634, 29624,  2706, 29624, 29624, 29624, 29624, 29624, 29624,
   29624, 29624, 29624, -3894, 32114,   227, -3894,   410,   339, 66000,
   25640,  2910, -3894, 21692, -3894,   296, 70320, -3894, -3894,   750,
   -3894, -3894, -3894, -3894, -3894,  1174,  2636, -3894,  2650, -3894,
   -3894, -3894, -3894, -3894, 77520,  2793, -3894, -3894,  2708, -3894,
   -3894, -3894, -3894,   786, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894,  2639, -3894, -3894, -3894, -3894, -3894,  2639, -3894, -3894,
    2667,  2643,  2399, -3894, -3894, -3894, -3894,  2902,  2907,   316,
   92871, -3894, 77520,   104, -3894, -3894, -3894,  2666, -3894, 77520,
     616, 68880, -3894, 26138, -3894,  1777,  2373, -3894,  2890, -3894,
    2644, -3894,  7544,  2890, -3894, -3894,   138,  2831,  2832,  2832,
   -3894,  2658, 10679, -3894,  1795, 10679,  1880, -3894, -3894, -3894,
   -3894, -3894, -3894,   977, -3894,  2720,  1370,  1785, -3894,  1993,
   -3894, -3894, 19102, -3894, 20621, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894,  2662, -3894, -3894, -3894, -3894,   150,
    2664,  3123, -3894, 58800, -3894, -3894, -3894,  3084, -3894,  2132,
   -3894,  2132,  3154, -3894, 70320, -3894, -3894, -3894, -3894,   798,
   -3894, 12635, -3894, 12635, -3894,  2672,  1780,  2737,  2741,  2783,
   77520, 77520, -3894, 50148, 77520, 77520, 77520, -3894,  3030,   877,
   63600,  2794, 62160, -3894, -3894,  2680, 77520,  2731,  2912,  2914,
    2686, -3894, -3894, 77520, -3894,  2871, 77520, 29624,  2878, 77520,
    1546,  2880, -3894,   135, 77520, 77520,  2864, -3894, -3894, -3894,
   61200, -3894, -3894, -3894,  2865, -3894, -3894, 55439, -3894, -3894,
    1791, -3894, 54958, 52553, -3894, -3894,  1034, 77520, 77520, 77520,
     978, -3894, -3894, 54477, -3894, 77520, 77520, 77520, 69360, 88560,
   89040,   961,  1005, 77520, 69840, -3894, 77520, 77520, 77520, 50148,
   -3894, 77520,  2877,   196, -3894,  1683,  2769, 77520, 77520,  2698,
    1800,  2776, -3894, 77520, 77520,  5282, -3894, 77520, 77520, -3894,
   -3894,   150, -3894, -3894, -3894, -3894, -3894, 77520, 77520,   150,
   77520,   150,  1122, -3894, 50629, 77520, -3894, -3894, -3894, 77520,
   77520, 77520, 77520, 77520, -3894, -3894,  1054,   672,  2843,  2844,
    2845, 77520, 77520, 77520, -3894, -3894,  2816, -3894, 77520,  5282,
   77520, 77520,  2786,  2787,   111,  2856, -3894, -3894, -3894, -3894,
   -3894, -3894,  2952,  3115, 77520,  2957,  2960,  2772,  2775,  2961,
    1918, 77520, 77520, 77520, 77520, 77520, 77520,  2966,  1918,  2908,
      82,  2739,  1804, -3894,  2748, -3894, 29624,  3132, 54477,  2740,
    2743,  2812, -3894,  2813,  2193, -3894,  1809, -3894,   308,  1943,
   -3894,   479,  4654,  3024, 77520,  1816, -3894,  2758, 77520,  4654,
   -3894,  1513, 63600, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894,  3027, -3894,  2553,  2213,  2213,  2213,  2213, -3894,
   -3894, -3894,  2928,  1420, -3894,  2752, 77520,  2859,  4654, -3894,
    2243,  3045, 77520, 60240,  1845,  3151,  2553,  2932, -3894, 23175,
    4166,  2933, 61200, 73200, -3894,  2766,  3028,  3031,  3050, -3894,
   33110, 74160,  2771,  2103, -3894, 74160, 74640, -3894,  2761,   750,
   27134,  2735,  2089, -3894,  3165, -3894,  3062,   316,  2101, -3894,
    2307, -3894, 77520, 77520, 77520, 77520,  2110, -3894, -3894,  2307,
    2949,   316,   316, -3894,  2950,   316,  2307,  2886,  3059, 61200,
   -3894,    74, -3894, -3894, -3894, -3894, -3894, 29624, -3894, -3894,
    2784,  1428, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, 70320,  2132, -3894,  1820, -3894, 77520, -3894,
    3036,  3038,  3042,  2307,  2818, 77520,  2788, -3894,  2307,  2193,
    2307,  2429,  2429,  2307, 75120,  3192,  3061, -3894,  1834, -3894,
   -3894, 25640, -3894,   287, -3894,   519,   785,  2995, -3894, -3894,
   -3894, -3894, 54477, -3894, -3894, -3894, -3894, -3894, 77520,   152,
    2968,  2792, 75120,  3174,   316, -3894,  1840, -3894,  1542, -3894,
    1565, 29624, 29624,   258, -3894,  9220,  1852,  2796,  2799,  1857,
   -3894, -3894, -3894, -3894, -3894, -3894,  2801,  3078, -3894, -3894,
    2804,  1868,  1875,  2805,  2807, -3894, -3894,  4198,  2810,  9562,
    2821, 31118, 31118,  1718, -3894, -3894, 31118,  2823, -3894,  1897,
    8658,  2811,  2824,  2836, -3894,  2825,  2829,  9856, 27632, 29624,
   27632, 27632,  9900,  2811,  2838,  1905, 50148, 10005,  1910, -3894,
   29624, 50148,  4511, 29624, -3894, 29624, 77520,  2841,  2847, -3894,
   -3894,  3506, -3894,  2846, -3894, 31118, 31118,  3032, 24644, -3894,
   -3894,  3085, -3894, -3894,  1430, -3894,  2850, -3894, -3894,  5213,
     147, 29624,  2632, 29624,  2883, 42849,  2357, 29624,  2291,  2989,
    2989,   429,   429,   153,   153,   153,  1470,   339, -3894, -3894,
   -3894,  2861,  2411, 29624, -3894,  1996,  2000, 77520,  7131,  9571,
   -3894, -3894, -3894, 33594,  2863, 29624, 29624, 29624,  2855,  2993,
   10087,   640, -3894, -3894, -3894, -3894,   265,  3154,  1174, -3894,
     860,  2193,  1352, 46738, -3894, -3894, -3894, 29624, -3894, -3894,
   -3894, -3894, -3894,  1953, 38932,  2615, 26138,   750,  1966, -3894,
   -3894, -3894, -3894, -3894, -3894, 29624, -3894, -3894,   542,  1854,
   29624,  1795, -3894, -3894, 77520,  2795,  2795, 29624, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894,  1450, -3894, -3894, -3894, -3894,
   -3894, -3894,  2834, -3894,  2860, -3894,  2857, -3894, -3894, -3894,
   -3894,   142,  2858,  2866,  2869,  1018, -3894, -3894, 77520, 77520,
   77520, -3894, -3894, -3894, -3894, -3894, -3894,  3064, -3894, 77520,
   77520,  3005, 77520,  3035,  3047, 29624,  1263, 77520,  2875,  2879,
    2881, 77520,   316, -3894, -3894, 10679, -3894, -3894,  2918,  2937,
   77520,  2689, -3894,  3120, -3894, -3894, -3894, -3894,  3060, -3894,
   -3894,  1682, -3894, 52553, 54958, -3894, 54958, -3894,  1682,  1512,
   -3894,  2307, -3894, -3894,   547, -3894, -3894, -3894, -3894, -3894,
    3170,   316,  3172,   316, 77520, 77520, 77520, 77520, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894,  1961, -3894,  1257, -3894, -3894,
   -3894, -3894, -3894, 77520,  1553, -3894,   460, 54477, -3894, 53996,
   77520, -3894, -3894,  3102, -3894, -3894, -3894,  3043, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894,  2003, -3894,  3044, 77520,
    2941, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   50148, 50148, 50148,  1968, -3894, -3894,  2553, -3894, -3894, -3894,
    2962, -3894, -3894, -3894,  3099,  3103,  3104,  2965,  2969,  2970,
    2972, -3894,  2973,  2975,  2976, -3894, -3894, -3894, 77520, -3894,
   -3894, -3894, 77520, 77520, -3894, -3894, -3894,  1918, 54477,  3130,
    1918,  1918, 77520, 77520,  1918, -3894, -3894, -3894,  3141,  3142,
    3143,  3144,  3148,  3149,  1918, -3894, -3894, -3894, -3894,  1119,
   50148, -3894,  2063, -3894,  1874, 40384,  4797,  2900,  2743,  2915,
    2193, 36028,   894,  3124,  2920, -3894,  1568,  3150,  2935,  2935,
    2935,  2935,  2935,  2935,  2935, -3894,  1749, -3894,  3093, 77520,
     576, 77520,  2193, -3894, -3894,  2985, -3894, -3894, 50148, 40384,
    1793,   174,  3055,  1364,  3254, -3894, -3894, -3894, -3894, -3894,
   77520, 77520,   308,  2553,  1971, -3894, 54477, 77520, 70320,  1942,
    2929, 77520,  2927,  2934, -3894, -3894, -3894, -3894,  1974, -3894,
   54477,   -48,  3110,  3113,  1942,  3006, 77520, -3894,  1988,    44,
   -3894,  2553, 61200, 53034, -3894,  3734, -3894, -3894,   930,  3206,
   -3894, 77520, -3894, -3894, 37480, 35046,  2103,  2942, 77520, -3894,
    2944, 33594,  3173,  3111, -3894, 33594,  3111,  1331,  3111,  3183,
   -3894, 39416, -3894,  2954, 21692,  1523,  3119, 10679, -3894,   316,
   54477, 77520, -3894,   316,  3003,   316,  3008,   316,   316, 77520,
   -3894, -3894, 77520, -3894, 77520, 68400,   316, -3894, 10679, 77520,
    3235, -3894, -3894, -3894, -3894,  3074,  3075,  3076, 77520,  2307,
   51110, -3894,  2967, 77520,  1129, -3894, -3894,  3139, -3894,  1942,
   77520,   750,  2997, -3894, -3894, -3894, -3894,  3263,  3267, -3894,
   -3894, -3894, 77520, 64560,   177, 77520, -3894, -3894, -3894, -3894,
    2978,  1992, 10328, 29624, -3894,  3277, 54477, -3894, -3894, -3894,
   -3894, -3894, 29624, -3894, -3894, -3894, -3894, -3894, 29624, -3894,
   29624,  3271, -3894,  3402,  3402, 54477, 31118,  1375,  2405, 31118,
   31118, 31118, 31118, 31118, 31118, 31118, 31118, 31118, 32612,   711,
   -3894, -3894, 29624, 29624,  3272,  3271, -3894, -3894,  1419,  1419,
   54477,  3000,  2811,  3004,  3012, 29624, -3894, -3894,  2002, 50148,
   -3894, 29624,  8581,  2013,  3046, 10445,   750,  5116, -3894,  3366,
    2553, 29624,  3091,  3145, 29624,  2021, 29624,  3279, -3894, -3894,
   -3894,  3007, -3894, -3894, 54477, 29624, 31118, 31118,  5268, -3894,
    5658, 29624,  3015,  5694, 24644, -3894,   913,   913,   913,   913,
   -3894, 77520, 77520,  2771, 29624,  3285,   -27,   -27,  3020,  2993,
   39900, -3894, 55920,  1600, 28130,  3029, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894,  3026, -3894,  3048, -3894, -3894,   490,  3037, -3894, -3894,
    7467,   142,  3049, 77520, -3894,  2735, -3894, -3894, -3894,  3040,
   -3894,  1854, -3894, -3894, -3894,  5388,  3205,  2429, -3894, -3894,
   -3894,  2193,  3054, -3894,  2132,   265, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894,  2935,  2307,  2307,   655,  2307,  3325,
     655,  5456, -3894, -3894, 34078, 77520, 77520,  2043, -3894, -3894,
   77520, -3894,  2082, -3894, -3894,  3290,  1516, -3894, -3894, -3894,
    3112,  1749,   712,  2492,   605, -3894,  3118, 77520, -3894, 77520,
   -3894, -3894, -3894, -3894, -3894, -3894, 50148, 40384, 50148, -3894,
    3128,  3129,   566,   588,  3131,  3134,  3053,  3065,  3067, -3894,
     143,  2553, -3894, -3894,  2553,  2307,  2553, -3894, -3894, -3894,
   -3894, 50629, -3894, -3894, 77520,  3329,   101,  1578, 77520, 77520,
   77520, 77520, 77520, 77520, 77520,  2689, -3894, -3894, -3894,  3069,
    1918, -3894, -3894,  3284,  3296, -3894,  1918,  1918,  1918,  1918,
    1918,  1918, -3894,   231,  2047, -3894, 35531, -3894, -3894,  2596,
    2596,    50, -3894,  2596, -3894,  2596, -3894, -3894,  2748,  3040,
    2193,  1570, -3894, -3894, -3894, -3894, -3894, -3894,   878,  2193,
    1896,  3073, -3894, 36996, -3894, -3894, -3894,  2258,  1352, 77520,
    2935, -3894,  2375,  2503,  2519,  2538, 75600, 76080, 76560,  3077,
   77520, 31118, -3894,   910,   158, -3894,  3303, 77520,  3108, -3894,
   -3894, -3894,  3081, -3894,  2307, 77520, 77520,  2307, -3894, 54477,
   -3894, -3894,  3468,   824, 77520,  3106,  3087,  3368, -3894,  3092,
    3094, -3894, -3894, 77520, -3894,  3093,  1765,  3133, 62640,  1845,
   -3894,  3345, 60240, -3894, 77520, -3894, -3894, -3894,  3458,  3181,
    3137,  2553,  2731, -3894, 52553, 29624, 29624, -3894,  3105, -3894,
    3116,  4348, -3894,  2213, -3894, -3894, -3894, -3894, -3894, -3894,
    3176, 77520,  3527, -3894, -3894, 74160,  3121, 77520,  2103, 33594,
   -3894, -3894,  2534, -3894, 33594,  3342, -3894, 33594, 77520,  3125,
   77520,  1068, 77520, -3894,  3114,   316, -3894, 77520, -3894, 77520,
   -3894, -3894,   316,   316, -3894,  3218, -3894, -3894,  1942, 77520,
   77520, 77520,  2307, -3894,  2193, -3894,  3383, 75120, -3894, -3894,
   -3894, -3894, -3894, -3894,    41,  3394, -3894, -3894, -3894, -3894,
   29624, 10679, -3894,  3122, 10679,  5980, 10679,  3272, -3894,  2245,
    3399, -3894,   938,  3126,  2245,  2212,  2212,   358,   358,   118,
     118,   118,  3402,   711, 10679, 10679, -3894, -3894, -3894, -3894,
    3127, -3894, -3894, -3894,  2811, -3894, 30122, -3894, -3894,  3162,
    3166,  3152, -3894, 29624, 30620,  3140, 55439, -3894, -3894,  1352,
    3041, 31118, 31118,  1487, -3894,  1058, 29624, 54477,  2048,  1487,
    3237,  3606, 29624, 29624,  6082,   259, 29624,  6274, 77520, 77520,
   77520, 77520, -3894, -3894, 10679,  3513,  3407, 29624,  3155, -3894,
    3156,  2993, -3894, 90960, -3894, -3894, -3894, -3894, -3894, -3894,
   29624, -3894,  2993,   265,   988,  2553, -3894, -3894,  1143, -3894,
   -3894, 42849, -3894, -3894, -3894, -3894, 12635, -3894, -3894, -3894,
     143, -3894, -3894, -3894,  3214, 63600,  3421,   878, 29624,  2059,
   -3894,  3185, 77040, 23660,  2064,  2084,  3108, -3894,  2468, -3894,
    3211, -3894,  3341, -3894, -3894,  3343,   143, 77520, -3894, 54477,
     316,   316, -3894, -3894,  3175, 77520, 77520,  2193,  2193, 54477,
    3160, -3894,  2193,  2193,  3164, -3894, 77520, 77520, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, 77520, 77520, 77520,
   77520,  3455, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
    3405, -3894,  1918,  1918, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894,  2217,  3482, -3894, 50148, -3894, 56880, -3894, -3894, -3894,
   -3894,  2553,  2553,  3356, 45279,  2553,  2553, -3894,  1214,  3493,
   -3894,  3423,   983,  3177,  1642,  3450, -3894,  1892, 36996, 36996,
   36996, 36996, 36996, -3894, -3894,  3453,   143, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, 29624,  1140,  2245, -3894, -3894, -3894, -3894,  3108,
    1793,  3229, 50148,  2307,  2307,  3230,  1942,   369, 77520,  3484,
    3219, -3894,  2553, -3894, -3894, -3894,   629, -3894,  2087, -3894,
   -3894, -3894,  3216,  3113,  1187,  3186,  1845, -3894, -3894,  1162,
   77520, -3894,   999, -3894,  3460,  3188, -3894, 10679, 10679,  2553,
   55920,  3734, -3894, 77520,  3437, 77520, -3894, -3894, 77520,  2106,
   -3894, 29624,  3193, -3894, -3894, 33594,  2534,  2119, 77520,  2129,
   54477,  2993, -3894,   316, -3894,   316,   316, -3894, -3894, 77520,
    2307,  2307,  2307, -3894,  3367, -3894,   316, 75120, 10679, -3894,
   -3894, -3894, 31118,  3472, -3894,  3198, 54477, -3894,  3200,  2138,
    2144, -3894, -3894, -3894,  6340,  3249, 10679,  3298,  3207,  3210,
   -3894,  1612,  1612,  1058,  2151, -3894, 31118, 31118,  1487,  1487,
   29624,  1487, -3894, -3894, -3894, -3894, -3894, 29624, 29624,  3246,
    2993,  2993, -3894,  3371, -3894,  3215, -3894, -3894,  1570, -3894,
   -3894, -3894, -3894,  1352, -3894,  3217, -3894, -3894, 75120,  3389,
   75120, -3894,  6620,  3108, 34078, 43342, 77520, -3894,   669,   669,
    3353,  3108,  3229, -3894, -3894, -3894, -3894, -3894,  3269, -3894,
   -3894, 40384, -3894, -3894, 34562, 42849, -3894,   566,  3227,  3234,
     588, -3894, -3894,  1200,   848,  3268,  2307,  3516,  1918, -3894,
   -3894,  2739,  2553, -3894, -3894, -3894,  2155, -3894, -3894, -3894,
   77520, -3894,  3087, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, 51110,  3631,  3631, -3894,  1660,  1660, -3894, -3894, -3894,
   77520,   878, -3894,  6697,  3425, -3894,  3229,  3454,  3498, -3894,
    2167, -3894, 77520,  3137, 60240,  3093, -3894,  1030,  3248,  3544,
   -3894, -3894,  3582, -3894, 62640,  3427,  3181,   811,   811, 77520,
    3113,  3373, -3894,  3376, -3894,  3625,  3431,  3628, 77520, 34078,
   -3894, 54958, -3894,  2170, -3894,  2863, 77520,   479, -3894,  3276,
    2174, -3894, 10679, 77520, -3894, -3894, -3894,  2177, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894,   177,   888, 31118, 54477,  2180,
   29624, -3894, 29624, -3894, -3894, -3894,   449, -3894, -3894, -3894,
    1612,  1612,  1487,  2811, 10679, 77520, -3894, -3894, -3894,  3642,
    3435,  2993, -3894, -3894, -3894, -3894,  1129,   655,   177, 77040,
    3229, -3894,  3270, -3894, -3894,  1854,  1854, 77520,  3229,   878,
   29624, -3894, -3894, 54477,  2101,   395, -3894, 54477, 54477, -3894,
   77520, 77520, 77520, 77520, 77520, -3894, -3894, -3894, -3894, 56880,
    3087,  3631,   856, -3894, -3894, -3894,  3548, -3894, -3894,   972,
    3443,  3352, -3894, 50148,  3560, -3894, -3894, -3894, -3894, -3894,
   29624,  3420, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894,  2188,  3181, -3894, -3894,  3451, -3894,
    3461, -3894,  2209, -3894, -3894,  4348, 55920,  3590, -3894, -3894,
    2256,  3700, -3894,  2215, -3894, -3894,   888,  2222, -3894,  2223,
    2241,  3333, -3894,  3286, -3894,  3685, 29624,  1049, -3894, -3894,
    3568, -3894,   669,  3330, 42849, -3894, -3894,  1793,   878, -3894,
   10679,  2260, -3894, -3894, -3894,  3434,  2264,  2273,  3294,  3331,
    3294, -3894,  2307, -3894, -3894, -3894, -3894,  3602, -3894, -3894,
   -3894,   250, -3894,  3474,  3477, 77520, -3894, 77520,  3699,  7093,
   51110,  1749, -3894, -3894, -3894, -3894,  3339, 34078,  3734, -3894,
     790, -3894, -3894, -3894, 77520, -3894, -3894, -3894, -3894, -3894,
   77520,  3307,  2811, 28628, 28628,  3310, 75120,  1854,  3312,   878,
    3313,  3454, -3894, 51110, -3894, -3894, -3894, 77520,  3439,   761,
     761,  3638, -3894,  3375, -3894, -3894, -3894,   566, -3894,  3315,
    2492,  3181, -3894, -3894, -3894, -3894,   626, -3894, -3894, -3894,
   31616,  3444,    89,  8955, -3894, -3894, -3894, -3894,   177, -3894,
   29624, -3894, -3894,  3443,  2101, -3894,  3219, -3894,  3732, -3894,
     828, -3894, -3894,  3160, 57360, -3894,  2863, -3894,  1172, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894,  3724, -3894, -3894, -3894,
   -3894, -3894, -3894,  7205,   878, -3894,  3622, -3894, -3894, -3894,
   -3894,  2289, -3894, -3894, -3894, -3894, -3894, -3894, -3894,  1305,
   -3894, -3894,  1460,  1979, 29126, -3894, -3894,  3479, -3894, 57360,
   -3894,  1172, -3894, 51110, -3894, -3894,  3336, 57360,  2296, -3894
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3894, -3894,  3481, -3894, -1140,   112,  2093, -1119, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894,  1386, -3894, -3894,   -85,  1601,  2325,  1078,
   -3894, -1318, -3894, -3894,  -836,   160,  -981, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894,  -785,  1503,   958,  3107, -3894, -1677,
   -3894, -3894,   439, -3894, -3894, -3894,   839,  -218, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894,    21, -3894, -3894,  -375, -1749,
    -108, -3894, -3894, -3894, -3894,   309,  -262, -1542, -3894, -2826,
   -3894,   -20, -3894, -3894, -3894,  -261, -1625,  1019,  -960, -1332,
    1298,  -503, -3894,  -165, -3894,  -543,  -463,  -461,  -507, -3894,
   -3324, -3424, -3495, -2506, -3894, -3894, -3894,   320, -3894, -1737,
   -3894, -3894,  2038, -1585, -3894,  -765, -3894, -3894, -3426, -3894,
    1595,  -269, -3894,   -45, -3894, -3894, -3894, -3894, -3894, -3894,
   -3388, -3894, -1673, -3894,   448, -2859,   929, -3894, -3894, -3894,
    2058, -3894, -3894, -3894, -3894, -1776, -3894, -3894, -1736, -3894,
    1446,   823, -3894, -3894, -3894,  -530,  -590,  -580, -3894, -3613,
      36,    39, -3894, -3894, -3894, -3894, -1206, -3894,   843, -2932,
   -1133, -3894, -3894,   880, -3894, -3894, -3894,  -495,  -162,  2080,
   -3894,  -418, -3894, -3894, -3894,  -159, -3894, -3894, -3894, -3894,
   -3894, -3894, -1880,  2830, -1115, -3894, -3894, -3894, -3894, -2283,
   -3894,  3725,   -15,   146, -1722, -3894,  -208,  -128,  2550, -1350,
   -2548,   275,  -292, -3894, -1931, -3894, -3894, -3894, -2486, -3894,
   -3894, -3894, -3894, -3247, -1719, -3894, -3894, -3894,   343, -3894,
   -3871, -3586, -3543, -3226, -3894, -3894, -1265, -3894, -3894, -3894,
   -1573,  1605, -2256, -3894, -2200,   347, -3440,  -978, -3028, -3894,
   -3389,  -364, -3894, -3894, -3894, -3894, -3894, -3894, -3894, -1262,
    -843, -3894, -3894,  3021, -3894, -3079, -3894, -3894, -3894, -3894,
    1013, -3894,  -620, -3894, -3894, -3894, -3894, -3894, -3894,  -480,
    -549, -3894, -3894, -3894,   204, -3894, -3894, -3894, -3894,  1729,
   -1159,  -982,  2891, -1716,  -184, -3894, -3894, -3894, -3894, -2844,
   -3894, -3894, -3894, -3894, -3894, -3894, -3894, -1224, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894,  1763,  1769,  -125,  -244, -3894,
   -3894, -1480, -3894,  -810, -3894,  2016, -3894, -3894, -3894, -3894,
   -3894,   216,   385,   -77, -3894, -3894,   763, -2383,   -73, -3894,
   -3894, -3894, -3894,  -346,   -72, -3894,  1160, -3894, -3894, -2056,
   -3894,   228,    20,  2624,  1384,   -74,   -63,  -239,  -263,  -190,
   -3894,  2889,  2394, -3894, -3894,  -205,  1377, -3894, -1053,  -342,
   -3894,  1159,  -898,  1751,  2384,  2388, -3894,  1152, -3894, -3894,
    1161, -3894, -3894, -3894,  -895,  1755, -3894,  2391,  1772, -3894,
    1802,  1213, -2434,  1457, -2392,   842,  -627,    14,  -153,  2923,
    3079, -3894, -3893,  1188, -3338,   419,  3346, -2045, -1768, -3894,
   -3894, -1367, 11636, -3894, -3894, -3894, 12893, 13406, -3894, -3894,
   14106, 14127, -3894, -1247,   705, 14521,  9187, -1393, -1765, -1497,
    7846, -2562,  -797, -1802, -3894, -3894, -3894,  -200,   720,    33,
   -3894, -3894, -3894,  -388, -2684,  -387, -3894, -3894, -3894,  -391,
   -3260,  1035, -3894,  -781, -3894, 15297,  1189, -3894, -1200, -2543,
   -2629, -1359, -1896, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -1538, -3053,  -537,  1266, -3894, -3894,  1358, -3894, -3894, -3894,
   -1487, -1104, -1999,  1265, -2038, -3894, -1050,  1391,  1893, -1017,
    4821,  2870, 12649,  -115, -2268, -1495, -1440, -3894,  -433, -3894,
      59,  1692,  -164, -3894,   233,   535,    75, -2904, -3894, -3894,
     247, -3894, -3894, -3894,  3357,   887, -3894,  2745, -3894,  1505,
    2142, -3894, -3894,  1778,  -944,    26, -3894,  -351, -3894,  -141,
   -3894, -3894, -3894,   130, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894, -3894, -3894,  2430, -3894, -3894, -1438, -3894, -3894, -3894,
   -3894, -3894,  3647,  -300, -3894,  3082,  -293, -3894, -3894, -3894,
   -3894, -3894, -3894, -3894, -3894, -3894,  2438,  1810, -3894,  2893,
   -3894, -3894, -3894,   -44,  2642, -3894, -3894, -3894, -1184,  -581,
    2905,  2906,  1775, -3894, -3894, -3894, -3894, -3894, -3894, -3894,
   -3894,  1784, -3894, -3894,  1259, -2053,  1786, -3894, -3894,   663,
   -3894, -3894,   288, -3894,   668, -3894,  2535, -3894, -3894, -3894,
     693, -3894, -3894, -3894,  -599, 10460,   191,   -81,   245,   613,
   -3894,  5394,  8601,   -98,  2454,   -24,  7994, 13525,   394, -3894,
    3639,  1788,  1464, -1011, -3894,   328,  2086,   292, -3894, -1111,
      23,    -2, -3894,  2140,  -654, -1163,  2736,  -742, -1870, -3894,
    4041, -3894, -3275, -3894,  -924,  3083, -1178
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2407
static const short yytable[] =
{
      80,   343,  1015,   968,   348,   344,   346,  1065,  1628,  1073,
    1505,  1931,   893,  1362,  1363,   349,  1882,  2340,  1367,   799,
    1989,  1236,  1575,  1048,   968,    79,  1890,  1577,  1962,  2551,
    2437,  2281,  1758,  1647,  1706,  2587,   796,   881,  1643,  1846,
     942,   877,  2000,   976,  1747,  1171,  2555,  2156,  1118,  2445,
    2019,  2020,  1518,  2046,   395,  2378,  2884,  2384,  2385,  2322,
     395,    74,  2766,   990,   799,  1268,  1080,  3401,  2517,  2035,
    1045,  2487,  1288,  1081,  3194,  3311,  3116,  3584,  2177,  1053,
    2926,   796,  1016,  1171,  2464,   852,  1821,   682,   840,  1781,
    1075,  1825,  2219,  2221,  2222,  1067,  2465,  2466,  1831,  3223,
    3224,  3437,   349,  3439,  3239,  2311,  2782,  1848,  1626,  2629,
    3178,  2467,  2885,  2887,  2468,   929,   697,  2469,  1526,  1919,
     691,  3496,  1122,  3130,  3132,  3752,   703,  3541,  3308,  2547,
    1323,  1036,   799,  3766,  1171,  2792,  1920,  2373,  3138,  3901,
    1873,  3941,  2321,  3272,  3273,  3015,  2213,  2213,  1915,   796,
     886,  2262,   965,   356,  4041,  3496,  2156,   904,   691,   356,
    2013,  2014,   844,  1076,  1946,  3944,  2815,  3914,  1654,  2787,
    1604,  1605,  3366,   965,  1569,  1676,   895,  1572,   885,   892,
    1113,  1617,  2114,  1064,   982,  2032,  3056,  4049,   416,   892,
    1312,  3676,   356,  1845,  1512,  3513,  3514,  3515,  3516,  3517,
    3518,  1874,  2063,  1748,  1618,  2831,  3225,  1874,   850,  2835,
     416,  1135,  3306,  3307,   399,   416,    37,    38,    39,    40,
    2324,   897,   416,    44,    45,  3575,   967,  2704,  3867,    45,
     892,    43,  2485,   841,  1262,  3923,    45,   356,   261,   416,
    1378,  2069,    37,    38,    39,    40,  1656,   967,    43,    44,
    1397,  1619,  2099,    45, -1368, -1368, -1368, -1368,  2994,  2704,
    1775, -1368,  4287,  2061, -1579,  3145,  2072,  3147,  2603,   394,
    3957, -1579,  3959,  3316,  2623,   394,  3317,  3318,  4283,  3565,
    2331,   343,   321,  1393,   348,   344,   346,  3319,  3320,  3321,
    1074,  3322,  3323,  2298,   342,   349,  3324,  3325,  3326,  2157,
    1350,   809,  2699,   810,  1874,   356,   347,  1070,   394,  3017,
    4448,  1981,  2492, -1368, -2405, -2405, -2405, -2405,  1755,  2409,
    2874, -2405,  1509,  3818,  2184,   357,  2738, -1378, -1378, -1378,
   -1378,  2753,  2461,  2739, -1378,  1596,  2920, -2406, -2406, -2406,
   -2406,  3897,   395,  1358, -2406, -1363, -1363, -1363, -1363,  1657,
     794,  1565, -1363,   394, -2403, -2403, -2403, -2403, -1595,  1758,
    1055, -2403,   797,  1769,  3853, -1595,  2225,  2595, -1833,  2226,
    1498, -1685, -1685, -1685, -1685,  2299,  1644,   395, -1685,  3192,
    1020,   681,  1842,  1138,  2105,  2604,   695,  4052,   695,  1154,
    1496,  1721,  3028,  1731,  2110,   794,  1922,  2111,   695,  2584,
    1751,  1843,  2875,  1884, -1363,  1645,  2462,   797,  2046,  3854,
    2185, -1378, -1378, -1378, -1378,  2498,  1567,   680, -1378,  -343,
    1222,   394,  2019,  2020,   695,  1171,  -127,  2069,  1109,  2035,
   -2402, -2402, -2402, -2402,   695,  -127,  4389, -2402,  4449,  3327,
    -127,   356,  1006,  1874,   695,   695,  3225,  1497,   695,  1006,
    1875,  1006,  2072,  1123,  2339,   695,  1875,  1680,  3203,   970,
     684,  2227,  1756,   794, -1368, -1368, -1368, -1368,  1908,   898,
    1586, -1368,  1273,  3819,  1021,   797,   356,  3898,  3727,  1281,
     970, -1997, -1997, -1997, -1997,  3793,  4402,   813, -1997,  1359,
    2493,  2100,  1658,  1932,  2479,   969,   695,  3183,  4246,  4136,
    2415, -1335, -1335, -1335, -1335,  4215,  4216,  2419, -1335,  2379,
    4116,   803,  1137,  3496,  3018,  1379,   969,  2069,   261,  1081,
    2158,  1935,   881,  2921,   814, -1348, -1348, -1348, -1348,  2486,
    3760,  1107, -1348,  3576,  2705,  1607,  1610,  1639,  1389,  2437,
    2013,  2014,  2072,  4468,  1116,  1117,  1884,   899,  2032,   900,
    1659,  2332,  4154,  1875,  2995,  3422,   803,   394,  2605,  2102,
    1681,  1366,   321,  2333,  1933,  3328,  3286,  1914,  2480,  1982,
    2064, -1579,  1613, -1833,   342,  2435,  2606,   811,  2369,  1910,
    2371, -1375, -1375, -1375, -1375,  1884,   347,  1828, -1375,  3383,
     246,  3611,   394,  4105,  4106,  4107,  4108,  4109,  2408,  2148,
    2149,  3181,  4140,  1011,  3981,   357,  4319,  2076,  2077,  2784,
    1011,  1114,  1011,   355,  2334,  3329,  3237,  2872,  2156,   355,
    4167,  2585,  2765,  4312,   803,  3732,  2576,  1158,  2115,  2412,
   -1833,   962,   963,  2740,  1056,   886,   962,   963,  2431,  2008,
    2800,  4265,  3031,   962,  1595, -1833,    37,    38,    39,    40,
    1982,  2092,   355,    44,  4210,  1115,  2080,  1366,  3423,  2235,
    1620,  1621,  4218,   885,  3659, -1595,  3876,  3664,  3665,  3666,
    3667,  3668,  3669,  3670,  3671,  3672,  3673,  2205,  2127,  1178,
    2206, -1368,  3637,  3840,  3398,  3741,  3399,  3598,  3184,   685,
    1124,  3602,  1875,  2492,   695,  3266,  1977,   355,  1331,  2302,
    4390,  2446,  1065,  1149,  1520,  4382,  3330,  1587,  2517,  2216,
    1126,   892,   892,     3,  3458,  3335,  4275,  3461,  3462,   130,
     131,  3465,  2041,  2632,  3710,  3711,  2356,   796,  1109,  3185,
    4288,  3472,  1682,  1576,  3463,  3464,  3341,  4256,  2559,  1122,
    2042, -2405,  1226,  1053,  1007,  3402, -2133,  2481,  3346,  1264,
    1915,  1007,  2132,  1007,  2043,  4301,  2145,  2145,  2482,  4323,
    1188,  2566,  1068,  1762, -2406,   355,  4421,  2569,  2843,  4377,
    1765,  2196, -1363,  2217,  2817,   934,  2817,  2892,  2796,  3784,
    4353, -2403,  1350,  2655,  2656,  2868,  2287,  1332,   395,  1338,
    1617,  1343,  2121,  2742,  1278,  3797,  1531,  1347, -1685,  3225,
    1532,  3424,  1217,  4131,  2626,  2628,  2041,    37,    38,    39,
      40,  3535,   157,  1618,    44,  2636,  1326,  3802,  2639,  1069,
    1856,  1338,  1343,  1651,  2042,  3494,  2651,  2652,  2218,  1321,
    3425,  1369,  2087,  2088,  2089,  2090,  2091,  2092,  2045,  2669,
    2671,  4476,  1540,  1050,  1541,  4358,  1219,  -127,  -127,  2008,
    2685,  1189,  2122,  3234,  3235,  3236,  3237, -2402,  2797,  3494,
    2352,    37,    38,    39,    40, -1172,  2580,   847,    44,  2287,
     416,  4124,  3349,    37,    38,    39,    40,   349,  1064,    43,
      44,  1397,  1619,   356,    45,  3761,   176,   356,  4427,  1070,
    4404, -1368,  2495,  2284,  1606,  1369,  3798,  1701,  2292,  1270,
     904,   355,   845,  3582,  2297,  2373,  4436,   215, -1997,  1521,
    4266,  1609,  2743,  3584,  1109,   402,   892,   992,  3803,  3785,
    3186,  3403,  1171,  1098,  2089,  2090,  2091,  2092,  2018,   695,
      80,  1545, -2133,  4302,  2870,  4132,   355,   223,  1336, -1172,
    1341,  4437,   193,  1508,   956,  2359,  3404,  1516,  2362,  2363,
    1350,  2517,  2024,  2591,  2592,    79,  4267,  3536,  1322,  3894,
    4310,  1317,  3750,  4268,   957,   892,  1522,  4335,  1351,  4403,
    1371,  1373,   234,  1337,  1070,  1342,  3225,   695,   695,  3227,
    3799,  1389,  1502, -1785,   237,  1356, -2133,  1377,  1253,  4315,
    4316,    74,   993,  4269,   695,  1757,  2558,  2720,  2220,   394,
    1071,  2416,  2288,   394,  2283,  1372,  1374,  3338, -1375,  4458,
     967,  2420,   967,  2979,   967,  1394,  3786,  1978,   215,  3787,
     967,  1348,  1349,  1499,  4244,  1536,  3782,  1511,  1270,  1513,
    2581,  1161,  1162,  1163,  2284,  1164,  1165,  1166,  1167,  1168,
    1169,   794,  2980,  4121,   967,   967,  2536,  4022,   223,  3762,
    1109,  4405,   691,   797,  1559,   861,  3736, -1682,  4026,  2582,
     416,  3857,  4270,    37,    38,    39,    40,  4428,  2330,    43,
      44,  2421,   896,  2066,    45,  2289,   232,  1542,  3763,  3035,
    1351,    35,   416,   234, -1172,    37,    38,    39,    40,    41,
      42,    43,    44,  1098,  3895,   237,    45,  1351,  3741,  1365,
    1339, -1175,  4336,  2106,  1344,  1345,  1346,  2339,  1171,  2380,
     863,  4025,   682,   682,  1357,  2562,  3586,  1630,    37,    38,
      39,    40,  2721,  1599,   356,    44,  2722,  4145,  4438,  4222,
    1188,  3983,  3858,  3984,  2217,  4146,  1119,  4429,  1628,  4001,
    4002, -1335,  1629,  3313,  1254,  3314,  2069,  4459,  1560,  2974,
    4446,  4419,   702,   416,  3896,  2975, -2407,  3496,  3976,   967,
    4430,  2723,  4334,   994,   995,  3950,  3857,  2285,  3187, -1785,
    3954,  2072,  1366,  3956,  1828, -1175, -1172,  3831,  1622,  1261,
     695,  2981,   695,  3834,  3835,  3836,  3837,  3838,  3839,  2218,
    3587,  2129,  3859,  2658,    37,    38,    39,    40,  3393,  1255,
    4338,    44,   803,  3947,  3232,  3233,  3234,  3235,  3236,  3237,
   -1172,  1858,  2269, -1172,  4482, -1335,  1698,  3494,  1736,  1779,
    4231,  1189,  2270, -1785,  1065,  4271,  2774,   695,   956,  1531,
     695,   695,  1838,  1532,  2103,  3188,  2951,  2271,  1626,  3633,
     394,  2664,  2327,   681,   956,   970,   416,   970,   957,   870,
    1531,   871,  2976,   681,  1532,  1171,  2404,   695,  2849,  1737,
      45,  1006,  3985,  3143,   957,  1006,  2405, -1816,   349,  3066,
    3067,  3068,  3069,  1839,  3148,  1793,  3519,   970,   970,   969,
    2951,   969,  2724,   969,  1098,  4147,  1094,  3749,  2771,   969,
    2406,  1620,  1621,  2328,  1980,  2364,  2130,  3859,  2178,  2179,
    2765,  2183,  1270,  2171,  3648,   349,    80,    80,  3347,    80,
    3397,  1865,  2464,   969,   969,  4339,   695,  4232,   695,  2517,
   -1175,  3521,  3588,  2517,  2465,  2466, -2407,  1270,  2850,  2275,
    3584,    79,    79,  2250,    79,   983,  4197,  4198,  2006,  2467,
    1081,  1122,  2468,   355,  2276,  2469,  2904,   355,  4141,  3965,
    1095,  3966,  1599,  1884,  1937,  2441,  1939,  2022,   157,  1943,
    4142,  1945,  2376,  1866,  1948,  1949,  1950,    74,    74,  2272,
      74,  1076,  1076,  1986,  1076,   979,  4340,  1957,  2188,  3625,
    3589,  3232,  3233,  3234,  3235,  3236,  3237,  2049,   967,  3139,
    2906,  1984,   681,  1985,  4346,  2977,  4137,  2905,  4095,  2275,
    2059,  2277,  1070,  1865,  1317,  1096,   681,   681,  1097,  4373,
    1616,  1738, -1175,  4257,  3566,  3135,  2365,  2278,  2366,  1095,
    4176,  1898,  1011,  2618,  2978,  1840,  1011,  2189,   969,  4175,
    2857,  3201,   176,  4374,  2155,  4138,  2187,  2518,  4351,  2522,
    4258,  2907,   680,   680,  4190,  4191, -1175,  1627,  2528, -1175,
    1867,   796,   991, -1816,  4114,  2561,  2119,  2120,  4096,  3525,
     848,    35,  1899,  2062,  2820,    37,    38,    39,    40,    41,
      42,  2277,    44,  2067,  1096,  2422,  2188,  2442,  1936,  3252,
    -796,  1938,  4028,  2104,  1942,   209,  1944,  2278,   193,  1947,
    4206,   956,  4208,  1951,  3526,  1739,  1884,  1868,  1074,  1074,
    1098,  1074,   796,   962,  1595,  1724,  3527, -1816,  3275,  1841,
    1746,   957,  1270,  4143,  1725,  2134,  2423,  4308,  3031,  1270,
    1270,  4164,  3035, -1335,  3370,  2189,   691,   691,  2441,  3387,
   -1834,  1776,  1777,  1154, -1335,  2219,  2018, -1335,  1646, -1335,
    1599,   813,  1867,  2061,  1599,  1599,  4219,  2279,  2155,  4079,
    4080,  2087,  2088,  2089,  2090,  2091,  2092,  2232,  2069,  3123,
     395,   395,  1248,  1007,   215,   796,  2640,  1007,  3660,  1098,
    3661,  3961,  2068,  3314,  1708,  2069,   967,  2136,   814,  1869,
     967,   967,  3772,  2072,   355,   804,  3528,  3124,  1565,  1868,
    2829,  1249,  1095,  1099,   223,   805,  2954,  1952,  3636,  1043,
    2072,   682,  3604,  1709,  2957,  2073,  2959,   356,  1704,   395,
    4248,  3126,  1100,  1077,  1900,  4296,  2254,  2279,  2228,  2137,
    1953,   681,   232,  3277,   813,  3278,   695,   691,   695,   234,
    2641,   695,  1250,   695,  3637,  1726,   695,   695,   695,  2280,
     861,   237,  1956,  2246,  2248,  1058,  3279,  1096,  2156,   695,
    2442,    43,  2224,  1567,  1349,   416,    45,   969,   356,   356,
     356,   814,  2443,   695,   856,   695,  3109,   956,  2424,  4230,
     695,  1869,  2238,  2341,   246,    37,    38,    39,    40,  2245,
    2247,  2444,    44,  3657,  4151,  2642,  1599,   957,  2643,  3662,
    1905,  4029,  1599,   806,  2765,   863,  1568,  1399,  1901,  3663,
    3225,  1229,   215,  1230,  4313,  1884, -1863,  3677,   356,  2280,
    1906,  3128,  4318,  3156, -1184,   356, -1834,  2364,  2342,  2343,
    1087,   356,   967,   394,  2377, -1184,  3783,  3788,   967, -1184,
    2457,  1705,   223,  1599,  2075,  -159,  1599,  1599,  3546,  1065,
    1088,  1514,  1098,  3874,   861,  1017,  3417,   796,  3071,  3280,
    1089,  2339,  2425,  3072,  3281,  2076,  2077,  1248,  1316,   416,
    -159,  3418,  2125,  -790,  2525,   794,  3396,   234,   157,   967,
   -1834, -1184,   967,   967,   394,   394,   394,   797,  1684,  2765,
    2644,   668,  3829,  2108,  1685,  1066,  3544,  3357,  3336,  1599,
   -1184,  2620,   695,   695,  1565,  4235,  2336,  2517,  1566,   863,
    3820,  1326,  2517,  1399,  2080,  2517,  3225,  2511,  4480,   681,
    1005,  4481,   246,   681,   681,  2402,   794,  2081,  1732,  1042,
    3821,  2041,   807,  1686,   394,   967,   813,  1250,  4418,  2608,
    1651,   394,  2470, -1184,   870,  2443,   871,   394,  2365,  2042,
    2366, -1184,   176,  3645,  2403,   969,  3062,  1733,  1090,   969,
     969,  1734,  2868,  2043,  4254,  3678,  3679,   815, -2197,  1567,
    2781,  3494,   349,   814,  2664,  2664,  1084,  1081,  3282,  2664,
    2619,  4101,  -365,  2645,  1687,   849,  1735,  3283,  1724,   794,
    3227,  1688,  3292,  1006,  1689,  3519,  4036,  2869,  2041,  2041,
     931,   797, -1863,   695,  3420,   681,  3509,  2506,  2507,  4102,
    3520,  3072,  1568,   356,  1006,  2240,  2042,  2042,  2664,  2664,
       8,    80,  1091,  2614,    80,  1064,  2617,  2615,  2616,  3161,
    2045,  2504,  1232,  3421,  1233,  3708,   803,   349,  3999,   122,
    3521,   680,  3522,  3921,  4000,  1690,    79,  3310,   870,    79,
     871,  1018,  3228,  2459,  1171,    35, -1863,   126,  1119,   873,
    3031,  4284, -1184,    41,    42,   681,  2564,  3361,  2565,   875,
    2488,   681,  2567,  1556,  2568,  3226, -1172,  2570,  2324,  1125,
    1741,  2571,    74,  2702,   215,    74,  2329,  1092,  2257,  1006,
    2087,  2088,  2089,  2090,  2091,  2092,  3227,  1150,  1916,  1691,
     796,   969,  1917,    37,    38,    39,    40,   969,  1136,  1742,
      44,  2870,   681,  3523,   223,   681,   681,  2258,  2145,  3400,
    1556,  1152,  2709,  3780,  2018,  2370,  2263,  3350,  2018,   394,
    2263,  2648,  2802,  1531,  1692, -1685,  1157,  1532,  1743,  3035,
    4151,  1186,   232,  1916,  2381,  1068,  2259,  2554,   969,   234,
     803,   969,   969,  3198,  1011,  1545, -1217,  2557,  3228,  1187,
   -1217,   237,  2341,  3774,  3775,  3684, -1216,  1694,   681,  1180,
   -1216,   794,  2851,  3524,  2854,  1011,  3199,   355,  3525,  1224,
    3200,  2341,  2711,   797,  2712,  2637,  2638,  2518,    37,    38,
      39,    40,  1695,  2650,   246,    44,  2690,  2653,  2654,  2693,
    2030,  2031,  1069,  3037,   969,  2713,  1228,  2342,  2343,  1925,
    3542,  1926,  2675,  3526,  2676,  3232,  3233,  3234,  3235,  3236,
    3237, -1217,  1221,  2794,  2401,  3527,  2342,  2343,   355,   355,
     355, -1216,  2005,  2697,   246,  2698,    37,    38,    39,    40,
    2339,  2772,  1237,    44,  1745,  2169,   395,  2170,   209,  1243,
    1011,  3251,    81,  3253,  3254,  3038,   356,  1648,  1225,  2339,
    2845,  2341,  1251,  2517, -1217,  3870,  3871,  3872,  3847,  1127,
    2209,  2210,  1070,  1746, -1216,  2155,  1252,  2172,   355,  2173,
    4241,  1128,  1129,  1257,  2238,   355,  1649,  1758,  2808,  2809,
     209,   355,   796,  3477,  2018,  1007,  1646,  2556,   395,  2557,
     395,  1130,  1260,  2714,  1131,  3528,  2342,  2343,  2715,  2577,
    2579,  2578,  2578,  2716,   416,  1650,  1007,  3229,  3230,  3231,
    1279,  3232,  3233,  3234,  3235,  3236,  3237,  1275,   396,  3039,
    3040,  1289,   803,  2611,   396,  2612,  3478,  1304,   695,  2339,
     695,   682,  3041,  1651,   695,   356,   695,  3005,  2931,   695,
    1298,  2917,  3772,   695,  3350,   967,   932,  1630,  2108,    80,
    3479,    80,  1599,  3728,  3730,  3851,  3852,   396,   796,  3855,
    1364,  3856,   394, -1240, -1240,  3122,  3579,  1319,  4204,  3480,
    1109,  1065,  1629,  1071,    79,  1651,    79,  3778,  3350,    45,
    2793,  1007,  1884,  2837,  3042,  2612,  3481,   356,   967,   356,
    2209,  2813,   887,   796,  2882,  1360,  2883,  1399,  1513,  1375,
    3225,  3482,   396,  2928,   794,  2929,  1132,  3023,  1622,  3024,
      74,  2018,    74,  2263,  3091,  3092,   797,  2717,  1381,  3057,
    2518,  3058,  3432,  3163,   901,  2578,  2718,    35,   416,  1387,
    1399,  3123,  1386,  3225,   215,    41,    42,  3179,   356,  3180,
    3352,  3353,    45,  3197,  1388,  2557,  1133,  3772,  4004,  1012,
    4328,   394,  4330,  3063,  1389,  3207,  1012,  2557,  1012,  3124,
    3210,  1390,  2557,   355,   223,  3864,  3865,  3043,  1710,  3044,
     396,  3214,  1391,  2557,  3125,  1517,  2068,  3942,  3215,  2069,
    2557,  1392,  3483,  3126,  1599,  3868,  3869,  3870,  3871,  3872,
    3484,  1956,  1599,  1396,  1599,  4104,  1994,  1995,  2764,   234,
    3241,  1395,  2557,   394,  2072,   394,  3127,  2240,  3257,  2073,
    2557,   237,  1519,  3260,   356,  3261,  1711,  1523,  3007,  3315,
     967,  3296,  3485,  3297,  1524,  3298,  3007,  3299,   967,  2664,
     967,  1525,  2664,  2664,  2664,  2664,  2664,  2664,  2664,  2664,
    2664,  2664,  2068,  1530,   246,  2069,  1562,  3115,  1564,   356,
      37,    38,    39,    40,   394,  1539,  3342,    44,  3343,  3358,
    3359,    45,  2070,  1546,  3415,   803,  3416,  1553,  1554,  1065,
    2072,  3440,  3065,  3441,  3552,  2073,  3553,  3563,   681,  3564,
    3227,  1556,  1557,  3128,  2068,  1563,  3990,  2069,  1580,  2664,
    2664,  3573,  1712,  3574,  3095,  3649,   794,  2557,  1584,  3603,
    1270,  3606,  1585,  3034,  2070,  3685,   396,  3686,   797,  3921,
    1578,  1588,  2072,  3227,   969,  1155,  3692,  2073,  3693,  1593,
    1174,   681,  4092,  1589,  3704,   681,  2557,  1590,  4084,  1184,
     394,  2826,  1591,  1616,  2074,  1600,   695,  1713,  2075,  1714,
    1592,   396,  3228,  3301,  3302,  1662,  3776,  1270,  2578,  2372,
    3843,  4005,  3844,  2612,  1231,  3772,  3877,   969,  1238,  2076,
    2077,   680,  4043,  1594,  4044,   394,  1601,  4050,  1247,  2578,
    1603,  1632,   794,  2078,  1633,  3228,  1663,  1627,    37,    38,
      39,    40,  1635,  1716,   797,    44,  1646,  4051,  3258,  2578,
    4133,  1641,  4134,  3263,    37,    38,    39,    40,  1661,  1109,
    2074,    44,  1703,  1678,  2075,   796,   355,   794,  2080,  4161,
     796,  1884,  1701,    37,    38,    39,    40,  1744,  1718,   797,
      44,  2081,  4166,  1740,  3553,  2076,  2077,  4179,    37,    38,
      39,    40,  4168,  1664,  3553,    44,  3350,  1754,  1759,  2078,
    3848,  4181,  2074,  4182,  1761,  2059,  2075,  4183,  3171,  2557,
    1763,  1753,  1720,   681,  4189,  1766,  2612,   803,  4238,  2709,
    4239,   681,  1773,   681,  1665,  1771,  1780,  2076,  2077,  1643,
    4252,  2079,  4253,  4285,  2080,  4286,  1783,  4292,  3295,  1884,
    4294,  2078,  3553,  4298,  3880,  2612,  1651,  2081,  2518,   969,
    2511,  4352,  2518,  2124,  2083,   355,  3122,   969,  4034,   969,
    3882,  4081, -2407, -2407,  1822,  3232,  3233,  3234,  3235,  3236,
    3237,  3850,  4356,  2079,  4357,  1828,  2080,  1832,  4365,  3884,
    1884,  -176,  1824,  4435,  2664,  4366,  4367,  2612,  3261,  2081,
    1847,  1834,  2082,   803,  3229,  3230,  3231,  1154,  3232,  3233,
    3234,  3235,  3236,  3237,  4368,  1836,  2557,   355,  1854,   355,
     827,  3868,  3869,  3870,  3871,  3872,  1870,  1872,  4240,  3873,
    2083,   356,  3123,  4383,  1862,  2612,   356,  4385,   803,  2612,
    1877,  1270, -1339, -1339, -1339, -1339,  4386,   887,  2612, -1339,
    2084,  2085,  2086,  1878,  2087,  2088,  2089,  2090,  2091,  2092,
    3124,  1879,  4478,   209,  4479,  2301,  1599,  1668,   355,  4489,
    1880,  4479,  2083,  1669,  1881,  3125,   668,   668,  1894,  1883,
    1670,  1889,  1884,  1892,  3126,  1903,  1893,  4193,  1746,  4297,
    1895, -1346, -1346, -1346, -1346,  1897,  1672,  2238, -1346,  1902,
    3337,  1904,   967,  1909,  1673,  1923,  1958,  3127, -1337, -1337,
   -1337, -1337,  1990,  1992,  1996, -1337,  2084,  2085,  2086,  1998,
    2087,  2088,  2089,  2090,  2091,  2092, -1340, -1340, -1340, -1340,
    1999,  2004,  3951, -1340,  4321,   695,  1956,  2012,  4326,  4327,
    2015,  2016,  2017,  2021,   355,   246,  2023,   394,  2026,   796,
     796,   796,   394,  1674, -1338, -1338, -1338, -1338,  2084,  2085,
    2086, -1338,  2087,  2088,  2089,  2090,  2091,  2092,  2027,  2028,
    2776,  2128,  2029,  2034,  2664,  2664,  2777,  2036,  4035,   355,
    2037,  2038,  1684,  2039,  3128,  2097,  2040,  2047,  1685,   794,
    2048,  4084,  3476,  2050,   794,  2051,  2052,  2053,  2054,  2055,
    2056,   797,  2139,  1350,  2124,  2150,   797,  3556,  2160,   796,
    4117,  2176,  1566,  2203,  3433,  2208,  2215,  1098,   396,  1568,
    2223,  2518,   396,  2229,  2231,  2233,  1146,  1686,  2241,  4322,
    2457,  2242,  1146,  4325,  3443,  2244,  2249,  2251, -2349,  2253,
    1171,  2260,  2263,  3594,  2261,  2264,  2265,   796,  2286,  2291,
    2293,  2294,  4300,  2295,  2296,  2324,  3952,  2317,  2318,  2326,
    2336,  2337,  2338,  1146,  2339,  3007,   881,  2346,  3007,  3007,
    2345,  2351,  3007,  2353,  2347,  3557,  2348,  2354,  1687,  2360,
    4085,  2367,  3007,  2357,  2358,  1688,   349,  1779,  1689,  2368,
    3570,  1724,  2374,  3497,  2393,  2375,  2382,  2383,  2414,  3506,
    2391,   349,  2426,  2428,  1265,   356,   356,   356,  2392,  2429,
    3593,  2398,  2400,  2436,  2008,  1146,  2438,  2439,  1599,  2018,
    2024,   349,  1146,  2448,   858,  1065,  2474,  3497,  2511,  2496,
    2240,  2491,  2511,  2454,  1726,   681,  2499,  2501,  2458,  1690,
    2502,  3551,    81,  2665,  2068,   937,  2503,  2069,  2509,  2532,
     803,  2520,  1599,  2533,   967,   803,  2534,  2535,  2548,  3501,
    3504,  3718,  3719,  3720,  3721,   356,  2549,   938,  2573,  3578,
    1270,   969,  2072,   157,   892,  3640,  4372,  2073,  2589,  2594,
    2597,  3538,  2601,  2609,  2631,  2622,   349,  2068,   967,  2574,
    2069,  2673,  4274,  1691,  2632,  2674,  2686,  2691,   939,  2069,
    2695,  2696,  2744,   356,  2708,  2703,  2725,  2753,  2727,  2768,
     892,  2767,  2770,  2778,  2773,  2072,  2775,  4307,  2779,  2795,
    2073,   394,   394,   394,  1069,  2786,  2804,  2822,  1692,  4455,
    2803,  3687,  1146,  2807,  2114,  2819,  2518,  2821,  1012,  2838,
    2840,  2518,  1012,  2839,  2518,  2836,  1399,   176,   796,  3225,
    2847,  2852,  2855,  2857,  2859,  2664,  2860,  1693,  2861,   396,
    2863,  1694,  2878,   794,   794,   794,  3701,  2866,  1146,  2873,
    2880,  2923,  4213,  2927,  2919,   797,   797,   797,  2930,  2664,
    2664,   394,  2988,  2982,  2983,  2984,  1695,  2996,  2992,  2993,
    2997,   355,  4225,  2998,  3002,  3000,   355,  3003,  3001,  3004,
    1399,  2059,  2074,  3225,  3014,  3016,  2075,  3025,  3274,  3027,
    3030,  3020,  1684,  3031,  3032,  3033,  3055,  3059,  1685,   394,
    3702,  3064,  3070,   794,  3073,  3077,  3078,  2076,  2077,  3094,
    3096,  3108,  3111,  3134,  1171,   797,  3811,  3112,  3699,  3315,
    3113,  2078,  3114,  3140,  3141, -2407,  3121,  3149,  3152,  2075,
    3350,  3155,  3154,  3165,  1171,  3166,  3159,  1686,  3177,  3167,
    3168,   794,  3189,  3170,  2623,   668,  3193,  1366,  3195,  3208,
    2076,  2077,  3209,   797,  3211,  3212,  2080,  3213,  3216,   215,
    3217,  3739,  3276,  3219, -2407,  3291,  2557,   681,  2917,  2081,
    3794,  3247,  1399,  4465,  3222,  3225,  3240,  3246,  3248,  3304,
    3310,  3271,  3249,  3377,   356,   796,  1146,   796,  1687,   223,
    3363,  3256,  4006,  1146,  3269,  1688,  3365,  3374,  1689,  2080,
    3270,   681,  3284,   969,   803,   803,   803,  4381,  3309,  3227,
     796,  3368,  2081,  3294,  1819,  3364,  3379,   232,  4465,  3390,
     695,  1916,  3369,  3389,   234,  3380,  4465,  3384,  3394,  3395,
    2664,  3385,  3407,  3386,  3409,  3430,   237,   969,  3431,  3434,
    3436,  3445,  2083,  1146,  3444,  3446,  3447,  3448,  3460,  1690,
    3499,  3449,  3450,  4085,  3451,  3452,   695,  3453,  3454,  3466,
    3467,  3468,  3469,  3227,   803,  3497,  3470,  3471,  3500,   246,
    3755,  3228,  2226,  3508,  3511,  3532,  3539,  3543,  3545,  3812,
    3561,  3558,  3813,  3510,  3814, -2407,  2397,  3567,  3571,  3562,
    1599,  3568,  3591,  3612,  3599,  3595,  3597,  3600,    81,    81,
     394,    81,   803,  1691,  3607,  3617,  3610,  3628,  3007,  1146,
    3619,  3629,  3630,  3631,  3007,  3007,  3007,  3007,  3007,  3007,
    3639,  4380,  3634,  3642,  1270,  3228,   967,  3643,  2005, -2407,
   -2407,  3652,  2087,  2088,  2089,  2090,  2091,  2092,  1692,   967,
    3225,   356,   794,   356,  3242,   355,   355,   355,  3243,  1599,
    2063,  3506,  2100,  3681,   797,  3227,  3706,  3682,  3694,  3707,
    3879,  3881,  3883,  3885,  2228,  3683,   356,  1729,  3715,  1819,
    3725,  1694,  2518,  3731,  2460,  2087,  2088,  2089,  2090,  2091,
    2092,  3743,  3742,  1171,  3754,   967,  2511,  3744,  3748,  2397,
    3745,  2511,  3751,  3756,  2511,  1146,  1730,  3765,  3779,  1348,
    1349,  3817,  3832,  3781,  3593,   355,  3808,  4039,  3863,  3789,
    3795,  3796,  3504,  3806,  3833,   349,  3807,  3228,  3809,  3934,
    3810,  3878,  3830,  1146,  3866,  3899,  3906,  3583,  3908,  3892,
    3229,  3230,  3231,  3902,  3232,  3233,  3234,  3235,  3236,  3237,
    3909,  2068,  2578,   355,  2069,  3911,  4037,  2397,  3925,  3912,
    1146,  1146,  3916,  1146,  3929,  3930,  3932,   394,  3943,   394,
    3939,  2518,  3945,  3955,  3969,  3974,  2096,  3963,  3940,  2072,
    1146,  3977,  4056,  3948,  2073,  3979,  3982,  3958,  3986,  3991,
    3987,  4224,   394,  3992,  3229,  3230,  3231,  4017,  3232,  3233,
    3234,  3235,  3236,  3237,  4018,  3997,  4038,  1147,  4040,   794,
    1151,   794,  4053,   803,  4045,  3993,  2826,  2135,  4020,  4021,
    4054,   797,  4055,   797,  4061,  4067,  1182,  4077,  1154,  4070,
    4082,  1146,   396,  4078,   794,  4090,  4097,  3858,  4100,  4103,
    4110,  4118,  4122,  4126,  4128,  4135,   797,  4148,  4139,  1227,
    4149,  1399,  4156,  3973,  3225,  4163,  2665,  2665,  4173,  4177,
    4178,  2665,  4180,  1146,  1245,  4185,  4186,  1146,  1146,   681,
    4187,  4007,  4112,  4188,  4195,  4199,  2518,  4207,  4201,  4217,
    4205,  4220,   681,   396,   396,   396,  3229,  3230,  3231,  4227,
    3232,  3233,  3234,  3235,  3236,  3237,  4228,  4233,  4234,  4242,
    2665,  2665,  4032,  4033,  3898,   969,  3476,  4249,  4251,  2074,
    4260,   130,   131,  2075,    80,  4261,  4262,  4276,   969,  4264,
    4277,  4278,  4279,   796,  4280,  4290,  4306,  4031,   681,  1070,
    4337,  4341,  4314,   396,  2076,  2077,  4345,  4347,  4350,    79,
     396,  1819,  4354,  1283,  4360,  4364,   396,  1291,  2078,  4369,
    1012,  4370,  4355,  4371,   355,  4376,  4378,  1303,  4323,  1910,
    4387,  4388,  4391,  2238,   969,  4393,   937,  4397,  4400,  3733,
     803,  1012,   803,  4417,  4420,    74,  4422,  4434,  1819,   967,
    2079,   796,  4426,  2080,  4389,  4390,  4457,  4447,   938,  4474,
    3007,  3007,  4123,  4477,   157,   803,  2081,  4483,  4487,  1079,
    2399,  1819,  3101,   349,  1270,   967,  3061,  2147,  2922,  4088,
    4089,  3339,  3405,  4093,  4094,  3792,  4064,  4065,  3473,   939,
    1662,  4068,  4069,  4236,  4333,  4083,  3506,  3506,  3506,  3506,
    3506,  3927,  4263,  4115,  3227,  3382,  3164,  4273,  4423,  4211,
    4454,  4394,  4392,  4432,  3928,  2871,  1012,  2490,  4289,  3815,
    3438,  1663,  2511,  2471,  3036,  3548,  4456,  4488,  4099,  4484,
    4098,  3540,  4433,  1819,  3487,  4226,  2453,  4384,   176,  2083,
    4130,  4229,  3975,   987,  4309,  3935,  1976,  4399,  2886,   356,
    2434,  3936,  4359,  1271,  2518,   668,  4440,  3504,  3504,  3504,
    3504,  3504,  4485,  2789,  1527,   967,  3228,  4150,  1819,  4255,
    2790,  3915,  2563,  3641,  3344,  3160,  1924,  2174,  1664,  1552,
    4424,   355,  2841,   355,  3348,  2200,  2844,  2812,  2199,  3360,
    2811,  2806,  3356,  1819,  2204,  2785,  3303,  3117,   396,  3605,
    4165,  1535,  3913,  3345,  3698,  1267,   355,   356,  2864,  1665,
    4299,  3688,  4408,  4416,  4409,  3287,  2876,  3351,  3289,  1699,
    1700,  3204,  3182,  2752,  1112,  2084,  2085,  2086,  3592,  2087,
    2088,  2089,  2090,  2091,  2092,  1864,  2505,  3102,  3110,  2890,
    1146,  2823,  1146,  4407,  1082,  2214,  1315,  2207,  1819,  2814,
    1987,  1146,  1611,  1612,  2830,  2827,  3334,  3758,  2828,  2913,
    1640,  4027,  2113,  3759,  3747,   394,  2240,  2211,  3162,  1105,
     215,  2834,  2575,    83,  1913,     0,  2932,  1355,  1774,  2952,
    4486,  4203,   681,    81,     0,     0,    81,     0,     0,  3497,
       0,     0,     0,     0,  1826,  1827,     0,  2968,     0,     0,
     223,     0,     0,     0,  2972,     0,  3007,   794,   681,     0,
    4237,  1853,     0,  2985,  1599,     0,     0,  4202,   969,   797,
    2989,     0,     0,   394,     0,  3229,  3230,  3231,   232,  3232,
    3233,  3234,  3235,  3236,  3237,   234,  1146,     0,   209,   940,
       0,     0,  1668,     0,   969,  1886,  1888,   237,  1669,     0,
     967,     0,     0,     0,     0,  1670,     0,     0,     0,     0,
       0,     0,     0,  1746,     0,   794,     0,     0,     0,     0,
       0,  1672,     0,     0,  1146,  1146,     0,   797,     0,  1673,
     941,  1684,  1146,     0,     0,  1146,     0,  1685,  1146,  1891,
       0,     0,     0,  2649,     0,     0,  1146,  1146,   681,     0,
       0,     0,   796,     0,  1146,     0,     0,  1146,  1146,  1146,
    1146,     0,     0,     0,     0,     0,     0,  1146,  1146,     0,
    1146,     0,  1146,     0,     0,  1146,  1686,     0,  1674,  4473,
       0,     0,  3104,  3583,   969,     0,     0,     0,     0,  1819,
    1146,   396,     0,     0,  1146,     0,     0,     0,  1146,     0,
       0,     0,  1146,     0,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,     0,  1146,  1975,     0,  1270,   803,     0,
    1146,     0,     0,  1146,     0,     0,     0,  1687,     0,     0,
       0,  1991,     0,     0,  1688,     0,     0,  1689,     0,     0,
       0,  2665,     0,  2001,  2665,  2665,  2665,  2665,  2665,  2665,
    2665,  2665,  2665,  2665,  3101,     0,     0,     0,     0,     0,
       0,     0,     0,  2068,     0,     0,  2069,     0,     0,     0,
       0,     0,  1662,    35,     0,     0,   803,     0,     0,     0,
     396,    41,    42,  2070,     0,     0,     0,  2068,  1690,     0,
    2069,  2072,     0,  1146,     0,     0,  2073,     0,     0,     0,
       0,  2665,  2665,  1663,     0,     0,     0,  2070,   356,  4442,
    2071,     0,  4445,  4443,  4444,  2072,     0,     0,     0,     0,
    2073,     0,     0,   349,     0,     0,     0,     0,     0,  4361,
       0,     0,   396,   681,   396,     0,     0,     0,     0,     0,
       0,  4442,  1691,     0,  4445,  4443,  4444,     0,     0,     0,
       0,     0,     0,     0,     0,  4472,     0,     0,     0,   355,
    1664,     0,     0,     0,     0,     0,     0,     0,     0,   969,
       0,    81,     0,    81,     0,     0,     0,  1692,     0,     0,
       0,     0,  1896,   396,  4442,     0,     0,  4445,  4443,  4444,
       0,  1665,     0,  1911,     0,     0,     0,     0,   349,     0,
       0,     0,     0,     0,  2175,     0,  1749,  1146,     0,     0,
    1694,     0,  4467,     0,     0,     0,     0,   355,     0,  3102,
       0,  2074,     0,     0,   394,  2075,     0,  1819,     0,     0,
       0,     0,  1819,  1819,     0,  1750,  3101,  4466,     0,     0,
       0,     0,     0,  1819,     0,  2074,  2076,  2077,     0,  2075,
       0,     0,     0,     0,  1662,     0,     0,  4467,     0,   396,
    2078,     0,     0,     0,     0,  4467,   794,     0,     0,     0,
    2076,  2077,     0,  4463,     0,     0,     0,     0,   797,     0,
       0,     0,  4466,     0,  2078,  1663,     0,     0,     0,     0,
    4466,     0,  2079,     0,   396,  2080,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2081,     0,
    3371,  2082,     0,     0,     0,     0,  2079,     0,  4463,  2080,
     209,     0,     0,     0,  3103,     0,  4463,     0,     0,     0,
    1669,     0,  2081,     0,     0,  2082,  2665,  1670,     0,     0,
       0,     0,  1664,     0,     0,  1746,  2386,  2387,  2388,  2389,
    1803,     0,     0,  1672,     0,     0,  1146,     0,  1819,     0,
       0,  1673,   681,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1665,     0,     0,  2068,  2417,  2418,  2069,
       0,  2083,     0,  2427,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3419,  2070,     0,  4362,     0,
       0,  3102,  3429,     0,  2072,  2083,     0,     0,     0,  2073,
    1674,     0,     0,     0,  3104,     0,     0,     0,     0,  1819,
       0,     0,     0,     0,     0,     0,     0,   803,     0,     0,
    1146,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1146,     0,     0,     0,     0,     0,     0,     0,  2475,  2476,
    2477,  2478,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3456,     0,     0,  2084,  2085,  2086,
       0,  2087,  2088,  2089,  2090,  2091,  2092,  1146,     0,     0,
       0,     0,     0,  3218,     0,     0,     0,     0,     0,     0,
       0,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,
    2092,     0,   209,     0,     0,  1988,  1668,     0,     0,     0,
       0,     0,  1669,     0,     0,     0,  2665,  2665,     0,  1670,
    2552,  1146,     0,     0,     0,  2068,     0,  1746,  2069,     0,
    3049,     0,  1819,  2530,  2074,  1672,     0,     0,  2075,     0,
       0,     0,  2539,  1673,     0,  2070,     0,     0,     0,     0,
       0,  1146,  1146,  2072,  2546,     0,     0,     0,  2073,  2076,
    2077,     0,     0,     0,     0,     0,     0,     0,   355,     0,
       0,     0,     0,  2078,     0,     0,     0,     0,     0,     0,
       0,  1146,  1146,     0,  2933,     0,  1146,     0,     0,     0,
       0,     0,  1674,  2934,  2935,  2936,  3104,     0,  1146,  1146,
    1146,  1146,     0,     0,     0,  2079,   396,     0,  2080,     0,
    1146,   396,     0,  1146,  2583,  1146,     0,  2588,     0,  2590,
       0,  2081,  2593,     0,  2082,  1146,  1146,  2397,  1146,     0,
       0,     0,     0,     0,     0,     0,     0,  2937,     0,     0,
       0,  1146,     0,  1146,     0,  3635,     0,  1146,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2068,  1146,     0,  2069,     0,  3647,     0,     0,
       0,     0,     0,  1146,     0,  1146,  1146,  1146,     0,     0,
       0,  3050,  2070,  2074,     0,     0,  2938,  2075,     0,     0,
    2072,     0,     0,     0,  2083,  2073,     0,  1146,     0,     0,
       0,     0,     0,     0,     0,     0,  1146,     0,  2076,  2077,
       0,     0,     0,     0,     0,  1146,     0,  1662,     0,     0,
    1146,     0,  2078,     0,     0,  2939,     0,  1146,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2940,  2941,  2942,  2943,  2944,     0,  2945,  1663,     0,
       0,     0,     0,     0,  2079,     0,     0,  2080,     0,     0,
    2523,     0,     0,     0,     0,     0,     0,  1988,     0,  2529,
    2081,     0,     0,  2082,     0,  1146,     0,  2537,  2538,  2946,
    2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,
       0,     0,     0,     0,     0,  2550,  3264,  2665,     0,     0,
       0,     0,     0,  1819,  1819,  1664,  1819,     0,     0,     0,
       0,     0,     0,     0,     0,  3051,     0,     0,     0,     0,
    2074,  2665,  2665,     0,  2075,     0,     0,  2350,     0,     0,
       0,     0,     0,     0,     0,     0,  1665,     0,     0,     0,
       0,     0,     0,  2083,     0,  2076,  2077,  1819,     0,  1819,
       0,     0,  2947,     0,  3052,     0,     0,     0,     0,  2078,
       0,     0,  3777,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2948,     0,
     396,   396,   396,     0,     0,  2949,     0,     0,  2950,  2413,
       0,  2079,     0,     0,  2080,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1988,  2081,     0,     0,
    2082,     0,     0,     0,     0,     0,     0,     0,  1819,     0,
    3822,     0,  3824,     0,     0,     0,     0,     0,     0,  2084,
    2085,  2086,  1666,  2087,  2088,  2089,  2090,  2091,  2092,     0,
     396,     0,     0,  2694,  3488,  1819,     0,     0,     0,  2450,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1667,     0,     0,     0,   209,     0,     0,  2891,  1668,
       0,     0,     0,     0,     0,  1669,     0,  2955,   396,  1819,
    2083,  2068,  1670,     0,  2069,     0,     0,     0,     0,     0,
    1671,     0,  2665,     0,     0,     0,  1819,     0,  1672,     0,
       0,  2070,     0,     0,  2524,     0,  1673,     0,     0,  2072,
    1819,     0,     0,     0,  2073,     0,     0,     0,     0,     0,
       0,     0,     0,  1819,  2999,     0,     0,     0,     0,     0,
       0,  3008,  3009,  3010,  3011,  3012,  3013,     0,     0,     0,
       0,  1146,     0,     0,     0,  1146,  2780,     0,     0,     0,
       0,     0,     0,     0,  1146,  1674,     0,     0,     0,     0,
    1819,     0,     0,     0,     0,     0,  2084,  2085,  2086,     0,
    2087,  2088,  2089,  2090,  2091,  2092,     0,     0,  2068,     0,
    3498,  2069,     0,     0,     0,     0,     0,     0,     0,     0,
    1146,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3080,     0,     0,     0,  2072,     0,     0,     0,
       0,  2073,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1146,     0,     0,  1819,     0,     0,     0,
       0,     0,  1146,  2068,     0,     0,  2069,     0,  1146,  2074,
    1146,     0,  3144,  2075,  3146,  1819,  1146,     0,     0,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,     0,
       0,  2072,  1146,  1146,  2076,  2077,  2073,     0,     0,     0,
    1819,     0,     0,     0,     0,  1146,     0,     0,  2078,   396,
       0,  1146,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1146,     0,     0,  1146,  2700,  1146,     0,     0,  3285,
       0,     0,     0,     0,  1819,  1146,  1146,  1146,     0,     0,
    2079,  1146,  2933,  2080,  1146,     0,     0,     0,     0,     0,
       0,  2934,  2935,  2936,  1146,     0,  2081,     0,     0,  2082,
       0,     0,  1819,     0,  1146,  3169, -2407,     0,     0,     0,
    2075,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2068,  3712,     0,  2069,     0,     0,     0,
       0,  2076,  2077,   676,     0,  2937,     0,  4062,   694,     0,
       0,     0,     0,  2070,     0, -2407,     0,     0,  4071,     0,
       0,  2072,     0,     0,     0,     0,  2073,     0,     0,     0,
       0, -2407,     0,     0,     0,  2075,     0,     0,     0,  2083,
       0,     0,     0,     0,  1146,     0,   694,     0,     0,     0,
    2080,     0,     0,     0,  2938,     0,  2076,  2077,     0,     0,
       0,  2068,     0,  2081,  2069,     0,   694,     0,     0,     0,
   -2407,     0,     0,     0,     0,     0,   396,  1819,   396,     0,
       0,  2070,     0,     0,     0,   978,     0,     0,     0,  2072,
       0,     0,     0,  2939,  2073,     0,     0,     0,     0,   980,
       0,   396,     0,     0,     0,  2080,     0,   988,     0,  2940,
    2941,  2942,  2943,  2944,     0,  2945,     0,     0,  2081,     0,
       0,     0,   998,     0,   978,  2084,  2085,  2086,  1019,  2087,
    2088,  2089,  2090,  2091,  2092,     0, -2407,  1047,     0,  3697,
       0,     0,     0,     0,     0,  1052,  1047,  2946,     0,     0,
       0,  2074,     0,     0,  3142,  2075,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1156,     0,     0,  3150,  3151,
       0,  1176,  3153,     0,     0,     0,  2076,  2077,  3157,  1185,
       0,  1146,     0,     0,     0,     0,     0,  1193,     0,  2893,
    2078, -2407,  1220,     0,     0,     0,     0,     0,     0,  1819,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2074,
    2947,     0,  2079,  2075,     0,  2080,  2087,  2088,  2089,  2090,
    2091,  2092,     0,     0,  1819,  1146,  1146,     0,  2081,  3375,
    3376,  2082,  3378,     0,  2076,  2077,  2948,     0,     0,     0,
       0,  3196,     0,  2949,     0,     0,  2950,     0,  2078,  1146,
       0,     0,     0,  2068,  1146,     0,  2069,  1146,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2087,  2088,  2089,  2090,  2091,  2092,     0,     0,     0,
    2079,  2072,     0,  2080,     0,     0,  2073,     0,     0,  2068,
       0,     0,  2069,     0,  3029,     0,  2081,     0,     0,  2082,
    1146,  2083,     0,     0,     0,     0,     0,     0,     0,     0,
    1368,     0,     0,     0,     0,     0,     0,  2072,     0,     0,
       0,     0,  2073,     0,     0,     0,     0,  1384,     0,  3435,
       0,     0,     0,     0,     0,     0,  1146,     0,     0,     0,
       0,     0,     0,  1146,  1146,     0,  1819,     0,     0,     0,
       0,  1146,  1146,     0,     0,     0,  1146,  1819,  1506,     0,
       0,     0,  1146,  1146,     0,     0,  1146,     0,     0,  2083,
       0,     0,     0,     0,  3713,  1529,     0,  1146,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2084,  2085,  2086,
    1146,  2087,  2088,  2089,  2090,  2091,  2092,     0,  1558,     0,
       0,  3753,     0,  1684,     0,     0,    81,     0,     0,  1685,
    3716, -2407,     0,     0,     0,  2075,     0,     0,  1146,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3534,
       0,  3537,     0,  1710,     0,     0,  2076,  2077,     0,  1819,
       0,     0,     0,     0,     0,     0,     0, -2407,  1686,  1819,
   -2407,  2075,     0,     0,     0,  2084,  2085,  2086,     0,  2087,
    2088,  2089,  2090,  2091,  2092,     0,     0,     0,  3190,  3767,
       0,     0,  2076,  2077,     0,     0,     0,     0,     0,  3388,
       0,  1711,     0,     0,     0,  2080, -2407,     0,     0,     0,
       0,     0,     0,     0,   396,     0,     0,     0,  2081,  1687,
       0,     0,     0,     0,     0,     0,  1688,     0,     0,  1689,
       0,     0,     0,     0,     0,     0,     0,     0,  3408,     0,
    3410,  2080,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2081,     0,     0,     0,     0,     0,
       0,   694,  1146,     0,     0,     0,     0,     0,  3632,     0,
       0,     0,   396,     0,     0,     0,     0,  1712,     0,     0,
    1690,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2407,  3644,     0,     0,  2068,     0,     0,  2069,  1849,
    1851,  1852,     0,     0,     0,     0,     0,     0,     0,     0,
    1819,     0,     0,     0,     0,  2070,     0,     0,     0,     0,
       0,  1146,  1713,  2072,  1714,  1146,     0, -2407,  2073,     0,
    1819,     0,     0,     0,  1715,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1146,     0,     0,     0,  1819,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1716,  1692,
       0,     0,     0,     0,     0,     0,  1146,  1146,     0,     0,
    1146,  2087,  2088,  2089,  2090,  2091,  2092,  1146,  1146,     0,
       0,     0,     0,     0,     0,     0,     0,  2068,  1717,     0,
    2069,     0,  1694,  1718,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1146,  1506,     0,  2087,  2088,  2089,
    2090,  2091,  2092,     0,     0,  2072,     0,  1719,     0,     0,
    2073,  1819,     0,     0,  1146,     0,     0,  1720,     0,     0,
    1142,  1148,   694,  1506,  1148,     0,  1142,   676,  1047,     0,
    1173,     0,   676,  2074,  1047,     0,  1047,  2075,     0,     0,
    1148,   676,  1047,     0,     0,     0,     0,     0,     0,     0,
    1195,  1146,     0,     0,     0,  1047,  3613,  1142,  2076,  2077,
    3616,   694,  3618,  1148,  3620,  3621,   676,     0,  1173,     0,
     676,  1240,  2078,  3626,     0,     0,     0,     0,  1148,     0,
     676,     0,     0,  3426,     0,  3428,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4010,  1146,
    1047,  1819,     0,     0,  2079,  1269,     0,  2080,     0,  1142,
       0,  3646,     0,   694,     0,     0,  1142,     0,     0,  1173,
    2081,     0,     0,  2082,     0,     0,     0,  1146,  1819,     0,
    1146,     0,  1146,     0,  1148, -2407,     0,     0,     0,  2075,
       0,     0,     0,     0,     0,  1330,     0,     0,     0,     0,
       0,     0,     0,     0,  3459,     0,     0,     0,     0,  2151,
    2076,  2077,     0,     0,     0,     0,     0,     0,     0,  2068,
    1146,     0,  2069,  1819, -2407,     0,     0,  1819,  1819,     0,
       0,     0,     0,  1047,     0,     0,     0,     0,  1047,  2070,
       0,     0,     0,  2083,     0,     0,     0,  2072,     0,     0,
    1047,  1385,  2073,   396,     0,     0,     0,     0,     0,  2080,
    1146,     0,     0,     0,     0,  3903,  3904,     0,     0,     0,
       0,     0,  2081,     0,     0,     0,  1488,     0,     0,     0,
     694,  1047,  3554,     0,  1269,  2068,  1819,     0,  2069,     0,
    4363,     0,     0,     0,     0,     0,  2893,     0,  1047,     0,
       0,     0,  1047,     0,     0,  2070,  1146,  1538,     0,     0,
       0,     0,  1488,  2072,     0,     0,     0,     0,  2073,     0,
       0,  1047,     0,     0,     0,     0,     0,     0,     0,  2084,
    2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,
       0,     0,     0,  3980,     0, -2407,  3614,     0,     0,     0,
    1146,     0,     0,     0,     0,     0,     0,  1146,     0,  3970,
    3971,  3972,     0,     0,     0,     0,     0,     0,   676,   676,
       0,  2335,     0,  1146,  1146,     0,     0,  2074,     0,     0,
       0,  2075,     0,  1146,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2076,  2077,     0,     0,     0,     0,     0,     0,
    1146,     0,  3653,  1148,  1148,     0,  2078,     0,     0,     0,
    1146,  2390,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3658,     0,     0,     0,  2087,  2088,  2089,  2090,  2091,
    2092,     0,  2411,  2074,     0,     0,     0,  2075,  2079,     0,
    1142,  2080,     0,     0,     0,     0,  3680,  1142,     0,     0,
    1173,     0,  4047,  4047,  2081,     0,     0,  2082,  2076,  2077,
       0,     0,  1148,     0,  1146,     0,     0,     0,     0,     0,
       0,     0,  2078,  1146,     0,     0,     0,     0,  1148,  1148,
    1988,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1047,  1047,  1047,  1148,     0,  1142,     0,  4075,
       0,  1861,     0,     0,  2079,     0,     0,  2080,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2081,     0,     0,  2082,     0,     0,     0,  2083,     0,  1148,
    1148,     0,     0,     0,     0,     0,     0,  4073,  4074,     0,
    4076,     0,     0,     0,     0,     0,     0,     0,  1269,     0,
       0,     0,     0,     0,     0,  2068,     0,     0,  2069,     0,
       0,     0,     0,  1488,     0,  2541,     0,     0,     0,     0,
       0,     0,  3964,  1269,  2545,  2070,     0,     0,     0,  3967,
    3968,     0,     0,  2072,     0,     0,     0,     0,  2073,     0,
       0,     0,     0,  2083,  2560,     0,     0,     0,     0,     0,
       0,     0,     0,  1961,  1961,     0,     0,     0,  1047,     0,
     978,     0,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,
    2090,  2091,  2092,     0,     0,     0,     0,  4012,     0,     0,
       0,     0,  2068,  1997,     0,  2069,  1047,     0,     0,  2003,
       0,  1506,  1506,     0,     0,     0,     0,     0,     0,  1488,
       0,     0,  2070,     0,     0,     0,     0,     0,     0,     0,
    2072,     0,     0,     0,     0,  2073,     0,     0,  4160,     0,
       0,     0,     0,     0,     0,     0,     0,  1488,  4160,  2084,
    2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,
       0,     0,     0,  4184,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1488,  1488,     0,  1488,     0,     0,
       0,     0,     0,  2074,     0,     0,     0,  2075,     0,     0,
       0,     0,     0,     0,  1488,     0,  4214,     0,     0,     0,
       0,     0,     0,     0,     0,  3905,     0,     0,  2076,  2077,
       0,     0,     0,     0,   694,   694,     0,  4059,  4060,     0,
       0,     0,  2078,     0,     0,     0,     0,     0,  1269,     0,
       0,     0,     0,     0,     0,  1269,  1269,     0,     0,     0,
    2751,     0,  1047,     0,     0,  1488,     0,     0,     0,     0,
       0,  2161,     0,  2168,  2079,     0,     0,  2080,     0,     0,
    2074,     0,     0,     0,  2075,  2769,     0,     0,     0,     0,
    2081,     0,     0,  2082,     0,     0,     0,  1488,     0,     0,
       0,  1488,  1488,     0,     0,  2076,  2077,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4281,  2078,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2788,     0,  2791,     0,     0,   694,     0,   676,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2079,     0,     0,  2080,     0,     0,     0,     0,     0,
       0,     0,     0,  2083,     0,     0,     0,  2081,     0,     0,
    2082,     0,     0,  4293,     0,     0,     0,     0,     0,  4047,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1988,     0,     0,     0,     0,     0,     0,
       0,  4329,     0,  4331,     0,     0,     0,     0,     0,     0,
    4169,     0,  4170,  4171,     0,     0,     0,     0,  2323,     0,
       0,     0,     0,  4174,  1047,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1173,     0,     0,
    2083,     0,     0,     0,  4332,     0,     0,     0,     0,  2084,
    2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,
       0,     0,     0,  4209,     0,     0,     0,     0,     0,     0,
    1148,  1148,  1148,  1148,  1047,  4058,     0,     0,   676,     0,
       0,     0,     0,     0,     0,  4066,     0,     0,     0,     0,
       0,     0,     0,  2410,     0,  1047,     0,  2912,     0,     0,
       0,  1148,  1148,     0,     0,     0,     0,  1148,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4396,  2068,     0,
       0,  2069,     0,     0,     0,     0,  2084,  2085,  2086,     0,
    2087,  2088,  2089,  2090,  2091,  2092,     0,     0,  2070,     0,
    4247,     0,     0,     0,     0,     0,  2072,     0,     0,     0,
       0,  2073,     0,     0,     0,     0,     0,  4425,     0,     0,
       0,     0,     0,     0,     0,     0,   676,     0,     0,     0,
       0,     0,  1148,  1148,  1148,  1148,     0,     0,     0,     0,
       0,   676,     0,     0,     0,     0,     0,     0,     0,  2410,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2519,     0,  1142,     0,     0,     0,
       0,     0,     0,   694,     0,  1142,     0,     0,     0,  3060,
       0,     0,  4295,  1173,     0,     0,     0,     0,  1047, -1918,
    2068,     0,     0,  2069,     0,     0,     0,  1047,     0,   676,
       0,     0,     0,  1148,  1148,     0,  3554,     0,     0,     0,
    2070,     0,     0,     0,     0,  4311,     0,  1047,  2072,     0,
    1330,     0,     0,  2073,     0,     0,     0,     0,     0,     0,
       0,     0,  1988,     0,     0,     0,  2074,     0, -1918,     0,
    2075,     0,     0,     0,     0,     0,     0,     0,     0, -1918,
       0,     0,  1961, -1918,     0,     0,     0,     0, -1918,     0,
    1142,  2076,  2077, -1918,  1047,  1047, -1918,     0, -1918,     0,
       0,     0,  2600,     0,     0,  2078,  1047,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   978,   978,     0, -1918,  2625,     0,  1488,  1488,
       0,     0,     0,     0,     0,     0,  1488,  2079,     0,  1488,
    2080,     0,  1488,     0, -1918,     0,     0,     0,     0,     0,
    1488,  1488,     0,  2081,     0,     0,  2082,     0,  1488,     0,
    1173,  1488,  1488,  1488,  1488,     0,     0,     0,     0,     0,
       0,  1488,  1488,     0,  1488,     0,  1488,     0,  2074,  1488,
       0,     0,  2075,     0,     0,     0,     0, -1918,     0,     0,
       0,     0,     0,     0,  1488, -1918,     0,     0,  1488,     0,
       0,     0,  1488,  2076,  2077,     0,  1488,     0,  1488,  1488,
    1488,  1488,  1488,  1488,  1488,  1488,  1488,  2078,  1488,     0,
       0,     0,     0,  1047,  1488,     0,  2083,  1488,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1918,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1047,  2079,
       0,     0,  2080,     0,  1988,  4452,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2081,     0,     0,  2082,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2068,   983,     0,  2069,  2168,     0,     0,     0,
       0,     0,     0,  1047,     0,  1047,     0,  1488,  3300,  1988,
       0,     0,  2070,  1988,  1988,     0, -1918,     0,     0,     0,
    2072,     0,  2084,  2085,  2086,  2073,  2087,  2088,  2089,  2090,
    2091,  2092,     0,     0,     0,     0,  4398, -1918,     0, -1918,
   -1918,     0,     0,     0,     0,     0,     0,     0,  2083,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1506,     0,   676,     0,  2068,
       0, -1918,  2069,     0, -1918, -1918,     0, -1918,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2070,
       0,     0,     0,  2796,   676,     0,     0,  2072,   676,   694,
       0,     0,  2073,     0,   978,     0,   978,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     676,  1488,     0,     0,     0,     0,     0,     0,   676,     0,
       0,     0,     0,     0,  2084,  2085,  2086,     0,  2087,  2088,
    2089,  2090,  2091,  2092,     0,     0,     0,     0,  4475,     0,
    2074,   676,     0,  2323,  2075,     0,     0,     0,     0,  2894,
       0,     0,     0,     0,  2903,     0,     0,     0,     0,     0,
    1047,   676,     0,  2797,     0,  2076,  2077,     0,     0,     0,
       0,  2925,  2925,     0,     0,     0,     0,   694,   676,  2078,
       0,   676,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1148,     0,     0,     0,     0,     0,     0,     0,   676,
       0,     0,     0,     0,     0,     0,   676,     0,     0,     0,
       0,  2079,     0,     0,  2080,   676,     0,  2074,     0,     0,
       0,  2075,   676,     0,     0,     0,     0,  2081,     0,     0,
    2082,     0,     0,     0,     0,     0,     0,     0,  1148,     0,
       0,     0,  2076,  2077,     0,  1148,  1148,  1148,  1148,  1148,
    1148,     0,     0,     0,     0,     0,  2078,     0,     0,     0,
    1488,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2925,     0,
       0,     0,  1047,     0,     0,     0,   978,     0,  2079,     0,
       0,  2080,     0,     0,     0,     0,     0,     0,     0,     0,
    2083,     0,     0,     0,  2081,     0,     0,  2082,     0,     0,
    3076,     0,     0,     0,     0,     0,  1148,  3090,     0,     0,
       0,     0,  3547,     0,     0,     0,  1269,  1861,     0,     0,
       0,     0,  3560,     0,  2519,  3120,     0,     0,     0,  3120,
    3133,     0,     0,     0,  1488,     0,     0,  3572,     0,     0,
       0,     0,     0,     0,     0,     0,  1148,  2925,  1148,  2925,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1269,     0,     0,     0,  2083,     0,     0,
       0,  1488,     0,     0,     0,     0,  2084,  2085,  2086,     0,
    2087,  2088,  2089,  2090,  2091,  2092,     0,     0,  3746,     0,
    3622,     0,  1961,  3623,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   676,     0,
       0,     0,     0,     0,     0,  1488,  2798,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1506,     0,   676,     0,     0,     0,
       0,     0,     0,     0,     0,  1488,  1488,     0,     0,     0,
       0,     0,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,
    2090,  2091,  2092,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1488,  1488,     0,     0,     0,
    1488,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1488,  1488,  1488,  1488,     0,     0,     0,     0,
       0,     0,     0,     0,  1488,     0,     0,  1488,     0,  1488,
    3268,     0,     0,     0,     0,     0,     0,     0,     0,  1488,
    1488,     0,  1488,     0,   853,     0,     0,     0,     0,     0,
       0,   802,     0,     0,     0,  1488,   854,  1488,     0,  1173,
       0,  1488,  3722,  3723,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   855,  1488,     0,     0,
       0,  1047,     0,     0,     0,     0,     0,  2519,     0,  1488,
    1488,  1488,     0,     0,     0,     0,   802,   856,     0,     0,
       0,  -630,     0,     0,     0,     0,     0,  1269,     0,     0,
       0,  1488,     0,     0,     0,     0,     0,     0,  2168,     0,
    1488,   857,     0,     0,     0,     0,     0,   858,     0,  1488,
       0,     0,     0,     0,  1488,     0,     0,     0,  1047,     0,
       0,  1488,   859,  1010,     0,     0,     0,     0,     0,     0,
    1010,     0,  1010,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     4,   802,     0,     0,     0,     0,     0,
     860,     0,   676,     0,     0,     0,     0,   861,     0,     0,
       0,   862,     0,     5,     0,     0,     0,     0,     0,  1488,
       0,  2925,     0,     6,     7,  1961,  -790,     0,     0,     8,
       0,     9,    10,     0,     0,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
       0,    36,   863,    37,    38,    39,    40,    41,    42,    43,
      44,     0,     0,     0,    45,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   676,   816,     0,
       0,     0,     0,     0,   676,     0,     0,     0,     0,     0,
    3875,     0,     0,     0,     0,     0,   864,     0,     0,   865,
       0,     0,     0,     0,     0,     0,     0,     0,  3900,     0,
       0,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3907,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   817,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   676,   866,     0,     0,
       0,     0,     0,   867,     0,   818,  2925,  2925,     0,  -365,
       0,   819,   868,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   820,     0,     0,     0,
       0,     0,     0,    47,     0,  3505,     0,     0,  -365,     0,
     869,   870,     0,   871,   872,     0,     0,     0,    48,     0,
       0,     0,   873,     0,   821,     0,     0,   874,     0,   822,
       0,     0,   875,     0,     0,   823,     0,   876,    49,     0,
       0,     0,     0,     0,  1961,  1047,     0,     0,     0,  -365,
     824,     0,     0,     0,     0,  1047,     0,     0,     0,     0,
      50,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1047,     0,     0,     0,   825,     0,  1269,     0,     0,     0,
       0,     0,     0,     0,     0,   694,     0,     0,     0,  3120,
       0,     0,  3596,    51,     0,  2519,    52,     0,     0,  2519,
       0,     0,     0,     0,     0,  3609,     0,     0,  1488,     0,
       0,     0,     0,     0,     0,     0,     0,    53,     0,  4013,
    4014,  4015,  4016,  1047,     0,     0,  1047,     0,     0,   676,
     826,     0,     0,  3627,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1142,     0,     0,   676,     0,     0,
       0,     0,     0,     0,  2600,     0,     0,   827,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1047,     0,   676,
       0,     0,     0,     0,     0,     0,     0,  1488,     0,     0,
       0,   828,     0,     0,     0,     0,  1488,   829,    54,     0,
       0,     0,  1488,   830,  1488,     0,   831,     0,     0,     0,
    1488,     0,     0,  1488,  1488,  1488,  1488,  1488,  1488,  1488,
    1488,  1488,  1488,     0,     0,     0,  1488,  1488,     0,     0,
       0,     0,   832,     0,   833,     0,     0,     0,   834,  1488,
      55,     0,     0,     0,     0,  1488,   835,     0,     0,     0,
       0,   836,     0,    56,     0,  1488,  2068,     0,  1488,  2069,
    1488,   837,     0,     0,     0,     0,    57,     0,     0,  1488,
    1488,  1488,     0,   838,     0,  1488,  2070,     0,  1488,     0,
       0,     0,     0,     0,  2072,  1047,  1047,     0,  1488,  2073,
       0,    58,     0,     0,  3735,     0,     0,    59,  1488,     0,
       0,    60,    61,    62,    63,    64,     0,     0,    65,    66,
      67,    68,     0,    69,    70,    71,    72,    73,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2168,     0,     0,
       0,     0,     0,  2068,     0,     0,  2069,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2070,  4155,     0,     0,     0,     0,     0,
       0,  2072,     0,     0,     0,     0,  2073,     0,  3773,  1961,
    1961,     0,     0,     0,   676,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   802,  3791,     0,     0,     0,     0,     0,     0,
    1144,     0,     0,     0,     0,     0,  1144,     0,     0,     0,
       0,     0,     0,     0,  2074,     0,     0,     0,  2075,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   676,     0,   676,     0,     0,  1144,     0,  2076,
    2077,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2078,     0,     0,     0,     0,  1476,     0,
    1269,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3242,     0,     0,     0,     0,  3243,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2079,     0,  3505,  2080,  1144,
       0,  2074,     0,  1047,  1549,  2075,  1144,     0,     0,     0,
       0,  2081,     0,     0,  2082,  1488,     0,     0,     0,     0,
       0,  1047,     0,     0,     0,     0,  2076,  2077,     0,     0,
       0,  4245,  3689,     0,     0,     0,     0,     0,  1047,     0,
    2078,     0,     0,     0,     0,     0,     0,  3076,     0,     0,
       0,     0,  3922,     0,     0,     0,  2323,     0,  3627,     0,
    1506,     0,     0,     0,     0,     0,     0,     0,     0,  1488,
    1488,     0,  2079,     0,     0,  2080,     0,     0,     0,     0,
       0,     0,     0,     0,  2083,     0,     0,     0,  2081,  3120,
       0,  2082,     0,  2519,     0,     0,     0,  3690,  2519,     0,
       0,  2519,  3076,     0,  3960,     0,     0,     0,     0,     0,
       0,  2925,     0,  2925,     0,     0,  1144,     0,     0,     0,
       0,     0,  1010,     0,     0,     0,  1010,     0,     0,     0,
       0,   676,     0,     0,     0,     0,     0,     0,  4317,     0,
    2068,     0,     0,  2069,  1488,     0,     0,     0,     0,     0,
       0,     0,  1144,     0,     0,     0,     0,     0,     0,     0,
    2070,  2083,     0,     0,     0,     0,     0,     0,  2072,     0,
    2084,  2085,  2086,  2073,  2087,  2088,  2089,  2090,  2091,  2092,
    1488,     0,     0,     0,     0,     0,     0,  1488,  1488,     0,
       0,     0,     0,     0,     0,  1488,  1488,     0,     0,     0,
    1488,     0,     0,     0,     0,     0,  1488,  1488,     0,     0,
    1488,     0,  1047,  1047,  1047,  1047,     0,     0,     0,     0,
       0,  1488,     0,     0,     0,     0,     0,  4024,     0,     0,
       0,     0,     0,     0,  1488,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1173,     0,  2084,  2085,  2086,
       0,  2087,  2088,  2089,  2090,  2091,  2092,     0,     0,   978,
       0,     0,  1488,     0,     0,     0,  1148,  1148,     0,     0,
       0,     0,     0,     0,     0,     0,  4450,     0,     0,     0,
       0,  4057,     0,     0,     0,     0,     0,     0,     0,   676,
    1144,     0,     0,     0,     0,     0,     0,  1144,  2074,     0,
     676,     0,  2075,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1148,     0,     0,     0,     0,  1817,     0,
       0,     0,     0,  2076,  2077,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2078,     0,     0,
    1269,     0,     0,     0,     0,     0,     0,  1144,  1961,     0,
       0,  2010,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3505,  3505,  3505,  3505,  3505,     0,     0,  2079,
       0,     0,  2080,     0,     0,     0,     0,     0,     0,  2033,
       0,     0,     0,     0,     0,  2081,  1488,     0,  2082,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4451,  2068,  2057,  2058,  2069,  2060,
       0,     0,     0,  1144,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2070,  2098,     0,  3206,     0,
       0,     0,     0,  2072,     0,     0,     0,  1047,  2073,  4159,
       0,     0,     0,     0,     0,  1488,     0,     0,     0,  2519,
       0,     0,  3960,     0,     0,     0,     0,     0,  2083,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   676,     0,  1817,     0,     0,  1488,  2152,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1144,
    1488,  1488,     0,     0,  1488,     0,     0,     0,     0,  2182,
       0,  1488,  1488,  2192,  2195,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1144,     0,     0,
       0,     0,   676,     0,   676,     0,     0,     0,  3773,  1173,
    1148,     0,     0,     0,  2084,  2085,  2086,     0,  2087,  2088,
    2089,  2090,  2091,  2092,  1144,  1144,     0,  1144,  1142,  1173,
       0,     0,     0,  2074,     0,     0,     0,  2075,     0,     0,
       0,     0,     0,     0,  1144,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1961,     0,     0,     0,  2076,  2077,
       0,     0,     0,     0,     0,  1142,     0,     0,     0,     0,
       0,     0,  2078,     0,  1047,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2925,     0,  2323,     0,
       0,     0,     0,     0,     0,  1144,   802,     0,  3922,     0,
       0,     0,     0,  1047,  2079,     0,     0,  2080,     0,     0,
       0,     0,  1148,  3773,     0,     0,     0,     0,     0,     0,
    2081,     0,     0,  2082,     0,     0,     0,  1144,     0,     0,
       0,  1144,  1144,     0,     0,     0,     0,     0,     0,     0,
       0,  1488,     0,     0,  1488,     0,  1488,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4305,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1148,     0,     0,     0,     0,     0,     0,
       0,  1047,     0,     0,  1488,     0,     0,     0,     0,     0,
       0,     0,     0,  2083,  1148,  1148,  1148,  1148,     0,     0,
       0,     0,     0,  1269,     0,  1817,     0,     0,     0,     0,
     802,     0,     0,     0,  1010,     0,     0,  2068,     0,     0,
    2069,     0,     0,     0,  1488,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1010,     0,  2070,     0,     0,
       0,     0,  1817,     0,     0,  2072,     0,     0,     0,     0,
    2073,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1817,     0,     0,     0,     0,
    1488,     0,     0,     0,     0,     0,     0,     0,  1173,  2084,
    2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1920,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1010,  1148,     0,     0,  1142,     0,     0,     0,     0,     0,
       0,  3773,     0,     0,     0,     0,     0,  1817,  4159,     0,
       0,     0,     0,     0,  4305,     0,     0,  1488,  1488,     0,
     676,     0,     0,     0,  1817,     0,     0,  1142, -1920,     0,
       0,  1148,     0,     0,     0,     0,     0,     0,     0, -1920,
       0,     0,  1817, -1920,     0,     0,     0,     0, -1920,     0,
       0,     0,     0, -1920,  1488,  2074, -1920,     0, -1920,  2075,
       0,     0,     0,     0,  1488,     0,     0,  1817,     0,     0,
       0,     0,   802,     0,     0,  1816,     0,     0,  4464,     0,
    2076,  2077,     0,     0,     0, -1920,     0,     0,     0,     0,
       0,     0,     0,     0,  2078,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1920,     0,     0,     0,  2635,     0,
       0,     0,     0,     0,  1144,     0,  1144,     0,  1488,     0,
       0,     0,  1817,  4464,     0,  1144,  2079,  1142,     0,  2080,
    2657,  4464,     0,  2659,     0,     0,  2670,     0,     0,     0,
       0,     0,  2081,  2677,  2682,  2082,     0, -1920,  2687,     0,
       0,  2692,     0,     0,     0, -1920,     0,     0,  3220,     0,
       0,     0,     0,     0,     0,     0,  2701,     0,     0,     0,
    2707,     0,     0,     0,  2719,     0,     0,     0,  2726,     0,
    2728,  2729,  2730,  2731,  2732,  2733,  2734,  2735,  2736,     0,
    2737,  2068,     0,     0,  2069,     0,  1476,     0, -1920,  2760,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1144,  2070,     0,     0,  3250,  2083,     0,     0,     0,  2072,
       0,     0,     0,     0,  2073,     0,     0,     0,     0,     0,
    1816,     0,     0,     0,     0,  2068,     0,     0,  2069,     0,
       0,     0,     0,   983,     0,     0,     0,     0,  1144,  1144,
       0,     0,     0,     0,     0,  2070,  1144,     0,     0,  1144,
       0,     0,  1144,  2072,     0,     0, -1920,     0,  2073,  1549,
    1144,  1144,     0,     0,     0,     0,     0,     0,  1144,     0,
       0,  1144,  1144,  1144,  1144,     0,     0, -1920,     0, -1920,
   -1920,  1144,  1144,     0,  1144,     0,  1144,     0,     0,  1144,
       0,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,
    2092,     0,     0,  1817,  1144,   802,     0,     0,  1144,     0,
       0, -1920,  1144,     0, -1920, -1920,  1144, -1920,  1144,  1144,
    1144,  1144,  1144,  1144,  1144,  1144,  1144,     0,  1144,     0,
    2068,     0,     0,  2069,  1144,     0,     0,  1144,     0,  2074,
       0,     0,     0,  2075,     0,     0,     0,     0,     0,     0,
    2070,     0,     0,  3259,     0,     0,     0,     0,  2072,     0,
       0,     0,     0,  2073,  2076,  2077,     0,  3255,     0,     0,
       0,     0,     0,  2865,     0,     0,     0,     0,  2078,     0,
       0,     0,     0,  2074,     0,     0,     0,  2075,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1144,  2076,  2077,
    2079,     0,  2068,  2080,     0,  2069,     0,     0,     0,     0,
       0,     0,  2078,     0,     0,     0,  2081,     0,     0,  2082,
       0,     0,  2070,     0,     0,  3312,     0,     0,     0,     0,
    2072,     0,     0,     0,     0,  2073,     0,     0,     0,     0,
       0,     0,     0,     0,  2079,     0,     0,  2080,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2081,     0,     0,  2082,     0,     0,     0,     0,     0,     0,
       0,     0,  1816,     0,     0,     0,     0,     0,  2074,     0,
       0,     0,  2075,     0,     0,     0,     0,   802,     0,  2083,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2076,  2077,     0,     0,     0,     0,  2316,
       0,  1144,  3026,     0,     0,     0,     0,  2078,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1817,  1816,  2083,     0,     0,  1817,  1817,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1817,     0,  2079,
       0,     0,  2080,     0,     0,     0,     0,     0,     0,     0,
    2074,     0,     0,   802,  2075,  2081,     0,     0,  2082,     0,
       0,     0,     0,     0,     0,  2084,  2085,  2086,     0,  2087,
    2088,  2089,  2090,  2091,  2092,  2076,  2077,     0,     0,     0,
       0,     0,     0,     0,  1816,     0,  3137,     0,   802,  2078,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1816,     0,     0,     0,     0,     0,     0,     0,  2084,
    2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,  1816,
       0,  2079,     0,  3158,  2080,     0,     0,     0,  2083,     0,
       0,  1814,     0,  2068,     0,     0,  2069,  2081,     0,     0,
    2082,     0,     0,     0,  1816,     0,     0,     0,     0,     0,
    1144,     0,  1817,  2070,     0,     0,     0,     0,     0,     0,
       0,  2072,     0,     0,     0,     0,  2073,  1476,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3202,  1816,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2083,     0,     0,  1817,  2084,  2085,  2086,     0,  2087,  2088,
    2089,  2090,  2091,  2092,  1144,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1144,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2682,     0,  2682,  2682,     0,     0,
    2068,     0,     0,  2069,     0,     0,  3262,     0,     0,  3265,
       0,  3267,     0,     0,     0,     0,     0,     0,     0,     0,
    2070,  1144,     0,  3696,     0,     0,     0,     0,  2072,     0,
       0,     0,     0,  2073,     0,     0,  1814,  3288,     0,  3290,
       0,  2074,     0,  3293,     0,  2075,  2084,  2085,  2086,     0,
    2087,  2088,  2089,  2090,  2091,  2092,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1144,  2076,  2077,     0,     0,
       0,  2760,  2760,  2760,     0,     0,  1817,     0,     0,     0,
    2078,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3340,     0,  1144,  1144,     0,     0,     0,
       0,     0,  1549,     0,     0,     0,     0,     0,     0,     0,
       0,  2182,  2079,     0,     0,  2080,  3355,     0,     0,     0,
       0,     0,     0,  2195,     0,  1144,  1144,     0,  2081,     0,
    1144,  2082,     0,     0,     0,     0,     0,     0,     0,  1008,
    1816,     0,  1144,  1144,  1144,  1144,  1008,     0,  1008,     0,
     802,     0,     0,     0,  1144,   802,     0,  1144,  2074,  1144,
       0,     0,  2075,     0,     0,     0,     0,     0,     0,  1144,
    1144,  3381,  1144,     0,  2133,     0,     0,     0,     0,     0,
       0,     0,     0,  2076,  2077,  1144,     0,  1144,     0,     0,
       0,  1144,     0,     0,     0,     0,     0,  2078,     0,     0,
       0,  2083,     0,     0,     0,     0,     0,  1144,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1144,     0,  1144,
    1144,  1144,     0,     0,     0,     0,     0,  3650,     0,  2079,
       0,     0,  2080,     0,  2068,     0,     0,  2069,     0,     0,
       0,  1144,     0,     0,     0,  2081,     0,     0,  2082,     0,
    1144,     0,     0,     0,  2070,     0,     0,     0,     0,  1144,
       0,     0,  2072,     0,  1144,     0,     0,  2073,     0,     0,
       0,  1144,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2084,  2085,  2086,
       0,  2087,  2088,  2089,  2090,  2091,  2092,     0,  1814,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2083,  1144,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1814,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1817,  1817,     0,
    1817,     0,     0,     0,     0,     0,     0,     0,  1814,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2881,     0,
       0,     0,     0,  2316,  2888,     0,     0,     0,     0,     0,
       0,  1817,  2074,  1817,  1816,     0,  2075,     0,     0,     0,
       0,     0,     0,     0,  2084,  2085,  2086,     0,  2087,  2088,
    2089,  2090,  2091,  2092,     0,     0,     0,  2076,  2077,     0,
    1814,     0,     0,     0,   802,   802,   802,     0,     0,     0,
       0,  2078,     0,     0,     0,     0,     0,  1814,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2760,     0,     0,     0,     0,  1814,     0,     0,     0,     0,
       0,     0,  1817,  2079,     0,     0,  2080,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2081,
    1814,     0,  2082,     0,   802,     0,     0,     0,     0,  1817,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1816,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3651,
       0,     0,   802,  1817,     0,   905,     0,     0,  3654,     0,
       0,     0,     0,     0,  3655,  1814,  3656,   906,     0,     0,
    1817,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2083,     0,  1817,     0,     0,   907,  3674,  3675,
       0,     0,     0,     0,     0,     0,     0,  1817,     0,     0,
    2316,     0,     0,     0,     0,     0,     0,  2687,     0,     0,
       0,     0,   908,     0,     0,  1144,     0,  3700,     0,  1144,
    3703,     0,  3705,     0,     0,     0,     0,     0,  1144,     0,
       0,  3709,   909,     0,  1817,     0,     0,  3714,     0,     0,
    3717,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3724,     0,     0,   910,     0,     0,     0,     0,     0,     0,
    2760,     0,     0,     0,  1144,     0,     0,     0,  2084,  2085,
    2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,     0,
       0,   911,     0,     0,     0,     0,   912,     0,     0,     0,
       0,     0,   913,     0,     0,     0,     0,  1144,     0,     0,
    1817,     0,     0,     0,     0,     0,  1144,   914,     0,     0,
       0,     0,  1144,  1816,  1144,     0,     0,     0,  1196,  1817,
    1144,     0,     0,  1144,  1144,  1144,  1144,  1144,  1144,  1144,
    1144,  1144,  1144,     0,     0,     0,  1144,  1144,     0,     0,
       0,     0,     0,     0,  1817,     0,     0,     0,     0,  1144,
    1197,     0,     0,   802,     0,  1144,  1814,     0,     0,     0,
       0,     0,     0,  1198,     0,  1144,     0,     0,  1144,     0,
    1144,  1199,     0,     0,     0,  1200,  1140,     0,  1817,  1144,
    1144,  1144,  1140,     0,     0,  1144,     0,   915,  1144,     0,
       0,     0,     0,     0,     0,  1201,     0,   916,  1144,     0,
       0,     0,     0,     0,     0,     0,  1817,     0,  1144,     0,
       0,     0,     0,  1140,   827,     0,  1202,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   917,     0,
       0,     0,   918,     0,   919,     0,     0,     0,     0,  1203,
     920,     0,     0,   921,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1140,     0,     0,     0,     0,
    1204,     0,  1140,     0,     0,     0,     0,     0,  1144,   922,
       0,   923,     0,     0,     0,   924,     0,     0,     0,     0,
       0,     0,     0,   925,  1205,     0,     0,     0,   926,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   927,     0,
     802,  1817,   802,     0,     0,     0,     0,     0,     0,     0,
     928,  3937,  3938,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   802,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1206,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   827,     0,     0,
       0,     0,  1140,     0,  2316,  2888,     0,  2888,  1008,     0,
       0,     0,  1008,     0,  1814,     0,  3978,     0,     0,  1814,
    1814,  1207,     0,     0,     0,  1208,     0,  1209,     0,     0,
    1814,     0,     0,  1210,     0,  1144,     0,     0,  1140,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1816,     0,
    1816,     0,     0,  1817,     0,     0,     0,     0,     0,  3994,
    3996,     0,  1211,     0,  1212,     0,     0,     0,  1213,     0,
       0,     0,  4003,     0,     0,     0,  1214,     0,  4008,  4009,
       0,  1215,  4011,     0,     0,     0,     0,     0,  1817,  1144,
    1144,     0,     0,  2760,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1216,     0,     0,  2760,     0,     0,     0,
       0,     0,     0,  1144,     0,     0,     0,     0,  1144,  1816,
       0,  1144,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4042,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1814,  2888,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1144,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1140,     0,     0,     0,
    2888,     0,     0,  1140,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1816,     0,     0,
    1144,     0,     0,     0,  1815,     0,  1814,  1144,  1144,     0,
    1817,  1816,     0,     0,     0,  1144,  1144,     0,     0,     0,
    1144,  1817,     0,     0,  2888,     0,  1144,  1144,     0,     0,
    1144,     0,     0,  1140,     0,     0,     0,     0,     0,     0,
       0,  1144,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1144,     0,     0,     0,  4113,     0,
       0,  1816,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1144,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1140,
       0,     0,     0,  1817,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1817,     0,     0,     0,  4162,     0,  1814,
       0,     0,     0,     0,     0,     0,     0,  1816,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1816,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   802,  1815,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1816,     0,     0,     0,     0,  4192,     0,     0,     0,
       0,     0,     0,     0,  4194,  1140,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1816,  1144,     0,     0,     0,
       0,     0,     0,  1140,     0,     0,   802,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3737,     0,     0,     0,     0,     0,     0,
    1140,  1140,     0,  1140,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1817,     0,     0,     0,     0,     0,
    1140,     0,     0,     0,     0,  1144,     0,     0,     0,  1144,
       0,     0,     0,     0,  1817,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1144,     0,     0,     0,
    1817,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1140,     0,     0,     0,     0,     0,     0,     0,     0,
    1144,  1144,     0,     0,  1144,     0,     0,     0,     0,     0,
       0,  1144,  1144,     0,     0,     0,     0,     0,  2888,     0,
       0,     0,     0,  1140,     0,     0,  2687,  1140,  1140,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1144,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1817,     0,     0,  1144,     0,
       0,     0,     0,     0,     0,     0,  4320,     0,     0,     0,
    1814,  1814,     0,  1814,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1144,     0,     0,     0,     0,
       0,  1815,     0,     0,     0,     0,  4349,     0,     0,     0,
    1008,     0,     0,     0,  1814,     0,  1814,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1008,     0,     0,     0,     0,     0,     0,  1815,     0,
    1816,     0,     0,  1144,     0,  1817,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1815,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1144,  1817,     0,  1144,  2316,  1144,     0,     0,     0,
       0,     0,     0,     0,     0,  1814,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1008,     0,     0,     0,
       0,     0,  1814,     0,  1144,     0,     0,  1817,     0,  4413,
    4413,  1817,  1817,  1815,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1815,     0,     0,     0,     0,     0,  1814,   802,     0,     0,
       0,     0,     0,     0,  1144,     0,  4413,     0,  1815,     0,
       0,     0,     0,  1814,     0,     0,  4453,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1814,     0,     0,
    1817,     0,     0,  1815,     0,     0,     0,     0,     0,     0,
    1814,     0,     0,     0,     0,     0,     0,  1816,     0,     0,
    1144,     0,     0,     0,     0,     0,     0,     0,  1816,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4413,     0,     0,     0,     0,     0,     0,  1814,     0,     0,
    1140,     0,  1140,     0,     0,     0,     0,     0,  1815,     0,
       0,  1140,     0,     0,  1144,     0,     0,     0,     0,     0,
       0,  1144,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1144,  1144,     0,
       0,     0,     0,     0,     0,     0,     0,  1144,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1816,     0,     0,  1814,     0,     0,     0,     0,     0,     0,
    1816,     0,     0,     0,  1144,     0,     0,     0,     0,     0,
       0,     0,  1814,     0,  1144,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1140,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1814,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1140,  1140,     0,     0,  1144,     0,
       0,  1814,  1140,     0,     0,  1140,     0,  1144,  1140,     0,
       0,     0,     0,     0,     0,     0,  1140,  1140,     0,     0,
       0,     0,     0,     0,  1140,     0,     0,  1140,  1140,  1140,
    1140,     0,     0,     0,     0,     0,     0,  1140,  1140,     0,
    1140,     0,  1140,     0,     0,  1140,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1815,
    1140,     0,     0,     0,  1140,     0,     0,     0,  1140,     0,
       0,  3737,  1140,     0,  1140,  1140,  1140,  1140,  1140,  1140,
    1140,  1140,  1140,     0,  1140,     0,     0,     0,     0,     0,
    1140,  1816,     0,  1140,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1816,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1814,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1140,     0,     0,     0,     0,     0,     0,
       4,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     0,  2888,     0,     0,     0,     0,     0,     0,     0,
       6,     7,     0,     0,     0,     0,     0,     0,     9,    10,
       0,     0,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,     0,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,     0,     0,     0,  1814,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   698,     0,  1140,     0,     0,
       0,     0,  2888,     0,     0,   698,     0,     0,     0,     0,
       0,  1814,     0,     0,     0,     0,     0,  1815,    46,     0,
       0,     0,  1815,  1815,     0,     0,     0,     0,     0,  1816,
       0,     0,     0,  1815,     0,     0,     0,     0,     0,     0,
       0,   698,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   891,     0,     0,   698,     0,     0,     0,     0,
       0,     0,   891,     0,     0,     0,   698,     0,     0,     0,
       0,     0,     0,     0,  1816,     0,     0,     0,  1816,  1816,
       0,     0,     0,     0,     0,     0,     0,   698,     0,     0,
      47,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   891,     0,    48,     0,     0,     0,     0,
    1806,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    49,     0,     0,     0,     0,
       0,     0,     0,  1814,     0,     0,  1063,  3737,     0,     0,
       0,     0,     0,     0,  1814,     0,  1140,    50,  1815,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      51,     0,     0,    52,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    53,     0,     0,     0,     0,  1815,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,     0,     0,     0,     0,  1814,     0,     0,     0,
    1140,     0,     0,     0,     0,     0,  1814,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1806,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,    54,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1108,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1140,     0,     0,     0,     0,     0,    55,     0,     0,
       0,     0,  1815,     0,     0,     0,     0,     0,     0,     0,
      56,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1140,  1140,    57,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    58,     0,
       0,  1140,  1140,     0,    59,     0,  1140,     0,    60,    61,
      62,    63,    64,     0,     0,    65,    66,  1308,  1140,  1140,
    1140,  1140,    71,  1309,     0,     0,     0,  1814,     0,     0,
    1140,     0,     0,  1140,     0,  1140,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1140,  1140,     0,  1140,     0,
       0,     0,     0,  1814,     0,     0,     0,     0,     0,     0,
       0,  1140,     0,  1140,     0,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1140,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1140,     0,  1140,  1140,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,  1140,     0,  1814,     0,
       0,     0,     0,     0,     0,  1140,     0,     0,     0,     0,
    1140,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1806,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1806,  1140,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   891,   891,     0,  1806,  1814,     0,
       0,     0,     0,  1815,  1815,     0,  1815,     0,     0,     0,
       0,  1108,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1814,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1815,     0,  1815,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1806,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1814,     0,     0,     0,  1814,  1814,  1806,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1806,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1815,  1806,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1175,     0,
    1177,     0,  1179,     0,  1181,  1815,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1223,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1806,     0,     0,  1241,  1242,  1815,
       0,     0,  1244,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1815,  1108,     0,   891,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1815,     0,     0,     0,     0,  1274,     0,     0,     0,     0,
       0,     0,     0,  1815,     0,     0,     0,  1293,     0,     0,
    1295,     0,  1297,     0,  1300,     0,     0,     0,     0,     0,
       0,  1140,     0,     0,     0,  1140,     0,   698,   891,     0,
       0,     0,     0,     0,  1140,     0,     0,     0,     0,     0,
    1815,     0,   698,     0,   698,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   698,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,     0,     0,   698,   698,     0,     0,     0,     0,
       0,  1382,     0,  1383,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1140,     0,     0,  1815,     0,     0,     0,
       0,     0,  1140,  1108,     0,     0,     0,     0,  1140,     0,
    1140,     0,     0,     0,     0,  1815,  1140,     0,     0,  1140,
    1140,  1140,  1140,  1140,  1140,  1140,  1140,  1140,  1140,     0,
       0,     0,  1140,  1140,     0,  1806,     0,     0,     0,  1063,
    1815,     0,     0,     0,     0,  1140,     0,     0,     0,     0,
       0,  1140,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1140,     0,     0,  1140,     0,  1140,     0,     0,     0,
       0,     0,     0,     0,  1815,  1140,  1140,  1140,     0,     0,
       0,  1140,     0,     0,  1140,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1140,     0,     0,     0,     0,     0,
       0,     0,  1815,     0,  1140,     0,  1634,     0,  1636,     0,
       0,     0,  1638,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1752,     0,     0,     0,     0,
       0,     0,     0,     0,  1140,     0,     0,     0,  1764,     0,
       0,     0,     0,     0,     0,     0,     0,  1770,     0,     0,
       0,     0,     0,  1772,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1820,     0,     0,  1815,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1857,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1806,     0,     0,     0,     0,  1806,  1806,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1806,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1140,     0,   698,     0,   698,     0,     0,   698,     0,
     698,     0,     0,   698,   698,   698,     0,     0,     0,  1815,
       0,     0,     0,     0,     0,     0,   698,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     698,     0,   698,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1815,  1140,  1140,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1140,
       0,     0,     0,     0,  1140,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,  1806,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,     0,     0,     0,     0,     0,  1808,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1806,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1140,     0,     0,     0,
       0,     0,     0,  1140,  1140,     0,  1815,     0,     0,     0,
       0,  1140,  1140,     0,     0,     0,  1140,  1815,     0,     0,
       0,     0,  1140,  1140,     0,     0,  1140,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,  1063,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1140,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1806,  1815,
       0,     0,     0,     0,     0,  2236,     0,     0,  2236,  1815,
       0,     0,     0,     0,     0,     0,  2243,     0,     0,     0,
       0,     0,  1808,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2252,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2290,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1145,     0,     0,     0,     0,     0,  1145,     0,     0,
       0,     0,  1140,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1815,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1140,     0,     0,     0,  1140,     0,     0,     0,     0,
    1815,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,  1145,     0,     0,
       0,     0,  1140,     0,     0,     0,  1815,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1140,  1140,     0,     0,
    1140,     0,     0,  2451,     0,     0,     0,  1140,  1140,     0,
       0,     0,     0,     0,     0,  2473,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1140,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1806,
    1806,  1815,  1806,     0,  1140,     0,     0,     0,     0,  2527,
       0,     0,     0,  2531,  1808,     0,     0,     0,     0,     0,
       0,     0,  2540,     0,  2542,     0,  2543,  1145,     0,     0,
       0,  2544,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1140,     0,  1806,     0,  1806,     0,     0,     0,     0,
       0,  1808,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1145,     0,   698,     0,   698,     0,     0,
       0,   698,     0,   698,  1808,     0,   698,     0,     0,     0,
     698,  2572,     0,     0,     0,     0,     0,     0,     0,  1140,
       0,  1815,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1809,     0,     0,     0,  1806,     0,     0,  1140,  1815,     0,
    1140,     0,  1140,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1808,     0,     0,     0,
       0,  1806,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1808,     0,     0,     0,     0,     0,     0,
    1140,     0,     0,  1815,     0,     0,     0,  1815,  1815,     0,
       0,  1808,     0,     0,     0,  1806,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1806,     0,     0,     0,  1808,     0,     0,     0,
    1140,  1145,     0,     0,     0,     0,  1806,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1806,
       0,     0,     0,     0,     0,     0,  1815,     0,     0,  1818,
       0,     0,     0,     0,     0,  2763,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1140,     0,     0,     0,
       0,  1808,     0,     0,     0,     0,  1806,     0,  1145,     0,
       0,     0,     0,     0,     0,  1809,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1140,  1140,     0,     0,     0,     0,     0,
       0,     0,  1806,  1140,  1145,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1806,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,     0,     0,     0,     0,  1806,     0,     0,     0,
       0,     0,     0,  1108,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1818,     0,     0,     0,     0,     0,
    2842,     0,     0,     0,     0,  2846,     0,     0,     0,     0,
    1806,     0,     0,     0,     0,  2856,     0,     0,     0,     0,
    1145,     0,  2862,     0,  1140,     0,     0,     0,  2867,     0,
       0,     0,     0,  1140,  2877,     0,     0,     0,     0,  2879,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,     0,
       0,     0,  1808,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2895,  2896,  2899,  2901,     0,
       0,     0,  2908,  2911,     0,  1145,  1145,  2914,  1145,     0,
    2918,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1145,     0,  2953,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2956,     0,  2958,
       0,     0,     0,     0,     0,     0,     0,     0,  2969,  2970,
    2971,     0,  2973,     0,     0,     0,     0,     0,     0,     0,
       0,  2986,  2987,     0,     0,     0,     0,  1809,     0,  2990,
    2991,     0,     0,  1806,     0,     0,  1145,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1809,     0,     0,     0,  1145,     0,
       0,     0,  1145,  1145,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1809,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1818,     0,     0,  1809,
       0,     0,     0,     0,     0,  1806,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1809,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1808,     0,     0,  1818,  1809,  1808,  1808,     0,     0,     0,
    1806,     0,     0,     0,     0,     0,  1808,     0,     0,     0,
       0,     0,  1108,     0,     0,     0,  1818,     0,     0,  1809,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3191,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1809,     0,     0,     0,  1818,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1818,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1818,     0,     0,     0,     0,     0,     0,
    1811,  1808,  1806,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1806,     0,     0,     0,     0,  1818,     0,
       0,  1812,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1808,     0,     0,  1145,     0,  1145,     0,     0,
       0,     0,     0,  1818,     0,     0,  1145,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1806,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1806,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1809,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1811,     0,     0,  3372,  3373,
       0,  1145,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1808,  1812,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3392,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1145,
    1145,     0,     0,     0,     0,     0,     0,  1145,     0,     0,
    1145,     0,     0,  1145,     0,     0,     0,     0,     0,     0,
       0,  1145,  1145,  3411,  3412,  3413,  3414,     0,     0,  1145,
       0,     0,  1145,  1145,  1145,  1145,     0,     0,     0,     0,
       0,     0,  1145,  1145,     0,  1145,     0,  1145,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1818,  1145,  1806,     0,     0,  1145,
       0,     0,     0,  1145,     0,     0,     0,  1145,     0,  1145,
    1145,  1145,  1145,  1145,  1145,  1145,  1145,  1145,     0,  1145,
       0,     0,  1806,     0,     0,  1145,     0,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,  3455,     0,     0,
       0,     0,  3457,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1806,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1809,     0,     0,     0,     0,  1809,  1809,
       0,     0,     0,     0,     0,     0,  3555,   891,     0,  1809,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1813,     0,  1811,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   891,     0,     0,     0,     0,  1812,     0,
       0,     0,     0,     0,     0,     0,  1808,  1808,     0,  1808,
       0,     0,     0,     0,  1811,     0,     0,  1806,     0,     0,
    3615,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3624,     0,  1812,     0,  1811,     0,     0,
       0,     0,  1145,     0,  1806,     0,     0,     0,     0,     0,
    1808,     0,  1808,     0,     0,     0,     0,     0,  1812,     0,
       0,     0,  1818,     0,     0,     0,     0,  1818,  1818,     0,
       0,     0,     0,     0,  1809,     0,     0,     0,  1818,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1806,
       0,     0,     0,  1806,  1806,     0,     0,     0,     0,  1811,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1811,     0,     0,     0,
    1812,  1808,     0,     0,     0,     0,     0,     0,     0,     0,
    1813,     0,     0,     0,  1811,  1809,     0,  1812,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1808,     0,
       0,     0,     0,     0,     0,  1812,     0,     0,     0,  1811,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1812,     0,  1808,     0,     0,     0,     0,     0,     0,     0,
       0,  1145,     0,  1818,     0,     0,     0,     0,     0,  1808,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1808,  1811,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1808,     0,     0,     0,
       0,     0,     0,     0,     0,  1812,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1809,     0,
       0,     0,     0,     0,  1818,     0,     0,     0,     0,     0,
       0,     0,     0,  1808,     0,  1145,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1145,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3790,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3816,     0,     0,     0,     0,  3823,  1808,
    3825,  3826,  3827,  3828,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1808,     0,
       0,     0,     0,     0,     0,     0,  1145,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1818,     0,     0,
       0,     0,     0,  1808,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,  1145,     0,     0,
       0,     0,  1813,     0,     0,  3887,  3889,  3891,     0,  3893,
       0,     0,     0,     0,     0,  1811,     0,  1808,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,  1145,     0,     0,
       0,  1145,     0,     0,     0,     0,  1812,     0,     0,  1813,
       0,     0,     0,  1145,  1145,  1145,  1145,     0,     0,     0,
       0,     0,     0,     0,     0,  1145,     0,     0,  1145,     0,
    1145,     0,  1813,     0,     0,     0,     0,     0,     0,     0,
    1145,  1145,     0,  1145,     0,     0,     0,     0,     0,     0,
    3392,     0,     0,     0,     0,     0,  1145,     0,  1145,     0,
       0,     0,  1145,     0,     0,     0,     0,     0,     0,     0,
       0,  3962,     0,     0,     0,     0,     0,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,     0,
    1145,  1145,  1145,     0,  1813,     0,     0,     0,     0,  1809,
    1809,     0,  1809,     0,     0,     0,     0,     0,     0,     0,
       0,  1813,  1145,     0,     0,     0,     0,     0,     0,     0,
    1808,  1145,     0,     0,     0,     0,     0,     0,     0,  1813,
    1145,     0,     0,     0,     0,  1145,     0,     0,     0,     0,
       0,     0,  1145,  1809,     0,  1809,     0,     0,     0,     0,
       0,     0,     0,     0,  1813,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1813,
       0,     0,     0,     0,  1809,     0,     0,     0,  1818,  1818,
       0,  1818,     0,  1811,     0,     0,     0,     0,  1811,  1811,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1811,
       0,  1809,  1808,     0,  1812,     0,     0,     0,     0,  1812,
    1812,     0,     0,     0,     0,  4063,     0,     0,     0,     0,
    1812,     0,  1818,     0,  1818,     0,  4072,     0,     0,     0,
       0,     0,     0,     0,     0,  1809,     0,  1808,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1809,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1809,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1809,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1818,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1811,     0,  1809,     0,     0,     0,
    1818,     0,     0,     0,     0,     0,     0,  4125,     0,     0,
       0,     0,     0,     0,     0,  1812,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4144,
       0,     0,     0,     0,  1818,     0,     0,     0,     0,  1808,
    1813,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1808,  1818,     0,     0,     0,  1811,     0,     0,     0,     0,
       0,     0,  1809,     0,     0,  1818,     0,     0,  4172,     0,
       0,     0,     0,     0,     0,     0,  1812,     0,  1818,     0,
       0,  1809,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,     0,     0,     0,
    1145,     0,     0,     0,     0,     0,  1809,     0,     0,  1145,
       0,     0,     0,     0,     0,  1818,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1808,     0,     0,     0,     0,     0,     0,     0,
    1809,     0,  1808,     0,     0,  1145,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1811,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,     0,
       0,  1818,     0,     0,     0,     0,     0,  1145,     0,  1812,
       0,     0,     0,  1145,     0,  1145,     0,     0,     0,     0,
    1818,  1145,     0,     0,  1145,  1145,  1145,  1145,  1145,  1145,
    1145,  1145,  1145,  1145,     0,     0,     0,  1145,  1145,     0,
       0,     0,     0,  2094,     0,  1818,     0,     0,     0,     0,
    1145,     0,     0,     0,     0,     0,  1145,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,     0,     0,  1145,
       0,  1145,     0,     0,     0,  3392,     0,     0,     0,  1818,
    1145,  1145,  1145,     0,     0,     0,  1145,     0,     0,  1145,
       0,     0,     0,  1809,     0,     0,     0,     0,  1813,  1145,
       0,     0,     0,  1813,  1813,     0,     0,  1818,     0,  1145,
       0,     0,     0,     0,  1813,     0,  2094,     0,     0,     0,
       0,     0,     0,  1808,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1808,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1145,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1818,     0,     0,  1809,     0,     0,     0,     0,
       0,     0,     0,     0,  1808,     0,     0,     0,     0,  1813,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1809,     0,     0,     0,     0,     0,     0,     0,     0,  1811,
    1811,     0,  1811,     0,  4395,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1812,  1812,     0,  1812,     0,     0,     0,     0,     0,     0,
    1813,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1811,     0,  1811,     0,     0,     0,     0,
       0,     0,     0,     0,  1808,     0,  1145,     0,     0,     0,
       0,     0,     0,     0,  1812,     0,  1812,     0,     0,     0,
       0,     0,     0,     0,  1818,     0,     0,     0,     0,     0,
       0,  1808,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1818,
    1145,  1145,  1809,     0,  1811,     0,     0,     0,     0,     0,
       0,     0,     0,  1809,     0,     0,  1808,     0,     0,     0,
    1808,  1808,     0,     0,  1145,  1812,     0,     0,     0,  1145,
       0,  1811,  1145,  1813,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1812,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1811,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1145,     0,     0,     0,     0,
       0,     0,  1811,     0,     0,     0,  1812,     0,     0,     0,
       0,     0,     0,     0,     0,  1809,  1811,     0,     0,     0,
       0,     0,     0,  1812,     0,  1809,     0,     0,     0,  1811,
       0,  1145,     0,     0,     0,  2094,     0,  1812,  1145,  1145,
       0,  1818,     0,     0,     0,     0,  1145,  1145,     0,     0,
    1812,  1145,  1818,     0,     0,     0,     0,  1145,  1145,     0,
       0,  1145,     0,     0,     0,     0,  1811,     0,     0,     0,
       0,     0,  1145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1145,     0,  1812,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1145,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2094,     0,     0,
       0,     0,  1811,     0,  1818,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1818,     0,     0,     0,     0,     0,
    2094,  1811,     0,  1812,     0,  2666,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1812,     0,  2094,  2094,  1811,  2094,     0,     0,
       0,     0,     0,     0,     0,     0,  1809,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1812,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1811,     0,  1809,     0,     0,  2094,     0,     0,     0,     0,
       0,     0,     0,     0,  1813,  1813,     0,  1813,     0,     0,
       0,  1812,     0,     0,     0,     0,     0,  1145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1813,  2094,
    1813,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1818,     0,  1809,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,     0,     0,  2094,
    1145,     0,     0,     0,     0,  1818,     0,     0,     0,  2094,
       0,     0,  2094,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1145,     0,     0,
       0,  1818,     0,     0,     0,     0,     0,     0,     0,  1813,
       0,     0,     0,  1811,     0,     0,     0,     0,     0,     0,
       0,  1145,  1145,     0,     0,  1145,     0,     0,     0,     0,
       0,     0,  1145,  1145,  1812,     0,  1813,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1809,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1145,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1813,     0,     0,     0,  1809,     0,  1818,     0,     0,  1145,
       0,     0,     0,     0,     0,     0,     0,  1813,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1813,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1813,     0,  1145,     0,     0,  1809,
       0,     0,     0,  1809,  1809,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1811,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1813,     0,     0,     0,     0,  1812,     0,     0,     0,
       0,     0,     0,     0,  1145,     0,  1818,     0,     0,     0,
    1811,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1812,  1145,  1818,     0,  1145,     0,  1145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1813,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1145,  1813,     0,  1818,     0,
       0,     0,  1818,  1818,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1813,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1145,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1811,     0,     0,  1813,     0,     0,     0,     0,
       0,  1818,     0,  1811,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1812,     0,     0,     0,     0,     0,     0,
       0,  1145,     0,     0,  1812,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1145,     0,     0,     0,     0,
       0,     0,  1145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1811,     0,     0,  1145,  1145,
       0,     0,     0,     0,     0,  1811,     0,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,  1812,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1812,     0,     0,     0,
       0,     0,  2094,     0,     0,  1145,     0,     0,  1813,     0,
       0,     0,     0,     0,     0,  1145,     0,     0,     0,     0,
       0,     0,     0,     0,  2094,     0,  2094,     0,  2666,  2666,
    3238,     0,     0,  2666,     0,     0,     0,  2094,     0,     0,
       0,     0,     0,     0,  2094,     0,     0,     0,     0,  2094,
       0,     0,     0,     0,  2094,     0,     0,     0,     0,  2094,
       0,     0,     0,     0,     0,     0,     0,     0,  2094,  1145,
       0,     0,  2666,  2666,  2094,     0,     0,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,  2094,     0,     0,     0,
       0,     0,     0,  2094,     0,  2094,  2094,  2094,  2094,  2094,
    2094,  2094,  2094,  2094,  2094,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2094,     0,     0,
    1813,     0,     0,     0,     0,     0,  1811,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1812,     0,     0,
       0,     0,  1811,     0,     0,  1813,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1812,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2094,     0,     0,     0,     0,  1811,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1812,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1813,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1813,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1811,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1812,     0,
       0,     0,     0,     0,  1811,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1812,     0,     0,     0,     0,
    1813,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1813,     0,     0,  2094,     0,     0,     0,     0,     0,  1811,
       0,     0,     0,  1811,  1811,     0,     0,     4,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1812,     0,     0,     0,  1812,  1812,     0,     5,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     6,     7,     0,
       0,     0,     0,     0,     0,     9,    10,     0,     0,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2094,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2094,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1813,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2094,
       0,     0,     0,     0,     0,     0,     0,  1813,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3238,  3238,     0,  2666,     0,     0,  2666,  2666,  2666,  2666,
    2666,  2666,  2666,  2666,  2666,  2666,  3238,    47,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    48,     0,     0,     0,     0,     0,     0,  2094,
       0,     0,  2094,     0,  2094,     0,     0,     0,     0,  3238,
    3238,     0,    49,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1813,  2666,  2666,  2094,     0,  2094,     0,     0,
    2094,     0,     0,     0,    50,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    51,     0,     0,
      52,     0,     0,     0,     0,     0,     0,  2094,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    53,  2094,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1813,     0,     0,     0,     0,     0,  2094,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1813,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    54,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1813,     0,     0,     0,  1813,  1813,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    55,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    56,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      57,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    58,     0,     0,  2666,     0,
       0,    59,     0,     0,     0,    60,    61,    62,    63,    64,
       0,     0,    65,    66,  1308,  1912,     0,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2094,     0,
       0,  2094,  2094,  2094,     0,     0,  3238,     0,     0,     0,
       0,  3238,  3238,  3238,  3238,  3238,  3238,  3238,  3238,  3238,
    3238,  2094,  2094,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2094,  2666,  2666,
    2094,     0,  2094,     0,     0,     0,  2094,  3238,  3238,     0,
       0,  2094,     0,     0,  2094,     0,     0,     0,     0,     0,
       0,  2094,     0,     0,     0,     0,     4,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     5,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     6,     7,     0,     0,
       0,     0,     0,     0,     9,    10,     0,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,     0,    45,    86,    87,
      88,     0,    90,    91,    92,     0,     0,     0,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
       0,     0,     0,   107,   108,   109,   110,     0,   111,   112,
     113,   114,   115,     0,   116,   117,   118,     0,     0,     0,
       0,     0,   121,   122,    46,     0,     0,     0,   123,     0,
       0,     0,     0,     0,     0,     0,     0,   124,     0,   125,
       0,   126,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,  3238,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   133,     0,     0,     0,
     135,   136,   137,   138,   139,     0,    47,     0,     0,     0,
       0,     0,     0,     0,  2094,  2094,   140,     0,     0,     0,
       0,    48,     0,   144,     0,     0,     0,     0,     0,     0,
     147,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    49,     0,     0,   150,     0,     0,     0,     0,     0,
     151,     0,     0,     0,     0,  2094,     0,     0,     0,  2666,
     154,   155,     0,    50,     0,     0,     0,     0,     0,     0,
       0,  2094,     0,  2094,     0,     0,     0,     0,  3238,  3238,
    2094,     0,     0,  2666,  2666,  2094,  2094,   162,  2094,     0,
       0,     0,     0,     0,   164,     0,    51,   166,     0,    52,
       0,     0,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   172,     0,     0,  2094,
      53,     0,     0,     0,     0,   173,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   174,   175,
       0,     0,     0,     0,     0,   177,     0,   178,     0,     0,
     179,   180,     0,   181,     0,     0,     0,     0,     0,     0,
       0,   182,   183,     0,   184,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   189,   190,   191,     0,     0,     0,
    2094,    54,     0,     0,   192,     0,     0,     0,     0,   194,
       0,     0,   195,     0,   196,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   197,   198,   199,
     200,   201,     0,     0,     0,     0,     0,     0,     0,     0,
     202,     0,   203,    55,     0,     0,     0,     0,     0,  2094,
       0,     0,     0,     0,   205,     0,    56,     0,     0,     0,
       0,     0,     0,  3238,  2666,     0,     0,     0,     0,    57,
       0,     0,   211,     0,     0,   213,     0,  3238,  3238,  2094,
       0,  2094,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   217,     0,    58,   219,     0,   220,     0,     0,
      59,     0,     0,     0,    60,    61,    62,    63,    64,   222,
       0,    65,    66,  1308,  2553,     0,     0,     0,    71,     0,
       0,     0,   224,   225,     0,     0,     0,   226,     0,   227,
       0,     0,     0,     0,     0,     0,     0,   230,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     235,     0,     0,   236,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   238,   239,   240,
     241,   242,   243,   244,   245,     0,     0,     0,     0,     0,
       0,     0,     0,  3238,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2816,     0,     0,     0,     0,     0,  2094,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2094,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   704,    86,    87,    88,
     403,    90,    91,    92,   404,     0,   405,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   705,   104,   105,   406,
     706,     0,   107,   108,   109,   110,   707,   708,   112,   113,
     114,   115,     0,   116,   709,   710,   407,   408,     0,     0,
    2094,   409,   410,     0,     0,     0,     0,   411,     0,     0,
       0,     0,     0,     0,     0,     0,   412,     0,   413,     0,
     414,   415,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
    2094,     0,   417,   418,   419,   420,   421,   422,   423,   424,
     711,   425,   426,   427,   712,   713,   714,   715,   716,   717,
     718,   428,   429,   719,   430,   133,   431,   432,   433,   135,
     136,   137,   138,   139,   720,   434,   435,   436,   437,   438,
     721,   722,   439,   440,   723,   140,   442,   724,   443,   444,
     445,   446,   144,   725,   726,   447,   448,   449,   450,   147,
     451,   727,   728,   453,   454,   455,   456,   457,   458,   729,
     459,   460,   461,   150,   462,   730,   731,   732,   733,   151,
     734,   735,   736,   463,   464,   465,   466,   467,   468,   154,
     155,   469,   737,   470,   738,   471,   472,   473,   474,   475,
     739,   476,   477,   478,   740,   741,   479,   480,   481,   482,
     483,   742,   484,   485,   486,   743,   487,   488,   744,   489,
     490,   491,   492,   164,   493,   494,   166,   745,   495,   746,
     496,   168,   497,   747,   498,   748,   499,   169,   749,   170,
     500,   501,   502,   750,   503,   172,   751,   504,   752,   505,
     506,   507,   508,   509,   173,   510,   511,   512,   753,   513,
     514,   515,   516,   517,   518,   754,   519,   174,   175,   755,
     520,   521,   522,   756,   177,   757,   178,   758,   523,   179,
     180,   524,   181,   525,   526,   527,   528,   529,   530,   759,
     182,   183,   531,   184,   760,   532,   533,   534,   761,   762,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   189,   190,   191,   548,   549,   550,   551,
     552,   553,   554,   192,   555,   763,   556,   557,   194,   558,
     764,   195,   559,   196,   560,   561,   765,   766,   562,   767,
     768,   563,   564,   565,   769,   770,   197,   198,   199,   200,
     201,   566,   567,   568,   569,   570,   571,   771,   572,   202,
     573,   203,   574,   575,   576,   772,   577,   578,   579,   580,
     581,   582,   583,   205,   584,   585,   586,   773,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,   774,   597,
     598,   211,   599,   600,   213,   601,   602,   603,   604,   605,
     606,   607,   608,   775,   609,   610,   611,   612,   613,   776,
     614,   217,   615,   616,   219,   617,   220,   777,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,   628,
     778,   629,   630,   779,   631,   632,   633,   634,   635,   636,
     780,   224,   225,   781,   782,   638,   226,   639,   227,   783,
     640,   641,   642,   643,   644,   645,   784,   785,   646,   647,
     648,   649,   786,   787,   650,   651,   652,   653,   788,   235,
     789,   655,   236,   656,   657,   658,   790,   791,   659,   792,
     793,   660,   661,   662,   663,   664,   238,   239,   240,   241,
     242,   243,   244,   245,   665,   666,   667,    85,     0,     0,
      86,    87,    88,    89,    90,    91,    92,    93,     0,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   932,
     104,   105,   106,     0,     0,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   115,     0,   116,   117,   118,   119,
     120,     0,     0,     0,   121,   122,     0,     0,     0,     0,
     123,     0,     0,     0,     0,     0,     0,     0,     0,   124,
       0,   125,     0,   126,   127,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   129,     0,   130,   131,     0,
       0,     0,     0,     0,     0,     0,     0,   132,   133,     0,
       0,   134,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   140,     0,
       0,   141,     0,   142,   143,   144,     0,     0,   145,     0,
     146,     0,   147,     0,     0,     0,     0,     0,     0,     0,
     148,     0,   149,     0,     0,     0,   150,     0,     0,     0,
       0,     0,   151,     0,     0,     0,     0,     0,     0,   152,
       0,   153,   154,   155,   156,     0,     0,     0,     0,     0,
     157,     0,     0,     0,     0,     0,   158,     0,   159,     0,
       0,     0,   160,     0,     0,     0,     0,     0,   161,   162,
       0,     0,     0,     0,     0,   163,   164,   165,     0,   166,
       0,     0,   167,     0,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,   171,     0,   172,     0,
       0,     0,     0,     0,     0,     0,     0,   173,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     174,   175,     0,     0,   176,     0,     0,   177,     0,   178,
       0,     0,   179,   180,     0,   181,     0,     0,     0,     0,
       0,     0,     0,   182,   183,     0,   184,     0,   185,   186,
       0,     0,     0,     0,   187,     0,     0,     0,     0,     0,
       0,     0,     0,   188,     0,     0,   189,   190,   191,     0,
       0,     0,     0,     0,     0,     0,   192,     0,     0,     0,
     193,   194,     0,     0,   195,     0,   196,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   197,
     198,   199,   200,   201,     0,     0,     0,     0,     0,     0,
       0,     0,   202,     0,   203,     0,   204,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   205,   206,     0,     0,
       0,   207,     0,   208,     0,     0,     0,     0,   209,     0,
       0,     0,     0,   210,   211,     0,   212,   213,     0,     0,
     214,     0,     0,     0,     0,     0,   215,     0,     0,     0,
       0,     0,     0,   216,   217,     0,   218,   219,     0,   220,
       0,     0,     0,   221,     0,     0,     0,     0,     0,     0,
       0,   222,     0,     0,     0,     0,   223,     0,     0,     0,
       0,     0,     0,     0,   224,   225,     0,     0,     0,   226,
       0,   227,     0,   228,     0,   229,     0,     0,     0,   230,
       0,     0,   231,     0,   232,     0,     0,   233,     0,     0,
       0,   234,   235,     0,     0,   236,     0,     0,     0,     0,
       0,     0,     0,   237,     0,     0,     0,     0,     0,   238,
     239,   240,   241,   242,   243,   244,   245,    86,    87,    88,
       0,    90,    91,    92,     0,     0,     0,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   246,   104,   105,     0,
    -124,     0,   107,   108,   109,   110,     0,   111,   112,   113,
     114,   115,     0,   116,   117,   118,     0,     0,     0,     0,
       0,   121,   122,     0,     0,     0,     0,   123,     0,     0,
       0,     0,     0,     0,     0,     0,   124,     0,   125,     0,
     126,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   133,     0,     0,     0,   135,
     136,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,     0,     0,     0,     0,
       0,     0,   144,     0,     0,     0,     0,     0,     0,   147,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   150,     0,     0,     0,     0,     0,   151,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   154,
     155,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   162,     0,     0,     0,
       0,     0,     0,   164,     0,     0,   166,     0,     0,     0,
       0,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   172,     0,     0,     0,     0,
       0,     0,     0,     0,   173,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   174,   175,     0,
       0,     0,     0,     0,   177,     0,   178,     0,     0,   179,
     180,     0,   181,     0,     0,     0,     0,     0,     0,     0,
     182,   183,     0,   184,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   189,   190,   191,     0,     0,     0,     0,
       0,     0,     0,   192,     0,     0,     0,     0,   194,     0,
       0,   195,     0,   196,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   197,   198,   199,   200,
     201,     0,     0,     0,     0,     0,     0,     0,     0,   202,
       0,   203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   205,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   211,     0,     0,   213,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   217,     0,     0,   219,     0,   220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   222,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   224,   225,     0,     0,     0,   226,     0,   227,     0,
       0,     0,     0,     0,     0,     0,   230,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   235,
       0,     0,   236,     0,     0,     0,     0,     0,     0,     4,
       0,     0,     0,     0,     0,     0,   238,   239,   240,   241,
     242,   243,   244,   245,     0,     0,     0,     0,     0,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     6,
       7,     0,     0,     0,     0,     0,     0,     9,    10,     0,
    2818,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,     0,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,     0,     0,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      85,     0,     0,     0,     0,     0,    89,     0,     0,     0,
      93,     0,    94,     0,    96,    97,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   106,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   119,   120,     0,     0,     0,     0,     0,    47,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    48,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    49,     0,     0,     0,   128,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   129,     0,
     130,   131,     0,     0,     0,     0,    50,     0,     0,     0,
       0,     0,     0,     0,  1078,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   141,     0,   142,   143,     0,    51,
       0,   145,    52,   146,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   148,     0,   149,     0,     0,     0,     0,
       0,     0,     0,    53,     0,     0,     0,     0,     0,     0,
       0,     0,   152,     0,   153,     0,     0,   156,     0,     0,
       0,     0,     0,   157,     0,     0,     0,     0,     0,   158,
       0,   159,     0,     0,     0,   160,     0,     0,     0,     0,
       0,   161,     0,     0,     0,     0,     0,     0,   163,     0,
     165,     0,     0,     0,     0,   167,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   171,
       0,     0,     0,     0,    54,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   176,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    55,     0,     0,     0,
       0,   185,   186,     0,     0,     0,     0,   187,     0,    56,
       0,     0,     0,     0,     0,     0,   188,     0,     0,     0,
       0,     0,    57,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   193,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    58,     0,     0,
       0,     0,     0,    59,     0,     0,     0,    60,    61,    62,
      63,    64,     0,     0,    65,    66,  1308,     0,     0,   204,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
     206,     0,     0,     0,   207,     0,   208,     0,     0,     0,
       0,   209,     0,     0,     0,     0,   210,     0,     0,   212,
       0,     0,     0,   214,     0,     0,     0,     0,     0,   215,
       0,     0,     0,     0,     0,     0,   216,     0,     0,   218,
       0,     0,     0,     0,     0,     0,   221,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   223,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   228,     0,   229,     0,
       0,     0,     0,     0,     0,   231,     0,   232,     0,     0,
     233,     0,     0,     0,   234,     0,     0,   704,    86,    87,
      88,   403,    90,    91,    92,   404,   237,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,   246,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,  2755,   425,   426,   427,     0,     0,     0,     0,  1401,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,  1402,   137,  1403,  1404,     0,   434,   435,   436,   437,
     438,  1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,
     444,   445,   446,  1409,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,   468,
    1417,  1418,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,  2756,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,  1420,   493,   494,  1421,  1422,   495,
       0,   496,  1423,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1424,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,  1425,  1426,     0,  1427,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,  1428,   183,   531,   184,     0,   532,   533,   534,  1429,
    1430,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1431,   190,  1432,   548,   549,   550,
     551,   552,   553,   554,   192,   555,  1433,   556,   557,   194,
     558,  1434,  1435,   559,  1436,   560,   561,     0,     0,   562,
       0,     0,  1437,   564,   565,     0,     0,   197,   198,   199,
     200,  1438,   566,   567,   568,   569,   570,   571,     0,   572,
    1439,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,  1440,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,  1441,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
    1442,   614,   217,   615,   616,   219,   617,  1443,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1444,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1445,  1446,     0,     0,   638,  1447,   639,  1448,
    1449,   640,   641,   642,   643,   644,   645,     0,  1450,   646,
     647,   648,   649,  1451,     0,   650,   651,   652,   653,   654,
    1452,  2757,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,  1453,  1454,
    1455,  1456,  1457,  1458,  1459,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,  1460,  1461,  2758,     0,     0,
       0,     0,     0,     0,  1463,  2759,   704,    86,    87,    88,
     403,    90,    91,    92,   404,     0,   405,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   705,   104,   105,   406,
     706,     0,   107,   108,   109,   110,   707,   708,   112,   113,
     114,   115,     0,   116,   709,   710,   407,   408,     0,     0,
       0,   409,   410,     0,     0,     0,     0,   411,     0,     0,
       0,     0,     0,     0,     0,     0,   412,     0,   413,     0,
     414,   415,    35,   416,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,     0,
       0,     0,   417,   418,   419,   420,   421,   422,   423,   424,
       0,   425,   426,   427,     0,     0,     0,     0,  1401,     0,
       0,   428,   429,     0,   430,   133,   431,   432,   433,   135,
    1402,   137,  1403,  1404,     0,   434,   435,   436,   437,   438,
    1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,   444,
     445,   446,  1409,     0,     0,   447,   448,   449,   450,   147,
     451,   452,     0,   453,   454,   455,   456,   457,   458,     0,
     459,   460,   461,   150,   462,     0,  1410,  1411,  1412,  1413,
    1414,  1415,  1416,   463,   464,   465,   466,   467,   468,  1417,
    1418,   469,     0,   470,     0,   471,   472,   473,   474,   475,
       0,   476,   477,   478,     0,     0,   479,   480,  1419,   482,
     483,     0,   484,   485,   486,     0,   487,   488,     0,   489,
     490,   491,   492,  1420,   493,   494,  1421,  1422,   495,     0,
     496,  1423,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,  1424,     0,   504,     0,   505,
     506,   507,   508,   509,   173,   510,   511,   512,     0,   513,
     514,   515,   516,   517,   518,     0,   519,   174,   175,     0,
     520,   521,   522,  1425,  1426,     0,  1427,     0,   523,   179,
     180,   524,   181,   525,   526,   527,   528,   529,   530,     0,
    1428,   183,   531,   184,     0,   532,   533,   534,  1429,  1430,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,  1431,   190,  1432,   548,   549,   550,   551,
     552,   553,   554,   192,   555,  1433,   556,   557,   194,   558,
    1434,  1435,   559,  1436,   560,   561,     0,     0,   562,     0,
       0,  1437,   564,   565,     0,     0,   197,   198,   199,   200,
    1438,   566,   567,   568,   569,   570,   571,     0,   572,  1439,
     573,   203,   574,   575,   576,     0,   577,   578,   579,   580,
     581,   582,   583,  1440,   584,   585,   586,     0,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   211,   599,   600,  1441,   601,   602,   603,   604,   605,
     606,   607,   608,     0,   609,   610,   611,   612,   613,  1442,
     614,   217,   615,   616,   219,   617,  1443,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,  1444,   628,
       0,   629,   630,     0,   631,   632,   633,   634,   635,   636,
       0,  1445,  1446,     0,     0,   638,  1447,   639,  1448,  1449,
     640,   641,   642,   643,   644,   645,     0,  1450,   646,   647,
     648,   649,  1451,     0,   650,   651,   652,   653,   654,  1452,
       0,   655,   236,   656,   657,   658,     0,     0,   659,     0,
       0,   660,   661,   662,   663,   664,   238,  1453,  1454,  1455,
    1456,  1457,  1458,  1459,   665,   666,   667,     0,     0,     0,
       0,     0,     0,     0,  1460,  1461,     0,     0,     0,     0,
       0,     0,     0,  1463,  2668,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,     0,  1784,
     137,  1785,  1786,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,  1787,  1788,   442,     0,   443,   444,   445,
     446,     0,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,     0,     0,     0,   151,     0,
       0,     0,   463,   464,   465,   466,   467,   468,  1789,  1790,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,  1419,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,     0,   493,   494,     0,     0,   495,     0,   496,
    1791,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,     0,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,  2304,   513,   514,
     515,   516,   517,   518,     0,   519,   174,  2305,     0,   520,
     521,   522,  1425,  1792,     0,  1793,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,     0,
     183,   531,   184,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,  1794,   190,  1795,   548,   549,   550,   551,   552,
     553,   554,     0,   555,     0,   556,   557,   194,   558,     0,
       0,   559,  1796,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,  2306,   198,   199,   200,     0,
     566,   567,   568,   569,   570,   571,     0,   572,     0,   573,
       0,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,  1797,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,     0,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
    2307,   615,   616,   219,   617,  1799,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,     0,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1800,  1801,     0,     0,   638,     0,   639,     0,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,     0,  1802,  2308,
     655,   236,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,     0,     0,     0,     0,     0,
       0,     0,     0,   665,   666,   667,     0,     0,     0,     0,
     704,    86,    87,    88,   403,    90,    91,    92,   404,     0,
     405,    95,     0,  2309,    98,    99,   100,   101,   102,   103,
     705,   104,   105,   406,   706,     0,   107,   108,   109,   110,
     707,   708,   112,   113,   114,   115,     0,   116,   709,   710,
     407,   408,     0,     0,     0,   409,   410,     0,     0,     0,
       0,   411,     0,     0,     0,     0,     0,     0,     0,     0,
     412,     0,   413,     0,   414,   415,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   417,   418,   419,   420,
     421,   422,   423,   424,     0,   425,   426,   427,     0,     0,
       0,     0,     0,     0,     0,   428,   429,     0,   430,   133,
     431,   432,   433,     0,  1784,   137,  1785,  1786,     0,   434,
     435,   436,   437,   438,     0,     0,   439,   440,  1787,  1788,
     442,     0,   443,   444,   445,   446,     0,     0,     0,   447,
     448,   449,   450,   147,   451,   452,     0,   453,   454,   455,
     456,   457,   458,     0,   459,   460,   461,   150,   462,     0,
       0,     0,     0,   151,     0,     0,     0,   463,   464,   465,
     466,   467,   468,  1789,  1790,   469,     0,   470,     0,   471,
     472,   473,   474,   475,     0,   476,   477,   478,     0,     0,
     479,   480,  1419,   482,   483,     0,   484,   485,   486,     0,
     487,   488,     0,   489,   490,   491,   492,     0,   493,   494,
       0,     0,   495,     0,   496,  1791,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,     0,
       0,   504,     0,   505,   506,   507,   508,   509,   173,   510,
     511,   512,  2304,   513,   514,   515,   516,   517,   518,     0,
     519,   174,  2305,     0,   520,   521,   522,  1425,  1792,     0,
    1793,     0,   523,   179,   180,   524,   181,   525,   526,   527,
     528,   529,   530,     0,     0,   183,   531,   184,     0,   532,
     533,   534,     0,     0,   535,   536,   537,   538,   539,   540,
     541,   542,   543,   544,   545,   546,   547,  1794,   190,  1795,
     548,   549,   550,   551,   552,   553,   554,     0,   555,     0,
     556,   557,   194,   558,     0,     0,   559,  1796,   560,   561,
       0,     0,   562,     0,     0,   563,   564,   565,     0,     0,
    2306,   198,   199,   200,     0,   566,   567,   568,   569,   570,
     571,     0,   572,     0,   573,     0,   574,   575,   576,     0,
     577,   578,   579,   580,   581,   582,   583,  1797,   584,   585,
     586,     0,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   211,   599,   600,     0,   601,
     602,   603,   604,   605,   606,   607,   608,     0,   609,   610,
     611,   612,   613,     0,   614,  2307,   615,   616,   219,   617,
    1799,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,     0,   628,     0,   629,   630,     0,   631,   632,
     633,   634,   635,   636,     0,  1800,  1801,     0,     0,   638,
       0,   639,     0,     0,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,     0,  1802,  2308,   655,   236,   656,   657,   658,
       0,     0,   659,     0,     0,   660,   661,   662,   663,   664,
       0,     0,     0,     0,     0,     0,     0,     0,   665,   666,
     667,     0,     0,     0,     0,     0,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,  3097,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,  4046,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,     0,     0,     0,     0,
       0,   704,    86,    87,    88,   403,    90,    91,    92,   404,
    1531,   405,    95,     0,  1532,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1397,
    1398,  1399,    45,  1400,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,  1401,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,   135,  1402,   137,  1403,  1404,  2678,
     434,   435,   436,   437,   438,  1405,  1406,   439,   440,  1407,
    1408,   442,     0,   443,   444,   445,   446,  1409,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
       0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,   463,   464,
     465,   466,   467,   468,  1417,  1418,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,  1420,   493,
     494,  1421,  1422,   495,     0,   496,  1423,   497,     0,   498,
       0,   499,   169,  2679,   170,   500,   501,   502,     0,   503,
    1424,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,   175,     0,   520,   521,   522,  1425,  1426,
       0,  1427,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,  2680,  1428,   183,   531,   184,     0,
     532,   533,   534,  1429,  1430,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1431,   190,
    1432,   548,   549,   550,   551,   552,   553,   554,   192,   555,
    1433,   556,   557,   194,   558,  1434,  1435,   559,  1436,   560,
     561,     0,     0,   562,     0,     0,  1437,   564,   565,     0,
       0,   197,   198,   199,   200,  1438,   566,   567,   568,   569,
     570,   571,     0,   572,  1439,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,  1440,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   211,   599,   600,  1441,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,  1442,   614,   217,   615,   616,   219,
     617,  1443,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1444,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,  1445,  1446,     0,  2681,
     638,  1447,   639,  1448,  1449,   640,   641,   642,   643,   644,
     645,     0,  1450,   646,   647,   648,   649,  1451,     0,   650,
     651,   652,   653,   654,  1452,     0,   655,   236,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,  1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,  1460,
    1461,     0,     0,     0,     0,     0,     0,     0,  1463,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1397,  1398,  1399,
      45,  1400,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,  1401,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,   135,  1402,   137,  1403,  1404,     0,   434,   435,
     436,   437,   438,  1405,  1406,   439,   440,  1407,  1408,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,  1417,  1418,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,  1420,   493,   494,  1421,
    1422,   495,     0,   496,  1423,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,  1425,  1426,     0,  1427,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,   184,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1431,   190,  1432,   548,
     549,   550,   551,   552,   553,   554,   192,   555,  1433,   556,
     557,   194,   558,  1434,  1435,   559,  1436,   560,   561,     0,
       0,   562,     0,     0,  1437,   564,   565,     0,     0,   197,
     198,   199,   200,  1438,   566,   567,   568,   569,   570,   571,
       0,   572,  1439,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,  1440,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,  1441,   601,   602,
     603,   604,   605,   606,   607,   608,   215,   609,   610,   611,
     612,   613,  1442,   614,   217,   615,   616,   219,   617,  1443,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1444,   628,     0,   629,   630,   223,   631,   632,   633,
     634,   635,   636,     0,  1445,  1446,     0,     0,   638,  1447,
     639,  1448,  1449,   640,   641,   642,   643,   644,   645,     0,
    1450,   646,   647,   648,   649,  1451,     0,   650,   651,   652,
     653,  1324,  1452,     0,   655,   236,   656,   657,   658,     0,
       0,   659,     0,   237,   660,   661,   662,   663,   664,   238,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,  1460,  1461,     0,
       0,     0,     0,     0,     0,     0,  1463,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,  1401,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,  1402,   137,  1403,  1404,     0,   434,   435,   436,   437,
     438,  1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,
     444,   445,   446,  1409,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,   468,
    1417,  1418,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,  1420,   493,   494,  1421,  1422,   495,
       0,   496,  1423,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1424,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,  1425,  1426,     0,  1427,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,  1428,   183,   531,   184,     0,   532,   533,   534,  1429,
    1430,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1431,   190,  1432,   548,   549,   550,
     551,   552,   553,   554,   192,   555,  1433,   556,   557,   194,
     558,  1434,  1435,   559,  1436,   560,   561,     0,     0,   562,
       0,     0,  1437,   564,   565,     0,     0,   197,   198,   199,
     200,  1438,   566,   567,   568,   569,   570,   571,     0,   572,
    1439,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,  1440,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,  1441,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
    1442,   614,   217,   615,   616,   219,   617,  1443,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1444,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1445,  1446,     0,     0,   638,  1447,   639,  1448,
    1449,   640,   641,   642,   643,   644,   645,     0,  1450,   646,
     647,   648,   649,  1451,     0,   650,   651,   652,   653,   654,
    1452,     0,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,  1453,  1454,
    1455,  1456,  1457,  1458,  1459,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,  1460,  1461,     0,     0,     0,
       0,     0,  2005,  2627,  1463,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1397,  1398,  1399,    45,  1400,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,  1401,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,   135,  1402,
     137,  1403,  1404,     0,   434,   435,   436,   437,   438,  1405,
    1406,   439,   440,  1407,  1408,   442,     0,   443,   444,   445,
     446,  1409,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,  1410,  1411,  1412,  1413,  1414,
    1415,  1416,   463,   464,   465,   466,   467,   468,  1417,  1418,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,  1419,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,  1420,   493,   494,  1421,  1422,   495,     0,   496,
    1423,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1424,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,  1425,  1426,     0,  1427,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,  1428,
     183,   531,   184,     0,   532,   533,   534,  1429,  1430,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,  1431,   190,  1432,   548,   549,   550,   551,   552,
     553,   554,   192,   555,  1433,   556,   557,   194,   558,  1434,
    1435,   559,  1436,   560,   561,     0,     0,   562,     0,     0,
    1437,   564,   565,     0,     0,   197,   198,   199,   200,  1438,
     566,   567,   568,   569,   570,   571,     0,   572,  1439,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,  1440,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,  1441,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,  1442,   614,
     217,   615,   616,   219,   617,  1443,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1444,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1445,  1446,     0,     0,   638,  1447,   639,  1448,  1449,   640,
     641,   642,   643,   644,   645,     0,  1450,   646,   647,   648,
     649,  1451,     0,   650,   651,   652,   653,   654,  1452,     0,
     655,   236,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,  1453,  1454,  1455,  1456,
    1457,  1458,  1459,   665,   666,   667,     0,     0,     0,     0,
       0,     0,     0,  1460,  1461,  1462,     0,     0,     0,     0,
       0,     0,  1463,   704,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   705,   104,   105,   406,   706,     0,   107,
     108,   109,   110,   707,   708,   112,   113,   114,   115,     0,
     116,   709,   710,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
     416,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1397,  1398,  1399,    45,  1400,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,  1401,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,   135,  1402,   137,  1403,
    1404,     0,   434,   435,   436,   437,   438,  1405,  1406,   439,
     440,  1407,  1408,   442,     0,   443,   444,   445,   446,  1409,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,     0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,
     463,   464,   465,   466,   467,   468,  1417,  1418,   469,  1548,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,  1419,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
    1420,   493,   494,  1421,  1422,   495,     0,   496,  1423,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1424,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
    1425,  1426,     0,  1427,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,  1428,   183,   531,
     184,     0,   532,   533,   534,  1429,  1430,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
    1431,   190,  1432,   548,   549,   550,   551,   552,   553,   554,
     192,   555,  1433,   556,   557,   194,   558,  1434,  1435,   559,
    1436,   560,   561,     0,     0,   562,     0,     0,  1437,   564,
     565,     0,     0,   197,   198,   199,   200,  1438,   566,   567,
     568,   569,   570,   571,     0,   572,  1439,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
    1440,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   211,   599,
     600,  1441,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,  1442,   614,   217,   615,
     616,   219,   617,  1443,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1444,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,  1445,  1446,
       0,     0,   638,  1447,   639,  1448,  1449,   640,   641,   642,
     643,   644,   645,     0,  1450,   646,   647,   648,   649,  1451,
       0,   650,   651,   652,   653,   654,  1452,     0,   655,   236,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,  1453,  1454,  1455,  1456,  1457,  1458,
    1459,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,  1460,  1461,     0,     0,     0,     0,     0,     0,     0,
    1463,   704,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1397,
    1398,  1399,    45,  1400,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,  2190,   425,   426,   427,     0,
       0,     0,     0,  1401,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,   135,  1402,   137,  1403,  1404,     0,
     434,   435,   436,   437,   438,  1405,  1406,   439,   440,  1407,
    1408,   442,     0,   443,   444,   445,   446,  1409,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
       0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,   463,   464,
     465,   466,   467,   468,  1417,  1418,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,  1420,   493,
     494,  1421,  1422,   495,     0,   496,  1423,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1424,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,   175,     0,   520,   521,   522,  1425,  1426,
       0,  1427,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,  1428,   183,   531,   184,     0,
     532,   533,   534,  1429,  1430,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1431,   190,
    1432,   548,   549,   550,   551,   552,   553,   554,   192,   555,
    1433,   556,   557,   194,   558,  1434,  1435,   559,  1436,   560,
     561,     0,     0,   562,     0,     0,  1437,   564,   565,     0,
       0,   197,   198,   199,   200,  1438,   566,   567,   568,   569,
     570,   571,     0,   572,  1439,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,  1440,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   211,   599,   600,  1441,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,  1442,   614,   217,   615,   616,   219,
     617,  1443,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1444,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,  1445,  1446,     0,     0,
     638,  1447,   639,  1448,  1449,   640,   641,   642,   643,   644,
     645,     0,  1450,   646,   647,   648,   649,  1451,     0,   650,
     651,   652,   653,   654,  1452,     0,   655,   236,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,  1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,  1460,
    1461,     0,     0,     0,     0,     0,     0,     0,  1463,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1397,  1398,  1399,
      45,  1400,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,  1401,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,   135,  1402,   137,  1403,  1404,     0,   434,   435,
     436,   437,   438,  1405,  1406,   439,   440,  1407,  1408,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,  3136,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,  1417,  1418,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,  1420,   493,   494,  1421,
    1422,   495,     0,   496,  1423,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,  1425,  1426,     0,  1427,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,   184,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1431,   190,  1432,   548,
     549,   550,   551,   552,   553,   554,   192,   555,  1433,   556,
     557,   194,   558,  1434,  1435,   559,  1436,   560,   561,     0,
       0,   562,     0,     0,  1437,   564,   565,     0,     0,   197,
     198,   199,   200,  1438,   566,   567,   568,   569,   570,   571,
       0,   572,  1439,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,  1440,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,  1441,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,  1442,   614,   217,   615,   616,   219,   617,  1443,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1444,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,  1445,  1446,     0,     0,   638,  1447,
     639,  1448,  1449,   640,   641,   642,   643,   644,   645,     0,
    1450,   646,   647,   648,   649,  1451,     0,   650,   651,   652,
     653,   654,  1452,     0,   655,   236,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,   238,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,  1460,  1461,     0,
       0,     0,     0,     0,     0,     0,  1463,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,  1401,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,  1402,   137,  1403,  1404,     0,   434,   435,   436,   437,
     438,  1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,
     444,   445,   446,  1409,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,   468,
    1417,  1418,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,  1420,   493,   494,  1421,  1422,   495,
       0,   496,  1423,   497,     0,   498,     0,   499,   169,  2679,
     170,   500,   501,   502,     0,   503,  1424,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,  1425,  1426,     0,  1427,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,  1428,   183,   531,   184,     0,   532,   533,   534,  1429,
    1430,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1431,   190,  1432,   548,   549,   550,
     551,   552,   553,   554,   192,   555,  1433,   556,   557,   194,
     558,  1434,  1435,   559,  1436,   560,   561,     0,     0,   562,
       0,     0,  1437,   564,   565,     0,     0,   197,   198,   199,
     200,  1438,   566,   567,   568,   569,   570,   571,     0,   572,
    1439,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,  1440,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,  1441,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
    1442,   614,   217,   615,   616,   219,   617,  1443,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1444,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1445,  1446,     0,     0,   638,  1447,   639,  1448,
    1449,   640,   641,   642,   643,   644,   645,     0,  1450,   646,
     647,   648,   649,  1451,     0,   650,   651,   652,   653,   654,
    1452,     0,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,  1453,  1454,
    1455,  1456,  1457,  1458,  1459,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,  1460,  1461,     0,     0,     0,
       0,     0,     0,     0,  1463,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1397,  1398,  1399,    45,  1400,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,  1401,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,   135,  1402,
     137,  1403,  1404,     0,   434,   435,   436,   437,   438,  1405,
    1406,   439,   440,  1407,  1408,   442,     0,   443,   444,   445,
     446,  1409,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,  1410,  1411,  1412,  1413,  1414,
    1415,  1416,   463,   464,   465,   466,   467,   468,  1417,  1418,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,  1419,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,  1420,   493,   494,  1421,  1422,   495,     0,   496,
    1423,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1424,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,  1425,  1426,     0,  1427,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,  1428,
     183,   531,   184,     0,   532,   533,   534,  1429,  1430,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,  1431,   190,  1432,   548,   549,   550,   551,   552,
     553,   554,   192,   555,  1433,   556,   557,   194,   558,  1434,
    1435,   559,  1436,   560,   561,     0,     0,   562,     0,     0,
    1437,   564,   565,     0,     0,   197,   198,   199,   200,  1438,
     566,   567,   568,   569,   570,   571,     0,   572,  1439,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,  1440,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,  1441,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,  1442,   614,
     217,   615,   616,   219,   617,  1443,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1444,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1445,  1446,     0,     0,   638,  1447,   639,  1448,  1449,   640,
     641,   642,   643,   644,   645,     0,  1450,   646,   647,   648,
     649,  1451,     0,   650,   651,   652,   653,   654,  1452,  3740,
     655,   236,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,  1453,  1454,  1455,  1456,
    1457,  1458,  1459,   665,   666,   667,     0,     0,     0,     0,
       0,     0,     0,  1460,  1461,     0,     0,     0,     0,     0,
       0,     0,  1463,   704,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   705,   104,   105,   406,   706,     0,   107,
     108,   109,   110,   707,   708,   112,   113,   114,   115,     0,
     116,   709,   710,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
     416,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1397,  1398,  1399,    45,  1400,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,  1401,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,  4410,  1402,   137,  1403,
    1404,     0,   434,   435,   436,   437,   438,  1405,  1406,   439,
     440,  1407,  1408,   442,     0,   443,   444,   445,   446,  1409,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,  4411,  1410,  1411,  1412,  1413,  1414,  1415,  1416,
     463,   464,   465,   466,   467,   468,  1417,  1418,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,  1419,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
    1420,   493,   494,  1421,  1422,   495,     0,   496,  1423,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1424,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
    1425,  1426,     0,  1427,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,  1428,   183,   531,
     184,     0,   532,   533,   534,  1429,  1430,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
    1431,   190,  1432,   548,   549,   550,   551,   552,   553,   554,
     192,   555,  1433,   556,   557,   194,   558,  1434,  1435,   559,
    1436,   560,   561,     0,     0,   562,     0,     0,  1437,   564,
     565,     0,     0,   197,   198,   199,   200,  1438,   566,   567,
     568,   569,   570,   571,     0,   572,  1439,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
    1440,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   211,   599,
     600,  1441,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,  1442,   614,   217,   615,
     616,   219,   617,  1443,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1444,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,  1445,  1446,
       0,     0,   638,  1447,   639,  1448,  1449,   640,   641,   642,
    4412,   644,   645,     0,  1450,   646,   647,   648,   649,  1451,
       0,   650,   651,   652,   653,   654,  1452,     0,   655,   236,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,  1453,  1454,  1455,  1456,  1457,  1458,
    1459,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,  1460,  1461,     0,     0,     0,     0,     0,     0,     0,
    1463,   704,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1397,
    1398,  1399,    45,  1400,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,  1401,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,   135,  1402,   137,  1403,  1404,     0,
     434,   435,   436,   437,   438,  1405,  1406,   439,   440,  1407,
    1408,   442,     0,   443,   444,   445,   446,  1409,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
    4411,  1410,  1411,  1412,  1413,  1414,  1415,  1416,   463,   464,
     465,   466,   467,   468,  1417,  1418,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,  1420,   493,
     494,  1421,  1422,   495,     0,   496,  1423,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1424,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,   175,     0,   520,   521,   522,  1425,  1426,
       0,  1427,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,  1428,   183,   531,   184,     0,
     532,   533,   534,  1429,  1430,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1431,   190,
    1432,   548,   549,   550,   551,   552,   553,   554,   192,   555,
    1433,   556,   557,   194,   558,  1434,  1435,   559,  1436,   560,
     561,     0,     0,   562,     0,     0,  1437,   564,   565,     0,
       0,   197,   198,   199,   200,  1438,   566,   567,   568,   569,
     570,   571,     0,   572,  1439,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,  1440,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   211,   599,   600,  1441,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,  1442,   614,   217,   615,   616,   219,
     617,  1443,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1444,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,  1445,  1446,     0,     0,
     638,  1447,   639,  1448,  1449,   640,   641,   642,  4412,   644,
     645,     0,  1450,   646,   647,   648,   649,  1451,     0,   650,
     651,   652,   653,   654,  1452,     0,   655,   236,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,  1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,  1460,
    1461,     0,     0,     0,     0,     0,     0,     0,  1463,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1397,  1398,  1399,
      45,  1400,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,  1401,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,   135,  1402,   137,  1403,  1404,     0,   434,   435,
     436,   437,   438,  1405,  1406,   439,   440,  1407,  1408,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,  1417,  1418,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,  1420,   493,   494,  1421,
    1422,   495,     0,   496,  1423,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,  1425,  1426,     0,  1427,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,   184,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1431,   190,  1432,   548,
     549,   550,   551,   552,   553,   554,   192,   555,  1433,   556,
     557,   194,   558,  1434,  1435,   559,  1436,   560,   561,     0,
       0,   562,     0,     0,  1437,   564,   565,     0,     0,   197,
     198,   199,   200,  1438,   566,   567,   568,   569,   570,   571,
       0,   572,  1439,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,  1440,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,  1441,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,  1442,   614,   217,   615,   616,   219,   617,  1443,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1444,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,  1445,  1446,     0,     0,   638,  1447,
     639,  1448,  1449,   640,   641,   642,   643,   644,   645,     0,
    1450,   646,   647,   648,   649,  1451,     0,   650,   651,   652,
     653,   654,  1452,     0,   655,   236,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,   238,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,  1460,  1461,     0,
       0,     0,     0,     0,     0,     0,  1463,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,  1401,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,  1402,   137,  1403,  1404,     0,   434,   435,   436,   437,
     438,  1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,
     444,   445,   446,  1409,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,   468,
    1417,  1418,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,  1420,   493,   494,  1421,  1422,   495,
       0,   496,  1423,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1424,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,  1425,  1426,     0,  1427,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,  1428,   183,   531,   184,     0,   532,   533,   534,  1429,
    1430,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1431,   190,  1432,   548,   549,   550,
     551,   552,   553,   554,   192,   555,  1433,   556,   557,   194,
     558,  1434,  1435,   559,  1436,   560,   561,     0,     0,   562,
       0,     0,  1437,   564,   565,     0,     0,   197,   198,   199,
     200,  1438,   566,   567,   568,   569,   570,   571,     0,   572,
    1439,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,  1440,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,  1441,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
    1442,   614,   217,   615,   616,   219,   617,  1443,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1444,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1445,  1446,     0,     0,   638,  1447,   639,  1448,
    1449,   640,   641,   642,   643,   644,   645,     0,  1450,   646,
     647,   648,   649,  1451,     0,   650,   651,   652,   653,   654,
    1452,     0,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,  3988,  1453,  1454,
    1455,  1456,  1457,  1458,  1459,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,  1460,  1461,     0,     0,     0,
       0,     0,     0,     0,  1463,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1397,  1398,  1399,    45,  1400,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,  1401,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,   135,  1402,
     137,  1403,  1404,     0,   434,   435,   436,   437,   438,  1405,
    1406,   439,   440,  1407,  1408,   442,     0,   443,   444,   445,
     446,  1409,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,  1410,  1411,  1412,  1413,  1414,
    1415,  1416,   463,   464,   465,   466,   467,   468,  1417,  1418,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,  1419,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,  1420,   493,   494,  1421,  1422,   495,     0,   496,
    1423,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1424,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,  1425,  1426,     0,  1427,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,  1428,
     183,   531,   184,     0,   532,   533,   534,  1429,  1430,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,  1431,   190,  1432,   548,  3995,   550,   551,   552,
     553,   554,   192,   555,  1433,   556,   557,   194,   558,  1434,
    1435,   559,  1436,   560,   561,     0,     0,   562,     0,     0,
    1437,   564,   565,     0,     0,   197,   198,   199,   200,  1438,
     566,   567,   568,   569,   570,   571,     0,   572,  1439,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,  1440,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,  1441,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,  1442,   614,
     217,   615,   616,   219,   617,  1443,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1444,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1445,  1446,     0,     0,   638,  1447,   639,  1448,  1449,   640,
     641,   642,   643,   644,   645,     0,  1450,   646,   647,   648,
     649,  1451,     0,   650,   651,   652,   653,   654,  1452,     0,
     655,   236,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,  1453,  1454,  1455,  1456,
    1457,  1458,  1459,   665,   666,   667,     0,     0,     0,     0,
       0,     0,     0,  1460,  1461,     0,     0,     0,     0,     0,
       0,     0,  1463,   704,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   705,   104,   105,   406,   706,     0,   107,
     108,   109,   110,   707,   708,   112,   113,   114,   115,     0,
     116,   709,   710,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
     416,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1397,  1398,  1399,    45,  1400,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,  1401,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,   135,  1402,   137,  1403,
    1404,     0,   434,   435,   436,   437,   438,  1405,  1406,   439,
     440,  1407,  1408,   442,     0,   443,   444,   445,   446,  1409,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,     0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,
     463,   464,   465,   466,   467,   468,  1417,  1418,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,  1419,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
    1420,   493,   494,  1421,  1422,   495,     0,   496,  1423,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1424,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
    1425,  1426,     0,  1427,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,  1428,   183,   531,
     184,     0,   532,   533,   534,  1429,  1430,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
    1431,   190,  1432,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,   194,   558,  1434,  1435,   559,
    1436,   560,   561,     0,     0,   562,     0,     0,  1437,   564,
     565,     0,     0,   197,   198,   199,   200,  1438,   566,   567,
     568,   569,   570,   571,     0,   572,  1439,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
    1440,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   211,   599,
     600,  1441,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,  1442,   614,   217,   615,
     616,   219,   617,  1443,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1444,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,  1445,  1446,
       0,     0,   638,  1447,   639,  1448,  1449,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,  1451,
       0,   650,   651,   652,   653,   654,  1452,     0,   655,   236,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,  1453,  1454,  1455,  1456,  1457,  1458,
    1459,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,  2661,  2662,     0,     0,     0,     0,     0,     0,     0,
    1463,   704,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1397,
    1398,  1399,    45,  1400,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,  1401,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433, -2407,  1402,   137,  1403,  1404,     0,
     434,   435,   436,   437,   438,  1405,  1406,   439,   440,  1407,
    1408,   442,     0,   443,   444,   445,   446,  1409,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
    4411,  1410,  1411,  1412,  1413,  1414,  1415,  1416,   463,   464,
     465,   466,   467,   468,  1417,  1418,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,  1420,   493,
     494,  1421,  1422,   495,     0,   496,  1423,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1424,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,   175,     0,   520,   521,   522,  1425,  1426,
       0,  1427,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,  1428,   183,   531,     0,     0,
     532,   533,   534,  1429,  1430,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1431,   190,
    1432,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,   194,   558,  1434,  1435,   559,  1436,   560,
     561,     0,     0,   562,     0,     0,  1437,   564,   565,     0,
       0,   197,   198,   199,   200,  1438,   566,   567,   568,   569,
     570,   571,     0,   572,  1439,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,  1440,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   211,   599,   600,  1441,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,  1442,   614,   217,   615,   616,     0,
     617,  1443,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1444,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,  1445,  1446,     0,     0,
     638,  1447,   639,  1448,  1449,   640,   641,   642,  4412,   644,
     645,     0,  1450,   646,   647,   648,   649,  1451,     0,   650,
     651,   652,   653,   654,  1452,     0,   655,   236,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,  1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,  1460,
    1461,     0,     0,     0,     0,     0,     0,     0,  1463,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1397,  1398,  1399,
      45,  1400,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,  1401,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,     0,  1402,   137,  1403,  1404,     0,   434,   435,
     436,   437,   438,  1405,  1406,   439,   440,  1407,  1408,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,  1417,  1418,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
       0,     0,   489,   490,   491,   492,  1420,   493,   494,  1421,
    1422,   495,     0,   496,  1423,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,     0,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,  1425,  1426,     0,  1427,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,     0,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1431,   190,  1432,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,   194,   558,  1434,  1435,   559,  1436,   560,   561,     0,
       0,   562,     0,     0,  1437,   564,   565,     0,     0,   197,
     198,   199,   200,  1438,   566,   567,   568,   569,   570,   571,
       0,   572,  1439,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,  1440,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,  1441,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,  1442,   614,   217,   615,   616,     0,   617,  1443,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1444,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,  1445,  1446,     0,     0,   638,  1447,
     639,  1448,  1449,   640,   641,   642,   643,   644,   645,     0,
    1450,   646,   647,   648,   649,  1451,     0,   650,   651,   652,
     653,   654,  1452,     0,   655,   236,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,   238,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,  1460,  1461,     0,
       0,     0,     0,     0,     0,     0,  1463,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,  1401,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
       0,  1402,   137,  1403,  1404,     0,   434,   435,   436,   437,
     438,  1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,
     444,   445,   446,  1409,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,   468,
    1417,  1418,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,     0,     0,
     489,   490,   491,   492,  1420,   493,   494,  1421,  1422,   495,
       0,   496,  1423,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1424,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,  1425,  1426,     0,  1427,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,  1428,   183,   531,     0,     0,   532,   533,   534,  1429,
    1430,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1431,   190,  1432,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,   194,
     558,  1434,  1435,   559,  1436,   560,   561,     0,     0,   562,
       0,     0,  1437,   564,   565,     0,     0,   197,   198,   199,
     200,  1438,   566,   567,   568,   569,   570,   571,     0,   572,
    1439,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,  1440,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,  1441,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
    1442,   614,   217,   615,   616,     0,   617,  1443,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1444,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1445,  1446,     0,     0,   638,  1447,   639,  1448,
    1449,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,  1451,     0,   650,   651,   652,   653,   654,
    1452,     0,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,  1453,  1454,
    1455,  1456,  1457,  1458,  1459,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,  2661,  2662,     0,     0,     0,
       0,     0,     0,     0,  1463,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,   135,   136,
     137,   138,   139,     0,   434,   435,   436,   437,   438,     0,
    1406,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,  1409,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,  1410,  1411,  1412,  1413,  1414,
    1415,  1416,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,  1421,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1424,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,  1428,
     183,   531,   184,     0,   532,   533,   534,  1429,  1430,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,   190,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,   194,   558,     0,
    1435,   559,   196,   560,   561,     0,     0,   562,     0,  1044,
     563,   564,   565,     0,     0,   197,   198,   199,   200,  1438,
     566,   567,   568,   569,   570,   571,     0,   572,  1439,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,   215,   609,   610,   611,   612,   613,  1442,   614,
     217,   615,   616,   219,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1444,   628,     0,
     629,   630,   223,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,  1447,   639,  1448,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,  1451,     0,   650,   651,   652,   653,  1324,   235,     0,
     655,   236,   656,   657,   658,     0,     0,   659,     0,   237,
     660,   661,   662,   663,   664,   238,  1453,  1454,  1455,  1456,
    1457,  1458,  1459,   665,   666,   667,     0,     0,     0,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,  2510,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,     0,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,   135,   136,   137,   138,   139,     0,   434,   435,
     436,   437,   438,     0,  1406,   439,   440,   441,   140,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,   154,   155,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,   164,   493,   494,  1421,
       0,   495,     0,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,     0,   177,     0,   178,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,   184,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   189,   190,   191,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,   194,   558,     0,  1435,   559,   196,   560,   561,     0,
       0,   562,     0,  1044,   563,   564,   565,     0,     0,   197,
     198,   199,   200,  1438,   566,   567,   568,   569,   570,   571,
       0,   572,  1439,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,   205,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,   213,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,  1442,   614,   217,   615,   616,   219,   617,   220,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1444,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,   224,   225,     0,     0,   638,  1447,
     639,  1448,     0,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,  1451,     0,   650,   651,   652,
     653,   654,   235,     0,   655,   236,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,   238,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,   666,   667,
       0,     0,     0,   704,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,  2510,    98,    99,   100,
     101,   102,   103,   705,   104,   105,   406,   706,     0,   107,
     108,   109,   110,   707,   708,   112,   113,   114,   115,     0,
     116,   709,   710,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,   135,   136,   137,   138,
     139,     0,   434,   435,   436,   437,   438,     0,  1406,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,  1409,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,     0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,  1421,     0,   495,     0,   496,   168,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1424,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,  1428,   183,   531,
     184,     0,   532,   533,   534,  1429,  1430,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,   190,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,   194,   558,     0,  1435,   559,
     196,   560,   561,     0,     0,   562,     0,     0,   563,   564,
     565,     0,     0,   197,   198,   199,   200,  1438,   566,   567,
     568,   569,   570,   571,     0,   572,  1439,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
     205,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   211,   599,
     600,   213,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,  1442,   614,   217,   615,
     616,   219,   617,   220,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1444,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,   224,   225,
       0,     0,   638,  1447,   639,  1448,     0,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,  1451,
       0,   650,   651,   652,   653,   654,   235,     0,   655,   236,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,  1453,  1454,  1455,  1456,  1457,  1458,
    1459,   665,   666,   667,     0,     0,     0,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
    3768,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,   136,   137,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,     0,     0,     0,
     151,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,   182,   183,   531,   184,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,   190,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,   194,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,   198,   199,
     200,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,   219,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,     0,     0,
       0,     0,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,  4223,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,  3118,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461, -1272,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0, -1272,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519, -1272,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524, -1272,   525,   526,
     527,   528,   529,   530,     0,   182, -1272,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189, -1272,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,     0,     0,   562,     0,     0,   563,   564,   565,     0,
       0,   197,     0,     0,     0,   201,   566,   567,   568,   569,
     570,   571,     0,   572,   202,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,   205,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598, -1272,   599,   600,   213,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,     0,   614,   217,   615,   616,     0,
     617,   220,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,   224,   225,     0,     0,
     638,   226,   639,   227,     0,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,   235,     0,   655,     0,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,   239,   240,   241,   242,   243,   244,   245,   665,
     666,   667,     0,     0,     0,     0,     0,    86,    87,    88,
     403,    90,    91,    92,   404,     0,   405,    95,     0,  1556,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   406,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   407,   408,     0,     0,
       0,   409,   410,     0,     0,     0,     0,   411,     0,     0,
       0,     0,     0,     0,     0,     0,   412,     0,   413,     0,
     414,   415,    35,   416,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,     0,    45,     0,     0,
       0,     0,   417,   418,   419,   420,   421,   422,   423,   424,
       0,   425,   426,   427,     0,     0,     0,     0,     0,     0,
       0,   428,   429,     0,   430,     0,   431,   432,   433,   135,
     136,     0,   138,   139,     0,   434,   435,   436,   437,   438,
       0,     0,   439,   440,   441,   140,   442,     0,   443,   444,
     445,   446,   144,     0,     0,   447,   448,   449,   450,     0,
     451,   452,     0,   453,   454,   455,   456,   457,   458,     0,
     459,   460,   461,     0,   462,     0,     0,     0,     0,     0,
       0,     0,     0,   463,   464,   465,   466,   467,   468,   154,
     155,   469,     0,   470,     0,   471,   472,   473,   474,   475,
       0,   476,   477,   478,     0,     0,   479,   480,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,     0,   489,
     490,   491,   492,   164,   493,   494,   166,  1927,   495,     0,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   507,   508,   509,     0,   510,   511,   512,     0,   513,
     514,   515,   516,   517,   518,     0,   519,     0,   175,     0,
     520,   521,   522,     0,   177,     0,   178,     0,   523,     0,
       0,   524,     0,   525,   526,   527,   528,   529,   530,     0,
     182,     0,   531,     0,     0,   532,   533,   534,     0,     0,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   189,     0,   191,   548,   549,   550,   551,
     552,   553,   554,   192,   555,     0,   556,   557,     0,   558,
       0,   195,   559,   196,   560,   561,  1928,     0,   562,  1929,
       0,   563,   564,   565,     0,     0,   197,     0,     0,     0,
     201,   566,   567,   568,   569,   570,   571,     0,   572,   202,
     573,   203,   574,   575,   576,     0,   577,   578,   579,   580,
     581,   582,   583,   205,   584,   585,   586,     0,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,     0,   599,   600,   213,   601,   602,   603,   604,   605,
     606,   607,   608,     0,   609,   610,   611,   612,   613,     0,
     614,   217,   615,   616,     0,   617,   220,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,   628,
       0,   629,   630,     0,   631,   632,   633,   634,   635,   636,
       0,   224,   225,     0,     0,   638,   226,   639,   227,  1930,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,   235,
       0,   655,     0,   656,   657,   658,     0,     0,   659,     0,
       0,   660,   661,   662,   663,   664,   238,   239,   240,   241,
     242,   243,   244,   245,   665,   666,   667,     0,     0,     0,
       0,     0,     0,     0,   962,  1595,  3845,     0,     0,     0,
       0,     0,     0,  3846,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   406,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,    45,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,     0,   431,   432,   433,   135,   136,     0,   138,
     139,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,   144,
       0,     0,   447,   448,   449,   450,     0,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
       0,   462,     0,     0,     0,     0,     0,     0,     0,     0,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,   166,     0,   495,     0,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   507,   508,
     509,     0,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,     0,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,     0,     0,   524,     0,
     525,   526,   527,   528,   529,   530,     0,   182,     0,   531,
       0,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,     0,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,     0,   558,     0,   195,   559,
     196,   560,   561,     0,     0,   562,     0,     0,   563,   564,
     565,     0,     0,   197,     0,     0,     0,   201,   566,   567,
     568,   569,   570,   571,     0,   572,   202,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
     205,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   213,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,     0,   614,   217,   615,
     616,     0,   617,   220,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,   224,   225,
       0,     0,   638,   226,   639,   227,     0,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,   235,     0,   655,     0,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,   239,   240,   241,   242,   243,   244,
     245,   665,   666,   667,     0,     0,     0,     0,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,  3502,
    3503,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,   130,   131,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,   215,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,   223,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,  1324,
     235,     0,   655,  1325,   656,   657,   658,     0,     0,   659,
       0,   237,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,     0,     0,
       0,     0,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,   246,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,    45,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,     0,     0,   562,     0,     0,   563,   564,   565,     0,
       0,   197,     0,     0,     0,   201,   566,   567,   568,   569,
     570,   571,     0,   572,   202,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,   205,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,     0,   599,   600,   213,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,     0,   614,   217,   615,   616,     0,
     617,   220,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,   224,   225,     0,     0,
     638,   226,   639,   227,     0,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,   235,     0,   655,     0,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,   239,   240,   241,   242,   243,   244,   245,   665,
     666,   667,     0,     0,     0,     0,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,  3503,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,   215,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,   223,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,  1324,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,   237,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,     0,     0,     0,     0,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,   246,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   406,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,     0,     0,     0,   428,   429,     0,   430,     0,   431,
     432,   433,   135,   136,     0,   138,   139,     0,   434,   435,
     436,   437,   438,     0,     0,   439,   440,   441,   140,   442,
       0,   443,   444,   445,   446,   144,     0,     0,   447,   448,
     449,   450,     0,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,     0,   462,     0,     0,
       0,     0,     0,     0,     0,     0,   463,   464,   465,   466,
     467,   468,   154,   155,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,   164,   493,   494,   166,
       0,   495,     0,   496,   168,   497,     0,   498,     0,   499,
       0,     0,     0,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,   507,   508,   509,     0,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
       0,   175,     0,   520,   521,   522,     0,   177,     0,   178,
       0,   523,     0,     0,   524,     0,   525,   526,   527,   528,
     529,   530,     0,   182,     0,   531,     0,     0,   532,   533,
     534,     0,     0,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   189,     0,   191,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,     0,   558,     0,   195,   559,   196,   560,   561,     0,
       0,   562,     0,     0,   563,   564,   565,     0,     0,   197,
       0,     0,     0,   201,   566,   567,   568,   569,   570,   571,
       0,   572,   202,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,   205,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   213,   601,   602,
     603,   604,   605,   606,   607,   608,   215,   609,   610,   611,
     612,   613,     0,   614,   217,   615,   616,     0,   617,   220,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,   628,     0,   629,   630,   223,   631,   632,   633,
     634,   635,   636,     0,   224,   225,     0,     0,   638,   226,
     639,   227,     0,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,  1324,   235,     0,   655,     0,   656,   657,   658,     0,
       0,   659,     0,   237,   660,   661,   662,   663,   664,   238,
     239,   240,   241,   242,   243,   244,   245,   665,   666,   667,
       0,     0,     0,     0,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,   246,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   406,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,     0,   431,   432,   433,   135,   136,     0,   138,
     139,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,   144,
       0,     0,   447,   448,   449,   450,     0,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
       0,   462,     0,     0,     0,     0,     0,     0,     0,     0,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,   166,     0,   495,     0,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   507,   508,
     509,     0,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,     0,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,     0,     0,   524,     0,
     525,   526,   527,   528,   529,   530,     0,   182,     0,   531,
       0,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,     0,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,     0,   558,     0,   195,   559,
     196,   560,   561,     0,     0,   562,     0,     0,   563,   564,
     565,     0,     0,   197,     0,     0,     0,   201,   566,   567,
     568,   569,   570,   571,     0,   572,   202,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
     205,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   213,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,     0,   614,   217,   615,
     616,     0,   617,   220,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,   224,   225,
       0,     0,   638,   226,   639,   227,     0,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,   235,     0,   655,     0,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,   239,   240,   241,   242,   243,   244,
     245,   665,   666,   667,     0,     0,     0,     0,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
    1528,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,     0,     0,
       0,     0,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,  2162,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,     0,     0,   562,     0,     0,   563,   564,   565,     0,
       0,   197,     0,     0,     0,   201,   566,   567,   568,   569,
     570,   571,     0,   572,   202,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,   205,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,     0,   599,   600,   213,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,     0,   614,   217,   615,   616,     0,
     617,   220,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,   224,   225,     0,     0,
     638,   226,   639,   227,     0,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,   235,     0,   655,     0,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,   239,   240,   241,   242,   243,   244,   245,   665,
     666,   667,     0,     0,     0,     0,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,  3608,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,     0,     0,     0,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,  3733,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,     0,     0,  1158,
      45,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,   711,   425,   426,   427,   712,   713,   714,
     715,   716,   717,   718,   428,   429,   719,   430,   133,   431,
     432,   433,     0,  1784,   137,  1785,  1786,   720,   434,   435,
     436,   437,   438,   721,   722,   439,   440,  1787,  1788,   442,
     724,   443,   444,   445,   446,     0,   725,   726,   447,   448,
     449,   450,   147,   451,   452,   728,   453,   454,   455,   456,
     457,   458,   729,   459,   460,   461,   150,   462,     0,   731,
     732,   733,   151,   734,   735,   736,   463,   464,   465,   466,
     467,   468,  1789,  1790,   469,   737,   470,   738,   471,   472,
     473,   474,   475,   739,   476,   477,   478,   740,   741,   479,
     480,  1419,   482,   483,   742,   484,   485,   486,   743,   487,
     488,   744,   489,   490,   491,   492,     0,   493,   494,     0,
     745,   495,   746,   496,  1791,   497,   747,   498,   748,   499,
     169,   749,   170,   500,   501,   502,   750,   503,     0,   751,
     504,   752,   505,   506,   507,   508,   509,   173,   510,   511,
     512,   753,   513,   514,   515,   516,   517,   518,   754,   519,
     174,     0,     0,   520,   521,   522,  1425,  1792,   757,  1793,
     758,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,   759,     0,   183,   531,   184,   760,   532,   533,
     534,   761,   762,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1794,   190,  1795,   548,
     549,   550,   551,   552,   553,   554,     0,   555,   763,   556,
     557,   194,   558,   764,     0,   559,  1796,   560,   561,   765,
     766,   562,   767,   768,  3489,   564,   565,   769,   770,     0,
     198,   199,   200,     0,   566,   567,   568,   569,   570,   571,
     771,   572,     0,   573,     0,   574,   575,   576,   772,   577,
     578,   579,   580,   581,   582,   583,  1797,   584,   585,   586,
     773,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,   774,   597,   598,   211,   599,   600,     0,   601,   602,
     603,   604,   605,   606,   607,   608,   775,   609,   610,   611,
     612,   613,   776,   614,  2307,   615,   616,   219,   617,  1799,
     777,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,     0,   628,   778,   629,   630,   779,   631,   632,   633,
     634,   635,   636,   780,  1800,  1801,     0,   782,   638,     0,
     639,     0,   783,   640,   641,   642,   643,   644,   645,     0,
     785,   646,   647,   648,   649,   786,   787,   650,   651,   652,
     653,     0,  1802,   789,   655,   236,   656,   657,   658,   790,
     791,   659,   792,   793,   660,   661,   662,   663,   664,     0,
       0,     0,     0,     0,     0,     0,     0,   665,   666,   667,
       0,     0,     0,  1161,  1162,  1163,     0,  3490,  3491,  1166,
    1167,  1168,  1169,    86,    87,    88,   403,    90,    91,    92,
     404,     0,   405,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   406,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   407,   408,     0,     0,     0,   409,   410,     0,
       0,     0,     0,   411,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,   413,     0,   414,   415,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,  1158,     0,     0,     0,     0,     0,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,   427,
       0,     0,     0,     0,     0,     0,     0,   428,   429,     0,
     430,     0,   431,   432,   433,   135,   136,     0,   138,   139,
       0,   434,   435,   436,   437,   438,     0,     0,   439,   440,
     441,   140,   442,     0,   443,  1159,   445,   446,   144,     0,
       0,   447,   448,   449,   450,     0,   451,   452,     0,   453,
     454,   455,   456,   457,   458,     0,   459,   460,   461,     0,
     462,     0,     0,     0,     0,     0,     0,     0,     0,   463,
     464,   465,   466,   467,   468,   154,   155,   469,     0,   470,
       0,   471,   472,   473,   474,   475,     0,   476,   477,   478,
       0,     0,   479,   480,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,   491,   492,   164,
     493,   494,   166,     0,  1160,     0,   496,   168,   497,     0,
     498,     0,   499,     0,     0,     0,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   507,   508,   509,
       0,   510,   511,   512,     0,   513,   514,   515,   516,   517,
     518,     0,   519,     0,   175,     0,   520,   521,   522,     0,
     177,     0,   178,     0,   523,     0,     0,   524,     0,   525,
     526,   527,   528,   529,   530,     0,   182,     0,   531,     0,
       0,   532,   533,   534,     0,     0,   535,   536,   537,   538,
     539,   540,   541,   542,   543,   544,   545,   546,   547,   189,
       0,   191,   548,   549,   550,   551,   552,   553,   554,   192,
     555,     0,   556,   557,     0,   558,     0,   195,   559,   196,
     560,   561,     0,     0,   562,     0,     0,   563,   564,   565,
       0,     0,   197,     0,     0,     0,   201,   566,   567,   568,
     569,   570,   571,     0,   572,   202,   573,   203,   574,   575,
     576,     0,   577,   578,   579,   580,   581,   582,   583,   205,
     584,   585,   586,     0,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,     0,   599,   600,
     213,   601,   602,   603,   604,   605,   606,   607,   608,     0,
     609,   610,   611,   612,   613,     0,   614,   217,   615,   616,
       0,   617,   220,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,   628,     0,   629,   630,     0,
     631,   632,   633,   634,   635,   636,     0,   224,   225,     0,
       0,   638,   226,   639,   227,     0,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,   235,     0,   655,     0,   656,
     657,   658,     0,     0,   659,     0,     0,   660,   661,   662,
     663,   664,   238,   239,   240,   241,   242,   243,   244,   245,
     665,   666,   667,     0,     0,     0,  1161,  1162,  1163,     0,
    1164,  1165,  1166,  1167,  1168,  1169,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,  1158,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,  1234,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,  1235,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,     0,     0,     0,  1161,
    1162,  1163,     0,  1164,  1165,  1166,  1167,  1168,  1169,    86,
      87,    88,   403,    90,    91,    92,   404,     0,   405,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   406,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   407,   408,
       0,     0,     0,   409,   410,     0,     0,     0,     0,   411,
       0,     0,     0,     0,     0,     0,     0,     0,   412,     0,
     413,     0,   414,   415,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,  1158,     0,
       0,     0,     0,     0,   417,   418,   419,   420,   421,   422,
     423,   424,     0,   425,   426,   427,     0,     0,     0,     0,
       0,     0,     0,   428,   429,     0,   430,     0,   431,   432,
     433,   135,   136,     0,   138,   139,     0,   434,   435,   436,
     437,   438,     0,     0,   439,   440,   441,   140,   442,     0,
     443,  1285,   445,   446,   144,     0,     0,   447,   448,   449,
     450,     0,   451,   452,     0,   453,   454,   455,   456,   457,
     458,     0,   459,   460,   461,     0,   462,     0,     0,     0,
       0,     0,     0,     0,     0,   463,   464,   465,   466,   467,
     468,   154,   155,   469,     0,   470,     0,   471,   472,   473,
     474,   475,     0,   476,   477,   478,     0,     0,   479,   480,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,   491,   492,   164,   493,   494,   166,     0,
    1286,     0,   496,   168,   497,     0,   498,     0,   499,     0,
       0,     0,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,   507,   508,  1287,     0,   510,   511,   512,
       0,   513,   514,   515,   516,   517,   518,     0,   519,     0,
     175,     0,   520,   521,   522,     0,   177,     0,   178,     0,
     523,     0,     0,   524,     0,   525,   526,   527,   528,   529,
     530,     0,   182,     0,   531,     0,     0,   532,   533,   534,
       0,     0,   535,   536,   537,   538,   539,   540,   541,   542,
     543,   544,   545,   546,   547,   189,     0,   191,   548,   549,
     550,   551,   552,   553,   554,   192,   555,     0,   556,   557,
       0,   558,     0,   195,   559,   196,   560,   561,     0,     0,
     562,     0,     0,   563,   564,   565,     0,     0,   197,     0,
       0,     0,   201,   566,   567,   568,   569,   570,   571,     0,
     572,   202,   573,   203,   574,   575,   576,     0,   577,   578,
     579,   580,   581,   582,   583,   205,   584,   585,   586,     0,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,   599,   600,   213,   601,   602,   603,
     604,   605,   606,   607,   608,     0,   609,   610,   611,   612,
     613,     0,   614,   217,   615,   616,     0,   617,   220,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,   628,     0,   629,   630,     0,   631,   632,   633,   634,
     635,   636,     0,   224,   225,     0,     0,   638,   226,   639,
     227,     0,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,   235,     0,   655,     0,   656,   657,   658,     0,     0,
     659,     0,     0,   660,   661,   662,   663,   664,   238,   239,
     240,   241,   242,   243,   244,   245,   665,   666,   667,     0,
       0,     0,  1161,  1162,  1163,     0,  1164,  1165,  1166,  1167,
    1168,  1169,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,  1158,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,  1767,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,  1768,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,     0,     0,   562,     0,     0,   563,   564,   565,     0,
       0,   197,     0,     0,     0,   201,   566,   567,   568,   569,
     570,   571,     0,   572,   202,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,   205,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,     0,   599,   600,   213,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,     0,   614,   217,   615,   616,     0,
     617,   220,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,   224,   225,     0,     0,
     638,   226,   639,   227,     0,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,   235,     0,   655,     0,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,   239,   240,   241,   242,   243,   244,   245,   665,
     666,   667,     0,     0,     0,  1161,  1162,  1163,     0,  1164,
    1165,  1166,  1167,  1168,  1169,    86,    87,    88,   403,    90,
      91,    92,   404,     0,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   406,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   407,   408,     0,     0,     0,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,  1158,     0,     0,     0,     0,     0,
     417,   418,   419,   420,   421,   422,   423,   424,     0,   425,
     426,   427,     0,     0,     0,     0,     0,     0,     0,   428,
     429,     0,   430,     0,   431,   432,   433,   135,   136,     0,
     138,   139,     0,   434,   435,   436,   437,   438,     0,     0,
     439,   440,   441,   140,   442,     0,   443,   444,   445,   446,
     144,     0,     0,   447,   448,   449,   450,     0,   451,   452,
       0,   453,   454,   455,   456,   457,   458,     0,   459,   460,
     461,     0,   462,     0,     0,     0,     0,     0,     0,     0,
       0,   463,   464,   465,   466,   467,   468,   154,   155,   469,
       0,   470,     0,   471,   472,   473,   474,   475,     0,   476,
     477,   478,     0,     0,   479,   480,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,   491,
     492,   164,   493,   494,   166,     0,   495,     0,   496,   168,
     497,     0,   498,     0,   499,     0,     0,     0,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   507,
     508,   509,     0,   510,   511,   512,     0,   513,   514,   515,
     516,   517,   518,     0,   519,     0,   175,     0,   520,   521,
     522,     0,   177,     0,   178,     0,   523,     0,     0,   524,
       0,   525,   526,   527,   528,   529,   530,     0,   182,     0,
     531,     0,     0,   532,   533,   534,     0,     0,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
     547,   189,     0,   191,   548,   549,   550,   551,   552,   553,
     554,   192,   555,     0,   556,   557,     0,   558,     0,   195,
     559,   196,   560,   561,     0,     0,   562,     0,     0,   563,
     564,   565,     0,     0,   197,     0,     0,     0,   201,   566,
     567,   568,   569,   570,   571,     0,   572,   202,   573,   203,
     574,   575,   576,     0,   577,   578,   579,   580,   581,   582,
     583,   205,   584,   585,   586,     0,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
     599,   600,   213,   601,   602,   603,   604,   605,   606,   607,
     608,     0,   609,   610,   611,   612,   613,     0,   614,   217,
     615,   616,     0,   617,   220,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,   628,     0,   629,
     630,     0,   631,   632,   633,   634,   635,   636,     0,   224,
     225,     0,     0,   638,   226,   639,   227,     0,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,   235,     0,   655,
       0,   656,   657,   658,     0,     0,   659,     0,     0,   660,
     661,   662,   663,   664,   238,   239,   240,   241,   242,   243,
     244,   245,   665,   666,   667,     0,     0,     0,  1161,  1162,
    1163,     0,  1164,  1165,  1166,  1167,  1168,  1169,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,  1158,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,  4212,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,     0,     0,
       0,  1161,  1162,  1163,     0,  1164,  1165,  1166,  1167,  1168,
    1169,   704,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,   711,   425,   426,   427,   712,
     713,   714,   715,   716,   717,   718,   428,   429,   719,   430,
     133,   431,   432,   433,   135,   136,   137,   138,   139,   720,
     434,   435,   436,   437,   438,   721,   722,   439,   440,   723,
     140,   442,   724,   443,   444,   445,   446,   144,   725,   726,
     447,   448,   449,   450,   147,   451,   727,   728,   453,   454,
     455,   456,   457,   458,   729,   459,   460,   461,   150,   462,
     730,   731,   732,   733,   151,   734,   735,   736,   463,   464,
     465,   466,   467,   468,   154,   155,   469,   737,   470,   738,
     471,   472,   473,   474,   475,   739,   476,   477,   478,   740,
     741,   479,   480,   481,   482,   483,   742,   484,   485,   486,
     743,   487,   488,   744,   489,   490,   491,   492,   164,   493,
     494,   166,   745,   495,   746,   496,   168,   497,   747,   498,
     748,   499,   169,   749,   170,   500,   501,   502,   750,   503,
     172,   751,   504,   752,   505,   506,   507,   508,   509,   173,
     510,   511,   512,   753,   513,   514,   515,   516,   517,   518,
     754,   519,   174,   175,   755,   520,   521,   522,   756,   177,
     757,   178,   758,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,   759,   182,   183,   531,   184,   760,
     532,   533,   534,   761,   762,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,   190,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
     763,   556,   557,   194,   558,   764,   195,   559,   196,   560,
     561,   765,   766,   562,   767,   768,   563,   564,   565,   769,
     770,   197,   198,   199,   200,   201,   566,   567,   568,   569,
     570,   571,   771,   572,   202,   573,   203,   574,   575,   576,
     772,   577,   578,   579,   580,   581,   582,   583,   205,   584,
     585,   586,   773,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,   774,   597,   598,   211,   599,   600,   213,
     601,   602,   603,   604,   605,   606,   607,   608,   775,   609,
     610,   611,   612,   613,   776,   614,   217,   615,   616,   219,
     617,   220,   777,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,   628,   778,   629,   630,   779,   631,
     632,   633,   634,   635,   636,   780,   224,   225,   781,   782,
     638,   226,   639,   227,   783,   640,   641,   642,   643,   644,
     645,   784,   785,   646,   647,   648,   649,   786,   787,   650,
     651,   652,   653,   788,   235,   789,   655,   236,   656,   657,
     658,   790,   791,   659,   792,   793,   660,   661,   662,   663,
     664,   238,   239,   240,   241,   242,   243,   244,   245,   665,
     666,   667,   704,    86,    87,    88,   403,    90,    91,    92,
     404,  2153,   405,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   705,   104,   105,   406,   706,     0,   107,   108,
     109,   110,   707,   708,   112,   113,   114,   115,     0,   116,
     709,   710,   407,   408,     0,     0,     0,   409,   410,     0,
       0,     0,     0,   411,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,   413,     0,   414,   415,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,   427,
       0,     0,     0,     0,     0,     0,     0,   428,   429,     0,
     430,   133,   431,   432,   433,     0,  1784,   137,  1785,  1786,
       0,   434,   435,   436,   437,   438,     0,     0,   439,   440,
    1787,  1788,   442,     0,   443,   444,   445,   446,     0,     0,
       0,   447,   448,   449,   450,   147,   451,   452,     0,   453,
     454,   455,   456,   457,   458,     0,   459,   460,   461,   150,
     462,     0,     0,     0,     0,   151,     0,     0,     0,   463,
     464,   465,   466,   467,   468,  1789,  1790,   469,     0,   470,
       0,   471,   472,   473,   474,   475,     0,   476,   477,   478,
       0,     0,   479,   480,  1419,   482,   483,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,   491,   492,     0,
     493,   494,     0,     0,   495,     0,   496,  1791,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,     0,     0,   504,     0,   505,   506,   507,   508,   509,
     173,   510,   511,   512,     0,   513,   514,   515,   516,   517,
     518,     0,   519,   174,     0,     0,   520,   521,   522,  1425,
    1792,     0,  1793,     0,   523,   179,   180,   524,   181,   525,
     526,   527,   528,   529,   530,     0,     0,   183,   531,   184,
       0,   532,   533,   534,     0,     0,   535,   536,   537,   538,
     539,   540,   541,   542,   543,   544,   545,   546,   547,  1794,
     190,  1795,   548,   549,   550,   551,   552,   553,   554,     0,
     555,     0,   556,   557,   194,   558,     0,     0,   559,  1796,
     560,   561,     0,     0,   562,     0,     0,   563,   564,   565,
       0,     0,     0,   198,   199,   200,     0,   566,   567,   568,
     569,   570,   571,     0,   572,     0,   573,     0,   574,   575,
     576,     0,   577,   578,   579,   580,   581,   582,   583,  1797,
     584,   585,   586,     0,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   211,   599,   600,
       0,   601,   602,   603,   604,   605,   606,   607,   608,     0,
     609,   610,   611,   612,   613,     0,   614,  1798,   615,   616,
     219,   617,  1799,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,     0,   628,     0,   629,   630,     0,
     631,   632,   633,   634,   635,   636,     0,  1800,  1801,     0,
       0,   638,     0,   639,     0,     0,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,     0,  1802,     0,   655,   236,   656,
     657,   658,     0,     0,   659,     0,     0,   660,   661,   662,
     663,   664,     0,     0,     0,     0,     0,     0,     0,     0,
     665,   666,   667,     0,    86,    87,    88,   403,    90,    91,
      92,   404,  2255,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   406,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,     0,   431,   432,   433,   135,   136,     0,   138,
     139,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,   144,
       0,     0,   447,   448,   449,   450,     0,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
       0,   462,     0,     0,     0,     0,     0,     0,     0,     0,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,   166,     0,   495,     0,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   507,   508,
     509,     0,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,     0,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,     0,     0,   524,     0,
     525,   526,   527,   528,   529,   530,     0,   182,     0,   531,
       0,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,     0,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,     0,   558,     0,   195,   559,
     196,   560,   561,     0,     0,   562,     0,     0,   563,   564,
     565,     0,     0,   197,     0,     0,     0,   201,   566,   567,
     568,   569,   570,   571,     0,   572,   202,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
     205,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   213,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,     0,   614,   217,   615,
     616,     0,   617,   220,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,   224,   225,
       0,     0,   638,   226,   639,   227,     0,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,   235,     0,   655,     0,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,   239,   240,   241,   242,   243,   244,
     245,   665,   666,   667,     0,    86,    87,    88,   403,    90,
      91,    92,   404,  1051,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   406,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   407,   408,     0,     0,     0,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     417,   418,   419,   420,   421,   422,   423,   424,     0,   425,
     426,   427,     0,     0,     0,     0,     0,     0,     0,   428,
     429,     0,   430,     0,   431,   432,   433,   135,   136,     0,
     138,   139,     0,   434,   435,   436,   437,   438,     0,     0,
     439,   440,   441,   140,   442,     0,   443,   444,   445,   446,
     144,     0,     0,   447,   448,   449,   450,     0,   451,   452,
       0,   453,   454,   455,   456,   457,   458,     0,   459,   460,
     461,     0,   462,     0,     0,     0,     0,     0,     0,     0,
       0,   463,   464,   465,   466,   467,   468,   154,   155,   469,
       0,   470,     0,   471,   472,   473,   474,   475,     0,   476,
     477,   478,     0,     0,   479,   480,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,   491,
     492,   164,   493,   494,   166,     0,   495,     0,   496,   168,
     497,     0,   498,     0,   499,     0,     0,     0,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   507,
     508,   509,     0,   510,   511,   512,     0,   513,   514,   515,
     516,   517,   518,     0,   519,     0,   175,     0,   520,   521,
     522,     0,   177,     0,   178,     0,   523,     0,     0,   524,
       0,   525,   526,   527,   528,   529,   530,     0,   182,     0,
     531,     0,     0,   532,   533,   534,     0,     0,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
     547,   189,     0,   191,   548,   549,   550,   551,   552,   553,
     554,   192,   555,     0,   556,   557,     0,   558,     0,   195,
     559,   196,   560,   561,     0,     0,   562,     0,     0,   563,
     564,   565,     0,     0,   197,     0,     0,     0,   201,   566,
     567,   568,   569,   570,   571,     0,   572,   202,   573,   203,
     574,   575,   576,     0,   577,   578,   579,   580,   581,   582,
     583,   205,   584,   585,   586,     0,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
     599,   600,   213,   601,   602,   603,   604,   605,   606,   607,
     608,     0,   609,   610,   611,   612,   613,     0,   614,   217,
     615,   616,     0,   617,   220,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,   628,     0,   629,
     630,     0,   631,   632,   633,   634,   635,   636,     0,   224,
     225,     0,     0,   638,   226,   639,   227,     0,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,   235,     0,   655,
       0,   656,   657,   658,     0,     0,   659,     0,     0,   660,
     661,   662,   663,   664,   238,   239,   240,   241,   242,   243,
     244,   245,   665,   666,   667,     0,    86,    87,    88,   403,
      90,    91,    92,   404,  4091,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,  2140,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,  1927,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,  1928,     0,   562,  1929,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,  1930,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,     0,     0,     0,     0,
       0,     0,     0,   962,  1595,    86,    87,    88,   403,    90,
      91,    92,   404,     0,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   406,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   407,   408,     0,     0,     0,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,   416,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,     0,     0,     0,    45,     0,     0,     0,     0,
     417,   418,   419,   420,   421,   422,   423,   424,     0,   425,
     426,   427,     0,     0,     0,     0,     0,     0,     0,   428,
     429,     0,   430,     0,   431,   432,   433,   135,   136,     0,
     138,   139,     0,   434,   435,   436,   437,   438,     0,     0,
     439,   440,   441,   140,   442,     0,   443,   444,   445,   446,
     144,     0,     0,   447,   448,   449,   450,     0,   451,   452,
       0,   453,   454,   455,   456,   457,   458,     0,   459,   460,
     461,     0,   462,     0,     0,     0,     0,     0,     0,     0,
       0,   463,   464,   465,   466,   467,   468,   154,   155,   469,
    2146,   470,     0,   471,   472,   473,   474,   475,     0,   476,
     477,   478,     0,     0,   479,   480,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,   491,
     492,   164,   493,   494,   166,  1927,   495,     0,   496,   168,
     497,     0,   498,     0,   499,     0,     0,     0,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   507,
     508,   509,     0,   510,   511,   512,     0,   513,   514,   515,
     516,   517,   518,     0,   519,     0,   175,     0,   520,   521,
     522,     0,   177,     0,   178,     0,   523,     0,     0,   524,
       0,   525,   526,   527,   528,   529,   530,     0,   182,     0,
     531,     0,     0,   532,   533,   534,     0,     0,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
     547,   189,     0,   191,   548,   549,   550,   551,   552,   553,
     554,   192,   555,     0,   556,   557,     0,   558,     0,   195,
     559,   196,   560,   561,  1928,     0,   562,  1929,     0,   563,
     564,   565,     0,     0,   197,     0,     0,     0,   201,   566,
     567,   568,   569,   570,   571,     0,   572,   202,   573,   203,
     574,   575,   576,     0,   577,   578,   579,   580,   581,   582,
     583,   205,   584,   585,   586,     0,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
     599,   600,   213,   601,   602,   603,   604,   605,   606,   607,
     608,     0,   609,   610,   611,   612,   613,     0,   614,   217,
     615,   616,     0,   617,   220,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,   628,     0,   629,
     630,     0,   631,   632,   633,   634,   635,   636,     0,   224,
     225,     0,     0,   638,   226,   639,   227,  1930,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,   235,     0,   655,
       0,   656,   657,   658,     0,     0,   659,     0,     0,   660,
     661,   662,   663,   664,   238,   239,   240,   241,   242,   243,
     244,   245,   665,   666,   667,     0,     0,     0,     0,     0,
       0,     0,   962,  1595,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   406,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
     416,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,     0,     0,     0,    45,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,     0,   431,   432,   433,   135,   136,     0,   138,
     139,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,   144,
       0,     0,   447,   448,   449,   450,     0,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
       0,   462,     0,     0,     0,     0,     0,     0,     0,     0,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,   166,  1927,   495,     0,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   507,   508,
     509,     0,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,     0,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,     0,     0,   524,     0,
     525,   526,   527,   528,   529,   530,     0,   182,     0,   531,
       0,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,     0,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,     0,   558,     0,   195,   559,
     196,   560,   561,  1928,     0,   562,  1929,     0,   563,   564,
     565,     0,     0,   197,     0,     0,     0,   201,   566,   567,
     568,   569,   570,   571,     0,   572,   202,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
     205,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   213,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,     0,   614,   217,   615,
     616,     0,   617,   220,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,   224,   225,
       0,     0,   638,   226,   639,   227,  1930,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,   235,     0,   655,     0,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,   239,   240,   241,   242,   243,   244,
     245,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,   962,  1595,    86,    87,    88,   403,    90,    91,    92,
     404,     0,   405,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   406,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   407,   408,     0,     0,     0,   409,   410,     0,
       0,     0,     0,   411,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,   413,     0,   414,   415,    35,   416,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,    45,     0,     0,     0,     0,   417,   951,
     419,   420,   421,   422,   423,   424,   952,   425,   426,   427,
       0,     0,     0,     0,     0,     0,     0,   428,   429,     0,
     430,     0,   953,   432,   433,   135,   136,     0,   138,   139,
       0,   434,   435,   436,   437,   438,     0,     0,   439,   440,
     441,   140,   442,     0,   443,   444,   445,   446,   144,     0,
       0,   447,   448,   449,   450,     0,   451,   452,     0,   453,
     454,   455,   456,   457,   458,     0,   459,   460,   461,     0,
     462,     0,     0,     0,     0,     0,     0,     0,     0,   463,
     464,   465,   466,   467,   468,   154,   155,   469,     0,   470,
       0,   471,   472,   473,   474,   475,     0,   476,   477,   478,
       0,     0,   479,   480,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,   491,   492,   164,
     493,   494,   166,     0,   495,     0,   954,   168,   497,     0,
     498,     0,   955,     0,   956,     0,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   507,   508,   509,
       0,   510,   511,   512,   957,   513,   514,   515,   516,   517,
     518,     0,   519,     0,   175,     0,   520,   521,   522,     0,
     177,     0,   178,     0,   523,     0,     0,   524,     0,   525,
     526,   527,   958,   529,   530,     0,   182,     0,   531,     0,
       0,   532,   533,   534,     0,     0,   535,   536,   537,   538,
     539,   540,   541,   542,   543,   544,   545,   546,   547,   189,
       0,   191,   959,   549,   550,   551,   552,   553,   554,   192,
     555,     0,   556,   557,     0,   558,     0,   195,   559,   196,
     560,   561,     0,     0,   562,     0,     0,   563,   564,   565,
       0,     0,   197,     0,     0,     0,   201,   566,   567,   568,
     569,   570,   571,     0,   572,   202,   573,   203,   574,   575,
     576,     0,   960,   578,   579,   580,   581,   582,   583,   205,
     584,   585,   586,     0,   587,   961,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,     0,   599,   600,
     213,   601,   602,   603,   604,   605,   606,   607,   608,     0,
     609,   610,   611,   612,   613,     0,   614,   217,   615,   616,
       0,   617,   220,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,   628,     0,   629,   630,     0,
     631,   632,   633,   634,   635,   636,     0,   224,   225,     0,
       0,   638,   226,   639,   227,     0,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,   235,     0,   655,     0,   656,
     657,   658,     0,     0,   659,     0,     0,   660,   661,   662,
     663,   664,   238,   239,   240,   241,   242,   243,   244,   245,
     665,   666,   667,     0,     0,     0,     0,     0,     0,     0,
     962,   963,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,   417,   951,   419,
     420,   421,   422,   423,   424,   952,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   985,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   954,   168,   497,     0,   498,
       0,   986,     0,   956,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,   957,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   958,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   959,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,     0,     0,   562,     0,     0,   563,   564,   565,     0,
       0,   197,     0,     0,     0,   201,   566,   567,   568,   569,
     570,   571,     0,   572,   202,   573,   203,   574,   575,   576,
       0,   960,   578,   579,   580,   581,   582,   583,   205,   584,
     585,   586,     0,   587,   961,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,     0,   599,   600,   213,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,     0,   614,   217,   615,   616,     0,
     617,   220,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,   224,   225,     0,     0,
     638,   226,   639,   227,     0,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,   235,     0,   655,     0,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,   239,   240,   241,   242,   243,   244,   245,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,   962,
     963,    86,    87,    88,   403,    90,    91,    92,   404,     0,
     405,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   406,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     407,   408,     0,     0,     0,   409,   410,     0,     0,     0,
       0,   411,     0,     0,     0,     0,     0,     0,     0,     0,
     412,     0,   413,     0,   414,   415,    35,   416,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,   417,   418,   419,   420,
     421,   422,   423,   424,  1335,   425,   426,   427,     0,     0,
       0,     0,     0,     0,     0,   428,   429,     0,   430,     0,
     431,   432,   433,   135,   136,     0,   138,   139,     0,   434,
     435,   436,   437,   438,     0,     0,   439,   440,   441,   140,
     442,     0,   443,   444,   445,   446,   144,     0,     0,   447,
     448,   449,   450,     0,   451,   452,     0,   453,   454,   455,
     456,   457,   458,     0,   459,   460,   461,     0,   462,     0,
       0,     0,     0,     0,     0,     0,     0,   463,   464,   465,
     466,   467,   468,   154,   155,   469,     0,   470,     0,   471,
     472,   473,   474,   475,     0,   476,   477,   478,     0,     0,
     479,   480,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,     0,   489,   490,   491,   492,   164,   493,   494,
     166,     0,   495,     0,   496,   168,   497,     0,   498,     0,
     499,     0,   956,     0,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   507,   508,   509,     0,   510,
     511,   512,   957,   513,   514,   515,   516,   517,   518,     0,
     519,     0,   175,     0,   520,   521,   522,     0,   177,     0,
     178,     0,   523,     0,     0,   524,     0,   525,   526,   527,
     528,   529,   530,     0,   182,     0,   531,     0,     0,   532,
     533,   534,     0,     0,   535,   536,   537,   538,   539,   540,
     541,   542,   543,   544,   545,   546,   547,   189,     0,   191,
     548,   549,   550,   551,   552,   553,   554,   192,   555,     0,
     556,   557,     0,   558,     0,   195,   559,   196,   560,   561,
       0,     0,   562,     0,     0,   563,   564,   565,     0,     0,
     197,     0,     0,     0,   201,   566,   567,   568,   569,   570,
     571,     0,   572,   202,   573,   203,   574,   575,   576,     0,
     577,   578,   579,   580,   581,   582,   583,   205,   584,   585,
     586,     0,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,     0,   599,   600,   213,   601,
     602,   603,   604,   605,   606,   607,   608,     0,   609,   610,
     611,   612,   613,     0,   614,   217,   615,   616,     0,   617,
     220,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,   628,     0,   629,   630,     0,   631,   632,
     633,   634,   635,   636,     0,   224,   225,     0,     0,   638,
     226,   639,   227,     0,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,   235,     0,   655,     0,   656,   657,   658,
       0,     0,   659,     0,     0,   660,   661,   662,   663,   664,
     238,   239,   240,   241,   242,   243,   244,   245,   665,   666,
     667,     0,     0,     0,     0,     0,     0,     0,   962,   963,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   406,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,  1340,   425,   426,   427,     0,     0,     0,
       0,     0,     0,     0,   428,   429,     0,   430,     0,   431,
     432,   433,   135,   136,     0,   138,   139,     0,   434,   435,
     436,   437,   438,     0,     0,   439,   440,   441,   140,   442,
       0,   443,   444,   445,   446,   144,     0,     0,   447,   448,
     449,   450,     0,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,     0,   462,     0,     0,
       0,     0,     0,     0,     0,     0,   463,   464,   465,   466,
     467,   468,   154,   155,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,   164,   493,   494,   166,
       0,   495,     0,   496,   168,   497,     0,   498,     0,   499,
       0,   956,     0,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,   507,   508,   509,     0,   510,   511,
     512,   957,   513,   514,   515,   516,   517,   518,     0,   519,
       0,   175,     0,   520,   521,   522,     0,   177,     0,   178,
       0,   523,     0,     0,   524,     0,   525,   526,   527,   528,
     529,   530,     0,   182,     0,   531,     0,     0,   532,   533,
     534,     0,     0,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   189,     0,   191,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,     0,   558,     0,   195,   559,   196,   560,   561,     0,
       0,   562,     0,     0,   563,   564,   565,     0,     0,   197,
       0,     0,     0,   201,   566,   567,   568,   569,   570,   571,
       0,   572,   202,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,   205,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   213,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,     0,   614,   217,   615,   616,     0,   617,   220,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,   224,   225,     0,     0,   638,   226,
     639,   227,     0,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,   235,     0,   655,     0,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,   238,
     239,   240,   241,   242,   243,   244,   245,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,   962,   963,    86,
      87,    88,   403,    90,    91,    92,   404,     0,   405,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   406,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   407,   408,
       0,     0,     0,   409,   410,     0,     0,     0,     0,   411,
       0,     0,     0,     0,     0,     0,     0,     0,   412,     0,
     413,     0,   414,   415,    35,   416,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   417,   418,   419,   420,   421,   422,
     423,   424,     0,   425,   426,   427,     0,     0,     0,     0,
       0,     0,     0,   428,   429,     0,   430,     0,   431,   432,
     433,   135,   136,     0,   138,   139,     0,   434,   435,   436,
     437,   438,     0,     0,   439,   440,   441,   140,   442,     0,
     443,   444,   445,   446,   144,     0,     0,   447,   448,   449,
     450,     0,   451,   452,     0,   453,   454,   455,   456,   457,
     458,     0,   459,   460,   461,     0,   462,     0,     0,     0,
       0,     0,     0,     0,     0,   463,   464,   465,   466,   467,
     468,   154,   155,   469,   689,   470,     0,   471,   472,   473,
     474,   475,     0,   476,   477,   478,     0,     0,   479,   480,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,   491,   492,   164,   493,   494,   166,     0,
     495,     0,   496,   168,   497,     0,   498,     0,   499,     0,
       0,     0,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,   507,   508,   509,     0,   510,   511,   512,
       0,   513,   514,   515,   516,   517,   518,     0,   519,     0,
     175,     0,   520,   521,   522,     0,   177,     0,   178,     0,
     523,     0,     0,   524,     0,   525,   526,   527,   528,   529,
     530,     0,   182,     0,   531,     0,     0,   532,   533,   534,
       0,     0,   535,   536,   537,   538,   539,   540,   541,   542,
     543,   544,   545,   546,   547,   189,     0,   191,   548,   549,
     550,   551,   552,   553,   554,   192,   555,     0,   556,   557,
       0,   558,     0,   195,   559,   196,   560,   561,     0,     0,
     562,     0,     0,   563,   564,   565,     0,     0,   197,     0,
       0,     0,   201,   566,   567,   568,   569,   570,   571,     0,
     572,   202,   573,   203,   574,   575,   576,     0,   577,   578,
     579,   580,   581,   582,   583,   205,   584,   585,   586,     0,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,   599,   600,   213,   601,   602,   603,
     604,   605,   606,   607,   608,     0,   609,   610,   611,   612,
     613,     0,   614,   217,   615,   616,     0,   617,   220,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,   628,     0,   629,   630,     0,   631,   632,   633,   634,
     635,   636,     0,   224,   225,  1500,     0,   638,   226,   639,
     227,     0,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,   235,     0,   655,     0,   656,   657,   658,     0,     0,
     659,     0,     0,   660,   661,   662,   663,   664,   238,   239,
     240,   241,   242,   243,   244,   245,   665,   666,   667,     0,
       0,  1023,  1501,    86,    87,    88,   403,    90,    91,    92,
     404,  1024,   405,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   406,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   407,   408,     0,     0,     0,   409,   410,     0,
       0,     0,     0,   411,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,   413,     0,   414,   415,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,   427,
       0,     0,     0,     0,     0,     0,     0,   428,   429,     0,
     430,     0,   431,   432,   433,   135,   136,     0,   138,   139,
       0,   434,   435,   436,   437,   438,     0,     0,  1025,   440,
    1000,   140,   442,     0,   443,   444,   445,   446,   144,     0,
       0,   447,   448,   449,   450,     0,   451,  1026,     0,  1027,
     454,   455,   456,   457,   458,     0,   459,   460,   461,     0,
     462,     0,     0,     0,     0,     0,     0,     0,     0,   463,
     464,   465,   466,   467,   468,   154,   155,   469,     0,   470,
       0,   471,   472,   473,   474,   475,     0,   476,   477,   478,
       0,     0,   479,   480,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,   491,   492,   164,
     493,   494,   166,     0,   495,     0,   496,   168,   497,     0,
     498,     0,   499,     0,     0,     0,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   507,   508,   509,
       0,   510,   511,   512,     0,   513,   514,   515,   516,   517,
     518,     0,   519,     0,   175,     0,   520,   521,   522,     0,
     177,     0,   178,     0,   523,     0,     0,   524,     0,   525,
     526,   527,   528,   529,   530,     0,   182,     0,   531,     0,
       0,   532,   533,  1028,     0,     0,   535,   536,   537,   538,
     539,   540,   541,   542,   543,   544,   545,   546,  1029,   189,
       0,   191,   548,   549,   550,   551,   552,   553,   554,   192,
     555,     0,   556,   557,     0,   558,     0,   195,   559,   196,
     560,   561,     0,     0,   562,     0,     0,   563,   564,   565,
       0,     0,   197,     0,     0,     0,   201,   566,   567,   568,
     569,   570,   571,     0,   572,   202,   573,   203,   574,   575,
     576,     0,   577,   578,   579,   580,   581,   582,   583,   205,
     584,   585,   586,     0,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,     0,  1030,   600,
     213,   601,   602,   603,  1031,   605,   606,   607,   608,     0,
     609,   610,   611,   612,  1032,     0,   614,   217,   615,   616,
       0,   617,   220,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,   628,     0,   629,   630,     0,
     631,   632,   633,   634,   635,   636,     0,  1033,   225,     0,
       0,  1034,   226,   639,   227,     0,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,  1004,   235,     0,   655,     0,   656,
     657,   658,     0,     0,   659,     0,     0,   660,   661,   662,
     663,  1035,   238,   239,   240,   241,   242,   243,   244,   245,
     665,   666,   667,   704,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   705,   104,   105,   406,   706,     0,   107,
     108,   109,   110,   707,   708,   112,   113,   114,   115,     0,
     116,   709,   710,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,   711,   425,   426,
     427,   712,   713,   714,   715,   716,   717,   718,   428,   429,
     719,   430,   133,   431,   432,   433,   135,   136,   137,   138,
     139,   720,   434,   435,   436,   437,   438,   721,   722,   439,
     440,   723,   140,   442,   724,   443,   444,   445,   446,   144,
     725,   726,   447,   448,   449,   450,   147,   451,   727,   728,
     453,   454,   455,   456,   457,   458,   729,   459,   460,   461,
     150,   462,   730,   731,   732,   733,   151,   734,   735,   736,
     463,   464,   465,   466,   467,   468,   154,   155,   469,   737,
     470,   738,   471,   472,   473,   474,   475,   739,   476,   477,
     478,   740,   741,   479,   480,   481,   482,   483,   742,   484,
     485,   486,   743,   487,   488,   744,   489,   490,   491,   492,
     164,   493,   494,   166,   745,   495,   746,   496,   168,   497,
     747,   498,   748,   499,   169,   749,   170,   500,   501,   502,
     750,   503,   172,   751,   504,   752,   505,   506,   507,   508,
     509,   173,   510,   511,   512,   753,   513,   514,   515,   516,
     517,   518,   754,   519,   174,   175,   755,   520,   521,   522,
     756,   177,   757,   178,   758,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,   759,   182,   183,   531,
     184,   760,   532,   533,   534,   761,   762,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,   190,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,   763,   556,   557,   194,   558,   764,   195,   559,
     196,   560,   561,   765,   766,   562,   767,   768,   563,   564,
     565,   769,   770,   197,   198,   199,   200,   201,   566,   567,
     568,   569,   570,   571,   771,   572,   202,   573,   203,   574,
     575,   576,   772,   577,   578,   579,   580,   581,   582,   583,
     205,   584,   585,   586,   773,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,   774,   597,   598,   211,   599,
     600,   213,   601,   602,   603,   604,   605,   606,   607,   608,
     775,   609,   610,   611,   612,   613,   776,   614,   217,   615,
     616,   219,   617,   220,   777,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,   628,   778,   629,   630,
     779,   631,   632,   633,   634,   635,   636,   780,   224,   225,
     781,   782,   638,   226,   639,   227,   783,   640,   641,   642,
     643,   644,   645,   784,   785,   646,   647,   648,   649,   786,
     787,   650,   651,   652,   653,   788,   235,   789,   655,   236,
     656,   657,   658,   790,   791,   659,   792,   793,   660,   661,
     662,   663,   664,   238,   239,   240,   241,   242,   243,   244,
     245,   665,   666,   667,   704,    86,    87,    88,   403,    90,
      91,    92,   404,     0,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   705,   104,   105,   406,   706,     0,
     107,   108,   109,   110,   707,   708,   112,   113,   114,   115,
       0,   116,   709,   710,   407,   408,     0,     0,     0,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     417,   418,   419,   420,  2960,   422,   423,   424,   711,   425,
     426,   427,   712,   713,   714,   715,   716,   717,   718,   428,
     429,   719,   430,   133,   431,   432,   433,   135,   136,   137,
     138,   139,   720,   434,   435,   436,   437,   438,   721,   722,
     439,   440,   723,   140,   442,   724,   443,   444,   445,   446,
     144,   725,   726,   447,   448,   449,   450,   147,   451,   727,
     728,   453,   454,   455,   456,   457,   458,   729,   459,   460,
     461,   150,   462,   730,   731,   732,   733,   151,   734,   735,
     736,   463,   464,   465,   466,   467,   468,   154,   155,   469,
     737,   470,   738,   471,   472,   473,   474,   475,   739,   476,
     477,   478,   740,   741,   479,   480,   481,  2961,   483,   742,
     484,   485,   486,   743,   487,   488,   744,   489,   490,   491,
     492,   164,   493,   494,   166,   745,   495,   746,   496,   168,
     497,   747,   498,   748,   499,   169,   749,   170,   500,   501,
     502,   750,   503,   172,   751,   504,   752,   505,   506,   507,
     508,   509,   173,   510,   511,   512,   753,   513,   514,   515,
     516,   517,   518,   754,   519,   174,   175,   755,   520,   521,
     522,   756,   177,   757,   178,   758,   523,   179,   180,   524,
     181,   525,   526,   527,   528,   529,   530,   759,   182,   183,
     531,   184,   760,   532,   533,   534,   761,   762,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
     547,   189,   190,   191,   548,   549,   550,   551,   552,   553,
     554,   192,   555,   763,   556,   557,   194,   558,   764,   195,
     559,   196,   560,   561,   765,   766,   562,   767,   768,   563,
     564,   565,   769,   770,   197,   198,   199,   200,   201,   566,
     567,   568,   569,   570,   571,   771,   572,   202,   573,   203,
     574,   575,   576,   772,   577,   578,   579,   580,   581,   582,
     583,   205,   584,   585,   586,   773,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,   774,   597,   598,   211,
     599,   600,   213,   601,   602,   603,   604,   605,   606,   607,
     608,   775,   609,   610,   611,   612,   613,   776,  2962,   217,
     615,   616,   219,   617,   220,   777,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,   628,   778,   629,
     630,   779,   631,   632,   633,   634,   635,   636,   780,   224,
     225,   781,   782,   638,   226,   639,   227,   783,   640,   641,
     642,   643,   644,   645,   784,   785,   646,   647,   648,   649,
     786,   787,   650,   651,   652,   653,   788,   235,   789,   655,
     236,   656,   657,   658,   790,   791,   659,   792,   793,   660,
     661,   662,   663,   664,   238,   239,   240,   241,   242,   243,
     244,   245,   665,   666,   667,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,   135,   136,
     137,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,     0,     0,     0,   151,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,   182,
     183,   531,   184,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,   190,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,   194,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,   198,   199,   200,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,   219,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,   236,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,   704,    86,    87,    88,
     403,    90,    91,    92,   404,     0,   405,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   705,   104,   105,   406,
     706,     0,   107,   108,   109,   110,   707,   708,   112,   113,
     114,   115,     0,   116,   709,   710,   407,   408,     0,     0,
       0,   409,   410,     0,     0,     0,     0,   411,     0,     0,
       0,     0,     0,     0,     0,     0,   412,     0,   413,     0,
     414,   415,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   417,   418,   419,   420,   421,   422,   423,   424,
       0,   425,   426,   427,     0,     0,     0,     0,     0,     0,
       0,   428,   429,     0,   430,   133,   431,   432,   433,   135,
     136,   137,   138,   139,     0,   434,   435,   436,   437,   438,
       0,     0,   439,   440,   441,   140,   442,     0,   443,   444,
     445,   446,   144,     0,     0,   447,   448,   449,   450,   147,
     451,   452,     0,   453,   454,   455,   456,   457,   458,     0,
     459,   460,   461,   150,   462,     0,     0,     0,     0,   151,
       0,     0,     0,   463,   464,   465,   466,   467,   468,   154,
     155,   469,     0,   470,     0,   471,   472,   473,   474,   475,
       0,   476,   477,   478,     0,     0,   479,   480,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,     0,   489,
     490,   491,   492,   164,   493,   494,   166,     0,   495,     0,
     496,   168,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   507,   508,  1272,   173,   510,   511,   512,     0,   513,
     514,   515,   516,   517,   518,     0,   519,   174,   175,     0,
     520,   521,   522,     0,   177,     0,   178,     0,   523,   179,
     180,   524,   181,   525,   526,   527,   528,   529,   530,     0,
     182,   183,   531,   184,     0,   532,   533,   534,     0,     0,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   189,   190,   191,   548,   549,   550,   551,
     552,   553,   554,   192,   555,     0,   556,   557,   194,   558,
       0,   195,   559,   196,   560,   561,     0,     0,   562,     0,
       0,   563,   564,   565,     0,     0,   197,   198,   199,   200,
     201,   566,   567,   568,   569,   570,   571,     0,   572,   202,
     573,   203,   574,   575,   576,     0,   577,   578,   579,   580,
     581,   582,   583,   205,   584,   585,   586,     0,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   211,   599,   600,   213,   601,   602,   603,   604,   605,
     606,   607,   608,     0,   609,   610,   611,   612,   613,     0,
     614,   217,   615,   616,   219,   617,   220,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,   628,
       0,   629,   630,     0,   631,   632,   633,   634,   635,   636,
       0,   224,   225,     0,     0,   638,   226,   639,   227,     0,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,   235,
       0,   655,   236,   656,   657,   658,     0,     0,   659,     0,
       0,   660,   661,   662,   663,   664,   238,   239,   240,   241,
     242,   243,   244,   245,   665,   666,   667,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,   136,   137,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,     0,     0,     0,
     151,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,  1280,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,   182,   183,   531,   184,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,   190,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,   194,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,   198,   199,
     200,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,   219,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,   704,    86,
      87,    88,   403,    90,    91,    92,   404,     0,   405,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   705,   104,
     105,   406,   706,     0,   107,   108,   109,   110,   707,   708,
     112,   113,   114,   115,     0,   116,   709,   710,   407,   408,
       0,     0,     0,   409,   410,     0,     0,     0,     0,   411,
       0,     0,     0,     0,     0,     0,     0,     0,   412,     0,
     413,     0,   414,   415,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   417,   418,   419,   420,   421,   422,
     423,   424,     0,   425,   426,   427,     0,     0,     0,     0,
       0,     0,     0,   428,   429,     0,   430,   133,   431,   432,
     433,     0,  1784,   137,  1785,  1786,     0,   434,   435,   436,
     437,   438,     0,     0,   439,   440,  1787,  1788,   442,     0,
     443,   444,   445,   446,     0,     0,     0,   447,   448,   449,
     450,   147,   451,   452,     0,   453,   454,   455,   456,   457,
     458,     0,   459,   460,   461,   150,   462,     0,     0,     0,
       0,   151,     0,     0,     0,   463,   464,   465,   466,   467,
     468,  1789,  1790,   469,     0,   470,     0,   471,   472,   473,
     474,   475,     0,   476,   477,   478,     0,     0,   479,   480,
    1419,   482,   483,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,   491,   492,     0,   493,   494,     0,     0,
     495,     0,   496,  1791,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,     0,     0,   504,
       0,   505,   506,   507,   508,   509,   173,   510,   511,   512,
    2304,   513,   514,   515,   516,   517,   518,     0,   519,   174,
    2305,     0,   520,   521,   522,  1425,  1792,     0,  1793,     0,
     523,   179,   180,   524,   181,   525,   526,   527,   528,   529,
     530,     0,     0,   183,   531,   184,     0,   532,   533,   534,
       0,     0,   535,   536,   537,   538,   539,   540,   541,   542,
     543,   544,   545,   546,   547,  1794,   190,  1795,   548,   549,
     550,   551,   552,   553,   554,     0,   555,     0,   556,   557,
     194,   558,     0,     0,   559,  1796,   560,   561,     0,     0,
     562,     0,     0,   563,   564,   565,     0,     0,  2306,   198,
     199,   200,     0,   566,   567,   568,   569,   570,   571,     0,
     572,     0,   573,     0,   574,   575,   576,     0,   577,   578,
     579,   580,   581,   582,   583,  1797,   584,   585,   586,     0,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   211,   599,   600,     0,   601,   602,   603,
     604,   605,   606,   607,   608,     0,   609,   610,   611,   612,
     613,     0,   614,  2307,   615,   616,   219,   617,  1799,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
       0,   628,     0,   629,   630,     0,   631,   632,   633,   634,
     635,   636,     0,  1800,  1801,     0,     0,   638,     0,   639,
       0,     0,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
       0,  1802,  2308,   655,   236,   656,   657,   658,     0,     0,
     659,     0,     0,   660,   661,   662,   663,   664,     0,     0,
       0,     0,     0,     0,     0,     0,   665,   666,   667,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,     0,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,     0,  1784,   137,  1785,  1786,     0,   434,   435,
     436,   437,   438,     0,     0,   439,   440,  1787,  1788,   442,
       0,   443,   444,   445,   446,     0,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,     0,
       0,     0,   151,     0,     0,     0,   463,   464,   465,   466,
     467,   468,  1789,  1790,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,     0,   493,   494,     0,
       0,   495,     0,   496,  1791,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,     0,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,     0,     0,   520,   521,   522,  1425,  1792,     0,  1793,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,     0,   183,   531,   184,     0,   532,   533,
     534,     0,     0,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1794,   190,  1795,   548,
     549,   550,   551,   552,   553,   554,     0,   555,     0,   556,
     557,   194,   558,  2296,     0,   559,  1796,   560,   561,     0,
       0,   562,     0,     0,   563,   564,   565,     0,     0,     0,
     198,   199,   200,     0,   566,   567,   568,   569,   570,   571,
       0,   572,     0,   573,     0,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,  1797,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,     0,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,     0,   614,  2307,   615,   616,   219,   617,  1799,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,     0,   628,     0,   629,   630,  3580,   631,   632,   633,
     634,   635,   636,     0,  1800,  1801,     0,     0,   638,     0,
     639,     0,     0,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,     0,  1802,     0,   655,   236,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,     0,
       0,     0,     0,     0,     0,     0,     0,   665,   666,   667,
     704,    86,    87,    88,   403,    90,    91,    92,   404,     0,
     405,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     705,   104,   105,   406,   706,     0,   107,   108,   109,   110,
     707,   708,   112,   113,   114,   115,     0,   116,   709,   710,
     407,   408,     0,     0,     0,   409,   410,     0,     0,     0,
       0,   411,     0,     0,     0,     0,     0,     0,     0,     0,
     412,     0,   413,     0,   414,   415,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   417,   418,   419,   420,
     421,   422,   423,   424,     0,   425,   426,   427,     0,     0,
       0,     0,     0,     0,     0,   428,   429,     0,   430,   133,
     431,   432,   433,     0,  1784,   137,  1785,  1786,     0,   434,
     435,   436,   437,   438,     0,     0,   439,   440,  1787,  1788,
     442,     0,   443,   444,   445,   446,     0,     0,     0,   447,
     448,   449,   450,   147,   451,   452,     0,   453,   454,   455,
     456,   457,   458,     0,   459,   460,   461,   150,   462,     0,
       0,     0,     0,   151,     0,     0,     0,   463,   464,   465,
     466,   467,   468,  1789,  1790,   469,     0,   470,     0,   471,
     472,   473,   474,   475,     0,   476,   477,   478,     0,     0,
     479,   480,  1419,   482,   483,     0,   484,   485,   486,     0,
     487,   488,     0,   489,   490,   491,   492,     0,   493,   494,
       0,     0,   495,     0,   496,  1791,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,     0,
       0,   504,     0,   505,   506,   507,   508,   509,   173,   510,
     511,   512,     0,   513,   514,   515,   516,   517,   518,     0,
     519,   174,     0,     0,   520,   521,   522,  1425,  1792,     0,
    1793,     0,   523,   179,   180,   524,   181,   525,   526,   527,
     528,   529,   530,     0,     0,   183,   531,   184,     0,   532,
     533,   534,     0,     0,   535,   536,   537,   538,   539,   540,
     541,   542,   543,   544,   545,   546,   547,  1794,   190,  1795,
     548,   549,   550,   551,   552,   553,   554,  2349,   555,     0,
     556,   557,   194,   558,     0,     0,   559,  1796,   560,   561,
       0,     0,   562,     0,     0,   563,   564,   565,     0,     0,
       0,   198,   199,   200,     0,   566,   567,   568,   569,   570,
     571,     0,   572,     0,   573,     0,   574,   575,   576,     0,
     577,   578,   579,   580,   581,   582,   583,  1797,   584,   585,
     586,     0,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   211,   599,   600,     0,   601,
     602,   603,   604,   605,   606,   607,   608,     0,   609,   610,
     611,   612,   613,     0,   614,  1798,   615,   616,   219,   617,
    1799,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,     0,   628,     0,   629,   630,     0,   631,   632,
     633,   634,   635,   636,     0,  1800,  1801,     0,     0,   638,
       0,   639,     0,     0,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,     0,  1802,     0,   655,   236,   656,   657,   658,
       0,     0,   659,     0,     0,   660,   661,   662,   663,   664,
       0,     0,     0,     0,     0,     0,     0,     0,   665,   666,
     667,   704,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,     0,  1784,   137,  1785,  1786,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,  1787,
    1788,   442,     0,   443,   444,   445,   446,     0,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
       0,     0,     0,     0,   151,     0,     0,     0,   463,   464,
     465,   466,   467,   468,  1789,  1790,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,     0,   493,
     494,     0,     0,   495,     0,   496,  1791,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
       0,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,     0,     0,   520,   521,   522,  1425,  1792,
       0,  1793,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,     0,   183,   531,   184,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1794,   190,
    1795,   548,   549,   550,   551,   552,   553,   554,  3427,   555,
       0,   556,   557,   194,   558,     0,     0,   559,  1796,   560,
     561,     0,     0,   562,     0,     0,   563,   564,   565,     0,
       0,     0,   198,   199,   200,     0,   566,   567,   568,   569,
     570,   571,     0,   572,     0,   573,     0,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,  1797,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   211,   599,   600,     0,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,     0,   614,  1798,   615,   616,   219,
     617,  1799,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,     0,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,  1800,  1801,     0,     0,
     638,     0,   639,     0,     0,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,     0,  1802,     0,   655,   236,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,     0,     0,     0,     0,     0,     0,     0,     0,   665,
     666,   667,   704,    86,    87,    88,   403,    90,    91,    92,
     404,     0,   405,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   705,   104,   105,   406,   706,     0,   107,   108,
     109,   110,   707,   708,   112,   113,   114,   115,     0,   116,
     709,   710,   407,   408,     0,     0,     0,   409,   410,     0,
       0,     0,     0,   411,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,   413,     0,   414,   415,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,   427,
       0,     0,     0,     0,     0,     0,     0,   428,   429,     0,
     430,   133,   431,   432,   433,     0,  1784,   137,  1785,  1786,
       0,   434,   435,   436,   437,   438,     0,     0,   439,   440,
    1787,  1788,   442,     0,   443,   444,   445,   446,     0,     0,
       0,   447,   448,   449,   450,   147,   451,   452,     0,   453,
     454,   455,   456,   457,   458,     0,   459,   460,   461,   150,
     462,     0,     0,     0,     0,   151,     0,     0,     0,   463,
     464,   465,   466,   467,   468,  1789,  1790,   469,     0,   470,
       0,   471,   472,   473,   474,   475,     0,   476,   477,   478,
       0,     0,   479,   480,  1419,   482,   483,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,   491,   492,     0,
     493,   494,     0,     0,   495,     0,   496,  1791,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,     0,     0,   504,     0,   505,   506,   507,   508,   509,
     173,   510,   511,   512,     0,   513,   514,   515,   516,   517,
     518,     0,   519,   174,     0,     0,   520,   521,   522,  1425,
    1792,     0,  1793,     0,   523,   179,   180,   524,   181,   525,
     526,   527,   528,   529,   530,     0,     0,   183,   531,   184,
       0,   532,   533,   534,     0,     0,   535,   536,   537,   538,
     539,   540,   541,   542,   543,   544,   545,   546,   547,  1794,
     190,  1795,   548,   549,   550,   551,   552,   553,   554,     0,
     555,     0,   556,   557,   194,   558,     0,     0,   559,  1796,
     560,   561,     0,     0,   562,     0,     0,   563,   564,   565,
       0,     0,     0,   198,   199,   200,     0,   566,   567,   568,
     569,   570,   571,     0,   572,     0,   573,     0,   574,   575,
     576,     0,   577,   578,   579,   580,   581,   582,   583,  1797,
     584,   585,   586,     0,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   211,   599,   600,
       0,   601,   602,   603,   604,   605,   606,   607,   608,     0,
     609,   610,   611,   612,   613,     0,   614,  1798,   615,   616,
     219,   617,  1799,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,     0,   628,     0,   629,   630,     0,
     631,   632,   633,   634,   635,   636,     0,  1800,  1801,     0,
       0,   638,     0,   639,     0,     0,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,     0,  1802,     0,   655,   236,   656,
     657,   658,     0,     0,   659,     0,     0,   660,   661,   662,
     663,   664,     0,     0,     0,     0,     0,     0,     0,     0,
     665,   666,   667,   704,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   705,   104,   105,   406,   706,     0,   107,
     108,   109,   110,   707,   708,   112,   113,   114,   115,     0,
     116,   709,   710,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,     0,  1784,   137,  1785,
    1786,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,  1787,  1788,   442,     0,   443,   444,   445,   446,     0,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,     0,     0,     0,     0,   151,     0,     0,     0,
     463,   464,   465,   466,   467,   468,  1789,  1790,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,  1419,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
       0,   493,   494,     0,     0,   495,     0,   496,  1791,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,     0,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,     0,     0,   520,   521,   522,
    1425,  1792,     0,  1793,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,     0,   183,   531,
     184,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
    1794,   190,  1795,   548,   549,   550,   551,   552,   553,   554,
       0,   555,     0,   556,   557,   194,   558,     0,     0,   559,
    1796,   560,   561,     0,     0,   562,     0,     0,   563,   564,
     565,     0,     0,     0,   198,   199,   200,     0,   566,   567,
     568,   569,   570,   571,     0,   572,     0,   573,     0,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
    1797,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   211,   599,
     600,     0,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,     0,   614,  2307,   615,
     616,   219,   617,  1799,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,     0,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,  1800,  1801,
       0,     0,   638,     0,   639,     0,     0,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,     0,  1802,     0,   655,   236,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,     0,     0,     0,     0,     0,     0,     0,
       0,   665,   666,   667,   704,    86,    87,    88,   403,    90,
      91,    92,   404,     0,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   705,   104,   105,   406,   706,     0,
     107,   108,   109,   110,   707,   708,   112,   113,   114,   115,
       0,   116,   709,   710,   407,   408,     0,     0,     0,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     417,   418,   419,   420,   421,   422,   423,   424,     0,   425,
     426,   427,     0,     0,     0,     0,     0,     0,     0,   428,
     429,     0,   430,   133,   431,   432,   433,     0,  1784,   137,
    1785,  1786,     0,   434,   435,   436,   437,   438,     0,     0,
     439,   440,  1787,  1788,   442,     0,   443,   444,   445,   446,
       0,     0,     0,   447,   448,   449,   450,   147,   451,   452,
       0,   453,   454,   455,   456,   457,   458,     0,   459,   460,
     461,   150,   462,     0,     0,     0,     0,   151,     0,     0,
       0,   463,   464,   465,   466,   467,   468,  1789,  1790,   469,
       0,   470,     0,   471,   472,   473,   474,   475,     0,   476,
     477,   478,     0,     0,   479,   480,  1419,   482,   483,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,   491,
     492,     0,   493,   494,     0,     0,   495,     0,   496,  1791,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,     0,     0,   504,     0,   505,   506,   507,
     508,   509,   173,   510,   511,   512,     0,   513,   514,   515,
     516,   517,   518,     0,   519,   174,     0,     0,   520,   521,
     522,  1425,  1792,     0,  1793,     0,   523,   179,   180,   524,
     181,   525,   526,   527,   528,   529,   530,     0,     0,   183,
     531,   184,     0,   532,   533,   534,     0,     0,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
     547,  1794,   190,  1795,   548,   549,   550,   551,   552,   553,
     554,     0,   555,     0,   556,   557,   194,   558,     0,     0,
     559,  1796,   560,   561,     0,     0,   562,     0,     0,   563,
     564,   565,     0,     0,     0,   198,   199,   200,     0,   566,
     567,   568,   569,   570,   571,     0,   572,     0,   573,     0,
     574,   575,   576,     0,   577,   578,   579,   580,   581,   582,
     583,  1797,   584,   585,   586,     0,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   211,
     599,   600,     0,   601,   602,   603,   604,   605,   606,   607,
     608,     0,   609,   610,   611,   612,   613,     0,   614,     0,
     615,   616,   219,   617,  1799,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,     0,   628,     0,   629,
     630,     0,   631,   632,   633,   634,   635,   636,     0,  1800,
    1801,     0,     0,   638,     0,   639,     0,     0,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,     0,  1802,     0,   655,
     236,   656,   657,   658,     0,     0,   659,     0,     0,   660,
     661,   662,   663,   664,     0,     0,     0,     0,     0,     0,
       0,     0,   665,   666,   667,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,     0,     0,
     137,     0,     0,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,     0,     0,   442,     0,   443,   444,   445,
     446,     0,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,     0,     0,     0,   151,     0,
       0,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,     0,   493,   494,     0,     0,   495,     0,   496,
       0,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,     0,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,     0,     0,   520,
     521,   522,     0,     0,     0,     0,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,     0,
     183,   531,   184,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,     0,   190,     0,   548,   549,   550,   551,   552,
     553,   554,     0,   555,     0,   556,   557,   194,   558,     0,
       0,   559,     0,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,     0,   198,   199,   200,     0,
     566,   567,   568,   569,   570,   571,     0,   572,     0,   573,
       0,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,     0,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
       0,   615,   616,   219,   617,     0,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,     0,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
       0,     0,     0,     0,   638,     0,   639,     0,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,     0,     0,     0,
     655,   236,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,     0,     0,     0,     0,     0,
       0,     0,     0,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,   711,
     425,   426,   427,   712,   713,   714,   715,   716,   717,   718,
     428,   429,   719,   430,   133,   431,   432,   433,   135,   136,
     137,   138,   139,   720,   434,   435,   436,   437,   438,   721,
     722,   439,   440,     0,   140,   442,   724,   443,   444,   445,
     446,   144,   725,   726,   447,   448,   449,   450,   147,   451,
     727,   728,   453,   454,   455,   456,   457,   458,   729,   459,
     460,   461,   150,   462,     0,   731,   732,   733,   151,   734,
     735,   736,   463,   464,   465,   466,     0,   468,   154,   155,
     469,   737,   470,   738,   471,   472,   473,   474,   475,   739,
     476,   477,   478,   740,   741,   479,   480,   481,   482,   483,
     742,   484,   485,   486,   743,   487,   488,   744,   489,   490,
     491,   492,   164,   493,   494,   166,   745,   495,   746,   496,
     168,   497,   747,   498,   748,   499,   169,   749,   170,   500,
     501,   502,   750,   503,   172,   751,   504,   752,   505,   506,
       0,   508,   509,   173,   510,   511,   512,   753,   513,   514,
     515,   516,   517,   518,   754,   519,   174,   175,     0,   520,
     521,   522,     0,   177,   757,   178,   758,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,   759,   182,
     183,   531,   184,   760,   532,   533,   534,   761,   762,   535,
     536,   537,   538,   539,   540,     0,   542,   543,     0,   545,
     546,   547,   189,   190,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,   763,   556,   557,   194,   558,   764,
     195,   559,   196,   560,   561,   765,   766,   562,   767,   768,
     563,   564,   565,   769,   770,   197,   198,   199,   200,   201,
     566,   567,   568,   569,   570,   571,   771,   572,   202,   573,
     203,   574,   575,   576,   772,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,   773,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,   774,   597,   598,
     211,   599,   600,   213,   601,   602,   603,   604,   605,   606,
       0,   608,   775,   609,   610,   611,   612,   613,   776,   614,
     217,   615,   616,   219,   617,   220,   777,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,   778,
     629,   630,   779,   631,   632,   633,   634,   635,   636,   780,
     224,   225,     0,   782,   638,   226,   639,   227,   783,   640,
     641,   642,   643,   644,   645,     0,   785,   646,   647,   648,
     649,   786,   787,   650,   651,   652,   653,     0,   235,   789,
     655,   236,   656,   657,   658,   790,   791,   659,   792,   793,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,     0,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,  1927,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,  1928,     0,   562,  1929,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,  1930,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1397,  4460,     0,    45,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,   637,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,  1111,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,  2126,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,  2275,   443,   444,   445,
     446,   144,     0,  2319,   447,   448,   449,   450,     0,   451,
     452,  2276,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,  2320,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,  2278,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,  2279,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,  2280,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,  2275,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,  2276,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,  2320,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,  2278,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,  3081,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,  2279,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,  2280,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,  1013,   423,   424,   971,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,   972,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,  1014,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,   973,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,   974,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1907,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,   971,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,   972,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,  2853,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,   973,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,   974,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,  2275,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,  2276,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,  2320,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,  2278,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,  2279,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,  2280,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,   687,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,   688,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,   689,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,   971,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,   972,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,   973,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,   974,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,   888,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,   889,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   890,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,  1963,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,  1964,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,  1965,   499,     0,     0,     0,  1966,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,  1967,  1968,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,  1969,   605,   606,
     607,   608,     0,  1970,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,  1971,   631,  1972,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,   972,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,   973,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,   974,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,   130,   131,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,  1325,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,  1952,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,  2237,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,  2745,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,  2746,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,  2747,   631,   632,  2748,   634,  2749,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,   696,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,   689,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,   843,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,  1263,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,  2394,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,  2395,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,   130,   131,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,  2897,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,  2898,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,  2909,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,  2910,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     894,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   935,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   989,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,  1044,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,  1503,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,  1859,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,  1952,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,  2237,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,  3118,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,  3131,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,  3173,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,  3886,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,  3888,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,  3890,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,  4046,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   997,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,   999,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,  1000,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
       0,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,  1001,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1002,   225,     0,     0,  1003,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,  1004,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,  1038,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,  1000,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
       0,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,  1039,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1040,   225,     0,     0,  1041,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,  1004,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,  1060,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,  1183,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,  1246,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1277,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1282,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1290,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1292,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1294,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1296,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1299,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1301,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,  1302,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1305,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,  1514,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,  1025,   440,  1000,   140,  1515,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
       0,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,  1029,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,  1030,   600,   213,   601,   602,   603,  1031,   605,   606,
     607,   608,     0,   609,   610,   611,   612,  1507,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1033,   225,     0,     0,  1034,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,  1004,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,  1035,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,  1537,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,     0,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,  1637,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1885,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1887,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,  2002,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  2526,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  2900,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  2902,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,  1025,   440,  1000,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
       0,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,  1029,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,  1030,   600,   213,   601,   602,   603,  1031,   605,   606,
     607,   608,     0,   609,   610,   611,   612,  1507,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1033,   225,     0,     0,  1034,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,  1004,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,  1035,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,  1025,   440,  1000,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
       0,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,  1029,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,  1030,   600,   213,   601,   602,   603,  1031,   605,   606,
     607,   608,     0,   609,   610,   611,   612,  1507,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,  2266,   633,   634,   635,   636,     0,
    1033,   225,     0,     0,  1034,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,  1004,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,  1035,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,  1025,   440,  1000,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
       0,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,  1029,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,  1030,   600,   213,   601,   602,   603,  2300,   605,   606,
     607,   608,     0,   609,   610,   611,   612,  1507,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1033,   225,     0,     0,  1034,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,  1004,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,  1035,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,     0,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
       0,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,     0,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,     0,
      90,    91,    92,     0,     0,     0,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,     0,     0,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115, -2161,   116,   117,   118,     0,     0,     0,     0,     0,
     121,   122,     0,     0,     0,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,   125,     0,   126,
     127,    35,     0,   398,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   133,     0,     0,     0,   135,   136,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
       0,   144,     0,     0,     0,     0,     0,     0,   147,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   150,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   154,   155,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   162,     0,     0,     0,     0,
       0,     0,   164,     0,     0,   166,     0,     0,     0,     0,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   172,     0,     0,     0,     0,     0,
       0,     0,     0,   173,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   174,   175,     0,     0,
       0,     0,     0,   177,     0,   178,     0,     0,   179,   180,
       0,   181,     0,     0,     0,     0,     0,     0,     0,   182,
     183,     0,   184,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   189,   190,   191,     0,     0,     0,     0,     0,
       0,     0,   192,     0,     0,     0,     0,   194,     0,     0,
     195,     0,   196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   197,   198,   199,   200,   201,
       0,     0,     0,     0,     0,     0,     0,     0,   202,     0,
     203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   205,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     211,     0,     0,   213,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     217,     0,     0,   219,     0,   220,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     224,   225,     0,     0,     0,   226,     0,   227,     0,     0,
       0,     0,     0,     0,     0,   230,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   235,     0,
       0,   236,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   238,   239,   240,   241,   242,
     243,   244,   245,    86,    87,    88,     0,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,     0,     0,     0,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115, -2162,   116,
     117,   118,     0,     0,     0,     0,     0,   121,   122,     0,
       0,     0,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,   124,     0,   125,     0,   126,   127,    35,     0,
    1106,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,     0,     0,   135,   136,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,   144,     0,
       0,     0,     0,     0,     0,   147,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   150,
       0,     0,     0,     0,     0,   151,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   154,   155,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   162,     0,     0,     0,     0,     0,     0,   164,
       0,     0,   166,     0,     0,     0,     0,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   172,     0,     0,     0,     0,     0,     0,     0,     0,
     173,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   174,   175,     0,     0,     0,     0,     0,
     177,     0,   178,     0,     0,   179,   180,     0,   181,     0,
       0,     0,     0,     0,     0,     0,   182,   183,     0,   184,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   189,
     190,   191,     0,     0,     0,     0,     0,     0,     0,   192,
       0,     0,     0,     0,   194,     0,     0,   195,     0,   196,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   197,   198,   199,   200,   201,     0,     0,     0,
       0,     0,     0,     0,     0,   202,     0,   203,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   211,     0,     0,
     213,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   217,     0,     0,
     219,     0,   220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   222,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   224,   225,     0,
       0,     0,   226,     0,   227,     0,     0,     0,     0,     0,
       0,     0,   230,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   235,     0,     0,   236,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   238,   239,   240,   241,   242,   243,   244,   245,
      86,    87,    88,     0,    90,    91,    92,     0,     0,     0,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,     0,     0,     0,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   115,     0,   116,   117,   118,     0,
       0,     0,     0,     0,   121,   122,     0,     0,     0,     0,
     123,     0,     0,     0,     0,     0,     0,     0,     0,   124,
       0,   125,     0,   126,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   133,     0,
       0,     0,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   140,     0,
       0,     0,     0,     0,     0,   144,     0,     0,     0,     0,
       0,     0,   147,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   150,     0,     0,     0,
       0,     0,   151,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   154,   155,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   162,
       0,     0,     0,     0,     0,     0,   164,     0,     0,   166,
       0,     0,     0,     0,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   172,     0,
       0,     0,     0,     0,     0,     0,     0,   173,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     174,   175,     0,     0,     0,     0,     0,   177,     0,   178,
       0,     0,   179,   180,     0,   181,     0,     0,     0,     0,
       0,     0,     0,   182,   183,     0,   184,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   189,   190,   191,     0,
       0,     0,     0,     0,     0,     0,   192,     0,     0,     0,
       0,   194,     0,     0,   195,     0,   196,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   197,
     198,   199,   200,   201,     0,     0,     0,     0,     0,     0,
       0,     0,   202,     0,   203,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   205,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   211,     0,     0,   213,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   217,     0,     0,   219,     0,   220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   222,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   224,   225,     0,     0,     0,   226,
       0,   227,     0,     0,     0,     0,     0,     0,     0,   230,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   235,     0,     0,   236,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   238,
     239,   240,   241,   242,   243,   244,   245,    86,    87,    88,
       0,    90,    91,    92,     0,     0,     0,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,     0,
       0,     0,   107,   108,   109,   110,     0,   111,   112,   113,
     114,   115,     0,   116,   117,   118,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   133,     0,     0,     0,   135,
     136,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,     0,     0,     0,     0,
       0,     0,   144,     0,     0,     0,     0,     0,     0,   147,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   150,     0,     0,     0,     0,     0,   151,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   154,
     155,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   162,     0,     0,     0,
       0,     0,     0,   164,     0,     0,   166,     0,     0,     0,
       0,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   172,     0,     0,     0,     0,
       0,     0,     0,     0,   173,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   174,   175,     0,
       0,     0,     0,     0,   177,     0,   178,     0,     0,   179,
     180,     0,   181,     0,     0,     0,     0,     0,     0,     0,
     182,   183,     0,   184,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   189,   190,   191,     0,     0,     0,     0,
       0,     0,     0,   192,     0,     0,     0,     0,   194,     0,
       0,   195,     0,   196,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   197,   198,   199,   200,
     201,     0,     0,     0,     0,     0,     0,     0,     0,   202,
       0,   203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   205,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   211,     0,     0,   213,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   217,     0,     0,   219,     0,   220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   222,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   224,   225,     0,     0,     0,   226,     0,   227,     0,
       0,     0,     0,     0,     0,     0,   230,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   235,
       0,     0,   236,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   238,   239,   240,   241,
     242,   243,   244,   245,    86,    87,    88,     0,    90,    91,
      92,     0,     0,     0,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,     0,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   133,     0,     0,     0,   135,   136,   137,   138,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,   144,
       0,     0,     0,     0,     0,     0,   147,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     150,     0,     0,     0,     0,     0,   151,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   154,   155,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     164,     0,     0,   166,     0,     0,     0,     0,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   172,     0,     0,     0,     0,     0,     0,     0,
       0,   173,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   174,   175,     0,     0,     0,     0,
       0,   177,     0,   178,     0,     0,   179,   180,     0,   181,
       0,     0,     0,     0,     0,     0,     0,   182,   183,     0,
     184,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,     0,     0,     0,     0,     0,
     192,     0,     0,     0,     0,   194,     0,     0,   195,     0,
     196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   197,   198,   199,   200,   201,     0,     0,
       0,     0,     0,     0,     0,     0,   202,     0,   203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     205,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   211,     0,
       0,   213,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   217,     0,
       0,   219,     0,   220,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   222,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   224,   225,
       0,     0,     0,   226,     0,   227,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   235,     0,     0,   236,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   238,   239,   240,   241,   242,   243,   244,
     245
};

static const short yycheck[] =
{
       2,    78,   210,   167,    78,    78,    78,   246,  1119,   351,
    1027,  1329,   153,   973,   974,    78,  1281,  1694,   978,   117,
    1379,   864,  1075,   228,   188,     2,  1288,  1077,  1360,  1909,
    1798,  1656,  1191,  1148,  1174,  1966,   117,   152,  1142,  1245,
     165,   149,  1392,   171,  1184,   826,  1916,  1534,   702,  1814,
    1417,  1418,  1034,  1446,    78,  1728,  2312,  1734,  1735,  1684,
      84,     2,  2115,   204,   162,   901,   366,  2893,  1870,  1436,
     223,  1847,   915,   366,  2622,  2759,  2510,  3105,  1558,   232,
    2348,   162,   210,   864,  1833,   148,  1226,    89,   132,  1222,
     353,  1231,  1589,  1590,  1591,   339,  1833,  1833,  1238,  2661,
    2662,  2960,   165,  2962,  2666,  1678,  2162,  1247,  1119,  2005,
    2596,  1833,  2312,  2313,  1833,   160,    96,  1833,  1042,  1319,
      94,  3025,   703,  2515,  2516,  3351,   106,  3059,  2757,  1905,
     940,   216,   230,  3380,   915,  2173,  1320,  1722,  2521,  3528,
    1273,  3581,  1684,  2705,  2706,  2428,  1584,  1585,  1311,   230,
     152,  1646,   167,    78,  3767,  3059,  1643,   159,   132,    84,
    1407,  1408,   142,   353,  1342,  3591,  2211,  3555,  1149,  2168,
    1114,  1115,    30,   188,  1072,  1153,   156,  1072,   152,   153,
      21,    14,    10,   246,   186,  1432,  2454,  3773,    72,   163,
     932,  3244,   117,   108,  1030,  3039,  3040,  3041,  3042,  3043,
    3044,   127,   134,  1184,    37,  2250,    88,   127,   120,  2254,
      72,   810,  2755,  2756,    84,    72,    75,    76,    77,    78,
     143,    99,    72,    82,    86,   181,   167,   112,  3503,    86,
     204,    81,   205,   180,   888,  3559,    86,   162,    78,    72,
     227,    88,    75,    76,    77,    78,    95,   188,    81,    82,
      83,    84,   266,    86,    75,    76,    77,    78,   147,   112,
    1220,    82,  4155,  1463,    99,  2533,   113,  2535,    93,    78,
    3608,   106,  3610,     8,   233,    84,    11,    12,  4149,   327,
     102,   358,    78,   227,   358,   358,   358,    22,    23,    24,
     353,    26,    27,   185,    78,   358,    31,    32,    33,   154,
     266,    38,  2067,    40,   127,   230,    78,   334,   117,   227,
     221,   247,   324,   134,    75,    76,    77,    78,   329,  1759,
     185,    82,   181,   222,   219,    78,    99,    75,    76,    77,
      78,   227,   158,   106,    82,  1100,   140,    75,    76,    77,
      78,   183,   366,   356,    82,    75,    76,    77,    78,   198,
     117,   218,    82,   162,    75,    76,    77,    78,    99,  1518,
     228,    82,   117,  1206,   314,   106,   295,   469,   227,   298,
    1024,    75,    76,    77,    78,   267,   341,   401,    82,   227,
      99,    89,    97,   816,  1488,   210,    94,  3776,    96,   822,
     432,  1176,  2437,  1178,   325,   162,  1320,   328,   106,   174,
    1185,   116,   267,   505,   134,   370,   232,   162,  1801,   359,
     305,    75,    76,    77,    78,  1855,   283,    89,    82,   188,
     853,   230,  1789,  1790,   132,  1206,    72,    88,   402,  1796,
      75,    76,    77,    78,   142,    81,   186,    82,   349,   174,
      86,   366,   209,   127,   152,   153,    88,   489,   156,   216,
     376,   218,   113,    25,   502,   163,   376,    95,   200,   167,
      29,   390,   473,   230,    75,    76,    77,    78,  1304,   347,
      25,    82,   905,   372,   193,   230,   401,   319,   505,   912,
     188,    75,    76,    77,    78,  3417,  4357,   434,    82,   502,
     502,   505,   341,  1329,   186,   167,   204,   210,  4111,  3923,
    1765,    75,    76,    77,    78,  4048,  4049,  1769,    82,   432,
    3899,   117,   812,  3417,   432,   502,   188,    88,   358,   812,
     375,  1331,   637,   327,   471,    75,    76,    77,    78,   502,
    3374,   401,    82,   489,   419,  1116,  1117,  1136,   504,  2307,
    1787,  1788,   113,  4436,   685,   686,   505,   425,  1795,   427,
     399,   373,  3941,   376,   443,    95,   162,   366,   383,  1483,
     198,   505,   358,   385,  1329,   300,   419,  1309,   260,   505,
     502,   406,   456,   432,   358,  1781,   401,   314,  1718,   505,
    1720,    75,    76,    77,    78,   505,   358,   502,    82,  2857,
     502,  3134,   401,  3868,  3869,  3870,  3871,  3872,  1757,  1523,
    1524,  2600,  3926,   209,  3657,   358,  4219,   268,   269,   505,
     216,   452,   218,    78,   436,   350,   498,  2290,  2105,    84,
    3958,   396,  2109,  4209,   230,  3309,  1958,    85,   456,  1762,
     489,   493,   494,   406,   502,   637,   493,   494,  1778,   460,
     502,  4136,   500,   493,   494,   504,    75,    76,    77,    78,
     505,   498,   117,    82,  4043,   496,   317,   505,   198,  1603,
     493,   494,  4051,   637,  3226,   406,  3510,  3229,  3230,  3231,
    3232,  3233,  3234,  3235,  3236,  3237,  3238,  1575,  1514,   832,
    1575,   502,   505,   452,  2884,  3314,  2886,  3121,   401,   258,
     262,  3125,   376,   324,   402,  2694,   181,   162,   942,  1677,
     450,  1816,   941,   818,   227,  4318,   441,   262,  2510,   176,
     808,   685,   686,     0,  2997,  2768,  4140,  3000,  3001,   103,
     104,  3004,   470,   465,  3286,  3287,  1707,   808,   702,   210,
    4156,  3014,   370,  1075,  3002,  3003,  2781,  4125,  1922,  1320,
     488,   502,   857,   896,   209,   198,   266,   439,  2786,   890,
    1913,   216,  1517,   218,   502,   306,  1521,  1522,   450,   364,
     270,  1939,   207,  1196,   502,   230,  4379,  1945,  2263,  4312,
    1203,  1568,   502,   240,  2212,   162,  2214,  2319,   109,   174,
    4275,   502,   266,  2030,  2031,   306,   181,   951,   812,   953,
      14,   955,   184,   383,   909,   229,   500,   961,   502,    88,
     504,   341,   847,   174,  2004,  2005,   470,    75,    76,    77,
      78,   235,   186,    37,    82,  2015,   941,   229,  2018,   264,
    1253,   985,   986,   469,   488,  3025,  2026,  2027,   295,   937,
     370,   984,   493,   494,   495,   496,   497,   498,   502,  2039,
    2040,  4454,   226,   230,   228,  4285,   848,   493,   494,   460,
    2050,   361,   244,   495,   496,   497,   498,   502,   189,  3059,
    1703,    75,    76,    77,    78,   158,   230,   328,    82,   181,
      72,   502,   330,    75,    76,    77,    78,   940,   941,    81,
      82,    83,    84,   808,    86,   230,   260,   812,   127,   334,
     100,   502,  1852,   181,   266,  1048,   330,   502,  1663,   901,
     902,   366,   461,  3103,  1669,  2490,  4401,   392,   502,   432,
      99,   266,   502,  3941,   888,    14,   890,   175,   330,   314,
     401,   374,  1703,   390,   495,   496,   497,   498,   502,   637,
     932,  1056,   452,   484,   455,   306,   401,   422,   953,   232,
     955,   315,   316,  1028,   227,  1710,   399,  1032,  1713,  1714,
     266,  2753,   502,  1970,  1971,   932,   145,   381,   938,  3521,
    4207,   935,  3345,   152,   247,   939,   489,   111,   452,  4358,
     985,   986,   457,   953,   334,   955,    88,   685,   686,   268,
     414,   504,  1026,   266,   469,   965,   506,   989,   229,  4215,
    4216,   932,   250,   182,   702,   505,  1920,   118,   295,   808,
     445,  1766,   314,   812,   151,   985,   986,  2772,   502,   181,
     951,   268,   953,   341,   955,  1017,   411,   502,   392,   414,
     961,   962,   963,  1025,  4103,  1049,   314,  1029,  1030,  1031,
     394,   489,   490,   491,   181,   493,   494,   495,   496,   497,
     498,   808,   370,  3902,   985,   986,  1889,  3731,   422,   394,
    1024,   261,  1026,   808,    99,   231,  3312,   328,  3742,   423,
      72,   183,   251,    75,    76,    77,    78,   306,  1688,    81,
      82,   328,   227,   502,    86,   387,   450,   461,   423,  2446,
     452,    71,    72,   457,   377,    75,    76,    77,    78,    79,
      80,    81,    82,   390,   184,   469,    86,   452,  3727,   432,
     954,   158,   246,    22,   958,   959,   960,   502,  1889,  1729,
     286,  3740,  1114,  1115,   968,  1925,   186,  1119,    75,    76,
      77,    78,   243,  1100,  1049,    82,   247,   128,   502,  4061,
     270,   193,   254,   195,   240,   136,   452,   376,  2249,  3701,
    3702,   107,  1119,   503,   385,   505,    88,   319,   193,    95,
    4410,  4377,    14,    72,   244,   101,   268,  4061,  3644,  1100,
     399,   282,  4241,   421,   422,  3599,   183,   314,   383,   452,
    3604,   113,   505,  3607,   502,   232,   469,  3460,  1119,   887,
     888,  2387,   890,  3466,  3467,  3468,  3469,  3470,  3471,   295,
     260,   181,   314,  2036,    75,    76,    77,    78,  2871,   440,
     228,    82,   808,  3595,   493,   494,   495,   496,   497,   498,
     503,  1256,   222,   506,  4474,   181,  1157,  3417,   149,  1221,
     372,   361,   232,   506,  1463,   414,  2150,   935,   227,   500,
     938,   939,   149,   504,   502,   450,  2355,   247,  2249,  3170,
    1049,  2038,   385,   951,   227,   953,    72,   955,   247,   425,
     500,   427,   198,   961,   504,  2036,   361,   965,   381,   190,
      86,  1028,   324,  2528,   247,  1032,   371,   266,  1331,  2475,
    2476,  2477,  2478,   190,  2536,   265,   136,   985,   986,   951,
    2399,   953,   403,   955,   390,   286,   176,  3343,   502,   961,
     395,   493,   494,   436,  1368,   173,   286,   314,  1561,  1562,
    2787,  1564,  1304,  1547,  3200,  1368,  1308,  1309,  2788,  1311,
    2883,   120,  3061,   985,   986,   343,  1024,   469,  1026,  3121,
     377,   181,   392,  3125,  3061,  3061,   268,  1329,   451,   136,
    4358,  1308,  1309,  1633,  1311,   422,  4020,  4021,  1401,  3061,
    1633,  1922,  3061,   808,   151,  3061,   385,   812,   186,  3617,
     240,  3619,  1329,   505,  1334,   176,  1336,  1420,   186,  1339,
     198,  1341,   319,   172,  1344,  1345,  1346,  1308,  1309,   379,
    1311,  1561,  1562,  1375,  1564,   266,   404,  1357,   401,  3155,
     450,   493,   494,   495,   496,   497,   498,  1450,  1329,  2522,
     385,  1371,  1100,  1373,  4253,   341,   209,   436,   184,   136,
    1463,   208,   334,   120,  1378,   295,  1114,  1115,   298,   360,
    1118,   342,   469,   383,  3091,  2519,   294,   224,   296,   240,
    3982,   149,  1028,   432,   370,   342,  1032,   450,  1100,  3977,
     452,  2631,   260,   384,  1532,   248,   361,  1870,  4264,  1872,
     410,   436,  1114,  1115,  4006,  4007,   503,  1119,  1881,   506,
     259,  1532,   340,   452,   314,   172,  1500,  1501,   244,   319,
     353,    71,   190,  1465,  2229,    75,    76,    77,    78,    79,
      80,   208,    82,  1475,   295,   149,   401,   298,  1332,  2679,
     502,  1335,   494,  1485,  1338,   374,  1340,   224,   316,  1343,
    4038,   227,  4040,  1347,   354,   426,   505,   306,  1561,  1562,
     390,  1564,  1583,   493,   494,   332,   366,   506,  2708,   426,
     399,   247,  1514,   351,   341,  1517,   190,  4201,   500,  1521,
    1522,  3955,  2889,   489,   506,   450,  1500,  1501,   176,  2861,
     266,   412,   413,  1966,   500,  3032,   502,   503,   504,   505,
    1517,   434,   259,  2743,  1521,  1522,  4052,   354,  1646,  3832,
    3833,   493,   494,   495,   496,   497,   498,  1601,    88,   228,
    1584,  1585,   393,  1028,   392,  1646,   176,  1032,   193,   390,
     195,   503,    85,   505,   341,    88,  1517,   153,   471,   388,
    1521,  1522,  3384,   113,  1049,    25,   446,   256,   218,   306,
    2244,   422,   240,   483,   422,    35,  2361,    14,   469,   434,
     113,  1603,   271,   370,  2369,   118,  2371,  1532,   247,  1633,
    4116,   280,   502,   505,   342,  4177,  1640,   354,  1595,   195,
      37,  1329,   450,   193,   434,   195,  1334,  1601,  1336,   457,
     240,  1339,   463,  1341,   505,   462,  1344,  1345,  1346,   446,
     231,   469,  1350,  1620,  1621,   502,   216,   295,  3135,  1357,
     298,    81,  1593,   283,  1595,    72,    86,  1329,  1583,  1584,
    1585,   471,   483,  1371,   151,  1373,  2502,   227,   342,   469,
    1378,   388,  1613,   424,   502,    75,    76,    77,    78,  1620,
    1621,   502,    82,  3221,  3940,   295,  1663,   247,   298,   314,
     222,  3744,  1669,   133,  3181,   286,   326,    85,   426,   324,
      88,   425,   392,   427,  4210,   505,   266,  3245,  1633,   446,
     242,   380,  4218,  2549,   207,  1640,   452,   173,   469,   470,
       5,  1646,  1663,  1532,  1726,   218,  3403,  3404,  1669,   222,
    1828,   370,   422,  1710,   247,   374,  1713,  1714,  3070,  1978,
      25,   114,   390,  3508,   231,   353,   489,  1828,   328,   319,
      35,   502,   426,   333,   324,   268,   269,   393,    71,    72,
     399,   504,   135,   250,  1879,  1532,  2881,   457,   186,  1710,
     506,   264,  1713,  1714,  1583,  1584,  1585,  1532,    95,  3266,
     390,    89,  3455,  1491,   101,   506,   422,  2804,  2770,  1766,
     283,  1999,  1500,  1501,   218,  4078,   252,  3599,   222,   286,
     222,  1926,  3604,    85,   317,  3607,    88,  1870,   503,  1517,
     209,   506,   502,  1521,  1522,   341,  1583,   330,   341,   218,
     242,   470,   262,   140,  1633,  1766,   434,   463,  4376,  1982,
     469,  1640,  1834,   326,   425,   483,   427,  1646,   294,   488,
     296,   334,   260,  3193,   370,  1517,   333,   370,   133,  1521,
    1522,   374,   306,   502,  4122,  3248,  3249,   128,   508,   283,
    2160,  4061,  1925,   471,  2661,  2662,   506,  2160,   438,  2666,
    1998,   229,   463,   483,   191,   146,   399,   447,   332,  1646,
     268,   198,  2725,  1650,   201,   136,  3756,   341,   470,   470,
     161,  1646,   452,  1601,   341,  1603,   328,   469,   470,   257,
     151,   333,   326,  1828,  1671,  1613,   488,   488,  2705,  2706,
      41,  1913,   197,  1990,  1916,  1978,  1990,  1990,  1990,  2573,
     502,  1862,   425,   370,   427,  3284,  1532,  1990,  3696,    51,
     181,  1603,   183,  3558,  3699,   252,  1913,   337,   425,  1916,
     427,   212,   330,  1831,  2725,    71,   506,    69,   452,   436,
     500,  4151,   445,    79,    80,  1663,  1936,   507,  1938,   446,
    1848,  1669,  1942,   503,  1944,   247,   506,  1947,   143,   262,
     341,  1951,  1913,  2071,   392,  1916,   151,   262,   341,  1746,
     493,   494,   495,   496,   497,   498,   268,   356,   505,   306,
    2071,  1663,   509,    75,    76,    77,    78,  1669,    16,   370,
      82,   455,  1710,   254,   422,  1713,  1714,   370,  2773,   497,
     503,   174,  2075,   497,   502,   387,   504,  2798,   502,  1828,
     504,  2023,  2186,   500,   341,   502,   323,   504,   399,  3396,
    4286,   273,   450,   505,   387,   207,   399,   509,  1710,   457,
    1646,  1713,  1714,   501,  1650,  2170,   218,   505,   330,    34,
     222,   469,   424,  3385,  3386,  3255,   218,   374,  1766,   389,
     222,  1828,  2270,   314,  2272,  1671,   501,  1532,   319,   502,
     505,   424,   193,  1828,   195,  2016,  2017,  2510,    75,    76,
      77,    78,   399,  2024,   502,    82,  2053,  2028,  2029,  2056,
     133,   134,   264,   150,  1766,   216,   174,   469,   470,   503,
    3060,   505,  2043,   354,  2045,   493,   494,   495,   496,   497,
     498,   283,   432,  2176,   387,   366,   469,   470,  1583,  1584,
    1585,   283,   500,  2064,   502,  2066,    75,    76,    77,    78,
     502,  2133,   372,    82,   370,   503,  2160,   505,   374,   389,
    1746,  2678,     2,  2680,  2681,   202,  2071,   341,   436,   502,
    2265,   424,   155,  3955,   326,   495,   496,   497,  3476,     7,
     505,   506,   334,   399,   326,  2263,   250,   503,  1633,   505,
    4101,    19,    20,    85,  2115,  1640,   370,  3336,   383,   384,
     374,  1646,  2263,   120,   502,  1650,   504,   503,  2212,   505,
    2214,    39,   507,   314,    42,   446,   469,   470,   319,   503,
     503,   505,   505,   324,    72,   399,  1671,   489,   490,   491,
     174,   493,   494,   495,   496,   497,   498,   242,    78,   276,
     277,   124,  1828,   503,    84,   505,   163,   273,  1936,   502,
    1938,  2233,   289,   469,  1942,  2160,  1944,   319,  2353,  1947,
     389,  2339,  4044,  1951,  3025,  2186,   508,  2249,  1956,  2251,
     187,  2253,  2229,  3306,  3307,  3479,  3480,   117,  2339,  3483,
     328,  3485,  2071,   383,   384,   162,  3102,   502,  4033,   206,
    2244,  2510,  2249,   445,  2251,   469,  2253,  3392,  3059,    86,
     503,  1746,   505,   503,   341,   505,   223,  2212,  2229,  2214,
     505,   506,   152,  2374,   503,   502,   505,    85,  2300,   505,
      88,   238,   162,   503,  2071,   505,   154,   503,  2249,   505,
    2251,   502,  2253,   504,   469,   470,  2071,   438,   124,   503,
    2753,   505,   319,   503,   273,   505,   447,    71,    72,   485,
      85,   228,   114,    88,   392,    79,    80,   503,  2263,   505,
     486,   487,    86,   503,   270,   505,   194,  4149,  3707,   209,
    4230,  2160,  4232,  2461,   504,   503,   216,   505,   218,   256,
     503,   331,   505,  1828,   422,   469,   470,   424,   125,   426,
     230,   503,   331,   505,   271,   485,    85,  3583,   503,    88,
     505,   328,   319,   280,  2361,   493,   494,   495,   496,   497,
     327,  2099,  2369,   328,  2371,   503,  1383,  1384,  2106,   457,
     503,   432,   505,  2212,   113,  2214,   303,  2115,   503,   118,
     505,   469,   331,   503,  2339,   505,   173,   114,  2420,  2761,
    2361,   425,   359,   427,   485,   425,  2428,   427,  2369,  3226,
    2371,   270,  3229,  3230,  3231,  3232,  3233,  3234,  3235,  3236,
    3237,  3238,    85,   495,   502,    88,  1069,  2510,  1071,  2374,
      75,    76,    77,    78,  2263,   399,   503,    82,   505,  2805,
    2806,    86,   105,   226,   503,  2071,   505,   505,   502,  2708,
     113,   503,  2474,   505,   503,   118,   505,   503,  2186,   505,
     268,   503,   503,   380,    85,   124,  3686,    88,   495,  3286,
    3287,   503,   249,   505,  2496,   503,  2263,   505,   508,  3126,
    2502,  3128,   508,  2444,   105,   503,   366,   505,  2263,  4134,
     506,   262,   113,   268,  2186,   823,   503,   118,   505,   502,
     828,  2229,  3854,   432,   503,  2233,   505,   432,  3846,   837,
    2339,  2239,   432,  2241,   243,   204,  2244,   294,   247,   296,
     432,   401,   330,  2748,  2749,   126,   503,  2549,   505,   306,
     503,   503,   505,   505,   862,  4357,   181,  2229,   866,   268,
     269,  2233,   503,   432,   505,  2374,   108,   503,   876,   505,
     124,   262,  2339,   282,   268,   330,   157,  2249,    75,    76,
      77,    78,   432,   340,  2339,    82,   504,   503,  2686,   505,
     503,   502,   505,  2691,    75,    76,    77,    78,   472,  2573,
     243,    82,   504,   502,   247,  2686,  2071,  2374,   317,   503,
    2691,   505,   502,    75,    76,    77,    78,   222,   375,  2374,
      82,   330,   503,   328,   505,   268,   269,  3986,    75,    76,
      77,    78,   503,   214,   505,    82,  3417,   281,   452,   282,
    3476,   503,   243,   505,   328,  2708,   247,   503,  2589,   505,
     502,   506,   409,  2361,   503,   323,   505,  2263,   503,  2722,
     505,  2369,   273,  2371,   245,   389,   502,   268,   269,  3773,
     503,   314,   505,   503,   317,   505,   136,   503,  2741,   505,
     503,   282,   505,   503,   181,   505,   469,   330,  3121,  2361,
    2753,   503,  3125,   505,   403,  2160,   162,  2369,  3748,  2371,
     181,  3841,   490,   491,   108,   493,   494,   495,   496,   497,
     498,  3476,   503,   314,   505,   502,   317,   114,   503,   181,
     505,   114,   472,  4400,  3521,   503,   503,   505,   505,   330,
     222,   441,   333,  2339,   489,   490,   491,  3170,   493,   494,
     495,   496,   497,   498,   503,   341,   505,  2212,   148,  2214,
     357,   493,   494,   495,   496,   497,   452,   212,  4090,   501,
     403,  2686,   228,   503,   507,   505,  2691,   503,  2374,   505,
     212,  2773,    75,    76,    77,    78,   503,   637,   505,    82,
     489,   490,   491,   502,   493,   494,   495,   496,   497,   498,
     256,   212,   503,   374,   505,   376,  2773,   378,  2263,   503,
     472,   505,   403,   384,   212,   271,  1114,  1115,   328,   212,
     391,   212,   505,   212,   280,   328,   212,  4017,   399,  4178,
     212,    75,    76,    77,    78,   212,   407,  2768,    82,   212,
    2771,   212,  2773,   212,   415,   422,   502,   303,    75,    76,
      77,    78,   108,   223,   281,    82,   489,   490,   491,   222,
     493,   494,   495,   496,   497,   498,    75,    76,    77,    78,
     222,   502,   328,    82,  4223,  2573,  2574,   502,  4227,  4228,
     502,   502,   502,   350,  2339,   502,   502,  2686,   502,  2960,
    2961,  2962,  2691,   464,    75,    76,    77,    78,   489,   490,
     491,    82,   493,   494,   495,   496,   497,   498,   502,   502,
     501,   108,   502,   502,  3701,  3702,   507,   502,  3751,  2374,
     502,   502,    95,   502,   380,   338,   502,   502,   101,  2686,
     502,  4239,  3020,   502,  2691,   502,   502,   502,   502,   502,
     502,  2686,   164,   266,   505,   281,  2691,  3078,   268,  3020,
    3900,   108,   222,   222,  2946,   495,   262,   390,   808,   326,
     298,  3384,   812,   505,   180,   451,   816,   140,   505,  4224,
    3058,   489,   822,  4225,  2966,    14,   505,   502,   502,   502,
    3751,   432,   504,  3114,   432,   432,   432,  3058,   432,   328,
     391,   432,  4182,   432,   319,   143,   452,   432,   451,   328,
     252,   432,   432,   853,   502,  2997,  3111,   341,  3000,  3001,
     505,   341,  3004,   175,   452,  3079,   452,   432,   191,   124,
    3846,   124,  3014,   432,   432,   198,  3079,  3019,   201,   432,
    3094,   332,   502,  3025,   387,   432,   432,   432,   328,  3031,
     432,  3094,   328,   268,   894,  2960,  2961,  2962,   432,   469,
    3114,   432,   432,   502,   460,   905,   108,   107,  3025,   502,
     502,  3114,   912,    97,   181,  3294,   289,  3059,  3121,   222,
    2768,   108,  3125,   452,   462,  2773,   502,   108,   463,   252,
     273,  3073,   932,  2038,    85,   158,   504,    88,   388,   212,
    2686,   466,  3059,   452,  3025,  2691,   212,   452,   212,  3030,
    3031,  3296,  3297,  3298,  3299,  3020,   212,   180,    14,  3101,
    3102,  2773,   113,   186,  3078,  3179,  4306,   118,   323,   432,
     457,  3052,   377,   318,   502,   227,  3179,    85,  3059,   505,
      88,   430,  4139,   306,   465,   485,   300,   300,   211,    88,
     505,   399,  2097,  3058,   502,   430,   502,   227,   432,   489,
    3114,   505,   434,   241,   505,   113,   503,  4200,   241,   505,
     118,  2960,  2961,  2962,   264,   489,   324,    34,   341,  4424,
     329,  3259,  1022,   505,    10,   503,  3599,   503,  1028,   432,
     387,  3604,  1032,   432,  3607,   503,    85,   260,  3259,    88,
     150,   387,   502,   452,   272,  3982,   272,   370,   502,  1049,
     319,   374,   328,  2960,  2961,  2962,   105,   319,  1058,   319,
     335,   432,  4045,   505,   327,  2960,  2961,  2962,   432,  4006,
    4007,  3020,   396,   370,   370,   370,   399,   361,   432,   432,
     268,  2686,  4065,   108,   452,   268,  2691,   452,   268,   268,
      85,  3294,   243,    88,   268,   327,   247,   489,   206,   107,
     500,   502,    95,   500,   432,   432,   222,   489,   101,  3058,
     105,   224,   324,  3020,   502,   396,   211,   268,   269,   108,
     328,   328,   496,   502,  4045,  3020,  3430,   239,  3270,  3611,
     239,   282,   222,   108,   212,   243,   505,   328,   328,   247,
    4061,   222,   396,   247,  4065,   247,   502,   140,    96,   247,
     472,  3058,   297,   505,   233,  1603,   328,   505,   124,   503,
     268,   269,   503,  3058,   503,   227,   317,   503,   503,   392,
     503,  3313,   227,   503,   282,   432,   505,  3025,  3416,   330,
    3418,   485,    85,  4434,   503,    88,   503,   503,   503,   466,
     337,   485,   503,   328,  3259,  3416,  1196,  3418,   191,   422,
     506,   503,   105,  1203,   503,   198,   489,   283,   201,   317,
     503,  3059,   502,  3025,  2960,  2961,  2962,  4317,   503,   268,
    3441,   503,   330,   502,  1224,   505,   331,   450,  4479,   432,
    3078,   505,   503,   455,   457,   328,  4487,   502,   258,   319,
    4177,   502,   212,   502,   212,   283,   469,  3059,   345,   345,
     449,   292,   403,  1253,   432,   292,   292,   432,   268,   252,
     500,   432,   432,  4239,   432,   432,  3114,   432,   432,   268,
     268,   268,   268,   268,  3020,  3417,   268,   268,   503,   502,
    3361,   330,   298,   503,   489,   332,   441,   372,   174,  3431,
     503,   502,  3434,   283,  3436,   403,  1744,   327,   432,   505,
    3417,   328,   236,   324,   271,   503,   502,   336,  1308,  1309,
    3259,  1311,  3058,   306,   271,   452,   502,   222,  3460,  1319,
     452,   387,   387,   387,  3466,  3467,  3468,  3469,  3470,  3471,
     331,  4314,   505,   210,  3476,   330,  3417,   210,   500,   490,
     491,   204,   493,   494,   495,   496,   497,   498,   341,  3430,
      88,  3416,  3259,  3418,   222,  2960,  2961,  2962,   227,  3476,
     134,  3503,   505,   503,  3259,   268,   227,   503,   462,   502,
    3512,  3513,  3514,  3515,  3491,   503,  3441,   370,   503,  1379,
     235,   374,  3955,   503,  1832,   493,   494,   495,   496,   497,
     498,   505,   503,  4314,   329,  3476,  3599,   489,   489,  1847,
     503,  3604,   502,   489,  3607,  1405,   399,   222,   258,  3490,
    3491,   222,   268,   441,  3628,  3020,   503,  3765,  3499,   441,
     432,   432,  3503,   432,   268,  3628,   432,   330,   503,  3571,
     503,  3512,   503,  1433,   501,   272,   108,   469,   472,   502,
     489,   490,   491,   502,   493,   494,   495,   496,   497,   498,
     222,    85,   505,  3058,    88,   503,  3760,  1905,   253,   505,
    1460,  1461,   469,  1463,   146,   424,   469,  3416,   432,  3418,
     505,  4044,    85,   271,   396,   232,  1476,   503,   502,   113,
    1480,   227,  3786,   502,   118,   503,   227,   502,   502,   467,
     503,  4064,  3441,   467,   489,   490,   491,   124,   493,   494,
     495,   496,   497,   498,   237,   505,   432,   817,   227,  3416,
     820,  3418,   441,  3259,   469,   503,  3364,  1517,   503,   503,
     319,  3416,   319,  3418,   489,   505,   836,   212,  4101,   505,
     188,  1531,  1532,   268,  3441,   319,   183,   254,   501,   229,
     227,   452,   452,   199,   465,   469,  3441,   227,   502,   859,
     502,    85,   255,  3634,    88,   502,  2661,  2662,   331,   227,
     502,  2666,   502,  1563,   874,   456,   408,  1567,  1568,  3417,
     503,   105,  3876,   503,   468,   344,  4149,   328,   503,   366,
     503,   452,  3430,  1583,  1584,  1585,   489,   490,   491,   502,
     493,   494,   495,   496,   497,   498,   502,   469,   222,   108,
    2705,  2706,  3744,  3745,   319,  3417,  3844,   293,   250,   243,
     502,   103,   104,   247,  3756,   211,   174,   384,  3430,   332,
     384,   136,   331,  3844,   136,   489,   124,  3744,  3476,   334,
     222,   328,   502,  1633,   268,   269,   424,   217,   358,  3756,
    1640,  1641,   331,   913,   194,    85,  1646,   917,   282,   456,
    1650,   505,   331,   108,  3259,   227,   466,   927,   364,   505,
     469,   199,   328,  3744,  3476,   328,   158,   108,   469,   502,
    3416,  1671,  3418,   503,   502,  3756,   503,   502,  1678,  3760,
     314,  3902,   383,   317,   186,   450,    94,   383,   180,   105,
    3832,  3833,  3906,   211,   186,  3441,   330,   358,   502,   358,
    1747,  1701,   108,  3906,  3846,  3786,  2460,  1522,  2345,  3851,
    3852,  2773,  2894,  3855,  3856,  3416,  3797,  3798,  3019,   211,
     126,  3802,  3803,  4081,  4239,  3844,  3868,  3869,  3870,  3871,
    3872,  3562,  4134,  3893,   268,  2856,  2578,  4138,  4381,  4044,
    4423,  4344,  4343,  4390,  3564,  2290,  1746,  1849,  4157,  3441,
    2961,   157,  3955,  1835,  2448,  3072,  4426,  4487,  3862,  4479,
    3861,  3058,  4397,  1763,  3024,  4067,  1826,  4325,   260,   403,
    3912,  4070,  3637,   188,  4206,  3572,  1366,  4350,  2313,  3844,
    1780,  3574,  4286,   902,  4357,  2233,  4406,  3868,  3869,  3870,
    3871,  3872,  4481,  2170,  1043,  3876,   330,  3939,  1798,  4123,
    2171,  3556,  1926,  3180,  2784,  2561,  1322,  1553,   214,  1060,
    4383,  3416,  2260,  3418,  2795,  1571,  2264,  2206,  1570,  2807,
    2205,  2189,  2801,  1823,  1573,  2163,  2753,  2510,  1828,  3127,
    3956,  1048,  3553,  2785,  3269,   896,  3441,  3902,  2286,   245,
    4180,  3261,  4370,  4374,  4371,  2720,  2294,  2798,  2722,  1159,
    1160,  2633,  2601,  2100,   637,   489,   490,   491,  3111,   493,
     494,   495,   496,   497,   498,  1260,  1864,   273,  2503,  2317,
    1870,  2233,  1872,  4364,   367,  1585,   934,  1579,  1878,  2209,
    1378,  1881,  1117,  1117,  2249,  2241,  2767,  3364,  2242,  2337,
    1137,  3743,  1497,  3365,  3341,  3844,  3744,  1583,  2574,   400,
     392,  2253,  1956,     2,  1308,    -1,  2354,   964,  1218,  2357,
    4483,  4028,  3760,  1913,    -1,    -1,  1916,    -1,    -1,  4061,
      -1,    -1,    -1,    -1,  1234,  1235,    -1,  2375,    -1,    -1,
     422,    -1,    -1,    -1,  2382,    -1,  4078,  3844,  3786,    -1,
    4082,  1251,    -1,  2391,  4061,    -1,    -1,  4028,  3760,  3844,
    2398,    -1,    -1,  3902,    -1,   489,   490,   491,   450,   493,
     494,   495,   496,   497,   498,   457,  1966,    -1,   374,   461,
      -1,    -1,   378,    -1,  3786,  1285,  1286,   469,   384,    -1,
    4061,    -1,    -1,    -1,    -1,   391,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   399,    -1,  3902,    -1,    -1,    -1,    -1,
      -1,   407,    -1,    -1,  2004,  2005,    -1,  3902,    -1,   415,
     502,    95,  2012,    -1,    -1,  2015,    -1,   101,  2018,  1289,
      -1,    -1,    -1,  2023,    -1,    -1,  2026,  2027,  3876,    -1,
      -1,    -1,  4253,    -1,  2034,    -1,    -1,  2037,  2038,  2039,
    2040,    -1,    -1,    -1,    -1,    -1,    -1,  2047,  2048,    -1,
    2050,    -1,  2052,    -1,    -1,  2055,   140,    -1,   464,  4438,
      -1,    -1,   468,   469,  3876,    -1,    -1,    -1,    -1,  2069,
    2070,  2071,    -1,    -1,  2074,    -1,    -1,    -1,  2078,    -1,
      -1,    -1,  2082,    -1,  2084,  2085,  2086,  2087,  2088,  2089,
    2090,  2091,  2092,    -1,  2094,  1365,    -1,  4239,  3844,    -1,
    2100,    -1,    -1,  2103,    -1,    -1,    -1,   191,    -1,    -1,
      -1,  1381,    -1,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,  3226,    -1,  1393,  3229,  3230,  3231,  3232,  3233,  3234,
    3235,  3236,  3237,  3238,   108,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    85,    -1,    -1,    88,    -1,    -1,    -1,
      -1,    -1,   126,    71,    -1,    -1,  3902,    -1,    -1,    -1,
    2160,    79,    80,   105,    -1,    -1,    -1,    85,   252,    -1,
      88,   113,    -1,  2173,    -1,    -1,   118,    -1,    -1,    -1,
      -1,  3286,  3287,   157,    -1,    -1,    -1,   105,  4253,  4406,
     108,    -1,  4406,  4406,  4406,   113,    -1,    -1,    -1,    -1,
     118,    -1,    -1,  4406,    -1,    -1,    -1,    -1,    -1,  4290,
      -1,    -1,  2212,  4061,  2214,    -1,    -1,    -1,    -1,    -1,
      -1,  4438,   306,    -1,  4438,  4438,  4438,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4438,    -1,    -1,    -1,  3844,
     214,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4061,
      -1,  2251,    -1,  2253,    -1,    -1,    -1,   341,    -1,    -1,
      -1,    -1,  1295,  2263,  4481,    -1,    -1,  4481,  4481,  4481,
      -1,   245,    -1,  1306,    -1,    -1,    -1,    -1,  4481,    -1,
      -1,    -1,    -1,    -1,  1554,    -1,   370,  2287,    -1,    -1,
     374,    -1,  4434,    -1,    -1,    -1,    -1,  3902,    -1,   273,
      -1,   243,    -1,    -1,  4253,   247,    -1,  2307,    -1,    -1,
      -1,    -1,  2312,  2313,    -1,   399,   108,  4434,    -1,    -1,
      -1,    -1,    -1,  2323,    -1,   243,   268,   269,    -1,   247,
      -1,    -1,    -1,    -1,   126,    -1,    -1,  4479,    -1,  2339,
     282,    -1,    -1,    -1,    -1,  4487,  4253,    -1,    -1,    -1,
     268,   269,    -1,  4434,    -1,    -1,    -1,    -1,  4253,    -1,
      -1,    -1,  4479,    -1,   282,   157,    -1,    -1,    -1,    -1,
    4487,    -1,   314,    -1,  2374,   317,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   330,    -1,
    2838,   333,    -1,    -1,    -1,    -1,   314,    -1,  4479,   317,
     374,    -1,    -1,    -1,   378,    -1,  4487,    -1,    -1,    -1,
     384,    -1,   330,    -1,    -1,   333,  3521,   391,    -1,    -1,
      -1,    -1,   214,    -1,    -1,   399,  1736,  1737,  1738,  1739,
    1224,    -1,    -1,   407,    -1,    -1,  2436,    -1,  2438,    -1,
      -1,   415,  4290,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   245,    -1,    -1,    85,  1767,  1768,    88,
      -1,   403,    -1,  1773,    -1,    -1,   