.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SAVEPOINT" "" "2007-11-16" "SQL - Language Statements" "SQL Commands"
.SH NAME
SAVEPOINT \- define a new savepoint within the current transaction

.SH SYNOPSIS
.sp
.nf
SAVEPOINT \fIsavepoint_name\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBSAVEPOINT\fR establishes a new savepoint within
the current transaction.
.PP
A savepoint is a special mark inside a transaction that allows all commands
that are executed after it was established to be rolled back, restoring
the transaction state to what it was at the time of the savepoint.
.SH "PARAMETERS"
.TP
\fB\fIsavepoint_name\fB\fR
The name to give to the new savepoint.
.SH "NOTES"
.PP
Use ROLLBACK TO SAVEPOINT [\fBrollback_to_savepoint\fR(l)] to
rollback to a savepoint. Use RELEASE SAVEPOINT [\fBrelease_savepoint\fR(l)] to destroy a savepoint, keeping
the effects of commands executed after it was established.
.PP
Savepoints can only be established when inside a transaction block.
There can be multiple savepoints defined within a transaction.
.SH "EXAMPLES"
.PP
To establish a savepoint and later undo the effects of all commands executed
after it was established:
.sp
.nf
BEGIN;
    INSERT INTO table1 VALUES (1);
    SAVEPOINT my_savepoint;
    INSERT INTO table1 VALUES (2);
    ROLLBACK TO SAVEPOINT my_savepoint;
    INSERT INTO table1 VALUES (3);
COMMIT;
.sp
.fi
The above transaction will insert the values 1 and 3, but not 2.
.PP
To establish and later destroy a savepoint:
.sp
.nf
BEGIN;
    INSERT INTO table1 VALUES (3);
    SAVEPOINT my_savepoint;
    INSERT INTO table1 VALUES (4);
    RELEASE SAVEPOINT my_savepoint;
COMMIT;
.sp
.fi
The above transaction will insert both 3 and 4.
.SH "COMPATIBILITY"
.PP
SQL requires a savepoint to be destroyed automatically when another
savepoint with the same name is established. In
PostgreSQL, the old savepoint is kept, though only the more
recent one will be used when rolling back or releasing. (Releasing the
newer savepoint will cause the older one to again become accessible to
\fBROLLBACK TO SAVEPOINT\fR and \fBRELEASE SAVEPOINT\fR.)
Otherwise, \fBSAVEPOINT\fR is fully SQL conforming.
.SH "SEE ALSO"
BEGIN [\fBbegin\fR(l)], COMMIT [\fBcommit\fR(l)], RELEASE SAVEPOINT [\fBrelease_savepoint\fR(l)], ROLLBACK [\fBrollback\fR(l)], ROLLBACK TO SAVEPOINT [\fBrollback_to_savepoint\fR(l)]
