.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "RESET" "" "2007-11-16" "SQL - Language Statements" "SQL Commands"
.SH NAME
RESET \- restore the value of a run-time parameter to the default value

.SH SYNOPSIS
.sp
.nf
RESET \fIconfiguration_parameter\fR
RESET ALL
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBRESET\fR restores run-time parameters to their
default values. \fBRESET\fR is an alternative
spelling for
.sp
.nf
SET \fIconfiguration_parameter\fR TO DEFAULT
.sp
.fi
Refer to SET [\fBset\fR(l)] for
details.
.PP
The default value is defined as the value that the parameter would
have had, if no \fBSET\fR had ever been issued for it in the
current session. The actual source of this value might be a
compiled-in default, the configuration file, command-line options,
or per-database or per-user default settings. This is subtly different
from defining it as ``the value that the parameter had at session
start'', because if the value came from the configuration file, it
will be reset to whatever is specified by the configuration file now.
See in the documentation for details.
.PP
The transactional behavior of \fBRESET\fR is the same as
\fBSET\fR: its effects will be undone by transaction rollback.
.SH "PARAMETERS"
.TP
\fB\fIconfiguration_parameter\fB\fR
Name of a settable run-time parameter. Available parameters are
documented in in the documentation and on the
SET [\fBset\fR(l)] reference page.
.TP
\fBALL\fR
Resets all settable run-time parameters to default values.
.SH "EXAMPLES"
.PP
Set the timezone configuration variable to its default value:
.sp
.nf
RESET timezone;
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBRESET\fR is a PostgreSQL extension.
.SH "SEE ALSO"
SET [\fBset\fR(l)], SHOW [\fBshow\fR(l)]
