.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "REASSIGN OWNED" "" "2007-10-05" "SQL - Language Statements" "SQL Commands"
.SH NAME
REASSIGN OWNED \- change the ownership of database objects owned by a database role

.SH SYNOPSIS
.sp
.nf
REASSIGN OWNED BY \fIold_role\fR [, ...] TO \fInew_role\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBREASSIGN OWNED\fR instructs the system to change
the ownership of the database objects owned by one of the
old_roles, to new_role.
.SH "PARAMETERS"
.TP
\fB\fIold_role\fB\fR
The name of a role. The ownership of all the objects in the
current database owned by this role will be reassigned to
\fInew_role\fR.
.TP
\fB\fInew_role\fB\fR
The name of the role that will be made the new owner of the
affected objects.
.SH "NOTES"
.PP
\fBREASSIGN OWNED\fR is often used to prepare for the
removal of one or more roles. Because \fBREASSIGN
OWNED\fR only affects the objects in the current database,
it is usually necessary to execute this command in each database
that contains objects owned by a role that is to be removed.
.PP
The DROP OWNED [\fBdrop_owned\fR(l)] command is an alternative that
drops all the database objects owned by one or more roles.
.PP
The \fBREASSIGN OWNED\fR command does not affect the
privileges granted to the old_roles in objects that are not owned
by them. Use \fBDROP OWNED\fR to revoke those
privileges.
.SH "COMPATIBILITY"
.PP
The \fBREASSIGN OWNED\fR statement is a
PostgreSQL extension.
.SH "SEE ALSO"
DROP OWNED [\fBdrop_owned\fR(l)], DROP ROLE [\fBdrop_role\fR(l)]
