/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 1

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse base_yyparse
#define yylex   base_yylex
#define yyerror base_yyerror
#define yylval  base_yylval
#define yychar  base_yychar
#define yydebug base_yydebug
#define yynerrs base_yynerrs
#define yylloc base_yylloc

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONTINUE = 265,
     SQL_COUNT = 266,
     SQL_DATA = 267,
     SQL_DATETIME_INTERVAL_CODE = 268,
     SQL_DATETIME_INTERVAL_PRECISION = 269,
     SQL_DESCRIBE = 270,
     SQL_DESCRIPTOR = 271,
     SQL_DISCONNECT = 272,
     SQL_FOUND = 273,
     SQL_FREE = 274,
     SQL_GO = 275,
     SQL_GOTO = 276,
     SQL_IDENTIFIED = 277,
     SQL_INDICATOR = 278,
     SQL_KEY_MEMBER = 279,
     SQL_LENGTH = 280,
     SQL_LONG = 281,
     SQL_NULLABLE = 282,
     SQL_OCTET_LENGTH = 283,
     SQL_OPEN = 284,
     SQL_OUTPUT = 285,
     SQL_REFERENCE = 286,
     SQL_RETURNED_LENGTH = 287,
     SQL_RETURNED_OCTET_LENGTH = 288,
     SQL_SCALE = 289,
     SQL_SECTION = 290,
     SQL_SHORT = 291,
     SQL_SIGNED = 292,
     SQL_SQL = 293,
     SQL_SQLERROR = 294,
     SQL_SQLPRINT = 295,
     SQL_SQLWARNING = 296,
     SQL_START = 297,
     SQL_STOP = 298,
     SQL_STRUCT = 299,
     SQL_UNSIGNED = 300,
     SQL_VAR = 301,
     SQL_WHENEVER = 302,
     S_ADD = 303,
     S_AND = 304,
     S_ANYTHING = 305,
     S_AUTO = 306,
     S_CONST = 307,
     S_DEC = 308,
     S_DIV = 309,
     S_DOTPOINT = 310,
     S_EQUAL = 311,
     S_EXTERN = 312,
     S_INC = 313,
     S_LSHIFT = 314,
     S_MEMPOINT = 315,
     S_MEMBER = 316,
     S_MOD = 317,
     S_MUL = 318,
     S_NEQUAL = 319,
     S_OR = 320,
     S_REGISTER = 321,
     S_RSHIFT = 322,
     S_STATIC = 323,
     S_SUB = 324,
     S_VOLATILE = 325,
     S_TYPEDEF = 326,
     TYPECAST = 327,
     ABORT_P = 328,
     ABSOLUTE_P = 329,
     ACCESS = 330,
     ACTION = 331,
     ADD_P = 332,
     ADMIN = 333,
     AFTER = 334,
     AGGREGATE = 335,
     ALL = 336,
     ALSO = 337,
     ALTER = 338,
     ALWAYS = 339,
     ANALYSE = 340,
     ANALYZE = 341,
     AND = 342,
     ANY = 343,
     ARRAY = 344,
     AS = 345,
     ASC = 346,
     ASSERTION = 347,
     ASSIGNMENT = 348,
     ASYMMETRIC = 349,
     AT = 350,
     AUTHORIZATION = 351,
     BACKWARD = 352,
     BEFORE = 353,
     BEGIN_P = 354,
     BETWEEN = 355,
     BIGINT = 356,
     BINARY = 357,
     BIT = 358,
     BOOLEAN_P = 359,
     BOTH = 360,
     BY = 361,
     CACHE = 362,
     CALLED = 363,
     CASCADE = 364,
     CASCADED = 365,
     CASE = 366,
     CAST = 367,
     CHAIN = 368,
     CHAR_P = 369,
     CHARACTER = 370,
     CHARACTERISTICS = 371,
     CHECK = 372,
     CHECKPOINT = 373,
     CLASS = 374,
     CLOSE = 375,
     CLUSTER = 376,
     COALESCE = 377,
     COLLATE = 378,
     COLUMN = 379,
     COMMENT = 380,
     COMMIT = 381,
     COMMITTED = 382,
     CONCURRENTLY = 383,
     CONFIGURATION = 384,
     CONNECTION = 385,
     CONSTRAINT = 386,
     CONSTRAINTS = 387,
     CONTENT_P = 388,
     CONVERSION_P = 389,
     CONVERT = 390,
     COPY = 391,
     COST = 392,
     CREATE = 393,
     CREATEDB = 394,
     CREATEROLE = 395,
     CREATEUSER = 396,
     CROSS = 397,
     CSV = 398,
     CURRENT_P = 399,
     CURRENT_DATE = 400,
     CURRENT_ROLE = 401,
     CURRENT_TIME = 402,
     CURRENT_TIMESTAMP = 403,
     CURRENT_USER = 404,
     CURSOR = 405,
     CYCLE = 406,
     DATABASE = 407,
     DAY_P = 408,
     DEALLOCATE = 409,
     DEC = 410,
     DECIMAL_P = 411,
     DECLARE = 412,
     DEFAULT = 413,
     DEFAULTS = 414,
     DEFERRABLE = 415,
     DEFERRED = 416,
     DEFINER = 417,
     DELETE_P = 418,
     DELIMITER = 419,
     DELIMITERS = 420,
     DESC = 421,
     DICTIONARY = 422,
     DISABLE_P = 423,
     DISCARD = 424,
     DISTINCT = 425,
     DO = 426,
     DOCUMENT_P = 427,
     DOMAIN_P = 428,
     DOUBLE_P = 429,
     DROP = 430,
     EACH = 431,
     ELSE = 432,
     ENABLE_P = 433,
     ENCODING = 434,
     ENCRYPTED = 435,
     END_P = 436,
     ENUM_P = 437,
     ESCAPE = 438,
     EXCEPT = 439,
     EXCLUSIVE = 440,
     EXCLUDING = 441,
     EXECUTE = 442,
     EXISTS = 443,
     EXPLAIN = 444,
     EXTERNAL = 445,
     EXTRACT = 446,
     FALSE_P = 447,
     FAMILY = 448,
     FETCH = 449,
     FIRST_P = 450,
     FLOAT_P = 451,
     FOR = 452,
     FORCE = 453,
     FOREIGN = 454,
     FORWARD = 455,
     FREEZE = 456,
     FROM = 457,
     FULL = 458,
     FUNCTION = 459,
     GET = 460,
     GLOBAL = 461,
     GRANT = 462,
     GRANTED = 463,
     GREATEST = 464,
     GROUP_P = 465,
     HANDLER = 466,
     HAVING = 467,
     HEADER_P = 468,
     HOLD = 469,
     HOUR_P = 470,
     IF_P = 471,
     ILIKE = 472,
     IMMEDIATE = 473,
     IMMUTABLE = 474,
     IMPLICIT_P = 475,
     IN_P = 476,
     INCLUDING = 477,
     INCREMENT = 478,
     INDEX = 479,
     INDEXES = 480,
     INHERIT = 481,
     INHERITS = 482,
     INITIALLY = 483,
     INNER_P = 484,
     INOUT = 485,
     INPUT_P = 486,
     INSENSITIVE = 487,
     INSERT = 488,
     INSTEAD = 489,
     INT_P = 490,
     INTEGER = 491,
     INTERSECT = 492,
     INTERVAL = 493,
     INTO = 494,
     INVOKER = 495,
     IS = 496,
     ISNULL = 497,
     ISOLATION = 498,
     JOIN = 499,
     KEY = 500,
     LANCOMPILER = 501,
     LANGUAGE = 502,
     LARGE_P = 503,
     LAST_P = 504,
     LEADING = 505,
     LEAST = 506,
     LEFT = 507,
     LEVEL = 508,
     LIKE = 509,
     LIMIT = 510,
     LISTEN = 511,
     LOAD = 512,
     LOCAL = 513,
     LOCALTIME = 514,
     LOCALTIMESTAMP = 515,
     LOCATION = 516,
     LOCK_P = 517,
     LOGIN_P = 518,
     MAPPING = 519,
     MATCH = 520,
     MAXVALUE = 521,
     MINUTE_P = 522,
     MINVALUE = 523,
     MODE = 524,
     MONTH_P = 525,
     MOVE = 526,
     NAME_P = 527,
     NAMES = 528,
     NATIONAL = 529,
     NATURAL = 530,
     NCHAR = 531,
     NEW = 532,
     NEXT = 533,
     NO = 534,
     NOCREATEDB = 535,
     NOCREATEROLE = 536,
     NOCREATEUSER = 537,
     NOINHERIT = 538,
     NOLOGIN_P = 539,
     NONE = 540,
     NOSUPERUSER = 541,
     NOT = 542,
     NOTHING = 543,
     NOTIFY = 544,
     NOTNULL = 545,
     NOWAIT = 546,
     NULL_P = 547,
     NULLIF = 548,
     NULLS_P = 549,
     NUMERIC = 550,
     OBJECT_P = 551,
     OF = 552,
     OFF = 553,
     OFFSET = 554,
     OIDS = 555,
     OLD = 556,
     ON = 557,
     ONLY = 558,
     OPERATOR = 559,
     OPTION = 560,
     OR = 561,
     ORDER = 562,
     OUT_P = 563,
     OUTER_P = 564,
     OVERLAPS = 565,
     OVERLAY = 566,
     OWNED = 567,
     OWNER = 568,
     PARSER = 569,
     PARTIAL = 570,
     PASSWORD = 571,
     PLACING = 572,
     PLANS = 573,
     POSITION = 574,
     PRECISION = 575,
     PRESERVE = 576,
     PREPARE = 577,
     PREPARED = 578,
     PRIMARY = 579,
     PRIOR = 580,
     PRIVILEGES = 581,
     PROCEDURAL = 582,
     PROCEDURE = 583,
     QUOTE = 584,
     READ = 585,
     REAL = 586,
     REASSIGN = 587,
     RECHECK = 588,
     REFERENCES = 589,
     REINDEX = 590,
     RELATIVE_P = 591,
     RELEASE = 592,
     RENAME = 593,
     REPEATABLE = 594,
     REPLACE = 595,
     REPLICA = 596,
     RESET = 597,
     RESTART = 598,
     RESTRICT = 599,
     RETURNING = 600,
     RETURNS = 601,
     REVOKE = 602,
     RIGHT = 603,
     ROLE = 604,
     ROLLBACK = 605,
     ROW = 606,
     ROWS = 607,
     RULE = 608,
     SAVEPOINT = 609,
     SCHEMA = 610,
     SCROLL = 611,
     SEARCH = 612,
     SECOND_P = 613,
     SECURITY = 614,
     SELECT = 615,
     SEQUENCE = 616,
     SERIALIZABLE = 617,
     SESSION = 618,
     SESSION_USER = 619,
     SET = 620,
     SETOF = 621,
     SHARE = 622,
     SHOW = 623,
     SIMILAR = 624,
     SIMPLE = 625,
     SMALLINT = 626,
     SOME = 627,
     STABLE = 628,
     STANDALONE_P = 629,
     START = 630,
     STATEMENT = 631,
     STATISTICS = 632,
     STDIN = 633,
     STDOUT = 634,
     STORAGE = 635,
     STRICT_P = 636,
     STRIP_P = 637,
     SUBSTRING = 638,
     SUPERUSER_P = 639,
     SYMMETRIC = 640,
     SYSID = 641,
     SYSTEM_P = 642,
     TABLE = 643,
     TABLESPACE = 644,
     TEMP = 645,
     TEMPLATE = 646,
     TEMPORARY = 647,
     TEXT_P = 648,
     THEN = 649,
     TIME = 650,
     TIMESTAMP = 651,
     TO = 652,
     TRAILING = 653,
     TRANSACTION = 654,
     TREAT = 655,
     TRIGGER = 656,
     TRIM = 657,
     TRUE_P = 658,
     TRUNCATE = 659,
     TRUSTED = 660,
     TYPE_P = 661,
     UNCOMMITTED = 662,
     UNENCRYPTED = 663,
     UNION = 664,
     UNIQUE = 665,
     UNKNOWN = 666,
     UNLISTEN = 667,
     UNTIL = 668,
     UPDATE = 669,
     USER = 670,
     USING = 671,
     VACUUM = 672,
     VALID = 673,
     VALIDATOR = 674,
     VALUE_P = 675,
     VALUES = 676,
     VARCHAR = 677,
     VARYING = 678,
     VERBOSE = 679,
     VERSION_P = 680,
     VIEW = 681,
     VOLATILE = 682,
     WHEN = 683,
     WHERE = 684,
     WHITESPACE_P = 685,
     WITH = 686,
     WITHOUT = 687,
     WORK = 688,
     WRITE = 689,
     XML_P = 690,
     XMLATTRIBUTES = 691,
     XMLCONCAT = 692,
     XMLELEMENT = 693,
     XMLFOREST = 694,
     XMLPARSE = 695,
     XMLPI = 696,
     XMLROOT = 697,
     XMLSERIALIZE = 698,
     YEAR_P = 699,
     YES_P = 700,
     ZONE = 701,
     NULLS_FIRST = 702,
     NULLS_LAST = 703,
     WITH_CASCADED = 704,
     WITH_LOCAL = 705,
     WITH_CHECK = 706,
     IDENT = 707,
     SCONST = 708,
     Op = 709,
     CSTRING = 710,
     CVARIABLE = 711,
     CPP_LINE = 712,
     IP = 713,
     BCONST = 714,
     XCONST = 715,
     DOLCONST = 716,
     ECONST = 717,
     NCONST = 718,
     ICONST = 719,
     PARAM = 720,
     FCONST = 721,
     POSTFIXOP = 722,
     UMINUS = 723
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONTINUE 265
#define SQL_COUNT 266
#define SQL_DATA 267
#define SQL_DATETIME_INTERVAL_CODE 268
#define SQL_DATETIME_INTERVAL_PRECISION 269
#define SQL_DESCRIBE 270
#define SQL_DESCRIPTOR 271
#define SQL_DISCONNECT 272
#define SQL_FOUND 273
#define SQL_FREE 274
#define SQL_GO 275
#define SQL_GOTO 276
#define SQL_IDENTIFIED 277
#define SQL_INDICATOR 278
#define SQL_KEY_MEMBER 279
#define SQL_LENGTH 280
#define SQL_LONG 281
#define SQL_NULLABLE 282
#define SQL_OCTET_LENGTH 283
#define SQL_OPEN 284
#define SQL_OUTPUT 285
#define SQL_REFERENCE 286
#define SQL_RETURNED_LENGTH 287
#define SQL_RETURNED_OCTET_LENGTH 288
#define SQL_SCALE 289
#define SQL_SECTION 290
#define SQL_SHORT 291
#define SQL_SIGNED 292
#define SQL_SQL 293
#define SQL_SQLERROR 294
#define SQL_SQLPRINT 295
#define SQL_SQLWARNING 296
#define SQL_START 297
#define SQL_STOP 298
#define SQL_STRUCT 299
#define SQL_UNSIGNED 300
#define SQL_VAR 301
#define SQL_WHENEVER 302
#define S_ADD 303
#define S_AND 304
#define S_ANYTHING 305
#define S_AUTO 306
#define S_CONST 307
#define S_DEC 308
#define S_DIV 309
#define S_DOTPOINT 310
#define S_EQUAL 311
#define S_EXTERN 312
#define S_INC 313
#define S_LSHIFT 314
#define S_MEMPOINT 315
#define S_MEMBER 316
#define S_MOD 317
#define S_MUL 318
#define S_NEQUAL 319
#define S_OR 320
#define S_REGISTER 321
#define S_RSHIFT 322
#define S_STATIC 323
#define S_SUB 324
#define S_VOLATILE 325
#define S_TYPEDEF 326
#define TYPECAST 327
#define ABORT_P 328
#define ABSOLUTE_P 329
#define ACCESS 330
#define ACTION 331
#define ADD_P 332
#define ADMIN 333
#define AFTER 334
#define AGGREGATE 335
#define ALL 336
#define ALSO 337
#define ALTER 338
#define ALWAYS 339
#define ANALYSE 340
#define ANALYZE 341
#define AND 342
#define ANY 343
#define ARRAY 344
#define AS 345
#define ASC 346
#define ASSERTION 347
#define ASSIGNMENT 348
#define ASYMMETRIC 349
#define AT 350
#define AUTHORIZATION 351
#define BACKWARD 352
#define BEFORE 353
#define BEGIN_P 354
#define BETWEEN 355
#define BIGINT 356
#define BINARY 357
#define BIT 358
#define BOOLEAN_P 359
#define BOTH 360
#define BY 361
#define CACHE 362
#define CALLED 363
#define CASCADE 364
#define CASCADED 365
#define CASE 366
#define CAST 367
#define CHAIN 368
#define CHAR_P 369
#define CHARACTER 370
#define CHARACTERISTICS 371
#define CHECK 372
#define CHECKPOINT 373
#define CLASS 374
#define CLOSE 375
#define CLUSTER 376
#define COALESCE 377
#define COLLATE 378
#define COLUMN 379
#define COMMENT 380
#define COMMIT 381
#define COMMITTED 382
#define CONCURRENTLY 383
#define CONFIGURATION 384
#define CONNECTION 385
#define CONSTRAINT 386
#define CONSTRAINTS 387
#define CONTENT_P 388
#define CONVERSION_P 389
#define CONVERT 390
#define COPY 391
#define COST 392
#define CREATE 393
#define CREATEDB 394
#define CREATEROLE 395
#define CREATEUSER 396
#define CROSS 397
#define CSV 398
#define CURRENT_P 399
#define CURRENT_DATE 400
#define CURRENT_ROLE 401
#define CURRENT_TIME 402
#define CURRENT_TIMESTAMP 403
#define CURRENT_USER 404
#define CURSOR 405
#define CYCLE 406
#define DATABASE 407
#define DAY_P 408
#define DEALLOCATE 409
#define DEC 410
#define DECIMAL_P 411
#define DECLARE 412
#define DEFAULT 413
#define DEFAULTS 414
#define DEFERRABLE 415
#define DEFERRED 416
#define DEFINER 417
#define DELETE_P 418
#define DELIMITER 419
#define DELIMITERS 420
#define DESC 421
#define DICTIONARY 422
#define DISABLE_P 423
#define DISCARD 424
#define DISTINCT 425
#define DO 426
#define DOCUMENT_P 427
#define DOMAIN_P 428
#define DOUBLE_P 429
#define DROP 430
#define EACH 431
#define ELSE 432
#define ENABLE_P 433
#define ENCODING 434
#define ENCRYPTED 435
#define END_P 436
#define ENUM_P 437
#define ESCAPE 438
#define EXCEPT 439
#define EXCLUSIVE 440
#define EXCLUDING 441
#define EXECUTE 442
#define EXISTS 443
#define EXPLAIN 444
#define EXTERNAL 445
#define EXTRACT 446
#define FALSE_P 447
#define FAMILY 448
#define FETCH 449
#define FIRST_P 450
#define FLOAT_P 451
#define FOR 452
#define FORCE 453
#define FOREIGN 454
#define FORWARD 455
#define FREEZE 456
#define FROM 457
#define FULL 458
#define FUNCTION 459
#define GET 460
#define GLOBAL 461
#define GRANT 462
#define GRANTED 463
#define GREATEST 464
#define GROUP_P 465
#define HANDLER 466
#define HAVING 467
#define HEADER_P 468
#define HOLD 469
#define HOUR_P 470
#define IF_P 471
#define ILIKE 472
#define IMMEDIATE 473
#define IMMUTABLE 474
#define IMPLICIT_P 475
#define IN_P 476
#define INCLUDING 477
#define INCREMENT 478
#define INDEX 479
#define INDEXES 480
#define INHERIT 481
#define INHERITS 482
#define INITIALLY 483
#define INNER_P 484
#define INOUT 485
#define INPUT_P 486
#define INSENSITIVE 487
#define INSERT 488
#define INSTEAD 489
#define INT_P 490
#define INTEGER 491
#define INTERSECT 492
#define INTERVAL 493
#define INTO 494
#define INVOKER 495
#define IS 496
#define ISNULL 497
#define ISOLATION 498
#define JOIN 499
#define KEY 500
#define LANCOMPILER 501
#define LANGUAGE 502
#define LARGE_P 503
#define LAST_P 504
#define LEADING 505
#define LEAST 506
#define LEFT 507
#define LEVEL 508
#define LIKE 509
#define LIMIT 510
#define LISTEN 511
#define LOAD 512
#define LOCAL 513
#define LOCALTIME 514
#define LOCALTIMESTAMP 515
#define LOCATION 516
#define LOCK_P 517
#define LOGIN_P 518
#define MAPPING 519
#define MATCH 520
#define MAXVALUE 521
#define MINUTE_P 522
#define MINVALUE 523
#define MODE 524
#define MONTH_P 525
#define MOVE 526
#define NAME_P 527
#define NAMES 528
#define NATIONAL 529
#define NATURAL 530
#define NCHAR 531
#define NEW 532
#define NEXT 533
#define NO 534
#define NOCREATEDB 535
#define NOCREATEROLE 536
#define NOCREATEUSER 537
#define NOINHERIT 538
#define NOLOGIN_P 539
#define NONE 540
#define NOSUPERUSER 541
#define NOT 542
#define NOTHING 543
#define NOTIFY 544
#define NOTNULL 545
#define NOWAIT 546
#define NULL_P 547
#define NULLIF 548
#define NULLS_P 549
#define NUMERIC 550
#define OBJECT_P 551
#define OF 552
#define OFF 553
#define OFFSET 554
#define OIDS 555
#define OLD 556
#define ON 557
#define ONLY 558
#define OPERATOR 559
#define OPTION 560
#define OR 561
#define ORDER 562
#define OUT_P 563
#define OUTER_P 564
#define OVERLAPS 565
#define OVERLAY 566
#define OWNED 567
#define OWNER 568
#define PARSER 569
#define PARTIAL 570
#define PASSWORD 571
#define PLACING 572
#define PLANS 573
#define POSITION 574
#define PRECISION 575
#define PRESERVE 576
#define PREPARE 577
#define PREPARED 578
#define PRIMARY 579
#define PRIOR 580
#define PRIVILEGES 581
#define PROCEDURAL 582
#define PROCEDURE 583
#define QUOTE 584
#define READ 585
#define REAL 586
#define REASSIGN 587
#define RECHECK 588
#define REFERENCES 589
#define REINDEX 590
#define RELATIVE_P 591
#define RELEASE 592
#define RENAME 593
#define REPEATABLE 594
#define REPLACE 595
#define REPLICA 596
#define RESET 597
#define RESTART 598
#define RESTRICT 599
#define RETURNING 600
#define RETURNS 601
#define REVOKE 602
#define RIGHT 603
#define ROLE 604
#define ROLLBACK 605
#define ROW 606
#define ROWS 607
#define RULE 608
#define SAVEPOINT 609
#define SCHEMA 610
#define SCROLL 611
#define SEARCH 612
#define SECOND_P 613
#define SECURITY 614
#define SELECT 615
#define SEQUENCE 616
#define SERIALIZABLE 617
#define SESSION 618
#define SESSION_USER 619
#define SET 620
#define SETOF 621
#define SHARE 622
#define SHOW 623
#define SIMILAR 624
#define SIMPLE 625
#define SMALLINT 626
#define SOME 627
#define STABLE 628
#define STANDALONE_P 629
#define START 630
#define STATEMENT 631
#define STATISTICS 632
#define STDIN 633
#define STDOUT 634
#define STORAGE 635
#define STRICT_P 636
#define STRIP_P 637
#define SUBSTRING 638
#define SUPERUSER_P 639
#define SYMMETRIC 640
#define SYSID 641
#define SYSTEM_P 642
#define TABLE 643
#define TABLESPACE 644
#define TEMP 645
#define TEMPLATE 646
#define TEMPORARY 647
#define TEXT_P 648
#define THEN 649
#define TIME 650
#define TIMESTAMP 651
#define TO 652
#define TRAILING 653
#define TRANSACTION 654
#define TREAT 655
#define TRIGGER 656
#define TRIM 657
#define TRUE_P 658
#define TRUNCATE 659
#define TRUSTED 660
#define TYPE_P 661
#define UNCOMMITTED 662
#define UNENCRYPTED 663
#define UNION 664
#define UNIQUE 665
#define UNKNOWN 666
#define UNLISTEN 667
#define UNTIL 668
#define UPDATE 669
#define USER 670
#define USING 671
#define VACUUM 672
#define VALID 673
#define VALIDATOR 674
#define VALUE_P 675
#define VALUES 676
#define VARCHAR 677
#define VARYING 678
#define VERBOSE 679
#define VERSION_P 680
#define VIEW 681
#define VOLATILE 682
#define WHEN 683
#define WHERE 684
#define WHITESPACE_P 685
#define WITH 686
#define WITHOUT 687
#define WORK 688
#define WRITE 689
#define XML_P 690
#define XMLATTRIBUTES 691
#define XMLCONCAT 692
#define XMLELEMENT 693
#define XMLFOREST 694
#define XMLPARSE 695
#define XMLPI 696
#define XMLROOT 697
#define XMLSERIALIZE 698
#define YEAR_P 699
#define YES_P 700
#define ZONE 701
#define NULLS_FIRST 702
#define NULLS_LAST 703
#define WITH_CASCADED 704
#define WITH_LOCAL 705
#define WITH_CHECK 706
#define IDENT 707
#define SCONST 708
#define Op 709
#define CSTRING 710
#define CVARIABLE 711
#define CPP_LINE 712
#define IP 713
#define BCONST 714
#define XCONST 715
#define DOLCONST 716
#define ECONST 717
#define NCONST 718
#define ICONST 719
#define PARAM 720
#define FCONST 721
#define POSTFIXOP 722
#define UMINUS 723




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, 0L, NULL, {NULL}};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, 0L, NULL, {NULL}};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error, ...)
{
	va_list ap;

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "WARNING: ");
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, "ERROR: ");
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			fclose(yyin);
			fclose(yyout);
			if (unlink(output_filename) != 0 && *output_filename != '-')
			        fprintf(stderr, "Could not remove output file %s!\n", output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, strdup(pacounter_buffer), make_str(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * {
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming.
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;

	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);

		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1"), ptr->variable->type->u.element->lineno), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}

		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));

		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);

			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "trying to access an undeclared cursor %s\n", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "Initializer not allowed in typedef command");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "Type %s already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "No multidimensional array support for simple data types");

		types = this;
	}
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 372 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1400 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1424 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   72887

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  489
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  565
/* YYNRULES -- Number of rules. */
#define YYNRULES  2242
/* YYNRULES -- Number of states. */
#define YYNSTATES  3871

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   724

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   475,     2,     2,
     480,   481,   473,   471,   487,   472,   482,   474,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   488,   483,
     468,   467,   469,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   478,     2,   479,   476,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   484,     2,   485,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   470,   477,   486
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   212,   214,   216,   218,   220,   222,   224,
     226,   228,   230,   232,   234,   236,   238,   240,   242,   244,
     246,   248,   250,   252,   254,   260,   262,   263,   266,   269,
     273,   277,   279,   281,   283,   285,   287,   289,   291,   293,
     295,   297,   301,   305,   308,   311,   314,   317,   321,   325,
     331,   337,   342,   348,   353,   357,   363,   367,   373,   379,
     386,   388,   390,   394,   400,   407,   412,   414,   415,   418,
     419,   421,   423,   425,   427,   429,   431,   434,   438,   442,
     446,   450,   454,   458,   462,   466,   469,   475,   478,   481,
     485,   489,   493,   495,   499,   501,   505,   508,   511,   514,
     516,   518,   520,   522,   524,   526,   528,   530,   532,   534,
     538,   545,   547,   549,   551,   553,   554,   556,   558,   562,
     567,   573,   578,   581,   584,   588,   593,   597,   600,   603,
     605,   610,   612,   614,   616,   618,   620,   623,   626,   629,
     632,   637,   642,   644,   648,   652,   657,   664,   671,   678,
     685,   690,   697,   700,   705,   709,   713,   717,   721,   726,
     731,   735,   739,   743,   747,   751,   755,   760,   765,   769,
     772,   776,   778,   780,   784,   788,   792,   795,   798,   802,
     805,   807,   809,   810,   813,   814,   817,   820,   830,   837,
     839,   841,   843,   845,   847,   850,   851,   853,   855,   859,
     863,   865,   867,   871,   875,   879,   884,   886,   887,   890,
     891,   895,   896,   898,   899,   911,   924,   926,   928,   931,
     934,   937,   940,   941,   943,   944,   946,   950,   952,   954,
     956,   960,   963,   964,   968,   970,   972,   975,   977,   981,
     986,   991,   994,  1000,  1002,  1005,  1008,  1011,  1015,  1018,
    1019,  1022,  1025,  1028,  1031,  1034,  1037,  1041,  1043,  1048,
    1055,  1063,  1075,  1079,  1080,  1084,  1086,  1088,  1091,  1094,
    1095,  1097,  1099,  1102,  1105,  1106,  1110,  1114,  1117,  1119,
    1121,  1124,  1127,  1132,  1133,  1136,  1139,  1142,  1143,  1147,
    1152,  1157,  1158,  1161,  1162,  1167,  1168,  1169,  1177,  1183,
    1187,  1188,  1192,  1194,  1196,  1202,  1207,  1210,  1211,  1214,
    1216,  1219,  1223,  1226,  1229,  1232,  1235,  1239,  1243,  1247,
    1249,  1250,  1256,  1266,  1268,  1269,  1271,  1274,  1277,  1278,
    1281,  1282,  1288,  1296,  1298,  1299,  1306,  1309,  1310,  1314,
    1320,  1335,  1355,  1357,  1359,  1361,  1365,  1371,  1373,  1375,
    1377,  1381,  1382,  1384,  1385,  1387,  1389,  1391,  1395,  1396,
    1398,  1400,  1401,  1404,  1406,  1409,  1411,  1414,  1417,  1419,
    1422,  1425,  1432,  1441,  1450,  1454,  1460,  1465,  1470,  1475,
    1479,  1487,  1496,  1503,  1510,  1517,  1524,  1528,  1530,  1534,
    1538,  1540,  1542,  1544,  1546,  1548,  1552,  1556,  1560,  1562,
    1566,  1570,  1572,  1576,  1590,  1592,  1596,  1601,  1609,  1614,
    1622,  1625,  1627,  1628,  1631,  1632,  1634,  1635,  1642,  1651,
    1660,  1662,  1666,  1672,  1678,  1686,  1696,  1704,  1714,  1720,
    1727,  1734,  1739,  1741,  1743,  1745,  1747,  1749,  1751,  1753,
    1755,  1759,  1763,  1767,  1771,  1773,  1777,  1779,  1782,  1785,
    1789,  1794,  1800,  1805,  1810,  1814,  1819,  1823,  1827,  1830,
    1835,  1838,  1840,  1842,  1844,  1846,  1849,  1852,  1854,  1856,
    1858,  1861,  1864,  1866,  1869,  1872,  1874,  1876,  1883,  1891,
    1899,  1909,  1918,  1927,  1934,  1944,  1954,  1962,  1973,  1981,
    1990,  1999,  2008,  2017,  2019,  2021,  2023,  2025,  2027,  2029,
    2031,  2033,  2035,  2037,  2039,  2041,  2043,  2045,  2053,  2061,
    2072,  2075,  2077,  2079,  2081,  2085,  2087,  2089,  2091,  2093,
    2095,  2098,  2101,  2104,  2107,  2110,  2113,  2116,  2118,  2122,
    2124,  2127,  2131,  2132,  2134,  2138,  2141,  2148,  2155,  2159,
    2160,  2164,  2165,  2179,  2194,  2196,  2197,  2200,  2201,  2203,
    2207,  2212,  2217,  2224,  2226,  2229,  2230,  2232,  2234,  2235,
    2237,  2239,  2240,  2250,  2258,  2261,  2262,  2266,  2269,  2271,
    2275,  2279,  2283,  2286,  2289,  2291,  2293,  2295,  2297,  2300,
    2302,  2306,  2308,  2310,  2312,  2317,  2323,  2325,  2328,  2333,
    2339,  2341,  2343,  2345,  2347,  2351,  2355,  2358,  2361,  2364,
    2367,  2369,  2372,  2375,  2377,  2380,  2381,  2387,  2389,  2392,
    2394,  2395,  2401,  2409,  2415,  2423,  2431,  2441,  2443,  2447,
    2451,  2455,  2457,  2461,  2473,  2484,  2487,  2488,  2498,  2501,
    2502,  2507,  2512,  2517,  2519,  2521,  2523,  2524,  2532,  2539,
    2546,  2553,  2560,  2568,  2578,  2588,  2595,  2602,  2609,  2616,
    2623,  2632,  2641,  2648,  2655,  2664,  2673,  2682,  2691,  2693,
    2694,  2702,  2709,  2716,  2723,  2730,  2737,  2745,  2752,  2759,
    2766,  2773,  2781,  2791,  2801,  2811,  2818,  2825,  2832,  2841,
    2850,  2851,  2866,  2868,  2870,  2874,  2878,  2880,  2882,  2884,
    2886,  2888,  2890,  2892,  2893,  2895,  2897,  2899,  2901,  2903,
    2905,  2906,  2913,  2922,  2925,  2928,  2931,  2934,  2937,  2941,
    2945,  2948,  2951,  2954,  2957,  2961,  2964,  2970,  2975,  2979,
    2983,  2987,  2989,  2991,  2992,  2996,  2999,  3002,  3004,  3008,
    3011,  3013,  3014,  3023,  3034,  3037,  3041,  3045,  3046,  3049,
    3055,  3059,  3061,  3064,  3068,  3072,  3076,  3080,  3084,  3088,
    3092,  3096,  3101,  3105,  3109,  3111,  3112,  3118,  3123,  3126,
    3127,  3132,  3136,  3142,  3149,  3154,  3161,  3168,  3174,  3182,
    3184,  3185,  3192,  3204,  3216,  3228,  3242,  3252,  3264,  3275,
    3279,  3281,  3286,  3289,  3290,  3295,  3301,  3307,  3310,  3315,
    3317,  3319,  3321,  3322,  3324,  3325,  3327,  3328,  3332,  3333,
    3338,  3340,  3342,  3344,  3346,  3348,  3350,  3352,  3353,  3359,
    3364,  3366,  3368,  3370,  3372,  3376,  3377,  3382,  3391,  3395,
    3396,  3399,  3403,  3406,  3410,  3416,  3418,  3423,  3426,  3430,
    3432,  3435,  3438,  3439,  3446,  3449,  3450,  3456,  3460,  3461,
    3464,  3467,  3470,  3474,  3476,  3480,  3482,  3485,  3487,  3488,
    3496,  3498,  3502,  3504,  3506,  3510,  3516,  3519,  3521,  3525,
    3533,  3534,  3537,  3540,  3543,  3547,  3548,  3551,  3554,  3556,
    3558,  3562,  3566,  3568,  3571,  3576,  3581,  3583,  3585,  3594,
    3596,  3601,  3606,  3611,  3614,  3616,  3617,  3621,  3625,  3630,
    3635,  3640,  3645,  3648,  3650,  3652,  3653,  3655,  3656,  3658,
    3664,  3666,  3667,  3669,  3670,  3674,  3676,  3680,  3685,  3689,
    3694,  3699,  3702,  3705,  3710,  3712,  3713,  3715,  3717,  3719,
    3723,  3724,  3727,  3728,  3730,  3734,  3736,  3737,  3739,  3742,
    3747,  3752,  3755,  3756,  3759,  3763,  3766,  3767,  3771,  3773,
    3775,  3778,  3780,  3783,  3789,  3796,  3802,  3804,  3807,  3809,
    3814,  3818,  3823,  3829,  3834,  3840,  3845,  3851,  3854,  3859,
    3861,  3864,  3867,  3870,  3872,  3874,  3875,  3880,  3883,  3885,
    3888,  3891,  3896,  3898,  3901,  3905,  3907,  3910,  3911,  3914,
    3919,  3924,  3925,  3927,  3931,  3934,  3937,  3941,  3947,  3954,
    3958,  3963,  3964,  3966,  3970,  3974,  3978,  3982,  3986,  3990,
    3992,  3994,  3996,  3998,  4000,  4002,  4004,  4007,  4013,  4015,
    4017,  4019,  4021,  4024,  4028,  4032,  4033,  4035,  4037,  4039,
    4041,  4043,  4046,  4049,  4052,  4055,  4058,  4060,  4064,  4065,
    4067,  4069,  4071,  4073,  4079,  4082,  4084,  4086,  4088,  4090,
    4096,  4099,  4102,  4105,  4107,  4111,  4115,  4118,  4120,  4121,
    4125,  4126,  4132,  4135,  4141,  4144,  4146,  4150,  4154,  4155,
    4157,  4159,  4161,  4163,  4165,  4167,  4171,  4175,  4179,  4183,
    4187,  4191,  4195,  4196,  4198,  4202,  4208,  4211,  4214,  4218,
    4222,  4226,  4230,  4234,  4238,  4242,  4246,  4250,  4254,  4257,
    4260,  4264,  4268,  4271,  4275,  4281,  4286,  4293,  4297,  4303,
    4308,  4315,  4320,  4327,  4333,  4341,  4344,  4348,  4351,  4356,
    4360,  4364,  4369,  4373,  4378,  4382,  4387,  4393,  4400,  4407,
    4415,  4422,  4430,  4437,  4445,  4449,  4454,  4459,  4466,  4469,
    4473,  4478,  4480,  4484,  4487,  4491,  4495,  4499,  4503,  4507,
    4511,  4515,  4519,  4523,  4527,  4530,  4533,  4539,  4546,  4553,
    4561,  4565,  4570,  4572,  4574,  4577,  4582,  4584,  4586,  4588,
    4591,  4594,  4597,  4599,  4603,  4608,  4614,  4620,  4625,  4627,
    4629,  4634,  4636,  4641,  4643,  4648,  4650,  4655,  4657,  4659,
    4661,  4663,  4670,  4675,  4680,  4685,  4690,  4697,  4703,  4709,
    4715,  4720,  4727,  4732,  4739,  4744,  4749,  4754,  4759,  4765,
    4773,  4781,  4791,  4796,  4803,  4809,  4817,  4825,  4828,  4832,
    4836,  4840,  4845,  4846,  4851,  4853,  4857,  4861,  4863,  4865,
    4867,  4870,  4873,  4874,  4879,  4883,  4889,  4891,  4893,  4895,
    4897,  4899,  4901,  4903,  4905,  4907,  4909,  4911,  4913,  4915,
    4917,  4919,  4924,  4926,  4931,  4933,  4938,  4940,  4943,  4945,
    4948,  4950,  4954,  4958,  4959,  4961,  4965,  4967,  4971,  4975,
    4979,  4981,  4983,  4985,  4987,  4989,  4991,  4993,  4995,  5000,
    5004,  5007,  5011,  5012,  5016,  5020,  5023,  5026,  5028,  5029,
    5032,  5035,  5039,  5042,  5044,  5046,  5050,  5056,  5059,  5061,
    5066,  5069,  5070,  5072,  5073,  5075,  5078,  5081,  5084,  5088,
    5094,  5096,  5099,  5100,  5103,  5105,  5106,  5108,  5110,  5112,
    5116,  5120,  5124,  5126,  5130,  5132,  5134,  5136,  5138,  5140,
    5144,  5146,  5149,  5151,  5155,  5157,  5159,  5161,  5163,  5165,
    5167,  5169,  5172,  5174,  5177,  5181,  5188,  5190,  5192,  5194,
    5196,  5198,  5200,  5202,  5204,  5206,  5208,  5210,  5212,  5214,
    5216,  5218,  5221,  5223,  5225,  5227,  5229,  5232,  5235,  5237,
    5239,  5241,  5243,  5245,  5247,  5249,  5251,  5254,  5257,  5259,
    5261,  5263,  5265,  5267,  5269,  5271,  5273,  5276,  5282,  5284,
    5286,  5288,  5290,  5296,  5300,  5303,  5306,  5310,  5318,  5320,
    5322,  5324,  5325,  5328,  5331,  5333,  5334,  5336,  5340,  5342,
    5345,  5346,  5349,  5350,  5353,  5354,  5356,  5360,  5365,  5369,
    5371,  5373,  5375,  5378,  5379,  5387,  5391,  5393,  5395,  5397,
    5399,  5402,  5403,  5405,  5409,  5413,  5417,  5421,  5422,  5427,
    5433,  5439,  5440,  5442,  5444,  5446,  5448,  5451,  5454,  5457,
    5459,  5462,  5463,  5471,  5472,  5478,  5479,  5484,  5487,  5490,
    5491,  5494,  5496,  5498,  5500,  5502,  5504,  5506,  5508,  5510,
    5512,  5514,  5516,  5522,  5525,  5527,  5531,  5534,  5537,  5541,
    5542,  5548,  5550,  5551,  5557,  5560,  5563,  5565,  5567,  5569,
    5572,  5575,  5579,  5581,  5584,  5587,  5591,  5595,  5600,  5603,
    5605,  5608,  5610,  5612,  5615,  5618,  5622,  5624,  5626,  5628,
    5630,  5631,  5633,  5637,  5643,  5644,  5647,  5648,  5650,  5653,
    5657,  5660,  5662,  5664,  5666,  5667,  5669,  5671,  5673,  5676,
    5679,  5681,  5683,  5684,  5686,  5688,  5690,  5692,  5695,  5698,
    5702,  5703,  5705,  5708,  5710,  5715,  5720,  5721,  5723,  5726,
    5728,  5730,  5734,  5736,  5738,  5743,  5748,  5753,  5755,  5756,
    5760,  5764,  5769,  5771,  5775,  5779,  5784,  5786,  5790,  5794,
    5796,  5803,  5805,  5809,  5813,  5820,  5822,  5826,  5830,  5832,
    5834,  5836,  5838,  5840,  5842,  5844,  5846,  5848,  5850,  5852,
    5854,  5856,  5858,  5860,  5865,  5870,  5872,  5874,  5879,  5884,
    5888,  5889,  5897,  5899,  5900,  5901,  5909,  5913,  5918,  5922,
    5924,  5926,  5928,  5931,  5935,  5941,  5944,  5950,  5953,  5955,
    5957,  5959,  5961,  5963,  5965,  5967,  5969,  5971,  5973,  5975,
    5977,  5979,  5981,  5983,  5985,  5987,  5989,  5991,  5993,  5995,
    5997,  5999,  6001,  6003,  6005,  6007,  6009,  6011,  6013,  6015,
    6017,  6019,  6021,  6023,  6025,  6027,  6029,  6031,  6033,  6035,
    6037,  6039,  6041,  6043,  6045,  6047,  6049,  6051,  6053,  6055,
    6057,  6059,  6061,  6063,  6065,  6067,  6069,  6071,  6073,  6075,
    6077,  6079,  6081,  6083,  6085,  6087,  6089,  6091,  6093,  6095,
    6097,  6099,  6101,  6103,  6105,  6107,  6109,  6111,  6113,  6115,
    6117,  6119,  6121,  6123,  6125,  6127,  6129,  6131,  6133,  6135,
    6137,  6139,  6141,  6143,  6145,  6147,  6149,  6151,  6153,  6155,
    6157,  6159,  6161,  6163,  6165,  6167,  6169,  6171,  6173,  6175,
    6177,  6179,  6181,  6183,  6185,  6187,  6189,  6191,  6193,  6195,
    6197,  6199,  6201,  6203,  6205,  6207,  6209,  6211,  6213,  6215,
    6217,  6219,  6221,  6223,  6225,  6227,  6229,  6231,  6233,  6235,
    6237,  6239,  6241,  6243,  6245,  6247,  6249,  6251,  6253,  6255,
    6257,  6259,  6261,  6263,  6265,  6267,  6269,  6271,  6273,  6275,
    6277,  6279,  6281,  6283,  6285,  6287,  6289,  6291,  6293,  6295,
    6297,  6299,  6301,  6303,  6305,  6307,  6309,  6311,  6313,  6315,
    6317,  6319,  6321,  6323,  6325,  6327,  6329,  6331,  6333,  6335,
    6337,  6339,  6341,  6343,  6345,  6347,  6349,  6351,  6353,  6355,
    6357,  6359,  6361,  6363,  6365,  6367,  6369,  6371,  6373,  6375,
    6377,  6379,  6381,  6383,  6385,  6387,  6389,  6391,  6393,  6395,
    6397,  6399,  6401,  6403,  6405,  6407,  6409,  6411,  6413,  6415,
    6417,  6419,  6421,  6423,  6425,  6427,  6429,  6431,  6433,  6435,
    6437,  6439,  6441,  6443,  6445,  6447,  6449,  6451,  6453,  6455,
    6457,  6459,  6461,  6463,  6465,  6467,  6469,  6471,  6473,  6475,
    6477,  6479,  6481,  6483,  6485,  6487,  6489,  6491,  6493,  6495,
    6497,  6499,  6501,  6503,  6505,  6507,  6509,  6511,  6513,  6515,
    6517,  6519,  6521,  6523,  6525,  6527,  6529,  6531,  6533,  6535,
    6537,  6539,  6541,  6543,  6545,  6547,  6549,  6551,  6553,  6555,
    6557,  6559,  6561,  6563,  6565,  6567,  6569,  6571,  6573,  6575,
    6577,  6579,  6581,  6583,  6585,  6587,  6589,  6591,  6593,  6595,
    6597,  6599,  6601,  6603,  6605,  6607,  6609,  6611,  6613,  6615,
    6617,  6619,  6621,  6623,  6625,  6627,  6629,  6631,  6633,  6635,
    6637,  6639,  6641,  6643,  6645,  6647,  6649,  6651,  6653,  6655,
    6657,  6659,  6661,  6663,  6665,  6667,  6669,  6671,  6673,  6675,
    6677,  6679,  6681,  6683,  6685,  6687,  6689,  6691,  6693,  6695,
    6697,  6699,  6701,  6703,  6705,  6707,  6709,  6711,  6713,  6715,
    6717,  6719,  6721,  6723,  6725,  6727,  6729,  6731,  6733,  6735,
    6737,  6739,  6741,  6743,  6745,  6747,  6749,  6751,  6753,  6755,
    6757,  6759,  6761,  6763,  6765,  6767,  6769,  6771,  6773,  6775,
    6777,  6779,  6781,  6783,  6785,  6787,  6789,  6791,  6793,  6795,
    6797,  6799,  6801,  6803,  6805,  6807,  6809,  6811,  6813,  6815,
    6817,  6819,  6821,  6823,  6825,  6827,  6829,  6831,  6833,  6835,
    6837,  6839,  6841,  6843,  6845,  6847,  6849,  6853,  6855,  6856,
    6858,  6861,  6863,  6866,  6868,  6870,  6873,  6876,  6878,  6880,
    6882,  6884,  6886,  6888,  6891,  6895,  6897,  6900,  6902,  6906,
    6908,  6912,  6914,  6916,  6918,  6920,  6922,  6924,  6926,  6928,
    6930,  6932,  6934,  6936,  6938,  6940,  6942,  6944,  6946,  6948,
    6950,  6952,  6954,  6956,  6958,  6960,  6962,  6964,  6966,  6968,
    6970,  6972,  6974,  6976,  6978,  6980,  6982,  6984,  6986,  6988,
    6990,  6992,  6994,  6996,  6998,  7000,  7002,  7004,  7006,  7008,
    7010,  7012,  7014,  7016,  7018,  7020,  7022,  7024,  7026,  7028,
    7030,  7032,  7034
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     490,     0,    -1,   491,    -1,    -1,   491,   492,    -1,  1039,
     493,   494,   483,    -1,  1039,   494,   483,    -1,  1039,   936,
      -1,   941,    -1,  1052,    -1,   457,    -1,   484,    -1,   485,
      -1,    95,   977,    -1,   730,    -1,   731,    -1,   736,    -1,
     687,    -1,   506,    -1,   704,    -1,   705,    -1,   584,    -1,
     531,    -1,   500,    -1,   499,    -1,   739,    -1,   738,    -1,
     501,    -1,   502,    -1,   744,    -1,   529,    -1,   539,    -1,
     741,    -1,   647,    -1,   526,    -1,   540,    -1,   577,    -1,
     612,    -1,   695,    -1,   740,    -1,   735,    -1,   673,    -1,
     505,    -1,   588,    -1,   624,    -1,   630,    -1,   631,    -1,
     495,    -1,   509,    -1,   583,    -1,   549,    -1,   595,    -1,
     598,    -1,   498,    -1,   726,    -1,   758,    -1,   777,    -1,
     614,    -1,   764,    -1,   530,    -1,   613,    -1,   697,    -1,
     508,    -1,   634,    -1,   635,    -1,   636,    -1,   593,    -1,
     503,    -1,   714,    -1,   638,    -1,   597,    -1,   611,    -1,
     504,    -1,   734,    -1,   750,    -1,   756,    -1,   644,    -1,
     650,    -1,   661,    -1,   665,    -1,   759,    -1,   716,    -1,
     725,    -1,   766,    -1,   715,    -1,   753,    -1,   637,    -1,
     699,    -1,   691,    -1,   692,    -1,   690,    -1,   702,    -1,
     651,    -1,   662,    -1,   706,    -1,   780,    -1,   718,    -1,
     643,    -1,   717,    -1,   770,    -1,   743,    -1,   513,    -1,
     523,    -1,   524,    -1,   723,    -1,   993,    -1,   920,    -1,
     934,    -1,   994,    -1,   974,    -1,   991,    -1,   975,    -1,
     935,    -1,   981,    -1,  1002,    -1,   995,    -1,   982,    -1,
    1009,    -1,  1011,    -1,  1005,    -1,   998,    -1,  1012,    -1,
    1015,    -1,  1017,    -1,   138,   349,   918,   496,   497,    -1,
     431,    -1,    -1,   316,   908,    -1,   316,   292,    -1,   180,
     316,   908,    -1,   408,   316,   908,    -1,   384,    -1,   286,
      -1,   226,    -1,   283,    -1,   139,    -1,   280,    -1,   140,
      -1,   281,    -1,   263,    -1,   284,    -1,   130,   255,   910,
      -1,   418,   413,   908,    -1,   415,   895,    -1,   386,   909,
      -1,    78,   895,    -1,   349,   895,    -1,   221,   349,   895,
      -1,   221,   210,   895,    -1,   138,   415,   918,   496,   497,
      -1,    83,   349,   918,   496,   497,    -1,    83,   349,   918,
     525,    -1,    83,   415,   918,   496,   497,    -1,    83,   415,
     918,   525,    -1,   175,   349,   895,    -1,   175,   349,   216,
     188,   895,    -1,   175,   415,   895,    -1,   175,   415,   216,
     188,   895,    -1,   138,   210,   918,   496,   497,    -1,    83,
     210,   918,   507,   415,   895,    -1,    77,    -1,   175,    -1,
     175,   210,   895,    -1,   175,   210,   216,   188,   895,    -1,
     138,   355,   510,    96,   918,   511,    -1,   138,   355,  1025,
     511,    -1,  1025,    -1,    -1,   511,   512,    -1,    -1,   549,
      -1,   665,    -1,   583,    -1,   598,    -1,   650,    -1,   723,
      -1,   365,   514,    -1,   365,   258,   514,    -1,   365,   363,
     514,    -1,   515,   397,   516,    -1,   515,   486,   516,    -1,
     515,   397,   158,    -1,   515,   486,   158,    -1,   515,   202,
     144,    -1,   395,   446,   520,    -1,   399,   721,    -1,   363,
     116,    90,   399,   721,    -1,   273,   521,    -1,   349,   522,
      -1,   363,    96,   522,    -1,   363,    96,   158,    -1,   435,
     305,   854,    -1,  1024,    -1,   515,   482,  1025,    -1,   518,
      -1,   516,   487,   518,    -1,   330,   407,    -1,   330,   127,
      -1,   339,   330,    -1,   362,    -1,   519,    -1,   916,    -1,
    1025,    -1,   403,    -1,   192,    -1,   302,    -1,   298,    -1,
     916,    -1,  1046,    -1,   842,   913,   844,    -1,   842,   480,
     909,   481,   913,   844,    -1,   158,    -1,   258,    -1,   913,
      -1,   158,    -1,    -1,  1025,    -1,   913,    -1,   368,   515,
     988,    -1,   368,   395,   446,   988,    -1,   368,   399,   243,
     253,   988,    -1,   368,   363,    96,   988,    -1,   368,    81,
      -1,   342,   515,    -1,   342,   395,   446,    -1,   342,   399,
     243,   253,    -1,   342,   363,    96,    -1,   342,    81,    -1,
     365,   514,    -1,   524,    -1,   365,   132,   527,   528,    -1,
      81,    -1,   893,    -1,   161,    -1,   218,    -1,   118,    -1,
     169,    81,    -1,   169,   390,    -1,   169,   392,    -1,   169,
     318,    -1,    83,   388,   814,   532,    -1,    83,   224,   814,
     534,    -1,   533,    -1,   532,   487,   533,    -1,    77,   703,
     554,    -1,    83,   703,  1025,   536,    -1,    83,   703,  1025,
     175,   287,   292,    -1,    83,   703,  1025,   365,   287,   292,
      -1,    83,   703,  1025,   365,   377,   909,    -1,    83,   703,
    1025,   365,   380,  1025,    -1,   175,   703,  1025,   537,    -1,
      83,   703,  1025,   406,   821,   538,    -1,    77,   562,    -1,
     175,   131,   896,   537,    -1,   365,   432,   300,    -1,   121,
     302,   896,    -1,   365,   432,   121,    -1,   178,   401,   896,
      -1,   178,    84,   401,   896,    -1,   178,   341,   401,   896,
      -1,   178,   401,    81,    -1,   178,   401,   415,    -1,   168,
     401,   896,    -1,   168,   401,    81,    -1,   168,   401,   415,
      -1,   178,   353,   896,    -1,   178,    84,   353,   896,    -1,
     178,   341,   353,   896,    -1,   168,   353,   896,    -1,   226,
     894,    -1,   279,   226,   894,    -1,   535,    -1,   535,    -1,
     534,   487,   535,    -1,   313,   397,   918,    -1,   365,   389,
     896,    -1,   365,   615,    -1,   342,   615,    -1,   365,   158,
     845,    -1,   175,   158,    -1,   109,    -1,   344,    -1,    -1,
     416,   845,    -1,    -1,   120,   896,    -1,   120,    81,    -1,
     136,   545,   894,   546,   541,   542,   547,   496,   543,    -1,
     136,   781,   397,   542,   496,   543,    -1,   397,    -1,   202,
      -1,   913,    -1,   378,    -1,   379,    -1,   543,   544,    -1,
      -1,   102,    -1,   300,    -1,   164,   737,   913,    -1,   292,
     737,   913,    -1,   143,    -1,   213,    -1,   329,   737,   908,
      -1,   183,   737,   908,    -1,   198,   329,   565,    -1,   198,
     287,   292,   565,    -1,   102,    -1,    -1,   431,   300,    -1,
      -1,   548,   165,   913,    -1,    -1,   416,    -1,    -1,   138,
     550,   388,   894,   480,   551,   481,   572,   573,   574,   575,
      -1,   138,   550,   388,   894,   297,   894,   480,   551,   481,
     573,   574,   575,    -1,   392,    -1,   390,    -1,   258,   392,
      -1,   258,   390,    -1,   206,   392,    -1,   206,   390,    -1,
      -1,   552,    -1,    -1,   553,    -1,   552,   487,   553,    -1,
     554,    -1,   559,    -1,   562,    -1,  1025,   821,   555,    -1,
     555,   556,    -1,    -1,   131,   896,   557,    -1,   557,    -1,
     558,    -1,   287,   292,    -1,   292,    -1,   410,   686,   576,
      -1,   324,   245,   686,   576,    -1,   117,   480,   845,   481,
      -1,   158,   846,    -1,   334,   894,   564,   567,   568,    -1,
     160,    -1,   287,   160,    -1,   228,   161,    -1,   228,   218,
      -1,   254,   894,   560,    -1,   560,   561,    -1,    -1,   222,
     159,    -1,   186,   159,    -1,   222,   132,    -1,   186,   132,
      -1,   222,   225,    -1,   186,   225,    -1,   131,   896,   563,
      -1,   563,    -1,   117,   480,   845,   481,    -1,   410,   480,
     565,   481,   686,   576,    -1,   324,   245,   480,   565,   481,
     686,   576,    -1,   199,   245,   480,   565,   481,   334,   894,
     564,   567,   568,   608,    -1,   480,   565,   481,    -1,    -1,
     565,   487,   566,    -1,   566,    -1,  1025,    -1,   265,   203,
      -1,   265,   315,    -1,    -1,   569,    -1,   570,    -1,   569,
     570,    -1,   570,   569,    -1,    -1,   302,   163,   571,    -1,
     302,   414,   571,    -1,   279,    76,    -1,   344,    -1,   109,
      -1,   365,   158,    -1,   365,   292,    -1,   227,   480,   893,
     481,    -1,    -1,   431,   615,    -1,   431,   300,    -1,   432,
     300,    -1,    -1,   302,   126,   175,    -1,   302,   126,   163,
     352,    -1,   302,   126,   321,   352,    -1,    -1,   389,   896,
      -1,    -1,   416,   224,   389,   896,    -1,    -1,    -1,   138,
     550,   388,   579,    90,   578,   780,    -1,   894,   580,   573,
     574,   575,    -1,   480,   581,   481,    -1,    -1,   581,   487,
     582,    -1,   582,    -1,  1025,    -1,   138,   550,   361,   894,
     585,    -1,    83,   361,   894,   585,    -1,   585,   586,    -1,
      -1,   107,   915,    -1,   151,    -1,   279,   151,    -1,   223,
     587,   915,    -1,   266,   915,    -1,   268,   915,    -1,   279,
     266,    -1,   279,   268,    -1,   312,   106,   641,    -1,   375,
     496,   915,    -1,   343,   496,   915,    -1,   106,    -1,    -1,
     138,   589,   594,   247,   522,    -1,   138,   589,   594,   247,
     522,   211,   590,   591,   592,    -1,   405,    -1,    -1,   896,
      -1,   896,   642,    -1,   419,   590,    -1,    -1,   246,   913,
      -1,    -1,   175,   594,   247,   913,   537,    -1,   175,   594,
     247,   216,   188,   913,   537,    -1,   327,    -1,    -1,   138,
     389,   896,   596,   261,   908,    -1,   313,   896,    -1,    -1,
     175,   389,   896,    -1,   175,   389,   216,   188,   896,    -1,
     138,   401,   896,   599,   600,   302,   894,   602,   187,   328,
     896,   480,   605,   481,    -1,   138,   131,   401,   896,    79,
     600,   302,   894,   607,   608,   197,   176,   351,   187,   328,
     902,   480,   605,   481,    -1,    98,    -1,    79,    -1,   601,
      -1,   601,   306,   601,    -1,   601,   306,   601,   306,   601,
      -1,   233,    -1,   163,    -1,   414,    -1,   197,   603,   604,
      -1,    -1,   176,    -1,    -1,   351,    -1,   376,    -1,   606,
      -1,   605,   487,   606,    -1,    -1,   917,    -1,  1025,    -1,
      -1,   202,   894,    -1,   609,    -1,   609,   610,    -1,   610,
      -1,   610,   609,    -1,   287,   160,    -1,   160,    -1,   228,
     218,    -1,   228,   161,    -1,   175,   401,   896,   302,   894,
     537,    -1,   175,   401,   216,   188,   896,   302,   894,   537,
      -1,   138,    92,   896,   117,   480,   845,   481,   608,    -1,
     175,    92,   896,    -1,   138,    80,   902,   619,   615,    -1,
     138,    80,   902,   620,    -1,   138,   304,   858,   615,    -1,
     138,   406,   641,   615,    -1,   138,   406,   641,    -1,   138,
     406,   641,    90,   480,   819,   481,    -1,   138,   406,   641,
      90,   182,   480,   623,   481,    -1,   138,   393,   357,   314,
     641,   615,    -1,   138,   393,   357,   167,   641,   615,    -1,
     138,   393,   357,   391,   641,   615,    -1,   138,   393,   357,
     129,   641,   615,    -1,   480,   616,   481,    -1,   617,    -1,
     616,   487,   617,    -1,  1027,   467,   618,    -1,  1027,    -1,
     682,    -1,  1037,    -1,   861,    -1,   916,    -1,   480,   865,
     481,    -1,   480,   473,   481,    -1,   480,   621,   481,    -1,
     622,    -1,   621,   487,   622,    -1,  1046,   467,   618,    -1,
     913,    -1,   623,   487,   913,    -1,   138,   304,   119,   641,
     627,   197,   406,   821,   416,   898,   628,    90,   625,    -1,
     626,    -1,   625,   487,   626,    -1,   304,   909,   694,   629,
      -1,   304,   909,   694,   480,   693,   481,   629,    -1,   204,
     909,   902,   675,    -1,   204,   909,   480,   865,   481,   902,
     675,    -1,   380,   821,    -1,   158,    -1,    -1,   193,   641,
      -1,    -1,   333,    -1,    -1,   138,   304,   193,   641,   416,
     898,    -1,    83,   304,   193,   641,   416,   898,    77,   625,
      -1,    83,   304,   193,   641,   416,   898,   175,   632,    -1,
     633,    -1,   632,   487,   633,    -1,   304,   909,   480,   865,
     481,    -1,   204,   909,   480,   865,   481,    -1,   175,   304,
     119,   641,   416,   898,   537,    -1,   175,   304,   119,   216,
     188,   641,   416,   898,   537,    -1,   175,   304,   193,   641,
     416,   898,   537,    -1,   175,   304,   193,   216,   188,   641,
     416,   898,   537,    -1,   175,   312,   106,   895,   537,    -1,
     332,   312,   106,   895,   397,   896,    -1,   175,   639,   216,
     188,   640,   537,    -1,   175,   639,   640,   537,    -1,   388,
      -1,   361,    -1,   426,    -1,   224,    -1,   406,    -1,   173,
      -1,   134,    -1,   355,    -1,   393,   357,   314,    -1,   393,
     357,   167,    -1,   393,   357,   391,    -1,   393,   357,   129,
      -1,   641,    -1,   640,   487,   641,    -1,  1025,    -1,  1025,
     642,    -1,   482,   899,    -1,   642,   482,   899,    -1,   404,
     787,   893,   537,    -1,   194,   645,   646,   896,   988,    -1,
     194,   645,   896,   988,    -1,   194,   646,   896,   988,    -1,
     194,   896,   988,    -1,   194,   645,   646,   896,    -1,   194,
     645,   896,    -1,   194,   646,   896,    -1,   194,   896,    -1,
     271,   645,   646,   896,    -1,   271,   896,    -1,   278,    -1,
     325,    -1,   195,    -1,   249,    -1,    74,   910,    -1,   336,
     910,    -1,   910,    -1,    81,    -1,   200,    -1,   200,   910,
      -1,   200,    81,    -1,    97,    -1,    97,   910,    -1,    97,
      81,    -1,   221,    -1,   202,    -1,   125,   302,   648,   896,
     241,   649,    -1,   125,   302,    80,   902,   619,   241,   649,
      -1,   125,   302,   204,   902,   675,   241,   649,    -1,   125,
     302,   304,   858,   480,   693,   481,   241,   649,    -1,   125,
     302,   401,   896,   302,   641,   241,   649,    -1,   125,   302,
     353,   896,   302,   641,   241,   649,    -1,   125,   302,   353,
     896,   241,   649,    -1,   125,   302,   304,   119,   641,   416,
     898,   241,   649,    -1,   125,   302,   304,   193,   641,   416,
     898,   241,   649,    -1,   125,   302,   248,   296,   915,   241,
     649,    -1,   125,   302,   112,   480,   821,    90,   821,   481,
     241,   649,    -1,   125,   302,   594,   247,   641,   241,   649,
      -1,   125,   302,   393,   357,   314,   641,   241,   649,    -1,
     125,   302,   393,   357,   167,   641,   241,   649,    -1,   125,
     302,   393,   357,   391,   641,   241,   649,    -1,   125,   302,
     393,   357,   129,   641,   241,   649,    -1,   124,    -1,   152,
      -1,   355,    -1,   224,    -1,   361,    -1,   388,    -1,   173,
      -1,   406,    -1,   426,    -1,   134,    -1,   389,    -1,   349,
      -1,   913,    -1,   292,    -1,   207,   652,   302,   655,   397,
     656,   658,    -1,   347,   652,   302,   655,   202,   656,   537,
      -1,   347,   207,   305,   197,   652,   302,   655,   202,   656,
     537,    -1,    81,   326,    -1,    81,    -1,   653,    -1,   654,
      -1,   653,   487,   654,    -1,   360,    -1,   334,    -1,   138,
      -1,  1025,    -1,   893,    -1,   388,   893,    -1,   361,   893,
      -1,   204,   659,    -1,   152,   895,    -1,   247,   895,    -1,
     355,   895,    -1,   389,   895,    -1,   657,    -1,   656,   487,
     657,    -1,   918,    -1,   210,   918,    -1,   431,   207,   305,
      -1,    -1,   660,    -1,   659,   487,   660,    -1,   902,   675,
      -1,   207,   653,   397,   895,   663,   664,    -1,   347,   653,
     202,   895,   664,   537,    -1,   431,    78,   305,    -1,    -1,
     208,   106,   918,    -1,    -1,   138,   666,   224,   900,   302,
     894,   667,   480,   668,   481,   686,   575,   817,    -1,   138,
     666,   224,   128,   900,   302,   894,   667,   480,   668,   481,
     686,   575,   817,    -1,   410,    -1,    -1,   416,   898,    -1,
      -1,   669,    -1,   668,   487,   669,    -1,  1025,   670,   671,
     672,    -1,   848,   670,   671,   672,    -1,   480,   845,   481,
     670,   671,   672,    -1,   641,    -1,   416,   641,    -1,    -1,
      91,    -1,   166,    -1,    -1,   447,    -1,   448,    -1,    -1,
     138,   674,   204,   902,   675,   346,   681,   683,   686,    -1,
     138,   674,   204,   902,   675,   683,   686,    -1,   306,   340,
      -1,    -1,   480,   676,   481,    -1,   480,   481,    -1,   677,
      -1,   676,   487,   677,    -1,   678,   680,   682,    -1,   680,
     678,   682,    -1,   680,   682,    -1,   678,   682,    -1,   682,
      -1,   221,    -1,   308,    -1,   230,    -1,   221,   308,    -1,
     913,    -1,   913,   487,   913,    -1,  1026,    -1,   682,    -1,
     821,    -1,  1026,   642,   475,   406,    -1,   366,  1026,   642,
     475,   406,    -1,   685,    -1,   683,   685,    -1,   108,   302,
     292,   231,    -1,   346,   292,   302,   292,   231,    -1,   381,
      -1,   219,    -1,   373,    -1,   427,    -1,   190,   359,   162,
      -1,   190,   359,   240,    -1,   359,   162,    -1,   359,   240,
      -1,   137,   915,    -1,   352,   915,    -1,   525,    -1,    90,
     679,    -1,   247,   522,    -1,   684,    -1,   431,   615,    -1,
      -1,    83,   204,   660,   688,   689,    -1,   684,    -1,   688,
     684,    -1,   344,    -1,    -1,   175,   204,   902,   675,   537,
      -1,   175,   204,   216,   188,   902,   675,   537,    -1,   175,
      80,   902,   619,   537,    -1,   175,    80,   216,   188,   902,
     619,   537,    -1,   175,   304,   858,   480,   693,   481,   537,
      -1,   175,   304,   216,   188,   694,   480,   693,   481,   537,
      -1,   821,    -1,   821,   487,   821,    -1,   285,   487,   821,
      -1,   821,   487,   285,    -1,   858,    -1,  1025,   482,   694,
      -1,   138,   112,   480,   821,    90,   821,   481,   431,   204,
     660,   696,    -1,   138,   112,   480,   821,    90,   821,   481,
     432,   204,   696,    -1,    90,    93,    -1,    -1,   175,   112,
     698,   480,   821,    90,   821,   481,   537,    -1,   216,   188,
      -1,    -1,   335,   700,   894,   701,    -1,   335,   387,   896,
     701,    -1,   335,   152,   896,   701,    -1,   224,    -1,   388,
      -1,   198,    -1,    -1,    83,    80,   902,   619,   338,   397,
     896,    -1,    83,   134,   641,   338,   397,   896,    -1,    83,
     152,   897,   338,   397,   897,    -1,    83,   204,   660,   338,
     397,   896,    -1,    83,   210,   918,   338,   397,   918,    -1,
      83,   594,   247,   896,   338,   397,   896,    -1,    83,   304,
     119,   641,   416,   898,   338,   397,   896,    -1,    83,   304,
     193,   641,   416,   898,   338,   397,   896,    -1,    83,   355,
     896,   338,   397,   896,    -1,    83,   388,   814,   338,   397,
     896,    -1,    83,   361,   814,   338,   397,   896,    -1,    83,
     426,   814,   338,   397,   896,    -1,    83,   224,   814,   338,
     397,   896,    -1,    83,   388,   814,   338,   703,   896,   397,
     896,    -1,    83,   401,   896,   302,   814,   338,   397,   896,
      -1,    83,   415,   918,   338,   397,   918,    -1,    83,   389,
     896,   338,   397,   896,    -1,    83,   393,   357,   314,   641,
     338,   397,   896,    -1,    83,   393,   357,   167,   641,   338,
     397,   896,    -1,    83,   393,   357,   391,   641,   338,   397,
     896,    -1,    83,   393,   357,   129,   641,   338,   397,   896,
      -1,   124,    -1,    -1,    83,    80,   902,   619,   365,   355,
     896,    -1,    83,   173,   641,   365,   355,   896,    -1,    83,
     204,   660,   365,   355,   896,    -1,    83,   361,   814,   365,
     355,   896,    -1,    83,   388,   814,   365,   355,   896,    -1,
      83,   406,   641,   365,   355,   896,    -1,    83,    80,   902,
     619,   313,   397,   918,    -1,    83,   134,   641,   313,   397,
     918,    -1,    83,   152,   897,   313,   397,   918,    -1,    83,
     173,   897,   313,   397,   918,    -1,    83,   204,   660,   313,
     397,   918,    -1,    83,   594,   247,   896,   313,   397,   918,
      -1,    83,   304,   694,   480,   693,   481,   313,   397,   918,
      -1,    83,   304,   119,   641,   416,   898,   313,   397,   918,
      -1,    83,   304,   193,   641,   416,   898,   313,   397,   918,
      -1,    83,   355,   896,   313,   397,   918,    -1,    83,   406,
     641,   313,   397,   918,    -1,    83,   389,   896,   313,   397,
     918,    -1,    83,   393,   357,   167,   641,   313,   397,   918,
      -1,    83,   393,   357,   129,   641,   313,   397,   918,    -1,
      -1,   138,   674,   353,   896,    90,   707,   302,   712,   397,
     894,   817,   171,   713,   708,    -1,   288,    -1,   710,    -1,
     480,   709,   481,    -1,   709,   483,   711,    -1,   711,    -1,
     780,    -1,   759,    -1,   770,    -1,   764,    -1,   715,    -1,
     710,    -1,    -1,   360,    -1,   414,    -1,   163,    -1,   233,
      -1,   234,    -1,    82,    -1,    -1,   175,   353,   896,   302,
     894,   537,    -1,   175,   353,   216,   188,   896,   302,   894,
     537,    -1,   289,  1025,    -1,   256,  1025,    -1,   412,  1025,
      -1,   412,   473,    -1,    73,   719,    -1,    99,   719,   722,
      -1,   375,   399,   722,    -1,   126,   719,    -1,   181,   719,
      -1,   350,   719,    -1,   354,  1025,    -1,   337,   354,  1025,
      -1,   337,  1025,    -1,   350,   719,   397,   354,  1025,    -1,
     350,   719,   397,  1025,    -1,   322,   399,   913,    -1,   126,
     323,   913,    -1,   350,   323,   913,    -1,   433,    -1,   399,
      -1,    -1,   243,   253,   517,    -1,   330,   303,    -1,   330,
     434,    -1,   720,    -1,   721,   487,   720,    -1,   721,   720,
      -1,   721,    -1,    -1,   138,   550,   426,   894,   564,    90,
     780,   724,    -1,   138,   306,   340,   550,   426,   894,   564,
      90,   780,   724,    -1,   451,   305,    -1,   449,   117,   305,
      -1,   450,   117,   305,    -1,    -1,   257,   901,    -1,   138,
     152,   897,   431,   727,    -1,   138,   152,   897,    -1,   728,
      -1,   727,   728,    -1,   389,   729,   896,    -1,   389,   729,
     158,    -1,   261,   729,   913,    -1,   261,   729,   158,    -1,
     391,   729,   896,    -1,   391,   729,   158,    -1,   179,   729,
     914,    -1,   179,   729,   158,    -1,   130,   255,   729,   909,
      -1,   313,   729,   896,    -1,   313,   729,   158,    -1,   467,
      -1,    -1,    83,   152,   897,   496,   732,    -1,    83,   152,
     897,   525,    -1,   732,   733,    -1,    -1,   130,   255,   729,
     909,    -1,   175,   152,   897,    -1,   175,   152,   216,   188,
     897,    -1,   138,   173,   641,   737,   821,   555,    -1,    83,
     173,   641,   536,    -1,    83,   173,   641,   175,   287,   292,
      -1,    83,   173,   641,   365,   287,   292,    -1,    83,   173,
     641,    77,   562,    -1,    83,   173,   641,   175,   131,   896,
     537,    -1,    90,    -1,    -1,    83,   393,   357,   167,   641,
     615,    -1,    83,   393,   357,   129,   641,    77,   264,   197,
     895,   431,   640,    -1,    83,   393,   357,   129,   641,    83,
     264,   197,   895,   431,   640,    -1,    83,   393,   357,   129,
     641,    83,   264,   340,   641,   431,   641,    -1,    83,   393,
     357,   129,   641,    83,   264,   197,   895,   340,   641,   431,
     641,    -1,    83,   393,   357,   129,   641,   175,   264,   197,
     895,    -1,    83,   393,   357,   129,   641,   175,   264,   216,
     188,   197,   895,    -1,   138,   627,   134,   641,   197,   913,
     397,   913,   202,   641,    -1,   121,   894,   742,    -1,   121,
      -1,   121,   894,   302,   894,    -1,   416,   900,    -1,    -1,
     417,   747,   748,   746,    -1,   417,   747,   748,   746,   894,
      -1,   417,   747,   748,   746,   744,    -1,   745,   746,    -1,
     745,   746,   894,   749,    -1,    86,    -1,    85,    -1,   424,
      -1,    -1,   203,    -1,    -1,   201,    -1,    -1,   480,   895,
     481,    -1,    -1,   189,   752,   746,   751,    -1,   780,    -1,
     759,    -1,   770,    -1,   764,    -1,   777,    -1,   756,    -1,
     745,    -1,    -1,   322,   980,   755,    90,   754,    -1,   322,
     980,   202,   979,    -1,   780,    -1,   759,    -1,   770,    -1,
     764,    -1,   480,   865,   481,    -1,    -1,   187,   980,   757,
     978,    -1,   138,   550,   388,   579,    90,   187,   980,   757,
      -1,   480,   863,   481,    -1,    -1,   154,   980,    -1,   154,
     322,   980,    -1,   154,    81,    -1,   154,   322,    81,    -1,
     233,   239,   894,   760,   763,    -1,   780,    -1,   480,   761,
     481,   780,    -1,   158,   421,    -1,   761,   487,   762,    -1,
     762,    -1,  1025,   885,    -1,   345,   890,    -1,    -1,   163,
     202,   815,   765,   818,   763,    -1,   416,   807,    -1,    -1,
     262,   787,   893,   767,   769,    -1,   221,   768,   269,    -1,
      -1,    75,   367,    -1,   351,   367,    -1,   351,   185,    -1,
     367,   414,   185,    -1,   367,    -1,   367,   351,   185,    -1,
     185,    -1,    75,   185,    -1,   291,    -1,    -1,   414,   815,
     365,   771,   806,   818,   763,    -1,   772,    -1,   771,   487,
     772,    -1,   773,    -1,   774,    -1,   775,   467,   887,    -1,
     480,   776,   481,   467,   889,    -1,  1025,   885,    -1,   775,
      -1,   776,   487,   775,    -1,   157,   896,   778,   150,   779,
     197,   780,    -1,    -1,   778,   102,    -1,   778,   232,    -1,
     778,   356,    -1,   778,   279,   356,    -1,    -1,   431,   214,
      -1,   432,   214,    -1,   782,    -1,   781,    -1,   480,   782,
     481,    -1,   480,   781,   481,    -1,   784,    -1,   783,   791,
      -1,   783,   790,   800,   795,    -1,   783,   790,   794,   801,
      -1,   784,    -1,   781,    -1,   360,   789,   890,   785,   806,
     817,   798,   799,    -1,   805,    -1,   783,   409,   788,   783,
      -1,   783,   237,   788,   783,    -1,   783,   184,   788,   783,
      -1,   239,   786,    -1,   988,    -1,    -1,   392,   787,   894,
      -1,   390,   787,   894,    -1,   258,   392,   787,   894,    -1,
     258,   390,   787,   894,    -1,   206,   392,   787,   894,    -1,
     206,   390,   787,   894,    -1,   388,   894,    -1,   894,    -1,
     388,    -1,    -1,    81,    -1,    -1,   170,    -1,   170,   302,
     480,   863,   481,    -1,    81,    -1,    -1,   791,    -1,    -1,
     307,   106,   792,    -1,   793,    -1,   792,   487,   793,    -1,
     845,   416,   861,   672,    -1,   845,   671,   672,    -1,   255,
     796,   299,   797,    -1,   299,   797,   255,   796,    -1,   255,
     796,    -1,   299,   797,    -1,   255,   796,   487,   797,    -1,
     794,    -1,    -1,   845,    -1,    81,    -1,   845,    -1,   210,
     106,   863,    -1,    -1,   212,   845,    -1,    -1,   802,    -1,
     197,   330,   303,    -1,   800,    -1,    -1,   803,    -1,   802,
     803,    -1,   197,   414,   804,   769,    -1,   197,   367,   804,
     769,    -1,   297,   895,    -1,    -1,   421,   889,    -1,   805,
     487,   889,    -1,   202,   807,    -1,    -1,   807,   487,   808,
      -1,   808,    -1,   814,    -1,   814,   810,    -1,   816,    -1,
     816,   810,    -1,   816,    90,   480,   819,   481,    -1,   816,
      90,  1025,   480,   819,   481,    -1,   816,  1025,   480,   819,
     481,    -1,   781,    -1,   781,   810,    -1,   809,    -1,   480,
     809,   481,   810,    -1,   480,   809,   481,    -1,   808,   142,
     244,   808,    -1,   808,   811,   244,   808,   813,    -1,   808,
     244,   808,   813,    -1,   808,   275,   811,   244,   808,    -1,
     808,   275,   244,   808,    -1,    90,  1025,   480,   895,   481,
      -1,    90,  1025,    -1,  1025,   480,   895,   481,    -1,  1025,
      -1,   203,   812,    -1,   252,   812,    -1,   348,   812,    -1,
     229,    -1,   309,    -1,    -1,   416,   480,   895,   481,    -1,
     302,   845,    -1,   894,    -1,   894,   473,    -1,   303,   894,
      -1,   303,   480,   894,   481,    -1,   814,    -1,   814,  1025,
      -1,   814,    90,  1025,    -1,   848,    -1,   429,   845,    -1,
      -1,   429,   845,    -1,   429,   144,   297,   896,    -1,   429,
     144,   297,   465,    -1,    -1,   820,    -1,   819,   487,   820,
      -1,  1025,   821,    -1,   824,   822,    -1,   366,   824,   822,
      -1,   824,    89,   478,   909,   479,    -1,   366,   824,    89,
     478,   909,   479,    -1,   478,   479,   822,    -1,   478,   823,
     479,   822,    -1,    -1,   909,    -1,   480,   823,   481,    -1,
     823,   471,   823,    -1,   823,   472,   823,    -1,   823,   473,
     823,    -1,   823,   474,   823,    -1,   823,   475,   823,    -1,
     908,    -1,  1025,    -1,   826,    -1,   841,    -1,   828,    -1,
     830,    -1,   834,    -1,   842,   844,    -1,   842,   480,   909,
     481,   844,    -1,   828,    -1,   831,    -1,   835,    -1,   841,
      -1,  1026,   827,    -1,  1026,   642,   827,    -1,   480,   863,
     481,    -1,    -1,   235,    -1,   236,    -1,   371,    -1,   101,
      -1,   331,    -1,   196,   829,    -1,   174,   320,    -1,   156,
     827,    -1,   155,   827,    -1,   295,   827,    -1,   104,    -1,
     480,   909,   481,    -1,    -1,   832,    -1,   833,    -1,   832,
      -1,   833,    -1,   103,   839,   480,   863,   481,    -1,   103,
     839,    -1,   836,    -1,   837,    -1,   836,    -1,   837,    -1,
     838,   480,   909,   481,   840,    -1,   838,   840,    -1,   115,
     839,    -1,   114,   839,    -1,   422,    -1,   274,   115,   839,
      -1,   274,   114,   839,    -1,   276,   839,    -1,   423,    -1,
      -1,   115,   365,  1025,    -1,    -1,   396,   480,   909,   481,
     843,    -1,   396,   843,    -1,   395,   480,   909,   481,   843,
      -1,   395,   843,    -1,   238,    -1,   431,   395,   446,    -1,
     432,   395,   446,    -1,    -1,   444,    -1,   270,    -1,   153,
      -1,   215,    -1,   267,    -1,   358,    -1,   444,   397,   270,
      -1,   153,   397,   215,    -1,   153,   397,   267,    -1,   153,
     397,   358,    -1,   215,   397,   267,    -1,   267,   397,   358,
      -1,   215,   397,   358,    -1,    -1,   847,    -1,   845,    72,
     821,    -1,   845,    95,   395,   446,   845,    -1,   471,   845,
      -1,   472,   845,    -1,   845,   471,   845,    -1,   845,   472,
     845,    -1,   845,   473,   845,    -1,   845,   474,   845,    -1,
     845,   475,   845,    -1,   845,   476,   845,    -1,   845,   468,
     845,    -1,   845,   469,   845,    -1,   845,   467,   845,    -1,
     845,   860,   845,    -1,   860,   845,    -1,   845,   860,    -1,
     845,    87,   845,    -1,   845,   306,   845,    -1,   287,   845,
      -1,   845,   254,   845,    -1,   845,   254,   845,   183,   845,
      -1,   845,   287,   254,   845,    -1,   845,   287,   254,   845,
     183,   845,    -1,   845,   217,   845,    -1,   845,   217,   845,
     183,   845,    -1,   845,   287,   217,   845,    -1,   845,   287,
     217,   845,   183,   845,    -1,   845,   369,   397,   845,    -1,
     845,   369,   397,   845,   183,   845,    -1,   845,   287,   369,
     397,   845,    -1,   845,   287,   369,   397,   845,   183,   845,
      -1,   845,   242,    -1,   845,   241,   292,    -1,   845,   290,
      -1,   845,   241,   287,   292,    -1,   856,   310,   856,    -1,
     845,   241,   403,    -1,   845,   241,   287,   403,    -1,   845,
     241,   192,    -1,   845,   241,   287,   192,    -1,   845,   241,
     411,    -1,   845,   241,   287,   411,    -1,   845,   241,   170,
     202,   845,    -1,   845,   241,   287,   170,   202,   845,    -1,
     845,   241,   297,   480,   865,   481,    -1,   845,   241,   287,
     297,   480,   865,   481,    -1,   845,   100,   886,   846,    87,
     846,    -1,   845,   287,   100,   886,   846,    87,   846,    -1,
     845,   100,   385,   846,    87,   846,    -1,   845,   287,   100,
     385,   846,    87,   846,    -1,   845,   221,   876,    -1,   845,
     287,   221,   876,    -1,   845,   862,   857,   781,    -1,   845,
     862,   857,   480,   845,   481,    -1,   410,   781,    -1,   845,
     241,   172,    -1,   845,   241,   287,   172,    -1,   847,    -1,
     846,    72,   821,    -1,   472,   846,    -1,   846,   471,   846,
      -1,   846,   472,   846,    -1,   846,   473,   846,    -1,   846,
     474,   846,    -1,   846,   475,   846,    -1,   846,   476,   846,
      -1,   846,   468,   846,    -1,   846,   469,   846,    -1,   846,
     467,   846,    -1,   846,   454,   846,    -1,   860,   846,    -1,
     846,   860,    -1,   846,   241,   170,   202,   846,    -1,   846,
     241,   287,   170,   202,   846,    -1,   846,   241,   297,   480,
     846,   481,    -1,   846,   241,   287,   297,   480,   846,   481,
      -1,   846,   241,   172,    -1,   846,   241,   287,   172,    -1,
     882,    -1,   903,    -1,   465,   885,    -1,   480,   845,   481,
     885,    -1,   877,    -1,   848,    -1,   781,    -1,   188,   781,
      -1,    89,   781,    -1,    89,   867,    -1,   856,    -1,   902,
     480,   481,    -1,   902,   480,   863,   481,    -1,   902,   480,
      81,   863,   481,    -1,   902,   480,   170,   863,   481,    -1,
     902,   480,   473,   481,    -1,   145,    -1,   147,    -1,   147,
     480,   909,   481,    -1,   148,    -1,   148,   480,   909,   481,
      -1,   259,    -1,   259,   480,   909,   481,    -1,   260,    -1,
     260,   480,   909,   481,    -1,   146,    -1,   149,    -1,   364,
      -1,   415,    -1,   112,   480,   845,    90,   821,   481,    -1,
     191,   480,   864,   481,    -1,   311,   480,   869,   481,    -1,
     319,   480,   871,   481,    -1,   383,   480,   872,   481,    -1,
     400,   480,   845,    90,   821,   481,    -1,   402,   480,   105,
     875,   481,    -1,   402,   480,   250,   875,   481,    -1,   402,
     480,   398,   875,   481,    -1,   402,   480,   875,   481,    -1,
     135,   480,   845,   416,   641,   481,    -1,   135,   480,   863,
     481,    -1,   293,   480,   845,   487,   845,   481,    -1,   122,
     480,   863,   481,    -1,   209,   480,   863,   481,    -1,   251,
     480,   863,   481,    -1,   437,   480,   863,   481,    -1,   438,
     480,   272,  1027,   481,    -1,   438,   480,   272,  1027,   487,
     851,   481,    -1,   438,   480,   272,  1027,   487,   863,   481,
      -1,   438,   480,   272,  1027,   487,   851,   487,   863,   481,
      -1,   439,   480,   852,   481,    -1,   440,   480,   854,   845,
     855,   481,    -1,   441,   480,   272,  1027,   481,    -1,   441,
     480,   272,  1027,   487,   845,   481,    -1,   442,   480,   845,
     487,   849,   850,   481,    -1,   425,   845,    -1,   425,   279,
     420,    -1,   487,   374,   445,    -1,   487,   374,   279,    -1,
     487,   374,   279,   420,    -1,    -1,   436,   480,   852,   481,
      -1,   853,    -1,   852,   487,   853,    -1,   845,    90,  1027,
      -1,   845,    -1,   172,    -1,   133,    -1,   321,   430,    -1,
     382,   430,    -1,    -1,   351,   480,   863,   481,    -1,   351,
     480,   481,    -1,   480,   863,   487,   845,   481,    -1,    88,
      -1,   372,    -1,    81,    -1,   454,    -1,   859,    -1,   471,
      -1,   472,    -1,   473,    -1,   475,    -1,   476,    -1,   474,
      -1,   468,    -1,   469,    -1,   467,    -1,   454,    -1,   304,
     480,   694,   481,    -1,   858,    -1,   304,   480,   694,   481,
      -1,   858,    -1,   304,   480,   694,   481,    -1,   254,    -1,
     287,   254,    -1,   217,    -1,   287,   217,    -1,   845,    -1,
     863,   487,   845,    -1,   868,   202,   845,    -1,    -1,   821,
      -1,   865,   487,   821,    -1,   867,    -1,   866,   487,   867,
      -1,   478,   863,   479,    -1,   478,   866,   479,    -1,  1046,
      -1,   444,    -1,   270,    -1,   153,    -1,   215,    -1,   267,
      -1,   358,    -1,   913,    -1,   845,   870,   873,   874,    -1,
     845,   870,   873,    -1,   317,   845,    -1,   846,   221,   846,
      -1,    -1,   845,   873,   874,    -1,   845,   874,   873,    -1,
     845,   873,    -1,   845,   874,    -1,   863,    -1,    -1,   202,
     845,    -1,   197,   845,    -1,   845,   202,   863,    -1,   202,
     863,    -1,   863,    -1,   781,    -1,   480,   863,   481,    -1,
     111,   881,   878,   880,   181,    -1,   878,   879,    -1,   879,
      -1,   428,   845,   394,   845,    -1,   177,   845,    -1,    -1,
     845,    -1,    -1,   892,    -1,   892,   884,    -1,   482,   899,
      -1,   482,   473,    -1,   478,   845,   479,    -1,   478,   845,
     488,   845,   479,    -1,   883,    -1,   884,   883,    -1,    -1,
     885,   883,    -1,    94,    -1,    -1,   845,    -1,   158,    -1,
     887,    -1,   888,   487,   887,    -1,   480,   888,   481,    -1,
     890,   487,   891,    -1,   891,    -1,   845,    90,  1027,    -1,
     845,    -1,   473,    -1,   919,    -1,  1025,    -1,   894,    -1,
     893,   487,   894,    -1,   892,    -1,   892,   884,    -1,   896,
      -1,   895,   487,   896,    -1,  1025,    -1,  1025,    -1,  1025,
      -1,  1027,    -1,  1025,    -1,   913,    -1,  1026,    -1,   892,
     884,    -1,   917,    -1,   825,   913,    -1,   842,   913,   844,
      -1,   842,   480,   909,   481,   913,   844,    -1,   403,    -1,
     192,    -1,   292,    -1,  1042,    -1,   464,    -1,   466,    -1,
     459,    -1,   460,    -1,   453,    -1,   462,    -1,   463,    -1,
     461,    -1,   904,    -1,  1043,    -1,   909,    -1,   472,   909,
      -1,   904,    -1,  1045,    -1,   905,    -1,   911,    -1,   472,
     905,    -1,   472,   904,    -1,   908,    -1,   908,    -1,  1043,
      -1,   904,    -1,   908,    -1,  1043,    -1,   905,    -1,   904,
      -1,   472,   905,    -1,   472,   904,    -1,  1043,    -1,   908,
      -1,   915,    -1,   908,    -1,   905,    -1,   904,    -1,   906,
      -1,   907,    -1,   902,   908,    -1,   902,   480,   863,   481,
     908,    -1,  1043,    -1,  1025,    -1,   301,    -1,   277,    -1,
       9,   397,   921,   928,   929,    -1,     9,   397,   158,    -1,
       9,   930,    -1,   152,   921,    -1,   922,   925,   927,    -1,
     923,   488,   924,   927,   474,   922,   933,    -1,   932,    -1,
     908,    -1,   897,    -1,    -1,  1046,  1045,    -1,   454,   926,
      -1,   924,    -1,    -1,  1025,    -1,  1025,   482,   926,    -1,
     458,    -1,   488,   909,    -1,    -1,    90,   977,    -1,    -1,
     415,   930,    -1,    -1,   931,    -1,   931,   474,   931,    -1,
     931,    22,   106,   931,    -1,   931,   416,   931,    -1,   918,
      -1,   913,    -1,  1045,    -1,   454,  1025,    -1,    -1,   157,
     896,   778,   150,   779,   197,   980,    -1,   187,   218,   979,
      -1,   937,    -1,   948,    -1,   950,    -1,   915,    -1,   487,
     915,    -1,    -1,   844,    -1,   444,   397,   267,    -1,   444,
     397,   358,    -1,   153,   397,   153,    -1,   270,   397,   270,
      -1,    -1,   943,   942,   945,   944,    -1,  1039,    99,   157,
      35,   483,    -1,  1039,   181,   157,    35,   483,    -1,    -1,
     946,    -1,   457,    -1,   950,    -1,   948,    -1,   946,   950,
      -1,   946,   948,    -1,   946,   457,    -1,   950,    -1,   947,
     950,    -1,    -1,    71,   949,   957,   973,  1028,   822,   483,
      -1,    -1,   954,   957,   951,   970,   483,    -1,    -1,   957,
     952,   970,   483,    -1,   960,   483,    -1,   488,   904,    -1,
      -1,   955,   956,    -1,   955,    -1,   956,    -1,    57,    -1,
      68,    -1,    66,    -1,    51,    -1,    52,    -1,    70,    -1,
     966,    -1,   962,    -1,   958,    -1,  1028,   480,   938,   939,
     481,    -1,  1028,   940,    -1,   964,    -1,   182,  1023,   959,
      -1,   182,   959,    -1,   182,  1023,    -1,   484,  1050,   485,
      -1,    -1,   964,   961,   484,   947,   485,    -1,   960,    -1,
      -1,   965,   963,   484,   947,   485,    -1,    44,  1023,    -1,
     409,  1023,    -1,    44,    -1,   409,    -1,   967,    -1,   969,
     968,    -1,    45,    36,    -1,    45,    36,   235,    -1,    45,
      -1,    45,   235,    -1,    45,    26,    -1,    45,    26,   235,
      -1,    45,    26,    26,    -1,    45,    26,    26,   235,    -1,
      45,   114,    -1,    36,    -1,    36,   235,    -1,   235,    -1,
      26,    -1,    26,   235,    -1,    26,    26,    -1,    26,    26,
     235,    -1,     5,    -1,   114,    -1,   174,    -1,    37,    -1,
      -1,   971,    -1,   970,   487,   971,    -1,   973,  1029,   822,
     953,   972,    -1,    -1,   467,  1051,    -1,    -1,   473,    -1,
     473,   473,    -1,   157,   376,  1046,    -1,    17,   976,    -1,
     977,    -1,   144,    -1,    81,    -1,    -1,   897,    -1,   158,
      -1,   932,    -1,   984,   988,    -1,   988,   984,    -1,   984,
      -1,   988,    -1,    -1,   932,    -1,   455,    -1,   896,    -1,
     932,    -1,    19,   896,    -1,    19,    81,    -1,    29,   896,
     983,    -1,    -1,   984,    -1,   416,   989,    -1,   985,    -1,
     416,   987,    16,  1047,    -1,   239,   987,    16,  1047,    -1,
      -1,    38,    -1,   239,  1038,    -1,   986,    -1,   990,    -1,
     990,   487,   989,    -1,   916,    -1,  1042,    -1,    15,   231,
     896,   985,    -1,    15,   992,   896,   985,    -1,    15,   992,
     896,   986,    -1,    30,    -1,    -1,     3,    16,  1047,    -1,
     154,    16,  1047,    -1,   205,    16,  1047,   996,    -1,   997,
      -1,   996,   487,   997,    -1,  1045,   467,  1001,    -1,   365,
      16,  1047,   999,    -1,  1000,    -1,   999,   487,  1000,    -1,
    1001,   467,   911,    -1,    11,    -1,   205,    16,  1047,   420,
     911,  1003,    -1,  1004,    -1,  1003,   487,  1004,    -1,  1045,
     467,  1008,    -1,   365,    16,  1047,   420,   911,  1006,    -1,
    1007,    -1,  1006,   487,  1007,    -1,  1008,   467,   912,    -1,
       8,    -1,    12,    -1,    13,    -1,    14,    -1,    23,    -1,
      24,    -1,    25,    -1,   272,    -1,    27,    -1,    28,    -1,
     320,    -1,    32,    -1,    33,    -1,    34,    -1,   406,    -1,
     365,     4,   467,  1010,    -1,   365,     4,   397,  1010,    -1,
     302,    -1,   298,    -1,   365,   130,   397,   977,    -1,   365,
     130,   467,   977,    -1,   365,   130,   977,    -1,    -1,   406,
    1013,  1028,   241,   957,   822,  1014,    -1,    31,    -1,    -1,
      -1,    46,  1016,  1027,   241,   957,   822,  1014,    -1,    47,
      39,  1018,    -1,    47,   287,    18,  1018,    -1,    47,    41,
    1018,    -1,    10,    -1,    40,    -1,    43,    -1,    21,   896,
      -1,    20,   397,   896,    -1,   171,   896,   480,  1040,   481,
      -1,   171,     6,    -1,     7,   896,   480,  1040,   481,    -1,
       7,   896,    -1,  1020,    -1,  1021,    -1,     6,    -1,     7,
      -1,     8,    -1,    10,    -1,    11,    -1,    12,    -1,    13,
      -1,    14,    -1,    18,    -1,    20,    -1,    21,    -1,    22,
      -1,    23,    -1,    24,    -1,    25,    -1,    27,    -1,    28,
      -1,    32,    -1,    33,    -1,    34,    -1,    35,    -1,    39,
      -1,    40,    -1,    41,    -1,    43,    -1,     9,    -1,    15,
      -1,    17,    -1,    29,    -1,    46,    -1,    47,    -1,     5,
      -1,    26,    -1,    30,    -1,    36,    -1,    44,    -1,    37,
      -1,    45,    -1,  1027,    -1,  1046,    -1,  1032,    -1,  1034,
      -1,  1035,    -1,  1019,    -1,  1030,    -1,   114,    -1,   421,
      -1,  1046,    -1,  1031,    -1,  1035,    -1,  1019,    -1,  1030,
      -1,   114,    -1,   421,    -1,  1046,    -1,  1031,    -1,  1036,
      -1,  1019,    -1,  1022,    -1,  1030,    -1,  1029,    -1,  1022,
      -1,   114,    -1,   231,    -1,   235,    -1,   409,    -1,   397,
      -1,  1030,    -1,  1032,    -1,  1046,    -1,  1035,    -1,  1036,
      -1,  1020,    -1,  1028,    -1,  1037,    -1,  1033,    -1,  1021,
      -1,    51,    -1,    52,    -1,    57,    -1,    66,    -1,    68,
      -1,    71,    -1,    70,    -1,  1032,    -1,  1033,    -1,   153,
      -1,   215,    -1,   267,    -1,   270,    -1,   358,    -1,   444,
      -1,  1034,    -1,   130,    -1,    73,    -1,    74,    -1,    75,
      -1,    76,    -1,    77,    -1,    78,    -1,    79,    -1,    80,
      -1,    82,    -1,    83,    -1,    84,    -1,    92,    -1,    93,
      -1,    95,    -1,    97,    -1,    98,    -1,    99,    -1,   106,
      -1,   107,    -1,   109,    -1,   110,    -1,   113,    -1,   116,
      -1,   118,    -1,   119,    -1,   120,    -1,   121,    -1,   125,
      -1,   126,    -1,   127,    -1,   128,    -1,   129,    -1,   132,
      -1,   133,    -1,   134,    -1,   136,    -1,   137,    -1,   139,
      -1,   140,    -1,   141,    -1,   143,    -1,   150,    -1,   151,
      -1,   152,    -1,   154,    -1,   157,    -1,   159,    -1,   161,
      -1,   163,    -1,   164,    -1,   165,    -1,   167,    -1,   168,
      -1,   169,    -1,   172,    -1,   173,    -1,   174,    -1,   175,
      -1,   176,    -1,   178,    -1,   179,    -1,   180,    -1,   183,
      -1,   186,    -1,   185,    -1,   187,    -1,   189,    -1,   190,
      -1,   193,    -1,   194,    -1,   195,    -1,   198,    -1,   200,
      -1,   204,    -1,   206,    -1,   208,    -1,   211,    -1,   213,
      -1,   214,    -1,   216,    -1,   218,    -1,   219,    -1,   220,
      -1,   222,    -1,   223,    -1,   224,    -1,   225,    -1,   226,
      -1,   227,    -1,   232,    -1,   233,    -1,   234,    -1,   243,
      -1,   245,    -1,   246,    -1,   247,    -1,   248,    -1,   249,
      -1,   253,    -1,   256,    -1,   257,    -1,   258,    -1,   261,
      -1,   262,    -1,   263,    -1,   264,    -1,   265,    -1,   266,
      -1,   268,    -1,   269,    -1,   271,    -1,   272,    -1,   273,
      -1,   278,    -1,   279,    -1,   280,    -1,   281,    -1,   282,
      -1,   283,    -1,   284,    -1,   286,    -1,   288,    -1,   289,
      -1,   291,    -1,   294,    -1,   296,    -1,   297,    -1,   300,
      -1,   304,    -1,   305,    -1,   312,    -1,   313,    -1,   314,
      -1,   315,    -1,   316,    -1,   318,    -1,   322,    -1,   323,
      -1,   321,    -1,   325,    -1,   326,    -1,   327,    -1,   328,
      -1,   329,    -1,   330,    -1,   332,    -1,   333,    -1,   335,
      -1,   336,    -1,   337,    -1,   338,    -1,   339,    -1,   340,
      -1,   341,    -1,   342,    -1,   343,    -1,   344,    -1,   346,
      -1,   347,    -1,   349,    -1,   350,    -1,   352,    -1,   353,
      -1,   354,    -1,   355,    -1,   356,    -1,   357,    -1,   361,
      -1,   362,    -1,   363,    -1,   365,    -1,   367,    -1,   368,
      -1,   370,    -1,   373,    -1,   374,    -1,   375,    -1,   376,
      -1,   377,    -1,   378,    -1,   379,    -1,   380,    -1,   381,
      -1,   382,    -1,   384,    -1,   387,    -1,   386,    -1,   389,
      -1,   390,    -1,   391,    -1,   392,    -1,   393,    -1,   399,
      -1,   401,    -1,   404,    -1,   405,    -1,   406,    -1,   407,
      -1,   408,    -1,   411,    -1,   412,    -1,   413,    -1,   414,
      -1,   417,    -1,   418,    -1,   419,    -1,   420,    -1,   423,
      -1,   425,    -1,   426,    -1,   427,    -1,   430,    -1,   431,
      -1,   432,    -1,   433,    -1,   434,    -1,   435,    -1,   445,
      -1,   446,    -1,   101,    -1,   103,    -1,   115,    -1,   122,
      -1,   135,    -1,   155,    -1,   156,    -1,   188,    -1,   191,
      -1,   196,    -1,   209,    -1,   230,    -1,   236,    -1,   238,
      -1,   251,    -1,   274,    -1,   276,    -1,   285,    -1,   293,
      -1,   295,    -1,   308,    -1,   311,    -1,   319,    -1,   320,
      -1,   331,    -1,   351,    -1,   366,    -1,   371,    -1,   383,
      -1,   395,    -1,   396,    -1,   400,    -1,   402,    -1,   422,
      -1,   436,    -1,   437,    -1,   438,    -1,   439,    -1,   440,
      -1,   441,    -1,   442,    -1,   443,    -1,    96,    -1,   100,
      -1,   102,    -1,   142,    -1,   201,    -1,   203,    -1,   217,
      -1,   229,    -1,   241,    -1,   242,    -1,   244,    -1,   252,
      -1,   254,    -1,   275,    -1,   290,    -1,   309,    -1,   310,
      -1,   348,    -1,   369,    -1,   424,    -1,    81,    -1,    85,
      -1,    86,    -1,    87,    -1,    88,    -1,    89,    -1,    90,
      -1,    91,    -1,    94,    -1,   105,    -1,   111,    -1,   112,
      -1,   117,    -1,   123,    -1,   124,    -1,   131,    -1,   138,
      -1,   144,    -1,   145,    -1,   147,    -1,   148,    -1,   146,
      -1,   149,    -1,   158,    -1,   160,    -1,   166,    -1,   170,
      -1,   171,    -1,   177,    -1,   181,    -1,   184,    -1,   192,
      -1,   197,    -1,   199,    -1,   202,    -1,   207,    -1,   210,
      -1,   212,    -1,   221,    -1,   228,    -1,   237,    -1,   239,
      -1,   250,    -1,   255,    -1,   277,    -1,   287,    -1,   292,
      -1,   298,    -1,   299,    -1,   301,    -1,   302,    -1,   303,
      -1,   306,    -1,   307,    -1,   324,    -1,   334,    -1,   345,
      -1,   360,    -1,   364,    -1,   372,    -1,   385,    -1,   388,
      -1,   394,    -1,   398,    -1,   403,    -1,   410,    -1,   415,
      -1,   416,    -1,   428,    -1,   429,    -1,  1041,    -1,  1038,
     487,  1041,    -1,    42,    -1,    -1,  1050,    -1,  1045,  1044,
      -1,  1045,    -1,  1045,  1044,    -1,  1045,    -1,  1045,    -1,
      23,  1045,    -1,    23,   896,    -1,   456,    -1,   452,    -1,
     455,    -1,   896,    -1,   932,    -1,  1053,    -1,   480,   481,
      -1,   480,  1049,   481,    -1,  1048,    -1,  1049,  1048,    -1,
    1051,    -1,  1050,   487,  1051,    -1,  1049,    -1,   484,  1050,
     485,    -1,  1053,    -1,   480,    -1,   481,    -1,   487,    -1,
     483,    -1,   452,    -1,   455,    -1,   904,    -1,   905,    -1,
     908,    -1,   473,    -1,   471,    -1,   472,    -1,   474,    -1,
     475,    -1,   292,    -1,    48,    -1,    49,    -1,    50,    -1,
      51,    -1,    52,    -1,    53,    -1,    54,    -1,    55,    -1,
      56,    -1,    57,    -1,    58,    -1,    59,    -1,    61,    -1,
      60,    -1,    62,    -1,    63,    -1,    64,    -1,    65,    -1,
      66,    -1,    67,    -1,    68,    -1,    69,    -1,    71,    -1,
      70,    -1,     5,    -1,   182,    -1,   215,    -1,   235,    -1,
      26,    -1,   267,    -1,   270,    -1,   358,    -1,    36,    -1,
      37,    -1,    44,    -1,    45,    -1,   444,    -1,   114,    -1,
     196,    -1,   397,    -1,   409,    -1,   422,    -1,   478,    -1,
     479,    -1,   467,    -1,   488,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   686,   686,   688,   689,   692,   693,   694,   700,   701,
     702,   703,   704,   707,   720,   721,   722,   723,   724,   725,
     726,   727,   728,   729,   730,   731,   732,   733,   734,   735,
     736,   737,   761,   762,   763,   764,   765,   766,   767,   768,
     769,   770,   771,   772,   773,   774,   775,   776,   777,   778,
     779,   780,   781,   782,   783,   784,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   829,   830,   831,   832,
     833,   834,   835,   836,   837,   838,   839,   845,   846,   847,
     848,   849,   850,   851,   852,   853,   859,   869,   873,   881,
     885,   896,   906,   907,   918,   925,   931,   942,   948,   957,
     964,   970,   979,   986,  1007,  1011,  1012,  1021,  1022,  1023,
    1024,  1025,  1026,  1027,  1028,  1029,  1030,  1031,  1032,  1033,
    1034,  1035,  1036,  1037,  1038,  1039,  1040,  1041,  1042,  1052,
    1063,  1067,  1077,  1080,  1090,  1092,  1102,  1104,  1115,  1125,
    1129,  1130,  1139,  1141,  1152,  1154,  1158,  1159,  1162,  1163,
    1170,  1171,  1172,  1173,  1174,  1175,  1188,  1190,  1192,  1197,
    1199,  1201,  1203,  1205,  1208,  1210,  1212,  1214,  1216,  1218,
    1220,  1222,  1226,  1227,  1231,  1233,  1237,  1238,  1239,  1240,
    1243,  1244,  1245,  1248,  1249,  1250,  1251,  1261,  1262,  1263,
    1265,  1267,  1269,  1273,  1274,  1275,  1278,  1279,  1282,  1284,
    1286,  1288,  1290,  1294,  1296,  1298,  1300,  1302,  1308,  1309,
    1312,  1316,  1318,  1322,  1323,  1329,  1333,  1334,  1335,  1336,
    1346,  1348,  1354,  1355,  1359,  1363,  1366,  1369,  1372,  1375,
    1378,  1381,  1384,  1387,  1390,  1393,  1396,  1399,  1402,  1405,
    1408,  1411,  1414,  1417,  1420,  1423,  1426,  1429,  1432,  1435,
    1438,  1440,  1444,  1445,  1451,  1454,  1456,  1458,  1463,  1464,
    1467,  1468,  1469,  1472,  1473,  1483,  1485,  1489,  1501,  1510,
    1511,  1514,  1515,  1516,  1519,  1520,  1523,  1524,  1525,  1527,
    1529,  1530,  1531,  1533,  1535,  1537,  1542,  1543,  1546,  1547,
    1554,  1557,  1560,  1561,  1571,  1574,  1584,  1585,  1586,  1587,
    1588,  1589,  1590,  1594,  1597,  1599,  1601,  1605,  1606,  1607,
    1610,  1614,  1615,  1618,  1620,  1621,  1635,  1637,  1639,  1641,
    1643,  1645,  1647,  1662,  1663,  1664,  1665,  1668,  1672,  1674,
    1678,  1679,  1680,  1681,  1682,  1683,  1690,  1692,  1696,  1698,
    1700,  1702,  1707,  1708,  1711,  1713,  1717,  1720,  1722,  1728,
    1731,  1732,  1733,  1734,  1735,  1738,  1742,  1746,  1747,  1748,
    1749,  1750,  1753,  1756,  1759,  1760,  1761,  1762,  1765,  1766,
    1767,  1768,  1771,  1772,  1775,  1776,  1785,  1784,  1795,  1801,
    1804,  1807,  1809,  1813,  1824,  1828,  1832,  1833,  1836,  1838,
    1840,  1842,  1844,  1846,  1848,  1850,  1852,  1854,  1856,  1860,
    1861,  1872,  1874,  1879,  1880,  1887,  1888,  1891,  1894,  1896,
    1899,  1902,  1904,  1908,  1909,  1919,  1923,  1924,  1938,  1940,
    1953,  1957,  1964,  1965,  1968,  1970,  1972,  1976,  1977,  1978,
    1981,  1984,  1987,  1988,  1991,  1992,  1995,  1997,  2000,  2003,
    2004,  2007,  2008,  2011,  2012,  2019,  2020,  2029,  2031,  2035,
    2037,  2041,  2043,  2054,  2062,  2077,  2079,  2081,  2083,  2085,
    2087,  2089,  2091,  2093,  2095,  2097,  2101,  2105,  2106,  2109,
    2110,  2114,  2115,  2116,  2117,  2120,  2121,  2124,  2127,  2128,
    2131,  2134,  2135,  2138,  2145,  2146,  2149,  2151,  2153,  2155,
    2157,  2161,  2162,  2165,  2166,  2169,  2170,  2173,  2177,  2179,
    2183,  2184,  2188,  2190,  2194,  2196,  2200,  2202,  2215,  2220,
    2232,  2234,  2238,  2239,  2240,  2241,  2242,  2243,  2244,  2245,
    2246,  2247,  2248,  2249,  2252,  2254,  2258,  2259,  2262,  2263,
    2272,  2287,  2292,  2297,  2302,  2307,  2312,  2317,  2322,  2327,
    2329,  2333,  2334,  2335,  2336,  2337,  2343,  2349,  2355,  2356,
    2357,  2363,  2364,  2365,  2371,  2374,  2375,  2378,  2380,  2382,
    2384,  2386,  2388,  2390,  2392,  2394,  2396,  2398,  2400,  2402,
    2404,  2406,  2408,  2412,  2413,  2414,  2415,  2416,  2417,  2418,
    2419,  2420,  2421,  2422,  2423,  2426,  2427,  2437,  2441,  2443,
    2447,  2448,  2449,  2452,  2454,  2458,  2459,  2460,  2461,  2464,
    2466,  2468,  2470,  2472,  2474,  2476,  2478,  2482,  2484,  2488,
    2489,  2492,  2497,  2500,  2502,  2506,  2515,  2520,  2524,  2525,
    2528,  2529,  2545,  2548,  2553,  2554,  2557,  2560,  2563,  2564,
    2567,  2569,  2571,  2575,  2576,  2577,  2580,  2581,  2582,  2585,
    2586,  2587,  2590,  2593,  2598,  2599,  2602,  2604,  2608,  2610,
    2614,  2615,  2616,  2617,  2618,  2621,  2622,  2623,  2624,  2627,
    2629,  2633,  2635,  2645,  2647,  2649,  2654,  2656,  2661,  2663,
    2665,  2667,  2669,  2671,  2673,  2675,  2677,  2679,  2681,  2683,
    2685,  2689,  2691,  2693,  2697,  2698,  2702,  2706,  2707,  2710,
    2711,  2724,  2726,  2730,  2732,  2736,  2738,  2742,  2744,  2746,
    2748,  2753,  2755,  2759,  2762,  2767,  2768,  2772,  2776,  2777,
    2787,  2789,  2791,  2795,  2796,  2799,  2800,  2811,  2813,  2815,
    2817,  2819,  2821,  2823,  2825,  2827,  2829,  2831,  2833,  2835,
    2837,  2839,  2841,  2843,  2845,  2847,  2849,  2851,  2855,  2856,
    2866,  2868,  2870,  2872,  2874,  2876,  2886,  2888,  2890,  2892,
    2894,  2896,  2898,  2900,  2902,  2904,  2906,  2908,  2910,  2912,
    2924,  2923,  2933,  2934,  2935,  2939,  2941,  2945,  2946,  2947,
    2948,  2949,  2952,  2953,  2957,  2958,  2959,  2960,  2963,  2964,
    2965,  2968,  2970,  2982,  2986,  2990,  2992,  3005,  3006,  3007,
    3008,  3009,  3010,  3011,  3012,  3013,  3014,  3015,  3016,  3017,
    3018,  3021,  3022,  3023,  3027,  3029,  3030,  3034,  3035,  3036,
    3040,  3041,  3052,  3054,  3063,  3068,  3073,  3079,  3089,  3101,
    3103,  3107,  3109,  3113,  3115,  3117,  3119,  3121,  3123,  3125,
    3127,  3129,  3131,  3133,  3137,  3138,  3149,  3153,  3158,  3159,
    3163,  3173,  3175,  3186,  3193,  3195,  3197,  3199,  3201,  3205,
    3206,  3210,  3215,  3217,  3219,  3221,  3223,  3225,  3230,  3244,
    3246,  3248,  3253,  3254,  3265,  3267,  3269,  3273,  3275,  3279,
    3280,  3283,  3284,  3287,  3288,  3291,  3292,  3295,  3298,  3309,
    3314,  3315,  3316,  3317,  3318,  3319,  3322,  3323,  3326,  3332,
    3341,  3342,  3343,  3344,  3347,  3348,  3351,  3356,  3361,  3362,
    3365,  3366,  3367,  3368,  3378,  3383,  3385,  3387,  3391,  3393,
    3397,  3401,  3402,  3412,  3416,  3417,  3420,  3424,  3427,  3430,
    3431,  3432,  3433,  3434,  3435,  3436,  3437,  3440,  3441,  3451,
    3460,  3461,  3465,  3466,  3470,  3473,  3476,  3479,  3480,  3489,
    3520,  3521,  3522,  3523,  3524,  3528,  3534,  3535,  3545,  3547,
    3551,  3553,  3557,  3559,  3561,  3563,  3567,  3568,  3571,  3575,
    3577,  3579,  3581,  3585,  3590,  3591,  3601,  3603,  3605,  3607,
    3609,  3611,  3613,  3615,  3619,  3620,  3623,  3624,  3627,  3629,
    3631,  3634,  3637,  3638,  3641,  3645,  3646,  3649,  3651,  3655,
    3657,  3659,  3661,  3663,  3667,  3668,  3671,  3672,  3675,  3685,
    3688,  3691,  3694,  3698,  3699,  3703,  3704,  3708,  3709,  3713,
    3715,  3720,  3721,  3724,  3726,  3738,  3739,  3742,  3743,  3753,
    3755,  3757,  3759,  3761,  3763,  3765,  3767,  3769,  3771,  3773,
    3794,  3796,  3798,  3800,  3802,  3804,  3808,  3810,  3812,  3814,
    3818,  3819,  3820,  3821,  3825,  3826,  3836,  3838,  3842,  3844,
    3846,  3848,  3852,  3854,  3856,  3860,  3863,  3864,  3867,  3868,
    3869,  3870,  3873,  3875,  3879,  3892,  3894,  3896,  3898,  3903,
    3909,  3916,  3923,  3924,  3925,  3926,  3927,  3928,  3929,  3930,
    3931,  3934,  3935,  3936,  3937,  3938,  3939,  3941,  3945,  3946,
    3947,  3948,  3951,  3952,  3955,  3956,  3964,  3966,  3968,  3970,
    3972,  3974,  3976,  3978,  3980,  3982,  3984,  3988,  3991,  3999,
    4000,  4003,  4004,  4007,  4011,  4020,  4021,  4024,  4025,  4028,
    4032,  4036,  4038,  4040,  4042,  4044,  4046,  4050,  4053,  4056,
    4059,  4062,  4064,  4066,  4068,  4072,  4076,  4078,  4081,  4084,
    4085,  4086,  4087,  4088,  4089,  4090,  4091,  4092,  4093,  4094,
    4095,  4096,  4097,  4123,  4125,  4127,  4138,  4140,  4142,  4144,
    4146,  4148,  4150,  4152,  4154,  4156,  4158,  4160,  4162,  4164,
    4166,  4168,  4170,  4172,  4174,  4176,  4178,  4180,  4182,  4184,
    4186,  4188,  4190,  4192,  4194,  4196,  4198,  4200,  4202,  4204,
    4215,  4217,  4219,  4221,  4223,  4225,  4227,  4229,  4231,  4233,
    4235,  4237,  4239,  4241,  4243,  4245,  4247,  4249,  4251,  4253,
    4255,  4267,  4269,  4271,  4273,  4275,  4277,  4279,  4281,  4283,
    4285,  4287,  4289,  4291,  4293,  4295,  4297,  4299,  4301,  4303,
    4305,  4307,  4319,  4321,  4323,  4325,  4327,  4329,  4331,  4333,
    4335,  4337,  4339,  4351,  4353,  4355,  4357,  4359,  4361,  4363,
    4365,  4367,  4369,  4371,  4373,  4375,  4377,  4379,  4381,  4383,
    4385,  4387,  4389,  4391,  4393,  4395,  4397,  4400,  4402,  4404,
    4406,  4408,  4410,  4412,  4414,  4416,  4418,  4420,  4422,  4424,
    4426,  4428,  4430,  4432,  4434,  4436,  4438,  4446,  4448,  4452,
    4454,  4456,  4459,  4462,  4466,  4468,  4472,  4474,  4478,  4479,
    4482,  4483,  4484,  4487,  4489,  4491,  4495,  4496,  4497,  4500,
    4501,  4504,  4505,  4506,  4507,  4508,  4509,  4510,  4511,  4512,
    4515,  4516,  4519,  4520,  4523,  4524,  4525,  4526,  4527,  4528,
    4531,  4533,  4537,  4540,  4543,  4545,  4549,  4550,  4554,  4555,
    4561,  4562,  4563,  4564,  4565,  4566,  4567,  4568,  4572,  4574,
    4579,  4583,  4586,  4589,  4591,  4593,  4595,  4597,  4600,  4603,
    4607,  4611,  4613,  4615,  4619,  4621,  4628,  4632,  4634,  4638,
    4642,  4645,  4648,  4649,  4652,  4653,  4657,  4658,  4659,  4660,
    4663,  4664,  4668,  4669,  4672,  4673,  4677,  4678,  4682,  4683,
    4686,  4694,  4696,  4701,  4703,  4705,  4781,  4782,  4785,  4787,
    4791,  4793,  4797,  4799,  4804,  4805,  4806,  4807,  4808,  4810,
    4812,  4814,  4822,  4824,  4826,  4828,  4830,  4832,  4834,  4836,
    4840,  4841,  4842,  4843,  4844,  4854,  4865,  4876,  4882,  4883,
    4886,  4887,  4890,  4898,  4901,  4909,  4910,  4919,  4928,  4940,
    4941,  4944,  4945,  4946,  4949,  4950,  4951,  4952,  4953,  4956,
    4957,  4960,  4961,  4962,  4963,  4964,  4965,  4966,  4968,  4971,
    4973,  4980,  4996,  4998,  5001,  5003,  5007,  5019,  5035,  5039,
    5050,  5051,  5054,  5066,  5075,  5076,  5079,  5080,  5081,  5084,
    5085,  5088,  5089,  5092,  5093,  5096,  5098,  5100,  5102,  5106,
    5113,  5136,  5168,  5178,  5185,  5222,  5231,  5233,  5234,  5237,
    5239,  5240,  5243,  5244,  5245,  5246,  5247,  5254,  5253,  5263,
    5265,  5267,  5268,  5269,  5272,  5273,  5274,  5275,  5276,  5279,
    5280,  5284,  5283,  5300,  5298,  5313,  5312,  5325,  5331,  5332,
    5335,  5337,  5338,  5341,  5342,  5343,  5344,  5347,  5348,  5351,
    5359,  5376,  5384,  5407,  5505,  5539,  5541,  5543,  5547,  5551,
    5550,  5601,  5603,  5602,  5617,  5623,  5630,  5635,  5638,  5639,
    5642,  5643,  5644,  5645,  5646,  5647,  5648,  5656,  5664,  5667,
    5668,  5669,  5670,  5671,  5672,  5680,  5688,  5689,  5690,  5693,
    5694,  5697,  5699,  5703,  5789,  5790,  5797,  5798,  5799,  5805,
    5814,  5817,  5818,  5819,  5820,  5823,  5824,  5825,  5828,  5829,
    5830,  5831,  5832,  5835,  5837,  5841,  5854,  5861,  5862,  5868,
    5870,  5871,  5874,  5875,  5878,  5885,  5892,  5892,  5894,  5895,
    5898,  5898,  5900,  5910,  5917,  5924,  5931,  5940,  5941,  5953,
    5964,  5975,  5979,  5980,  5983,  5988,  5992,  5993,  5996,  6003,
    6010,  6014,  6015,  6018,  6021,  6025,  6026,  6029,  6036,  6037,
    6038,  6039,  6040,  6041,  6042,  6043,  6044,  6045,  6046,  6047,
    6048,  6049,  6050,  6057,  6058,  6061,  6062,  6069,  6070,  6071,
    6078,  6077,  6094,  6095,  6102,  6101,  6170,  6176,  6182,  6190,
    6196,  6202,  6208,  6214,  6220,  6226,  6232,  6238,  6249,  6250,
    6253,  6254,  6255,  6256,  6257,  6258,  6259,  6260,  6261,  6262,
    6263,  6264,  6265,  6266,  6267,  6268,  6269,  6270,  6271,  6272,
    6273,  6274,  6275,  6276,  6277,  6280,  6281,  6282,  6283,  6284,
    6285,  6289,  6290,  6291,  6292,  6293,  6294,  6295,  6298,  6312,
    6313,  6314,  6315,  6316,  6317,  6318,  6319,  6323,  6324,  6325,
    6326,  6327,  6328,  6329,  6333,  6334,  6335,  6336,  6337,  6338,
    6344,  6345,  6346,  6347,  6348,  6349,  6350,  6351,  6352,  6355,
    6356,  6357,  6358,  6361,  6362,  6363,  6364,  6367,  6368,  6369,
    6370,  6371,  6372,  6373,  6391,  6391,  6393,  6394,  6395,  6396,
    6397,  6398,  6404,  6405,  6408,  6409,  6410,  6411,  6412,  6413,
    6414,  6415,  6416,  6417,  6418,  6419,  6420,  6421,  6422,  6423,
    6424,  6425,  6426,  6427,  6428,  6429,  6430,  6431,  6432,  6433,
    6434,  6435,  6436,  6437,  6438,  6439,  6441,  6442,  6443,  6444,
    6445,  6446,  6447,  6448,  6449,  6450,  6451,  6452,  6454,  6455,
    6456,  6457,  6458,  6459,  6460,  6461,  6462,  6463,  6464,  6465,
    6466,  6467,  6468,  6469,  6470,  6471,  6473,  6474,  6475,  6476,
    6477,  6478,  6479,  6480,  6481,  6482,  6483,  6484,  6485,  6486,
    6487,  6488,  6489,  6491,  6492,  6493,  6494,  6495,  6496,  6497,
    6498,  6499,  6500,  6501,  6502,  6503,  6504,  6505,  6506,  6507,
    6508,  6509,  6510,  6511,  6512,  6513,  6514,  6515,  6516,  6517,
    6518,  6519,  6521,  6522,  6524,  6525,  6526,  6527,  6528,  6529,
    6530,  6531,  6532,  6533,  6534,  6535,  6536,  6537,  6538,  6539,
    6540,  6541,  6542,  6543,  6544,  6545,  6546,  6547,  6548,  6549,
    6550,  6551,  6552,  6553,  6554,  6555,  6556,  6557,  6558,  6559,
    6560,  6561,  6562,  6563,  6564,  6565,  6566,  6567,  6568,  6569,
    6570,  6571,  6572,  6573,  6574,  6575,  6576,  6577,  6578,  6579,
    6580,  6582,  6583,  6584,  6585,  6586,  6587,  6588,  6589,  6590,
    6591,  6592,  6593,  6594,  6595,  6596,  6597,  6598,  6599,  6600,
    6601,  6602,  6603,  6604,  6605,  6606,  6607,  6608,  6609,  6610,
    6611,  6612,  6613,  6614,  6615,  6616,  6617,  6618,  6619,  6620,
    6621,  6622,  6623,  6624,  6625,  6626,  6627,  6628,  6629,  6630,
    6631,  6632,  6634,  6648,  6649,  6653,  6654,  6655,  6656,  6657,
    6658,  6659,  6660,  6661,  6662,  6666,  6667,  6668,  6669,  6670,
    6671,  6672,  6673,  6674,  6675,  6676,  6677,  6678,  6679,  6680,
    6681,  6682,  6683,  6684,  6685,  6686,  6689,  6690,  6691,  6692,
    6693,  6694,  6695,  6696,  6697,  6711,  6712,  6713,  6714,  6715,
    6716,  6717,  6718,  6719,  6720,  6721,  6722,  6723,  6724,  6725,
    6726,  6727,  6728,  6729,  6730,  6740,  6741,  6742,  6743,  6744,
    6745,  6746,  6747,  6748,  6749,  6750,  6751,  6752,  6753,  6754,
    6755,  6756,  6757,  6758,  6759,  6760,  6761,  6762,  6763,  6764,
    6765,  6766,  6767,  6768,  6769,  6770,  6771,  6772,  6773,  6774,
    6775,  6776,  6777,  6778,  6779,  6780,  6781,  6782,  6783,  6784,
    6785,  6786,  6787,  6788,  6789,  6790,  6791,  6792,  6793,  6794,
    6795,  6796,  6797,  6798,  6799,  6800,  6801,  6802,  6806,  6807,
    6811,  6812,  6813,  6814,  6815,  6819,  6819,  6822,  6828,  6829,
    6832,  6834,  6839,  6849,  6856,  6857,  6858,  6861,  6893,  6894,
    6897,  6899,  6907,  6908,  6909,  6913,  6914,  6918,  6919,  6922,
    6923,  6926,  6927,  6928,  6929,  6930,  6933,  6934,  6935,  6936,
    6937,  6938,  6939,  6940,  6941,  6942,  6943,  6944,  6945,  6946,
    6947,  6948,  6949,  6950,  6951,  6952,  6953,  6954,  6955,  6956,
    6957,  6958,  6959,  6960,  6961,  6962,  6963,  6964,  6965,  6966,
    6967,  6968,  6969,  6970,  6971,  6972,  6973,  6974,  6975,  6976,
    6977,  6978,  6979,  6980,  6981,  6982,  6983,  6984,  6985,  6986,
    6987,  6988,  6989
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONTINUE", "SQL_COUNT", "SQL_DATA", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GO", "SQL_GOTO", 
  "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", "SQL_LENGTH", 
  "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN", 
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH", 
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", 
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT", 
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", 
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", 
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", 
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", 
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", 
  "S_VOLATILE", "S_TYPEDEF", "TYPECAST", "ABORT_P", "ABSOLUTE_P", 
  "ACCESS", "ACTION", "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", 
  "ALSO", "ALTER", "ALWAYS", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", 
  "AS", "ASC", "ASSERTION", "ASSIGNMENT", "ASYMMETRIC", "AT", 
  "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", 
  "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", 
  "CASCADE", "CASCADED", "CASE", "CAST", "CHAIN", "CHAR_P", "CHARACTER", 
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", 
  "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMIT", "COMMITTED", 
  "CONCURRENTLY", "CONFIGURATION", "CONNECTION", "CONSTRAINT", 
  "CONSTRAINTS", "CONTENT_P", "CONVERSION_P", "CONVERT", "COPY", "COST", 
  "CREATE", "CREATEDB", "CREATEROLE", "CREATEUSER", "CROSS", "CSV", 
  "CURRENT_P", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", 
  "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATABASE", 
  "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE", "DEFAULT", 
  "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P", 
  "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", "DISABLE_P", "DISCARD", 
  "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", 
  "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ENUM_P", 
  "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXCLUDING", "EXECUTE", "EXISTS", 
  "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P", "FAMILY", "FETCH", 
  "FIRST_P", "FLOAT_P", "FOR", "FORCE", "FOREIGN", "FORWARD", "FREEZE", 
  "FROM", "FULL", "FUNCTION", "GET", "GLOBAL", "GRANT", "GRANTED", 
  "GREATEST", "GROUP_P", "HANDLER", "HAVING", "HEADER_P", "HOLD", 
  "HOUR_P", "IF_P", "ILIKE", "IMMEDIATE", "IMMUTABLE", "IMPLICIT_P", 
  "IN_P", "INCLUDING", "INCREMENT", "INDEX", "INDEXES", "INHERIT", 
  "INHERITS", "INITIALLY", "INNER_P", "INOUT", "INPUT_P", "INSENSITIVE", 
  "INSERT", "INSTEAD", "INT_P", "INTEGER", "INTERSECT", "INTERVAL", 
  "INTO", "INVOKER", "IS", "ISNULL", "ISOLATION", "JOIN", "KEY", 
  "LANCOMPILER", "LANGUAGE", "LARGE_P", "LAST_P", "LEADING", "LEAST", 
  "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", 
  "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "LOGIN_P", 
  "MAPPING", "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", 
  "MONTH_P", "MOVE", "NAME_P", "NAMES", "NATIONAL", "NATURAL", "NCHAR", 
  "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEROLE", "NOCREATEUSER", 
  "NOINHERIT", "NOLOGIN_P", "NONE", "NOSUPERUSER", "NOT", "NOTHING", 
  "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OR", "ORDER", "OUT_P", "OUTER_P", "OVERLAPS", 
  "OVERLAY", "OWNED", "OWNER", "PARSER", "PARTIAL", "PASSWORD", "PLACING", 
  "PLANS", "POSITION", "PRECISION", "PRESERVE", "PREPARE", "PREPARED", 
  "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "QUOTE", 
  "READ", "REAL", "REASSIGN", "RECHECK", "REFERENCES", "REINDEX", 
  "RELATIVE_P", "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "REPLICA", 
  "RESET", "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", 
  "RIGHT", "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", 
  "SCHEMA", "SCROLL", "SEARCH", "SECOND_P", "SECURITY", "SELECT", 
  "SEQUENCE", "SERIALIZABLE", "SESSION", "SESSION_USER", "SET", "SETOF", 
  "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", "STABLE", 
  "STANDALONE_P", "START", "STATEMENT", "STATISTICS", "STDIN", "STDOUT", 
  "STORAGE", "STRICT_P", "STRIP_P", "SUBSTRING", "SUPERUSER_P", 
  "SYMMETRIC", "SYSID", "SYSTEM_P", "TABLE", "TABLESPACE", "TEMP", 
  "TEMPLATE", "TEMPORARY", "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", 
  "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", 
  "TRUNCATE", "TRUSTED", "TYPE_P", "UNCOMMITTED", "UNENCRYPTED", "UNION", 
  "UNIQUE", "UNKNOWN", "UNLISTEN", "UNTIL", "UPDATE", "USER", "USING", 
  "VACUUM", "VALID", "VALIDATOR", "VALUE_P", "VALUES", "VARCHAR", 
  "VARYING", "VERBOSE", "VERSION_P", "VIEW", "VOLATILE", "WHEN", "WHERE", 
  "WHITESPACE_P", "WITH", "WITHOUT", "WORK", "WRITE", "XML_P", 
  "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLFOREST", "XMLPARSE", 
  "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P", "YES_P", "ZONE", 
  "NULLS_FIRST", "NULLS_LAST", "WITH_CASCADED", "WITH_LOCAL", 
  "WITH_CHECK", "IDENT", "SCONST", "Op", "CSTRING", "CVARIABLE", 
  "CPP_LINE", "IP", "BCONST", "XCONST", "DOLCONST", "ECONST", "NCONST", 
  "ICONST", "PARAM", "FCONST", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", 
  "'-'", "'*'", "'/'", "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", 
  "'.'", "';'", "'{'", "'}'", "\"=\"", "','", "':'", "$accept", "prog", 
  "statements", "statement", "at", "stmt", "CreateRoleStmt", "opt_with", 
  "OptRoleList", "CreateUserStmt", "AlterRoleStmt", "AlterRoleSetStmt", 
  "AlterUserStmt", "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", 
  "CreateGroupStmt", "AlterGroupStmt", "add_drop", "DropGroupStmt", 
  "CreateSchemaStmt", "OptSchemaName", "OptSchemaEltList", "schema_stmt", 
  "VariableSetStmt", "set_rest", "var_name", "var_list", "iso_level", 
  "var_value", "opt_boolean", "zone_value", "opt_encoding", 
  "ColId_or_Sconst", "VariableShowStmt", "VariableResetStmt", 
  "SetResetClause", "ConstraintsSetStmt", "constraints_set_list", 
  "constraints_set_mode", "CheckPointStmt", "DiscardStmt", 
  "AlterTableStmt", "alter_table_cmds", "alter_table_cmd", 
  "alter_rel_cmds", "alter_rel_cmd", "alter_column_default", 
  "opt_drop_behavior", "alter_using", "ClosePortalStmt", "CopyStmt", 
  "copy_from", "copy_file_name", "copy_opt_list", "copy_opt_item", 
  "opt_binary", "opt_oids", "copy_delimiter", "opt_using", "CreateStmt", 
  "OptTemp", "OptTableElementList", "TableElementList", "TableElement", 
  "columnDef", "ColQualList", "ColConstraint", "ColConstraintElem", 
  "ConstraintAttr", "TableLikeClause", "TableLikeOptionList", 
  "TableLikeOption", "TableConstraint", "ConstraintElem", 
  "opt_column_list", "columnList", "columnElem", "key_match", 
  "key_actions", "key_delete", "key_update", "key_action", "OptInherit", 
  "OptWith", "OnCommitOption", "OptTableSpace", "OptConsTableSpace", 
  "CreateAsStmt", "@1", "create_as_target", "OptCreateAs", "CreateAsList", 
  "CreateAsElement", "CreateSeqStmt", "AlterSeqStmt", "OptSeqList", 
  "OptSeqElem", "opt_by", "CreatePLangStmt", "opt_trusted", 
  "handler_name", "opt_validator", "opt_lancompiler", "DropPLangStmt", 
  "opt_procedural", "CreateTableSpaceStmt", "OptTableSpaceOwner", 
  "DropTableSpaceStmt", "CreateTrigStmt", "TriggerActionTime", 
  "TriggerEvents", "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", 
  "TriggerForType", "TriggerFuncArgs", "TriggerFuncArg", 
  "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition", 
  "def_list", "def_elem", "def_arg", "aggr_args", "old_aggr_definition", 
  "old_aggr_list", "old_aggr_elem", "enum_val_list", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_opfamily", 
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt", 
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt", 
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt", 
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt", 
  "FetchStmt", "fetch_direction", "from_in", "CommentStmt", 
  "comment_type", "comment_text", "GrantStmt", "RevokeStmt", "privileges", 
  "privilege_list", "privilege", "privilege_target", "grantee_list", 
  "grantee", "opt_grant_grant_option", "function_with_argtypes_list", 
  "function_with_argtypes", "GrantRoleStmt", "RevokeRoleStmt", 
  "opt_grant_admin_option", "opt_granted_by", "IndexStmt", 
  "index_opt_unique", "access_method_clause", "index_params", 
  "index_elem", "opt_class", "opt_asc_desc", "opt_nulls_order", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "arg_class", "func_as", "param_name", "func_return", 
  "func_type", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "opt_definition", "AlterFunctionStmt", 
  "alterfunc_opt_list", "opt_restrict", "RemoveFuncStmt", 
  "RemoveAggrStmt", "RemoveOperStmt", "oper_argtypes", "any_operator", 
  "CreateCastStmt", "cast_context", "DropCastStmt", "opt_if_exists", 
  "ReindexStmt", "reindex_type", "opt_force", "RenameStmt", "opt_column", 
  "AlterObjectSchemaStmt", "AlterOwnerStmt", "RuleStmt", "@2", 
  "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", 
  "AlterTSDictionaryStmt", "AlterTSConfigurationStmt", 
  "CreateConversionStmt", "ClusterStmt", "cluster_index_specification", 
  "VacuumStmt", "AnalyzeStmt", "analyze_keyword", "opt_verbose", 
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "PrepareStmt", "PreparableStmt", 
  "prep_type_clause", "ExecuteStmt", "execute_param_clause", 
  "DeallocateStmt", "InsertStmt", "insert_rest", "insert_column_list", 
  "insert_column_item", "returning_clause", "DeleteStmt", "using_clause", 
  "LockStmt", "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", 
  "set_clause_list", "set_clause", "single_set_clause", 
  "multiple_set_clause", "set_target", "set_target_list", 
  "DeclareCursorStmt", "cursor_options", "opt_hold", "SelectStmt", 
  "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "select_limit_value", "select_offset_value", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "for_locking_items", "for_locking_item", "locked_rels_list", 
  "values_clause", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "relation_expr_opt_alias", "func_table", 
  "where_clause", "where_or_current_clause", "TableFuncElementList", 
  "TableFuncElement", "Typename", "opt_array_bounds", "Iresult", 
  "SimpleTypename", "ConstTypename", "GenericType", "opt_type_modifiers", 
  "Numeric", "opt_float", "Bit", "ConstBit", "BitWithLength", 
  "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "a_expr", "b_expr", "c_expr", 
  "func_expr", "xml_root_version", "opt_xml_root_standalone", 
  "xml_attributes", "xml_attribute_list", "xml_attribute_el", 
  "document_or_content", "xml_whitespace_option", "row", "sub_type", 
  "all_Op", "MathOp", "qual_Op", "qual_all_Op", "subquery_Op", 
  "expr_list", "extract_list", "type_list", "array_expr_list", 
  "array_expr", "extract_arg", "overlay_list", "overlay_placing", 
  "position_list", "substr_list", "substr_from", "substr_for", 
  "trim_list", "in_expr", "case_expr", "when_clause_list", "when_clause", 
  "case_default", "case_arg", "columnref", "indirection_el", 
  "indirection", "opt_indirection", "opt_asymmetric", "ctext_expr", 
  "ctext_expr_list", "ctext_row", "target_list", "target_el", 
  "relation_name", "qualified_name_list", "qualified_name", "name_list", 
  "name", "database_name", "access_method", "attr_name", "index_name", 
  "file_name", "func_name", "AexprConst", "Iconst", "Fconst", "Bconst", 
  "Xconst", "Sconst", "PosIntConst", "IntConst", "IntConstVar", 
  "AllConstVar", "StringConst", "PosIntStringConst", "NumConst", 
  "AllConst", "PosAllConst", "RoleId", "SpecialRuleRelation", 
  "ECPGConnect", "connection_target", "opt_database_name", "db_prefix", 
  "server", "opt_server", "server_name", "opt_port", 
  "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "ECPGCursorStmt", 
  "ECPGExecuteImmediateStmt", "ECPGVarDeclaration", 
  "single_vt_declaration", "precision", "opt_scale", "ecpg_interval", 
  "ECPGDeclaration", "@3", "sql_startdeclare", "sql_enddeclare", 
  "var_type_declarations", "vt_declarations", "variable_declarations", 
  "type_declaration", "@4", "var_declaration", "@5", "@6", 
  "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@7", "struct_union_type", "@8", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "execute_rest", 
  "execstring", "prepared_name", "ECPGFree", "ECPGOpen", "opt_ecpg_using", 
  "ecpg_using", "using_descriptor", "into_descriptor", "opt_sql", 
  "ecpg_into", "using_list", "UsingConst", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "desc_header_item", "ECPGGetDescriptor", 
  "ECPGGetDescItems", "ECPGGetDescItem", "ECPGSetDescriptor", 
  "ECPGSetDescItems", "ECPGSetDescItem", "descriptor_item", 
  "ECPGSetAutocommit", "on_off", "ECPGSetConnection", "ECPGTypedef", "@9", 
  "opt_reference", "ECPGVar", "@10", "ECPGWhenever", "action", 
  "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ECPGColId", "ColId", "type_function_name", 
  "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", "ECPGCKeywords", 
  "unreserved_keyword", "ECPGunreserved_interval", "ECPGunreserved", 
  "ECPGunreserved_con", "col_name_keyword", "type_func_name_keyword", 
  "reserved_keyword", "into_list", "ecpgstart", "c_args", 
  "coutputvariable", "civarind", "civar", "indicator", "cvariable", 
  "ident", "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", 
  "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,    61,    60,    62,
     722,    43,    45,    42,    47,    37,    94,   723,    91,    93,
      40,    41,    46,    59,   123,   125,   724,    44,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   489,   490,   491,   491,   492,   492,   492,   492,   492,
     492,   492,   492,   493,   494,   494,   494,   494,   494,   494,
     494,   494,   494,   494,   494,   494,   494,   494,   494,   494,
     494,   494,   494,   494,   494,   494,   494,   494,   494,   494,
     494,   494,   494,   494,   494,   494,   494,   494,   494,   494,
     494,   494,   494,   494,   494,   494,   494,   494,   494,   494,
     494,   494,   494,   494,   494,   494,   494,   494,   494,   494,
     494,   494,   494,   494,   494,   494,   494,   494,   494,   494,
     494,   494,   494,   494,   494,   494,   494,   494,   494,   494,
     494,   494,   494,   494,   494,   494,   494,   494,   494,   494,
     494,   494,   494,   494,   494,   494,   494,   494,   494,   494,
     494,   494,   494,   494,   494,   494,   494,   494,   494,   494,
     494,   494,   494,   494,   495,   496,   496,   497,   497,   497,
     497,   497,   497,   497,   497,   497,   497,   497,   497,   497,
     497,   497,   497,   497,   497,   497,   497,   497,   497,   498,
     499,   500,   501,   502,   503,   503,   504,   504,   505,   506,
     507,   507,   508,   508,   509,   509,   510,   510,   511,   511,
     512,   512,   512,   512,   512,   512,   513,   513,   513,   514,
     514,   514,   514,   514,   514,   514,   514,   514,   514,   514,
     514,   514,   515,   515,   516,   516,   517,   517,   517,   517,
     518,   518,   518,   519,   519,   519,   519,   520,   520,   520,
     520,   520,   520,   521,   521,   521,   522,   522,   523,   523,
     523,   523,   523,   524,   524,   524,   524,   524,   525,   525,
     526,   527,   527,   528,   528,   529,   530,   530,   530,   530,
     531,   531,   532,   532,   533,   533,   533,   533,   533,   533,
     533,   533,   533,   533,   533,   533,   533,   533,   533,   533,
     533,   533,   533,   533,   533,   533,   533,   533,   533,   533,
     533,   533,   534,   534,   535,   535,   535,   535,   536,   536,
     537,   537,   537,   538,   538,   539,   539,   540,   540,   541,
     541,   542,   542,   542,   543,   543,   544,   544,   544,   544,
     544,   544,   544,   544,   544,   544,   545,   545,   546,   546,
     547,   547,   548,   548,   549,   549,   550,   550,   550,   550,
     550,   550,   550,   551,   551,   552,   552,   553,   553,   553,
     554,   555,   555,   556,   556,   556,   557,   557,   557,   557,
     557,   557,   557,   558,   558,   558,   558,   559,   560,   560,
     561,   561,   561,   561,   561,   561,   562,   562,   563,   563,
     563,   563,   564,   564,   565,   565,   566,   567,   567,   567,
     568,   568,   568,   568,   568,   569,   570,   571,   571,   571,
     571,   571,   572,   572,   573,   573,   573,   573,   574,   574,
     574,   574,   575,   575,   576,   576,   578,   577,   579,   580,
     580,   581,   581,   582,   583,   584,   585,   585,   586,   586,
     586,   586,   586,   586,   586,   586,   586,   586,   586,   587,
     587,   588,   588,   589,   589,   590,   590,   591,   591,   592,
     592,   593,   593,   594,   594,   595,   596,   596,   597,   597,
     598,   598,   599,   599,   600,   600,   600,   601,   601,   601,
     602,   602,   603,   603,   604,   604,   605,   605,   605,   606,
     606,   607,   607,   608,   608,   608,   608,   609,   609,   610,
     610,   611,   611,   612,   613,   614,   614,   614,   614,   614,
     614,   614,   614,   614,   614,   614,   615,   616,   616,   617,
     617,   618,   618,   618,   618,   619,   619,   620,   621,   621,
     622,   623,   623,   624,   625,   625,   626,   626,   626,   626,
     626,   627,   627,   628,   628,   629,   629,   630,   631,   631,
     632,   632,   633,   633,   634,   634,   635,   635,   636,   637,
     638,   638,   639,   639,   639,   639,   639,   639,   639,   639,
     639,   639,   639,   639,   640,   640,   641,   641,   642,   642,
     643,   644,   644,   644,   644,   644,   644,   644,   644,   644,
     644,   645,   645,   645,   645,   645,   645,   645,   645,   645,
     645,   645,   645,   645,   645,   646,   646,   647,   647,   647,
     647,   647,   647,   647,   647,   647,   647,   647,   647,   647,
     647,   647,   647,   648,   648,   648,   648,   648,   648,   648,
     648,   648,   648,   648,   648,   649,   649,   650,   651,   651,
     652,   652,   652,   653,   653,   654,   654,   654,   654,   655,
     655,   655,   655,   655,   655,   655,   655,   656,   656,   657,
     657,   658,   658,   659,   659,   660,   661,   662,   663,   663,
     664,   664,   665,   665,   666,   666,   667,   667,   668,   668,
     669,   669,   669,   670,   670,   670,   671,   671,   671,   672,
     672,   672,   673,   673,   674,   674,   675,   675,   676,   676,
     677,   677,   677,   677,   677,   678,   678,   678,   678,   679,
     679,   680,   681,   682,   682,   682,   683,   683,   684,   684,
     684,   684,   684,   684,   684,   684,   684,   684,   684,   684,
     684,   685,   685,   685,   686,   686,   687,   688,   688,   689,
     689,   690,   690,   691,   691,   692,   692,   693,   693,   693,
     693,   694,   694,   695,   695,   696,   696,   697,   698,   698,
     699,   699,   699,   700,   700,   701,   701,   702,   702,   702,
     702,   702,   702,   702,   702,   702,   702,   702,   702,   702,
     702,   702,   702,   702,   702,   702,   702,   702,   703,   703,
     704,   704,   704,   704,   704,   704,   705,   705,   705,   705,
     705,   705,   705,   705,   705,   705,   705,   705,   705,   705,
     707,   706,   708,   708,   708,   709,   709,   710,   710,   710,
     710,   710,   711,   711,   712,   712,   712,   712,   713,   713,
     713,   714,   714,   715,   716,   717,   717,   718,   718,   718,
     718,   718,   718,   718,   718,   718,   718,   718,   718,   718,
     718,   719,   719,   719,   720,   720,   720,   721,   721,   721,
     722,   722,   723,   723,   724,   724,   724,   724,   725,   726,
     726,   727,   727,   728,   728,   728,   728,   728,   728,   728,
     728,   728,   728,   728,   729,   729,   730,   731,   732,   732,
     733,   734,   734,   735,   736,   736,   736,   736,   736,   737,
     737,   738,   739,   739,   739,   739,   739,   739,   740,   741,
     741,   741,   742,   742,   743,   743,   743,   744,   744,   745,
     745,   746,   746,   747,   747,   748,   748,   749,   749,   750,
     751,   751,   751,   751,   751,   751,   752,   752,   753,   753,
     754,   754,   754,   754,   755,   755,   756,   756,   757,   757,
     758,   758,   758,   758,   759,   760,   760,   760,   761,   761,
     762,   763,   763,   764,   765,   765,   766,   767,   767,   768,
     768,   768,   768,   768,   768,   768,   768,   769,   769,   770,
     771,   771,   772,   772,   773,   774,   775,   776,   776,   777,
     778,   778,   778,   778,   778,   779,   779,   779,   780,   780,
     781,   781,   782,   782,   782,   782,   783,   783,   784,   784,
     784,   784,   784,   785,   785,   785,   786,   786,   786,   786,
     786,   786,   786,   786,   787,   787,   788,   788,   789,   789,
     789,   789,   790,   790,   791,   792,   792,   793,   793,   794,
     794,   794,   794,   794,   795,   795,   796,   796,   797,   798,
     798,   799,   799,   800,   800,   801,   801,   802,   802,   803,
     803,   804,   804,   805,   805,   806,   806,   807,   807,   808,
     808,   808,   808,   808,   808,   808,   808,   808,   808,   808,
     809,   809,   809,   809,   809,   809,   810,   810,   810,   810,
     811,   811,   811,   811,   812,   812,   813,   813,   814,   814,
     814,   814,   815,   815,   815,   816,   817,   817,   818,   818,
     818,   818,   819,   819,   820,   821,   821,   821,   821,   822,
     822,   822,   823,   823,   823,   823,   823,   823,   823,   823,
     823,   824,   824,   824,   824,   824,   824,   824,   825,   825,
     825,   825,   826,   826,   827,   827,   828,   828,   828,   828,
     828,   828,   828,   828,   828,   828,   828,   829,   829,   830,
     830,   831,   831,   832,   833,   834,   834,   835,   835,   836,
     837,   838,   838,   838,   838,   838,   838,   839,   839,   840,
     840,   841,   841,   841,   841,   842,   843,   843,   843,   844,
     844,   844,   844,   844,   844,   844,   844,   844,   844,   844,
     844,   844,   844,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   846,   846,   846,   846,   846,   846,   846,   846,   846,
     846,   846,   846,   846,   846,   846,   846,   846,   846,   846,
     846,   846,   847,   847,   847,   847,   847,   847,   847,   847,
     847,   847,   847,   848,   848,   848,   848,   848,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   848,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   848,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   848,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   849,   849,   850,
     850,   850,   850,   851,   852,   852,   853,   853,   854,   854,
     855,   855,   855,   856,   856,   856,   857,   857,   857,   858,
     858,   859,   859,   859,   859,   859,   859,   859,   859,   859,
     860,   860,   861,   861,   862,   862,   862,   862,   862,   862,
     863,   863,   864,   864,   865,   865,   866,   866,   867,   867,
     868,   868,   868,   868,   868,   868,   868,   868,   869,   869,
     870,   871,   871,   872,   872,   872,   872,   872,   872,   873,
     874,   875,   875,   875,   876,   876,   877,   878,   878,   879,
     880,   880,   881,   881,   882,   882,   883,   883,   883,   883,
     884,   884,   885,   885,   886,   886,   887,   887,   888,   888,
     889,   890,   890,   891,   891,   891,   892,   892,   893,   893,
     894,   894,   895,   895,   896,   897,   898,   899,   900,   901,
     902,   902,   903,   903,   903,   903,   903,   903,   903,   903,
     904,   905,   906,   907,   908,   908,   908,   908,   909,   909,
     910,   910,   911,   911,   912,   912,   912,   912,   912,   913,
     913,   914,   914,   914,   915,   915,   915,   915,   915,   916,
     916,   917,   917,   917,   917,   917,   917,   917,   917,   918,
     919,   919,   920,   920,   920,   920,   921,   921,   921,   921,
     922,   922,   923,   924,   925,   925,   926,   926,   926,   927,
     927,   928,   928,   929,   929,   930,   930,   930,   930,   931,
     931,   932,   933,   933,   934,   935,   936,   937,   937,   938,
     939,   939,   940,   940,   940,   940,   940,   942,   941,   943,
     944,   945,   945,   945,   946,   946,   946,   946,   946,   947,
     947,   949,   948,   951,   950,   952,   950,   950,   953,   953,
     954,   954,   954,   955,   955,   955,   955,   956,   956,   957,
     957,   957,   957,   957,   957,   958,   958,   958,   959,   961,
     960,   962,   963,   962,   964,   964,   965,   965,   966,   966,
     967,   967,   967,   967,   967,   967,   967,   967,   967,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   969,
     969,   970,   970,   971,   972,   972,   973,   973,   973,   974,
     975,   976,   976,   976,   976,   977,   977,   977,   978,   978,
     978,   978,   978,   979,   979,   980,   980,   981,   981,   982,
     983,   983,   984,   984,   985,   986,   987,   987,   988,   988,
     989,   989,   990,   990,   991,   991,   991,   992,   992,   993,
     994,   995,   996,   996,   997,   998,   999,   999,  1000,  1001,
    1002,  1003,  1003,  1004,  1005,  1006,  1006,  1007,  1008,  1008,
    1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,  1008,
    1008,  1008,  1008,  1009,  1009,  1010,  1010,  1011,  1011,  1011,
    1013,  1012,  1014,  1014,  1016,  1015,  1017,  1017,  1017,  1018,
    1018,  1018,  1018,  1018,  1018,  1018,  1018,  1018,  1019,  1019,
    1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,
    1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,  1020,
    1020,  1020,  1020,  1020,  1020,  1021,  1021,  1021,  1021,  1021,
    1021,  1022,  1022,  1022,  1022,  1022,  1022,  1022,  1023,  1024,
    1024,  1024,  1024,  1024,  1024,  1024,  1024,  1025,  1025,  1025,
    1025,  1025,  1025,  1025,  1026,  1026,  1026,  1026,  1026,  1026,
    1027,  1027,  1027,  1027,  1027,  1027,  1027,  1027,  1027,  1028,
    1028,  1028,  1028,  1029,  1029,  1029,  1029,  1030,  1030,  1030,
    1030,  1030,  1030,  1030,  1031,  1031,  1032,  1032,  1032,  1032,
    1032,  1032,  1033,  1033,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1035,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1036,  1036,  1036,  1036,  1036,
    1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,
    1036,  1036,  1036,  1036,  1036,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1038,  1038,  1039,  1040,  1040,
    1041,  1041,  1042,  1043,  1044,  1044,  1044,  1045,  1046,  1046,
    1047,  1047,  1048,  1048,  1048,  1049,  1049,  1050,  1050,  1051,
    1051,  1052,  1052,  1052,  1052,  1052,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,  1053,
    1053,  1053,  1053
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     5,     1,     0,     2,     2,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     3,     2,     2,     2,     2,     3,     3,     5,
       5,     4,     5,     4,     3,     5,     3,     5,     5,     6,
       1,     1,     3,     5,     6,     4,     1,     0,     2,     0,
       1,     1,     1,     1,     1,     1,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     5,     2,     2,     3,
       3,     3,     1,     3,     1,     3,     2,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       6,     1,     1,     1,     1,     0,     1,     1,     3,     4,
       5,     4,     2,     2,     3,     4,     3,     2,     2,     1,
       4,     1,     1,     1,     1,     1,     2,     2,     2,     2,
       4,     4,     1,     3,     3,     4,     6,     6,     6,     6,
       4,     6,     2,     4,     3,     3,     3,     3,     4,     4,
       3,     3,     3,     3,     3,     3,     4,     4,     3,     2,
       3,     1,     1,     3,     3,     3,     2,     2,     3,     2,
       1,     1,     0,     2,     0,     2,     2,     9,     6,     1,
       1,     1,     1,     1,     2,     0,     1,     1,     3,     3,
       1,     1,     3,     3,     3,     4,     1,     0,     2,     0,
       3,     0,     1,     0,    11,    12,     1,     1,     2,     2,
       2,     2,     0,     1,     0,     1,     3,     1,     1,     1,
       3,     2,     0,     3,     1,     1,     2,     1,     3,     4,
       4,     2,     5,     1,     2,     2,     2,     3,     2,     0,
       2,     2,     2,     2,     2,     2,     3,     1,     4,     6,
       7,    11,     3,     0,     3,     1,     1,     2,     2,     0,
       1,     1,     2,     2,     0,     3,     3,     2,     1,     1,
       2,     2,     4,     0,     2,     2,     2,     0,     3,     4,
       4,     0,     2,     0,     4,     0,     0,     7,     5,     3,
       0,     3,     1,     1,     5,     4,     2,     0,     2,     1,
       2,     3,     2,     2,     2,     2,     3,     3,     3,     1,
       0,     5,     9,     1,     0,     1,     2,     2,     0,     2,
       0,     5,     7,     1,     0,     6,     2,     0,     3,     5,
      14,    19,     1,     1,     1,     3,     5,     1,     1,     1,
       3,     0,     1,     0,     1,     1,     1,     3,     0,     1,
       1,     0,     2,     1,     2,     1,     2,     2,     1,     2,
       2,     6,     8,     8,     3,     5,     4,     4,     4,     3,
       7,     8,     6,     6,     6,     6,     3,     1,     3,     3,
       1,     1,     1,     1,     1,     3,     3,     3,     1,     3,
       3,     1,     3,    13,     1,     3,     4,     7,     4,     7,
       2,     1,     0,     2,     0,     1,     0,     6,     8,     8,
       1,     3,     5,     5,     7,     9,     7,     9,     5,     6,
       6,     4,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     3,     3,     3,     1,     3,     1,     2,     2,     3,
       4,     5,     4,     4,     3,     4,     3,     3,     2,     4,
       2,     1,     1,     1,     1,     2,     2,     1,     1,     1,
       2,     2,     1,     2,     2,     1,     1,     6,     7,     7,
       9,     8,     8,     6,     9,     9,     7,    10,     7,     8,
       8,     8,     8,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     7,     7,    10,
       2,     1,     1,     1,     3,     1,     1,     1,     1,     1,
       2,     2,     2,     2,     2,     2,     2,     1,     3,     1,
       2,     3,     0,     1,     3,     2,     6,     6,     3,     0,
       3,     0,    13,    14,     1,     0,     2,     0,     1,     3,
       4,     4,     6,     1,     2,     0,     1,     1,     0,     1,
       1,     0,     9,     7,     2,     0,     3,     2,     1,     3,
       3,     3,     2,     2,     1,     1,     1,     1,     2,     1,
       3,     1,     1,     1,     4,     5,     1,     2,     4,     5,
       1,     1,     1,     1,     3,     3,     2,     2,     2,     2,
       1,     2,     2,     1,     2,     0,     5,     1,     2,     1,
       0,     5,     7,     5,     7,     7,     9,     1,     3,     3,
       3,     1,     3,    11,    10,     2,     0,     9,     2,     0,
       4,     4,     4,     1,     1,     1,     0,     7,     6,     6,
       6,     6,     7,     9,     9,     6,     6,     6,     6,     6,
       8,     8,     6,     6,     8,     8,     8,     8,     1,     0,
       7,     6,     6,     6,     6,     6,     7,     6,     6,     6,
       6,     7,     9,     9,     9,     6,     6,     6,     8,     8,
       0,    14,     1,     1,     3,     3,     1,     1,     1,     1,
       1,     1,     1,     0,     1,     1,     1,     1,     1,     1,
       0,     6,     8,     2,     2,     2,     2,     2,     3,     3,
       2,     2,     2,     2,     3,     2,     5,     4,     3,     3,
       3,     1,     1,     0,     3,     2,     2,     1,     3,     2,
       1,     0,     8,    10,     2,     3,     3,     0,     2,     5,
       3,     1,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     4,     3,     3,     1,     0,     5,     4,     2,     0,
       4,     3,     5,     6,     4,     6,     6,     5,     7,     1,
       0,     6,    11,    11,    11,    13,     9,    11,    10,     3,
       1,     4,     2,     0,     4,     5,     5,     2,     4,     1,
       1,     1,     0,     1,     0,     1,     0,     3,     0,     4,
       1,     1,     1,     1,     1,     1,     1,     0,     5,     4,
       1,     1,     1,     1,     3,     0,     4,     8,     3,     0,
       2,     3,     2,     3,     5,     1,     4,     2,     3,     1,
       2,     2,     0,     6,     2,     0,     5,     3,     0,     2,
       2,     2,     3,     1,     3,     1,     2,     1,     0,     7,
       1,     3,     1,     1,     3,     5,     2,     1,     3,     7,
       0,     2,     2,     2,     3,     0,     2,     2,     1,     1,
       3,     3,     1,     2,     4,     4,     1,     1,     8,     1,
       4,     4,     4,     2,     1,     0,     3,     3,     4,     4,
       4,     4,     2,     1,     1,     0,     1,     0,     1,     5,
       1,     0,     1,     0,     3,     1,     3,     4,     3,     4,
       4,     2,     2,     4,     1,     0,     1,     1,     1,     3,
       0,     2,     0,     1,     3,     1,     0,     1,     2,     4,
       4,     2,     0,     2,     3,     2,     0,     3,     1,     1,
       2,     1,     2,     5,     6,     5,     1,     2,     1,     4,
       3,     4,     5,     4,     5,     4,     5,     2,     4,     1,
       2,     2,     2,     1,     1,     0,     4,     2,     1,     2,
       2,     4,     1,     2,     3,     1,     2,     0,     2,     4,
       4,     0,     1,     3,     2,     2,     3,     5,     6,     3,
       4,     0,     1,     3,     3,     3,     3,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     2,     5,     1,     1,
       1,     1,     2,     3,     3,     0,     1,     1,     1,     1,
       1,     2,     2,     2,     2,     2,     1,     3,     0,     1,
       1,     1,     1,     5,     2,     1,     1,     1,     1,     5,
       2,     2,     2,     1,     3,     3,     2,     1,     0,     3,
       0,     5,     2,     5,     2,     1,     3,     3,     0,     1,
       1,     1,     1,     1,     1,     3,     3,     3,     3,     3,
       3,     3,     0,     1,     3,     5,     2,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     2,
       3,     3,     2,     3,     5,     4,     6,     3,     5,     4,
       6,     4,     6,     5,     7,     2,     3,     2,     4,     3,
       3,     4,     3,     4,     3,     4,     5,     6,     6,     7,
       6,     7,     6,     7,     3,     4,     4,     6,     2,     3,
       4,     1,     3,     2,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     2,     2,     5,     6,     6,     7,
       3,     4,     1,     1,     2,     4,     1,     1,     1,     2,
       2,     2,     1,     3,     4,     5,     5,     4,     1,     1,
       4,     1,     4,     1,     4,     1,     4,     1,     1,     1,
       1,     6,     4,     4,     4,     4,     6,     5,     5,     5,
       4,     6,     4,     6,     4,     4,     4,     4,     5,     7,
       7,     9,     4,     6,     5,     7,     7,     2,     3,     3,
       3,     4,     0,     4,     1,     3,     3,     1,     1,     1,
       2,     2,     0,     4,     3,     5,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     1,     4,     1,     4,     1,     2,     1,     2,
       1,     3,     3,     0,     1,     3,     1,     3,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     3,
       2,     3,     0,     3,     3,     2,     2,     1,     0,     2,
       2,     3,     2,     1,     1,     3,     5,     2,     1,     4,
       2,     0,     1,     0,     1,     2,     2,     2,     3,     5,
       1,     2,     0,     2,     1,     0,     1,     1,     1,     3,
       3,     3,     1,     3,     1,     1,     1,     1,     1,     3,
       1,     2,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     2,     3,     6,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     5,     1,     1,
       1,     1,     5,     3,     2,     2,     3,     7,     1,     1,
       1,     0,     2,     2,     1,     0,     1,     3,     1,     2,
       0,     2,     0,     2,     0,     1,     3,     4,     3,     1,
       1,     1,     2,     0,     7,     3,     1,     1,     1,     1,
       2,     0,     1,     3,     3,     3,     3,     0,     4,     5,
       5,     0,     1,     1,     1,     1,     2,     2,     2,     1,
       2,     0,     7,     0,     5,     0,     4,     2,     2,     0,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     5,     2,     1,     3,     2,     2,     3,     0,
       5,     1,     0,     5,     2,     2,     1,     1,     1,     2,
       2,     3,     1,     2,     2,     3,     3,     4,     2,     1,
       2,     1,     1,     2,     2,     3,     1,     1,     1,     1,
       0,     1,     3,     5,     0,     2,     0,     1,     2,     3,
       2,     1,     1,     1,     0,     1,     1,     1,     2,     2,
       1,     1,     0,     1,     1,     1,     1,     2,     2,     3,
       0,     1,     2,     1,     4,     4,     0,     1,     2,     1,
       1,     3,     1,     1,     4,     4,     4,     1,     0,     3,
       3,     4,     1,     3,     3,     4,     1,     3,     3,     1,
       6,     1,     3,     3,     6,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     4,     1,     1,     4,     4,     3,
       0,     7,     1,     0,     0,     7,     3,     4,     3,     1,
       1,     1,     2,     3,     5,     2,     5,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     1,     0,     1,
       2,     1,     2,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     2,     3,     1,     2,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  2221,  2225,  2229,  2230,  2157,  2231,
    2232,  2197,  2198,  2199,  2200,  2201,  2202,  2203,  2204,  2205,
    2206,  2207,  2208,  2210,  2209,  2211,  2212,  2213,  2214,  2215,
    2216,  2217,  2218,  2220,  2219,  2234,  2222,  2235,  2223,  2224,
    2226,  2227,  2196,  2228,  2236,  2237,  2238,  2233,  2186,  1444,
    2187,    10,  1447,  1445,  1446,  1440,  1441,  2241,  2192,  2193,
    2191,  2194,  2195,  2239,  2240,  2182,  2183,  2185,    11,    12,
    2184,  2242,     4,  2188,  2189,  2190,     8,  1527,  1600,     9,
    2181,  1600,     0,  1710,  1711,  1712,     0,  1713,  1714,  1715,
    1716,  1717,  1648,  1614,  1718,     0,  1719,  1720,  1721,  1722,
    1723,  1724,  1725,  1726,     0,  1727,  1728,  1729,  1730,  1599,
    1731,  1732,  1733,  1734,  1576,  1582,  1694,     0,  1556,  1557,
    1553,  1555,  1554,  1558,  1541,   823,   434,   890,   889,     0,
    2065,   823,  2066,  2023,  2067,  2024,  2025,   235,     0,   880,
    2026,     0,   823,  2027,   307,   322,  2068,  1491,     0,  2028,
    2029,     0,     0,     0,   434,   823,     0,     0,  2030,   907,
    2031,     0,  2032,  2069,  2070,     0,     0,  2033,  2071,  2072,
    2034,     0,  2035,  2036,  2073,  2074,  2075,  2037,  2076,  2077,
       0,     0,   995,     0,  2038,  2078,  2039,  2040,     0,  2079,
    2041,  2042,  2043,  2080,  2081,  2044,  2045,  2046,     0,  2047,
       0,     0,     0,     0,     0,  2082,   823,  2048,     0,  1001,
       0,  2049,     0,  2083,  2050,     0,  2051,  2052,  2053,  2054,
    2055,   995,  1690,  1577,     0,     0,   894,     0,  2056,  2084,
    2057,  2058,  2059,  2060,  2061,  2062,  2063,  2064,  2168,  2169,
       0,     0,     0,    47,    53,    24,    23,    27,    28,    67,
      72,    42,    18,    62,    48,   101,   102,   103,    34,    30,
      59,    22,    31,    35,    50,    36,    49,    21,    43,    66,
      51,    70,    52,    71,    37,    60,    57,    44,    45,    46,
      63,    64,    65,    86,    69,    97,    76,    33,    77,    92,
      78,    93,    79,    41,    17,    90,    88,    89,    38,    61,
      87,    91,    19,    20,    94,    68,    84,    81,    98,    96,
     104,    82,    54,    14,    15,    73,    40,    16,    26,    25,
      39,    32,   100,    29,   892,    74,    85,    75,    55,    80,
      58,    83,    99,    56,    95,   969,   968,  1003,   972,   979,
     106,   107,   112,     7,  1516,  1517,  1518,  1600,  1551,  1552,
    1545,  1561,  1571,  1560,  1564,  1572,  1559,  1578,     0,   109,
     111,   113,   116,   110,   105,   108,   115,   120,   114,   119,
     117,   118,   121,   122,   123,  1782,  1172,  1780,  1781,  1779,
    1533,     0,  1600,  1535,  1534,     0,  1735,  1736,  1737,  1738,
    1739,  1740,  1787,  1788,  1789,  1790,  1791,  1793,  1792,  1804,
    1805,  1806,  1807,  1808,  1809,  1810,  1811,  1812,  1813,  1814,
    1815,  1816,  1817,  1818,  1819,  1820,  1821,  1822,  1823,  1824,
    1825,  1762,  1826,  1827,  1828,  1829,  1830,  1831,  1832,  1833,
    1834,  1835,  1803,  1836,  1837,  1838,  1839,  1840,  1841,  1842,
    1843,  1844,  1845,  1846,  1847,  1796,  1848,  1849,  1850,  1851,
    1852,  1853,  1854,  1855,  1856,  1857,  1858,  1859,  1860,  1861,
    1862,  1863,  1864,  1865,  1866,  1868,  1867,  1869,  1870,  1871,
    1872,  1873,  1874,  1875,  1876,  1877,  1878,  1879,  1880,  1881,
    1882,  1797,  1883,  1884,  1885,  1886,  1887,  1888,  1889,  1890,
    1891,  1892,  1893,  1894,  1895,  1896,  1897,  1898,  1899,  1900,
    1901,  1902,  1903,  1904,  1905,  1906,  1907,  1908,  1909,  1910,
    1911,  1798,  1912,  1913,  1799,  1914,  1915,  1916,  1917,  1918,
    1919,  1920,  1921,  1922,  1923,  1924,  1925,  1926,  1927,  1928,
    1929,  1930,  1931,  1932,  1933,  1934,  1935,  1936,  1937,  1938,
    1939,  1942,  1940,  1941,  1943,  1944,  1945,  1946,  1947,  1948,
    1949,  1950,  1951,  1952,  1953,  1954,  1955,  1956,  1957,  1958,
    1959,  1960,  1961,  1962,  1963,  1964,  1965,  1966,  1967,  1968,
    1969,  1970,  1800,  1971,  1972,  1973,  1974,  1975,  1976,  1977,
    1978,  1979,  1980,  1981,  1982,  1983,  1984,  1985,  1986,  1987,
    1988,  1990,  1989,  1991,  1992,  1993,  1994,  1995,  1491,  1996,
    1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,  2005,  2006,
    2007,  2008,  2009,  2010,  1763,  2011,  2012,  2013,  2014,  2015,
    2016,  2017,  2018,  2019,  2020,  1801,  2021,  2022,  2167,  1459,
    1510,  1509,  1484,  1505,  1760,  1708,  1709,  1479,  1761,  1758,
    1794,  1795,  1802,  1759,  1460,  2163,  1757,  1647,     0,     0,
    1613,  1612,  1616,  1615,  1617,  1610,  1611,  1425,  1511,  1628,
    1627,  1424,  1630,  1741,  1742,  1743,  1744,  1746,  1745,  1747,
    2085,  2086,  2087,  2088,  2089,  2090,  2091,  2092,  2093,  2094,
    2095,  2096,  1772,  2097,  2098,  2099,  2100,  2101,  2102,  2103,
    2106,  2104,  2105,  2107,  2108,  2109,  2110,  2111,  2112,  2113,
    2114,  2115,  2116,  2117,  2118,  2119,  2120,  2121,  2122,  2123,
    2124,  1773,  1774,  2125,  2126,  2127,  2128,  2129,  2130,  2131,
    2132,  2133,  2134,  2135,  2136,  2137,  2138,  2139,  2140,  2141,
    2142,  2143,  2144,  2145,  2146,  2147,  1776,  2148,  2149,  1775,
    2150,  2151,  2152,  2153,  2154,  1786,  1771,  1574,  1748,  1783,
    1770,  1777,  1778,  1785,  1784,  1584,  1580,  1588,  1583,     0,
       0,     0,     0,  1600,   822,   821,   807,     0,     0,     0,
       0,     0,     0,     0,     0,   433,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    13,     0,   831,
     286,   285,  1481,  1480,  1420,   883,  1416,  1417,   434,     0,
     810,   306,     0,     0,     0,     0,     0,     0,     0,   511,
       0,     0,     0,     0,     0,     0,     0,   167,     0,   317,
     316,     0,     0,   423,     0,   644,     0,     0,   434,     0,
       0,     0,  1490,  1489,  1485,  1495,     0,  1488,  1757,     0,
     922,  1940,  1625,  1626,   920,  1981,   960,     0,   236,   239,
     237,   238,     0,     0,   729,   538,     0,   537,     0,     0,
     535,     0,     0,     0,     0,   539,   533,   532,     0,     0,
       0,   536,     0,   534,     0,     0,   811,     0,  1566,  1567,
    1884,   919,   906,   892,  1805,   568,   572,   563,   569,   576,
     575,   564,   561,   562,  1952,     0,     0,     0,   558,  1448,
    1450,   567,  1449,     0,   611,   617,   616,   615,     0,   612,
     613,   618,     0,   804,   838,  1429,   994,     0,     0,   560,
     803,  1996,   915,     0,     0,   733,     0,   734,     0,  1967,
     815,   227,  1755,  1973,  2052,  1996,  1756,   223,  1753,   192,
    1754,  1750,  1751,  1752,  1749,     0,     0,   612,     0,   812,
     813,  1000,   998,     0,     0,     0,     0,  1836,  1905,   215,
    1963,  1973,  2052,  1996,  2020,   176,     0,   222,  1973,  2052,
    1996,     0,   831,     0,     0,  1575,   806,   805,     0,  1072,
       0,  1068,   893,   896,     0,  1033,   977,     0,   823,     0,
       6,   891,   887,   997,   997,     0,   997,     0,   973,     0,
    1543,  1571,  1550,  1606,  1547,     0,     0,  1596,  1592,  1589,
    1597,  1598,  1591,  1579,  1161,  1162,  1163,  1160,  1164,  1159,
       0,  1522,  1563,  1528,     0,  1538,  1537,  1536,  2170,  2171,
    1649,  1483,  1502,     0,     0,     0,     0,     0,  1636,  1629,
    1631,  1633,  1586,  1585,  1581,     0,     0,  1699,     0,     0,
    1700,  1701,     0,  1696,  1698,     0,  1606,     0,     0,  1760,
    1768,  1430,  1761,  1758,  1766,  1757,     0,   546,   126,     0,
       0,   546,     0,     0,     0,     0,  1828,  1872,  1329,  1339,
    1337,  1338,  1331,  1332,  1333,  1336,  1334,  1335,     0,   721,
    1330,     0,   126,     0,     0,   407,     0,     0,     0,     0,
       0,   126,     0,     0,     0,     0,     0,   827,   830,   808,
       0,     0,  1400,  1421,     0,     0,   879,     0,     0,   593,
     602,   594,   599,     0,   596,     0,     0,   604,     0,   595,
     597,   598,   603,     0,     0,   600,   601,     0,     0,   819,
     309,     0,     0,     0,     0,     0,   840,   870,   321,   320,
     126,   319,   318,     0,     0,     0,   664,   126,     0,   169,
     437,     0,     0,   479,   126,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1494,  1500,     0,  1492,  1650,   923,
     921,  1609,     0,   935,  1883,     0,   474,     0,     0,  1883,
     861,  1883,     0,  1883,   162,  1422,     0,     0,     0,     0,
       0,  1883,   154,  1883,     0,  1883,   438,     0,  1883,     0,
    1883,   156,     0,  1883,   282,   544,     0,     0,  2175,  2179,
       0,  2177,  2172,  1565,  1624,  1623,  1515,     0,  1622,     0,
     565,   574,   573,   571,   570,   566,  1451,     0,   556,   557,
    1636,  1639,   554,     0,   610,     0,     0,     0,     0,   938,
    1418,     0,   818,     0,     0,     0,     0,   736,   736,   736,
     814,   226,   224,     0,     0,     0,     0,     0,   820,     0,
       0,     0,  2023,  2024,  1126,  1393,     0,  1762,  2025,  2026,
    2027,  1268,  1277,  1269,  1271,  1278,  2028,  2029,  1860,  2030,
    2031,  1437,  2032,  2033,  1116,  2035,  2036,  2037,  1273,  1275,
    2038,  2039,     0,  1438,  2041,  2042,  1932,  2044,  2045,  2047,
    2048,  1279,  2050,  2051,  2052,  2053,  2054,  2055,  1436,     0,
    1280,  2056,  2058,  2059,  2060,  2061,  2062,  2063,  1340,  1442,
    1443,  1402,     0,     0,  1415,     0,  1258,     0,  1108,  1109,
    1131,  1132,  1110,  1137,  1138,  1150,  1111,     0,  1414,  1173,
    1257,  1262,     0,  1256,  1252,   985,  1412,  1394,     0,  1253,
    1473,  1472,  1474,  1475,  1471,  1432,  1439,  1478,  2163,     0,
       0,     0,     0,     0,  1689,   231,     0,   232,  1973,   177,
     214,   187,   213,   188,   217,   216,     0,  1826,   178,     0,
     185,     0,     0,     0,     0,     0,     0,     0,   218,   809,
     282,     0,     0,  1070,     0,  1073,     0,  1069,   895,   892,
    1407,  1406,  1408,     0,   971,   970,     5,   898,   996,     0,
       0,     0,     0,     0,     0,     0,  1026,  1015,  1023,  1027,
    1034,  1606,  1607,     0,  1601,     0,  1600,  1600,  1594,  1593,
    1590,     0,     0,     0,     0,     0,     0,  1465,  1464,  1519,
    1521,  1468,     0,     0,  1504,     0,  1508,  1506,  1636,  1644,
    1636,  1645,  1646,  1637,  1469,  1470,  1642,     0,  1632,  1640,
    1643,  1587,  1600,  1707,     0,  1702,  1705,     0,  1697,     0,
    1431,     0,     0,     0,     0,     0,   547,     0,     0,     0,
     125,   859,   229,   857,     0,     0,     0,   864,     0,     0,
       0,     0,   691,     0,     0,     0,     0,     0,     0,   692,
     690,   693,   700,   707,   710,     0,   635,   160,   161,     0,
       0,     0,     0,     0,     0,   241,   272,     0,     0,     0,
       0,     0,   151,     0,     0,     0,     0,   405,   759,   759,
       0,     0,   759,     0,     0,     0,   759,     0,   240,   242,
     271,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   153,     0,     0,  1529,     0,   825,   826,     0,
     829,     0,  1397,  1396,  1427,  1401,   881,   882,  1428,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   292,   293,   126,   291,     0,     0,   476,
       0,  1119,  1148,  1148,  1148,  1115,  1115,  1128,  1117,  1155,
       0,  1148,  1115,  1120,     0,  1118,  1158,  1158,  1143,     0,
    1091,  1101,  1103,  1104,  1129,  1130,  1105,  1135,  1136,  1102,
    1172,  1767,  1115,  1769,  1765,  1764,     0,     0,   869,     0,
       0,   512,     0,     0,   477,     0,     0,     0,   165,     0,
       0,     0,     0,     0,     0,   443,   442,     0,     0,   478,
       0,   407,     0,   400,   363,     0,     0,  1834,     0,     0,
       0,  1498,  1493,  1496,     0,  1486,  1500,   961,   965,   962,
       0,   963,     0,  1081,     0,   282,   728,     0,     0,     0,
     282,     0,     0,  1883,     0,  1883,     0,     0,     0,   282,
       0,     0,     0,     0,   543,   541,   540,   542,     0,     0,
       0,     0,   282,     0,   280,   281,     0,   531,  2173,     0,
       0,  2176,  1568,     0,  1350,     0,   916,  1620,  1621,   322,
       0,     0,   899,   905,   901,   903,   902,   904,   900,   555,
     552,   553,     0,  1638,  2155,  2161,     0,  1651,  1652,     0,
    1847,  1877,  1899,  1968,  1971,     0,  1991,     0,   619,   639,
     614,     0,     0,   932,   925,     0,     0,   948,   559,   909,
    1354,     0,     0,     0,   735,   732,   731,   730,   225,   193,
       0,     0,   641,  1967,   817,     0,     0,  1260,  1261,  1147,
    1134,  1392,     0,     0,  1142,  1141,     0,     0,     0,     0,
       0,  1124,  1123,  1122,  1259,  1353,     0,  1121,     0,     0,
       0,     0,  1148,  1148,  1146,  1192,     0,  1125,     0,     0,
    1372,     0,  1378,     0,     0,     0,  1154,     0,  1152,     0,
       0,  1228,     0,     0,     0,     0,     0,     0,  1254,  1176,
    1177,  1763,  1258,  1350,     0,  1433,     0,     0,  1140,     0,
    1172,     0,     0,     0,     0,  1405,  1348,     0,     0,  1205,
    1346,     0,  1207,     0,     0,     0,  1340,  1339,  1337,  1338,
    1331,  1332,  1333,  1336,  1334,  1335,  1344,  1189,     0,     0,
    1188,  1636,     0,  1036,   984,  1395,     0,  1476,     0,  2162,
    2164,  1686,  1685,  1684,  1683,  1659,     0,  1655,  1656,     0,
    1687,  1688,   233,   234,   230,     0,   190,   189,     0,   211,
     212,   184,     0,   207,   208,  1319,  1318,   191,   183,   181,
     204,   206,   205,   203,   179,   194,   200,   201,   202,   182,
     180,   221,   219,     0,   550,  1600,     0,  1074,     0,  1036,
     950,   952,   953,     0,  1402,   884,  1410,     0,     0,   888,
     977,   982,   976,   981,  1004,  1005,   658,   980,     0,  1032,
    1032,  1017,  1011,  1016,  1012,  1018,  1025,   975,  1014,   974,
       0,  1028,     0,  1608,  1546,  1606,  1091,  1600,  1539,  1600,
    1595,  1525,  1166,  1167,  1168,  1169,  1171,  1170,  1526,  1523,
    1165,  1524,  1467,  1466,     0,     0,     0,  1501,     0,  1482,
    1507,     0,     0,  1091,  2158,  1703,  2158,  1091,     0,     0,
       0,     0,     0,     0,     0,   548,     0,     0,     0,   228,
     856,     0,     0,     0,     0,     0,   867,   357,     0,   279,
       0,     0,     0,     0,     0,     0,   698,     0,     0,     0,
       0,   699,   696,   697,  1968,   709,   708,   706,   675,   677,
     676,     0,   667,     0,   668,     0,     0,   674,   683,   681,
       0,     0,     0,     0,   277,     0,   276,     0,     0,     0,
       0,     0,   717,   722,     0,     0,   135,   137,     0,     0,
     133,   139,   136,   138,   134,   140,   132,     0,     0,   131,
       0,     0,     0,     0,   150,     0,     0,     0,     0,     0,
     409,   420,     0,     0,     0,     0,   126,   126,   406,   758,
     252,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   269,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   152,
       0,     0,     0,     0,     0,   199,   824,   828,  1398,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   308,   290,   289,     0,
     295,     0,   498,  1764,   475,     0,  1091,     0,     0,     0,
    1085,  1161,  1160,  1159,     0,  1106,  1115,  1112,     0,     0,
     855,   855,   855,   855,   855,   839,   841,   332,   158,     0,
       0,     0,   487,   490,     0,   124,   169,   322,     0,   168,
     170,   172,   173,   174,   171,   175,   436,     0,     0,     0,
       0,     0,   448,   447,   449,     0,   444,     0,     0,   149,
     404,   396,     0,   324,   387,     0,     0,   421,     0,     0,
       0,     0,   780,     0,  1499,     0,     0,     0,     0,   964,
       0,  1046,   934,  1038,  1048,  1039,  1041,  1075,  1420,     0,
       0,   932,     0,   713,     0,   862,     0,   711,   163,  1423,
       0,     0,     0,     0,     0,     0,   528,   155,     0,   282,
     439,     0,   282,   157,     0,   431,   282,   545,  2174,  2180,
    2178,   918,     0,  1618,  1619,     0,   960,   551,     0,     0,
    2160,  1452,     0,  1453,     0,     0,   623,   622,   633,   624,
     625,   621,   620,   626,     0,     0,   641,   927,     0,   929,
    1402,     0,   924,     0,   945,     0,   943,     0,  1419,   947,
     936,   914,     0,   908,   911,   913,   912,   910,     0,     0,
     612,     0,     0,   282,   816,     0,     0,     0,  1356,     0,
       0,  1391,  1388,     0,     0,  1350,     0,     0,     0,     0,
    1363,  1364,  1365,  1362,  1366,  1361,     0,     0,  1367,  1360,
       0,     0,     0,     0,     0,  1145,  1144,     0,     0,     0,
       0,     0,     0,  1231,  1262,     0,     0,  1324,     0,  1350,
    1377,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1350,  1383,     0,     0,     0,  1317,     0,  1314,     0,
       0,     0,  1403,  1402,     0,     0,     0,     0,  1434,  1174,
    1190,  1413,     0,  1404,     0,     0,  1197,     0,  1384,  1224,
       0,  1229,  1212,     0,  1206,     0,  1210,  1214,  1193,  1405,
    1349,     0,  1347,     0,     0,  1191,     0,  1186,  1184,  1185,
    1178,  1179,  1180,  1181,  1182,  1183,  1187,  1328,  1326,  1327,
       0,     0,     0,  1209,  1878,  1905,     0,   995,   995,   983,
     993,  1411,     0,  1077,     0,     0,     0,  1263,     0,  2166,
    2165,     0,     0,     0,     0,     0,  1172,     0,   220,  1091,
    1071,   957,     0,     0,  1081,     0,   956,   886,   885,  1409,
       0,     0,   656,   657,     0,   661,  1024,     0,   948,   948,
       0,     0,     0,  1544,  1602,  1549,  1570,  1540,  1573,  1520,
    1562,     0,  1503,  1634,  1641,  1693,     0,  2159,     0,     0,
     496,   495,     0,     0,     0,   767,   738,   549,   768,   739,
       0,   858,     0,     0,     0,     0,     0,   282,   865,   278,
     866,   761,   769,     0,   694,   695,   770,   740,     0,   762,
     678,  1115,   666,     0,     0,   673,     0,   672,  1115,  1115,
     741,   159,   274,   749,   275,   273,     0,  1426,     0,     0,
       0,     0,   145,     0,     0,     0,     0,   128,   127,   146,
     144,     0,   143,     0,   775,   745,   747,   763,   408,   419,
       0,   412,   413,   410,   414,   415,     0,     0,     0,   244,
       0,     0,   255,   268,   263,   264,   262,   282,   282,     0,
       0,     0,     0,   265,   260,   261,   257,   270,   746,     0,
     764,   256,   254,     0,   243,   777,   753,     0,     0,     0,
       0,     0,     0,     0,   871,     0,     0,     0,   776,   765,
     752,   748,     0,     0,   197,   196,   198,     0,     0,     0,
       0,     0,     0,     0,     0,   606,   583,   605,     0,     0,
       0,     0,     0,     0,     0,   577,   311,   288,   497,     0,
       0,     0,     0,  1086,     0,     0,  1091,     0,     0,  1099,
    1092,  1100,     0,     0,     0,  1113,     0,   855,   854,     0,
       0,     0,     0,     0,   842,   863,     0,   517,   486,     0,
       0,   363,   164,     0,     0,   435,   485,   483,   482,   484,
       0,     0,     0,     0,  1082,     0,     0,     0,     0,     0,
       0,   323,   325,   327,   328,   329,     0,   402,   403,     0,
       0,   391,     0,   365,   366,     0,     0,     0,     0,   647,
       0,     0,     0,   705,   703,   686,     0,  1497,  1491,   966,
     967,     0,   977,     0,  1048,     0,  1047,  1059,     0,     0,
    1065,  1063,     0,  1065,     0,  1065,     0,  1040,     0,  1042,
    1059,  1421,     0,     0,  1078,   933,   282,     0,   282,     0,
     282,     0,   282,     0,   282,     0,   801,     0,   471,   282,
     530,  1351,     0,     0,  1635,  2156,  1660,  1661,     0,  1653,
    1654,     0,     0,   632,   627,   629,     0,   636,     0,     0,
     930,   931,   946,   939,   941,   940,     0,     0,   937,  1355,
     529,     0,   282,     0,   637,   999,  1358,  1359,     0,     0,
       0,     0,  1387,     0,     0,  1294,     0,  1292,  1270,  1272,
    1114,  1282,     0,  1127,  1295,  1296,  1274,  1276,     0,  1341,
       0,     0,  1283,  1233,     0,     0,     0,     0,  1340,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1245,  1244,
    1284,  1323,     0,     0,  1375,  1376,  1285,  1156,  1157,  1158,
    1158,     0,     0,  1382,     0,     0,     0,  1290,  1297,     0,
       0,  1302,     0,  1322,     0,     0,  1255,  1351,  1149,  1150,
       0,     0,     0,     0,     0,     0,     0,     0,  1230,  1213,
    1208,     0,  1211,  1215,     0,     0,     0,     0,  1199,  1225,
    1195,     0,     0,  1201,     0,  1226,   995,   995,   995,   995,
     992,     0,     0,  1035,     0,  1020,     0,     0,  1267,  1264,
    1668,  1669,  1670,  1671,  1672,  1673,  1674,  1676,  1677,  1679,
    1680,  1681,  1675,  1678,  1682,  1664,  1665,     0,  1657,  1658,
     186,     0,   209,   195,  1693,     0,     0,   951,   932,   954,
     897,  1006,     0,  1342,   661,   659,   660,  1008,  1031,  1030,
    1029,  1009,  1013,  1010,     0,  1604,  1530,  1692,  1695,  1706,
    1704,  1542,   766,   737,   760,   855,     0,   356,     0,     0,
       0,   868,   688,     0,  1115,   669,   670,   671,     0,     0,
       0,     0,     0,     0,     0,   719,     0,   720,   718,   141,
     129,   148,   147,   130,   142,   411,   416,   418,   417,   332,
       0,     0,     0,   245,   253,   250,   266,   258,   267,   259,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   771,   742,  1399,   578,     0,   579,   586,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   588,   312,   126,
       0,   296,   300,   870,   870,     0,   301,   870,   297,   870,
     294,   499,     0,  1932,  1332,   500,   491,   493,   494,   492,
       0,     0,     0,     0,  1089,     0,     0,     0,     0,     0,
       0,  1091,  1172,     0,     0,   850,  1461,  1462,   849,  1463,
     846,   845,   853,   852,   844,   843,   848,   847,     0,     0,
       0,   343,     0,     0,   337,     0,     0,   705,   331,   334,
     335,     0,   488,   489,     0,   322,     0,   451,   445,     0,
     501,   480,     0,  1084,   919,   397,   324,   349,   383,     0,
     399,     0,   385,   384,   386,     0,   393,   362,     0,   837,
     428,   425,     0,   647,     0,     0,   701,   679,   702,     0,
     682,     0,   687,   663,     0,  1513,   959,  1514,  1050,  1057,
       0,  1037,     0,  1064,  1060,     0,  1061,     0,     0,  1062,
       0,     0,  1057,     0,     0,     0,   714,     0,   712,     0,
     524,     0,   526,     0,   715,   282,   282,   432,     0,   400,
     965,     0,     0,   634,   630,     0,     0,   607,   638,   926,
     928,   944,   942,     0,   608,   640,  1357,  1133,     0,  1390,
    1386,     0,     0,  1352,     0,  1370,  1369,  1232,  1371,     0,
    1250,     0,     0,  1243,  1242,  1240,  1241,  1234,  1235,  1236,
    1237,  1238,  1239,  1380,  1379,  1373,  1374,  1153,  1151,     0,
    1287,  1288,  1289,  1381,  1298,     0,  1316,  1315,     0,     0,
       0,  1304,     0,     0,  1312,  1325,  1139,  1172,  1175,     0,
       0,  1198,  1385,  1216,     0,     0,     0,  1194,     0,     0,
       0,     0,  1203,  1341,     0,     0,     0,     0,     0,     0,
     987,   986,  1076,     0,  1022,  1265,  1266,  1477,     0,     0,
       0,  1691,     0,   958,   949,     0,  1007,  1548,     0,  1603,
       0,   358,     0,     0,   705,   689,     0,   684,     0,     0,
       0,     0,     0,   518,   504,     0,     0,   519,   520,     0,
       0,     0,   330,     0,     0,     0,     0,   284,   750,     0,
       0,     0,     0,     0,   779,   757,   778,   755,   754,   756,
     751,     0,     0,     0,     0,   582,   592,   590,   589,   591,
     581,   295,     0,     0,     0,     0,     0,     0,     0,   468,
       0,     0,   473,   463,   465,     0,     0,     0,  1087,  1093,
    1094,  1095,  1096,  1097,  1098,  1090,  1107,   461,   851,     0,
       0,   341,   345,   346,   344,   336,   705,   363,   395,     0,
       0,     0,   453,     0,     0,   481,     0,  1083,   917,     0,
     347,     0,   387,   326,   401,   403,     0,     0,   398,   364,
       0,     0,     0,   832,     0,   430,   426,     0,     0,   646,
       0,     0,   705,   704,   796,   797,   794,   795,     0,     0,
    1487,  1049,     0,     0,  1051,     0,     0,  1053,  1055,     0,
       0,     0,     0,     0,  1424,  1264,  1080,  1079,   282,   282,
     282,   282,   802,   472,     0,     0,     0,  1662,  1663,     0,
     628,     0,  1389,  1281,  1291,  1293,  1368,     0,     0,  1251,
       0,     0,  1286,  2057,     0,     0,  1320,  1321,  1303,     0,
    1918,  1307,     0,     0,  1435,  1222,  1220,  1217,     0,  1218,
       0,     0,  1200,  1196,     0,  1202,  1227,   991,   990,   989,
     988,     0,     0,   978,  1666,     0,  1454,  1458,  1455,  1667,
    1172,   955,     0,  1605,   860,     0,   705,   395,   685,   773,
     743,     0,     0,   510,     0,     0,     0,     0,   774,   744,
     772,   246,   247,   248,   249,     0,   251,     0,     0,     0,
     876,     0,     0,   584,   585,   580,   287,   310,   298,   303,
       0,   304,   299,   302,   470,   469,   467,   464,   466,  1088,
       0,   726,     0,     0,     0,     0,   333,   395,   369,     0,
     338,     0,   837,   324,   452,     0,     0,   446,   502,   387,
       0,     0,   348,     0,   391,     0,   388,     0,   392,     0,
       0,   834,   427,     0,   422,     0,     0,     0,     0,   648,
     655,   655,   680,   662,     0,  1512,     0,  1058,  1067,     0,
    1054,  1052,  1043,     0,  1045,   727,   525,   527,   716,     0,
     631,   282,  1246,     0,     0,     0,     0,  1299,     0,  1300,
    1305,  1308,     0,  1306,  1219,  1223,  1221,  1204,  1019,  1021,
    1457,  1456,   210,  1343,     0,   395,   359,     0,     0,   516,
     505,     0,     0,   521,   283,     0,     0,     0,     0,     0,
     587,   305,   726,     0,   724,   462,     0,   340,   339,     0,
     374,     0,   514,   833,   454,   455,   450,     0,   391,   353,
     351,   355,   352,   350,   354,     0,   393,   389,   390,   835,
     836,   429,   878,     0,     0,   705,     0,     0,   653,   658,
     658,  1077,  1056,     0,  1044,   609,  1247,     0,  1248,     0,
       0,  1310,  1309,   363,   360,     0,   508,   515,     0,   506,
       0,     0,   872,     0,   873,   874,   877,   723,   725,     0,
     367,   368,     0,   342,   370,   371,     0,     0,     0,     0,
     393,   382,   314,   705,   655,   393,   649,   654,   661,   661,
       0,  1066,  1249,  1313,  1301,  1311,   369,     0,     0,   523,
     522,     0,     0,     0,     0,     0,   372,     0,   373,   394,
     513,     0,   458,   315,   393,   658,  1077,   651,   650,   800,
     374,     0,   516,   875,     0,   379,     0,   378,     0,   375,
     376,   503,     0,   456,     0,   459,   460,  1077,   661,   642,
     799,   798,     0,     0,   509,   507,     0,   377,   380,   381,
     440,     0,     0,   643,   652,   782,   793,   781,   783,   791,
     788,   790,   789,   787,   361,     0,   457,     0,     0,   792,
     786,   977,   968,     0,     0,   784,   793,   458,   785,     0,
     441
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    72,   241,   242,   243,  1491,  2094,   244,
     245,   246,   247,   248,   249,   250,   251,   252,  1520,   253,
     254,  1158,  1648,  2209,   255,  2019,   966,  1924,  2146,  1925,
    1926,  1911,  1381,  1383,   256,  1492,  1512,   258,  1376,  1904,
     259,   260,   261,  1548,  1549,  1525,  1550,  1497,  1717,  3566,
     262,   263,  2169,  1595,  2677,  3090,   802,  1592,  3079,  3080,
     264,  1645,  2730,  2731,  2732,  2733,  2705,  3138,  3139,  3140,
    2734,  3430,  3612,  2735,  2027,  2236,  2742,  2743,  3700,  3763,
    3764,  3765,  3819,  3432,  2741,  3166,  3438,  3600,   265,  2727,
    1662,  2234,  2736,  2737,   266,   267,  1537,  2108,  2600,   268,
     828,  3170,  3445,  3624,   269,   786,   270,  1650,   271,   272,
    1657,  2225,  2226,  3423,  3605,  3706,  3822,  3823,  3593,  3392,
    3393,  3394,   273,   274,   275,   276,  2066,  2201,  2202,  3095,
    1482,  1599,  2171,  2172,  3149,   277,  3343,  3344,   829,  3768,
    3749,   278,   279,  3347,  3348,   280,   281,   282,   283,   284,
     875,  1214,  1215,  1486,   285,   286,   896,   897,   287,  1138,
    2666,   288,   289,   908,  2340,   910,  1757,  2813,  2814,  3227,
    2307,  1072,   290,   291,  2316,  2343,   292,   830,  3175,  3628,
    3629,  3729,  2505,  2987,   293,   831,  1516,  2053,  2054,  2055,
    3176,  2056,  3179,  2057,  2753,  2754,  2755,  3183,   294,  1514,
    2047,   295,   296,   297,  2071,  1088,   298,  3694,   299,  1188,
     300,   928,  1775,   301,  2111,   302,   303,   304,  2756,  3847,
    3858,  3859,  3860,  3458,  3832,   305,  3849,   307,   308,   309,
     789,  1107,  1108,  1109,   310,  3443,   311,   312,  2195,  2196,
    2699,   313,   314,  2020,  2541,   315,   316,   317,  1639,   318,
     319,   320,   321,  1116,   322,   323,   324,   992,   983,  1409,
    1949,   325,  1732,   883,   326,  2333,  1255,   327,  1228,   328,
    3850,  1763,  2318,  2319,  2322,  3851,  1683,   331,  1767,  2327,
    2330,  3852,  1939,  1940,  1941,  1942,  1943,  2492,   333,  1182,
    2248,  3853,  1336,   336,   337,   338,  1883,  2469,   917,  1419,
     953,   997,   998,  1954,  1955,  1426,  1969,  1962,  1964,  3314,
    3533,  1427,  1967,  1428,  1429,  2508,   339,  2473,  2252,  2253,
    2254,  2766,  2776,  3194,  3467,  2255,   980,  2256,  2945,  2261,
    2723,  2724,  2058,  2180,  2688,  1620,  1337,  1621,  2187,  1338,
    1807,  1623,  1339,  1340,  1341,  1626,  1342,  1343,  1344,  1345,
    1790,  1848,  1346,  1347,  1826,  1021,  1724,  2382,  1349,  1350,
    3284,  3513,  3504,  2407,  2408,  1917,  3280,  1351,  2460,  1876,
    1090,  1352,  3097,  1878,  2402,  2366,  2009,  2347,  1788,  2367,
    2380,  2861,  2386,  2391,  2884,  2885,  2403,  2429,  1353,  2351,
    2352,  2843,  1792,  1354,  1112,  1113,  1838,  2425,  1412,  1413,
     985,  1355,  1356,  1357,  1758,   981,  3463,  1195,   653,  2576,
    1573,  1577,   914,  1358,  1359,  1360,  1361,  1362,  1363,  1364,
     900,   901,  2302,  3539,  2667,  3118,  1465,  1927,  1365,   631,
     796,   340,   834,   835,   836,  1174,  1175,  1672,  1675,  1454,
    1999,   632,   633,   843,  3460,   341,   342,   343,   344,  1450,
    1995,  1022,    76,    81,    77,  1023,   381,   382,  1977,   345,
     763,  1978,  1431,  1003,  2995,   347,   348,   349,   350,   351,
     878,   352,  1005,   353,  1006,   354,   355,   356,   357,  1013,
     358,  1433,  1434,  3329,  1435,   359,   360,   655,   656,  1726,
    1226,   881,   361,   362,  1039,  1040,  1041,  1241,  1742,  1242,
    1468,  1469,   363,   649,   364,   365,   366,  1747,  1748,   367,
    1897,  1898,  1899,   368,  2806,  2807,   369,  2965,  2966,  2967,
     370,  1893,   371,   372,   974,  2998,   373,   759,   374,  1053,
     634,   635,   636,  1060,   747,   939,   797,  1061,   748,   749,
     750,   638,   639,   640,   641,   642,   643,  1064,   754,  1743,
      78,  2526,  1744,  1366,  1367,  1889,  1368,   646,  1030,  1218,
    1219,  2527,  1221,    79,  1222
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3376
static const int yypact[] =
{
   -3376,   303, 15102, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, 18549, -3376,
   -3376, 42259,   298, -3376, -3376, -3376, 39524, -3376, -3376, -3376,
   -3376, -3376,   222, 45869, -3376, 57582, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, 61632, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, 43164,   833, -3376,   313, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376,   -84,  4609, -3376, -3376, 49026,
   -3376,   149, -3376, -3376, -3376, -3376, -3376, -3376, 58032, 55782,
   -3376,    29,   789, -3376,    83,  9860, -3376, 40898, 47673, -3376,
   -3376, 62082,   141,    96,  2696,   -84, 17188, 50379, -3376,  1117,
   -3376, 37217, -3376, -3376, -3376,   341, 53082, -3376, -3376, -3376,
   -3376,   449, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   61632,  1961,   422, 37684, -3376, -3376, -3376, -3376, 61632, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, 50830, -3376,
     293,    48, 62532, 62982, 52632, -3376,   805, -3376, 61632,   945,
   41809, -3376, 63432, -3376, -3376,   477, -3376, -3376, -3376, -3376,
   -3376,   422, -3376, 43164, 35362, 53982,   623,   433, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
     446,  7127,   459, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376,   505, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376,  1040, -3376,   404,  1528,   541,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, 71982,  1372, -3376,
   -3376, -3376,   638, -3376,   585, -3376, -3376, -3376,  1384, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376,    19, -3376, -3376, -3376,
   -3376,  1032, 42711, -3376, -3376, 51281, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, 39982, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376,   105, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, 61632, 61632,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376,   722, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376,   206,   923, -3376, -3376, 43164,
    1647,  1647,  1155, 71982, -3376, -3376, -3376, 43615, 61632, 61632,
   61632, 43615, 61632, 53982, 33511, -3376, 61632, 61632, 53982, 53982,
   61632,   876, 61632, 61632, 61632, 53982,  1122, -3376,  1376,   548,
   -3376, -3376, -3376, -3376,   193,   291, -3376, -3376,  5843,  1961,
   -3376, -3376, 55782,  1038, 43615, 61632,   807,  1039, 61632, -3376,
   61632,  1005, 61632,  1266,  2173,  1115, 61632, 61632, 61632, -3376,
   -3376,  1195, 61632, -3376, 61632, -3376, 61632,   781,  1152,  1381,
    1333,    65, -3376, -3376, -3376,  1159,  1106, -3376,  1179, 51281,
   -3376, 49477, -3376, -3376, -3376,  1239, -3376, 53982, -3376, -3376,
   -3376, -3376, 44066, 61632,  1455, -3376, 63882, -3376, 44517, 64332,
   -3376,  1729,  1536, 64782, 65232, -3376, -3376, -3376, 65682,  1324,
   66132, -3376, 66582, -3376,  1451, 67032, -3376, 13807, -3376,  1202,
    1172,  1231, -3376,   505,  1065, -3376,   264,   -31,   622, -3376,
   -3376,    53,    54,   102,  1065,   830, 56232, 61632,  1464, -3376,
   -3376, -3376, -3376, 51281,  1398, -3376, -3376, -3376,  1413,   -90,
   -3376, -3376, 55782, -3376, -3376, -3376, -3376, 55782,  1237, -3376,
   -3376,  1961,    22,  1641, 61632, -3376, 61632, -3376, 55782, 61632,
   -3376, -3376, -3376,  1633,  1304,  1512, -3376,  1300, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376,  1480,  1495,     4,  1961,  1404,
   -3376, -3376,  1527, 21368,  -101, 51281, 38613, 54432, 70632,  1494,
   40898, 67482,  1392,   548,  1509, -3376,   237, -3376,  1745,  1403,
    1614,   -10,   548, 55782, 72432, -3376, -3376, -3376, 30775, 67932,
    1502,  1416, -3376,  1705, 21844, -3376,  1436,  1454,   -84,  1456,
   -3376, -3376, 55782,  1833,  1833,  1837,  1833,   766,  1009,   433,
   -3376, -3376, -3376,  1496, -3376,  1493,  1510, -3376,   367,  1746,
   -3376, -3376, -3376, -3376,  1612,  1616,  1666,  1669, -3376,  1698,
    1306, -3376, -3376, -3376,  1824, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376,  2015,  1983, 40898, 40898,  1718,    14,    94, -3376,
   -3376, -3376,  1906, -3376, -3376,  1905, 61632, -3376,  1759, 61632,
   -3376, -3376, 68382, -3376, -3376,  1647,  1496,   193,  1685,  1274,
   -3376, -3376,  1491,  1670, -3376,  1728,   661,  1717,   913,   145,
    1861,   -59,  3318,  1730,   185,  1112, 61632, 61632, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,  1733, -3376,
   -3376,  1738,   955,   927,   818,   547,  2659,   961,   217,  1926,
     595,  1010,  1885, 61632,  1755,  1982,   -44, -3376,    97, -3376,
   24700, 34454, -3376,   193, 55782, 61632, -3376, 43615,  1770, -3376,
   -3376, -3376, -3376, 43615, -3376,  1962,  2345, -3376, 61632, -3376,
   -3376, -3376, -3376,  1923, 61632, -3376, -3376,  2037, 61632, -3376,
    1850,  1608,  1806,  2172, 48125, 61632,  1860,  2219, -3376, -3376,
    1887, -3376, -3376, 61632, 61632,  1840,   546,  1887,  2232,  2237,
    2041,   501,   678,    64,  1887, 55782, 55782, 55782,  2111, 61632,
   68832, 43615, 61632, 41356, -3376,  1877,  1159, -3376, -3376, -3376,
   -3376, -3376,   554,  1952,  2181,  1685, -3376,  2185,  1895,  2191,
   -3376,  2192,  1730,  2193,  1899, -3376, 69282, 69732,  2204,  1915,
   61632,  2209,  1899,  2210,  2101,  2216, -3376,   626,  2222,  2109,
    2225,  1899,   848,  2231,    47, -3376, 16008, 13807, -3376,  5006,
    1279, -3376, -3376, -3376, -3376, -3376, -3376, 24700,   393,   780,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, 61632,  1464,  1464,
     106, -3376, -3376,   897, -3376, 54882, 61632, 55332,    10,   -19,
   -3376, 61632, -3376,  1172, 48125,  2331, 61632,  2229,  2229,  2229,
   -3376, -3376, -3376,  2179, 61632,  2238, 54882, 61632, -3376, 70182,
    1954,  1281,  1999,  1462, -3376, 24700,  1956,   391,   391,  1958,
    1960, -3376, -3376,  1964,  1978, -3376,  1592,  1592,  2134,  1987,
    1988, -3376,  1659,  1989, -3376,  2034,  1696,  1993,  2001,  2002,
    1430,   391, 24700, -3376,  2004,  1592,  2008,  2011,  2013,  2065,
    2014, -3376,  2097,  2019,  1682,  1873,  2020,  2024, -3376,  1987,
   -3376,   271,  2025,  2028,  2031,  2033,  2040,  2043, -3376, -3376,
   -3376, -3376, 24700, 24700, -3376, 22320, -3376,  1961, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376,    37, -3376,  1769,  9109, -3376,
   -3376,  2215, 24700, -3376, -3376,    56, -3376,   193,  1732, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,   125,  1036,
    1036,   126, 49026, 49026, -3376, -3376,   508,  1996,   854, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, 40440,  2424, -3376,  3232,
      97,  1037,  2385, 35816, 36283,  1464,  1464,  2277, -3376, -3376,
      72,  2291, 55782, -3376, 61632, -3376, 32129, -3376, -3376,   505,
   -3376, 10563, -3376,  1043, -3376, -3376, -3376,  2056, -3376,   446,
     446, 24700,   446,   752, 22796, 24700,  2343,    80,  2347, -3376,
   -3376,  1496,  2073,  1024, -3376, 51732, 71532, 71532,  2313, -3376,
   -3376,   553,   325,  2198,  2279,  1018,  1415, -3376, -3376, -3376,
    2064, -3376,  2409, 49026,  2152, 40898, -3376, -3376,  2530, -3376,
    2530, -3376, -3376, -3376, -3376, -3376, -3376,  2555, -3376,  2087,
   -3376, -3376, 71982,  2096, 61632, -3376,  2098,  2099, -3376, 72432,
     193, 34908,  1135,  2180,  2183, 43164,  2102,  2184,  2189, 70632,
   -3376, -3376, -3376, -3376,   170,   952,   469, -3376,  2190,  2286,
    1306,  2233, -3376,  2196,  2197,  2298,  1306,   663, 71082, -3376,
   -3376, -3376, -3376, -3376,  1875, 19964, -3376, -3376, -3376,  2199,
    2182,  2201,  2207,  1840,   499,  2119, -3376,  2194,  2195, 46321,
   33982,  4164, -3376,  2211,  2212,  2218,  2258,  1223,   320,  2492,
    2315,   866,  1344,   104, 55782,  2393,    87,   804,  2133, -3376,
   -3376,  2224,  2226, 61632, 61632, 61632, 61632, 53982,  2234,  2271,
    2239,  4164, -3376,  2240,  1019, -3376,  1180, -3376, -3376,   548,
   -3376,  3854, -3376, -3376, -3376, -3376, -3376, -3376, -3376,  1685,
   48125,  1730,  1306, 61632, 61632,  2148,   488,   727,  2327, 61632,
    2389,  2334,    28, -3376, -3376,  1887, -3376, 34908,  1840, -3376,
    2155, -3376,  2228,  2228,  2228,  2158,  2158,  2159, -3376, -3376,
    1430,  2228,  2158, -3376, 49929, -3376,   841,  1061, -3376,  2563,
      73, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
      27, -3376,  1337, -3376, -3376, -3376,  2575,   900, -3376, 48125,
    4164,  2502,  2245, 43164, -3376,  2236,  4164, 61632,   146, 61632,
    2402, 61632, 61632, 61632, 61632, -3376, -3376,    52,    -7, -3376,
    4164, -3376,  2574,   -71,  2186, 40898,  2468, 61632,  2365,  1730,
    2579, -3376, -3376,  2202,   830, -3376,  1877, -3376,  1275, -3376,
    2318, -3376, 28017,  2246, 43615,   189, -3376, 48125, 61632, 43615,
     189, 61632, 61632,  2488,  2261,  2491,  2264, 33982, 46321,    77,
   61632, 61632, 55782, 61632, -3376, -3376, -3376, -3376, 61632, 55782,
   61632,  2493,   189, 61632, -3376, -3376, 61632, -3376, -3376, 16485,
    1411, -3376, -3376, 13807, 10563,  1047, -3376,  1464,   722,     6,
   61632, 51281, -3376, -3376, -3376, -3376, -3376, -3376, -3376,  1464,
   -3376, -3376,  2667,  2200, -3376,   125,   830,  2205, -3376,  2221,
   61632, 43615, 61632, 61632, 55782, 55782, 61632,  2289,  1996,  -140,
   -3376,  2270, 31679,  2348, -3376,    98, 55782,  2403, -3376, -3376,
   -3376,  1075,   555,   580, -3376, -3376, -3376, -3376, -3376, -3376,
   53082,  2494,   -12, 61632, -3376, 24700, 23272, -3376, -3376, -3376,
    2227, 10563,  2274, 24700, -3376, -3376, 24700, 24700,   830,   830,
   24700, -3376, -3376, -3376, -3376,  2054,   830, -3376, 24700, 24700,
     830,   830,  2228,  2228, -3376,  6937, 24700, -3376, 33982, 24700,
   26128, 19487, 24700,  2304,  2316,   830, -3376,   830, -3376, 24700,
   20892, -3376, 24700,  2440, 24700,  1037,  2441, 24700,   193,  2643,
    2643,   433,    20,  5426,  2230, -3376,  2356,   830, -3376,   830,
     681, 48125, 24700, 43164,  2328,   127, 24700,  2242,  1368, -3376,
   24700,   166, -3376,  2247, 24700,  2329,   117, 24700, 24700, 24700,
   24700, 24700, 24700, 24700, 24700, 24700, -3376, 26604,   157,   -86,
    1012, 45418, 21368,  2526, -3376,  1102, 19010, -3376, 51281, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376,   830,  2250, -3376,  2267,
   -3376, -3376, -3376, -3376, -3376,  2424, -3376, -3376,  2339, -3376,
   -3376, -3376,  1834, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376,  2252, -3376, -3376, -3376, -3376, -3376,
    2252, -3376, -3376,  1464, -3376, 71982,  2260, -3376, 61632,    41,
   -3376, -3376, -3376,  2278, -3376, 53532, -3376, 21844, 61632, -3376,
   -3376,  2507, -3376, -3376,  2263, -3376,  8072,  2507,  2449,  2456,
    2456, -3376,   -68, 10563,  2500, 10563, -3376, -3376, -3376, -3376,
     -96, -3376,  1060, -3376, -3376,  1496,  2280, 17641, -3376, 18095,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376,  1306,  2275,  2722, -3376, 40898, -3376,
   -3376, 51281,  1439,  2280, 13807, -3376, 13807,  2280,  2281,  1089,
    2363,  2364,  2410, 61632, 61632, -3376, 43164, 61632, 61632, -3376,
    2634,  2287, 61632,  2521,  2523,  2292, -3376, -3376, 61632, -3376,
    2479, 24700,  2482, 61632, 61632,  2485, -3376,   695, 61632, 61632,
    2477, -3376, -3376, -3376, 61632, -3376, -3376, -3376,  2473, -3376,
   -3376, 49929, -3376,  1104, -3376, 48576, 44968, -3376, -3376,   283,
   61632, 61632, 61632, 61632, -3376, 61632, -3376,  1028, 61632, 61632,
    2295,  2302,  2299, -3376, 61632,  2532, -3376, -3376,  2469,   515,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376,   669, 61632, -3376,
     830,  2474, 61632,  2378, -3376, 61632, 61632, 61632, 61632,  1306,
   -3376,  2686,  1306,  1306,   506,  2688,  1887,  1887, -3376, -3376,
   -3376, 61632, 61632, 61632, 61632, 56682, 61632, 61632,   917,   926,
   61632, 57132, -3376, 55782, 61632, 61632, 61632,   128,  3427, 61632,
   61632,   265,   699,  2457,  2460,  2463, 61632, 61632, 61632, -3376,
   61632,  2407,  2412,    49,  2476, -3376, -3376, -3376, -3376, 24700,
    2566,  2720,  2570,  2581,  2399,  2408, 46321,   461, 61632, 61632,
   61632, 61632, 61632, 61632,  2584,   461, -3376, -3376, -3376,  1608,
   -3376,  1121, -3376,  2359, -3376, 24700,    76, 48125,  2350, 29839,
   -3376,  2432, -3376,  2434,   830, -3376,  1469, -3376,    52,  2578,
    2371,  2371,  2371,  2371,  2371,   900, -3376, -3376, -3376,  2642,
   61632,  1125, -3376,  2373, 55782, -3376, -3376,  1303, 53082, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376,  1946,  1840,  1840,
    1840,  1840, -3376, -3376, -3376,  2540,  2538,  2366, 61632, -3376,
    1223,  2658, 55782, 52182,  1373, 61632,  2757,  2639,  1961,  2552,
   55782,  2796, -3376, 41356, -3376,  2384,  2656,  2661,  2682, -3376,
   27556, 58482,  2396,  1433, -3376, 58482, 58932, -3376,   193,  2400,
   23748,  2348,  1685, -3376,  2794, -3376,  1730, -3376,  1899, -3376,
   61632, 61632, 61632, 61632,  2414,  2411, -3376,  1899,  2586,   189,
   -3376,  2587,   189,  1899,  1961, -3376,    47, -3376, -3376, -3376,
   -3376, -3376, 24700, -3376, -3376,  2508, -3376, -3376, 51281,  1179,
   -3376, -3376,  1179, -3376,  1179,  2879,  1899,  2416, -3376,  1899,
    1899,  1996,  1996,  1899, 59382,  2817,  2689, -3376,  1129, -3376,
   -3376, 21368, -3376,    55, -3376,   223,   270,  2629, -3376, -3376,
   -3376, -3376, 48125, -3376, -3376, -3376, -3376, -3376, 61632,  2599,
    2422, 59382,  2804,   189, -3376,  1158,  1025,  1035, -3376, 24700,
   24700,    50, -3376,  9418,  1189,  9569,  1229,  2431,  2433,  1241,
   -3376, -3376, -3376, -3376, -3376, -3376,  2438,  2719, -3376, -3376,
    2442,  1252,  1282,  2446,  2448, -3376, -3376,  3125,  2450,  9837,
    2455, 26128,   241, -3376, -3376, 26128,  2458, -3376,  1287,  8778,
    2443,  2459,  2495,  2496,  2462,  2464,  9726, 24224, 24700, 24224,
   24224, 10061,  2443,  2465,  1299, 43164, 10339,  1308, -3376, 24700,
   43164,  4391, -3376, -3376, 24700, 61632,  2467,  2470, -3376, -3376,
    6937, -3376,  2498, -3376, 26128, 26128,  5083, 22320, -3376, -3376,
    2735, -3376, -3376,  1170, -3376,  2472, -3376, -3376,  5708,   131,
   24700,  2242, 24700,  2553, 33982,  4481, 24700,  3736,  3946,  3946,
     144,   144,    89,    89,    89,  1305,  1012, -3376, -3376, -3376,
    2475,  2014, 24700, -3376,  1582,  1601, 55782, 10699, 11001, -3376,
   -3376, -3376, 28017,  2520, 24700, 24700,  2478, -3376,  1321, -3376,
   -3376,  2074,  2879,   830,   548,   830,   681, 36750, -3376,  2280,
   -3376, -3376,  1328, 32129,  2246, 21844,   193, -3376, -3376, -3376,
    1335, 24700, -3376, -3376,  1974,  1173, -3376, 61632,  2403,  2403,
   24700, 24700, 22796, -3376, -3376,  2483, -3376, -3376, -3376, -3376,
   -3376,  2484, -3376, -3376, -3376,  2922,  2480,  2471,  2489,  2497,
   -3376, -3376, 61632, 61632, 61632, -3376, -3376, -3376, -3376, -3376,
    2702, -3376, 24700,   130,  2486,  2499, 61632,   189, -3376, 10563,
   -3376, -3376, -3376,  2729, -3376, -3376, -3376, -3376,  2673, -3376,
   -3376,  1337, -3376, 44968, 48576, -3376, 48576, -3376,  1337,  1097,
   -3376,  1899, -3376, -3376, -3376, -3376,  1058, -3376,   571, 48125,
    2662, 46772,  1899,  1065,  1946, 61632, 61632, -3376, -3376,  1899,
   -3376,  1946,  1899,  1946, -3376, -3376, -3376, -3376, -3376, -3376,
    1306, -3376, -3376, -3376, -3376, -3376, 61632,  1306,  1306, -3376,
   48125,   591, -3376, -3376, -3376, -3376, -3376,   189,   189, 61632,
   61632, 61632, 61632, -3376, -3376, -3376, -3376, -3376, -3376,  2577,
   -3376, -3376, -3376,  -116, -3376, -3376, -3376,  2714,  2718,  2721,
    2593,  2595,  2597,  2598, -3376,  2601,  2602,  2605, -3376, -3376,
   -3376, -3376, 61632, 61632, -3376, -3376, -3376,  7702,   461, 48125,
     461,   461, 61632, 61632,  2515, -3376, -3376, -3376,  2742,  2763,
    2765,  2766,  2768,  2770,   461, -3376,    58,  1431, -3376,  1239,
   33040,  5861,  2539, -3376,  2535,   830,  2280, 30314,  2090, -3376,
   -3376, -3376,   665,  2748,  2541, -3376,  2717,  2371, -3376,   728,
     796, 59832, 60282, 60732, -3376,  1506,  2615, -3376, -3376, 43164,
   33040,  2186,   146,  2694,   874, -3376, -3376, -3376, -3376, -3376,
   55782,    52,  1961,  1345, -3376, 48125, 51281,   446,  2546, 55782,
    2547,  2548, -3376, -3376, -3376, -3376,  1350, -3376, 48125,   -56,
    2736,  2737,  1389, -3376, -3376,   446, 61632,  2644, 55782,  2624,
    1961, 40898, 47223,  2791, -3376, -3376,  2744, -3376, 61632, -3376,
   -3376, 31225, 29389,  1433,  2567, 61632, -3376,  2564, 28017,  2803,
    2741, -3376, 28017,  2741,   968,  2741,  2808, -3376, 32579, -3376,
    2573,  1312, 19010,  2758, 10563, -3376,   189, 48125,   189,  2638,
     189,  2640,   189, 46321,   189, 55782, -3376, 55782, -3376,   189,
   -3376, 10563, 55782,   642, -3376, -3376,  2571, -3376,  2592, -3376,
   -3376, 43615, 61632,   -98, -3376, -3376,  2755, -3376,   446, 61632,
     193,  2580, -3376, -3376, -3376, -3376,  2876,  2877, -3376, -3376,
   -3376, 54882,    88, 61632, -3376, -3376, -3376, -3376,  2588,  1391,
   10477, 24700, -3376,  2883, 48125, -3376, 61632, -3376, -3376, -3376,
   -3376, -3376, 24700, -3376, -3376, -3376, -3376, -3376, 24700, -3376,
   24700,  2863, -3376,  2996, 48125, 26128,   974,  2008, 27080, 26128,
   26128, 26128, 26128, 26128, 26128, 26128, 26128, 26128, -3376,   308,
   -3376, -3376, 24700, 24700,  2878,  2863, -3376, -3376, -3376,  1402,
    1402, 48125,  2596,  2443,  2600,  2606, 24700, -3376, -3376,  1407,
   43164, -3376, 24700,  8605,  1412,  2651,   193,  6273, -3376,  2963,
    1961, 24700,  1799,  1876, 24700,  1426, 24700,  2880, -3376, -3376,
   -3376,  2603, -3376, -3376, 48125, 24700, 26128, 26128,  7509, -3376,
    7539, 24700,  2607,  8133, 22320, -3376,   422,   422,   422,   422,
   -3376, 55782, 55782,  2396, 24700,  2869,  1446,  1459, -3376,  1946,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376,  2604, -3376,  2613, -3376, -3376,
      97,  2609, -3376, -3376,  2922,  2619, 61632, -3376,  2348, -3376,
   -3376, -3376,  2612, -3376,  1173, -3376, -3376, -3376,  1899, -3376,
   -3376, -3376, -3376, -3376,  2630,  2626, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376,  2371,  6381, -3376, 61632, 61632,
    1497, -3376, -3376,  2864,  1263, -3376, -3376, -3376,  2692,  2703,
    2704,   427,   100,  2706,  2712, -3376,  2713, -3376, -3376, -3376,
   -3376,  1899,  1899, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
     124,   783, 48125, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   61632,  2902,   456,  1250, 61632, 61632, 61632, 61632, 61632, 61632,
   61632, -3376, -3376, -3376, -3376,  2631, -3376, -3376,  2872,  2873,
    2874,   461,   461,   461,   461,   461,   461, -3376, -3376,  1887,
    2951, -3376, -3376,  2219,  2219,   709, -3376,  2219, -3376,  2219,
   -3376, -3376,  2359,  2612,  1415, -3376, -3376, -3376, -3376, -3376,
     806,   830,  1414,  2641, -3376,  1543, 30314, 30314, 30314, 30314,
   30314,  2280,   681, 55782,   830, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,  2637, 61632,
   26128, -3376,   644,   103, -3376,  2881, 55782,  2687, -3376, -3376,
   -3376, 48125, -3376, -3376,  3033,     6, 55782,  2927,  2819,  1501,
   -3376, -3376, 61632, -3376,  1231, -3376, 52182, -3376,  2900, 52182,
   -3376, 61632, -3376, -3376, -3376,  3002,  2745, -3376, 61632,  1630,
    2711,  1717,  1961,  2624, 61632,  2655, -3376,  2649, -3376,  3188,
   -3376,  1840, -3376, -3376,    46,  2677, -3376, -3376, 58482,  2664,
   61632,  1433, 28017, -3376, -3376,  1230, -3376, 28017,  2895, -3376,
   28017, 61632,  2665, 61632,  1508, 39064, -3376,  2660, -3376, 61632,
   -3376, 61632, -3376,  2668, -3376,   189,   189, -3376,  3056,  2671,
    1275,  1179,  2074, -3376, -3376,  2945, 59382, -3376, -3376, -3376,
   -3376, -3376, -3376,  2952, -3376, -3376, -3376, -3376, 24700, 10563,
   -3376,  2672,  2676, 10563,  6591, 10563,  2878, -3376,   575,  2956,
   -3376,   995,  2679,   308,   575,   586,   586,   164,   164,    92,
      92,    92,  2996, 10563, 10563, -3376, -3376, -3376, -3376,  2681,
   -3376, -3376, -3376,  2443, -3376, 25176, -3376, -3376,  2730,  2733,
    2684, -3376, 24700, 25652,  2680, -3376, -3376,   681,  2643, 26128,
   26128,   205, -3376,   267, 24700, 48125,  1547,   205,  1888,  2003,
   24700, 24700,  8164,   160, 24700,  6877, 55782, 55782, 55782, 55782,
   -3376, -3376, 10563,  3060,  2961, -3376, -3376, -3376,  2074,  1921,
    1961, -3376,   433, -3376, -3376, 33982, -3376, -3376, 13807, -3376,
     830, -3376,  1549,  1557,  2687, -3376,  2762, -3376, 61632, 61632,
     830,   830, 48125,  2691, -3376,   830,   830,  2693, -3376, 61632,
   61632, 61632,  1506,  2882,  2889,   830, 61632,  2759, -3376, 61632,
   61632, 61632, 61632,  2994, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376,  2943,   461,   461,   461, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376,  1961,  1961,  1946,  2894, 61632,  1961,  1946, -3376,
     930,  3027, -3376,  2965,   118,  2710,  2991,  2992, -3376, -3376,
    1864,  1864, -3376, -3376, -3376, -3376, -3376,  2998, -3376, 24700,
     163,   575, -3376, -3376, -3376, -3376,  2687,  2186,  2782,  2785,
     446,   -47,  3026,  3017,    52, -3376,  1961, -3376, -3376,  2725,
    1163,  2727,  1373, -3376, -3376, -3376,   610, 61632, -3376, -3376,
    3092,  3093,  2906, -3376, 61632,  2967,  2102,  3012,  2746, -3376,
   28478,  1961,  2791, -3376, -3376, -3376, -3376, -3376,  2818, 61632,
   -3376, -3376, 61632,  1569, -3376, 24700,  2747, -3376, -3376, 28017,
    1230,  1570, 61632,  1571, 48125, -3376, -3376, -3376,   189,   189,
     189,   189, -3376, -3376,  2658, 61632,  3019, -3376, -3376,  2912,
   -3376, 59382, 10563, -3376, -3376, -3376, -3376, 26128,  3022, -3376,
    2750, 26128, -3376,  2756,  1581,  1596, -3376, -3376, -3376,  7053,
    2815, 10563,  2865,  2760, -3376,   218,   218,   267,  1597, -3376,
   26128, 26128,   205,   205, 24700,   205, -3376, -3376, -3376, -3376,
   -3376, 24700, 24700, -3376, -3376,  1415, -3376, -3376, -3376, -3376,
     681, -3376,  2761, -3376, -3376,  2904,  2687,  2782, -3376, -3376,
   -3376, 28939, 33982, -3376,   427,  2769,  2771,   100, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, 24700, -3376,   363,   -80,  2809,
    1899,  3046,   461, -3376, -3376, -3376,  1431, -3376, -3376, -3376,
   61632,  2767, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   43615,  3155, 55782,   806,  7401,  2960, -3376,  2782,  2983,  3029,
   -3376, 61632,  1630, 52182, -3376,   -40,  2929, -3376, -3376,  1373,
     846,   957, -3376, 55782,  2737,  2903, -3376,  2910, -3376,  2958,
    2959, -3376, -3376,  1961, -3376, 61632, 28478, 24700,  1623, -3376,
   61182, 20414, -3376, -3376, 55782, -3376,  1638, -3376, 10563, 61632,
   -3376, -3376, -3376,  1655, -3376, -3376, -3376, -3376, -3376,   446,
   -3376,    88,   366, 26128, 26128,   519, 24700, -3376, 24700, -3376,
   -3376, -3376,   -11, -3376, -3376,   218,   218,   205,  2443, 10563,
   -3376, -3376, -3376, -3376, 55782,  2782, -3376, 48125,  1730,   352,
   -3376, 48125, 48125, -3376, 10563, 61632, 61632, 61632, 61632, 61632,
   -3376,  2767,  3155,  3174, -3376, -3376,  3072, -3376, -3376,   462,
    2970,  2887,  3084, -3376, -3376, -3376, -3376, 61632,  2737, -3376,
   -3376, -3376, -3376, -3376, -3376,  1673,  2745, -3376, -3376, -3376,
   -3376, -3376, -3376,  1691,  7478,  2687, 28478, 61632, -3376,   190,
     190,  2520, -3376,  1692, -3376, -3376,   366,   892, -3376,  1752,
    1778,  2884, -3376,  2186, -3376,  1798, -3376, -3376, 46321, -3376,
    1807,  1812,  2797,  2852,  2797, -3376,  1899, -3376, -3376,  3113,
   -3376, -3376,   113, -3376,  2997,  3000, 61632, 61632,  3203,  2814,
    2745, -3376, -3376,  2687, 61182,  2745, -3376, -3376,  1173,  1173,
    3127, -3376, -3376, -3376, -3376, -3376,  2983, 43615,  2824, -3376,
   -3376, 61632,  2949,   746,   746,  2892, -3376,  3147, -3376, -3376,
   -3376,   427, 38152, -3376,  2745,   190,  2520, -3376, -3376,   176,
    2970,  1730,  2979, -3376,  3126, -3376,  3240, -3376,   109, -3376,
   -3376,  2691,  1830, -3376,  1784, -3376,  1165,  2520,  1173, -3376,
   -3376, -3376,   720,   806, -3376, -3376,  2993, -3376, -3376, -3376,
   -3376, 38152, 24700, -3376, -3376, -3376,  1023, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, 43615, -3376,  1835,  1478, -3376,
   -3376,  1635,  1454,  2839,  1946, -3376,  1023, 38152, -3376,  1844,
   -3376
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3376, -3376, -3376, -3376, -3376,  3079, -3376, -1054,  -327, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376,  1116, -3376, -3376,  -110,  1020,  1930, -3376,   840,
   -3376, -3376, -3376, -1321, -3376,   619,   368, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376,  1200, -3376,  -986,   718,  -247, -3376,
   -3376, -3376, -3376,  1161,   -50, -3376, -3376, -3376, -3376, -3376,
   -1569,  -133,   178, -3376,   173,  1224,   297, -3376,   -73, -3376,
   -3376, -3376, -3376,  -374,   795, -2614, -2456,   172,  -443,  -465,
    -418,  -415,  -442, -3376, -2781, -3358, -2314, -2810, -3376, -3376,
     552, -3376, -3376,   195, -1567, -3376,  1697, -3376, -3376, -3376,
   -3376,   -85, -3376, -3376, -3376,   -53, -3376, -3376, -3376, -1565,
   -3376,  1175, -2626, -3376, -3376, -3376,  -507,  -477, -3376, -3375,
     -29,   -25, -3376, -3376, -3376, -3376, -1121, -3376,   660,   664,
   -1064, -3376, -3376,   694, -3376, -3376,  -426,  -178,  1736, -3376,
    -429, -3376, -3376, -3376,  -173, -3376, -3376, -3376, -3376, -3376,
   -3376, -1695,  -754, -1546, -3376, -3376,  3204,   407, -3376, -3376,
   -2091, -1561, -3376,  -179,   970,  2141, -1216, -2261,   165, -3376,
   -3376, -1716, -3376, -3376, -3376,  1073, -1560, -3376,   219,  -233,
    -331, -3357, -2423, -2873, -3376, -3376, -1189, -3376,   834,  1340,
   -3376,  1343, -3376, -1921,   224,  -942, -2633, -3004, -3376, -3376,
   -3376, -3376, -3376, -3376, -1689, -1519, -3376,  -291, -3376, -3376,
   -3376, -3376,   762, -3376,   -45, -3376, -3376, -3376, -3376, -3376,
   -3376,  -430,  -460, -3376, -3376, -3376,   627, -3376, -3376, -3376,
    1353, -1088,  -931,  2436, -1557,  -193, -3376, -3376, -3376,  1215,
   -2034, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -1086, -3376,
   -3376, -3376, -3376, -3376, -3376,  1468,  3255,  -781, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376,  2187,   263, -3376,
     -54, -3376, -3376,   601, -2167,   -52, -3376, -3376, -3376, -3376,
    -339,   -42, -3376,   929, -3376, -3376, -1863, -3376,  2203,  1127,
     207,   -72,   -21,  -239,   434,   835, -3376, -3376,  -206,  1157,
   -3376, -3376, -3376, -3376,   924,  2006, -3376,   916,  -324, -3376,
   -3376,  2010, -3376, -3376,  2009,  1470, -3376,  1499,   962, -2173,
    1190, -2157,   668,  -557,   -27,  -112,  2610, -3376, -2838,   950,
   -2968,   287,   680, -1864, -2494, -1474, -3376, -3376, -1247,  2924,
   -3376, -3376, -3376,  3094,  4295, -3376, -3376,  6147,  6169, -3376,
   -1111,   536,  7661,  2843, -1239, -1599, 12798,  1140,   606, -1600,
   -3376, -3376, -3376,  -210,   545,  1615, -3376,   890, -3376,  -752,
   -3376, 13506,   947, -3376, -1199, -3376, -1252, -3376, -1701, -3376,
   -3376, -3376, -3376, -3376, -1482, -2721,  -810,  1011, -3376, -3376,
    1103, -3376, -3376, -3376, -1067,  -989, -1802,  1014, -1825, -3376,
    -995,  1137,  1577,  7673,  -909,  1797,   -51,  8632,  -134, -1963,
   -1367, -1041, -3376,  -597, -3376, 11000,    25, -3376, -3376,    -2,
    1178,  -843, -1823, -3376,   -32, -3376,  -976, -1001, -2512,  -130,
   -3376, -3376,  2866,   703, -3376,  2290, -3376,  1219,  1787, -3376,
   -3376,  1471,  -884,   -22, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,  2035,   101,
   -3376,   -48, -3376, -3376, -3376, -3376, -3376,  3120,  -294, -3376,
    2608,  -287, -3376, -3376, -3376, -3376, -3376, -3376, -3376, -3376,
   -3376,  2055,  1514, -3376,  2429, -3376, -3376, -3376,   -36, -3376,
    2243,  -143, -3376, -3376, -3376, -1124,  1206,  2454,  -897,  -857,
    1498, -3376, -3376, -3376, -3376, -3376, -3376, -3376,  1191, -3376,
   -3376,  1015,  1188, -3376, -3376,   277, -3376, -3376,   183,   280,
   -3376,  2135, -3376, -3376, -3376,   529, -3376, -3376, -3376,  -570,
    9751,   132,  -107,   -97,   153, -3376,  3099,  9140,  -736,   -15,
    2072,  6244, 12141,   -95,  -104,   -57,   114,   247, -1607, -3376,
    3128,  1507,  1217,  -946, 10257,  1772,  5140,    -9,  -772, -1095,
    2303,  -706, -1702, -3376,  3512
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1995
static const short yytable[] =
{
      75,   987,  1771,  1690,  1430,   844,   334,   745,  1249,  2275,
     753,  2073,   827,   832,  1066,   973,  1069,   746,  2286,   752,
    1570,  2290,  1089,  1045,   329,   946,   330,    74,  1725,  1100,
     346,  2185,  1390,   384,  1644,  2308,   332,  1466,  1531,  1801,
    1802,  1230,  1659,  1232,  1449,  1234,  1575,  1561,  1377,   745,
    1781,  1235,   753,  1000,   630,   922,  1147,   335,  1817,   746,
    1001,   752,  1155,   376,  1400,  1907,   376,  1178,  1480,   379,
    1163,   654,   379,  2481,  2675,  2491,  1828,  2763,  1598,  2210,
    2832,  2211,  2257,  2212,   629,  2348,  2186,  2213,  2214,  1526,
    3010,  2215,  1470,   787,  2785,  3148,  1640,  3144,  2777,  2779,
     965,   874,  1229,  1646,  1727,   379,  2578,   654,   941,  1199,
    1660,  3326,  2515,   979,  1398,   941,   745,   941,  2015,   753,
    3182,  1685,  2499,   803,  1721,   837,   746,  1033,   752,  1668,
    1513,  1243,  1463,  3418,  2565,  2567,  1844,  1895,   838,  2525,
    2176,  1467,  2496,  2529,  1463,   833,   942,   379,  1888,   915,
    1456,  1457,  1846,   942,  1658,   942,  1714,  2700,  2701,  2702,
    2703,  1851,  2178,  3265,  2864,  2682,  1794,  1795,  1761,   334,
    1058,  1220,  1014,  2323,  1073,  2227,  2654,   848,  2274,   629,
    2181,  1714,   383,  1371,  1854,   801,  1714,   329,  2118,   330,
    1814,  1054,   377,  3105,   944,   377,  2342,  1714, -1329,   332,
     924,   944,  1765,   944,  -977, -1329,  1267,  1142, -1874,  3454,
     375,  2109,   811,   375,   379,  2222,  1851,  -977,  3696,   986,
     335,  2423,  1494,  -313,  1253,  2423,  2232,  2841,   377,  1240,
    2167,  2510,  1042,  3471,  1015,  3473,  2864,  2707,  2457,  1854,
    2822, -1345,  1015,  2472,  3162,  2458,   375,  2021, -1345,  2631,
    2232,  2418,   647,  1460, -1425,  1185,  3716,  -977,  3830,  1567,
    3686,  1192,  1517,  3414,   813,  2461,  2439,  3838,  3741,  1171,
     377,  1959,   925,  2065,  3730,  -977,  3793,  1851,  3389,  3455,
    3128,  2502,  2029,  2324,  2207,  2223,  1016,  2021,   375,  1017,
    2864,  2315, -1901, -1917,  1016,  1881,  1369,  2182,  1714,  2378,
    1854,  2022,  1570,     3,  3345,  1855,   788,  1246,  2790,   879,
    2792,  3704,  2683,  2864,   385,   764,  2127,   943,  1960,  -977,
    1495,  3130,  1527,  1528,   943,   378,   943,  -977,   378,  2023,
    3547,   798,   376,  3225,  1027,  1424,  3705,   377,   379,  1851,
    1105, -1943,  2637,   847,  2237,  1231,  1553,  1692,  2638,   765,
    3770,  3687,   760,  2208,   761,   375,  2503,   903,  1801,  1802,
    1518,   378,  1854,  1029,  1643,  1817,  1370,   376,  1885,  2023,
     209,  1728, -1115,   379,  1585,  1574,   975,  1018,  1828,  1425,
    2864,  1740,  1741,  2440,  1554,  1018, -1143,  2441,  1913,  3226,
    1568,  1715,  2152,  1438,  2462,  3415,   819,  1247,   820,  1641,
    1642,  3839,  2064,   378,  3346,  3391,  3456,  1692,  2824,  2233,
    3831,  3353,  3597,  1575,   849,  1666,  1715,  3805,  1172,  2511,
    2442,  1715,  2823,  1485,  1643,  2168,  1857,  1106,  2632,  -977,
    1458,   227,  1715,  3603,  3742,   926,   927,  2021,  2864,  1392,
    2639,  1043,  1694,  1696,  2109,  2119,  1858,  1859,  3633,  2325,
    3595,  2022, -1874,   648,  2024,  3134,  2655,  2120,  3854,  2866,
    3457,   377,  2865,  1019,   832,  2326,  2224,  2664,  1766,  1056,
     378,  2183,  1264,  2228,  3078,  1692,  1001,  2174,  2350,   375,
    2241,  2147,  2866,  1026,  2124,  1478,   850,  3135,   851, -1329,
    1762,  1247,  1794,  1795,  2024,  1862,   377,  3136,  1884,  1020,
    1814,  1414,  1254, -1818,  3643,  2121, -1148,  2184, -1995,  1863,
    1496,  1720,  2424,  2569,   375,  2150,  2926,  1847,  2820,  2023,
    1579,  1034,  2867,  1519,  2036,  3496,  1581,  3794,  2493,  2459,
    2041,  1555, -1345,  1715,  1716,  2443, -1901, -1917,  1931,  1932,
    2025,  2170,  3675,  1882,  1643,  2867,  1896,    49,   764,  2866,
     628,  2179,  3332,  3333,  2179,    52,    53,    54,    55,  1766,
      56,  1467,   628,   240,  1692,  1875,  1446,  3064,  2877,  3066,
    3067,  2000,  2046,  3137,  1669,  3226,   837,  2176,  2640,  1035,
    2025,   628,   765,  3077,  1569, -1943,  2345,  2346,   993,   838,
    2825,  2864,  1985,  1114,   378,  3191,   833,  2354,  2356,  3195,
     762,  2359,  1439,  2641,  2294,   923,  2153, -1995,  1556,  2371,
    2372,  2906,  3400,  3401,  3402,  3403,  3404,  1872,  1873,  1874,
    1875,  2826,  2388,  2390,  1721,  2974,  2239,  2031,  1945,   378,
    1651,  3340,  1240,  2404,  1393,  1068,  1070,  2874,  2875,  2876,
    2877,   994,  1074,  3016,  2024,  3017,  1092,  2864,  3021,  2537,
    2257,  3614,   745,  3360,  1101,   753,  1677,  2603,  2864,  1866,
    2969,  1075,   746,  3114,   752,  3760,  1094,  1096,  1652,  1902,
    2979,  1110,  2868,  1102,  1146,  1111,  1870,  1871,  1872,  1873,
    1874,  1875,  1150,  1986,  2827,  3747,  1157,  2478,   912,  2872,
    2873,  2874,  2875,  2876,  2877,  2868,  1164,   257,  1180,  3068,
    3069,  2375,  2376,  1233,  1678,   306,  1981,  1115,  2869,  2870,
    2871,   995,  2872,  2873,  2874,  2875,  2876,  2877,   152,  1264,
     628,  3775,  1190,  1394, -1143,  2585,  1903, -1143,    55,  2157,
    2025,  3341, -1143, -1143, -1143,   979,   895,  3676,  1870,  1871,
    1872,  1873,  1874,  1875,  1677,  1137,  3022, -1818,   376,  1574,
     379, -1143,   811,  2665,   379,  1704,  2032,  1655,  1065,  3096,
    2866, -1115,  1065,  1800, -1115,  1485,  3040,  1139,  1982,  3804,
   -1115,  2412,  2604,  3615,  2605,  1168,  1656,  3761,  1089,  2872,
    2873,  2874,  2875,  2876,  2877,  3616,  1679,  3698,   171,  3096,
    2158,  1105,  3220,  1705,  3685,  1065,  3361,   629,  3607,  2131,
    2132,  2133,  2134,  3598,   813,  3412,   209,  3342,  1194,  1038,
     916,  3324,  1202,   996,  1789,  1653,  2866,  1029,  1575,  3182,
    1983,  1211,  3104,  2867,  2033,  2042,   982,  2866,  3708,  2154,
    2155,  3180,  3748,  1680,  2181,  2164,  1181,  2872,  2873,  2874,
    2875,  2876,  2877,  1065, -1148,  2311,  2312, -1148,  1379,  1065,
    1692,  1388, -1148, -1148, -1148,  3815,  2159,  2554,  1225,   755,
     257, -1876,  3413,   941,  2586,  3744,   941,   227,   306,   756,
    2293, -1148,  2257,   377,  1679,    75,   972,   377,  1106,  2867,
    1982,  1029,  2297,   152,  3023, -1068,  3115,  2972,  2065,  1252,
    2867,   375,  1654,  3780,  2160,   375,  1015,  2218,  2219,  2220,
    2221,   942,    74,  2043,   942,  3807,  3808,  2203,  1558,  3024,
    1681,  1984, -1068,   984,    49,   209,  1268,   628,  1729,   629,
    1374,  1680,    52,    53,    54,  2932,   240,  1382,  1384,   991,
    3581,  3617,  1983,  1029,   654,  2555,   819,  1730,   820,  2695,
    1706,  2031,   990,   152,  1065,  1089,   629,   757,  1016,   944,
    1386,  2182,   944,   171,  3120,  3844,  3041,   629,   629,  1401,
    1559,  2587,  2287,  1423,  2864,   379,  3389,  1731,  3829,   225,
    1905,  3330,  -322,  2868,  1483,  1065,   227,  2338,  3709,  1643,
    3375,  3376,  3377,  3378,  3379,  3380,  2869,  2870,  2871,  3843,
    2872,  2873,  2874,  2875,  2876,  2877,  3385,  3042,  1681,  1484,
    3738,  1466,   630,   630,   745,  3710,   378,   753,  3845,   188,
     378,  2644,  2642,   171,   746,  3014,   752,  1707,  2519,  3464,
    1407,  1424,  2569,  1984,  3468,  3816,   951,  3470,   999,  2868,
    2189,  3461,   629,   629,  3390,   240,  1464,  2643,  3386,  1018,
    2868,  2161,  2869,  2870,  2871,  1448,  2872,  2873,  2874,  2875,
    2876,  2877,  2607,  2608, -1995, -1995,  1470,  2872,  2873,  2874,
    2875,  2876,  2877,  1448,  1711,  1425,  1089,  1692,   758, -1569,
    3354,  3711,   943,  3099,     8,   943,  2488,  2788,   628,  2190,
     209,  2575,  1958,  2028,  1851,  2259,    55,  2262,   377,  3712,
    3817,  3584,  2266,  3391,   895,  3223,   987,  2716,  2717,  2718,
    2719,  1065,   379,  3099,  3213, -1876,   375,  1854,  1065,  1596,
    2029,  3818,   799,  3323,  1065,   952,  3713,  2421,  2162,  1959,
    2026,  1004,    49,  2598,  3691,  2183,  2601,  2602,   948,  3786,
      52,    53,    54,  2866,   225,  1635,   909,  3236,  1038,   629,
     209,   227,  1165,  2210,  3249,  2211,  3250,  2212,  3585,  1699,
    2839,  2213,  2214,  1934,  1073,  2215,  1535,  1738,  1044,  2126,
    3355,  2191,  1065,  3356,  2110,  3498,  1960,  3499,  2257,  1166,
    1915,  2770,  2257,  1055,   947,  1734,  1764,  1735,  2003,  1643,
    1712,    49,  3714,  1536,   628,  1001,   152,  1736,   764,    52,
      53,    54,    55,  2065,   225,  1759,  2867,  2771,  2786,  2893,
    3846,   227,   127,   128,   764,  1773, -1002,  1167,   335,  1916,
     629,  3449,  3197,  2192,    75,    75,  1782,    75,  1065,  2114,
    2773,   378,   765,   937,  -977,   377,  1487,   335,  2915,  2523,
    3651,  1225,   971,  1098,  2139,  1165,  2127,  -977,   765,  2030,
    1533,    74,    74,   375,    74,  1635,  3479,  3405,  3480,    49,
    1787,  1488,   628,  1858,  1859,   203,   171,    52,    53,    54,
     240,  3251,  3146,  1844, -1002,  1534,  1065,  2115,  1804,  2781,
    2619,  3252,  1823,  1824,  1551,  2946,  2947,  -977,  1489,  2621,
    1574,  3573,  3574,  3575,  1643,  1989,   628,  1144,  1990,  2193,
    3825,  2194,  3500,  1065,    55,  -977,  3640,   203,  1831,  1552,
    1167,    49,  1862,  1237,   628,  1845,  3778,  3779, -1002,    52,
      53,    54,   188,  2198,  1842,  1850,  2775,  1746,  2620,  2205,
    1489,  1825,  2695,  1065,  1065,  1251,  1065,  2622,   745,  3825,
    2099,   753,  2141,  2229,  1891,   629,  1900,  1901,  1892,  -977,
    2917,  1521,  2918,  1065,  1490,   629,  2868,  -977,  1560,  3610,
     654,   654,   203,   628,  1384,  3825,  1887,  2142,   378,  2869,
    2870,  2871,  2919,  2872,  2873,  2874,  2875,  2876,  2877,  1103,
    1523,  3019,  2769,  3782,  2100,  1489,  1991,  1851,   745,  3246,
    1914,   753,  3828,   209,   629,  3611,  1490,  1464,   746,  1007,
     752,  1464,  1464,  1524,   941,  1148,  3020,  1149,  1950,  1950,
    1854,  1950,  3772,  3266,  2668,  2669,  2670,  2671,  2672,  2673,
    1008,  1104,  1065,   941,  1448,  1065,  1065,  1997,  1448,  1448,
    1009,   376,   376,   630,   119,  1521,   379,   379,   379,  2412,
    3178,   654,   942,  2770,   807,  1141,  1493,   225,  2263,   889,
    1145,  1490,   123,  2267,   227,  2135,  2101,  3362,  2010,  -977,
    1522,   942,  2276,   629,  1523,  1156,  3803,   376,   890,  2771,
    1532,  3806,  2920,   379,  2007,  2285,  3363,  2921,  2109,  1562,
     379,  1993,  1635,  2011,  2772,  2116,   379,  1524,   766,   775,
     944,  3690,  2773,  1870,  1871,  1872,  1873,  1874,  1875,  2102,
    3827,  2103,  1823,  1824,  2112,   800,  3538,  2117,  1010,   944,
    2012,  2125,  2104,   240,  2836,  2774,  1635,  1974,   876,   811,
    2143,  1975,  2292,  3406,  2837,  1169,  2789,  2206,  2791,  2144,
    1635,   628,  2838,   987,  1946,  1448,  2804,  -645,  2291,    55,
    1947,  1448,  3465,  3081,  2292,  2105,   745,   895,  2430,   753,
    2431,  1827,  2145,  2513,  1812,  1813,   746,  1975,   752,   377,
     377,   377,  1161,  2970,  2265, -1431,  2331,  1170,  1011,   949,
    2432,   813,  2332, -1431, -1431, -1431,  2106,   375,   375,   375,
    2531,  1635,  3018,  2922,  3082,  2769,  2332,  1800,  2775,  2016,
    1110,  2923, -1431,  3204,  1111,  2562,   377,  2892,  2173,  2894,
    2895,  2563,  2257,   377,  1176,  3083,  2295,  2257,  2107,   377,
    2257,  2339,  2678,   943,   375,  1635,  2708,  1448,  2679,  2713,
    2818,   375,  2709,  1173,  3084,  3233,  2819,   375,  3163,  1012,
    2985,  2986,   943,  3128,  3035,  3446,  3543,  1224,   628,  3085,
    1635,  3037,  3038,  1384,   379,   628,  2770,  3129,  3702,  2835,
    2268,  2489,  1200, -1417,  3086,  2292,  3466, -1417,  1001,  2277,
    3267,  3268,  1380,  2259,  1046,  2433,  1151,  1047,  1152,  2283,
    2434,  2251,  2771,   629,  3130,  2435,  3131,  1048,  1049,  2899,
    2845,  1187,  3296,  1065,  2904,  1065,  2292,  2772,  1635,  3098,
    1065,  1207,   378,   378,   378,  2773,   877,  1050,  3514,  1635,
    1051,   238,  1089,   819,   239,   820, -1916,  3273,  1212,  2306,
    2337,  2309,  2310,  1240,   822,  2313,  2246,  2247,  2774,  3098,
    2847,  1227,  -976,   825,  1575,  1245,  2292,    75,  2334,   378,
    2335,    75,  2850,  3087,  1244,  -976,   378, -1767,  2292,  1261,
    2336,  3088,   378,  2854,  3132, -1767, -1767, -1767,  3336,  2292,
    3029,   986,  1065,  1800,    74,  2016,   745,  1256,    74,   753,
    1262,   335,  2983,  2412, -1767,  1263,   746,   377,   752,  1786,
    3089,   240,   628,  2855,  1722,  -976,  1723,  2695,  2881,  2292,
      55,  2436,    56,  2368,  2292,   375,  1065,  1065,  1446,  2437,
    2898,  2775,  1264,  -976,  1065,  1265,  2292,  1065,  1065,  2901,
    1110,  1065, -1431,  3133,  1111,  2902,  2369,  1266,  3134,  1065,
    1065,  1269,  2949,   629,  2739,  2740,  3542,  1065,  2292,  2975,
    1065,  1065,  1065,  1065,  1391,  2976,  2980,  1800,  1052,  1485,
    1065,  1065,  1692,  1065,  1619,  1065,  3151,  -976,  1065,  1270,
    3135,  3160,  3152,  1823,  1824,  -976,  2428,  3161,  1389,  2412,
    3136,  1395,  1635,  1065,   379,  3396,  3397,  1065,  1196,  1396,
    3630,  1065,  3036,  1951,  1953,  1065,  1957,  1397,  1065,  1065,
    1065,  1065,  1065,  1065,  1065,  1065,  1065,  1406,  1065,  2257,
    3167,  2864,  3237,  1065,  3692,  2259,  3168,  1065,  2292,    55,
    2486,    56,  1570,  2535,  2539,  1789,  3289,  2538,  3274,  1407,
     378, -1916,    49,  3281,  3275,   628,  2289,  2500,  1723,  3282,
      52,    53,    54,    55,  2552,    56,  1408,  3292,  2556,   745,
     629,  1446,   753,  2292,  1418, -1148,  3137,  1414, -1148,   746,
     376,   752,  1197, -1148, -1148, -1148,   379,  3315,  2983,  2517,
    2570,  2517,  2572,  2292,  1770,  1415,   795,  -976,  1065,  1416,
    3316,  3672, -1148,  1421, -1769,  1198,  2292,    49,  2864,  1800,
     628,  2016, -1769, -1769, -1769,    52,    53,    54,  2983,  3865,
    2864,  3866,   376,  3290,   376,  2594,   630,   377,   379,  1432,
     379, -1769,  2936,  2203,  2937,  3520, -1916,  1436,  3334,  1029,
   -1916,  1440,  3425,  1499,  3168,   375,  1593,  1594,  3426,  3475,
    3752,  2938,  3754,  2939,  1437,  2292,   629,  3383,  3384,  2635,
    1464,  3387,    75,  3388,    75,  1452,  2648,   379,  2650,  1441,
    2571,   987,  1500,  1442,  3106,  3107,  3108,  3109,  3110,  1448,
    1776,  1777,  1065,  2582,  3399,  3381,  3630,  1448,  3519,    74,
    3545,    74,  2796,  3679,  2332,  2798,  3168,  2589,  3546,  2800,
    2866,  2592,  1635,  3518,  3168, -1115,  1635,  1635, -1115,   377,
    3637,  3642,  3644, -1115, -1115, -1115,  1692,  3152,  3152,  3788,
    3453,    49,  3657,  1443,   628,  1501,  1444,   375,  3658,    52,
      53,    54,  1800,  1236,  2714,  2864,  3505,  3659,  3664,  3440,
    3441,  3442,  2950,  2292,  2332,  2588,  2951,  2952,  2953,  1455,
    3521,   377,  3242,   377,  1502,  1445,  2834,  2954,  2955,  2956,
     378,  2957,  2958,  2867,  3725,  1453,  2959,  2960,  2961,   375,
    3726,   375, -1128,  1823,  1824, -1128,  1414,  2866,  -969,  3732,
   -1128, -1128, -1128, -1765,  1448,  1692,  3630,  1448,  1448,  2866,
     377, -1765, -1765, -1765,  1458, -1158,  3734,  1596, -1158,  1806,
    1065,  1471,  3152, -1158, -1158, -1158,  1472,  1635,   375, -1155,
   -1765,  1420, -1155,  1422,  3771,   629,  1474, -1155, -1155, -1155,
    1766,  1770,  1825,   629,  3276,  1481,  1065,   629,  1635,  2989,
    2990,  2259,  3773,  3781,  1498,  2259, -1155,  2689,  3726,  1692,
    2867, -1764,   378,  1078,  2815,    49,  2991,  2992,   987, -1764,
   -1764, -1764,  2867,    52,    53,    54,  1079,  1080,  1081,  1485,
    1082,  1083,  1084,  1085,  1086,  1087,  2747,  2360, -1764,  2072,
    1515,  2815,  1886,  1529,  1073,  2715,  3196,   203,  3199,  2045,
    1530,  1505,    49,  1563,   378,   628,   378,  1506,  1557,  2762,
      52,    53,    54,  3783,  1507,  1566,   629,    49,  1565,  2902,
    1489,  1065,  1459,  1461,  2866,    52,    53,    54,  1509,  1849,
    1580,  1065,  2799,  2868,  1952,  1952,  1510,  1952,  1582,  3784,
    2151,  2941,  2942,   378,  3842,  2292,  2869,  2870,  2871,  2361,
    2872,  2873,  2874,  2875,  2876,  2877,  1029,  1770,  2982,  3787,
    1587,  1591,   629,  1065,  1589,  2332,  1597,    49,  3789,  1600,
     628,  1637,  1153,  3790,  2332,    52,    53,    54,   745,  2332,
    3011,   753,  1511,   745,  1823,  1824,   753,  2867,   746,  1638,
     752,  3840,  1065,   746,  2485,   752,  3864,  3841,  1490,  2197,
    1643,  2362,  2292,  1635,  2363,  3870, -1158,  3541,  1647, -1158,
    2868,  3841,  3668,  -166, -1158, -1158, -1158,  3108,  3109,  3110,
    1065,  1065,  2868,  2869,  2870,  2871,  2962,  2872,  2873,  2874,
    2875,  2876,  2877,  1827,  1649,  2869,  2870,  2871,  1665,  2872,
    2873,  2874,  2875,  2876,  2877,  1674,  1154,  2264,  1682,  1684,
    3044,  3045,  1065,  1686,    49,  1687,  1065,   628,  2072,  1688,
    1689,  1691,    52,    53,    54,    55,  1692,    56,  1065,  1065,
    1065,  1065,  1697,  3535,  2963,  1698,   379,  1700,  1701,    49,
    1065,   379,  3002,  1702,  1703,  1065,  1842,    52,    53,    54,
    1708,  1709,  2364,  1710,    49,  1065,  1065,   628,  1065,  1713,
    2428,  1772,    52,    53,    54,  3745,  2383,  1774,  1078,  3750,
    3751,  1065,  1778,  1065,  1785,  1780,  1793,  1065,  1796,  2935,
    1797,  1079,  1080,  1081,  1798,  1082,  1083,  1084,  1085,  1086,
    1087,  2251, -1119,  1065,  1803, -1119,  2988,  2868,  1799,  3740,
   -1119, -1119, -1119,  1065,  1583,  1065,  1065,   240,  1805,  1808,
    2869,  2870,  2871,  1809,  2872,  2873,  2874,  2875,  2876,  2877,
    2964,  1810,  1811,  1766,  1816,  1464,  1065, -1117,  1818,  3746,
   -1117,  1819,  1065,  1820,  1821, -1117, -1117, -1117,  2365,  1822,
    1829,  1065,  1065,  1065,  1830,  1832,   238,    49,  1833,   239,
     628,  1834,  1448,  1835,  1908,    52,    53,    54, -1120,   377,
    1836, -1120,  3061,  1837,   377,  1879, -1120, -1120, -1120,  1918,
    1933,  2419,  1935,  1065,  3031,  3032,  1948,   375,  1584,  3206,
    1423,  3208,   375,  3210,  1970,  3212,  1973,  3214,  1980,  1988,
   -1118,  1994,  3217, -1118,  1635,  1635,  1987,  1635, -1118, -1118,
   -1118,  3106,  3107,  3108,  3109,  3110,  1996,  1998,  1463,  3111,
    1635,  2001,  1635,  1089,  2002,  1095,  2004,  2013, -1710,  2006,
    2014,  2017,  3030,  3154,  2016,  3234,  2018,  2034,  2035,  3033,
    2040,  3034,  2037,  2038,  2039,  2259,  2060,  2061,  2062,  1140,
    2259,  1635,   745,  2259,  2063,   753,  2067,  3569,  2095,  2096,
    2068,  2069,   746,  2098,   752,  2097,  2109,  2113,  3187,  2123,
    2128,  2129,  3834,  2130,   832,  1448,  2137,  1078,  2156,  2163,
    2165,  2136,  1448,  1448,  2166,  2175,  2138,  2140,  1800,  1806,
    1079,  1080,  1081,  3857,  1082,  1083,  1084,  1085,  1086,  1087,
    1635,  1789,   378,  2177,  2188,  3155,   629,   378,   629,   629,
     809,  2200,  2204,  2217,  2231,  2238,  2235,  2240,  3121,  2242,
    3092,  1635,   629,  3169,  2249,  2260,  2270,  2271,  1464,  2272,
    2273,  2284,  3224,  2298,  2243,  2689,  2314,  2299,  2305,  3186,
    3150,  2317,  2304,  2321,  2329,   987,  2341,  3117,   629,  2392,
     379,  1635,  2350,  3235,  3715,  1448,   335,  2349,  1464,  1248,
    2384,  2393,  2405,  2410,  1250,  1851,  1635,  2414,  3177,  1384,
     629,  2415,  2427,  2422,   335,  1259,  2446,  2444,  2472,  1635,
    3306,  3307,  3308,  3309,  2483,  1448,  1538,  2482,  2484,  2487,
     335,  2490,  1539,  1635,   994,  2495,  3229,  2251,   629,   629,
    2501,  2251,  2506,  2507,  1250,  2512,  2520,  2521,  2179,  1065,
    2532,  2533,  2530,  1065,  2540,  2534,  2544,  2542,  2545,  2463,
    1250,  2548,  2546,  1065,  2550,  1403,   852,  2553,  1635,  2558,
    1540,  2560,  2579,  2580,  1635,  2584,  2581,  2583,   853,  1417,
    2591,  2593,  2599,   745,  2606,  2645,   753,   335,  2646,  1078,
    1089,  2647,  1065,   746,  2652,   752,  2656,  2658,   854,  2653,
    2659,  2660,  1079,  1080,  1081,  2662,  1082,  1083,  1084,  1085,
    1086,  1087,  2661,   377,  2663,  2674,  2680,  1541,  2685,  2692,
     855,  2693,  1065,  2697,  1542,  1635,  2072,  1543,  2698,  2706,
    2710,   375,  2720,  1065,  2721,  2726,  2722,  2745,   856,  1065,
    2746,  1065,  2244,  2259,  2748,  1635,  1065,  2684,  2758,  1065,
    1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,   857,
    2759,  3722,  2259,  1065,  1065,  2760,  3728,  3728,  3287,  2761,
    2782,  2750,  1635,  2768,  2787,  1544,  2750,  1065,  2795,  2797,
    1895,   379,  2794,  1065,  2793,  2816,  2802,  2342,  2828,  1499,
     858,  2831,  1065,  2811,  1499,  1065,   859,  1065,   629,  1247,
    2833,  1576,  2848,  1842,  2849,  1635,  1065,  1065,  1065,  2851,
     860,  2852,  1065,  2853,  3364,  1065,  3366,  2856,  1500,  2857,
    2292,  2859,  3753,  1500,  3755,  1065,  2862,  2916,  1545,  2880,
    2886,  2887,  2888,  2889,  2911,  2890,  2897,  3317,  2909,  2944,
    2931,  2910,  2924,  2997,  3678,  2934,   378,  3005,  1723,  2948,
    3012,  2999,  1661,  1663,  1664,  3013,  3008,  2996,  3482,  3483,
    3000,  2994,  1521,  3777,  3050,  3026,  2357,  2358,  3051,  3009,
    3001,  1501,  3052,  3071,  2370,  3053,  1501,  2383,  2373,  2374,
    3054,  2383,  3055,  1073,  3056,  3057,  3070,  1546,  3058,  3059,
     861,  1523,  3060,  2394,  3072,  2395,  3073,  3074,   862,  3075,
    1502,  3076,  2829,  3800,   377,  1502,  3102,  3101,  1990,  3113,
    3728,  3141,  3112,   775,  1547,  2416,  3156,  2417,  3158,  2259,
    2383,  2383,   375,  1635,  3145,  3159,  3164,  3813,  2751,  3165,
    3174,  3172,  1250,  2751,  3190,   863,  3184,  3192,  3188,   864,
    3193,   865,  3200,  3203,  3209,  3205,  3211,   866,  3221,  3222,
    3228,  3231,  3232,  1250,  3240,  2883,  1786,  1882,  2864,   629,
     629,   629,   629,   629,   629,  2882,  3283,  3270,  1846,  3313,
    3319,  3271,  3294,  3295,   867,   868,  3322,  3272,  3303,   869,
    3320,  3318,  3325,  3328,    55,  3335,  2815,   870,  3337,  3359,
    3338,  3339,   871,  3349,  2689,  2689,  2689,  2689,  2689,  3350,
    3351,   872,  3371,  3372,  3373,  3374,  3382,  3409,  3181,  1993,
    3398,  1065,   873,  3420,  3422,  3424,  3416,  3431,  3436,  2259,
    3444,  3459,  1635,   203,  3437,  3450,  3451,  1505,   203,  3469,
    3447,  3478,  2752,  1506,  3462,  3472,  3484,   378,  1506,  3481,
    1507,  3485,  3489,  3493,  3491,  1507,  1489,  3494,  3497,  3501,
    3506,  1489,  3502,  3507,  1509,  3508,  3531,  3512,  3548,  1509,
     629,  2251,  1510,  3532,  3561,  3565,  2251,  1510,  3554,  2251,
    3557,  3562,  3571,  1065,  3572,   637,  3580,  3586,  1065,  3589,
    3811,  1065,   657,  3390,   661,  3590,  3591,  1851,  3599,  1936,
    3592,  3601,  3604,   661,  3606,  3824,  3609,  3613,  3549,  3619,
    3620,  3621,  1852,  3623,  3625,  3634,  3649,  3650,  1511,  3558,
    1854,  3560,  3181,  1511,  3653,  1855,  3626,  3639,   657,  1065,
    3654,  3645,  3646,  3647,  3648,  3661,  3656,   661,  3674,  3662,
    3688,  3663,  3673,  3689,  3824,  3693,   657,   661,  3699,  3681,
     661,  3682,  3415,  3701,  3168,  3717,   661,  3707,  3863,  3025,
     661,  3028,  3718,  3719,  3720,   911,  1065,  3758,  2590,  3759,
    3824,  2384,  3762,  1065,  1065,  2384,  3766,  3767,  2750,   913,
    1065,  1065,   661,  3791,  1716,  1065,  1635,   920,  3540,  3792,
    3039,  1065,  1065,  3801,  3802,  1065,  1499,   661,  3809,  3795,
    3814,   930,  3797,   911,  3785,  3812,  3794,   950,  3567,  3568,
    3793,  3570,  3747,  3836,  2384,  2384,  3837,  3537,   629,  3867,
     989,  3855,  2712,   977,  1930,  1500,    75,  2973,  2634,  3043,
    2676,  3576,  3433,  1635,  3429,  2609,  3352,  3596,  3007,  3065,
    3439,  2122,  1856,  3810,  3536,  3833,  1857,  3798,  3602,  3796,
    3577,  3578,  3820,    74,  3218,  3582,  3434,  2690,  2230,  3622,
    3869,  2815,  2694,  2696,  3856,  3588,  1858,  1859,  3587,  3142,
     629,   629,   629,  3091,  3143,  3821,  3680,  2199,  1501,  1860,
     629,   629,  3579,  3835,  3683,   629,  3583,   918,  1760,  2817,
    1909,  3490,  3448,  3723,  3608,  3776,  2566,  3015,  2564,   335,
    1065,  3757,  3848,  3452,  3735,  3153,  3868,  1502,  1399,  3703,
    2704,  3636,  1861,  2497,   882,  1862,  1733,  3428,  3039,  3632,
    3230,  3636,  2977,  2803,   629,  2981,  1499,  3486,  2993,  1863,
    2509,  1864,  1737,  1968,  2943,  2751,  1966,  1971,  2494,  3427,
    2764,  1065,  3198,  3641,  2978,  3286,  3739,  3277,  2251,   629,
    2409,  2984,  2929,  2927,  2842,  1500,  1065,  1183,  2821,  2471,
    1065,  3185,  2757,  2245,  1032,  1635,  1676,  3207,  1002,  2522,
    1609,  2383,  1979,  2072,  2383,  2383,  2383,  2383,  2383,  2383,
    2383,  2383,  2383,  2383,   661,  1479,  1972,  1223,  1065,  2514,
    1910,  1462,  1065,  2810,  1865,  2809,  1769,  2968,  3487,  2279,
    2524,  3534,  3488,  3321,  1538,  1894,  2282,  1976,  1501,  1024,
    1539,  1065,  1065,  2528,    80,  1065,  2805,  2300,     0,  1719,
       0,  2863,  1065,  1065,  3241,  2879,     0,     0,     0,     0,
     203,     0,  2383,  2383,  1505,     0,     0,  1502,     0,     0,
    1506,     0,  1065,     0,  3247,     0,     0,  1507,  1540,     0,
       0,  1250,  1250,  1489,     0,     0,  1065,     0,     0,     0,
    3671,  1509,     0,  2328,  2912,  2913,     0,     0,     0,  1510,
     629,  3269,     0,     0,     0,     0,     0,  3186,     0,  1866,
       0,  1065,     0,     0,     0,     0,     0,     0,  3733,     0,
       0,  3721,  1867,  1868,  1869,  1541,  1870,  1871,  1872,  1873,
    1874,  1875,  1542,     0,  1770,  1543,     0,  3862,     0,     0,
       0,     0,  2858,     0,     0,  1511,     0,  1065,  1065,     0,
       0,   629,     0,     0,     0,     0,     0,     0,   335,     0,
       0,  1503,     0,     0,     0,     0,     0,     0,  3756,     0,
       0,     0,     0,     0,  1065,  1065,     0,  1065,     0,  1065,
       0,     0,     0,  1544,     0,     0,  1504,     0,     0,     0,
     203,     0,     0,  2971,  1505,     0,     0,     0,  1635,     0,
    1506,     0,  1635,  1635,     0,     0,     0,  1507,  2470,     0,
       0,     0,     0,  1508,   238,    49,     0,   239,   628,     0,
       0,  1509,     0,    52,    53,    54,    55,   657,    56,  1510,
       0,     0,     0,     0,  1446,     0,  1545,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1065,     0,     0,
       0,     0,  3357,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2383,     0,     0,  1635,
    1521,     0,  2498,     0,     0,  1511,     0,   661,   661,     0,
       0,     0,     0,     0,     0,  2384,     0,     0,  2384,  2384,
    2384,  2384,  2384,  2384,  2384,  2384,  2384,  2384,     0,  1523,
       0,     0,     0,     0,     0,     0,     0,     0,  1065,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2633,  1065,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1851,     0,
       0,   335,     0,     0,     0,     0,  2384,  2384,     0,     0,
       0,  3419,  1887,     0,     0,  3861,     0,     0,     0,     0,
       0,  1854,  1065,  1065,     0,     0,  1855,     0,     0,     0,
       0,     0,     0,     0,     0,   335,  1065,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1065,     0,
       0,     0,  3317,  3103,     0,  2690,     0,  1067,   657,  1071,
       0,   637,     0,  1091,     0,   637,   661,     0,     0,   661,
       0,   661,  1067,   637,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2383,  2383,     0,     0,     0,
       0,     0,     0,     0,   661,     0,     0,   657,     0,  1067,
       0,   637,     0,     0,     0,   637,  1159,   661,     0,     0,
    2627,   661,     0,  1067,     0,   637,  1851,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   661,     0,
     661,  1852,     0,     0,     0,     0,     0,     0,     0,  1854,
       0,     0,   661,  1856,  1855,   657,     0,  1857,   661,     0,
       0,     0,   661,   661,     0,     0,     0,   661,     0,   661,
       0,   661,     0,     0,  1067,  1770,     0,  1858,  1859,     0,
       0,     0,     0,     0,     0,     0,     0,  1630,     0,     0,
    1860,     0,     0,     0,     0,   661,   661,     0,     0,     0,
       0,  2711,   661,     0,     0,  3248,     0,     0,  3253,  3254,
    3255,  3256,  3257,  3258,  3259,  3260,  3261,  3262,  1851,     0,
    2384,     0,  3553,   661,     0,   661,  1862,     0,  1260,  2728,
       0,     0,     0,     0,     0,     0,     0,  2749,     0,     0,
    1863,  1854,     0,     0,     0,     0,  1855,     0,     0,     0,
       0,     0,     0,     0,   661,   657,     0,     0,     0,  1385,
       0,     0,     0,     0,     0,     0,  3298,  3299,  1622,     0,
       0,  1856,     0,     0,     0,  1857,     0,     0,  1405,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1858,  1859,  1630,     0,     0,
       0,     0,     0,  2383,     0,  1865,     0,  2383,  1860,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2383,  2383,     0,     0,
       0,     0,     0,   637,   637,     0,     0,     0,     0,     0,
       0,  1861,     0,     0,  1862,   661,     0,     0,   661,     0,
       0,   661,     0,     0,  3153,     0,     0,     0,  1863,     0,
    1864,     0,     0,  1856,     0,     0,     0,  1857,     0,     0,
       0,     0,     0,     0,     0,  1067,  1067,     0,  1622,  2384,
    2384,     0,     0,     0,     0,     0,     0,  1858,  1859,     0,
    1866,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1860,     0,   661,  1867,  1868,  1869,     0,  1870,  1871,  1872,
    1873,  1874,  1875,     0,  1578,     0,     0,     0,     0,     0,
       0,     0,     0,  1865,     0,     0,     0,   661,     0,     0,
       0,     0,  1912,   661,     0,     0,  1862,   661,  1624,     0,
       0,     0,  2074,     0,   661,     0,     0,     0,     0,     0,
    1863,     0,  1067,  1067,     0,     0,     0,     0,     0,  2383,
    2383,     0,     0,  2940,     0,     0,     0,     0,  1067,  1578,
    3411,   661,  1673,     0,     0,     0,     0,     0,     0,  3395,
       0,     0,     0,     0,  2690,  2690,  2690,  2690,  2690,     0,
       0,     0,  3408,     0,  2075,  1067,  1067,     0,     0,   661,
       0,     0,     0,  2076,  2077,     0,     0,     0,  1866,     0,
       0,     0,     0,     0,     0,  1865,     0,     0,     0,     0,
       0,  1867,  1868,  1869,  1630,  1870,  1871,  1872,  1873,  1874,
    1875,     0,     0,  2148,     0,     0,   661,     0,     0,     0,
       0,     0,  2149,     0,  2078,   661,   911,     0,  1624,     0,
     661,     0,     0,     0,     0,   661,     0,  1770,  1630,     0,
       0,  1770,  1770,  1779,     0,     0,   661,     0,  1784,     0,
       0,     0,  1630,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2079,     0,  2384,     0,     0,
    2080,  2384,     0,     0,     0,     0,     0,     0,     0,     0,
    1866,     0,     0,     0,     0,  1622,     0,     0,     0,     0,
    2384,  2384,     0,     0, -1995, -1995,     0,  1870,  1871,  1872,
    1873,  1874,  1875,  1630,     0,     0,     0,  2081,  2072,  3515,
    3516,     0,     0,     0,     0,     0,     0,     0,     0,  1622,
    1630,     0,     0,     0,  2082,  2083,     0,  2084,  2085,     0,
    2086,     0,     0,  1622,     0,     0,     0,  1630,     0,     0,
       0,     0,     0,  1851,     0,     0,     0,     0,     0,     0,
       0,   657,   657,     0,     0,     0,     0,     0,  1852,     0,
    2087,     0,  1630,     0,     0,  1385,  1854,     0,     0,     0,
       0,  1855,  1928,  1928,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1937,  1622,  1944,     0,     0,  3544,     0,
       0,     0,     0,  2088,     0,     0,     0,  3147,  3551,  3552,
       0,  1622,     0,  3555,  3556,     0,  3157,     0,     0,     0,
    1630,     0,     0,  3563,     0,     0,     0,     0,  1622,     0,
       0,  1630,     0,  2384,  2384,  3173,     0,     0,  2089,     0,
    2090,     0,   657,  1851,   637,     0,     0,     0,     0,     0,
       0,     0,     0,  1622,     0,     0,     0,     0,  1852,     0,
       0,     0,  2091,   661,     0,  1624,  1854,     0,     0,  2092,
       0,  1855,  2093,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3215,     0,  3216,     0,     0,     0,     0,  3219,
       0,     0,     0,     0,     0,     0,     0,     0,  1856,  1624,
       0,  1622,  1857,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1622,  1624,     0,     0,     0,     0,  1250,  1091,
       0,     0,  1858,  1859,     0,     0,     0,  3652,     0,     0,
       0,  3655,     0,     0,     0,  1860,     0,     0,     0,     0,
       0,     0,  1067,  1067,  1067,  1067,     0,     0,     0,     0,
    3665,  3666,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1624,     0,     0,     0,  1861,     0,
       0,  1862,  1067,  1067,     0,     0,     0,     0,  1067,   767,
       0,  1624,     0,     0,  1630,  1863,     0,  1864,  1856,     0,
       0,     0,  1857,     0,     0,     0,     0,     0,  1624,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1858,  1859,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1624,     0,  1860,     0,     0,  3310,  3311,
       0,     0,     0,   768,     0,     0,   637,     0,   661,     0,
    1067,  1067,  1067,  1067,     0,     0,     0,     0,     0,     0,
    1865,   769,     0,     0,  1385,     0,  1578,     0,  1861,     0,
       0,  1862,     0,     0,     0,  1622,     0,     0,     0,     0,
       0,  1624,   770,     0,     0,  1863,     0,   657,     0,     0,
     661,   661,  1624,  3736,  3737,     0,  1091,     0,     0,   661,
     661,     0,   661,     0,     0,     0,     0,   661,     0,   661,
       0,     0,  1067,   771,     0,  1067,     0,     0,     0,   772,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   661,
     661,     0,     0,   773,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1866,     0,     0,     0,   661,
    1865,   661,   661,     0,     0,   661,     0,     0,  1867,  1868,
    1869,  2320,  1870,  1871,  1872,  1873,  1874,  1875,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2905,   911,
       0,     0,  2344,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1630,     0,     0,     0,  1630,  1630,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3407,     0,     0,   774,     0,     0,     0,  1091,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3417,     0,  1866,   775,     0,     0,     0,
       0,     0,     0,  3421,     0,  1624,     0,     0,  1867,  1868,
    1869,     0,  1870,  1871,  1872,  1873,  1874,  1875,   776,     0,
       0,     0,     0,     0,   777,     0,     0,     0,     0,     0,
     778,     0,     0,     0,     0,  1622,     0,     0,     0,  1622,
    1622,     0,     0,     0,     0,     0,     0,   661,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   779,   780,  1630,
       0,     0,   781,     0,     0,     0,     0,     0,     0,     0,
     782,     4,     0,     0,     0,   783,     0,     0,     0,     0,
    1630,     0,     0,     0,   784,     0,     0,     0,     0,     0,
       0,     0,     5,     0,     0,   785,     0,  1944,     0,     0,
       0,     0,     6,     7,     0,     0,     0,   661,     0,     0,
       9,    10,     0,     0,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,     0,     0,
    1622,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   637,     0,     0,
     661,  1622,     0,  3527,  3528,  3529,  3530,     0,     0,     0,
       0,     0,   637,   661,     0,     0,   637,   657,     0,     0,
      35,   661,     0,     0,     0,     0,     0,   661,     0,     0,
       0,     0,   661,   637,     0,     0,     0,   637,   661,     0,
       0,     0,     0,   661,     0,  1624,     0,     0,     0,  1624,
    1624,     0,     0,     0,     0,  1851,     0,     0,     0,   637,
     661,   637,   661,     0,   661,     0,     0,  2577,  2577,     0,
       0,     0,     0,   661,     0,  1630,     0,     0,  1854,     0,
       0,     0,     0,  1855,     0,     0,     0,   661,    36,     0,
       0,   661,     0,     0,   637,   661,   661,   661,     0,     0,
       0,     0,    37,     0,     0,     0,     0,     0,     0,     0,
    2610,  2611,   661,   661,   661,   661,  2618,     0,     0,   661,
     661,    38,     0,   661,   661,   661,   645,     0,   637,   661,
       0,     0,     0,   658,     0,   637,   661,   637,     0,   661,
       0,    39,     0,     0,     0,     0,     0,     0,     0,     0,
    1624,     0,     0,     0,     0,     0,  1622,  1067,  1067,  1067,
    1067,  1067,  1067,     0,     0,     0,  2914,     0,     0,   658,
       0,  1624,     0,    40,     0,     0,    41,     0,  2691,     0,
       0,     0,     0,     0,     0,     0,     0,   658,   658,     0,
       0,     0,     0,     0,     0,     0,     0,   658,    42,  2577,
   -1995,   645,     0,     0,  1857,     0,     0,   911,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   645,     0,   645,  1858,  1859,     0,  2725,     0,     0,
       0,     0,  2738,     0,  2744,     0,     0, -1995,   658,     0,
       0,     0,  1673,     0,     0,     0,     0,     0,     0,     0,
    2767,     0,     0,     0,  2767,  2780,     0,     0,     0,     0,
       0,     0,     0,     0,    43,     0,     0,     0,     0,  1067,
    2577,  1067,  2577,  1862,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1863,     0,  3695,
       0,     0,     0,     0,     0,     0,     0,   661,     0,     0,
       0,     0,     0,    44,     0,     0,  1630,  1630,     0,  1630,
    1250,     0,     0,   637,     0,    45,     0,     0,     0,     0,
       0,     0,  1630,     0,  1630,     0,  1624,     0,    46,     0,
       0,  3731,     0,     0,     0,     0,     0,   661,     0,  1625,
     637,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0, -1995,  1630,     0,     0,     0,     0,    48,    49,
       0,    50,     0,     0,     0,     0,     0,    52,    53,    54,
      55,  3743,    56,    57,     0,     0,     0,    58,    59,    60,
      61,    62,     0,     0,    63,    64,  1216,  1622,  1622,     0,
    1622,     0,     0,     0,    71,     0,     0,     0,  1851,     0,
       0,     0,  1630,  1622,     0,  1622,     0,     0,     0,     0,
       0,     0,     0,  1852,  2908,     0,     0,     0,     0,     0,
       0,  1854,     0,  1630,     0,   658,  1855,     0,     0,     0,
       0,     0,     0,     0,  1622,     0,     0,  1866,     0,     0,
       0,     0,     0,  1091,     0,     0,     0,     0,     0,  1625,
       0,     0,     0,  1630,  1870,  1871,  1872,  1873,  1874,  1875,
       0,     0,     0,     0,     0,     0,     0,     0,  1630,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1630,     0,  1622,     0,     0,  1928,     0,     0,     0,
       0,     0,  1944,     0,     0,  1630,     0,     0,     0,     0,
       0,     0,     0,     0,  1622,     0,   661,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1630,   637,   661,   661,  1622,     0,  1630,     0,     0,     0,
       0,     0,     0,  1856,     0,  2744,     0,  1857,     0,  1622,
       0,     0,     0,     0,     0,     0,     0,  1624,  1624,     0,
    1624,     0,  1622,     0,     0,     0,     0,  1858,  1859,     0,
       0,     0,     0,  1624,     0,  1624,  1622,     0,     0,     0,
    1860,     0,     0,     0,   661,   661,     0,  1630,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1624,  1067,     0,  1630,     0,     0,
       0,  1622,     0,  1861,     0,     0,  1862,  1622,   661,   661,
     661,   661,     0,     0,     0,     0,     0,     0,     0,     0,
    1863,     0,  1864,     0,  1630,     0,     0,     0,   658,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   637,   661,  1624,     0,     0,     0,     0,     0,     0,
       0,  2577,  2577,     0,     0,     0,     0,  1630,  1622,     0,
       0,     0,     0,     0,  1624,     0,  1625,     0,     0,     0,
    1851,     0,     0,     0,     0,     0,  2691,     0,  1622,     0,
       0,     0,     0,     0,     0,  1865,     0,     0,     0,     0,
     661,   661,   661,  1854,  1624,     0,     0,     0,  1855,     0,
    1625,     0,     0,     0,     0,  1622,     0,     0,     0,  1624,
       0,     0,     0,     0,  1625,   661,     0,     0,     0,     0,
       0,     0,  1624,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   661,  1624,     0,  1622,     0,
    1385,     0,     0,     0,     0,     0,     0,   657,     0,     0,
     661,  2767,     0,     0,  3189,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1625,     0,  3202,     0,     0,
    1866,  1624,     0,     0,     0,  1630,     0,  1624,     0,     0,
       0,  2925,  1625,  1867,  1868,  1869,     0,  1870,  1871,  1872,
    1873,  1874,  1875,     0,     0,     0,     0,  2413,     0,  1625,
       0,   637,     0,     0,     0,     0,     0,     0,  2320,     0,
       0,     0,     0,  1117,     0, -1995,     0,     0,     0,  1857,
       0,     0,   637,  1851,  1625,     0,     0,     0,  1624,   645,
       0,     0,     0,     0,     0,  1067,     0,     0,  1852,  1858,
    1859,     0,     0,     0,     0,  1118,  1854,     0,  1624,     0,
       0,  1855, -1995,     0,     0,     0,  1622,  1119,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1120,  1177,   658,
       0,   658,  1625,     0,  1630,  1624,     0,     0,     0,     0,
       0,     0,     0,  1625,     0,  1121,     0,     0,  1862,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1863,     0,     0,     0,  1122,     0,  1624,     0,
     658,     0,     0,     0,   645,     0,   645,     0,   645,     0,
       0,     0,     0,     0,   645,   645,     0,     0,     0,     0,
       0,     0,     0,   658,     0,     0,     0,  1123,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   645,     0,     0,     0,  1622,     0,  1124,     0,     0,
       0,     0,     0,     0,     0,  1944,     0, -1995,  1856,     0,
       0,     0,  1857,     0,     0,     0,     0,     0,   645,     0,
       0,  1125,     0,     0,     0,   658,   658,     0,     0,   645,
     645,     0,  1858,  1859,     0,     0,     0,  2744,  2744,     0,
       0,     0,     0,     0,     0,  1860,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1624,     0,  1630,     0,
       0,     0,     0,     0,     0,     0,  1625,  1126,  1861,   661,
       0,  1862,     0,   637,   661,   637,   661,   661,   661,   661,
     645,     0,  1866,     0,     0,  1863,     0,  1864,     0,     0,
     775,     0,     0,     0,   645,   645,     0,     0,     0,  1870,
    1871,  1872,  1873,  1874,  1875,  1630,     0,     0,     0,     0,
       0,     0,  1127,     0,     0,     0,  1128,     0,  1129,     0,
       0,     0,     0,     0,  1130,  2691,  2691,  2691,  2691,  2691,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1622,
       0,     0,     0,     0,     0,     0,     0,     0,   661,     0,
    1865,  1131,  1132,     0,     0,  1624,  1133,     0,     0,     0,
       0,     0,     0,     0,  1134,     0,     0,     0,     0,  1135,
       0,  2725,     0,     0,     0,  2610,     0,     0,  2610,     0,
    3435,     0,     0,     0,     0,     0,  1622,  2744,     0,  1136,
       0,     0,     0,  2577,     0,     0,     0,     0,     0,     0,
       0,   645,     0,     0,     0,     0,     0,  2767,     0,   661,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2725,     0,  3474,     0,   661,     0,     0,     0,  2577,     0,
    2577,     0,     0,     0,     0,  1866,     0,  1630,     0,     0,
       0,     0,     0,     0,     0,   637,     0,     0,  1867,  1868,
    1869,     0,  1870,  1871,  1872,  1873,  1874,  1875,     0,     0,
       0,     0,  3100,     0,     0,  1851,  1625,     0,     0,     0,
    1625,  1625,   645,     0,     0,     0,     0,     0,   751,     0,
    1852,     0,     0,     0,     0,     0,     0,     0,  1854,     0,
       0,     0,     0,  1855,     0,     0,     0,     0,     0,     0,
    1745,     0,     0,  1749,     0,     0,     0,     0,     0,  1624,
       0,     0,     0,   658,     0,     0,     0,     0,  1622,     0,
     751,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1091,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1624,   637,   661,     0,
       0,     0,     0,     0,     0,     0,     0,   940,   637,   661,
     637,  1625,     0,  1851,   940,  3564,   940,     0,   661,   661,
    1067,   661,     0,     0,     0,     0,     0,   751,  1852,     0,
       0,     0,  1625,     0,     0,     0,  1854,   645,     0,     0,
       0,  1855,     0,     0,     0,  2744,     0,   645,     0,     0,
    1856,     0,     0,     0,  1857,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1890,     0,
       0,     0,   658,   658,  1858,  1859,     0,     0,     0,     0,
    1630,     0,     0,     0,  1630,  1630,   645,  1860,     0,   645,
       0,     0,     0,   645,   645,     0,   661,     0,     0,     0,
       0,     0,     0,   661,     0,     0,     0,     0,     0,  3631,
       0,     0,     0,     0,     0,     0,     0,     0,  3635,     0,
    1861,   661,     0,  1862,     0,     0,     0,     0,  1624,     0,
       0,  3474,     0,     0,     0,     0,     0,  1863,     0,  1864,
       0,     0,     0,     0,  3435,     0,     0,     0,     0,     0,
     637,  1630,     0,   658,     0,   645,     0,     0,  1856,     0,
       0,  1622,  1857,     0,     0,  1622,  1622,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1858,  1859,     0,     0,     0,  1625,     0,     0,
       0,     0,     0,     0,     0,  1860,     0,     0,     0,     0,
     645,     0,  1865,     0,     0,     0,   645,     0,     0,     0,
       0,  1091,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1851,     0,     0,     0,     0,  1861,     0,
       0,  1862,  1622,     0,     0,     0,     0,     0,  1852,  2744,
       0,     0,     0,     0,     0,  1863,  1854,  1864,     0,     0,
       0,  1855,     0,     0,     0,     0,     0,     0,     0,     0,
    2577,     0,  2610,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   645,     0,  1067,  3631,     0,  1866,     0,  1067,
    1067,     0,     0,     0,     0,     0,     0,     0,   661,     0,
    1867,  1868,  1869,     0,  1870,  1871,  1872,  1873,  1874,  1875,
    1865,     0,     0,     0,  3285,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1624,     0,     0,     0,  1624,  1624,     0,     0,     0,
       0,     0,     0,     0,  1067,  1067,  1067,  1067,   661,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   645,   661,     0,  1856,     0,
       0,     0,  1857,     0,   645,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3631,  1067,     0,     0,     0,
       0,     0,  1858,  1859,     0,  1866,     0,     0,     0,     0,
       0,     0,  1624,     0,     0,  1860,     0,     0,  1867,  1868,
    1869,     0,  1870,  1871,  1872,  1873,  1874,  1875,  1625,  1625,
       0,  1625,  3331,     0,     0,   661,  1067,     0,     0,     0,
       0,   658,     0,  1067,  1625,     0,  1625,     0,  1861,     0,
       0,  1862,     0,     0,     0,  1890,  2303,     0,     0,     0,
    1067,     0,     0,     0,     0,  1863,     0,  1864,     0,     0,
       0,  3826,     0,     0,     0,  1625,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   645,   645,
    3826,     0,     0,     0,     0,   645,   645,     0,     0,  1851,
     645,   645,     0,     0,  1625,     0,     0,     0,     0,     0,
    1865,     0,     0,     0,  1852,   645,  3826,   645,     0,     0,
       0,     0,  1854,     0,     0,  1625,     0,  1855,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   645,     0,   645,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   751,     0,  1625,     0,     0,     0,  1851,
       0,  1062,     0,     0,     0,  1062,     0,     0,     0,     0,
    1625,  1745,     0,     0,     0,     0,     0,     0,  2480,     0,
       0,     0,  1854,  1625,     0,     0,  2303,  1855,     0,     0,
       0,     0,     0,     0,     0,  1866,     0,  1625,  1062,     0,
       0,     0,   645,     0,     0,     0,     0,     0,  1867,  1868,
    1869,     0,  1870,  1871,  1872,  1873,  1874,  1875,     0,     0,
       0,     0,  3495,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1625,     0,     0,     0,     0,     0,  1625,     0,
       0,     0,     0,     0,  1856,     0,  1062,     0,  1857,     0,
       0,     0,  1062,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1858,  1859,
       0,     0,     0,     0,     0,  1851,     0,     0,     0,     0,
      82,  1860,     0,     0,   645,     0,    86,     0,   645,  1625,
    1852,   658,    92,     0,    93,     0,    95,     0,  1854,     0,
       0,     0,     0,  1855,  1856,     0,   104,     0,  1857,  1625,
       0,     0,     0,     0,  1861,     0,     0,  1862,     0,     0,
       0,     0,     0,   116,   117,     0,     0,     0,  1858,  1859,
       0,  1863,     0,  1864,     0,     0,  1625,     0,     0,     0,
       0,  1860,     0,     0,     0,     0,     0,  1062,     0,     0,
     125,     0,   940,     0,     0,   940,     0,     0,     0,     0,
     126,     0,   127,   128,     0,     0,     0,     0,     0,  1625,
       0,     0,     0,     0,  1861,     0,   988,  1862,  1062,     0,
     645,     0,     0,     0,     0,     0,     0,     0,     0,   645,
       0,  1863,   645,   645,     0,   137,  1865,   138,   139,     0,
       0,     0,   141,   142,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   144,     0,   145,     0,     0,     0,     0,
    1856,     0,     0,     0,  1857,     0,     0,     0,     0,   147,
       0,   148,     0,     0,   151,     0,     0,     0,     0,     0,
     152,  1627,     0,     0,  1858,  1859,   153,   645,     0,     0,
       0,     0,   154,     0,     0,   645,  1865,  1860,   155,   645,
       0,     0,     0,  1628,   157,     0,   159,     0,     0,   645,
       0,   161,     0,     0,   645,     0,     0,     0,     0,     0,
       0,  1866,   165,     0,   166,     0,     0,  1625,     0,     0,
    1861,     0,     0,  1862,  1867,  1868,  1869,     0,  1870,  1871,
    1872,  1873,  1874,  1875,  1062,   751,     0,  1863,  3526,  1864,
     171,  1062,     0,     0,     0,     0,     0,  1062,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   645,     0,
       0,     0,     0,   180,   181,     0,     0,     0,  1633,   182,
       0,  1866,     0,     0,     0,     0,     0,     0,   183,     0,
       0,  1627,     0,     0,  1867,  1868,  1869,     0,  1870,  1871,
    1872,  1873,  1874,  1875,     0,  1062,   188,     0,     0,     0,
       0,     0,  1865,  1628,   645,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1625,     0,   658,  1745,
       0,     0,  2808,     0,  1749,     0,     0,     0,     0,   198,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,   203,
       0,  1062,     0,  1851,   204,     0,     0,   206,     0,     0,
       0,   208,     0,     0,     0,     0,     0,   209,  1852,     0,
       0,     0,   210,     0,     0,   212,  1854,     0,  1633,     0,
       0,  1855,   215,     0,     0,     0,     0,  1866,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1062,
    1867,  1868,  1869,     0,  1870,  1871,  1872,  1873,  1874,  1875,
       0,   221,     0,   222,  3660,     0,     0,     0,     0,   224,
       0,   225,     0,     0,   226,     0,  1062,     0,   227,     0,
    1851,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1852,     0,     0,     0,     0,
       0,     0,     0,  1854,     0,     0,  1062,  1062,  1855,  1062,
       0,  1851,     0,     0,     0,     0,     0,     0,     0,     0,
    1625,     0,     0,     0,     0,     0,  1062,     0,     0,     0,
       0,     0,     0,     0,  1854,     0,     0,   240,     0,  1855,
       0,  1851,     0,     0,     0,     0,     0,     0,  1856,     0,
       0,     0,  1857,  2303,     0,   645,     0,   645,  1627,     0,
       0,     0,     0,     0,  1854,     0,     0,  1625,     0,  1855,
       0,     0,  1858,  1859,     0,     0,     0,     0,     0,     0,
    1628,     0,     0,     0,     0,  1860,     0,     0,     0,     0,
       0,     0,  1627,     0,     0,  1062,     0,     0,  1062,  1062,
       0,     0,     0,     0,     0,     0,  1627,     0,     0,     0,
       0,     0,     0,     0,  1628,     0,     0,     0,  1861,     0,
       0,  1862,  3300,     0,     0,  1856,     0,     0,  1628,  1857,
       0,     0,     0,     0,     0,  1863,     0,  1864,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1858,
    1859,     0,  3301,   645,     0,  1633, -1995,  1627,     0,   751,
    1857,     0,  1860,   940,     0,     0,     0,     0,     0,     0,
     645,     0,     0,     0,  1627,     0,     0,   645,   645,  1628,
    1858,  1859,   940,     0,     0,     0, -1995,     0,     0,  1633,
    1857,  1627,     0, -1995,     0,  1861,  1628,     0,  1862,  1625,
    1865,     0,     0,  1633,  1851,     0,     0,     0,     0,     0,
    1858,  1859,  1863,  1628,  1864,     0,  1627,     0,     0,  1852,
       0,     0,     0, -1995,     0,     0,     0,  1854,   645,  1862,
     645,   645,  1855,     0,     0,     0,     0,     0,  1628,     0,
       0,     0,   794,  1863,   645,     0,     0,     0,     0,     0,
     645,     0,     0,     0,  1633,   645,     0,   645,     0,  1862,
       0,     0,     0,     0,  1627,     0,     0,     0,     0,   645,
     645,  1633,     0,  1863,     0,  1627,     0,  1865,     0,     0,
     645,     0,     0,     0,     0,  1866,  1628,     0,  1633,     0,
       0,     0,   645,     0,     0,     0,   658,  1628,  1867,  1868,
    1869,     0,  1870,  1871,  1872,  1873,  1874,  1875, -1995,     0,
       0,     0,  3697,  1633,     0,     0,     0,   751,     0,     0,
     645,   645,     0,     0,     0,     0,     0,     0,   794,     0,
       0,   658,     0,     0,     0,     0,     0,     0, -1995,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1856,
       0,     0,     0,  1857,     0,     0,  1062,     0,  1062,     0,
       0,  1633,  1866,  1062,     0,     0,     0,     0,     0,     0,
       0,     0,  1633,  1858,  1859,  1867,  1868,  1869,     0,  1870,
    1871,  1872,  1873,  1874,  1875,     0,  1860,     0,     0,  3774,
       0,     0,     0,  1866,     0,     0,     0,     0,     0,     0,
       0,     0,  1625,     0,     0,     0,  1625,  1625,     0,     0,
    1870,  1871,  1872,  1873,  1874,  1875,     0,     0,     0,  1861,
       0,     0,  1862,  1866,     0,  1062,     0,     0,  1627,     0,
       0,     0,     0,     0,     0,     0,  1863,     0,  1864,     0,
    1870,  1871,  1872,  1873,  1874,  1875,     0,     0,     0,     0,
    1628,     0,     0,     0,     0,     0,     0,     0,     0,  1062,
    1062,     0,     0,     0,     0,     0,     0,  1062,     0,     0,
    1062,  1062,     0,  1625,  1062,     0,     0,     0,     0,     0,
     645,     0,  1062,  1062,     0,     0,     0,     0,     0,     0,
    1062,     0,     0,  1062,  1062,  1062,  1062,     0,     0,     0,
       0,  1865,     0,  1062,  1062,     0,  1062,     0,  1062,     0,
       0,  1062,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1633,  1062,   751,     0,     0,
    1062,     0,     0,     0,  1062,     0,     0,     0,  1062,     0,
       0,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
       0,  1062,     0,     0,     0,     0,  1062,     0,     0,     0,
    1062,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1851,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1866,     0,     0,  1852,
       0,     0,     0,  2502,     0,     0,     0,  1854,     0,  1867,
    1868,  1869,  1855,  1870,  1871,  1872,  1873,  1874,  1875,     0,
       0,  3063,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1062,     0,     0,     0,     0,     0,     0,  1627,     0,
       0,     0,  1627,  1627,     0,  1851,     0,     0,     0,     0,
       0,   645,   645,   645,   645,   645,   645,     0,     0,     0,
    1628,     0,     0,     0,  1628,  1628,     0,     0,  1854,     0,
       0,     0,     0,  1855,     0,     0,  1851,     0,  2503,     0,
       0,   645,     0,     0,     0,     0,   645,   645,   645,   645,
     645,     0,     0,     0,   645,     0,     0,     0,     0,  1854,
     751,     0,     0,     0,  1855,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1062,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1856,
       0,     0,     0,  1857,     0,  1633,     0,     0,     0,  1633,
    1633,     0,     0,  1627,     0,     0,     0,     0,     0,     0,
       0,     0,   645,  1858,  1859,     0,  3304,     0,     0,     0,
       0,     0,     0,     0,  1627,  1628,  1860,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1628,  3524,     0,     0,
   -1995,     0,     0,     0,  1857,     0,     0,     0,     0,  1861,
       0,  2808,  1862,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1858,  1859,  1863,     0,  1864,     0,
       0, -1995,     0,     0,     0,  1857,     0, -1995,     0,     0,
       0,     0,     0,  1062,     0,     0,     0,     0,     0,     0,
    1633,     0,     0,     0,     0,  1858,  1859,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1995,  1062,
       0,  1633,     0,  1862,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1863,     0,     0,
    1057,  1865,     0,     0,  1057,     0,   794,     0,     0,     0,
       0,   794,   794,     0,  1862,     0,     0,     0,   794,  2303,
     645,     0,     0,     0,     0,     0,     0,     0,  1863,     0,
     645,     0,     0,     0,     0,   794,     0,  1057,     0,  1627,
     645,   645,     0,     0,     0,   645,   645,     0,  2504,     0,
       0,     0,     0,     0,  1062,   645,     0,     0,     0,     0,
       0,  1628, -1995,     0,  1062,     0,     0,     0,     0,     0,
       0,     0,   645,   645,   645,     0,     0,     0,     0,     0,
     794,     0,   645,   645,     0,  1057,  1866,   645,     0,     0,
       0,  1057,     0, -1995,     0,     0,  1062,     0,     0,  1867,
    1868,  1869,     0,  1870,  1871,  1872,  1873,  1874,  1875,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1062,   645,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1633,     0,     0,     0,
       0,     0,     0,     0,     0,   794,     0,  1866,     0,     0,
     794,   645,     0,  1062,  1062,     0,     0,     0,     0,     0,
       0,   794,     0,     0,  1870,  1871,  1872,  1873,  1874,  1875,
       0,     0,     0,     0,     0,     0,     0,     0,  1866,     0,
       0,     0,     0,     0,     0,  1062,     0,     0,     0,  1062,
     794,     0,     0,     0,     0,  1870,  1871,  1872,  1873,  1874,
    1875,  1062,  1062,  1062,  1062,     0,   794,     0,     0,   751,
       0,   794,     0,  1062,   751,     0,     0,     0,  1062,     0,
       0,     0,     0,     0,     0,   794,     0,     0,  1062,  1062,
       0,  1062,     0,     0,     0,     0,     0,  1851,     0,     0,
       0,     0,     0,     0,  1062,     0,  1062,     0,     0,     0,
    1062,     0,  1852,     0,     0,     0,     0,     0,     0,     0,
    1854,     0,     0,     0,     0,  1855,  1062,     0,     0,     0,
    1627,  1627,   645,  1627,     0,     0,  1062,     0,  1062,  1062,
       0,     0,     0,     0,     0,     0,  1627,   660,  1627,     0,
       0,     0,  1628,  1628,     0,  1628,   662,     0,     0,  1062,
       0,     0,     0,     0,     0,  1062,     0,     0,  1628,     0,
    1628,     0,     0,     0,  1062,  1062,  1062,  1627,     0,     0,
       0,     0,     0,   645,     0,     0,     0,     0,     0,     0,
     791,     0,     0,     0,     0,     0,     0,     0,     0,  1628,
     842,     0,     0,   846,     0,     0,  1062,   794,     0,   842,
    1057,     0,     0,   898,     0,     0,  1057,     0,     0,     0,
       0,     0,     0,     0,     0,  1629,  1627,  1633,  1633,     0,
    1633,     0,     0,     0,     0,   919,     0,     0,     0,     0,
       0,     0,  1856,  1633,     0,  1633,  1857,  1627,  1628,     0,
     842,     0,     0,     0,     0,     0,     0,     0,   794,   794,
     794,     0,     0,     0,  1057,     0,  1858,  1859,     0,  1628,
    1851,     0,     0,     0,  1633,     0,     0,  1627,     0,  1860,
       0,     0,     0,     0,     0,  1852,     0,     0,     0,     0,
       0,     0,  1627,  1854,     0,     0,     0,     0,  1855,  1628,
       0,     0,     0,     0,     0,  1627,     0,     0,     0,     0,
       0,     0,  1861,     0,  1628,  1862,     0,     0,     0,  1627,
       0,     0,     0,  1633,     0,     0,     0,  1628,     0,  1863,
       0,  1864,     0,     0,     0,  1629,     0,     0,   794,     0,
       0,  1628,     0,     0,  1633,     0,  3278,     0,     0,     0,
       0,     0,     0,     0,  1627,     0,     0,     0,     0,   794,
    1627,     0,   645,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   751,  1633,     0,  1628,     0,     0,     0,
       0,     0,  1628,     0,     0,     0,     0,     0,     0,  1633,
       0,     0,     0,     0,  1865,  2882,     0,     0,     0,     0,
    2883,   645,  1633,     0,     0,     0,     0,  3279,     0,     0,
       0,  1627,     0,     0,     0,  1856,  1633,     0,     0,  1857,
       0,     0,     0,     0,     0,     0,     0,   645,     0,     0,
       0,  1627,  1062,  1628,     0,     0,  1062,  1028,     0,  1858,
    1859,     0,     0,     0,     0,     0,  1062,     0,     0,     0,
       0,  1633,  1860,  1628,     0,     0,     0,  1633,  1627,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1062,     0,     0,     0,  1866,
    1628,     0,     0,     0,     0,  1861,     0,     0,  1862,     0,
       0,  1627,  1867,  1868,  1869,   794,  1870,  1871,  1872,  1873,
    1874,  1875,  1863,     0,  1864,  1062,     0,     0,  1633,     0,
       0,     0,     0,  1628,     0,     0,  1062,     0,     0,     0,
       0,     0,  1062,     0,  1062,     0,     0,     0,  1633,  1062,
       0,     0,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,     0,     0,     0,     0,  1062,  1062,     0,     0,
       0,     0,     0,     0,     0,  1633,     0,     0,     0,     0,
    1062,     0,  1629,     0,   751,     0,  1062,  1865,     0,     0,
       0,     0,     0,     0,     0,  1062,     0,     0,  1062,     0,
    1062,     0,     0,     0,     0,     0,     0,     0,  1633,  1062,
    1062,  1062,     0,     0,     0,  1062,  1629,     0,  1062,     0,
       0,  1851,     0,     0,     0,     0,     0,     0,  1062,  1627,
    1629,     0,     0,     0,     0,     0,  1852,     0,     0,  1853,
       0,     0,     0,     0,  1854,     0,     0,     0,     0,  1855,
       0,  1628,     0,     0,     0,     0,     0,   794,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     794,     0,  1866,     0,     0,     0,     0,     0,     0,     0,
       0,  1629,     0,     0,     0,  1867,  1868,  1869,     0,  1870,
    1871,  1872,  1873,  1874,  1875,     0,     0,     0,  1629,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1629,     0,     0,     0,     0,
    1036,  1037,     0,     0,     0,     0,  1633,     0,  1627,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1629,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1628,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1856,     0,     0,     0,
    1857,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1629,     0,
    1858,  1859,     0,     0,     0,  2258,     0,  1057,     0,  1629,
       0,     0,  1057,  1860,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1062,   794,     0,     0,     0,     0,
       0,     0,   794,     0,     0,  1633,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1861,     0,     0,  1862,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1093,
       0,     0,  1097,  1863,  1099,  1864,     0,     0,     0,     0,
       0,     0,     0,     0,  1057,     0,     0,   794,   794,     0,
       0,     0,     0,     0,     0,     0,  1062,  1143,     0,   794,
       0,  1062,  1627,     0,  1062,     0,     0,     0,     0,     0,
    1160,     0,     0,     0,  1162,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1628,     0,     0,     0,     0,     0,
       0,  1028,     0,   842,     0,     0,     0,     0,  1865,     0,
       0,     0,  1062,     0,     0,  1186,     0,     0,     0,  1627,
    1851,     0,     0,     0,     0,     0,  1204,     0,     0,     0,
    1206,     0,  1209,     0,     0,  1852,     0,     0,  2844,     0,
       0,  1628,  1629,  1854,     0,     0,     0,     0,  1855,  1062,
       0,     0,     0,     0,     0,     0,  1062,  1062,  1238,  1239,
       0,     0,     0,  1062,  1062,  1028,     0,     0,  1062,  1633,
       0,     0,     0,     0,  1062,  1062,     0,     0,  1062,     0,
       0,     0,     0,     0,   794,     0,  1257,     0,  1258,     0,
       0,     0,     0,  1866,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1867,  1868,  1869,     0,
    1870,  1871,  1872,  1873,  1874,  1875,  1633,  1028,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   794,     0,
       0,  1627,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1856,     0,     0,     0,  1857,
       0,  1851,     0,  1628,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1062,     0,     0,  1852,     0,     0,  1858,
    1859,     0,     0,     0,  1854,     0,     0,     0,     0,  1855,
       0,     0,  1860,     0,     0,     0,     0,     0,  1473,     0,
       0,  1475,     0,     0,  1477,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1062,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1861,     0,     0,  1862,  1062,
       0,     0,  1629,  1062,     0,     0,  1629,  1629,  1633,     0,
       0,     0,  1863,     0,  1864,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1564,     0,     0,     0,     0,
       0,  1062,     0,     0,     0,  1062,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1586,     0,     0,     0,  1062,  1062,  1588,     0,  1062,     0,
    1590,     0,     0,     0,     0,  1062,  1062,  1636,     0,     0,
       0,     0,     0,     0,     0,     0,  1856,  1865,     0,     0,
    1857,     0,     0,     0,     0,  1062,   794,     0,  1851,     0,
       0,     0,     0,     0,  1670,     0,     0,     0,     0,  1062,
    1858,  1859,     0,  1852,     0,     0,  2891,  1629,     0,     0,
       0,  1854,     0,  1860,  1627,     0,  1855,     0,  1627,  1627,
       0,     0,     0,     0,  1062,     0,     0,     0,  1629,     0,
       0,     0,     0,     0,     0,     0,  1628,     0,     0,     0,
    1628,  1628,     0,     0,     0,     0,  1861,     0,     0,  1862,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1739,
    1062,  1062,  1866,  1863,     0,  1864,     0,   794,     0,     0,
       0,     0,     0,  1768,     0,  1867,  1868,  1869,     0,  1870,
    1871,  1872,  1873,  1874,  1875,  1627,     0,  1062,  1062,     0,
    1062,     0,  1062,     0,     0,   794,     0,     0,     0,  1851,
       0,     0,     0,   794,     0,     0,     0,  1628,     0,     0,
       0,  1633,     0,  2258,  1852,  1633,  1633,     0,     0,     0,
       0,     0,  1854,     0,     0,     0,     0,  1855,  1865,     0,
     804,     0,     0,  1856,     0,     0,     0,  1857,     0,     0,
       0,     0,   805,     0,   938,     0,     0,     0,     0,     0,
       0,   938,     0,   938,     0,     0,     0,  1858,  1859,     0,
    1062,     0,   806,     0,     0,     0,     0,     0,     0,     0,
    1860,     0,     0,     0,     0,  2846,     0,     0,     0,     0,
       0,   807,  1633,  1629,  -512,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   808,  1861,     0,     0,  1862,     0,   809,     0,
       0,     0,     0,  1866,     0,     0,     0,     0,     0,     0,
    1863,  1062,  1864,   810,     0,     0,  1867,  1868,  1869,     0,
    1870,  1871,  1872,  1873,  1874,  1875,  1062,     0,     0,     0,
       0,     0,     0,     0,  1856,     0,     0,     0,  1857,     0,
       0,     0,     0,     0,  -665,     0,   811,     0,     0,     0,
     812,     0,     0,     0,     0,     0,     0,     0,  1858,  1859,
       0,     0,     0,     0,  -645,  1062,  1062,     0,     0,     0,
       0,  1860,     0,     0,     0,  1865,     0,     0,     0,  1062,
       0,     0,     0,     0,     0,     0,  2005,  -424,     0,     0,
       0,  1062,     0,     0,     0,     0,     0,     0,   813,     0,
       0,     0,     0,     0,  1861,     0,     0,  1862,     0,     0,
       0,     0,     0,  1851,     0,     0,     0,     0,     0,   794,
       0,  1863,     0,  1864,     0,  2258,     0,     0,  1852,     0,
       0,     0,     0,     0,  2860,     0,  1854,     0,     0,     0,
       0,  1855,     0,     0,   814,     0,   815,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1866,     0,     0,     0,     0,     0,     0,  -424,     0,     0,
       0,     0,     0,  1867,  1868,  1869,     0,  1870,  1871,  1872,
    1873,  1874,  1875,     0,     0,     0,  1865,     0,     0,   816,
       0,     0,     0,  -665,     0,   817,     0,     0,     0,     0,
       0,     0,     0,     0,  1629,  1629,     0,  1629,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1629,     0,  1629,     0,     0,     0,     0,     0,     0,   818,
     819,     0,   820,   821,     0,     0,     0,     0,     0,     0,
       0,   822,     0,  2896,     0,   823,   824,     0,     0,     0,
     825,  1629,     0,     0,     0,   826,     0,     0,  1856,     0,
       0,  2216,  1857,     0,  1632,     0,     0,     0,     0,     0,
       0,  1866,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1858,  1859,  1867,  1868,  1869,     0,  1870,  1871,
    1872,  1873,  1874,  1875,     0,  1860,     0,     0,     0,     0,
    1629,     0,     0,     0,  2269,     0,     0,     0,     0,     0,
       0,     0,     0,  2278,     0,  2280,     0,     0,     0,     0,
    2281,  1629,     0,   644,     0,     0,     0,     0,  1861,     0,
       0,  1862,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2296,   842,     0,  1863,     0,  1864,     0,     0,
       0,  1629,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1629,     0,     0,     0,
       0,     0,     0,   794,  1632,     0,     0,     0,     0,  1629,
       0,     0,   794,     0,     0,     0,     0,     0,     0,     0,
       0,  1851,     0,  1629,     0,     0,     0,     0,   902,     0,
       0,   794,     0,     0,     0,     0,  1852,     0,     0,  2900,
    1865,     0,     0,     0,  1854,     0,     0,     0,   644,  1855,
     902,  2258,     0,     0,     0,  2258,     0,     0,  1629,     0,
       0,     0,     0,     0,  1629,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   794,     0,
     794,     0,     0,     0,     0,   794,     0,     0,     0,     0,
       0,     0,     0,     0,  1057,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   794,  1629,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1866,     0,     0,  1059,     0,
    2479,     0,  1059,     0,     0,  1629,     0,     0,  1867,  1868,
    1869,     0,  1870,  1871,  1872,  1873,  1874,  1875,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1851,
       0,     0,  1629,     0,     0,  1059,  1856,     0,     0,     0,
    1857,     0,     0,     0,  1852,     0,     0,     0,     0,     0,
       0,     0,  1854,     0,     0,     0,     0,  1855,     0,     0,
    1858,  1859,     0,     0,     0,  1629,     0,     0,     0,     0,
       0,     0,     0,  1860,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1059,     0,     0,     0,     0,     0,  1059,
       0,     0,     0,     0,   794,   794,     0,     0,     0,     0,
       0,  1632,     0,     0,     0,     0,  1861,     0,     0,  1862,
       0,     0,     0,  1028,     0,  1851,     0,     0,     0,     0,
       0,     0,     0,  1863,     0,  1864,  2536,     0,     0,     0,
    1852,     0,     0,     0,  2543,  2059,     0,     0,  1854,     0,
    2547,     0,     0,  1855,     0,  2551,     0,     0,     0,  1632,
       0,  2557,     0,     0,     0,     0,  2559,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1856,  2573,     0,  2574,  1857,     0,
       0,     0,     0,  1629,  1059,     0,     0,     0,  1865,   938,
       0,     0,   938,     0,     0,     0,     0,     0,  1858,  1859,
    1632,     0,     0,     0,     0,     0,     0,     0,  2595,  2596,
    2597,  1860,     0,     0,     0,  1059,     0,  1632,     0,     0,
       0,     0,     0,     0,     0,  2612,  2613,  2616,  2617,     0,
       0,     0,  2623,  2626,  1632,     0,  2628,  2629,  2630,     0,
       0,     0,  2636,     0,  1861,     0,     0,  1862,     0,  2649,
       0,     0,  2651,     0,     0,     0,     0,     0,     0,  1632,
    1856,  1863,     0,  1864,  1857,     0,   794,     0,     0,     0,
       0,     0,     0,  1866,     0,     0,     0,     0,     0,     0,
       0,     0,  1629,     0,  1858,  1859,  1867,  1868,  1869,   794,
    1870,  1871,  1872,  1873,  1874,  1875,     0,  1860,     0,   794,
       0,     0,     0,     0,     0,     0,     0,  1632,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1992,  1632,     0,
       0,     0,     0,     0,     0,     0,  1865,     0,     0,     0,
    1861,     0,     0,  1862,     0,     0,     0,     0,     0,     0,
       0,  1059,     0,     0,     0,  2258,     0,  1863,  1059,  1864,
    2258,  3238,     0,  2258,  1059,     0,     0,     0,     0,     0,
       0,     0,     0, -1992,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1631, -1992,     0,     0,     0,
       0, -1992,     0,     0,     0,     0, -1992,     0,     0, -1992,
       0, -1992,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1059,     0,     0,     0,     0,     0,     0,     0,
    1028,  1866,  1865,     0,     0,     0, -1992,     0,     0,     0,
       0,     0,     0,     0,  1867,  1868,  1869,     0,  1870,  1871,
    1872,  1873,  1874,  1875, -1992,     0,  1629,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2830,     0,     0,     0,     0,     0,     0,     0,  1059,   794,
     794,   794,   794,     0,     0,     0,     0,     0,     0,     0,
       0,  1632,     0,     0,     0,     0,     0,     0, -1992,     0,
       0,     0,    73,  1629,     0,  1631, -1992,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1866,     0,     0,
       0,     0,     0,     0,     0,     0,  1059,     0,     0,     0,
    1867,  1868,  1869,     0,  1870,  1871,  1872,  1873,  1874,  1875,
       0,     0,     0,     0, -1992,     0,     0,     0,     0,     0,
       0,     0,     0,  1059,     0,     0,   644,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1059,  1059,     0,  1059,   916,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1059,     0,     0,     0,     0, -1992,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1057,     0,     0,     0,     0, -1992,     0,
       0,     0,     0,     0,     0,  1629,     0,     0,     0, -1994,
       0,   902,  2258,   902,     0,   902,     0,     0, -1992, -1992,
   -1992,   902,   902,     0,     0,     0,     0,     0,     0,     0,
       0,   899,     0,     0,     0,  3003,  3004,     0,     0,     0,
       0,     0,  1059,     0,     0,  1059,  1059, -1992,   644,     0,
   -1992, -1992, -1992,   899,     0, -1994,     0,     0,     0,     0,
       0,  2561,     0,     0,     0,  2059,  2568,     0, -1994,     0,
       0,     0,     0, -1994,     0,   644,     0,     0, -1994,     0,
       0, -1994,     0, -1994,     0,     0,   644,   644,     0,     0,
       0,     0,     0,     0,  1057,     0,     0,     0,     0,     0,
       0,     0,  1631,     0,     0,     0,     0,     0, -1994,     0,
     938,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3046,  3047,  3048,  3049,     0, -1994,     0,     0,   938,
       0,     0,     0,  1057,     0,   794,  1631,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1451,     0,     0,
    1631,     0,     0,     0,     0,  3062,   794,     0,     0,     0,
       0,   644,   644,     0,     0,  1451,  1632,     0,     0,  1057,
   -1994,     0,     0,     0,     0,     0,     0,   794, -1994,     0,
       0,     0,     0,     0,     0,     0,     0,  1632,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1631,     0,  3123,  3125,  3127,     0,     0,  1629,     0,
       0,     0,  1629,  1629,     0,     0, -1994,   794,  1631,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   842,     0,
       0,     0,     0,     0,     0,  1631,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3171,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   916,
    1631,     0,     0,   842,     0,     0,     0,     0,   644,  1057,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1629,
   -1994,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1994,     0,     0,  1059,     0,  1059,     0,     0,  1631,     0,
    1059,     0,     0,     0,     0,     0,     0,     0,     0,  1631,
   -1994, -1994, -1994,     0,     0,     0,     0,     0,     0,     0,
    1057,     0,     0,     0,     0,     0,     0,     0,     0,   644,
       0,     0,  1632,     0,     0,  1057,     0,     0,     0, -1994,
       0,     0, -1994, -1994, -1994,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1059,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1057,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1057,     0,
       0,     0,     0,     0,     0,     0,  1059,  1059,     0,     0,
    1057,     0,     0,     0,  1059,     0,     0,  1059,  1059,     0,
       0,  1059,     0,     0,     0,     0,     0,     0,     0,  1059,
    1059,     0,     0,     0,     0,     0,     0,  1059,     0,     0,
    1059,  1059,  1059,  1059,     0,     0,     0,     0,     0,     0,
    1059,  1059,     0,  1059,     0,  1059,     0,     0,  1059,     0,
       0,     0,     0,     0,   644,     0,     0,     0,     0,     0,
       0,     0,  1631,  1059,   644,     0,     0,  1059,     0,     0,
       0,  1059,     0,     0,     0,  1059,     0,     0,  1059,  1059,
    1059,  1059,  1059,  1059,  1059,  1059,  1059,     0,  1059,     0,
       0,     0,     0,  1059,     0,     0,     0,  1059,     0,     0,
       0,     0,     0,   644,     0,     0,  1451,     0,     0,     0,
    1451,  1451,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3358,     0,     0,     0,     0,  3365,     0,  3367,
    3368,  3369,  3370,     0,     0,     0,     0,     0,  1059,     0,
       0,     0,     0,  2059,  2568,     0,  2568,     0,     0,     0,
       0,     0,   644,     0,     0,     0,     0,     0,     0,  1632,
       0,  1632,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1632,     0,     0,     0,     0,     0,     0,  1451,     0,     0,
       0,  3410,     0,  1451,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1059,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1632,
       0,     0,  1631,     0,     0,     0,  1631,  1631,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2568,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3477,     0,  1451,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2568,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1632,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    73,  1632,     0,
       0,     0,     0,     0,   899,     0,   899,     0,   899,     0,
       0,     0,  2568,     0,   899,   899,     0,     0,     0,     0,
    1059,     0,     0,     0,     0,     0,     0,  1631,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   644,     0,     0,     0,  1059,  1632,  1631,     0,
       0,   902,     0,  1632,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3550,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3559,     0,  1632,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1059,     0,     0,  1632,     0,     0,     0,     0,     0,
       0,  1059,     0,     0,     0,     0,     0,     0,     0,     0,
    1447,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1632,     0,     0,     0,     0,     0,     0,  1447,     0,
       0,     0,     0,  1059,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   902,   902,     0,     0,     0,
       0,     0,   644,   902,  1632,     0,     0,   902,   902,  3618,
       0,     0,  1059,     0,     0,     0,  3171,     0,     0,     0,
       0,     0,   902,  1631,   902,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1059,  1059,     0,     0,   902,     0,   902,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1059,     0,     0,     0,  1059,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1059,  1059,
    1059,  1059,     0,     0,     0,     0,     0,     0,     0,     0,
    1059,     0,     0,     0,     0,  1059,     0,     0,     0,   644,
       0,     0,     0,     0,     0,  1059,  1059,     0,  1059,     0,
       0,     0,  1632,     0,     0,     0,     0,     0,     0,     0,
       0,  1059,     0,  1059,     0,     0,     0,  1059,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1059,     0,     0,    73,    73,     0,    73,
       0,     0,     0,  1059,     0,  1059,  1059,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1059,     0,     0,     0,
       0,  1451,  1059,     0,     0,   644,     0,     0,     0,  1451,
       0,  1059,  1059,  1059,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1632,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1059,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1631,  1631,     0,  1631,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1631,     0,  1631,     0,     0,     0,     0,     0,     0,  3769,
       0,     0,     0,     0,     0,     0,     0,   902,     0,     0,
       0,     0,     0,     0,     0,     0,  1451,     0,     0,  1451,
    1451,  1631,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1447,
       0,     0,     0,  1447,  1447,     0,     0,     0,  3799,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1631,     0,     0,     0,   644,     0,     0,     0,     0,     0,
       0,     0,   644,     0,     0,     0,   644,     0,     0,     0,
       0,  1631,     0,     0,     0,  1632,   902,     0,     0,     0,
       0,   902,     0,     0,     0,     0,  1992,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1631,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1631,     0,     0,     0,
       0,     0,  1632,     0,     0,     0,     0,     0,     0,  1631,
       0,     0,     0,     0,     0,   644,     0,     0,     0,     0,
    1447,     0,     0,  1631,     0,     0,  1447,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1059,
       0,     0,     0,  1059,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1059,     0,     0,     0,     0,  1631,     0,
       0,   644,     0,     0,  1631,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1059,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1447,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1059,     0,     0,  1631,     0,     0,     0,     0,
       0,     0,     0,  1059,     0,     0,     0,     0,     0,  1059,
       0,  1059,     0,     0,  1632,  1631,  1059,     0,     0,  1059,
    1059,  1059,  1059,  1059,  1059,  1059,  1059,  1059,  1059,     0,
       0,     0,     0,  1059,  1059,     0,     0,     0,     0,     0,
       0,     0,  1631,     0,     0,     0,     0,  1059,     0,     0,
       0,     0,     0,  1059,     0,     0,     0,     0,     0,     0,
       0,     0,  1059,     0,     0,  1059,     0,  1059,     0,     0,
       0,     0,     0,     0,   899,  1631,  1059,  1059,  1059,     0,
       0,     0,  1059,     0,     0,  1059,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1059,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    73,
       0,     0,     0,    73,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   902,     0,  1451,     0,  2301,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1631,     0,     0,     0,     0,   899,   899,
       0,     0,     0,     0,     0,     0,   899,     0,     0,     0,
     899,   899,     0,     0,     0,     0,     0,  1632,     0,     0,
       0,  1632,  1632,     0,     0,   899,     0,   899,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     902,     0,     0,     0,     0,     0,     0,   899,     0,   899,
       0,     0,     0,     0,     0,     0,     0,  1451,     0,     0,
       0,     0,     0,     0,  1451,  1451,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1059,     0,     0,     0,     0,     0,     0,  1632,     0,
       0,     0,  1631,     0,     0,     0,  2301,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1063,     0,
       0,     0,  1063,     0,     0,   644,     0,   644,   644,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   644,     0,     0,     0,     0,     0,  1451,     0,     0,
       0,     0,   902,  1059,   902,  1063,     0,     0,  1059,     0,
       0,  1059,     0,     0,     0,     0,  3119,   644,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1451,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   644,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1059,
       0,     0,     0,  1063,  1447,     0,     0,     0,     0,  1063,
       0,     0,  1447,     0,    73,     0,    73,   644,   644,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1059,     0,     0,     0,
       0,     0,     0,  1059,  1059,     0,     0,     0,     0,     0,
    1059,  1059,     0,     0,     0,  1059,  1631,     0,     0,     0,
       0,  1059,  1059,     0,     0,  1059,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     899,     0,     0,  1631,  1063,     0,     0,     0,     0,  1447,
       0,     0,  1447,  1447,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1063,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1059,     0,     0,     0,     0,     0,     0,   644,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   899,
       0,     0,     0,     0,   899,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1059,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1059,     0,     0,     0,
    1059,     0,     0,     0,     0,  1631,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1059,     0,
       0,  1063,  1059,     0,     0,     0,     0,     0,  1063,     0,
       0,     0,     0,     0,  1063,     0,     0,     0,     0,     0,
       0,  1059,  1059,     0,     0,  1059,     0,     0,     0,     0,
       0,     0,  1059,  1059,     0,  1634,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1059,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1063,     0,     0,     0,  1059,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   644,   644,
     644,   644,   644,   644,     0,     0,     0,     0,     0,     0,
       0,  1059,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   902,     0,
       0,     0,     0,   902,   902,   902,   902,   902,  1063,     0,
       0,   902,     0,     0,     0,     0,     0,  1059,  1059,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1634,     0,     0,     0,     0,
       0,     0,     0,     0,  1059,  1059,     0,  1059,     0,  1059,
       0,     0,     0,     0,     0,     0,  1063,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1631,   644,
       0,     0,  1631,  1631,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1063,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1063,  1063,     0,  1063,  1059,     0,     0,
       0,     0,     0,  2301,     0,   899,     0,  1447,     0,     0,
       0,     0,     0,  1063,     0,     0,     0,     0,     0,  1631,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1059,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1059,     0,     0,     0,     0,     0,     0,
       0,     0,  1063,     0,     0,  1063,  1063,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   644,     0,     0,
       0,     0,     0,   899,     0,     0,     0,   902,     0,     0,
       0,     0,  1059,  1059,     0,     0,     0,   902,   902,     0,
    1447,     0,   902,   902,     0,     0,  1059,  1447,  1447,     0,
       0,     0,   902,     0,     0,     0,     0,     0,  1059,     0,
       0,     0,  1634,     0,     0,     0,     0,     0,     0,   644,
     644,   644,     0,     0,     0,     0,     0,     0,     0,   644,
     644,     0,     0,     0,   644,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1634,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1634,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1447,     0,     0,   644,     0,   899,     0,   899,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3116,
       0,     0,     0,     0,     0,     0,     0,     0,   644,     0,
    1447,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1634,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1634,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1348,     0,     0,     0,  1634,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1634,     0,  1411,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     4,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1063,     0,  1063,     0,     0,  1634,   644,
    1063,     0,     0,     5,     0,     0,     0,     0,     0,  1634,
       0,     0,     0,     6,     7,     0,     0,     0,     0,     0,
       0,     9,    10,     0,     0,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,     0,
     644,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1063,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1571,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,     0,     0,     0,     0,  1063,  1063,     0,     0,
       0,     0,     0,     0,  1063,     0,     0,  1063,  1063,     0,
       0,  1063,     0,     0,     0,     0,     0,     0,     0,  1063,
    1063,     0,     0,     0,     0,     0,     0,  1063,     0,     0,
    1063,  1063,  1063,  1063,     0,     0,     0,     0,     0,     0,
    1063,  1063,     0,  1063,     0,  1063,     0,     0,  1063,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    36,
       0,     0,  1634,  1063,  3327,     0,     0,  1063,     0,     0,
       0,  1063,     0,    37,     0,  1063,     0,     0,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,     0,  1063,     0,
       0,     0,    38,  1063,     0,     0,     0,  1063,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1791,    40,     0,     0,    41,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1063,     0,
       0,     0,     0,     0,  1992,     0,     0,     0,     0,    42,
    1815,   899,     0,     0,     0,     0,   899,   899,   899,   899,
     899,     0,     0,     0,   899,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1839,  1840,     0,  1843,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1880,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,     0,
       0,     0,  1063,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1634,     0,     0,     0,  1634,  1634,     0,     0,
       0,     0,     0,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    45,     0,     0,  1956,
       0,     0,  1963,  1965,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,     0,     0,     0,     0,    48,
      49,     0,    50,     0,     0,     0,     0,     0,    52,    53,
      54,    55,     0,    56,    57,     0,     0,     0,    58,    59,
      60,    61,    62,     0,     0,    63,    64,  1216,     0,     0,
    1063,  1217,     0,     0,     0,    71,     0,  1634,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1063,     0,  1634,  2301,
       0,     0,     0,     0,     0,     0,     0,     0,    73,     0,
     899,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     899,   899,     0,     0,     0,   899,   899,     0,     0,     0,
       0,     0,     0,     0,     0,   899,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1063,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1063,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1063,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1063,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1634,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1063,  1063,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1063,     0,     0,     0,  1063,     0,     0,     0,
       0,     0,     0,     0,     0,  3670,     0,     0,  1063,  1063,
    1063,  1063,     0,     0,     0,     0,     0,     0,     0,     0,
    1063,     0,     0,     0,     0,  1063,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1063,  1063,     0,  1063,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1063,     0,  1063,     0,     0,     0,  1063,     0,     0,
       0,  2353,     0,     0,     0,  2355,     0,     0,     0,     0,
       0,     0,     0,  1063,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1063,  2377,  1063,  1063,  2379,     0,     0,
    2389,     0,     0,     0,     0,     0,     0,  2396,  2401,     0,
       0,     0,  2406,     0,     0,  2411,  1063,     0,     0,     0,
       0,     0,  1063,     0,     0,     0,     0,     0,     0,     0,
    2420,  1063,  1063,  1063,  2426,     0,     0,     0,  2438,     0,
       0,     0,  2445,     0,     0,  2447,  2448,  2449,  2450,  2451,
    2452,  2453,  2454,  2455,     0,  2456,     0,     0,     0,     0,
    1348,     0,     0,  1063,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1634,  1634,     0,  1634,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1634,     0,  1634,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1411,     0,     0,     0,     0,
       0,  1634,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1634,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1634,     0,     0,     0,     0,     0,     0,     0,  2549,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1634,     0,     0,  1877,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1634,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1634,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1634,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1063,
       0,     0,     0,  1063,     0,     0,     0,  1877,     0,     0,
       0,     0,     0,  1063,     0,     0,     0,     0,  1634,     0,
       0,     0,     0,     0,  1634,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2657,     0,     0,
       0,     0,  1063,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2681,     0,     0,     0,     0,     0,     0,
       0,     0,  1063,     0,     0,  1634,     0,     0,     0,     0,
       0,     0,     0,  1063,     0,     0,     0,     0,     0,  1063,
       0,  1063,     0,     0,     0,  1634,  1063,     0,     0,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,     0,
       0,     0,     0,  1063,  1063,     0,     0,     0,     0,     0,
       0,     0,  1634,     0,     0,     0,     0,  1063,     0,     0,
       0,     0,     0,  1063,     0,     0,     0,     0,     0,     0,
       0,     0,  1063,     0,     0,  1063,     0,  1063,  2784,     0,
       0,     0,     0,     0,     0,  1634,  1063,  1063,  1063,     0,
       0,     0,  1063,     0,     0,  1063,     0,  1877,     0,     0,
       0,     0,     0,     0,     0,  1063,     0,     0,     0,     0,
    2801,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     4,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1348,
       0,     0,     0,     0,     0,     0,     0,     0,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     7,
       0,     0,     0,     0,     8,     0,     9,    10,  2840,     0,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1634,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2401,     0,  2401,  2401,     0,
       0,     0,     0,     0,     0,     0,     0,  2903,     0,     0,
       0,     0,  2907,     0,     0,     0,    35,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1877,     0,     0,     0,     0,     0,     0,     0,  2928,     0,
    2930,     0,     0,     0,  2933,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1063,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1634,     0,    36,     0,     0,     0,     0,     0,
       0,     0,     0,  1411,     0,     0,     0,  1877,    37,  1956,
       0,     0,     0,     0,     0,     0,     0,     0,  1965,  1965,
    1963,     0,     0,     0,     0,     0,     0,    38,     0,     0,
       0,  1877,     0,     0,     0,     0,  2385,     0,     0,     0,
       0,     0,     0,  1063,     0,     0,     0,    39,  1063,     0,
    3006,  1063,     0,     0,     0,  1877,  1877,     0,     0,  1877,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    40,
       0,     0,    41,     0,     0,     0,     0,     0,     0,  1063,
       0,     0,     0,     0,     0,     0,  1877,     0,     0,     0,
       0,     0,     0,     0,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1063,     0,     0,     0,
       0,     0,     0,  1063,  1063,     0,     0,     0,     0,     0,
    1063,  1063,     0,     0,     0,  1063,  1634,     0,     0,     0,
       0,  1063,  1063,     0,     0,  1063,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      43,     0,  1877,     0,     0,     0,     0,     0,     0,  1877,
       0,  1877,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1634,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
    1063,     0,     0,     0,    48,    49,     0,    50,     0,    51,
       0,     0,     0,    52,    53,    54,    55,     0,    56,    57,
       0,     0,     0,    58,    59,    60,    61,    62,     0,     0,
      63,    64,    65,    66,     0,    67,    68,    69,     0,    70,
      71,  1063,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1063,     0,     0,     0,
    1063,     0,     0,     0,     0,  1634,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1063,  3239,
       0,     0,  1063,     0,     0,     0,     0,     0,     0,     0,
    3243,     0,     0,     0,     0,     0,  3244,     0,  3245,     0,
       0,  1063,  1063,     0,     0,  1063,     0,     0,     0,     0,
       0,     0,  1063,  1063,     0,     0,     0,     0,     0,     0,
    3263,  3264,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1063,     0,     0,     0,     0,     0,     0,     0,
    2406,     0,     0,     0,     0,     0,  1063,     0,     0,  3288,
       0,     0,  3291,     0,  3293,     0,     0,     0,     0,     0,
       0,     0,     0,  3297,     0,     0,     0,     0,     0,  3302,
       0,  1063,  3305,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3312,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1063,  1063,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1063,  1063,     0,  1063,     0,  1063,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1634,     0,
       0,     0,  1634,  1634,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1877,
       0,  1877,     0,     0,     0,     0,     0,  1063,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1877,     0,  1877,     0,  2385,  2878,  1634,
       0,  2385,     0,     0,     0,  1877,     0,     0,     0,     0,
       0,     0,  1877,     0,     0,     0,     0,  1877,     0,     0,
       0,     0,  1877,     0,     0,     0,     0,  1877,     0,     0,
       0,     0,     0,     0,     0,     0,  1877,     0,  1063,     0,
    2385,  2385,  1877,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1063,  1877,     0,     0,     0,     0,     0,
       0,  1877,     0,  1877,  1877,  1877,  1877,  1877,  1877,  1877,
    1877,  1877,  1877,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1063,  1063,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1063,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1063,     0,
       0,     0,     0,     4,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     5,     0,  3492,     0,     0,     0,
       0,     0,     0,     0,     6,     7,     0,     0,     0,     0,
       0,     0,     9,    10,     0,  1877,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
    3509,  3511,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3517,     0,     0,     0,     0,     0,  3522,  3523,
       0,     0,  3525,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1877,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1877,     0,     0,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,     0,     0,  3594,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    38,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    39,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3638,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    40,     0,     0,    41,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1877,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      42,     0,     0,     0,     0,     0,     0,  1877,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3667,     0,     0,     0,     0,     0,     0,     0,
    3669,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1877,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3684,     0,     0,    43,     0,     0,  2878,
       0,  2385,     0,     0,  2385,  2385,  2385,  2385,  2385,  2385,
    2385,  2385,  2385,  2385,     0,  2878,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    44,     0,     0,     0,  1877,
       0,     0,     0,  1877,     0,     0,     0,    45,  2878,  2878,
       0,     0,     0,     0,     0,  3724,     0,     0,     0,     0,
      46,     0,  2385,  2385,  1877,     0,  1877,     0,     0,  1877,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,  2406,     0,     0,     0,     0,     0,
      48,    49,     0,    50,     0,     0,     0,     0,     0,    52,
      53,    54,    55,     0,    56,    57,     0,     0,     0,    58,
      59,    60,    61,    62,     0,     0,    63,    64,  1216,  1718,
       4,     0,     0,     0,     0,     0,    71,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,  1877,     0,     0,     0,     0,     0,     0,     0,
       0,     6,     7,     0,     0,     0,     0,     0,     0,     9,
      10,     0,     0,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2385,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      38,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      39,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1877,     0,     0,     0,  1877,
    1877,  1877,    40,     0,  2878,    41,     0,     0,     0,  2878,
    2878,  2878,  2878,  2878,  2878,  2878,  2878,  2878,  2878,  1877,
    1877,     0,     0,     0,     0,     0,     0,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1877,  2385,  2385,  1877,     0,  1877,
       0,     0,     0,  1877,  2878,  2878,     0,     0,  1877,     0,
       0,  1877,     0,     0,     0,     0,     0,     0,  1877,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    45,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2878,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,     0,     0,     0,     0,    48,    49,     0,
      50,     0,     0,     0,     0,     0,    52,    53,    54,    55,
       0,    56,    57,     0,     0,     0,    58,    59,    60,    61,
      62,     0,     0,    63,    64,  1216,  2288,     0,     0,     0,
       0,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1877,     0,
       0,     0,     0,  2385,     0,     0,     0,  2385,     0,     0,
       0,     0,     0,     0,     0,  1877,     0,  1877,     0,     0,
       0,  2878,  2878,  1877,     0,     0,  2385,  2385,  1877,  1877,
       0,  1877,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1877,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1877,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2878,  2385,
    2385,  2878,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2878,  2878,  1877,     0,  1877,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1877,     0,     0,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,     0,   110,   111,   112,
    1877,   113,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,  2878,  2878,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,   670,
     407,   408,   409,   671,   672,   673,   674,   675,   676,   677,
     410,   411,   678,   412,   130,   413,   414,   415,   132,   133,
     134,   135,     0,   679,   416,   417,     0,   418,   419,   680,
     681,   420,   682,   136,   422,   683,   423,   424,   425,   426,
     140,   684,   685,   427,   428,   429,   430,   431,   432,   686,
     433,   434,   435,   143,   436,   437,   687,   438,   439,   440,
     146,   441,   688,   689,   690,   691,   692,   693,   442,   443,
     444,   445,   446,   149,   150,   447,   694,   448,   695,   449,
       0,   450,   451,   452,   696,   453,   454,   455,   697,   698,
     456,   457,   458,   459,   460,   699,   461,   462,   463,   700,
       0,   464,   701,   465,   466,   467,   158,   468,   469,   160,
     702,   470,   471,   472,   162,   703,   473,   704,   474,   163,
     705,   164,   475,     0,   476,   706,   477,   167,   707,   478,
     708,   479,   480,   481,   482,   168,   483,   484,   485,   709,
     486,   487,   488,   489,   490,   491,   710,   169,   170,   711,
     492,   493,   494,   712,   172,   713,   173,   714,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,   715,   177,
     178,   501,   179,   716,   502,   503,   504,     0,     0,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   184,   185,   186,   717,   518,   519,   520,   521,
     522,   523,   524,   187,   525,   718,   526,   527,   189,   528,
     719,   190,   529,   191,   530,   531,   720,   721,   532,   722,
     723,   724,   533,   534,   725,   726,   192,   193,   194,   195,
     535,   536,   537,   538,   539,     0,   540,   196,   197,   541,
     542,   543,   727,   544,   545,   546,   547,   548,   549,   199,
     550,   551,   728,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,   729,   562,   563,   205,   564,   565,   207,
     566,   567,   568,   569,   570,   571,   572,     0,   730,   573,
     574,   575,   731,   576,   211,   577,   578,   213,   579,   214,
     732,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   216,   590,   733,   591,   592,   734,   593,   594,   595,
     596,   597,   735,   217,   218,   736,   737,   599,   219,   600,
     220,   738,   601,   602,   603,   604,   605,   739,   740,   606,
     607,   608,   609,   741,   742,   610,   611,   612,   613,     0,
     228,   615,   229,   616,   617,   618,   743,   744,   619,   620,
     621,   622,   623,   624,   230,   231,   232,   233,   234,   235,
     236,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,     0,     0,     0,    83,    84,    85,
       0,    87,    88,    89,    90,    91,     0,     0,     0,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
       0,     0,   877,   105,   106,   107,   108,     0,   109,     0,
     110,   111,   112,     0,   113,   114,   115,     0,     0,     0,
       0,     0,   118,   119,     0,     0,     0,     0,   120,     0,
       0,     0,     0,     0,     0,     0,     0,   121,     0,   122,
       0,   123,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   130,     0,     0,
       0,   132,   133,   134,   135,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   136,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   143,     0,     0,     0,
       0,     0,     0,   146,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   149,   150,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   156,     0,     0,     0,     0,     0,   158,
       0,     0,   160,     0,     0,     0,     0,   162,     0,     0,
       0,     0,   163,     0,   164,     0,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,     0,     0,   168,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     169,   170,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,   174,   175,     0,   176,     0,     0,     0,     0,
       0,     0,   177,   178,     0,   179,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   184,   185,   186,     0,     0,
       0,     0,     0,     0,     0,     0,   187,     0,     0,     0,
       0,   189,     0,     0,   190,     0,   191,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   192,
     193,   194,   195,     0,     0,     0,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   199,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
       0,     0,   207,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   211,     0,     0,
     213,     0,   214,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   216,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   217,   218,     0,     0,
       0,   219,     0,   220,     0,     0,     0,     0,     0,     0,
     223,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   228,     0,   229,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   230,   231,   232,
     233,   234,   235,   236,   237,     0,     0,     0,     0,     0,
       0,     0,     0,   238,     0,     0,   239,     0,     0,     0,
       0,    83,    84,    85,     0,    87,    88,    89,    90,    91,
       0,     0,     0,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,     0,     0,  2516,   105,   106,   107,
     108,     0,   109,     0,   110,   111,   112,     0,   113,   114,
     115,     0,     0,     0,     0,     0,   118,   119,     0,     0,
       0,     0,   120,     0,     0,     0,     0,     0,     0,     0,
       0,   121,     0,   122,     0,   123,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   130,     0,     0,     0,   132,   133,   134,   135,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     136,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     143,     0,     0,     0,     0,     0,     0,   146,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     149,   150,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   156,     0,     0,
       0,     0,     0,   158,     0,     0,   160,     0,     0,     0,
       0,   162,     0,     0,     0,     0,   163,     0,   164,     0,
       0,     0,     0,     0,   167,     0,     0,     0,     0,     0,
       0,     0,   168,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   169,   170,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,   174,   175,     0,   176,
       0,     0,     0,     0,     0,     0,   177,   178,     0,   179,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   184,
     185,   186,     0,     0,     0,     0,     0,     0,     0,     0,
     187,     0,     0,     0,     0,   189,     0,     0,   190,     0,
     191,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   192,   193,   194,   195,     0,     0,     0,
       0,     0,     0,     0,   196,   197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   199,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   205,     0,     0,   207,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   211,     0,     0,   213,     0,   214,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   216,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     217,   218,     0,     0,     0,   219,     0,   220,     0,     0,
       0,     0,     0,     0,   223,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   228,     0,   229,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   230,   231,   232,   233,   234,   235,   236,   237,     0,
       0,     0,     0,     0,     0,     0,     0,   238,     0,     0,
     239,     0,    82,     0,     0,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,     0,    93,    94,    95,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   104,     0,
    2518,   105,   106,   107,   108,     0,   109,     0,   110,   111,
     112,     0,   113,   114,   115,   116,   117,     0,     0,     0,
     118,   119,     0,     0,     0,     0,   120,     0,     0,     0,
       0,     0,     0,     0,     0,   121,     0,   122,     0,   123,
     124,     0,   125,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   126,     0,   127,   128,     0,     0,     0,     0,
       0,     0,     0,     0,   129,   130,     0,     0,   131,   132,
     133,   134,   135,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   136,     0,     0,   137,     0,   138,
     139,   140,     0,     0,   141,   142,     0,     0,     0,     0,
       0,     0,     0,     0,   143,   144,     0,   145,     0,     0,
       0,   146,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   147,     0,   148,   149,   150,   151,     0,     0,     0,
       0,     0,   152,     0,     0,     0,     0,     0,   153,     0,
       0,     0,     0,     0,   154,     0,     0,     0,     0,     0,
     155,   156,     0,     0,     0,     0,   157,   158,   159,     0,
     160,     0,     0,   161,     0,   162,     0,     0,     0,     0,
     163,     0,   164,     0,   165,     0,   166,     0,   167,     0,
       0,     0,     0,     0,     0,     0,   168,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   169,   170,
       0,     0,   171,     0,     0,   172,     0,   173,     0,     0,
     174,   175,     0,   176,     0,     0,     0,     0,     0,     0,
     177,   178,     0,   179,     0,   180,   181,     0,     0,     0,
       0,   182,     0,     0,     0,     0,     0,     0,     0,     0,
     183,     0,     0,   184,   185,   186,     0,     0,     0,     0,
       0,     0,     0,     0,   187,     0,     0,     0,   188,   189,
       0,     0,   190,     0,   191,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   192,   193,   194,
     195,     0,     0,     0,     0,     0,     0,     0,   196,   197,
       0,   198,     0,     0,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,   203,     0,     0,     0,     0,   204,   205,     0,   206,
     207,     0,     0,   208,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   210,   211,     0,   212,   213,     0,
     214,     0,     0,     0,   215,     0,     0,     0,     0,     0,
       0,     0,   216,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   217,   218,     0,     0,     0,   219,
       0,   220,     0,   221,     0,   222,     0,     0,   223,     0,
       0,   224,     0,   225,     0,     0,   226,     0,     0,     0,
     227,   228,     0,   229,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   230,   231,   232,   233,   234,
     235,   236,   237,     0,     0,     0,     0,     0,     0,     0,
       0,   238,     0,     0,   239,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   663,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,   240,
      96,    97,    98,    99,   100,   101,   664,   102,   103,   389,
     665,     0,   105,   106,   107,   108,   666,   667,     0,   110,
     111,   112,     0,   113,   668,   669,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,  2474,   407,   408,   409,     0,     0,     0,     0,  1271,
       0,     0,   410,   411,     0,   412,   130,   413,   414,   415,
     132,  1272,   134,  1273,  1274,     0,   416,   417,     0,   418,
     419,  1275,  1276,   420,  1277,  1278,   422,     0,   423,   424,
     425,   426,  1279,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,  1280,   436,   437,     0,   438,
     439,   440,   146,   441,     0,  1281,  1282,  1283,  1284,  1285,
     442,   443,   444,   445,   446,  1286,  1287,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
    2475,     0,   456,   457,  1288,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,  1289,   468,
     469,  1290,  1291,   470,   471,   472,  1292,     0,   473,     0,
     474,   163,     0,   164,   475,     0,   476,     0,   477,  1293,
       0,   478,     0,   479,   480,   481,   482,   168,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,   169,
     170,     0,   492,   493,   494,  1294,  1295,     0,  1296,     0,
       0,   174,   175,   495,   176,   496,   497,   498,   499,   500,
       0,  1297,   178,   501,   179,     0,   502,   503,   504,  1298,
    1299,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,  1300,   185,  1301,   792,   518,   519,
     520,   521,   522,   523,   524,   187,   525,  1302,   526,   527,
     189,   528,  1303,  1304,   529,  1305,   530,   531,     0,     0,
     532,   793,     0,     0,  1306,   534,     0,     0,   192,   193,
     194,  1307,   535,   536,   537,   538,   539,     0,   540,  1308,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,  1309,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,   205,   564,
     565,  1310,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,  1311,   576,   211,   577,   578,   213,
     579,  1312,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,  1313,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,  1314,  1315,     0,     0,   599,
    1316,   600,  1317,  1318,   601,   602,   603,   604,   605,     0,
    1319,   606,   607,   608,   609,  1320,     0,   610,   611,   612,
     613,   614,  1321,   615,   229,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,  1322,  1323,  1324,
    1325,  1326,  1327,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,    49,  1328,   239,   628,     0,     0,  1329,
    1330,    52,    53,    54,    55,  1331,    56,     0,     0,     0,
       0,  1332,  1333,  2476,     0,     0,     0,     0,     0,     0,
    1335,  2477,   663,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,   664,   102,   103,   389,   665,     0,   105,
     106,   107,   108,   666,   667,     0,   110,   111,   112,     0,
     113,   668,   669,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,  1271,     0,     0,   410,
     411,     0,   412,   130,   413,   414,   415,   132,  1272,   134,
    1273,  1274,     0,   416,   417,     0,   418,   419,  1275,  1276,
     420,  1277,  1278,   422,     0,   423,   424,   425,   426,  1279,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,  1280,   436,   437,     0,   438,   439,   440,   146,
     441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,   444,
     445,   446,  1286,  1287,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,  1288,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,  1289,   468,   469,  1290,  1291,
     470,   471,   472,  1292,     0,   473,     0,   474,   163,     0,
     164,   475,     0,   476,     0,   477,  1293,     0,   478,     0,
     479,   480,   481,   482,   168,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,   169,   170,     0,   492,
     493,   494,  1294,  1295,     0,  1296,     0,     0,   174,   175,
     495,   176,   496,   497,   498,   499,   500,     0,  1297,   178,
     501,   179,     0,   502,   503,   504,  1298,  1299,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,  1300,   185,  1301,   792,   518,   519,   520,   521,   522,
     523,   524,   187,   525,  1302,   526,   527,   189,   528,  1303,
    1304,   529,  1305,   530,   531,     0,     0,   532,   793,     0,
       0,  1306,   534,     0,     0,   192,   193,   194,  1307,   535,
     536,   537,   538,   539,     0,   540,  1308,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,  1309,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,   205,   564,   565,  1310,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,  1311,   576,   211,   577,   578,   213,   579,  1312,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
    1313,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,  1314,  1315,     0,     0,   599,  1316,   600,  1317,
    1318,   601,   602,   603,   604,   605,     0,  1319,   606,   607,
     608,   609,  1320,     0,   610,   611,   612,   613,   614,  1321,
     615,   229,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,  1327,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
      49,  1328,   239,   628,     0,     0,  1329,  1330,    52,    53,
      54,    55,  1331,    56,     0,     0,     0,     0,  1332,  1333,
       0,     0,     0,     0,     0,     0,     0,  1335,  2387,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,     0,   110,   111,   112,     0,   113,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
     130,   413,   414,   415,   132,  1601,   134,  1602,  1274,     0,
     416,   417,     0,   418,   419,     0,     0,   420,  1603,  1604,
     422,     0,   423,   424,   425,   426,     0,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,     0,
     436,   437,     0,   438,   439,   440,   146,   441,     0,     0,
       0,     0,     0,     0,   442,   443,   444,   445,   446,  1605,
    1606,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,  1288,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,     0,   468,   469,     0,     0,   470,   471,   472,
    1607,     0,   473,     0,   474,   163,     0,   164,   475,     0,
     476,     0,   477,     0,     0,   478,     0,   479,   480,   481,
     482,   168,   483,   484,   485,  2048,   486,   487,   488,   489,
     490,   491,     0,   169,  2049,     0,   492,   493,   494,  1294,
    1608,     0,  1609,     0,     0,   174,   175,   495,   176,   496,
     497,   498,   499,   500,     0,     0,   178,   501,   179,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,  1610,   185,
    1611,     0,   518,   519,   520,   521,   522,   523,   524,     0,
     525,     0,   526,   527,   189,   528,     0,     0,   529,  1612,
     530,   531,     0,     0,   532,     0,     0,     0,   533,   534,
       0,     0,  2050,   193,   194,     0,   535,   536,   537,   538,
     539,     0,   540,     0,     0,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,  1613,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,   205,   564,   565,     0,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,     0,   576,
    2051,   577,   578,   213,   579,  1615,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,     0,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,  1616,
    1617,     0,     0,   599,     0,   600,     0,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,     0,
       0,   610,   611,   612,   613,     0,  1618,   615,   229,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
       0,     0,     0,     0,     0,     0,     0,     0,   625,   626,
     627,     0,     0,     0,     0,     0,   238,     0,     0,   239,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   389,     0,  2052,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
       0,   413,   414,   415,     0,   133,     0,   135,     0,     0,
     416,   417,     0,   418,   419,     0,     0,   420,   421,   136,
     422,     0,   423,   424,   425,   426,   140,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   143,
     436,   437,     0,   438,   439,   440,     0,   441,     0,     0,
       0,     0,     0,     0,   442,   443,   444,   445,   446,   149,
     150,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,   458,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,   158,   468,   469,   160,     0,   470,   471,   472,
     162,     0,   473,     0,   474,     0,     0,     0,   475,     0,
     476,     0,   477,   167,     0,   478,     0,   479,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,     0,   170,     0,   492,   493,   494,     0,
     172,     0,   173,     0,     0,     0,     0,   495,     0,   496,
     497,   498,   499,   500,     0,   177,     0,   501,     0,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   184,     0,
     186,     0,   518,   519,   520,   521,   522,   523,   524,   187,
     525,     0,   526,   527,     0,   528,     0,   190,   529,   191,
     530,   531,     0,     0,   532,     0,     0,     0,   533,   534,
       0,     0,   192,     0,     0,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,   199,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,     0,   564,   565,   207,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,     0,   576,
     211,   577,   578,     0,   579,   214,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,   217,
     218,     0,     0,   599,   219,   600,   220,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,     0,
    3727,   610,   611,   612,   613,   614,   228,   615,     0,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,     0,     0,   239,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1417,     0,     0,     0, -1417,   663,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,   664,   102,
     103,   389,   665,     0,   105,   106,   107,   108,   666,   667,
       0,   110,   111,   112,     0,   113,   668,   669,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,  1271,     0,     0,   410,   411,     0,   412,   130,   413,
     414,   415,   132,  1272,   134,  1273,  1274,  2397,   416,   417,
       0,   418,   419,  1275,  1276,   420,  1277,  1278,   422,     0,
     423,   424,   425,   426,  1279,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,  1280,   436,   437,
       0,   438,   439,   440,   146,   441,     0,  1281,  1282,  1283,
    1284,  1285,   442,   443,   444,   445,   446,  1286,  1287,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,  1288,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
    1289,   468,   469,  1290,  1291,   470,   471,   472,  1292,     0,
     473,     0,   474,   163,  2398,   164,   475,     0,   476,     0,
     477,  1293,     0,   478,     0,   479,   480,   481,   482,   168,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,   169,   170,     0,   492,   493,   494,  1294,  1295,     0,
    1296,     0,     0,   174,   175,   495,   176,   496,   497,   498,
     499,   500,  2399,  1297,   178,   501,   179,     0,   502,   503,
     504,  1298,  1299,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,  1300,   185,  1301,   792,
     518,   519,   520,   521,   522,   523,   524,   187,   525,  1302,
     526,   527,   189,   528,  1303,  1304,   529,  1305,   530,   531,
       0,     0,   532,   793,     0,     0,  1306,   534,     0,     0,
     192,   193,   194,  1307,   535,   536,   537,   538,   539,     0,
     540,  1308,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,  1309,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
     205,   564,   565,  1310,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,  1311,   576,   211,   577,
     578,   213,   579,  1312,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,  1313,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,  1314,  1315,     0,
    2400,   599,  1316,   600,  1317,  1318,   601,   602,   603,   604,
     605,     0,  1319,   606,   607,   608,   609,  1320,     0,   610,
     611,   612,   613,   614,  1321,   615,   229,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,  1322,
    1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,    49,  1328,   239,   628,     0,
       0,  1329,  1330,    52,    53,    54,    55,  1331,    56,     0,
       0,     0,     0,  1332,  1333,     0,     0,     0,     0,     0,
       0,     0,  1335,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,     0,   110,   111,   112,
       0,   113,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,  1271,     0,     0,
     410,   411,     0,   412,   130,   413,   414,   415,   132,  1272,
     134,  1273,  1274,     0,   416,   417,     0,   418,   419,  1275,
    1276,   420,  1277,  1278,   422,     0,   423,   424,   425,   426,
    1279,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,  1280,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,  1286,  1287,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,  1289,   468,   469,  1290,
    1291,   470,   471,   472,  1292,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,  1294,  1295,     0,  1296,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1300,   185,  1301,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,  1302,   526,   527,   189,   528,
    1303,  1304,   529,  1305,   530,   531,     0,     0,   532,   793,
       0,     0,  1306,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1309,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,  1310,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,  1312,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1314,  1315,     0,     0,   599,  1316,   600,
    1317,  1318,   601,   602,   603,   604,   605,     0,  1319,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
    1321,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,    49,  1328,   239,   628,     0,     0,  1329,  1330,    52,
      53,    54,    55,  1331,    56,     0,     0,     0,     0,  1332,
    1333,  1334,     0,     0,     0,     0,     0,     0,  1335,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,     0,   110,   111,   112,     0,   113,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,  1271,     0,     0,   410,   411,     0,   412,
     130,   413,   414,   415,   132,  1272,   134,  1273,  1274,     0,
     416,   417,     0,   418,   419,  1275,  1276,   420,  1277,  1278,
     422,     0,   423,   424,   425,   426,  1279,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,  1280,
     436,   437,     0,   438,   439,   440,   146,   441,     0,  1281,
    1282,  1283,  1284,  1285,   442,   443,   444,   445,   446,  1286,
    1287,   447,  1410,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,  1288,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,  1289,   468,   469,  1290,  1291,   470,   471,   472,
    1292,     0,   473,     0,   474,   163,     0,   164,   475,     0,
     476,     0,   477,  1293,     0,   478,     0,   479,   480,   481,
     482,   168,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,   169,   170,     0,   492,   493,   494,  1294,
    1295,     0,  1296,     0,     0,   174,   175,   495,   176,   496,
     497,   498,   499,   500,     0,  1297,   178,   501,   179,     0,
     502,   503,   504,  1298,  1299,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,  1300,   185,
    1301,   792,   518,   519,   520,   521,   522,   523,   524,   187,
     525,  1302,   526,   527,   189,   528,  1303,  1304,   529,  1305,
     530,   531,     0,     0,   532,   793,     0,     0,  1306,   534,
       0,     0,   192,   193,   194,  1307,   535,   536,   537,   538,
     539,     0,   540,  1308,   197,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,  1309,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,   205,   564,   565,  1310,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,  1311,   576,
     211,   577,   578,   213,   579,  1312,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,  1313,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,  1314,
    1315,     0,     0,   599,  1316,   600,  1317,  1318,   601,   602,
     603,   604,   605,     0,  1319,   606,   607,   608,   609,  1320,
       0,   610,   611,   612,   613,   614,  1321,   615,   229,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,  1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,    49,  1328,   239,
     628,     0,     0,  1329,  1330,    52,    53,    54,    55,  1331,
      56,     0,     0,     0,     0,  1332,  1333,     0,     0,     0,
       0,     0,     0,     0,  1335,   663,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,     0,
      96,    97,    98,    99,   100,   101,   664,   102,   103,   389,
     665,     0,   105,   106,   107,   108,   666,   667,     0,   110,
     111,   112,     0,   113,   668,   669,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,     0,   407,   408,   409,     0,     0,     0,     0,  1271,
       0,     0,   410,   411,     0,   412,   130,   413,   414,   415,
     132,  1272,   134,  1273,  1274,     0,   416,   417,     0,   418,
     419,  1275,  1276,   420,  1277,  1278,   422,     0,   423,   424,
     425,   426,  1279,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,  1280,   436,   437,     0,   438,
     439,   440,   146,   441,     0,  1281,  1282,  1283,  1284,  1285,
     442,   443,   444,   445,   446,  1286,  1287,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,  1288,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,  1289,   468,
     469,  1290,  1291,   470,   471,   472,  1292,     0,   473,     0,
     474,   163,     0,   164,   475,     0,   476,     0,   477,  1293,
       0,   478,     0,   479,   480,   481,   482,   168,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,   169,
     170,     0,   492,   493,   494,  1294,  1295,     0,  1296,     0,
       0,   174,   175,   495,   176,   496,   497,   498,   499,   500,
       0,  1297,   178,   501,   179,     0,   502,   503,   504,  1298,
    1299,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,  1300,   185,  1301,   792,   518,   519,
     520,   521,   522,   523,   524,   187,   525,  1302,   526,   527,
     189,   528,  1303,  1304,   529,  1305,   530,   531,     0,     0,
     532,   793,     0,     0,  1306,   534,     0,     0,   192,   193,
     194,  1307,   535,   536,   537,   538,   539,     0,   540,  1308,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,  1309,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,   205,   564,
     565,  1310,   566,   567,   568,   569,   570,   571,   572,     0,
     209,   573,   574,   575,  1311,   576,   211,   577,   578,   213,
     579,  1312,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,  1313,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,  1314,  1315,     0,     0,   599,
    1316,   600,  1317,  1318,   601,   602,   603,   604,   605,     0,
    1319,   606,   607,   608,   609,  1320,     0,   610,   611,   612,
     613,  1841,  1321,   615,   229,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,  1322,  1323,  1324,
    1325,  1326,  1327,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,    49,  1328,   239,   628,     0,     0,  1329,
    1330,    52,    53,    54,    55,  1331,    56,     0,     0,     0,
       0,  1332,  1333,     0,     0,     0,     0,     0,     0,     0,
    1335,   663,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,   664,   102,   103,   389,   665,     0,   105,   106,
     107,   108,   666,   667,     0,   110,   111,   112,     0,   113,
     668,   669,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,  1961,   407,   408,
     409,     0,     0,     0,     0,  1271,     0,     0,   410,   411,
       0,   412,   130,   413,   414,   415,   132,  1272,   134,  1273,
    1274,     0,   416,   417,     0,   418,   419,  1275,  1276,   420,
    1277,  1278,   422,     0,   423,   424,   425,   426,  1279,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,  1280,   436,   437,     0,   438,   439,   440,   146,   441,
       0,  1281,  1282,  1283,  1284,  1285,   442,   443,   444,   445,
     446,  1286,  1287,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
    1288,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,  1289,   468,   469,  1290,  1291,   470,
     471,   472,  1292,     0,   473,     0,   474,   163,     0,   164,
     475,     0,   476,     0,   477,  1293,     0,   478,     0,   479,
     480,   481,   482,   168,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,   169,   170,     0,   492,   493,
     494,  1294,  1295,     0,  1296,     0,     0,   174,   175,   495,
     176,   496,   497,   498,   499,   500,     0,  1297,   178,   501,
     179,     0,   502,   503,   504,  1298,  1299,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
    1300,   185,  1301,   792,   518,   519,   520,   521,   522,   523,
     524,   187,   525,  1302,   526,   527,   189,   528,  1303,  1304,
     529,  1305,   530,   531,     0,     0,   532,   793,     0,     0,
    1306,   534,     0,     0,   192,   193,   194,  1307,   535,   536,
     537,   538,   539,     0,   540,  1308,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,  1309,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,   205,   564,   565,  1310,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
    1311,   576,   211,   577,   578,   213,   579,  1312,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,  1313,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,  1314,  1315,     0,     0,   599,  1316,   600,  1317,  1318,
     601,   602,   603,   604,   605,     0,  1319,   606,   607,   608,
     609,  1320,     0,   610,   611,   612,   613,   614,  1321,   615,
     229,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,  1322,  1323,  1324,  1325,  1326,  1327,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,    49,
    1328,   239,   628,     0,     0,  1329,  1330,    52,    53,    54,
      55,  1331,    56,     0,     0,     0,     0,  1332,  1333,     0,
       0,     0,     0,     0,     0,     0,  1335,   663,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,   664,   102,
     103,   389,   665,     0,   105,   106,   107,   108,   666,   667,
       0,   110,   111,   112,     0,   113,   668,   669,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,  1271,     0,     0,   410,   411,     0,   412,   130,   413,
     414,   415,   132,  1272,   134,  1273,  1274,     0,   416,   417,
       0,   418,   419,  1275,  1276,   420,  1277,  1278,   422,     0,
     423,   424,   425,   426,  1279,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,  1280,   436,   437,
       0,   438,   439,   440,   146,   441,     0,  1281,  1282,  1283,
    1284,  1285,   442,   443,   444,   445,   446,  1286,  1287,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,  1288,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
    1289,   468,   469,  1290,  1291,   470,   471,   472,  1292,     0,
     473,     0,   474,   163,     0,   164,   475,     0,   476,     0,
     477,  1293,     0,   478,     0,   479,   480,   481,   482,   168,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,   169,   170,     0,   492,   493,   494,  1294,  1295,     0,
    1296,     0,     0,   174,   175,   495,   176,   496,   497,   498,
     499,   500,     0,  1297,   178,   501,   179,     0,   502,   503,
     504,  1298,  1299,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,  1300,   185,  1301,   792,
     518,   519,   520,   521,   522,   523,   524,   187,   525,  1302,
     526,   527,   189,   528,  1303,  1304,   529,  1305,   530,   531,
       0,     0,   532,   793,     0,     0,  1306,   534,     0,     0,
     192,   193,   194,  1307,   535,   536,   537,   538,   539,     0,
     540,  1308,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,  1309,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
     205,   564,   565,  1310,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,  1311,   576,   211,   577,
     578,   213,   579,  1312,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,  1313,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,  1314,  1315,     0,
       0,   599,  1316,   600,  1317,  1318,   601,   602,   603,   604,
     605,     0,  1319,   606,   607,   608,   609,  1320,     0,   610,
     611,   612,   613,   614,  1321,   615,   229,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,  1322,
    1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,    49,  1328,   239,   628,     0,
       0,  1329,  1330,    52,    53,    54,    55,  1331,    56,     0,
       0,     0,     0,  1332,  1333,     0,     0,     0,     0,     0,
    1786,     0,  1335,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,     0,   110,   111,   112,
       0,   113,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,  1271,     0,     0,
     410,   411,     0,   412,   130,   413,   414,   415,   132,  1272,
     134,  1273,  1274,     0,   416,   417,     0,   418,   419,  1275,
    1276,   420,  1277,  1278,   422,     0,   423,   424,   425,   426,
    1279,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,  1280,   436,   437,     0,   438,   439,   440,
     146,   441,  2783,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,  1286,  1287,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,  1289,   468,   469,  1290,
    1291,   470,   471,   472,  1292,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,  1294,  1295,     0,  1296,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1300,   185,  1301,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,  1302,   526,   527,   189,   528,
    1303,  1304,   529,  1305,   530,   531,     0,     0,   532,   793,
       0,     0,  1306,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1309,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,  1310,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,  1312,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1314,  1315,     0,     0,   599,  1316,   600,
    1317,  1318,   601,   602,   603,   604,   605,     0,  1319,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
    1321,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,    49,  1328,   239,   628,     0,     0,  1329,  1330,    52,
      53,    54,    55,  1331,    56,     0,     0,     0,     0,  1332,
    1333,     0,     0,     0,     0,     0,     0,     0,  1335,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,     0,   110,   111,   112,     0,   113,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,  1271,     0,     0,   410,   411,     0,   412,
     130,   413,   414,   415,   132,  1272,   134,  1273,  1274,     0,
     416,   417,     0,   418,   419,  1275,  1276,   420,  1277,  1278,
     422,     0,   423,   424,   425,   426,  1279,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,  1280,
     436,   437,     0,   438,   439,   440,   146,   441,     0,  1281,
    1282,  1283,  1284,  1285,   442,   443,   444,   445,   446,  1286,
    1287,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,  1288,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,  1289,   468,   469,  1290,  1291,   470,   471,   472,
    1292,     0,   473,     0,   474,   163,  2398,   164,   475,     0,
     476,     0,   477,  1293,     0,   478,     0,   479,   480,   481,
     482,   168,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,   169,   170,     0,   492,   493,   494,  1294,
    1295,     0,  1296,     0,     0,   174,   175,   495,   176,   496,
     497,   498,   499,   500,     0,  1297,   178,   501,   179,     0,
     502,   503,   504,  1298,  1299,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,  1300,   185,
    1301,   792,   518,   519,   520,   521,   522,   523,   524,   187,
     525,  1302,   526,   527,   189,   528,  1303,  1304,   529,  1305,
     530,   531,     0,     0,   532,   793,     0,     0,  1306,   534,
       0,     0,   192,   193,   194,  1307,   535,   536,   537,   538,
     539,     0,   540,  1308,   197,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,  1309,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,   205,   564,   565,  1310,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,  1311,   576,
     211,   577,   578,   213,   579,  1312,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,  1313,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,  1314,
    1315,     0,     0,   599,  1316,   600,  1317,  1318,   601,   602,
     603,   604,   605,     0,  1319,   606,   607,   608,   609,  1320,
       0,   610,   611,   612,   613,   614,  1321,   615,   229,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,  1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,    49,  1328,   239,
     628,     0,     0,  1329,  1330,    52,    53,    54,    55,  1331,
      56,     0,     0,     0,     0,  1332,  1333,     0,     0,     0,
       0,     0,     0,     0,  1335,   663,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,     0,
      96,    97,    98,    99,   100,   101,   664,   102,   103,   389,
     665,     0,   105,   106,   107,   108,   666,   667,     0,   110,
     111,   112,     0,   113,   668,   669,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,     0,   407,   408,   409,     0,     0,     0,     0,  1271,
       0,     0,   410,   411,     0,   412,   130,   413,   414,   415,
     132,  1272,   134,  1273,  1274,     0,   416,   417,     0,   418,
     419,  1275,  1276,   420,  1277,  1278,   422,     0,   423,   424,
     425,   426,  1279,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,  1280,   436,   437,     0,   438,
     439,   440,   146,   441,     0,  1281,  1282,  1283,  1284,  1285,
     442,   443,   444,   445,   446,  1286,  1287,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,  1288,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,  1289,   468,
     469,  1290,  1291,   470,   471,   472,  1292,     0,   473,     0,
     474,   163,     0,   164,   475,     0,   476,     0,   477,  1293,
       0,   478,     0,   479,   480,   481,   482,   168,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,   169,
     170,     0,   492,   493,   494,  1294,  1295,     0,  1296,     0,
       0,   174,   175,   495,   176,   496,   497,   498,   499,   500,
       0,  1297,   178,   501,   179,     0,   502,   503,   504,  1298,
    1299,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,  1300,   185,  1301,   792,   518,   519,
     520,   521,   522,   523,   524,   187,   525,  1302,   526,   527,
     189,   528,  1303,  1304,   529,  1305,   530,   531,     0,     0,
     532,   793,     0,     0,  1306,   534,     0,     0,   192,   193,
     194,  1307,   535,   536,   537,   538,   539,     0,   540,  1308,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,  1309,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,   205,   564,
     565,  1310,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,  1311,   576,   211,   577,   578,   213,
     579,  1312,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,  1313,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,  1314,  1315,     0,     0,   599,
    1316,   600,  1317,  1318,   601,   602,   603,   604,   605,     0,
    1319,   606,   607,   608,   609,  1320,     0,   610,   611,   612,
     613,   614,  1321,   615,   229,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,  1322,  1323,  1324,
    1325,  1326,  1327,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,    49,  1328,   239,   628,     0,     0,  1329,
    1330,    52,    53,    54,    55,  1331,    56,     0,     0,     0,
       0,  1332,  1333,     0,     0,     0,     0,     0,     0,     0,
    1335,   663,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,   664,   102,   103,   389,   665,     0,   105,   106,
     107,   108,   666,   667,     0,   110,   111,   112,     0,   113,
     668,   669,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,  1271,     0,     0,   410,   411,
       0,   412,   130,   413,   414,   415,   132,  1272,   134,  1273,
    1274,     0,   416,   417,     0,   418,   419,  1275,  1276,   420,
    1277,  1278,   422,     0,   423,   424,   425,   426,  1279,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,  1280,   436,   437,     0,   438,   439,   440,   146,   441,
       0,  1281,  1282,  1283,  1284,  1285,   442,   443,   444,   445,
     446,  1286,  1287,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
    1288,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,  1289,   468,   469,  1290,  1291,   470,
     471,   472,  1292,     0,   473,     0,   474,   163,     0,   164,
     475,     0,   476,     0,   477,  1293,     0,   478,     0,   479,
     480,   481,   482,   168,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,   169,   170,     0,   492,   493,
     494,  1294,  1295,     0,  1296,     0,     0,   174,   175,   495,
     176,   496,   497,   498,   499,   500,     0,  1297,   178,   501,
     179,     0,   502,   503,   504,  1298,  1299,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
    1300,   185,  1301,   792,   518,   519,   520,   521,   522,   523,
     524,   187,   525,  1302,   526,   527,   189,   528,  1303,  1304,
     529,  1305,   530,   531,     0,     0,   532,   793,     0,     0,
    1306,   534,     0,     0,   192,   193,   194,  1307,   535,   536,
     537,   538,   539,     0,   540,  1308,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,  1309,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,   205,   564,   565,  1310,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
    1311,   576,   211,   577,   578,   213,   579,  1312,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,  1313,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,  1314,  1315,     0,     0,   599,  1316,   600,  1317,  1318,
     601,   602,   603,   604,   605,     0,  1319,   606,   607,   608,
     609,  1320,     0,   610,   611,   612,   613,   614,  1321,   615,
     229,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,  3503,  1322,  1323,  1324,  1325,  1326,  1327,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,    49,
    1328,   239,   628,     0,     0,  1329,  1330,    52,    53,    54,
      55,  1331,    56,     0,     0,     0,     0,  1332,  1333,     0,
       0,     0,     0,     0,     0,     0,  1335,   663,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,   664,   102,
     103,   389,   665,     0,   105,   106,   107,   108,   666,   667,
       0,   110,   111,   112,     0,   113,   668,   669,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,  1271,     0,     0,   410,   411,     0,   412,   130,   413,
     414,   415,   132,  1272,   134,  1273,  1274,     0,   416,   417,
       0,   418,   419,  1275,  1276,   420,  1277,  1278,   422,     0,
     423,   424,   425,   426,  1279,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,  1280,   436,   437,
       0,   438,   439,   440,   146,   441,     0,  1281,  1282,  1283,
    1284,  1285,   442,   443,   444,   445,   446,  1286,  1287,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,  1288,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
    1289,   468,   469,  1290,  1291,   470,   471,   472,  1292,     0,
     473,     0,   474,   163,     0,   164,   475,     0,   476,     0,
     477,  1293,     0,   478,     0,   479,   480,   481,   482,   168,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,   169,   170,     0,   492,   493,   494,  1294,  1295,     0,
    1296,     0,     0,   174,   175,   495,   176,   496,   497,   498,
     499,   500,     0,  1297,   178,   501,   179,     0,   502,   503,
     504,  1298,  1299,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,  1300,   185,  1301,   792,
     518,  3510,   520,   521,   522,   523,   524,   187,   525,  1302,
     526,   527,   189,   528,  1303,  1304,   529,  1305,   530,   531,
       0,     0,   532,   793,     0,     0,  1306,   534,     0,     0,
     192,   193,   194,  1307,   535,   536,   537,   538,   539,     0,
     540,  1308,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,  1309,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
     205,   564,   565,  1310,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,  1311,   576,   211,   577,
     578,   213,   579,  1312,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,  1313,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,  1314,  1315,     0,
       0,   599,  1316,   600,  1317,  1318,   601,   602,   603,   604,
     605,     0,  1319,   606,   607,   608,   609,  1320,     0,   610,
     611,   612,   613,   614,  1321,   615,   229,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,  1322,
    1323,  1324,  1325,  1326,  1327,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,    49,  1328,   239,   628,     0,
       0,  1329,  1330,    52,    53,    54,    55,  1331,    56,     0,
       0,     0,     0,  1332,  1333,     0,     0,     0,     0,     0,
       0,     0,  1335,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,     0,   110,   111,   112,
       0,   113,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,  1271,     0,     0,
     410,   411,     0,   412,   130,   413,   414,   415,   132,  1272,
     134,  1273,  1274,     0,   416,   417,     0,   418,   419,  1275,
    1276,   420,  1277,  1278,   422,     0,   423,   424,   425,   426,
    1279,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,  1280,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,  1286,  1287,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,  1289,   468,   469,  1290,
    1291,   470,   471,   472,  1292,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,  1294,  1295,     0,  1296,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1300,   185,  1301,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,   189,   528,
    1303,  1304,   529,  1305,   530,   531,     0,     0,   532,   793,
       0,     0,  1306,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1309,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,  1310,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,  1312,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1314,  1315,     0,     0,   599,  1316,   600,
    1317,  1318,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
    1321,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,    49,  1328,   239,   628,     0,     0,  1329,  1330,    52,
      53,    54,    55,  1331,    56,     0,     0,     0,     0,     0,
    2381,     0,     0,     0,     0,     0,     0,     0,  1335,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,     0,   110,   111,   112,     0,   113,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,  1271,     0,     0,   410,   411,     0,   412,
     130,   413,   414,   415,     0,  1272,   134,  1273,  1274,     0,
     416,   417,     0,   418,   419,  1275,  1276,   420,  1277,  1278,
     422,     0,   423,   424,   425,   426,  1279,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,  1280,
     436,   437,     0,   438,   439,   440,   146,   441,     0,  1281,
    1282,  1283,  1284,  1285,   442,   443,   444,   445,   446,  1286,
    1287,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,  1288,   459,
     460,     0,   461,   462,   463,     0,     0,     0,     0,   465,
     466,   467,  1289,   468,   469,  1290,  1291,   470,   471,   472,
    1292,     0,   473,     0,   474,   163,     0,   164,   475,     0,
     476,     0,   477,  1293,     0,   478,     0,   479,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,   169,   170,     0,   492,   493,   494,  1294,
    1295,     0,  1296,     0,     0,   174,   175,   495,   176,   496,
     497,   498,   499,   500,     0,  1297,   178,   501,     0,     0,
     502,   503,   504,  1298,  1299,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,  1300,   185,
    1301,   792,   518,   519,   520,   521,   522,   523,   524,   187,
     525,     0,   526,   527,   189,   528,  1303,  1304,   529,  1305,
     530,   531,     0,     0,   532,   793,     0,     0,  1306,   534,
       0,     0,   192,   193,   194,  1307,   535,   536,   537,   538,
     539,     0,   540,  1308,   197,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,  1309,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,   205,   564,   565,  1310,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,  1311,   576,
     211,   577,   578,     0,   579,  1312,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,  1313,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,  1314,
    1315,     0,     0,   599,  1316,   600,  1317,  1318,   601,   602,
     603,   604,   605,     0,  1319,   606,   607,   608,   609,  1320,
       0,   610,   611,   612,   613,   614,  1321,   615,   229,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,  1322,  1323,  1324,  1325,  1326,  1327,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,    49,  1328,   239,
     628,     0,     0,  1329,  1330,    52,    53,    54,    55,  1331,
      56,     0,     0,     0,     0,  1332,  1333,     0,     0,     0,
       0,     0,     0,     0,  1335,   663,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,     0,
      96,    97,    98,    99,   100,   101,   664,   102,   103,   389,
     665,     0,   105,   106,   107,   108,   666,   667,     0,   110,
     111,   112,     0,   113,   668,   669,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,     0,   407,   408,   409,     0,     0,     0,     0,  1271,
       0,     0,   410,   411,     0,   412,   130,   413,   414,   415,
       0,  1272,   134,  1273,  1274,     0,   416,   417,     0,   418,
     419,  1275,  1276,   420,  1277,  1278,   422,     0,   423,   424,
     425,   426,  1279,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,  1280,   436,   437,     0,   438,
     439,   440,   146,   441,     0,  1281,  1282,  1283,  1284,  1285,
     442,   443,   444,   445,   446,  1286,  1287,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,  1288,   459,   460,     0,   461,   462,
     463,     0,     0,     0,     0,   465,   466,   467,  1289,   468,
     469,  1290,  1291,   470,   471,   472,  1292,     0,   473,     0,
     474,   163,     0,   164,   475,     0,   476,     0,   477,  1293,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,   169,
     170,     0,   492,   493,   494,  1294,  1295,     0,  1296,     0,
       0,   174,   175,   495,   176,   496,   497,   498,   499,   500,
       0,  1297,   178,   501,     0,     0,   502,   503,   504,  1298,
    1299,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,  1300,   185,  1301,   792,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
     189,   528,  1303,  1304,   529,  1305,   530,   531,     0,     0,
     532,   793,     0,     0,     0,   534,     0,     0,   192,   193,
     194,  1307,   535,   536,   537,   538,   539,     0,   540,  1308,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,  1309,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,   205,   564,
     565,  1310,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,  1311,   576,   211,   577,   578,     0,
     579,  1312,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,  1313,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,  1314,  1315,     0,     0,   599,
    1316,   600,  1317,  1318,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,  1320,     0,   610,   611,   612,
     613,   614,  1321,   615,   229,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,  1322,  1323,  1324,
    1325,  1326,  1327,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,    49,     0,   239,   628,     0,     0,  1329,
    1330,    52,    53,    54,    55,  1331,    56,     0,     0,     0,
       0,     0,  2381,     0,     0,     0,     0,     0,     0,     0,
    1335,   663,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,   664,   102,   103,   389,   665,     0,   105,   106,
     107,   108,   666,   667,     0,   110,   111,   112,     0,   113,
     668,   669,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,   130,   413,   414,   415,   132,   133,   134,   135,
       0,     0,   416,   417,     0,   418,   419,     0,  1276,   420,
     421,   136,   422,     0,   423,   424,   425,   426,  1279,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,  1280,   436,   437,     0,   438,   439,   440,   146,   441,
       0,  1281,  1282,  1283,  1284,  1285,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,  1290,     0,   470,
     471,   472,   162,     0,   473,     0,   474,   163,     0,   164,
     475,     0,   476,     0,   477,  1293,     0,   478,     0,   479,
     480,   481,   482,   168,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,   169,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,   174,   175,   495,
     176,   496,   497,   498,   499,   500,     0,  1297,   178,   501,
     179,     0,   502,   503,   504,  1298,  1299,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,   185,   186,   792,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,   189,   528,     0,  1304,
     529,   191,   530,   531,     0,     0,   532,   793,     0,   978,
     533,   534,     0,     0,   192,   193,   194,  1307,   535,   536,
     537,   538,   539,     0,   540,  1308,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,   205,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,   209,   573,   574,   575,
    1311,   576,   211,   577,   578,   213,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,  1313,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,  1316,   600,  1317,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,  1320,     0,   610,   611,   612,   613,  1841,   228,   615,
     229,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,  1322,  1323,  1324,  1325,  1326,  1327,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   663,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,  2250,    96,    97,    98,
      99,   100,   101,   664,   102,   103,   389,   665,     0,   105,
     106,   107,   108,   666,   667,     0,   110,   111,   112,     0,
     113,   668,   669,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,   130,   413,   414,   415,   132,   133,   134,
     135,     0,     0,   416,   417,     0,   418,   419,     0,  1276,
     420,   421,   136,   422,     0,   423,   424,   425,   426,  1279,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,  1280,   436,   437,     0,   438,   439,   440,   146,
     441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,   444,
     445,   446,   149,   150,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,  1290,     0,
     470,   471,   472,   162,     0,   473,     0,   474,   163,     0,
     164,   475,     0,   476,     0,   477,  1293,     0,   478,     0,
     479,   480,   481,   482,   168,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,   169,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,   174,   175,
     495,   176,   496,   497,   498,   499,   500,     0,  1297,   178,
     501,   179,     0,   502,   503,   504,  1298,  1299,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,   185,   186,   792,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,   189,   528,     0,
    1304,   529,   191,   530,   531,     0,     0,   532,   793,     0,
     978,   533,   534,     0,     0,   192,   193,   194,  1307,   535,
     536,   537,   538,   539,     0,   540,  1308,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,   205,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,  1311,   576,   211,   577,   578,   213,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
    1313,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,  1316,   600,  1317,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,  1320,     0,   610,   611,   612,   613,   614,   228,
     615,   229,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,  1327,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,  2250,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,     0,   110,   111,   112,
       0,   113,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,   130,   413,   414,   415,   132,   133,
     134,   135,     0,     0,   416,   417,     0,   418,   419,     0,
    1276,   420,   421,   136,   422,     0,   423,   424,   425,   426,
    1279,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,  1280,   436,   437,     0,   438,   439,   440,
     146,   441,     0,  1281,  1282,  1283,  1284,  1285,   442,   443,
     444,   445,   446,   149,   150,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,   458,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,   158,   468,   469,  1290,
       0,   470,   471,   472,   162,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,  1293,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,   170,     0,
     492,   493,   494,     0,   172,     0,   173,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,  1297,
     178,   501,   179,     0,   502,   503,   504,  1298,  1299,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   184,   185,   186,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,   189,   528,
       0,  1304,   529,   191,   530,   531,     0,     0,   532,   793,
       0,     0,   533,   534,     0,     0,   192,   193,   194,  1307,
     535,   536,   537,   538,   539,     0,   540,  1308,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,   199,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,   207,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,  1311,   576,   211,   577,   578,   213,   579,   214,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,  1313,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,   217,   218,     0,     0,   599,  1316,   600,
    1317,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,  1320,     0,   610,   611,   612,   613,   614,
     228,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,  1322,  1323,  1324,  1325,  1326,
    1327,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,  3627,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,     0,   110,   111,
     112,     0,   113,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,   130,   413,   414,   415,   132,
     133,   134,   135,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   136,   422,     0,   423,   424,   425,
     426,   140,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   143,   436,   437,     0,   438,   439,
     440,   146,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
     163,     0,   164,   475,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,   482,   168,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,   169,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
     174,   175,   495,   176,   496,   497,   498,   499,   500,     0,
     177,   178,   501,   179,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184,   185,   186,   792,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,   189,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
     793,     0,     0,   533,   534,     0,     0,   192,   193,   194,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,   205,   564,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,     0,   576,   211,   577,   578,   213,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
     614,   228,   615,   229,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   389,  3677,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,  2765,
       0,   410,   411,     0,   412,     0,   413,   414,   415,     0,
     133,     0,   135,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   136,   422,     0,   423,   424,   425,
     426,   140,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   143,   436,   437,     0,   438,   439,
     440, -1046,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0, -1046,   475,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0, -1046,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495, -1046,   496,   497,   498,   499,   500,     0,
     177, -1046,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184, -1046,   186,     0,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563, -1046,   564,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
     614,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   389,     0,
    1414,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,     0,   413,   414,   415,     0,
     133,     0,   135,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   136,   422,     0,   423,   424,   425,
     426,   140,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   143,   436,   437,     0,   438,   439,
     440,     0,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0,     0,   475,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,   498,   499,   500,     0,
     177,     0,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184,     0,   186,     0,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   564,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
     614,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,    49,     0,   239,   628,     0,     0,     0,     0,
      52,    53,    54,    55,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2686,  2687,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   389,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
       0,   413,   414,   415,     0,   133,     0,   135,     0,     0,
     416,   417,     0,   418,   419,     0,     0,   420,   421,   136,
     422,     0,   423,   424,   425,   426,   140,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   143,
     436,   437,     0,   438,   439,   440,     0,   441,     0,     0,
       0,     0,     0,     0,   442,   443,   444,   445,   446,   149,
     150,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,   458,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,   158,   468,   469,   160,     0,   470,   471,   472,
     162,     0,   473,     0,   474,     0,     0,     0,   475,     0,
     476,     0,   477,   167,     0,   478,     0,   479,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,     0,   170,     0,   492,   493,   494,     0,
     172,     0,   173,     0,     0,     0,     0,   495,     0,   496,
     497,   498,   499,   500,     0,   177,     0,   501,     0,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   184,     0,
     186,     0,   518,   519,   520,   521,   522,   523,   524,   187,
     525,     0,   526,   527,     0,   528,     0,   190,   529,   191,
     530,   531,     0,     0,   532,     0,     0,     0,   533,   534,
       0,     0,   192,     0,     0,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,   199,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,     0,   564,   565,   207,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,     0,   576,
     211,   577,   578,     0,   579,   214,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,   217,
     218,     0,     0,   599,   219,   600,   220,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,     0,
       0,   610,   611,   612,   613,   614,   228,   615,     0,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,    49,     0,   239,
     628,     0,     0,     0,     0,    52,    53,    54,    55,     0,
       0,    83,    84,    85,   386,    87,    88,    89,    90,    91,
     387,     0,   388,    94,  2687,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   389,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   390,   391,     0,     0,     0,   392,   393,     0,     0,
       0,     0,   394,     0,     0,     0,     0,     0,     0,     0,
       0,   395,     0,   396,     0,   397,   398,     0,   399,   400,
     401,   402,   403,   404,   405,   406,     0,   407,   408,   409,
       0,     0,     0,     0,     0,     0,     0,   410,   411,     0,
     412,     0,   413,   414,   415,     0,   133,     0,   135,     0,
       0,   416,   417,     0,   418,   419,     0,     0,   420,   421,
     136,   422,     0,   423,   424,   425,   426,   140,     0,     0,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
     143,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,   470,   471,
     472,   162,     0,   473,     0,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,     0,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
       0,   186,   792,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,   793,     0,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   564,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,     0,
     576,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     217,   218,     0,     0,   599,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,   614,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,     0,     0,
     239,    83,    84,    85,   386,    87,    88,    89,    90,    91,
     387,     0,   388,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   389,  1402,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   390,   391,     0,     0,     0,   392,   393,     0,     0,
       0,     0,   394,     0,     0,     0,     0,     0,     0,     0,
       0,   395,     0,   396,     0,   397,   398,     0,   399,   400,
     401,   402,   403,   404,   405,   406,     0,   407,   408,   409,
       0,     0,     0,     0,     0,     0,     0,   410,   411,     0,
     412,     0,   413,   414,   415,     0,   133,     0,   135,     0,
       0,   416,   417,     0,   418,   419,     0,     0,   420,   421,
     136,   422,     0,   423,   424,   425,   426,   140,     0,     0,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
     143,   436,   437,     0,   438,   439,   440,     0,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,   470,   471,
     472,   162,     0,   473,     0,   474,     0,     0,     0,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,     0,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,     0,     0,   495,     0,
     496,   497,   498,   499,   500,     0,   177,     0,   501,     0,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
       0,   186,     0,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,     0,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,     0,     0,     0,   533,
     534,     0,     0,   192,     0,     0,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,     0,   564,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,   209,   573,   574,   575,     0,
     576,   211,   577,   578,     0,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     217,   218,     0,     0,   599,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,  1841,   228,   615,     0,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,     0,     0,
     239,   628,     0,     0,     0,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,   240,   102,   103,   389,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,     0,   413,   414,   415,     0,
     133,     0,   135,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   136,   422,     0,   423,   424,   425,
     426,   140,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   143,   436,   437,     0,   438,   439,
     440,     0,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0,     0,   475,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,   498,   499,   500,     0,
     177,     0,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184,     0,   186,     0,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   564,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,   209,
     573,   574,   575,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
    1841,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   389,   240,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,     0,   413,   414,   415,     0,
     133,     0,   135,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   136,   422,     0,   423,   424,   425,
     426,   140,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   143,   436,   437,     0,   438,   439,
     440,     0,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0,     0,   475,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,   498,   499,   500,     0,
     177,     0,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184,     0,   186,     0,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   564,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
     614,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   389,  1938,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,     0,   413,   414,   415,     0,
     133,     0,   135,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   136,   422,     0,   423,   424,   425,
     426,   140,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   143,   436,   437,     0,   438,   439,
     440,     0,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0,     0,   475,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,   498,   499,   500,     0,
     177,     0,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184,     0,   186,     0,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   564,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
     614,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   663,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,  3201,
      96,    97,    98,    99,   100,   101,   664,   102,   103,   389,
     665,     0,   105,   106,   107,   108,   666,   667,     0,   110,
     111,   112,     0,   113,   668,   669,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,   670,   407,   408,   409,   671,   672,   673,   674,   675,
     676,   677,   410,   411,   678,   412,   130,   413,   414,   415,
     132,  1601,   134,  1602,  1274,   679,   416,   417,     0,   418,
     419,   680,   681,   420,  1603,  1604,   422,   683,   423,   424,
     425,   426,     0,   684,   685,   427,   428,   429,   430,   431,
     432,   686,   433,   434,   435,     0,   436,   437,   687,   438,
     439,   440,   146,   441,   688,   689,   690,   691,   692,   693,
     442,   443,   444,   445,   446,  1605,  1606,   447,   694,   448,
     695,   449,     0,   450,   451,   452,   696,   453,   454,   455,
     697,   698,   456,   457,  1288,   459,   460,   699,   461,   462,
     463,   700,     0,   464,   701,   465,   466,   467,     0,   468,
     469,     0,   702,   470,   471,   472,  1607,   703,   473,   704,
     474,   163,   705,   164,   475,     0,   476,   706,   477,     0,
     707,   478,   708,   479,   480,   481,   482,   168,   483,   484,
     485,   709,   486,   487,   488,   489,   490,   491,   710,   169,
       0,     0,   492,   493,   494,  1294,  1608,   713,  1609,   714,
       0,   174,   175,   495,   176,   496,   497,   498,   499,   500,
     715,     0,   178,   501,   179,   716,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,  1610,   185,  1611,   717,   518,   519,
     520,   521,   522,   523,   524,     0,   525,   718,   526,   527,
     189,   528,   719,     0,   529,  1612,   530,   531,   720,   721,
     532,   722,   723,   724,  3093,   534,   725,   726,     0,   193,
     194,     0,   535,   536,   537,   538,   539,     0,   540,     0,
       0,   541,   542,   543,   727,   544,   545,   546,   547,   548,
     549,  1613,   550,   551,   728,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,   729,   562,   563,   205,   564,
     565,     0,   566,   567,   568,   569,   570,   571,   572,     0,
     730,   573,   574,   575,   731,   576,  2051,   577,   578,   213,
     579,  1615,   732,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,     0,   590,   733,   591,   592,   734,   593,
     594,   595,   596,   597,   735,  1616,  1617,     0,   737,   599,
       0,   600,     0,   738,   601,   602,   603,   604,   605,     0,
     740,   606,   607,   608,   609,   741,   742,   610,   611,   612,
     613,     0,  1618,   615,   229,   616,   617,   618,   743,   744,
     619,   620,   621,   622,   623,   624,     0,     0,     0,     0,
       0,     0,     0,     0,   625,   626,   627,     0,     0,     0,
       0,     0,   238,    49,  1078,   239,   628,     0,     0,     0,
       0,    52,    53,    54,    55,     0,    56,  1079,  1080,  1081,
       0,  1082,  3094,  1084,  1085,  1086,  1087,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,     0,   407,   408,   409,     0,     0,     0,     0,
       0,     0,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   133,     0,   135,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   421,   136,   422,     0,   423,
    1076,   425,   426,   140,     0,     0,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,   143,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,  1077,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,  1078,   239,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1079,  1080,
    1081,     0,  1082,  1083,  1084,  1085,  1086,  1087,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,  1078,   239,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1079,
    1080,  1081,     0,  1082,  1083,  1084,  1085,  1086,  1087,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,     0,   110,   111,   112,     0,   113,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,   670,   407,   408,   409,   671,
     672,   673,   674,   675,   676,   677,   410,   411,   678,   412,
     130,   413,   414,   415,   132,   133,   134,   135,     0,   679,
     416,   417,     0,   418,   419,   680,   681,   420,   682,   136,
     422,   683,   423,   424,   425,   426,   140,   684,   685,   427,
     428,   429,   430,   431,   432,   686,   433,   434,   435,   143,
     436,   437,   687,   438,   439,   440,   146,   441,   688,   689,
     690,   691,   692,   693,   442,   443,   444,   445,   446,   149,
     150,   447,   694,   448,   695,   449,     0,   450,   451,   452,
     696,   453,   454,   455,   697,   698,   456,   457,   458,   459,
     460,   699,   461,   462,   463,   700,     0,   464,   701,   465,
     466,   467,   158,   468,   469,   160,   702,   470,   471,   472,
     162,   703,   473,   704,   474,   163,   705,   164,   475,     0,
     476,   706,   477,   167,   707,   478,   708,   479,   480,   481,
     482,   168,   483,   484,   485,   709,   486,   487,   488,   489,
     490,   491,   710,   169,   170,   711,   492,   493,   494,   712,
     172,   713,   173,   714,     0,   174,   175,   495,   176,   496,
     497,   498,   499,   500,   715,   177,   178,   501,   179,   716,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   184,   185,
     186,   717,   518,   519,   520,   521,   522,   523,   524,   187,
     525,   718,   526,   527,   189,   528,   719,   190,   529,   191,
     530,   531,   720,   721,   532,   722,   723,   724,   533,   534,
     725,   726,   192,   193,   194,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,   727,   544,
     545,   546,   547,   548,   549,   199,   550,   551,   728,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,   729,
     562,   563,   205,   564,   565,   207,   566,   567,   568,   569,
     570,   571,   572,     0,   730,   573,   574,   575,   731,   576,
     211,   577,   578,   213,   579,   214,   732,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,   733,
     591,   592,   734,   593,   594,   595,   596,   597,   735,   217,
     218,   736,   737,   599,   219,   600,   220,   738,   601,   602,
     603,   604,   605,   739,   740,   606,   607,   608,   609,   741,
     742,   610,   611,   612,   613,     0,   228,   615,   229,   616,
     617,   618,   743,   744,   619,   620,   621,   622,   623,   624,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,     0,     0,   239,
       0,     0,     0,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,  1572,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,     0,   110,   111,   112,
       0,   113,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,   130,   413,   414,   415,   132,  1601,
     134,  1602,  1274,     0,   416,   417,     0,   418,   419,     0,
       0,   420,  1603,  1604,   422,     0,   423,   424,   425,   426,
       0,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,   436,   437,     0,   438,   439,   440,
     146,   441,     0,     0,     0,     0,     0,     0,   442,   443,
     444,   445,   446,  1605,  1606,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,     0,   468,   469,     0,
       0,   470,   471,   472,  1607,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,     0,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,   169,     0,     0,
     492,   493,   494,  1294,  1608,     0,  1609,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,     0,
     178,   501,   179,     0,   502,   503,   504,     0,     0,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1610,   185,  1611,     0,   518,   519,   520,   521,
     522,   523,   524,     0,   525,     0,   526,   527,   189,   528,
       0,     0,   529,  1612,   530,   531,     0,     0,   532,     0,
       0,     0,   533,   534,     0,     0,     0,   193,   194,     0,
     535,   536,   537,   538,   539,     0,   540,     0,     0,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1613,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,     0,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,     0,   576,  1614,   577,   578,   213,   579,  1615,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,     0,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1616,  1617,     0,     0,   599,     0,   600,
       0,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,     0,     0,   610,   611,   612,   613,     0,
    1618,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,     0,     0,     0,     0,     0,     0,
       0,     0,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,     0,     0,     0,     0,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,  2008,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,     0,     0,
       0,     0,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,   976,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   133,     0,   135,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   136,   422,     0,   423,   424,   425,   426,   140,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   143,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,  1919,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,  1920,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,  1921,     0,   532,     0,  1922,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,  1923,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,    49,
       0,   239,   628,     0,     0,     0,     0,    52,    53,    54,
      55,     0,    56,     0,     0,     0,     0,     0,  1446,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   389,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,     0,
     413,   414,   415,     0,   133,     0,   135,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   136,   422,
       0,   423,   424,   425,   426,   140,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   143,   436,
     437,     0,   438,   439,   440,     0,   441,     0,     0,     0,
       0,     0,     0,   442,   443,   444,   445,   446,   149,   150,
     447,  1929,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,   458,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,   158,   468,   469,   160,  1920,   470,   471,   472,   162,
       0,   473,     0,   474,     0,     0,     0,   475,     0,   476,
       0,   477,   167,     0,   478,     0,   479,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,     0,   170,     0,   492,   493,   494,     0,   172,
       0,   173,     0,     0,     0,     0,   495,     0,   496,   497,
     498,   499,   500,     0,   177,     0,   501,     0,     0,   502,
     503,   504,     0,     0,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   184,     0,   186,
       0,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,     0,   528,     0,   190,   529,   191,   530,
     531,  1921,     0,   532,     0,  1922,     0,   533,   534,     0,
       0,   192,     0,     0,   195,   535,   536,   537,   538,   539,
       0,   540,   196,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,   199,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,     0,   564,   565,   207,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,     0,   576,   211,
     577,   578,     0,   579,   214,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   216,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,   217,   218,
       0,     0,   599,   219,   600,   220,  1923,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,     0,     0,
     610,   611,   612,   613,   614,   228,   615,     0,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
     231,   232,   233,   234,   235,   236,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,    49,     0,   239,   628,
       0,     0,     0,     0,    52,    53,    54,    55,     0,    56,
       0,     0,     0,     0,     0,  1446,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   389,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,     0,   407,   408,   409,     0,     0,     0,     0,     0,
       0,     0,   410,   411,     0,   412,     0,   413,   414,   415,
       0,   133,     0,   135,     0,     0,   416,   417,     0,   418,
     419,     0,     0,   420,   421,   136,   422,     0,   423,   424,
     425,   426,   140,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,   143,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,  1920,   470,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,     0,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,  1921,     0,
     532,     0,  1922,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   217,   218,     0,     0,   599,
     219,   600,   220,  1923,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,     0,     0,   610,   611,   612,
     613,   614,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,    49,     0,   239,   628,     0,     0,     0,
       0,    52,    53,    54,    55,     0,    56,     0,     0,     0,
       0,     0,  1446,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   884,   401,   402,   403,   404,   405,   406,   885,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   886,   414,   415,     0,   133,     0,
     135,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   136,   422,     0,   423,   424,   425,   426,   140,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   143,   436,   437,     0,   438,   439,   440,     0,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,     0,
     470,   471,   887,   162,     0,   473,     0,   888,     0,   889,
       0,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,   482,     0,   483,   484,   485,   890,   486,
     487,   488,   489,   490,   491,     0,     0,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,     0,     0,
     495,     0,   496,   497,   498,   499,   891,     0,   177,     0,
     501,     0,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,     0,   186,     0,   892,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,     0,   528,     0,
     190,   529,   191,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,   192,     0,     0,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   893,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   894,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,     0,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,   211,   577,   578,     0,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,   614,   228,
     615,     0,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,   628,     0,     0,     0,     0,     0,     0,
       0,    55,     0,     0,     0,     0,     0,     0,     0,   895,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   389,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   884,   401,
     402,   403,   404,   405,   406,   885,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
       0,   886,   414,   415,     0,   133,     0,   135,     0,     0,
     416,   417,     0,   418,   419,     0,     0,   420,   421,   136,
     422,     0,   423,   424,   425,   426,   140,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   143,
     436,   437,     0,   438,   439,   440,     0,   441,     0,     0,
       0,     0,     0,     0,   442,   443,   444,   445,   446,   149,
     150,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,   458,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,   158,   468,   469,   160,     0,   470,   471,   887,
     162,     0,   473,     0,   888,     0,     0,     0,   475,     0,
     476,     0,   477,   167,     0,   478,     0,   479,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,     0,   170,     0,   492,   493,   494,     0,
     172,     0,   173,     0,     0,     0,     0,   495,     0,   496,
     497,   498,   499,   891,     0,   177,     0,   501,     0,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   184,     0,
     186,     0,   892,   519,   520,   521,   522,   523,   524,   187,
     525,     0,   526,   527,     0,   528,     0,   190,   529,   191,
     530,   531,     0,     0,   532,     0,     0,     0,   533,   534,
       0,     0,   192,     0,     0,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,     0,   893,
     545,   546,   547,   548,   549,   199,   550,   551,     0,   552,
     894,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,     0,   564,   565,   207,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,     0,   576,
     211,   577,   578,     0,   579,   214,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,   217,
     218,     0,     0,   599,   219,   600,   220,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,     0,
       0,   610,   611,   612,   613,   614,   228,   615,     0,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,     0,     0,   239,
     628,     0,     0,     0,     0,     0,     0,     0,    55,     0,
       0,     0,     0,     0,     0,     0,   895,   663,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,   664,   102,
     103,   389,   665,     0,   105,   106,   107,   108,   666,   667,
       0,   110,   111,   112,     0,   113,   668,   669,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,   130,   413,
     414,   415,   132,   133,   134,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,   146,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,   163,     0,   164,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,   168,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,   169,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,   174,   175,   495,   176,   496,   497,   498,
     499,   500,     0,   177,   178,   501,   179,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,   185,   186,   792,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,   189,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,   793,     0,     0,   533,   534,     0,     0,
     192,   193,   194,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
     205,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,   213,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,   229,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,    49,     0,   239,   628,     0,
       0,  1329,  1330,    52,    53,    54,    55,     0,    56,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   389,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,     0,
     413,   414,   415,     0,   133,     0,   135,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   136,   422,
       0,   423,   424,   425,   426,   140,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   143,   436,
     437,     0,   438,   439,   440,     0,   441,     0,     0,     0,
       0,     0,     0,   442,   443,   444,   445,   446,   149,   150,
     447,   652,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,   458,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,   158,   468,   469,   160,     0,   470,   471,   472,   162,
       0,   473,     0,   474,     0,     0,     0,   475,     0,   476,
       0,   477,   167,     0,   478,     0,   479,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,     0,   170,     0,   492,   493,   494,     0,   172,
       0,   173,     0,     0,     0,     0,   495,     0,   496,   497,
     498,   499,   500,     0,   177,     0,   501,     0,     0,   502,
     503,   504,     0,     0,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   184,     0,   186,
       0,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,     0,   528,     0,   190,   529,   191,   530,
     531,     0,     0,   532,     0,     0,     0,   533,   534,     0,
       0,   192,     0,     0,   195,   535,   536,   537,   538,   539,
       0,   540,   196,   197,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,   199,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,     0,   564,   565,   207,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,     0,   576,   211,
     577,   578,     0,   579,   214,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   216,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,   217,   218,
    1372,     0,   599,   219,   600,   220,     0,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,     0,     0,
     610,   611,   612,   613,   614,   228,   615,     0,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
     231,   232,   233,   234,   235,   236,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,     0,     0,   239,   628,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
    1373,   388,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   389,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
       0,   413,   414,   415,     0,   133,     0,   135,     0,     0,
     416,   417,     0,   418,   419,     0,     0,   420,   421,   136,
     422,     0,   423,   424,   425,   426,   140,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   143,
     436,   437,     0,   438,   439,   440,     0,   441,     0,     0,
       0,     0,     0,     0,   442,   443,   444,   445,   446,   149,
     150,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,   458,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,   158,   468,   469,   160,     0,   470,   471,   472,
     162,     0,   473,     0,   474,     0,     0,     0,   475,     0,
     476,     0,   477,   167,     0,   478,     0,   479,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,     0,   170,     0,   492,   493,   494,     0,
     172,     0,   173,     0,     0,     0,     0,   495,     0,   496,
     497,   498,   499,   500,     0,   177,     0,   501,     0,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   184,     0,
     186,     0,   518,   519,   520,   521,   522,   523,   524,   187,
     525,     0,   526,   527,     0,   528,     0,   190,   529,   191,
     530,   531,     0,     0,   532,     0,     0,     0,   533,   534,
       0,     0,   192,     0,     0,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,   199,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,     0,   564,   565,   207,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,     0,   576,
     211,   577,   578,     0,   579,   214,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,   217,
     218,     0,     0,   599,   219,   600,   220,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,     0,
       0,   610,   611,   612,   613,   614,   228,   615,     0,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,     0,     0,   239,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3476,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   389,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,     0,   407,   408,   409,     0,
       0,     0,     0,     0,     0,     0,   410,   411,     0,   412,
       0,   413,   414,   415,     0,   133,     0,   135,     0,     0,
     416,   417,     0,   418,   419,     0,     0,   420,   421,   136,
     422,     0,   423,   424,   425,   426,   140,     0,     0,   427,
     428,   429,   430,   431,   432,     0,   433,   434,   435,   143,
     436,   437,     0,   438,   439,   440,     0,   441,     0,     0,
       0,     0,     0,     0,   442,   443,   444,   445,   446,   149,
     150,   447,     0,   448,     0,   449,     0,   450,   451,   452,
       0,   453,   454,   455,     0,     0,   456,   457,   458,   459,
     460,     0,   461,   462,   463,     0,     0,   464,     0,   465,
     466,   467,   158,   468,   469,   160,     0,   470,   471,   472,
     162,     0,   473,     0,   474,     0,     0,     0,   475,     0,
     476,     0,   477,   167,     0,   478,     0,   479,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     490,   491,     0,     0,   170,     0,   492,   493,   494,     0,
     172,     0,   173,     0,     0,     0,     0,   495,     0,   496,
     497,   498,   499,   500,     0,   177,     0,   501,     0,     0,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   184,     0,
     186,     0,   518,   519,   520,   521,   522,   523,   524,   187,
     525,     0,   526,   527,     0,   528,     0,   190,   529,   191,
     530,   531,     0,     0,   532,     0,     0,     0,   533,   534,
       0,     0,   192,     0,     0,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,     0,   544,
     545,   546,   547,   548,   549,   199,   550,   551,     0,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,     0,
     562,   563,     0,   564,   565,   207,   566,   567,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,     0,   576,
     211,   577,   578,     0,   579,   214,     0,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,     0,
     591,   592,     0,   593,   594,   595,   596,   597,     0,   217,
     218,   598,     0,   599,   219,   600,   220,     0,   601,   602,
     603,   604,   605,     0,     0,   606,   607,   608,   609,     0,
       0,   610,   611,   612,   613,   614,   228,   615,     0,   616,
     617,   618,     0,     0,   619,   620,   621,   622,   623,   624,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,    49,     0,   239,
     628,     0,     0,     0,     0,    52,    53,    54,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
    1031,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,    49,     0,   239,   628,     0,
       0,     0,     0,    52,    53,    54,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   389,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,     0,   407,   408,   409,     0,     0,     0,     0,     0,
       0,     0,   410,   411,     0,   412,     0,   413,   414,   415,
       0,   133,     0,   135,     0,     0,   416,   417,     0,   418,
     419,     0,     0,   420,   421,   136,   422,     0,   423,   424,
     425,   426,   140,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,   143,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,  1906,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,     0,   470,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,     0,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,     0,     0,
     532,     0,     0,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   217,   218,     0,     0,   599,
     219,   600,   220,     0,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,     0,     0,   610,   611,   612,
     613,   614,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,    49,     0,   239,   628,     0,     0,     0,
       0,    52,    53,    54,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   389,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,     0,   413,   414,   415,     0,   133,
       0,   135,     0,     0,   416,   417,     0,   418,   419,     0,
       0,   420,   421,   136,   422,     0,   423,   424,   425,   426,
     140,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   143,   436,   437,     0,   438,   439,   440,
       0,   441,     0,     0,     0,     0,     0,     0,   442,   443,
     444,   445,   446,   149,   150,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,   458,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,   158,   468,   469,   160,
       0,   470,   471,   472,   162,     0,   473,     0,   474,     0,
       0,     0,   475,     0,   476,     0,   477,   167,     0,   478,
       0,   479,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,     0,   170,     0,
     492,   493,   494,     0,   172,     0,   173,     0,     0,     0,
       0,   495,     0,   496,   497,   498,   499,   500,     0,   177,
       0,   501,     0,     0,   502,   503,   504,     0,     0,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   184,     0,   186,     0,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,     0,   528,
       0,   190,   529,   191,   530,   531,     0,     0,   532,     0,
       0,     0,   533,   534,     0,     0,   192,     0,     0,   195,
     535,   536,   537,   538,   539,     0,   540,   196,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,   199,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,     0,   564,   565,   207,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,     0,   576,   211,   577,   578,     0,   579,   214,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   216,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,   217,   218,     0,     0,   599,   219,   600,
     220,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,     0,     0,   610,   611,   612,   613,   614,
     228,   615,     0,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,   231,   232,   233,   234,   235,
     236,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,    49,     0,   239,   628,     0,     0,     0,     0,    52,
      53,    54,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   133,     0,   135,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   136,   422,     0,   423,   424,   425,   426,   140,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   143,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,     0,   954,  1671,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,   955,   388,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   389,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,     0,   413,   414,   415,     0,
     133,     0,   135,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   932,   136,   422,     0,   423,   424,   425,
     426,   140,     0,     0,   427,   428,   429,   430,   431,   956,
       0,   957,   434,   435,   143,   436,   437,     0,   438,   439,
     440,     0,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0,     0,   475,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,   498,   499,   500,     0,
     177,     0,   501,     0,     0,   502,   503,   958,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   959,   184,     0,   186,     0,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   960,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   961,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   962,   218,     0,     0,   963,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
     936,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   964,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,    83,    84,    85,     0,    87,
      88,    89,    90,    91,     0,     0,     0,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,     0,     0,
       0,   105,   106,   107,   108,     0,   109,     0,   110,   111,
     112, -1531,   113,   114,   115,     0,     0,     0,     0,     0,
     118,   119,     0,     0,     0,     0,   120,     0,     0,     0,
       0,     0,     0,     0,     0,   121,     0,   122,     0,   123,
     124,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   130,     0,     0,     0,   132,
     133,   134,   135,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   136,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   143,     0,     0,     0,     0,     0,
       0,   146,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   149,   150,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   156,     0,     0,     0,     0,     0,   158,     0,     0,
     160,     0,     0,     0,     0,   162,     0,     0,     0,     0,
     163,     0,   164,     0,     0,     0,     0,     0,   167,     0,
       0,     0,     0,     0,     0,     0,   168,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   169,   170,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
     174,   175,     0,   176,     0,     0,     0,     0,     0,     0,
     177,   178,     0,   179,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   184,   185,   186,     0,     0,     0,     0,
       0,     0,     0,     0,   187,     0,     0,     0,     0,   189,
       0,     0,   190,     0,   191,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   192,   193,   194,
     195,     0,     0,     0,     0,     0,     0,     0,   196,   197,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     199,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   205,     0,     0,
     207,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   211,     0,     0,   213,     0,
     214,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   216,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   217,   218,     0,     0,     0,   219,
       0,   220,     0,     0,     0,     0,     0,     0,   223,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   228,     0,   229,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   230,   231,   232,   233,   234,
     235,   236,   237,     0,     0,     0,     0,     0,     0,     0,
       0,   238,     0,     0,   239,     0,   380,    83,    84,    85,
       0,    87,    88,    89,    90,    91,     0,     0,     0,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
       0,     0,     0,   105,   106,   107,   108,     0,   109,     0,
     110,   111,   112, -1532,   113,   114,   115,     0,     0,     0,
       0,     0,   118,   119,     0,     0,     0,     0,   120,     0,
       0,     0,     0,     0,     0,     0,     0,   121,     0,   122,
       0,   123,   124,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   130,     0,     0,
       0,   132,   133,   134,   135,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   136,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   143,     0,     0,     0,
       0,     0,     0,   146,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   149,   150,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   156,     0,     0,     0,     0,     0,   158,
       0,     0,   160,     0,     0,     0,     0,   162,     0,     0,
       0,     0,   163,     0,   164,     0,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,     0,     0,   168,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     169,   170,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,   174,   175,     0,   176,     0,     0,     0,     0,
       0,     0,   177,   178,     0,   179,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   184,   185,   186,     0,     0,
       0,     0,     0,     0,     0,     0,   187,     0,     0,     0,
       0,   189,     0,     0,   190,     0,   191,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   192,
     193,   194,   195,     0,     0,     0,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   199,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
       0,     0,   207,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   211,     0,     0,
     213,     0,   214,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   216,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   217,   218,     0,     0,
       0,   219,     0,   220,     0,     0,     0,     0,     0,     0,
     223,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   228,     0,   229,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   230,   231,   232,
     233,   234,   235,   236,   237,     0,     0,     0,     0,     0,
       0,     0,     0,   238,     0,     0,   239,     0,  1025,   663,
      83,    84,    85,   386,    87,    88,    89,    90,    91,   387,
       0,   388,    94,     0,    96,    97,    98,    99,   100,   101,
     664,   102,   103,   389,   665,     0,   105,   106,   107,   108,
     666,   667,     0,   110,   111,   112,     0,   113,   668,   669,
     390,   391,     0,     0,     0,   392,   393,     0,     0,     0,
       0,   394,     0,     0,     0,     0,     0,     0,     0,     0,
     395,     0,   396,     0,   397,   398,     0,   399,   400,   401,
     402,   403,   404,   405,   406,   670,   407,   408,   409,   671,
     672,   673,   674,   675,   676,   677,   410,   411,   678,   412,
     130,   413,   414,   415,   132,   133,   134,   135,     0,   679,
     416,   417,     0,   418,   419,   680,   681,   420,   682,   136,
     422,   683,   423,   424,   425,   426,   140,   684,   685,   427,
     428,   429,   430,   431,   432,   686,   433,   434,   435,   143,
     436,   437,   687,   438,   439,   440,   146,   441,   688,   689,
     690,   691,   692,   693,   442,   443,   444,   445,   446,   149,
     150,   447,   694,   448,   695,   449,     0,   450,   451,   452,
     696,   453,   454,   455,   697,   698,   456,   457,   458,   459,
     460,   699,   461,   462,   463,   700,     0,   464,   701,   465,
     466,   467,   158,   468,   469,   160,   702,   470,   471,   472,
     162,   703,   473,   704,   474,   163,   705,   164,   475,     0,
     476,   706,   477,   167,   707,   478,   708,   479,   480,   481,
     482,   168,   483,   484,   485,   709,   486,   487,   488,   489,
     490,   491,   710,   169,   170,   711,   492,   493,   494,   712,
     172,   713,   173,   714,     0,   174,   175,   495,   176,   496,
     497,   498,   499,   500,   715,   177,   178,   501,   179,   716,
     502,   503,   504,     0,     0,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   517,   184,   185,
     186,   717,   518,   519,   520,   521,   522,   523,   524,   187,
     525,   718,   526,   527,   189,   528,   719,   190,   529,   191,
     530,   531,   720,   721,   532,   722,   723,   724,   533,   534,
     725,   726,   192,   193,   194,   195,   535,   536,   537,   538,
     539,     0,   540,   196,   197,   541,   542,   543,   727,   544,
     545,   546,   547,   548,   549,   199,   550,   551,   728,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   561,   729,
     562,   563,   205,   564,   565,   207,   566,   567,   568,   569,
     570,   571,   572,     0,   730,   573,   574,   575,   731,   576,
     211,   577,   578,   213,   579,   214,   732,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   216,   590,   733,
     591,   592,   734,   593,   594,   595,   596,   597,   735,   217,
     218,   736,   737,   599,   219,   600,   220,   738,   601,   602,
     603,   604,   605,   739,   740,   606,   607,   608,   609,   741,
     742,   610,   611,   612,   613,     0,   228,   615,   229,   616,
     617,   618,   743,   744,   619,   620,   621,   622,   623,   624,
     230,   231,   232,   233,   234,   235,   236,   237,   625,   626,
     627,     0,     0,     0,     0,     0,   238,     0,     0,   239,
     663,    83,    84,    85,   386,    87,    88,    89,    90,    91,
     387,     0,   388,    94,     0,    96,    97,    98,    99,   100,
     101,   664,   102,   103,   389,   665,     0,   105,   106,   107,
     108,   666,   667,     0,   110,   111,   112,     0,   113,   668,
     669,   390,   391,     0,     0,     0,   392,   393,     0,     0,
       0,     0,   394,     0,     0,     0,     0,     0,     0,     0,
       0,   395,     0,   396,     0,   397,   398,     0,   399,   400,
     401,   402,   403,   404,   405,   406,     0,   407,   408,   409,
       0,     0,     0,     0,     0,     0,     0,   410,   411,     0,
     412,   130,   413,   414,   415,   132,   133,   134,   135,     0,
       0,   416,   417,     0,   418,   419,     0,     0,   420,   421,
     136,   422,     0,   423,   424,   425,   426,   140,     0,     0,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
     143,   436,   437,     0,   438,   439,   440,   146,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
     149,   150,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,   458,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,   158,   468,   469,   160,     0,   470,   471,
     472,   162,     0,   473,     0,   474,   163,     0,   164,   475,
       0,   476,     0,   477,   167,     0,   478,     0,   479,   480,
     481,   482,   168,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,   169,   170,     0,   492,   493,   494,
       0,   172,     0,   173,     0,     0,   174,   175,   495,   176,
     496,   497,   498,   499,   500,     0,   177,   178,   501,   179,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,   184,
     185,   186,   792,   518,   519,   520,   521,   522,   523,   524,
     187,   525,     0,   526,   527,   189,   528,     0,   190,   529,
     191,   530,   531,     0,     0,   532,   793,     0,     0,   533,
     534,     0,     0,   192,   193,   194,   195,   535,   536,   537,
     538,   539,     0,   540,   196,   197,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,   199,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,   205,   564,   565,   207,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,     0,
     576,   211,   577,   578,   213,   579,   214,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   216,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
     217,   218,     0,     0,   599,   219,   600,   220,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,   614,   228,   615,   229,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,   230,   231,   232,   233,   234,   235,   236,   237,   625,
     626,   627,     0,     0,     0,     0,     0,   238,     0,     0,
     239,   663,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,   664,   102,   103,   389,   665,     0,   105,   106,
     107,   108,   666,   667,     0,   110,   111,   112,     0,   113,
     668,   669,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,   130,   413,   414,   415,   132,   133,   134,   135,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   136,   422,     0,   423,   424,   425,   426,   140,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   143,   436,   437,     0,   438,   439,   440,   146,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,   163,     0,   164,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,  1184,   168,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,   169,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,   174,   175,   495,
     176,   496,   497,   498,   499,   500,     0,   177,   178,   501,
     179,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,   185,   186,   792,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,   189,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,   793,     0,     0,
     533,   534,     0,     0,   192,   193,   194,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,   205,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,   213,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
     229,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,   663,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,   664,   102,   103,   389,   665,     0,   105,
     106,   107,   108,   666,   667,     0,   110,   111,   112,     0,
     113,   668,   669,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,     0,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,   130,   413,   414,   415,   132,   133,   134,
     135,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   136,   422,     0,   423,   424,   425,   426,   140,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   143,   436,   437,     0,   438,   439,   440,   146,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,     0,
     470,   471,   472,   162,     0,   473,     0,   474,   163,     0,
     164,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,  1191,   168,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,   169,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,   174,   175,
     495,   176,   496,   497,   498,   499,   500,     0,   177,   178,
     501,   179,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,   185,   186,   792,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,   189,   528,     0,
     190,   529,   191,   530,   531,     0,     0,   532,   793,     0,
       0,   533,   534,     0,     0,   192,   193,   194,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,   205,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,   211,   577,   578,   213,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,   614,   228,
     615,   229,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,   663,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,   664,   102,   103,   389,   665,     0,
     105,   106,   107,   108,   666,   667,     0,   110,   111,   112,
       0,   113,   668,   669,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,   130,   413,   414,   415,   132,  1601,
     134,  1602,  1274,     0,   416,   417,     0,   418,   419,     0,
       0,   420,  1603,  1604,   422,     0,   423,   424,   425,   426,
       0,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,     0,   436,   437,     0,   438,   439,   440,
     146,   441,     0,     0,     0,     0,     0,     0,   442,   443,
     444,   445,   446,  1605,  1606,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,  1288,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,     0,   468,   469,     0,
       0,   470,   471,   472,  1607,     0,   473,     0,   474,   163,
       0,   164,   475,     0,   476,     0,   477,     0,     0,   478,
       0,   479,   480,   481,   482,   168,   483,   484,   485,  2048,
     486,   487,   488,   489,   490,   491,     0,   169,  2049,     0,
     492,   493,   494,  1294,  1608,     0,  1609,     0,     0,   174,
     175,   495,   176,   496,   497,   498,   499,   500,     0,     0,
     178,   501,   179,     0,   502,   503,   504,     0,     0,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,  1610,   185,  1611,     0,   518,   519,   520,   521,
     522,   523,   524,     0,   525,     0,   526,   527,   189,   528,
       0,     0,   529,  1612,   530,   531,     0,     0,   532,     0,
       0,     0,   533,   534,     0,     0,  2050,   193,   194,     0,
     535,   536,   537,   538,   539,     0,   540,     0,     0,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,  1613,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,   205,   564,   565,     0,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,     0,   576,  2051,   577,   578,   213,   579,  1615,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,     0,   590,     0,   591,   592,     0,   593,   594,   595,
     596,   597,     0,  1616,  1617,     0,     0,   599,     0,   600,
       0,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,     0,     0,   610,   611,   612,   613,     0,
    1618,   615,   229,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,     0,     0,     0,     0,     0,     0,
       0,     0,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,    83,    84,    85,   386,    87,    88,
      89,    90,    91,   387,     0,   388,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   389,     0,     0,
     105,   106,   107,   108,     0,     0,  1463,   110,   111,   112,
       0,   113,     0,     0,   390,   391,     0,     0,     0,   392,
     393,     0,     0,     0,     0,   394,     0,     0,     0,     0,
       0,     0,     0,     0,   395,     0,   396,     0,   397,   398,
       0,   399,   400,   401,   402,   403,   404,   405,   406,     0,
     407,   408,   409,     0,     0,     0,     0,     0,     0,     0,
     410,   411,     0,   412,     0,   413,   414,   415,     0,   133,
       0,   135,     0,     0,   416,   417,     0,   418,   419,     0,
       0,   420,   421,   136,   422,     0,   423,   424,   425,   426,
     140,     0,     0,   427,   428,   429,   430,   431,   432,     0,
     433,   434,   435,   143,   436,   437,     0,   438,   439,   440,
       0,   441,     0,     0,     0,     0,     0,     0,   442,   443,
     444,   445,   446,   149,   150,   447,     0,   448,     0,   449,
       0,   450,   451,   452,     0,   453,   454,   455,     0,     0,
     456,   457,   458,   459,   460,     0,   461,   462,   463,     0,
       0,   464,     0,   465,   466,   467,   158,   468,   469,   160,
       0,   470,   471,   472,   162,     0,   473,     0,   474,     0,
       0,     0,   475,     0,  2464,     0,   477,   167,     0,   478,
       0,   479,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   490,   491,     0,     0,   170,     0,
     492,   493,   494,     0,   172,     0,   173,     0,     0,     0,
       0,   495,     0,   496,   497,   498,   499,   500,     0,   177,
       0,   501,     0,     0,   502,   503,  2465,     0,     0,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   184,     0,   186,   792,   518,   519,   520,   521,
     522,   523,   524,   187,   525,     0,   526,   527,     0,   528,
       0,   190,   529,   191,   530,   531,     0,     0,   532,   793,
       0,     0,   533,   534,     0,     0,   192,     0,     0,   195,
     535,   536,   537,   538,   539,     0,   540,   196,   197,   541,
     542,   543,     0,   544,   545,   546,   547,   548,   549,   199,
     550,   551,     0,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   561,     0,   562,   563,     0,   564,   565,   207,
     566,   567,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,     0,   576,   211,   577,   578,     0,   579,   214,
       0,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   216,   590,     0,   591,   592,  2466,   593,  2467,   595,
    2468,   597,     0,   217,   218,     0,     0,   599,   219,   600,
     220,     0,   601,   602,   603,   604,   605,     0,     0,   606,
     607,   608,   609,     0,     0,   610,   611,   612,   613,   614,
     228,   615,     0,   616,   617,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   230,   231,   232,   233,   234,   235,
     236,   237,   625,   626,   627,     0,     0,     0,     0,     0,
     238,     0,     0,   239,   628,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   389,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
     650,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,     0,   413,   414,   415,     0,
     133,     0,   135,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   136,   422,     0,   423,   424,   425,
     426,   140,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   143,   436,   437,     0,   438,   439,
     440,     0,   441,   651,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,   652,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0,     0,   475,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,   498,   499,   500,     0,
     177,     0,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184,     0,   186,     0,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   564,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
     614,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,   628,   663,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
       0,    96,    97,    98,    99,   100,   101,   664,   102,   103,
     389,   665,     0,   105,   106,   107,   108,   666,   667,     0,
     110,   111,   112,     0,   113,   668,   669,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,     0,   407,   408,   409,     0,     0,     0,     0,
       0,     0,     0,   410,   411,     0,   412,   130,   413,   414,
     415,   132,  1601,   134,  1602,  1274,     0,   416,   417,     0,
     418,   419,     0,     0,   420,  1603,  1604,   422,     0,   423,
     424,   425,   426,     0,     0,     0,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,     0,   436,   437,     0,
     438,   439,   440,   146,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,  1605,  1606,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,  1288,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,     0,
     468,   469,     0,     0,   470,   471,   472,  1607,     0,   473,
       0,   474,   163,     0,   164,   475,     0,   476,     0,   477,
       0,     0,   478,     0,   479,   480,   481,   482,   168,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
     169,     0,     0,   492,   493,   494,  1294,  1608,     0,  1609,
       0,     0,   174,   175,   495,   176,   496,   497,   498,   499,
     500,     0,     0,   178,   501,   179,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,  1610,   185,  1611,     0,   518,
     519,   520,   521,   522,   523,   524,  2070,   525,     0,   526,
     527,   189,   528,     0,     0,   529,  1612,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,     0,
     193,   194,     0,   535,   536,   537,   538,   539,     0,   540,
       0,     0,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,  1613,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,   205,
     564,   565,     0,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,  1614,   577,   578,
     213,   579,  1615,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,     0,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,  1616,  1617,     0,     0,
     599,     0,   600,     0,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,     0,  1618,   615,   229,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,     0,     0,     0,
       0,     0,     0,     0,     0,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,   663,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,   664,   102,
     103,   389,   665,     0,   105,   106,   107,   108,   666,   667,
       0,   110,   111,   112,     0,   113,   668,   669,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,   130,   413,
     414,   415,   132,  1601,   134,  1602,  1274,     0,   416,   417,
       0,   418,   419,     0,     0,   420,  1603,  1604,   422,     0,
     423,   424,   425,   426,     0,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,     0,   436,   437,
       0,   438,   439,   440,   146,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,  1605,  1606,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,  1288,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
       0,   468,   469,     0,     0,   470,   471,   472,  1607,     0,
     473,     0,   474,   163,     0,   164,   475,     0,   476,     0,
     477,     0,     0,   478,     0,   479,   480,   481,   482,   168,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,   169,     0,     0,   492,   493,   494,  1294,  1608,     0,
    1609,     0,     0,   174,   175,   495,   176,   496,   497,   498,
     499,   500,     0,     0,   178,   501,   179,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,  1610,   185,  1611,     0,
     518,   519,   520,   521,   522,   523,   524,  3027,   525,     0,
     526,   527,   189,   528,     0,     0,   529,  1612,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
       0,   193,   194,     0,   535,   536,   537,   538,   539,     0,
     540,     0,     0,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,  1613,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
     205,   564,   565,     0,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,  1614,   577,
     578,   213,   579,  1615,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,     0,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,  1616,  1617,     0,
       0,   599,     0,   600,     0,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,     0,  1618,   615,   229,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,     0,     0,
       0,     0,     0,     0,     0,     0,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,   663,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,     0,
     388,    94,     0,    96,    97,    98,    99,   100,   101,   664,
     102,   103,   389,   665,     0,   105,   106,   107,   108,   666,
     667,     0,   110,   111,   112,     0,   113,   668,   669,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,     0,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,   130,
     413,   414,   415,   132,  1601,   134,  1602,  1274,     0,   416,
     417,     0,   418,   419,     0,     0,   420,  1603,  1604,   422,
       0,   423,   424,   425,   426,     0,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,     0,   436,
     437,     0,   438,   439,   440,   146,   441,     0,     0,     0,
       0,     0,     0,   442,   443,   444,   445,   446,  1605,  1606,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,  1288,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,     0,   468,   469,     0,     0,   470,   471,   472,  1607,
       0,   473,     0,   474,   163,     0,   164,   475,     0,   476,
       0,   477,     0,     0,   478,     0,   479,   480,   481,   482,
     168,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,   169,     0,     0,   492,   493,   494,  1294,  1608,
       0,  1609,     0,     0,   174,   175,   495,   176,   496,   497,
     498,   499,   500,     0,     0,   178,   501,   179,     0,   502,
     503,   504,     0,     0,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,  1610,   185,  1611,
       0,   518,   519,   520,   521,   522,   523,   524,     0,   525,
       0,   526,   527,   189,   528,  2040,     0,   529,  1612,   530,
     531,     0,     0,   532,     0,     0,     0,   533,   534,     0,
       0,     0,   193,   194,     0,   535,   536,   537,   538,   539,
       0,   540,     0,     0,   541,   542,   543,     0,   544,   545,
     546,   547,   548,   549,  1613,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,   205,   564,   565,     0,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,     0,   576,  2051,
     577,   578,   213,   579,  1615,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,     0,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,  1616,  1617,
       0,     0,   599,     0,   600,     0,     0,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,     0,     0,
     610,   611,   612,   613,     0,  1618,   615,   229,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,     0,
       0,     0,     0,     0,     0,     0,     0,   625,   626,   627,
       0,     0,     0,     0,     0,   238,     0,     0,   239,    83,
      84,    85,   386,    87,    88,    89,    90,    91,   387,   839,
     388,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   389,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   390,
     391,     0,     0,     0,   392,   393,     0,     0,     0,     0,
     394,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,   397,   398,     0,   399,   400,   401,   402,
     403,   404,   405,   406,   840,   407,   408,   409,     0,     0,
       0,     0,     0,     0,     0,   410,   411,     0,   412,     0,
     413,   414,   415,     0,   133,     0,   135,     0,     0,   416,
     417,     0,   418,   419,     0,     0,   420,   421,   136,   422,
       0,   423,   424,   425,   426,   140,     0,     0,   427,   428,
     429,   430,   431,   432,     0,   433,   434,   435,   143,   436,
     437,     0,   438,   439,   440,     0,   441,     0,     0,     0,
       0,     0,     0,   442,   443,   444,   445,   446,   149,   150,
     447,     0,   448,     0,   449,     0,   450,   451,   452,     0,
     453,   454,   455,     0,     0,   456,   457,   458,   459,   460,
       0,   461,   462,   463,     0,     0,   464,     0,   465,   466,
     467,   158,   468,   469,   160,     0,   470,   471,   472,   162,
       0,   473,     0,   474,     0,     0,     0,   475,     0,   476,
       0,   477,   167,     0,   478,     0,   479,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   490,
     491,     0,     0,   170,     0,   492,   493,   494,     0,   172,
       0,   173,     0,     0,     0,     0,   495,     0,   496,   497,
     498,   499,   500,     0,   177,     0,   501,     0,     0,   502,
     503,   504,     0,     0,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   517,   184,     0,   186,
       0,   518,   519,   520,   521,   522,   523,   524,   187,   525,
       0,   526,   527,     0,   528,     0,   190,   529,   191,   530,
     531,     0,     0,   532,     0,     0,     0,   533,   534,     0,
       0,   192,     0,     0,   195,   535,   536,   537,   538,   539,
       0,   540,   196,   197,   541,   841,   543,     0,   544,   545,
     546,   547,   548,   549,   199,   550,   551,     0,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   561,     0,   562,
     563,     0,   564,   565,   207,   566,   567,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,     0,   576,   211,
     577,   578,     0,   579,   214,     0,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   216,   590,     0,   591,
     592,     0,   593,   594,   595,   596,   597,     0,   217,   218,
       0,     0,   599,   219,   600,   220,     0,   601,   602,   603,
     604,   605,     0,     0,   606,   607,   608,   609,     0,     0,
     610,   611,   612,   613,   614,   228,   615,     0,   616,   617,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   230,
     231,   232,   233,   234,   235,   236,   237,   625,   626,   627,
       0,     0,     0,     0,     0,   238,     0,     0,   239,   628,
     663,    83,    84,    85,   386,    87,    88,    89,    90,    91,
     387,     0,   388,    94,     0,    96,    97,    98,    99,   100,
     101,   664,   102,   103,   389,   665,     0,   105,   106,   107,
     108,   666,   667,     0,   110,   111,   112,     0,   113,   668,
     669,   390,   391,     0,     0,     0,   392,   393,     0,     0,
       0,     0,   394,     0,     0,     0,     0,     0,     0,     0,
       0,   395,     0,   396,     0,   397,   398,     0,   399,   400,
     401,   402,   403,   404,   405,   406,     0,   407,   408,   409,
       0,     0,     0,     0,     0,     0,     0,   410,   411,     0,
     412,   130,   413,   414,   415,   132,  1601,   134,  1602,  1274,
       0,   416,   417,     0,   418,   419,     0,     0,   420,  1603,
    1604,   422,     0,   423,   424,   425,   426,     0,     0,     0,
     427,   428,   429,   430,   431,   432,     0,   433,   434,   435,
       0,   436,   437,     0,   438,   439,   440,   146,   441,     0,
       0,     0,     0,     0,     0,   442,   443,   444,   445,   446,
    1605,  1606,   447,     0,   448,     0,   449,     0,   450,   451,
     452,     0,   453,   454,   455,     0,     0,   456,   457,  1288,
     459,   460,     0,   461,   462,   463,     0,     0,   464,     0,
     465,   466,   467,     0,   468,   469,     0,     0,   470,   471,
     472,  1607,     0,   473,     0,   474,   163,     0,   164,   475,
       0,   476,     0,   477,     0,     0,   478,     0,   479,   480,
     481,   482,   168,   483,   484,   485,     0,   486,   487,   488,
     489,   490,   491,     0,   169,     0,     0,   492,   493,   494,
    1294,  1608,     0,  1609,     0,     0,   174,   175,   495,   176,
     496,   497,   498,   499,   500,     0,     0,   178,   501,   179,
       0,   502,   503,   504,     0,     0,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   517,  1610,
     185,  1611,     0,   518,   519,   520,   521,   522,   523,   524,
       0,   525,     0,   526,   527,   189,   528,     0,     0,   529,
    1612,   530,   531,     0,     0,   532,     0,     0,     0,   533,
     534,     0,     0,     0,   193,   194,     0,   535,   536,   537,
     538,   539,     0,   540,     0,     0,   541,   542,   543,     0,
     544,   545,   546,   547,   548,   549,  1613,   550,   551,     0,
     552,   553,   554,   555,   556,   557,   558,   559,   560,   561,
       0,   562,   563,   205,   564,   565,     0,   566,   567,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,     0,
     576,  1614,   577,   578,   213,   579,  1615,     0,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,     0,   590,
       0,   591,   592,     0,   593,   594,   595,   596,   597,     0,
    1616,  1617,     0,     0,   599,     0,   600,     0,     0,   601,
     602,   603,   604,   605,     0,     0,   606,   607,   608,   609,
       0,     0,   610,   611,   612,   613,     0,  1618,   615,   229,
     616,   617,   618,     0,     0,   619,   620,   621,   622,   623,
     624,     0,     0,     0,     0,     0,     0,     0,     0,   625,
     626,   627,     0,     0,     0,     0,     0,   238,     0,     0,
     239,   663,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,   664,   102,   103,   389,   665,     0,   105,   106,
     107,   108,   666,   667,     0,   110,   111,   112,     0,   113,
     668,   669,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,   130,   413,   414,   415,   132,  1601,   134,  1602,
    1274,     0,   416,   417,     0,   418,   419,     0,     0,   420,
    1603,  1604,   422,     0,   423,   424,   425,   426,     0,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,     0,   436,   437,     0,   438,   439,   440,   146,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,  1605,  1606,   447,     0,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
    1288,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,     0,   468,   469,     0,     0,   470,
     471,   472,  1607,     0,   473,     0,   474,   163,     0,   164,
     475,     0,   476,     0,   477,     0,     0,   478,     0,   479,
     480,   481,   482,   168,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,   169,     0,     0,   492,   493,
     494,  1294,  1608,     0,  1609,     0,     0,   174,   175,   495,
     176,   496,   497,   498,   499,   500,     0,     0,   178,   501,
     179,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
    1610,   185,  1611,     0,   518,   519,   520,   521,   522,   523,
     524,     0,   525,     0,   526,   527,   189,   528,     0,     0,
     529,  1612,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,     0,   193,   194,     0,   535,   536,
     537,   538,   539,     0,   540,     0,     0,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,  1613,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,   205,   564,   565,     0,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,  2051,   577,   578,   213,   579,  1615,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,     0,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,  1616,  1617,     0,     0,   599,     0,   600,     0,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,     0,  1618,   615,
     229,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,     0,     0,     0,     0,     0,     0,     0,     0,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,    83,    84,    85,   386,    87,    88,    89,    90,
      91,   387,     0,   388,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   389,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   390,   391,     0,     0,     0,   392,   393,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,   395,     0,   396,     0,   397,   398,     0,   399,
     400,   401,   402,   403,   404,   405,   406,     0,   407,   408,
     409,     0,     0,     0,     0,     0,     0,     0,   410,   411,
       0,   412,     0,   413,   414,   415,     0,   133,     0,   135,
       0,     0,   416,   417,     0,   418,   419,     0,     0,   420,
     421,   136,   422,     0,   423,   424,   425,   426,   140,     0,
       0,   427,   428,   429,   430,   431,   432,     0,   433,   434,
     435,   143,   436,   437,     0,   438,   439,   440,     0,   441,
       0,     0,     0,     0,     0,     0,   442,   443,   444,   445,
     446,   149,   150,   447,   652,   448,     0,   449,     0,   450,
     451,   452,     0,   453,   454,   455,     0,     0,   456,   457,
     458,   459,   460,     0,   461,   462,   463,     0,     0,   464,
       0,   465,   466,   467,   158,   468,   469,   160,     0,   470,
     471,   472,   162,     0,   473,     0,   474,     0,     0,     0,
     475,     0,   476,     0,   477,   167,     0,   478,     0,   479,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   490,   491,     0,     0,   170,     0,   492,   493,
     494,     0,   172,     0,   173,     0,     0,     0,     0,   495,
       0,   496,   497,   498,   499,   500,     0,   177,     0,   501,
       0,     0,   502,   503,   504,     0,     0,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     184,     0,   186,     0,   518,   519,   520,   521,   522,   523,
     524,   187,   525,     0,   526,   527,     0,   528,     0,   190,
     529,   191,   530,   531,     0,     0,   532,     0,     0,     0,
     533,   534,     0,     0,   192,     0,     0,   195,   535,   536,
     537,   538,   539,     0,   540,   196,   197,   541,   542,   543,
       0,   544,   545,   546,   547,   548,   549,   199,   550,   551,
       0,   552,   553,   554,   555,   556,   557,   558,   559,   560,
     561,     0,   562,   563,     0,   564,   565,   207,   566,   567,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
       0,   576,   211,   577,   578,     0,   579,   214,     0,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   216,
     590,     0,   591,   592,     0,   593,   594,   595,   596,   597,
       0,   217,   218,     0,     0,   599,   219,   600,   220,     0,
     601,   602,   603,   604,   605,     0,     0,   606,   607,   608,
     609,     0,     0,   610,   611,   612,   613,   614,   228,   615,
       0,   616,   617,   618,     0,     0,   619,   620,   621,   622,
     623,   624,   230,   231,   232,   233,   234,   235,   236,   237,
     625,   626,   627,     0,     0,     0,     0,     0,   238,     0,
       0,   239,   628,    83,    84,    85,   386,    87,    88,    89,
      90,    91,   387,     0,   388,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   389,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   390,   391,     0,     0,     0,   392,   393,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,   395,     0,   396,     0,   397,   398,     0,
     399,   400,   401,   402,   403,   404,   405,   406,  1179,   407,
     408,   409,     0,     0,     0,     0,     0,     0,     0,   410,
     411,     0,   412,     0,   413,   414,   415,     0,   133,     0,
     135,     0,     0,   416,   417,     0,   418,   419,     0,     0,
     420,   421,   136,   422,     0,   423,   424,   425,   426,   140,
       0,     0,   427,   428,   429,   430,   431,   432,     0,   433,
     434,   435,   143,   436,   437,     0,   438,   439,   440,     0,
     441,     0,     0,     0,     0,     0,     0,   442,   443,   444,
     445,   446,   149,   150,   447,     0,   448,     0,   449,     0,
     450,   451,   452,     0,   453,   454,   455,     0,     0,   456,
     457,   458,   459,   460,     0,   461,   462,   463,     0,     0,
     464,     0,   465,   466,   467,   158,   468,   469,   160,     0,
     470,   471,   472,   162,     0,   473,     0,   474,     0,     0,
       0,   475,     0,   476,     0,   477,   167,     0,   478,     0,
     479,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   490,   491,     0,     0,   170,     0,   492,
     493,   494,     0,   172,     0,   173,     0,     0,     0,     0,
     495,     0,   496,   497,   498,   499,   500,     0,   177,     0,
     501,     0,     0,   502,   503,   504,     0,     0,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     517,   184,     0,   186,     0,   518,   519,   520,   521,   522,
     523,   524,   187,   525,     0,   526,   527,     0,   528,     0,
     190,   529,   191,   530,   531,     0,     0,   532,     0,     0,
       0,   533,   534,     0,     0,   192,     0,     0,   195,   535,
     536,   537,   538,   539,     0,   540,   196,   197,   541,   542,
     543,     0,   544,   545,   546,   547,   548,   549,   199,   550,
     551,     0,   552,   553,   554,   555,   556,   557,   558,   559,
     560,   561,     0,   562,   563,     0,   564,   565,   207,   566,
     567,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,     0,   576,   211,   577,   578,     0,   579,   214,     0,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     216,   590,     0,   591,   592,     0,   593,   594,   595,   596,
     597,     0,   217,   218,     0,     0,   599,   219,   600,   220,
       0,   601,   602,   603,   604,   605,     0,     0,   606,   607,
     608,   609,     0,     0,   610,   611,   612,   613,   614,   228,
     615,     0,   616,   617,   618,     0,     0,   619,   620,   621,
     622,   623,   624,   230,   231,   232,   233,   234,   235,   236,
     237,   625,   626,   627,     0,     0,     0,     0,     0,   238,
       0,     0,   239,   628,   663,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,   664,   102,   103,   389,   665,
       0,   105,   106,   107,   108,   666,   667,     0,   110,   111,
     112,     0,   113,   668,   669,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,   130,   413,   414,   415,   132,
    1601,   134,  1602,  1274,     0,   416,   417,     0,   418,   419,
       0,     0,   420,  1603,  1604,   422,     0,   423,   424,   425,
     426,     0,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,     0,   436,   437,     0,   438,   439,
     440,   146,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,  1605,  1606,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,  1288,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,     0,   468,   469,
       0,     0,   470,   471,   472,  1607,     0,   473,     0,   474,
     163,     0,   164,   475,     0,   476,     0,   477,     0,     0,
     478,     0,   479,   480,   481,   482,   168,   483,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,   169,     0,
       0,   492,   493,   494,  1294,  1608,     0,  1609,     0,     0,
     174,   175,   495,   176,   496,   497,   498,   499,   500,     0,
       0,   178,   501,   179,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,  1610,   185,  1611,     0,   518,   519,   520,
     521,   522,   523,   524,     0,   525,     0,   526,   527,   189,
     528,     0,     0,   529,  1612,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,     0,   193,   194,
       0,   535,   536,   537,   538,   539,     0,   540,     0,     0,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
    1613,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,   205,   564,   565,
       0,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,     0,   576,     0,   577,   578,   213,   579,
    1615,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,     0,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,  1616,  1617,     0,     0,   599,     0,
     600,     0,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
       0,  1618,   615,   229,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,     0,     0,     0,     0,     0,
       0,     0,     0,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,    83,    84,    85,   386,    87,
      88,    89,    90,    91,   387,     0,   388,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   389,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   390,   391,     0,     0,     0,
     392,   393,     0,     0,     0,     0,   394,     0,     0,     0,
       0,     0,     0,     0,     0,   395,     0,   396,     0,   397,
     398,     0,   399,   400,   401,   402,   403,   404,   405,   406,
       0,   407,   408,   409,     0,     0,     0,     0,     0,     0,
       0,   410,   411,     0,   412,     0,   413,   414,   415,     0,
     133,     0,   135,     0,     0,   416,   417,     0,   418,   419,
       0,     0,   420,   421,   136,   422,     0,   423,   424,   425,
     426,   140,     0,     0,   427,   428,   429,   430,   431,   432,
       0,   433,   434,   435,   143,   436,   437,     0,   438,   439,
     440,     0,   441,     0,     0,     0,     0,     0,     0,   442,
     443,   444,   445,   446,   149,   150,   447,     0,   448,     0,
     449,     0,   450,   451,   452,     0,   453,   454,   455,     0,
       0,   456,   457,   458,   459,   460,     0,   461,   462,   463,
       0,     0,   464,     0,   465,   466,   467,   158,   468,   469,
     160,     0,   470,   471,   472,   162,     0,   473,     0,   474,
       0,     0,     0,   475,     0,   476,     0,   477,   167,     0,
     478,     0,   479,   480,   481,   482,     0,   880,   484,   485,
       0,   486,   487,   488,   489,   490,   491,     0,     0,   170,
       0,   492,   493,   494,     0,   172,     0,   173,     0,     0,
       0,     0,   495,     0,   496,   497,   498,   499,   500,     0,
     177,     0,   501,     0,     0,   502,   503,   504,     0,     0,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   184,     0,   186,     0,   518,   519,   520,
     521,   522,   523,   524,   187,   525,     0,   526,   527,     0,
     528,     0,   190,   529,   191,   530,   531,     0,     0,   532,
       0,     0,     0,   533,   534,     0,     0,   192,     0,     0,
     195,   535,   536,   537,   538,   539,     0,   540,   196,   197,
     541,   542,   543,     0,   544,   545,   546,   547,   548,   549,
     199,   550,   551,     0,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,     0,   562,   563,     0,   564,   565,
     207,   566,   567,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,     0,   576,   211,   577,   578,     0,   579,
     214,     0,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   216,   590,     0,   591,   592,     0,   593,   594,
     595,   596,   597,     0,   217,   218,     0,     0,   599,   219,
     600,   220,     0,   601,   602,   603,   604,   605,     0,     0,
     606,   607,   608,   609,     0,     0,   610,   611,   612,   613,
     614,   228,   615,     0,   616,   617,   618,     0,     0,   619,
     620,   621,   622,   623,   624,   230,   231,   232,   233,   234,
     235,   236,   237,   625,   626,   627,     0,     0,     0,     0,
       0,   238,     0,     0,   239,   628,    83,    84,    85,   386,
      87,    88,    89,    90,    91,   387,     0,   388,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   389,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   390,   391,     0,     0,
       0,   392,   393,     0,     0,     0,     0,   394,     0,     0,
       0,     0,     0,     0,     0,     0,   395,     0,   396,     0,
     397,   398,     0,   399,   400,   401,   402,   403,   404,   405,
     406,     0,   407,   408,   409,     0,     0,     0,     0,     0,
       0,     0,   410,   411,     0,   412,     0,   413,   414,   415,
       0,   133,     0,   135,     0,     0,   416,   417,     0,   418,
     419,     0,     0,   420,   421,   136,   422,     0,   423,   424,
     425,   426,   140,     0,     0,   427,   428,   429,   430,   431,
     432,     0,   433,   434,   435,   143,   436,   437,     0,   438,
     439,   440,     0,   441,     0,     0,     0,     0,     0,     0,
     442,   443,   444,   445,   446,   149,   150,   447,     0,   448,
       0,   449,     0,   450,   451,   452,     0,   453,   454,   455,
       0,     0,   456,   457,   458,   459,   460,     0,   461,   462,
     463,     0,     0,   464,     0,   465,   466,   467,   158,   468,
     469,   160,     0,   470,   471,   472,   162,     0,   473,     0,
     474,     0,     0,     0,   475,     0,   476,     0,   477,   167,
       0,   478,     0,   479,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   490,   491,     0,     0,
     170,     0,   492,   493,   494,     0,   172,     0,   173,     0,
       0,     0,     0,   495,     0,   496,   497,   498,   499,   500,
       0,   177,     0,   501,     0,     0,   502,   503,   504,     0,
       0,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   517,   184,     0,   186,     0,   518,   519,
     520,   521,   522,   523,   524,   187,   525,     0,   526,   527,
       0,   528,     0,   190,   529,   191,   530,   531,     0,     0,
     532,     0,     0,     0,   533,   534,     0,     0,   192,     0,
       0,   195,   535,   536,   537,   538,   539,     0,   540,   196,
     197,   541,   542,   543,     0,   544,   545,   546,   547,   548,
     549,   199,   550,   551,     0,   552,   553,   554,   555,   556,
     557,   558,   559,   560,   561,     0,   562,   563,     0,   564,
     565,   207,   566,   567,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,     0,   576,   211,   577,   578,     0,
     579,   214,     0,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   216,   590,     0,   591,   592,     0,   593,
     594,   595,   596,   597,     0,   217,   218,     0,     0,   921,
     219,   600,   220,     0,   601,   602,   603,   604,   605,     0,
       0,   606,   607,   608,   609,     0,     0,   610,   611,   612,
     613,   614,   228,   615,     0,   616,   617,   618,     0,     0,
     619,   620,   621,   622,   623,   624,   230,   231,   232,   233,
     234,   235,   236,   237,   625,   626,   627,     0,     0,     0,
       0,     0,   238,     0,     0,   239,   628,    83,    84,    85,
     386,    87,    88,    89,    90,    91,   387,     0,   388,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     389,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   390,   391,     0,
       0,     0,   392,   393,     0,     0,     0,     0,   394,     0,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,   397,   398,     0,   399,   400,   401,   402,   403,   404,
     405,   406,     0,   407,   408,   409,     0,     0,     0,     0,
       0,     0,     0,   410,   411,     0,   412,     0,   413,   414,
     415,     0,   133,     0,   135,     0,     0,   416,   417,     0,
     418,   419,     0,     0,   420,   421,   136,   422,     0,   423,
     424,   425,   426,   140,     0,     0,   427,   428,   429,   430,
     431,   432,     0,   433,   434,   435,   143,   436,   437,     0,
     438,   439,   440,     0,   441,     0,     0,     0,     0,     0,
       0,   442,   443,   444,   445,   446,   149,   150,   447,     0,
     448,     0,   449,     0,   450,   451,   452,     0,   453,   454,
     455,     0,     0,   456,   457,   458,   459,   460,     0,   461,
     462,   463,     0,     0,   464,     0,   465,   466,   467,   158,
     468,   469,   160,     0,   470,   471,   472,   162,     0,   473,
       0,   474,     0,     0,     0,   475,     0,   476,     0,   477,
     167,     0,   478,     0,   479,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   490,   491,     0,
       0,   170,     0,   492,   493,   494,     0,   172,     0,   173,
       0,     0,     0,     0,   495,     0,   496,   497,   498,   499,
     500,     0,   177,     0,   501,     0,     0,   502,   503,   504,
       0,     0,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   517,   184,     0,   186,     0,   518,
     519,   520,   521,   522,   523,   524,   187,   525,     0,   526,
     527,     0,   528,     0,   190,   529,   191,   530,   531,     0,
       0,   532,     0,     0,     0,   533,   534,     0,     0,   192,
       0,     0,   195,   535,   536,   537,   538,   539,     0,   540,
     196,   197,   541,   542,   543,     0,   544,   545,   546,   547,
     548,   549,   199,   550,   551,     0,   552,   553,   554,   555,
     556,   557,   558,   559,   560,   561,     0,   562,   563,     0,
     564,   565,   207,   566,   567,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,     0,   576,   211,   577,   578,
       0,   579,   214,     0,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   216,   590,     0,   591,   592,     0,
     593,   594,   595,   596,   597,     0,   217,   218,     0,     0,
     599,   219,   600,   220,     0,   601,   602,   603,   604,   605,
       0,     0,   606,   607,   608,   609,     0,     0,   610,   611,
     612,   613,   614,   228,   615,     0,   616,   617,   618,     0,
       0,   619,   620,   621,   622,   623,   624,   230,   231,   232,
     233,   234,   235,   236,   237,   625,   626,   627,     0,     0,
       0,     0,     0,   238,     0,     0,   239,   628,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   670,   407,   408,   409,   671,   672,   673,
     674,   675,   676,   677,   410,   411,   678,   412,   130,   413,
     414,   415,   132,   133,   134,   135,     0,   679,   416,   417,
       0,   418,   419,   680,   681,   420,     0,   136,   422,   683,
     423,   424,   425,   426,   140,   684,   685,   427,   428,   429,
     430,   431,   432,   686,   433,   434,   435,   143,   436,   437,
     687,   438,   439,   440,   146,   441,   688,   689,   690,   691,
     692,   693,   442,   443,   444,     0,   446,   149,   150,   447,
     694,   448,   695,   449,     0,   450,   451,   452,   696,   453,
     454,   455,   697,   698,   456,   457,   458,   459,   460,   699,
     461,   462,   463,   700,     0,   464,   701,   465,   466,   467,
     158,   468,   469,   160,   702,   470,   471,   472,   162,   703,
     473,   704,   474,   163,   705,   164,   475,     0,   476,   706,
     477,   167,   707,   478,   708,   479,   480,     0,   482,   168,
     483,   484,   485,   709,   486,   487,   488,   489,   490,   491,
     710,   169,   170,     0,   492,   493,   494,     0,   172,   713,
     173,   714,     0,   174,   175,   495,   176,   496,   497,   498,
     499,   500,   715,   177,   178,   501,   179,   716,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,     0,
     512,   513,     0,   515,   516,   517,   184,   185,   186,   717,
     518,   519,   520,   521,   522,   523,   524,   187,   525,   718,
     526,   527,   189,   528,   719,   190,   529,   191,   530,   531,
     720,   721,   532,   722,   723,   724,   533,   534,   725,   726,
     192,   193,   194,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,   727,   544,   545,   546,
     547,   548,   549,   199,   550,   551,   728,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   729,   562,   563,
     205,   564,   565,   207,   566,   567,   568,   569,   570,   571,
       0,     0,   730,   573,   574,   575,   731,   576,   211,   577,
     578,   213,   579,   214,   732,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,   733,   591,   592,
     734,   593,   594,   595,   596,   597,   735,   217,   218,     0,
     737,   599,   219,   600,   220,   738,   601,   602,   603,   604,
     605,     0,   740,   606,   607,   608,   609,   741,   742,   610,
     611,   612,   613,     0,   228,   615,   229,   616,   617,   618,
     743,   744,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,     0,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,  2021,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,  2022,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,  2023,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,  2729,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,  2024,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,  2025,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   904,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
     905,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,   945,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,   906,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,   907,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   904,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
     905,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,   906,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,   907,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,   127,   128,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,   792,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,   793,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,   792,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,   793,     0,   978,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,  1375,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,   792,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,   793,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,  1750,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,  1751,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,  1752,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,   792,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,   793,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,  1753,   570,   571,
     572,     0,     0,  1754,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
    1755,  1756,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
     905,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,   906,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,   907,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,   792,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,   793,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,   889,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,   890,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,  2614,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,  2615,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,  2624,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,  2625,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   659,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   790,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,  2765,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,  2778,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,  2812,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
    3122,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
    3124,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
    3126,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,  3727,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   845,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   929,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   931,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   932,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,     0,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   933,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   934,   218,     0,
       0,   935,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   936,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   967,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   932,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,     0,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   968,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   969,   218,     0,
       0,   970,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   936,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,  1189,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,  1193,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,  1201,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,  1203,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,  1205,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,  1208,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,  1210,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,  1213,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,  1386,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   932,   136,  1387,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,     0,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   959,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   960,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,  1378,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   962,   218,     0,
       0,   963,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   936,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   964,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,  1404,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,     0,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,  1476,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
    1667,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,  1693,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,  1695,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   421,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,   432,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   517,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   564,   565,   207,   566,   567,  1783,   569,   570,   571,
     572,     0,     0,   573,   574,   575,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   217,   218,     0,
       0,   599,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   614,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   624,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   932,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,     0,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   959,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   960,   565,   207,   566,   567,   568,   569,   570,   571,
     572,     0,     0,   573,   574,  1378,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   962,   218,     0,
       0,   963,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   936,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   964,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,   386,    87,    88,    89,    90,    91,   387,     0,   388,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   389,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   390,   391,
       0,     0,     0,   392,   393,     0,     0,     0,     0,   394,
       0,     0,     0,     0,     0,     0,     0,     0,   395,     0,
     396,     0,   397,   398,     0,   399,   400,   401,   402,   403,
     404,   405,   406,     0,   407,   408,   409,     0,     0,     0,
       0,     0,     0,     0,   410,   411,     0,   412,     0,   413,
     414,   415,     0,   133,     0,   135,     0,     0,   416,   417,
       0,   418,   419,     0,     0,   420,   932,   136,   422,     0,
     423,   424,   425,   426,   140,     0,     0,   427,   428,   429,
     430,   431,     0,     0,   433,   434,   435,   143,   436,   437,
       0,   438,   439,   440,     0,   441,     0,     0,     0,     0,
       0,     0,   442,   443,   444,   445,   446,   149,   150,   447,
       0,   448,     0,   449,     0,   450,   451,   452,     0,   453,
     454,   455,     0,     0,   456,   457,   458,   459,   460,     0,
     461,   462,   463,     0,     0,   464,     0,   465,   466,   467,
     158,   468,   469,   160,     0,   470,   471,   472,   162,     0,
     473,     0,   474,     0,     0,     0,   475,     0,   476,     0,
     477,   167,     0,   478,     0,   479,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   490,   491,
       0,     0,   170,     0,   492,   493,   494,     0,   172,     0,
     173,     0,     0,     0,     0,   495,     0,   496,   497,   498,
     499,   500,     0,   177,     0,   501,     0,     0,   502,   503,
     504,     0,     0,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   959,   184,     0,   186,     0,
     518,   519,   520,   521,   522,   523,   524,   187,   525,     0,
     526,   527,     0,   528,     0,   190,   529,   191,   530,   531,
       0,     0,   532,     0,     0,     0,   533,   534,     0,     0,
     192,     0,     0,   195,   535,   536,   537,   538,   539,     0,
     540,   196,   197,   541,   542,   543,     0,   544,   545,   546,
     547,   548,   549,   199,   550,   551,     0,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,     0,   562,   563,
       0,   960,   565,   207,   566,   567,   568,  2044,   570,   571,
     572,     0,     0,   573,   574,  1378,     0,   576,   211,   577,
     578,     0,   579,   214,     0,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   216,   590,     0,   591,   592,
       0,   593,   594,   595,   596,   597,     0,   962,   218,     0,
       0,   963,   219,   600,   220,     0,   601,   602,   603,   604,
     605,     0,     0,   606,   607,   608,   609,     0,     0,   610,
     611,   612,   613,   936,   228,   615,     0,   616,   617,   618,
       0,     0,   619,   620,   621,   622,   623,   964,   230,   231,
     232,   233,   234,   235,   236,   237,   625,   626,   627,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,     0,    87,    88,    89,    90,    91,     0,     0,     0,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,     0,     0,     0,   105,   106,   107,   108,     0,   109,
       0,   110,   111,   112,     0,   113,   114,   115,     0,     0,
       0,     0,     0,   118,   119,     0,     0,     0,     0,   120,
       0,     0,     0,     0,     0,     0,     0,     0,   121,     0,
     122,     0,   123,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   130,     0,
       0,     0,   132,   133,   134,   135,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   136,     0,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   143,     0,     0,
       0,     0,     0,     0,   146,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   149,   150,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   156,     0,     0,     0,     0,     0,
     158,     0,     0,   160,     0,     0,     0,     0,   162,     0,
       0,     0,     0,   163,     0,   164,     0,     0,     0,     0,
       0,   167,     0,     0,     0,     0,     0,     0,     0,   168,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   169,   170,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,   174,   175,     0,   176,     0,     0,     0,
       0,     0,     0,   177,   178,     0,   179,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   184,   185,   186,     0,
       0,     0,     0,     0,     0,     0,     0,   187,     0,     0,
       0,     0,   189,     0,     0,   190,     0,   191,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     192,   193,   194,   195,     0,     0,     0,     0,     0,     0,
       0,   196,   197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   199,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     205,     0,     0,   207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   211,     0,
       0,   213,     0,   214,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   216,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   217,   218,     0,
       0,     0,   219,     0,   220,     0,     0,     0,     0,     0,
       0,   223,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   228,     0,   229,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   230,   231,
     232,   233,   234,   235,   236,   237,     0,     0,     0,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,     0,    87,    88,    89,    90,    91,     0,     0,     0,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,     0,     0,     0,   105,   106,   107,   108,     0,   109,
       0,   110,   111,   112,     0,   113,   114,   115,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   130,     0,
       0,     0,   132,   133,   134,   135,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   136,     0,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   143,     0,     0,
       0,     0,     0,     0,   146,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   149,   150,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   156,     0,     0,     0,     0,     0,
     158,     0,     0,   160,     0,     0,     0,     0,   162,     0,
       0,     0,     0,   163,     0,   164,     0,     0,     0,     0,
       0,   167,     0,     0,     0,     0,     0,     0,     0,   168,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   169,   170,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,   174,   175,     0,   176,     0,     0,     0,
       0,     0,     0,   177,   178,     0,   179,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   184,   185,   186,     0,
       0,     0,     0,     0,     0,     0,     0,   187,     0,     0,
       0,     0,   189,     0,     0,   190,     0,   191,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     192,   193,   194,   195,     0,     0,     0,     0,     0,     0,
       0,   196,   197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   199,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     205,     0,     0,   207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   211,     0,
       0,   213,     0,   214,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   216,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   217,   218,     0,
       0,     0,   219,     0,   220,     0,     0,     0,     0,     0,
       0,   223,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   228,     0,   229,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   230,   231,
     232,   233,   234,   235,   236,   237,     0,     0,     0,     0,
       0,     0,     0,     0,   238,     0,     0,   239,    83,    84,
      85,     0,    87,    88,    89,    90,    91,     0,     0,     0,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,     0,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   130,     0,
       0,     0,   132,   133,   134,   135,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   136,     0,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   143,     0,     0,
       0,     0,     0,     0,   146,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   149,   150,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     158,     0,     0,   160,     0,     0,     0,     0,   162,     0,
       0,     0,     0,   163,     0,   164,     0,     0,     0,     0,
       0,   167,     0,     0,     0,     0,     0,     0,     0,   168,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   169,   170,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,   174,   175,     0,   176,     0,     0,     0,
       0,     0,     0,   177,   178,     0,   179,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   184,   185,   186,     0,
       0,     0,     0,     0,     0,     0,     0,   187,     0,     0,
       0,     0,   189,     0,     0,   190,     0,   191,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     192,   193,   194,   195,     0,     0,     0,     0,     0,     0,
       0,   196,   197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   199,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     205,     0,     0,   207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   211,     0,
       0,   213,     0,   214,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   216,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   217,   218,     0,
       0,     0,   219,     0,   220,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   228,     0,   229,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   230,   231,
     232,   233,   234,   235,   236,   237,     0,     0,     0,     0,
       0,     0,     0,     0,   238,     0,     0,   239
};

static const short yycheck[] =
{
       2,   240,  1254,  1192,   999,   148,    78,   114,   917,  1698,
     114,  1530,   145,   147,   768,   221,   770,   114,  1713,   114,
    1108,  1723,   774,   759,    78,   204,    78,     2,  1227,   783,
      78,  1630,   963,    81,  1155,  1751,    78,  1038,  1092,  1286,
    1287,   884,  1163,   886,  1020,   888,  1113,  1101,   957,   156,
    1266,   894,   156,   347,    86,   198,   810,    78,  1305,   156,
     347,   156,   814,    78,   973,  1386,    81,   839,  1057,    78,
     824,    93,    81,  1896,  2165,  1938,  1315,  2250,  1142,  1648,
    2341,  1648,  1682,  1648,    86,  1786,  1632,  1648,  1648,  1075,
    2546,  1648,  1038,   129,  2261,  2721,  1150,  2711,  2255,  2256,
     210,   154,   883,  1157,  1228,   114,  2069,   129,   203,   861,
    1164,  2984,  1976,   225,   971,   210,   223,   212,  1485,   223,
    2753,  1185,  1947,   144,  1219,   147,   223,    22,   223,  1170,
    1072,   903,    38,  3137,  2055,  2056,  1335,    11,   147,  2003,
    1614,  1038,  1944,  2007,    38,   147,   203,   156,    23,   181,
    1034,  1035,   115,   210,    90,   212,   109,  2191,  2192,  2193,
    2194,    72,    89,  2884,    72,    89,  1277,  1278,   158,   241,
     767,   877,   153,    75,   771,   182,   127,    81,  1697,   181,
     153,   109,    81,   955,    95,   102,   109,   241,    84,   241,
    1301,   761,    78,  2687,   203,    81,   208,   109,    81,   241,
     152,   210,   221,   212,   184,    88,   202,   804,   239,   163,
      78,   124,   206,    81,   223,   163,    72,   197,  3593,   240,
     241,    94,    77,   165,   202,    94,   297,   177,   114,   239,
     202,   299,    26,  3201,   215,  3203,    72,  2200,    81,    95,
     185,    81,   215,   202,   300,    88,   114,   117,    88,   121,
     297,  1850,    30,   239,   313,   852,  3614,   237,    82,   303,
     340,   858,    77,   160,   258,   351,   100,   158,   279,   204,
     156,   367,   224,   389,  3631,   255,   163,    72,   160,   233,
     117,    91,   158,   185,   138,   233,   267,   117,   156,   270,
      72,   431,   239,   239,   267,   239,   397,   270,   109,  1818,
      95,   131,  1390,     0,   204,   100,   157,   397,  2271,   156,
    2273,   351,  2176,    72,    16,   399,   432,   203,   414,   299,
     175,   158,  1076,  1077,   210,    78,   212,   307,    81,   199,
    3334,   302,   347,   431,   382,   255,   376,   223,   347,    72,
     243,   239,    77,   202,  1665,    81,   129,   487,    83,   433,
    3708,   431,    39,   207,    41,   223,   166,    16,  1605,  1606,
     175,   114,    95,   385,   480,  1612,   467,   382,  1357,   199,
     360,  1228,    89,   382,  1126,  1111,   223,   358,  1617,   299,
      72,  1238,  1239,   217,   167,   358,   115,   221,  1389,   487,
     434,   344,  1581,    26,   480,   292,   390,   487,   392,  1153,
    1154,   292,  1523,   156,   304,   287,   360,   487,   185,   480,
     234,   287,  3416,  1480,   318,  1169,   344,  3774,   353,   487,
     254,   344,   367,   482,   480,   397,   221,   330,   300,   409,
     416,   421,   344,   480,   445,   387,   388,   117,    72,   202,
     175,   235,  1196,  1197,   124,   341,   241,   242,  3452,   351,
     287,   131,   483,   231,   324,   292,   407,   353,  3833,   241,
     414,   347,   221,   444,   598,   367,   414,  2156,   487,   763,
     223,   444,   482,   480,   416,   487,   763,  1598,   428,   347,
    1669,  1569,   241,   382,   397,  1055,   390,   324,   392,   372,
     480,   487,  1603,  1604,   324,   290,   382,   334,  1355,   480,
    1611,   481,   480,   239,  3472,   401,   115,   480,   241,   304,
     365,  1217,   385,  2059,   382,  1579,   385,   480,  2320,   199,
    1117,   416,   304,   338,  1500,  3246,  1123,   414,   487,   372,
    1506,   314,   372,   344,   487,   369,   483,   483,  1395,  1396,
     410,  1595,  3546,   487,   480,   304,   420,   453,   399,   241,
     456,   478,  3008,  3009,   478,   461,   462,   463,   464,   487,
     466,  1458,   456,   480,   487,   476,   472,  2658,   476,  2660,
    2661,  1455,  1514,   410,  1171,   487,   598,  2051,   313,   474,
     410,   456,   433,  2674,   487,   483,  1785,  1786,   184,   598,
     367,    72,   267,   302,   347,  2768,   598,  1796,  1797,  2772,
     287,  1800,   235,   338,  1728,   312,  1582,   241,   391,  1808,
    1809,  2413,  3106,  3107,  3108,  3109,  3110,   473,   474,   475,
     476,   351,  1821,  1822,  1719,  2489,  1667,   158,  1409,   382,
     129,   204,   239,  1832,   397,   769,   770,   473,   474,   475,
     476,   237,   772,  2564,   324,  2566,   776,    72,    77,  2016,
    2250,  3432,   759,   197,   784,   759,   102,   151,    72,   454,
    2483,   773,   759,  2697,   759,   203,   778,   779,   167,   161,
    2495,   478,   454,   785,   808,   482,   471,   472,   473,   474,
     475,   476,   812,   358,   414,   333,   816,  1886,   239,   471,
     472,   473,   474,   475,   476,   454,   826,    78,   841,  2662,
    2663,  1812,  1813,    81,   150,    78,   153,   416,   467,   468,
     469,   307,   471,   472,   473,   474,   475,   476,   163,   482,
     456,  3725,   856,   486,   453,   210,   218,   456,   464,   241,
     410,   304,   461,   462,   463,   847,   472,  3547,   471,   472,
     473,   474,   475,   476,   102,   798,   175,   483,   763,  1485,
     759,   480,   206,   292,   763,   129,   287,    79,   767,  2680,
     241,   478,   771,   480,   481,   482,   175,   799,   215,  3773,
     487,  1838,   266,   163,   268,   828,    98,   315,  1530,   471,
     472,   473,   474,   475,   476,   175,   232,  3597,   233,  2710,
     302,   243,   150,   167,   431,   804,   340,   799,  3424,  1553,
    1554,  1555,  1556,  3417,   258,   161,   360,   380,   859,   416,
     388,  2978,   863,   409,   423,   314,   241,   839,  1885,  3452,
     267,   872,  2686,   304,   355,   162,   203,   241,  3609,  1583,
    1584,  2752,   480,   279,   153,  1589,   845,   471,   472,   473,
     474,   475,   476,   852,   453,  1754,  1755,   456,   958,   858,
     487,   961,   461,   462,   463,   109,   129,   162,   880,    26,
     241,   239,   218,   958,   349,  3675,   961,   421,   241,    36,
    1727,   480,  2472,   759,   232,   877,   399,   763,   330,   304,
     215,   903,  1739,   163,   313,   338,   158,  2486,   389,   921,
     304,   759,   391,  3731,   167,   763,   215,  1651,  1652,  1653,
    1654,   958,   877,   240,   961,  3778,  3779,  1643,   313,   338,
     356,   358,   365,   480,   453,   360,   948,   456,   138,   921,
     956,   279,   461,   462,   463,  2444,   480,   959,   960,   424,
    3386,   321,   267,   955,   956,   240,   390,   157,   392,  2186,
     314,   158,   483,   163,   953,  1697,   948,   114,   267,   958,
      96,   270,   961,   233,   158,  3828,   365,   959,   960,   974,
     365,   292,  1716,   197,    72,   974,   160,   187,  3806,   414,
     116,  3005,   426,   454,   313,   984,   421,   397,   132,   480,
    3071,  3072,  3073,  3074,  3075,  3076,   467,   468,   469,  3827,
     471,   472,   473,   474,   475,   476,   287,   406,   356,   338,
     481,  2002,  1034,  1035,  1111,   159,   759,  1111,   288,   289,
     763,  2132,   313,   233,  1111,  2561,  1111,   391,  1994,  3192,
     473,   255,  2568,   358,  3197,   279,    81,  3200,   487,   454,
     130,  3188,  1034,  1035,   228,   480,  1038,   338,   329,   358,
     454,   314,   467,   468,   469,  1020,   471,   472,   473,   474,
     475,   476,  2106,  2107,   468,   469,  2002,   471,   472,   473,
     474,   475,   476,  1038,   216,   299,  1818,   487,   235,   484,
     287,   225,   958,  2680,    42,   961,  1933,  2266,   456,   179,
     360,  2067,   330,   131,    72,  1682,   464,  1684,   974,   132,
     344,   161,  1689,   287,   472,  2811,  1335,  2218,  2219,  2220,
    2221,  1110,  1111,  2710,  2793,   483,   974,    95,  1117,  1141,
     158,   365,   323,  2976,  1123,   170,   159,  1853,   391,   367,
    1494,   483,   453,  2099,  3580,   444,  2102,  2103,   323,  3743,
     461,   462,   463,   241,   414,  1144,   166,  2838,   416,  1141,
     360,   421,   361,  2712,   170,  2712,   172,  2712,   218,  1200,
    2349,  2712,  2712,  1400,  1751,  2712,   338,  1229,   235,   355,
     377,   261,  1171,   380,  1538,   170,   414,   172,  2768,   388,
     133,   203,  2772,    18,   204,  1229,  1248,  1229,  1472,   480,
    1212,   453,   225,   365,   456,  1472,   163,  1229,   399,   461,
     462,   463,   464,   389,   414,  1246,   304,   229,  2262,  2398,
     480,   421,    85,    86,   399,  1256,   197,   426,  1229,   172,
    1212,  3174,   244,   313,  1216,  1217,  1267,  1219,  1227,   353,
     252,   974,   433,   203,   184,  1111,   313,  1248,  2427,  2001,
    3491,  1253,   212,   357,  1561,   361,   432,   197,   433,   287,
     313,  1216,  1217,  1111,  1219,  1254,  3209,  3111,  3211,   453,
    1271,   338,   456,   241,   242,   342,   233,   461,   462,   463,
     480,   287,   388,  2462,   255,   338,  1275,   401,  1289,  2258,
     353,   297,   431,   432,   313,  2474,  2475,   237,   365,   353,
    2016,  3372,  3373,  3374,   480,   267,   456,   480,   270,   389,
    3802,   391,   297,  1302,   464,   255,  3469,   342,  1319,   338,
     426,   453,   290,   896,   456,  1337,  3729,  3730,   299,   461,
     462,   463,   289,  1640,  1335,  1347,   348,   420,   401,  1646,
     365,   480,  2569,  1332,  1333,   918,  1335,   401,  1435,  3841,
     107,  1435,   313,  1660,   298,  1337,  1372,  1373,   302,   299,
     170,   313,   172,  1352,   431,  1347,   454,   307,   338,   186,
    1372,  1373,   342,   456,  1386,  3867,  1358,   338,  1111,   467,
     468,   469,   192,   471,   472,   473,   474,   475,   476,   247,
     342,   313,   142,   481,   151,   365,   358,    72,  1485,  2861,
    1389,  1485,  3805,   360,  1386,   222,   431,  1389,  1485,     5,
    1485,  1393,  1394,   365,  1489,   390,   338,   392,  1419,  1420,
      95,  1422,  3716,  2885,  2158,  2159,  2160,  2161,  2162,  2163,
      26,    35,  1421,  1508,  1389,  1424,  1425,  1453,  1393,  1394,
      36,  1436,  1437,  1455,    52,   313,  1435,  1436,  1437,  2496,
    2751,  1453,  1489,   203,   131,   397,  1068,   414,  1685,   202,
     401,   431,    70,  1690,   421,  1557,   223,   197,   313,   409,
     338,  1508,  1699,  1455,   342,   340,  3770,  1472,   221,   229,
    1092,  3775,   292,  1472,  1479,  1712,   216,   297,   124,  1101,
    1479,  1446,  1481,   338,   244,   131,  1485,   365,   125,   327,
    1489,  3572,   252,   471,   472,   473,   474,   475,   476,   266,
    3804,   268,   431,   432,  1539,   142,  3319,  1542,   114,  1508,
     365,  1546,   279,   480,   479,   275,  1515,   483,   155,   206,
     330,   487,   487,  3112,   479,   134,  2270,  1647,  2272,   339,
    1529,   456,   487,  1762,   481,  1500,  2298,   224,   481,   464,
     487,  1506,   302,   102,   487,   312,  1643,   472,   170,  1643,
     172,   480,   362,   483,   114,   115,  1643,   487,  1643,  1435,
    1436,  1437,   357,  2484,  1688,   453,   481,   224,   174,   206,
     192,   258,   487,   461,   462,   463,   343,  1435,  1436,  1437,
     481,  1580,   475,   403,   143,   142,   487,   480,   348,   482,
     478,   411,   480,  2782,   482,   481,  1472,  2397,  1597,  2399,
    2400,   487,  3192,  1479,   488,   164,  1729,  3197,   375,  1485,
    3200,  1780,   481,  1489,  1472,  1614,   481,  1582,   487,   306,
     481,  1479,   487,   454,   183,  2831,   487,  1485,  2739,   235,
     447,   448,  1508,   117,  2600,  3171,  3328,   455,   456,   198,
    1639,  2607,  2608,  1665,  1643,   456,   203,   131,  3601,   481,
    1691,  1935,   106,   478,   213,   487,   416,   482,  1935,  1700,
    2889,  2890,   158,  2250,     7,   287,   390,    10,   392,  1710,
     292,  1682,   229,  1665,   158,   297,   160,    20,    21,  2405,
     481,   216,  2924,  1682,  2410,  1684,   487,   244,  1687,  2680,
    1689,   357,  1435,  1436,  1437,   252,   484,    40,  3287,  1698,
      43,   452,  2444,   390,   455,   392,   202,  2896,   247,  1750,
    1772,  1752,  1753,   239,   401,  1756,   431,   432,   275,  2710,
     481,   480,   184,   410,  2781,   302,   487,  1719,  1772,  1472,
    1772,  1723,   481,   292,   326,   197,  1479,   453,   487,    96,
    1772,   300,  1485,   481,   228,   461,   462,   463,   475,   487,
    2583,  1762,  1751,   480,  1719,   482,  1853,   106,  1723,  1853,
     446,  1772,  2504,  2820,   480,   243,  1853,  1643,  1853,   478,
     329,   480,   456,   481,   485,   237,   487,  3014,   481,   487,
     464,   403,   466,  1805,   487,  1643,  1785,  1786,   472,   411,
     481,   348,   482,   255,  1793,   305,   487,  1796,  1797,   481,
     478,  1800,   480,   287,   482,   487,  1805,   302,   292,  1808,
    1809,   397,   481,  1805,   431,   432,  3325,  1816,   487,   481,
    1819,  1820,  1821,  1822,   305,   487,   481,   480,   171,   482,
    1829,  1830,   487,  1832,  1144,  1834,   481,   299,  1837,   302,
     324,   481,   487,   431,   432,   307,  1857,   487,   446,  2906,
     334,    96,  1851,  1852,  1853,   431,   432,  1856,   119,   446,
    3450,  1860,  2606,  1419,  1420,  1864,  1422,   243,  1867,  1868,
    1869,  1870,  1871,  1872,  1873,  1874,  1875,   365,  1877,  3469,
     481,    72,   481,  1882,  3590,  2472,   487,  1886,   487,   464,
    1912,   466,  2970,  2013,  2018,   423,    87,  2017,   481,   473,
    1643,   397,   453,   481,   487,   456,   485,  1948,   487,   487,
     461,   462,   463,   464,  2034,   466,   201,   481,  2038,  2016,
    1912,   472,  2016,   487,    81,   453,   410,   481,   456,  2016,
    1935,  2016,   193,   461,   462,   463,  1935,   481,  2680,  1977,
    2060,  1979,  2062,   487,  1254,   481,   139,   409,  1947,   483,
     481,  3540,   480,   106,   453,   216,   487,   453,    72,   480,
     456,   482,   461,   462,   463,   461,   462,   463,  2710,   481,
      72,   483,  1977,    87,  1979,  2095,  1998,  1853,  1977,   473,
    1979,   480,   390,  2709,   392,    87,   482,   484,   481,  2001,
     486,   235,   481,   108,   487,  1853,   378,   379,   487,   481,
    3685,   390,  3687,   392,   484,   487,  1998,  3083,  3084,  2129,
    2002,  3087,  2004,  3089,  2006,   181,  2136,  2016,  2138,   397,
    2061,  2250,   137,   397,   471,   472,   473,   474,   475,  1994,
    1258,  1259,  2031,  2074,   481,  3079,  3626,  2002,   481,  2004,
     481,  2006,  2279,  3552,   487,  2282,   487,  2088,   481,  2286,
     241,  2092,  2051,  3295,   487,   453,  2055,  2056,   456,  1935,
     481,   481,   481,   461,   462,   463,   487,   487,   487,  3748,
    3181,   453,   481,   397,   456,   190,   397,  1935,   487,   461,
     462,   463,   480,   895,  2207,    72,  3275,   481,   481,   449,
     450,   451,     8,   487,   487,  2087,    12,    13,    14,   106,
      87,  1977,  2846,  1979,   219,   397,  2343,    23,    24,    25,
    1853,    27,    28,   304,   481,    90,    32,    33,    34,  1977,
     487,  1979,   453,   431,   432,   456,   481,   241,   483,   481,
     461,   462,   463,   453,  2099,   487,  3726,  2102,  2103,   241,
    2016,   461,   462,   463,   416,   453,   481,  2169,   456,   480,
    2149,   235,   487,   461,   462,   463,   241,  2156,  2016,   453,
     480,   994,   456,   996,   481,  2157,   397,   461,   462,   463,
     487,  1481,   480,  2165,  2900,   480,  2175,  2169,  2177,  2508,
    2509,  2768,   481,   481,   313,  2772,   480,  2179,   487,   487,
     304,   453,  1935,   454,  2314,   453,  2510,  2511,  2427,   461,
     462,   463,   304,   461,   462,   463,   467,   468,   469,   482,
     471,   472,   473,   474,   475,   476,  2238,   153,   480,  1529,
     480,  2341,   480,   480,  2811,  2217,  2773,   342,  2775,   344,
     482,   346,   453,   338,  1977,   456,  1979,   352,   302,  2250,
     461,   462,   463,   481,   359,   253,  2238,   453,   483,   487,
     365,  2250,  1036,  1037,   241,   461,   462,   463,   373,   480,
     480,  2260,  2284,   454,  1419,  1420,   381,  1422,   296,   481,
    1580,  2467,  2468,  2016,   480,   487,   467,   468,   469,   215,
     471,   472,   473,   474,   475,   476,  2298,  1597,   304,   481,
     357,   431,  2284,  2292,   247,   487,   480,   453,   481,   117,
     456,   431,   119,   481,   487,   461,   462,   463,  2405,   487,
    2547,  2405,   427,  2410,   431,   432,  2410,   304,  2405,    90,
    2405,   481,  2321,  2410,   480,  2410,   481,   487,   431,  1639,
     480,   267,   487,  2332,   270,   481,   453,  3322,    96,   456,
     454,   487,  3531,    96,   461,   462,   463,   473,   474,   475,
    2349,  2350,   454,   467,   468,   469,   272,   471,   472,   473,
     474,   475,   476,   480,   313,   467,   468,   469,   247,   471,
     472,   473,   474,   475,   476,   488,   193,  1687,   416,   188,
    2617,  2618,  2381,   188,   453,   480,  2385,   456,  1698,   188,
     188,   188,   461,   462,   463,   464,   487,   466,  2397,  2398,
    2399,  2400,   188,   472,   320,   480,  2405,   188,   188,   453,
    2409,  2410,  2532,   302,   188,  2414,  2427,   461,   462,   463,
     188,   302,   358,   188,   453,  2424,  2425,   456,  2427,   188,
    2441,    90,   461,   462,   463,  3677,  1820,   198,   454,  3681,
    3682,  2440,   253,  2442,   480,   197,   480,  2446,   480,  2460,
     480,   467,   468,   469,   480,   471,   472,   473,   474,   475,
     476,  2472,   453,  2462,   320,   456,  2507,   454,   480,  3658,
     461,   462,   463,  2472,   119,  2474,  2475,   480,   480,   480,
     467,   468,   469,   480,   471,   472,   473,   474,   475,   476,
     406,   480,   480,   487,   480,  2487,  2495,   453,   480,  3678,
     456,   480,  2501,   480,   480,   461,   462,   463,   444,   480,
     480,  2510,  2511,  2512,   480,   480,   452,   453,   480,   455,
     456,   480,  2487,   480,    90,   461,   462,   463,   453,  2405,
     480,   456,  2652,   480,  2410,   310,   461,   462,   463,   144,
     253,  1851,   241,  2542,  2585,  2586,   480,  2405,   193,  2786,
     197,  2788,  2410,  2790,   197,  2792,   473,  2794,   235,   270,
     453,   487,  2799,   456,  2563,  2564,   358,  2566,   461,   462,
     463,   471,   472,   473,   474,   475,   157,   415,    38,   479,
    2579,    16,  2581,  3325,   487,   778,   480,   397,   480,   480,
     397,   397,  2584,  2726,   482,  2832,   397,   397,   302,  2591,
     292,  2593,   359,   397,   397,  3192,   397,   415,   397,   802,
    3197,  2610,  2709,  3200,   397,  2709,   487,  3361,   397,   397,
     416,   416,  2709,   355,  2709,   397,   124,   302,  2761,   226,
     487,   397,  3811,   397,  2758,  2600,   355,   454,   480,   302,
     241,   397,  2607,  2608,   300,   480,   397,   397,   480,   480,
     467,   468,   469,  3842,   471,   472,   473,   474,   475,   476,
    2659,   423,  2405,    90,    79,  2727,  2658,  2410,  2660,  2661,
     158,   416,   426,   261,    90,   197,   480,   302,  2700,    90,
    2679,  2680,  2674,  2745,   356,   429,   188,   416,  2680,   188,
     416,   188,  2812,    16,   482,  2687,   397,   487,   467,  2761,
    2722,   421,   487,   345,   291,  2934,   202,  2699,  2700,   395,
    2709,  2710,   428,  2833,  3613,  2680,  2727,   480,  2710,   912,
    1820,   395,   272,   272,   917,    72,  2725,   487,  2750,  2751,
    2722,   365,   480,   395,  2745,   928,   397,   480,   202,  2738,
    2936,  2937,  2938,  2939,   467,  2710,    77,   487,   399,   487,
    2761,   481,    83,  2752,   237,   467,  2818,  2768,  2750,  2751,
     487,  2772,   303,   297,   957,   255,   481,    35,   478,  2768,
     397,   397,   481,  2772,   130,   355,   245,   480,   245,  1879,
     973,   292,   480,  2782,   292,   978,    80,   292,  2787,   302,
     121,   308,   487,   481,  2793,   316,   487,   255,    92,   992,
     316,   413,   106,  2900,   106,   338,  2900,  2818,   338,   454,
    3552,   338,  2811,  2900,   397,  2900,   330,   241,   112,   397,
      90,   241,   467,   468,   469,   416,   471,   472,   473,   474,
     475,   476,   241,  2709,   416,   241,   467,   168,   478,   397,
     134,   397,  2841,   255,   175,  2844,  2156,   178,   467,   197,
     467,  2709,   302,  2852,   306,   187,   480,    90,   152,  2858,
     211,  2860,  1674,  3450,   302,  2864,  2865,  2177,   474,  2868,
    2869,  2870,  2871,  2872,  2873,  2874,  2875,  2876,  2877,   173,
     214,  3625,  3469,  2882,  2883,   214,  3630,  3631,  2910,   197,
     480,    90,  2891,   487,    90,   226,    90,  2896,   302,   302,
      11,  2900,   481,  2902,   480,    78,   388,   208,   269,   108,
     204,   302,  2911,   487,   108,  2914,   210,  2916,  2910,   487,
     106,  1114,   481,  2934,   481,  2924,  2925,  2926,  2927,   481,
     224,   202,  2931,   481,  3054,  2934,  3056,   481,   137,   481,
     487,   481,  3686,   137,  3688,  2944,   481,   202,   279,   481,
     481,   446,   446,   481,   446,   481,   481,  2949,   481,   429,
     397,   481,   480,    31,  3551,   480,  2709,   255,   487,   481,
     231,   481,  1165,  1166,  1167,   292,   480,   483,  3215,  3216,
     481,   488,   313,  3727,   397,   313,  1798,  1799,   264,   480,
     483,   190,   264,   241,  1806,   264,   190,  2381,  1810,  1811,
     397,  2385,   397,  3590,   397,   397,   481,   338,   397,   397,
     304,   342,   397,  1825,   241,  1827,   241,   241,   312,   241,
     219,   241,  2332,  3767,  2900,   219,   481,   478,   270,   302,
    3774,   406,   481,   327,   365,  1847,   480,  1849,   481,  3626,
    2424,  2425,  2900,  3042,   340,   487,   300,  3791,   247,   302,
     416,   397,  1245,   247,   480,   349,   302,   244,   481,   353,
     309,   355,   244,   480,   416,   297,   416,   361,   487,   467,
     305,   185,   185,  1266,   181,   202,   478,   487,    72,  3071,
    3072,  3073,  3074,  3075,  3076,   197,   425,   481,   115,   210,
     467,   481,   202,   480,   388,   389,   467,   481,   481,   393,
     481,   487,   480,   467,   464,   231,  3226,   401,   406,   197,
     397,   397,   406,   397,  3106,  3107,  3108,  3109,  3110,   397,
     397,   415,   481,   241,   241,   241,   165,   480,   431,  3094,
     479,  3130,   426,    90,   197,   306,   245,   227,   126,  3726,
     419,   454,  3141,   342,   389,   480,   487,   346,   342,   244,
    3172,   481,   346,   352,   480,   480,    90,  2900,   352,   481,
     359,   480,   207,   481,   202,   359,   365,   481,   202,   480,
     430,   365,   481,   430,   373,   481,   106,   487,   406,   373,
    3172,  3192,   381,   212,   292,   416,  3197,   381,   487,  3200,
     487,   292,   188,  3192,   241,    86,   292,   160,  3197,   479,
    3787,  3200,    93,   228,    95,   204,   204,    72,   416,  1402,
     202,   416,   176,   104,   187,  3802,   481,   480,  3338,   117,
     117,   305,    87,   246,   202,   397,   197,   305,   427,  3349,
      95,  3351,   431,   427,   202,   100,   480,   480,   129,  3238,
     480,  3478,  3479,  3480,  3481,   420,   480,   138,   334,   374,
     431,   481,   481,   197,  3841,    90,   147,   148,   265,   480,
     151,   480,   292,   224,   487,   352,   157,   328,  3855,  2579,
     161,  2581,   352,   305,   305,   166,  3275,    93,  2090,   197,
    3867,  2381,   302,  3282,  3283,  2385,   389,   193,    90,   180,
    3289,  3290,   183,   431,   487,  3294,  3295,   188,  3320,   176,
    2610,  3300,  3301,    90,   480,  3304,   108,   198,   171,   302,
     351,   202,   302,   204,   420,   481,   414,   208,  3359,  3360,
     163,  3362,   333,   187,  2424,  2425,    76,  3319,  3320,   480,
     241,   328,  2206,   224,  1394,   137,  3328,  2487,  2128,  2611,
    2169,  3381,  3159,  3342,  3156,  2111,  3039,  3410,  2543,  2659,
    3168,  1544,   217,  3786,  3319,  3810,   221,  3765,  3420,  3764,
    3382,  3383,  3794,  3328,  2802,  3387,  3161,  2179,  1661,  3444,
    3867,  3491,  2184,  2188,  3841,  3394,   241,   242,  3393,  2709,
    3372,  3373,  3374,  2679,  2710,  3801,  3554,  1641,   190,   254,
    3382,  3383,  3384,  3812,  3557,  3387,  3388,   183,  1247,  2316,
     158,  3226,  3173,  3626,  3426,  3726,  2056,  2563,  2055,  3420,
    3409,  3692,  3832,  3179,  3651,  2725,  3866,   219,   972,  3602,
    2195,  3462,   287,  1945,   159,   290,  1229,  3154,  2738,  3451,
    2819,  3472,  2493,  2296,  3426,  2501,   108,  3220,  2512,   304,
    1960,   306,  1229,  1427,  2472,   247,  1426,  1428,  1939,  3152,
    2250,  3450,  2774,  3470,  2494,  2909,  3656,  2902,  3469,  3451,
    1835,  2504,  2441,  2439,  2351,   137,  3465,   847,  2321,  1882,
    3469,  2758,  2243,  1676,   598,  3474,  1176,  2787,   348,  1998,
     238,  2865,  1437,  2793,  2868,  2869,  2870,  2871,  2872,  2873,
    2874,  2875,  2876,  2877,   385,  1056,  1431,   879,  3497,  1975,
     258,  1037,  3501,  2305,   369,  2304,  1253,  2482,  3221,  1702,
    2002,  3318,  3222,  2974,    77,  1370,  1709,  1435,   190,   381,
      83,  3520,  3521,  2006,     2,  3524,  2299,  1745,    -1,  1216,
      -1,  2381,  3531,  3532,  2844,  2385,    -1,    -1,    -1,    -1,
     342,    -1,  2926,  2927,   346,    -1,    -1,   219,    -1,    -1,
     352,    -1,  3551,    -1,  2864,    -1,    -1,   359,   121,    -1,
      -1,  1754,  1755,   365,    -1,    -1,  3565,    -1,    -1,    -1,
    3535,   373,    -1,  1766,  2424,  2425,    -1,    -1,    -1,   381,
    3572,  2891,    -1,    -1,    -1,    -1,    -1,  3649,    -1,   454,
      -1,  3590,    -1,    -1,    -1,    -1,    -1,    -1,  3639,    -1,
      -1,  3623,   467,   468,   469,   168,   471,   472,   473,   474,
     475,   476,   175,    -1,  2924,   178,    -1,  3846,    -1,    -1,
      -1,    -1,   487,    -1,    -1,   427,    -1,  3626,  3627,    -1,
      -1,  3623,    -1,    -1,    -1,    -1,    -1,    -1,  3649,    -1,
      -1,   313,    -1,    -1,    -1,    -1,    -1,    -1,  3689,    -1,
      -1,    -1,    -1,    -1,  3653,  3654,    -1,  3656,    -1,  3658,
      -1,    -1,    -1,   226,    -1,    -1,   338,    -1,    -1,    -1,
     342,    -1,    -1,  2485,   346,    -1,    -1,    -1,  3677,    -1,
     352,    -1,  3681,  3682,    -1,    -1,    -1,   359,  1881,    -1,
      -1,    -1,    -1,   365,   452,   453,    -1,   455,   456,    -1,
      -1,   373,    -1,   461,   462,   463,   464,   598,   466,   381,
      -1,    -1,    -1,    -1,   472,    -1,   279,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3726,    -1,    -1,
      -1,    -1,  3042,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3130,    -1,    -1,  3748,
     313,    -1,  1945,    -1,    -1,   427,    -1,   648,   649,    -1,
      -1,    -1,    -1,    -1,    -1,  2865,    -1,    -1,  2868,  2869,
    2870,  2871,  2872,  2873,  2874,  2875,  2876,  2877,    -1,   342,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3787,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   365,  3802,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      -1,  3832,    -1,    -1,    -1,    -1,  2926,  2927,    -1,    -1,
      -1,  3141,  3824,    -1,    -1,  3846,    -1,    -1,    -1,    -1,
      -1,    95,  3841,  3842,    -1,    -1,   100,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3866,  3855,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3867,    -1,
      -1,    -1,  3864,  2685,    -1,  2687,    -1,   768,   769,   770,
      -1,   772,    -1,   774,    -1,   776,   777,    -1,    -1,   780,
      -1,   782,   783,   784,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3289,  3290,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   805,    -1,    -1,   808,    -1,   810,
      -1,   812,    -1,    -1,    -1,   816,   817,   818,    -1,    -1,
    2123,   822,    -1,   824,    -1,   826,    72,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   839,    -1,
     841,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      -1,    -1,   853,   217,   100,   856,    -1,   221,   859,    -1,
      -1,    -1,   863,   864,    -1,    -1,    -1,   868,    -1,   870,
      -1,   872,    -1,    -1,   875,  3295,    -1,   241,   242,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1144,    -1,    -1,
     254,    -1,    -1,    -1,    -1,   896,   897,    -1,    -1,    -1,
      -1,  2204,   903,    -1,    -1,  2865,    -1,    -1,  2868,  2869,
    2870,  2871,  2872,  2873,  2874,  2875,  2876,  2877,    72,    -1,
    3130,    -1,  3342,   924,    -1,   926,   290,    -1,   929,  2232,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2240,    -1,    -1,
     304,    95,    -1,    -1,    -1,    -1,   100,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   955,   956,    -1,    -1,    -1,   960,
      -1,    -1,    -1,    -1,    -1,    -1,  2926,  2927,  1144,    -1,
      -1,   217,    -1,    -1,    -1,   221,    -1,    -1,   979,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   241,   242,  1254,    -1,    -1,
      -1,    -1,    -1,  3497,    -1,   369,    -1,  3501,   254,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3520,  3521,    -1,    -1,
      -1,    -1,    -1,  1034,  1035,    -1,    -1,    -1,    -1,    -1,
      -1,   287,    -1,    -1,   290,  1046,    -1,    -1,  1049,    -1,
      -1,  1052,    -1,    -1,  3474,    -1,    -1,    -1,   304,    -1,
     306,    -1,    -1,   217,    -1,    -1,    -1,   221,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1076,  1077,    -1,  1254,  3289,
    3290,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,    -1,
     454,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     254,    -1,  1103,   467,   468,   469,    -1,   471,   472,   473,
     474,   475,   476,    -1,  1115,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   369,    -1,    -1,    -1,  1128,    -1,    -1,
      -1,    -1,  1389,  1134,    -1,    -1,   290,  1138,  1144,    -1,
      -1,    -1,    78,    -1,  1145,    -1,    -1,    -1,    -1,    -1,
     304,    -1,  1153,  1154,    -1,    -1,    -1,    -1,    -1,  3653,
    3654,    -1,    -1,  2466,    -1,    -1,    -1,    -1,  1169,  1170,
    3130,  1172,  1173,    -1,    -1,    -1,    -1,    -1,    -1,  3101,
      -1,    -1,    -1,    -1,  3106,  3107,  3108,  3109,  3110,    -1,
      -1,    -1,  3114,    -1,   130,  1196,  1197,    -1,    -1,  1200,
      -1,    -1,    -1,   139,   140,    -1,    -1,    -1,   454,    -1,
      -1,    -1,    -1,    -1,    -1,   369,    -1,    -1,    -1,    -1,
      -1,   467,   468,   469,  1481,   471,   472,   473,   474,   475,
     476,    -1,    -1,   479,    -1,    -1,  1237,    -1,    -1,    -1,
      -1,    -1,   488,    -1,   180,  1246,  1247,    -1,  1254,    -1,
    1251,    -1,    -1,    -1,    -1,  1256,    -1,  3677,  1515,    -1,
      -1,  3681,  3682,  1264,    -1,    -1,  1267,    -1,  1269,    -1,
      -1,    -1,  1529,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   221,    -1,  3497,    -1,    -1,
     226,  3501,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     454,    -1,    -1,    -1,    -1,  1481,    -1,    -1,    -1,    -1,
    3520,  3521,    -1,    -1,   468,   469,    -1,   471,   472,   473,
     474,   475,   476,  1580,    -1,    -1,    -1,   263,  3748,  3289,
    3290,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1515,
    1597,    -1,    -1,    -1,   280,   281,    -1,   283,   284,    -1,
     286,    -1,    -1,  1529,    -1,    -1,    -1,  1614,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1372,  1373,    -1,    -1,    -1,    -1,    -1,    87,    -1,
     316,    -1,  1639,    -1,    -1,  1386,    95,    -1,    -1,    -1,
      -1,   100,  1393,  1394,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1404,  1580,  1406,    -1,    -1,  3330,    -1,
      -1,    -1,    -1,   349,    -1,    -1,    -1,  2720,  3340,  3341,
      -1,  1597,    -1,  3345,  3346,    -1,  2729,    -1,    -1,    -1,
    1687,    -1,    -1,  3355,    -1,    -1,    -1,    -1,  1614,    -1,
      -1,  1698,    -1,  3653,  3654,  2748,    -1,    -1,   384,    -1,
     386,    -1,  1453,    72,  1455,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1639,    -1,    -1,    -1,    -1,    87,    -1,
      -1,    -1,   408,  1474,    -1,  1481,    95,    -1,    -1,   415,
      -1,   100,   418,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2795,    -1,  2797,    -1,    -1,    -1,    -1,  2802,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   217,  1515,
      -1,  1687,   221,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1698,  1529,    -1,    -1,    -1,    -1,  2831,  1530,
      -1,    -1,   241,   242,    -1,    -1,    -1,  3497,    -1,    -1,
      -1,  3501,    -1,    -1,    -1,   254,    -1,    -1,    -1,    -1,
      -1,    -1,  1553,  1554,  1555,  1556,    -1,    -1,    -1,    -1,
    3520,  3521,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1580,    -1,    -1,    -1,   287,    -1,
      -1,   290,  1583,  1584,    -1,    -1,    -1,    -1,  1589,    80,
      -1,  1597,    -1,    -1,  1851,   304,    -1,   306,   217,    -1,
      -1,    -1,   221,    -1,    -1,    -1,    -1,    -1,  1614,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1639,    -1,   254,    -1,    -1,  2941,  2942,
      -1,    -1,    -1,   134,    -1,    -1,  1647,    -1,  1649,    -1,
    1651,  1652,  1653,  1654,    -1,    -1,    -1,    -1,    -1,    -1,
     369,   152,    -1,    -1,  1665,    -1,  1667,    -1,   287,    -1,
      -1,   290,    -1,    -1,    -1,  1851,    -1,    -1,    -1,    -1,
      -1,  1687,   173,    -1,    -1,   304,    -1,  1688,    -1,    -1,
    1691,  1692,  1698,  3653,  3654,    -1,  1697,    -1,    -1,  1700,
    1701,    -1,  1703,    -1,    -1,    -1,    -1,  1708,    -1,  1710,
      -1,    -1,  1713,   204,    -1,  1716,    -1,    -1,    -1,   210,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1730,
    1731,    -1,    -1,   224,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   454,    -1,    -1,    -1,  1750,
     369,  1752,  1753,    -1,    -1,  1756,    -1,    -1,   467,   468,
     469,  1762,   471,   472,   473,   474,   475,   476,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   487,  1780,
      -1,    -1,  1783,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2051,    -1,    -1,    -1,  2055,  2056,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3113,    -1,    -1,   304,    -1,    -1,    -1,  1818,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3136,    -1,   454,   327,    -1,    -1,    -1,
      -1,    -1,    -1,  3146,    -1,  1851,    -1,    -1,   467,   468,
     469,    -1,   471,   472,   473,   474,   475,   476,   349,    -1,
      -1,    -1,    -1,    -1,   355,    -1,    -1,    -1,    -1,    -1,
     361,    -1,    -1,    -1,    -1,  2051,    -1,    -1,    -1,  2055,
    2056,    -1,    -1,    -1,    -1,    -1,    -1,  1888,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   388,   389,  2156,
      -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     401,     5,    -1,    -1,    -1,   406,    -1,    -1,    -1,    -1,
    2177,    -1,    -1,    -1,   415,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    26,    -1,    -1,   426,    -1,  1938,    -1,    -1,
      -1,    -1,    36,    37,    -1,    -1,    -1,  1948,    -1,    -1,
      44,    45,    -1,    -1,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    -1,    -1,
    2156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1998,    -1,    -1,
    2001,  2177,    -1,  3306,  3307,  3308,  3309,    -1,    -1,    -1,
      -1,    -1,  2013,  2014,    -1,    -1,  2017,  2018,    -1,    -1,
     114,  2022,    -1,    -1,    -1,    -1,    -1,  2028,    -1,    -1,
      -1,    -1,  2033,  2034,    -1,    -1,    -1,  2038,  2039,    -1,
      -1,    -1,    -1,  2044,    -1,  2051,    -1,    -1,    -1,  2055,
    2056,    -1,    -1,    -1,    -1,    72,    -1,    -1,    -1,  2060,
    2061,  2062,  2063,    -1,  2065,    -1,    -1,  2068,  2069,    -1,
      -1,    -1,    -1,  2074,    -1,  2332,    -1,    -1,    95,    -1,
      -1,    -1,    -1,   100,    -1,    -1,    -1,  2088,   182,    -1,
      -1,  2092,    -1,    -1,  2095,  2096,  2097,  2098,    -1,    -1,
      -1,    -1,   196,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2111,  2112,  2113,  2114,  2115,  2116,  2117,    -1,    -1,  2120,
    2121,   215,    -1,  2124,  2125,  2126,    86,    -1,  2129,  2130,
      -1,    -1,    -1,    93,    -1,  2136,  2137,  2138,    -1,  2140,
      -1,   235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2156,    -1,    -1,    -1,    -1,    -1,  2332,  2158,  2159,  2160,
    2161,  2162,  2163,    -1,    -1,    -1,   183,    -1,    -1,   129,
      -1,  2177,    -1,   267,    -1,    -1,   270,    -1,  2179,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   147,   148,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   157,   292,  2200,
     217,   161,    -1,    -1,   221,    -1,    -1,  2208,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   181,    -1,   183,   241,   242,    -1,  2228,    -1,    -1,
      -1,    -1,  2233,    -1,  2235,    -1,    -1,   254,   198,    -1,
      -1,    -1,  2243,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2251,    -1,    -1,    -1,  2255,  2256,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,    -1,    -1,    -1,    -1,  2270,
    2271,  2272,  2273,   290,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   304,    -1,  3592,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2298,    -1,    -1,
      -1,    -1,    -1,   397,    -1,    -1,  2563,  2564,    -1,  2566,
    3613,    -1,    -1,  2314,    -1,   409,    -1,    -1,    -1,    -1,
      -1,    -1,  2579,    -1,  2581,    -1,  2332,    -1,   422,    -1,
      -1,  3634,    -1,    -1,    -1,    -1,    -1,  2338,    -1,  1144,
    2341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     444,    -1,   369,  2610,    -1,    -1,    -1,    -1,   452,   453,
      -1,   455,    -1,    -1,    -1,    -1,    -1,   461,   462,   463,
     464,  3674,   466,   467,    -1,    -1,    -1,   471,   472,   473,
     474,   475,    -1,    -1,   478,   479,   480,  2563,  2564,    -1,
    2566,    -1,    -1,    -1,   488,    -1,    -1,    -1,    72,    -1,
      -1,    -1,  2659,  2579,    -1,  2581,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    87,  2415,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    -1,  2680,    -1,   385,   100,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2610,    -1,    -1,   454,    -1,    -1,
      -1,    -1,    -1,  2444,    -1,    -1,    -1,    -1,    -1,  1254,
      -1,    -1,    -1,  2710,   471,   472,   473,   474,   475,   476,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2725,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2738,    -1,  2659,    -1,    -1,  2487,    -1,    -1,    -1,
      -1,    -1,  2493,    -1,    -1,  2752,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2680,    -1,  2507,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2787,  2532,  2533,  2534,  2710,    -1,  2793,    -1,    -1,    -1,
      -1,    -1,    -1,   217,    -1,  2546,    -1,   221,    -1,  2725,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2563,  2564,    -1,
    2566,    -1,  2738,    -1,    -1,    -1,    -1,   241,   242,    -1,
      -1,    -1,    -1,  2579,    -1,  2581,  2752,    -1,    -1,    -1,
     254,    -1,    -1,    -1,  2585,  2586,    -1,  2844,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2610,  2606,    -1,  2864,    -1,    -1,
      -1,  2787,    -1,   287,    -1,    -1,   290,  2793,  2619,  2620,
    2621,  2622,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     304,    -1,   306,    -1,  2891,    -1,    -1,    -1,   598,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2652,  2653,  2659,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2662,  2663,    -1,    -1,    -1,    -1,  2924,  2844,    -1,
      -1,    -1,    -1,    -1,  2680,    -1,  1481,    -1,    -1,    -1,
      72,    -1,    -1,    -1,    -1,    -1,  2687,    -1,  2864,    -1,
      -1,    -1,    -1,    -1,    -1,   369,    -1,    -1,    -1,    -1,
    2701,  2702,  2703,    95,  2710,    -1,    -1,    -1,   100,    -1,
    1515,    -1,    -1,    -1,    -1,  2891,    -1,    -1,    -1,  2725,
      -1,    -1,    -1,    -1,  1529,  2726,    -1,    -1,    -1,    -1,
      -1,    -1,  2738,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2746,  2752,    -1,  2924,    -1,
    2751,    -1,    -1,    -1,    -1,    -1,    -1,  2758,    -1,    -1,
    2761,  2762,    -1,    -1,  2765,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1580,    -1,  2778,    -1,    -1,
     454,  2787,    -1,    -1,    -1,  3042,    -1,  2793,    -1,    -1,
      -1,   183,  1597,   467,   468,   469,    -1,   471,   472,   473,
     474,   475,   476,    -1,    -1,    -1,    -1,   481,    -1,  1614,
      -1,  2812,    -1,    -1,    -1,    -1,    -1,    -1,  2819,    -1,
      -1,    -1,    -1,    80,    -1,   217,    -1,    -1,    -1,   221,
      -1,    -1,  2833,    72,  1639,    -1,    -1,    -1,  2844,   799,
      -1,    -1,    -1,    -1,    -1,  2846,    -1,    -1,    87,   241,
     242,    -1,    -1,    -1,    -1,   112,    95,    -1,  2864,    -1,
      -1,   100,   254,    -1,    -1,    -1,  3042,   124,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   134,   838,   839,
      -1,   841,  1687,    -1,  3141,  2891,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1698,    -1,   152,    -1,    -1,   290,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   304,    -1,    -1,    -1,   173,    -1,  2924,    -1,
     880,    -1,    -1,    -1,   884,    -1,   886,    -1,   888,    -1,
      -1,    -1,    -1,    -1,   894,   895,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   903,    -1,    -1,    -1,   204,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   921,    -1,    -1,    -1,  3141,    -1,   224,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2976,    -1,   369,   217,    -1,
      -1,    -1,   221,    -1,    -1,    -1,    -1,    -1,   948,    -1,
      -1,   248,    -1,    -1,    -1,   955,   956,    -1,    -1,   959,
     960,    -1,   241,   242,    -1,    -1,    -1,  3008,  3009,    -1,
      -1,    -1,    -1,    -1,    -1,   254,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3042,    -1,  3295,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1851,   304,   287,  3050,
      -1,   290,    -1,  3054,  3055,  3056,  3057,  3058,  3059,  3060,
    1020,    -1,   454,    -1,    -1,   304,    -1,   306,    -1,    -1,
     327,    -1,    -1,    -1,  1034,  1035,    -1,    -1,    -1,   471,
     472,   473,   474,   475,   476,  3342,    -1,    -1,    -1,    -1,
      -1,    -1,   349,    -1,    -1,    -1,   353,    -1,   355,    -1,
      -1,    -1,    -1,    -1,   361,  3106,  3107,  3108,  3109,  3110,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3295,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3129,    -1,
     369,   388,   389,    -1,    -1,  3141,   393,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   401,    -1,    -1,    -1,    -1,   406,
      -1,  3152,    -1,    -1,    -1,  3156,    -1,    -1,  3159,    -1,
    3161,    -1,    -1,    -1,    -1,    -1,  3342,  3168,    -1,   426,
      -1,    -1,    -1,  3174,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1141,    -1,    -1,    -1,    -1,    -1,  3188,    -1,  3190,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3201,    -1,  3203,    -1,  3205,    -1,    -1,    -1,  3209,    -1,
    3211,    -1,    -1,    -1,    -1,   454,    -1,  3474,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3226,    -1,    -1,   467,   468,
     469,    -1,   471,   472,   473,   474,   475,   476,    -1,    -1,
      -1,    -1,   481,    -1,    -1,    72,  2051,    -1,    -1,    -1,
    2055,  2056,  1212,    -1,    -1,    -1,    -1,    -1,   114,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,
      -1,    -1,    -1,   100,    -1,    -1,    -1,    -1,    -1,    -1,
    1240,    -1,    -1,  1243,    -1,    -1,    -1,    -1,    -1,  3295,
      -1,    -1,    -1,  1253,    -1,    -1,    -1,    -1,  3474,    -1,
     156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3325,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3342,  3338,  3339,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   203,  3349,  3350,
    3351,  2156,    -1,    72,   210,  3356,   212,    -1,  3359,  3360,
    3361,  3362,    -1,    -1,    -1,    -1,    -1,   223,    87,    -1,
      -1,    -1,  2177,    -1,    -1,    -1,    95,  1337,    -1,    -1,
      -1,   100,    -1,    -1,    -1,  3386,    -1,  1347,    -1,    -1,
     217,    -1,    -1,    -1,   221,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1368,    -1,
      -1,    -1,  1372,  1373,   241,   242,    -1,    -1,    -1,    -1,
    3677,    -1,    -1,    -1,  3681,  3682,  1386,   254,    -1,  1389,
      -1,    -1,    -1,  1393,  1394,    -1,  3437,    -1,    -1,    -1,
      -1,    -1,    -1,  3444,    -1,    -1,    -1,    -1,    -1,  3450,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3459,    -1,
     287,  3462,    -1,   290,    -1,    -1,    -1,    -1,  3474,    -1,
      -1,  3472,    -1,    -1,    -1,    -1,    -1,   304,    -1,   306,
      -1,    -1,    -1,    -1,  3485,    -1,    -1,    -1,    -1,    -1,
    3491,  3748,    -1,  1453,    -1,  1455,    -1,    -1,   217,    -1,
      -1,  3677,   221,    -1,    -1,  3681,  3682,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,    -1,    -1,    -1,  2332,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   254,    -1,    -1,    -1,    -1,
    1500,    -1,   369,    -1,    -1,    -1,  1506,    -1,    -1,    -1,
      -1,  3552,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    -1,    -1,    -1,   287,    -1,
      -1,   290,  3748,    -1,    -1,    -1,    -1,    -1,    87,  3580,
      -1,    -1,    -1,    -1,    -1,   304,    95,   306,    -1,    -1,
      -1,   100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3601,    -1,  3603,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1582,    -1,  3625,  3626,    -1,   454,    -1,  3630,
    3631,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3639,    -1,
     467,   468,   469,    -1,   471,   472,   473,   474,   475,   476,
     369,    -1,    -1,    -1,   481,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3677,    -1,    -1,    -1,  3681,  3682,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3685,  3686,  3687,  3688,  3689,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1665,  3707,    -1,   217,    -1,
      -1,    -1,   221,    -1,  1674,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3726,  3727,    -1,    -1,    -1,
      -1,    -1,   241,   242,    -1,   454,    -1,    -1,    -1,    -1,
      -1,    -1,  3748,    -1,    -1,   254,    -1,    -1,   467,   468,
     469,    -1,   471,   472,   473,   474,   475,   476,  2563,  2564,
      -1,  2566,   481,    -1,    -1,  3766,  3767,    -1,    -1,    -1,
      -1,  1731,    -1,  3774,  2579,    -1,  2581,    -1,   287,    -1,
      -1,   290,    -1,    -1,    -1,  1745,  1746,    -1,    -1,    -1,
    3791,    -1,    -1,    -1,    -1,   304,    -1,   306,    -1,    -1,
      -1,  3802,    -1,    -1,    -1,  2610,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1798,  1799,
    3841,    -1,    -1,    -1,    -1,  1805,  1806,    -1,    -1,    72,
    1810,  1811,    -1,    -1,  2659,    -1,    -1,    -1,    -1,    -1,
     369,    -1,    -1,    -1,    87,  1825,  3867,  1827,    -1,    -1,
      -1,    -1,    95,    -1,    -1,  2680,    -1,   100,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1847,    -1,  1849,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   759,    -1,  2710,    -1,    -1,    -1,    72,
      -1,   767,    -1,    -1,    -1,   771,    -1,    -1,    -1,    -1,
    2725,  1881,    -1,    -1,    -1,    -1,    -1,    -1,  1888,    -1,
      -1,    -1,    95,  2738,    -1,    -1,  1896,   100,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   454,    -1,  2752,   804,    -1,
      -1,    -1,  1912,    -1,    -1,    -1,    -1,    -1,   467,   468,
     469,    -1,   471,   472,   473,   474,   475,   476,    -1,    -1,
      -1,    -1,   481,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2787,    -1,    -1,    -1,    -1,    -1,  2793,    -1,
      -1,    -1,    -1,    -1,   217,    -1,   852,    -1,   221,    -1,
      -1,    -1,   858,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    -1,    -1,    -1,
       3,   254,    -1,    -1,  1994,    -1,     9,    -1,  1998,  2844,
      87,  2001,    15,    -1,    17,    -1,    19,    -1,    95,    -1,
      -1,    -1,    -1,   100,   217,    -1,    29,    -1,   221,  2864,
      -1,    -1,    -1,    -1,   287,    -1,    -1,   290,    -1,    -1,
      -1,    -1,    -1,    46,    47,    -1,    -1,    -1,   241,   242,
      -1,   304,    -1,   306,    -1,    -1,  2891,    -1,    -1,    -1,
      -1,   254,    -1,    -1,    -1,    -1,    -1,   953,    -1,    -1,
      73,    -1,   958,    -1,    -1,   961,    -1,    -1,    -1,    -1,
      83,    -1,    85,    86,    -1,    -1,    -1,    -1,    -1,  2924,
      -1,    -1,    -1,    -1,   287,    -1,    99,   290,   984,    -1,
    2090,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2099,
      -1,   304,  2102,  2103,    -1,   118,   369,   120,   121,    -1,
      -1,    -1,   125,   126,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   136,    -1,   138,    -1,    -1,    -1,    -1,
     217,    -1,    -1,    -1,   221,    -1,    -1,    -1,    -1,   152,
      -1,   154,    -1,    -1,   157,    -1,    -1,    -1,    -1,    -1,
     163,  1144,    -1,    -1,   241,   242,   169,  2157,    -1,    -1,
      -1,    -1,   175,    -1,    -1,  2165,   369,   254,   181,  2169,
      -1,    -1,    -1,  1144,   187,    -1,   189,    -1,    -1,  2179,
      -1,   194,    -1,    -1,  2184,    -1,    -1,    -1,    -1,    -1,
      -1,   454,   205,    -1,   207,    -1,    -1,  3042,    -1,    -1,
     287,    -1,    -1,   290,   467,   468,   469,    -1,   471,   472,
     473,   474,   475,   476,  1110,  1111,    -1,   304,   481,   306,
     233,  1117,    -1,    -1,    -1,    -1,    -1,  1123,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2238,    -1,
      -1,    -1,    -1,   256,   257,    -1,    -1,    -1,  1144,   262,
      -1,   454,    -1,    -1,    -1,    -1,    -1,    -1,   271,    -1,
      -1,  1254,    -1,    -1,   467,   468,   469,    -1,   471,   472,
     473,   474,   475,   476,    -1,  1171,   289,    -1,    -1,    -1,
      -1,    -1,   369,  1254,  2284,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3141,    -1,  2298,  2299,
      -1,    -1,  2302,    -1,  2304,    -1,    -1,    -1,    -1,   322,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   332,
      -1,    -1,   335,    -1,   337,    -1,    -1,    -1,    -1,   342,
      -1,  1227,    -1,    72,   347,    -1,    -1,   350,    -1,    -1,
      -1,   354,    -1,    -1,    -1,    -1,    -1,   360,    87,    -1,
      -1,    -1,   365,    -1,    -1,   368,    95,    -1,  1254,    -1,
      -1,   100,   375,    -1,    -1,    -1,    -1,   454,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1275,
     467,   468,   469,    -1,   471,   472,   473,   474,   475,   476,
      -1,   404,    -1,   406,   481,    -1,    -1,    -1,    -1,   412,
      -1,   414,    -1,    -1,   417,    -1,  1302,    -1,   421,    -1,
      72,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    -1,    -1,  1332,  1333,   100,  1335,
      -1,    72,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3295,    -1,    -1,    -1,    -1,    -1,  1352,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    -1,    -1,   480,    -1,   100,
      -1,    72,    -1,    -1,    -1,    -1,    -1,    -1,   217,    -1,
      -1,    -1,   221,  2483,    -1,  2485,    -1,  2487,  1481,    -1,
      -1,    -1,    -1,    -1,    95,    -1,    -1,  3342,    -1,   100,
      -1,    -1,   241,   242,    -1,    -1,    -1,    -1,    -1,    -1,
    1481,    -1,    -1,    -1,    -1,   254,    -1,    -1,    -1,    -1,
      -1,    -1,  1515,    -1,    -1,  1421,    -1,    -1,  1424,  1425,
      -1,    -1,    -1,    -1,    -1,    -1,  1529,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1515,    -1,    -1,    -1,   287,    -1,
      -1,   290,   183,    -1,    -1,   217,    -1,    -1,  1529,   221,
      -1,    -1,    -1,    -1,    -1,   304,    -1,   306,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   241,
     242,    -1,   183,  2583,    -1,  1481,   217,  1580,    -1,  1485,
     221,    -1,   254,  1489,    -1,    -1,    -1,    -1,    -1,    -1,
    2600,    -1,    -1,    -1,  1597,    -1,    -1,  2607,  2608,  1580,
     241,   242,  1508,    -1,    -1,    -1,   217,    -1,    -1,  1515,
     221,  1614,    -1,   254,    -1,   287,  1597,    -1,   290,  3474,
     369,    -1,    -1,  1529,    72,    -1,    -1,    -1,    -1,    -1,
     241,   242,   304,  1614,   306,    -1,  1639,    -1,    -1,    87,
      -1,    -1,    -1,   254,    -1,    -1,    -1,    95,  2658,   290,
    2660,  2661,   100,    -1,    -1,    -1,    -1,    -1,  1639,    -1,
      -1,    -1,   139,   304,  2674,    -1,    -1,    -1,    -1,    -1,
    2680,    -1,    -1,    -1,  1580,  2685,    -1,  2687,    -1,   290,
      -1,    -1,    -1,    -1,  1687,    -1,    -1,    -1,    -1,  2699,
    2700,  1597,    -1,   304,    -1,  1698,    -1,   369,    -1,    -1,
    2710,    -1,    -1,    -1,    -1,   454,  1687,    -1,  1614,    -1,
      -1,    -1,  2722,    -1,    -1,    -1,  2726,  1698,   467,   468,
     469,    -1,   471,   472,   473,   474,   475,   476,   369,    -1,
      -1,    -1,   481,  1639,    -1,    -1,    -1,  1643,    -1,    -1,
    2750,  2751,    -1,    -1,    -1,    -1,    -1,    -1,   225,    -1,
      -1,  2761,    -1,    -1,    -1,    -1,    -1,    -1,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   217,
      -1,    -1,    -1,   221,    -1,    -1,  1682,    -1,  1684,    -1,
      -1,  1687,   454,  1689,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1698,   241,   242,   467,   468,   469,    -1,   471,
     472,   473,   474,   475,   476,    -1,   254,    -1,    -1,   481,
      -1,    -1,    -1,   454,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3677,    -1,    -1,    -1,  3681,  3682,    -1,    -1,
     471,   472,   473,   474,   475,   476,    -1,    -1,    -1,   287,
      -1,    -1,   290,   454,    -1,  1751,    -1,    -1,  1851,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   304,    -1,   306,    -1,
     471,   472,   473,   474,   475,   476,    -1,    -1,    -1,    -1,
    1851,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1785,
    1786,    -1,    -1,    -1,    -1,    -1,    -1,  1793,    -1,    -1,
    1796,  1797,    -1,  3748,  1800,    -1,    -1,    -1,    -1,    -1,
    2910,    -1,  1808,  1809,    -1,    -1,    -1,    -1,    -1,    -1,
    1816,    -1,    -1,  1819,  1820,  1821,  1822,    -1,    -1,    -1,
      -1,   369,    -1,  1829,  1830,    -1,  1832,    -1,  1834,    -1,
      -1,  1837,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1851,  1852,  1853,    -1,    -1,
    1856,    -1,    -1,    -1,  1860,    -1,    -1,    -1,  1864,    -1,
      -1,  1867,  1868,  1869,  1870,  1871,  1872,  1873,  1874,  1875,
      -1,  1877,    -1,    -1,    -1,    -1,  1882,    -1,    -1,    -1,
    1886,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   454,    -1,    -1,    87,
      -1,    -1,    -1,    91,    -1,    -1,    -1,    95,    -1,   467,
     468,   469,   100,   471,   472,   473,   474,   475,   476,    -1,
      -1,   479,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1947,    -1,    -1,    -1,    -1,    -1,    -1,  2051,    -1,
      -1,    -1,  2055,  2056,    -1,    72,    -1,    -1,    -1,    -1,
      -1,  3071,  3072,  3073,  3074,  3075,  3076,    -1,    -1,    -1,
    2051,    -1,    -1,    -1,  2055,  2056,    -1,    -1,    95,    -1,
      -1,    -1,    -1,   100,    -1,    -1,    72,    -1,   166,    -1,
      -1,  3101,    -1,    -1,    -1,    -1,  3106,  3107,  3108,  3109,
    3110,    -1,    -1,    -1,  3114,    -1,    -1,    -1,    -1,    95,
    2016,    -1,    -1,    -1,   100,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2031,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   217,
      -1,    -1,    -1,   221,    -1,  2051,    -1,    -1,    -1,  2055,
    2056,    -1,    -1,  2156,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3172,   241,   242,    -1,   183,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2177,  2156,   254,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2177,   183,    -1,    -1,
     217,    -1,    -1,    -1,   221,    -1,    -1,    -1,    -1,   287,
      -1,  3221,   290,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   304,    -1,   306,    -1,
      -1,   217,    -1,    -1,    -1,   221,    -1,   254,    -1,    -1,
      -1,    -1,    -1,  2149,    -1,    -1,    -1,    -1,    -1,    -1,
    2156,    -1,    -1,    -1,    -1,   241,   242,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   254,  2175,
      -1,  2177,    -1,   290,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   304,    -1,    -1,
     767,   369,    -1,    -1,   771,    -1,   773,    -1,    -1,    -1,
      -1,   778,   779,    -1,   290,    -1,    -1,    -1,   785,  3319,
    3320,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   304,    -1,
    3330,    -1,    -1,    -1,    -1,   802,    -1,   804,    -1,  2332,
    3340,  3341,    -1,    -1,    -1,  3345,  3346,    -1,   416,    -1,
      -1,    -1,    -1,    -1,  2250,  3355,    -1,    -1,    -1,    -1,
      -1,  2332,   369,    -1,  2260,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3372,  3373,  3374,    -1,    -1,    -1,    -1,    -1,
     847,    -1,  3382,  3383,    -1,   852,   454,  3387,    -1,    -1,
      -1,   858,    -1,   369,    -1,    -1,  2292,    -1,    -1,   467,
     468,   469,    -1,   471,   472,   473,   474,   475,   476,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2321,  3426,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2332,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   912,    -1,   454,    -1,    -1,
     917,  3451,    -1,  2349,  2350,    -1,    -1,    -1,    -1,    -1,
      -1,   928,    -1,    -1,   471,   472,   473,   474,   475,   476,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   454,    -1,
      -1,    -1,    -1,    -1,    -1,  2381,    -1,    -1,    -1,  2385,
     957,    -1,    -1,    -1,    -1,   471,   472,   473,   474,   475,
     476,  2397,  2398,  2399,  2400,    -1,   973,    -1,    -1,  2405,
      -1,   978,    -1,  2409,  2410,    -1,    -1,    -1,  2414,    -1,
      -1,    -1,    -1,    -1,    -1,   992,    -1,    -1,  2424,  2425,
      -1,  2427,    -1,    -1,    -1,    -1,    -1,    72,    -1,    -1,
      -1,    -1,    -1,    -1,  2440,    -1,  2442,    -1,    -1,    -1,
    2446,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    -1,    -1,    -1,    -1,   100,  2462,    -1,    -1,    -1,
    2563,  2564,  3572,  2566,    -1,    -1,  2472,    -1,  2474,  2475,
      -1,    -1,    -1,    -1,    -1,    -1,  2579,    95,  2581,    -1,
      -1,    -1,  2563,  2564,    -1,  2566,   104,    -1,    -1,  2495,
      -1,    -1,    -1,    -1,    -1,  2501,    -1,    -1,  2579,    -1,
    2581,    -1,    -1,    -1,  2510,  2511,  2512,  2610,    -1,    -1,
      -1,    -1,    -1,  3623,    -1,    -1,    -1,    -1,    -1,    -1,
     138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2610,
     148,    -1,    -1,   151,    -1,    -1,  2542,  1114,    -1,   157,
    1117,    -1,    -1,   161,    -1,    -1,  1123,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1144,  2659,  2563,  2564,    -1,
    2566,    -1,    -1,    -1,    -1,   183,    -1,    -1,    -1,    -1,
      -1,    -1,   217,  2579,    -1,  2581,   221,  2680,  2659,    -1,
     198,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1165,  1166,
    1167,    -1,    -1,    -1,  1171,    -1,   241,   242,    -1,  2680,
      72,    -1,    -1,    -1,  2610,    -1,    -1,  2710,    -1,   254,
      -1,    -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,  2725,    95,    -1,    -1,    -1,    -1,   100,  2710,
      -1,    -1,    -1,    -1,    -1,  2738,    -1,    -1,    -1,    -1,
      -1,    -1,   287,    -1,  2725,   290,    -1,    -1,    -1,  2752,
      -1,    -1,    -1,  2659,    -1,    -1,    -1,  2738,    -1,   304,
      -1,   306,    -1,    -1,    -1,  1254,    -1,    -1,  1245,    -1,
      -1,  2752,    -1,    -1,  2680,    -1,   321,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2787,    -1,    -1,    -1,    -1,  1266,
    2793,    -1,  3802,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2709,  2710,    -1,  2787,    -1,    -1,    -1,
      -1,    -1,  2793,    -1,    -1,    -1,    -1,    -1,    -1,  2725,
      -1,    -1,    -1,    -1,   369,   197,    -1,    -1,    -1,    -1,
     202,  3841,  2738,    -1,    -1,    -1,    -1,   382,    -1,    -1,
      -1,  2844,    -1,    -1,    -1,   217,  2752,    -1,    -1,   221,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3867,    -1,    -1,
      -1,  2864,  2768,  2844,    -1,    -1,  2772,   385,    -1,   241,
     242,    -1,    -1,    -1,    -1,    -1,  2782,    -1,    -1,    -1,
      -1,  2787,   254,  2864,    -1,    -1,    -1,  2793,  2891,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2811,    -1,    -1,    -1,   454,
    2891,    -1,    -1,    -1,    -1,   287,    -1,    -1,   290,    -1,
      -1,  2924,   467,   468,   469,  1402,   471,   472,   473,   474,
     475,   476,   304,    -1,   306,  2841,    -1,    -1,  2844,    -1,
      -1,    -1,    -1,  2924,    -1,    -1,  2852,    -1,    -1,    -1,
      -1,    -1,  2858,    -1,  2860,    -1,    -1,    -1,  2864,  2865,
      -1,    -1,  2868,  2869,  2870,  2871,  2872,  2873,  2874,  2875,
    2876,  2877,    -1,    -1,    -1,    -1,  2882,  2883,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2891,    -1,    -1,    -1,    -1,
    2896,    -1,  1481,    -1,  2900,    -1,  2902,   369,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2911,    -1,    -1,  2914,    -1,
    2916,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2924,  2925,
    2926,  2927,    -1,    -1,    -1,  2931,  1515,    -1,  2934,    -1,
      -1,    72,    -1,    -1,    -1,    -1,    -1,    -1,  2944,  3042,
    1529,    -1,    -1,    -1,    -1,    -1,    87,    -1,    -1,    90,
      -1,    -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,   100,
      -1,  3042,    -1,    -1,    -1,    -1,    -1,  1544,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1557,    -1,   454,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1580,    -1,    -1,    -1,   467,   468,   469,    -1,   471,
     472,   473,   474,   475,   476,    -1,    -1,    -1,  1597,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1614,    -1,    -1,    -1,    -1,
     648,   649,    -1,    -1,    -1,    -1,  3042,    -1,  3141,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1639,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3141,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   217,    -1,    -1,    -1,
     221,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1687,    -1,
     241,   242,    -1,    -1,    -1,  1682,    -1,  1684,    -1,  1698,
      -1,    -1,  1689,   254,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3130,  1702,    -1,    -1,    -1,    -1,
      -1,    -1,  1709,    -1,    -1,  3141,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   287,    -1,    -1,   290,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   777,
      -1,    -1,   780,   304,   782,   306,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1751,    -1,    -1,  1754,  1755,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3192,   805,    -1,  1766,
      -1,  3197,  3295,    -1,  3200,    -1,    -1,    -1,    -1,    -1,
     818,    -1,    -1,    -1,   822,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3295,    -1,    -1,    -1,    -1,    -1,
      -1,   839,    -1,   841,    -1,    -1,    -1,    -1,   369,    -1,
      -1,    -1,  3238,    -1,    -1,   853,    -1,    -1,    -1,  3342,
      72,    -1,    -1,    -1,    -1,    -1,   864,    -1,    -1,    -1,
     868,    -1,   870,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,  3342,  1851,    95,    -1,    -1,    -1,    -1,   100,  3275,
      -1,    -1,    -1,    -1,    -1,    -1,  3282,  3283,   896,   897,
      -1,    -1,    -1,  3289,  3290,   903,    -1,    -1,  3294,  3295,
      -1,    -1,    -1,    -1,  3300,  3301,    -1,    -1,  3304,    -1,
      -1,    -1,    -1,    -1,  1881,    -1,   924,    -1,   926,    -1,
      -1,    -1,    -1,   454,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   467,   468,   469,    -1,
     471,   472,   473,   474,   475,   476,  3342,   955,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1945,    -1,
      -1,  3474,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   217,    -1,    -1,    -1,   221,
      -1,    72,    -1,  3474,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3409,    -1,    -1,    87,    -1,    -1,   241,
     242,    -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,   100,
      -1,    -1,   254,    -1,    -1,    -1,    -1,    -1,  1046,    -1,
      -1,  1049,    -1,    -1,  1052,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3450,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   287,    -1,    -1,   290,  3465,
      -1,    -1,  2051,  3469,    -1,    -1,  2055,  2056,  3474,    -1,
      -1,    -1,   304,    -1,   306,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1103,    -1,    -1,    -1,    -1,
      -1,  3497,    -1,    -1,    -1,  3501,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1128,    -1,    -1,    -1,  3520,  3521,  1134,    -1,  3524,    -1,
    1138,    -1,    -1,    -1,    -1,  3531,  3532,  1145,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   217,   369,    -1,    -1,
     221,    -1,    -1,    -1,    -1,  3551,  2123,    -1,    72,    -1,
      -1,    -1,    -1,    -1,  1172,    -1,    -1,    -1,    -1,  3565,
     241,   242,    -1,    87,    -1,    -1,    90,  2156,    -1,    -1,
      -1,    95,    -1,   254,  3677,    -1,   100,    -1,  3681,  3682,
      -1,    -1,    -1,    -1,  3590,    -1,    -1,    -1,  2177,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3677,    -1,    -1,    -1,
    3681,  3682,    -1,    -1,    -1,    -1,   287,    -1,    -1,   290,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1237,
    3626,  3627,   454,   304,    -1,   306,    -1,  2204,    -1,    -1,
      -1,    -1,    -1,  1251,    -1,   467,   468,   469,    -1,   471,
     472,   473,   474,   475,   476,  3748,    -1,  3653,  3654,    -1,
    3656,    -1,  3658,    -1,    -1,  2232,    -1,    -1,    -1,    72,
      -1,    -1,    -1,  2240,    -1,    -1,    -1,  3748,    -1,    -1,
      -1,  3677,    -1,  2250,    87,  3681,  3682,    -1,    -1,    -1,
      -1,    -1,    95,    -1,    -1,    -1,    -1,   100,   369,    -1,
      80,    -1,    -1,   217,    -1,    -1,    -1,   221,    -1,    -1,
      -1,    -1,    92,    -1,   203,    -1,    -1,    -1,    -1,    -1,
      -1,   210,    -1,   212,    -1,    -1,    -1,   241,   242,    -1,
    3726,    -1,   112,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     254,    -1,    -1,    -1,    -1,   416,    -1,    -1,    -1,    -1,
      -1,   131,  3748,  2332,   134,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   152,   287,    -1,    -1,   290,    -1,   158,    -1,
      -1,    -1,    -1,   454,    -1,    -1,    -1,    -1,    -1,    -1,
     304,  3787,   306,   173,    -1,    -1,   467,   468,   469,    -1,
     471,   472,   473,   474,   475,   476,  3802,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   217,    -1,    -1,    -1,   221,    -1,
      -1,    -1,    -1,    -1,   204,    -1,   206,    -1,    -1,    -1,
     210,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
      -1,    -1,    -1,    -1,   224,  3841,  3842,    -1,    -1,    -1,
      -1,   254,    -1,    -1,    -1,   369,    -1,    -1,    -1,  3855,
      -1,    -1,    -1,    -1,    -1,    -1,  1474,   247,    -1,    -1,
      -1,  3867,    -1,    -1,    -1,    -1,    -1,    -1,   258,    -1,
      -1,    -1,    -1,    -1,   287,    -1,    -1,   290,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    -1,    -1,    -1,    -1,  2466,
      -1,   304,    -1,   306,    -1,  2472,    -1,    -1,    87,    -1,
      -1,    -1,    -1,    -1,   317,    -1,    95,    -1,    -1,    -1,
      -1,   100,    -1,    -1,   304,    -1,   306,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     454,    -1,    -1,    -1,    -1,    -1,    -1,   327,    -1,    -1,
      -1,    -1,    -1,   467,   468,   469,    -1,   471,   472,   473,
     474,   475,   476,    -1,    -1,    -1,   369,    -1,    -1,   349,
      -1,    -1,    -1,   353,    -1,   355,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2563,  2564,    -1,  2566,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2579,    -1,  2581,    -1,    -1,    -1,    -1,    -1,    -1,   389,
     390,    -1,   392,   393,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   401,    -1,   202,    -1,   405,   406,    -1,    -1,    -1,
     410,  2610,    -1,    -1,    -1,   415,    -1,    -1,   217,    -1,
      -1,  1649,   221,    -1,  1144,    -1,    -1,    -1,    -1,    -1,
      -1,   454,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   467,   468,   469,    -1,   471,   472,
     473,   474,   475,   476,    -1,   254,    -1,    -1,    -1,    -1,
    2659,    -1,    -1,    -1,  1692,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1701,    -1,  1703,    -1,    -1,    -1,    -1,
    1708,  2680,    -1,    86,    -1,    -1,    -1,    -1,   287,    -1,
      -1,   290,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1730,  1731,    -1,   304,    -1,   306,    -1,    -1,
      -1,  2710,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2725,    -1,    -1,    -1,
      -1,    -1,    -1,  2720,  1254,    -1,    -1,    -1,    -1,  2738,
      -1,    -1,  2729,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,  2752,    -1,    -1,    -1,    -1,   161,    -1,
      -1,  2748,    -1,    -1,    -1,    -1,    87,    -1,    -1,    90,
     369,    -1,    -1,    -1,    95,    -1,    -1,    -1,   181,   100,
     183,  2768,    -1,    -1,    -1,  2772,    -1,    -1,  2787,    -1,
      -1,    -1,    -1,    -1,  2793,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2795,    -1,
    2797,    -1,    -1,    -1,    -1,  2802,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2811,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2831,  2844,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   454,    -1,    -1,   767,    -1,
    1888,    -1,   771,    -1,    -1,  2864,    -1,    -1,   467,   468,
     469,    -1,   471,   472,   473,   474,   475,   476,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    -1,  2891,    -1,    -1,   804,   217,    -1,    -1,    -1,
     221,    -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    -1,    -1,    -1,    -1,   100,    -1,    -1,
     241,   242,    -1,    -1,    -1,  2924,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   254,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   852,    -1,    -1,    -1,    -1,    -1,   858,
      -1,    -1,    -1,    -1,  2941,  2942,    -1,    -1,    -1,    -1,
      -1,  1481,    -1,    -1,    -1,    -1,   287,    -1,    -1,   290,
      -1,    -1,    -1,  2001,    -1,    72,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   304,    -1,   306,  2014,    -1,    -1,    -1,
      87,    -1,    -1,    -1,  2022,  1515,    -1,    -1,    95,    -1,
    2028,    -1,    -1,   100,    -1,  2033,    -1,    -1,    -1,  1529,
      -1,  2039,    -1,    -1,    -1,    -1,  2044,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   217,  2063,    -1,  2065,   221,    -1,
      -1,    -1,    -1,  3042,   953,    -1,    -1,    -1,   369,   958,
      -1,    -1,   961,    -1,    -1,    -1,    -1,    -1,   241,   242,
    1580,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2096,  2097,
    2098,   254,    -1,    -1,    -1,   984,    -1,  1597,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2113,  2114,  2115,  2116,    -1,
      -1,    -1,  2120,  2121,  1614,    -1,  2124,  2125,  2126,    -1,
      -1,    -1,  2130,    -1,   287,    -1,    -1,   290,    -1,  2137,
      -1,    -1,  2140,    -1,    -1,    -1,    -1,    -1,    -1,  1639,
     217,   304,    -1,   306,   221,    -1,  3113,    -1,    -1,    -1,
      -1,    -1,    -1,   454,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3141,    -1,   241,   242,   467,   468,   469,  3136,
     471,   472,   473,   474,   475,   476,    -1,   254,    -1,  3146,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1687,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,  1698,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   369,    -1,    -1,    -1,
     287,    -1,    -1,   290,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1110,    -1,    -1,    -1,  3192,    -1,   304,  1117,   306,
    3197,   394,    -1,  3200,  1123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   184,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1144,   197,    -1,    -1,    -1,
      -1,   202,    -1,    -1,    -1,    -1,   207,    -1,    -1,   210,
      -1,   212,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1171,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2298,   454,   369,    -1,    -1,    -1,   237,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   467,   468,   469,    -1,   471,   472,
     473,   474,   475,   476,   255,    -1,  3295,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2338,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1227,  3306,
    3307,  3308,  3309,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1851,    -1,    -1,    -1,    -1,    -1,    -1,   299,    -1,
      -1,    -1,     2,  3342,    -1,  1254,   307,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   454,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1275,    -1,    -1,    -1,
     467,   468,   469,    -1,   471,   472,   473,   474,   475,   476,
      -1,    -1,    -1,    -1,   345,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1302,    -1,    -1,   799,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1332,  1333,    -1,  1335,   388,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1352,    -1,    -1,    -1,    -1,   409,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3450,    -1,    -1,    -1,    -1,   429,    -1,
      -1,    -1,    -1,    -1,    -1,  3474,    -1,    -1,    -1,   138,
      -1,   884,  3469,   886,    -1,   888,    -1,    -1,   449,   450,
     451,   894,   895,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   161,    -1,    -1,    -1,  2533,  2534,    -1,    -1,    -1,
      -1,    -1,  1421,    -1,    -1,  1424,  1425,   478,   921,    -1,
     481,   482,   483,   183,    -1,   184,    -1,    -1,    -1,    -1,
      -1,  2051,    -1,    -1,    -1,  2055,  2056,    -1,   197,    -1,
      -1,    -1,    -1,   202,    -1,   948,    -1,    -1,   207,    -1,
      -1,   210,    -1,   212,    -1,    -1,   959,   960,    -1,    -1,
      -1,    -1,    -1,    -1,  3551,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1481,    -1,    -1,    -1,    -1,    -1,   237,    -1,
    1489,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2619,  2620,  2621,  2622,    -1,   255,    -1,    -1,  1508,
      -1,    -1,    -1,  3590,    -1,  3592,  1515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1020,    -1,    -1,
    1529,    -1,    -1,    -1,    -1,  2653,  3613,    -1,    -1,    -1,
      -1,  1034,  1035,    -1,    -1,  1038,  2156,    -1,    -1,  3626,
     299,    -1,    -1,    -1,    -1,    -1,    -1,  3634,   307,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2177,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1580,    -1,  2701,  2702,  2703,    -1,    -1,  3677,    -1,
      -1,    -1,  3681,  3682,    -1,    -1,   345,  3674,  1597,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2726,    -1,
      -1,    -1,    -1,    -1,    -1,  1614,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2746,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   388,
    1639,    -1,    -1,  2761,    -1,    -1,    -1,    -1,  1141,  3726,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3748,
     409,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     429,    -1,    -1,  1682,    -1,  1684,    -1,    -1,  1687,    -1,
    1689,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1698,
     449,   450,   451,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3787,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1212,
      -1,    -1,  2332,    -1,    -1,  3802,    -1,    -1,    -1,   478,
      -1,    -1,   481,   482,   483,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1751,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3841,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3855,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1785,  1786,    -1,    -1,
    3867,    -1,    -1,    -1,  1793,    -1,    -1,  1796,  1797,    -1,
      -1,  1800,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1808,
    1809,    -1,    -1,    -1,    -1,    -1,    -1,  1816,    -1,    -1,
    1819,  1820,  1821,  1822,    -1,    -1,    -1,    -1,    -1,    -1,
    1829,  1830,    -1,  1832,    -1,  1834,    -1,    -1,  1837,    -1,
      -1,    -1,    -1,    -1,  1337,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1851,  1852,  1347,    -1,    -1,  1856,    -1,    -1,
      -1,  1860,    -1,    -1,    -1,  1864,    -1,    -1,  1867,  1868,
    1869,  1870,  1871,  1872,  1873,  1874,  1875,    -1,  1877,    -1,
      -1,    -1,    -1,  1882,    -1,    -1,    -1,  1886,    -1,    -1,
      -1,    -1,    -1,  1386,    -1,    -1,  1389,    -1,    -1,    -1,
    1393,  1394,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3050,    -1,    -1,    -1,    -1,  3055,    -1,  3057,
    3058,  3059,  3060,    -1,    -1,    -1,    -1,    -1,  1947,    -1,
      -1,    -1,    -1,  2563,  2564,    -1,  2566,    -1,    -1,    -1,
      -1,    -1,  1455,    -1,    -1,    -1,    -1,    -1,    -1,  2579,
      -1,  2581,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2610,    -1,    -1,    -1,    -1,    -1,    -1,  1500,    -1,    -1,
      -1,  3129,    -1,  1506,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2031,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2659,
      -1,    -1,  2051,    -1,    -1,    -1,  2055,  2056,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2680,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3205,    -1,  1582,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2710,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2725,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   877,  2738,    -1,
      -1,    -1,    -1,    -1,   884,    -1,   886,    -1,   888,    -1,
      -1,    -1,  2752,    -1,   894,   895,    -1,    -1,    -1,    -1,
    2149,    -1,    -1,    -1,    -1,    -1,    -1,  2156,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1665,    -1,    -1,    -1,  2175,  2787,  2177,    -1,
      -1,  1674,    -1,  2793,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3339,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3350,    -1,  2844,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2250,    -1,    -1,  2864,    -1,    -1,    -1,    -1,    -1,
      -1,  2260,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1020,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2891,    -1,    -1,    -1,    -1,    -1,    -1,  1038,    -1,
      -1,    -1,    -1,  2292,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1798,  1799,    -1,    -1,    -1,
      -1,    -1,  1805,  1806,  2924,    -1,    -1,  1810,  1811,  3437,
      -1,    -1,  2321,    -1,    -1,    -1,  3444,    -1,    -1,    -1,
      -1,    -1,  1825,  2332,  1827,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2349,  2350,    -1,    -1,  1847,    -1,  1849,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2381,    -1,    -1,    -1,  2385,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2397,  2398,
    2399,  2400,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2409,    -1,    -1,    -1,    -1,  2414,    -1,    -1,    -1,  1912,
      -1,    -1,    -1,    -1,    -1,  2424,  2425,    -1,  2427,    -1,
      -1,    -1,  3042,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2440,    -1,  2442,    -1,    -1,    -1,  2446,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2462,    -1,    -1,  1216,  1217,    -1,  1219,
      -1,    -1,    -1,  2472,    -1,  2474,  2475,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2495,    -1,    -1,    -1,
      -1,  1994,  2501,    -1,    -1,  1998,    -1,    -1,    -1,  2002,
      -1,  2510,  2511,  2512,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3141,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2542,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2563,  2564,    -1,  2566,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2579,    -1,  2581,    -1,    -1,    -1,    -1,    -1,    -1,  3707,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2090,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2099,    -1,    -1,  2102,
    2103,  2610,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1389,
      -1,    -1,    -1,  1393,  1394,    -1,    -1,    -1,  3766,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2659,    -1,    -1,    -1,  2157,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2165,    -1,    -1,    -1,  2169,    -1,    -1,    -1,
      -1,  2680,    -1,    -1,    -1,  3295,  2179,    -1,    -1,    -1,
      -1,  2184,    -1,    -1,    -1,    -1,  1446,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2710,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2725,    -1,    -1,    -1,
      -1,    -1,  3342,    -1,    -1,    -1,    -1,    -1,    -1,  2738,
      -1,    -1,    -1,    -1,    -1,  2238,    -1,    -1,    -1,    -1,
    1500,    -1,    -1,  2752,    -1,    -1,  1506,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2768,
      -1,    -1,    -1,  2772,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2782,    -1,    -1,    -1,    -1,  2787,    -1,
      -1,  2284,    -1,    -1,  2793,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2811,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1582,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2841,    -1,    -1,  2844,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2852,    -1,    -1,    -1,    -1,    -1,  2858,
      -1,  2860,    -1,    -1,  3474,  2864,  2865,    -1,    -1,  2868,
    2869,  2870,  2871,  2872,  2873,  2874,  2875,  2876,  2877,    -1,
      -1,    -1,    -1,  2882,  2883,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2891,    -1,    -1,    -1,    -1,  2896,    -1,    -1,
      -1,    -1,    -1,  2902,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2911,    -1,    -1,  2914,    -1,  2916,    -1,    -1,
      -1,    -1,    -1,    -1,  1674,  2924,  2925,  2926,  2927,    -1,
      -1,    -1,  2931,    -1,    -1,  2934,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2944,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1719,
      -1,    -1,    -1,  1723,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2485,    -1,  2487,    -1,  1746,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3042,    -1,    -1,    -1,    -1,  1798,  1799,
      -1,    -1,    -1,    -1,    -1,    -1,  1806,    -1,    -1,    -1,
    1810,  1811,    -1,    -1,    -1,    -1,    -1,  3677,    -1,    -1,
      -1,  3681,  3682,    -1,    -1,  1825,    -1,  1827,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2583,    -1,    -1,    -1,    -1,    -1,    -1,  1847,    -1,  1849,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2600,    -1,    -1,
      -1,    -1,    -1,    -1,  2607,  2608,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3130,    -1,    -1,    -1,    -1,    -1,    -1,  3748,    -1,
      -1,    -1,  3141,    -1,    -1,    -1,  1896,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   767,    -1,
      -1,    -1,   771,    -1,    -1,  2658,    -1,  2660,  2661,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2674,    -1,    -1,    -1,    -1,    -1,  2680,    -1,    -1,
      -1,    -1,  2685,  3192,  2687,   804,    -1,    -1,  3197,    -1,
      -1,  3200,    -1,    -1,    -1,    -1,  2699,  2700,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2710,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2722,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3238,
      -1,    -1,    -1,   852,  1994,    -1,    -1,    -1,    -1,   858,
      -1,    -1,  2002,    -1,  2004,    -1,  2006,  2750,  2751,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3275,    -1,    -1,    -1,
      -1,    -1,    -1,  3282,  3283,    -1,    -1,    -1,    -1,    -1,
    3289,  3290,    -1,    -1,    -1,  3294,  3295,    -1,    -1,    -1,
      -1,  3300,  3301,    -1,    -1,  3304,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2090,    -1,    -1,  3342,   953,    -1,    -1,    -1,    -1,  2099,
      -1,    -1,  2102,  2103,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   984,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3409,    -1,    -1,    -1,    -1,    -1,    -1,  2910,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2179,
      -1,    -1,    -1,    -1,  2184,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3450,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3465,    -1,    -1,    -1,
    3469,    -1,    -1,    -1,    -1,  3474,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3497,    -1,
      -1,  1110,  3501,    -1,    -1,    -1,    -1,    -1,  1117,    -1,
      -1,    -1,    -1,    -1,  1123,    -1,    -1,    -1,    -1,    -1,
      -1,  3520,  3521,    -1,    -1,  3524,    -1,    -1,    -1,    -1,
      -1,    -1,  3531,  3532,    -1,  1144,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3551,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1171,    -1,    -1,    -1,  3565,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3071,  3072,
    3073,  3074,  3075,  3076,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3590,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3101,    -1,
      -1,    -1,    -1,  3106,  3107,  3108,  3109,  3110,  1227,    -1,
      -1,  3114,    -1,    -1,    -1,    -1,    -1,  3626,  3627,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1254,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3653,  3654,    -1,  3656,    -1,  3658,
      -1,    -1,    -1,    -1,    -1,    -1,  1275,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3677,  3172,
      -1,    -1,  3681,  3682,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1302,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1332,  1333,    -1,  1335,  3726,    -1,    -1,
      -1,    -1,    -1,  2483,    -1,  2485,    -1,  2487,    -1,    -1,
      -1,    -1,    -1,  1352,    -1,    -1,    -1,    -1,    -1,  3748,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3787,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3802,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1421,    -1,    -1,  1424,  1425,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3320,    -1,    -1,
      -1,    -1,    -1,  2583,    -1,    -1,    -1,  3330,    -1,    -1,
      -1,    -1,  3841,  3842,    -1,    -1,    -1,  3340,  3341,    -1,
    2600,    -1,  3345,  3346,    -1,    -1,  3855,  2607,  2608,    -1,
      -1,    -1,  3355,    -1,    -1,    -1,    -1,    -1,  3867,    -1,
      -1,    -1,  1481,    -1,    -1,    -1,    -1,    -1,    -1,  3372,
    3373,  3374,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3382,
    3383,    -1,    -1,    -1,  3387,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1529,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2680,    -1,    -1,  3426,    -1,  2685,    -1,  2687,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2699,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3451,    -1,
    2710,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1580,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1597,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   953,    -1,    -1,    -1,  1614,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1639,    -1,   984,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1682,    -1,  1684,    -1,    -1,  1687,  3572,
    1689,    -1,    -1,    26,    -1,    -1,    -1,    -1,    -1,  1698,
      -1,    -1,    -1,    36,    37,    -1,    -1,    -1,    -1,    -1,
      -1,    44,    45,    -1,    -1,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    -1,
    3623,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1751,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1110,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   114,    -1,    -1,    -1,    -1,  1785,  1786,    -1,    -1,
      -1,    -1,    -1,    -1,  1793,    -1,    -1,  1796,  1797,    -1,
      -1,  1800,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1808,
    1809,    -1,    -1,    -1,    -1,    -1,    -1,  1816,    -1,    -1,
    1819,  1820,  1821,  1822,    -1,    -1,    -1,    -1,    -1,    -1,
    1829,  1830,    -1,  1832,    -1,  1834,    -1,    -1,  1837,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   182,
      -1,    -1,  1851,  1852,  2994,    -1,    -1,  1856,    -1,    -1,
      -1,  1860,    -1,   196,    -1,  1864,    -1,    -1,  1867,  1868,
    1869,  1870,  1871,  1872,  1873,  1874,  1875,    -1,  1877,    -1,
      -1,    -1,   215,  1882,    -1,    -1,    -1,  1886,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1275,   267,    -1,    -1,   270,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1947,    -1,
      -1,    -1,    -1,    -1,  3094,    -1,    -1,    -1,    -1,   292,
    1302,  3101,    -1,    -1,    -1,    -1,  3106,  3107,  3108,  3109,
    3110,    -1,    -1,    -1,  3114,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1332,  1333,    -1,  1335,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,    -1,    -1,    -1,    -1,
      -1,    -1,  2031,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2051,    -1,    -1,    -1,  2055,  2056,    -1,    -1,
      -1,    -1,    -1,    -1,   397,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   409,    -1,    -1,  1421,
      -1,    -1,  1424,  1425,    -1,    -1,    -1,    -1,    -1,   422,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   444,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   452,
     453,    -1,   455,    -1,    -1,    -1,    -1,    -1,   461,   462,
     463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,
     473,   474,   475,    -1,    -1,   478,   479,   480,    -1,    -1,
    2149,   484,    -1,    -1,    -1,   488,    -1,  2156,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2175,    -1,  2177,  3319,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3328,    -1,
    3330,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3340,  3341,    -1,    -1,    -1,  3345,  3346,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3355,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2250,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2260,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2292,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2321,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2332,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2349,  2350,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2381,    -1,    -1,    -1,  2385,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3535,    -1,    -1,  2397,  2398,
    2399,  2400,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2409,    -1,    -1,    -1,    -1,  2414,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2424,  2425,    -1,  2427,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2440,    -1,  2442,    -1,    -1,    -1,  2446,    -1,    -1,
      -1,  1793,    -1,    -1,    -1,  1797,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2462,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2472,  1816,  2474,  2475,  1819,    -1,    -1,
    1822,    -1,    -1,    -1,    -1,    -1,    -1,  1829,  1830,    -1,
      -1,    -1,  1834,    -1,    -1,  1837,  2495,    -1,    -1,    -1,
      -1,    -1,  2501,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1852,  2510,  2511,  2512,  1856,    -1,    -1,    -1,  1860,    -1,
      -1,    -1,  1864,    -1,    -1,  1867,  1868,  1869,  1870,  1871,
    1872,  1873,  1874,  1875,    -1,  1877,    -1,    -1,    -1,    -1,
    1882,    -1,    -1,  2542,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2563,  2564,    -1,  2566,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2579,    -1,  2581,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1947,    -1,    -1,    -1,    -1,
      -1,  2610,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2659,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2680,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2031,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2710,    -1,    -1,  1348,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2725,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2738,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2752,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2768,
      -1,    -1,    -1,  2772,    -1,    -1,    -1,  1411,    -1,    -1,
      -1,    -1,    -1,  2782,    -1,    -1,    -1,    -1,  2787,    -1,
      -1,    -1,    -1,    -1,  2793,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2149,    -1,    -1,
      -1,    -1,  2811,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2175,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2841,    -1,    -1,  2844,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2852,    -1,    -1,    -1,    -1,    -1,  2858,
      -1,  2860,    -1,    -1,    -1,  2864,  2865,    -1,    -1,  2868,
    2869,  2870,  2871,  2872,  2873,  2874,  2875,  2876,  2877,    -1,
      -1,    -1,    -1,  2882,  2883,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2891,    -1,    -1,    -1,    -1,  2896,    -1,    -1,
      -1,    -1,    -1,  2902,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2911,    -1,    -1,  2914,    -1,  2916,  2260,    -1,
      -1,    -1,    -1,    -1,    -1,  2924,  2925,  2926,  2927,    -1,
      -1,    -1,  2931,    -1,    -1,  2934,    -1,  1571,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2944,    -1,    -1,    -1,    -1,
    2292,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2321,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    26,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    36,    37,
      -1,    -1,    -1,    -1,    42,    -1,    44,    45,  2350,    -1,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3042,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2397,    -1,  2399,  2400,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2409,    -1,    -1,
      -1,    -1,  2414,    -1,    -1,    -1,   114,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1724,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2440,    -1,
    2442,    -1,    -1,    -1,  2446,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3141,    -1,   182,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2495,    -1,    -1,    -1,  1791,   196,  2501,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2510,  2511,
    2512,    -1,    -1,    -1,    -1,    -1,    -1,   215,    -1,    -1,
      -1,  1815,    -1,    -1,    -1,    -1,  1820,    -1,    -1,    -1,
      -1,    -1,    -1,  3192,    -1,    -1,    -1,   235,  3197,    -1,
    2542,  3200,    -1,    -1,    -1,  1839,  1840,    -1,    -1,  1843,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
      -1,    -1,   270,    -1,    -1,    -1,    -1,    -1,    -1,  3238,
      -1,    -1,    -1,    -1,    -1,    -1,  1880,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   292,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3275,    -1,    -1,    -1,
      -1,    -1,    -1,  3282,  3283,    -1,    -1,    -1,    -1,    -1,
    3289,  3290,    -1,    -1,    -1,  3294,  3295,    -1,    -1,    -1,
      -1,  3300,  3301,    -1,    -1,  3304,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,    -1,  1956,    -1,    -1,    -1,    -1,    -1,    -1,  1963,
      -1,  1965,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3342,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   397,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   409,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   422,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   444,    -1,    -1,    -1,
    3409,    -1,    -1,    -1,   452,   453,    -1,   455,    -1,   457,
      -1,    -1,    -1,   461,   462,   463,   464,    -1,   466,   467,
      -1,    -1,    -1,   471,   472,   473,   474,   475,    -1,    -1,
     478,   479,   480,   481,    -1,   483,   484,   485,    -1,   487,
     488,  3450,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3465,    -1,    -1,    -1,
    3469,    -1,    -1,    -1,    -1,  3474,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3497,  2841,
      -1,    -1,  3501,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2852,    -1,    -1,    -1,    -1,    -1,  2858,    -1,  2860,    -1,
      -1,  3520,  3521,    -1,    -1,  3524,    -1,    -1,    -1,    -1,
      -1,    -1,  3531,  3532,    -1,    -1,    -1,    -1,    -1,    -1,
    2882,  2883,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3551,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2902,    -1,    -1,    -1,    -1,    -1,  3565,    -1,    -1,  2911,
      -1,    -1,  2914,    -1,  2916,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2925,    -1,    -1,    -1,    -1,    -1,  2931,
      -1,  3590,  2934,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2944,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3626,  3627,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3653,  3654,    -1,  3656,    -1,  3658,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3677,    -1,
      -1,    -1,  3681,  3682,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2353,
      -1,  2355,    -1,    -1,    -1,    -1,    -1,  3726,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2377,    -1,  2379,    -1,  2381,  2382,  3748,
      -1,  2385,    -1,    -1,    -1,  2389,    -1,    -1,    -1,    -1,
      -1,    -1,  2396,    -1,    -1,    -1,    -1,  2401,    -1,    -1,
      -1,    -1,  2406,    -1,    -1,    -1,    -1,  2411,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2420,    -1,  3787,    -1,
    2424,  2425,  2426,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3802,  2438,    -1,    -1,    -1,    -1,    -1,
      -1,  2445,    -1,  2447,  2448,  2449,  2450,  2451,  2452,  2453,
    2454,  2455,  2456,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3841,  3842,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3855,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3867,    -1,
      -1,    -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    26,    -1,  3238,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    36,    37,    -1,    -1,    -1,    -1,
      -1,    -1,    44,    45,    -1,  2549,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
    3282,  3283,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3294,    -1,    -1,    -1,    -1,    -1,  3300,  3301,
      -1,    -1,  3304,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   114,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2657,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2681,    -1,    -1,
     182,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   196,    -1,    -1,  3409,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   215,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3465,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,    -1,    -1,   270,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2784,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     292,    -1,    -1,    -1,    -1,    -1,    -1,  2801,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3524,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3532,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2840,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3565,    -1,    -1,   358,    -1,    -1,  2863,
      -1,  2865,    -1,    -1,  2868,  2869,  2870,  2871,  2872,  2873,
    2874,  2875,  2876,  2877,    -1,  2879,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   397,    -1,    -1,    -1,  2903,
      -1,    -1,    -1,  2907,    -1,    -1,    -1,   409,  2912,  2913,
      -1,    -1,    -1,    -1,    -1,  3627,    -1,    -1,    -1,    -1,
     422,    -1,  2926,  2927,  2928,    -1,  2930,    -1,    -1,  2933,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   444,    -1,  3656,    -1,    -1,    -1,    -1,    -1,
     452,   453,    -1,   455,    -1,    -1,    -1,    -1,    -1,   461,
     462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,
     472,   473,   474,   475,    -1,    -1,   478,   479,   480,   481,
       5,    -1,    -1,    -1,    -1,    -1,   488,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    26,  3006,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    36,    37,    -1,    -1,    -1,    -1,    -1,    -1,    44,
      45,    -1,    -1,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   114,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3130,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   182,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   196,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     215,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3239,    -1,    -1,    -1,  3243,
    3244,  3245,   267,    -1,  3248,   270,    -1,    -1,    -1,  3253,
    3254,  3255,  3256,  3257,  3258,  3259,  3260,  3261,  3262,  3263,
    3264,    -1,    -1,    -1,    -1,    -1,    -1,   292,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3288,  3289,  3290,  3291,    -1,  3293,
      -1,    -1,    -1,  3297,  3298,  3299,    -1,    -1,  3302,    -1,
      -1,  3305,    -1,    -1,    -1,    -1,    -1,    -1,  3312,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   397,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   409,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   422,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3411,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   444,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   452,   453,    -1,
     455,    -1,    -1,    -1,    -1,    -1,   461,   462,   463,   464,
      -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,   474,
     475,    -1,    -1,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,    -1,   488,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3492,    -1,
      -1,    -1,    -1,  3497,    -1,    -1,    -1,  3501,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3509,    -1,  3511,    -1,    -1,
      -1,  3515,  3516,  3517,    -1,    -1,  3520,  3521,  3522,  3523,
      -1,  3525,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3594,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3638,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3652,  3653,
    3654,  3655,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3665,  3666,  3667,    -1,  3669,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3684,    -1,    -1,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    -1,    17,    18,    -1,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    -1,    39,    40,    41,
    3724,    43,    44,    45,    46,    47,    -1,    -1,    -1,    51,
      52,    -1,  3736,  3737,    -1,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,
      -1,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,    -1,   105,   106,   107,    -1,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,   157,   158,   159,   160,   161,
      -1,   163,   164,   165,   166,   167,   168,   169,   170,   171,
     172,   173,   174,   175,   176,   177,   178,   179,   180,   181,
      -1,   183,   184,   185,   186,   187,   188,   189,   190,   191,
     192,   193,   194,   195,   196,   197,   198,   199,   200,   201,
     202,   203,   204,    -1,   206,   207,   208,   209,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,    -1,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,    -1,    -1,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,    -1,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,   397,   398,   399,   400,   401,
     402,   403,   404,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,   420,    -1,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,   444,   445,   446,    -1,    -1,    -1,    -1,    -1,
     452,    -1,    -1,   455,    -1,    -1,    -1,     6,     7,     8,
      -1,    10,    11,    12,    13,    14,    -1,    -1,    -1,    18,
      -1,    20,    21,    22,    23,    24,    25,    -1,    27,    28,
      -1,    -1,   484,    32,    33,    34,    35,    -1,    37,    -1,
      39,    40,    41,    -1,    43,    44,    45,    -1,    -1,    -1,
      -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,
      -1,    70,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    -1,    -1,
      -1,   100,   101,   102,   103,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,
      -1,    -1,    -1,   122,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   135,    -1,    -1,    -1,
      -1,    -1,    -1,   142,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   155,   156,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,    -1,   188,
      -1,    -1,   191,    -1,    -1,    -1,    -1,   196,    -1,    -1,
      -1,    -1,   201,    -1,   203,    -1,    -1,    -1,    -1,    -1,
     209,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   217,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     229,   230,    -1,    -1,    -1,    -1,    -1,   236,    -1,   238,
      -1,    -1,   241,   242,    -1,   244,    -1,    -1,    -1,    -1,
      -1,    -1,   251,   252,    -1,   254,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   274,   275,   276,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   285,    -1,    -1,    -1,
      -1,   290,    -1,    -1,   293,    -1,   295,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   308,
     309,   310,   311,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     319,   320,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   348,
      -1,    -1,   351,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   366,    -1,    -1,
     369,    -1,   371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   383,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   395,   396,    -1,    -1,
      -1,   400,    -1,   402,    -1,    -1,    -1,    -1,    -1,    -1,
     409,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   422,    -1,   424,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   452,    -1,    -1,   455,    -1,    -1,    -1,
      -1,     6,     7,     8,    -1,    10,    11,    12,    13,    14,
      -1,    -1,    -1,    18,    -1,    20,    21,    22,    23,    24,
      25,    -1,    27,    28,    -1,    -1,   485,    32,    33,    34,
      35,    -1,    37,    -1,    39,    40,    41,    -1,    43,    44,
      45,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    -1,    68,    -1,    70,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    -1,    -1,    -1,   100,   101,   102,   103,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     115,    -1,    -1,    -1,    -1,    -1,    -1,   122,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     135,    -1,    -1,    -1,    -1,    -1,    -1,   142,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     155,   156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   182,    -1,    -1,
      -1,    -1,    -1,   188,    -1,    -1,   191,    -1,    -1,    -1,
      -1,   196,    -1,    -1,    -1,    -1,   201,    -1,   203,    -1,
      -1,    -1,    -1,    -1,   209,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   217,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   229,   230,    -1,    -1,    -1,    -1,
      -1,   236,    -1,   238,    -1,    -1,   241,   242,    -1,   244,
      -1,    -1,    -1,    -1,    -1,    -1,   251,   252,    -1,   254,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   274,
     275,   276,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     285,    -1,    -1,    -1,    -1,   290,    -1,    -1,   293,    -1,
     295,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   308,   309,   310,   311,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   319,   320,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   348,    -1,    -1,   351,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   366,    -1,    -1,   369,    -1,   371,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   383,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     395,   396,    -1,    -1,    -1,   400,    -1,   402,    -1,    -1,
      -1,    -1,    -1,    -1,   409,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   422,    -1,   424,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   436,   437,   438,   439,   440,   441,   442,   443,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   452,    -1,    -1,
     455,    -1,     3,    -1,    -1,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    -1,    27,    28,    29,    -1,
     485,    32,    33,    34,    35,    -1,    37,    -1,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    83,    -1,    85,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    -1,    99,   100,
     101,   102,   103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   115,    -1,    -1,   118,    -1,   120,
     121,   122,    -1,    -1,   125,   126,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,   142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   152,    -1,   154,   155,   156,   157,    -1,    -1,    -1,
      -1,    -1,   163,    -1,    -1,    -1,    -1,    -1,   169,    -1,
      -1,    -1,    -1,    -1,   175,    -1,    -1,    -1,    -1,    -1,
     181,   182,    -1,    -1,    -1,    -1,   187,   188,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,    -1,    -1,    -1,    -1,
     201,    -1,   203,    -1,   205,    -1,   207,    -1,   209,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   217,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   229,   230,
      -1,    -1,   233,    -1,    -1,   236,    -1,   238,    -1,    -1,
     241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,    -1,
     251,   252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,
      -1,   262,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     271,    -1,    -1,   274,   275,   276,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   285,    -1,    -1,    -1,   289,   290,
      -1,    -1,   293,    -1,   295,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   308,   309,   310,
     311,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,   320,
      -1,   322,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     331,   332,    -1,    -1,   335,    -1,   337,    -1,    -1,    -1,
      -1,   342,    -1,    -1,    -1,    -1,   347,   348,    -1,   350,
     351,    -1,    -1,   354,    -1,    -1,    -1,    -1,    -1,   360,
      -1,    -1,    -1,    -1,   365,   366,    -1,   368,   369,    -1,
     371,    -1,    -1,    -1,   375,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   395,   396,    -1,    -1,    -1,   400,
      -1,   402,    -1,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,    -1,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,    -1,   424,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   436,   437,   438,   439,   440,
     441,   442,   443,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   452,    -1,    -1,   455,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    -1,    17,    18,   480,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    -1,    39,
      40,    41,    -1,    43,    44,    45,    46,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,
      70,    71,    -1,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    92,    93,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,    -1,   106,   107,    -1,   109,
     110,   111,   112,   113,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,    -1,    -1,   125,   126,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,   136,   137,    -1,   139,
     140,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,    -1,   159,
      -1,   161,    -1,   163,   164,   165,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,   175,   176,    -1,   178,   179,
     180,    -1,    -1,   183,    -1,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,    -1,   198,    -1,
     200,   201,    -1,   203,   204,    -1,   206,    -1,   208,   209,
      -1,   211,    -1,   213,   214,   215,   216,   217,   218,   219,
     220,    -1,   222,   223,   224,   225,   226,   227,    -1,   229,
     230,    -1,   232,   233,   234,   235,   236,    -1,   238,    -1,
      -1,   241,   242,   243,   244,   245,   246,   247,   248,   249,
      -1,   251,   252,   253,   254,    -1,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,    -1,
     300,   301,    -1,    -1,   304,   305,    -1,    -1,   308,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,    -1,   325,   326,   327,   328,   329,
     330,   331,   332,   333,    -1,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,    -1,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,    -1,
      -1,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,    -1,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,   384,    -1,   386,   387,    -1,   389,
     390,   391,   392,   393,    -1,   395,   396,    -1,    -1,   399,
     400,   401,   402,   403,   404,   405,   406,   407,   408,    -1,
     410,   411,   412,   413,   414,   415,    -1,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,    -1,    -1,
     430,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,   444,   445,   446,    -1,    -1,    -1,
      -1,    -1,   452,   453,   454,   455,   456,    -1,    -1,   459,
     460,   461,   462,   463,   464,   465,   466,    -1,    -1,    -1,
      -1,   471,   472,   473,    -1,    -1,    -1,    -1,    -1,    -1,
     480,   481,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    18,    -1,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    -1,    39,    40,    41,    -1,
      43,    44,    45,    46,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    -1,    -1,    -1,    -1,    89,    -1,    -1,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,    -1,   106,   107,    -1,   109,   110,   111,   112,
     113,   114,   115,   116,    -1,   118,   119,   120,   121,   122,
      -1,    -1,   125,   126,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,   136,   137,    -1,   139,   140,   141,   142,
     143,    -1,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,   157,    -1,   159,    -1,   161,    -1,
     163,   164,   165,    -1,   167,   168,   169,    -1,    -1,   172,
     173,   174,   175,   176,    -1,   178,   179,   180,    -1,    -1,
     183,    -1,   185,   186,   187,   188,   189,   190,   191,   192,
     193,   194,   195,   196,    -1,   198,    -1,   200,   201,    -1,
     203,   204,    -1,   206,    -1,   208,   209,    -1,   211,    -1,
     213,   214,   215,   216,   217,   218,   219,   220,    -1,   222,
     223,   224,   225,   226,   227,    -1,   229,   230,    -1,   232,
     233,   234,   235,   236,    -1,   238,    -1,    -1,   241,   242,
     243,   244,   245,   246,   247,   248,   249,    -1,   251,   252,
     253,   254,    -1,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,    -1,    -1,   300,   301,    -1,
      -1,   304,   305,    -1,    -1,   308,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,    -1,   325,   326,   327,   328,   329,   330,   331,   332,
     333,    -1,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,    -1,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,    -1,    -1,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,   371,    -1,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,   384,    -1,   386,   387,    -1,   389,   390,   391,   392,
     393,    -1,   395,   396,    -1,    -1,   399,   400,   401,   402,
     403,   404,   405,   406,   407,   408,    -1,   410,   411,   412,
     413,   414,   415,    -1,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,    -1,    -1,   430,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,   444,   445,   446,    -1,    -1,    -1,    -1,    -1,   452,
     453,   454,   455,   456,    -1,    -1,   459,   460,   461,   462,
     463,   464,   465,   466,    -1,    -1,    -1,    -1,   471,   472,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   480,   481,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    -1,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,    -1,
     106,   107,    -1,   109,   110,    -1,    -1,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,    -1,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,    -1,
     136,   137,    -1,   139,   140,   141,   142,   143,    -1,    -1,
      -1,    -1,    -1,    -1,   150,   151,   152,   153,   154,   155,
     156,   157,    -1,   159,    -1,   161,    -1,   163,   164,   165,
      -1,   167,   168,   169,    -1,    -1,   172,   173,   174,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,   185,
     186,   187,    -1,   189,   190,    -1,    -1,   193,   194,   195,
     196,    -1,   198,    -1,   200,   201,    -1,   203,   204,    -1,
     206,    -1,   208,    -1,    -1,   211,    -1,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,   225,
     226,   227,    -1,   229,   230,    -1,   232,   233,   234,   235,
     236,    -1,   238,    -1,    -1,   241,   242,   243,   244,   245,
     246,   247,   248,   249,    -1,    -1,   252,   253,   254,    -1,
     256,   257,   258,    -1,    -1,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,    -1,   278,   279,   280,   281,   282,   283,   284,    -1,
     286,    -1,   288,   289,   290,   291,    -1,    -1,   294,   295,
     296,   297,    -1,    -1,   300,    -1,    -1,    -1,   304,   305,
      -1,    -1,   308,   309,   310,    -1,   312,   313,   314,   315,
     316,    -1,   318,    -1,    -1,   321,   322,   323,    -1,   325,
     326,   327,   328,   329,   330,   331,   332,   333,    -1,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,    -1,
     346,   347,   348,   349,   350,    -1,   352,   353,   354,   355,
     356,   357,   358,    -1,    -1,   361,   362,   363,    -1,   365,
     366,   367,   368,   369,   370,   371,    -1,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,    -1,   384,    -1,
     386,   387,    -1,   389,   390,   391,   392,   393,    -1,   395,
     396,    -1,    -1,   399,    -1,   401,    -1,    -1,   404,   405,
     406,   407,   408,    -1,    -1,   411,   412,   413,   414,    -1,
      -1,   417,   418,   419,   420,    -1,   422,   423,   424,   425,
     426,   427,    -1,    -1,   430,   431,   432,   433,   434,   435,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   444,   445,
     446,    -1,    -1,    -1,    -1,    -1,   452,    -1,    -1,   455,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      -1,    27,    28,    29,    -1,   481,    32,    33,    34,    35,
      -1,    -1,    -1,    39,    40,    41,    -1,    43,    -1,    -1,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    92,    93,    -1,    95,
      -1,    97,    98,    99,    -1,   101,    -1,   103,    -1,    -1,
     106,   107,    -1,   109,   110,    -1,    -1,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,   137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,
      -1,    -1,    -1,    -1,   150,   151,   152,   153,   154,   155,
     156,   157,    -1,   159,    -1,   161,    -1,   163,   164,   165,
      -1,   167,   168,   169,    -1,    -1,   172,   173,   174,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,   185,
     186,   187,   188,   189,   190,   191,    -1,   193,   194,   195,
     196,    -1,   198,    -1,   200,    -1,    -1,    -1,   204,    -1,
     206,    -1,   208,   209,    -1,   211,    -1,   213,   214,   215,
     216,    -1,   218,   219,   220,    -1,   222,   223,   224,   225,
     226,   227,    -1,    -1,   230,    -1,   232,   233,   234,    -1,
     236,    -1,   238,    -1,    -1,    -1,    -1,   243,    -1,   245,
     246,   247,   248,   249,    -1,   251,    -1,   253,    -1,    -1,
     256,   257,   258,    -1,    -1,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,    -1,
     276,    -1,   278,   279,   280,   281,   282,   283,   284,   285,
     286,    -1,   288,   289,    -1,   291,    -1,   293,   294,   295,
     296,   297,    -1,    -1,   300,    -1,    -1,    -1,   304,   305,
      -1,    -1,   308,    -1,    -1,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,    -1,   325,
     326,   327,   328,   329,   330,   331,   332,   333,    -1,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,    -1,
     346,   347,    -1,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,    -1,    -1,   361,   362,   363,    -1,   365,
     366,   367,   368,    -1,   370,   371,    -1,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,   384,    -1,
     386,   387,    -1,   389,   390,   391,   392,   393,    -1,   395,
     396,    -1,    -1,   399,   400,   401,   402,    -1,   404,   405,
     406,   407,   408,    -1,    -1,   411,   412,   413,   414,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,    -1,   425,
     426,   427,    -1,    -1,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
     446,    -1,    -1,    -1,    -1,    -1,   452,    -1,    -1,   455,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   478,    -1,    -1,    -1,   482,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      18,    -1,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      -1,    39,    40,    41,    -1,    43,    44,    45,    46,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,
      68,    -1,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
      -1,   109,   110,   111,   112,   113,   114,   115,   116,    -1,
     118,   119,   120,   121,   122,    -1,    -1,   125,   126,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,   136,   137,
      -1,   139,   140,   141,   142,   143,    -1,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
      -1,   159,    -1,   161,    -1,   163,   164,   165,    -1,   167,
     168,   169,    -1,    -1,   172,   173,   174,   175,   176,    -1,
     178,   179,   180,    -1,    -1,   183,    -1,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,    -1,
     198,    -1,   200,   201,   202,   203,   204,    -1,   206,    -1,
     208,   209,    -1,   211,    -1,   213,   214,   215,   216,   217,
     218,   219,   220,    -1,   222,   223,   224,   225,   226,   227,
      -1,   229,   230,    -1,   232,   233,   234,   235,   236,    -1,
     238,    -1,    -1,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,    -1,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,    -1,   300,   301,    -1,    -1,   304,   305,    -1,    -1,
     308,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,    -1,   325,   326,   327,
     328,   329,   330,   331,   332,   333,    -1,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,    -1,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,    -1,    -1,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,    -1,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,   384,    -1,   386,   387,
      -1,   389,   390,   391,   392,   393,    -1,   395,   396,    -1,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,    -1,   410,   411,   412,   413,   414,   415,    -1,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
      -1,    -1,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   445,   446,    -1,
      -1,    -1,    -1,    -1,   452,   453,   454,   455,   456,    -1,
      -1,   459,   460,   461,   462,   463,   464,   465,   466,    -1,
      -1,    -1,    -1,   471,   472,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   480,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    -1,    17,    18,    -1,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    -1,    39,    40,    41,
      -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,    51,
      52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,
      -1,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,    -1,
      92,    93,    -1,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,    -1,   106,   107,    -1,   109,   110,   111,
     112,   113,   114,   115,   116,    -1,   118,   119,   120,   121,
     122,    -1,    -1,   125,   126,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,   136,   137,    -1,   139,   140,   141,
     142,   143,    -1,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,   157,    -1,   159,    -1,   161,
      -1,   163,   164,   165,    -1,   167,   168,   169,    -1,    -1,
     172,   173,   174,   175,   176,    -1,   178,   179,   180,    -1,
      -1,   183,    -1,   185,   186,   187,   188,   189,   190,   191,
     192,   193,   194,   195,   196,    -1,   198,    -1,   200,   201,
      -1,   203,   204,    -1,   206,    -1,   208,   209,    -1,   211,
      -1,   213,   214,   215,   216,   217,   218,   219,   220,    -1,
     222,   223,   224,   225,   226,   227,    -1,   229,   230,    -1,
     232,   233,   234,   235,   236,    -1,   238,    -1,    -1,   241,
     242,   243,   244,   245,   246,   247,   248,   249,    -1,   251,
     252,   253,   254,    -1,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,    -1,   304,   305,    -1,    -1,   308,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,    -1,   325,   326,   327,   328,   329,   330,   331,
     332,   333,    -1,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,    -1,   346,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,    -1,    -1,   361,
     362,   363,   364,   365,   366,   367,   368,   369,   370,   371,
      -1,   373,   374,   375,   376,   377,   378,   379,   380,   381,
     382,   383,   384,    -1,   386,   387,    -1,   389,   390,   391,
     392,   393,    -1,   395,   396,    -1,    -1,   399,   400,   401,
     402,   403,   404,   405,   406,   407,   408,    -1,   410,   411,
     412,   413,   414,   415,    -1,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,    -1,    -1,   430,   431,
     432,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,   444,   445,   446,    -1,    -1,    -1,    -1,    -1,
     452,   453,   454,   455,   456,    -1,    -1,   459,   460,   461,
     462,   463,   464,   465,   466,    -1,    -1,    -1,    -1,   471,
     472,   473,    -1,    -1,    -1,    -1,    -1,    -1,   480,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    -1,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,    -1,
     106,   107,    -1,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,   137,    -1,   139,   140,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,   159,    -1,   161,    -1,   163,   164,   165,
      -1,   167,   168,   169,    -1,    -1,   172,   173,   174,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
     196,    -1,   198,    -1,   200,   201,    -1,   203,   204,    -1,
     206,    -1,   208,   209,    -1,   211,    -1,   213,   214,   215,
     216,   217,   218,   219,   220,    -1,   222,   223,   224,   225,
     226,   227,    -1,   229,   230,    -1,   232,   233,   234,   235,
     236,    -1,   238,    -1,    -1,   241,   242,   243,   244,   245,
     246,   247,   248,   249,    -1,   251,   252,   253,   254,    -1,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,    -1,   300,   301,    -1,    -1,   304,   305,
      -1,    -1,   308,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,    -1,   325,
     326,   327,   328,   329,   330,   331,   332,   333,    -1,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,    -1,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,    -1,    -1,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,    -1,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,   384,    -1,
     386,   387,    -1,   389,   390,   391,   392,   393,    -1,   395,
     396,    -1,    -1,   399,   400,   401,   402,   403,   404,   405,
     406,   407,   408,    -1,   410,   411,   412,   413,   414,   415,
      -1,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,    -1,    -1,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
     446,    -1,    -1,    -1,    -1,    -1,   452,   453,   454,   455,
     456,    -1,    -1,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,    -1,    -1,    -1,   471,   472,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   480,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    -1,    17,    18,    -1,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    -1,    39,
      40,    41,    -1,    43,    44,    45,    46,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,
      70,    71,    -1,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    92,    93,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,    -1,   106,   107,    -1,   109,
     110,   111,   112,   113,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,    -1,    -1,   125,   126,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,   136,   137,    -1,   139,
     140,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,    -1,   159,
      -1,   161,    -1,   163,   164,   165,    -1,   167,   168,   169,
      -1,    -1,   172,   173,   174,   175,   176,    -1,   178,   179,
     180,    -1,    -1,   183,    -1,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,    -1,   198,    -1,
     200,   201,    -1,   203,   204,    -1,   206,    -1,   208,   209,
      -1,   211,    -1,   213,   214,   215,   216,   217,   218,   219,
     220,    -1,   222,   223,   224,   225,   226,   227,    -1,   229,
     230,    -1,   232,   233,   234,   235,   236,    -1,   238,    -1,
      -1,   241,   242,   243,   244,   245,   246,   247,   248,   249,
      -1,   251,   252,   253,   254,    -1,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,    -1,
     300,   301,    -1,    -1,   304,   305,    -1,    -1,   308,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,    -1,   325,   326,   327,   328,   329,
     330,   331,   332,   333,    -1,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,    -1,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,    -1,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,   384,    -1,   386,   387,    -1,   389,
     390,   391,   392,   393,    -1,   395,   396,    -1,    -1,   399,
     400,   401,   402,   403,   404,   405,   406,   407,   408,    -1,
     410,   411,   412,   413,   414,   415,    -1,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,    -1,    -1,
     430,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,   444,   445,   446,    -1,    -1,    -1,
      -1,    -1,   452,   453,   454,   455,   456,    -1,    -1,   459,
     460,   461,   462,   463,   464,   465,   466,    -1,    -1,    -1,
      -1,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     480,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    -1,    17,    18,    -1,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    -1,    39,    40,    41,    -1,    43,
      44,    45,    46,    47,    -1,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    -1,    -1,    -1,    89,    -1,    -1,    92,    93,
      -1,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,    -1,   106,   107,    -1,   109,   110,   111,   112,   113,
     114,   115,   116,    -1,   118,   119,   120,   121,   122,    -1,
      -1,   125,   126,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,   136,   137,    -1,   139,   140,   141,   142,   143,
      -1,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,   157,    -1,   159,    -1,   161,    -1,   163,
     164,   165,    -1,   167,   168,   169,    -1,    -1,   172,   173,
     174,   175,   176,    -1,   178,   179,   180,    -1,    -1,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,    -1,   198,    -1,   200,   201,    -1,   203,
     204,    -1,   206,    -1,   208,   209,    -1,   211,    -1,   213,
     214,   215,   216,   217,   218,   219,   220,    -1,   222,   223,
     224,   225,   226,   227,    -1,   229,   230,    -1,   232,   233,
     234,   235,   236,    -1,   238,    -1,    -1,   241,   242,   243,
     244,   245,   246,   247,   248,   249,    -1,   251,   252,   253,
     254,    -1,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,    -1,   300,   301,    -1,    -1,
     304,   305,    -1,    -1,   308,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,   328,   329,   330,   331,   332,   333,
      -1,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,    -1,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,    -1,    -1,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,    -1,   373,
     374,   375,   376,   377,   378,   379,   380,   381,   382,   383,
     384,    -1,   386,   387,    -1,   389,   390,   391,   392,   393,
      -1,   395,   396,    -1,    -1,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,    -1,   410,   411,   412,   413,
     414,   415,    -1,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,    -1,    -1,   430,   431,   432,   433,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
     444,   445,   446,    -1,    -1,    -1,    -1,    -1,   452,   453,
     454,   455,   456,    -1,    -1,   459,   460,   461,   462,   463,
     464,   465,   466,    -1,    -1,    -1,    -1,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   480,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      18,    -1,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      -1,    39,    40,    41,    -1,    43,    44,    45,    46,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,
      68,    -1,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,    -1,   106,   107,
      -1,   109,   110,   111,   112,   113,   114,   115,   116,    -1,
     118,   119,   120,   121,   122,    -1,    -1,   125,   126,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,   136,   137,
      -1,   139,   140,   141,   142,   143,    -1,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
      -1,   159,    -1,   161,    -1,   163,   164,   165,    -1,   167,
     168,   169,    -1,    -1,   172,   173,   174,   175,   176,    -1,
     178,   179,   180,    -1,    -1,   183,    -1,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,    -1,
     198,    -1,   200,   201,    -1,   203,   204,    -1,   206,    -1,
     208,   209,    -1,   211,    -1,   213,   214,   215,   216,   217,
     218,   219,   220,    -1,   222,   223,   224,   225,   226,   227,
      -1,   229,   230,    -1,   232,   233,   234,   235,   236,    -1,
     238,    -1,    -1,   241,   242,   243,   244,   245,   246,   247,
     248,   249,    -1,   251,   252,   253,   254,    -1,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,    -1,   300,   301,    -1,    -1,   304,   305,    -1,    -1,
     308,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,    -1,   325,   326,   327,
     328,   329,   330,   331,   332,   333,    -1,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,    -1,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,    -1,    -1,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,    -1,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,   384,    -1,   386,   387,
      -1,   389,   390,   391,   392,   393,    -1,   395,   396,    -1,
      -1,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,    -1,   410,   411,   412,   413,   414,   415,    -1,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
      -1,    -1,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   445,   446,    -1,
      -1,    -1,    -1,    -1,   452,   453,   454,   455,   456,    -1,
      -1,   459,   460,   461,   462,   463,   464,   465,   466,    -1,
      -1,    -1,    -1,   471,   472,    -1,    -1,    -1,    -1,    -1,
     478,    -1,   480,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    -1,    17,    18,    -1,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    -1,    39,    40,    41,
      -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,    51,
      52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,
      -1,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,    -1,
      92,    93,    -1,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,    -1,   106,   107,    -1,   109,   110,   111,
     112,   113,   114,   115,   116,    -1,   118,   119,   120,   121,
     122,    -1,    -1,   125,   126,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,   157,    -1,   159,    -1,   161,
      -1,   163,   164,   165,    -1,   167,   168,   169,    -1,    -1,
     172,   173,   174,   175,   176,    -1,   178,   179,   180,    -1,
      -1,   183,    -1,   185,   186,   187,   188,   189,   190,   191,
     192,   193,   194,   195,   196,    -1,   198,    -1,   200,   201,
      -1,   203,   204,    -1,   206,    -1,   208,   209,    -1,   211,
      -1,   213,   214,   215,   216,   217,   218,   219,   220,    -1,
     222,   223,   224,   225,   226,   227,    -1,   229,   230,    -1,
     232,   233,   234,   235,   236,    -1,   238,    -1,    -1,   241,
     242,   243,   244,   245,   246,   247,   248,   249,    -1,   251,
     252,   253,   254,    -1,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,    -1,   304,   305,    -1,    -1,   308,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,    -1,   325,   326,   327,   328,   329,   330,   331,
     332,   333,    -1,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,    -1,   346,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,    -1,    -1,   361,
     362,   363,   364,   365,   366,   367,   368,   369,   370,   371,
      -1,   373,   374,   375,   376,   377,   378,   379,   380,   381,
     382,   383,   384,    -1,   386,   387,    -1,   389,   390,   391,
     392,   393,    -1,   395,   396,    -1,    -1,   399,   400,   401,
     402,   403,   404,   405,   406,   407,   408,    -1,   410,   411,
     412,   413,   414,   415,    -1,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,    -1,    -1,   430,   431,
     432,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,   444,   445,   446,    -1,    -1,    -1,    -1,    -1,
     452,   453,   454,   455,   456,    -1,    -1,   459,   460,   461,
     462,   463,   464,   465,   466,    -1,    -1,    -1,    -1,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   480,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    -1,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,    -1,
     106,   107,    -1,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,   137,    -1,   139,   140,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,    -1,   159,    -1,   161,    -1,   163,   164,   165,
      -1,   167,   168,   169,    -1,    -1,   172,   173,   174,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
     196,    -1,   198,    -1,   200,   201,   202,   203,   204,    -1,
     206,    -1,   208,   209,    -1,   211,    -1,   213,   214,   215,
     216,   217,   218,   219,   220,    -1,   222,   223,   224,   225,
     226,   227,    -1,   229,   230,    -1,   232,   233,   234,   235,
     236,    -1,   238,    -1,    -1,   241,   242,   243,   244,   245,
     246,   247,   248,   249,    -1,   251,   252,   253,   254,    -1,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,    -1,   300,   301,    -1,    -1,   304,   305,
      -1,    -1,   308,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,    -1,   325,
     326,   327,   328,   329,   330,   331,   332,   333,    -1,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,    -1,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,    -1,    -1,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,    -1,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,   384,    -1,
     386,   387,    -1,   389,   390,   391,   392,   393,    -1,   395,
     396,    -1,    -1,   399,   400,   401,   402,   403,   404,   405,
     406,   407,   408,    -1,   410,   411,   412,   413,   414,   415,
      -1,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,    -1,    -1,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
     446,    -1,    -1,    -1,    -1,    -1,   452,   453,   454,   455,
     456,    -1,    -1,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,    -1,    -1,    -1,   471,   472,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   480,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    -1,    17,    18,    -1,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    -1,    39,
      40,    41,    -1,    43,    44,    45,    46,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,
      70,    71,    -1,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    92,    93,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,    -1,   106,   107,    -1,   109,
     110,   111,   112,   113,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,    -1,    -1,   125,   126,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,   136,   137,    -1,   139,
     140,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,    -1,   159,
      -1,   161,    -1,   163,   164,   165,    -1,   167,   168,   169,
      -1,    -1,   172,   173,   174,   175,   176,    -1,   178,   179,
     180,    -1,    -1,   183,    -1,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,    -1,   198,    -1,
     200,   201,    -1,   203,   204,    -1,   206,    -1,   208,   209,
      -1,   211,    -1,   213,   214,   215,   216,   217,   218,   219,
     220,    -1,   222,   223,   224,   225,   226,   227,    -1,   229,
     230,    -1,   232,   233,   234,   235,   236,    -1,   238,    -1,
      -1,   241,   242,   243,   244,   245,   246,   247,   248,   249,
      -1,   251,   252,   253,   254,    -1,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,    -1,
     300,   301,    -1,    -1,   304,   305,    -1,    -1,   308,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,    -1,   325,   326,   327,   328,   329,
     330,   331,   332,   333,    -1,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,    -1,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,    -1,
      -1,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,    -1,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,   384,    -1,   386,   387,    -1,   389,
     390,   391,   392,   393,    -1,   395,   396,    -1,    -1,   399,
     400,   401,   402,   403,   404,   405,   406,   407,   408,    -1,
     410,   411,   412,   413,   414,   415,    -1,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,    -1,    -1,
     430,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,   444,   445,   446,    -1,    -1,    -1,
      -1,    -1,   452,   453,   454,   455,   456,    -1,    -1,   459,
     460,   461,   462,   463,   464,   465,   466,    -1,    -1,    -1,
      -1,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     480,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    -1,    17,    18,    -1,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    -1,    39,    40,    41,    -1,    43,
      44,    45,    46,    47,    -1,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,    73,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    -1,    -1,    -1,    -1,    89,    -1,    -1,    92,    93,
      -1,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,    -1,   106,   107,    -1,   109,   110,   111,   112,   113,
     114,   115,   116,    -1,   118,   119,   120,   121,   122,    -1,
      -1,   125,   126,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,   136,   137,    -1,   139,   140,   141,   142,   143,
      -1,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,   157,    -1,   159,    -1,   161,    -1,   163,
     164,   165,    -1,   167,   168,   169,    -1,    -1,   172,   173,
     174,   175,   176,    -1,   178,   179,   180,    -1,    -1,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,    -1,   198,    -1,   200,   201,    -1,   203,
     204,    -1,   206,    -1,   208,   209,    -1,   211,    -1,   213,
     214,   215,   216,   217,   218,   219,   220,    -1,   222,   223,
     224,   225,   226,   227,    -1,   229,   230,    -1,   232,   233,
     234,   235,   236,    -1,   238,    -1,    -1,   241,   242,   243,
     244,   245,   246,   247,   248,   249,    -1,   251,   252,   253,
     254,    -1,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,    -1,   300,   301,    -1,    -1,
     304,   305,    -1,    -1,   308,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,   328,   329,   330,   331,   332,   333,
      -1,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,    -1,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,    -1,    -1,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,    -1,   373,
     374,   375,   376,   377,   378,   379,   380,   381,   382,   383,
     384,    -1,   386,   387,    -1,   389,   390,   391,   392,   393,
      -1,   395,   396,    -1,    -1,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,    -1,   410,   411,   412,   413,
     414,   415,    -1,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,    -1,    -1,   430,   431,   432,   433,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
     444,   445,   446,    -1,    -1,    -1,    -1,    -1,   452,   453,
     454,   455,   456,    -1,    -1,   459,   460,   461,   462,   463,
     464,   465,   466,    -1,    -1,    -1,    -1,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   480,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      18,    -1,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      -1,    39,    40,    41,    -1,    43,    44,    45,    46,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,
      68,    -1,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,    -1,   106,   107,
      -1,   109,   110,   111,   112,   113,   114,   115,   116,    -1,
     118,   119,   120,   121,   122,    -1,    -1,   125,   126,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,   136,   137,
      -1,   139,   140,   141,   142,   143,    -1,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
      -1,   159,    -1,   161,    -1,   163,   164,   165,    -1,   167,
     168,   169,    -1,    -1,   172,   173,   174,   175,   176,    -1,
     178,   179,   180,    -1,    -1,   183,    -1,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,    -1,
     198,    -1,   200,   201,    -1,   203,   204,    -1,   206,    -1,
     208,   209,    -1,   211,    -1,   213,   214,   215,   216,   217,
     218,   219,   220,    -1,   222,   223,   224,   225,   226,   227,
      -1,   229,   230,    -1,   232,   233,   234,   235,   236,    -1,
     238,    -1,    -1,   241,   242,   243,   244,   245,   246,   247,
     248,   249,    -1,   251,   252,   253,   254,    -1,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
      -1,    -1,   300,   301,    -1,    -1,   304,   305,    -1,    -1,
     308,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,    -1,   325,   326,   327,
     328,   329,   330,   331,   332,   333,    -1,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,    -1,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,    -1,    -1,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,    -1,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,   384,    -1,   386,   387,
      -1,   389,   390,   391,   392,   393,    -1,   395,   396,    -1,
      -1,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,    -1,   410,   411,   412,   413,   414,   415,    -1,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
      -1,    -1,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   445,   446,    -1,
      -1,    -1,    -1,    -1,   452,   453,   454,   455,   456,    -1,
      -1,   459,   460,   461,   462,   463,   464,   465,   466,    -1,
      -1,    -1,    -1,   471,   472,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   480,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    -1,    17,    18,    -1,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    -1,    39,    40,    41,
      -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,    51,
      52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,
      -1,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,    -1,
      92,    93,    -1,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,    -1,   106,   107,    -1,   109,   110,   111,
     112,   113,   114,   115,   116,    -1,   118,   119,   120,   121,
     122,    -1,    -1,   125,   126,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,   136,   137,    -1,   139,   140,   141,
     142,   143,    -1,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,   157,    -1,   159,    -1,   161,
      -1,   163,   164,   165,    -1,   167,   168,   169,    -1,    -1,
     172,   173,   174,   175,   176,    -1,   178,   179,   180,    -1,
      -1,   183,    -1,   185,   186,   187,   188,   189,   190,   191,
     192,   193,   194,   195,   196,    -1,   198,    -1,   200,   201,
      -1,   203,   204,    -1,   206,    -1,   208,   209,    -1,   211,
      -1,   213,   214,   215,   216,   217,   218,   219,   220,    -1,
     222,   223,   224,   225,   226,   227,    -1,   229,   230,    -1,
     232,   233,   234,   235,   236,    -1,   238,    -1,    -1,   241,
     242,   243,   244,   245,   246,   247,   248,   249,    -1,   251,
     252,   253,   254,    -1,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,    -1,   304,   305,    -1,    -1,   308,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,    -1,   325,   326,   327,   328,   329,   330,   331,
     332,   333,    -1,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,    -1,   346,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,    -1,    -1,   361,
     362,   363,   364,   365,   366,   367,   368,   369,   370,   371,
      -1,   373,   374,   375,   376,   377,   378,   379,   380,   381,
     382,   383,   384,    -1,   386,   387,    -1,   389,   390,   391,
     392,   393,    -1,   395,   396,    -1,    -1,   399,   400,   401,
     402,   403,   404,   405,   406,   407,   408,    -1,    -1,   411,
     412,   413,   414,   415,    -1,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,    -1,    -1,   430,   431,
     432,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,   444,   445,   446,    -1,    -1,    -1,    -1,    -1,
     452,   453,   454,   455,   456,    -1,    -1,   459,   460,   461,
     462,   463,   464,   465,   466,    -1,    -1,    -1,    -1,    -1,
     472,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   480,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    -1,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,    -1,   101,   102,   103,   104,    -1,
     106,   107,    -1,   109,   110,   111,   112,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,   137,    -1,   139,   140,   141,   142,   143,    -1,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,    -1,   159,    -1,   161,    -1,   163,   164,   165,
      -1,   167,   168,   169,    -1,    -1,   172,   173,   174,   175,
     176,    -1,   178,   179,   180,    -1,    -1,    -1,    -1,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
     196,    -1,   198,    -1,   200,   201,    -1,   203,   204,    -1,
     206,    -1,   208,   209,    -1,   211,    -1,   213,   214,   215,
     216,    -1,   218,   219,   220,    -1,   222,   223,   224,   225,
     226,   227,    -1,   229,   230,    -1,   232,   233,   234,   235,
     236,    -1,   238,    -1,    -1,   241,   242,   243,   244,   245,
     246,   247,   248,   249,    -1,   251,   252,   253,    -1,    -1,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,    -1,   300,   301,    -1,    -1,   304,   305,
      -1,    -1,   308,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,    -1,   325,
     326,   327,   328,   329,   330,   331,   332,   333,    -1,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,    -1,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,    -1,    -1,   361,   362,   363,   364,   365,
     366,   367,   368,    -1,   370,   371,    -1,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,   384,    -1,
     386,   387,    -1,   389,   390,   391,   392,   393,    -1,   395,
     396,    -1,    -1,   399,   400,   401,   402,   403,   404,   405,
     406,   407,   408,    -1,   410,   411,   412,   413,   414,   415,
      -1,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,    -1,    -1,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,   444,   445,
     446,    -1,    -1,    -1,    -1,    -1,   452,   453,   454,   455,
     456,    -1,    -1,   459,   460,   461,   462,   463,   464,   465,
     466,    -1,    -1,    -1,    -1,   471,   472,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   480,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    -1,    17,    18,    -1,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    -1,    39,
      40,    41,    -1,    43,    44,    45,    46,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,
      70,    71,    -1,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    92,    93,    -1,    95,    96,    97,    98,    99,
      -1,   101,   102,   103,   104,    -1,   106,   107,    -1,   109,
     110,   111,   112,   113,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,    -1,    -1,   125,   126,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,   136,   137,    -1,   139,
     140,   141,   142,   143,    -1,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,    -1,   159,
      -1,   161,    -1,   163,   164,   165,    -1,   167,   168,   169,
      -1,    -1,   172,   173,   174,   175,   176,    -1,   178,   179,
     180,    -1,    -1,    -1,    -1,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,    -1,   198,    -1,
     200,   201,    -1,   203,   204,    -1,   206,    -1,   208,   209,
      -1,   211,    -1,   213,   214,   215,   216,    -1,   218,   219,
     220,    -1,   222,   223,   224,   225,   226,   227,    -1,   229,
     230,    -1,   232,   233,   234,   235,   236,    -1,   238,    -1,
      -1,   241,   242,   243,   244,   245,   246,   247,   248,   249,
      -1,   251,   252,   253,    -1,    -1,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,    -1,    -1,
     300,   301,    -1,    -1,    -1,   305,    -1,    -1,   308,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,    -1,   325,   326,   327,   328,   329,
     330,   331,   332,   333,    -1,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,    -1,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,    -1,
      -1,   361,   362,   363,   364,   365,   366,   367,   368,    -1,
     370,   371,    -1,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,   384,    -1,   386,   387,    -1,   389,
     390,   391,   392,   393,    -1,   395,   396,    -1,    -1,   399,
     400,   401,   402,   403,   404,   405,   406,   407,   408,    -1,
      -1,   411,   412,   413,   414,   415,    -1,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,    -1,    -1,
     430,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,   444,   445,   446,    -1,    -1,    -1,
      -1,    -1,   452,   453,    -1,   455,   456,    -1,    -1,   459,
     460,   461,   462,   463,   464,   465,   466,    -1,    -1,    -1,
      -1,    -1,   472,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     480,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    -1,    17,    18,    -1,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    -1,    39,    40,    41,    -1,    43,
      44,    45,    46,    47,    -1,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,    73,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    92,    93,
      -1,    95,    96,    97,    98,    99,   100,   101,   102,   103,
      -1,    -1,   106,   107,    -1,   109,   110,    -1,   112,   113,
     114,   115,   116,    -1,   118,   119,   120,   121,   122,    -1,
      -1,   125,   126,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,   136,   137,    -1,   139,   140,   141,   142,   143,
      -1,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,   157,    -1,   159,    -1,   161,    -1,   163,
     164,   165,    -1,   167,   168,   169,    -1,    -1,   172,   173,
     174,   175,   176,    -1,   178,   179,   180,    -1,    -1,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,    -1,   193,
     194,   195,   196,    -1,   198,    -1,   200,   201,    -1,   203,
     204,    -1,   206,    -1,   208,   209,    -1,   211,    -1,   213,
     214,   215,   216,   217,   218,   219,   220,    -1,   222,   223,
     224,   225,   226,   227,    -1,   229,   230,    -1,   232,   233,
     234,    -1,   236,    -1,   238,    -1,    -1,   241,   242,   243,
     244,   245,   246,   247,   248,   249,    -1,   251,   252,   253,
     254,    -1,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,    -1,   293,
     294,   295,   296,   297,    -1,    -1,   300,   301,    -1,   303,
     304,   305,    -1,    -1,   308,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,   328,   329,   330,   331,   332,   333,
      -1,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,    -1,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,    -1,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,    -1,   373,
     374,   375,   376,   377,   378,   379,   380,   381,   382,   383,
     384,    -1,   386,   387,    -1,   389,   390,   391,   392,   393,
      -1,   395,   396,    -1,    -1,   399,   400,   401,   402,    -1,
     404,   405,   406,   407,   408,    -1,    -1,   411,   412,   413,
     414,   415,    -1,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,    -1,    -1,   430,   431,   432,   433,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
     444,   445,   446,    -1,    -1,    -1,    -1,    -1,   452,    -1,
      -1,   455,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    -1,    17,    18,   480,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    -1,    39,    40,    41,    -1,
      43,    44,    45,    46,    47,    -1,    -1,    -1,    51,    52,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    92,
      93,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,    -1,    -1,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,    -1,   118,   119,   120,   121,   122,
      -1,    -1,   125,   126,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,   136,   137,    -1,   139,   140,   141,   142,
     143,    -1,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,   157,    -1,   159,    -1,   161,    -1,
     163,   164,   165,    -1,   167,   168,   169,    -1,    -1,   172,
     173,   174,   175,   176,    -1,   178,   179,   180,    -1,    -1,
     183,    -1,   185,   186,   187,   188,   189,   190,   191,    -1,
     193,   194,   195,   196,    -1,   198,    -1,   200,   201,    -1,
     203,   204,    -1,   206,    -1,   208,   209,    -1,   211,    -1,
     213,   214,   215,   216,   217,   218,   219,   220,    -1,   222,
     223,   224,   225,   226,   227,    -1,   229,   230,    -1,   232,
     233,   234,    -1,   236,    -1,   238,    -1,    -1,   241,   242,
     243,   244,   245,   246,   247,   248,   249,    -1,   251,   252,
     253,   254,    -1,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,    -1,
     293,   294,   295,   296,   297,    -1,    -1,   300,   301,    -1,
     303,   304,   305,    -1,    -1,   308,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,    -1,   325,   326,   327,   328,   329,   330,   331,   332,
     333,    -1,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,    -1,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,    -1,    -1,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,   371,    -1,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     383,   384,    -1,   386,   387,    -1,   389,   390,   391,   392,
     393,    -1,   395,   396,    -1,    -1,   399,   400,   401,   402,
      -1,   404,   405,   406,   407,   408,    -1,    -1,   411,   412,
     413,   414,   415,    -1,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,    -1,    -1,   430,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,   444,   445,   446,    -1,    -1,    -1,    -1,    -1,   452,
      -1,    -1,   455,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    -1,    17,    18,   480,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    -1,    39,    40,    41,
      -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,    51,
      52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,
      -1,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      92,    93,    -1,    95,    96,    97,    98,    99,   100,   101,
     102,   103,    -1,    -1,   106,   107,    -1,   109,   110,    -1,
     112,   113,   114,   115,   116,    -1,   118,   119,   120,   121,
     122,    -1,    -1,   125,   126,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,   136,   137,    -1,   139,   140,   141,
     142,   143,    -1,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,   157,    -1,   159,    -1,   161,
      -1,   163,   164,   165,    -1,   167,   168,   169,    -1,    -1,
     172,   173,   174,   175,   176,    -1,   178,   179,   180,    -1,
      -1,   183,    -1,   185,   186,   187,   188,   189,   190,   191,
      -1,   193,   194,   195,   196,    -1,   198,    -1,   200,   201,
      -1,   203,   204,    -1,   206,    -1,   208,   209,    -1,   211,
      -1,   213,   214,   215,   216,   217,   218,   219,   220,    -1,
     222,   223,   224,   225,   226,   227,    -1,   229,   230,    -1,
     232,   233,   234,    -1,   236,    -1,   238,    -1,    -1,   241,
     242,   243,   244,   245,   246,   247,   248,   249,    -1,   251,
     252,   253,   254,    -1,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,    -1,   304,   305,    -1,    -1,   308,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,    -1,   325,   326,   327,   328,   329,   330,   331,
     332,   333,    -1,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,    -1,   346,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,    -1,    -1,   361,
     362,   363,   364,   365,   366,   367,   368,   369,   370,   371,
      -1,   373,   374,   375,   376,   377,   378,   379,   380,   381,
     382,   383,   384,    -1,   386,   387,    -1,   389,   390,   391,
     392,   393,    -1,   395,   396,    -1,    -1,   399,   400,   401,
     402,    -1,   404,   405,   406,   407,   408,    -1,    -1,   411,
     412,   413,   414,   415,    -1,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,    -1,    -1,   430,   431,
     432,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,   444,   445,   446,    -1,    -1,    -1,    -1,    -1,
     452,    -1,    -1,   455,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,   480,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    -1,    39,    40,
      41,    -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    92,    93,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,    -1,    -1,   106,   107,    -1,   109,   110,
      -1,    -1,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,   137,    -1,   139,   140,
     141,   142,   143,    -1,    -1,    -1,    -1,    -1,    -1,   150,
     151,   152,   153,   154,   155,   156,   157,    -1,   159,    -1,
     161,    -1,   163,   164,   165,    -1,   167,   168,   169,    -1,
      -1,   172,   173,   174,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,   185,   186,   187,   188,   189,   190,
     191,    -1,   193,   194,   195,   196,    -1,   198,    -1,   200,
     201,    -1,   203,   204,    -1,   206,    -1,   208,   209,    -1,
     211,    -1,   213,   214,   215,   216,   217,   218,   219,   220,
      -1,   222,   223,   224,   225,   226,   227,    -1,   229,   230,
      -1,   232,   233,   234,    -1,   236,    -1,   238,    -1,    -1,
     241,   242,   243,   244,   245,   246,   247,   248,   249,    -1,
     251,   252,   253,   254,    -1,   256,   257,   258,    -1,    -1,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,    -1,   293,   294,   295,   296,   297,    -1,    -1,   300,
     301,    -1,    -1,   304,   305,    -1,    -1,   308,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,    -1,   325,   326,   327,   328,   329,   330,
     331,   332,   333,    -1,   335,   336,   337,   338,   339,   340,
     341,   342,   343,   344,    -1,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,    -1,    -1,
     361,   362,   363,    -1,   365,   366,   367,   368,   369,   370,
     371,    -1,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,   384,    -1,   386,   387,    -1,   389,   390,
     391,   392,   393,    -1,   395,   396,    -1,    -1,   399,   400,
     401,   402,    -1,   404,   405,   406,   407,   408,    -1,    -1,
     411,   412,   413,   414,    -1,    -1,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,    -1,    -1,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,   446,    -1,    -1,    -1,    -1,
      -1,   452,    -1,    -1,   455,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    -1,    27,    28,    29,   480,
      -1,    32,    33,    34,    35,    -1,    -1,    -1,    39,    40,
      41,    -1,    43,    -1,    -1,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,    90,
      -1,    92,    93,    -1,    95,    -1,    97,    98,    99,    -1,
     101,    -1,   103,    -1,    -1,   106,   107,    -1,   109,   110,
      -1,    -1,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,   137,    -1,   139,   140,
     141,   142,   143,    -1,    -1,    -1,    -1,    -1,    -1,   150,
     151,   152,   153,   154,   155,   156,   157,    -1,   159,    -1,
     161,    -1,   163,   164,   165,    -1,   167,   168,   169,    -1,
      -1,   172,   173,   174,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,   185,   186,   187,   188,   189,   190,
     191,    -1,   193,   194,   195,   196,    -1,   198,    -1,   200,
      -1,    -1,   203,   204,    -1,   206,    -1,   208,   209,    -1,
     211,    -1,   213,   214,   215,   216,    -1,   218,   219,   220,
      -1,   222,   223,   224,   225,   226,   227,    -1,   229,   230,
      -1,   232,   233,   234,    -1,   236,    -1,   238,    -1,    -1,
      -1,    -1,   243,   244,   245,   246,   247,   248,   249,    -1,
     251,   252,   253,    -1,    -1,   256,   257,   258,    -1,    -1,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,    -1,   278,   279,   280,
     281,   282,   283,   284,   285,   286,    -1,   288,   289,    -1,
     291,    -1,   293,   294,   295,   296,   297,    -1,    -1,   300,
      -1,    -1,    -1,   304,   305,    -1,    -1,   308,    -1,    -1,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,    -1,   325,   326,   327,   328,   329,   330,
     331,   332,   333,    -1,   335,   336,   337,   338,   339,   340,
     341,   342,   343,   344,    -1,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,    -1,    -1,
     361,   362,   363,    -1,   365,   366,   367,   368,    -1,   370,
     371,    -1,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,   384,    -1,   386,   387,    -1,   389,   390,
     391,   392,   393,    -1,   395,   396,    -1,    -1,   399,   400,
     401,   402,    -1,   404,   405,   406,   407,   408,    -1,    -1,
     411,   412,   413,   414,    -1,    -1,   417,   418,   419,   420,
     421,   422,   423,    -1,   425,   426,   427,    -1,    -1,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,   446,    -1,    -1,    -1,    -1,
      -1,   452,    -1,    -1,   455,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    -1,    27,    28,    29,    -1,
     481,    32,    33,    34,    35,    -1,    -1,    -1,    39,    40,
      41,    -1,    43,    -1,    -1,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    92,    93,    -1,    95,    -1,    97,    98,    99,    -1,
     101,    -1,   103,    -1,    -1,   106,   107,    -1,   109,   110,
      -1,    -1,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,   137,    -1,   139,   140,
     141,    -1,   143,    -1,    -1,    -1,    -1,    -1,    -1,   150,
     151,   152,   153,   154,   155,   156,   157,    -1,   159,    -1,
     161,    -1,   163,   164,   165,    -1,   167,   168,   169,    -1,
      -1,   172,   173,   174,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,   185,   186,   187,   188,   189,   190,
     191,    -1,   193,   194,   195,   196,    -1,   198,    -1,   200,
      -1,    -1,    -1,   204,    -1,   206,    -1,   208,   209,    -1,
     211,    -1,   213,   214,   215,   216,    -1,   218,   219,   220,
      -1,   222,   223,   224,   225,   226,   227,    -1,    -1,   230,
      -1,   232,   233,   234,    -1,   236,    -1,   238,    -1,    -1,
      -1,    -1,   243,    -1,   245,   246,   247,   248,   249,    -1,
     251,    -1,   253,    -1,    -1,   256,   257,   258,    -1,    -1,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,    -1,   276,    -1,   278,   279,   280,
     281,   282,   283,   284,   285,   286,    -1,   288,   289,    -1,
     291,    -1,   293,   294,   295,   296,   297,    -1,    -1,   300,
      -1,    -1,    -1,   304,   305,    -1,    -1,   308,    -1,    -1,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,    -1,   325,   326,   327,   328,   329,   330,
     331,   332,   333,    -1,   335,   336,   337,   338,   339,   340,
     341,   342,   343,   344,    -1,   346,   347,    -1,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,    -1,    -1,
     361,   362,   363,    -1,   365,   366,   367,   368,    -1,   370,
     371,    -1,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,   384,    -1,   386,   387,    -1,   389,   390,
     391,   392,   393,    -1,   395,   396,    -1,    -1,   399,   400,
     401,   402,    -1,   404,   405,   406,   407,   408,    -1,    -1,
     411,   412,   413,   414,    -1,    -1,   417,   418,   419,   420,
     421,   422,   423,    -1,   425,   426,   427,    -1,    -1,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,   446,    -1,    -1,    -1,    -1,
      -1,   452,   453,    -1,   455,   456,    -1,    -1,    -1,    -1,
     461,   462,   463,   464,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      -1,    27,    28,    29,    -1,    -1,    32,    33,    34,    35,
      -1,    -1,    -1,    39,    40,    41,    -1,    43,    -1,    -1,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    92,    93,    -1,    95,
      -1,    97,    98,    99,    -1,   101,    -1,   103,    -1,    -1,
     106,   107,    -1,   109,   110,    -1,    -1,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,   137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,
      -1,    -1,    -1,    -1,   150,   151,   152,   153,   154,   155,
     156,   157,    -1,   159,    -1,   161,    -1,   163,   164,   165,
      -1,   167,   168,   169,    -1,    -1,   172,   173,   174,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,   185,
     186,   187,   188,   189,   190,   191,    -1,   193,   194,   195,
     196,    -1,   198,    -1,   200,    -1,    -1,    -1,   204,    -1,
     206,    -1,   208,   209,    -1,   211,    -1,   213,   214,   215,
     216,    -1,   218,   219,   220,    -1,   222,   223,   224,   225,
     226,   227,    -1,    -1,   230,    -1,   232,   233,   234,    -1,
     236,    -1,   238,    -1,    -1,    -1,    -1,   243,    -1,   245,
     246,   247,   248,   249,    -1,   251,    -1,   253,    -1,    -1,
     256,   257,   258,    -1,  