.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER INDEX" "" "2008-01-18" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER INDEX \- change the definition of an index

.SH SYNOPSIS
.sp
.nf
ALTER INDEX \fIname\fR RENAME TO \fInew_name\fR
ALTER INDEX \fIname\fR SET TABLESPACE \fItablespace_name\fR
ALTER INDEX \fIname\fR SET ( \fIstorage_parameter\fR = \fIvalue\fR [, ... ] )
ALTER INDEX \fIname\fR RESET ( \fIstorage_parameter\fR [, ... ] )
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER INDEX\fR changes the definition of an existing index.
There are several subforms:
.TP
\fBRENAME\fR
The RENAME form changes the name of the index. 
There is no effect on the stored data.
.TP
\fBSET TABLESPACE\fR
This form changes the index's tablespace to the specified tablespace and
moves the data file(s) associated with the index to the new tablespace.
See also 
CREATE TABLESPACE [\fBcreate_tablespace\fR(l)].
.TP
\fBSET ( \fIstorage_parameter\fB = \fIvalue\fB [, ... ] )\fR
This form changes one or more index-method-specific storage parameters
for the index. See
CREATE INDEX [\fBcreate_index\fR(l)]
for details on the available parameters. Note that the index contents
will not be modified immediately by this command; depending on the
parameter you might need to rebuild the index with
REINDEX [\fBreindex\fR(l)]
to get the desired effects.
.TP
\fBRESET ( \fIstorage_parameter\fB [, ... ] )\fR
This form resets one or more index-method-specific storage parameters to
their defaults. As with SET, a REINDEX
might be needed to update the index entirely.
.PP
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (possibly schema-qualified) of an existing index to
alter.
.TP
\fB\fInew_name\fB\fR
The new name for the index.
.TP
\fB\fItablespace_name\fB\fR
The tablespace to which the index will be moved.
.TP
\fB\fIstorage_parameter\fB\fR
The name of an index-method-specific storage parameter.
.TP
\fB\fIvalue\fB\fR
The new value for an index-method-specific storage parameter.
This might be a number or a word depending on the parameter.
.SH "NOTES"
.PP
These operations are also possible using
ALTER TABLE [\fBalter_table\fR(l)].
\fBALTER INDEX\fR is in fact just an alias for the forms
of \fBALTER TABLE\fR that apply to indexes.
.PP
There was formerly an \fBALTER INDEX OWNER\fR variant, but
this is now ignored (with a warning). An index cannot have an owner
different from its table's owner. Changing the table's owner
automatically changes the index as well.
.PP
Changing any part of a system catalog index is not permitted.
.SH "EXAMPLES"
.PP
To rename an existing index:
.sp
.nf
ALTER INDEX distributors RENAME TO suppliers;
.sp
.fi
.PP
To move an index to a different tablespace:
.sp
.nf
ALTER INDEX distributors SET TABLESPACE fasttablespace;
.sp
.fi
.PP
To change an index's fill factor (assuming that the index method
supports it):
.sp
.nf
ALTER INDEX distributors SET (fillfactor = 75);
REINDEX INDEX distributors;
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBALTER INDEX\fR is a PostgreSQL
extension.
.SH "SEE ALSO"
CREATE INDEX [\fBcreate_index\fR(l)], REINDEX [\fBreindex\fR(l)]
