/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONTINUE = 265,
     SQL_COUNT = 266,
     SQL_CURRENT = 267,
     SQL_DATA = 268,
     SQL_DATETIME_INTERVAL_CODE = 269,
     SQL_DATETIME_INTERVAL_PRECISION = 270,
     SQL_DESCRIBE = 271,
     SQL_DESCRIPTOR = 272,
     SQL_DISCONNECT = 273,
     SQL_ENUM = 274,
     SQL_FOUND = 275,
     SQL_FREE = 276,
     SQL_GO = 277,
     SQL_GOTO = 278,
     SQL_IDENTIFIED = 279,
     SQL_INDICATOR = 280,
     SQL_KEY_MEMBER = 281,
     SQL_LENGTH = 282,
     SQL_LONG = 283,
     SQL_NAME = 284,
     SQL_NULLABLE = 285,
     SQL_OCTET_LENGTH = 286,
     SQL_OPEN = 287,
     SQL_OUTPUT = 288,
     SQL_REFERENCE = 289,
     SQL_RETURNED_LENGTH = 290,
     SQL_RETURNED_OCTET_LENGTH = 291,
     SQL_SCALE = 292,
     SQL_SECTION = 293,
     SQL_SHORT = 294,
     SQL_SIGNED = 295,
     SQL_SQL = 296,
     SQL_SQLERROR = 297,
     SQL_SQLPRINT = 298,
     SQL_SQLWARNING = 299,
     SQL_START = 300,
     SQL_STOP = 301,
     SQL_STRUCT = 302,
     SQL_UNSIGNED = 303,
     SQL_VALUE = 304,
     SQL_VAR = 305,
     SQL_WHENEVER = 306,
     S_ADD = 307,
     S_AND = 308,
     S_ANYTHING = 309,
     S_AUTO = 310,
     S_CONST = 311,
     S_DEC = 312,
     S_DIV = 313,
     S_DOTPOINT = 314,
     S_EQUAL = 315,
     S_EXTERN = 316,
     S_INC = 317,
     S_LSHIFT = 318,
     S_MEMPOINT = 319,
     S_MEMBER = 320,
     S_MOD = 321,
     S_MUL = 322,
     S_NEQUAL = 323,
     S_OR = 324,
     S_REGISTER = 325,
     S_RSHIFT = 326,
     S_STATIC = 327,
     S_SUB = 328,
     S_VOLATILE = 329,
     S_TYPEDEF = 330,
     TYPECAST = 331,
     ABORT_P = 332,
     ABSOLUTE_P = 333,
     ACCESS = 334,
     ACTION = 335,
     ADD_P = 336,
     ADMIN = 337,
     AFTER = 338,
     AGGREGATE = 339,
     ALL = 340,
     ALSO = 341,
     ALTER = 342,
     ANALYSE = 343,
     ANALYZE = 344,
     AND = 345,
     ANY = 346,
     ARRAY = 347,
     AS = 348,
     ASC = 349,
     ASSERTION = 350,
     ASSIGNMENT = 351,
     ASYMMETRIC = 352,
     AT = 353,
     AUTHORIZATION = 354,
     BACKWARD = 355,
     BEFORE = 356,
     BEGIN_P = 357,
     BETWEEN = 358,
     BIGINT = 359,
     BINARY = 360,
     BIT = 361,
     BOOLEAN_P = 362,
     BOTH = 363,
     BY = 364,
     CACHE = 365,
     CALLED = 366,
     CASCADE = 367,
     CASCADED = 368,
     CASE = 369,
     CAST = 370,
     CHAIN = 371,
     CHAR_P = 372,
     CHARACTER = 373,
     CHARACTERISTICS = 374,
     CHECK = 375,
     CHECKPOINT = 376,
     CLASS = 377,
     CLOSE = 378,
     CLUSTER = 379,
     COALESCE = 380,
     COLLATE = 381,
     COLUMN = 382,
     COMMENT = 383,
     COMMIT = 384,
     COMMITTED = 385,
     CONCURRENTLY = 386,
     CONNECTION = 387,
     CONSTRAINT = 388,
     CONSTRAINTS = 389,
     CONVERSION_P = 390,
     CONVERT = 391,
     COPY = 392,
     CREATE = 393,
     CREATEDB = 394,
     CREATEROLE = 395,
     CREATEUSER = 396,
     CROSS = 397,
     CSV = 398,
     CURRENT_DATE = 399,
     CURRENT_ROLE = 400,
     CURRENT_TIME = 401,
     CURRENT_TIMESTAMP = 402,
     CURRENT_USER = 403,
     CURSOR = 404,
     CYCLE = 405,
     DATABASE = 406,
     DAY_P = 407,
     DEALLOCATE = 408,
     DEC = 409,
     DECIMAL_P = 410,
     DECLARE = 411,
     DEFAULT = 412,
     DEFAULTS = 413,
     DEFERRABLE = 414,
     DEFERRED = 415,
     DEFINER = 416,
     DELETE_P = 417,
     DELIMITER = 418,
     DELIMITERS = 419,
     DESC = 420,
     DISABLE_P = 421,
     DISTINCT = 422,
     DO = 423,
     DOMAIN_P = 424,
     DOUBLE_P = 425,
     DROP = 426,
     EACH = 427,
     ELSE = 428,
     ENABLE_P = 429,
     ENCODING = 430,
     ENCRYPTED = 431,
     END_P = 432,
     ESCAPE = 433,
     EXCEPT = 434,
     EXCLUSIVE = 435,
     EXCLUDING = 436,
     EXECUTE = 437,
     EXISTS = 438,
     EXPLAIN = 439,
     EXTERNAL = 440,
     EXTRACT = 441,
     FALSE_P = 442,
     FETCH = 443,
     FIRST_P = 444,
     FLOAT_P = 445,
     FOR = 446,
     FORCE = 447,
     FOREIGN = 448,
     FORWARD = 449,
     FREEZE = 450,
     FROM = 451,
     FULL = 452,
     FUNCTION = 453,
     GET = 454,
     GLOBAL = 455,
     GRANT = 456,
     GRANTED = 457,
     GREATEST = 458,
     GROUP_P = 459,
     HANDLER = 460,
     HAVING = 461,
     HEADER_P = 462,
     HOLD = 463,
     HOUR_P = 464,
     IF_P = 465,
     ILIKE = 466,
     IMMEDIATE = 467,
     IMMUTABLE = 468,
     IMPLICIT_P = 469,
     IN_P = 470,
     INCLUDING = 471,
     INCREMENT = 472,
     INDEX = 473,
     INDEXES = 474,
     INHERIT = 475,
     INHERITS = 476,
     INITIALLY = 477,
     INNER_P = 478,
     INOUT = 479,
     INPUT_P = 480,
     INSENSITIVE = 481,
     INSERT = 482,
     INSTEAD = 483,
     INT_P = 484,
     INTEGER = 485,
     INTERSECT = 486,
     INTERVAL = 487,
     INTO = 488,
     INVOKER = 489,
     IS = 490,
     ISNULL = 491,
     ISOLATION = 492,
     JOIN = 493,
     KEY = 494,
     LANCOMPILER = 495,
     LANGUAGE = 496,
     LARGE_P = 497,
     LAST_P = 498,
     LEADING = 499,
     LEAST = 500,
     LEFT = 501,
     LEVEL = 502,
     LIKE = 503,
     LIMIT = 504,
     LISTEN = 505,
     LOAD = 506,
     LOCAL = 507,
     LOCALTIME = 508,
     LOCALTIMESTAMP = 509,
     LOCATION = 510,
     LOCK_P = 511,
     LOGIN_P = 512,
     MATCH = 513,
     MAXVALUE = 514,
     MINUTE_P = 515,
     MINVALUE = 516,
     MODE = 517,
     MONTH_P = 518,
     MOVE = 519,
     NAMES = 520,
     NATIONAL = 521,
     NATURAL = 522,
     NCHAR = 523,
     NEW = 524,
     NEXT = 525,
     NO = 526,
     NOCREATEDB = 527,
     NOCREATEROLE = 528,
     NOCREATEUSER = 529,
     NOINHERIT = 530,
     NOLOGIN_P = 531,
     NONE = 532,
     NOSUPERUSER = 533,
     NOT = 534,
     NOTHING = 535,
     NOTIFY = 536,
     NOTNULL = 537,
     NOWAIT = 538,
     NULL_P = 539,
     NULLIF = 540,
     NUMERIC = 541,
     OBJECT_P = 542,
     OF = 543,
     OFF = 544,
     OFFSET = 545,
     OIDS = 546,
     OLD = 547,
     ON = 548,
     ONLY = 549,
     OPERATOR = 550,
     OPTION = 551,
     OR = 552,
     ORDER = 553,
     OUT_P = 554,
     OUTER_P = 555,
     OVERLAPS = 556,
     OVERLAY = 557,
     OWNED = 558,
     OWNER = 559,
     PARTIAL = 560,
     PASSWORD = 561,
     PLACING = 562,
     POSITION = 563,
     PRECISION = 564,
     PRESERVE = 565,
     PREPARE = 566,
     PREPARED = 567,
     PRIMARY = 568,
     PRIOR = 569,
     PRIVILEGES = 570,
     PROCEDURAL = 571,
     PROCEDURE = 572,
     QUOTE = 573,
     READ = 574,
     REAL = 575,
     REASSIGN = 576,
     RECHECK = 577,
     REFERENCES = 578,
     REINDEX = 579,
     RELATIVE_P = 580,
     RELEASE = 581,
     RENAME = 582,
     REPEATABLE = 583,
     REPLACE = 584,
     RESET = 585,
     RESTART = 586,
     RESTRICT = 587,
     RETURNING = 588,
     RETURNS = 589,
     REVOKE = 590,
     RIGHT = 591,
     ROLE = 592,
     ROLLBACK = 593,
     ROW = 594,
     ROWS = 595,
     RULE = 596,
     SAVEPOINT = 597,
     SCHEMA = 598,
     SCROLL = 599,
     SECOND_P = 600,
     SECURITY = 601,
     SELECT = 602,
     SEQUENCE = 603,
     SERIALIZABLE = 604,
     SESSION = 605,
     SESSION_USER = 606,
     SET = 607,
     SETOF = 608,
     SHARE = 609,
     SHOW = 610,
     SIMILAR = 611,
     SIMPLE = 612,
     SMALLINT = 613,
     SOME = 614,
     STABLE = 615,
     START = 616,
     STATEMENT = 617,
     STATISTICS = 618,
     STDIN = 619,
     STDOUT = 620,
     STORAGE = 621,
     STRICT_P = 622,
     SUBSTRING = 623,
     SUPERUSER_P = 624,
     SYMMETRIC = 625,
     SYSID = 626,
     SYSTEM_P = 627,
     TABLE = 628,
     TABLESPACE = 629,
     TEMP = 630,
     TEMPLATE = 631,
     TEMPORARY = 632,
     THEN = 633,
     TIME = 634,
     TIMESTAMP = 635,
     TO = 636,
     TRAILING = 637,
     TRANSACTION = 638,
     TREAT = 639,
     TRIGGER = 640,
     TRIM = 641,
     TRUE_P = 642,
     TRUNCATE = 643,
     TRUSTED = 644,
     TYPE_P = 645,
     UNCOMMITTED = 646,
     UNENCRYPTED = 647,
     UNION = 648,
     UNIQUE = 649,
     UNKNOWN = 650,
     UNLISTEN = 651,
     UNTIL = 652,
     UPDATE = 653,
     USER = 654,
     USING = 655,
     VACUUM = 656,
     VALID = 657,
     VALIDATOR = 658,
     VALUES = 659,
     VARCHAR = 660,
     VARYING = 661,
     VERBOSE = 662,
     VIEW = 663,
     VOLATILE = 664,
     WHEN = 665,
     WHERE = 666,
     WITH = 667,
     WITHOUT = 668,
     WORK = 669,
     WRITE = 670,
     YEAR_P = 671,
     ZONE = 672,
     WITH_CASCADED = 673,
     WITH_LOCAL = 674,
     WITH_CHECK = 675,
     IDENT = 676,
     SCONST = 677,
     Op = 678,
     CSTRING = 679,
     CVARIABLE = 680,
     CPP_LINE = 681,
     IP = 682,
     BCONST = 683,
     XCONST = 684,
     DOLCONST = 685,
     ICONST = 686,
     PARAM = 687,
     FCONST = 688,
     POSTFIXOP = 689,
     UMINUS = 690
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONTINUE 265
#define SQL_COUNT 266
#define SQL_CURRENT 267
#define SQL_DATA 268
#define SQL_DATETIME_INTERVAL_CODE 269
#define SQL_DATETIME_INTERVAL_PRECISION 270
#define SQL_DESCRIBE 271
#define SQL_DESCRIPTOR 272
#define SQL_DISCONNECT 273
#define SQL_ENUM 274
#define SQL_FOUND 275
#define SQL_FREE 276
#define SQL_GO 277
#define SQL_GOTO 278
#define SQL_IDENTIFIED 279
#define SQL_INDICATOR 280
#define SQL_KEY_MEMBER 281
#define SQL_LENGTH 282
#define SQL_LONG 283
#define SQL_NAME 284
#define SQL_NULLABLE 285
#define SQL_OCTET_LENGTH 286
#define SQL_OPEN 287
#define SQL_OUTPUT 288
#define SQL_REFERENCE 289
#define SQL_RETURNED_LENGTH 290
#define SQL_RETURNED_OCTET_LENGTH 291
#define SQL_SCALE 292
#define SQL_SECTION 293
#define SQL_SHORT 294
#define SQL_SIGNED 295
#define SQL_SQL 296
#define SQL_SQLERROR 297
#define SQL_SQLPRINT 298
#define SQL_SQLWARNING 299
#define SQL_START 300
#define SQL_STOP 301
#define SQL_STRUCT 302
#define SQL_UNSIGNED 303
#define SQL_VALUE 304
#define SQL_VAR 305
#define SQL_WHENEVER 306
#define S_ADD 307
#define S_AND 308
#define S_ANYTHING 309
#define S_AUTO 310
#define S_CONST 311
#define S_DEC 312
#define S_DIV 313
#define S_DOTPOINT 314
#define S_EQUAL 315
#define S_EXTERN 316
#define S_INC 317
#define S_LSHIFT 318
#define S_MEMPOINT 319
#define S_MEMBER 320
#define S_MOD 321
#define S_MUL 322
#define S_NEQUAL 323
#define S_OR 324
#define S_REGISTER 325
#define S_RSHIFT 326
#define S_STATIC 327
#define S_SUB 328
#define S_VOLATILE 329
#define S_TYPEDEF 330
#define TYPECAST 331
#define ABORT_P 332
#define ABSOLUTE_P 333
#define ACCESS 334
#define ACTION 335
#define ADD_P 336
#define ADMIN 337
#define AFTER 338
#define AGGREGATE 339
#define ALL 340
#define ALSO 341
#define ALTER 342
#define ANALYSE 343
#define ANALYZE 344
#define AND 345
#define ANY 346
#define ARRAY 347
#define AS 348
#define ASC 349
#define ASSERTION 350
#define ASSIGNMENT 351
#define ASYMMETRIC 352
#define AT 353
#define AUTHORIZATION 354
#define BACKWARD 355
#define BEFORE 356
#define BEGIN_P 357
#define BETWEEN 358
#define BIGINT 359
#define BINARY 360
#define BIT 361
#define BOOLEAN_P 362
#define BOTH 363
#define BY 364
#define CACHE 365
#define CALLED 366
#define CASCADE 367
#define CASCADED 368
#define CASE 369
#define CAST 370
#define CHAIN 371
#define CHAR_P 372
#define CHARACTER 373
#define CHARACTERISTICS 374
#define CHECK 375
#define CHECKPOINT 376
#define CLASS 377
#define CLOSE 378
#define CLUSTER 379
#define COALESCE 380
#define COLLATE 381
#define COLUMN 382
#define COMMENT 383
#define COMMIT 384
#define COMMITTED 385
#define CONCURRENTLY 386
#define CONNECTION 387
#define CONSTRAINT 388
#define CONSTRAINTS 389
#define CONVERSION_P 390
#define CONVERT 391
#define COPY 392
#define CREATE 393
#define CREATEDB 394
#define CREATEROLE 395
#define CREATEUSER 396
#define CROSS 397
#define CSV 398
#define CURRENT_DATE 399
#define CURRENT_ROLE 400
#define CURRENT_TIME 401
#define CURRENT_TIMESTAMP 402
#define CURRENT_USER 403
#define CURSOR 404
#define CYCLE 405
#define DATABASE 406
#define DAY_P 407
#define DEALLOCATE 408
#define DEC 409
#define DECIMAL_P 410
#define DECLARE 411
#define DEFAULT 412
#define DEFAULTS 413
#define DEFERRABLE 414
#define DEFERRED 415
#define DEFINER 416
#define DELETE_P 417
#define DELIMITER 418
#define DELIMITERS 419
#define DESC 420
#define DISABLE_P 421
#define DISTINCT 422
#define DO 423
#define DOMAIN_P 424
#define DOUBLE_P 425
#define DROP 426
#define EACH 427
#define ELSE 428
#define ENABLE_P 429
#define ENCODING 430
#define ENCRYPTED 431
#define END_P 432
#define ESCAPE 433
#define EXCEPT 434
#define EXCLUSIVE 435
#define EXCLUDING 436
#define EXECUTE 437
#define EXISTS 438
#define EXPLAIN 439
#define EXTERNAL 440
#define EXTRACT 441
#define FALSE_P 442
#define FETCH 443
#define FIRST_P 444
#define FLOAT_P 445
#define FOR 446
#define FORCE 447
#define FOREIGN 448
#define FORWARD 449
#define FREEZE 450
#define FROM 451
#define FULL 452
#define FUNCTION 453
#define GET 454
#define GLOBAL 455
#define GRANT 456
#define GRANTED 457
#define GREATEST 458
#define GROUP_P 459
#define HANDLER 460
#define HAVING 461
#define HEADER_P 462
#define HOLD 463
#define HOUR_P 464
#define IF_P 465
#define ILIKE 466
#define IMMEDIATE 467
#define IMMUTABLE 468
#define IMPLICIT_P 469
#define IN_P 470
#define INCLUDING 471
#define INCREMENT 472
#define INDEX 473
#define INDEXES 474
#define INHERIT 475
#define INHERITS 476
#define INITIALLY 477
#define INNER_P 478
#define INOUT 479
#define INPUT_P 480
#define INSENSITIVE 481
#define INSERT 482
#define INSTEAD 483
#define INT_P 484
#define INTEGER 485
#define INTERSECT 486
#define INTERVAL 487
#define INTO 488
#define INVOKER 489
#define IS 490
#define ISNULL 491
#define ISOLATION 492
#define JOIN 493
#define KEY 494
#define LANCOMPILER 495
#define LANGUAGE 496
#define LARGE_P 497
#define LAST_P 498
#define LEADING 499
#define LEAST 500
#define LEFT 501
#define LEVEL 502
#define LIKE 503
#define LIMIT 504
#define LISTEN 505
#define LOAD 506
#define LOCAL 507
#define LOCALTIME 508
#define LOCALTIMESTAMP 509
#define LOCATION 510
#define LOCK_P 511
#define LOGIN_P 512
#define MATCH 513
#define MAXVALUE 514
#define MINUTE_P 515
#define MINVALUE 516
#define MODE 517
#define MONTH_P 518
#define MOVE 519
#define NAMES 520
#define NATIONAL 521
#define NATURAL 522
#define NCHAR 523
#define NEW 524
#define NEXT 525
#define NO 526
#define NOCREATEDB 527
#define NOCREATEROLE 528
#define NOCREATEUSER 529
#define NOINHERIT 530
#define NOLOGIN_P 531
#define NONE 532
#define NOSUPERUSER 533
#define NOT 534
#define NOTHING 535
#define NOTIFY 536
#define NOTNULL 537
#define NOWAIT 538
#define NULL_P 539
#define NULLIF 540
#define NUMERIC 541
#define OBJECT_P 542
#define OF 543
#define OFF 544
#define OFFSET 545
#define OIDS 546
#define OLD 547
#define ON 548
#define ONLY 549
#define OPERATOR 550
#define OPTION 551
#define OR 552
#define ORDER 553
#define OUT_P 554
#define OUTER_P 555
#define OVERLAPS 556
#define OVERLAY 557
#define OWNED 558
#define OWNER 559
#define PARTIAL 560
#define PASSWORD 561
#define PLACING 562
#define POSITION 563
#define PRECISION 564
#define PRESERVE 565
#define PREPARE 566
#define PREPARED 567
#define PRIMARY 568
#define PRIOR 569
#define PRIVILEGES 570
#define PROCEDURAL 571
#define PROCEDURE 572
#define QUOTE 573
#define READ 574
#define REAL 575
#define REASSIGN 576
#define RECHECK 577
#define REFERENCES 578
#define REINDEX 579
#define RELATIVE_P 580
#define RELEASE 581
#define RENAME 582
#define REPEATABLE 583
#define REPLACE 584
#define RESET 585
#define RESTART 586
#define RESTRICT 587
#define RETURNING 588
#define RETURNS 589
#define REVOKE 590
#define RIGHT 591
#define ROLE 592
#define ROLLBACK 593
#define ROW 594
#define ROWS 595
#define RULE 596
#define SAVEPOINT 597
#define SCHEMA 598
#define SCROLL 599
#define SECOND_P 600
#define SECURITY 601
#define SELECT 602
#define SEQUENCE 603
#define SERIALIZABLE 604
#define SESSION 605
#define SESSION_USER 606
#define SET 607
#define SETOF 608
#define SHARE 609
#define SHOW 610
#define SIMILAR 611
#define SIMPLE 612
#define SMALLINT 613
#define SOME 614
#define STABLE 615
#define START 616
#define STATEMENT 617
#define STATISTICS 618
#define STDIN 619
#define STDOUT 620
#define STORAGE 621
#define STRICT_P 622
#define SUBSTRING 623
#define SUPERUSER_P 624
#define SYMMETRIC 625
#define SYSID 626
#define SYSTEM_P 627
#define TABLE 628
#define TABLESPACE 629
#define TEMP 630
#define TEMPLATE 631
#define TEMPORARY 632
#define THEN 633
#define TIME 634
#define TIMESTAMP 635
#define TO 636
#define TRAILING 637
#define TRANSACTION 638
#define TREAT 639
#define TRIGGER 640
#define TRIM 641
#define TRUE_P 642
#define TRUNCATE 643
#define TRUSTED 644
#define TYPE_P 645
#define UNCOMMITTED 646
#define UNENCRYPTED 647
#define UNION 648
#define UNIQUE 649
#define UNKNOWN 650
#define UNLISTEN 651
#define UNTIL 652
#define UPDATE 653
#define USER 654
#define USING 655
#define VACUUM 656
#define VALID 657
#define VALIDATOR 658
#define VALUES 659
#define VARCHAR 660
#define VARYING 661
#define VERBOSE 662
#define VIEW 663
#define VOLATILE 664
#define WHEN 665
#define WHERE 666
#define WITH 667
#define WITHOUT 668
#define WORK 669
#define WRITE 670
#define YEAR_P 671
#define ZONE 672
#define WITH_CASCADED 673
#define WITH_LOCAL 674
#define WITH_CHECK 675
#define IDENT 676
#define SCONST 677
#define Op 678
#define CSTRING 679
#define CVARIABLE 680
#define CPP_LINE 681
#define IP 682
#define BCONST 683
#define XCONST 684
#define DOLCONST 685
#define ICONST 686
#define PARAM 687
#define FCONST 688
#define POSTFIXOP 689
#define UMINUS 690




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, 0L, NULL, {NULL}};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, 0L, NULL, {NULL}};

/* INFORMIX workaround, no longer needed
static struct inf_compat_col
{
	char *name;
	char *indirection;
	struct inf_compat_col *next;
} *informix_col;

static struct inf_compat_val
{
	char *val;
	struct inf_compat_val *next;
} *informix_val;
*/

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error, ...)
{
	va_list ap;

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "WARNING: ");
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, "ERROR: ");
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
		result = cat2_str(result, make_str("? , "));

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * {
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming.
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;

	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);

		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1")), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}

		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));

		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);

			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "trying to access an undeclared cursor %s\n", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 314 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1269 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1281 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   62599

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  456
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  545
/* YYNRULES -- Number of rules. */
#define YYNRULES  2098
/* YYNRULES -- Number of states. */
#define YYNSTATES  3532

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   691

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   442,     2,     2,
     447,   448,   440,   438,   454,   439,   449,   441,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   455,   450,
     435,   434,   436,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   445,     2,   446,   443,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   451,     2,   452,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   437,
     444,   453
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   212,   214,   216,   218,   220,   222,   224,
     226,   228,   230,   232,   234,   236,   238,   244,   246,   247,
     250,   253,   257,   261,   263,   265,   267,   269,   271,   273,
     275,   277,   279,   281,   285,   289,   292,   295,   298,   301,
     305,   309,   315,   321,   327,   332,   338,   344,   349,   353,
     359,   363,   369,   375,   382,   384,   386,   390,   396,   403,
     408,   410,   411,   414,   415,   417,   419,   421,   423,   425,
     427,   430,   434,   438,   442,   446,   450,   453,   459,   462,
     465,   469,   473,   475,   479,   481,   483,   485,   489,   492,
     495,   498,   500,   502,   504,   506,   508,   510,   512,   514,
     516,   518,   522,   529,   531,   533,   535,   537,   538,   540,
     542,   546,   551,   557,   562,   565,   568,   572,   577,   581,
     584,   589,   591,   593,   595,   597,   599,   604,   609,   611,
     615,   619,   624,   631,   638,   645,   652,   657,   664,   667,
     672,   676,   680,   684,   688,   692,   696,   700,   704,   708,
     711,   715,   717,   719,   723,   727,   731,   734,   737,   741,
     744,   746,   748,   749,   752,   753,   756,   766,   773,   775,
     777,   779,   781,   783,   786,   787,   789,   791,   795,   799,
     801,   803,   807,   811,   815,   820,   822,   823,   826,   827,
     831,   832,   834,   835,   847,   860,   862,   864,   867,   870,
     873,   876,   877,   879,   880,   882,   886,   888,   890,   892,
     896,   899,   900,   904,   906,   908,   911,   913,   917,   922,
     927,   930,   936,   938,   941,   944,   947,   951,   954,   955,
     958,   961,   964,   967,   970,   973,   977,   979,   984,   991,
     999,  1011,  1015,  1016,  1020,  1022,  1024,  1027,  1030,  1031,
    1033,  1035,  1038,  1041,  1042,  1046,  1050,  1053,  1055,  1057,
    1060,  1063,  1068,  1069,  1072,  1075,  1078,  1079,  1083,  1088,
    1093,  1094,  1097,  1098,  1103,  1104,  1105,  1117,  1121,  1122,
    1126,  1128,  1130,  1136,  1141,  1144,  1145,  1148,  1150,  1153,
    1157,  1160,  1163,  1166,  1169,  1173,  1177,  1181,  1183,  1184,
    1190,  1200,  1202,  1203,  1205,  1208,  1211,  1212,  1215,  1216,
    1222,  1230,  1232,  1233,  1240,  1243,  1244,  1248,  1254,  1269,
    1289,  1291,  1293,  1295,  1299,  1305,  1307,  1309,  1311,  1315,
    1316,  1318,  1319,  1321,  1323,  1325,  1329,  1330,  1332,  1334,
    1335,  1338,  1340,  1343,  1345,  1348,  1351,  1353,  1356,  1359,
    1366,  1375,  1384,  1388,  1394,  1399,  1404,  1409,  1413,  1421,
    1425,  1427,  1431,  1435,  1437,  1439,  1441,  1443,  1445,  1447,
    1451,  1455,  1457,  1461,  1465,  1467,  1471,  1475,  1488,  1490,
    1494,  1499,  1507,  1512,  1515,  1517,  1518,  1520,  1521,  1529,
    1539,  1545,  1552,  1559,  1564,  1566,  1568,  1570,  1572,  1574,
    1576,  1578,  1580,  1582,  1586,  1588,  1591,  1594,  1598,  1603,
    1609,  1614,  1619,  1623,  1628,  1632,  1636,  1639,  1644,  1647,
    1649,  1651,  1653,  1655,  1658,  1661,  1663,  1665,  1667,  1670,
    1673,  1675,  1678,  1681,  1683,  1685,  1692,  1700,  1708,  1718,
    1727,  1736,  1743,  1753,  1761,  1772,  1780,  1782,  1784,  1786,
    1788,  1790,  1792,  1794,  1796,  1798,  1800,  1802,  1804,  1806,
    1808,  1816,  1824,  1835,  1838,  1840,  1842,  1844,  1848,  1850,
    1852,  1854,  1856,  1858,  1861,  1864,  1867,  1870,  1873,  1876,
    1879,  1881,  1885,  1887,  1890,  1894,  1895,  1897,  1901,  1904,
    1911,  1918,  1922,  1923,  1927,  1928,  1942,  1957,  1959,  1960,
    1963,  1964,  1966,  1970,  1973,  1976,  1981,  1983,  1986,  1987,
    1997,  2005,  2008,  2009,  2013,  2016,  2018,  2022,  2026,  2030,
    2033,  2036,  2038,  2040,  2042,  2044,  2047,  2049,  2053,  2055,
    2057,  2063,  2065,  2070,  2072,  2075,  2080,  2086,  2088,  2090,
    2092,  2094,  2098,  2102,  2105,  2108,  2111,  2114,  2116,  2119,
    2120,  2126,  2128,  2131,  2133,  2134,  2140,  2148,  2154,  2162,
    2170,  2180,  2182,  2186,  2190,  2194,  2196,  2200,  2212,  2223,
    2226,  2227,  2237,  2240,  2241,  2246,  2251,  2256,  2258,  2260,
    2262,  2263,  2271,  2278,  2285,  2293,  2300,  2307,  2317,  2324,
    2331,  2338,  2347,  2356,  2363,  2370,  2372,  2373,  2381,  2388,
    2396,  2403,  2410,  2417,  2425,  2432,  2439,  2446,  2454,  2464,
    2474,  2481,  2488,  2495,  2496,  2511,  2513,  2515,  2519,  2523,
    2525,  2527,  2529,  2531,  2533,  2535,  2537,  2538,  2540,  2542,
    2544,  2546,  2548,  2550,  2551,  2558,  2567,  2570,  2573,  2576,
    2579,  2582,  2586,  2590,  2593,  2596,  2599,  2602,  2606,  2609,
    2615,  2620,  2624,  2628,  2632,  2634,  2636,  2637,  2641,  2644,
    2647,  2649,  2653,  2656,  2658,  2659,  2668,  2679,  2682,  2686,
    2690,  2691,  2694,  2700,  2704,  2706,  2709,  2713,  2717,  2721,
    2725,  2729,  2733,  2737,  2741,  2746,  2750,  2754,  2756,  2757,
    2763,  2769,  2774,  2777,  2778,  2783,  2787,  2793,  2800,  2805,
    2812,  2819,  2825,  2833,  2835,  2836,  2847,  2852,  2855,  2857,
    2862,  2868,  2874,  2877,  2882,  2884,  2886,  2888,  2889,  2891,
    2892,  2894,  2895,  2899,  2900,  2905,  2907,  2909,  2911,  2913,
    2915,  2917,  2918,  2924,  2926,  2931,  2934,  2938,  2940,  2943,
    2946,  2947,  2954,  2957,  2958,  2964,  2968,  2969,  2972,  2975,
    2978,  2982,  2984,  2988,  2990,  2993,  2995,  2996,  3004,  3006,
    3010,  3012,  3014,  3018,  3024,  3027,  3029,  3033,  3041,  3042,
    3045,  3048,  3051,  3055,  3056,  3059,  3062,  3064,  3066,  3070,
    3074,  3076,  3079,  3084,  3089,  3091,  3093,  3102,  3104,  3109,
    3114,  3119,  3122,  3124,  3125,  3129,  3133,  3138,  3143,  3148,
    3153,  3156,  3158,  3160,  3161,  3163,  3164,  3166,  3172,  3174,
    3175,  3177,  3178,  3182,  3184,  3188,  3192,  3195,  3198,  3200,
    3205,  3210,  3213,  3216,  3221,  3223,  3224,  3226,  3228,  3230,
    3234,  3235,  3238,  3239,  3241,  3245,  3247,  3248,  3250,  3253,
    3258,  3263,  3266,  3267,  3270,  3274,  3277,  3278,  3282,  3284,
    3286,  3289,  3291,  3294,  3300,  3307,  3313,  3315,  3318,  3320,
    3325,  3329,  3334,  3340,  3345,  3351,  3356,  3362,  3365,  3370,
    3372,  3375,  3378,  3381,  3383,  3385,  3386,  3391,  3394,  3396,
    3399,  3402,  3407,  3409,  3412,  3416,  3418,  3421,  3422,  3424,
    3428,  3431,  3434,  3438,  3444,  3451,  3455,  3460,  3461,  3463,
    3467,  3471,  3475,  3479,  3483,  3487,  3489,  3491,  3493,  3495,
    3497,  3499,  3501,  3504,  3510,  3513,  3515,  3517,  3519,  3521,
    3523,  3525,  3527,  3529,  3531,  3533,  3535,  3538,  3541,  3544,
    3547,  3550,  3552,  3556,  3557,  3563,  3567,  3568,  3574,  3578,
    3579,  3581,  3583,  3585,  3587,  3593,  3596,  3598,  3600,  3602,
    3604,  3610,  3613,  3616,  3619,  3621,  3625,  3629,  3632,  3634,
    3635,  3639,  3640,  3646,  3649,  3655,  3658,  3660,  3664,  3668,
    3669,  3671,  3673,  3675,  3677,  3679,  3681,  3685,  3689,  3693,
    3697,  3701,  3705,  3709,  3710,  3712,  3716,  3722,  3725,  3728,
    3732,  3736,  3740,  3744,  3748,  3752,  3756,  3760,  3764,  3768,
    3771,  3774,  3778,  3782,  3785,  3789,  3795,  3800,  3807,  3811,
    3817,  3822,  3829,  3834,  3841,  3847,  3855,  3858,  3862,  3865,
    3870,  3874,  3879,  3883,  3888,  3892,  3897,  3903,  3910,  3917,
    3925,  3932,  3940,  3947,  3955,  3959,  3964,  3969,  3976,  3979,
    3981,  3985,  3988,  3992,  3996,  4000,  4004,  4008,  4012,  4016,
    4020,  4024,  4028,  4031,  4034,  4040,  4047,  4054,  4062,  4064,
    4066,  4069,  4074,  4076,  4078,  4080,  4083,  4086,  4089,  4091,
    4095,  4100,  4106,  4112,  4117,  4119,  4121,  4126,  4128,  4133,
    4135,  4140,  4142,  4147,  4149,  4151,  4153,  4155,  4162,  4167,
    4172,  4177,  4182,  4189,  4195,  4201,  4207,  4212,  4219,  4224,
    4231,  4236,  4241,  4246,  4251,  4255,  4261,  4263,  4265,  4267,
    4269,  4271,  4273,  4275,  4277,  4279,  4281,  4283,  4285,  4287,
    4289,  4291,  4296,  4298,  4303,  4305,  4310,  4312,  4315,  4317,
    4320,  4322,  4326,  4330,  4331,  4335,  4337,  4339,  4343,  4347,
    4351,  4353,  4355,  4357,  4359,  4361,  4363,  4365,  4367,  4372,
    4376,  4379,  4383,  4384,  4388,  4392,  4395,  4398,  4400,  4401,
    4404,  4407,  4411,  4414,  4416,  4418,  4422,  4428,  4431,  4433,
    4438,  4441,  4442,  4444,  4445,  4447,  4450,  4453,  4456,  4460,
    4466,  4468,  4471,  4472,  4475,  4477,  4478,  4480,  4482,  4484,
    4488,  4492,  4496,  4498,  4502,  4504,  4506,  4508,  4510,  4512,
    4516,  4518,  4521,  4523,  4527,  4529,  4531,  4533,  4535,  4537,
    4539,  4541,  4544,  4546,  4549,  4553,  4560,  4562,  4564,  4566,
    4568,  4570,  4572,  4574,  4576,  4578,  4580,  4582,  4584,  4586,
    4589,  4591,  4593,  4595,  4597,  4600,  4603,  4605,  4607,  4609,
    4611,  4613,  4615,  4617,  4619,  4622,  4625,  4627,  4629,  4631,
    4633,  4635,  4637,  4639,  4641,  4643,  4645,  4647,  4649,  4655,
    4659,  4662,  4665,  4669,  4677,  4679,  4681,  4683,  4684,  4687,
    4690,  4692,  4693,  4695,  4699,  4701,  4704,  4705,  4708,  4709,
    4712,  4713,  4715,  4719,  4724,  4728,  4730,  4732,  4734,  4737,
    4738,  4746,  4750,  4753,  4755,  4757,  4759,  4760,  4766,  4767,
    4772,  4775,  4777,  4780,  4781,  4783,  4787,  4791,  4795,  4799,
    4800,  4805,  4811,  4817,  4818,  4820,  4822,  4824,  4826,  4829,
    4832,  4835,  4837,  4840,  4841,  4849,  4850,  4856,  4857,  4862,
    4865,  4868,  4869,  4872,  4874,  4876,  4878,  4880,  4882,  4884,
    4886,  4888,  4890,  4892,  4894,  4900,  4903,  4905,  4909,  4912,
    4915,  4919,  4920,  4926,  4928,  4929,  4935,  4938,  4941,  4943,
    4945,  4947,  4950,  4953,  4957,  4959,  4962,  4965,  4969,  4973,
    4978,  4981,  4983,  4986,  4988,  4990,  4993,  4996,  5000,  5002,
    5004,  5006,  5008,  5009,  5011,  5015,  5021,  5022,  5025,  5026,
    5028,  5031,  5035,  5038,  5040,  5042,  5044,  5045,  5047,  5049,
    5051,  5055,  5056,  5061,  5064,  5067,  5069,  5071,  5072,  5074,
    5076,  5078,  5080,  5083,  5087,  5088,  5090,  5093,  5095,  5100,
    5105,  5106,  5108,  5111,  5113,  5115,  5119,  5121,  5123,  5128,
    5133,  5138,  5143,  5145,  5146,  5150,  5154,  5159,  5161,  5165,
    5169,  5174,  5176,  5180,  5184,  5186,  5193,  5195,  5199,  5203,
    5210,  5212,  5216,  5220,  5222,  5224,  5226,  5228,  5230,  5232,
    5234,  5236,  5238,  5240,  5242,  5244,  5246,  5248,  5250,  5255,
    5260,  5262,  5264,  5269,  5274,  5278,  5279,  5287,  5289,  5290,
    5291,  5299,  5303,  5308,  5312,  5314,  5316,  5318,  5321,  5325,
    5331,  5334,  5340,  5343,  5345,  5347,  5349,  5351,  5353,  5355,
    5357,  5359,  5361,  5363,  5365,  5367,  5369,  5371,  5373,  5375,
    5377,  5379,  5381,  5383,  5385,  5387,  5389,  5391,  5393,  5395,
    5397,  5399,  5401,  5403,  5405,  5407,  5409,  5411,  5413,  5415,
    5417,  5419,  5421,  5423,  5425,  5427,  5429,  5431,  5433,  5435,
    5437,  5439,  5441,  5443,  5445,  5447,  5449,  5451,  5453,  5455,
    5457,  5459,  5461,  5463,  5465,  5467,  5469,  5471,  5473,  5475,
    5477,  5479,  5481,  5483,  5485,  5487,  5489,  5491,  5493,  5495,
    5497,  5499,  5501,  5503,  5505,  5507,  5509,  5511,  5513,  5515,
    5517,  5519,  5521,  5523,  5525,  5527,  5529,  5531,  5533,  5535,
    5537,  5539,  5541,  5543,  5545,  5547,  5549,  5551,  5553,  5555,
    5557,  5559,  5561,  5563,  5565,  5567,  5569,  5571,  5573,  5575,
    5577,  5579,  5581,  5583,  5585,  5587,  5589,  5591,  5593,  5595,
    5597,  5599,  5601,  5603,  5605,  5607,  5609,  5611,  5613,  5615,
    5617,  5619,  5621,  5623,  5625,  5627,  5629,  5631,  5633,  5635,
    5637,  5639,  5641,  5643,  5645,  5647,  5649,  5651,  5653,  5655,
    5657,  5659,  5661,  5663,  5665,  5667,  5669,  5671,  5673,  5675,
    5677,  5679,  5681,  5683,  5685,  5687,  5689,  5691,  5693,  5695,
    5697,  5699,  5701,  5703,  5705,  5707,  5709,  5711,  5713,  5715,
    5717,  5719,  5721,  5723,  5725,  5727,  5729,  5731,  5733,  5735,
    5737,  5739,  5741,  5743,  5745,  5747,  5749,  5751,  5753,  5755,
    5757,  5759,  5761,  5763,  5765,  5767,  5769,  5771,  5773,  5775,
    5777,  5779,  5781,  5783,  5785,  5787,  5789,  5791,  5793,  5795,
    5797,  5799,  5801,  5803,  5805,  5807,  5809,  5811,  5813,  5815,
    5817,  5819,  5821,  5823,  5825,  5827,  5829,  5831,  5833,  5835,
    5837,  5839,  5841,  5843,  5845,  5847,  5849,  5851,  5853,  5855,
    5857,  5859,  5861,  5863,  5865,  5867,  5869,  5871,  5873,  5875,
    5877,  5879,  5881,  5883,  5885,  5887,  5889,  5891,  5893,  5895,
    5897,  5899,  5901,  5903,  5905,  5907,  5909,  5911,  5913,  5915,
    5917,  5919,  5921,  5923,  5925,  5927,  5929,  5931,  5933,  5935,
    5937,  5939,  5941,  5943,  5945,  5947,  5949,  5951,  5953,  5955,
    5957,  5959,  5961,  5963,  5965,  5967,  5969,  5971,  5973,  5975,
    5977,  5979,  5981,  5983,  5985,  5987,  5989,  5991,  5993,  5995,
    5997,  5999,  6001,  6003,  6005,  6007,  6009,  6011,  6013,  6015,
    6017,  6019,  6021,  6023,  6025,  6027,  6029,  6031,  6033,  6035,
    6037,  6039,  6041,  6043,  6045,  6047,  6049,  6051,  6053,  6055,
    6057,  6059,  6061,  6063,  6065,  6067,  6069,  6071,  6073,  6075,
    6077,  6079,  6081,  6083,  6085,  6087,  6089,  6091,  6093,  6095,
    6097,  6099,  6101,  6103,  6105,  6107,  6109,  6111,  6113,  6115,
    6117,  6119,  6121,  6123,  6125,  6127,  6129,  6131,  6133,  6135,
    6137,  6139,  6141,  6143,  6145,  6147,  6149,  6151,  6153,  6155,
    6157,  6159,  6161,  6163,  6165,  6167,  6169,  6171,  6173,  6175,
    6177,  6179,  6181,  6185,  6187,  6188,  6190,  6193,  6195,  6198,
    6200,  6202,  6205,  6208,  6210,  6212,  6214,  6216,  6218,  6220,
    6223,  6227,  6229,  6232,  6234,  6238,  6240,  6244,  6246,  6248,
    6250,  6252,  6254,  6256,  6258,  6260,  6262,  6264,  6266,  6268,
    6270,  6272,  6274,  6276,  6278,  6280,  6282,  6284,  6286,  6288,
    6290,  6292,  6294,  6296,  6298,  6300,  6302,  6304,  6306,  6308,
    6310,  6312,  6314,  6316,  6318,  6320,  6322,  6324,  6326,  6328,
    6330,  6332,  6334,  6336,  6338,  6340,  6342,  6344,  6346,  6348,
    6350,  6352,  6354,  6356,  6358,  6360,  6362,  6364,  6366
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     457,     0,    -1,   458,    -1,    -1,   458,   459,    -1,   986,
     460,   461,   450,    -1,   986,   461,   450,    -1,   986,   876,
      -1,   884,    -1,   999,    -1,   426,    -1,   451,    -1,   452,
      -1,    98,   920,    -1,   686,    -1,   687,    -1,   692,    -1,
     643,    -1,   472,    -1,   660,    -1,   661,    -1,   548,    -1,
     496,    -1,   467,    -1,   466,    -1,   468,    -1,   697,    -1,
     495,    -1,   504,    -1,   695,    -1,   605,    -1,   492,    -1,
     505,    -1,   542,    -1,   576,    -1,   651,    -1,   694,    -1,
     691,    -1,   629,    -1,   471,    -1,   552,    -1,   588,    -1,
     462,    -1,   475,    -1,   547,    -1,   514,    -1,   559,    -1,
     562,    -1,   465,    -1,   682,    -1,   724,    -1,   578,    -1,
     711,    -1,   577,    -1,   653,    -1,   474,    -1,   593,    -1,
     594,    -1,   557,    -1,   469,    -1,   670,    -1,   596,    -1,
     561,    -1,   575,    -1,   470,    -1,   690,    -1,   703,    -1,
     602,    -1,   608,    -1,   619,    -1,   623,    -1,   706,    -1,
     672,    -1,   681,    -1,   713,    -1,   671,    -1,   595,    -1,
     655,    -1,   647,    -1,   648,    -1,   646,    -1,   658,    -1,
     609,    -1,   620,    -1,   662,    -1,   727,    -1,   674,    -1,
     601,    -1,   673,    -1,   717,    -1,   696,    -1,   479,    -1,
     490,    -1,   491,    -1,   679,    -1,   939,    -1,   860,    -1,
     874,    -1,   875,    -1,   940,    -1,   917,    -1,   937,    -1,
     918,    -1,   921,    -1,   926,    -1,   948,    -1,   941,    -1,
     927,    -1,   936,    -1,   955,    -1,   957,    -1,   951,    -1,
     944,    -1,   958,    -1,   961,    -1,   963,    -1,   138,   337,
     858,   463,   464,    -1,   412,    -1,    -1,   306,   848,    -1,
     306,   284,    -1,   176,   306,   848,    -1,   392,   306,   848,
      -1,   369,    -1,   278,    -1,   220,    -1,   275,    -1,   139,
      -1,   272,    -1,   140,    -1,   273,    -1,   257,    -1,   276,
      -1,   132,   249,   850,    -1,   402,   397,   848,    -1,   399,
     835,    -1,   371,   849,    -1,    82,   835,    -1,   337,   835,
      -1,   215,   337,   835,    -1,   215,   204,   835,    -1,   138,
     399,   858,   463,   464,    -1,    87,   337,   858,   463,   464,
      -1,    87,   337,   858,   352,   480,    -1,    87,   337,   858,
     491,    -1,    87,   399,   858,   463,   464,    -1,    87,   399,
     858,   352,   480,    -1,    87,   399,   858,   491,    -1,   171,
     337,   835,    -1,   171,   337,   210,   183,   835,    -1,   171,
     399,   835,    -1,   171,   399,   210,   183,   835,    -1,   138,
     204,   858,   463,   464,    -1,    87,   204,   858,   473,   399,
     835,    -1,    81,    -1,   171,    -1,   171,   204,   835,    -1,
     171,   204,   210,   183,   835,    -1,   138,   343,   476,    99,
     858,   477,    -1,   138,   343,   971,   477,    -1,   971,    -1,
      -1,   477,   478,    -1,    -1,   514,    -1,   623,    -1,   547,
      -1,   562,    -1,   608,    -1,   679,    -1,   352,   480,    -1,
     352,   252,   480,    -1,   352,   350,   480,    -1,   481,   381,
     482,    -1,   481,   453,   482,    -1,   379,   417,   487,    -1,
     383,   677,    -1,   350,   119,    93,   383,   677,    -1,   265,
     488,    -1,   337,   489,    -1,   350,    99,   489,    -1,   350,
      99,   157,    -1,   970,    -1,   481,   449,   971,    -1,   483,
      -1,   157,    -1,   485,    -1,   483,   454,   485,    -1,   319,
     391,    -1,   319,   130,    -1,   328,   319,    -1,   349,    -1,
     486,    -1,   856,    -1,   971,    -1,   387,    -1,   187,    -1,
     293,    -1,   289,    -1,   856,    -1,   993,    -1,   789,   853,
     791,    -1,   789,   447,   849,   448,   853,   791,    -1,   157,
      -1,   252,    -1,   853,    -1,   157,    -1,    -1,   971,    -1,
     853,    -1,   355,   481,   933,    -1,   355,   379,   417,   933,
      -1,   355,   383,   237,   247,   933,    -1,   355,   350,    99,
     933,    -1,   355,    85,    -1,   330,   481,    -1,   330,   379,
     417,    -1,   330,   383,   237,   247,    -1,   330,   350,    99,
      -1,   330,    85,    -1,   352,   134,   493,   494,    -1,    85,
      -1,   833,    -1,   160,    -1,   212,    -1,   121,    -1,    87,
     373,   761,   497,    -1,    87,   218,   761,   499,    -1,   498,
      -1,   497,   454,   498,    -1,    81,   659,   519,    -1,    87,
     659,   971,   501,    -1,    87,   659,   971,   171,   279,   284,
      -1,    87,   659,   971,   352,   279,   284,    -1,    87,   659,
     971,   352,   363,   849,    -1,    87,   659,   971,   352,   366,
     971,    -1,   171,   659,   971,   502,    -1,    87,   659,   971,
     390,   767,   503,    -1,    81,   527,    -1,   171,   133,   836,
     502,    -1,   352,   413,   291,    -1,   124,   293,   836,    -1,
     352,   413,   124,    -1,   174,   385,   836,    -1,   174,   385,
      85,    -1,   174,   385,   399,    -1,   166,   385,   836,    -1,
     166,   385,    85,    -1,   166,   385,   399,    -1,   220,   834,
      -1,   271,   220,   834,    -1,   500,    -1,   500,    -1,   499,
     454,   500,    -1,   304,   381,   858,    -1,   352,   374,   836,
      -1,   352,   579,    -1,   330,   579,    -1,   352,   157,   792,
      -1,   171,   157,    -1,   112,    -1,   332,    -1,    -1,   400,
     792,    -1,    -1,   123,   836,    -1,   137,   510,   834,   511,
     506,   507,   512,   463,   508,    -1,   137,   728,   381,   507,
     463,   508,    -1,   381,    -1,   196,    -1,   853,    -1,   364,
      -1,   365,    -1,   508,   509,    -1,    -1,   105,    -1,   291,
      -1,   163,   693,   853,    -1,   284,   693,   853,    -1,   143,
      -1,   207,    -1,   318,   693,   848,    -1,   178,   693,   848,
      -1,   192,   318,   530,    -1,   192,   279,   284,   530,    -1,
     105,    -1,    -1,   412,   291,    -1,    -1,   513,   164,   853,
      -1,    -1,   400,    -1,    -1,   138,   515,   373,   834,   447,
     516,   448,   537,   538,   539,   540,    -1,   138,   515,   373,
     834,   288,   834,   447,   516,   448,   538,   539,   540,    -1,
     377,    -1,   375,    -1,   252,   377,    -1,   252,   375,    -1,
     200,   377,    -1,   200,   375,    -1,    -1,   517,    -1,    -1,
     518,    -1,   517,   454,   518,    -1,   519,    -1,   524,    -1,
     527,    -1,   971,   767,   520,    -1,   520,   521,    -1,    -1,
     133,   836,   522,    -1,   522,    -1,   523,    -1,   279,   284,
      -1,   284,    -1,   394,   642,   541,    -1,   313,   239,   642,
     541,    -1,   120,   447,   792,   448,    -1,   157,   793,    -1,
     323,   834,   529,   532,   533,    -1,   159,    -1,   279,   159,
      -1,   222,   160,    -1,   222,   212,    -1,   248,   834,   525,
      -1,   525,   526,    -1,    -1,   216,   158,    -1,   181,   158,
      -1,   216,   134,    -1,   181,   134,    -1,   216,   219,    -1,
     181,   219,    -1,   133,   836,   528,    -1,   528,    -1,   120,
     447,   792,   448,    -1,   394,   447,   530,   448,   642,   541,
      -1,   313,   239,   447,   530,   448,   642,   541,    -1,   193,
     239,   447,   530,   448,   323,   834,   529,   532,   533,   572,
      -1,   447,   530,   448,    -1,    -1,   530,   454,   531,    -1,
     531,    -1,   971,    -1,   258,   197,    -1,   258,   305,    -1,
      -1,   534,    -1,   535,    -1,   534,   535,    -1,   535,   534,
      -1,    -1,   293,   162,   536,    -1,   293,   398,   536,    -1,
     271,    80,    -1,   332,    -1,   112,    -1,   352,   157,    -1,
     352,   284,    -1,   221,   447,   833,   448,    -1,    -1,   412,
     579,    -1,   412,   291,    -1,   413,   291,    -1,    -1,   293,
     129,   171,    -1,   293,   129,   162,   340,    -1,   293,   129,
     310,   340,    -1,    -1,   374,   836,    -1,    -1,   400,   218,
     374,   836,    -1,    -1,    -1,   138,   515,   373,   834,   544,
     538,   539,   540,    93,   543,   727,    -1,   447,   545,   448,
      -1,    -1,   545,   454,   546,    -1,   546,    -1,   971,    -1,
     138,   515,   348,   834,   549,    -1,    87,   348,   834,   549,
      -1,   549,   550,    -1,    -1,   110,   855,    -1,   150,    -1,
     271,   150,    -1,   217,   551,   855,    -1,   259,   855,    -1,
     261,   855,    -1,   271,   259,    -1,   271,   261,    -1,   303,
     109,   599,    -1,   361,   463,   855,    -1,   331,   463,   855,
      -1,   109,    -1,    -1,   138,   553,   558,   241,   489,    -1,
     138,   553,   558,   241,   489,   205,   554,   555,   556,    -1,
     389,    -1,    -1,   836,    -1,   836,   600,    -1,   403,   554,
      -1,    -1,   240,   853,    -1,    -1,   171,   558,   241,   853,
     502,    -1,   171,   558,   241,   210,   183,   853,   502,    -1,
     316,    -1,    -1,   138,   374,   836,   560,   255,   848,    -1,
     304,   836,    -1,    -1,   171,   374,   836,    -1,   171,   374,
     210,   183,   836,    -1,   138,   385,   836,   563,   564,   293,
     834,   566,   182,   317,   836,   447,   569,   448,    -1,   138,
     133,   385,   836,    83,   564,   293,   834,   571,   572,   191,
     172,   339,   182,   317,   842,   447,   569,   448,    -1,   101,
      -1,    83,    -1,   565,    -1,   565,   297,   565,    -1,   565,
     297,   565,   297,   565,    -1,   227,    -1,   162,    -1,   398,
      -1,   191,   567,   568,    -1,    -1,   172,    -1,    -1,   339,
      -1,   362,    -1,   570,    -1,   569,   454,   570,    -1,    -1,
     857,    -1,   971,    -1,    -1,   196,   834,    -1,   573,    -1,
     573,   574,    -1,   574,    -1,   574,   573,    -1,   279,   159,
      -1,   159,    -1,   222,   212,    -1,   222,   160,    -1,   171,
     385,   836,   293,   834,   502,    -1,   171,   385,   210,   183,
     836,   293,   834,   502,    -1,   138,    95,   836,   120,   447,
     792,   448,   572,    -1,   171,    95,   836,    -1,   138,    84,
     842,   583,   579,    -1,   138,    84,   842,   585,    -1,   138,
     295,   798,   579,    -1,   138,   390,   599,   579,    -1,   138,
     390,   599,    -1,   138,   390,   599,    93,   447,   765,   448,
      -1,   447,   580,   448,    -1,   581,    -1,   580,   454,   581,
      -1,   974,   434,   582,    -1,   974,    -1,   638,    -1,   983,
      -1,   984,    -1,   801,    -1,   856,    -1,   447,   584,   448,
      -1,   447,   440,   448,    -1,   767,    -1,   584,   454,   767,
      -1,   447,   586,   448,    -1,   587,    -1,   586,   454,   587,
      -1,   993,   434,   582,    -1,   138,   295,   122,   599,   591,
     191,   390,   767,   400,   838,    93,   589,    -1,   590,    -1,
     589,   454,   590,    -1,   295,   849,   650,   592,    -1,   295,
     849,   650,   447,   649,   448,   592,    -1,   198,   849,   842,
     631,    -1,   366,   767,    -1,   157,    -1,    -1,   322,    -1,
      -1,   171,   295,   122,   599,   400,   838,   502,    -1,   171,
     295,   122,   210,   183,   599,   400,   838,   502,    -1,   171,
     303,   109,   835,   502,    -1,   321,   303,   109,   835,   381,
     836,    -1,   171,   597,   210,   183,   598,   502,    -1,   171,
     597,   598,   502,    -1,   373,    -1,   348,    -1,   408,    -1,
     218,    -1,   390,    -1,   169,    -1,   135,    -1,   343,    -1,
     599,    -1,   598,   454,   599,    -1,   971,    -1,   971,   600,
      -1,   449,   839,    -1,   600,   449,   839,    -1,   388,   734,
     833,   502,    -1,   188,   603,   604,   836,   933,    -1,   188,
     603,   836,   933,    -1,   188,   604,   836,   933,    -1,   188,
     836,   933,    -1,   188,   603,   604,   836,    -1,   188,   603,
     836,    -1,   188,   604,   836,    -1,   188,   836,    -1,   264,
     603,   604,   836,    -1,   264,   836,    -1,   270,    -1,   314,
      -1,   189,    -1,   243,    -1,    78,   850,    -1,   325,   850,
      -1,   850,    -1,    85,    -1,   194,    -1,   194,   850,    -1,
     194,    85,    -1,   100,    -1,   100,   850,    -1,   100,    85,
      -1,   215,    -1,   196,    -1,   128,   293,   606,   836,   235,
     607,    -1,   128,   293,    84,   842,   583,   235,   607,    -1,
     128,   293,   198,   842,   631,   235,   607,    -1,   128,   293,
     295,   798,   447,   649,   448,   235,   607,    -1,   128,   293,
     385,   836,   293,   599,   235,   607,    -1,   128,   293,   341,
     836,   293,   599,   235,   607,    -1,   128,   293,   341,   836,
     235,   607,    -1,   128,   293,   295,   122,   599,   400,   838,
     235,   607,    -1,   128,   293,   242,   287,   855,   235,   607,
      -1,   128,   293,   115,   447,   767,    93,   767,   448,   235,
     607,    -1,   128,   293,   558,   241,   599,   235,   607,    -1,
     127,    -1,   151,    -1,   343,    -1,   218,    -1,   348,    -1,
     373,    -1,   169,    -1,   390,    -1,   408,    -1,   135,    -1,
     374,    -1,   337,    -1,   853,    -1,   284,    -1,   201,   610,
     293,   613,   381,   614,   616,    -1,   335,   610,   293,   613,
     196,   614,   502,    -1,   335,   201,   296,   191,   610,   293,
     613,   196,   614,   502,    -1,    85,   315,    -1,    85,    -1,
     611,    -1,   612,    -1,   611,   454,   612,    -1,   347,    -1,
     323,    -1,   138,    -1,   971,    -1,   833,    -1,   373,   833,
      -1,   348,   833,    -1,   198,   617,    -1,   151,   835,    -1,
     241,   835,    -1,   343,   835,    -1,   374,   835,    -1,   615,
      -1,   614,   454,   615,    -1,   858,    -1,   204,   858,    -1,
     412,   201,   296,    -1,    -1,   618,    -1,   617,   454,   618,
      -1,   842,   631,    -1,   201,   611,   381,   835,   621,   622,
      -1,   335,   611,   196,   835,   622,   502,    -1,   412,    82,
     296,    -1,    -1,   202,   109,   858,    -1,    -1,   138,   624,
     218,   840,   293,   834,   625,   447,   626,   448,   642,   540,
     764,    -1,   138,   624,   218,   131,   840,   293,   834,   625,
     447,   626,   448,   642,   540,   764,    -1,   394,    -1,    -1,
     400,   838,    -1,    -1,   627,    -1,   626,   454,   627,    -1,
     971,   628,    -1,   795,   628,    -1,   447,   792,   448,   628,
      -1,   599,    -1,   400,   599,    -1,    -1,   138,   630,   198,
     842,   631,   334,   637,   639,   642,    -1,   138,   630,   198,
     842,   631,   639,   642,    -1,   297,   329,    -1,    -1,   447,
     632,   448,    -1,   447,   448,    -1,   633,    -1,   632,   454,
     633,    -1,   634,   636,   638,    -1,   636,   634,   638,    -1,
     636,   638,    -1,   634,   638,    -1,   638,    -1,   215,    -1,
     299,    -1,   224,    -1,   215,   299,    -1,   853,    -1,   853,
     454,   853,    -1,   973,    -1,   638,    -1,   353,   972,   600,
     442,   390,    -1,   767,    -1,   972,   600,   442,   390,    -1,
     641,    -1,   639,   641,    -1,   111,   293,   284,   225,    -1,
     334,   284,   293,   284,   225,    -1,   367,    -1,   213,    -1,
     360,    -1,   409,    -1,   185,   346,   161,    -1,   185,   346,
     234,    -1,   346,   161,    -1,   346,   234,    -1,    93,   635,
      -1,   241,   489,    -1,   640,    -1,   412,   579,    -1,    -1,
      87,   198,   618,   644,   645,    -1,   640,    -1,   644,   640,
      -1,   332,    -1,    -1,   171,   198,   842,   631,   502,    -1,
     171,   198,   210,   183,   842,   631,   502,    -1,   171,    84,
     842,   583,   502,    -1,   171,    84,   210,   183,   842,   583,
     502,    -1,   171,   295,   798,   447,   649,   448,   502,    -1,
     171,   295,   210,   183,   650,   447,   649,   448,   502,    -1,
     767,    -1,   767,   454,   767,    -1,   277,   454,   767,    -1,
     767,   454,   277,    -1,   798,    -1,   971,   449,   650,    -1,
     138,   115,   447,   767,    93,   767,   448,   412,   198,   618,
     652,    -1,   138,   115,   447,   767,    93,   767,   448,   413,
     198,   652,    -1,    93,    96,    -1,    -1,   171,   115,   654,
     447,   767,    93,   767,   448,   502,    -1,   210,   183,    -1,
      -1,   324,   656,   834,   657,    -1,   324,   372,   836,   657,
      -1,   324,   151,   836,   657,    -1,   218,    -1,   373,    -1,
     192,    -1,    -1,    87,    84,   842,   583,   327,   381,   836,
      -1,    87,   135,   599,   327,   381,   836,    -1,    87,   151,
     837,   327,   381,   837,    -1,    87,   198,   842,   631,   327,
     381,   836,    -1,    87,   204,   858,   327,   381,   858,    -1,
      87,   241,   836,   327,   381,   836,    -1,    87,   295,   122,
     599,   400,   838,   327,   381,   836,    -1,    87,   343,   836,
     327,   381,   836,    -1,    87,   373,   761,   327,   381,   836,
      -1,    87,   218,   761,   327,   381,   836,    -1,    87,   373,
     761,   327,   659,   836,   381,   836,    -1,    87,   385,   836,
     293,   761,   327,   381,   836,    -1,    87,   399,   858,   327,
     381,   858,    -1,    87,   374,   836,   327,   381,   836,    -1,
     127,    -1,    -1,    87,    84,   842,   583,   352,   343,   836,
      -1,    87,   169,   599,   352,   343,   836,    -1,    87,   198,
     842,   631,   352,   343,   836,    -1,    87,   348,   761,   352,
     343,   836,    -1,    87,   373,   761,   352,   343,   836,    -1,
      87,   390,   599,   352,   343,   836,    -1,    87,    84,   842,
     583,   304,   381,   858,    -1,    87,   135,   599,   304,   381,
     858,    -1,    87,   151,   837,   304,   381,   858,    -1,    87,
     169,   837,   304,   381,   858,    -1,    87,   198,   842,   631,
     304,   381,   858,    -1,    87,   295,   650,   447,   649,   448,
     304,   381,   858,    -1,    87,   295,   122,   599,   400,   838,
     304,   381,   858,    -1,    87,   343,   836,   304,   381,   858,
      -1,    87,   390,   599,   304,   381,   858,    -1,    87,   374,
     836,   304,   381,   858,    -1,    -1,   138,   630,   341,   836,
      93,   663,   293,   668,   381,   834,   764,   168,   669,   664,
      -1,   280,    -1,   666,    -1,   447,   665,   448,    -1,   665,
     450,   667,    -1,   667,    -1,   727,    -1,   706,    -1,   717,
      -1,   711,    -1,   671,    -1,   666,    -1,    -1,   347,    -1,
     398,    -1,   162,    -1,   227,    -1,   228,    -1,    86,    -1,
      -1,   171,   341,   836,   293,   834,   502,    -1,   171,   341,
     210,   183,   836,   293,   834,   502,    -1,   281,   834,    -1,
     250,   834,    -1,   396,   834,    -1,   396,   440,    -1,    77,
     675,    -1,   102,   675,   678,    -1,   361,   383,   678,    -1,
     129,   675,    -1,   177,   675,    -1,   338,   675,    -1,   342,
     971,    -1,   326,   342,   971,    -1,   326,   971,    -1,   338,
     675,   381,   342,   971,    -1,   338,   675,   381,   971,    -1,
     311,   383,   853,    -1,   129,   312,   853,    -1,   338,   312,
     853,    -1,   414,    -1,   383,    -1,    -1,   237,   247,   484,
      -1,   319,   294,    -1,   319,   415,    -1,   676,    -1,   677,
     454,   676,    -1,   677,   676,    -1,   677,    -1,    -1,   138,
     515,   408,   834,   529,    93,   727,   680,    -1,   138,   297,
     329,   515,   408,   834,   529,    93,   727,   680,    -1,   420,
     296,    -1,   418,   120,   296,    -1,   419,   120,   296,    -1,
      -1,   251,   841,    -1,   138,   151,   837,   412,   683,    -1,
     138,   151,   837,    -1,   684,    -1,   683,   684,    -1,   374,
     685,   836,    -1,   374,   685,   157,    -1,   255,   685,   853,
      -1,   255,   685,   157,    -1,   376,   685,   836,    -1,   376,
     685,   157,    -1,   175,   685,   854,    -1,   175,   685,   157,
      -1,   132,   249,   685,   849,    -1,   304,   685,   836,    -1,
     304,   685,   157,    -1,   434,    -1,    -1,    87,   151,   837,
     463,   688,    -1,    87,   151,   837,   352,   480,    -1,    87,
     151,   837,   491,    -1,   688,   689,    -1,    -1,   132,   249,
     685,   849,    -1,   171,   151,   837,    -1,   171,   151,   210,
     183,   837,    -1,   138,   169,   599,   693,   767,   520,    -1,
      87,   169,   599,   501,    -1,    87,   169,   599,   171,   279,
     284,    -1,    87,   169,   599,   352,   279,   284,    -1,    87,
     169,   599,    81,   527,    -1,    87,   169,   599,   171,   133,
     836,   502,    -1,    93,    -1,    -1,   138,   591,   135,   599,
     191,   853,   381,   853,   196,   599,    -1,   124,   840,   293,
     834,    -1,   124,   834,    -1,   124,    -1,   401,   700,   701,
     699,    -1,   401,   700,   701,   699,   834,    -1,   401,   700,
     701,   699,   697,    -1,   698,   699,    -1,   698,   699,   834,
     702,    -1,    89,    -1,    88,    -1,   407,    -1,    -1,   197,
      -1,    -1,   195,    -1,    -1,   447,   835,   448,    -1,    -1,
     184,   705,   699,   704,    -1,   727,    -1,   706,    -1,   717,
      -1,   711,    -1,   724,    -1,   698,    -1,    -1,   227,   233,
     834,   707,   710,    -1,   727,    -1,   447,   708,   448,   727,
      -1,   157,   404,    -1,   708,   454,   709,    -1,   709,    -1,
     971,   825,    -1,   333,   830,    -1,    -1,   162,   196,   762,
     712,   764,   710,    -1,   400,   754,    -1,    -1,   256,   734,
     833,   714,   716,    -1,   215,   715,   262,    -1,    -1,    79,
     354,    -1,   339,   354,    -1,   339,   180,    -1,   354,   398,
     180,    -1,   354,    -1,   354,   339,   180,    -1,   180,    -1,
      79,   180,    -1,   283,    -1,    -1,   398,   762,   352,   718,
     753,   764,   710,    -1,   719,    -1,   718,   454,   719,    -1,
     720,    -1,   721,    -1,   722,   434,   827,    -1,   447,   723,
     448,   434,   829,    -1,   971,   825,    -1,   722,    -1,   723,
     454,   722,    -1,   156,   836,   725,   149,   726,   191,   727,
      -1,    -1,   725,   105,    -1,   725,   226,    -1,   725,   344,
      -1,   725,   271,   344,    -1,    -1,   412,   208,    -1,   413,
     208,    -1,   729,    -1,   728,    -1,   447,   729,   448,    -1,
     447,   728,   448,    -1,   731,    -1,   730,   738,    -1,   730,
     737,   747,   742,    -1,   730,   737,   741,   748,    -1,   731,
      -1,   728,    -1,   347,   736,   830,   732,   753,   764,   745,
     746,    -1,   752,    -1,   730,   393,   735,   730,    -1,   730,
     231,   735,   730,    -1,   730,   179,   735,   730,    -1,   233,
     733,    -1,   933,    -1,    -1,   377,   734,   834,    -1,   375,
     734,   834,    -1,   252,   377,   734,   834,    -1,   252,   375,
     734,   834,    -1,   200,   377,   734,   834,    -1,   200,   375,
     734,   834,    -1,   373,   834,    -1,   834,    -1,   373,    -1,
      -1,    85,    -1,    -1,   167,    -1,   167,   293,   447,   803,
     448,    -1,    85,    -1,    -1,   738,    -1,    -1,   298,   109,
     739,    -1,   740,    -1,   739,   454,   740,    -1,   792,   400,
     801,    -1,   792,    94,    -1,   792,   165,    -1,   792,    -1,
     249,   743,   290,   744,    -1,   290,   744,   249,   743,    -1,
     249,   743,    -1,   290,   744,    -1,   249,   743,   454,   744,
      -1,   741,    -1,    -1,   792,    -1,    85,    -1,   792,    -1,
     204,   109,   803,    -1,    -1,   206,   792,    -1,    -1,   749,
      -1,   191,   319,   294,    -1,   747,    -1,    -1,   750,    -1,
     749,   750,    -1,   191,   398,   751,   716,    -1,   191,   354,
     751,   716,    -1,   288,   835,    -1,    -1,   404,   829,    -1,
     752,   454,   829,    -1,   196,   754,    -1,    -1,   754,   454,
     755,    -1,   755,    -1,   761,    -1,   761,   757,    -1,   763,
      -1,   763,   757,    -1,   763,    93,   447,   765,   448,    -1,
     763,    93,   971,   447,   765,   448,    -1,   763,   971,   447,
     765,   448,    -1,   728,    -1,   728,   757,    -1,   756,    -1,
     447,   756,   448,   757,    -1,   447,   756,   448,    -1,   755,
     142,   238,   755,    -1,   755,   758,   238,   755,   760,    -1,
     755,   238,   755,   760,    -1,   755,   267,   758,   238,   755,
      -1,   755,   267,   238,   755,    -1,    93,   971,   447,   835,
     448,    -1,    93,   971,    -1,   971,   447,   835,   448,    -1,
     971,    -1,   197,   759,    -1,   246,   759,    -1,   336,   759,
      -1,   223,    -1,   300,    -1,    -1,   400,   447,   835,   448,
      -1,   293,   792,    -1,   834,    -1,   834,   440,    -1,   294,
     834,    -1,   294,   447,   834,   448,    -1,   761,    -1,   761,
     971,    -1,   761,    93,   971,    -1,   795,    -1,   411,   792,
      -1,    -1,   766,    -1,   765,   454,   766,    -1,   971,   767,
      -1,   770,   768,    -1,   353,   770,   768,    -1,   770,    92,
     445,   849,   446,    -1,   353,   770,    92,   445,   849,   446,
      -1,   445,   446,   768,    -1,   445,   769,   446,   768,    -1,
      -1,   849,    -1,   447,   769,   448,    -1,   769,   438,   769,
      -1,   769,   439,   769,    -1,   769,   440,   769,    -1,   769,
     441,   769,    -1,   769,   442,   769,    -1,   848,    -1,   971,
      -1,   772,    -1,   788,    -1,   773,    -1,   777,    -1,   781,
      -1,   789,   791,    -1,   789,   447,   849,   448,   791,    -1,
     972,   600,    -1,   772,    -1,   788,    -1,   773,    -1,   778,
      -1,   782,    -1,   972,    -1,   229,    -1,   230,    -1,   358,
      -1,   104,    -1,   320,    -1,   190,   774,    -1,   170,   309,
      -1,   155,   776,    -1,   154,   776,    -1,   286,   775,    -1,
     107,    -1,   447,   849,   448,    -1,    -1,   447,   849,   454,
     849,   448,    -1,   447,   849,   448,    -1,    -1,   447,   849,
     454,   849,   448,    -1,   447,   849,   448,    -1,    -1,   779,
      -1,   780,    -1,   779,    -1,   780,    -1,   106,   786,   447,
     849,   448,    -1,   106,   786,    -1,   783,    -1,   784,    -1,
     783,    -1,   784,    -1,   785,   447,   849,   448,   787,    -1,
     785,   787,    -1,   118,   786,    -1,   117,   786,    -1,   405,
      -1,   266,   118,   786,    -1,   266,   117,   786,    -1,   268,
     786,    -1,   406,    -1,    -1,   118,   352,   971,    -1,    -1,
     380,   447,   849,   448,   790,    -1,   380,   790,    -1,   379,
     447,   849,   448,   790,    -1,   379,   790,    -1,   232,    -1,
     412,   379,   417,    -1,   413,   379,   417,    -1,    -1,   416,
      -1,   263,    -1,   152,    -1,   209,    -1,   260,    -1,   345,
      -1,   416,   381,   263,    -1,   152,   381,   209,    -1,   152,
     381,   260,    -1,   152,   381,   345,    -1,   209,   381,   260,
      -1,   260,   381,   345,    -1,   209,   381,   345,    -1,    -1,
     794,    -1,   792,    76,   767,    -1,   792,    98,   379,   417,
     792,    -1,   438,   792,    -1,   439,   792,    -1,   792,   438,
     792,    -1,   792,   439,   792,    -1,   792,   440,   792,    -1,
     792,   441,   792,    -1,   792,   442,   792,    -1,   792,   443,
     792,    -1,   792,   435,   792,    -1,   792,   436,   792,    -1,
     792,   434,   792,    -1,   792,   800,   792,    -1,   800,   792,
      -1,   792,   800,    -1,   792,    90,   792,    -1,   792,   297,
     792,    -1,   279,   792,    -1,   792,   248,   792,    -1,   792,
     248,   792,   178,   792,    -1,   792,   279,   248,   792,    -1,
     792,   279,   248,   792,   178,   792,    -1,   792,   211,   792,
      -1,   792,   211,   792,   178,   792,    -1,   792,   279,   211,
     792,    -1,   792,   279,   211,   792,   178,   792,    -1,   792,
     356,   381,   792,    -1,   792,   356,   381,   792,   178,   792,
      -1,   792,   279,   356,   381,   792,    -1,   792,   279,   356,
     381,   792,   178,   792,    -1,   792,   236,    -1,   792,   235,
     284,    -1,   792,   282,    -1,   792,   235,   279,   284,    -1,
     792,   235,   387,    -1,   792,   235,   279,   387,    -1,   792,
     235,   187,    -1,   792,   235,   279,   187,    -1,   792,   235,
     395,    -1,   792,   235,   279,   395,    -1,   792,   235,   167,
     196,   792,    -1,   792,   235,   279,   167,   196,   792,    -1,
     792,   235,   288,   447,   805,   448,    -1,   792,   235,   279,
     288,   447,   805,   448,    -1,   792,   103,   826,   793,    90,
     793,    -1,   792,   279,   103,   826,   793,    90,   793,    -1,
     792,   103,   370,   793,    90,   793,    -1,   792,   279,   103,
     370,   793,    90,   793,    -1,   792,   215,   816,    -1,   792,
     279,   215,   816,    -1,   792,   802,   797,   728,    -1,   792,
     802,   797,   447,   792,   448,    -1,   394,   728,    -1,   794,
      -1,   793,    76,   767,    -1,   439,   793,    -1,   793,   438,
     793,    -1,   793,   439,   793,    -1,   793,   440,   793,    -1,
     793,   441,   793,    -1,   793,   442,   793,    -1,   793,   443,
     793,    -1,   793,   435,   793,    -1,   793,   436,   793,    -1,
     793,   434,   793,    -1,   793,   423,   793,    -1,   800,   793,
      -1,   793,   800,    -1,   793,   235,   167,   196,   793,    -1,
     793,   235,   279,   167,   196,   793,    -1,   793,   235,   288,
     447,   793,   448,    -1,   793,   235,   279,   288,   447,   793,
     448,    -1,   822,    -1,   843,    -1,   432,   825,    -1,   447,
     792,   448,   825,    -1,   817,    -1,   795,    -1,   728,    -1,
     183,   728,    -1,    92,   728,    -1,    92,   807,    -1,   796,
      -1,   842,   447,   448,    -1,   842,   447,   803,   448,    -1,
     842,   447,    85,   803,   448,    -1,   842,   447,   167,   803,
     448,    -1,   842,   447,   440,   448,    -1,   144,    -1,   146,
      -1,   146,   447,   849,   448,    -1,   147,    -1,   147,   447,
     849,   448,    -1,   253,    -1,   253,   447,   849,   448,    -1,
     254,    -1,   254,   447,   849,   448,    -1,   145,    -1,   148,
      -1,   351,    -1,   399,    -1,   115,   447,   792,    93,   767,
     448,    -1,   186,   447,   804,   448,    -1,   302,   447,   809,
     448,    -1,   308,   447,   811,   448,    -1,   368,   447,   812,
     448,    -1,   384,   447,   792,    93,   767,   448,    -1,   386,
     447,   108,   815,   448,    -1,   386,   447,   244,   815,   448,
      -1,   386,   447,   382,   815,   448,    -1,   386,   447,   815,
     448,    -1,   136,   447,   792,   400,   599,   448,    -1,   136,
     447,   803,   448,    -1,   285,   447,   792,   454,   792,   448,
      -1,   125,   447,   803,   448,    -1,   203,   447,   803,   448,
      -1,   245,   447,   803,   448,    -1,   339,   447,   803,   448,
      -1,   339,   447,   448,    -1,   447,   803,   454,   792,   448,
      -1,    91,    -1,   359,    -1,    85,    -1,   423,    -1,   799,
      -1,   438,    -1,   439,    -1,   440,    -1,   442,    -1,   443,
      -1,   441,    -1,   435,    -1,   436,    -1,   434,    -1,   423,
      -1,   295,   447,   650,   448,    -1,   798,    -1,   295,   447,
     650,   448,    -1,   798,    -1,   295,   447,   650,   448,    -1,
     248,    -1,   279,   248,    -1,   211,    -1,   279,   211,    -1,
     792,    -1,   803,   454,   792,    -1,   808,   196,   792,    -1,
      -1,   805,   454,   767,    -1,   767,    -1,   807,    -1,   806,
     454,   807,    -1,   445,   803,   446,    -1,   445,   806,   446,
      -1,   993,    -1,   416,    -1,   263,    -1,   152,    -1,   209,
      -1,   260,    -1,   345,    -1,   853,    -1,   792,   810,   813,
     814,    -1,   792,   810,   813,    -1,   307,   792,    -1,   793,
     215,   793,    -1,    -1,   792,   813,   814,    -1,   792,   814,
     813,    -1,   792,   813,    -1,   792,   814,    -1,   803,    -1,
      -1,   196,   792,    -1,   191,   792,    -1,   792,   196,   803,
      -1,   196,   803,    -1,   803,    -1,   728,    -1,   447,   803,
     448,    -1,   114,   821,   818,   820,   177,    -1,   818,   819,
      -1,   819,    -1,   410,   792,   378,   792,    -1,   173,   792,
      -1,    -1,   792,    -1,    -1,   832,    -1,   832,   824,    -1,
     449,   839,    -1,   449,   440,    -1,   445,   792,   446,    -1,
     445,   792,   455,   792,   446,    -1,   823,    -1,   824,   823,
      -1,    -1,   825,   823,    -1,    97,    -1,    -1,   792,    -1,
     157,    -1,   827,    -1,   828,   454,   827,    -1,   447,   828,
     448,    -1,   830,   454,   831,    -1,   831,    -1,   792,    93,
     974,    -1,   792,    -1,   440,    -1,   859,    -1,   971,    -1,
     834,    -1,   833,   454,   834,    -1,   832,    -1,   832,   824,
      -1,   836,    -1,   835,   454,   836,    -1,   971,    -1,   971,
      -1,   971,    -1,   974,    -1,   971,    -1,   853,    -1,   973,
      -1,   832,   824,    -1,   857,    -1,   771,   853,    -1,   789,
     853,   791,    -1,   789,   447,   849,   448,   853,   791,    -1,
     387,    -1,   187,    -1,   284,    -1,   989,    -1,   431,    -1,
     433,    -1,   428,    -1,   429,    -1,   422,    -1,   430,    -1,
     844,    -1,   990,    -1,   849,    -1,   439,   849,    -1,   844,
      -1,   992,    -1,   845,    -1,   851,    -1,   439,   845,    -1,
     439,   844,    -1,   848,    -1,   848,    -1,   990,    -1,   844,
      -1,   848,    -1,   990,    -1,   845,    -1,   844,    -1,   439,
     845,    -1,   439,   844,    -1,   990,    -1,   848,    -1,   855,
      -1,   848,    -1,   845,    -1,   844,    -1,   846,    -1,   847,
      -1,   990,    -1,   971,    -1,   292,    -1,   269,    -1,     9,
     381,   861,   868,   869,    -1,     9,   381,   157,    -1,     9,
     870,    -1,   151,   861,    -1,   862,   865,   867,    -1,   863,
     455,   864,   867,   441,   862,   873,    -1,   872,    -1,   848,
      -1,   837,    -1,    -1,   993,   992,    -1,   423,   866,    -1,
     864,    -1,    -1,   971,    -1,   971,   449,   866,    -1,   427,
      -1,   455,   849,    -1,    -1,    93,   920,    -1,    -1,   399,
     870,    -1,    -1,   871,    -1,   871,   441,   871,    -1,   871,
      24,   109,   871,    -1,   871,   400,   871,    -1,   858,    -1,
     853,    -1,   992,    -1,   423,   971,    -1,    -1,   156,   836,
     725,   149,   726,   191,   925,    -1,   153,   311,   925,    -1,
     153,   925,    -1,   877,    -1,   891,    -1,   878,    -1,    -1,
     897,   900,   879,   913,   450,    -1,    -1,   900,   880,   913,
     450,    -1,   903,   450,    -1,   855,    -1,   454,   855,    -1,
      -1,   791,    -1,   416,   381,   260,    -1,   416,   381,   345,
      -1,   152,   381,   152,    -1,   263,   381,   263,    -1,    -1,
     886,   885,   888,   887,    -1,   986,   102,   156,    38,   450,
      -1,   986,   177,   156,    38,   450,    -1,    -1,   889,    -1,
     426,    -1,   893,    -1,   891,    -1,   889,   893,    -1,   889,
     891,    -1,   889,   426,    -1,   893,    -1,   890,   893,    -1,
      -1,    75,   892,   900,   916,   975,   768,   450,    -1,    -1,
     897,   900,   894,   913,   450,    -1,    -1,   900,   895,   913,
     450,    -1,   903,   450,    -1,   455,   844,    -1,    -1,   898,
     899,    -1,   898,    -1,   899,    -1,    61,    -1,    72,    -1,
      70,    -1,    55,    -1,    56,    -1,    74,    -1,   909,    -1,
     905,    -1,   901,    -1,   975,   447,   881,   882,   448,    -1,
     975,   883,    -1,   907,    -1,    19,   969,   902,    -1,    19,
     902,    -1,    19,   969,    -1,   451,   997,   452,    -1,    -1,
     907,   904,   451,   890,   452,    -1,   903,    -1,    -1,   908,
     906,   451,   890,   452,    -1,    47,   969,    -1,   393,   969,
      -1,    47,    -1,   393,    -1,   910,    -1,   912,   911,    -1,
      48,    39,    -1,    48,    39,   229,    -1,    48,    -1,    48,
     229,    -1,    48,    28,    -1,    48,    28,   229,    -1,    48,
      28,    28,    -1,    48,    28,    28,   229,    -1,    48,   117,
      -1,    39,    -1,    39,   229,    -1,   229,    -1,    28,    -1,
      28,   229,    -1,    28,    28,    -1,    28,    28,   229,    -1,
       5,    -1,   117,    -1,   170,    -1,    40,    -1,    -1,   914,
      -1,   913,   454,   914,    -1,   916,   976,   768,   896,   915,
      -1,    -1,   434,   998,    -1,    -1,   440,    -1,   440,   440,
      -1,   156,   362,   993,    -1,    18,   919,    -1,   920,    -1,
      12,    -1,    85,    -1,    -1,   837,    -1,   157,    -1,   872,
      -1,   182,   212,   924,    -1,    -1,   182,   925,   922,   923,
      -1,   929,   933,    -1,   933,   929,    -1,   929,    -1,   933,
      -1,    -1,   872,    -1,   424,    -1,   836,    -1,   872,    -1,
      21,   836,    -1,    32,   836,   928,    -1,    -1,   929,    -1,
     400,   934,    -1,   930,    -1,   400,   932,    17,   994,    -1,
     233,   932,    17,   994,    -1,    -1,    41,    -1,   233,   985,
      -1,   931,    -1,   935,    -1,   935,   454,   934,    -1,   856,
      -1,   989,    -1,   311,   925,   196,   924,    -1,    16,   225,
     836,   930,    -1,    16,   938,   836,   930,    -1,    16,   938,
     836,   931,    -1,    33,    -1,    -1,     3,    17,   994,    -1,
     153,    17,   994,    -1,   199,    17,   994,   942,    -1,   943,
      -1,   942,   454,   943,    -1,   992,   434,   947,    -1,   352,
      17,   994,   945,    -1,   946,    -1,   945,   454,   946,    -1,
     947,   434,   851,    -1,    11,    -1,   199,    17,   994,    49,
     851,   949,    -1,   950,    -1,   949,   454,   950,    -1,   992,
     434,   954,    -1,   352,    17,   994,    49,   851,   952,    -1,
     953,    -1,   952,   454,   953,    -1,   954,   434,   852,    -1,
       8,    -1,    13,    -1,    14,    -1,    15,    -1,    25,    -1,
      26,    -1,    27,    -1,    29,    -1,    30,    -1,    31,    -1,
     309,    -1,    35,    -1,    36,    -1,    37,    -1,   390,    -1,
     352,     4,   434,   956,    -1,   352,     4,   381,   956,    -1,
     293,    -1,   289,    -1,   352,   132,   381,   920,    -1,   352,
     132,   434,   920,    -1,   352,   132,   920,    -1,    -1,   390,
     959,   975,   235,   900,   768,   960,    -1,    34,    -1,    -1,
      -1,    50,   962,   974,   235,   900,   768,   960,    -1,    51,
      42,   964,    -1,    51,   279,    20,   964,    -1,    51,    44,
     964,    -1,    10,    -1,    43,    -1,    46,    -1,    23,   836,
      -1,    22,   381,   836,    -1,   168,   836,   447,   987,   448,
      -1,   168,     6,    -1,     7,   836,   447,   987,   448,    -1,
       7,   836,    -1,   966,    -1,   967,    -1,     6,    -1,     7,
      -1,     8,    -1,    10,    -1,    11,    -1,    13,    -1,    14,
      -1,    15,    -1,    20,    -1,    22,    -1,    23,    -1,    24,
      -1,    25,    -1,    26,    -1,    27,    -1,    29,    -1,    30,
      -1,    31,    -1,    35,    -1,    36,    -1,    37,    -1,    38,
      -1,    42,    -1,    43,    -1,    44,    -1,    46,    -1,    49,
      -1,     9,    -1,    16,    -1,    18,    -1,    32,    -1,    50,
      -1,    51,    -1,     5,    -1,    28,    -1,    33,    -1,    39,
      -1,    47,    -1,    40,    -1,    48,    -1,   974,    -1,   993,
      -1,   979,    -1,   981,    -1,   982,    -1,   965,    -1,   977,
      -1,   117,    -1,   404,    -1,   993,    -1,   978,    -1,   982,
      -1,   965,    -1,   977,    -1,   117,    -1,   404,    -1,   993,
      -1,   978,    -1,   965,    -1,   968,    -1,   977,    -1,   993,
      -1,   978,    -1,   983,    -1,   965,    -1,   977,    -1,   976,
      -1,   968,    -1,   117,    -1,   225,    -1,   229,    -1,   393,
      -1,   381,    -1,   977,    -1,   979,    -1,   993,    -1,   982,
      -1,   983,    -1,   966,    -1,   975,    -1,   984,    -1,   980,
      -1,   967,    -1,    55,    -1,    56,    -1,    61,    -1,    70,
      -1,    72,    -1,    75,    -1,    74,    -1,   979,    -1,   980,
      -1,   152,    -1,   209,    -1,   260,    -1,   263,    -1,   345,
      -1,   416,    -1,   981,    -1,   132,    -1,    77,    -1,    78,
      -1,    79,    -1,    80,    -1,    81,    -1,    82,    -1,    83,
      -1,    84,    -1,    86,    -1,    87,    -1,    95,    -1,    96,
      -1,    98,    -1,   100,    -1,   101,    -1,   102,    -1,   109,
      -1,   110,    -1,   112,    -1,   113,    -1,   116,    -1,   119,
      -1,   121,    -1,   122,    -1,   123,    -1,   124,    -1,   128,
      -1,   129,    -1,   130,    -1,   131,    -1,   134,    -1,   135,
      -1,   137,    -1,   139,    -1,   140,    -1,   141,    -1,   143,
      -1,   149,    -1,   150,    -1,   151,    -1,   153,    -1,   156,
      -1,   158,    -1,   160,    -1,   162,    -1,   163,    -1,   164,
      -1,   166,    -1,   169,    -1,   170,    -1,   171,    -1,   172,
      -1,   174,    -1,   175,    -1,   176,    -1,   178,    -1,   181,
      -1,   180,    -1,   182,    -1,   184,    -1,   188,    -1,   189,
      -1,   192,    -1,   194,    -1,   198,    -1,   200,    -1,   202,
      -1,   205,    -1,   207,    -1,   208,    -1,   210,    -1,   212,
      -1,   213,    -1,   214,    -1,   216,    -1,   217,    -1,   218,
      -1,   219,    -1,   220,    -1,   221,    -1,   226,    -1,   227,
      -1,   228,    -1,   237,    -1,   239,    -1,   240,    -1,   241,
      -1,   242,    -1,   243,    -1,   247,    -1,   250,    -1,   251,
      -1,   252,    -1,   255,    -1,   256,    -1,   257,    -1,   258,
      -1,   259,    -1,   261,    -1,   262,    -1,   264,    -1,   265,
      -1,   270,    -1,   271,    -1,   272,    -1,   273,    -1,   274,
      -1,   275,    -1,   276,    -1,   278,    -1,   280,    -1,   281,
      -1,   283,    -1,   287,    -1,   288,    -1,   291,    -1,   295,
      -1,   296,    -1,   303,    -1,   304,    -1,   305,    -1,   306,
      -1,   311,    -1,   312,    -1,   310,    -1,   314,    -1,   315,
      -1,   316,    -1,   317,    -1,   318,    -1,   319,    -1,   321,
      -1,   322,    -1,   324,    -1,   325,    -1,   326,    -1,   327,
      -1,   328,    -1,   329,    -1,   330,    -1,   331,    -1,   332,
      -1,   334,    -1,   335,    -1,   337,    -1,   338,    -1,   340,
      -1,   341,    -1,   342,    -1,   343,    -1,   344,    -1,   348,
      -1,   349,    -1,   350,    -1,   352,    -1,   354,    -1,   355,
      -1,   357,    -1,   360,    -1,   361,    -1,   362,    -1,   363,
      -1,   364,    -1,   365,    -1,   366,    -1,   369,    -1,   367,
      -1,   372,    -1,   371,    -1,   374,    -1,   375,    -1,   376,
      -1,   377,    -1,   383,    -1,   385,    -1,   388,    -1,   389,
      -1,   390,    -1,   391,    -1,   392,    -1,   395,    -1,   396,
      -1,   397,    -1,   398,    -1,   401,    -1,   402,    -1,   406,
      -1,   408,    -1,   412,    -1,   413,    -1,   414,    -1,   415,
      -1,   417,    -1,   104,    -1,   106,    -1,   118,    -1,   125,
      -1,   136,    -1,   154,    -1,   155,    -1,   183,    -1,   186,
      -1,   190,    -1,   203,    -1,   224,    -1,   230,    -1,   232,
      -1,   245,    -1,   266,    -1,   268,    -1,   277,    -1,   285,
      -1,   286,    -1,   299,    -1,   302,    -1,   308,    -1,   309,
      -1,   320,    -1,   339,    -1,   353,    -1,   358,    -1,   368,
      -1,   379,    -1,   380,    -1,   384,    -1,   386,    -1,   405,
      -1,    99,    -1,   103,    -1,   105,    -1,   142,    -1,   195,
      -1,   197,    -1,   211,    -1,   223,    -1,   235,    -1,   236,
      -1,   238,    -1,   246,    -1,   248,    -1,   267,    -1,   282,
      -1,   300,    -1,   301,    -1,   336,    -1,   356,    -1,   407,
      -1,    85,    -1,    88,    -1,    89,    -1,    90,    -1,    91,
      -1,    92,    -1,    93,    -1,    94,    -1,    97,    -1,   108,
      -1,   114,    -1,   115,    -1,   120,    -1,   126,    -1,   127,
      -1,   133,    -1,   138,    -1,   144,    -1,   146,    -1,   147,
      -1,   145,    -1,   148,    -1,   157,    -1,   159,    -1,   165,
      -1,   167,    -1,   168,    -1,   173,    -1,   177,    -1,   179,
      -1,   187,    -1,   191,    -1,   193,    -1,   196,    -1,   201,
      -1,   204,    -1,   206,    -1,   215,    -1,   222,    -1,   231,
      -1,   233,    -1,   244,    -1,   249,    -1,   269,    -1,   279,
      -1,   284,    -1,   289,    -1,   290,    -1,   292,    -1,   293,
      -1,   294,    -1,   297,    -1,   298,    -1,   313,    -1,   323,
      -1,   333,    -1,   347,    -1,   351,    -1,   359,    -1,   370,
      -1,   373,    -1,   378,    -1,   382,    -1,   387,    -1,   394,
      -1,   399,    -1,   400,    -1,   410,    -1,   411,    -1,   988,
      -1,   985,   454,   988,    -1,    45,    -1,    -1,   997,    -1,
     992,   991,    -1,   992,    -1,   992,   991,    -1,   992,    -1,
     992,    -1,    25,   992,    -1,    25,   836,    -1,   425,    -1,
     421,    -1,   424,    -1,   836,    -1,   872,    -1,  1000,    -1,
     447,   448,    -1,   447,   996,   448,    -1,   995,    -1,   996,
     995,    -1,   998,    -1,   997,   454,   998,    -1,   996,    -1,
     451,   997,   452,    -1,  1000,    -1,   447,    -1,   448,    -1,
     454,    -1,   450,    -1,   421,    -1,   424,    -1,   844,    -1,
     845,    -1,   848,    -1,   440,    -1,   438,    -1,   439,    -1,
     441,    -1,   442,    -1,   284,    -1,    52,    -1,    53,    -1,
      54,    -1,    55,    -1,    56,    -1,    57,    -1,    58,    -1,
      59,    -1,    60,    -1,    61,    -1,    62,    -1,    63,    -1,
      65,    -1,    64,    -1,    66,    -1,    67,    -1,    68,    -1,
      69,    -1,    70,    -1,    71,    -1,    72,    -1,    73,    -1,
      75,    -1,    74,    -1,     5,    -1,    19,    -1,   209,    -1,
     229,    -1,    28,    -1,   260,    -1,   263,    -1,   345,    -1,
      39,    -1,    40,    -1,    47,    -1,    48,    -1,   416,    -1,
     117,    -1,   190,    -1,   381,    -1,   393,    -1,   405,    -1,
     445,    -1,   446,    -1,   434,    -1,   455,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   610,   610,   612,   613,   616,   617,   618,   624,   625,
     626,   627,   628,   631,   643,   644,   645,   646,   647,   648,
     649,   650,   651,   652,   653,   654,   655,   656,   657,   681,
     682,   683,   684,   685,   686,   687,   688,   689,   690,   691,
     692,   693,   694,   695,   696,   697,   698,   699,   700,   701,
     703,   704,   705,   706,   707,   708,   709,   710,   711,   712,
     713,   714,   715,   716,   717,   718,   719,   721,   722,   723,
     724,   725,   726,   727,   728,   729,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   747,   748,   749,
     750,   751,   752,   753,   754,   755,   761,   771,   775,   783,
     791,   795,   806,   816,   820,   827,   834,   840,   851,   861,
     867,   876,   883,   889,   898,   905,   926,   930,   931,   940,
     941,   942,   943,   944,   945,   946,   947,   948,   949,   950,
     951,   952,   953,   954,   955,   956,   957,   958,   959,   960,
     961,   971,   982,   986,   988,   998,  1001,  1003,  1013,  1015,
    1025,  1027,  1038,  1048,  1052,  1053,  1062,  1064,  1075,  1077,
    1081,  1082,  1085,  1086,  1093,  1094,  1095,  1096,  1097,  1098,
    1111,  1113,  1115,  1119,  1121,  1123,  1125,  1127,  1129,  1131,
    1133,  1135,  1139,  1140,  1144,  1146,  1150,  1152,  1156,  1157,
    1158,  1159,  1162,  1163,  1164,  1167,  1168,  1169,  1170,  1180,
    1181,  1182,  1184,  1186,  1188,  1192,  1193,  1194,  1197,  1198,
    1201,  1203,  1205,  1207,  1209,  1213,  1215,  1217,  1219,  1221,
    1225,  1229,  1231,  1235,  1236,  1242,  1253,  1255,  1261,  1262,
    1266,  1270,  1273,  1276,  1279,  1282,  1285,  1288,  1291,  1294,
    1297,  1300,  1303,  1306,  1309,  1312,  1315,  1318,  1321,  1324,
    1327,  1329,  1333,  1334,  1340,  1343,  1345,  1347,  1352,  1353,
    1356,  1357,  1358,  1361,  1362,  1372,  1376,  1388,  1397,  1398,
    1401,  1402,  1403,  1406,  1407,  1410,  1411,  1412,  1414,  1416,
    1417,  1418,  1420,  1422,  1424,  1429,  1430,  1433,  1434,  1441,
    1444,  1447,  1448,  1458,  1461,  1471,  1472,  1473,  1474,  1475,
    1476,  1477,  1481,  1484,  1486,  1488,  1492,  1493,  1494,  1497,
    1501,  1502,  1505,  1507,  1508,  1522,  1524,  1526,  1528,  1530,
    1532,  1534,  1549,  1550,  1551,  1552,  1555,  1559,  1561,  1565,
    1566,  1567,  1568,  1569,  1570,  1577,  1579,  1583,  1585,  1587,
    1589,  1594,  1595,  1598,  1600,  1604,  1607,  1609,  1615,  1618,
    1619,  1620,  1621,  1622,  1625,  1629,  1633,  1634,  1635,  1636,
    1637,  1640,  1643,  1646,  1647,  1648,  1649,  1652,  1653,  1654,
    1655,  1658,  1659,  1662,  1663,  1672,  1671,  1682,  1685,  1688,
    1690,  1694,  1705,  1709,  1713,  1714,  1717,  1719,  1721,  1723,
    1725,  1727,  1729,  1731,  1733,  1735,  1737,  1741,  1742,  1753,
    1755,  1760,  1761,  1768,  1769,  1772,  1775,  1777,  1780,  1783,
    1785,  1789,  1790,  1800,  1804,  1805,  1819,  1821,  1834,  1838,
    1845,  1846,  1849,  1851,  1853,  1857,  1858,  1859,  1862,  1865,
    1868,  1869,  1872,  1873,  1876,  1878,  1881,  1884,  1885,  1888,
    1889,  1892,  1893,  1900,  1901,  1910,  1912,  1916,  1918,  1922,
    1924,  1935,  1943,  1958,  1960,  1962,  1964,  1966,  1968,  1972,
    1976,  1977,  1980,  1981,  1985,  1986,  1987,  1988,  1989,  1992,
    1993,  1997,  1998,  2001,  2004,  2005,  2008,  2012,  2019,  2020,
    2023,  2025,  2027,  2029,  2033,  2034,  2037,  2038,  2041,  2043,
    2056,  2061,  2073,  2075,  2079,  2080,  2081,  2082,  2083,  2084,
    2085,  2086,  2089,  2091,  2095,  2096,  2099,  2100,  2109,  2124,
    2129,  2134,  2139,  2144,  2149,  2154,  2159,  2164,  2166,  2170,
    2171,  2172,  2173,  2174,  2175,  2176,  2177,  2178,  2179,  2180,
    2181,  2182,  2183,  2186,  2187,  2190,  2192,  2194,  2196,  2198,
    2200,  2202,  2204,  2206,  2208,  2210,  2214,  2215,  2216,  2217,
    2218,  2219,  2220,  2221,  2222,  2223,  2224,  2225,  2228,  2229,
    2239,  2243,  2245,  2249,  2250,  2251,  2254,  2256,  2260,  2261,
    2262,  2263,  2266,  2268,  2270,  2272,  2274,  2276,  2278,  2280,
    2284,  2286,  2290,  2291,  2294,  2299,  2302,  2304,  2308,  2317,
    2322,  2326,  2327,  2330,  2331,  2347,  2350,  2355,  2356,  2359,
    2362,  2365,  2366,  2369,  2371,  2373,  2377,  2378,  2379,  2382,
    2385,  2390,  2391,  2394,  2396,  2400,  2402,  2406,  2407,  2408,
    2409,  2410,  2413,  2414,  2415,  2416,  2419,  2421,  2425,  2427,
    2435,  2439,  2441,  2446,  2448,  2453,  2455,  2457,  2459,  2461,
    2463,  2465,  2467,  2469,  2471,  2474,  2476,  2478,  2482,  2483,
    2487,  2491,  2492,  2495,  2496,  2509,  2511,  2515,  2517,  2521,
    2523,  2527,  2529,  2531,  2533,  2538,  2540,  2544,  2547,  2552,
    2553,  2557,  2561,  2562,  2572,  2574,  2576,  2580,  2581,  2584,
    2585,  2596,  2598,  2600,  2602,  2604,  2606,  2608,  2610,  2612,
    2614,  2616,  2618,  2620,  2622,  2626,  2627,  2637,  2639,  2641,
    2643,  2645,  2647,  2657,  2659,  2661,  2663,  2665,  2667,  2669,
    2671,  2673,  2675,  2687,  2686,  2696,  2697,  2698,  2702,  2704,
    2708,  2709,  2710,  2711,  2712,  2715,  2716,  2720,  2721,  2722,
    2723,  2726,  2727,  2728,  2731,  2733,  2745,  2749,  2753,  2755,
    2768,  2769,  2770,  2771,  2772,  2773,  2774,  2775,  2776,  2777,
    2778,  2779,  2780,  2781,  2784,  2785,  2786,  2790,  2792,  2793,
    2797,  2798,  2799,  2803,  2804,  2815,  2817,  2826,  2828,  2830,
    2833,  2843,  2855,  2857,  2861,  2863,  2867,  2869,  2871,  2873,
    2875,  2877,  2879,  2881,  2883,  2885,  2887,  2891,  2892,  2903,
    2907,  2909,  2914,  2915,  2919,  2929,  2931,  2942,  2949,  2951,
    2953,  2955,  2957,  2961,  2962,  2966,  2980,  2982,  2984,  2997,
    2999,  3001,  3005,  3007,  3011,  3012,  3015,  3016,  3019,  3020,
    3023,  3024,  3027,  3030,  3041,  3046,  3047,  3048,  3049,  3050,
    3054,  3055,  3105,  3110,  3112,  3114,  3118,  3120,  3124,  3128,
    3129,  3139,  3143,  3144,  3147,  3151,  3154,  3157,  3158,  3159,
    3160,  3161,  3162,  3163,  3164,  3167,  3168,  3178,  3187,  3188,
    3192,  3193,  3197,  3200,  3203,  3206,  3207,  3216,  3247,  3248,
    3249,  3250,  3251,  3255,  3261,  3262,  3272,  3274,  3278,  3280,
    3284,  3286,  3288,  3290,  3294,  3295,  3298,  3302,  3304,  3306,
    3308,  3312,  3317,  3318,  3328,  3330,  3332,  3334,  3336,  3338,
    3340,  3342,  3346,  3347,  3350,  3351,  3354,  3356,  3358,  3361,
    3364,  3365,  3368,  3372,  3373,  3376,  3378,  3380,  3382,  3386,
    3388,  3390,  3392,  3394,  3398,  3399,  3402,  3403,  3406,  3416,
    3419,  3422,  3425,  3429,  3430,  3434,  3435,  3439,  3440,  3444,
    3446,  3451,  3452,  3455,  3457,  3469,  3470,  3473,  3474,  3484,
    3486,  3488,  3490,  3492,  3494,  3496,  3498,  3500,  3502,  3504,
    3525,  3527,  3529,  3531,  3533,  3535,  3539,  3541,  3543,  3545,
    3549,  3550,  3551,  3552,  3556,  3557,  3567,  3569,  3573,  3575,
    3577,  3579,  3583,  3585,  3587,  3591,  3594,  3595,  3598,  3600,
    3604,  3617,  3619,  3621,  3623,  3628,  3634,  3641,  3648,  3649,
    3650,  3651,  3652,  3653,  3654,  3655,  3656,  3659,  3660,  3661,
    3662,  3663,  3664,  3666,  3668,  3672,  3673,  3674,  3675,  3676,
    3679,  3687,  3689,  3691,  3693,  3695,  3697,  3699,  3701,  3703,
    3705,  3707,  3711,  3714,  3717,  3719,  3722,  3725,  3727,  3730,
    3738,  3739,  3742,  3743,  3746,  3750,  3759,  3760,  3763,  3764,
    3767,  3771,  3775,  3777,  3779,  3781,  3783,  3785,  3789,  3792,
    3795,  3798,  3801,  3803,  3805,  3807,  3811,  3815,  3817,  3820,
    3823,  3824,  3825,  3826,  3827,  3828,  3829,  3830,  3831,  3832,
    3833,  3834,  3835,  3836,  3862,  3864,  3866,  3877,  3879,  3881,
    3883,  3885,  3887,  3889,  3891,  3893,  3895,  3897,  3899,  3901,
    3903,  3905,  3907,  3909,  3911,  3913,  3915,  3917,  3919,  3921,
    3923,  3925,  3927,  3929,  3931,  3933,  3935,  3937,  3939,  3941,
    3952,  3954,  3956,  3958,  3960,  3962,  3964,  3966,  3968,  3970,
    3972,  3974,  3976,  3978,  3980,  3982,  3984,  3986,  3988,  4000,
    4002,  4004,  4006,  4008,  4010,  4012,  4014,  4016,  4018,  4020,
    4022,  4024,  4026,  4028,  4030,  4032,  4034,  4036,  4048,  4050,
    4052,  4054,  4056,  4058,  4060,  4062,  4064,  4066,  4068,  4080,
    4082,  4084,  4086,  4088,  4090,  4092,  4094,  4096,  4098,  4100,
    4102,  4104,  4106,  4108,  4110,  4112,  4114,  4116,  4118,  4120,
    4122,  4124,  4126,  4129,  4131,  4133,  4135,  4137,  4139,  4141,
    4143,  4145,  4147,  4152,  4154,  4156,  4160,  4161,  4162,  4165,
    4166,  4169,  4170,  4171,  4172,  4173,  4174,  4175,  4176,  4177,
    4180,  4181,  4184,  4185,  4188,  4189,  4190,  4191,  4192,  4193,
    4196,  4198,  4202,  4205,  4208,  4210,  4214,  4215,  4219,  4220,
    4226,  4227,  4228,  4229,  4230,  4231,  4232,  4233,  4237,  4239,
    4244,  4248,  4251,  4254,  4256,  4258,  4260,  4262,  4265,  4268,
    4272,  4276,  4278,  4280,  4284,  4286,  4293,  4297,  4299,  4303,
    4307,  4310,  4313,  4314,  4317,  4318,  4322,  4323,  4324,  4325,
    4328,  4329,  4333,  4334,  4337,  4338,  4342,  4343,  4347,  4348,
    4351,  4359,  4361,  4366,  4368,  4370,  4446,  4447,  4450,  4452,
    4456,  4458,  4462,  4464,  4469,  4470,  4471,  4472,  4473,  4475,
    4477,  4479,  4487,  4489,  4491,  4493,  4495,  4497,  4499,  4501,
    4505,  4506,  4507,  4508,  4509,  4519,  4525,  4526,  4529,  4530,
    4533,  4541,  4544,  4552,  4553,  4562,  4571,  4583,  4584,  4587,
    4588,  4589,  4592,  4593,  4594,  4595,  4596,  4599,  4600,  4603,
    4604,  4605,  4606,  4607,  4608,  4611,  4613,  4620,  4636,  4638,
    4641,  4643,  4647,  4659,  4675,  4679,  4690,  4691,  4694,  4706,
    4715,  4716,  4719,  4720,  4721,  4724,  4725,  4728,  4729,  4732,
    4733,  4736,  4738,  4740,  4742,  4746,  4753,  4776,  4808,  4818,
    4825,  4865,  4867,  4874,  4876,  4877,  4882,  4880,  4895,  4894,
    4907,  4913,  4915,  4916,  4919,  4920,  4921,  4922,  4923,  4930,
    4929,  4939,  4941,  4943,  4944,  4945,  4948,  4949,  4950,  4951,
    4952,  4955,  4956,  4960,  4959,  5017,  5015,  5030,  5029,  5042,
    5048,  5049,  5052,  5054,  5055,  5058,  5059,  5060,  5061,  5064,
    5065,  5068,  5076,  5093,  5101,  5124,  5218,  5252,  5254,  5256,
    5260,  5264,  5263,  5314,  5316,  5315,  5330,  5336,  5343,  5348,
    5351,  5352,  5355,  5356,  5357,  5358,  5359,  5360,  5361,  5369,
    5377,  5380,  5381,  5382,  5383,  5384,  5385,  5393,  5401,  5402,
    5403,  5406,  5407,  5410,  5412,  5416,  5498,  5499,  5506,  5507,
    5508,  5514,  5523,  5526,  5527,  5528,  5529,  5532,  5533,  5534,
    5540,  5554,  5553,  5571,  5572,  5573,  5574,  5575,  5578,  5580,
    5584,  5585,  5592,  5597,  5599,  5600,  5603,  5604,  5607,  5614,
    5621,  5621,  5623,  5624,  5627,  5627,  5629,  5639,  5648,  5655,
    5661,  5667,  5675,  5676,  5688,  5699,  5710,  5714,  5715,  5718,
    5723,  5727,  5728,  5731,  5738,  5745,  5749,  5750,  5753,  5756,
    5760,  5761,  5764,  5771,  5772,  5773,  5774,  5775,  5776,  5777,
    5778,  5779,  5780,  5781,  5782,  5783,  5784,  5785,  5815,  5816,
    5819,  5820,  5827,  5828,  5829,  5836,  5835,  5894,  5895,  5902,
    5901,  5970,  5976,  5982,  5990,  5996,  6002,  6008,  6014,  6020,
    6026,  6032,  6038,  6049,  6050,  6053,  6054,  6055,  6056,  6057,
    6058,  6059,  6060,  6061,  6062,  6063,  6064,  6065,  6066,  6067,
    6068,  6069,  6070,  6071,  6072,  6073,  6074,  6075,  6076,  6077,
    6078,  6079,  6082,  6083,  6084,  6085,  6086,  6087,  6091,  6092,
    6093,  6094,  6095,  6096,  6097,  6100,  6114,  6115,  6116,  6117,
    6118,  6119,  6120,  6121,  6125,  6126,  6127,  6128,  6129,  6130,
    6131,  6135,  6136,  6137,  6138,  6139,  6144,  6145,  6146,  6147,
    6148,  6154,  6155,  6156,  6157,  6158,  6159,  6160,  6161,  6162,
    6165,  6166,  6167,  6168,  6171,  6172,  6173,  6174,  6177,  6178,
    6179,  6180,  6181,  6182,  6183,  6201,  6201,  6203,  6204,  6205,
    6206,  6207,  6208,  6214,  6215,  6218,  6219,  6220,  6221,  6222,
    6223,  6224,  6225,  6226,  6227,  6228,  6229,  6230,  6231,  6232,
    6233,  6234,  6235,  6236,  6237,  6238,  6239,  6240,  6241,  6242,
    6243,  6244,  6245,  6246,  6247,  6249,  6250,  6251,  6252,  6253,
    6254,  6255,  6256,  6257,  6258,  6260,  6261,  6262,  6263,  6264,
    6265,  6266,  6267,  6268,  6269,  6270,  6271,  6272,  6273,  6274,
    6275,  6276,  6277,  6278,  6279,  6280,  6281,  6282,  6283,  6284,
    6285,  6286,  6287,  6288,  6289,  6291,  6292,  6293,  6294,  6295,
    6296,  6297,  6298,  6299,  6300,  6301,  6302,  6303,  6304,  6305,
    6306,  6307,  6308,  6309,  6310,  6311,  6312,  6313,  6314,  6315,
    6316,  6317,  6318,  6320,  6321,  6323,  6324,  6325,  6326,  6327,
    6328,  6329,  6330,  6331,  6332,  6333,  6334,  6335,  6336,  6337,
    6338,  6339,  6340,  6341,  6342,  6343,  6344,  6345,  6346,  6347,
    6348,  6349,  6350,  6351,  6352,  6353,  6354,  6355,  6356,  6357,
    6358,  6359,  6360,  6361,  6362,  6363,  6364,  6365,  6366,  6367,
    6368,  6369,  6370,  6371,  6372,  6373,  6375,  6376,  6377,  6378,
    6379,  6380,  6381,  6382,  6383,  6384,  6385,  6386,  6387,  6388,
    6389,  6390,  6391,  6392,  6393,  6394,  6395,  6396,  6397,  6398,
    6399,  6400,  6401,  6402,  6403,  6404,  6405,  6406,  6407,  6408,
    6409,  6410,  6411,  6412,  6413,  6414,  6415,  6417,  6431,  6432,
    6436,  6437,  6438,  6439,  6440,  6441,  6442,  6443,  6444,  6445,
    6449,  6450,  6451,  6452,  6453,  6454,  6455,  6456,  6457,  6458,
    6459,  6460,  6461,  6462,  6463,  6464,  6465,  6466,  6467,  6468,
    6469,  6472,  6486,  6487,  6488,  6489,  6490,  6491,  6492,  6493,
    6494,  6495,  6496,  6497,  6498,  6499,  6500,  6501,  6502,  6503,
    6504,  6505,  6515,  6516,  6517,  6518,  6519,  6520,  6521,  6522,
    6523,  6524,  6525,  6526,  6527,  6528,  6529,  6530,  6531,  6532,
    6533,  6534,  6535,  6536,  6537,  6538,  6539,  6540,  6541,  6542,
    6543,  6544,  6545,  6546,  6547,  6548,  6549,  6550,  6551,  6552,
    6553,  6554,  6555,  6556,  6557,  6558,  6559,  6560,  6561,  6562,
    6563,  6564,  6565,  6566,  6567,  6568,  6569,  6570,  6571,  6572,
    6573,  6574,  6575,  6576,  6580,  6581,  6585,  6586,  6587,  6588,
    6589,  6593,  6593,  6596,  6599,  6600,  6603,  6605,  6610,  6620,
    6627,  6628,  6629,  6632,  6664,  6665,  6668,  6670,  6678,  6679,
    6680,  6684,  6685,  6689,  6690,  6693,  6694,  6697,  6698,  6699,
    6700,  6701,  6704,  6705,  6706,  6707,  6708,  6709,  6710,  6711,
    6712,  6713,  6714,  6715,  6716,  6717,  6718,  6719,  6720,  6721,
    6722,  6723,  6724,  6725,  6726,  6727,  6728,  6729,  6730,  6731,
    6732,  6733,  6734,  6735,  6736,  6737,  6738,  6739,  6740,  6741,
    6742,  6743,  6744,  6745,  6746,  6747,  6748,  6749,  6750,  6751,
    6752,  6753,  6754,  6755,  6756,  6757,  6758,  6759,  6760
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONTINUE", "SQL_COUNT", "SQL_CURRENT", "SQL_DATA", 
  "SQL_DATETIME_INTERVAL_CODE", "SQL_DATETIME_INTERVAL_PRECISION", 
  "SQL_DESCRIBE", "SQL_DESCRIPTOR", "SQL_DISCONNECT", "SQL_ENUM", 
  "SQL_FOUND", "SQL_FREE", "SQL_GO", "SQL_GOTO", "SQL_IDENTIFIED", 
  "SQL_INDICATOR", "SQL_KEY_MEMBER", "SQL_LENGTH", "SQL_LONG", "SQL_NAME", 
  "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN", "SQL_OUTPUT", 
  "SQL_REFERENCE", "SQL_RETURNED_LENGTH", "SQL_RETURNED_OCTET_LENGTH", 
  "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", "SQL_SIGNED", "SQL_SQL", 
  "SQL_SQLERROR", "SQL_SQLPRINT", "SQL_SQLWARNING", "SQL_START", 
  "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", "SQL_VALUE", "SQL_VAR", 
  "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", "S_CONST", 
  "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", "S_INC", 
  "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", "S_NEQUAL", 
  "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", "S_VOLATILE", 
  "S_TYPEDEF", "TYPECAST", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", 
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", 
  "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION", 
  "ASSIGNMENT", "ASYMMETRIC", "AT", "AUTHORIZATION", "BACKWARD", "BEFORE", 
  "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT", "BOOLEAN_P", "BOTH", 
  "BY", "CACHE", "CALLED", "CASCADE", "CASCADED", "CASE", "CAST", "CHAIN", 
  "CHAR_P", "CHARACTER", "CHARACTERISTICS", "CHECK", "CHECKPOINT", 
  "CLASS", "CLOSE", "CLUSTER", "COALESCE", "COLLATE", "COLUMN", "COMMENT", 
  "COMMIT", "COMMITTED", "CONCURRENTLY", "CONNECTION", "CONSTRAINT", 
  "CONSTRAINTS", "CONVERSION_P", "CONVERT", "COPY", "CREATE", "CREATEDB", 
  "CREATEROLE", "CREATEUSER", "CROSS", "CSV", "CURRENT_DATE", 
  "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", 
  "CURSOR", "CYCLE", "DATABASE", "DAY_P", "DEALLOCATE", "DEC", 
  "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", 
  "DEFINER", "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", "DISABLE_P", 
  "DISTINCT", "DO", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", 
  "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ESCAPE", "EXCEPT", 
  "EXCLUSIVE", "EXCLUDING", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", 
  "EXTRACT", "FALSE_P", "FETCH", "FIRST_P", "FLOAT_P", "FOR", "FORCE", 
  "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "GET", 
  "GLOBAL", "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", 
  "HAVING", "HEADER_P", "HOLD", "HOUR_P", "IF_P", "ILIKE", "IMMEDIATE", 
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX", 
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INNER_P", "INOUT", 
  "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P", "INTEGER", 
  "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", "ISOLATION", 
  "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", "LARGE_P", "LAST_P", 
  "LEADING", "LEAST", "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", 
  "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "LOGIN_P", 
  "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", "MONTH_P", "MOVE", 
  "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEW", "NEXT", "NO", 
  "NOCREATEDB", "NOCREATEROLE", "NOCREATEUSER", "NOINHERIT", "NOLOGIN_P", 
  "NONE", "NOSUPERUSER", "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", 
  "NULL_P", "NULLIF", "NUMERIC", "OBJECT_P", "OF", "OFF", "OFFSET", 
  "OIDS", "OLD", "ON", "ONLY", "OPERATOR", "OPTION", "OR", "ORDER", 
  "OUT_P", "OUTER_P", "OVERLAPS", "OVERLAY", "OWNED", "OWNER", "PARTIAL", 
  "PASSWORD", "PLACING", "POSITION", "PRECISION", "PRESERVE", "PREPARE", 
  "PREPARED", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", 
  "QUOTE", "READ", "REAL", "REASSIGN", "RECHECK", "REFERENCES", "REINDEX", 
  "RELATIVE_P", "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "RESET", 
  "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", "RIGHT", 
  "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", "SCHEMA", 
  "SCROLL", "SECOND_P", "SECURITY", "SELECT", "SEQUENCE", "SERIALIZABLE", 
  "SESSION", "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR", 
  "SIMPLE", "SMALLINT", "SOME", "STABLE", "START", "STATEMENT", 
  "STATISTICS", "STDIN", "STDOUT", "STORAGE", "STRICT_P", "SUBSTRING", 
  "SUPERUSER_P", "SYMMETRIC", "SYSID", "SYSTEM_P", "TABLE", "TABLESPACE", 
  "TEMP", "TEMPLATE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TO", 
  "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", 
  "TRUNCATE", "TRUSTED", "TYPE_P", "UNCOMMITTED", "UNENCRYPTED", "UNION", 
  "UNIQUE", "UNKNOWN", "UNLISTEN", "UNTIL", "UPDATE", "USER", "USING", 
  "VACUUM", "VALID", "VALIDATOR", "VALUES", "VARCHAR", "VARYING", 
  "VERBOSE", "VIEW", "VOLATILE", "WHEN", "WHERE", "WITH", "WITHOUT", 
  "WORK", "WRITE", "YEAR_P", "ZONE", "WITH_CASCADED", "WITH_LOCAL", 
  "WITH_CHECK", "IDENT", "SCONST", "Op", "CSTRING", "CVARIABLE", 
  "CPP_LINE", "IP", "BCONST", "XCONST", "DOLCONST", "ICONST", "PARAM", 
  "FCONST", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", 
  "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "';'", "'{'", 
  "'}'", "\"=\"", "','", "':'", "$accept", "prog", "statements", 
  "statement", "opt_at", "stmt", "CreateRoleStmt", "opt_with", 
  "OptRoleList", "CreateUserStmt", "AlterRoleStmt", "AlterRoleSetStmt", 
  "AlterUserStmt", "DropRoleStmt", "DropUserStmt", "CreateGroupStmt", 
  "AlterGroupStmt", "add_drop", "DropGroupStmt", "CreateSchemaStmt", 
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt", 
  "set_rest", "var_name", "var_list_or_default", "var_list", "iso_level", 
  "var_value", "opt_boolean", "zone_value", "opt_encoding", 
  "ColId_or_Sconst", "VariableShowStmt", "VariableResetStmt", 
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode", 
  "CheckPointStmt", "AlterTableStmt", "alter_table_cmds", 
  "alter_table_cmd", "alter_rel_cmds", "alter_rel_cmd", 
  "alter_column_default", "opt_drop_behavior", "alter_using", 
  "ClosePortalStmt", "CopyStmt", "copy_from", "copy_file_name", 
  "copy_opt_list", "copy_opt_item", "opt_binary", "opt_oids", 
  "copy_delimiter", "opt_using", "CreateStmt", "OptTemp", 
  "OptTableElementList", "TableElementList", "TableElement", "columnDef", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption", 
  "TableConstraint", "ConstraintElem", "opt_column_list", "columnList", 
  "columnElem", "key_match", "key_actions", "key_delete", "key_update", 
  "key_action", "OptInherit", "OptWith", "OnCommitOption", 
  "OptTableSpace", "OptConsTableSpace", "CreateAsStmt", "@1", 
  "OptCreateAs", "CreateAsList", "CreateAsElement", "CreateSeqStmt", 
  "AlterSeqStmt", "OptSeqList", "OptSeqElem", "opt_by", "CreatePLangStmt", 
  "opt_trusted", "handler_name", "opt_validator", "opt_lancompiler", 
  "DropPLangStmt", "opt_procedural", "CreateTableSpaceStmt", 
  "OptTableSpaceOwner", "DropTableSpaceStmt", "CreateTrigStmt", 
  "TriggerActionTime", "TriggerEvents", "TriggerOneEvent", 
  "TriggerForSpec", "TriggerForOpt", "TriggerForType", "TriggerFuncArgs", 
  "TriggerFuncArg", "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition", 
  "def_list", "def_elem", "def_arg", "aggr_args", "aggr_args_list", 
  "old_aggr_definition", "old_aggr_list", "old_aggr_elem", 
  "CreateOpClassStmt", "opclass_item_list", "opclass_item", "opt_default", 
  "opt_recheck", "DropOpClassStmt", "DropOwnedStmt", "ReassignOwnedStmt", 
  "DropStmt", "drop_type", "any_name_list", "any_name", "attrs", 
  "TruncateStmt", "FetchStmt", "fetch_direction", "from_in", 
  "CommentStmt", "comment_type", "comment_text", "GrantStmt", 
  "RevokeStmt", "privileges", "privilege_list", "privilege", 
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option", 
  "function_with_argtypes_list", "function_with_argtypes", 
  "GrantRoleStmt", "RevokeRoleStmt", "opt_grant_admin_option", 
  "opt_granted_by", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "arg_class", "func_as", "param_name", "func_return", 
  "func_type", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "opt_definition", "AlterFunctionStmt", 
  "alterfunc_opt_list", "opt_restrict", "RemoveFuncStmt", 
  "RemoveAggrStmt", "RemoveOperStmt", "oper_argtypes", "any_operator", 
  "CreateCastStmt", "cast_context", "DropCastStmt", "opt_if_exists", 
  "ReindexStmt", "reindex_type", "opt_force", "RenameStmt", "opt_column", 
  "AlterObjectSchemaStmt", "AlterOwnerStmt", "RuleStmt", "@2", 
  "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", "CreateConversionStmt", 
  "ClusterStmt", "VacuumStmt", "AnalyzeStmt", "analyze_keyword", 
  "opt_verbose", "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "InsertStmt", "insert_rest", 
  "insert_column_list", "insert_column_item", "returning_clause", 
  "DeleteStmt", "using_clause", "LockStmt", "opt_lock", "lock_type", 
  "opt_nowait", "UpdateStmt", "set_clause_list", "set_clause", 
  "single_set_clause", "multiple_set_clause", "set_target", 
  "set_target_list", "DeclareCursorStmt", "cursor_options", "opt_hold", 
  "SelectStmt", "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "select_limit_value", "select_offset_value", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "for_locking_items", "for_locking_item", "locked_rels_list", 
  "values_clause", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "relation_expr_opt_alias", "func_table", 
  "where_clause", "TableFuncElementList", "TableFuncElement", "Typename", 
  "opt_array_bounds", "Iresult", "SimpleTypename", "ConstTypename", 
  "GenericType", "Numeric", "opt_float", "opt_numeric", "opt_decimal", 
  "Bit", "ConstBit", "BitWithLength", "BitWithoutLength", "Character", 
  "ConstCharacter", "CharacterWithLength", "CharacterWithoutLength", 
  "character", "opt_varying", "opt_charset", "ConstDatetime", 
  "ConstInterval", "opt_timezone", "opt_interval", "a_expr", "b_expr", 
  "c_expr", "func_expr", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "extract_list", "type_list", 
  "array_expr_list", "array_expr", "extract_arg", "overlay_list", 
  "overlay_placing", "position_list", "substr_list", "substr_from", 
  "substr_for", "trim_list", "in_expr", "case_expr", "when_clause_list", 
  "when_clause", "case_default", "case_arg", "columnref", 
  "indirection_el", "indirection", "opt_indirection", "opt_asymmetric", 
  "ctext_expr", "ctext_expr_list", "ctext_row", "target_list", 
  "target_el", "relation_name", "qualified_name_list", "qualified_name", 
  "name_list", "name", "database_name", "access_method", "attr_name", 
  "index_name", "file_name", "func_name", "AexprConst", "Iconst", 
  "Fconst", "Bconst", "Xconst", "Sconst", "PosIntConst", "IntConst", 
  "IntConstVar", "AllConstVar", "StringConst", "PosIntStringConst", 
  "NumConst", "AllConst", "PosAllConst", "RoleId", "SpecialRuleRelation", 
  "ECPGConnect", "connection_target", "opt_database_name", "db_prefix", 
  "server", "opt_server", "server_name", "opt_port", 
  "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "ECPGCursorStmt", "ECPGDeallocate", 
  "ECPGVarDeclaration", "single_vt_declaration", "single_var_declaration", 
  "@3", "@4", "precision", "opt_scale", "ecpg_interval", 
  "ECPGDeclaration", "@5", "sql_startdeclare", "sql_enddeclare", 
  "var_type_declarations", "vt_declarations", "variable_declarations", 
  "type_declaration", "@6", "var_declaration", "@7", "@8", 
  "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@9", "struct_union_type", "@10", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "ECPGExecute", "@11", 
  "execute_rest", "execstring", "prepared_name", "ECPGFree", "ECPGOpen", 
  "opt_ecpg_using", "ecpg_using", "using_descriptor", "into_descriptor", 
  "opt_sql", "ecpg_into", "using_list", "UsingConst", "ECPGPrepare", 
  "ECPGDescribe", "opt_output", "ECPGAllocateDescr", 
  "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "desc_header_item", "ECPGGetDescriptor", 
  "ECPGGetDescItems", "ECPGGetDescItem", "ECPGSetDescriptor", 
  "ECPGSetDescItems", "ECPGSetDescItem", "descriptor_item", 
  "ECPGSetAutocommit", "on_off", "ECPGSetConnection", "ECPGTypedef", 
  "@12", "opt_reference", "ECPGVar", "@13", "ECPGWhenever", "action", 
  "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ECPGColId", "ColId", "type_name", 
  "function_name", "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", 
  "ECPGCKeywords", "unreserved_keyword", "ECPGunreserved_interval", 
  "ECPGunreserved", "ECPGunreserved_con", "col_name_keyword", 
  "func_name_keyword", "reserved_keyword", "into_list", "ecpgstart", 
  "c_args", "coutputvariable", "civarind", "civar", "indicator", 
  "cvariable", "ident", "quoted_ident_stringvar", "c_stuff_item", 
  "c_stuff", "c_list", "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,    61,    60,    62,   689,    43,    45,
      42,    47,    37,    94,   690,    91,    93,    40,    41,    46,
      59,   123,   125,   691,    44,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   456,   457,   458,   458,   459,   459,   459,   459,   459,
     459,   459,   459,   460,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   462,   463,   463,   464,
     464,   464,   464,   464,   464,   464,   464,   464,   464,   464,
     464,   464,   464,   464,   464,   464,   464,   464,   464,   464,
     464,   465,   466,   467,   467,   468,   467,   467,   469,   469,
     470,   470,   471,   472,   473,   473,   474,   474,   475,   475,
     476,   476,   477,   477,   478,   478,   478,   478,   478,   478,
     479,   479,   479,   480,   480,   480,   480,   480,   480,   480,
     480,   480,   481,   481,   482,   482,   483,   483,   484,   484,
     484,   484,   485,   485,   485,   486,   486,   486,   486,   487,
     487,   487,   487,   487,   487,   488,   488,   488,   489,   489,
     490,   490,   490,   490,   490,   491,   491,   491,   491,   491,
     492,   493,   493,   494,   494,   495,   496,   496,   497,   497,
     498,   498,   498,   498,   498,   498,   498,   498,   498,   498,
     498,   498,   498,   498,   498,   498,   498,   498,   498,   498,
     498,   498,   499,   499,   500,   500,   500,   500,   501,   501,
     502,   502,   502,   503,   503,   504,   505,   505,   506,   506,
     507,   507,   507,   508,   508,   509,   509,   509,   509,   509,
     509,   509,   509,   509,   509,   510,   510,   511,   511,   512,
     512,   513,   513,   514,   514,   515,   515,   515,   515,   515,
     515,   515,   516,   516,   517,   517,   518,   518,   518,   519,
     520,   520,   521,   521,   521,   522,   522,   522,   522,   522,
     522,   522,   523,   523,   523,   523,   524,   525,   525,   526,
     526,   526,   526,   526,   526,   527,   527,   528,   528,   528,
     528,   529,   529,   530,   530,   531,   532,   532,   532,   533,
     533,   533,   533,   533,   534,   535,   536,   536,   536,   536,
     536,   537,   537,   538,   538,   538,   538,   539,   539,   539,
     539,   540,   540,   541,   541,   543,   542,   544,   544,   545,
     545,   546,   547,   548,   549,   549,   550,   550,   550,   550,
     550,   550,   550,   550,   550,   550,   550,   551,   551,   552,
     552,   553,   553,   554,   554,   555,   555,   556,   556,   557,
     557,   558,   558,   559,   560,   560,   561,   561,   562,   562,
     563,   563,   564,   564,   564,   565,   565,   565,   566,   566,
     567,   567,   568,   568,   569,   569,   569,   570,   570,   571,
     571,   572,   572,   572,   572,   573,   573,   574,   574,   575,
     575,   576,   577,   578,   578,   578,   578,   578,   578,   579,
     580,   580,   581,   581,   582,   582,   582,   582,   582,   583,
     583,   584,   584,   585,   586,   586,   587,   588,   589,   589,
     590,   590,   590,   590,   591,   591,   592,   592,   593,   593,
     594,   595,   596,   596,   597,   597,   597,   597,   597,   597,
     597,   597,   598,   598,   599,   599,   600,   600,   601,   602,
     602,   602,   602,   602,   602,   602,   602,   602,   602,   603,
     603,   603,   603,   603,   603,   603,   603,   603,   603,   603,
     603,   603,   603,   604,   604,   605,   605,   605,   605,   605,
     605,   605,   605,   605,   605,   605,   606,   606,   606,   606,
     606,   606,   606,   606,   606,   606,   606,   606,   607,   607,
     608,   609,   609,   610,   610,   610,   611,   611,   612,   612,
     612,   612,   613,   613,   613,   613,   613,   613,   613,   613,
     614,   614,   615,   615,   616,   616,   617,   617,   618,   619,
     620,   621,   621,   622,   622,   623,   623,   624,   624,   625,
     625,   626,   626,   627,   627,   627,   628,   628,   628,   629,
     629,   630,   630,   631,   631,   632,   632,   633,   633,   633,
     633,   633,   634,   634,   634,   634,   635,   635,   636,   637,
     637,   638,   638,   639,   639,   640,   640,   640,   640,   640,
     640,   640,   640,   640,   640,   641,   641,   641,   642,   642,
     643,   644,   644,   645,   645,   646,   646,   647,   647,   648,
     648,   649,   649,   649,   649,   650,   650,   651,   651,   652,
     652,   653,   654,   654,   655,   655,   655,   656,   656,   657,
     657,   658,   658,   658,   658,   658,   658,   658,   658,   658,
     658,   658,   658,   658,   658,   659,   659,   660,   660,   660,
     660,   660,   660,   661,   661,   661,   661,   661,   661,   661,
     661,   661,   661,   663,   662,   664,   664,   664,   665,   665,
     666,   666,   666,   666,   666,   667,   667,   668,   668,   668,
     668,   669,   669,   669,   670,   670,   671,   672,   673,   673,
     674,   674,   674,   674,   674,   674,   674,   674,   674,   674,
     674,   674,   674,   674,   675,   675,   675,   676,   676,   676,
     677,   677,   677,   678,   678,   679,   679,   680,   680,   680,
     680,   681,   682,   682,   683,   683,   684,   684,   684,   684,
     684,   684,   684,   684,   684,   684,   684,   685,   685,   686,
     687,   687,   688,   688,   689,   690,   690,   691,   692,   692,
     692,   692,   692,   693,   693,   694,   695,   695,   695,   696,
     696,   696,   697,   697,   698,   698,   699,   699,   700,   700,
     701,   701,   702,   702,   703,   704,   704,   704,   704,   704,
     705,   705,   706,   707,   707,   707,   708,   708,   709,   710,
     710,   711,   712,   712,   713,   714,   714,   715,   715,   715,
     715,   715,   715,   715,   715,   716,   716,   717,   718,   718,
     719,   719,   720,   721,   722,   723,   723,   724,   725,   725,
     725,   725,   725,   726,   726,   726,   727,   727,   728,   728,
     729,   729,   729,   729,   730,   730,   731,   731,   731,   731,
     731,   732,   732,   732,   733,   733,   733,   733,   733,   733,
     733,   733,   734,   734,   735,   735,   736,   736,   736,   736,
     737,   737,   738,   739,   739,   740,   740,   740,   740,   741,
     741,   741,   741,   741,   742,   742,   743,   743,   744,   745,
     745,   746,   746,   747,   747,   748,   748,   749,   749,   750,
     750,   751,   751,   752,   752,   753,   753,   754,   754,   755,
     755,   755,   755,   755,   755,   755,   755,   755,   755,   755,
     756,   756,   756,   756,   756,   756,   757,   757,   757,   757,
     758,   758,   758,   758,   759,   759,   760,   760,   761,   761,
     761,   761,   762,   762,   762,   763,   764,   764,   765,   765,
     766,   767,   767,   767,   767,   768,   768,   768,   769,   769,
     769,   769,   769,   769,   769,   769,   769,   770,   770,   770,
     770,   770,   770,   770,   770,   771,   771,   771,   771,   771,
     772,   773,   773,   773,   773,   773,   773,   773,   773,   773,
     773,   773,   774,   774,   775,   775,   775,   776,   776,   776,
     777,   777,   778,   778,   779,   780,   781,   781,   782,   782,
     783,   784,   785,   785,   785,   785,   785,   785,   786,   786,
     787,   787,   788,   788,   788,   788,   789,   790,   790,   790,
     791,   791,   791,   791,   791,   791,   791,   791,   791,   791,
     791,   791,   791,   791,   792,   792,   792,   792,   792,   792,
     792,   792,   792,   792,   792,   792,   792,   792,   792,   792,
     792,   792,   792,   792,   792,   792,   792,   792,   792,   792,
     792,   792,   792,   792,   792,   792,   792,   792,   792,   792,
     792,   792,   792,   792,   792,   792,   792,   792,   792,   792,
     792,   792,   792,   792,   792,   792,   792,   792,   792,   793,
     793,   793,   793,   793,   793,   793,   793,   793,   793,   793,
     793,   793,   793,   793,   793,   793,   793,   793,   794,   794,
     794,   794,   794,   794,   794,   794,   794,   794,   794,   795,
     795,   795,   795,   795,   795,   795,   795,   795,   795,   795,
     795,   795,   795,   795,   795,   795,   795,   795,   795,   795,
     795,   795,   795,   795,   795,   795,   795,   795,   795,   795,
     795,   795,   795,   796,   796,   796,   797,   797,   797,   798,
     798,   799,   799,   799,   799,   799,   799,   799,   799,   799,
     800,   800,   801,   801,   802,   802,   802,   802,   802,   802,
     803,   803,   804,   804,   805,   805,   806,   806,   807,   807,
     808,   808,   808,   808,   808,   808,   808,   808,   809,   809,
     810,   811,   811,   812,   812,   812,   812,   812,   812,   813,
     814,   815,   815,   815,   816,   816,   817,   818,   818,   819,
     820,   820,   821,   821,   822,   822,   823,   823,   823,   823,
     824,   824,   825,   825,   826,   826,   827,   827,   828,   828,
     829,   830,   830,   831,   831,   831,   832,   832,   833,   833,
     834,   834,   835,   835,   836,   837,   838,   839,   840,   841,
     842,   842,   843,   843,   843,   843,   843,   843,   843,   843,
     844,   845,   846,   847,   848,   848,   849,   849,   850,   850,
     851,   851,   852,   852,   852,   852,   852,   853,   853,   854,
     854,   854,   855,   855,   855,   855,   855,   856,   856,   857,
     857,   857,   857,   857,   857,   858,   859,   859,   860,   860,
     860,   860,   861,   861,   861,   861,   862,   862,   863,   864,
     865,   865,   866,   866,   866,   867,   867,   868,   868,   869,
     869,   870,   870,   870,   870,   871,   871,   872,   873,   873,
     874,   875,   875,   876,   877,   877,   879,   878,   880,   878,
     878,   881,   882,   882,   883,   883,   883,   883,   883,   885,
     884,   886,   887,   888,   888,   888,   889,   889,   889,   889,
     889,   890,   890,   892,   891,   894,   893,   895,   893,   893,
     896,   896,   897,   897,   897,   898,   898,   898,   898,   899,
     899,   900,   900,   900,   900,   900,   900,   901,   901,   901,
     902,   904,   903,   905,   906,   905,   907,   907,   908,   908,
     909,   909,   910,   910,   910,   910,   910,   910,   910,   910,
     910,   911,   911,   911,   911,   911,   911,   911,   911,   911,
     911,   912,   912,   913,   913,   914,   915,   915,   916,   916,
     916,   917,   918,   919,   919,   919,   919,   920,   920,   920,
     921,   922,   921,   923,   923,   923,   923,   923,   924,   924,
     925,   925,   926,   927,   928,   928,   929,   929,   930,   931,
     932,   932,   933,   933,   934,   934,   935,   935,   936,   937,
     937,   937,   938,   938,   939,   940,   941,   942,   942,   943,
     944,   945,   945,   946,   947,   948,   949,   949,   950,   951,
     952,   952,   953,   954,   954,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   955,   955,
     956,   956,   957,   957,   957,   959,   958,   960,   960,   962,
     961,   963,   963,   963,   964,   964,   964,   964,   964,   964,
     964,   964,   964,   965,   965,   966,   966,   966,   966,   966,
     966,   966,   966,   966,   966,   966,   966,   966,   966,   966,
     966,   966,   966,   966,   966,   966,   966,   966,   966,   966,
     966,   966,   967,   967,   967,   967,   967,   967,   968,   968,
     968,   968,   968,   968,   968,   969,   970,   970,   970,   970,
     970,   970,   970,   970,   971,   971,   971,   971,   971,   971,
     971,   972,   972,   972,   972,   972,   973,   973,   973,   973,
     973,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     975,   975,   975,   975,   976,   976,   976,   976,   977,   977,
     977,   977,   977,   977,   977,   978,   978,   979,   979,   979,
     979,   979,   979,   980,   980,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   982,   982,
     982,   982,   982,   982,   982,   982,   982,   982,   982,   982,
     982,   982,   982,   982,   982,   982,   982,   982,   982,   982,
     982,   982,   982,   982,   982,   982,   982,   982,   982,   982,
     982,   982,   983,   983,   983,   983,   983,   983,   983,   983,
     983,   983,   983,   983,   983,   983,   983,   983,   983,   983,
     983,   983,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   985,   985,   986,   987,   987,   988,   988,   989,   990,
     991,   991,   991,   992,   993,   993,   994,   994,   995,   995,
     995,   996,   996,   997,   997,   998,   998,   999,   999,   999,
     999,   999,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     1,     0,     2,
       2,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     3,     2,     2,     2,     2,     3,
       3,     5,     5,     5,     4,     5,     5,     4,     3,     5,
       3,     5,     5,     6,     1,     1,     3,     5,     6,     4,
       1,     0,     2,     0,     1,     1,     1,     1,     1,     1,
       2,     3,     3,     3,     3,     3,     2,     5,     2,     2,
       3,     3,     1,     3,     1,     1,     1,     3,     2,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     6,     1,     1,     1,     1,     0,     1,     1,
       3,     4,     5,     4,     2,     2,     3,     4,     3,     2,
       4,     1,     1,     1,     1,     1,     4,     4,     1,     3,
       3,     4,     6,     6,     6,     6,     4,     6,     2,     4,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     2,
       3,     1,     1,     3,     3,     3,     2,     2,     3,     2,
       1,     1,     0,     2,     0,     2,     9,     6,     1,     1,
       1,     1,     1,     2,     0,     1,     1,     3,     3,     1,
       1,     3,     3,     3,     4,     1,     0,     2,     0,     3,
       0,     1,     0,    11,    12,     1,     1,     2,     2,     2,
       2,     0,     1,     0,     1,     3,     1,     1,     1,     3,
       2,     0,     3,     1,     1,     2,     1,     3,     4,     4,
       2,     5,     1,     2,     2,     2,     3,     2,     0,     2,
       2,     2,     2,     2,     2,     3,     1,     4,     6,     7,
      11,     3,     0,     3,     1,     1,     2,     2,     0,     1,
       1,     2,     2,     0,     3,     3,     2,     1,     1,     2,
       2,     4,     0,     2,     2,     2,     0,     3,     4,     4,
       0,     2,     0,     4,     0,     0,    11,     3,     0,     3,
       1,     1,     5,     4,     2,     0,     2,     1,     2,     3,
       2,     2,     2,     2,     3,     3,     3,     1,     0,     5,
       9,     1,     0,     1,     2,     2,     0,     2,     0,     5,
       7,     1,     0,     6,     2,     0,     3,     5,    14,    19,
       1,     1,     1,     3,     5,     1,     1,     1,     3,     0,
       1,     0,     1,     1,     1,     3,     0,     1,     1,     0,
       2,     1,     2,     1,     2,     2,     1,     2,     2,     6,
       8,     8,     3,     5,     4,     4,     4,     3,     7,     3,
       1,     3,     3,     1,     1,     1,     1,     1,     1,     3,
       3,     1,     3,     3,     1,     3,     3,    12,     1,     3,
       4,     7,     4,     2,     1,     0,     1,     0,     7,     9,
       5,     6,     6,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     2,     2,     3,     4,     5,
       4,     4,     3,     4,     3,     3,     2,     4,     2,     1,
       1,     1,     1,     2,     2,     1,     1,     1,     2,     2,
       1,     2,     2,     1,     1,     6,     7,     7,     9,     8,
       8,     6,     9,     7,    10,     7,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       7,     7,    10,     2,     1,     1,     1,     3,     1,     1,
       1,     1,     1,     2,     2,     2,     2,     2,     2,     2,
       1,     3,     1,     2,     3,     0,     1,     3,     2,     6,
       6,     3,     0,     3,     0,    13,    14,     1,     0,     2,
       0,     1,     3,     2,     2,     4,     1,     2,     0,     9,
       7,     2,     0,     3,     2,     1,     3,     3,     3,     2,
       2,     1,     1,     1,     1,     2,     1,     3,     1,     1,
       5,     1,     4,     1,     2,     4,     5,     1,     1,     1,
       1,     3,     3,     2,     2,     2,     2,     1,     2,     0,
       5,     1,     2,     1,     0,     5,     7,     5,     7,     7,
       9,     1,     3,     3,     3,     1,     3,    11,    10,     2,
       0,     9,     2,     0,     4,     4,     4,     1,     1,     1,
       0,     7,     6,     6,     7,     6,     6,     9,     6,     6,
       6,     8,     8,     6,     6,     1,     0,     7,     6,     7,
       6,     6,     6,     7,     6,     6,     6,     7,     9,     9,
       6,     6,     6,     0,    14,     1,     1,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     1,     1,
       1,     1,     1,     0,     6,     8,     2,     2,     2,     2,
       2,     3,     3,     2,     2,     2,     2,     3,     2,     5,
       4,     3,     3,     3,     1,     1,     0,     3,     2,     2,
       1,     3,     2,     1,     0,     8,    10,     2,     3,     3,
       0,     2,     5,     3,     1,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     4,     3,     3,     1,     0,     5,
       5,     4,     2,     0,     4,     3,     5,     6,     4,     6,
       6,     5,     7,     1,     0,    10,     4,     2,     1,     4,
       5,     5,     2,     4,     1,     1,     1,     0,     1,     0,
       1,     0,     3,     0,     4,     1,     1,     1,     1,     1,
       1,     0,     5,     1,     4,     2,     3,     1,     2,     2,
       0,     6,     2,     0,     5,     3,     0,     2,     2,     2,
       3,     1,     3,     1,     2,     1,     0,     7,     1,     3,
       1,     1,     3,     5,     2,     1,     3,     7,     0,     2,
       2,     2,     3,     0,     2,     2,     1,     1,     3,     3,
       1,     2,     4,     4,     1,     1,     8,     1,     4,     4,
       4,     2,     1,     0,     3,     3,     4,     4,     4,     4,
       2,     1,     1,     0,     1,     0,     1,     5,     1,     0,
       1,     0,     3,     1,     3,     3,     2,     2,     1,     4,
       4,     2,     2,     4,     1,     0,     1,     1,     1,     3,
       0,     2,     0,     1,     3,     1,     0,     1,     2,     4,
       4,     2,     0,     2,     3,     2,     0,     3,     1,     1,
       2,     1,     2,     5,     6,     5,     1,     2,     1,     4,
       3,     4,     5,     4,     5,     4,     5,     2,     4,     1,
       2,     2,     2,     1,     1,     0,     4,     2,     1,     2,
       2,     4,     1,     2,     3,     1,     2,     0,     1,     3,
       2,     2,     3,     5,     6,     3,     4,     0,     1,     3,
       3,     3,     3,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     2,     5,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     2,     2,
       2,     1,     3,     0,     5,     3,     0,     5,     3,     0,
       1,     1,     1,     1,     5,     2,     1,     1,     1,     1,
       5,     2,     2,     2,     1,     3,     3,     2,     1,     0,
       3,     0,     5,     2,     5,     2,     1,     3,     3,     0,
       1,     1,     1,     1,     1,     1,     3,     3,     3,     3,
       3,     3,     3,     0,     1,     3,     5,     2,     2,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     2,
       2,     3,     3,     2,     3,     5,     4,     6,     3,     5,
       4,     6,     4,     6,     5,     7,     2,     3,     2,     4,
       3,     4,     3,     4,     3,     4,     5,     6,     6,     7,
       6,     7,     6,     7,     3,     4,     4,     6,     2,     1,
       3,     2,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     2,     2,     5,     6,     6,     7,     1,     1,
       2,     4,     1,     1,     1,     2,     2,     2,     1,     3,
       4,     5,     5,     4,     1,     1,     4,     1,     4,     1,
       4,     1,     4,     1,     1,     1,     1,     6,     4,     4,
       4,     4,     6,     5,     5,     5,     4,     6,     4,     6,
       4,     4,     4,     4,     3,     5,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     1,     4,     1,     4,     1,     2,     1,     2,
       1,     3,     3,     0,     3,     1,     1,     3,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     3,
       2,     3,     0,     3,     3,     2,     2,     1,     0,     2,
       2,     3,     2,     1,     1,     3,     5,     2,     1,     4,
       2,     0,     1,     0,     1,     2,     2,     2,     3,     5,
       1,     2,     0,     2,     1,     0,     1,     1,     1,     3,
       3,     3,     1,     3,     1,     1,     1,     1,     1,     3,
       1,     2,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     2,     3,     6,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     1,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     5,     3,
       2,     2,     3,     7,     1,     1,     1,     0,     2,     2,
       1,     0,     1,     3,     1,     2,     0,     2,     0,     2,
       0,     1,     3,     4,     3,     1,     1,     1,     2,     0,
       7,     3,     2,     1,     1,     1,     0,     5,     0,     4,
       2,     1,     2,     0,     1,     3,     3,     3,     3,     0,
       4,     5,     5,     0,     1,     1,     1,     1,     2,     2,
       2,     1,     2,     0,     7,     0,     5,     0,     4,     2,
       2,     0,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     5,     2,     1,     3,     2,     2,
       3,     0,     5,     1,     0,     5,     2,     2,     1,     1,
       1,     2,     2,     3,     1,     2,     2,     3,     3,     4,
       2,     1,     2,     1,     1,     2,     2,     3,     1,     1,
       1,     1,     0,     1,     3,     5,     0,     2,     0,     1,
       2,     3,     2,     1,     1,     1,     0,     1,     1,     1,
       3,     0,     4,     2,     2,     1,     1,     0,     1,     1,
       1,     1,     2,     3,     0,     1,     2,     1,     4,     4,
       0,     1,     2,     1,     1,     3,     1,     1,     4,     4,
       4,     4,     1,     0,     3,     3,     4,     1,     3,     3,
       4,     1,     3,     3,     1,     6,     1,     3,     3,     6,
       1,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     4,
       1,     1,     4,     4,     3,     0,     7,     1,     0,     0,
       7,     3,     4,     3,     1,     1,     1,     2,     3,     5,
       2,     5,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     1,     0,     1,     2,     1,     2,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     2,
       3,     1,     2,     1,     3,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  2077,  2078,  2081,  2085,  2086,  2013,
    2087,  2088,  2053,  2054,  2055,  2056,  2057,  2058,  2059,  2060,
    2061,  2062,  2063,  2064,  2066,  2065,  2067,  2068,  2069,  2070,
    2071,  2072,  2073,  2074,  2076,  2075,  2090,  2091,  2079,  2080,
    2082,  2083,  2052,  2084,  2092,  2093,  2094,  2089,  2042,  1324,
    2043,    10,  1325,  1320,  1321,  2097,  2048,  2049,  2047,  2050,
    2051,  2095,  2096,  2038,  2039,  2041,    11,    12,  2040,  2098,
       4,  2044,  2045,  2046,     8,  1409,  1482,     9,  2037,  1482,
       0,  1595,  1596,  1597,     0,  1598,  1599,  1600,  1601,  1602,
    1533,  1496,     0,  1603,     0,  1604,  1605,  1606,  1607,  1608,
    1609,  1610,  1611,  1612,     0,  1613,  1614,  1615,  1616,  1481,
    1617,  1618,  1619,  1620,  1458,  1464,  1621,  1579,     0,  1438,
    1439,  1435,  1437,  1436,  1440,  1423,   756,     0,   815,   814,
       0,  1922,   756,  1923,  1888,  1924,  1889,  1890,   225,     0,
     808,  1891,     0,   756,  1892,   286,   301,  1925,  1367,     0,
    1893,  1894,     0,     0,   412,   756,     0,  1895,   831,  1896,
       0,  1897,  1926,  1927,     0,     0,  1898,  1928,  1929,  1899,
       0,  1900,  1901,  1930,  1931,  1932,  1902,  1933,  1934,     0,
       0,   903,     0,  1903,  1935,  1904,  1905,     0,  1936,  1906,
    1907,  1908,  1937,  1938,  1909,  1910,  1911,     0,  1912,     0,
       0,     0,     0,     0,  1939,   756,  1913,     0,   909,     0,
    1914,     0,  1940,  1915,     0,  1916,  1917,  1918,  1919,  1920,
     903,  1575,  1459,     0,     0,   819,     0,  1921,  1941,  2024,
    2025,     0,     0,     0,    42,    48,    24,    23,    25,    59,
      64,    39,    18,    55,    43,    91,    92,    93,    31,    27,
      22,    28,    32,    45,    33,    44,    21,    40,    58,    46,
      62,    47,    63,    34,    53,    51,    41,    56,    57,    76,
      61,    87,    67,    30,    68,    82,    69,    83,    70,    38,
      17,    80,    78,    79,    35,    54,    77,    81,    19,    20,
      84,    60,    75,    72,    88,    86,    94,    73,    49,    14,
      15,    65,    37,    16,    36,    29,    90,    26,   817,    66,
      71,    52,    74,    89,    50,    85,   877,   876,   911,   880,
     887,    96,    97,    98,     7,  1393,  1395,  1394,  1482,  1433,
    1434,  1398,  1443,  1453,  1442,  1446,  1454,  1441,  1460,     0,
     100,   102,   103,   104,   107,   108,   101,    95,    99,   106,
     112,   105,   111,   109,   110,   113,   114,   115,  1673,  1083,
    1671,  1672,  1670,  1415,     0,  1482,  1417,  1416,  1482,  1427,
    1453,     0,  1622,  1623,  1624,  1625,  1626,  1627,  1678,  1679,
    1680,  1681,  1682,  1684,  1683,  1695,  1696,  1697,  1698,  1699,
    1700,  1701,  1702,  1703,  1704,  1705,  1706,  1707,  1708,  1709,
    1710,  1711,  1712,  1713,  1714,  1715,  1649,  1716,  1717,  1718,
    1719,  1720,  1721,  1722,  1723,  1724,  1694,  1725,  1726,  1727,
    1728,  1729,  1730,  1731,  1732,  1733,  1734,  1687,  1735,  1736,
    1737,  1738,  1739,  1740,  1741,  1742,  1743,  1744,  1745,  1746,
    1747,  1748,  1749,  1750,  1752,  1751,  1753,  1754,  1755,  1756,
    1757,  1758,  1759,  1760,  1761,  1762,  1763,  1764,  1688,  1765,
    1766,  1767,  1768,  1769,  1770,  1771,  1772,  1773,  1774,  1775,
    1776,  1777,  1778,  1779,  1780,  1781,  1782,  1783,  1784,  1785,
    1786,  1787,  1788,  1789,  1790,  1791,  1792,  1689,  1793,  1794,
    1690,  1795,  1796,  1797,  1798,  1799,  1800,  1801,  1802,  1803,
    1804,  1805,  1806,  1807,  1808,  1809,  1810,  1811,  1812,  1813,
    1814,  1815,  1816,  1819,  1817,  1818,  1820,  1821,  1822,  1823,
    1824,  1825,  1826,  1827,  1828,  1829,  1830,  1831,  1832,  1833,
    1834,  1835,  1836,  1837,  1838,  1839,  1840,  1841,  1842,  1843,
    1844,  1845,  1691,  1846,  1847,  1848,  1849,  1850,  1851,  1852,
    1853,  1854,  1855,  1856,  1857,  1858,  1859,  1861,  1860,  1863,
    1862,  1864,  1865,  1866,  1867,  1367,  1868,  1869,  1870,  1871,
    1872,  1873,  1874,  1875,  1876,  1877,  1878,  1879,  1880,  1650,
    1881,  1882,  1883,  1884,  1885,  1886,  1692,  1887,  2023,  1337,
    1386,  1385,  1360,  1381,  1647,  1593,  1594,  1355,  1648,  1645,
    1685,  1686,  1693,  1646,  1338,  2019,  1644,  1532,     0,     0,
    1494,  1495,  1498,  1497,  1499,  1492,  1493,  1305,  1387,  1628,
    1629,  1630,  1631,  1633,  1632,  1634,  1942,  1943,  1944,  1945,
    1946,  1947,  1948,  1949,  1950,  1951,  1952,  1953,  1663,  1954,
    1955,  1956,  1957,  1958,  1959,  1962,  1960,  1961,  1963,  1964,
    1965,  1966,  1967,  1968,  1969,  1970,  1971,  1972,  1973,  1974,
    1975,  1976,  1977,  1978,  1979,  1980,  1664,  1665,  1981,  1982,
    1983,  1984,  1985,  1986,  1987,  1988,  1989,  1990,  1991,  1992,
    1993,  1994,  1995,  1996,  1997,  1998,  1999,  2000,  2001,  2002,
    2003,  1667,  2004,  2005,  1666,  2006,  2007,  2008,  2009,  2010,
       0,  1448,  1677,  1662,  1449,  1635,  1674,  1661,  1668,  1669,
    1676,  1675,  1512,  1304,  1514,  1456,  1466,  1462,  1470,  1465,
       0,     0,     0,     0,  1482,   755,   754,   740,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    13,     0,   764,   265,  1357,
    1356,  1300,   807,     0,  1296,  1297,   412,     0,   743,   285,
       0,     0,     0,     0,     0,     0,     0,   484,     0,     0,
       0,     0,     0,     0,     0,   161,     0,   296,   295,     0,
     401,     0,   597,     0,     0,   412,     0,     0,     0,  1366,
    1365,  1361,  1371,     0,  1364,  1644,     0,  1817,  1510,  1511,
    1392,  1855,   868,     0,     0,     0,   673,   500,     0,   499,
       0,     0,   497,     0,     0,   411,     0,     0,   501,   495,
     494,     0,     0,   498,     0,   496,     0,     0,   744,  1766,
    1501,   830,   817,  1696,   526,   530,   521,   527,   534,   533,
     522,   519,   520,  1829,     0,     0,     0,   516,  1326,  1328,
     525,  1327,     0,   564,   570,   569,   568,     0,   565,   566,
     571,     0,   737,  1297,   771,  1309,   902,     0,     0,   518,
     736,  1868,     0,     0,     0,   677,     0,   678,     0,  1843,
     748,   219,  1642,  1848,  1917,  1868,  1643,   215,  1640,   182,
    1641,  1637,  1638,  1639,  1636,     0,     0,   565,     0,   745,
     746,   908,   906,     0,     0,     0,     0,  1725,  1787,  1796,
    1839,  1848,  1917,  1868,   170,     0,   214,  1848,  1917,  1868,
       0,   764,     0,     0,  1457,   739,   738,     0,   982,     0,
     978,   818,   821,     0,   943,   885,     0,   756,     0,     6,
     816,   812,   905,   905,     0,   905,     0,   881,     0,  1396,
    1453,  1432,  1488,  1400,     0,     0,  1478,  1474,  1471,  1479,
    1480,  1473,  1461,  1072,  1073,  1074,  1071,  1075,  1070,     0,
    1404,  1445,  1410,     0,  1420,  1419,  1418,  1425,  1488,  1429,
    2026,  2027,  1534,  1359,  1378,     0,     0,     0,     0,     0,
       0,     0,  2031,  2035,     0,  2033,  2028,  1447,  1520,  1513,
    1515,  1517,  1468,  1467,  1463,     0,     0,  1584,     0,     0,
    1585,  1586,     0,  1581,  1583,     0,  1488,     0,     0,  1647,
    1310,  1648,  1645,  1658,  1644,     0,   504,   118,     0,     0,
     504,     0,     0,     0,     0,     0,  1718,  1209,  1219,  1217,
    1218,  1211,  1212,  1213,  1216,  1214,  1215,     0,   665,  1210,
       0,   118,     0,     0,   385,     0,     0,     0,     0,   118,
       0,     0,     0,   760,   763,   741,     0,     0,  1280,  1301,
       0,     0,     0,   546,   555,   547,   552,     0,   549,     0,
       0,   557,     0,   548,   550,   551,   556,     0,   553,   554,
       0,     0,   752,   288,     0,     0,     0,     0,     0,   773,
     804,   300,   299,   118,   298,   297,     0,     0,   611,   118,
       0,   163,   415,     0,   457,   118,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1370,  1376,     0,  1368,  1535,
    1391,  1491,     0,   843,  1765,     0,   452,     0,     0,  1765,
     795,  1765,     0,  1765,   156,  1302,     0,     0,     0,     0,
    1765,   148,  1765,     0,  1765,   416,  1765,     0,  1765,   150,
       0,  1765,   262,   502,  1509,  1508,  1500,  1507,     0,   523,
     532,   531,   529,   528,   524,  1329,     0,   514,   515,  1520,
    1523,   512,     0,   563,     0,     0,     0,     0,   846,  1298,
       0,   751,     0,     0,   680,   680,   680,   747,   218,   216,
       0,     0,     0,     0,     0,   753,     0,     0,     0,  1888,
    1889,  1031,  1273,     0,  1649,  1890,  1891,  1892,  1174,  1183,
    1175,  1177,  1184,  1893,  1894,  1744,  1895,  1896,  1317,  1897,
    1898,  1021,  1900,  1901,  1902,  1179,  1181,  1903,  1904,     0,
    1318,  1906,  1907,  1811,  1909,  1910,  1912,  1913,  1185,  1915,
    1916,  1917,  1918,  1919,  1920,  1316,     0,  1186,  1921,  1220,
    1322,  1323,  1282,     0,     0,  1295,     0,  1164,     0,  1015,
    1017,  1018,  1042,  1043,  1019,  1048,  1049,  1061,  1016,     0,
    1294,  1084,  1163,  1168,     0,  1162,  1158,   893,  1292,  1274,
       0,  1159,  1351,  1350,  1352,  1353,  1349,  1312,  1647,  1654,
    1020,  1648,  1645,  1319,  1354,  2019,  1644,     0,     0,     0,
       0,     0,  1574,   221,     0,   222,  1848,   171,   206,   178,
     205,   179,   209,   208,     0,  1716,   172,     0,   176,     0,
       0,     0,     0,     0,   210,   742,   262,     0,     0,   980,
       0,   983,     0,   979,   820,   817,  1287,  1286,  1288,     0,
     879,   878,     5,   823,   904,     0,     0,     0,     0,     0,
       0,     0,   936,   925,   933,   937,   944,  1488,  1489,     0,
    1483,     0,  1482,  1482,  1476,  1475,  1472,     0,     0,     0,
       0,     0,     0,  1343,  1342,  1401,  1403,  1346,     0,  1488,
       0,     0,  1380,     0,  1384,  1382,  1520,  1529,  1520,  1530,
    1531,  2029,     0,     0,  2032,  1450,     0,  1521,  1347,  1348,
    1526,     0,  1516,  1524,  1527,  1469,  1482,  1592,     0,  1587,
    1590,     0,  1582,     0,  1311,     0,     0,     0,     0,     0,
     505,     0,     0,     0,   117,   793,   791,     0,     0,     0,
     798,     0,     0,     0,   638,     0,     0,   639,   637,   640,
     651,   654,     0,   588,   154,   155,     0,     0,     0,     0,
       0,     0,   227,   252,     0,     0,     0,     0,     0,     0,
     144,     0,     0,     0,   383,   696,   696,     0,     0,   696,
       0,     0,     0,   696,     0,   226,   228,   251,     0,     0,
       0,     0,     0,     0,     0,     0,   147,  1411,     0,   758,
     759,     0,   762,     0,  1277,  1276,  1307,  1281,   806,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   271,   272,   118,   270,     0,     0,   454,     0,  1024,
    1059,  1059,  1059,  1039,  1039,  1033,  1022,  1066,     0,  1059,
    1036,  1025,     0,  1023,  1069,  1069,  1054,     0,   997,  1007,
    1009,  1010,  1040,  1041,  1011,  1046,  1047,  1008,  1083,  1653,
    1020,  1655,  1652,  1651,     0,     0,   803,     0,     0,   485,
       0,   455,     0,     0,     0,   159,     0,     0,   421,   420,
       0,     0,   456,     0,   385,   378,   342,     0,     0,  1724,
       0,  1308,     0,     0,  1374,  1369,  1372,     0,  1362,  1376,
     869,   873,   870,     0,   871,     0,   987,     0,   262,   672,
       0,     0,     0,   262,     0,     0,  1765,     0,     0,     0,
     262,     0,     0,     0,     0,     0,     0,     0,     0,   262,
       0,   260,   261,     0,   493,  1502,  1505,  1506,     0,   824,
     826,   828,   827,   829,   825,   513,   510,   511,     0,  1522,
    2011,  2017,     0,  1536,  1537,     0,  1734,  1759,  1781,  1844,
    1846,     0,  1864,     0,   572,   592,   567,     0,     0,   840,
     833,     0,     0,   856,   517,  1528,     0,   679,   676,   675,
     674,   217,   183,     0,     0,   594,  1843,   750,     0,     0,
    1166,  1167,  1058,  1045,  1272,     0,     0,  1053,  1052,     0,
       0,     0,     0,     0,  1029,  1028,  1027,  1165,  1233,     0,
    1026,     0,     0,     0,     0,  1059,  1059,  1057,  1103,     0,
       0,  1030,     0,     0,  1252,     0,  1258,     0,     0,     0,
    1065,     0,  1063,     0,     0,  1138,  1160,  1087,  1088,  1650,
    1164,  1230,     0,  1313,     0,     0,  1051,     0,  1083,     0,
       0,     0,     0,  1285,  1228,     0,     0,  1116,  1226,     0,
    1118,     0,     0,     0,  1220,  1219,  1217,  1218,  1211,  1212,
    1213,  1216,  1214,  1215,  1224,  1100,     0,  1099,  1520,     0,
     946,   892,  1275,     0,     0,  2018,  2020,  1571,  1570,  1569,
    1568,  1544,     0,  1540,  1541,     0,  1572,  1573,   223,   224,
     220,     0,   181,   180,     0,   203,   204,   175,     0,   199,
     200,   185,   196,   198,   197,   195,   173,   184,   186,   192,
     193,   194,   174,   213,   211,     0,   508,  1482,     0,   984,
       0,   946,   858,   860,   861,     0,  1282,   809,  1290,     0,
       0,   813,   885,   890,   884,   889,   912,   913,   918,   888,
       0,   942,   942,   927,   921,   926,   922,   928,   935,   883,
     924,   882,     0,   938,     0,  1490,  1399,  1488,   997,  1482,
    1421,  1482,  1477,  1407,  1077,  1078,  1079,  1080,  1082,  1081,
    1408,  1405,  1076,  1406,  1345,  1344,     0,     0,     0,     0,
    1428,  1377,     0,  1358,  1383,  2030,  2036,  2034,     0,     0,
     997,  2014,  1588,  2014,   997,     0,     0,   471,     0,     0,
       0,     0,     0,   506,     0,     0,     0,   790,   789,     0,
       0,     0,     0,     0,   801,   336,     0,   259,     0,     0,
       0,     0,     0,     0,     0,     0,   643,   644,   653,   652,
     650,   622,   624,   623,   614,     0,   615,     0,     0,   621,
     631,  1659,  1020,   628,  1660,  1657,  1656,     0,     0,     0,
       0,     0,     0,     0,   257,     0,   256,     0,     0,     0,
       0,     0,   661,   666,   143,     0,     0,   127,   129,     0,
       0,   125,   131,   128,   130,   126,   132,   124,     0,     0,
     123,     0,     0,     0,     0,   142,     0,     0,     0,     0,
     387,   398,     0,     0,     0,     0,   118,   118,   384,   695,
     238,     0,     0,     0,     0,     0,     0,     0,   249,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   146,   145,     0,     0,   191,   757,   761,  1278,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   287,   269,   268,     0,   274,     0,   474,  1651,   453,
       0,   997,     0,     0,     0,   991,  1072,  1071,  1070,     0,
    1012,  1014,     0,     0,   788,   788,   788,   788,   788,   772,
     774,   311,   152,     0,     0,   460,   463,     0,   116,   163,
     301,     0,   162,   164,   166,   167,   168,   165,   169,   414,
       0,   426,   425,   427,     0,   422,     0,   141,   382,     0,
     303,   366,     0,     0,   399,     0,     0,     0,     0,   713,
       0,  1375,     0,     0,     0,     0,   872,     0,   956,   842,
     948,   958,   949,   951,   985,  1300,     0,   840,     0,   657,
       0,   796,     0,   655,   157,  1303,     0,     0,     0,     0,
     490,   149,     0,   262,   417,     0,   262,   151,     0,   409,
     262,   503,  1503,  1504,   868,   509,     0,     0,  2016,  1330,
       0,  1331,     0,     0,   576,   575,   586,     0,   577,   578,
     574,   573,   579,     0,     0,   594,   835,     0,   837,  1282,
       0,   832,     0,   853,     0,   851,     0,  1299,   855,   844,
       0,     0,   565,     0,     0,   262,   749,  1230,     0,     0,
       0,  1236,     0,     0,  1271,  1268,     0,     0,  1230,     0,
       0,     0,     0,  1243,  1244,  1245,  1242,  1246,  1241,     0,
       0,  1247,  1240,     0,     0,     0,     0,     0,  1056,  1055,
       0,     0,     0,     0,     0,     0,     0,  1139,     0,     0,
    1204,     0,  1230,  1257,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1230,  1263,     0,  1283,  1282,     0,
       0,     0,     0,  1314,  1085,  1101,  1293,     0,  1284,     0,
       0,  1108,     0,  1264,  1134,     0,  1122,     0,  1117,     0,
    1120,  1124,  1104,  1285,  1229,     0,  1227,     0,     0,  1102,
       0,  1097,  1095,  1096,  1089,  1090,  1091,  1092,  1093,  1094,
    1098,  1208,  1206,  1207,     0,  1760,  1787,     0,   903,   903,
     891,   901,  1291,     0,   987,     0,     0,     0,  1169,     0,
    2022,  2021,     0,     0,     0,     0,     0,  1083,     0,   212,
     997,   981,   865,     0,     0,   987,     0,   864,   811,   810,
    1289,     0,     0,   916,   917,     0,   934,     0,   856,   856,
       0,     0,     0,  1397,  1484,  1431,  1452,  1422,  1455,  1402,
    1444,     0,  1426,  1379,  1518,  1525,  1578,     0,  2015,     0,
       0,   470,   469,     0,     0,     0,     0,   704,   682,   507,
     705,   683,     0,   792,     0,     0,     0,     0,     0,   262,
     799,   258,   800,   698,   706,     0,   641,   642,     0,   625,
     613,     0,     0,   620,     0,   619,  1014,     0,     0,     0,
     685,   153,   254,   690,   255,   253,   686,     0,  1306,     0,
       0,     0,   137,     0,     0,     0,     0,   120,   119,   138,
     136,     0,   135,     0,   710,   688,   700,   386,   397,     0,
     390,   391,   388,   392,   393,     0,     0,     0,   230,     0,
       0,   241,   247,   248,   246,   262,   262,   244,   245,   243,
     250,   689,     0,   701,   242,   240,     0,   229,   712,   694,
       0,   711,   702,   693,   189,   188,   190,     0,     0,     0,
       0,     0,     0,     0,   559,   541,   558,     0,     0,     0,
     535,   290,   267,   473,     0,     0,     0,     0,   992,     0,
       0,   997,     0,     0,  1005,   998,  1006,     0,     0,     0,
       0,   788,   787,     0,     0,     0,     0,     0,   775,   797,
       0,   459,     0,     0,   342,   158,     0,     0,   413,     0,
       0,     0,   988,     0,     0,     0,     0,   302,   304,   306,
     307,   308,     0,   380,   381,     0,     0,   370,     0,   344,
     345,     0,     0,     0,     0,   600,     0,     0,     0,   649,
     647,   633,     0,  1373,  1367,   874,   875,     0,   885,     0,
     958,     0,   957,   969,     0,     0,   975,   973,     0,   975,
       0,   975,     0,   950,     0,   952,   969,  1301,   986,   841,
     262,     0,   262,     0,   262,     0,   262,     0,   734,     0,
     449,   262,   492,     0,  1519,  2012,  1545,  1546,     0,  1538,
    1539,     0,   588,     0,   585,   580,   582,     0,   589,     0,
       0,   838,   839,   854,   847,   849,   848,     0,     0,   845,
     491,     0,   262,     0,   590,   907,     0,  1238,  1239,     0,
       0,     0,     0,  1267,     0,     0,  1200,     0,  1198,  1176,
    1178,  1038,     0,  1188,     0,  1032,  1201,  1202,  1180,  1182,
       0,  1035,     0,  1221,     0,     0,  1189,  1141,     0,     0,
       0,     0,  1220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1153,  1152,  1190,  1203,     0,     0,  1255,  1256,
    1191,  1067,  1068,  1069,  1069,     0,     0,  1262,     0,     0,
       0,  1196,  1161,  1231,  1060,  1061,     0,     0,     0,     0,
       0,     0,     0,     0,  1123,  1119,     0,  1121,  1125,     0,
       0,     0,     0,  1110,  1135,  1106,     0,     0,  1112,     0,
    1136,   903,   903,   903,   903,   900,     0,     0,   945,   930,
       0,     0,  1173,  1170,  1553,  1554,  1555,  1556,  1557,  1558,
    1559,  1560,  1561,  1562,  1564,  1565,  1566,  1563,  1567,  1549,
    1550,     0,  1542,  1543,   177,     0,   201,   187,  1578,     0,
       0,   859,   840,   862,   822,   914,     0,  1222,   915,   941,
     940,   939,   919,   923,   920,     0,  1486,  1412,  1577,  1580,
    1591,  1589,  1424,   472,   703,   681,   697,   788,     0,   335,
       0,     0,     0,   802,   635,     0,   616,   617,   618,     0,
     707,   684,   699,     0,     0,   663,     0,   664,   662,   133,
     121,   140,   139,   122,   134,   389,   394,   396,   395,   311,
       0,     0,     0,   231,   239,   236,     0,     0,  1279,   536,
       0,   537,   543,     0,     0,     0,     0,   545,   291,   118,
       0,   275,   279,   804,   804,     0,   280,   804,   276,   804,
     273,   475,     0,  1811,  1212,   476,   464,   467,   468,   465,
     466,     0,     0,     0,     0,   995,     0,     0,     0,     0,
       0,     0,   997,  1083,     0,     0,   783,  1339,  1340,   782,
    1341,   779,   778,   786,   785,   777,   776,   781,   780,     0,
       0,     0,   322,     0,     0,   316,     0,     0,   649,   310,
     313,   314,     0,   461,   462,     0,   301,     0,   429,   423,
     458,     0,   990,   303,   328,   362,     0,   377,     0,   364,
     363,   365,     0,   372,   341,     0,   770,   406,   403,     0,
     600,     0,     0,   645,   626,   646,     0,     0,   629,     0,
     634,   610,     0,  1389,   867,  1390,   960,   967,     0,   947,
       0,   974,   970,     0,   971,     0,     0,   972,     0,     0,
     967,     0,   658,     0,   656,     0,   488,     0,   659,   262,
     262,   410,   873,     0,     0,   587,   583,     0,     0,   560,
     591,   834,   836,   852,   850,     0,   561,   593,  1231,  1237,
    1044,     0,  1270,  1266,     0,     0,     0,  1232,     0,     0,
    1250,  1249,  1140,  1251,     0,     0,     0,  1151,  1150,  1148,
    1149,  1142,  1143,  1144,  1145,  1146,  1147,  1260,  1259,  1253,
    1254,  1064,  1062,     0,  1193,  1194,  1195,  1261,  1205,  1050,
    1083,  1086,     0,     0,  1109,  1265,  1126,     0,     0,  1235,
       0,  1105,     0,     0,     0,     0,  1114,  1221,     0,     0,
       0,     0,     0,     0,   895,   894,     0,   932,  1171,  1172,
       0,     0,     0,  1576,     0,   866,   857,     0,  1430,     0,
    1485,     0,   337,     0,     0,   649,   636,   632,     0,     0,
       0,   309,     0,     0,     0,     0,   264,   691,   692,     0,
       0,     0,   540,   539,   274,     0,     0,     0,     0,     0,
       0,     0,   446,     0,     0,   451,   441,   443,     0,     0,
       0,   993,   999,  1000,  1001,  1002,  1003,  1004,   996,  1013,
     439,   784,     0,     0,   320,   324,   325,   323,   315,   649,
     342,   374,     0,     0,     0,   431,     0,     0,   989,     0,
     326,     0,   366,   305,   379,   381,     0,     0,     0,   343,
       0,     0,     0,   765,     0,   408,   404,     0,     0,   599,
       0,     0,  1020,   649,   648,   729,   730,   727,   728,     0,
       0,  1363,   959,     0,     0,   961,     0,     0,   963,   965,
       0,     0,     0,     0,     0,  1304,   262,   262,   262,   735,
     450,     0,  1547,  1548,     0,   581,     0,  1269,  1187,  1197,
    1037,  1199,  1034,  1248,     0,     0,     0,     0,  1192,  1315,
    1132,  1130,  1127,     0,  1128,     0,     0,     0,  1111,  1107,
       0,  1113,  1137,   899,   898,   897,   896,     0,     0,   886,
    1551,     0,  1332,  1336,  1333,  1552,  1083,   863,     0,  1487,
     794,     0,   649,   374,   709,   687,   708,   232,   233,   234,
     235,     0,   237,     0,   542,   538,   266,   289,   277,   282,
       0,   283,   278,   281,   448,   447,   445,   442,   444,   994,
       0,   670,     0,     0,     0,     0,   312,   374,   348,     0,
     317,     0,   770,   303,   430,     0,     0,   424,   366,     0,
       0,   327,     0,   370,     0,   367,     0,   371,   375,     0,
       0,   767,   405,     0,   400,     0,     0,     0,     0,   601,
     608,   608,   627,  1014,   609,     0,  1388,     0,   968,   977,
       0,   964,   962,   953,     0,   955,   671,   489,   660,     0,
     584,   262,  1154,     0,     0,     0,  1129,  1234,  1133,  1131,
    1115,   929,   931,  1335,  1334,   202,  1223,     0,   374,   338,
     263,   544,   284,   670,     0,   668,   440,     0,   319,   318,
       0,   353,     0,     0,   766,   432,   433,   428,     0,   370,
     332,   330,   334,   331,   329,   333,     0,   372,   368,   369,
       0,   768,   769,   407,   805,     0,     0,   649,     0,     0,
     606,   604,   603,     0,   987,   966,     0,   954,   562,  1155,
       0,  1156,   342,   339,   667,   669,     0,   346,   347,     0,
     321,   349,   350,     0,     0,     0,   372,   361,   293,   376,
     649,   608,   372,   602,   607,   630,     0,   976,  1157,   348,
       0,     0,     0,     0,   351,     0,   352,   373,     0,     0,
       0,   477,   478,   436,   294,   372,   605,   987,   733,   353,
       0,   358,     0,   357,     0,   354,   355,     0,     0,   483,
       0,     0,   434,   437,   438,   987,   595,   732,   731,     0,
       0,     0,   356,   359,   360,     0,   487,   479,   418,     0,
     596,   715,   726,   714,   716,   724,   721,   723,   722,   720,
     340,     0,   482,   486,     0,   480,   435,     0,   725,   719,
     885,   876,     0,     0,   717,   726,   436,   487,   718,     0,
     481,   419
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    70,   232,   233,   234,  1435,  1995,   235,
     236,   237,   238,   239,   240,   241,   242,  1457,   243,   244,
    1110,  1575,  2092,   245,   914,   915,  1816,  1817,  2036,  1818,
    1819,  1807,  1319,  1321,   246,   247,   248,  1314,  1800,   249,
     250,  1485,  1486,  1462,  1487,  1440,  1634,  3272,   251,   252,
    2054,  1523,  2502,  2870,   760,  1520,  2859,  2860,   253,  1572,
    2546,  2547,  2548,  2549,  2529,  2919,  2920,  2921,  2550,  3160,
    3311,  2551,  1925,  2113,  2558,  2559,  3381,  3430,  3431,  3432,
    3475,  3162,  2557,  2943,  3168,  3300,   254,  3400,  2111,  2552,
    2553,   255,   256,  1474,  2008,  2449,   257,   785,  2947,  3175,
    3324,   258,   826,   259,  1577,   260,   261,  1580,  2104,  2105,
    3156,  3305,  3387,  3481,  3482,  3293,  3125,  3126,  3127,   262,
     263,   264,   265,  1966,  2084,  2085,  2875,  1426,  1906,  1527,
    2056,  2057,   266,  3461,  3462,   786,  3515,   267,   268,   269,
     270,   827,  1162,  3410,  1430,   271,   272,   845,   846,   273,
    1091,  2495,   274,   275,   857,  2202,   859,  1663,  2624,  2625,
    2999,  2175,  1031,   276,   277,  2185,  2205,   278,   787,  2952,
    3328,  3329,  3411,   279,   788,  1453,  1945,  1946,  1947,  2953,
    1948,  2957,  1949,  2569,  2570,  2571,  2961,   280,  1451,  1940,
     281,   282,   283,  1971,  1047,   284,  3375,   285,  1138,   286,
     878,  1678,   287,  2011,   288,   289,   290,  2572,  3503,  3517,
    3518,  3519,  3189,  3489,   291,  3505,   293,   294,   295,   747,
    1063,  1064,  1065,   296,  3173,   297,   298,  2079,  2080,  2523,
     299,   300,  1918,  2393,   301,   302,   303,  1567,   304,   305,
     306,   307,   308,   941,   932,  1345,  1841,   309,  1639,   832,
    3506,  1669,  2187,  2188,  2191,  3507,  1606,   312,  1673,  2196,
    2199,  3508,  1831,  1832,  1833,  1834,  1835,  2343,   314,  1132,
    2125,  3509,  1267,   317,   318,   319,  1780,  2320,   867,  1355,
     903,   946,   947,  1846,  1847,  1362,  1861,  1854,  1856,  3077,
    3249,  1363,  1859,  1364,  1365,  2358,   320,  2324,  2129,  2130,
    2131,  2582,  2592,  2972,  3198,  2132,   929,  2133,  2137,  2541,
    2542,  1950,  2065,  2513,  1548,  1268,  1269,  1270,  1710,  1721,
    1704,  1551,  1271,  1272,  1273,  1554,  1274,  1275,  1276,  1277,
    1693,  1746,  1278,  1279,  1730,   970,  2207,  2246,  1281,  1282,
    1283,  2314,  1774,  1049,  1284,  2877,  1776,  2265,  2229,  3060,
    2210,  1691,  2230,  2244,  2675,  2249,  2254,  2698,  2699,  2266,
    2284,  1285,  2214,  2215,  2654,  1695,  1286,  1068,  1069,  1736,
    2280,  1348,  1349,   934,  1287,  1288,  1289,  1664,   930,  3194,
    1145,   613,  2427,  1505,   753,   864,  1290,  1291,  1292,  1293,
    1294,  1295,  1296,   849,   850,  2170,  3255,  2496,  2899,  1409,
    1820,  1297,   591,   754,   321,   791,   792,   793,  1125,  1126,
    1595,  1598,  1392,  1893,   592,   593,   614,  3191,   322,   323,
     324,   325,   326,  1367,   952,  1386,  1887,   971,    74,    79,
      75,   972,   364,   365,  1869,   327,   724,  1870,  1389,   978,
    2796,   368,   329,   330,   369,   332,   701,   370,   954,   334,
     955,   335,   336,   337,   338,   962,   339,  1369,  1370,  3090,
    1371,   340,   341,   615,   616,   342,  1167,  1635,  1166,   800,
     343,   344,   999,  1000,  1001,  1180,  1648,  1181,  1412,  1413,
     345,   346,   609,   347,   348,   349,  1653,  1654,   350,  1793,
    1794,  1795,   351,  2616,  2617,   352,  2769,  2770,  2771,   353,
    1789,   354,   355,   923,  2799,   356,   720,   357,  1013,   594,
     595,   596,  1299,   704,   889,   863,  1300,  1020,   705,   359,
     707,   598,   599,   600,   601,   602,   603,  1023,   711,  1649,
      76,  2377,  1650,  1303,  1304,  1785,  1305,   606,   982,   992,
     993,  2378,   995,    77,   996
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3156
static const int yypact[] =
{
   -3156,   279, 13500, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, 16500, -3156, -3156, 35797,
     296, -3156, -3156, -3156, 33263, -3156, -3156, -3156, -3156, -3156,
     325, 38319, 15250, -3156, 52996, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, 52996, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, 36640,   710, -3156, -3156,   243, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156,   420,  4502, -3156, -3156,
   38739, -3156,    49, -3156, -3156, -3156, -3156, -3156, -3156, 52996,
   48387, -3156,   110,   492, -3156,    93,  9300, -3156, 34538, 39159,
   -3156, -3156, 53415,   177,  5526,   420, 39579, -3156,   274, -3156,
   31559, -3156, -3156, -3156,   405, 45873, -3156, -3156, -3156, -3156,
     304, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, 48387,
     983,   348, 31986, -3156, -3156, -3156, -3156, 48387, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, 39999, -3156,   503,
     485, 53834, 54253, 45454, -3156,   634, -3156, 52996,   213, 35385,
   -3156, 54672, -3156, -3156,   473, -3156, -3156, -3156, -3156, -3156,
     348, -3156, 36640, 30272, 46711,   790,   609, -3156, -3156, -3156,
   -3156,   519,  5432,   645, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,   788, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156,  1723, -3156,   435,  1724,
     752, -3156, -3156, -3156, -3156, -3156, -3156, -3156, 61772,   996,
   -3156, -3156, -3156,   812, -3156,   848, -3156, -3156, -3156,  1109,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,    36,
   -3156, -3156, -3156, -3156,  1297, 36218, -3156, -3156, 61772, -3156,
     913, 40419, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, 33688, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156,   125, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, 52996, 52996,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   10387, -3156, -3156, -3156,   961, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156,  1017, -3156,   181,  1193, -3156, -3156,
   36640,  1578,  1578,  1428, 61772, -3156, -3156, -3156, 43778, 52996,
   52996, 52996, 43778, 52996, 46711, 52996, 28555, 52996, 52996, 46711,
   46711, 52996, 52996, 52996, 52996, -3156,  1400,    80, -3156, -3156,
   -3156,   911, -3156,  1158, -3156,  1173,  2698,   983, -3156, -3156,
   48387,  1127, 43778, 52996,  1036,  1131, 52996, -3156, 52996,   919,
   52996,  1000,   769,  1204, 52996, 52996, 52996, -3156, -3156, 52996,
   -3156, 52996, -3156, 52996,   727,  1238,  1403,  1346,    53, -3156,
   -3156, -3156,  1146,  1134, -3156,  1157, 40419, 40419, -3156, -3156,
   -3156,   829, -3156, 46711, 44197, 52996,  1382, -3156, 55091, -3156,
   44616, 55510, -3156,  1200,  1490, -3156, 55929, 56348, -3156, -3156,
   -3156, 56767, 57186, -3156, 57605, -3156,  1405, 58024, -3156,   796,
   -3156, -3156,   788,  1088, -3156,   151,   -19,   208, -3156, -3156,
      34,   124,   142,  1088,   794, 48806, 52996,  1431, -3156, -3156,
   -3156, -3156, 40419,  1359, -3156, -3156, -3156,  1393,   428, -3156,
   -3156, 48387, -3156, -3156, -3156, -3156, -3156, 48387,   753, -3156,
   -3156,   983,  1509,  1608, 52996, -3156, 52996, -3156, 48387, 52996,
   -3156, -3156, -3156,  1625,  1340,  1530, -3156,  1325, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156,  1487,  1502,     7,   983,  1419,
   -3156, -3156,  1522, 19097,   316, 40419, 32413, 47130, 60957,    28,
   34538, 58443,  1395,    80, -3156,   744, -3156,  1727,  1412,  1597,
      69,    80, 48387, 62175, -3156, -3156, -3156, 26008, 58862,  1506,
    1427, -3156,  1694, 19540, -3156,  1457,  1461,   420,  1444, -3156,
   -3156, 48387,  1831,  1831,  1811,  1831,   693,   892,   609, -3156,
   -3156, -3156,  1483, -3156,  1485,  1489, -3156,   214,  1730, -3156,
   -3156, -3156, -3156,  1575,  1590,  1595,  1607, -3156,  1611,  1119,
   -3156, -3156, -3156,  1818, -3156, -3156, -3156, -3156,  1483, -3156,
   -3156, -3156, -3156, -3156,  1905,  1894, 34538, 34538,  1615,     1,
   14085, 10387, -3156, 14807,   980, -3156, -3156, -3156,   169, -3156,
   -3156, -3156,  1801, -3156, -3156,  1799, 52996, -3156,  1667, 52996,
   -3156, -3156, 59281, -3156, -3156,  1578,  1483,   911,  1594,  1616,
   -3156,  1619,  1624, -3156,  1626,   347,  1638,   550,   123,  1785,
     -64,  1697,  1645,   144,  1044,  1767, 52996, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156,  1648, -3156, -3156,
    1647,   656,   480,  1745,   -84,  2482,   909,  1806,   509,   832,
    1650,  1854,   340, -3156,    55, -3156, 21723, 29432, -3156,   911,
   48387, 43778,  1656, -3156, -3156, -3156, -3156, 43778, -3156,  1817,
    1544, -3156, 52996, -3156, -3156, -3156, -3156, 52996, -3156, -3156,
    1871, 52996, -3156,  1707,   937,  1674,  2003, 42520, 52996,  1715,
    2035, -3156, -3156,  1717, -3156, -3156, 52996,  1684,   728,  1717,
    2034,  2043,  1830,  1018,    86,  1717, 48387, 48387, 48387,  1902,
   52996, 59700, 43778, 52996, 34963, -3156,  1691,  1146, -3156, -3156,
   -3156, -3156,   811,  1748,  1966,  1594, -3156,  1969,  1710,  1976,
   -3156,  1979,  1645,  1981,  1700, -3156, 60119,  1982,  1725, 52996,
    1987,  1700,  1988,  1882,  1994, -3156,  1996,  1887,  2000,  1700,
     363,  2004,    75, -3156, -3156, -3156, -3156,    33,   749, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, 52996,  1431,  1431,   129,
   -3156, -3156,   126, -3156, 47549, 52996, 47968,    40,    14, -3156,
   52996, -3156,   796, 52996,  1997,  1997,  1997, -3156, -3156, -3156,
    1943, 52996,  2001, 47549, 52996, -3156, 60538,  1749,  1047,  1068,
    1101, -3156, 21723,  1757,    73,    73,  1758,  1762, -3156, -3156,
    1764,  1765, -3156,   977,   977,  1907,  1770,  1772, -3156,   984,
    1774, -3156,  1137,  1050,  1776,  1777,  1780,  1456,    73, 21723,
   -3156,  1783,  1222,  1784,  1786,  1789,  1203,  1793, -3156,  1265,
    1794,  1466,  1756,  1795,  1800, -3156,  1770, -3156,   215, -3156,
   -3156, -3156, -3156, 21723, 21723, -3156, 19975, -3156,   983, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156,    68, -3156,  1319,
    7116, -3156, -3156, -3156, 21723, -3156, -3156,   -25, -3156,   911,
    1816, -3156, -3156, -3156, -3156, -3156, -3156, -3156,  1430, -3156,
   -3156,  1440,  1496, -3156, -3156,   143,  1503,  1108,  1108,   305,
   38739, 38739, -3156, -3156,   894,  1760,  1139, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, 34113,  2139, -3156,  1804,    55, 30691,
   30691,  1431,  1431,  1999, -3156, -3156,   105,  2016, 48387, -3156,
   52996, -3156, 27272, -3156, -3156,   788, -3156,  8888, -3156,   878,
   -3156, -3156, -3156,  1823, -3156,   519,   519, 21723,   519,   681,
   20410, 21723,  2081,    39,  2084, -3156, -3156,  1483,  1837,  1284,
   -3156, 43359, 61369, 61369,  2049, -3156, -3156,   160,     5,  1934,
    2017,   786,   880, -3156, -3156, -3156,  1829, -3156,  2128,  1483,
    1360, 38739,  1886, 34538, -3156, -3156,  2246, -3156,  2246, -3156,
   -3156, -3156, 14565,  1281, -3156, -3156, 10387, -3156, -3156, -3156,
   -3156,  2272, -3156,  1836, -3156, -3156, 61772,  1857, 52996, -3156,
    1862,  1869, -3156, 62175,   911, 29853,   918,  1924,  1936, 36640,
    1870,  1937,  1940, 60957, -3156, -3156, -3156,    91,   138,   521,
   -3156,  1941,  2031,  1989, -3156,  2054,   659, -3156, -3156, -3156,
   -3156,  1460, 17814,   924, -3156, -3156,  1952,  1944,  1958,  1959,
    1684,   574,  1888, -3156,  1963,  1946, 41260, 28993, 60957,  3677,
   -3156,  1968,  1974,  2007,  1827,   117,  2220,  2059,  1972,  1218,
    1973, 48387,  2136,    65,   618,  1906, -3156, -3156,  1980,  1983,
   46711,  1984,  2019,  1992, 60957,  3677, -3156, -3156,  1030, -3156,
   -3156,    80, -3156,  2966, -3156, -3156, -3156, -3156, -3156,  1594,
   42520,  1645,  1119, 52996,  1927,   601,  2085, 52996,  2142,  2088,
      37, -3156, -3156,  1717, -3156, 29853,  1684, -3156,  1933, -3156,
    1977,  1977,  1977,  1935,  1935,  1938, -3156, -3156,  1456,  1977,
    1939, -3156, 42940, -3156,   897,   969, -3156,  2291,    85, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,   191, -3156,
    1638, -3156, -3156, -3156,  2304,   654, -3156, 42520,  3677,  2231,
   36640, -3156,  1985,  3677, 52996,   566, 52996,  2134, -3156, -3156,
     112,  1945, -3156,  3677, -3156,   228,  1948, 34538,  2199, 52996,
    2098, -3156,  1645,  2303, -3156, -3156,  1949,   794, -3156,  1691,
   -3156,  1196, -3156,  2056, -3156, 24302,  1990, 43778,   148, -3156,
   42520, 52996, 43778,   148, 52996, 52996,  2219,  2008, 28993, 41260,
     115, 52996, 52996, 48387, 52996, 52996, 48387, 52996,  2221,   148,
   52996, -3156, -3156, 52996, -3156, -3156,  1431,  1017, 52996, -3156,
   -3156, -3156, -3156, -3156, -3156,  1431, -3156, -3156,  2398,  1962,
   -3156,   143,   794,  1964, -3156,  1991, 52996, 43778, 52996, 52996,
   48387, 48387, 52996,  2036,  1760,   418, -3156,  2015, 26853,  2096,
   -3156,   134, 48387,  2149, -3156, -3156,   623, -3156, -3156, -3156,
   -3156, -3156, -3156, 45873,  2237,    50, 52996, -3156, 21723, 20845,
   -3156, -3156, -3156,  1993,  8888,  2025, 21723, -3156, -3156, 21723,
   21723,   794,   794,   794, -3156, -3156, -3156, -3156,  2289,   794,
   -3156, 21723, 21723,   794,   794,  1977,  1977, -3156,  5054, 21723,
     794, -3156, 28993, 21723, 22158, 17370, 21723,  2060,  2063,   794,
   -3156,   794, -3156, 21723, 18662, -3156,   911,  2362,  2362,   609,
     859,  3406,  1998, -3156,  2091,   794, -3156,   794,   664, 42520,
   21723, 36640,  2067,   119, 21723,  2006,   538, -3156, 21723,   150,
   -3156,  2009, 21723,  2069,   108, 21723, 21723, 21723, 21723, 21723,
   21723, 21723, 21723, 21723, -3156, 22593,   137,   230, 37899, 19097,
    2255, -3156,  1096, 16926, 40419, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156,   794,  2011, -3156,  2024, -3156, -3156, -3156, -3156,
   -3156,  2139, -3156, -3156,  2083, -3156, -3156, -3156,  1527, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156,  2014, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156,  1431, -3156, 61772,  2021, -3156,
   52996,    10, -3156, -3156, -3156,  2037, -3156, 46292, -3156, 19540,
   52996, -3156, -3156,  2241, -3156, -3156,  2022, -3156,  6584,  2241,
    2179,  2187,  2187, -3156,   -33,  8888,  2228,  8888, -3156, -3156,
   -3156, -3156,   800, -3156,  1363, -3156, -3156,  1483,  2033, 15662,
   -3156, 16081, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156,  1119,  2032,  2443,  1409,
   -3156, -3156, 34538, -3156, -3156, -3156, -3156, -3156, 40419,  1577,
    2033, 10387, -3156, 10387,  2033,  2039,   988, -3156,  2103,  2108,
    2148, 52996, 52996, -3156, 36640, 52996, 52996, -3156,  2361,  2050,
   52996,  2257,  2262,  2057, -3156, -3156, 52996, -3156,  2223, 21723,
    2227, 52996, 52996,  2230,   852,  2212, -3156, -3156, -3156, -3156,
   -3156,  2224, -3156, -3156, -3156,  1004, -3156, 37480, 40840, -3156,
   -3156,   239,  1638, -3156,   261,   263,   278,  2137,  2138,  2177,
   52996, 52996, 52996, 52996, -3156, 52996, -3156,   945, 52996, 52996,
    2068,  2078,  2073, -3156, -3156, 52996,  2279, -3156, -3156,  2233,
     342, -3156, -3156, -3156, -3156, -3156, -3156, -3156,   555, 52996,
   -3156,   794,  2235, 52996,  2133, -3156, 52996, 52996, 52996,  1119,
   -3156,  2428,  1119,  1119,   696,  2433,  1717,  1717, -3156, -3156,
   -3156, 52996, 52996, 52996, 49225, 52996, 52996, 49644, -3156, 48387,
   52996, 52996, 52996,   258,  2571, 52996, 52996,  2234, 52996, 52996,
   52996, -3156, -3156,   128,  2232, -3156, -3156, -3156, -3156, 21723,
    2311,  2454,  2315,  2322,  2160, 41260,   568, 52996, 52996,  2327,
     568, -3156, -3156, -3156,   937, -3156,  1011, -3156,  2131, -3156,
   21723,    90, 42520,  2141, 25140, -3156,  2196, -3156,  2198,   794,
   -3156,  1870,   112,  2333,  2150,  2150,  2150,  2150,  2150,   654,
   -3156, -3156, -3156,  2392,  1020, -3156,  2153, 48387, -3156, -3156,
    1479, 45873, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
     801, -3156, -3156, -3156,  2295,  2292, 52996, -3156,  1827, 48387,
   45035,  1473, 52996,  2497,  2386,   983,  2299, 48387,   478, -3156,
   34963, -3156,  2152,  2387,  2400,  2403, -3156, 23883, 50063,  2156,
    1517, -3156, 50063, 50482, -3156,   911, 21723,  2096,  1594, -3156,
    2519, -3156,  1645, -3156,  1700, -3156, 52996, 52996,  2166,  2167,
   -3156,  1700,  2321,   148, -3156,  2323,   148,  1700,   983, -3156,
      75, -3156, -3156, -3156, -3156, -3156, 40419,  1157, -3156, -3156,
    1157, -3156,  1157,  2606,  1700,  2164, -3156,  1645,  1700,  1700,
    1760,  1760,  1700, 50901,  2537,  2418, -3156,  1022, -3156, -3156,
   19097, -3156,    61, -3156,    81,   -30,  2359, -3156, -3156, -3156,
   52996,  2329,  2171, 50901,  2524,   148, -3156,  8888,  1055,   866,
     981, -3156,   794, 21723,    89, -3156,  7538,  1080,  6844,  1148,
    2191,  2193,  1162, -3156, -3156, -3156, -3156, -3156, -3156,  2194,
    2439, -3156, -3156,  2195,  1165,  1172,  2197,  2203, -3156, -3156,
    3272,  1206,  2206,  7703,  2211, 22158,   825, -3156, 22158,  2213,
   -3156,  1227,  6907,  2182,  2214,  2229,  2248,  2225,  2226,  7748,
   21288, 21723, 21288, 21288,  7839,  2182,  2236, -3156, -3156, 21723,
   52996,  2238,  2239, -3156, -3156,  5054, -3156,  2250, -3156, 22158,
   22158,  2188, 19975, -3156, -3156,  2448, -3156,   959, -3156,  2200,
   -3156, -3156,  3207,   122, 21723,  2006, 21723,  2290, 28993,  3930,
   21723,  4547,  5360,  5360,   120,   120,    96,    96,    96,   704,
     230, -3156, -3156, -3156,  2242,  1377,  1464, 48387,  6105,  8304,
   -3156, -3156, -3156, 24302,  1990, 21723, 21723,  2240, -3156,  1234,
   -3156, -3156,   311,  2606,   794,    80,   794,   664, 31125, -3156,
    2033, -3156, -3156,  1254, 27272,  1990, 19540,   911, -3156, -3156,
   -3156,  1255, 21723, -3156, -3156,  1872, -3156, 52996,  2149,  2149,
   21723, 21723, 20410, -3156, -3156,  2217, -3156, -3156, -3156, -3156,
   -3156,  2243, -3156, -3156, -3156, -3156,  2641,  2244,  2222,  2249,
    2251, -3156, -3156, 42520, 52996, 52996, 52996, -3156, -3156, -3156,
   -3156, -3156,  2429, -3156, 21723,    82,  2247,  2252, 52996,   148,
   -3156,  8888, -3156, -3156, -3156,  2452, -3156, -3156,  2396, -3156,
   -3156, 37060, 42520, -3156, 42520, -3156,  -138, 52996, 52996, 52996,
   -3156,  1700, -3156, -3156, -3156, -3156, -3156,  1060, -3156, 42520,
    2378, 41680,  1700,  1088,   801, 52996, 52996, -3156, -3156,  1700,
   -3156,   801,  1700,   801, -3156, -3156, -3156, -3156, -3156,  1119,
   -3156, -3156, -3156, -3156, -3156, 52996,  1119,  1119, -3156, 42520,
     252, -3156, -3156, -3156, -3156,   148,   148, -3156, -3156, -3156,
   -3156, -3156,  2302, -3156, -3156, -3156,   431, -3156, -3156, -3156,
    2317, -3156, -3156, -3156, -3156, -3156, -3156,  4299,   568, 42520,
     568,   568, 52996,  2256, -3156, -3156, -3156,  2461,  2465,   568,
   -3156,    62,   987, -3156,   829, 28117,  3689,  2258, -3156,  2259,
     794,  2033, 25582,  1930, -3156, -3156, -3156,   589,  2449,  2268,
    2413,  2150, -3156,   234,   270, 51320, 51739, 52158, -3156,  1446,
    2328, -3156, 36640, 28117,  1948,   566,  2388,   759, -3156, 48387,
     112,  1267, -3156, 42520,  2273, 48387,  2274,  2267, -3156, -3156,
   -3156, -3156,  1268, -3156, 42520,   -35,  2432,  2431,  1278, -3156,
   -3156,   519, 52996,  2344, 48387,  2326,   983, 34538, 42100,  1205,
   -3156, -3156,  2434, -3156, 52996, -3156, -3156, 26427, 23463,  1517,
    2280, 52996, -3156,  2282, 24302,  2495,  2435, -3156, 24302,  2435,
    1425,  2435,  2496, -3156, 27691, -3156,  2293,  1096,  8888, -3156,
     148, 42520,   148,  2336,   148, 41260,   148, 48387, -3156, 48387,
   -3156,   148, -3156,   898, -3156, -3156,  2284, -3156,  2305, -3156,
   -3156, 43778, -3156, 52996,   561, -3156, -3156,  2445, -3156,   519,
   52996,   911,  2294, -3156, -3156, -3156, -3156,  2563,  2564, -3156,
   -3156, 47549,   127, 52996, -3156, -3156, 21723, -3156, -3156,  2301,
    2306,  8120, 21723, -3156,  2570, 42520, -3156, 52996, -3156, -3156,
   -3156, -3156,   794, -3156, 21723, -3156, -3156, -3156, -3156, -3156,
   21723, -3156,   794, -3156, 21723,  2553, -3156,  2676, 42520, 22158,
     625,  1784, 23028, 22158, 22158, 22158, 22158, 22158, 22158, 22158,
   22158, 22158, -3156,   321, -3156, -3156, 21723, 21723,  2565,  2553,
   -3156, -3156, -3156,  1519,  1519, 42520,  2307,  2182,  2310,  2312,
   21723, -3156,   911,  3820, -3156,  2643,   983, 21723,  1759,  1971,
   21723,  1294, 21723,  2566, -3156, -3156,  2316, -3156, -3156, 42520,
   21723, 22158, 22158,  4989, -3156,  5968, 21723,  2318,  6316, 19975,
   -3156,   348,   348,   348,   348, -3156, 48387, 48387,  2156,  2560,
    1299,  1302, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,  2313,
   -3156,  2331, -3156, -3156,    55,  2320, -3156, -3156,  2641,  2337,
   52996, -3156,  2096, -3156, -3156, -3156,  2325, -3156, -3156,  1700,
   -3156, -3156, -3156, -3156, -3156,  2339,  2340, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156,  2150,  4683, -3156,
   52996, 52996,  1316, -3156, -3156,  2548, -3156, -3156, -3156,  2385,
   -3156, -3156, -3156,  2395,  2397, -3156,  2402, -3156, -3156, -3156,
   -3156,  1700,  1700, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
     456,   532, 42520, -3156, -3156, -3156, 52996, 52996, -3156, -3156,
    2341, -3156, -3156,  2542,  2544,   568,   568, -3156, -3156,  1717,
    2623, -3156, -3156,  2035,  2035,   590, -3156,  2035, -3156,  2035,
   -3156, -3156,  2131,  2325,   880, -3156, -3156, -3156, -3156, -3156,
   -3156,   631,   794,  1606,  2342, -3156,  1889, 25582, 25582, 25582,
   25582, 25582,  2033,   664, 48387,   794, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,  2343,
   52996, 22158, -3156,   927,   531, -3156,  2557, 48387,  2380, -3156,
   -3156, -3156, 42520, -3156, -3156,  2704,   499, 48387,  2608,  2503,
   -3156, 52996, -3156, 45035, -3156,  2580, 45035, -3156, 52996, -3156,
   -3156, -3156,  2673,  2430, -3156, 52996,  1212,  2407,  1638,   983,
    2326, 52996,  2356, -3156,  2351, -3156, 42940,  1244, -3156,  1684,
   -3156, -3156,    59,  2391, -3156, -3156, 50063,  2364, 52996,  1517,
   24302, -3156, -3156,  1660, -3156, 24302,  2579, -3156, 24302, 52996,
    2371, 52996, -3156,  2372, -3156, 52996, -3156,  2373, -3156,   148,
     148, -3156,  1196,  1157,   311, -3156, -3156,  2618, 50901, -3156,
   -3156, -3156, -3156, -3156, -3156,  2626, -3156, -3156,  8888, -3156,
   -3156, 21723,  8888, -3156,  2375,  2376,  2381,  8888,  4935,  2382,
    8888,  2565, -3156,  1858,  2630,   549,  2389,   321,  1858,   850,
     850,   155,   155,   102,   102,   102,  2676,  8888,  8888, -3156,
   -3156, -3156, -3156,  2384, -3156, -3156, -3156,  2182, -3156, -3156,
     664,  2362, 22158, 22158,  1586, -3156,   734, 21723, 42520, -3156,
    1317,  1586,  2132,  2162, 21723, 21723,  6818,   206, 21723,  6034,
   48387, 48387, 48387, 48387, -3156, -3156,  2719,  2629, -3156, -3156,
     311,  1843,   983, -3156,   609, -3156, -3156, 28993, -3156, 10387,
   -3156,   794, -3156,  1333,  1349,  2380, -3156, -3156, 52996, 52996,
   52996,  1446,  2554,  2555,   794, 52996,  2437, -3156, -3156,  2605,
     568,   568, -3156, -3156, -3156,   983,   983,   801,  2559, 52996,
     983,   801, -3156,   949,  2682, -3156,  2622,   113,  2399,  2649,
    2650, -3156, -3156,  1215,  1215, -3156, -3156, -3156, -3156, -3156,
    2654, -3156, 21723,   661,  1858, -3156, -3156, -3156, -3156,  2380,
    1948,  2451,  2455,   519,   295,  2685,  2672,   112, -3156,  2410,
     936,  2412,  1473, -3156, -3156, -3156,   484, 52996,  2767, -3156,
    2741,  2742,  2567, -3156, 52996,  2624,  1870,  2669,  2419, -3156,
   24721,   983,  1638,  1205, -3156, -3156, -3156, -3156, -3156,  2487,
   52996, -3156, -3156, 52996,  1350, -3156, 21723,  2422, -3156, -3156,
   24302,  1660,  1389, 52996,  1390, 42520,   148,   148,   148, -3156,
   -3156,  2679, -3156, -3156,  2575, -3156, 50901,  8888, -3156, -3156,
   -3156, -3156, -3156, -3156, 22158,  2677,  2427, 22158, -3156, -3156,
     747,   747,   734,  1418, -3156, 42520, 22158, 22158,  1586,  1586,
   21723,  1586, -3156, -3156, -3156, -3156, -3156, 21723, 21723, -3156,
   -3156,   880, -3156, -3156, -3156, -3156,   664, -3156,  2436, -3156,
   -3156,  2556,  2380,  2451, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, 21723, -3156,   568, -3156, -3156,   987, -3156, -3156, -3156,
   52996,  2423, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   43778,  2783, 48387,   631,  6136,  2594, -3156,  2451,  2625,  2664,
   -3156, 52996,  1212, 45035, -3156,  1027,  2573, -3156,  1473,  1008,
    1081, -3156, 48387,  2431,  2551, -3156,  2558, -3156, -3156,  2598,
    2601, -3156, -3156,   983, -3156, 52996, 24721, 21723,  1426, -3156,
   52577, 18234, -3156,   662, -3156, 48387, -3156,  1476, -3156,  8888,
   52996, -3156, -3156, -3156,  1515, -3156, -3156, -3156, -3156,   519,
   -3156,   127,   479, 22158, 22158,   335, -3156, -3156,   747,   747,
    1586,  2182,  8888, -3156, -3156, -3156, -3156, 48387,  2451, -3156,
    8888, -3156,  2423,  2783,  2806, -3156, -3156,  2714, -3156, -3156,
     419,  2613,  2533,  2815, -3156, -3156, -3156, -3156, 52996,  2431,
   -3156, -3156, -3156, -3156, -3156, -3156,  1516,  2430, -3156, -3156,
     519, -3156, -3156, -3156, -3156,  1557,  6552,  2380, 24721, 52996,
   -3156, -3156, -3156,  2522,  1990, -3156,  1558, -3156, -3156,   479,
     584, -3156,  1948, -3156, -3156, -3156,  2737, -3156, -3156,    76,
   -3156,  2621,  2627, 52996,   459,  2472,  2430, -3156, -3156, -3156,
    2380, 52577,  2430, -3156, -3156, -3156,  2753, -3156, -3156,  2625,
    2588,   165,   165,  2531, -3156,  2768, -3156, -3156,   794,   794,
   42520,  2478, -3156, 32835, -3156,  2430, -3156,  1990,   421,  2613,
    2751, -3156,  2854, -3156,   462, -3156, -3156, 43778, 28993, -3156,
     459,  1569, -3156, -3156, -3156,  1990, -3156, -3156, -3156,  1159,
     631,  2619, -3156, -3156, -3156,  1645,   396, -3156, -3156, 32835,
   -3156, -3156,   467, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, 43778, -3156, -3156, 41260, -3156, -3156,  1518, -3156, -3156,
    1585,  1461,  2488,  2489, -3156,   467, 32835,  2616, -3156,  1584,
   -3156, -3156
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3156, -3156, -3156, -3156, -3156,  2707, -3156,  -908,  -296, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156,   854, -3156, -3156,  -772,   754,  1617, -3156, -3156,   603,
   -3156, -3156, -3156, -1252, -3156,   173, -3156, -3156, -3156, -3156,
   -3156, -3156,   921, -3156,  -924,   486, -1082, -3156, -3156, -3156,
   -3156,   895,  -166, -3156, -3156, -3156, -3156, -3156, -1482,  -132,
      18, -3156,    16,   947,   131, -3156,  -187, -3156, -3156, -3156,
   -3156, -1115,   567, -2416, -2269,    20,  -482,  -501,  -461,  -458,
    -478, -3156, -2899, -3012, -2196, -2963, -3156, -3156, -3156, -3156,
      38, -1477, -3156,  1391, -3156, -3156, -3156, -3156,  -196, -3156,
   -3156, -3156,   187, -3156, -3156, -3156, -1476, -3156,   907, -2417,
   -3156, -3156, -3156,  -546,  -518, -3156, -3034,  -145,  -143, -3156,
   -3156, -3156, -3156, -1088, -3156,   452,   453, -1009, -3156, -3156,
   -3156,   481, -3156, -3156,  -493,  1420,  -539, -3156, -3156, -3156,
   -3156, -3156,  1361,  -718, -1533, -3156, -3156,  2808,   543, -3156,
   -3156, -1967, -1474, -3156,  -172,   588,  1808, -1168, -2114,    -6,
   -3156, -3156, -1620, -3156, -3156, -3156,   814, -1473, -3156,    46,
    -326,  -406, -3058, -3156, -3156, -1132, -3156,   592,  1056, -3156,
    1058, -3156, -1803,    51,  -884, -2452, -2790, -3156, -3156, -3156,
   -3156, -3156, -3156, -1603, -1458, -3156,  -367, -3156, -3156, -3156,
   -3156,   863, -3156,   104, -3156, -3156, -3156, -3156, -3156, -3156,
    -480,  -515, -3156, -3156, -3156,   207, -3156, -3156, -3156,  1198,
   -1046,  -851,  2090, -1471,  -290, -3156, -3156, -3156,   934, -1944,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -1039, -3156, -3156,
   -3156,  1178,  2858,  -710, -3156, -3156, -3156, -3156, -3156, -3156,
     -12, -3156, -3156,   387, -2026,     3, -3156, -3156, -3156, -3156,
    -280,    15, -3156,   675, -3156, -3156, -1723, -3156,  1852,   857,
      31,   -71,   -75,  -227,   430,   635, -3156, -3156,  -208,  1094,
   -3156, -3156, -3156, -3156,   672,  1663, -3156,   665,  -276, -3156,
   -3156,  1666, -3156, -3156,  1665,  1179, -3156,  1199,   711, -2040,
     906, -2012,   446,  -538,  -164,  -182,  2245, -3156, -2250, -2615,
     107,  -882, -1754, -2264, -1495, -3156,  1593,  2266, -3156, -3156,
   -1041, -3156, -3156,  3617,  3639, -3156, -3156,  7508,  9227, -3156,
   -1062,   328,  9334,   226, -1222, -1536, 11124,   536,  -429, -1515,
   -3156, -3156,  -728, -3156, 11370,   685, -3156, -1198, -3156,   -14,
   -3156, -1583, -3156, -3156, -3156, -3156, -3156, -1586, -2527,  -569,
     755, -3156, -3156,   833, -3156, -3156, -3156, -1016,  -957, -1681,
     756, -1714, -3156,  -933,   861,  1273,  7228,  -864,  3518,  -759,
    8641,  -125, -2044, -1292,  -979, -3156,  -726, -3156,    -2,    43,
   -3156, -3156,  7821,  -750,  -766, -1741, -3156,   -50, -3156,  -881,
    -949, -3155,  -678, -3156, -3156,  2490,   483, -3156,  1926, -3156,
     938,  1455, -3156, -3156,  1168,  -813,  -116, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156, -3156,
   -3156, -3156, -3156, -3156,  1689,   121, -3156,   -62, -3156, -3156,
   -3156,  2987, -3156,  2738,   -48, -3156,  2369,   -47, -3156, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156,  -814,  1207, -3156,
    2061, -3156, -3156, -3156,   -55, -3156, -3156, -3156,  1883,  -149,
   -3156, -3156, -3156, -1019,  1102,  2087,  -832,  -753,  1181, -3156,
   -3156, -3156, -3156, -3156, -3156, -3156, -3156,   912, -3156, -3156,
     748,   917, -3156, -3156,    92, -3156, -3156,     6,    97, -3156,
    1787, -3156, -3156, -3156,   314, -3156, -3156, -3156,  -533,  9263,
      48,   -68,   -53,   530, -3156,  1339, 10797, -1344,  -700,    24,
    1722,  5964, 10396,    67,    27,  -129,    21,   -38, -1365, -3156,
    2730,  1194,   929,  -883,  6772,  1447,  2762,  4240,  -740,  -830,
    2109,  -510, -1385, -3156,  3098
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1868
static const short yytable[] =
{
      71,   316,  1018,  1188,   936,   315,  1032,   830,  1048,  1973,
    1613,  1025,   922,  1028,   784,  1366,  2149,   367,  1502,  1571,
    1005,  1897,  2070,   789,   702,  1058,  1582,  2071,   331,   333,
    1732,   896,   794,   799,   590,  1684,  1095,  2176,   361,   703,
     799,   361,   928,  1315,  1107,    72,   702,  2061,   872,  1410,
    1100,  2332,  1144,  1507,   361,  1033,  1129,  1151,  1336,  1051,
    1424,   703,  1328,  1114,   310,  1159,  1059,  1169,  1742,  1171,
     761,  1173,  1803,   892,  2749,   745,   361,  1174,  1135,   311,
     892,   799,   892,  2500,  1142,  1148,  1526,  2579,  1385,  2642,
    2134,   313,  1103,  2093,  1175,  2782,  1109,   360,  2094,  2095,
     360,  2096,  2097,  2604,  2098,  1115,  2211,  2342,  1953,  1163,
    1463,  2599,  1182,   360,  2365,  1414,   706,  2960,  2925,   710,
    2593,  2595,  1168,  2929,   358,  2350,  1608,   358,  3151,  2812,
     865,  2524,  2525,  2526,  2527,   360,  1317,  1913,   706,  1326,
     358,   710,  1590,  1469,  2413,  2415,  2376,  1450,  1636,   985,
    2380,  1495,  1697,  1698,   702,  2347,   935,   316,   848,   709,
    2148,   315,   358,  1404,  1390,  1309,  1411,  1334,  1784,   703,
    1407,  3039,  1749,  1394,  1395,  1652,  1717,  2063,  2678,  1581,
     848,   709,  2507,  1705,   361,  1318,  1744,  1631,   963,  1014,
     994, -1059,  2009, -1209,  1752,  1568,  1749,  1667,   759, -1209,
     366,  1573,  1919,  1204,  1437,   746,  2323,  1583,  1778,  1002,
    1407,  1919,  2273,  2192, -1756,  1547,  2278,  1631,  1752,  2278,
     310,  3185,  2311,   893,  1920,  1454,  -292,  1631,  2312,  1671,
     893,  2678,   893,  2052,  1398,   311,  1170,  1919,  3451,  1631,
   -1305,  2633,  1374,   360,  2009,   964,   706,   313,  2886,   710,
    1920,  1122,  2204,  2293,  1826,   981,  2939,  2360,  2484,  3377,
    1631,  2635,  2652,  3313,  2242,  1877,  1179, -1783,  -978,   891,
     358,  1926,  3122,  3412,  2101,  1921,   891,  3471,   891,     3,
     949,   950,  1502,   292,  1921,   721,  3186,   722,  1360,   709,
     361, -1225,  1061,  1172,  1438,  1927,   965, -1225,   901,   966,
    3369,  3397,  1179,   976,  2819,  3263,  1749,  2508,  3483,  2637,
    1921,  1914,  1873,   371,  2193,  1455,  1791,  1061,  1465,  2754,
     977,   950,  1924,  1732,  2755,  2756,  2757,   361,  1752,  1361,
     361, -1653,  1782, -1054,  3379,  2114,  2758,  2759,  2760,  2102,
    2761,  2762,  2763,  2066,  3483,  1509,  2764,  2765,  2766,   360,
    1878,  1511,  1514, -1655,  1792, -1652,  1343, -1797,   607,  3297,
    2010,  2294,   128,   129,  3202,  2295,  3204,  1506,  2638,  1874,
   -1651,  3483,  1964,   803,  1062, -1820,   358,  3436,  1809,  2042,
     902,   967,  2474,  3466, -1708,  1429,   360,   208,  1569,   360,
    1620,  2896,  3124,  3334,  1123,  1922,  1592,  2678,  2296,  1062,
     964,  1396,  1588,   756,  1922,  3423,  3187,  1632,  1507,  3389,
    1003,  2678,  1570,   358,  1637,  2634,   358,  1928,  2053,  2416,
    1875,  2361,   852,  2840,  1646,  1647,  1665,  2901,  1617,  1779,
    1922, -1756,   725,   998,  1676,  2636,  3472,  1632,  2059,   292,
     789, -1758,  2493,  1375,   226,  1685,  2020,  1632,  2853,   794,
      49,   965,   968,   588,  2067,  2037,  3510,  3188,    52,  1632,
    2118,  1186,  2858,   726,  2344,  1756,  1757, -1209,  1672,  1697,
    1698,  1456,  3368,  2194,  3452,  1439,  1923,  1717,  -207,  1692,
    1632,  1403,  1422,   969, -1783,  1923,   975,  1668,  2195,  2279,
    2208,  2209,  2731,  1705,  3223, -1059,  2313,  3473, -1059,  2213,
    2040,  2217,  2219, -1059,  1615,  1876,  2297,  3487,  2631,  1501,
    2103,  1923,  1760,  2234,  2235,  1745,  2109,  3474,  1201,  2485,
   -1059,  2849,   723,  2851,  2852,   986,  2139,  2251,  2253,  1633,
    2064,  2143,  2857,  1570,  1781,  2064,   967,   861,  2150,  1773,
     231,  3093,  3094,  1907,  2969,  2691,  2435,  2159,  2973,  2475,
     608,   588,  1034,  1864,   588,  2678,  2680,  1053,  1055,  1672,
    1770,  1771,  1772,  1773,  1411, -1225,   987,  1939,   588,  1615,
    2680,  2566,  1404,  1628, -1797,  1889,   588,  2895,  1823,  1824,
    1894,  2998,    53,  2109,  1972,  2329,  2778,  2712,  3344,  1442,
     844,    49, -1820,  2773,   588,  2688,  2689,  2690,  2691,    52,
      53, -1708,    54,  1953,  2841,  1027,  1029,  2068,  1382,  2817,
    2116,  2818,  2134,  1927,   942,  2055,  3427,  3442,  2163,  3493,
    2767,   928,  2389,  3133,  3134,  3135,  3136,  3137,  2041,   153,
    2681,  2043,  2783,   588,  1499,  1837,   874, -1054,  2069,    53,
   -1054,  1099,  2842,  1907,   715, -1054,  3314,   844,  1130,  3488,
    3465,  1427,   702,  2238,  2239,  3315,    49,  3458, -1758,   588,
    2678,  1917, -1054,  1443,    52,    53,   943,   703,  1768,  1769,
    1770,  1771,  1772,  1773,  1428,  2110,  1016,   950,  1929,  2436,
     981,   799,   361,  1140, -1653,  2081,   361, -1653, -1653,  1929,
    3147,  1444,    49, -1653,   170,   588,  1974,  1307,    71,   769,
      52,  2768,  2876,   875,  2090,  2285, -1655,  1092, -1652, -1655,
   -1655, -1652, -1652,  1165, -1868, -1655,  3225, -1652,  3513,  2567,
    2267,   866,  2031, -1651,  3428,  2286, -1651, -1651,  2140,  1506,
    2876,  2960, -1651,   944,  3298,  3102,   981,  1972,   716,  1048,
    3307,   360,  3303,    72,   706,   360,  3494,   710,   187,   717,
    1308,   771,   924,   858,  3459,  1500,  3086,  2885,  2682,  2686,
    2687,  2688,  2689,  2690,  2691,  2958,  1507,  2091,   358,  2683,
    2684,  2685,   358,  2686,  2687,  2688,  2689,  2690,  2691,   892,
    1749,  2909,   892,  3421,  1471,    49,  2073,   709,   588,   981,
    3122,   897,  3024,    52,  3316,  2044,  2180,  2181,  1874,  2049,
    1930,  2776,  1752,   725,   757,  1965,   873,  1472,  2134,  1185,
    1749,  3103,  2568,  1491,   208,  3148,  2066,  2287,  2911,  2680,
    1936,  1191,  2288,  2678,  1446,  3460,  2289,   718,   945,  2074,
    2184,   848,  1752,   848,   726,   848,  2046,  3226,  1447,  2437,
    2737,   848,   848,  3514,  2023,  1448,  2452,  2121,  1205,  1875,
    3281,  1312,  2494,  3123,  1431,  2144,   921,   876,   877,  1320,
    1322,  1492,  2151,  3091,  1931,   224,   208,  2274,  2157,  3118,
    2086,   226,  1615,   964,   777,   725,   778,  1432,  1570,  2681,
     202,  2138,  1186,  2162,  1359,   361,  2142,  1449,  3112,  3113,
    1048,  1106,  2165,  1937,  2047,  3104,  2089,  2174,  3105,  2178,
    2179,  2678,  1433,  2182,  3025,  1638,   726,  3179,  3119,  2075,
    3124,   153,  1163,  3026,   231,  2161,  1600,  2686,  2687,  2688,
    2689,  2690,  2691,   226,   965,  2290,  2678,  2067,   769,   893,
    3195,  2177,   893,  2291,  1876,  3199,   590,   590,  3201,   719,
    3295,  3207,  1360,  1090,   360,  2915,   898,  1337,  1965,   838,
    1410,  2220,  2221,  2222,  3192,  2453,   887,  2454,  2076,  2233,
    1601,  2022,  1434,  2236,  2237,   920,   231,  1383,   839, -1868,
    2241,   358,  1119,  2997,  2916,   891,   170,    49,   891,  2257,
     771,  2258,  2680,  1361,  2917,    52,   202,   931,    71,    71,
      49,    71,  1965,   588,  1048,  2271,  1383,  2272,    52,   702,
    1850,  2995,  2987,  1600,  2200,  2369,  3449,  2682,  1468,   967,
    2602,  3372,  1384,  2406,   703,  2998,  1414,   725,  2683,  2684,
    2685,  1570,  2686,  2687,  2688,  2689,  2690,  2691,  2077,   361,
    2078,  2023,  3448,    72,    72,  1851,    72,  1602,  -885,   936,
    2679,  1384,  2681,  2425,  1524,  2622,  1881,  2992,   726,  1882,
    -885,  2276,   120,  2093,  1798,  2918,   933,  3085,  2094,  2095,
    2680,  2096,  2097,  2707,  2098,  1570,  3009,  1953,  1434,  2134,
     124,  2608,  2339,  2134,  2610,  1116,  1165,  1615,  2612,  1852,
    2068,  2351,  1603,  -910,  2721,  2680,  2407,  3145,   360,  3021,
    -885,   706,  2861,   316,   710,   939,   208,  1644,  2456,  2457,
    1117,  1578,  3351,   777,  3413,   778,  1799,  1116,  -885,  3284,
    1629,  1914,   316,  3040,   956,   358,  1670,  3309,  2447,  1579,
    2681,  2450,  2451,  2644,  1602,  1329,  2723,  2750,  2751,  2600,
    2862,  1883,  2927,  1690,   709,  1118,  -301,   957,  3138,  3146,
    2880,  -910,  3390,  3274,  3275,  2681,  2724,   224,   958,  -885,
    2863,  1707,  3310,   226,  1851,  1604,  1640,  -885,  2374,  1493,
    3341,  3285,   202,  1972,  3446,  2864,  3391,  1118,  2880,  1603,
    2682,  1641,  1768,  1769,  1770,  1771,  1772,  1773,  2597,  2865,
    2509,  1735,  -910,  1642,  1494,  2686,  2687,  2688,  2689,  2690,
    2691,  1740,  1037,  1201,  2866,   940,   231,  1330,  1852,  2032,
    1436,  3438,  2421,  1038,  1039,  1040,   948,  1041,  1042,  1043,
    1044,  1045,  1046,  1488,  1506,  3393,  2432,  3486,  1743,   588,
    1164,   588,  1908,    49,  1470,    53,   959,  3392,  1957,  1748,
    2439,    52,  1496,  2387,  2442,  3500,  1489,  2390,  1324,  3394,
    3464,  2440,  1604,  2725,  1434,  1909,  3467,  2726,  2682,  1458,
     229,  1958,  -885,   230,  2404,  1796,  1797,  3383,  1801,  2683,
    2684,  2685,   953,  2686,  2687,  2688,  2689,  2690,  2691,  3485,
    1910,  2867,  2082,  2682,  1322,  1460,  1959,  2088,  2868,   960,
    1842,  1842,  2420,  1842,  2422, -1868, -1868,  2107,  2686,  2687,
    2688,  2689,  2690,  2691,  1101,  2247,  1102,  1461,  2566, -1451,
    3395,  1521,  1522,   702,   892,  2869,  3371,  1350,  2027,  1727,
    1728,    53,  2647,    54,  2515,  2955,  1442,  2813,  2444,  2519,
    2646,   153,  1146,  1558,   727,  1383,  1838,  1383,  1383,  2497,
    2498,  2267,  1839,   361,   361,   361,  1891,  2566,   961,   892,
    3254,   758,     9,   590,  1729,  2009,  2727,  2478,  1458,  2033,
    2481,  2015,  2483,   828,  2728,  1442,  1066,  3139,  2034,    49,
    1067,   702,   588,   979,  2823,   892,  3385,    52,  1900,   950,
    1384,  1459,  1384,  1384,  1460,  1104,   703,  1105,   361,  2035,
    1884,  1727,  1728,  2844,  2845,   361,   170,  2824,  1176,  3386,
    1443,   361,   360,   360,   360,   706,  1461,  1787,   710, -1039,
      71,  1788, -1039,   899,    71,    49, -1033, -1039,   588, -1033,
    1147,  1190,   700,    52, -1033,  3176,  1731,   998,  1444,   358,
     358,   358,  1004,   597,  1703,  1885,  2614,  2648,  2603,  1443,
     617,  1709,  1405,   713,  1406,  2649,  2382,   360,  1060,  3501,
     187,   936,  2383,   713,   360,    72,  2567,  1904,  1015,    72,
     360,  1070,  2410,   706,   893,  2134,   710,  1444,  2411,  2503,
    2134,  2061,  2650,  2134,   358,  2504, -1308,  2940,  2531,   617,
    2629,   358, -1066,  3005,  2532, -1066,  2630,   358,   713,   755,
   -1066,  3041,  3042,  1097,  2774,  2567,  2141,   617,   713,   893,
   -1024,   713,  1689, -1024,   231,   713,   709, -1066, -1024,   713,
     891,  2803,   702,  2645,   860,  2626,   208,  1692,  1094,  2646,
    1383,  2201,  3047,   588,  3229,   893,  1098,   703,  2982,    53,
    2984,   713,  2986, -1059,  2988,  2626, -1059,   844,  2656,  2991,
    2128, -1059,   361,  1108,  2646,   891,   713,  1322,  1120,  1445,
     880,  1066,   860, -1311,   588,  1067,   900,  2825, -1059,  2828,
      53,  1446,    54,  1808,   815,  1384,  2878,   224,  1382, -1022,
    3006,   891, -1022,   226,  1121,  1447,  2909, -1022,  2835,  1124,
    1048,  1442,  1448,  1715,  1716,  2837,  2838,  2839,  1445,  2910,
    2012,  1507,   588,  2016,  2878,  1006,  2775,  2021,  1007,  1127,
    1446,   360,  1137,   935,   706,   848,  2658,   710,  2789,  1149,
    1008,  1009,  2646,  2911,  1447,  2912,  3502,  2850,  2123,  2124,
    2661,  1448,   765,  2666,  1449,  2267,  2662,  2959,   358,  2646,
    2667,  1010,  2586,  1037,  1011, -1025,  2646,  2787, -1025,  3258,
    3170,  3171,  3172, -1025,  1038,  1039,  1040,   709,  1041,  1042,
    1043,  1044,  1045,  1046, -1036,  1443,  1160, -1036,  2587,  3333,
    2169,  1558, -1036,  1449,  2671,  2889,  2890,  2891,  2231,  2585,
    2672,  2932,  1749,  2975,  1179,  3330,  1513,  2829,  2913,  1720,
    3373,  2589,  2839,  1444,  1183,  2695,  2831,  2832,  1558,   769,
    2283,  2646,  2753,   702,  1752,  2134,  1184, -1023,  2646,  1753,
   -1023,  2706,  1558,  2708,  2709, -1023,  2267,  -598,   703,   848,
     848,   848,  2779,  2784,  3259,  1192,  2804,   848,  2780,  1615,
     713,   848,   848,   361,  2586,  2930,  2937,  1193,   848,  2983,
    3365,  2931,  2938,  1972,  1198,  2914,  2944,   848,  1502,   848,
    2915,   771,  2945,  1896,  1866,  1406,  1558,  2836,  1867,  2820,
    2587,    49,  3055,   848,   588,   848,  1012,  3078,  2646,    52,
    3079,  1558,  2741,  2646,  2742,  2588,  2646,  1199,  2337,  2916,
    2884,  2591,  2515,  2589,  3095,  3234,  1747,  1200,  1558,  2917,
    2945,  3235,   360,  3014,  1201,   706,  2536,  2787,   710,  2340,
     950,  3261,   981,  1202,  2590,  1843,  1845,  2945,  1849,   361,
    2169,  2391,  1938,  1558,  1445,  1203,  3022,  3262,  3338,   358,
    1206,  1755,  2585,  2945,  1615,  2787,  1446,  2367,  1442,  2367,
    1890,  3330,  1327,  2363,  1867,  1207,  2247,  1867,   709,  2247,
    1447,  1756,  1757,  3043,  3116,  3117,  1331,  1448,  3120,  1332,
    3121,   361,  2086,   361,  1333,  2678,  1558,  3343,  3345,  2743,
    2918,  2744,   590,  2931,  2931,  1558,   702,  3059,   360,  3052,
    2247,  2247, -1653,  2591,   777, -1653,   778,  2586,  1342,  2372,
   -1653,   703, -1655,  1867,   779, -1655,  3356,  1343,  1760,  1449,
   -1655,  3184,  3235,   782,  3407,   358,   361, -1659,  1727,  1728,
    3408,  1761,  1443,  2587,  1383,  2555,  2556, -1660, -1069,  1344,
     360, -1069,   360,  3330,  1352,  2177, -1069,  1383,  2588,    71,
     936,    71,  -885,  -884,   617,  1350,  2589,  3209,  3210,  1351,
    1444,  3523,  3016,  1729,  -885,  -884,  1354,   358, -1652,   358,
    1357, -1652,  3019,  1368,  3415, -1651, -1652,  2590, -1651,  1384,
    1615,  1727,  1728, -1651,  2678,   360,  1372,  1999,   706,  3015,
    1373,   710,  1384, -1657,    72,  2996,    72,   713,   713,    49,
   -1656,  3114,   588,  3196,  -885,  -884,  1377,    52,  2537,  1376,
    3106,  1805,   358,  3417,  3437,  3007,  3524,  1037,  3525,  2931,
    1672,  1378,  -885,  -884,  2336,  1558,  1379,  2000,  1038,  1039,
    1040,   709,  1041,  1042,  1043,  1044,  1045,  1046,  1380,   848,
    1844,  1844,  1381,  1844,  2680,  1388,  2591,  1383,  1391,    49,
    1383,  1383,   588,  1393,  1524,  3440,  3447,    52,    53,  1764,
      54,  3408,  1615,  -885,  -884,  1396,  1382,  3498,  3129,  3130,
    3496,  -885,  -884,  3499,  1768,  1769,  1770,  1771,  1772,  1773,
    1415,  1445,  3531,  1350,  1416,  -877,  1537,  1356,  3499,  1358,
    3152,  1425,  1384,  1446,  2001,  1384,  1384,  2678,  1418,  3361,
     981,  2974,  2578,  2977,  2681,   936,  1806,  1447,  1679,  1680,
    3197,  3053,   848, -1659,  1448,  2563, -1660,   848,  1026,   617,
    1030, -1657,   597, -1656,   713,  1050,   597,   713,  2790,  2791,
     713,   713,  1026,   597,  2792,  2793,  2002,  1429,  2003,  1441,
    1397,  1399,  1452,  2680,  1464,  1466,  1467,  1473,  2004,  1490,
    1497,  1498,   713,  1510,  1512,   617,  1449,  1026,  2611,   597,
    2746,  2747,  1517,   597,  1111,   713,  -885,  -884,   713,  1519,
    1026,  1525,   597,  1528,  3346,  3347,  3348,  1565,  1566,  1434,
    2005,  1570,  3128,  1574,  1576,   713,   713,  2515,  2515,  2515,
    2515,  2515,  -160,  1587,   713,  3141,  1597,   617,  1605,  1607,
     713,  3257,  1609,  2681,  1615,   713,   713,  1610,  2006,  1611,
     713,   713,  1612,   713,  1614,  1618,  1026,  2786,  1727,  1728,
    1621,  1622,  1619,  1558,  1558,  1623,  3059,  1624, -1069,  1625,
    1626, -1069,  2682,  1627,   713,   713, -1069,  1630,  2007,  1677,
    1681,   713,  1683,  2683,  2684,  2685,  1688,  2686,  2687,  2688,
    2689,  2690,  2691,  1731,  1696,  1699,  2680,  1740,  2678,  1700,
     848,  1701,  1702,   713,  1672,   713,  1706,   231,  1197,  1708,
    2283,  1711,  3236,  1712,  1713,   229,    49,  1714,   230,   588,
    1719,  1722,  1804,  1723,    52,    53,  1724,    54,  2678,  2740,
    1725,  1726,  1733,  1382,   713,   617,  1825,  1734,  2128,  1323,
    2247,  1827,  3237,  2247,  2247,  2247,  2247,  2247,  2247,  2247,
    2247,  2247,  2247,  1783,  1749,    49,  2681,  1341,   588,  3418,
    1840,  1558,  1359,    52,    53,  1862,    54,  1865,  1872,  1879,
    1880,  2682,  3251,  1886,  1888,  1892,  1752,  1407,  1558,  1898,
    1899,  1753,  2683,  2684,  2685,  1037,  2686,  2687,  2688,  2689,
    2690,  2691,  2247,  2247,  1901,  1911,  1038,  1039,  1040, -1595,
    1041,  1042,  1043,  1044,  1045,  1046,  1903,  1912,  1915,  1914,
    2626,  1916,  1932,  2932,  1933,   597,   597,  2887,  2888,  2889,
    2890,  2891,  2169,  1960,   848,  1934,  1383,  3132,  1935,  1962,
    1963,  3260,  1967,  1961,  1968,   713,  1969,  2009,   713,  1996,
    1998,   713,  2013,  3357,  3269,  1997,  2019,  2014,  2017,  1048,
    2024,  2025,  2029,  3512,  2026,  2028,  2720,  2680,  2887,  2888,
    2889,  2890,  2891,  2030,  2045,  1026,  2892,  2050,  2048,  2051,
    2060,  1384,  1703,  1692,  2062,  1709,  1720,  2072,   767,  2100,
    2115,  2117,  2106,  2087,  2682,  2112,  2119,  2680,  2120, -1868,
    2126,  2136,  2146,  1755,  2158,  2683,  2684,  2685,  2147,  2686,
    2687,  2688,  2689,  2690,  2691,  2166,  2167,  2183,  2172,  2186,
    3264,   713,  3266,  1756,  1757,  2173,   713,  2681,  2965,  2190,
     713,   848,  2198,  2203,  3337,  2213, -1868,   713,  1749,  2255,
    2212,  2223,  2256,  2270,  3337,  1026,  2277,  1383,  3396,   789,
    2300,  2323,  2269,  2282,  1383,  1383,  2298,  2681,  2334,  1026,
    1591,   799,   713,  1596,   702,  2333,  2335,  2879,  2338,  2341,
    1760,  2346,   943,  2356,  2902,  2357,  2352,  2362,  2064,   703,
    2370,  2371,  2247,  1761,  2384,  1026,   316,  2381,   713,  2385,
    2946,  2386,  1384,  2392,   361,  2879,  2396,  2394,  2224,  1384,
    1384,  2397,   316,  1383,  2398,  2408,  2964,  2400,   848,  2128,
     848,  2402,   936,  2128,  2405,   713,  2954,  1322,  2417,  2418,
    2419,  2897,  2429,  2409,   713,   860,  2430,  2431,  2433,   713,
    2443,  1383,   713,  3070,  3071,  3072,  3073,  2448,  2626,  2434,
    1682,  2441,  2455,   713, -1868,  1687,  2488,  2489,  1384,  2225,
    2490,  2486,  2226,   360,   316,  2682,   706,  2491,  3001,   710,
    2492,  2480,  2499,  1475,  2177,  2505,  2683,  2684,  2685,  1476,
    2686,  2687,  2688,  2689,  2690,  2691,  1384,  2517,  3479,  2518,
     358,  3416,  2521,  2530,  2522,  2682,  2510,  2533,  2539,  2540,
    2561,  2562,  2564,  2574,  2577,  2575,  2683,  2684,  2685,   709,
    2686,  2687,  2688,  2689,  2690,  2691,  1477,  3404,  2576,  1558,
    2584,  1764,  2601,  2605,  2607,  2606,  2609,  1791,  2621,  2627,
    2204,  2639,  2641,  2247,  2247,  1186,  1768,  1769,  1770,  1771,
    1772,  1773,  1972,  2643,  2227,  2664,  2646,  1558,  1558,  2659,
    1558,  2660,  2663,  2665,  2722,  2668,  2701,  2729,  1478,   617,
     617,  2669,  1475,  1479,  2673,  1558,  1480,  1558,  1476,  2676,
     848,  2694,  2700,  1323,  1740,  2702,  3050,  2717,  1821,  1821,
     848,  2736,  2795,  2703,  2704,  2798,  1406,  2814,  2807,  1829,
    2815,  1836,  2826,  2846,  2711,  1558,  2715,  2716,  2752,  2739,
    1549,  3444,  2800,  2797,  2810,  1477,  2855,  2801,  2847,  2811,
    2856,  2802,  1481,  2882,  2854,  2228,  2894,  2883,  3477,  3478,
     229,    49,  1882,   230,   588,  1558,  2893,  2926,  2922,    52,
    2933,  2936,  2935,  2941,  2942,  2949,  2951,  2962,  2966,  2968,
     617,  1558,   597,  2970,  2978,  2971,  2985,  1478,  2993,  2994,
    2981,  3000,  1479,  3003,  3004,  1480,  1689,  3013,  1779,  2697,
    1048,  3495,  2678,  1482,  3010,  3044,  2696,   713,  3045,  1558,
    3046,  1744,  3057,  3058,  3076,  3081,  3067,  3080,  3082,  1558,
      53,  3084,  3087,  3096,  3089,  3097,  3098,  3110,  3099,  3111,
    1558,  2677,  1071,  3100,  2693,  3522,  1458,  3115,  3131,  3109,
    3142,  1481,  2959,  3088,  1558,  2247,  3149,  3153,  2247,  3155,
    3157,  3161,  3166,  3180,  3167,  3181,  1050,  2247,  2247,  1483,
    3174,  3193,  1460,  1072,  3190,  2718,  2719,  3200,  3203,  3214,
    3206,  3208,  3216,  3218,  3219,  1073,  3224,  1558,  3247,  3220,
    3222,  1558,  3228,  1074,  1484,  3248,  3227,  3271,  3267,  3268,
    3273,  3286,  1482,  3280,  3123,  3289,   605,  3290,  3291,  1075,
    3292,  3299,  1026,   618,  3306,  3301,  1026,  3304,  3308,  3312,
    3318,  3319,  3320,  3321,  3323,  3325,  3326,  1076,  3335,  3340,
    3349,  3350,  1884,  3353,  3354,  1458,  3374,  2945,  3148,  3367,
     848,  1558,  3382,  3380,  3366,   848,   848,   848,   848,   848,
    3388,  3398,   618,   848,  3401,  2128,  1077,  3402,  3399,  3177,
    2128,  1460,  3425,  2128,  1558,  3426,  3429,  3433,  3434,  3450,
     618,   618,  3445,   597,  3453,   713,  1078,  1885,   618,  3463,
    3455,  3468,   605,  2476,  2247,  2247,  1323,  3470,  1591,  3452,
    3451,  1558,  3480,  3491,  3492,  3526,  3511,  3527,  3513,   938,
    1079,  2777,   605,  2535,   605,  2477,  2843,  1822,  3276,  2501,
     617,  3159,  3163,   713,   713,  1558,  3296,  1050,  2458,   618,
     713,   713,  2809,   713,   713,  3169,   713,  3469,  3490,  1026,
    3101,  3456,  1026,  3454,  3476,  2108,  3164,   713,  3322,  2520,
    3529,  3516,  3288,  3287,  2923,  2871,  2924,  3497,  3530,  2083,
     868,  2160,  3215,  1080,  1666,   713,  3178,   713,   713,  2628,
    3405,   713,  3443,  2816,  2414,  2412,  3424,  2189,  3183,  3504,
    3528,  1335,  3384,  2528,   815,  2348,   831,  3002,  1549,  2781,
    1643,  2613,   860,  3211,  2785,  2206,  1860,  2794,  1858,  1863,
    2345,  2359,  3256,  2580,  2748,  1081,  2976,  3342,  3158,  1082,
    2788,  1083,  1749,  3049,  3233,  1549,  1084,  2653,  1133,  2732,
    2734,  2632,  2322,  1599,  2122,   984,  1750,  2963,  2573,  1549,
    2373,  1050,  1871,   328,  1752,  3277,  3278,   951,  1558,  1753,
    3282,  1085,  1086,   997,  2364,  1675,  1400,  1423,   316,  2169,
    2375,  2772,  3302,  1087,  2619,  3212,  3250,    71,  1088,   848,
    2620,  3213,  3083,  1868,   973,  1790,  2615,  2379,  2168,  1402,
      78,     0,   848,  1549,     0,     0,  1089,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1549,     0,
       0,     0,     0,   713,  3252,  2128,     0,     0,     0,     0,
       0,  3332,    72,   618,     0,  1549,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1558,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1549,     0,     0,     0,     0,     0,     0,     0,     0,  1836,
       0,     0,     0,     0,     0,     0,     0,  1754,     0,   713,
       0,  1755,  1558,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1756,  1757,  1549,     0,     0,     0,     0,     0,     0,
       0,     0,  1549,     0,  1758,  3023,     0,     0,  3027,  3028,
    3029,  3030,  3031,  3032,  3033,  3034,  3035,  3036,     0,     0,
       0,   597,     0,     0,     0,     0,     0,   713,     0,     0,
       0,     0,     0,     0,     0,  1759,     0,     0,  1760,  3363,
     597,   713,     0,     0,   597,   617,     0,     0,     0,   713,
       0,  1761,     0,  1762,     0,   713,     0,  3062,  3063,     0,
     713,   597,     0,  3403,   316,  3521,     0,     0,  2964,     0,
       0,     0,     0,  1749,  1558,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3364,     0,     0,     0,     0,   597,
     713,   597,   713,     0,   713,  1752,     0,   713,  2428,     0,
    1753,     0,     0,     0,   713,     0,     0,     0,     0,     0,
       0,     0,  1763,     0,     0,   316,     0,   618,   713,  3439,
       0,     0,   713,     0,     0,   597,   713,   713,     0,     0,
       0,     0,  1549,     0,     0,     0,     0,     0,  1749,     0,
    2459,  2460,   713,   713,   713,  2466,   713,     0,     0,   713,
     713,   713,  1750,  1550,   597,   713,     0,   597,   713,   597,
    1752,     0,     0,     0,     0,  1753,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2730,  1026,  1026,     0,  1764,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1765,  1766,  1767,  2516,  1768,  1769,  1770,  1771,  1772,  1773,
       0,     0,  2038,     0,   316,     0,     0,     0, -1868,     0,
       0,  2039,  1755,     0,     0,     0,     0,  3520,     0,     0,
     860,  1558,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1756,  1757,     0,  2543,     0,  3144,     0,  2554,
     316,  2560,     0,     0,     0, -1868,   848,   848,     0,  1596,
       0,  1558,     0,     0,     0,     0,     0,  2583,     0,     0,
       0,  2583,  2596,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1749,  1754,     0,  1026,  2428,  1755,     0,  1760,
       0,     0,     0,     0,     0,     0,  1750,     0,     0,     0,
       0,     0,  1761,     0,  1752,   713,     0,  1756,  1757,  1753,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   605,
    1758,     0,   597,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   713,
    1549,  1549,   597,     0,     0,     0,     0,     0,     0,     0,
       0,  1759,     0,     0,  1760,     0,     0,  1128,   618,   618,
       0,     0,     0, -1868,     0,     0,     0,  1761,     0,  1762,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3230,  3231,
       0,   618,     0,     0,     0,   605,     0,   605,     0,   605,
       0,     0,     0,     0,     0,   605,   605,     0,     0,  2714,
       0,     0,     0,     0,   618,     0,     0,  1754,     0,     0,
       0,  1755,     0,     0,     0,     0,     0,     0,  1763,     0,
    1764,     0,     0,   605,     0,     0,     0,  1050,  1549,     0,
       0,  1756,  1757,     0,     0,  1768,  1769,  1770,  1771,  1772,
    1773,     0,     0,     0,  1758,  1549,     0,     0,   752,     0,
     605,     0,     0,     0,     0,     0,     0,   618,   618,     0,
       0,   605,   605,     0,     0,     0,     0,  1821,     0,     0,
       0,     0,     0,  1836,     0,  1759,  1558,     0,  1760,     0,
       0,  1550,     0,     0,     0,  1764,   713,   862,     0,     0,
       0,  1761,     0,  1762,     0,   870,  1765,  1766,  1767,     0,
    1768,  1769,  1770,  1771,  1772,  1773,     0,     0,  1550,     0,
       0,     0,     0,   597,   713,   713,  2670,     0,     0,     0,
       0,   605,  1550,     0,     0,     0,     0,  2560,     0,     0,
    1558,   926,     0,     0,     0,     0,     0,     0,   605,   605,
       0,     0,     0,     0,     0,     0,   597,   713,   713,  1975,
    3352,     0,  1763,  3355,     0,  1749,     0,     0,     0,     0,
       0,     0,  3358,  3359,   713,   713,  1550,     0,     0,  1750,
       0,     0,     0,     0,     0,     0,     0,  1752,     0,     0,
       0,  1550,  1753,     0,  1026,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1550,  1976,
       0,     0,     0,     0,     0,     0,  1977,  1978,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1764,
       0,  2428,     0,  1550,     0,     0,     0,     0,     0,     0,
    1765,  1766,  1767,     0,  1768,  1769,  1770,  1771,  1772,  1773,
       0,  2516,     0,  1979,  2268,     0,   605,     0,     0,     0,
       0,     0,     0,     0,   713,   713,   713,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1550,     0,     0,     0,
       0,     0,     0,     0,     0,  1550,     0,     0,     0,  3419,
    3420,     0,  1980,     0,     0,     0,  1749,  1981,     0,     0,
    1754,   713,     0,     0,  1755,     0,  1323,     0,     0,     0,
    1750,     0,     0,   617,     0,     0,   713,  2583,  1752,     0,
    2967,     0,   605,  1753,  1756,  1757,     0,     0,     0,     0,
       0,     0,     0,  2980,  1982,     0,     0,  1758,     0,     0,
       0,  1651,     0,     0,  1655,     0,     0,     0,     0,  1983,
    1984,     0,  1985,  1986,   618,  1987,     0,     0,     0,     0,
       0,     0,   597,     0,     0,     0,     0,     0,  1759,  2189,
       0,  1760,     0,     0,     0,     0,  1549,     0,     0,     0,
       0,     0,   597,  1988,  1761,     0,  1762,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1026,     0,     0,     0,
       0,     0,     0,     0,  1549,  1549,  1749,  1549,     0,     0,
       0,     0,     0,     0,  1989,  1550,     0,     0,     0,     0,
    1750,     0,  1549,     0,  1549,     0,     0,     0,  1752,     0,
     605,  1754,     0,  1753,     0,  1755,     0,     0,     0,     0,
       0,   605,     0,     0,     0,  1763,  1990,     0,  1991,     0,
       0,     0,  1549,     0,     0,  1756,  1757,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1786,  1758,  1992,
       0,     0,   618,   618,     0,     0,  1993,     0,     0,  1994,
       0,     0,  1549,     0,     0,     0,   605,     0,     0,   605,
       0,   605,   605,     0,     0,     0,     0,     0,  1549,  1759,
       0,     0,  1760,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1764,     0,     0,  1761,     0,  1762,     0,  1836,
       0,     0,     0,  1765,  1766,  1767,  1549,  1768,  1769,  1770,
    1771,  1772,  1773,     0,     0,     0,  1549,  2881,     0,     0,
       0,  1754,     0,     0,     0,  1755,     0,  1549,     0,  2560,
    2560,     0,     0,   618,     0,   605,     0,     0,     0,     0,
       0,  1549,     0,     0,     0,  1756,  1757,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1763,     0,  1758,     0,
       0,     0,     0,     0,     0,   713,   713,     0,     0,     0,
       0,     0,     0,     0,  1549,     0,     0,     0,  1549,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1759,
       0,     0,  1760,  1550,  1550,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1761,  2516,  2516,  2516,  2516,
    2516,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1764,     0,     0,     0,     0,  1549,   713,
       0,     0,     0,     0,  1765,  1766,  1767,  1054,  1768,  1769,
    1770,  1771,  1772,  1773,     0,     0,     0,     0,  3048,     0,
    2543,  1549,  2459,     0,   605,  2459,     0,  3165,  1093,     0,
       0,     0,     0,     0,  2560,     0,  1763,     0,     0,     0,
    2428,     0,     0,     0,     0,     0,     0,     0,  1549,     0,
       0,     0,     0,     0,     0,  2583,     0,   713,     0,     0,
       0,  1550,     0,     0,     0,     0,   362,     0,  2543,   362,
    3205,     0,  1549,     0,  2428,     0,     0,     0,  1550,     0,
       0,     0,   362,     0,     0,     0,     0,   597,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   605,
       0,     0,     0,  1764,   362,     0,     0,     0,     0,   605,
       0,     0,     0,     0,  1765,  1766,  1767,     0,  1768,  1769,
    1770,  1771,  1772,  1773,     0,  1749,     0,     0,     0,  1187,
       0,     0,     0,     0,     0,  1189,     0,     0,   795,  1750,
       0,     0,     0,     0,     0,     0,  1196,  1752,     0,     0,
       0,     0,  1753,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1786,  2171,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1189,  1050,     0,     0,     0,
       0,     0,     0,     0,     0,  1549,     0,   597,   713,   597,
    1189,     0,   894,     0,  3270,  1339,     0,     0,     0,   894,
       0,   894,     0,     0,     0,     0,     0,     0,  2560,  1353,
       0,     0,   362,   605,   605,   605,     0,     0,     0,     0,
     605,   605,     0,     0,     0,   605,   605,     0,     0,     0,
       0,     0,   605,     0,     0,     0,     0,     0,     0,     0,
       0,   605,     0,   605,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   713,   605,     0,   605,
    1754,     0,     0,   713,  1755,  1549,     0,     0,     0,  3331,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3336,
       0,     0,   713,     0,  1756,  1757,     0,     0,     0,     0,
    1651,     0,  3205,     0,     0,     0,  2331,  1758,     0,  1549,
       0,     0,     0,     0,  2171,   597,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   362,     0,
     605,     0,     0,     0,     0,     0,     0,     0,  1759,     0,
       0,  1760,     0,     0,     0,     0,   728,     0,  1508,     0,
       0,     0,     0,     0,  1761,     0,  1762,     0,     0,     0,
       0,     0,     0,     0,     0,   362,     0,     0,   362,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2560,
       0,     0,     0,  1749,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1584,  1585,  1586,   729,     0,     0,
    2428,     0,  2459,     0,     0,  1752,     0,     0,   605,  1550,
    1753,  1549,     0,   730,   605,  1763,     0,     0,     0,     0,
     618,     0,     0,     0,  1026,  3331,     0,     0,     0,  1026,
    1026,   731,     0,     0,     0,     0,     0,  1550,  1550,   713,
    1550,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1550,     0,  1550,     0,     0,
     732,     0,  1189,     0,     0,     0,   733,     0,     0,     0,
       0,     0,     0,     0,  1552,     0,     0,     0,     0,     0,
     734,  1189,  1764,     0,     0,  1550,     0,   713,     0,     0,
       0,     0,     0,  1765,  1766,  1767,  1553,  1768,  1769,  1770,
    1771,  1772,  1773,   735,     0,  2848,     0,  3331,  1026,     0,
       0,     0,     0,   605,     0,  1550,     0,     0,  1754,  1749,
       0,   605,  1755,     0,   605,   605,     0,     0,     0,     0,
       0,  1550,   713,  1750,     0,     0,     0,     0,     0,     0,
    1026,  1752,  1756,  1757,     0,     0,  1753,     0,     0,     0,
       0,     0,     0,     0,     0,  1758,     0,   736,  1549,  1550,
       0,     0,  3484,     0,     0,   795,     0,     0,   605,  1550,
       0,     0,   605,     0,     0,     0,   605,  1050,     0,     0,
    1550,     0,     0,     0,     0,     0,   605,     0,  1549,  1760,
       0,   605,     0,     0,  1550,     0,     0,     0,  3484,   737,
       0,     0,  1761,     0,     0,   738,     0,     0,     0,     0,
     739,     0,     0,     0,     0,     0,  1828,     0,     0,     0,
       0,     0,     0,     0,     0,  3484,     0,  1550,     0,     0,
       0,  1550,     0,     0,     0,   740,   741,   605,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   742,     0,     0,
       0,     0,   743,     0,  1754,     0,     0,     0,  1755,     0,
       0,   744,     0,  1763,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1756,  1757,
     605,  1550,     0,     0,     0,     0,     0,     0,   618,  1651,
       0,  1758,  2618,     0,  1655,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1550,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     362,     0,  1759,     0,   362,  1760,     0,     0,  1024,     0,
    1764,  1550,  1024,     0,   605,     0,     0,     0,  1761,     0,
    1762,  1765,  1766,  1767,     0,  1768,  1769,  1770,  1771,  1772,
    1773,     0,     0,     0,     0,  1550,     0,     0,     0,  2018,
       0,     0,  1024,     0,     0,     0,     0,     0,     0,     0,
       0,  1749,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1750,     0,     0,     0,     0,
       0,     0,     0,  1752,     0,     0,     0,     0,  1753,  1763,
       0,  1131,  1552,     0,  1024,     0,     0,     0,     0,     0,
    1024,     0,     0,  1549,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1553,  1749,     0,     0,     0,  1552,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1552,     0,     0,     0,  1752,     0,     0,
       0,  1553,  1753,     0,     0,     0,  2171,     0,   605,     0,
     605,     0,     0,     0,     0,  1553,  1764,  1549,  1550,     0,
       0,     0,     0,     0,     0,     0,     0,  1765,  1766,  1767,
       0,  1768,  1769,  1770,  1771,  1772,  1773,  1552,     0,     0,
    1749,  3092,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2153,  1552,  1306,  2156,     0,  1754,     0,   894,  1553,
    1755,   894,  1752,     0,     0,     0,     0,  1753,     0,  1552,
       0,     0,     0,   362,  1553,     0,     0,  3064,     0,     0,
    1756,  1757,     0,  1306,     0,     0,     0,     0,  1189,  1189,
       0,  1553,     0,  1758,  1552,     0,     0,     0,  1550,     0,
    2197,     0,     0,     0,     0,   605,     0,     0,     0,     0,
   -1868,     0,     0,     0,  1755,     0,  1553,     0,     0,     0,
       0,   605,     0,     0,  1759,     0,     0,  1760,   605,   605,
       0,     0,  1550,     0,  1756,  1757,     0,  1552,     0,     0,
    1761,     0,  1762,     0,     0,     0,  1552, -1868,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1553,
     605,     0,   605,   605,     0,     0,     0,     0,  1553,     0,
       0,   605,     0,     0,     0,  1754,     0,   605,     0,  1755,
       0,  1760,   605,     0,   605,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1761,   605,   605,     0,     0,  1756,
    1757,  1763,     0,     0,     0,   605,  2321,     0,     0,     0,
       0,     0,  1758,     0,     0,     0,  1306,   362,     0,     0,
       0,  1024,     0,     0,     0,     0,     0,  1024,     0,     0,
       0,     0,     0,     0,  1550,     0,     0,     0,   605,   605,
       0,     0,     0,  1759,     0,     0,  1760,  1563,     0,   618,
       0,     0,     0,     0,     0, -1868,     0,     0,     0,  1761,
       0,     0,     0,     0,     0,  2349,     0,     0,  1764,     0,
       0,     0,  1024,     0,     0,     0,  1552,     0,     0,  1765,
    1766,  1767,     0,  1768,  1769,  1770,  1771,  1772,  1773,     0,
       0,     0,     0,  3221,     0,     0,     0,     0,  1553,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1763,     0,  1764,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   605,     0,     0,  1768,  1769,  1770,
    1771,  1772,  1773,     0,   605,    80,  1749,     0,     0,     0,
       0,    84,     0,     0,     0,     0,     0,     0,    90,     0,
      91,     0,  1306,    94,     0,     0,     0,     0,  1752,     0,
       0,     0,     0,  1753,   104,     0,     0,     0,     0,     0,
       0,  1550,     0,     0,     0,     0,     0,  1764,   605,  1306,
       0,     0,   117,   118,     0,     0,     0,     0,  1765,  1766,
    1767,     0,  1768,  1769,  1770,  1771,  1772,  1773,     0,     0,
       0,  1550,     0,  1306,  1306,     0,  1306,     0,     0,   126,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   127,
     128,   129,     0,     0,  1306,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   937,     0,     0,  2470,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   138,     0,   139,   140,     0,     0,     0,
     142,   143,     0,     0,  1552,  1552,     0,  1810,     0,   145,
     146,  1754,     0,     0,     0,  1755,     0,     0,     0,     0,
       0,     0,     0,   148,     0,   149,  1553,  1553,   152,     0,
       0,     0,     0,     0,   153,  1756,  1757,  1306,     0,     0,
    1306,  1306,     0,   154,     0,  2534,     0,     0,  1758,   155,
     804,   362,   362,   362,   156,     0,   158,   605,   605,     0,
     160,   805,     0,     0,     0,     0,     0,  2544,     0,     0,
       0,   164,     0,   165,     0,  2565,     0,     0,     0,     0,
       0,   806,  1760,     0,   605,     0,     0,     0,     0,   605,
     605,   605,   605,   605,     0,  1761,   362,   605,     0,   170,
       0,   807,  1552,   362,     0,  1563,     0,     0,     0,   362,
       0,     0,     0,   894,     0,     0,     0,   808,     0,  1552,
       0,     0,   179,   180,  1553,     0,     0,     0,   181,     0,
       0,     0,  1956,     0,     0,   809,   182,     0,     0,     0,
       0,  1553,     0,     0,     0,     0,  1563,     0,   894,     0,
       0,   605,     0,   187,     0,     0,  1763,     0,     0,     0,
       0,     0,     0,     0,   810,     0,  1550,     0,     0,     0,
     811,     0,     0,     0,   894,     0,     0,     0,     0,     0,
       0,     0,     0,   197,   812,     0,     0,     0,     0,     0,
    1563,     0,     0,   199,     0,  2618,   200,     0,   201,     0,
       0,     0,   202,     0,     0,  2058,     0,   203,     0,     0,
     205,     0,     0,     0,   207,     0,     0,     0,     0,   208,
    1550,     0,  1563,  1764,   209,     0,     0,   211,     0,     0,
       0,     0,     0,   214,     0, -1868, -1868,     0,  1768,  1769,
    1770,  1771,  1772,  1773,     0,     0,     0,  1563,     0,     0,
     362,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     220,   813,   221,     0,     0,     0,     0,     0,   223,   814,
     224,     0,     0,   225,     0,  2745,   226,     0,     0,     0,
       0,     0,   815,  2171,   605,  1024,     0,  1024,     0,     0,
    1563,     0,  1024,   605,     0,     0,     0,     0,     0,  1563,
       0,     0,     0,   816,     0,     0,   605,   817,     0,   818,
       0,     0,   605,   605,   819,     0,     0,   605,   605,   231,
       0,     0,   605,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1024,     0,   820,
     821,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   822,     0,     0,     0,     0,   823,     0,     0,     0,
       0,     0,     0,     0,     0,   824,     0,     0,  1306,  1306,
       0,     0,     0,     0,   825,     0,  1306,     0,     0,  1306,
    1306,     0,     0,   605,     0,     0,     0,     0,  2232,     0,
       0,  1306,  1306,     0,     0,     0,     0,     0,     0,  1306,
       0,     0,     0,  1306,  1306,  1306,  1306,     0,     0,     0,
       0,     0,     0,  1306,  1306,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1563,
    1306,   362,     0,     0,  1306,     0,     0,     0,  1306,     0,
    1552,     0,  1306,     0,     0,  1306,  1306,  1306,  1306,  1306,
    1306,  1306,  1306,  1306,     0,  1306,     0,     0,     0,  1306,
       0,     0,  1553,  1306,     0,     0,     0,     0,  1552,  1552,
       0,  1552,     0,     0,     0,   605,     0,     0,     0,     0,
       0,     0,     0,     0,  1749,     0,  1552,     0,  1552,     0,
    1553,  1553,     0,  1553,     0,     0,   708,  2928,     0,     0,
       0,     0,     0,  2934,     0,     0,  1752,   362,  1553,     0,
    1553,  1753,     0,     0,     0,     0,  1552,     0,   708,  1306,
       0,     0,  2950,     0,     0,   605,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1553,     0,
       0,     0,     0,     0,     0,     0,  1552,     0,     0,   362,
    1749,   362,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1552,     0,  1750,  2989,     0,  2990,  1553,     0,
       0,     0,  1752,     0,     0,     0,     0,  1753,     0,     0,
       0,     0,     0,     0,  1553,     0,  3065,     0,     0,     0,
    1552,     0,     0,     0,   362,     0,     0,     0,     0,  1189,
    1552,     0,     0,     0,     0,     0,   890,     0,     0,  1306,
       0,  1552,  1553,   890,     0,   890,     0,     0,     0, -1868,
       0,     0,  1553,  1755,     0,  1552,   708,  1956,  1563,     0,
       0,     0,     0,  1553,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1756,  1757,     0,     0,  1553,     0,     0,
       0,     0,  1749,     0,     0,     0, -1868,     0,  1552,     0,
     605,   605,  1552,     0,     0,   605,  1750,     0,     0,     0,
       0,     0,     0,     0,  1752,     0,     0,     0,     0,  1753,
    1553,     0,     0, -1865,  1553,  1754,     0,     0,     0,  1755,
    1760,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   605,     0,  1761,  3074,  3075,     0,     0,     0,  1756,
    1757,     0,  1552,     0,     0,     0,     0,     0,     0,  1306,
       0,     0,  1758,     0, -1865,  1563,     0,     0,   605,     0,
       0,     0,     0,     0,  1553,  1552, -1865,     0,     0,     0,
    1306, -1865,  1563,     0,     0,     0, -1865,     0,     0, -1865,
       0, -1865,     0,  1759,     0,     0,  1760,  1553,     0,     0,
       0,     0,  1552,     0, -1868,     0,     0,     0,     0,  1761,
       0,  1762,     0,     0,     0,     0, -1865,     0,     0,     0,
       0,     0,     0,     0,  1553,     0,  1552,  1754,     0,     0,
       0,  1755,     0,     0, -1865,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1024,  1553,     0,
       0,  1756,  1757,     0,     0,     0,  1306,     0,     0,     0,
       0,     0,     0,     0,  1758,     0,     0,     0,     0,     0,
    1763,  1764,  1749,     0,     0, -1865,     0,     0,     0,     0,
       0,     0,     0, -1865,     0,     0,  1768,  1769,  1770,  1771,
    1772,  1773,  3140,     0,  1752,  1759,     0,     0,  1760,  1753,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1306,  1761,     0,  1762,     0,  3150,     0,     0, -1865,     0,
       0,     0,     0,     0,     0,  3154,     0,     0,     0,     0,
       0,     0,     0,  1306,     0,     0,     0,  1764,     0,  1552,
       0,     0,     0,     0,     0,     0,     0,     0,  1765,  1766,
    1767,     0,  1768,  1769,  1770,  1771,  1772,  1773,   866,     0,
       0,  1553,  3242,     0,     0,  1306,     0,     0,  1306,     0,
       0,     0,  1763,     0,  3068,     0,     0,     0, -1865,     0,
    1306,  1306,  1306,  1306,     0,     0,     0,     0,     0,  1306,
       0,     0,     0,     0,     0,     0, -1865,     0,     0,  1306,
    1306,     0,  1306, -1865, -1865, -1865,     0, -1868,     0,     0,
       0,  1755,     0,     0,  1306,     0,  1306,     0,     0,  1552,
    1306,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1865,  1756,  1757, -1865, -1865, -1865,     0,     0,     0,  1764,
       0,  1553,     0,  1024, -1868,  1306,  1306,     0,     0,     0,
    1765,  1766,  1767,  1552,  1768,  1769,  1770,  1771,  1772,  1773,
       0,     0,     0,     0,  3378,     0,  1306,     0,  3243,  3244,
    3245,  3246,  1306,     0,     0,  1553,     0,     0,  1760,     0,
    1306,  1306,  1306,     0,     0,     0,     0,     0,     0,     0,
       0,  1761,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1563,     0,     0,     0,     0,  1749,     0,
       0,     0,     0,     0,  1306,     0,     0,     0,     0,     0,
       0,     0,  1750,     0,     0,     0,     0,     0,     0,     0,
    1752,  1956,  1563,     0,  1563,  1753,     0,     0,     0,     0,
    1749,     0,     0,     0,     0,     0,     0,     0,     0,  1563,
       0,  1563, -1868,     0,  1750,  1552,     0,     0,  2353,     0,
       0,     0,  1752,     0,   708,     0,     0,  1753,     0,     0,
       0,     0,  1021,     0,     0,     0,  1021,  1553,     0,  1563,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1021,     0,     0,  1563,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1764,
       0,     0,     0,     0,  2872,  1563,     0,     0,     0,  2354,
       0,     0,     0,     0,  1768,  1769,  1770,  1771,  1772,  1773,
       0,     0,     0,  1754,     0,     0,     0,  1755,  1021,     0,
       0,     0,   362,  1563,  1021,     0,     0,     0,     0,     0,
       0,     0,     0,  1563,     0,     0,     0,  1756,  1757,     0,
       0,     0,     0,     0,  1563,  1754,     0,     0,     0,  1755,
    1758,     0,     0,     0,     0,     0,     0,     0,  1563,     0,
    3376,     0,     0,     0,     0,     0,     0,     0,     0,  1756,
    1757,     0,  1552,     0,  1024,     0,     0,     0,  1024,     0,
    1189,  1759,  1758,     0,  1760,     0,     0,     0,     0,     0,
       0,  1563,     0,     0,  1553,  1563,     0,  1761,     0,  1762,
       0,     0,  1552,  3414,     0,     0,   604,     0,     0,     0,
       0,  1024,     0,  1759,     0,     0,  1760,  1301,     0,     0,
       0,     0,   890,     0,  1553,   890,     0,     0,     0,  1761,
       0,  1762,     0,     0,     0,  3422,  1306,     0,     0,     0,
       0,     0,  1306,     0,  1749,  1563,     0,  1301,     0,     0,
       0,     0,     0,     0,  1306,     0,     0,     0,  1763,     0,
    1306,     0,     0,     0,  1306,     0,  1752,     0,  1563,  1306,
    1749,  1753,  1306,  1306,  1306,  1306,  1306,  1306,  1306,  1306,
    1306,  1306,   851,     0,  1750,     0,  1306,  1306,     0,     0,
    1763,     0,  1752,     0,     0,  1563,     0,  1753,     0,     0,
    1306,     0,   604,     0,   851,     0,     0,  1306,     0,     0,
    1306,     0,  1306,     0,     0,     0,     0,     0,     0,  1563,
    1306,  1306,  1306,     0,     0,  1764,  1306,     0,     0,  1306,
       0,     0,     0,  1749,  2355,     0,  1765,  1766,  1767,     0,
    1768,  1769,  1770,  1771,  1772,  1773,  3240,  1750,     0,     0,
    3441,     0,     0,     0,     0,  1752,     0,  1764,     0,     0,
    1753,     0,     0,     0,     0,     0,     0,     0,  1765,  1766,
    1767,     0,  1768,  1769,  1770,  1771,  1772,  1773,     0, -1868,
    1301,   708,     0,  1755,     0,  1021,     0,     0,     0,     0,
       0,  1021,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1756,  1757,  1754,     0,     0,     0,  1755,
       0,  1561,     0,     0,     0,     0, -1868,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1552,     0,  1756,
    1757,     0,  1563,     0,     0,     0,  1021,     0,     0,     0,
       0,     0,  1758,     0,     0,     0,     0,     0,  2696,  1553,
    1760,     0,     0,  2697,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1761,     0,     0,     0,     0,  1754,     0,
       0,     0,  1755,  1759,     0,     0,  1760,     0,     0,     0,
       0,  1552,     0,     0,     0,     0,     0,     0,     0,  1761,
       0,  1762,  1756,  1757,     0,     0,     0,     0,     0,     0,
       0,  1306,     0,  1553,     0,  1758,     0,     0,     0,     0,
       0,     0,  1563,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1868,     0,  1301,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1759,     0,     0,  1760,
       0,     0,  1749,     0,     0,     0,  1563,     0,     0,     0,
    1763,     0,  1761,  1301,  1762,     0,  1750,     0,     0,  1751,
    1024,     0,     0,     0,  1752,  1024,     0,     0,  1024,  1753,
       0,     0,     0,     0,     0,     0,     0,  1301,  1301,     0,
    1301,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1764,     0,     0,  2657,     0,     0,     0,  1301,     0,
       0,  1306,     0,     0,     0,     0,  1768,  1769,  1770,  1771,
    1772,  1773,     0,  1763,     0,     0,     0,  1764,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1765,  1766,
    1767,     0,  1768,  1769,  1770,  1771,  1772,  1773,     0,     0,
       0,     0,  1306,  1306,     0,     0,     0,  1306,  1563,     0,
       0,     0,     0,     0,  1306,  1306,     0,     0,  1306,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1301,     0,     0,  1301,  1301,     0,  1754,     0,     0,
    1764,  1755,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1765,  1766,  1767,     0,  1768,  1769,  1770,  1771,  1772,
    1773,  1756,  1757,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1758,     0,     0,     0,   751,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1306,     0,     0,     0,     0,     0,     0,  1561,
       0,     0,     0,   708,     0,  1759,     0,   890,  1760,     0,
       0,     0,     0,     0,     0,     0,     0,   751,     0,     0,
       0,  1761,     0,  1762,     0,   751,  1954,     0,     0,     0,
    1024,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1561,     0,   890,     0,     0,     0,  1306,     0,     0,     0,
    1024,     0,     0,     0,     0,  1563,     0,     0,     0,     0,
       0,   751,   751,     0,     0,     0,     0,     0,   890,     0,
       0,     0,     0,     0,  1306,     0,     0,  1306,     0,     0,
       0,     0,  1763,     0,  1561,  1563,  1306,  1306,     0,     0,
    1306,     0,     0,     0,     0,     0,     0,  1306,  1306,  1561,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1561,     0,     0,     0,
       0,  1306,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   604,
    1024,  1561,     0,     0,   708,     0,     0,     0,     0,  1764,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1765,  1766,  1767,     0,  1768,  1769,  1770,  1771,  1772,  1773,
       0,     0,     0,     0,     0,     0,  1024,  1306,     0,  1021,
       0,  1021,     0,     0,  1561,     0,  1021,     0,     0,     0,
       0,     0,     0,  1561,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1306,  1306,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   851,     0,   851,     0,   851,
       0,     0,     0,     0,  1749,   851,   851,     0,     0,     0,
       0,  1021,     0,     0,     0,     0,     0,     0,  1750,     0,
       0,  2655,     0,     0,     0,     0,  1752,     0,     0,     0,
       0,  1753,     0,   604,     0,     0,     0,     0,  1024,     0,
       0,     0,  1301,  1301,     0,     0,     0,     0,     0,     0,
    1301,     0,     0,  1301,  1301,     0,     0,     0,     0,     0,
     604,     0,     0,     0,     0,  1301,  1301,     0,     0,     0,
       0,   604,   604,  1301,     0,     0,     0,  1301,  1301,  1301,
    1301,     0,     0,     0,     0,     0,     0,  1301,  1301,     0,
    1563,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1561,  1301,   708,     0,  1024,  1301,     0,
       0,     0,  1301,     0,     0,     0,  1301,     0,     0,  1301,
    1301,  1301,  1301,  1301,  1301,  1301,  1301,  1301,     0,  1301,
       0,  1387,     0,  1301,     0,     0,     0,  1301,     0,  1754,
       0,  1024,     0,  1755,  1563,     0,     0,     0,   604,   604,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1387,     0,     0,  1756,  1757,     0,     0,     0,     0,  1749,
       0,     0,     0,     0,     0,     0,  1758,     0,     0,     0,
       0,     0,     0,  1750,     0,     0,     0,     0,     0,     0,
       0,  1752,     0,  1301,     0,     0,  1753,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1759,     0,     0,
    1760,     0,     0,    73,  1749,     0,     0,     0,     0,     0,
       0,     0,     0,  1761,     0,  1762,     0,     0,  1750,     0,
       0,  2705,     0,     0,     0,     0,  1752,     0,     0,     0,
       0,  1753,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   604,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   708,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1301,  1763,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   589,     0,     0,     0,     0,
       0,  1954,  1561,     0,  1754,  1749,     0,     0,  1755,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1750,
       0,     0,   604,     0,     0,     0,     0,  1752,  1756,  1757,
       0,     0,  1753,     0,     0,     0,     0,     0,     0,     0,
       0,  1758,     0,     0,     0,     0,  1017,     0,     0,  1754,
    1017,  1764,   751,  1755,     0,     0,     0,   751,   751,   790,
       0,     0,  1765,  1766,  1767,     0,  1768,  1769,  1770,  1771,
    1772,  1773,  1759,  1756,  1757,  1760,     0,     0,   751,     0,
    1017,     0,     0,     0,     0,     0,  1758,     0,  1761,     0,
    1762,   589,     0,  1301,     0,     0,     0,     0,     0,  1561,
    2674,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1301,     0,  1561,  1759,     0,     0,
    1760,   751,  1017,     0,     0,  2710,     0,     0,  1017,     0,
     604,     0,     0,  1761,     0,  1762,     0,     0,     0,     0,
    1754,   604,     0,     0,  1755,     0,     0,     0,     0,  1763,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1756,  1757,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1758,     0,   751,
       0,  1021,     0,     0,     0,   751,   604,     0,     0,  1387,
    1301,  1387,  1387,     0,  1763,     0,   751,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1759,     0,
       0,  1760,     0,     0,     0,     0,  1764,     0,     0,     0,
       0,     0,     0,     0,  1761,   751,  1762,  1765,  1766,  1767,
       0,  1768,  1769,  1770,  1771,  1772,  1773,     0,     0,     0,
     751,     0,     0,     0,  1301,   751,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   604,     0,     0,     0,   751,
       0,  1764,     0,     0,     0,     0,     0,  1301,     0,     0,
       0,     0,  1765,  1766,  1767,     0,  1768,  1769,  1770,  1771,
    1772,  1773,     0,     0,     0,  1763,  1749,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1301,
    1750,     0,  1301,     0,     0,     0,     0,     0,  1752,     0,
       0,     0,     0,  1753,  1301,  1301,  1301,  1301,     0,     0,
       0,     0,     0,  1301,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1301,  1301,     0,  1301,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1301,     0,
    1301,     0,  1764,     0,  1301,     0,     0,     0,     0,     0,
       0,     0,     0,  1765,  1766,  1767,     0,  1768,  1769,  1770,
    1771,  1772,  1773,     0,  1387,     0,     0,  1021,     0,  1301,
    1301,     0,     0,     0,     0,     0,     0,     0,   751,  1017,
       0,     0,     0,     0,     0,  1017,     0,     0,     0,     0,
    1301,     0,     0,     0,     0,     0,  1301,     0,     0,     0,
       0,     0,     0,     0,  1301,  1301,  1301,     0,     0,     0,
       0,  1754,     0,     0,     0,  1755,     0,     0,     0,     0,
       0,     0,     0,     0,   751,   751,   751,  1561,     0,     0,
    1017,     0,     0,     0,     0,  1756,  1757,     0,  1301,   604,
       0,     0,     0,     0,     0,     0,     0,     0,  1758,   851,
       0,     0,     0,     0,     0,  1954,  1561,     0,  1561,     0,
       0,     0,     0,     0,     0,     0,   790,     0,     0,     0,
       0,     0,     0,  1561,     0,  1561,     0,     0,     0,  1759,
       0,     0,  1760,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   751,     0,     0,  1761,     0,  1762,     0,     0,
       0,     0,     0,  1561,     0,     0,     0,     0,     0,     0,
       0,   751,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1867,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1561,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1561,
       0,     0,     0,   851,   851,   851,  1763,     0,     0,     0,
     604,   851,     0, -1867,     0,   851,   851,     0,     0,     0,
       0,     0,   851,     0,     0, -1867,   708,  1561,  3011,     0,
   -1867,   851,     0,   851,     0, -1867,     0,  1561, -1867,     0,
   -1867,     0,     0,     0,     0,     0,     0,   851,  1561,   851,
       0,    73,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1561,     0,     0, -1867,     0,     0,     0,     0,
       0,     0,     0,  1764,     0,     0,     0,     0,  1021,     0,
       0,     0,  1021, -1867,  1765,  1766,  1767,     0,  1768,  1769,
    1770,  1771,  1772,  1773,     0,  1561,   751,     0,     0,  1561,
       0,     0,     0,     0,     0,     0,     0,     0,   589,     0,
     604,     0,     0,     0,     0,  1021,     0,     0,     0,     0,
       0,     0,     0,     0, -1867,     0,     0,     0,     0,     0,
       0,     0, -1867,     0,     0,  1555,     0,     0,     0,     0,
    1301,     0,     0,     0,     0,     0,  1301,     0,     0,  1561,
       0,     0,     0,     0,     0,     0,     0,     0,  1301,     0,
       0,     0,     0,     0,  1301,     0,     0, -1867,  1301,     0,
       0,     0,  1561,  1301,     0,     0,  1301,  1301,  1301,  1301,
    1301,  1301,  1301,  1301,  1301,  1301,     0,     0,  1387,     0,
    1301,  1301,     0,     0,   604,     0,     0,     0,     0,  1561,
       0,  1387,     0,     0,  1301,     0,     0,   866,     0,     0,
       0,  1301,     0,     0,  1301,     0,  1301,     0,     0,     0,
       0,     0,   589,  1561,  1301,  1301,  1301, -1867,     0,     0,
    1301,     0,     0,  1301,     0,     0,     0,     0,     0,   751,
       0,     0,     0,     0,     0, -1867,     0,     0,   751,   589,
       0,     0, -1867, -1867, -1867,     0,     0,     0,     0,     0,
     589,   589,     0,     0,     0,   712,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   714,     0,     0,     0, -1867,
       0,     0, -1867, -1867, -1867,     0,     0,     0,     0,     0,
       0,     0,     0,   851,     0,     0,     0,     0,     0,     0,
       0,  1387,     0,     0,  1387,  1387,     0,     0,     0,     0,
     748,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     798,     0,     0,   802,     0,     0,     0,   798,     0,     0,
       0,   847,     0,     0,     0,     0,  1561,   589,   589,     0,
       0,    73,    73,     0,    73,     0,     0,     0,   604,  1408,
       0,     0,   604,   869,     0,     0,   604,     0,     0,     0,
       0,     0,     0,  2135,     0,  1017,   851,     0,   798,     0,
    1017,   851,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   751,     0,     0,   751,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1301,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1017,  1561,   604,   751,   751,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     751,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   589,     0,     0,     0,     0,
    1561,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     604,     0,     0,  1555,  1021,     0,     0,     0,     0,  1021,
       0,     0,  1021,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1555,     0,     0,     0,  1749,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1555,  1301,     0,     0,  1750,     0,
       0,   589,     0,     0,   851,     0,  1752,     0,     0,     0,
       0,  1753,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   751,     0,     0,     0,
       0,     0,   980,     0,     0,     0,  1301,  1301,  1555,     0,
       0,  1301,  1561,     0,     0,     0,     0,     0,  1301,  1301,
       0,     0,  1301,  1555,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1555,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   751,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1555,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   589,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1754,
     589,     0,     0,  1755,     0,     0,  1301,     0,   851,     0,
    1387,     0,     0,     0,     0,     0,     0,     0,  1555,     0,
       0,     0,     0,  1756,  1757,     0,     0,  1555,     0,     0,
       0,     0,     0,     0,     0,     0,  1758,     0,     0,     0,
       0,     0,     0,     0,  1021,   589,     0,     0,  1408,     0,
    1408,  1408,     0,     0,     0,     0,     0,     0,     0,     0,
    1301,     0,     0,     0,  1021,     0,     0,  1759,     0,  1561,
    1760,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1761,     0,  1762,     0,     0,  1301,     0,
       0,  1301,     0,     0,     0,     0,     0,     0,     0,  1561,
    1301,  1301,     0,     0,  1301,   851,     0,     0,     0,     0,
       0,  1301,  1301,     0,   589,     0,     0,     0,     0,     0,
       0,  1387,     0,    73,     0,     0,     0,    73,  1387,  1387,
       0,     0,     0,     0,     0,  1301,     0,     0,     0,     0,
       0,     0,     0,     0,  1763,     0,     0,   751,     0,   988,
     989,     0,     0,     0,  1021,     0,     0,  1555,     0,     0,
     604,     0,   604,   604,     0,     0,     0,     0,     0,     0,
       0,   604,     0,     0,     0,     0,     0,  1387,     0,     0,
       0,     0,   851,     0,   851,     0,     0,     0,     0,     0,
    1021,  1301,     0,     0,     0,  2900,   604,     0,     0,     0,
       0,     0,     0,     0,     0,  1387,     0,     0,     0,     0,
       0,  1764,     0,     0,     0,   751,     0,  1301,  1301,     0,
       0,     0,  1765,  1766,  1767,     0,  1768,  1769,  1770,  1771,
    1772,  1773,     0,     0,     0,     0,     0,   751,   604,   604,
       0,     0,     0,     0,     0,   751,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2135,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1021,     0,     0,     0,  1035,     0,     0,  1052,
       0,     0,  1056,  1057,   762,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   763,     0,     0,     0,     0,
       0,     0,     0,     0,  1096,     0,     0,     0,   589,     0,
       0,     0,     0,     0,     0,   764,     0,  1112,     0,     0,
    1113,     0,     0,     0,  1561,     0,     0,     0,     0,     0,
       0,     0,     0,   765,   851,  -485,     0,   980,   798,     0,
       0,  1021,     0,     0,   851,     0,  1136,     0,     0,     0,
       0,   766,     0,     0,     0,  1555,  1555,   767,  1153,     0,
       0,     0,  1155,  1157,     0,   888,     0,     0,     0,   768,
       0,     0,   888,     0,   888,  1021,     0,     0,  1561,     0,
       0,     0,     0,     0,     0,     0,  1177,  1178,   604,     0,
       0,     0,     0,   980,     0,     0,     0,     0,  -612,     0,
     769,     0,     0,     0,   770,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1194,     0,  1195,  -598,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   589,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -402,     0,     0,     0,   751,   980,     0,     0,     0,
       0,  2135,   771,  1555,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1555,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   772,     0,   773,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -402,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   604,   604,   589,
       0,     0,     0,     0,     0,     0,     0,   774,     0,     0,
       0,  -612,     0,   775,     0,     0,     0,  1417,     0,     0,
    1419,     0,     0,  1421,   851,     0,     0,     0,     0,   851,
     851,   851,   851,   851,     0,     0,     0,   851,     0,     0,
       0,     0,     0,     0,   776,   777,     0,   778,     0,     0,
       0,     0,     0,     0,     0,   779,     0,     0,     0,   780,
     781,     0,     0,     0,   782,     0,     0,     0,     0,   783,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   589,     0,     0,     0,     0,     0,     0,
    1408,   604,    73,  1515,    73,     0,     0,     0,  1516,     0,
       0,     0,  1518,     0,     0,     0,     0,     0,     0,  1564,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1593,     0,     0,   751,     0,     0,
       0,     0,     0,   751,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   751,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2438,
       0,     0,  2135,     0,     0,     0,  2135,  1645,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1674,     0,     0,     0,   751,     0,   751,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1017,
       0,     0,     0,     0,   604,     0,     0,     0,     0,     0,
       0,     0,     0,   851,     0,     0,     0,   589,     0,   751,
       0,   589,     0,     0,     0,   589,   851,     0,     0,     0,
       0,     0,   604,   604,     0,  2514,     0,   604,   604,     0,
       0,  1555,   604,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1555,
    1555,  2538,  1555,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   589,  1555,     0,  1555,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   604,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1555,     0,     0,
       0,     0,     0,     0,   751,   751,     0,     0,     0,   589,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1019,     0,     0,     0,  1019,     0,  1555,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1555,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1019,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1555,     0,     0,     0,   604,     0,     0,     0,     0,
       0,  1555,     0,     0,     0,     0,     0,     0,     0,  1902,
       0,     0,  1555,     0,     0,     0,     0,  1019,     0,     0,
       0,     0,     0,  1019,     0,     0,  1555,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   604,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1555,
       0,     0,     0,  1555,     0,     0,     0,     0,     0,     0,
       0,     0,   751,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   751,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   751,     0,     0,     0,  1408,
       0,     0,     0,  1555,     0,     0,  1298,     0,     0,     0,
       0,   888,     0,     0,   888,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1555,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1298,     0,  2135,     0,
       0,     0,     0,  2135,     0,     0,  2135,     0,     0,     0,
       0,     0,     0,  1555,     0,     0,     0,  2099,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     851,   851,     0,     0,     0,     0,     0,  1555,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2830,  2145,     0,     0,     0,
       0,     0,  2833,  2152,  2834,  2154,  2155,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2164,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   751,   751,
     751,   751,     0,     0,     0,     0,     0,     0,     0,   589,
       0,   589,   589,     0,     0,     0,     0,     0,     0,     0,
     589,     0,     0,     0,  1556,     0,  1408,     0,     0,  1298,
       0,     0,     0,  2514,  1019,     0,     0,     0,     0,     0,
    1019,     0,     0,     0,  2898,   589,     0,     0,     0,     0,
    1555,     0,     0,     0,  1408,     0,     0,     0,     0,     0,
    1559,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1019,     0,   589,   589,     0,
       0,     0,     4,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     5,     0,  1017,     0,
       0,     0,     0,     0,     0,     6,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2330,     7,     8,  2135,     0,
    1555,  1557,     0,     0,    10,    11,     0,     0,     0,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,  1555,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1298,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1298,     0,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1017,     0,
     751,     0,     0,     0,     0,     0,  1298,  1298,     0,  1298,
       0,     0,     0,     0,     0,     0,     0,   589,     0,   980,
     751,     0,     0,     0,     0,     0,     0,  1298,     0,     0,
       0,     0,     0,  2388,  1017,     0,     0,     0,     0,     0,
       0,  2395,     0,   751,     0,     0,  1555,  2399,     0,     0,
       0,     0,  2403,     0,     0,     0,     0,    37,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   751,    38,     0,     0,     0,
       0,     0,     0,     0,  2423,     0,  2424,     0,     0,  2426,
       0,     0,     0,     0,     0,     0,    39,     0,     0,     0,
    1298,     0,     0,  1298,  1298,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1017,     0,  2445,  2446,
       0,     0,     0,     0,     0,     0,     0,    40,     0,     0,
      41,     0,  1556,     0,  2461,  2464,  2465,     0,  2469,     0,
       0,  2471,  2472,  2473,     0,     0,     0,  2479,     0,     0,
    2482,    42,     0,     0,     0,     0,   589,   589,     0,  1556,
       0,     0,     0,     0,     0,     0,     0,     0,  1559,     0,
       0,     0,     0,  1556,     0,     0,   888,     0,     0,     0,
       0,     0,     0,     0,     0,  1017,     0,     0,  2514,  2514,
    2514,  2514,  2514,  1555,     0,  1951,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1559,
       0,   888,    43,     0,     0,     0,     0,  1556,     0,  1017,
       0,     0,     0,  1555,     0,     0,     0,     0,     0,     0,
       0,     0,  1556,     0,     0,     0,     0,   888,     0,  1557,
       0,     0,     0,     0,     0,     0,     0,     0,    44,  1556,
     589,     0,     0,  1559,     0,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,     0,  1557,     0,  1559,     0,
       0,     0,    46,     0,  1556,     0,     0,     0,     0,     0,
    1557,     0,     0,    47,     0,  1559,     0,   980,    48,    49,
       0,    50,     0,     0,     0,     0,     0,    52,    53,     0,
      54,    55,     0,     0,     0,    56,    57,    58,    59,    60,
    1559,     0,    61,    62,   990,     0,     0,  1556,   991,     0,
       0,  2640,    69,     0,  1557,     0,  1556,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1557,
       0,     0,     0,     0,     0,     0,     0,     0,  1019,     0,
    1019,     0,     0,  1559,     0,  1019,  1557,     0,     0,     0,
       0,     0,  1559,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1557,  3253,   589,     0,     0,     0,     0,     0,     0,
      73,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1019,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   589,   589,     0,     0,     0,   589,   589,  3279,     0,
       0,   589,  3283,     0,  1557,     0,     0,     0,     0,     0,
       0,  1298,  1298,  1557,     0,     0,     0,     0,     0,  1298,
       0,     0,  1298,  1298,     0,     0,     0,     0,  1555,     0,
       0,     0,     0,     0,  1298,  1298,  1556,     0,     0,     0,
       0,     0,  1298,     0,     0,     0,  1298,  1298,  1298,  1298,
       0,     0,     0,     0,     0,     0,  1298,  1298,     0,     0,
       0,     0,   589,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1559,  1298,     0,     0,     0,  1298,     0,     0,
       0,  1298,  1555,     0,     0,  1298,  2805,  2806,  1298,  1298,
    1298,  1298,  1298,  1298,  1298,  1298,  1298,     0,  1298,     0,
       0,     0,  1298,     0,     0,     0,  1298,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2821,
    2822,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1557,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   589,     0,     0,     0,     0,     0,
       0,     0,  1298,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1022,     0,     0,     0,  1022,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   589,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1022,     0,
       0,     0,     0,     0,     0,     0,  2904,  2906,  2908,     0,
       0,     0,     0,     0,  1556,  1556,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1298,     0,     0,     0,     0,     0,     0,     0,
    1022,     0,     0,  2948,     0,     0,  1022,     0,     0,     0,
    1951,  1559,     0,     0,     0,     0,     0,     0,   798,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1556,     0,     0,     0,     0,     0,     0,     0,
       0,  1557,  1557,     0,     0,     0,     0,     0,     0,  1556,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1302,
       0,     0,  1298,     0,     0,     0,     0,     0,  1559,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1298,     0,  1559,     0,     0,     0,  1302,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1557,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1019,     0,     0,     0,     0,     0,  1557,     0,     0,  1298,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1298,     0,     0,     0,     0,     0,     0,
       0,     0,  1302,     0,     0,     0,     0,  1022,     0,     0,
       0,     0,     0,  1022,     0,     0,  1298,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3107,  3108,     0,
       0,     0,     0,  1562,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1298,     0,
       0,  1298,     0,     0,     0,     0,     0,     0,  1022,     0,
       0,     0,     0,  1298,  1298,  1298,  1298,     0,     0,     0,
       0,     0,  1298,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1298,  1298,     0,  1298,     0,     0,     0,     0,
       0,  3143,     0,     0,     0,     0,     0,  1298,     0,  1298,
       0,     0,     0,  1298,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1019,     0,  1298,  1298,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1302,  1298,
    1556,     0,     0,     0,     0,  1298,     0,     0,     0,     0,
       0,     0,     0,  1298,  1298,  1298,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1302,     0,     0,  1556,  1556,
       0,  1556,     0,     0,     0,     0,  1559,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1556,  1298,  1556,  1302,
    1302,     0,  1302,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1951,  1559,     0,  1559,     0,     0,
    1302,     0,     0,     0,     0,     0,  1556,     0,     0,     0,
       0,     0,  1559,     0,  1559,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1556,  1557,     0,     0,
       0,     0,  1559,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1556,     0,     0,     0,     0,     0,     0,     0,
    3265,     0,     0,     0,     0,  1557,  1557,     0,  1557,     0,
       0,     0,  1559,  1302,     0,     0,  1302,  1302,     0,     0,
    1556,     0,     0,  1557,     0,  1557,     0,     0,  1559,     0,
    1556,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1556,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1557,     0,  1556,  1559,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1559,     0,  3317,     0,
       0,     0,     0,     0,     0,  2948,     0,  1559,     0,     0,
       0,  1562,     0,  1557,     0,     0,     0,     0,  1556,     0,
       0,  1559,  1556,     0,     0,     0,     0,     0,     0,  1557,
       0,     0,     0,     0,     0,     0,     0,  1019,  1955,     0,
       0,  1019,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1562,     0,  1559,     0,     0,  1557,  1559,     0,
       0,     0,     0,     0,     0,     0,     0,  1557,     0,     0,
       0,     0,  1556,     0,  1019,     0,     0,     0,  1557,     0,
       0,     0,     0,     0,  1560,     0,     0,     0,     0,     0,
       0,     0,  1557,     0,     0,  1556,  1562,     0,     0,  1298,
       0,     0,     0,     0,     0,  1298,     0,     0,  1559,     0,
       0,  1562,     0,     0,     0,     0,     0,  1298,     0,     0,
       0,     0,  1556,  1298,     0,  1557,     0,  1298,  1562,  1557,
       0,  1559,  1298,     0,     0,  1298,  1298,  1298,  1298,  1298,
    1298,  1298,  1298,  1298,  1298,     0,  1556,     0,     0,  1298,
    1298,     0,     0,  1562,     0,     0,     0,     0,  1559,     0,
       0,     0,     0,  1298,     0,     0,     0,     0,     0,     0,
    1298,     0,     0,  1298,     0,  1298,     0,     0,     0,  1557,
       0,     0,  1559,  1298,  1298,  1298,     0,     0,     0,  1298,
       0,  1022,  1298,  1022,     0,     0,  1562,     0,  1022,     0,
       0,     0,  1557,     0,     0,  1562,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1280,     0,  3435,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1557,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1022,     0,     0,     0,  1347,     0,     0,
       0,     0,     0,  1557,     0,     0,     0,     0,     0,  1556,
       0,     0,     0,     0,  3457,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1302,  1302,     0,     0,     0,     0,
       0,     0,  1302,     0,     0,  1302,  1302,     0,     0,     0,
       0,     0,     0,     0,     0,  1559,     0,  1302,  1302,     0,
       0,     0,     0,     0,     0,  1302,     0,     0,     0,  1302,
    1302,  1302,  1302,     0,     0,     0,     0,     0,     0,  1302,
    1302,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1562,  1302,     0,     0,  1556,
    1302,     0,     0,     0,  1302,     0,     0,     0,  1302,     0,
       0,  1302,  1302,  1302,  1302,  1302,  1302,  1302,  1302,  1302,
       0,  1302,     0,     0,  1298,  1302,  1557,     0,     0,  1302,
       0,     0,     0,  1556,     0,  1559,     0,     0,     0,     0,
    1503,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1559,
       0,     0,  1560,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1019,     0,  1302,     0,     0,  1019,     0,
       0,  1019,     0,     0,     0,     0,     0,     0,     0,  1952,
       0,     0,     0,     0,     0,     0,  1557,     0,     0,     0,
       0,     0,     0,  1560,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1298,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1556,     0,     0,     0,     0,
    1557,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1560,     0,     0,
       0,     0,     0,     0,     0,  1298,  1298,     0,     0,     0,
    1298,  1559,  1560,     0,     0,  1302,     0,  1298,  1298,     0,
       0,  1298,     0,     0,     0,     0,  1694,     0,     0,  1560,
       0,     0,     0,  1955,  1562,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1718,  1560,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1737,  1738,     0,
    1741,     0,  1557,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1298,     0,  1560,  1777,     0,
       0,     0,     0,     0,     0,     0,  1560,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1556,     0,     0,  1302,     0,     0,     0,     0,
       0,  1562,     0,  1019,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1302,     0,  1562,  1298,
       0,     0,  1556,  1019,     0,     0,     0,     0,  1559,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1848,     0,     0,  1855,  1857,     0,  1298,     0,     0,
    1298,     0,     0,     0,     0,     0,     0,     0,  1559,  1298,
    1298,     0,     0,  1298,     0,     0,     0,     0,     0,     0,
    1298,  1298,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1022,     0,     0,     0,     0,     0,     0,
       0,     0,  1302,     0,  1298,     0,     0,     0,     0,  1557,
       0,     0,     0,     0,     0,     0,  1560,     0,     0,     0,
       0,     0,     0,  1019,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1557,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1302,     0,     0,  1019,
    1298,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1302,
       0,     0,     0,     0,     0,     0,  1298,  1298,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1302,     0,     0,  1302,     0,     0,     0,     0,     0,
    1775,     0,     0,     0,     0,     0,  1302,  1302,  1302,  1302,
       0,     0,     0,     0,     0,  1302,     0,     0,     0,     0,
       0,  1019,     0,     0,     0,  1302,  1302,     0,  1302,     0,
       0,     0,     0,     0,     0,     0,     0,  1556,     0,     0,
    1302,     0,  1302,     0,     0,     0,  1302,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1775,     0,  1022,
       0,  1302,  1302,  1559,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1019,  1556,  1302,     0,  1952,  1952,     0,     0,  1302,     0,
       0,     0,     0,     0,     0,     0,  1302,  1302,  1302,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1019,     0,     0,  1559,     0,  1562,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1302,     0,     0,     0,  1557,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1955,  1562,     0,
    1562,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2216,     0,     0,     0,  2218,  1562,     0,  1562,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1560,  2240,     0,     0,     0,  2243,  1557,     0,
    2252,     0,     0,     0,     0,  1562,     0,  2259,  2264,  1560,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1775,  2275,     0,     0,     0,  2281,     0,
       0,     0,  2292,     0,     0,  1562,  2299,     0,     0,  2301,
    2302,  2303,  2304,  2305,  2306,  2307,  2308,  2309,     0,  2310,
       0,  1562,     0,  1280,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1562,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1562,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1562,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1347,  1562,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1022,     0,     0,     0,  1022,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1562,     0,     0,
       0,  1562,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1022,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1302,     0,     0,     0,     0,     0,  1302,     0,
       0,  1562,     0,  2401,     0,     0,     0,     0,     0,     0,
    1302,     0,     0,     0,  1775,     0,  1302,     0,     0,     0,
    1302,     0,     0,     0,  1562,  1302,     0,     0,  1302,  1302,
    1302,  1302,  1302,  1302,  1302,  1302,  1302,  1302,  1775,     0,
       0,     0,  1302,  1302,  2248,     0,     0,     0,     0,     0,
       0,  1562,     0,     0,     0,     0,  1302,  1775,  1775,     0,
       0,  1775,     0,  1302,     0,     0,  1302,     0,  1302,     0,
       0,     0,     0,     0,     0,  1562,  1302,  1302,  1302,     0,
       0,     0,  1302,     0,     0,  1302,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1775,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2487,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1560,     0,     0,     0,  2506,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1952,  1952,
       0,  1952,     0,     0,     0,     0,     0,     0,  1775,     0,
       0,     0,     0,     0,     0,  1775,  1560,  1775,  1560,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1562,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1560,     0,     0,     0,
    2598,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1560,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1952,     0,     0,     0,     0,  1302,     0,     0,
       0,     0,     0,     0,  1280,     0,     0,     0,  1562,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1952,     0,     0,     0,     0,     0,     0,  2651,     0,     0,
    1560,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1560,  1562,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1952,  1022,     0,     0,     0,
       0,  1022,     0,     0,  1022,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2264,     0,  2264,  2264,     0,     0,
       0,     0,     0,  2713,     0,     0,     0,     0,  1560,     0,
       0,     0,  1560,     0,     0,     0,     0,  1302,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2733,     0,
    2735,     0,     0,     0,  2738,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1302,  1302,
       0,     0,  1560,  1302,  1562,     0,     0,     0,     0,     0,
    1302,  1302,     0,     0,  1302,     0,     0,     0,     0,     0,
    1347,     0,     0,     0,     0,  1560,  1848,     0,     0,     0,
       0,     0,     0,     0,  1857,  1857,  1855,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1560,     0,     0,     4,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2808,     5,
       0,     0,     0,     0,     0,     0,  1560,     0,     6,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1302,     7,
       8,     0,     0,     0,     0,     9,     0,    10,    11,     0,
       0,     0,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,  1022,  1775,     0,     0,
       0,     0,     0,     0,     0,     0,  1775,     0,  1775,     0,
       0,     0,  1302,     0,     0,     0,  1022,     0,     0,     0,
       0,  1562,     0,     0,     0,     0,     0,     0,     0,     0,
    1775,     0,     0,  1775,     0,  2248,  2692,    36,  2248,     0,
    1302,     0,  1775,  1302,     0,     0,     0,     0,     0,  1775,
       0,  1562,  1302,  1302,  1775,     0,  1302,     0,     0,  1560,
       0,     0,     0,  1302,  1302,  1775,     0,     0,     0,  2248,
    2248,  1775,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1775,     0,     0,     0,     0,  1302,     0,  1775,
       0,  1775,  1775,  1775,  1775,  1775,  1775,  1775,  1775,  1775,
    1775,     0,     0,     0,     0,     0,  1022,     0,     0,     0,
      37,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    38,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1560,
       0,     0,  1022,  1302,     0,     0,     0,     0,     0,    39,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1302,
    1302,     0,     0,  3182,     0,     0,     0,     0,     0,     0,
      40,     0,     0,    41,     0,     0,     0,     0,     0,     0,
    3008,  1775,     0,     0,     0,     0,  3012,     0,     0,     0,
       0,     0,     0,     0,    42,     0,     0,     0,  3017,     0,
       0,     0,     0,     0,  3018,     0,     0,     0,  3020,     0,
       0,     0,     0,     0,  1022,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3037,  3038,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3051,     0,     0,  3054,    43,  3056,     0,     0,     0,
       0,     0,     0,     0,  3061,  1560,  1562,  1775,     0,     0,
    3066,     0,     0,  3069,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1022,     0,     0,  1775,     0,     0,     0,
       0,    44,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    45,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46,     0,  1022,     0,     0,
    1562,     0,     0,     0,     0,     0,    47,     0,     0,     0,
       0,    48,    49,     0,    50,     0,    51,     0,     0,     0,
      52,    53,     0,    54,    55,     0,     0,     0,    56,    57,
      58,    59,    60,     0,     0,    61,    62,    63,    64,     0,
      65,    66,    67,     0,    68,    69,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1775,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1560,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1775,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1560,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2692,     0,  2248,
       0,     0,  2248,  2248,  2248,  2248,  2248,  2248,  2248,  2248,
    2248,  2248,     0,  2692,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1775,     0,     0,     0,     0,  2692,  2692,
       4,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2248,  2248,  1775,     5,  1775,     0,     0,  1775,     0,
       0,     0,     0,     6,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     7,     8,     0,     0,     0,     0,
       0,     0,    10,    11,     0,  3217,     0,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1775,     0,
       0,  3232,     0,     0,     0,     0,     0,     0,  3238,  3239,
       0,     0,  3241,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1560,     0,     0,
       0,     0,     0,     0,     0,     0,  3294,     0,     0,     0,
       0,     0,     0,     0,     0,    37,     0,     0,     0,     0,
       0,  2248,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    38,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1560,     0,     0,    39,     0,     0,     0,     0,     0,
    3339,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    40,     0,     0,    41,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3360,     0,     0,     0,     0,    42,
       0,     0,  3362,     0,     0,     0,     0,     0,  1775,     0,
       0,     0,  1775,     0,     0,     0,     0,  1775,  1775,     0,
    1775,     0,     0,  2692,     0,  3370,     0,  2692,  2692,  2692,
    2692,  2692,  2692,  2692,  2692,  2692,  2692,  1775,  1775,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1775,  2248,  2248,  1775,     0,  1775,     0,     0,     0,
      43,  1775,  2692,  2692,     0,     0,  1775,     0,     0,  1775,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3406,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    44,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,     0,    48,    49,     0,    50,
       0,     0,     0,     0,  2692,    52,    53,     0,    54,    55,
       0,     0,     0,    56,    57,    58,    59,    60,     0,     0,
      61,    62,   990,  1401,     0,     0,     0,     0,     0,     0,
      69,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       4,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     5,     0,     0,  1775,     0,     0,
       0,     0,     0,     6,  2248,     0,     0,  2248,     0,     0,
    2692,  2692,  1775,     0,     7,     8,  2248,  2248,  1775,  1775,
       0,  1775,    10,    11,     0,     0,     0,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1775,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1775,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2692,  2248,  2248,  2692,     0,     0,  2692,  2692,
    1775,     0,  1775,     0,     0,     0,     0,     0,     0,     0,
    1775,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    38,     0,  1775,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2692,
    2692,     0,     0,     0,    39,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     4,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    40,     5,     0,    41,     0,
       0,     0,     0,     0,     0,     6,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     7,     8,     0,    42,
       0,     0,     0,     0,    10,    11,     0,     0,     0,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      43,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    44,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,     0,    48,    49,     0,    50,
       0,     0,     0,     0,     0,    52,    53,    37,    54,    55,
       0,     0,     0,    56,    57,    58,    59,    60,     0,     0,
      61,    62,   990,  1895,     0,     0,    38,     0,     0,     0,
      69,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    39,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    40,     0,     0,
      41,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,     0,     0,     0,     0,    48,    49,
       0,    50,     0,     0,     0,     0,     0,    52,    53,     0,
      54,    55,     0,     0,     0,    56,    57,    58,    59,    60,
       0,     0,    61,    62,   990,   619,    81,    82,    83,   372,
      85,    86,    69,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,   620,   101,
     102,   103,   375,   621,     0,   105,   106,   107,   108,   622,
     623,     0,   110,   111,   112,     0,   113,   624,   625,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,   626,   393,   394,   627,   628,
     629,   630,   631,   632,   633,   395,   396,   634,   397,   131,
     398,   399,   400,   133,   134,   135,   136,     0,   635,   401,
     402,     0,   403,   404,   636,   637,   405,   638,   137,   407,
     639,   408,   409,   410,   411,   141,   640,   641,   412,   413,
     414,   415,   416,   642,   417,   418,   144,   419,   643,   420,
     421,   422,   147,   423,   644,   645,   646,   647,   648,   424,
     425,   426,   427,   428,   150,   151,   429,   649,   430,   650,
     431,     0,   432,   433,   434,   651,   435,   652,   653,   436,
     437,   438,   439,   654,   440,   441,   442,   655,   443,   656,
     444,   445,   446,   157,   447,     0,   159,   657,   448,   449,
     161,   658,   450,   659,   451,   162,   660,   163,   452,     0,
     453,   661,   454,   166,   662,   455,   663,   456,   457,   458,
     459,   167,   460,   461,   462,   664,   463,   464,   465,   466,
     467,   468,   665,   168,   169,   666,   469,   470,   471,   667,
     171,   668,   172,   669,     0,   173,   174,   472,   175,   473,
     474,   475,   476,   477,   670,   176,   177,   478,   178,   671,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   183,   184,   185,   672,
     493,   494,   495,   496,   497,   498,   499,   186,   500,   673,
     501,   502,   188,   503,   674,   189,   190,   504,   505,   675,
     676,   506,   677,   678,   679,   507,   508,   680,   681,   191,
     192,   193,   194,   509,   510,   511,   512,     0,   195,   196,
     513,   514,   515,   682,   516,   517,   518,   519,   520,   521,
     198,   522,   523,   683,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   684,   533,   534,   204,   535,   536,   206,
     537,   538,   539,   540,   541,   542,     0,   685,   543,   544,
     545,   686,   546,   210,   547,   548,   212,   549,   213,   687,
     550,   551,   552,   553,   554,   555,   556,   557,   215,   558,
     688,   559,   560,   689,   561,   562,   563,   564,   690,   216,
     217,   691,   692,   566,   218,   567,   219,   693,   568,   569,
     570,   571,   572,   694,   695,   573,   574,   575,   576,   696,
     697,   577,   578,     0,     0,   227,   580,   228,   581,     0,
     698,   699,   582,   583,   584,   585,   586,   587,    81,    82,
      83,   229,    85,    86,   230,    87,    88,    89,     0,     0,
       0,    92,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,     0,     0,     0,   105,   106,   107,
     108,   700,   109,     0,   110,   111,   112,     0,   113,   114,
     115,   116,     0,     0,     0,     0,     0,   119,   120,     0,
       0,     0,     0,   121,     0,     0,     0,     0,     0,     0,
       0,     0,   122,     0,   123,     0,   124,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   131,     0,     0,     0,   133,   134,   135,   136,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     137,     0,     0,     0,     0,     0,     0,   141,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   144,     0,
       0,     0,     0,     0,   147,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   150,   151,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   157,     0,     0,   159,     0,
       0,     0,   161,     0,     0,     0,     0,   162,     0,   163,
       0,     0,     0,     0,     0,   166,     0,     0,     0,     0,
       0,     0,     0,   167,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   168,   169,     0,     0,     0,
       0,     0,   171,     0,   172,     0,     0,   173,   174,     0,
     175,     0,     0,     0,     0,     0,     0,   176,   177,     0,
     178,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   183,   184,
     185,     0,     0,     0,     0,     0,     0,     0,     0,   186,
       0,     0,     0,     0,   188,     0,     0,   189,   190,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   191,   192,   193,   194,     0,     0,     0,     0,     0,
     195,   196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   198,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   204,     0,
       0,   206,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   210,     0,     0,   212,     0,
     213,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     215,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   216,   217,     0,     0,     0,   218,     0,   219,     0,
       0,     0,     0,     0,     0,   222,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,     0,   228,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   229,     0,     0,   230,    81,    82,    83,
       0,    85,    86,     0,    87,    88,    89,     0,     0,     0,
      92,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,     0,  2366,     0,   105,   106,   107,   108,
       0,   109,     0,   110,   111,   112,     0,   113,   114,   115,
     116,     0,     0,     0,     0,     0,   119,   120,     0,     0,
       0,     0,   121,     0,     0,     0,     0,     0,     0,     0,
       0,   122,     0,   123,     0,   124,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     131,     0,     0,     0,   133,   134,   135,   136,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   137,
       0,     0,     0,     0,     0,     0,   141,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   144,     0,     0,
       0,     0,     0,   147,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   150,   151,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   157,     0,     0,   159,     0,     0,
       0,   161,     0,     0,     0,     0,   162,     0,   163,     0,
       0,     0,     0,     0,   166,     0,     0,     0,     0,     0,
       0,     0,   167,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   168,   169,     0,     0,     0,     0,
       0,   171,     0,   172,     0,     0,   173,   174,     0,   175,
       0,     0,     0,     0,     0,     0,   176,   177,     0,   178,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   183,   184,   185,
       0,     0,     0,     0,     0,     0,     0,     0,   186,     0,
       0,     0,     0,   188,     0,     0,   189,   190,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     191,   192,   193,   194,     0,     0,     0,     0,     0,   195,
     196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   198,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   204,     0,     0,
     206,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   210,     0,     0,   212,     0,   213,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   215,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     216,   217,     0,     0,     0,   218,     0,   219,     0,     0,
       0,     0,     0,     0,   222,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,     0,   228,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   229,    80,     0,   230,    81,    82,    83,    84,
      85,    86,     0,    87,    88,    89,    90,     0,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,   104,  2368,     0,   105,   106,   107,   108,     0,
     109,     0,   110,   111,   112,     0,   113,   114,   115,   116,
     117,   118,     0,     0,     0,   119,   120,     0,     0,     0,
       0,   121,     0,     0,     0,     0,     0,     0,     0,     0,
     122,     0,   123,     0,   124,   125,     0,   126,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   127,   128,   129,
       0,     0,     0,     0,     0,     0,     0,     0,   130,   131,
       0,     0,   132,   133,   134,   135,   136,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   137,     0,
       0,   138,     0,   139,   140,   141,     0,     0,   142,   143,
       0,     0,     0,     0,     0,     0,   144,   145,   146,     0,
       0,     0,   147,     0,     0,     0,     0,     0,     0,     0,
       0,   148,     0,   149,   150,   151,   152,     0,     0,     0,
       0,     0,   153,     0,     0,     0,     0,     0,     0,     0,
       0,   154,     0,     0,     0,     0,     0,   155,     0,     0,
       0,     0,   156,   157,   158,     0,   159,     0,   160,     0,
     161,     0,     0,     0,     0,   162,     0,   163,     0,   164,
       0,   165,     0,   166,     0,     0,     0,     0,     0,     0,
       0,   167,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   168,   169,     0,     0,   170,     0,     0,
     171,     0,   172,     0,     0,   173,   174,     0,   175,     0,
       0,     0,     0,     0,     0,   176,   177,     0,   178,     0,
     179,   180,     0,     0,     0,     0,   181,     0,     0,     0,
       0,     0,     0,     0,   182,     0,   183,   184,   185,     0,
       0,     0,     0,     0,     0,     0,     0,   186,     0,     0,
       0,   187,   188,     0,     0,   189,   190,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   191,
     192,   193,   194,     0,     0,     0,     0,     0,   195,   196,
       0,   197,     0,     0,     0,     0,     0,     0,     0,     0,
     198,   199,     0,     0,   200,     0,   201,     0,     0,     0,
     202,     0,     0,     0,     0,   203,   204,     0,   205,   206,
       0,     0,   207,     0,     0,     0,     0,   208,     0,     0,
       0,     0,   209,   210,     0,   211,   212,     0,   213,     0,
       0,   214,     0,     0,     0,     0,     0,     0,   215,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   216,
     217,     0,     0,     0,   218,     0,   219,     0,   220,     0,
     221,     0,     0,   222,     0,     0,   223,     0,   224,     0,
       0,   225,     0,     0,   226,   227,     0,   228,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   229,     0,     0,   230,     0,     0,     0,     0,     0,
       0,   619,    81,    82,    83,   372,    85,    86,     0,    87,
      88,    89,   373,     0,   374,     0,    93,   231,    95,    96,
      97,    98,    99,   100,   620,   101,   102,   103,   375,   621,
       0,   105,   106,   107,   108,   622,   623,     0,   110,   111,
     112,     0,   113,   624,   625,   116,   376,   377,     0,     0,
       0,   378,   379,     0,     0,     0,     0,   380,     0,     0,
       0,     0,     0,     0,     0,     0,   381,     0,   382,     0,
     383,   384,     0,   385,   386,   387,   388,   389,   390,   391,
     392,  2325,   393,   394,     0,     0,     0,     0,  1208,     0,
       0,   395,   396,     0,   397,   131,   398,   399,   400,   133,
    1209,   135,  1210,  1211,     0,   401,   402,     0,   403,   404,
    1212,  1213,   405,  1214,  1215,   407,     0,   408,   409,   410,
     411,  1216,     0,     0,   412,   413,   414,   415,   416,     0,
     417,   418,  1217,   419,     0,   420,   421,   422,   147,   423,
    1218,  1219,  1220,  1221,  1222,   424,   425,   426,   427,   428,
    1223,  1224,   429,     0,   430,     0,   431,     0,   432,   433,
     434,     0,   435,  2326,     0,   436,  1225,   438,   439,     0,
     440,   441,   442,     0,   443,     0,   444,   445,   446,  1226,
     447,     0,  1227,  1228,   448,   449,  1229,     0,   450,     0,
     451,   162,     0,   163,   452,     0,   453,     0,   454,  1230,
       0,   455,     0,   456,   457,   458,   459,   167,   460,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,   168,
     169,     0,   469,   470,   471,  1231,  1232,     0,  1233,     0,
       0,   173,   174,   472,   175,   473,   474,   475,   476,   477,
       0,  1234,   177,   478,   178,     0,   479,   480,   481,  1235,
    1236,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,  1237,   184,  1238,   749,   493,   494,   495,   496,
     497,   498,   499,   186,   500,  1239,   501,   502,   188,   503,
    1240,  1241,  1242,   504,   505,     0,     0,   506,   750,     0,
       0,  1243,   508,     0,     0,   191,   192,   193,  1244,   509,
     510,   511,   512,     0,  1245,   196,   513,   514,   515,     0,
     516,   517,   518,   519,   520,   521,  1246,   522,   523,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,     0,
     533,   534,   204,   535,   536,  1247,   537,   538,   539,   540,
     541,   542,     0,     0,   543,   544,   545,  1248,   546,   210,
     547,   548,   212,   549,  1249,     0,   550,   551,   552,   553,
     554,   555,   556,   557,  1250,   558,     0,   559,   560,     0,
     561,   562,   563,   564,     0,  1251,  1252,     0,     0,   566,
    1253,   567,  1254,  1255,   568,   569,   570,   571,   572,     0,
    1256,   573,   574,   575,   576,  1257,     0,   577,   578,     0,
     579,  1258,   580,   228,   581,     0,     0,     0,   582,   583,
     584,   585,   586,   587,     0,     0,     0,   229,    49,  1259,
     230,   588,     0,     0,  1260,  1261,    52,    53,  1262,    54,
       0,     0,     0,     0,  1263,  1264,  2327,     0,     0,     0,
       0,     0,     0,  1266,  2328,   619,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,   620,   101,
     102,   103,   375,   621,     0,   105,   106,   107,   108,   622,
     623,     0,   110,   111,   112,     0,   113,   624,   625,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,  1208,     0,     0,   395,   396,     0,   397,   131,
     398,   399,   400,   133,  1209,   135,  1210,  1211,     0,   401,
     402,     0,   403,   404,  1212,  1213,   405,  1214,  1215,   407,
       0,   408,   409,   410,   411,  1216,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,  1217,   419,     0,   420,
     421,   422,   147,   423,  1218,  1219,  1220,  1221,  1222,   424,
     425,   426,   427,   428,  1223,  1224,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
    1225,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,  1226,   447,     0,  1227,  1228,   448,   449,
    1229,     0,   450,     0,   451,   162,     0,   163,   452,     0,
     453,     0,   454,  1230,     0,   455,     0,   456,   457,   458,
     459,   167,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,   168,   169,     0,   469,   470,   471,  1231,
    1232,     0,  1233,     0,     0,   173,   174,   472,   175,   473,
     474,   475,   476,   477,     0,  1234,   177,   478,   178,     0,
     479,   480,   481,  1235,  1236,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,  1237,   184,  1238,   749,
     493,   494,   495,   496,   497,   498,   499,   186,   500,  1239,
     501,   502,   188,   503,  1240,  1241,  1242,   504,   505,     0,
       0,   506,   750,     0,     0,  1243,   508,     0,     0,   191,
     192,   193,  1244,   509,   510,   511,   512,     0,  1245,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
    1246,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,   204,   535,   536,  1247,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,  1248,   546,   210,   547,   548,   212,   549,  1249,     0,
     550,   551,   552,   553,   554,   555,   556,   557,  1250,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,  1251,
    1252,     0,     0,   566,  1253,   567,  1254,  1255,   568,   569,
     570,   571,   572,     0,  1256,   573,   574,   575,   576,  1257,
       0,   577,   578,     0,   579,  1258,   580,   228,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,    49,  1259,   230,   588,     0,     0,  1260,  1261,
      52,    53,  1262,    54,     0,     0,     0,     0,  1263,  1264,
       0,     0,     0,     0,     0,     0,     0,  1266,  2250,   619,
      81,    82,    83,   372,    85,    86,     0,    87,    88,    89,
     373,     0,   374,     0,    93,     0,    95,    96,    97,    98,
      99,   100,   620,   101,   102,   103,   375,   621,     0,   105,
     106,   107,   108,   622,   623,     0,   110,   111,   112,     0,
     113,   624,   625,   116,   376,   377,     0,     0,     0,   378,
     379,     0,     0,     0,     0,   380,     0,     0,     0,     0,
       0,     0,     0,     0,   381,     0,   382,     0,   383,   384,
       0,   385,   386,   387,   388,   389,   390,   391,   392,     0,
     393,   394,     0,     0,     0,     0,     0,     0,     0,   395,
     396,     0,   397,   131,   398,   399,   400,   133,  1529,   135,
    1530,  1211,     0,   401,   402,     0,   403,   404,     0,     0,
     405,  1531,  1532,   407,     0,   408,   409,   410,   411,     0,
       0,     0,   412,   413,   414,   415,   416,     0,   417,   418,
       0,   419,     0,   420,   421,   422,   147,   423,     0,     0,
       0,     0,     0,   424,   425,   426,   427,   428,  1533,  1534,
     429,     0,   430,     0,   431,     0,   432,   433,   434,     0,
     435,     0,     0,   436,  1225,   438,   439,     0,   440,   441,
     442,     0,   443,     0,   444,   445,   446,     0,   447,     0,
       0,     0,   448,   449,  1535,     0,   450,     0,   451,   162,
       0,   163,   452,     0,   453,     0,   454,     0,     0,   455,
       0,   456,   457,   458,   459,   167,   460,   461,   462,  1941,
     463,   464,   465,   466,   467,   468,     0,   168,  1942,     0,
     469,   470,   471,  1231,  1536,     0,  1537,     0,     0,   173,
     174,   472,   175,   473,   474,   475,   476,   477,     0,     0,
     177,   478,   178,     0,   479,   480,   481,     0,     0,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
    1538,   184,  1539,     0,   493,   494,   495,   496,   497,   498,
     499,     0,   500,     0,   501,   502,   188,   503,     0,     0,
    1540,   504,   505,     0,     0,   506,     0,     0,     0,   507,
     508,     0,     0,  1943,   192,   193,     0,   509,   510,   511,
     512,     0,     0,     0,   513,   514,   515,     0,   516,   517,
     518,   519,   520,   521,  1541,   522,   523,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,     0,   533,   534,
     204,   535,   536,     0,   537,   538,   539,   540,   541,   542,
       0,     0,   543,   544,   545,     0,   546,  1542,   547,   548,
     212,   549,  1543,     0,   550,   551,   552,   553,   554,   555,
     556,   557,     0,   558,     0,   559,   560,     0,   561,   562,
     563,   564,     0,  1544,  1545,     0,     0,   566,     0,   567,
       0,     0,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,   576,     0,     0,   577,   578,     0,     0,  1546,
     580,   228,   581,     0,     0,     0,   582,   583,   584,   585,
     586,   587,     0,     0,     0,   229,     0,     0,   230,     0,
      81,    82,    83,   372,    85,    86,     0,    87,    88,    89,
     373,     0,   374,     0,    93,     0,    95,    96,    97,    98,
      99,   100,  1944,   101,   102,   103,   375,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   116,   376,   377,     0,     0,     0,   378,
     379,     0,     0,     0,     0,   380,     0,     0,     0,     0,
       0,     0,     0,     0,   381,     0,   382,     0,   383,   384,
       0,   385,   386,   387,   388,   389,   390,   391,   392,     0,
     393,   394,     0,     0,     0,     0,     0,     0,     0,   395,
     396,     0,   397,     0,   398,   399,   400,     0,   134,     0,
     136,     0,     0,   401,   402,     0,   403,   404,     0,     0,
     405,   406,   137,   407,     0,   408,   409,   410,   411,   141,
       0,     0,   412,   413,   414,   415,   416,     0,   417,   418,
     144,   419,     0,   420,   421,   422,     0,   423,     0,     0,
       0,     0,     0,   424,   425,   426,   427,   428,   150,   151,
     429,     0,   430,     0,   431,     0,   432,   433,   434,     0,
     435,     0,     0,   436,   437,   438,   439,     0,   440,   441,
     442,     0,   443,     0,   444,   445,   446,   157,   447,     0,
     159,     0,   448,   449,   161,     0,   450,     0,   451,     0,
       0,     0,   452,     0,   453,     0,   454,   166,     0,   455,
       0,   456,   457,   458,   459,     0,   460,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   169,     0,
     469,   470,   471,     0,   171,     0,   172,     0,     0,     0,
       0,   472,     0,   473,   474,   475,   476,   477,     0,   176,
       0,   478,     0,     0,   479,   480,   481,     0,     0,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     183,     0,   185,     0,   493,   494,   495,   496,   497,   498,
     499,   186,   500,     0,   501,   502,     0,   503,     0,   189,
     190,   504,   505,     0,     0,   506,     0,     0,     0,   507,
     508,     0,     0,   191,     0,     0,   194,   509,   510,   511,
     512,     0,   195,   196,   513,   514,   515,     0,   516,   517,
     518,   519,   520,   521,   198,   522,   523,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,     0,   533,   534,
       0,   535,   536,   206,   537,   538,   539,   540,   541,   542,
       0,     0,   543,   544,   545,     0,   546,   210,   547,   548,
       0,   549,   213,     0,   550,   551,   552,   553,   554,   555,
     556,   557,   215,   558,     0,   559,   560,     0,   561,   562,
     563,   564,     0,   216,   217,     0,     0,   566,   218,   567,
     219,     0,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,   576,     0,  3409,   577,   578,     0,   579,   227,
     580,     0,   581,     0,     0,     0,   582,   583,   584,   585,
     586,   587,     0,     0,     0,   229,     0,     0,   230,     0,
       0,     0,     0,     0,     0,     0,     0,   619,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373, -1297,
     374,     0,    93, -1297,    95,    96,    97,    98,    99,   100,
     620,   101,   102,   103,   375,   621,     0,   105,   106,   107,
     108,   622,   623,     0,   110,   111,   112,     0,   113,   624,
     625,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,  1208,     0,     0,   395,   396,     0,
     397,   131,   398,   399,   400,   133,  1209,   135,  1210,  1211,
    2260,   401,   402,     0,   403,   404,  1212,  1213,   405,  1214,
    1215,   407,     0,   408,   409,   410,   411,  1216,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,  1217,   419,
       0,   420,   421,   422,   147,   423,  1218,  1219,  1220,  1221,
    1222,   424,   425,   426,   427,   428,  1223,  1224,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,  1225,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,  1226,   447,     0,  1227,  1228,
     448,   449,  1229,     0,   450,     0,   451,   162,  2261,   163,
     452,     0,   453,     0,   454,  1230,     0,   455,     0,   456,
     457,   458,   459,   167,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,   168,   169,     0,   469,   470,
     471,  1231,  1232,     0,  1233,     0,     0,   173,   174,   472,
     175,   473,   474,   475,   476,   477,  2262,  1234,   177,   478,
     178,     0,   479,   480,   481,  1235,  1236,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,  1237,   184,
    1238,   749,   493,   494,   495,   496,   497,   498,   499,   186,
     500,  1239,   501,   502,   188,   503,  1240,  1241,  1242,   504,
     505,     0,     0,   506,   750,     0,     0,  1243,   508,     0,
       0,   191,   192,   193,  1244,   509,   510,   511,   512,     0,
    1245,   196,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,  1246,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,   204,   535,
     536,  1247,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,  1248,   546,   210,   547,   548,   212,   549,
    1249,     0,   550,   551,   552,   553,   554,   555,   556,   557,
    1250,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,  1251,  1252,     0,  2263,   566,  1253,   567,  1254,  1255,
     568,   569,   570,   571,   572,     0,  1256,   573,   574,   575,
     576,  1257,     0,   577,   578,     0,   579,  1258,   580,   228,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,    49,  1259,   230,   588,     0,     0,
    1260,  1261,    52,    53,  1262,    54,     0,     0,     0,     0,
    1263,  1264,   619,    81,    82,    83,   372,    85,    86,  1266,
      87,    88,    89,   373,     0,   374,     0,    93,     0,    95,
      96,    97,    98,    99,   100,   620,   101,   102,   103,   375,
     621,     0,   105,   106,   107,   108,   622,   623,     0,   110,
     111,   112,     0,   113,   624,   625,   116,   376,   377,     0,
       0,     0,   378,   379,     0,     0,     0,     0,   380,     0,
       0,     0,     0,     0,     0,     0,     0,   381,     0,   382,
       0,   383,   384,     0,   385,   386,   387,   388,   389,   390,
     391,   392,     0,   393,   394,     0,     0,     0,     0,  1208,
       0,     0,   395,   396,     0,   397,   131,   398,   399,   400,
     133,  1209,   135,  1210,  1211,     0,   401,   402,     0,   403,
     404,  1212,  1213,   405,  1214,  1215,   407,     0,   408,   409,
     410,   411,  1216,     0,     0,   412,   413,   414,   415,   416,
       0,   417,   418,  1217,   419,     0,   420,   421,   422,   147,
     423,  1218,  1219,  1220,  1221,  1222,   424,   425,   426,   427,
     428,  1223,  1224,   429,     0,   430,     0,   431,     0,   432,
     433,   434,     0,   435,     0,     0,   436,  1225,   438,   439,
       0,   440,   441,   442,     0,   443,     0,   444,   445,   446,
    1226,   447,     0,  1227,  1228,   448,   449,  1229,     0,   450,
       0,   451,   162,     0,   163,   452,     0,   453,     0,   454,
    1230,     0,   455,     0,   456,   457,   458,   459,   167,   460,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
     168,   169,     0,   469,   470,   471,  1231,  1232,     0,  1233,
       0,     0,   173,   174,   472,   175,   473,   474,   475,   476,
     477,     0,  1234,   177,   478,   178,     0,   479,   480,   481,
    1235,  1236,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,  1237,   184,  1238,   749,   493,   494,   495,
     496,   497,   498,   499,   186,   500,  1239,   501,   502,   188,
     503,  1240,  1241,  1242,   504,   505,     0,     0,   506,   750,
       0,     0,  1243,   508,     0,     0,   191,   192,   193,  1244,
     509,   510,   511,   512,     0,  1245,   196,   513,   514,   515,
       0,   516,   517,   518,   519,   520,   521,  1246,   522,   523,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
       0,   533,   534,   204,   535,   536,  1247,   537,   538,   539,
     540,   541,   542,     0,     0,   543,   544,   545,  1248,   546,
     210,   547,   548,   212,   549,  1249,     0,   550,   551,   552,
     553,   554,   555,   556,   557,  1250,   558,     0,   559,   560,
       0,   561,   562,   563,   564,     0,  1251,  1252,     0,     0,
     566,  1253,   567,  1254,  1255,   568,   569,   570,   571,   572,
       0,  1256,   573,   574,   575,   576,  1257,     0,   577,   578,
       0,   579,  1258,   580,   228,   581,     0,     0,     0,   582,
     583,   584,   585,   586,   587,     0,     0,     0,   229,    49,
    1259,   230,   588,     0,     0,  1260,  1261,    52,    53,  1262,
      54,     0,     0,     0,     0,  1263,  1264,  1265,     0,     0,
       0,     0,     0,     0,  1266,   619,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,   620,   101,
     102,   103,   375,   621,     0,   105,   106,   107,   108,   622,
     623,     0,   110,   111,   112,     0,   113,   624,   625,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,  1208,     0,     0,   395,   396,     0,   397,   131,
     398,   399,   400,   133,  1209,   135,  1210,  1211,     0,   401,
     402,     0,   403,   404,  1212,  1213,   405,  1214,  1215,   407,
       0,   408,   409,   410,   411,  1216,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,  1217,   419,     0,   420,
     421,   422,   147,   423,  1218,  1219,  1220,  1221,  1222,   424,
     425,   426,   427,   428,  1223,  1224,   429,  1346,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
    1225,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,  1226,   447,     0,  1227,  1228,   448,   449,
    1229,     0,   450,     0,   451,   162,     0,   163,   452,     0,
     453,     0,   454,  1230,     0,   455,     0,   456,   457,   458,
     459,   167,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,   168,   169,     0,   469,   470,   471,  1231,
    1232,     0,  1233,     0,     0,   173,   174,   472,   175,   473,
     474,   475,   476,   477,     0,  1234,   177,   478,   178,     0,
     479,   480,   481,  1235,  1236,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,  1237,   184,  1238,   749,
     493,   494,   495,   496,   497,   498,   499,   186,   500,  1239,
     501,   502,   188,   503,  1240,  1241,  1242,   504,   505,     0,
       0,   506,   750,     0,     0,  1243,   508,     0,     0,   191,
     192,   193,  1244,   509,   510,   511,   512,     0,  1245,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
    1246,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,   204,   535,   536,  1247,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,  1248,   546,   210,   547,   548,   212,   549,  1249,     0,
     550,   551,   552,   553,   554,   555,   556,   557,  1250,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,  1251,
    1252,     0,     0,   566,  1253,   567,  1254,  1255,   568,   569,
     570,   571,   572,     0,  1256,   573,   574,   575,   576,  1257,
       0,   577,   578,     0,   579,  1258,   580,   228,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,    49,  1259,   230,   588,     0,     0,  1260,  1261,
      52,    53,  1262,    54,     0,     0,     0,     0,  1263,  1264,
     619,    81,    82,    83,   372,    85,    86,  1266,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,   620,   101,   102,   103,   375,   621,     0,
     105,   106,   107,   108,   622,   623,     0,   110,   111,   112,
       0,   113,   624,   625,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,  1208,     0,     0,
     395,   396,     0,   397,   131,   398,   399,   400,   133,  1209,
     135,  1210,  1211,     0,   401,   402,     0,   403,   404,  1212,
    1213,   405,  1214,  1215,   407,     0,   408,   409,   410,   411,
    1216,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,  1217,   419,     0,   420,   421,   422,   147,   423,  1218,
    1219,  1220,  1221,  1222,   424,   425,   426,   427,   428,  1223,
    1224,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,  1225,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,  1226,   447,
       0,  1227,  1228,   448,   449,  1229,     0,   450,     0,   451,
     162,     0,   163,   452,     0,   453,     0,   454,  1230,     0,
     455,     0,   456,   457,   458,   459,   167,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,   168,   169,
       0,   469,   470,   471,  1231,  1232,     0,  1233,     0,     0,
     173,   174,   472,   175,   473,   474,   475,   476,   477,     0,
    1234,   177,   478,   178,     0,   479,   480,   481,  1235,  1236,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,  1237,   184,  1238,   749,   493,   494,   495,   496,   497,
     498,   499,   186,   500,  1239,   501,   502,   188,   503,  1240,
    1241,  1242,   504,   505,     0,     0,   506,   750,     0,     0,
    1243,   508,     0,     0,   191,   192,   193,  1244,   509,   510,
     511,   512,     0,  1245,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,  1246,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,   204,   535,   536,  1247,   537,   538,   539,   540,   541,
     542,     0,   208,   543,   544,   545,  1248,   546,   210,   547,
     548,   212,   549,  1249,     0,   550,   551,   552,   553,   554,
     555,   556,   557,  1250,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,  1251,  1252,     0,     0,   566,  1253,
     567,  1254,  1255,   568,   569,   570,   571,   572,     0,  1256,
     573,   574,   575,   576,  1257,     0,   577,   578,     0,  1739,
    1258,   580,   228,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,    49,  1259,   230,
     588,     0,     0,  1260,  1261,    52,    53,  1262,    54,     0,
       0,     0,     0,  1263,  1264,   619,    81,    82,    83,   372,
      85,    86,  1266,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,   620,   101,
     102,   103,   375,   621,     0,   105,   106,   107,   108,   622,
     623,     0,   110,   111,   112,     0,   113,   624,   625,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,  1853,   393,   394,     0,     0,
       0,     0,  1208,     0,     0,   395,   396,     0,   397,   131,
     398,   399,   400,   133,  1209,   135,  1210,  1211,     0,   401,
     402,     0,   403,   404,  1212,  1213,   405,  1214,  1215,   407,
       0,   408,   409,   410,   411,  1216,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,  1217,   419,     0,   420,
     421,   422,   147,   423,  1218,  1219,  1220,  1221,  1222,   424,
     425,   426,   427,   428,  1223,  1224,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
    1225,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,  1226,   447,     0,  1227,  1228,   448,   449,
    1229,     0,   450,     0,   451,   162,     0,   163,   452,     0,
     453,     0,   454,  1230,     0,   455,     0,   456,   457,   458,
     459,   167,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,   168,   169,     0,   469,   470,   471,  1231,
    1232,     0,  1233,     0,     0,   173,   174,   472,   175,   473,
     474,   475,   476,   477,     0,  1234,   177,   478,   178,     0,
     479,   480,   481,  1235,  1236,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,  1237,   184,  1238,   749,
     493,   494,   495,   496,   497,   498,   499,   186,   500,  1239,
     501,   502,   188,   503,  1240,  1241,  1242,   504,   505,     0,
       0,   506,   750,     0,     0,  1243,   508,     0,     0,   191,
     192,   193,  1244,   509,   510,   511,   512,     0,  1245,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
    1246,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,   204,   535,   536,  1247,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,  1248,   546,   210,   547,   548,   212,   549,  1249,     0,
     550,   551,   552,   553,   554,   555,   556,   557,  1250,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,  1251,
    1252,     0,     0,   566,  1253,   567,  1254,  1255,   568,   569,
     570,   571,   572,     0,  1256,   573,   574,   575,   576,  1257,
       0,   577,   578,     0,   579,  1258,   580,   228,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,    49,  1259,   230,   588,     0,     0,  1260,  1261,
      52,    53,  1262,    54,     0,     0,     0,     0,  1263,  1264,
     619,    81,    82,    83,   372,    85,    86,  1266,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,   620,   101,   102,   103,   375,   621,     0,
     105,   106,   107,   108,   622,   623,     0,   110,   111,   112,
       0,   113,   624,   625,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,  1208,     0,     0,
     395,   396,     0,   397,   131,   398,   399,   400,   133,  1209,
     135,  1210,  1211,     0,   401,   402,     0,   403,   404,  1212,
    1213,   405,  1214,  1215,   407,     0,   408,   409,   410,   411,
    1216,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,  1217,   419,     0,   420,   421,   422,   147,   423,  1218,
    1219,  1220,  1221,  1222,   424,   425,   426,   427,   428,  1223,
    1224,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,  1225,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,  1226,   447,
       0,  1227,  1228,   448,   449,  1229,     0,   450,     0,   451,
     162,     0,   163,   452,     0,   453,     0,   454,  1230,     0,
     455,     0,   456,   457,   458,   459,   167,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,   168,   169,
       0,   469,   470,   471,  1231,  1232,     0,  1233,     0,     0,
     173,   174,   472,   175,   473,   474,   475,   476,   477,     0,
    1234,   177,   478,   178,     0,   479,   480,   481,  1235,  1236,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,  1237,   184,  1238,   749,   493,   494,   495,   496,   497,
     498,   499,   186,   500,  1239,   501,   502,   188,   503,  1240,
    1241,  1242,   504,   505,     0,     0,   506,   750,     0,     0,
    1243,   508,     0,     0,   191,   192,   193,  1244,   509,   510,
     511,   512,     0,  1245,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,  1246,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,   204,   535,   536,  1247,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   545,  1248,   546,   210,   547,
     548,   212,   549,  1249,     0,   550,   551,   552,   553,   554,
     555,   556,   557,  1250,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,  1251,  1252,     0,     0,   566,  1253,
     567,  1254,  1255,   568,   569,   570,   571,   572,     0,  1256,
     573,   574,   575,   576,  1257,     0,   577,   578,     0,   579,
    1258,   580,   228,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,    49,  1259,   230,
     588,     0,     0,  1260,  1261,    52,    53,  1262,    54,     0,
       0,     0,     0,  1263,  1264,     0,     0,     0,     0,     0,
    1689,     0,  1266,   619,    81,    82,    83,   372,    85,    86,
       0,    87,    88,    89,   373,     0,   374,     0,    93,     0,
      95,    96,    97,    98,    99,   100,   620,   101,   102,   103,
     375,   621,     0,   105,   106,   107,   108,   622,   623,     0,
     110,   111,   112,     0,   113,   624,   625,   116,   376,   377,
       0,     0,     0,   378,   379,     0,     0,     0,     0,   380,
       0,     0,     0,     0,     0,     0,     0,     0,   381,     0,
     382,     0,   383,   384,     0,   385,   386,   387,   388,   389,
     390,   391,   392,     0,   393,   394,     0,     0,     0,     0,
    1208,     0,     0,   395,   396,     0,   397,   131,   398,   399,
     400,   133,  1209,   135,  1210,  1211,     0,   401,   402,     0,
     403,   404,  1212,  1213,   405,  1214,  1215,   407,     0,   408,
     409,   410,   411,  1216,     0,     0,   412,   413,   414,   415,
     416,     0,   417,   418,  1217,   419,     0,   420,   421,   422,
     147,   423,  1218,  1219,  1220,  1221,  1222,   424,   425,   426,
     427,   428,  1223,  1224,   429,     0,   430,     0,   431,     0,
     432,   433,   434,     0,   435,     0,     0,   436,  1225,   438,
     439,     0,   440,   441,   442,     0,   443,     0,   444,   445,
     446,  1226,   447,     0,  1227,  1228,   448,   449,  1229,     0,
     450,     0,   451,   162,  2261,   163,   452,     0,   453,     0,
     454,  1230,     0,   455,     0,   456,   457,   458,   459,   167,
     460,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,   168,   169,     0,   469,   470,   471,  1231,  1232,     0,
    1233,     0,     0,   173,   174,   472,   175,   473,   474,   475,
     476,   477,     0,  1234,   177,   478,   178,     0,   479,   480,
     481,  1235,  1236,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,  1237,   184,  1238,   749,   493,   494,
     495,   496,   497,   498,   499,   186,   500,  1239,   501,   502,
     188,   503,  1240,  1241,  1242,   504,   505,     0,     0,   506,
     750,     0,     0,  1243,   508,     0,     0,   191,   192,   193,
    1244,   509,   510,   511,   512,     0,  1245,   196,   513,   514,
     515,     0,   516,   517,   518,   519,   520,   521,  1246,   522,
     523,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,     0,   533,   534,   204,   535,   536,  1247,   537,   538,
     539,   540,   541,   542,     0,     0,   543,   544,   545,  1248,
     546,   210,   547,   548,   212,   549,  1249,     0,   550,   551,
     552,   553,   554,   555,   556,   557,  1250,   558,     0,   559,
     560,     0,   561,   562,   563,   564,     0,  1251,  1252,     0,
       0,   566,  1253,   567,  1254,  1255,   568,   569,   570,   571,
     572,     0,  1256,   573,   574,   575,   576,  1257,     0,   577,
     578,     0,   579,  1258,   580,   228,   581,     0,     0,     0,
     582,   583,   584,   585,   586,   587,     0,     0,     0,   229,
      49,  1259,   230,   588,     0,     0,  1260,  1261,    52,    53,
    1262,    54,     0,     0,     0,     0,  1263,  1264,   619,    81,
      82,    83,   372,    85,    86,  1266,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,   620,   101,   102,   103,   375,   621,     0,   105,   106,
     107,   108,   622,   623,     0,   110,   111,   112,     0,   113,
     624,   625,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,  1208,     0,     0,   395,   396,
       0,   397,   131,   398,   399,   400,   133,  1209,   135,  1210,
    1211,     0,   401,   402,     0,   403,   404,  1212,  1213,   405,
    1214,  1215,   407,     0,   408,   409,   410,   411,  1216,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,  1217,
     419,     0,   420,   421,   422,   147,   423,  1218,  1219,  1220,
    1221,  1222,   424,   425,   426,   427,   428,  1223,  1224,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,  1225,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,  1226,   447,     0,  1227,
    1228,   448,   449,  1229,     0,   450,     0,   451,   162,     0,
     163,   452,     0,   453,     0,   454,  1230,     0,   455,     0,
     456,   457,   458,   459,   167,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,   168,   169,     0,   469,
     470,   471,  1231,  1232,     0,  1233,     0,     0,   173,   174,
     472,   175,   473,   474,   475,   476,   477,     0,  1234,   177,
     478,   178,     0,   479,   480,   481,  1235,  1236,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,  1237,
     184,  1238,   749,   493,   494,   495,   496,   497,   498,   499,
     186,   500,  1239,   501,   502,   188,   503,  1240,  1241,  1242,
     504,   505,     0,     0,   506,   750,     0,     0,  1243,   508,
       0,     0,   191,   192,   193,  1244,   509,   510,   511,   512,
       0,  1245,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,  1246,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,   204,
     535,   536,  1247,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,   545,  1248,   546,   210,   547,   548,   212,
     549,  1249,     0,   550,   551,   552,   553,   554,   555,   556,
     557,  1250,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,  1251,  1252,     0,     0,   566,  1253,   567,  1254,
    1255,   568,   569,   570,   571,   572,     0,  1256,   573,   574,
     575,   576,  1257,     0,   577,   578,     0,   579,  1258,   580,
     228,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,    49,  1259,   230,   588,     0,
       0,  1260,  1261,    52,    53,  1262,    54,     0,     0,     0,
       0,  1263,  1264,   619,    81,    82,    83,   372,    85,    86,
    1266,    87,    88,    89,   373,     0,   374,     0,    93,     0,
      95,    96,    97,    98,    99,   100,   620,   101,   102,   103,
     375,   621,     0,   105,   106,   107,   108,   622,   623,     0,
     110,   111,   112,     0,   113,   624,   625,   116,   376,   377,
       0,     0,     0,   378,   379,     0,     0,     0,     0,   380,
       0,     0,     0,     0,     0,     0,     0,     0,   381,     0,
     382,     0,   383,   384,     0,   385,   386,   387,   388,   389,
     390,   391,   392,     0,   393,   394,     0,     0,     0,     0,
    1208,     0,     0,   395,   396,     0,   397,   131,   398,   399,
     400,   133,  1209,   135,  1210,  1211,     0,   401,   402,     0,
     403,   404,  1212,  1213,   405,  1214,  1215,   407,     0,   408,
     409,   410,   411,  1216,     0,     0,   412,   413,   414,   415,
     416,     0,   417,   418,  1217,   419,     0,   420,   421,   422,
     147,   423,  1218,  1219,  1220,  1221,  1222,   424,   425,   426,
     427,   428,  1223,  1224,   429,     0,   430,     0,   431,     0,
     432,   433,   434,     0,   435,     0,     0,   436,  1225,   438,
     439,     0,   440,   441,   442,     0,   443,     0,   444,   445,
     446,  1226,   447,     0,  1227,  1228,   448,   449,  1229,     0,
     450,     0,   451,   162,     0,   163,   452,     0,   453,     0,
     454,  1230,     0,   455,     0,   456,   457,   458,   459,   167,
     460,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,   168,   169,     0,   469,   470,   471,  1231,  1232,     0,
    1233,     0,     0,   173,   174,   472,   175,   473,   474,   475,
     476,   477,     0,  1234,   177,   478,   178,     0,   479,   480,
     481,  1235,  1236,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,  1237,   184,  1238,   749,   493,   494,
     495,   496,   497,   498,   499,   186,   500,     0,   501,   502,
     188,   503,  1240,  1241,  1242,   504,   505,     0,     0,   506,
     750,     0,     0,  1243,   508,     0,     0,   191,   192,   193,
    1244,   509,   510,   511,   512,     0,  1245,   196,   513,   514,
     515,     0,   516,   517,   518,   519,   520,   521,  1246,   522,
     523,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,     0,   533,   534,   204,   535,   536,  1247,   537,   538,
     539,   540,   541,   542,     0,     0,   543,   544,   545,  1248,
     546,   210,   547,   548,   212,   549,  1249,     0,   550,   551,
     552,   553,   554,   555,   556,   557,  1250,   558,     0,   559,
     560,     0,   561,   562,   563,   564,     0,  1251,  1252,     0,
       0,   566,  1253,   567,  1254,  1255,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,   576,  1257,     0,   577,
     578,     0,   579,  1258,   580,   228,   581,     0,     0,     0,
     582,   583,   584,   585,   586,   587,     0,     0,     0,   229,
      49,  1259,   230,   588,     0,     0,  1260,  1261,    52,    53,
    1262,    54,     0,     0,     0,     0,     0,  2245,   619,    81,
      82,    83,   372,    85,    86,  1266,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,   620,   101,   102,   103,   375,   621,     0,   105,   106,
     107,   108,   622,   623,     0,   110,   111,   112,     0,   113,
     624,   625,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,  1208,     0,     0,   395,   396,
       0,   397,   131,   398,   399,   400,     0,  1209,   135,  1210,
    1211,     0,   401,   402,     0,   403,   404,  1212,  1213,   405,
    1214,  1215,   407,     0,   408,   409,   410,   411,  1216,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,  1217,
     419,     0,   420,   421,   422,   147,   423,  1218,  1219,  1220,
    1221,  1222,   424,   425,   426,   427,   428,  1223,  1224,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,  1225,   438,   439,     0,   440,   441,   442,
       0,     0,     0,   444,   445,   446,  1226,   447,     0,  1227,
    1228,   448,   449,  1229,     0,   450,     0,   451,   162,     0,
     163,   452,     0,   453,     0,   454,  1230,     0,   455,     0,
     456,   457,   458,   459,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,   168,   169,     0,   469,
     470,   471,  1231,  1232,     0,  1233,     0,     0,   173,   174,
     472,   175,   473,   474,   475,   476,   477,     0,  1234,   177,
     478,     0,     0,   479,   480,   481,  1235,  1236,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,  1237,
     184,  1238,   749,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,   188,   503,  1240,  1241,  1242,
     504,   505,     0,     0,   506,   750,     0,     0,  1243,   508,
       0,     0,   191,   192,   193,  1244,   509,   510,   511,   512,
       0,  1245,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,  1246,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,   204,
     535,   536,  1247,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,   545,  1248,   546,   210,   547,   548,     0,
     549,  1249,     0,   550,   551,   552,   553,   554,   555,   556,
     557,  1250,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,  1251,  1252,     0,     0,   566,  1253,   567,  1254,
    1255,   568,   569,   570,   571,   572,     0,  1256,   573,   574,
     575,   576,  1257,     0,   577,   578,     0,   579,  1258,   580,
     228,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,    49,  1259,   230,   588,     0,
       0,  1260,  1261,    52,    53,  1262,    54,     0,     0,     0,
       0,  1263,  1264,   619,    81,    82,    83,   372,    85,    86,
    1266,    87,    88,    89,   373,     0,   374,     0,    93,     0,
      95,    96,    97,    98,    99,   100,   620,   101,   102,   103,
     375,   621,     0,   105,   106,   107,   108,   622,   623,     0,
     110,   111,   112,     0,   113,   624,   625,   116,   376,   377,
       0,     0,     0,   378,   379,     0,     0,     0,     0,   380,
       0,     0,     0,     0,     0,     0,     0,     0,   381,     0,
     382,     0,   383,   384,     0,   385,   386,   387,   388,   389,
     390,   391,   392,     0,   393,   394,     0,     0,     0,     0,
    1208,     0,     0,   395,   396,     0,   397,   131,   398,   399,
     400,     0,  1209,   135,  1210,  1211,     0,   401,   402,     0,
     403,   404,  1212,  1213,   405,  1214,  1215,   407,     0,   408,
     409,   410,   411,  1216,     0,     0,   412,   413,   414,   415,
     416,     0,   417,   418,  1217,   419,     0,   420,   421,   422,
     147,   423,  1218,  1219,  1220,  1221,  1222,   424,   425,   426,
     427,   428,  1223,  1224,   429,     0,   430,     0,   431,     0,
     432,   433,   434,     0,   435,     0,     0,   436,  1225,   438,
     439,     0,   440,   441,   442,     0,     0,     0,   444,   445,
     446,  1226,   447,     0,  1227,  1228,   448,   449,  1229,     0,
     450,     0,   451,   162,     0,   163,   452,     0,   453,     0,
     454,  1230,     0,   455,     0,   456,   457,   458,   459,     0,
     460,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,   168,   169,     0,   469,   470,   471,  1231,  1232,     0,
    1233,     0,     0,   173,   174,   472,   175,   473,   474,   475,
     476,   477,     0,  1234,   177,   478,     0,     0,   479,   480,
     481,  1235,  1236,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,  1237,   184,  1238,   749,   493,   494,
     495,   496,   497,   498,   499,   186,   500,     0,   501,   502,
     188,   503,  1240,  1241,  1242,   504,   505,     0,     0,   506,
     750,     0,     0,     0,   508,     0,     0,   191,   192,   193,
    1244,   509,   510,   511,   512,     0,  1245,   196,   513,   514,
     515,     0,   516,   517,   518,   519,   520,   521,  1246,   522,
     523,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,     0,   533,   534,   204,   535,   536,  1247,   537,   538,
     539,   540,   541,   542,     0,     0,   543,   544,   545,  1248,
     546,   210,   547,   548,     0,   549,  1249,     0,   550,   551,
     552,   553,   554,   555,   556,   557,  1250,   558,     0,   559,
     560,     0,   561,   562,   563,   564,     0,  1251,  1252,     0,
       0,   566,  1253,   567,  1254,  1255,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,   576,  1257,     0,   577,
     578,     0,   579,  1258,   580,   228,   581,     0,     0,     0,
     582,   583,   584,   585,   586,   587,     0,     0,     0,   229,
      49,     0,   230,   588,     0,     0,  1260,  1261,    52,    53,
    1262,    54,     0,     0,     0,     0,     0,  2245,     0,    81,
      82,    83,   372,    85,    86,  1266,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,     0,  2581,     0,   395,   396,
       0,   397,     0,   398,   399,   400,     0,   134,     0,   136,
       0,     0,   401,   402,     0,   403,   404,     0,     0,   405,
     406,   137,   407,     0,   408,   409,   410,   411,   141,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,   144,
     419,     0,   420,   421,   422,  -956,   423,     0,     0,     0,
       0,     0,   424,   425,   426,   427,   428,   150,   151,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,   159,
       0,   448,   449,   161,     0,   450,     0,   451,     0,     0,
    -956,   452,     0,   453,     0,   454,   166,     0,   455,     0,
     456,   457,   458,   459,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,  -956,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,     0,     0,
     472,  -956,   473,   474,   475,   476,   477,     0,   176,  -956,
     478,     0,     0,   479,   480,   481,     0,     0,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   183,
    -956,   185,     0,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,     0,   503,     0,   189,   190,
     504,   505,     0,     0,   506,     0,     0,     0,   507,   508,
       0,     0,   191,     0,     0,   194,   509,   510,   511,   512,
       0,   195,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,  -956,
     535,   536,   206,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,   545,     0,   546,   210,   547,   548,     0,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,   215,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   216,   217,     0,     0,   566,   218,   567,   219,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,     0,     0,   577,   578,     0,   579,   227,   580,
       0,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,     0,     0,   230,     0,    81,
      82,    83,   372,    85,    86,     0,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,  1350,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,     0,     0,     0,   395,   396,
       0,   397,   131,   398,   399,   400,   133,   134,   135,   136,
       0,     0,   401,   402,     0,   403,   404,     0,  1213,   405,
     406,   137,   407,     0,   408,   409,   410,   411,  1216,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,  1217,
     419,     0,   420,   421,   422,   147,   423,  1218,  1219,  1220,
    1221,  1222,   424,   425,   426,   427,   428,   150,   151,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,  1227,
       0,   448,   449,   161,     0,   450,     0,   451,   162,     0,
     163,   452,     0,   453,     0,   454,  1230,     0,   455,     0,
     456,   457,   458,   459,   167,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,   168,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,   173,   174,
     472,   175,   473,   474,   475,   476,   477,     0,  1234,   177,
     478,   178,     0,   479,   480,   481,  1235,  1236,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   183,
     184,   185,   749,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,   188,   503,     0,  1241,   190,
     504,   505,     0,     0,   506,   750,     0,   927,   507,   508,
       0,     0,   191,   192,   193,  1244,   509,   510,   511,   512,
       0,  1245,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,   204,
     535,   536,   206,   537,   538,   539,   540,   541,   542,     0,
     208,   543,   544,   545,  1248,   546,   210,   547,   548,   212,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,  1250,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   216,   217,     0,     0,   566,  1253,   567,  1254,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,  1257,     0,   577,   578,     0,  1739,   227,   580,
     228,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,     0,     0,   230,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
    2127,   101,   102,   103,   375,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,     0,     0,     0,   395,   396,     0,
     397,   131,   398,   399,   400,   133,   134,   135,   136,     0,
       0,   401,   402,     0,   403,   404,     0,  1213,   405,   406,
     137,   407,     0,   408,   409,   410,   411,  1216,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,  1217,   419,
       0,   420,   421,   422,   147,   423,  1218,  1219,  1220,  1221,
    1222,   424,   425,   426,   427,   428,   150,   151,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,   437,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,   157,   447,     0,  1227,     0,
     448,   449,   161,     0,   450,     0,   451,   162,     0,   163,
     452,     0,   453,     0,   454,  1230,     0,   455,     0,   456,
     457,   458,   459,   167,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,   168,   169,     0,   469,   470,
     471,     0,   171,     0,   172,     0,     0,   173,   174,   472,
     175,   473,   474,   475,   476,   477,     0,  1234,   177,   478,
     178,     0,   479,   480,   481,  1235,  1236,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   183,   184,
     185,   749,   493,   494,   495,   496,   497,   498,   499,   186,
     500,     0,   501,   502,   188,   503,     0,  1241,   190,   504,
     505,     0,     0,   506,   750,     0,   927,   507,   508,     0,
       0,   191,   192,   193,  1244,   509,   510,   511,   512,     0,
    1245,   196,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,   198,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,   204,   535,
     536,   206,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,  1248,   546,   210,   547,   548,   212,   549,
     213,     0,   550,   551,   552,   553,   554,   555,   556,   557,
    1250,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,   216,   217,     0,     0,   566,  1253,   567,  1254,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,  1257,     0,   577,   578,     0,   579,   227,   580,   228,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,    81,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,     0,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,  2127,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,     0,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
     131,   398,   399,   400,   133,   134,   135,   136,     0,     0,
     401,   402,     0,   403,   404,     0,  1213,   405,   406,   137,
     407,     0,   408,   409,   410,   411,  1216,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,  1217,   419,     0,
     420,   421,   422,   147,   423,  1218,  1219,  1220,  1221,  1222,
     424,   425,   426,   427,   428,   150,   151,   429,     0,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,  1227,     0,   448,
     449,   161,     0,   450,     0,   451,   162,     0,   163,   452,
       0,   453,     0,   454,  1230,     0,   455,     0,   456,   457,
     458,   459,   167,   460,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,   168,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,   173,   174,   472,   175,
     473,   474,   475,   476,   477,     0,  1234,   177,   478,   178,
       0,   479,   480,   481,  1235,  1236,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,   184,   185,
     749,   493,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,   188,   503,     0,  1241,   190,   504,   505,
       0,     0,   506,   750,     0,     0,   507,   508,     0,     0,
     191,   192,   193,  1244,   509,   510,   511,   512,     0,  1245,
     196,   513,   514,   515,     0,   516,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,   204,   535,   536,
     206,   537,   538,   539,   540,   541,   542,     0,     0,   543,
     544,   545,  1248,   546,   210,   547,   548,   212,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,  1250,
     558,     0,   559,   560,     0,   561,   562,   563,   564,     0,
     216,   217,     0,     0,   566,  1253,   567,  1254,     0,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
    1257,     0,   577,   578,     0,   579,   227,   580,   228,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,     0,     0,   230,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,  3327,   101,
     102,   103,   375,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,     0,
     398,   399,   400,     0,   134,     0,   136,     0,     0,   401,
     402,     0,   403,   404,     0,     0,   405,   406,   137,   407,
       0,   408,   409,   410,   411,   141,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,   144,   419,     0,   420,
     421,   422,     0,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,   150,   151,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
     437,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,   157,   447,     0,   159,     0,   448,   449,
     161,     0,   450,     0,   451,     0,     0,     0,   452,     0,
     453,     0,   454,   166,     0,   455,     0,   456,   457,   458,
     459,     0,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   169,     0,   469,   470,   471,     0,
     171,     0,   172,     0,     0,     0,     0,   472,     0,   473,
     474,   475,   476,   477,     0,   176,     0,   478,     0,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   183,     0,   185,     0,
     493,   494,   495,   496,   497,   498,   499,   186,   500,     0,
     501,   502,     0,   503,     0,   189,   190,   504,   505,     0,
       0,   506,     0,     0,     0,   507,   508,     0,     0,   191,
       0,     0,   194,   509,   510,   511,   512,     0,   195,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
     198,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,   206,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,   210,   547,   548,     0,   549,   213,     0,
     550,   551,   552,   553,   554,   555,   556,   557,   215,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,   216,
     217,     0,     0,   566,   218,   567,   219,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,   579,   227,   580,     0,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,    49,     0,   230,   588,     0,     0,     0,     0,
      52,    53,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2511,  2512,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   375,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,     0,     0,     0,   395,   396,     0,
     397,     0,   398,   399,   400,     0,   134,     0,   136,     0,
       0,   401,   402,     0,   403,   404,     0,     0,   405,   406,
     137,   407,     0,   408,   409,   410,   411,   141,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,   144,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,   150,   151,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,   437,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,   157,   447,     0,   159,     0,
     448,   449,   161,     0,   450,     0,   451,     0,     0,     0,
     452,     0,   453,     0,   454,   166,     0,   455,     0,   456,
     457,   458,   459,     0,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   169,     0,   469,   470,
     471,     0,   171,     0,   172,     0,     0,     0,     0,   472,
       0,   473,   474,   475,   476,   477,     0,   176,     0,   478,
       0,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   183,     0,
     185,     0,   493,   494,   495,   496,   497,   498,   499,   186,
     500,     0,   501,   502,     0,   503,     0,   189,   190,   504,
     505,     0,     0,   506,     0,     0,     0,   507,   508,     0,
       0,   191,     0,     0,   194,   509,   510,   511,   512,     0,
     195,   196,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,   198,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   206,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,   546,   210,   547,   548,     0,   549,
     213,     0,   550,   551,   552,   553,   554,   555,   556,   557,
     215,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,   216,   217,     0,     0,   566,   218,   567,   219,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,   579,   227,   580,     0,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,    49,     0,   230,   588,     0,     0,
       0,     0,    52,    53,    81,    82,    83,   372,    85,    86,
       0,    87,    88,    89,   373,     0,   374,     0,    93,  2512,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     375,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   116,   376,   377,
       0,     0,     0,   378,   379,     0,     0,     0,     0,   380,
       0,     0,     0,     0,     0,     0,     0,     0,   381,     0,
     382,     0,   383,   384,     0,   385,   386,   387,   388,   389,
     390,   391,   392,     0,   393,   394,     0,     0,     0,     0,
       0,     0,     0,   395,   396,     0,   397,     0,   398,   399,
     400,     0,   134,     0,   136,     0,     0,   401,   402,     0,
     403,   404,     0,     0,   405,   406,   137,   407,     0,   408,
     409,   410,   411,   141,     0,     0,   412,   413,   414,   415,
     416,     0,   417,   418,   144,   419,     0,   420,   421,   422,
       0,   423,     0,     0,     0,     0,     0,   424,   425,   426,
     427,   428,   150,   151,   429,     0,   430,     0,   431,     0,
     432,   433,   434,     0,   435,     0,     0,   436,   437,   438,
     439,     0,   440,   441,   442,     0,   443,     0,   444,   445,
     446,   157,   447,     0,   159,     0,   448,   449,   161,     0,
     450,     0,   451,     0,     0,     0,   452,     0,   453,     0,
     454,   166,     0,   455,     0,   456,   457,   458,   459,     0,
     460,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   169,     0,   469,   470,   471,     0,   171,     0,
     172,     0,     0,     0,     0,   472,     0,   473,   474,   475,
     476,   477,     0,   176,     0,   478,     0,     0,   479,   480,
     481,     0,     0,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   183,     0,   185,   749,   493,   494,
     495,   496,   497,   498,   499,   186,   500,     0,   501,   502,
       0,   503,     0,   189,   190,   504,   505,     0,     0,   506,
     750,     0,     0,   507,   508,     0,     0,   191,     0,     0,
     194,   509,   510,   511,   512,     0,   195,   196,   513,   514,
     515,     0,   516,   517,   518,   519,   520,   521,   198,   522,
     523,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,     0,   533,   534,     0,   535,   536,   206,   537,   538,
     539,   540,   541,   542,     0,     0,   543,   544,   545,     0,
     546,   210,   547,   548,     0,   549,   213,     0,   550,   551,
     552,   553,   554,   555,   556,   557,   215,   558,     0,   559,
     560,     0,   561,   562,   563,   564,     0,   216,   217,     0,
       0,   566,   218,   567,   219,     0,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,   576,     0,     0,   577,
     578,     0,   579,   227,   580,     0,   581,     0,     0,     0,
     582,   583,   584,   585,   586,   587,     0,     0,     0,   229,
       0,     0,   230,    81,    82,    83,   372,    85,    86,     0,
      87,    88,    89,   373,     0,   374,     0,    93,     0,    95,
      96,    97,    98,    99,   100,  1338,   101,   102,   103,   375,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   116,   376,   377,     0,
       0,     0,   378,   379,     0,     0,     0,     0,   380,     0,
       0,     0,     0,     0,     0,     0,     0,   381,     0,   382,
       0,   383,   384,     0,   385,   386,   387,   388,   389,   390,
     391,   392,     0,   393,   394,     0,     0,     0,     0,     0,
       0,     0,   395,   396,     0,   397,     0,   398,   399,   400,
       0,   134,     0,   136,     0,     0,   401,   402,     0,   403,
     404,     0,     0,   405,   406,   137,   407,     0,   408,   409,
     410,   411,   141,     0,     0,   412,   413,   414,   415,   416,
       0,   417,   418,   144,   419,     0,   420,   421,   422,     0,
     423,     0,     0,     0,     0,     0,   424,   425,   426,   427,
     428,   150,   151,   429,     0,   430,     0,   431,     0,   432,
     433,   434,     0,   435,     0,     0,   436,   437,   438,   439,
       0,   440,   441,   442,     0,   443,     0,   444,   445,   446,
     157,   447,     0,   159,     0,   448,   449,   161,     0,   450,
       0,   451,     0,     0,     0,   452,     0,   453,     0,   454,
     166,     0,   455,     0,   456,   457,   458,   459,     0,   460,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   169,     0,   469,   470,   471,     0,   171,     0,   172,
       0,     0,     0,     0,   472,     0,   473,   474,   475,   476,
     477,     0,   176,     0,   478,     0,     0,   479,   480,   481,
       0,     0,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   183,     0,   185,     0,   493,   494,   495,
     496,   497,   498,   499,   186,   500,     0,   501,   502,     0,
     503,     0,   189,   190,   504,   505,     0,     0,   506,     0,
       0,     0,   507,   508,     0,     0,   191,     0,     0,   194,
     509,   510,   511,   512,     0,   195,   196,   513,   514,   515,
       0,   516,   517,   518,   519,   520,   521,   198,   522,   523,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
       0,   533,   534,     0,   535,   536,   206,   537,   538,   539,
     540,   541,   542,     0,   208,   543,   544,   545,     0,   546,
     210,   547,   548,     0,   549,   213,     0,   550,   551,   552,
     553,   554,   555,   556,   557,   215,   558,     0,   559,   560,
       0,   561,   562,   563,   564,     0,   216,   217,     0,     0,
     566,   218,   567,   219,     0,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,   576,     0,     0,   577,   578,
       0,  1739,   227,   580,     0,   581,     0,     0,     0,   582,
     583,   584,   585,   586,   587,     0,     0,     0,   229,     0,
       0,   230,   588,     0,     0,     0,     0,     0,     0,    81,
      82,    83,   372,    85,    86,     0,    87,    88,    89,   373,
       0,   374,     0,    93,   231,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,     0,     0,     0,   395,   396,
       0,   397,     0,   398,   399,   400,     0,   134,     0,   136,
       0,     0,   401,   402,     0,   403,   404,     0,     0,   405,
     406,   137,   407,     0,   408,   409,   410,   411,   141,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,   144,
     419,     0,   420,   421,   422,     0,   423,     0,     0,     0,
       0,     0,   424,   425,   426,   427,   428,   150,   151,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,   159,
       0,   448,   449,   161,     0,   450,     0,   451,     0,     0,
       0,   452,     0,   453,     0,   454,   166,     0,   455,     0,
     456,   457,   458,   459,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,     0,     0,
     472,     0,   473,   474,   475,   476,   477,     0,   176,     0,
     478,     0,     0,   479,   480,   481,     0,     0,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   183,
       0,   185,     0,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,     0,   503,     0,   189,   190,
     504,   505,     0,     0,   506,     0,     0,     0,   507,   508,
       0,     0,   191,     0,     0,   194,   509,   510,   511,   512,
       0,   195,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   206,   537,   538,   539,   540,   541,   542,     0,
     208,   543,   544,   545,     0,   546,   210,   547,   548,     0,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,   215,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   216,   217,     0,     0,   566,   218,   567,   219,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,     0,     0,   577,   578,     0,  1739,   227,   580,
       0,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,     0,     0,   230,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
     231,   101,   102,   103,   375,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,     0,     0,     0,   395,   396,     0,
     397,     0,   398,   399,   400,     0,   134,     0,   136,     0,
       0,   401,   402,     0,   403,   404,     0,     0,   405,   406,
     137,   407,     0,   408,   409,   410,   411,   141,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,   144,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,   150,   151,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,   437,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,   157,   447,     0,   159,     0,
     448,   449,   161,     0,   450,     0,   451,     0,     0,     0,
     452,     0,   453,     0,   454,   166,     0,   455,     0,   456,
     457,   458,   459,     0,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   169,     0,   469,   470,
     471,     0,   171,     0,   172,     0,     0,     0,     0,   472,
       0,   473,   474,   475,   476,   477,     0,   176,     0,   478,
       0,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   183,     0,
     185,     0,   493,   494,   495,   496,   497,   498,   499,   186,
     500,     0,   501,   502,     0,   503,     0,   189,   190,   504,
     505,     0,     0,   506,     0,     0,     0,   507,   508,     0,
       0,   191,     0,     0,   194,   509,   510,   511,   512,     0,
     195,   196,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,   198,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   206,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,   546,   210,   547,   548,     0,   549,
     213,     0,   550,   551,   552,   553,   554,   555,   556,   557,
     215,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,   216,   217,     0,     0,   566,   218,   567,   219,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,   579,   227,   580,     0,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,    81,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,     0,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,  1830,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,     0,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
       0,   398,   399,   400,     0,   134,     0,   136,     0,     0,
     401,   402,     0,   403,   404,     0,     0,   405,   406,   137,
     407,     0,   408,   409,   410,   411,   141,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,   144,   419,     0,
     420,   421,   422,     0,   423,     0,     0,     0,     0,     0,
     424,   425,   426,   427,   428,   150,   151,   429,     0,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,   159,     0,   448,
     449,   161,     0,   450,     0,   451,     0,     0,     0,   452,
       0,   453,     0,   454,   166,     0,   455,     0,   456,   457,
     458,   459,     0,   460,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,     0,     0,   472,     0,
     473,   474,   475,   476,   477,     0,   176,     0,   478,     0,
       0,   479,   480,   481,     0,     0,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,     0,   185,
       0,   493,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,     0,   503,     0,   189,   190,   504,   505,
       0,     0,   506,     0,     0,     0,   507,   508,     0,     0,
     191,     0,     0,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   514,   515,     0,   516,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     206,   537,   538,   539,   540,   541,   542,     0,     0,   543,
     544,   545,     0,   546,   210,   547,   548,     0,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,     0,   559,   560,     0,   561,   562,   563,   564,     0,
     216,   217,     0,     0,   566,   218,   567,   219,     0,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
       0,     0,   577,   578,     0,   579,   227,   580,     0,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,     0,     0,   230,     0,     0,     0,     0,
       0,     0,   619,    81,    82,    83,   372,    85,    86,     0,
      87,    88,    89,   373,     0,   374,     0,    93,  2979,    95,
      96,    97,    98,    99,   100,   620,   101,   102,   103,   375,
     621,     0,   105,   106,   107,   108,   622,   623,     0,   110,
     111,   112,     0,   113,   624,   625,   116,   376,   377,     0,
       0,     0,   378,   379,     0,     0,     0,     0,   380,     0,
       0,     0,     0,     0,     0,     0,     0,   381,     0,   382,
       0,   383,   384,     0,   385,   386,   387,   388,   389,   390,
     391,   392,   626,   393,   394,   627,   628,   629,   630,   631,
     632,   633,   395,   396,   634,   397,   131,   398,   399,   400,
     133,  1529,   135,  1530,  1211,   635,   401,   402,     0,   403,
     404,   636,   637,   405,  1531,  1532,   407,   639,   408,   409,
     410,   411,     0,   640,   641,   412,   413,   414,   415,   416,
     642,   417,   418,     0,   419,   643,   420,   421,   422,   147,
     423,   644,   645,   646,   647,   648,   424,   425,   426,   427,
     428,  1533,  1534,   429,   649,   430,   650,   431,     0,   432,
     433,   434,   651,   435,   652,   653,   436,  1225,   438,   439,
     654,   440,   441,   442,   655,   443,   656,   444,   445,   446,
       0,   447,     0,     0,   657,   448,   449,  1535,   658,   450,
     659,   451,   162,   660,   163,   452,     0,   453,   661,   454,
       0,   662,   455,   663,   456,   457,   458,   459,   167,   460,
     461,   462,   664,   463,   464,   465,   466,   467,   468,   665,
     168,     0,     0,   469,   470,   471,  1231,  1536,   668,  1537,
     669,     0,   173,   174,   472,   175,   473,   474,   475,   476,
     477,   670,     0,   177,   478,   178,   671,   479,   480,   481,
       0,     0,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,  1538,   184,  1539,   672,   493,   494,   495,
     496,   497,   498,   499,     0,   500,   673,   501,   502,   188,
     503,   674,     0,  1540,   504,   505,   675,   676,   506,   677,
     678,   679,  2873,   508,   680,   681,     0,   192,   193,     0,
     509,   510,   511,   512,     0,     0,     0,   513,   514,   515,
     682,   516,   517,   518,   519,   520,   521,  1541,   522,   523,
     683,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     684,   533,   534,   204,   535,   536,     0,   537,   538,   539,
     540,   541,   542,     0,   685,   543,   544,   545,   686,   546,
    1542,   547,   548,   212,   549,  1543,   687,   550,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   688,   559,   560,
     689,   561,   562,   563,   564,   690,  1544,  1545,     0,   692,
     566,     0,   567,     0,   693,   568,   569,   570,   571,   572,
       0,   695,   573,   574,   575,   576,   696,   697,   577,   578,
       0,     0,  1546,   580,   228,   581,     0,   698,   699,   582,
     583,   584,   585,   586,   587,     0,     0,     0,   229,    49,
    1037,   230,   588,     0,     0,     0,     0,    52,    53,     0,
      54,  1038,  1039,  1040,     0,  1041,  2874,  1043,  1044,  1045,
    1046,    81,    82,    83,   372,    85,    86,     0,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   406,   137,   407,     0,   408,  1036,   410,   411,
     141,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,   144,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,     0,   448,   449,   161,     0,   450,     0,   451,
       0,     0,     0,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
     176,     0,   478,     0,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   183,     0,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   206,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   545,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   216,   217,     0,     0,   566,   218,
     567,   219,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,     0,     0,   577,   578,     0,   579,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,     0,  1037,   230,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1038,
    1039,  1040,     0,  1041,  1042,  1043,  1044,  1045,  1046,    81,
      82,    83,   372,    85,    86,     0,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,     0,     0,     0,   395,   396,
       0,   397,     0,   398,   399,   400,     0,   134,     0,   136,
       0,     0,   401,   402,     0,   403,   404,     0,     0,   405,
     406,   137,   407,     0,   408,   409,   410,   411,   141,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,   144,
     419,     0,   420,   421,   422,     0,   423,     0,     0,     0,
       0,     0,   424,   425,   426,   427,   428,   150,   151,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,   159,
       0,   448,   449,   161,     0,   450,     0,   451,     0,     0,
       0,   452,     0,   453,     0,   454,   166,     0,   455,     0,
     456,   457,   458,   459,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,     0,     0,
     472,     0,   473,   474,   475,   476,   477,     0,   176,     0,
     478,     0,     0,   479,   480,   481,     0,     0,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   183,
       0,   185,     0,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,     0,   503,     0,   189,   190,
     504,   505,     0,     0,   506,     0,     0,     0,   507,   508,
       0,     0,   191,     0,     0,   194,   509,   510,   511,   512,
       0,   195,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   206,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,   545,     0,   546,   210,   547,   548,     0,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,   215,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   216,   217,     0,     0,   566,   218,   567,   219,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,     0,     0,   577,   578,     0,   579,   227,   580,
       0,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,     0,  1037,   230,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1038,  1039,  1040,
       0,  1041,  1042,  1043,  1044,  1045,  1046,   619,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
     620,   101,   102,   103,   375,   621,     0,   105,   106,   107,
     108,   622,   623,     0,   110,   111,   112,     0,   113,   624,
     625,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,   626,   393,   394,
     627,   628,   629,   630,   631,   632,   633,   395,   396,   634,
     397,   131,   398,   399,   400,   133,   134,   135,   136,     0,
     635,   401,   402,     0,   403,   404,   636,   637,   405,   638,
     137,   407,   639,   408,   409,   410,   411,   141,   640,   641,
     412,   413,   414,   415,   416,   642,   417,   418,   144,   419,
     643,   420,   421,   422,   147,   423,   644,   645,   646,   647,
     648,   424,   425,   426,   427,   428,   150,   151,   429,   649,
     430,   650,   431,     0,   432,   433,   434,   651,   435,   652,
     653,   436,   437,   438,   439,   654,   440,   441,   442,   655,
     443,   656,   444,   445,   446,   157,   447,     0,   159,   657,
     448,   449,   161,   658,   450,   659,   451,   162,   660,   163,
     452,     0,   453,   661,   454,   166,   662,   455,   663,   456,
     457,   458,   459,   167,   460,   461,   462,   664,   463,   464,
     465,   466,   467,   468,   665,   168,   169,   666,   469,   470,
     471,   667,   171,   668,   172,   669,     0,   173,   174,   472,
     175,   473,   474,   475,   476,   477,   670,   176,   177,   478,
     178,   671,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   183,   184,
     185,   672,   493,   494,   495,   496,   497,   498,   499,   186,
     500,   673,   501,   502,   188,   503,   674,   189,   190,   504,
     505,   675,   676,   506,   677,   678,   679,   507,   508,   680,
     681,   191,   192,   193,   194,   509,   510,   511,   512,     0,
     195,   196,   513,   514,   515,   682,   516,   517,   518,   519,
     520,   521,   198,   522,   523,   683,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   684,   533,   534,   204,   535,
     536,   206,   537,   538,   539,   540,   541,   542,     0,   685,
     543,   544,   545,   686,   546,   210,   547,   548,   212,   549,
     213,   687,   550,   551,   552,   553,   554,   555,   556,   557,
     215,   558,   688,   559,   560,   689,   561,   562,   563,   564,
     690,   216,   217,   691,   692,   566,   218,   567,   219,   693,
     568,   569,   570,   571,   572,   694,   695,   573,   574,   575,
     576,   696,   697,   577,   578,     0,     0,   227,   580,   228,
     581,     0,   698,   699,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,     0,   619,    81,
      82,    83,   372,    85,    86,     0,    87,    88,    89,   373,
       0,   374,  1504,    93,     0,    95,    96,    97,    98,    99,
     100,   620,   101,   102,   103,   375,   621,     0,   105,   106,
     107,   108,   622,   623,     0,   110,   111,   112,     0,   113,
     624,   625,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,     0,     0,     0,   395,   396,
       0,   397,     0,   398,   399,   400,     0,  1529,     0,  1530,
    1211,     0,   401,   402,     0,   403,   404,     0,     0,   405,
    1531,  1532,   407,     0,   408,   409,   410,   411,     0,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,     0,
     419,     0,   420,   421,   422,     0,   423,     0,     0,     0,
       0,     0,   424,   425,   426,   427,   428,  1533,  1534,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,  1225,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,     0,   447,     0,     0,
       0,   448,   449,  1535,     0,   450,     0,   451,     0,     0,
       0,   452,     0,   453,     0,   454,     0,     0,   455,     0,
     456,   457,   458,   459,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,     0,     0,   469,
     470,   471,  1231,  1536,     0,  1537,     0,     0,     0,     0,
     472,     0,   473,   474,   475,   476,   477,     0,     0,     0,
     478,     0,     0,   479,   480,   481,     0,     0,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,  1538,
       0,  1539,     0,   493,   494,   495,   496,   497,   498,   499,
       0,   500,     0,   501,   502,     0,   503,     0,     0,  1540,
     504,   505,     0,     0,   506,     0,     0,     0,   507,   508,
       0,     0,     0,     0,     0,     0,   509,   510,   511,   512,
       0,     0,     0,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,  1541,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,     0,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,   545,     0,   546,  1542,   547,   548,     0,
     549,  1543,     0,   550,   551,   552,   553,   554,   555,   556,
     557,     0,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,  1544,  1545,     0,     0,   566,     0,   567,     0,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,     0,     0,   577,   578,     0,     0,  1546,   580,
       0,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,     0,     0,   230,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,  1905,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   375,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,     0,     0,     0,   395,   396,     0,
     397,     0,   398,   399,   400,     0,   134,     0,   136,     0,
       0,   401,   402,     0,   403,   404,     0,     0,   405,   406,
     137,   407,     0,   408,   409,   410,   411,   141,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,   144,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,   150,   151,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,   437,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,   157,   447,     0,   159,     0,
     448,   449,   161,     0,   450,     0,   451,     0,     0,     0,
     452,     0,   453,     0,   454,   166,     0,   455,     0,   456,
     457,   458,   459,     0,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   169,     0,   469,   470,
     471,     0,   171,     0,   172,     0,     0,     0,     0,   472,
       0,   473,   474,   475,   476,   477,     0,   176,     0,   478,
       0,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   183,     0,
     185,   749,   493,   494,   495,   496,   497,   498,   499,   186,
     500,     0,   501,   502,     0,   503,     0,   189,   190,   504,
     505,     0,     0,   506,   750,     0,     0,   507,   508,     0,
       0,   191,     0,     0,   194,   509,   510,   511,   512,     0,
     195,   196,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,   198,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   206,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,   546,   210,   547,   548,     0,   549,
     213,     0,   550,   551,   552,   553,   554,   555,   556,   557,
     215,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,   216,   217,     0,     0,   566,   218,   567,   219,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,   579,   227,   580,     0,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,    81,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,     0,   374,
       0,    93,   925,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,     0,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
       0,   398,   399,   400,     0,   134,     0,   136,     0,     0,
     401,   402,     0,   403,   404,     0,     0,   405,   406,   137,
     407,     0,   408,   409,   410,   411,   141,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,   144,   419,     0,
     420,   421,   422,     0,   423,     0,     0,     0,     0,     0,
     424,   425,   426,   427,   428,   150,   151,   429,  1811,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,   159,  1812,   448,
     449,   161,     0,   450,     0,   451,     0,     0,     0,   452,
       0,   453,     0,   454,   166,     0,   455,     0,   456,   457,
     458,   459,     0,   460,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,     0,     0,   472,     0,
     473,   474,   475,   476,   477,     0,   176,     0,   478,     0,
       0,   479,   480,   481,     0,     0,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,     0,   185,
       0,   493,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,     0,   503,     0,   189,   190,   504,   505,
    1813,     0,   506,     0,  1814,     0,   507,   508,     0,     0,
     191,     0,     0,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   514,   515,     0,   516,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     206,   537,   538,   539,   540,   541,   542,     0,     0,   543,
     544,   545,     0,   546,   210,   547,   548,     0,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,     0,   559,   560,     0,   561,   562,   563,   564,     0,
     216,   217,     0,     0,   566,   218,   567,   219,  1815,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
       0,     0,   577,   578,     0,   579,   227,   580,     0,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,    49,     0,   230,   588,     0,     0,     0,
       0,    52,    53,     0,    54,     0,     0,     0,     0,     0,
    1382,    81,    82,    83,   372,    85,    86,     0,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   406,   137,   407,     0,   408,   409,   410,   411,
     141,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,   144,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,  1812,   448,   449,   161,     0,   450,     0,   451,
       0,     0,     0,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
     176,     0,   478,     0,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   183,     0,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,  1813,     0,   506,     0,  1814,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   206,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   545,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   216,   217,     0,     0,   566,   218,
     567,   219,  1815,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,     0,     0,   577,   578,     0,   579,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,    49,     0,   230,
     588,     0,     0,     0,     0,    52,    53,     0,    54,     0,
       0,     0,     0,     0,  1382,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   833,   387,   388,
     389,   390,   391,   392,   834,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   395,   396,     0,   397,     0,   835,
     399,   400,     0,   134,     0,   136,     0,     0,   401,   402,
       0,   403,   404,     0,     0,   405,   406,   137,   407,     0,
     408,   409,   410,   411,   141,     0,     0,   412,   413,   414,
     415,   416,     0,   417,   418,   144,   419,     0,   420,   421,
     422,     0,   423,     0,     0,     0,     0,     0,   424,   425,
     426,   427,   428,   150,   151,   429,     0,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,   437,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,   157,   447,     0,   159,     0,   448,   836,   161,
       0,   450,     0,   837,     0,   838,     0,   452,     0,   453,
       0,   454,   166,     0,   455,     0,   456,   457,   458,   459,
       0,   460,   461,   462,   839,   463,   464,   465,   466,   467,
     468,     0,     0,   169,     0,   469,   470,   471,     0,   171,
       0,   172,     0,     0,     0,     0,   472,     0,   473,   474,
     475,   476,   840,     0,   176,     0,   478,     0,     0,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   183,     0,   185,     0,   841,
     494,   495,   496,   497,   498,   499,   186,   500,     0,   501,
     502,     0,   503,     0,   189,   190,   504,   505,     0,     0,
     506,     0,     0,     0,   507,   508,     0,     0,   191,     0,
       0,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     514,   515,     0,   842,   517,   518,   519,   520,   521,   198,
     522,   523,     0,   524,   843,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   206,   537,
     538,   539,   540,   541,   542,     0,     0,   543,   544,   545,
       0,   546,   210,   547,   548,     0,   549,   213,     0,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,     0,
     559,   560,     0,   561,   562,   563,   564,     0,   216,   217,
       0,     0,   566,   218,   567,   219,     0,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,   576,     0,     0,
     577,   578,     0,   579,   227,   580,     0,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,     0,     0,   230,   588,     0,     0,     0,     0,     0,
      53,     0,    81,    82,    83,   372,    85,    86,   844,    87,
      88,    89,   373,     0,   374,     0,    93,     0,    95,    96,
      97,    98,    99,   100,     0,   101,   102,   103,   375,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   116,   376,   377,     0,     0,
       0,   378,   379,     0,     0,     0,     0,   380,     0,     0,
       0,     0,     0,     0,     0,     0,   381,     0,   382,     0,
     383,   384,     0,   385,   833,   387,   388,   389,   390,   391,
     392,   834,   393,   394,     0,     0,     0,     0,     0,     0,
       0,   395,   396,     0,   397,     0,   835,   399,   400,     0,
     134,     0,   136,     0,     0,   401,   402,     0,   403,   404,
       0,     0,   405,   406,   137,   407,     0,   408,   409,   410,
     411,   141,     0,     0,   412,   413,   414,   415,   416,     0,
     417,   418,   144,   419,     0,   420,   421,   422,     0,   423,
       0,     0,     0,     0,     0,   424,   425,   426,   427,   428,
     150,   151,   429,     0,   430,     0,   431,     0,   432,   433,
     434,     0,   435,     0,     0,   436,   437,   438,   439,     0,
     440,   441,   442,     0,   443,     0,   444,   445,   446,   157,
     447,     0,   159,     0,   448,   836,   161,     0,   450,     0,
     837,     0,     0,     0,   452,     0,   453,     0,   454,   166,
       0,   455,     0,   456,   457,   458,   459,     0,   460,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     169,     0,   469,   470,   471,     0,   171,     0,   172,     0,
       0,     0,     0,   472,     0,   473,   474,   475,   476,   840,
       0,   176,     0,   478,     0,     0,   479,   480,   481,     0,
       0,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   183,     0,   185,     0,   841,   494,   495,   496,
     497,   498,   499,   186,   500,     0,   501,   502,     0,   503,
       0,   189,   190,   504,   505,     0,     0,   506,     0,     0,
       0,   507,   508,     0,     0,   191,     0,     0,   194,   509,
     510,   511,   512,     0,   195,   196,   513,   514,   515,     0,
     842,   517,   518,   519,   520,   521,   198,   522,   523,     0,
     524,   843,   526,   527,   528,   529,   530,   531,   532,     0,
     533,   534,     0,   535,   536,   206,   537,   538,   539,   540,
     541,   542,     0,     0,   543,   544,   545,     0,   546,   210,
     547,   548,     0,   549,   213,     0,   550,   551,   552,   553,
     554,   555,   556,   557,   215,   558,     0,   559,   560,     0,
     561,   562,   563,   564,     0,   216,   217,     0,     0,   566,
     218,   567,   219,     0,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,   576,     0,     0,   577,   578,     0,
     579,   227,   580,     0,   581,     0,     0,     0,   582,   583,
     584,   585,   586,   587,     0,     0,     0,   229,     0,     0,
     230,   588,     0,     0,     0,     0,     0,    53,     0,    81,
      82,    83,   372,    85,    86,   844,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,     0,     0,     0,   395,   396,
       0,   397,     0,   398,   399,   400,     0,   134,     0,   136,
       0,     0,   401,   402,     0,   403,   404,     0,     0,   405,
     406,   137,   407,     0,   408,   409,   410,   411,   141,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,   144,
     419,     0,   420,   421,   422,     0,   423,     0,     0,     0,
       0,     0,   424,   425,   426,   427,   428,   150,   151,   429,
     612,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,   159,
       0,   448,   449,   161,     0,   450,     0,   451,     0,     0,
       0,   452,     0,   453,     0,   454,   166,     0,   455,     0,
     456,   457,   458,   459,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,     0,     0,
     472,     0,   473,   474,   475,   476,   477,     0,   176,     0,
     478,     0,     0,   479,   480,   481,     0,     0,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   183,
       0,   185,     0,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,     0,   503,     0,   189,   190,
     504,   505,     0,     0,   506,     0,     0,     0,   507,   508,
       0,     0,   191,     0,     0,   194,   509,   510,   511,   512,
       0,   195,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   206,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,   545,     0,   546,   210,   547,   548,     0,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,   215,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   216,   217,  1310,     0,   566,   218,   567,   219,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,     0,     0,   577,   578,     0,   579,   227,   580,
       0,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,     0,     0,   230,   588,     0,
       0,    81,    82,    83,   372,    85,    86,  1311,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   406,   137,   407,     0,   408,   409,   410,   411,
     141,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,   144,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,     0,   448,   449,   161,     0,   450,     0,   451,
       0,     0,     0,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
     176,     0,   478,     0,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   183,     0,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   206,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   545,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   216,   217,     0,     0,   566,   218,
     567,   219,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,     0,     0,   577,   578,     0,   579,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,    49,     0,   230,
     588,     0,     0,  1260,  1261,    52,    53,     0,    54,    81,
      82,    83,   372,    85,    86,     0,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,     0,     0,     0,   395,   396,
       0,   397,     0,   398,   399,   400,     0,   134,     0,   136,
       0,     0,   401,   402,     0,   403,   404,     0,     0,   405,
     406,   137,   407,     0,   408,   409,   410,   411,   141,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,   144,
     419,     0,   420,   421,   422,     0,   423,     0,     0,     0,
       0,     0,   424,   425,   426,   427,   428,   150,   151,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,   159,
       0,   448,   449,   161,     0,   450,     0,   451,     0,     0,
       0,   452,     0,   453,     0,   454,   166,     0,   455,     0,
     456,   457,   458,   459,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,     0,     0,
     472,     0,   473,   474,   475,   476,   477,     0,   176,     0,
     478,     0,     0,   479,   480,   481,     0,     0,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   183,
       0,   185,     0,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,     0,   503,     0,   189,   190,
     504,   505,     0,     0,   506,     0,     0,     0,   507,   508,
       0,     0,   191,     0,     0,   194,   509,   510,   511,   512,
       0,   195,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   206,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,   545,     0,   546,   210,   547,   548,     0,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,   215,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   216,   217,   565,     0,   566,   218,   567,   219,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,     0,     0,   577,   578,     0,   579,   227,   580,
       0,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,    49,     0,   230,   588,     0,
       0,     0,     0,    52,    81,    82,    83,   372,    85,    86,
       0,    87,    88,    89,   373,     0,   374,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     375,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   116,   376,   377,
       0,     0,     0,   378,   379,     0,     0,     0,     0,   380,
       0,     0,     0,     0,     0,     0,     0,     0,   381,     0,
     382,     0,   383,   384,     0,   385,   386,   387,   388,   389,
     390,   391,   392,     0,   393,   394,     0,     0,     0,     0,
       0,     0,     0,   395,   396,     0,   397,     0,   398,   399,
     400,     0,   134,     0,   136,     0,     0,   401,   402,     0,
     403,   404,     0,     0,   405,   406,   137,   407,     0,   408,
     409,   410,   411,   141,     0,     0,   412,   413,   414,   415,
     416,     0,   417,   418,   144,   419,     0,   420,   421,   422,
       0,   423,     0,     0,     0,     0,     0,   424,   425,   426,
     427,   428,   150,   151,   429,   983,   430,     0,   431,     0,
     432,   433,   434,     0,   435,     0,     0,   436,   437,   438,
     439,     0,   440,   441,   442,     0,   443,     0,   444,   445,
     446,   157,   447,     0,   159,     0,   448,   449,   161,     0,
     450,     0,   451,     0,     0,     0,   452,     0,   453,     0,
     454,   166,     0,   455,     0,   456,   457,   458,   459,     0,
     460,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   169,     0,   469,   470,   471,     0,   171,     0,
     172,     0,     0,     0,     0,   472,     0,   473,   474,   475,
     476,   477,     0,   176,     0,   478,     0,     0,   479,   480,
     481,     0,     0,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   183,     0,   185,     0,   493,   494,
     495,   496,   497,   498,   499,   186,   500,     0,   501,   502,
       0,   503,     0,   189,   190,   504,   505,     0,     0,   506,
       0,     0,     0,   507,   508,     0,     0,   191,     0,     0,
     194,   509,   510,   511,   512,     0,   195,   196,   513,   514,
     515,     0,   516,   517,   518,   519,   520,   521,   198,   522,
     523,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,     0,   533,   534,     0,   535,   536,   206,   537,   538,
     539,   540,   541,   542,     0,     0,   543,   544,   545,     0,
     546,   210,   547,   548,     0,   549,   213,     0,   550,   551,
     552,   553,   554,   555,   556,   557,   215,   558,     0,   559,
     560,     0,   561,   562,   563,   564,     0,   216,   217,     0,
       0,   566,   218,   567,   219,     0,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,   576,     0,     0,   577,
     578,     0,   579,   227,   580,     0,   581,     0,     0,     0,
     582,   583,   584,   585,   586,   587,     0,     0,     0,   229,
      49,     0,   230,   588,     0,     0,     0,     0,    52,    81,
      82,    83,   372,    85,    86,     0,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,     0,     0,     0,   395,   396,
       0,   397,     0,   398,   399,   400,     0,   134,     0,   136,
       0,     0,   401,   402,     0,   403,   404,     0,     0,   405,
     406,   137,   407,     0,   408,   409,   410,   411,   141,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,   144,
     419,     0,   420,   421,   422,     0,   423,     0,     0,     0,
       0,     0,   424,   425,   426,   427,   428,   150,   151,   429,
    1802,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,   159,
       0,   448,   449,   161,     0,   450,     0,   451,     0,     0,
       0,   452,     0,   453,     0,   454,   166,     0,   455,     0,
     456,   457,   458,   459,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,     0,     0,
     472,     0,   473,   474,   475,   476,   477,     0,   176,     0,
     478,     0,     0,   479,   480,   481,     0,     0,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   183,
       0,   185,     0,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,     0,   503,     0,   189,   190,
     504,   505,     0,     0,   506,     0,     0,     0,   507,   508,
       0,     0,   191,     0,     0,   194,   509,   510,   511,   512,
       0,   195,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   206,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,   545,     0,   546,   210,   547,   548,     0,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,   215,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   216,   217,     0,     0,   566,   218,   567,   219,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,     0,     0,   577,   578,     0,   579,   227,   580,
       0,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,    49,     0,   230,   588,     0,
       0,     0,     0,    52,    81,    82,    83,   372,    85,    86,
       0,    87,    88,    89,   373,     0,   374,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     375,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   116,   376,   377,
       0,     0,     0,   378,   379,     0,     0,     0,     0,   380,
       0,     0,     0,     0,     0,     0,     0,     0,   381,     0,
     382,     0,   383,   384,     0,   385,   386,   387,   388,   389,
     390,   391,   392,     0,   393,   394,     0,     0,     0,     0,
       0,     0,     0,   395,   396,     0,   397,     0,   398,   399,
     400,     0,   134,     0,   136,     0,     0,   401,   402,     0,
     403,   404,     0,     0,   405,   406,   137,   407,     0,   408,
     409,   410,   411,   141,     0,     0,   412,   413,   414,   415,
     416,     0,   417,   418,   144,   419,     0,   420,   421,   422,
       0,   423,     0,     0,     0,     0,     0,   424,   425,   426,
     427,   428,   150,   151,   429,     0,   430,     0,   431,     0,
     432,   433,   434,     0,   435,     0,     0,   436,   437,   438,
     439,     0,   440,   441,   442,     0,   443,     0,   444,   445,
     446,   157,   447,     0,   159,     0,   448,   449,   161,     0,
     450,     0,   451,     0,     0,     0,   452,     0,   453,     0,
     454,   166,     0,   455,     0,   456,   457,   458,   459,     0,
     460,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   169,     0,   469,   470,   471,     0,   171,     0,
     172,     0,     0,     0,     0,   472,     0,   473,   474,   475,
     476,   477,     0,   176,     0,   478,     0,     0,   479,   480,
     481,     0,     0,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   183,     0,   185,     0,   493,   494,
     495,   496,   497,   498,   499,   186,   500,     0,   501,   502,
       0,   503,     0,   189,   190,   504,   505,     0,     0,   506,
       0,     0,     0,   507,   508,     0,     0,   191,     0,     0,
     194,   509,   510,   511,   512,     0,   195,   196,   513,   514,
     515,     0,   516,   517,   518,   519,   520,   521,   198,   522,
     523,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,     0,   533,   534,     0,   535,   536,   206,   537,   538,
     539,   540,   541,   542,     0,     0,   543,   544,   545,     0,
     546,   210,   547,   548,     0,   549,   213,     0,   550,   551,
     552,   553,   554,   555,   556,   557,   215,   558,     0,   559,
     560,     0,   561,   562,   563,   564,     0,   216,   217,     0,
       0,   566,   218,   567,   219,     0,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,   576,     0,     0,   577,
     578,     0,   579,   227,   580,     0,   581,     0,     0,     0,
     582,   583,   584,   585,   586,   587,     0,     0,     0,   229,
      49,     0,   230,   588,     0,     0,     0,     0,    52,    81,
      82,    83,   372,    85,    86,     0,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,     0,     0,     0,   395,   396,
       0,   397,     0,   398,   399,   400,     0,   134,     0,   136,
       0,     0,   401,   402,     0,   403,   404,     0,     0,   405,
     406,   137,   407,     0,   408,   409,   410,   411,   141,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,   144,
     419,     0,   420,   421,   422,     0,   423,     0,     0,     0,
       0,     0,   424,   425,   426,   427,   428,   150,   151,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,   159,
       0,   448,   449,   161,     0,   450,     0,   451,     0,     0,
       0,   452,     0,   453,     0,   454,   166,     0,   455,     0,
     456,   457,   458,   459,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,     0,     0,
     472,     0,   473,   474,   475,   476,   477,     0,   176,     0,
     478,     0,     0,   479,   480,   481,     0,     0,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   183,
       0,   185,     0,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,     0,   503,     0,   189,   190,
     504,   505,     0,     0,   506,     0,     0,     0,   507,   508,
       0,     0,   191,     0,     0,   194,   509,   510,   511,   512,
       0,   195,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   206,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,   545,     0,   546,   210,   547,   548,     0,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,   215,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   216,   217,     0,     0,   566,   218,   567,   219,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,     0,     0,   577,   578,     0,   579,   227,   580,
       0,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,     0,     0,   230,     0,   904,
    1594,    81,    82,    83,   372,    85,    86,     0,    87,    88,
      89,   373,   905,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   882,   137,   407,     0,   408,   409,   410,   411,
     141,     0,     0,   412,   413,   414,   415,   906,     0,   907,
     418,   144,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,     0,   448,   449,   161,     0,   450,     0,   451,
       0,     0,     0,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
     176,     0,   478,     0,     0,   479,   480,   908,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     909,   183,     0,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   910,   536,   206,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   911,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   912,   217,     0,     0,   913,   218,
     567,   219,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,     0,     0,   577,   578,     0,   886,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,    81,    82,    83,   229,    85,    86,   230,
      87,    88,    89,     0,     0,     0,    92,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,     0,
       0,     0,   105,   106,   107,   108,     0,   109,     0,   110,
     111,   112, -1413,   113,   114,   115,   116,     0,     0,     0,
       0,     0,   119,   120,     0,     0,     0,     0,   121,     0,
       0,     0,     0,     0,     0,     0,     0,   122,     0,   123,
       0,   124,   125,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   131,     0,     0,     0,
     133,   134,   135,   136,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   137,     0,     0,     0,     0,
       0,     0,   141,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   144,     0,     0,     0,     0,     0,   147,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   150,   151,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     157,     0,     0,   159,     0,     0,     0,   161,     0,     0,
       0,     0,   162,     0,   163,     0,     0,     0,     0,     0,
     166,     0,     0,     0,     0,     0,     0,     0,   167,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     168,   169,     0,     0,     0,     0,     0,   171,     0,   172,
       0,     0,   173,   174,     0,   175,     0,     0,     0,     0,
       0,     0,   176,   177,     0,   178,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   183,   184,   185,     0,     0,     0,     0,
       0,     0,     0,     0,   186,     0,     0,     0,     0,   188,
       0,     0,   189,   190,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   191,   192,   193,   194,
       0,     0,     0,     0,     0,   195,   196,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   198,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   204,     0,     0,   206,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     210,     0,     0,   212,     0,   213,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   215,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   216,   217,     0,     0,
       0,   218,     0,   219,     0,     0,     0,     0,     0,     0,
     222,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,     0,   228,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,     0,   363,    81,    82,    83,     0,    85,    86,
       0,    87,    88,    89,     0,     0,     0,    92,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
       0,     0,     0,   105,   106,   107,   108,     0,   109,     0,
     110,   111,   112, -1414,   113,   114,   115,   116,     0,     0,
       0,     0,     0,   119,   120,     0,     0,     0,     0,   121,
       0,     0,     0,     0,     0,     0,     0,     0,   122,     0,
     123,     0,   124,   125,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   131,     0,     0,
       0,   133,   134,   135,   136,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   137,     0,     0,     0,
       0,     0,     0,   141,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   144,     0,     0,     0,     0,     0,
     147,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   150,   151,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   157,     0,     0,   159,     0,     0,     0,   161,     0,
       0,     0,     0,   162,     0,   163,     0,     0,     0,     0,
       0,   166,     0,     0,     0,     0,     0,     0,     0,   167,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   168,   169,     0,     0,     0,     0,     0,   171,     0,
     172,     0,     0,   173,   174,     0,   175,     0,     0,     0,
       0,     0,     0,   176,   177,     0,   178,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   183,   184,   185,     0,     0,     0,
       0,     0,     0,     0,     0,   186,     0,     0,     0,     0,
     188,     0,     0,   189,   190,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   191,   192,   193,
     194,     0,     0,     0,     0,     0,   195,   196,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   198,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   204,     0,     0,   206,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   210,     0,     0,   212,     0,   213,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   215,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   216,   217,     0,
       0,     0,   218,     0,   219,     0,     0,     0,     0,     0,
       0,   222,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,     0,   228,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   229,
       0,     0,   230,     0,   974,   619,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,   620,   101,
     102,   103,   375,   621,     0,   105,   106,   107,   108,   622,
     623,     0,   110,   111,   112,     0,   113,   624,   625,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,   626,   393,   394,   627,   628,
     629,   630,   631,   632,   633,   395,   396,   634,   397,   131,
     398,   399,   400,   133,   134,   135,   136,     0,   635,   401,
     402,     0,   403,   404,   636,   637,   405,   638,   137,   407,
     639,   408,   409,   410,   411,   141,   640,   641,   412,   413,
     414,   415,   416,   642,   417,   418,   144,   419,   643,   420,
     421,   422,   147,   423,   644,   645,   646,   647,   648,   424,
     425,   426,   427,   428,   150,   151,   429,   649,   430,   650,
     431,     0,   432,   433,   434,   651,   435,   652,   653,   436,
     437,   438,   439,   654,   440,   441,   442,   655,   443,   656,
     444,   445,   446,   157,   447,     0,   159,   657,   448,   449,
     161,   658,   450,   659,   451,   162,   660,   163,   452,     0,
     453,   661,   454,   166,   662,   455,   663,   456,   457,   458,
     459,   167,   460,   461,   462,   664,   463,   464,   465,   466,
     467,   468,   665,   168,   169,   666,   469,   470,   471,   667,
     171,   668,   172,   669,     0,   173,   174,   472,   175,   473,
     474,   475,   476,   477,   670,   176,   177,   478,   178,   671,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   183,   184,   185,   672,
     493,   494,   495,   496,   497,   498,   499,   186,   500,   673,
     501,   502,   188,   503,   674,   189,   190,   504,   505,   675,
     676,   506,   677,   678,   679,   507,   508,   680,   681,   191,
     192,   193,   194,   509,   510,   511,   512,     0,   195,   196,
     513,   514,   515,   682,   516,   517,   518,   519,   520,   521,
     198,   522,   523,   683,   524,   525,   526,   527,   528,   529,
     530,   531,   532,   684,   533,   534,   204,   535,   536,   206,
     537,   538,   539,   540,   541,   542,     0,   685,   543,   544,
     545,   686,   546,   210,   547,   548,   212,   549,   213,   687,
     550,   551,   552,   553,   554,   555,   556,   557,   215,   558,
     688,   559,   560,   689,   561,   562,   563,   564,   690,   216,
     217,   691,   692,   566,   218,   567,   219,   693,   568,   569,
     570,   571,   572,   694,   695,   573,   574,   575,   576,   696,
     697,   577,   578,     0,     0,   227,   580,   228,   581,     0,
     698,   699,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,   619,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,   620,   101,
     102,   103,   375,   621,     0,   105,   106,   107,   108,   622,
     623,     0,   110,   111,   112,     0,   113,   624,   625,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,   131,
     398,   399,   400,   133,  1529,   135,  1530,  1211,     0,   401,
     402,     0,   403,   404,     0,     0,   405,  1531,  1532,   407,
       0,   408,   409,   410,   411,     0,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,     0,   419,     0,   420,
     421,   422,   147,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,  1533,  1534,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
    1225,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,     0,   447,     0,     0,     0,   448,   449,
    1535,     0,   450,     0,   451,   162,     0,   163,   452,     0,
     453,     0,   454,     0,     0,   455,     0,   456,   457,   458,
     459,   167,   460,   461,   462,  1941,   463,   464,   465,   466,
     467,   468,     0,   168,  1942,     0,   469,   470,   471,  1231,
    1536,     0,  1537,     0,     0,   173,   174,   472,   175,   473,
     474,   475,   476,   477,     0,     0,   177,   478,   178,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,  1538,   184,  1539,     0,
     493,   494,   495,   496,   497,   498,   499,     0,   500,     0,
     501,   502,   188,   503,     0,     0,  1540,   504,   505,     0,
       0,   506,     0,     0,     0,   507,   508,     0,     0,  1943,
     192,   193,     0,   509,   510,   511,   512,     0,     0,     0,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
    1541,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,   204,   535,   536,     0,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,  1542,   547,   548,   212,   549,  1543,     0,
     550,   551,   552,   553,   554,   555,   556,   557,     0,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,  1544,
    1545,     0,     0,   566,     0,   567,     0,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,     0,  1546,   580,   228,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,   619,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,   620,   101,
     102,   103,   375,   621,     0,   105,   106,   107,   108,   622,
     623,     0,   110,   111,   112,     0,   113,   624,   625,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,   131,
     398,   399,   400,   133,  1529,   135,  1530,  1211,     0,   401,
     402,     0,   403,   404,     0,     0,   405,  1531,  1532,   407,
       0,   408,   409,   410,   411,     0,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,     0,   419,     0,   420,
     421,   422,   147,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,  1533,  1534,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
    1225,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,     0,   447,     0,     0,     0,   448,   449,
    1535,     0,   450,     0,   451,   162,     0,   163,   452,     0,
     453,     0,   454,     0,     0,   455,     0,   456,   457,   458,
     459,   167,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,   168,     0,     0,   469,   470,   471,  1231,
    1536,     0,  1537,     0,     0,   173,   174,   472,   175,   473,
     474,   475,   476,   477,     0,     0,   177,   478,   178,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,  1538,   184,  1539,     0,
     493,   494,   495,   496,   497,   498,   499,     0,   500,     0,
     501,   502,   188,   503,     0,     0,  1540,   504,   505,     0,
       0,   506,     0,     0,     0,   507,   508,     0,     0,     0,
     192,   193,     0,   509,   510,   511,   512,     0,     0,     0,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
    1541,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,   204,   535,   536,     0,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,  1542,   547,   548,   212,   549,  1543,     0,
     550,   551,   552,   553,   554,   555,   556,   557,     0,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,  1544,
    1545,     0,     0,   566,     0,   567,     0,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,     0,  1546,   580,   228,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
    1407,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,     0,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   395,   396,     0,   397,     0,   398,
     399,   400,     0,   134,     0,   136,     0,     0,   401,   402,
       0,   403,   404,     0,     0,   405,   406,   137,   407,     0,
     408,   409,   410,   411,   141,     0,     0,   412,   413,   414,
     415,   416,     0,   417,   418,   144,   419,     0,   420,   421,
     422,     0,   423,     0,     0,     0,     0,     0,   424,   425,
     426,   427,   428,   150,   151,   429,     0,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,   437,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,   157,   447,     0,   159,     0,   448,   449,   161,
       0,   450,     0,   451,     0,     0,     0,   452,     0,  2315,
       0,   454,   166,     0,   455,     0,   456,   457,   458,   459,
       0,   460,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   169,     0,   469,   470,   471,     0,   171,
       0,   172,     0,     0,     0,     0,   472,     0,   473,   474,
     475,   476,   477,     0,   176,     0,   478,     0,     0,   479,
     480,  2316,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   183,     0,   185,   749,   493,
     494,   495,   496,   497,   498,   499,   186,   500,     0,   501,
     502,     0,   503,     0,   189,   190,   504,   505,     0,     0,
     506,   750,     0,     0,   507,   508,     0,     0,   191,     0,
       0,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     514,   515,     0,   516,   517,   518,   519,   520,   521,   198,
     522,   523,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   206,   537,
     538,   539,   540,   541,   542,     0,     0,   543,   544,   545,
       0,   546,   210,   547,   548,     0,   549,   213,     0,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,     0,
     559,   560,  2317,   561,  2318,   563,  2319,     0,   216,   217,
       0,     0,   566,   218,   567,   219,     0,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,   576,     0,     0,
     577,   578,     0,   579,   227,   580,     0,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,     0,     0,   230,   588,    81,    82,    83,   372,    85,
      86,   610,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,   611,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   395,   396,     0,   397,     0,   398,
     399,   400,     0,   134,     0,   136,     0,     0,   401,   402,
       0,   403,   404,     0,     0,   405,   406,   137,   407,     0,
     408,   409,   410,   411,   141,     0,     0,   412,   413,   414,
     415,   416,     0,   417,   418,   144,   419,     0,   420,   421,
     422,     0,   423,     0,     0,     0,     0,     0,   424,   425,
     426,   427,   428,   150,   151,   429,   612,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,   437,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,   157,   447,     0,   159,     0,   448,   449,   161,
       0,   450,     0,   451,     0,     0,     0,   452,     0,   453,
       0,   454,   166,     0,   455,     0,   456,   457,   458,   459,
       0,   460,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   169,     0,   469,   470,   471,     0,   171,
       0,   172,     0,     0,     0,     0,   472,     0,   473,   474,
     475,   476,   477,     0,   176,     0,   478,     0,     0,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   183,     0,   185,     0,   493,
     494,   495,   496,   497,   498,   499,   186,   500,     0,   501,
     502,     0,   503,     0,   189,   190,   504,   505,     0,     0,
     506,     0,     0,     0,   507,   508,     0,     0,   191,     0,
       0,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     514,   515,     0,   516,   517,   518,   519,   520,   521,   198,
     522,   523,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   206,   537,
     538,   539,   540,   541,   542,     0,     0,   543,   544,   545,
       0,   546,   210,   547,   548,     0,   549,   213,     0,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,     0,
     559,   560,     0,   561,   562,   563,   564,     0,   216,   217,
       0,     0,   566,   218,   567,   219,     0,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,   576,     0,     0,
     577,   578,     0,   579,   227,   580,     0,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,     0,     0,   230,   588,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,     0,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   395,   396,     0,   397,     0,   398,
     399,   400,     0,   134,     0,   136,     0,     0,   401,   402,
       0,   403,   404,     0,     0,   405,   406,   137,   407,     0,
     408,   409,   410,   411,   141,     0,     0,   412,   413,   414,
     415,   416,     0,   417,   418,   144,   419,     0,   420,   421,
     422,     0,   423,     0,     0,     0,     0,     0,   424,   425,
     426,   427,   428,   150,   151,   429,   612,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,   437,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,   157,   447,     0,   159,     0,   448,   449,   161,
       0,   450,     0,   451,     0,     0,     0,   452,     0,   453,
       0,   454,   166,     0,   455,     0,   456,   457,   458,   459,
       0,   460,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   169,     0,   469,   470,   471,     0,   171,
       0,   172,     0,     0,     0,     0,   472,     0,   473,   474,
     475,   476,   477,     0,   176,     0,   478,     0,     0,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   183,     0,   185,     0,   493,
     494,   495,   496,   497,   498,   499,   186,   500,     0,   501,
     502,     0,   503,     0,   189,   190,   504,   505,     0,     0,
     506,     0,     0,     0,   507,   508,     0,     0,   191,     0,
       0,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     514,   515,     0,   516,   517,   518,   519,   520,   521,   198,
     522,   523,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   206,   537,
     538,   539,   540,   541,   542,     0,     0,   543,   544,   545,
       0,   546,   210,   547,   548,     0,   549,   213,     0,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,     0,
     559,   560,     0,   561,   562,   563,   564,     0,   216,   217,
       0,     0,   566,   218,   567,   219,     0,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,   576,     0,     0,
     577,   578,     0,   579,   227,   580,     0,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,     0,     0,   230,   588,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,   796,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,     0,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   395,   396,     0,   397,     0,   398,
     399,   400,     0,   134,     0,   136,     0,     0,   401,   402,
       0,   403,   404,     0,     0,   405,   406,   137,   407,     0,
     408,   409,   410,   411,   141,     0,     0,   412,   413,   414,
     415,   416,     0,   417,   418,   144,   419,     0,   420,   421,
     422,     0,   423,     0,     0,     0,     0,     0,   424,   425,
     426,   427,   428,   150,   151,   429,     0,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,   437,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,   157,   447,     0,   159,     0,   448,   449,   161,
       0,   450,     0,   451,     0,     0,     0,   452,     0,   453,
       0,   454,   166,     0,   455,     0,   456,   457,   458,   459,
       0,   460,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   169,     0,   469,   470,   471,     0,   171,
       0,   172,     0,     0,     0,     0,   472,     0,   473,   474,
     475,   476,   477,     0,   176,     0,   478,     0,     0,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   183,     0,   185,     0,   493,
     494,   495,   496,   497,   498,   499,   186,   500,     0,   501,
     502,     0,   503,     0,   189,   190,   504,   505,     0,     0,
     506,     0,     0,     0,   507,   508,     0,     0,   191,     0,
       0,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     797,   515,     0,   516,   517,   518,   519,   520,   521,   198,
     522,   523,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   206,   537,
     538,   539,   540,   541,   542,     0,     0,   543,   544,   545,
       0,   546,   210,   547,   548,     0,   549,   213,     0,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,     0,
     559,   560,     0,   561,   562,   563,   564,     0,   216,   217,
       0,     0,   566,   218,   567,   219,     0,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,   576,     0,     0,
     577,   578,     0,   579,   227,   580,     0,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,     0,     0,   230,   588,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,     0,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   395,   396,     0,   397,     0,   398,
     399,   400,     0,   134,     0,   136,     0,     0,   401,   402,
       0,   403,   404,     0,     0,   405,   406,   137,   407,     0,
     408,   409,   410,   411,   141,     0,     0,   412,   413,   414,
     415,   416,     0,   417,   418,   144,   419,     0,   420,   421,
     422,     0,   423,     0,     0,     0,     0,     0,   424,   425,
     426,   427,   428,   150,   151,   429,     0,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,   437,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,   157,   447,     0,   159,     0,   448,   449,   161,
       0,   450,     0,   451,     0,     0,     0,   452,     0,   453,
       0,   454,   166,     0,   455,     0,   456,   457,   458,   459,
       0,   829,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   169,     0,   469,   470,   471,     0,   171,
       0,   172,     0,     0,     0,     0,   472,     0,   473,   474,
     475,   476,   477,     0,   176,     0,   478,     0,     0,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   183,     0,   185,     0,   493,
     494,   495,   496,   497,   498,   499,   186,   500,     0,   501,
     502,     0,   503,     0,   189,   190,   504,   505,     0,     0,
     506,     0,     0,     0,   507,   508,     0,     0,   191,     0,
       0,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     514,   515,     0,   516,   517,   518,   519,   520,   521,   198,
     522,   523,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   206,   537,
     538,   539,   540,   541,   542,     0,     0,   543,   544,   545,
       0,   546,   210,   547,   548,     0,   549,   213,     0,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,     0,
     559,   560,     0,   561,   562,   563,   564,     0,   216,   217,
       0,     0,   566,   218,   567,   219,     0,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,   576,     0,     0,
     577,   578,     0,   579,   227,   580,     0,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,     0,     0,   230,   588,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,     0,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   395,   396,     0,   397,     0,   398,
     399,   400,     0,   134,     0,   136,     0,     0,   401,   402,
       0,   403,   404,     0,     0,   405,   406,   137,   407,     0,
     408,   409,   410,   411,   141,     0,     0,   412,   413,   414,
     415,   416,     0,   417,   418,   144,   419,     0,   420,   421,
     422,     0,   423,     0,     0,     0,     0,     0,   424,   425,
     426,   427,   428,   150,   151,   429,     0,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,   437,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,   157,   447,     0,   159,     0,   448,   449,   161,
       0,   450,     0,   451,     0,     0,     0,   452,     0,   453,
       0,   454,   166,     0,   455,     0,   456,   457,   458,   459,
       0,   460,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   169,     0,   469,   470,   471,     0,   171,
       0,   172,     0,     0,     0,     0,   472,     0,   473,   474,
     475,   476,   477,     0,   176,     0,   478,     0,     0,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   183,     0,   185,     0,   493,
     494,   495,   496,   497,   498,   499,   186,   500,     0,   501,
     502,     0,   503,     0,   189,   190,   504,   505,     0,     0,
     506,     0,     0,     0,   507,   508,     0,     0,   191,     0,
       0,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     514,   515,     0,   516,   517,   518,   519,   520,   521,   198,
     522,   523,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   206,   537,
     538,   539,   540,   541,   542,     0,     0,   543,   544,   545,
       0,   546,   210,   547,   548,     0,   549,   213,     0,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,     0,
     559,   560,     0,   561,   562,   563,   564,     0,   216,   217,
       0,     0,   871,   218,   567,   219,     0,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,   576,     0,     0,
     577,   578,     0,   579,   227,   580,     0,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,     0,     0,   230,   588,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,     0,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   395,   396,     0,   397,     0,   398,
     399,   400,     0,   134,     0,   136,     0,     0,   401,   402,
       0,   403,   404,     0,     0,   405,   406,   137,   407,     0,
     408,   409,   410,   411,   141,     0,     0,   412,   413,   414,
     415,   416,     0,   417,   418,   144,   419,     0,   420,   421,
     422,     0,   423,     0,     0,     0,     0,     0,   424,   425,
     426,   427,   428,   150,   151,   429,     0,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,   437,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,   157,   447,     0,   159,     0,   448,   449,   161,
       0,   450,     0,   451,     0,     0,     0,   452,     0,   453,
       0,   454,   166,     0,   455,     0,   456,   457,   458,   459,
       0,   460,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   169,     0,   469,   470,   471,     0,   171,
       0,   172,     0,     0,     0,     0,   472,     0,   473,   474,
     475,   476,   477,     0,   176,     0,   478,     0,     0,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   183,     0,   185,     0,   493,
     494,   495,   496,   497,   498,   499,   186,   500,     0,   501,
     502,     0,   503,     0,   189,   190,   504,   505,     0,     0,
     506,     0,     0,     0,   507,   508,     0,     0,   191,     0,
       0,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     514,   515,     0,   516,   517,   518,   519,   520,   521,   198,
     522,   523,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   206,   537,
     538,   539,   540,   541,   542,     0,     0,   543,   544,   545,
       0,   546,   210,   547,   548,     0,   549,   213,     0,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,     0,
     559,   560,     0,   561,   562,   563,   564,     0,   216,   217,
       0,     0,   566,   218,   567,   219,     0,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,   576,     0,     0,
     577,   578,     0,   579,   227,   580,     0,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,     0,     0,   230,   588,   619,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,   620,   101,
     102,   103,   375,   621,     0,   105,   106,   107,   108,   622,
     623,     0,   110,   111,   112,     0,   113,   624,   625,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,     0,
     398,   399,   400,     0,  1529,     0,  1530,  1211,     0,   401,
     402,     0,   403,   404,     0,     0,   405,  1531,  1532,   407,
       0,   408,   409,   410,   411,     0,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,     0,   419,     0,   420,
     421,   422,     0,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,  1533,  1534,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
    1225,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,     0,   447,     0,     0,     0,   448,   449,
    1535,     0,   450,     0,   451,     0,     0,     0,   452,     0,
     453,     0,   454,     0,     0,   455,     0,   456,   457,   458,
     459,     0,   460,   461,   462,  1941,   463,   464,   465,   466,
     467,   468,     0,     0,  1942,     0,   469,   470,   471,  1231,
    1536,     0,  1537,     0,     0,     0,     0,   472,     0,   473,
     474,   475,   476,   477,     0,     0,     0,   478,     0,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,  1538,     0,  1539,     0,
     493,   494,   495,   496,   497,   498,   499,     0,   500,     0,
     501,   502,     0,   503,     0,     0,  1540,   504,   505,     0,
       0,   506,     0,     0,     0,   507,   508,     0,     0,  1943,
       0,     0,     0,   509,   510,   511,   512,     0,     0,     0,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
    1541,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,     0,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,  1542,   547,   548,     0,   549,  1543,     0,
     550,   551,   552,   553,   554,   555,   556,   557,     0,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,  1544,
    1545,     0,     0,   566,     0,   567,     0,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,     0,  1546,   580,     0,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,   619,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,   620,   101,
     102,   103,   375,   621,     0,   105,   106,   107,   108,   622,
     623,     0,   110,   111,   112,     0,   113,   624,   625,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,     0,
     398,   399,   400,     0,  1529,     0,  1530,  1211,     0,   401,
     402,     0,   403,   404,     0,     0,   405,  1531,  1532,   407,
       0,   408,   409,   410,   411,     0,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,     0,   419,     0,   420,
     421,   422,     0,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,  1533,  1534,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
    1225,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,     0,   447,     0,     0,     0,   448,   449,
    1535,     0,   450,     0,   451,     0,     0,     0,   452,     0,
     453,     0,   454,     0,     0,   455,     0,   456,   457,   458,
     459,     0,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,     0,     0,   469,   470,   471,  1231,
    1536,     0,  1537,     0,     0,     0,     0,   472,     0,   473,
     474,   475,   476,   477,     0,     0,     0,   478,     0,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,  1538,     0,  1539,     0,
     493,   494,   495,   496,   497,   498,   499,  1970,   500,     0,
     501,   502,     0,   503,     0,     0,  1540,   504,   505,     0,
       0,   506,     0,     0,     0,   507,   508,     0,     0,     0,
       0,     0,     0,   509,   510,   511,   512,     0,     0,     0,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
    1541,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,     0,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,  1542,   547,   548,     0,   549,  1543,     0,
     550,   551,   552,   553,   554,   555,   556,   557,     0,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,  1544,
    1545,     0,     0,   566,     0,   567,     0,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,     0,  1546,   580,     0,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,   619,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,   620,   101,
     102,   103,   375,   621,     0,   105,   106,   107,   108,   622,
     623,     0,   110,   111,   112,     0,   113,   624,   625,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,     0,
     398,   399,   400,     0,  1529,     0,  1530,  1211,     0,   401,
     402,     0,   403,   404,     0,     0,   405,  1531,  1532,   407,
       0,   408,   409,   410,   411,     0,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,     0,   419,     0,   420,
     421,   422,     0,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,  1533,  1534,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
    1225,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,     0,   447,     0,     0,     0,   448,   449,
    1535,     0,   450,     0,   451,     0,     0,     0,   452,     0,
     453,     0,   454,     0,     0,   455,     0,   456,   457,   458,
     459,     0,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,     0,     0,   469,   470,   471,  1231,
    1536,     0,  1537,     0,     0,     0,     0,   472,     0,   473,
     474,   475,   476,   477,     0,     0,     0,   478,     0,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,  1538,     0,  1539,     0,
     493,   494,   495,   496,   497,   498,   499,  2827,   500,     0,
     501,   502,     0,   503,     0,     0,  1540,   504,   505,     0,
       0,   506,     0,     0,     0,   507,   508,     0,     0,     0,
       0,     0,     0,   509,   510,   511,   512,     0,     0,     0,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
    1541,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,     0,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,  1542,   547,   548,     0,   549,  1543,     0,
     550,   551,   552,   553,   554,   555,   556,   557,     0,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,  1544,
    1545,     0,     0,   566,     0,   567,     0,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,     0,  1546,   580,     0,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,   619,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,   620,   101,
     102,   103,   375,   621,     0,   105,   106,   107,   108,   622,
     623,     0,   110,   111,   112,     0,   113,   624,   625,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,     0,
     398,   399,   400,     0,  1529,     0,  1530,  1211,     0,   401,
     402,     0,   403,   404,     0,     0,   405,  1531,  1532,   407,
       0,   408,   409,   410,   411,     0,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,     0,   419,     0,   420,
     421,   422,     0,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,  1533,  1534,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
    1225,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,     0,   447,     0,     0,     0,   448,   449,
    1535,     0,   450,     0,   451,     0,     0,     0,   452,     0,
     453,     0,   454,     0,     0,   455,     0,   456,   457,   458,
     459,     0,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,     0,     0,   469,   470,   471,  1231,
    1536,     0,  1537,     0,     0,     0,     0,   472,     0,   473,
     474,   475,   476,   477,     0,     0,     0,   478,     0,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,  1538,     0,  1539,     0,
     493,   494,   495,   496,   497,   498,   499,     0,   500,     0,
     501,   502,     0,   503,  1935,     0,  1540,   504,   505,     0,
       0,   506,     0,     0,     0,   507,   508,     0,     0,     0,
       0,     0,     0,   509,   510,   511,   512,     0,     0,     0,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
    1541,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,     0,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,  2956,   547,   548,     0,   549,  1543,     0,
     550,   551,   552,   553,   554,   555,   556,   557,     0,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,  1544,
    1545,     0,     0,   566,     0,   567,     0,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,     0,  1546,   580,     0,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,   619,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,   620,   101,
     102,   103,   375,   621,     0,   105,   106,   107,   108,   622,
     623,     0,   110,   111,   112,     0,   113,   624,   625,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,     0,
     398,   399,   400,     0,  1529,     0,  1530,  1211,     0,   401,
     402,     0,   403,   404,     0,     0,   405,  1531,  1532,   407,
       0,   408,   409,   410,   411,     0,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,     0,   419,     0,   420,
     421,   422,     0,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,  1533,  1534,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
    1225,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,     0,   447,     0,     0,     0,   448,   449,
    1535,     0,   450,     0,   451,     0,     0,     0,   452,     0,
     453,     0,   454,     0,     0,   455,     0,   456,   457,   458,
     459,     0,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,     0,     0,   469,   470,   471,  1231,
    1536,     0,  1537,     0,     0,     0,     0,   472,     0,   473,
     474,   475,   476,   477,     0,     0,     0,   478,     0,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,  1538,     0,  1539,     0,
     493,   494,   495,   496,   497,   498,   499,     0,   500,     0,
     501,   502,     0,   503,     0,     0,  1540,   504,   505,     0,
       0,   506,     0,     0,     0,   507,   508,     0,     0,     0,
       0,     0,     0,   509,   510,   511,   512,     0,     0,     0,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
    1541,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,     0,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,  1542,   547,   548,     0,   549,  1543,     0,
     550,   551,   552,   553,   554,   555,   556,   557,     0,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,  1544,
    1545,     0,     0,   566,     0,   567,     0,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,     0,  1546,   580,     0,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,   619,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,   620,   101,
     102,   103,   375,   621,     0,   105,   106,   107,   108,   622,
     623,     0,   110,   111,   112,     0,   113,   624,   625,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,     0,
     398,   399,   400,     0,  1529,     0,  1530,  1211,     0,   401,
     402,     0,   403,   404,     0,     0,   405,  1531,  1532,   407,
       0,   408,   409,   410,   411,     0,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,     0,   419,     0,   420,
     421,   422,     0,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,  1533,  1534,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
    1225,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,     0,   447,     0,     0,     0,   448,   449,
    1535,     0,   450,     0,   451,     0,     0,     0,   452,     0,
     453,     0,   454,     0,     0,   455,     0,   456,   457,   458,
     459,     0,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,     0,     0,   469,   470,   471,  1231,
    1536,     0,  1537,     0,     0,     0,     0,   472,     0,   473,
     474,   475,   476,   477,     0,     0,     0,   478,     0,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,  1538,     0,  1539,     0,
     493,   494,   495,   496,   497,   498,   499,     0,   500,     0,
     501,   502,     0,   503,     0,     0,  1540,   504,   505,     0,
       0,   506,     0,     0,     0,   507,   508,     0,     0,     0,
       0,     0,     0,   509,   510,   511,   512,     0,     0,     0,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
    1541,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,     0,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,     0,   547,   548,     0,   549,  1543,     0,
     550,   551,   552,   553,   554,   555,   556,   557,     0,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,  1544,
    1545,     0,     0,   566,     0,   567,     0,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,     0,  1546,   580,     0,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   385,   386,   387,   388,
     389,   390,   391,   392,   626,   393,   394,   627,   628,   629,
     630,   631,   632,   633,   395,   396,   634,   397,   131,   398,
     399,   400,   133,   134,   135,   136,     0,   635,   401,   402,
       0,   403,   404,   636,   637,   405,     0,   137,   407,   639,
     408,   409,   410,   411,   141,   640,   641,   412,   413,   414,
     415,   416,   642,   417,   418,   144,   419,   643,   420,   421,
     422,   147,   423,   644,   645,   646,   647,   648,   424,   425,
     426,     0,   428,   150,   151,   429,   649,   430,   650,   431,
       0,   432,   433,   434,   651,   435,   652,   653,   436,   437,
     438,   439,   654,   440,   441,   442,   655,   443,   656,   444,
     445,   446,   157,   447,     0,   159,   657,   448,   449,   161,
     658,   450,   659,   451,   162,   660,   163,   452,     0,   453,
     661,   454,   166,   662,   455,   663,   456,   457,     0,   459,
     167,   460,   461,   462,   664,   463,   464,   465,   466,   467,
     468,   665,   168,   169,     0,   469,   470,   471,     0,   171,
     668,   172,   669,     0,   173,   174,   472,   175,   473,   474,
     475,   476,   477,   670,   176,   177,   478,   178,   671,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,     0,
     488,   489,     0,   491,   492,   183,   184,   185,   672,   493,
     494,   495,   496,   497,   498,   499,   186,   500,   673,   501,
     502,   188,   503,   674,   189,   190,   504,   505,   675,   676,
     506,   677,   678,   679,   507,   508,   680,   681,   191,   192,
     193,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     514,   515,   682,   516,   517,   518,   519,   520,   521,   198,
     522,   523,   683,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   684,   533,   534,   204,   535,   536,   206,   537,
     538,   539,   540,   541,     0,     0,   685,   543,   544,   545,
     686,   546,   210,   547,   548,   212,   549,   213,   687,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,   688,
     559,   560,   689,   561,   562,   563,   564,   690,   216,   217,
       0,   692,   566,   218,   567,   219,   693,   568,   569,   570,
     571,   572,     0,   695,   573,   574,   575,   576,   696,   697,
     577,   578,     0,     0,   227,   580,   228,   581,     0,   698,
     699,   582,   583,   584,   585,     0,   587,     0,     0,     0,
     229,     0,     0,   230,    81,    82,    83,   372,    85,    86,
       0,    87,    88,    89,   373,     0,   374,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     375,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   116,   376,   377,
       0,     0,     0,   378,   379,     0,     0,     0,     0,   380,
       0,     0,     0,     0,     0,     0,     0,     0,   381,     0,
     382,     0,   383,   384,     0,   385,   386,   387,   388,   389,
     390,   391,   392,     0,   393,   394,     0,     0,     0,     0,
       0,     0,     0,   395,   396,     0,   397,   131,   398,   399,
     400,   133,   134,   135,   136,     0,     0,   401,   402,     0,
     403,   404,     0,     0,   405,   406,   137,   407,     0,   408,
     409,   410,   411,   141,     0,     0,   412,   413,   414,   415,
     416,     0,   417,   418,   144,   419,     0,   420,   421,   422,
     147,   423,     0,     0,     0,     0,     0,   424,   425,   426,
     427,   428,   150,   151,   429,     0,   430,     0,   431,     0,
     432,   433,   434,     0,   435,     0,     0,   436,   437,   438,
     439,     0,   440,   441,   442,     0,   443,     0,   444,   445,
     446,   157,   447,     0,   159,     0,   448,   449,   161,     0,
     450,     0,   451,   162,     0,   163,   452,     0,   453,     0,
     454,   166,     0,   455,     0,   456,   457,   458,   459,   167,
     460,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,   168,   169,     0,   469,   470,   471,     0,   171,     0,
     172,     0,     0,   173,   174,   472,   175,   473,   474,   475,
     476,   477,     0,   176,   177,   478,   178,     0,   479,   480,
     481,     0,     0,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   183,   184,   185,   749,   493,   494,
     495,   496,   497,   498,   499,   186,   500,     0,   501,   502,
     188,   503,     0,   189,   190,   504,   505,     0,     0,   506,
     750,     0,     0,   507,   508,     0,     0,   191,   192,   193,
     194,   509,   510,   511,   512,     0,   195,   196,   513,   514,
     515,     0,   516,   517,   518,   519,   520,   521,   198,   522,
     523,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,     0,   533,   534,   204,   535,   536,   206,   537,   538,
     539,   540,   541,   542,     0,     0,   543,   544,   545,     0,
     546,   210,   547,   548,   212,   549,   213,     0,   550,   551,
     552,   553,   554,   555,   556,   557,   215,   558,     0,   559,
     560,     0,   561,   562,   563,   564,     0,   216,   217,     0,
       0,   566,   218,   567,   219,     0,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,   576,     0,     0,   577,
     578,     0,   579,   227,   580,   228,   581,     0,     0,     0,
     582,   583,   584,   585,   586,   587,     0,     0,     0,   229,
       0,     0,   230,    81,    82,    83,   372,    85,    86,     0,
      87,    88,    89,   373,     0,   374,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   375,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   116,   376,   377,     0,
       0,     0,   378,   379,     0,     0,     0,     0,   380,     0,
       0,     0,     0,     0,     0,     0,     0,   381,     0,   382,
       0,   383,   384,     0,   385,   386,   387,   388,   389,   390,
     391,   392,     0,   393,   394,     0,     0,     0,     0,     0,
       0,     0,   395,   396,     0,   397,   131,   398,   399,   400,
     133,   134,   135,   136,     0,     0,   401,   402,     0,   403,
     404,     0,     0,   405,   406,   137,   407,     0,   408,   409,
     410,   411,   141,     0,     0,   412,   413,   414,   415,   416,
       0,   417,   418,   144,   419,     0,   420,   421,   422,   147,
     423,     0,     0,     0,     0,     0,   424,   425,   426,   427,
     428,   150,   151,   429,     0,   430,     0,   431,     0,   432,
     433,   434,     0,   435,     0,     0,   436,   437,   438,   439,
       0,   440,   441,   442,     0,   443,     0,   444,   445,   446,
     157,   447,     0,   159,     0,   448,   449,   161,     0,   450,
       0,   451,   162,     0,   163,   452,     0,   453,     0,   454,
     166,     0,   455,     0,   456,   457,   458,  1134,   167,   460,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
     168,   169,     0,   469,   470,   471,     0,   171,     0,   172,
       0,     0,   173,   174,   472,   175,   473,   474,   475,   476,
     477,     0,   176,   177,   478,   178,     0,   479,   480,   481,
       0,     0,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   183,   184,   185,   749,   493,   494,   495,
     496,   497,   498,   499,   186,   500,     0,   501,   502,   188,
     503,     0,   189,   190,   504,   505,     0,     0,   506,   750,
       0,     0,   507,   508,     0,     0,   191,   192,   193,   194,
     509,   510,   511,   512,     0,   195,   196,   513,   514,   515,
       0,   516,   517,   518,   519,   520,   521,   198,   522,   523,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
       0,   533,   534,   204,   535,   536,   206,   537,   538,   539,
     540,   541,   542,     0,     0,   543,   544,   545,     0,   546,
     210,   547,   548,   212,   549,   213,     0,   550,   551,   552,
     553,   554,   555,   556,   557,   215,   558,     0,   559,   560,
       0,   561,   562,   563,   564,     0,   216,   217,     0,     0,
     566,   218,   567,   219,     0,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,   576,     0,     0,   577,   578,
       0,   579,   227,   580,   228,   581,     0,     0,     0,   582,
     583,   584,   585,   586,   587,     0,     0,     0,   229,     0,
       0,   230,    81,    82,    83,   372,    85,    86,     0,    87,
      88,    89,   373,     0,   374,     0,    93,     0,    95,    96,
      97,    98,    99,   100,     0,   101,   102,   103,   375,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   116,   376,   377,     0,     0,
       0,   378,   379,     0,     0,     0,     0,   380,     0,     0,
       0,     0,     0,     0,     0,     0,   381,     0,   382,     0,
     383,   384,     0,   385,   386,   387,   388,   389,   390,   391,
     392,     0,   393,   394,     0,     0,     0,     0,     0,     0,
       0,   395,   396,     0,   397,   131,   398,   399,   400,   133,
     134,   135,   136,     0,     0,   401,   402,     0,   403,   404,
       0,     0,   405,   406,   137,   407,     0,   408,   409,   410,
     411,   141,     0,     0,   412,   413,   414,   415,   416,     0,
     417,   418,   144,   419,     0,   420,   421,   422,   147,   423,
       0,     0,     0,     0,     0,   424,   425,   426,   427,   428,
     150,   151,   429,     0,   430,     0,   431,     0,   432,   433,
     434,     0,   435,     0,     0,   436,   437,   438,   439,     0,
     440,   441,   442,     0,   443,     0,   444,   445,   446,   157,
     447,     0,   159,     0,   448,   449,   161,     0,   450,     0,
     451,   162,     0,   163,   452,     0,   453,     0,   454,   166,
       0,   455,     0,   456,   457,   458,  1141,   167,   460,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,   168,
     169,     0,   469,   470,   471,     0,   171,     0,   172,     0,
       0,   173,   174,   472,   175,   473,   474,   475,   476,   477,
       0,   176,   177,   478,   178,     0,   479,   480,   481,     0,
       0,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   183,   184,   185,   749,   493,   494,   495,   496,
     497,   498,   499,   186,   500,     0,   501,   502,   188,   503,
       0,   189,   190,   504,   505,     0,     0,   506,   750,     0,
       0,   507,   508,     0,     0,   191,   192,   193,   194,   509,
     510,   511,   512,     0,   195,   196,   513,   514,   515,     0,
     516,   517,   518,   519,   520,   521,   198,   522,   523,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,     0,
     533,   534,   204,   535,   536,   206,   537,   538,   539,   540,
     541,   542,     0,     0,   543,   544,   545,     0,   546,   210,
     547,   548,   212,   549,   213,     0,   550,   551,   552,   553,
     554,   555,   556,   557,   215,   558,     0,   559,   560,     0,
     561,   562,   563,   564,     0,   216,   217,     0,     0,   566,
     218,   567,   219,     0,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,   576,     0,     0,   577,   578,     0,
     579,   227,   580,   228,   581,     0,     0,     0,   582,   583,
     584,   585,   586,   587,     0,     0,     0,   229,     0,     0,
     230,    81,    82,    83,   372,    85,    86,     0,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   406,   137,   407,  1919,   408,   409,   410,   411,
     141,     0,     0,   412,   413,   414,   415,   416,  1920,   417,
     418,   144,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,     0,   448,   449,   161,     0,   450,  1921,   451,
       0,     0,     0,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
     176,     0,   478,  2545,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   183,     0,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,  1922,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   206,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   545,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   216,   217,     0,     0,   566,   218,
     567,   219,     0,   568,   569,   570,   571,   572,     0,  1923,
     573,   574,   575,   576,     0,     0,   577,   578,     0,   579,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,     0,     0,   230,
      81,    82,    83,   372,    85,    86,     0,    87,    88,    89,
     373,     0,   374,     0,    93,     0,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,   375,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   116,   376,   377,     0,     0,     0,   378,
     379,     0,     0,     0,     0,   380,     0,     0,     0,     0,
       0,     0,     0,     0,   381,     0,   382,     0,   383,   384,
       0,   385,   386,   387,   388,   389,   390,   391,   392,   853,
     393,   394,     0,     0,     0,     0,     0,     0,     0,   395,
     396,     0,   397,     0,   398,   399,   400,     0,   134,     0,
     136,     0,     0,   401,   402,     0,   403,   404,     0,     0,
     405,   406,   137,   407,     0,   408,   409,   410,   411,   141,
       0,     0,   412,   413,   414,   415,   416,     0,   417,   418,
     144,   419,   854,   420,   421,   422,     0,   423,     0,     0,
       0,     0,     0,   424,   425,   426,   427,   428,   150,   151,
     429,     0,   430,     0,   431,     0,   432,   433,   434,     0,
     435,     0,     0,   436,   437,   438,   439,     0,   440,   441,
     442,     0,   443,     0,   444,   445,   446,   157,   447,     0,
     159,     0,   448,   449,   161,     0,   450,     0,   451,     0,
       0,     0,   452,     0,   453,   895,   454,   166,     0,   455,
       0,   456,   457,   458,   459,     0,   460,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   169,     0,
     469,   470,   471,     0,   171,     0,   172,     0,     0,     0,
       0,   472,     0,   473,   474,   475,   476,   477,     0,   176,
       0,   478,     0,     0,   479,   480,   481,     0,     0,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     183,     0,   185,     0,   493,   494,   495,   496,   497,   498,
     499,   186,   500,     0,   501,   502,     0,   503,     0,   189,
     190,   504,   505,     0,     0,   506,     0,     0,     0,   507,
     508,     0,     0,   191,     0,     0,   194,   509,   510,   511,
     512,     0,   195,   196,   513,   514,   515,     0,   516,   517,
     518,   519,   520,   521,   198,   522,   523,   855,   524,   525,
     526,   527,   528,   529,   530,   531,   532,     0,   533,   534,
       0,   535,   536,   206,   537,   538,   539,   540,   541,   542,
       0,   856,   543,   544,   545,     0,   546,   210,   547,   548,
       0,   549,   213,     0,   550,   551,   552,   553,   554,   555,
     556,   557,   215,   558,     0,   559,   560,     0,   561,   562,
     563,   564,     0,   216,   217,     0,     0,   566,   218,   567,
     219,     0,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,   576,     0,     0,   577,   578,     0,   579,   227,
     580,     0,   581,     0,     0,     0,   582,   583,   584,   585,
     586,   587,     0,     0,     0,   229,     0,     0,   230,    81,
      82,    83,   372,    85,    86,     0,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,   853,   393,
     394,     0,     0,     0,     0,     0,     0,     0,   395,   396,
       0,   397,     0,   398,   399,   400,     0,   134,     0,   136,
       0,     0,   401,   402,     0,   403,   404,     0,     0,   405,
     406,   137,   407,     0,   408,   409,   410,   411,   141,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,   144,
     419,   854,   420,   421,   422,     0,   423,     0,     0,     0,
       0,     0,   424,   425,   426,   427,   428,   150,   151,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,   159,
       0,   448,   449,   161,     0,   450,     0,   451,     0,     0,
       0,   452,     0,   453,     0,   454,   166,     0,   455,     0,
     456,   457,   458,   459,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,     0,     0,
     472,     0,   473,   474,   475,   476,   477,     0,   176,     0,
     478,     0,     0,   479,   480,   481,     0,     0,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   183,
       0,   185,     0,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,     0,   503,     0,   189,   190,
     504,   505,     0,     0,   506,     0,     0,     0,   507,   508,
       0,     0,   191,     0,     0,   194,   509,   510,   511,   512,
       0,   195,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,   855,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   206,   537,   538,   539,   540,   541,   542,     0,
     856,   543,   544,   545,     0,   546,   210,   547,   548,     0,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,   215,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   216,   217,     0,     0,   566,   218,   567,   219,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,     0,     0,   577,   578,     0,   579,   227,   580,
       0,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,     0,     0,   230,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   375,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
     128,   129,     0,     0,     0,     0,     0,   395,   396,     0,
     397,     0,   398,   399,   400,     0,   134,     0,   136,     0,
       0,   401,   402,     0,   403,   404,     0,     0,   405,   406,
     137,   407,     0,   408,   409,   410,   411,   141,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,   144,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,   150,   151,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,   437,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,   157,   447,     0,   159,     0,
     448,   449,   161,     0,   450,     0,   451,     0,     0,     0,
     452,     0,   453,     0,   454,   166,     0,   455,     0,   456,
     457,   458,   459,     0,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   169,     0,   469,   470,
     471,     0,   171,     0,   172,     0,     0,     0,     0,   472,
       0,   473,   474,   475,   476,   477,     0,   176,     0,   478,
       0,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   183,     0,
     185,   749,   493,   494,   495,   496,   497,   498,   499,   186,
     500,     0,   501,   502,     0,   503,     0,   189,   190,   504,
     505,     0,     0,   506,   750,     0,     0,   507,   508,     0,
       0,   191,     0,     0,   194,   509,   510,   511,   512,     0,
     195,   196,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,   198,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   206,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,   546,   210,   547,   548,     0,   549,
     213,     0,   550,   551,   552,   553,   554,   555,   556,   557,
     215,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,   216,   217,     0,     0,   566,   218,   567,   219,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,   579,   227,   580,     0,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,    81,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,     0,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,     0,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
       0,   398,   399,   400,     0,   134,     0,   136,     0,     0,
     401,   402,     0,   403,   404,     0,     0,   405,   406,   137,
     407,     0,   408,   409,   410,   411,   141,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,   144,   419,     0,
     420,   421,   422,     0,   423,     0,     0,     0,     0,     0,
     424,   425,   426,   427,   428,   150,   151,   429,     0,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,   159,     0,   448,
     449,   161,     0,   450,     0,   451,     0,     0,     0,   452,
       0,   453,     0,   454,   166,     0,   455,     0,   456,   457,
     458,   459,     0,   460,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,     0,     0,   472,     0,
     473,   474,   475,   476,   477,     0,   176,     0,   478,     0,
       0,   479,   480,   481,     0,     0,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,     0,   185,
     749,   493,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,     0,   503,     0,   189,   190,   504,   505,
       0,     0,   506,   750,     0,   927,   507,   508,     0,     0,
     191,     0,     0,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   514,   515,     0,   516,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     206,   537,   538,   539,   540,   541,   542,     0,     0,   543,
     544,   545,     0,   546,   210,   547,   548,     0,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,     0,   559,   560,     0,   561,   562,   563,   564,     0,
     216,   217,     0,     0,   566,   218,   567,   219,     0,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
       0,     0,   577,   578,     0,   579,   227,   580,     0,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,     0,     0,   230,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,   375,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,  1313,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,     0,
     398,   399,   400,     0,   134,     0,   136,     0,     0,   401,
     402,     0,   403,   404,     0,     0,   405,   406,   137,   407,
       0,   408,   409,   410,   411,   141,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,   144,   419,     0,   420,
     421,   422,     0,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,   150,   151,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
     437,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,   157,   447,     0,   159,     0,   448,   449,
     161,     0,   450,     0,   451,     0,     0,     0,   452,     0,
     453,     0,   454,   166,     0,   455,     0,   456,   457,   458,
     459,     0,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   169,     0,   469,   470,   471,     0,
     171,     0,   172,     0,     0,     0,     0,   472,     0,   473,
     474,   475,   476,   477,     0,   176,     0,   478,     0,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   183,     0,   185,   749,
     493,   494,   495,   496,   497,   498,   499,   186,   500,     0,
     501,   502,     0,   503,     0,   189,   190,   504,   505,     0,
       0,   506,   750,     0,     0,   507,   508,     0,     0,   191,
       0,     0,   194,   509,   510,   511,   512,     0,   195,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
     198,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,   206,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,   210,   547,   548,     0,   549,   213,     0,
     550,   551,   552,   553,   554,   555,   556,   557,   215,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,   216,
     217,     0,     0,   566,   218,   567,   219,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,   579,   227,   580,     0,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,     0,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   395,   396,     0,   397,     0,   398,
     399,   400,     0,   134,     0,   136,     0,     0,   401,   402,
       0,   403,   404,     0,     0,   405,   406,   137,   407,     0,
     408,   409,   410,   411,   141,     0,     0,   412,   413,   414,
     415,   416,     0,   417,   418,   144,   419,     0,   420,   421,
     422,     0,   423,     0,     0,     0,     0,     0,   424,   425,
    1656,   427,   428,   150,   151,   429,     0,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,   437,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,   157,   447,     0,   159,     0,   448,   449,   161,
       0,   450,     0,   451,     0,     0,     0,  1657,     0,   453,
       0,   454,   166,     0,   455,     0,   456,   457,   458,   459,
       0,   460,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   169,     0,   469,   470,   471,     0,   171,
       0,   172,     0,     0,     0,     0,   472,     0,   473,   474,
    1658,   476,   477,     0,   176,     0,   478,     0,     0,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   183,     0,   185,   749,   493,
     494,   495,   496,   497,   498,   499,   186,   500,     0,   501,
     502,     0,   503,     0,   189,   190,   504,   505,     0,     0,
     506,   750,     0,     0,   507,   508,     0,     0,   191,     0,
       0,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     514,   515,     0,   516,   517,   518,   519,   520,   521,   198,
     522,   523,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   206,   537,
     538,   539,  1659,   541,   542,     0,     0,  1660,   544,   545,
       0,   546,   210,   547,   548,     0,   549,   213,     0,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,     0,
     559,   560,  1661,  1662,   562,   563,   564,     0,   216,   217,
       0,     0,   566,   218,   567,   219,     0,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,   576,     0,     0,
     577,   578,     0,   579,   227,   580,     0,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,     0,     0,   230,    81,    82,    83,   372,    85,    86,
       0,    87,    88,    89,   373,     0,   374,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     375,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   116,   376,   377,
       0,     0,     0,   378,   379,     0,     0,     0,     0,   380,
       0,     0,     0,     0,     0,     0,     0,     0,   381,     0,
     382,     0,   383,   384,     0,   385,   386,   387,   388,   389,
     390,   391,   392,     0,   393,   394,     0,     0,     0,     0,
       0,     0,     0,   395,   396,     0,   397,     0,   398,   399,
     400,     0,   134,     0,   136,     0,     0,   401,   402,     0,
     403,   404,     0,     0,   405,   406,   137,   407,     0,   408,
     409,   410,   411,   141,     0,     0,   412,   413,   414,   415,
     416,     0,   417,   418,   144,   419,   854,   420,   421,   422,
       0,   423,     0,     0,     0,     0,     0,   424,   425,   426,
     427,   428,   150,   151,   429,     0,   430,     0,   431,     0,
     432,   433,   434,     0,   435,     0,     0,   436,   437,   438,
     439,     0,   440,   441,   442,     0,   443,     0,   444,   445,
     446,   157,   447,     0,   159,     0,   448,   449,   161,     0,
     450,     0,   451,     0,     0,     0,   452,     0,   453,     0,
     454,   166,     0,   455,     0,   456,   457,   458,   459,     0,
     460,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   169,     0,   469,   470,   471,     0,   171,     0,
     172,     0,     0,     0,     0,   472,     0,   473,   474,   475,
     476,   477,     0,   176,     0,   478,     0,     0,   479,   480,
     481,     0,     0,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   183,     0,   185,     0,   493,   494,
     495,   496,   497,   498,   499,   186,   500,     0,   501,   502,
       0,   503,     0,   189,   190,   504,   505,     0,     0,   506,
       0,     0,     0,   507,   508,     0,     0,   191,     0,     0,
     194,   509,   510,   511,   512,     0,   195,   196,   513,   514,
     515,     0,   516,   517,   518,   519,   520,   521,   198,   522,
     523,   855,   524,   525,   526,   527,   528,   529,   530,   531,
     532,     0,   533,   534,     0,   535,   536,   206,   537,   538,
     539,   540,   541,   542,     0,   856,   543,   544,   545,     0,
     546,   210,   547,   548,     0,   549,   213,     0,   550,   551,
     552,   553,   554,   555,   556,   557,   215,   558,     0,   559,
     560,     0,   561,   562,   563,   564,     0,   216,   217,     0,
       0,   566,   218,   567,   219,     0,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,   576,     0,     0,   577,
     578,     0,   579,   227,   580,     0,   581,     0,     0,     0,
     582,   583,   584,   585,   586,   587,     0,     0,     0,   229,
       0,     0,   230,    81,    82,    83,   372,    85,    86,     0,
      87,    88,    89,   373,     0,   374,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   375,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   116,   376,   377,     0,
       0,     0,   378,   379,     0,     0,     0,     0,   380,     0,
       0,     0,     0,     0,     0,     0,     0,   381,     0,   382,
       0,   383,   384,     0,   385,   386,   387,   388,   389,   390,
     391,   392,     0,   393,   394,     0,     0,     0,     0,     0,
       0,     0,   395,   396,     0,   397,     0,   398,   399,   400,
       0,   134,     0,   136,     0,     0,   401,   402,     0,   403,
     404,     0,     0,   405,   406,   137,   407,     0,   408,   409,
     410,   411,   141,     0,     0,   412,   413,   414,   415,   416,
       0,   417,   418,   144,   419,     0,   420,   421,   422,     0,
     423,     0,     0,     0,     0,     0,   424,   425,   426,   427,
     428,   150,   151,   429,     0,   430,     0,   431,     0,   432,
     433,   434,     0,   435,     0,     0,   436,   437,   438,   439,
       0,   440,   441,   442,     0,   443,     0,   444,   445,   446,
     157,   447,     0,   159,     0,   448,   449,   161,     0,   450,
       0,   451,     0,     0,     0,   452,     0,   453,     0,   454,
     166,     0,   455,     0,   456,   457,   458,   459,     0,   460,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   169,     0,   469,   470,   471,     0,   171,     0,   172,
       0,     0,     0,     0,   472,     0,   473,   474,   475,   476,
     477,     0,   176,     0,   478,     0,     0,   479,   480,   481,
       0,     0,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   183,     0,   185,   749,   493,   494,   495,
     496,   497,   498,   499,   186,   500,     0,   501,   502,     0,
     503,     0,   189,   190,   504,   505,     0,     0,   506,   750,
       0,     0,   507,   508,     0,     0,   191,     0,     0,   194,
     509,   510,   511,   512,     0,   195,   196,   513,   514,   515,
       0,   516,   517,   518,   519,   520,   521,   198,   522,   523,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
       0,   533,   534,     0,   535,   536,   206,   537,   538,   539,
     540,   541,   542,     0,     0,   543,   544,   545,     0,   546,
     210,   547,   548,     0,   549,   213,     0,   550,   551,   552,
     553,   554,   555,   556,   557,   215,   558,     0,   559,   560,
       0,   561,   562,   563,   564,     0,   216,   217,     0,     0,
     566,   218,   567,   219,     0,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,   576,     0,     0,   577,   578,
       0,   579,   227,   580,     0,   581,     0,     0,     0,   582,
     583,   584,   585,   586,   587,     0,     0,     0,   229,     0,
       0,   230,    81,    82,    83,   372,    85,    86,     0,    87,
      88,    89,   373,     0,   374,     0,    93,     0,    95,    96,
      97,    98,    99,   100,     0,   101,   102,   103,   375,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   116,   376,   377,     0,     0,
       0,   378,   379,     0,     0,     0,     0,   380,     0,     0,
       0,     0,     0,     0,     0,     0,   381,     0,   382,     0,
     383,   384,     0,   385,   386,   387,   388,   389,   390,   391,
     392,     0,   393,   394,     0,     0,     0,     0,     0,     0,
       0,   395,   396,     0,   397,     0,   398,   399,   400,     0,
     134,     0,   136,     0,     0,   401,   402,     0,   403,   404,
       0,     0,   405,   406,   137,   407,     0,   408,   409,   410,
     411,   141,     0,     0,   412,   413,   414,   415,   416,     0,
     417,   418,   144,   419,     0,   420,   421,   422,     0,   423,
       0,     0,     0,     0,     0,   424,   425,   426,   427,   428,
     150,   151,   429,     0,   430,     0,   431,     0,   432,   433,
     434,     0,   435,     0,     0,   436,   437,   438,   439,     0,
     440,   441,   442,     0,   443,     0,   444,   445,   446,   157,
     447,     0,   159,     0,   448,   449,   161,     0,   450,     0,
     451,     0,   838,     0,   452,     0,   453,     0,   454,   166,
       0,   455,     0,   456,   457,   458,   459,     0,   460,   461,
     462,   839,   463,   464,   465,   466,   467,   468,     0,     0,
     169,     0,   469,   470,   471,     0,   171,     0,   172,     0,
       0,     0,     0,   472,     0,   473,   474,   475,   476,   477,
       0,   176,     0,   478,     0,     0,   479,   480,   481,     0,
       0,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   183,     0,   185,     0,   493,   494,   495,   496,
     497,   498,   499,   186,   500,     0,   501,   502,     0,   503,
       0,   189,   190,   504,   505,     0,     0,   506,     0,     0,
       0,   507,   508,     0,     0,   191,     0,     0,   194,   509,
     510,   511,   512,     0,   195,   196,   513,   514,   515,     0,
     516,   517,   518,   519,   520,   521,   198,   522,   523,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,     0,
     533,   534,     0,   535,   536,   206,   537,   538,   539,   540,
     541,   542,     0,     0,   543,   544,   545,     0,   546,   210,
     547,   548,     0,   549,   213,     0,   550,   551,   552,   553,
     554,   555,   556,   557,   215,   558,     0,   559,   560,     0,
     561,   562,   563,   564,     0,   216,   217,     0,     0,   566,
     218,   567,   219,     0,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,   576,     0,     0,   577,   578,     0,
     579,   227,   580,     0,   581,     0,     0,     0,   582,   583,
     584,   585,   586,   587,     0,     0,     0,   229,     0,     0,
     230,    81,    82,    83,   372,    85,    86,     0,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
    2462,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   406,   137,   407,     0,   408,   409,   410,   411,
     141,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,   144,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,     0,   448,   449,   161,     0,   450,     0,   451,
       0,     0,     0,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
     176,     0,   478,     0,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   183,     0,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   206,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   545,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   216,   217,     0,     0,   566,   218,
     567,   219,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,  2463,     0,   577,   578,     0,   579,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,     0,     0,   230,
      81,    82,    83,   372,    85,    86,     0,    87,    88,    89,
     373,     0,   374,     0,    93,     0,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,   375,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   116,   376,   377,     0,     0,     0,   378,
     379,     0,     0,     0,     0,   380,     0,     0,     0,     0,
       0,     0,     0,     0,   381,     0,   382,     0,   383,   384,
       0,   385,   386,   387,   388,   389,   390,   391,   392,  2467,
     393,   394,     0,     0,     0,     0,     0,     0,     0,   395,
     396,     0,   397,     0,   398,   399,   400,     0,   134,     0,
     136,     0,     0,   401,   402,     0,   403,   404,     0,     0,
     405,   406,   137,   407,     0,   408,   409,   410,   411,   141,
       0,     0,   412,   413,   414,   415,   416,     0,   417,   418,
     144,   419,     0,   420,   421,   422,     0,   423,     0,     0,
       0,     0,     0,   424,   425,   426,   427,   428,   150,   151,
     429,     0,   430,     0,   431,     0,   432,   433,   434,     0,
     435,     0,     0,   436,   437,   438,   439,     0,   440,   441,
     442,     0,   443,     0,   444,   445,   446,   157,   447,     0,
     159,     0,   448,   449,   161,     0,   450,     0,   451,     0,
       0,     0,   452,     0,   453,     0,   454,   166,     0,   455,
       0,   456,   457,   458,   459,     0,   460,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   169,     0,
     469,   470,   471,     0,   171,     0,   172,     0,     0,     0,
       0,   472,     0,   473,   474,   475,   476,   477,     0,   176,
       0,   478,     0,     0,   479,   480,   481,     0,     0,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     183,     0,   185,     0,   493,   494,   495,   496,   497,   498,
     499,   186,   500,     0,   501,   502,     0,   503,     0,   189,
     190,   504,   505,     0,     0,   506,     0,     0,     0,   507,
     508,     0,     0,   191,     0,     0,   194,   509,   510,   511,
     512,     0,   195,   196,   513,   514,   515,     0,   516,   517,
     518,   519,   520,   521,   198,   522,   523,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,     0,   533,   534,
       0,   535,   536,   206,   537,   538,   539,   540,   541,   542,
       0,     0,   543,   544,   545,     0,   546,   210,   547,   548,
       0,   549,   213,     0,   550,   551,   552,   553,   554,   555,
     556,   557,   215,   558,     0,   559,   560,     0,   561,   562,
     563,   564,     0,   216,   217,     0,     0,   566,   218,   567,
     219,     0,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,   576,  2468,     0,   577,   578,     0,   579,   227,
     580,     0,   581,     0,     0,     0,   582,   583,   584,   585,
     586,   587,     0,     0,     0,   229,     0,     0,   230,    81,
      82,    83,   372,    85,    86,     0,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,     0,  2581,     0,   395,   396,
       0,   397,     0,   398,   399,   400,     0,   134,     0,   136,
       0,     0,   401,   402,     0,   403,   404,     0,     0,   405,
     406,   137,   407,     0,   408,   409,   410,   411,   141,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,   144,
     419,     0,   420,   421,   422,     0,   423,     0,     0,     0,
       0,     0,   424,   425,   426,   427,   428,   150,   151,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,   159,
       0,   448,   449,   161,     0,   450,     0,   451,     0,     0,
       0,   452,     0,   453,     0,   454,   166,     0,   455,     0,
     456,   457,   458,   459,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,     0,     0,
     472,     0,   473,   474,   475,   476,   477,     0,   176,     0,
     478,     0,     0,   479,   480,   481,     0,     0,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   183,
       0,   185,     0,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,     0,   503,     0,   189,   190,
     504,   505,     0,     0,   506,     0,     0,     0,   507,   508,
       0,     0,   191,     0,     0,   194,   509,   510,   511,   512,
       0,   195,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   206,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,   545,     0,   546,   210,   547,   548,     0,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,   215,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   216,   217,     0,     0,   566,   218,   567,   219,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,     0,     0,   577,   578,     0,   579,   227,   580,
       0,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,     0,     0,   230,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   375,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,     0,  2594,     0,   395,   396,     0,
     397,     0,   398,   399,   400,     0,   134,     0,   136,     0,
       0,   401,   402,     0,   403,   404,     0,     0,   405,   406,
     137,   407,     0,   408,   409,   410,   411,   141,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,   144,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,   150,   151,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,   437,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,   157,   447,     0,   159,     0,
     448,   449,   161,     0,   450,     0,   451,     0,     0,     0,
     452,     0,   453,     0,   454,   166,     0,   455,     0,   456,
     457,   458,   459,     0,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   169,     0,   469,   470,
     471,     0,   171,     0,   172,     0,     0,     0,     0,   472,
       0,   473,   474,   475,   476,   477,     0,   176,     0,   478,
       0,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   183,     0,
     185,     0,   493,   494,   495,   496,   497,   498,   499,   186,
     500,     0,   501,   502,     0,   503,     0,   189,   190,   504,
     505,     0,     0,   506,     0,     0,     0,   507,   508,     0,
       0,   191,     0,     0,   194,   509,   510,   511,   512,     0,
     195,   196,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,   198,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   206,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,   546,   210,   547,   548,     0,   549,
     213,     0,   550,   551,   552,   553,   554,   555,   556,   557,
     215,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,   216,   217,     0,     0,   566,   218,   567,   219,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,   579,   227,   580,     0,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,    81,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,     0,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,     0,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
       0,   398,   399,   400,     0,   134,     0,   136,     0,     0,
     401,   402,     0,   403,   404,     0,     0,   405,   406,   137,
     407,     0,   408,   409,   410,   411,   141,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,   144,   419,     0,
     420,   421,   422,     0,   423,     0,     0,     0,     0,     0,
     424,   425,   426,   427,   428,   150,   151,   429,     0,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,   159,     0,   448,
     449,   161,     0,   450,     0,   451,     0,     0,     0,   452,
       0,   453,     0,   454,   166,  2623,   455,     0,   456,   457,
     458,   459,     0,   460,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,     0,     0,   472,     0,
     473,   474,   475,   476,   477,     0,   176,     0,   478,     0,
       0,   479,   480,   481,     0,     0,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,     0,   185,
       0,   493,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,     0,   503,     0,   189,   190,   504,   505,
       0,     0,   506,     0,     0,     0,   507,   508,     0,     0,
     191,     0,     0,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   514,   515,     0,   516,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     206,   537,   538,   539,   540,   541,   542,     0,     0,   543,
     544,   545,     0,   546,   210,   547,   548,     0,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,     0,   559,   560,     0,   561,   562,   563,   564,     0,
     216,   217,     0,     0,   566,   218,   567,   219,     0,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
       0,     0,   577,   578,     0,   579,   227,   580,     0,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,     0,     0,   230,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,   375,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,     0,
     398,   399,   400,     0,   134,     0,   136,     0,     0,   401,
     402,     0,   403,   404,     0,     0,   405,   406,   137,   407,
       0,   408,   409,   410,   411,   141,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,   144,   419,     0,   420,
     421,   422,     0,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,   150,   151,   429,  2903,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
     437,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,   157,   447,     0,   159,     0,   448,   449,
     161,     0,   450,     0,   451,     0,     0,     0,   452,     0,
     453,     0,   454,   166,     0,   455,     0,   456,   457,   458,
     459,     0,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   169,     0,   469,   470,   471,     0,
     171,     0,   172,     0,     0,     0,     0,   472,     0,   473,
     474,   475,   476,   477,     0,   176,     0,   478,     0,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   183,     0,   185,     0,
     493,   494,   495,   496,   497,   498,   499,   186,   500,     0,
     501,   502,     0,   503,     0,   189,   190,   504,   505,     0,
       0,   506,     0,     0,     0,   507,   508,     0,     0,   191,
       0,     0,   194,   509,   510,   511,   512,     0,   195,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
     198,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,   206,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,   210,   547,   548,     0,   549,   213,     0,
     550,   551,   552,   553,   554,   555,   556,   557,   215,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,   216,
     217,     0,     0,   566,   218,   567,   219,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,   579,   227,   580,     0,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,     0,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   395,   396,     0,   397,     0,   398,
     399,   400,     0,   134,     0,   136,     0,     0,   401,   402,
       0,   403,   404,     0,     0,   405,   406,   137,   407,     0,
     408,   409,   410,   411,   141,     0,     0,   412,   413,   414,
     415,   416,     0,   417,   418,   144,   419,     0,   420,   421,
     422,     0,   423,     0,     0,     0,     0,     0,   424,   425,
     426,   427,   428,   150,   151,   429,  2905,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,   437,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,   157,   447,     0,   159,     0,   448,   449,   161,
       0,   450,     0,   451,     0,     0,     0,   452,     0,   453,
       0,   454,   166,     0,   455,     0,   456,   457,   458,   459,
       0,   460,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   169,     0,   469,   470,   471,     0,   171,
       0,   172,     0,     0,     0,     0,   472,     0,   473,   474,
     475,   476,   477,     0,   176,     0,   478,     0,     0,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   183,     0,   185,     0,   493,
     494,   495,   496,   497,   498,   499,   186,   500,     0,   501,
     502,     0,   503,     0,   189,   190,   504,   505,     0,     0,
     506,     0,     0,     0,   507,   508,     0,     0,   191,     0,
       0,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     514,   515,     0,   516,   517,   518,   519,   520,   521,   198,
     522,   523,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   206,   537,
     538,   539,   540,   541,   542,     0,     0,   543,   544,   545,
       0,   546,   210,   547,   548,     0,   549,   213,     0,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,     0,
     559,   560,     0,   561,   562,   563,   564,     0,   216,   217,
       0,     0,   566,   218,   567,   219,     0,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,   576,     0,     0,
     577,   578,     0,   579,   227,   580,     0,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,     0,     0,   230,    81,    82,    83,   372,    85,    86,
       0,    87,    88,    89,   373,     0,   374,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     375,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   116,   376,   377,
       0,     0,     0,   378,   379,     0,     0,     0,     0,   380,
       0,     0,     0,     0,     0,     0,     0,     0,   381,     0,
     382,     0,   383,   384,     0,   385,   386,   387,   388,   389,
     390,   391,   392,     0,   393,   394,     0,     0,     0,     0,
       0,     0,     0,   395,   396,     0,   397,     0,   398,   399,
     400,     0,   134,     0,   136,     0,     0,   401,   402,     0,
     403,   404,     0,     0,   405,   406,   137,   407,     0,   408,
     409,   410,   411,   141,     0,     0,   412,   413,   414,   415,
     416,     0,   417,   418,   144,   419,     0,   420,   421,   422,
       0,   423,     0,     0,     0,     0,     0,   424,   425,   426,
     427,   428,   150,   151,   429,  2907,   430,     0,   431,     0,
     432,   433,   434,     0,   435,     0,     0,   436,   437,   438,
     439,     0,   440,   441,   442,     0,   443,     0,   444,   445,
     446,   157,   447,     0,   159,     0,   448,   449,   161,     0,
     450,     0,   451,     0,     0,     0,   452,     0,   453,     0,
     454,   166,     0,   455,     0,   456,   457,   458,   459,     0,
     460,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   169,     0,   469,   470,   471,     0,   171,     0,
     172,     0,     0,     0,     0,   472,     0,   473,   474,   475,
     476,   477,     0,   176,     0,   478,     0,     0,   479,   480,
     481,     0,     0,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   183,     0,   185,     0,   493,   494,
     495,   496,   497,   498,   499,   186,   500,     0,   501,   502,
       0,   503,     0,   189,   190,   504,   505,     0,     0,   506,
       0,     0,     0,   507,   508,     0,     0,   191,     0,     0,
     194,   509,   510,   511,   512,     0,   195,   196,   513,   514,
     515,     0,   516,   517,   518,   519,   520,   521,   198,   522,
     523,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,     0,   533,   534,     0,   535,   536,   206,   537,   538,
     539,   540,   541,   542,     0,     0,   543,   544,   545,     0,
     546,   210,   547,   548,     0,   549,   213,     0,   550,   551,
     552,   553,   554,   555,   556,   557,   215,   558,     0,   559,
     560,     0,   561,   562,   563,   564,     0,   216,   217,     0,
       0,   566,   218,   567,   219,     0,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,   576,     0,     0,   577,
     578,     0,   579,   227,   580,     0,   581,     0,     0,     0,
     582,   583,   584,   585,   586,   587,     0,     0,     0,   229,
       0,     0,   230,    81,    82,    83,   372,    85,    86,     0,
      87,    88,    89,   373,     0,   374,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   375,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   116,   376,   377,     0,
       0,     0,   378,   379,     0,     0,     0,     0,   380,     0,
       0,     0,     0,     0,     0,     0,     0,   381,     0,   382,
       0,   383,   384,     0,   385,   386,   387,   388,   389,   390,
     391,   392,     0,   393,   394,     0,     0,     0,     0,     0,
       0,     0,   395,   396,     0,   397,     0,   398,   399,   400,
       0,   134,     0,   136,     0,     0,   401,   402,     0,   403,
     404,     0,     0,   405,   406,   137,   407,     0,   408,   409,
     410,   411,   141,     0,     0,   412,   413,   414,   415,   416,
       0,   417,   418,   144,   419,     0,   420,   421,   422,     0,
     423,     0,     0,     0,     0,     0,   424,   425,   426,   427,
     428,   150,   151,   429,     0,   430,     0,   431,     0,   432,
     433,   434,     0,   435,     0,     0,   436,   437,   438,   439,
       0,   440,   441,   442,     0,   443,     0,   444,   445,   446,
     157,   447,     0,   159,     0,   448,   449,   161,     0,   450,
       0,   451,     0,     0,     0,   452,     0,   453,     0,   454,
     166,     0,   455,     0,   456,   457,   458,   459,     0,   460,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   169,     0,   469,   470,   471,     0,   171,     0,   172,
       0,     0,     0,     0,   472,     0,   473,   474,   475,   476,
     477,     0,   176,     0,   478,     0,     0,   479,   480,   481,
       0,     0,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   183,     0,   185,     0,   493,   494,   495,
     496,   497,   498,   499,   186,   500,     0,   501,   502,     0,
     503,     0,   189,   190,   504,   505,     0,     0,   506,     0,
       0,     0,   507,   508,     0,     0,   191,     0,     0,   194,
     509,   510,   511,   512,     0,   195,   196,   513,   514,   515,
       0,   516,   517,   518,   519,   520,   521,   198,   522,   523,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
       0,   533,   534,     0,   535,   536,   206,   537,   538,   539,
     540,   541,   542,     0,     0,   543,   544,   545,     0,   546,
     210,   547,   548,     0,   549,   213,     0,   550,   551,   552,
     553,   554,   555,   556,   557,   215,   558,     0,   559,   560,
       0,   561,   562,   563,   564,     0,   216,   217,     0,     0,
     566,   218,   567,   219,     0,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,   576,     0,  3409,   577,   578,
       0,   579,   227,   580,     0,   581,     0,     0,     0,   582,
     583,   584,   585,   586,   587,     0,     0,     0,   229,     0,
       0,   230,    81,    82,    83,   372,    85,    86,     0,    87,
      88,    89,   373,     0,   374,     0,    93,     0,    95,    96,
      97,    98,    99,   100,     0,   101,   102,   103,   375,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   116,   376,   377,     0,     0,
       0,   378,   379,     0,     0,     0,     0,   380,     0,     0,
       0,     0,     0,     0,     0,     0,   381,     0,   382,     0,
     383,   384,     0,   385,   386,   387,   388,   389,   390,   391,
     392,     0,   393,   394,     0,     0,     0,     0,     0,     0,
       0,   395,   396,     0,   397,     0,   398,   399,   400,     0,
     134,     0,   136,     0,     0,   401,   402,     0,   403,   404,
       0,     0,   405,   406,   137,   407,     0,   408,   409,   410,
     411,   141,     0,     0,   412,   413,   414,   415,   416,     0,
     417,   418,   144,   419,     0,   420,   421,   422,     0,   423,
       0,     0,     0,     0,     0,   424,   425,   426,   427,   428,
     150,   151,   429,     0,   430,     0,   431,     0,   432,   433,
     434,     0,   435,     0,     0,   436,   437,   438,   439,     0,
     440,   441,   442,     0,   443,     0,   444,   445,   446,   157,
     447,     0,   159,     0,   448,   449,   161,     0,   450,     0,
     451,     0,     0,     0,   452,     0,   453,     0,   454,   166,
       0,   455,     0,   456,   457,   458,   459,     0,   460,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     169,     0,   469,   470,   471,     0,   171,     0,   172,     0,
       0,     0,     0,   472,     0,   473,   474,   475,   476,   477,
       0,   176,     0,   478,     0,     0,   479,   480,   481,     0,
       0,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   183,     0,   185,     0,   493,   494,   495,   496,
     497,   498,   499,   186,   500,     0,   501,   502,     0,   503,
       0,   189,   190,   504,   505,     0,     0,   506,     0,     0,
       0,   507,   508,     0,     0,   191,     0,     0,   194,   509,
     510,   511,   512,     0,   195,   196,   513,   514,   515,     0,
     516,   517,   518,   519,   520,   521,   198,   522,   523,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,     0,
     533,   534,     0,   535,   536,   206,   537,   538,   539,   540,
     541,   542,     0,     0,   543,   544,   545,     0,   546,   210,
     547,   548,     0,   549,   213,     0,   550,   551,   552,   553,
     554,   555,   556,   557,   215,   558,     0,   559,   560,     0,
     561,   562,   563,   564,     0,   216,   217,     0,     0,   566,
     218,   567,   219,     0,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,   576,     0,     0,   577,   578,     0,
     579,   227,   580,     0,   581,     0,     0,     0,   582,   583,
     584,   585,   586,   587,     0,     0,     0,   229,     0,     0,
     230,    81,    82,    83,   372,    85,    86,     0,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   406,   137,   407,     0,   408,   409,   410,   411,
     141,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,   144,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,     0,   448,   449,   161,     0,   450,     0,   451,
       0,     0,     0,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
     176,     0,   478,     0,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   183,     0,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   206,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   545,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   801,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   216,   217,     0,     0,   566,   218,
     567,   219,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,     0,     0,   577,   578,     0,   579,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,     0,     0,   230,
      81,    82,    83,   372,    85,    86,     0,    87,    88,    89,
     373,     0,   374,     0,    93,     0,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,   375,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   116,   376,   377,     0,     0,     0,   378,
     379,     0,     0,     0,     0,   380,     0,     0,     0,     0,
       0,     0,     0,     0,   381,     0,   382,     0,   383,   384,
       0,   385,   386,   387,   388,   389,   390,   391,   392,     0,
     393,   394,     0,     0,     0,     0,     0,     0,     0,   395,
     396,     0,   397,     0,   398,   399,   400,     0,   134,     0,
     136,     0,     0,   401,   402,     0,   403,   404,     0,     0,
     405,   406,   137,   407,     0,   408,   409,   410,   411,   141,
       0,     0,   412,   413,   414,   415,   416,     0,   417,   418,
     144,   419,     0,   420,   421,   422,     0,   423,     0,     0,
       0,     0,     0,   424,   425,   426,   427,   428,   150,   151,
     429,     0,   430,     0,   431,     0,   432,   433,   434,     0,
     435,     0,     0,   436,   437,   438,   439,     0,   440,   441,
     442,     0,   443,     0,   444,   445,   446,   157,   447,     0,
     159,     0,   448,   449,   161,     0,   450,     0,   451,     0,
       0,     0,   452,     0,   453,     0,   454,   166,     0,   455,
       0,   456,   457,   458,   459,     0,   460,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   169,     0,
     469,   470,   471,     0,   171,     0,   172,     0,     0,     0,
       0,   472,     0,   473,   474,   475,   476,   477,     0,   176,
       0,   478,     0,     0,   479,   480,   481,     0,     0,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     183,     0,   185,     0,   493,   494,   495,   496,   497,   498,
     499,   186,   500,     0,   501,   502,     0,   503,     0,   189,
     190,   504,   505,     0,     0,   506,     0,     0,     0,   507,
     508,     0,     0,   191,     0,     0,   194,   509,   510,   511,
     512,     0,   195,   196,   513,   514,   515,     0,   516,   517,
     518,   519,   520,   521,   198,   522,   523,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,     0,   533,   534,
       0,   535,   536,   206,   537,   538,   879,   540,   541,   542,
       0,     0,   543,   544,   545,     0,   546,   210,   547,   548,
       0,   549,   213,     0,   550,   551,   552,   553,   554,   555,
     556,   557,   215,   558,     0,   559,   560,     0,   561,   562,
     563,   564,     0,   216,   217,     0,     0,   566,   218,   567,
     219,     0,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,   576,     0,     0,   577,   578,     0,   579,   227,
     580,     0,   581,     0,     0,     0,   582,   583,   584,   585,
     586,   587,     0,     0,     0,   229,     0,     0,   230,    81,
      82,    83,   372,    85,    86,     0,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,   881,   393,
     394,     0,     0,     0,     0,     0,     0,     0,   395,   396,
       0,   397,     0,   398,   399,   400,     0,   134,     0,   136,
       0,     0,   401,   402,     0,   403,   404,     0,     0,   405,
     882,   137,   407,     0,   408,   409,   410,   411,   141,     0,
       0,   412,   413,   414,   415,     0,     0,   417,   418,   144,
     419,     0,   420,   421,   422,     0,   423,     0,     0,     0,
       0,     0,   424,   425,   426,   427,   428,   150,   151,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,   159,
       0,   448,   449,   161,     0,   450,     0,   451,     0,     0,
       0,   452,     0,   453,     0,   454,   166,     0,   455,     0,
     456,   457,   458,   459,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,     0,     0,
     472,     0,   473,   474,   475,   476,   477,     0,   176,     0,
     478,     0,     0,   479,   480,   481,     0,     0,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   183,
       0,   185,     0,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,     0,   503,     0,   189,   190,
     504,   505,     0,     0,   506,     0,     0,     0,   507,   508,
       0,     0,   191,     0,     0,   194,   509,   510,   511,   512,
       0,   195,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   206,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,   883,     0,   546,   210,   547,   548,     0,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,   215,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   884,   217,     0,     0,   885,   218,   567,   219,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,     0,     0,   577,   578,     0,   886,   227,   580,
       0,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,     0,     0,   230,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   375,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,   916,   393,   394,
       0,     0,     0,     0,     0,     0,     0,   395,   396,     0,
     397,     0,   398,   399,   400,     0,   134,     0,   136,     0,
       0,   401,   402,     0,   403,   404,     0,     0,   405,   882,
     137,   407,     0,   408,   409,   410,   411,   141,     0,     0,
     412,   413,   414,   415,     0,     0,   417,   418,   144,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,   150,   151,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,   437,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,   157,   447,     0,   159,     0,
     448,   449,   161,     0,   450,     0,   451,     0,     0,     0,
     452,     0,   453,     0,   454,   166,     0,   455,     0,   456,
     457,   458,   459,     0,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   169,     0,   469,   470,
     471,     0,   171,     0,   172,     0,     0,     0,     0,   472,
       0,   473,   474,   475,   476,   477,     0,   176,     0,   478,
       0,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   183,     0,
     185,     0,   493,   494,   495,   496,   497,   498,   499,   186,
     500,     0,   501,   502,     0,   503,     0,   189,   190,   504,
     505,     0,     0,   506,     0,     0,     0,   507,   508,     0,
       0,   191,     0,     0,   194,   509,   510,   511,   512,     0,
     195,   196,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,   198,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   206,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   917,     0,   546,   210,   547,   548,     0,   549,
     213,     0,   550,   551,   552,   553,   554,   555,   556,   557,
     215,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,   918,   217,     0,     0,   919,   218,   567,   219,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,   886,   227,   580,     0,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,    81,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,     0,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,     0,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
       0,   398,   399,   400,     0,   134,     0,   136,     0,     0,
     401,   402,     0,   403,   404,     0,     0,   405,   406,   137,
     407,     0,   408,   409,   410,   411,   141,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,   144,   419,     0,
     420,   421,   422,     0,   423,     0,     0,     0,     0,     0,
     424,   425,   426,   427,   428,   150,   151,   429,     0,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,   159,     0,   448,
     449,   161,     0,   450,     0,   451,     0,     0,     0,   452,
       0,   453,     0,   454,   166,     0,   455,     0,   456,   457,
     458,  1139,     0,   460,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,     0,     0,   472,     0,
     473,   474,   475,   476,   477,     0,   176,     0,   478,     0,
       0,   479,   480,   481,     0,     0,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,     0,   185,
       0,   493,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,     0,   503,     0,   189,   190,   504,   505,
       0,     0,   506,     0,     0,     0,   507,   508,     0,     0,
     191,     0,     0,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   514,   515,     0,   516,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     206,   537,   538,   539,   540,   541,   542,     0,     0,   543,
     544,   545,     0,   546,   210,   547,   548,     0,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,     0,   559,   560,     0,   561,   562,   563,   564,     0,
     216,   217,     0,     0,   566,   218,   567,   219,     0,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
       0,     0,   577,   578,     0,   579,   227,   580,     0,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,     0,     0,   230,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,   375,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,     0,
     398,   399,   400,     0,   134,     0,   136,     0,     0,   401,
     402,     0,   403,   404,     0,     0,   405,   406,   137,   407,
       0,   408,   409,   410,   411,   141,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,   144,   419,     0,   420,
     421,   422,     0,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,   150,   151,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
     437,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,   157,   447,     0,   159,     0,   448,   449,
     161,     0,   450,     0,   451,     0,     0,     0,   452,     0,
     453,     0,   454,   166,     0,   455,     0,   456,   457,   458,
    1143,     0,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   169,     0,   469,   470,   471,     0,
     171,     0,   172,     0,     0,     0,     0,   472,     0,   473,
     474,   475,   476,   477,     0,   176,     0,   478,     0,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   183,     0,   185,     0,
     493,   494,   495,   496,   497,   498,   499,   186,   500,     0,
     501,   502,     0,   503,     0,   189,   190,   504,   505,     0,
       0,   506,     0,     0,     0,   507,   508,     0,     0,   191,
       0,     0,   194,   509,   510,   511,   512,     0,   195,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
     198,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,   206,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,   210,   547,   548,     0,   549,   213,     0,
     550,   551,   552,   553,   554,   555,   556,   557,   215,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,   216,
     217,     0,     0,   566,   218,   567,   219,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,   579,   227,   580,     0,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,     0,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   395,   396,     0,   397,     0,   398,
     399,   400,     0,   134,     0,   136,     0,     0,   401,   402,
       0,   403,   404,     0,     0,   405,   406,   137,   407,     0,
     408,   409,   410,   411,   141,     0,     0,   412,   413,   414,
     415,   416,     0,   417,   418,   144,   419,     0,   420,   421,
     422,     0,   423,     0,     0,     0,     0,     0,   424,   425,
     426,   427,   428,   150,   151,   429,     0,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,   437,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,   157,   447,     0,   159,     0,   448,   449,   161,
       0,   450,     0,   451,     0,     0,     0,   452,     0,   453,
       0,   454,   166,     0,   455,     0,   456,   457,   458,  1150,
       0,   460,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   169,     0,   469,   470,   471,     0,   171,
       0,   172,     0,     0,     0,     0,   472,     0,   473,   474,
     475,   476,   477,     0,   176,     0,   478,     0,     0,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   183,     0,   185,     0,   493,
     494,   495,   496,   497,   498,   499,   186,   500,     0,   501,
     502,     0,   503,     0,   189,   190,   504,   505,     0,     0,
     506,     0,     0,     0,   507,   508,     0,     0,   191,     0,
       0,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     514,   515,     0,   516,   517,   518,   519,   520,   521,   198,
     522,   523,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   206,   537,
     538,   539,   540,   541,   542,     0,     0,   543,   544,   545,
       0,   546,   210,   547,   548,     0,   549,   213,     0,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,     0,
     559,   560,     0,   561,   562,   563,   564,     0,   216,   217,
       0,     0,   566,   218,   567,   219,     0,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,   576,     0,     0,
     577,   578,     0,   579,   227,   580,     0,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,     0,     0,   230,    81,    82,    83,   372,    85,    86,
       0,    87,    88,    89,   373,     0,   374,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     375,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   116,   376,   377,
       0,     0,     0,   378,   379,     0,     0,     0,     0,   380,
       0,     0,     0,     0,     0,     0,     0,     0,   381,     0,
     382,     0,   383,   384,     0,   385,   386,   387,   388,   389,
     390,   391,   392,     0,   393,   394,     0,     0,     0,     0,
       0,     0,     0,   395,   396,     0,   397,     0,   398,   399,
     400,     0,   134,     0,   136,     0,     0,   401,   402,     0,
     403,   404,     0,     0,   405,   406,   137,   407,     0,   408,
     409,   410,   411,   141,     0,     0,   412,   413,   414,   415,
     416,     0,   417,   418,   144,   419,     0,   420,   421,   422,
       0,   423,     0,     0,     0,     0,     0,   424,   425,   426,
     427,   428,   150,   151,   429,     0,   430,     0,   431,     0,
     432,   433,   434,     0,   435,     0,     0,   436,   437,   438,
     439,     0,   440,   441,   442,     0,   443,     0,   444,   445,
     446,   157,   447,     0,   159,     0,   448,   449,   161,     0,
     450,     0,   451,     0,     0,     0,   452,     0,   453,     0,
     454,   166,     0,   455,     0,   456,   457,   458,  1152,     0,
     460,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   169,     0,   469,   470,   471,     0,   171,     0,
     172,     0,     0,     0,     0,   472,     0,   473,   474,   475,
     476,   477,     0,   176,     0,   478,     0,     0,   479,   480,
     481,     0,     0,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   183,     0,   185,     0,   493,   494,
     495,   496,   497,   498,   499,   186,   500,     0,   501,   502,
       0,   503,     0,   189,   190,   504,   505,     0,     0,   506,
       0,     0,     0,   507,   508,     0,     0,   191,     0,     0,
     194,   509,   510,   511,   512,     0,   195,   196,   513,   514,
     515,     0,   516,   517,   518,   519,   520,   521,   198,   522,
     523,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,     0,   533,   534,     0,   535,   536,   206,   537,   538,
     539,   540,   541,   542,     0,     0,   543,   544,   545,     0,
     546,   210,   547,   548,     0,   549,   213,     0,   550,   551,
     552,   553,   554,   555,   556,   557,   215,   558,     0,   559,
     560,     0,   561,   562,   563,   564,     0,   216,   217,     0,
       0,   566,   218,   567,   219,     0,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,   576,     0,     0,   577,
     578,     0,   579,   227,   580,     0,   581,     0,     0,     0,
     582,   583,   584,   585,   586,   587,     0,     0,     0,   229,
       0,     0,   230,    81,    82,    83,   372,    85,    86,     0,
      87,    88,    89,   373,     0,   374,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   375,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   116,   376,   377,     0,
       0,     0,   378,   379,     0,     0,     0,     0,   380,     0,
       0,     0,     0,     0,     0,     0,     0,   381,     0,   382,
       0,   383,   384,     0,   385,   386,   387,   388,   389,   390,
     391,   392,     0,   393,   394,     0,     0,     0,     0,     0,
       0,     0,   395,   396,     0,   397,     0,   398,   399,   400,
       0,   134,     0,   136,     0,     0,   401,   402,     0,   403,
     404,     0,     0,   405,   406,   137,   407,     0,   408,   409,
     410,   411,   141,     0,     0,   412,   413,   414,   415,   416,
       0,   417,   418,   144,   419,     0,   420,   421,   422,     0,
     423,     0,     0,     0,     0,     0,   424,   425,   426,   427,
     428,   150,   151,   429,     0,   430,     0,   431,     0,   432,
     433,   434,     0,   435,     0,     0,   436,   437,   438,   439,
       0,   440,   441,   442,     0,   443,     0,   444,   445,   446,
     157,   447,     0,   159,     0,   448,   449,   161,     0,   450,
       0,   451,     0,     0,     0,   452,     0,   453,     0,   454,
     166,     0,   455,     0,   456,   457,   458,  1154,     0,   460,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   169,     0,   469,   470,   471,     0,   171,     0,   172,
       0,     0,     0,     0,   472,     0,   473,   474,   475,   476,
     477,     0,   176,     0,   478,     0,     0,   479,   480,   481,
       0,     0,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   183,     0,   185,     0,   493,   494,   495,
     496,   497,   498,   499,   186,   500,     0,   501,   502,     0,
     503,     0,   189,   190,   504,   505,     0,     0,   506,     0,
       0,     0,   507,   508,     0,     0,   191,     0,     0,   194,
     509,   510,   511,   512,     0,   195,   196,   513,   514,   515,
       0,   516,   517,   518,   519,   520,   521,   198,   522,   523,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
       0,   533,   534,     0,   535,   536,   206,   537,   538,   539,
     540,   541,   542,     0,     0,   543,   544,   545,     0,   546,
     210,   547,   548,     0,   549,   213,     0,   550,   551,   552,
     553,   554,   555,   556,   557,   215,   558,     0,   559,   560,
       0,   561,   562,   563,   564,     0,   216,   217,     0,     0,
     566,   218,   567,   219,     0,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,   576,     0,     0,   577,   578,
       0,   579,   227,   580,     0,   581,     0,     0,     0,   582,
     583,   584,   585,   586,   587,     0,     0,     0,   229,     0,
       0,   230,    81,    82,    83,   372,    85,    86,     0,    87,
      88,    89,   373,     0,   374,     0,    93,     0,    95,    96,
      97,    98,    99,   100,     0,   101,   102,   103,   375,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   116,   376,   377,     0,     0,
       0,   378,   379,     0,     0,     0,     0,   380,     0,     0,
       0,     0,     0,     0,     0,     0,   381,     0,   382,     0,
     383,   384,     0,   385,   386,   387,   388,   389,   390,   391,
     392,     0,   393,   394,     0,     0,     0,     0,     0,     0,
       0,   395,   396,     0,   397,     0,   398,   399,   400,     0,
     134,     0,   136,     0,     0,   401,   402,     0,   403,   404,
       0,     0,   405,   406,   137,   407,     0,   408,   409,   410,
     411,   141,     0,     0,   412,   413,   414,   415,   416,     0,
     417,   418,   144,   419,     0,   420,   421,   422,     0,   423,
       0,     0,     0,     0,     0,   424,   425,   426,   427,   428,
     150,   151,   429,     0,   430,     0,   431,     0,   432,   433,
     434,     0,   435,     0,     0,   436,   437,   438,   439,     0,
     440,   441,   442,     0,   443,     0,   444,   445,   446,   157,
     447,     0,   159,     0,   448,   449,   161,     0,   450,     0,
     451,     0,     0,     0,   452,     0,   453,     0,   454,   166,
       0,   455,     0,   456,   457,   458,  1156,     0,   460,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     169,     0,   469,   470,   471,     0,   171,     0,   172,     0,
       0,     0,     0,   472,     0,   473,   474,   475,   476,   477,
       0,   176,     0,   478,     0,     0,   479,   480,   481,     0,
       0,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   183,     0,   185,     0,   493,   494,   495,   496,
     497,   498,   499,   186,   500,     0,   501,   502,     0,   503,
       0,   189,   190,   504,   505,     0,     0,   506,     0,     0,
       0,   507,   508,     0,     0,   191,     0,     0,   194,   509,
     510,   511,   512,     0,   195,   196,   513,   514,   515,     0,
     516,   517,   518,   519,   520,   521,   198,   522,   523,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,     0,
     533,   534,     0,   535,   536,   206,   537,   538,   539,   540,
     541,   542,     0,     0,   543,   544,   545,     0,   546,   210,
     547,   548,     0,   549,   213,     0,   550,   551,   552,   553,
     554,   555,   556,   557,   215,   558,     0,   559,   560,     0,
     561,   562,   563,   564,     0,   216,   217,     0,     0,   566,
     218,   567,   219,     0,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,   576,     0,     0,   577,   578,     0,
     579,   227,   580,     0,   581,     0,     0,     0,   582,   583,
     584,   585,   586,   587,     0,     0,     0,   229,     0,     0,
     230,    81,    82,    83,   372,    85,    86,     0,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   406,   137,   407,     0,   408,   409,   410,   411,
     141,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,   144,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,     0,   448,   449,   161,     0,   450,     0,   451,
       0,     0,     0,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,  1158,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
     176,     0,   478,     0,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   183,     0,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   206,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   545,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   216,   217,     0,     0,   566,   218,
     567,   219,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,     0,     0,   577,   578,     0,   579,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,     0,     0,   230,
      81,    82,    83,   372,    85,    86,     0,    87,    88,    89,
     373,     0,   374,     0,    93,     0,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,   375,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   116,   376,   377,     0,     0,     0,   378,
     379,     0,     0,     0,     0,   380,     0,     0,     0,     0,
       0,     0,     0,     0,   381,     0,   382,     0,   383,   384,
       0,   385,   386,   387,   388,   389,   390,   391,   392,     0,
     393,   394,     0,     0,     0,     0,     0,     0,     0,   395,
     396,     0,   397,     0,   398,   399,   400,     0,   134,     0,
     136,     0,     0,   401,   402,     0,   403,   404,     0,     0,
     405,   406,   137,   407,     0,   408,   409,   410,   411,   141,
       0,     0,   412,   413,   414,   415,   416,     0,   417,   418,
     144,   419,     0,   420,   421,   422,     0,   423,     0,     0,
       0,     0,     0,   424,   425,   426,   427,   428,   150,   151,
     429,     0,   430,     0,   431,     0,   432,   433,   434,     0,
     435,     0,     0,   436,   437,   438,   439,     0,   440,   441,
     442,     0,   443,     0,   444,   445,   446,   157,   447,     0,
     159,     0,   448,   449,   161,     0,   450,     0,   451,     0,
       0,     0,   452,     0,   453,     0,   454,   166,     0,   455,
       0,   456,   457,   458,  1161,     0,   460,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   169,     0,
     469,   470,   471,     0,   171,     0,   172,     0,     0,     0,
       0,   472,     0,   473,   474,   475,   476,   477,     0,   176,
       0,   478,     0,     0,   479,   480,   481,     0,     0,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     183,     0,   185,     0,   493,   494,   495,   496,   497,   498,
     499,   186,   500,     0,   501,   502,     0,   503,     0,   189,
     190,   504,   505,     0,     0,   506,     0,     0,     0,   507,
     508,     0,     0,   191,     0,     0,   194,   509,   510,   511,
     512,     0,   195,   196,   513,   514,   515,     0,   516,   517,
     518,   519,   520,   521,   198,   522,   523,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,     0,   533,   534,
       0,   535,   536,   206,   537,   538,   539,   540,   541,   542,
       0,     0,   543,   544,   545,     0,   546,   210,   547,   548,
       0,   549,   213,     0,   550,   551,   552,   553,   554,   555,
     556,   557,   215,   558,     0,   559,   560,     0,   561,   562,
     563,   564,     0,   216,   217,     0,     0,   566,   218,   567,
     219,     0,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,   576,     0,     0,   577,   578,     0,   579,   227,
     580,     0,   581,     0,     0,     0,   582,   583,   584,   585,
     586,   587,     0,     0,     0,   229,     0,     0,   230,    81,
      82,    83,   372,    85,    86,     0,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,     0,     0,     0,   395,   396,
       0,   397,  1324,   398,   399,   400,     0,   134,     0,   136,
       0,     0,   401,   402,     0,   403,   404,     0,     0,   405,
     882,   137,  1325,     0,   408,   409,   410,   411,   141,     0,
       0,   412,   413,   414,   415,     0,     0,   417,   418,   144,
     419,     0,   420,   421,   422,     0,   423,     0,     0,     0,
       0,     0,   424,   425,   426,   427,   428,   150,   151,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,   159,
       0,   448,   449,   161,     0,   450,     0,   451,     0,     0,
       0,   452,     0,   453,     0,   454,   166,     0,   455,     0,
     456,   457,   458,   459,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,     0,     0,
     472,     0,   473,   474,   475,   476,   477,     0,   176,     0,
     478,     0,     0,   479,   480,   481,     0,     0,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   909,   183,
       0,   185,     0,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,     0,   503,     0,   189,   190,
     504,   505,     0,     0,   506,     0,     0,     0,   507,   508,
       0,     0,   191,     0,     0,   194,   509,   510,   511,   512,
       0,   195,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     910,   536,   206,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,  1316,     0,   546,   210,   547,   548,     0,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,   215,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   912,   217,     0,     0,   913,   218,   567,   219,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,     0,     0,   577,   578,     0,   886,   227,   580,
       0,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,     0,     0,   230,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   375,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,     0,  1340,     0,   395,   396,     0,
     397,     0,   398,   399,   400,     0,   134,     0,   136,     0,
       0,   401,   402,     0,   403,   404,     0,     0,   405,   406,
     137,   407,     0,   408,   409,   410,   411,   141,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,   144,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,   150,   151,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,   437,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,   157,   447,     0,   159,     0,
     448,   449,   161,     0,   450,     0,   451,     0,     0,     0,
     452,     0,   453,     0,   454,   166,     0,   455,     0,   456,
     457,   458,   459,     0,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   169,     0,   469,   470,
     471,     0,   171,     0,   172,     0,     0,     0,     0,   472,
       0,   473,   474,   475,   476,   477,     0,   176,     0,   478,
       0,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   183,     0,
     185,     0,   493,   494,   495,   496,   497,   498,   499,   186,
     500,     0,   501,   502,     0,   503,     0,   189,   190,   504,
     505,     0,     0,   506,     0,     0,     0,   507,   508,     0,
       0,   191,     0,     0,   194,   509,   510,   511,   512,     0,
     195,   196,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,   198,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   206,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,     0,   210,   547,   548,     0,   549,
     213,     0,   550,   551,   552,   553,   554,   555,   556,   557,
     215,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,   216,   217,     0,     0,   566,   218,   567,   219,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,   579,   227,   580,     0,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,  1420,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,     0,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,     0,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
       0,   398,   399,   400,     0,   134,     0,   136,     0,     0,
     401,   402,     0,   403,   404,     0,     0,   405,   406,   137,
     407,     0,   408,   409,   410,   411,   141,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,   144,   419,     0,
     420,   421,   422,     0,   423,     0,     0,     0,     0,     0,
     424,   425,   426,   427,   428,   150,   151,   429,     0,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,   159,     0,   448,
     449,   161,     0,   450,     0,   451,     0,     0,     0,   452,
       0,   453,     0,   454,   166,     0,   455,     0,   456,   457,
     458,   459,     0,   460,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,     0,     0,   472,     0,
     473,   474,   475,   476,   477,     0,   176,     0,   478,     0,
       0,   479,   480,   481,     0,     0,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,     0,   185,
       0,   493,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,     0,   503,     0,   189,   190,   504,   505,
       0,     0,   506,     0,     0,     0,   507,   508,     0,     0,
     191,     0,     0,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   514,   515,     0,   516,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     206,   537,   538,   539,   540,   541,   542,     0,     0,   543,
     544,   545,     0,   546,   210,   547,   548,     0,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,     0,   559,   560,     0,   561,   562,   563,   564,     0,
     216,   217,     0,     0,   566,   218,   567,   219,     0,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
       0,     0,   577,   578,     0,   579,   227,   580,     0,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,     0,     0,   230,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,   375,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,     0,
     398,   399,   400,     0,   134,     0,   136,     0,     0,   401,
     402,     0,   403,   404,     0,     0,   405,   406,   137,   407,
       0,   408,   409,   410,   411,   141,     0,     0,   412,   413,
     414,  1589,   416,     0,   417,   418,   144,   419,     0,   420,
     421,   422,     0,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,   150,   151,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
     437,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,   157,   447,     0,   159,     0,   448,   449,
     161,     0,   450,     0,   451,     0,     0,     0,   452,     0,
     453,     0,   454,   166,     0,   455,     0,   456,   457,   458,
     459,     0,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   169,     0,   469,   470,   471,     0,
     171,     0,   172,     0,     0,     0,     0,   472,     0,   473,
     474,   475,   476,   477,     0,   176,     0,   478,     0,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   183,     0,   185,     0,
     493,   494,   495,   496,   497,   498,   499,   186,   500,     0,
     501,   502,     0,   503,     0,   189,   190,   504,   505,     0,
       0,   506,     0,     0,     0,   507,   508,     0,     0,   191,
       0,     0,   194,   509,   510,   511,   512,     0,   195,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
     198,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,   206,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,   210,   547,   548,     0,   549,   213,     0,
     550,   551,   552,   553,   554,   555,   556,   557,   215,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,   216,
     217,     0,     0,   566,   218,   567,   219,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,   579,   227,   580,     0,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,     0,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   395,   396,     0,   397,     0,   398,
     399,   400,     0,   134,     0,   136,     0,     0,   401,   402,
       0,   403,   404,     0,     0,   405,   406,   137,   407,     0,
     408,   409,   410,   411,   141,     0,     0,   412,   413,   414,
     415,   416,     0,   417,   418,   144,   419,     0,   420,   421,
     422,     0,   423,     0,     0,     0,     0,     0,   424,   425,
     426,   427,   428,   150,   151,   429,     0,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,   437,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,   157,   447,     0,   159,     0,   448,   449,   161,
       0,   450,     0,   451,     0,     0,     0,   452,     0,   453,
       0,   454,   166,     0,   455,     0,   456,   457,   458,  1616,
       0,   460,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   169,     0,   469,   470,   471,     0,   171,
       0,   172,     0,     0,     0,     0,   472,     0,   473,   474,
     475,   476,   477,     0,   176,     0,   478,     0,     0,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   183,     0,   185,     0,   493,
     494,   495,   496,   497,   498,   499,   186,   500,     0,   501,
     502,     0,   503,     0,   189,   190,   504,   505,     0,     0,
     506,     0,     0,     0,   507,   508,     0,     0,   191,     0,
       0,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     514,   515,     0,   516,   517,   518,   519,   520,   521,   198,
     522,   523,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   206,   537,
     538,   539,   540,   541,   542,     0,     0,   543,   544,   545,
       0,   546,   210,   547,   548,     0,   549,   213,     0,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,     0,
     559,   560,     0,   561,   562,   563,   564,     0,   216,   217,
       0,     0,   566,   218,   567,   219,     0,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,   576,     0,     0,
     577,   578,     0,   579,   227,   580,     0,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,     0,     0,   230,    81,    82,    83,   372,    85,    86,
       0,    87,    88,    89,   373,     0,   374,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     375,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   116,   376,   377,
       0,     0,     0,   378,   379,     0,     0,     0,     0,   380,
       0,     0,     0,     0,     0,     0,     0,     0,   381,     0,
     382,     0,   383,   384,     0,   385,   386,   387,   388,   389,
     390,   391,   392,     0,   393,   394,     0,     0,     0,     0,
       0,     0,     0,   395,   396,     0,   397,     0,   398,   399,
     400,     0,   134,     0,   136,     0,     0,   401,   402,     0,
     403,   404,     0,     0,   405,   406,   137,   407,     0,   408,
     409,   410,   411,   141,     0,     0,   412,   413,   414,   415,
     416,     0,   417,   418,   144,   419,     0,   420,   421,   422,
       0,   423,     0,     0,     0,     0,     0,   424,   425,   426,
     427,   428,   150,   151,   429,     0,   430,     0,   431,     0,
     432,   433,   434,     0,   435,     0,     0,   436,   437,   438,
     439,     0,   440,   441,   442,     0,   443,     0,   444,   445,
     446,   157,   447,     0,   159,     0,   448,   449,   161,     0,
     450,     0,   451,     0,     0,     0,   452,     0,   453,     0,
     454,   166,     0,   455,     0,   456,   457,   458,   459,     0,
     460,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   169,     0,   469,   470,   471,     0,   171,     0,
     172,     0,     0,     0,     0,   472,     0,   473,   474,   475,
     476,   477,     0,   176,     0,   478,     0,     0,   479,   480,
     481,     0,     0,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   183,     0,   185,     0,   493,   494,
     495,   496,   497,   498,   499,   186,   500,     0,   501,   502,
       0,   503,     0,   189,   190,   504,   505,     0,     0,   506,
       0,     0,     0,   507,   508,     0,     0,   191,     0,     0,
     194,   509,   510,   511,   512,     0,   195,   196,   513,   514,
     515,     0,   516,   517,   518,   519,   520,   521,   198,   522,
     523,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,     0,   533,   534,     0,   535,   536,   206,   537,   538,
    1686,   540,   541,   542,     0,     0,   543,   544,   545,     0,
     546,   210,   547,   548,     0,   549,   213,     0,   550,   551,
     552,   553,   554,   555,   556,   557,   215,   558,     0,   559,
     560,     0,   561,   562,   563,   564,     0,   216,   217,     0,
       0,   566,   218,   567,   219,     0,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,   576,     0,     0,   577,
     578,     0,   579,   227,   580,     0,   581,     0,     0,     0,
     582,   583,   584,   585,   586,   587,     0,     0,     0,   229,
       0,     0,   230,    81,    82,    83,   372,    85,    86,     0,
      87,    88,    89,   373,     0,   374,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   375,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   116,   376,   377,     0,
       0,     0,   378,   379,     0,     0,     0,     0,   380,     0,
       0,     0,     0,     0,     0,     0,     0,   381,     0,   382,
       0,   383,   384,     0,   385,   386,   387,   388,   389,   390,
     391,   392,     0,   393,   394,     0,     0,     0,     0,     0,
       0,     0,   395,   396,     0,   397,     0,   398,   399,   400,
       0,   134,     0,   136,     0,     0,   401,   402,     0,   403,
     404,     0,     0,   405,   882,   137,   407,     0,   408,   409,
     410,   411,   141,     0,     0,   412,   413,   414,   415,     0,
       0,   417,   418,   144,   419,     0,   420,   421,   422,     0,
     423,     0,     0,     0,     0,     0,   424,   425,   426,   427,
     428,   150,   151,   429,     0,   430,     0,   431,     0,   432,
     433,   434,     0,   435,     0,     0,   436,   437,   438,   439,
       0,   440,   441,   442,     0,   443,     0,   444,   445,   446,
     157,   447,     0,   159,     0,   448,   449,   161,     0,   450,
       0,   451,     0,     0,     0,   452,     0,   453,     0,   454,
     166,     0,   455,     0,   456,   457,   458,   459,     0,   460,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   169,     0,   469,   470,   471,     0,   171,     0,   172,
       0,     0,     0,     0,   472,     0,   473,   474,   475,   476,
     477,     0,   176,     0,   478,     0,     0,   479,   480,   481,
       0,     0,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   909,   183,     0,   185,     0,   493,   494,   495,
     496,   497,   498,   499,   186,   500,     0,   501,   502,     0,
     503,     0,   189,   190,   504,   505,     0,     0,   506,     0,
       0,     0,   507,   508,     0,     0,   191,     0,     0,   194,
     509,   510,   511,   512,     0,   195,   196,   513,   514,   515,
       0,   516,   517,   518,   519,   520,   521,   198,   522,   523,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
       0,   533,   534,     0,   910,   536,   206,   537,   538,   539,
     540,   541,   542,     0,     0,   543,   544,  1316,     0,   546,
     210,   547,   548,     0,   549,   213,     0,   550,   551,   552,
     553,   554,   555,   556,   557,   215,   558,     0,   559,   560,
       0,   561,   562,   563,   564,     0,   912,   217,     0,     0,
     913,   218,   567,   219,     0,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,   576,     0,     0,   577,   578,
       0,   886,   227,   580,     0,   581,     0,     0,     0,   582,
     583,   584,   585,   586,   587,    81,    82,    83,   229,    85,
      86,   230,    87,    88,    89,     0,     0,     0,    92,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,     0,     0,     0,   105,   106,   107,   108,     0,   109,
       0,   110,   111,   112,     0,   113,   114,   115,   116,     0,
       0,     0,     0,     0,   119,   120,     0,     0,     0,     0,
     121,     0,     0,     0,     0,     0,     0,     0,     0,   122,
       0,   123,     0,   124,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   131,     0,
       0,     0,   133,   134,   135,   136,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   137,     0,     0,
       0,     0,     0,     0,   141,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   144,     0,     0,     0,     0,
       0,   147,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   150,   151,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   157,     0,     0,   159,     0,     0,     0,   161,
       0,     0,     0,     0,   162,     0,   163,     0,     0,     0,
       0,     0,   166,     0,     0,     0,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   168,   169,     0,     0,     0,     0,     0,   171,
       0,   172,     0,     0,   173,   174,     0,   175,     0,     0,
       0,     0,     0,     0,   176,   177,     0,   178,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   183,   184,   185,     0,     0,
       0,     0,     0,     0,     0,     0,   186,     0,     0,     0,
       0,   188,     0,     0,   189,   190,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   191,   192,
     193,   194,     0,     0,     0,     0,     0,   195,   196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   198,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   204,     0,     0,   206,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   210,     0,     0,   212,     0,   213,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   215,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   216,   217,
       0,     0,     0,   218,     0,   219,     0,     0,     0,     0,
       0,     0,   222,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,     0,   228,     0,    81,    82,
      83,     0,    85,    86,     0,    87,    88,    89,     0,     0,
     229,    92,    93,   230,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,     0,     0,     0,   105,   106,   107,
     108,     0,   109,     0,   110,   111,   112,     0,   113,   114,
     115,   116,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   131,     0,     0,     0,   133,   134,   135,   136,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     137,     0,     0,     0,     0,     0,     0,   141,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   144,     0,
       0,     0,     0,     0,   147,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   150,   151,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   157,     0,     0,   159,     0,
       0,     0,   161,     0,     0,     0,     0,   162,     0,   163,
       0,     0,     0,     0,     0,   166,     0,     0,     0,     0,
       0,     0,     0,   167,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   168,   169,     0,     0,     0,
       0,     0,   171,     0,   172,     0,     0,   173,   174,     0,
     175,     0,     0,     0,     0,     0,     0,   176,   177,     0,
     178,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   183,   184,
     185,     0,     0,     0,     0,     0,     0,     0,     0,   186,
       0,     0,     0,     0,   188,     0,     0,   189,   190,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   191,   192,   193,   194,     0,     0,     0,     0,     0,
     195,   196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   198,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   204,     0,
       0,   206,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   210,     0,     0,   212,     0,
     213,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     215,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   216,   217,     0,     0,     0,   218,     0,   219,     0,
       0,     0,     0,     0,     0,   222,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,     0,   228,
       0,    81,    82,    83,     0,    85,    86,     0,    87,    88,
      89,     0,     0,   229,     0,    93,   230,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,     0,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   131,     0,     0,     0,   133,   134,
     135,   136,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   137,     0,     0,     0,     0,     0,     0,
     141,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   144,     0,     0,     0,     0,     0,   147,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   150,
     151,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   157,     0,
       0,   159,     0,     0,     0,   161,     0,     0,     0,     0,
     162,     0,   163,     0,     0,     0,     0,     0,   166,     0,
       0,     0,     0,     0,     0,     0,   167,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   168,   169,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
     173,   174,     0,   175,     0,     0,     0,     0,     0,     0,
     176,   177,     0,   178,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   183,   184,   185,     0,     0,     0,     0,     0,     0,
       0,     0,   186,     0,     0,     0,     0,   188,     0,     0,
     189,   190,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   191,   192,   193,   194,     0,     0,
       0,     0,     0,   195,   196,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   198,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   204,     0,     0,   206,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   210,     0,
       0,   212,     0,   213,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   215,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   216,   217,     0,     0,     0,   218,
       0,   219,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,     0,   228,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   229,     0,     0,   230
};

static const short yycheck[] =
{
       2,    76,   728,   867,   231,    76,   732,   156,   736,  1467,
    1142,   729,   220,   731,   146,   948,  1619,    79,  1064,  1107,
     720,  1406,  1558,   148,    92,   743,  1114,  1560,    76,    76,
    1252,   203,   148,   149,    84,  1203,   762,  1657,    76,    92,
     156,    79,   224,   907,   772,     2,   114,  1542,   197,   998,
     768,  1792,   811,  1069,    92,   733,   796,   816,   922,   737,
    1017,   114,   913,   781,    76,   824,   744,   833,  1266,   835,
     145,   837,  1324,   202,  2324,   130,   114,   843,   804,    76,
     209,   197,   211,  2050,   810,   813,  1095,  2127,   969,  2203,
    1605,    76,   770,  1575,   844,  2345,   774,    76,  1575,  1575,
      79,  1575,  1575,  2147,  1575,   783,  1689,  1830,  1452,   827,
    1034,  2137,   852,    92,  1868,   998,    92,  2569,  2534,    92,
    2132,  2133,   832,  2540,    76,  1839,  1135,    79,  2918,  2398,
     180,  2075,  2076,  2077,  2078,   114,   908,  1429,   114,   911,
      92,   114,  1121,  1051,  1947,  1948,  1900,  1031,  1167,    24,
    1904,  1059,  1214,  1215,   222,  1836,   231,   232,   160,    92,
    1618,   232,   114,   993,   978,   905,   998,   920,    25,   222,
      41,  2698,    76,   986,   987,    49,  1238,    92,    76,    93,
     182,   114,    92,  1224,   222,   157,   118,   112,   152,   722,
     700,   118,   127,    85,    98,  1103,    76,   157,   105,    91,
      79,  1109,   120,   196,    81,   156,   196,  1115,   233,    28,
      41,   120,  1748,    79,   233,  1097,    97,   112,    98,    97,
     232,   162,    85,   202,   133,    81,   164,   112,    91,   215,
     209,    76,   211,   196,   233,   232,    85,   120,   162,   112,
     304,   180,    28,   222,   127,   209,   222,   232,  2512,   222,
     133,   198,   202,   103,  1336,   371,   291,   290,   130,  3293,
     112,   180,   173,  3162,  1722,   260,   233,   233,   352,   202,
     222,   133,   159,  3331,   162,   193,   209,   112,   211,     0,
     328,   328,  1328,    76,   193,    42,   227,    44,   249,   222,
     328,    85,   237,    85,   171,   157,   260,    91,    85,   263,
    3263,  3313,   233,   365,   442,  3095,    76,  2061,  3463,   339,
     193,   449,   152,    17,   180,   171,    11,   237,  1036,     8,
     368,   368,  1437,  1545,    13,    14,    15,   365,    98,   290,
     368,    92,  1289,   118,  3297,  1587,    25,    26,    27,   227,
      29,    30,    31,   152,  3499,  1071,    35,    36,    37,   328,
     345,  1077,  1080,    92,    49,    92,   440,   233,    33,  3149,
    1475,   211,    88,    89,  2979,   215,  2981,  1067,   398,   209,
      92,  3526,  1460,   196,   319,   233,   328,  3389,  1327,  1511,
     167,   345,   124,  3441,   233,   449,   365,   347,  1106,   368,
    1149,   157,   279,  3183,   341,   313,  1122,    76,   248,   319,
     209,   400,  1120,   293,   313,  3368,   347,   332,  1424,  3308,
     229,    76,   447,   365,  1167,   354,   368,   279,   381,  1952,
     260,   454,    17,   171,  1177,  1178,  1185,   157,  1146,   454,
     313,   450,   383,   400,  1193,   354,   271,   332,  1526,   232,
     565,   233,  2045,   229,   404,  1204,   381,   332,  2492,   565,
     422,   260,   416,   425,   263,  1501,  3490,   398,   430,   332,
    1592,   454,   400,   414,   454,   235,   236,   359,   454,  1531,
    1532,   327,  3262,   339,   398,   352,   394,  1539,   450,   406,
     332,   991,  1015,   447,   450,   394,   365,   447,   354,   370,
    1688,  1689,   370,  1534,  3021,   422,   359,   332,   425,   410,
    1509,  1699,  1700,   430,   454,   345,   356,    86,  2189,   454,
     398,   394,   282,  1711,  1712,   447,   288,   352,   449,   391,
     447,  2488,   279,  2490,  2491,   400,  1608,  1725,  1726,   454,
     445,  1613,  2499,   447,  1287,   445,   345,   233,  1620,   443,
     447,  2810,  2811,  1425,  2584,   443,   204,  1629,  2588,   291,
     225,   425,   734,  1367,   425,    76,   235,   739,   740,   454,
     440,   441,   442,   443,  1396,   359,   441,  1451,   425,   454,
     235,    93,  1402,   210,   450,  1389,   425,  2521,  1331,  1332,
    1393,   454,   431,   288,  1466,  1783,  2340,  2268,  3203,   111,
     439,   422,   450,  2334,   425,   440,   441,   442,   443,   430,
     431,   450,   433,  1947,   352,   730,   731,   416,   439,  2412,
    1589,  2414,  2127,   157,   179,  1523,   197,  3407,  1637,   157,
     309,   803,  1914,  2887,  2888,  2889,  2890,  2891,  1510,   162,
     295,  1512,  2346,   425,   294,  1345,   151,   422,   447,   431,
     425,   766,   390,  1525,   114,   430,   162,   439,   797,   228,
    3440,   304,   720,  1715,  1716,   171,   422,   198,   450,   425,
      76,  1433,   447,   185,   430,   431,   231,   720,   438,   439,
     440,   441,   442,   443,   327,   447,   724,   724,   157,   337,
     796,   797,   720,   808,   445,  1567,   724,   448,   449,   157,
     159,   213,   422,   454,   227,   425,  1468,   381,   700,   200,
     430,   390,  2505,   218,   138,   167,   445,   757,   445,   448,
     449,   448,   449,   829,   235,   454,   167,   454,   322,   241,
    1736,   373,  1494,   445,   305,   187,   448,   449,  1610,  1429,
    2533,  3183,   454,   298,  3150,   279,   852,  1619,    28,  1467,
    3157,   720,   447,   700,   720,   724,   284,   720,   281,    39,
     434,   252,   222,   165,   295,   415,  2782,  2511,   423,   438,
     439,   440,   441,   442,   443,  2568,  1782,   201,   720,   434,
     435,   436,   724,   438,   439,   440,   441,   442,   443,   908,
      76,   120,   911,   448,   304,   422,   132,   720,   425,   905,
     159,   203,   167,   430,   310,  1513,  1660,  1661,   209,  1517,
     279,  2337,    98,   383,   312,   374,   303,   327,  2323,   381,
      76,   279,   334,   304,   347,   284,   152,   279,   157,   235,
     161,   871,   284,    76,   346,   366,   288,   117,   393,   175,
     412,   833,    98,   835,   414,   837,   235,   288,   360,   284,
    2298,   843,   844,   447,   413,   367,   150,  1597,   898,   260,
    3119,   906,   284,   222,   304,  1614,   383,   372,   373,   909,
     910,   352,  1621,  2807,   343,   398,   347,  1749,  1627,   279,
    1570,   404,   454,   209,   375,   383,   377,   327,   447,   295,
     330,  1607,   454,  1636,   191,   923,  1612,   409,  2855,  2856,
    1618,   122,  1645,   234,   293,   363,  1574,  1656,   366,  1658,
    1659,    76,   352,  1662,   279,   156,   414,  2951,   318,   255,
     279,   162,  1630,   288,   447,  1633,   105,   438,   439,   440,
     441,   442,   443,   404,   260,   387,    76,   263,   200,   908,
    2970,  1657,   911,   395,   345,  2975,   986,   987,  2978,   229,
     279,  2985,   249,   756,   923,   284,   312,   923,   374,   196,
    1899,  1701,  1702,  1703,  2966,   259,   202,   261,   304,  1709,
     149,   343,   412,  1713,  1714,   211,   447,   969,   215,   235,
    1720,   923,   785,   412,   313,   908,   227,   422,   911,  1729,
     252,  1731,   235,   290,   323,   430,   330,   197,   990,   991,
     422,   993,   374,   425,  1722,  1745,   998,  1747,   430,  1067,
     319,  2621,  2605,   105,   381,  1886,  3422,   423,   352,   345,
    2142,  3280,   969,   161,  1067,   454,  1899,   383,   434,   435,
     436,   447,   438,   439,   440,   441,   442,   443,   374,  1067,
     376,   413,   448,   990,   991,   354,   993,   226,   179,  1266,
     215,   998,   295,  1967,  1094,  2177,   260,   149,   414,   263,
     191,  1751,    56,  2535,   160,   394,   447,  2780,  2535,  2535,
     235,  2535,  2535,  2261,  2535,   447,  2649,  2411,   412,  2584,
      74,  2153,  1825,  2588,  2156,   348,  1192,   454,  2160,   398,
     416,  1840,   271,   191,  2282,   235,   234,   160,  1067,  2675,
     231,  1067,   105,  1168,  1067,   450,   347,  1168,  2006,  2007,
     373,    83,  3216,   375,   442,   377,   212,   348,   249,   160,
    1160,   449,  1187,  2699,     5,  1067,  1187,   181,  1999,   101,
     295,  2002,  2003,  2205,   226,   381,   167,  2325,  2326,  2138,
     143,   345,   373,  1208,  1067,   408,   408,    28,  2892,   212,
    2505,   249,   134,  3110,  3111,   295,   187,   398,    39,   290,
     163,  1226,   216,   404,   354,   344,  1168,   298,  1898,   327,
    3200,   212,   330,  2045,  3414,   178,   158,   408,  2533,   271,
     423,  1168,   438,   439,   440,   441,   442,   443,  2135,   192,
    2062,  1256,   290,  1168,   352,   438,   439,   440,   441,   442,
     443,  1266,   423,   449,   207,   407,   447,   453,   398,  1495,
    1027,  3397,  1961,   434,   435,   436,   454,   438,   439,   440,
     441,   442,   443,   304,  1914,   134,  1975,  3467,  1268,   425,
     424,   425,   304,   422,  1051,   431,   117,   219,   304,  1279,
    1989,   430,  1059,  1911,  1993,  3485,   327,  1915,    99,   158,
    3436,  1991,   344,   284,   412,   327,  3442,   288,   423,   304,
     421,   327,   393,   424,  1932,  1310,  1311,  3301,   119,   434,
     435,   436,   450,   438,   439,   440,   441,   442,   443,  3465,
     352,   284,  1568,   423,  1324,   330,   352,  1573,   291,   170,
    1355,  1356,  1960,  1358,  1962,   435,   436,  1583,   438,   439,
     440,   441,   442,   443,   375,  1724,   377,   352,    93,   451,
     219,   364,   365,  1371,  1433,   318,  3273,   448,  1490,   412,
     413,   431,   446,   433,  2064,  2567,   111,  2399,  1996,  2069,
     454,   162,   122,  1097,   126,  1327,   448,  1329,  1330,  2047,
    2048,  2347,   454,  1371,  1372,  1373,  1391,    93,   229,  1468,
    3081,   143,    45,  1393,   447,   127,   387,  2025,   304,   319,
    2028,   133,  2030,   155,   395,   111,   445,  2893,   328,   422,
     449,  1429,   425,   450,   304,  1494,   339,   430,  1416,  1416,
    1327,   327,  1329,  1330,   330,   375,  1429,   377,  1416,   349,
    1382,   412,   413,  2465,  2466,  1423,   227,   327,   845,   362,
     185,  1429,  1371,  1372,  1373,  1371,   352,   289,  1371,   422,
    1402,   293,   425,   205,  1406,   422,   422,   430,   425,   425,
     210,   868,   451,   430,   430,  2948,   447,   400,   213,  1371,
    1372,  1373,   229,    84,   447,  1382,  2166,   446,  2146,   185,
      91,   447,   452,    94,   454,   454,   448,  1416,    38,   280,
     281,  1668,   454,   104,  1423,  1402,   241,  1423,    20,  1406,
    1429,   293,   448,  1429,  1433,  2970,  1429,   213,   454,   448,
    2975,  2956,  2212,  2978,  1416,   454,   293,  2555,   448,   130,
     448,  1423,   422,  2641,   454,   425,   454,  1429,   139,   140,
     430,  2703,  2704,   447,  2335,   241,  1611,   148,   149,  1468,
     422,   152,   445,   425,   447,   156,  1429,   447,   430,   160,
    1433,  2383,  1570,   448,   165,  2183,   347,   406,   381,   454,
    1512,  1683,  2710,   425,  3050,  1494,   385,  1570,  2600,   431,
    2602,   182,  2604,   422,  2606,  2203,   425,   439,   448,  2611,
    1605,   430,  1570,   329,   454,  1468,   197,  1587,   135,   334,
     201,   445,   203,   447,   425,   449,   207,  2429,   447,  2431,
     431,   346,   433,  1327,   316,  1512,  2505,   398,   439,   422,
    2642,  1494,   425,   404,   218,   360,   120,   430,  2449,   423,
    2298,   111,   367,   117,   118,  2456,  2457,  2459,   334,   133,
    1476,  2597,   425,  1479,  2533,     7,  2336,  1483,    10,   455,
     346,  1570,   210,  1668,  1570,  1597,   448,  1570,  2357,   109,
      22,    23,   454,   157,   360,   159,   447,  2489,   412,   413,
     448,   367,   133,   448,   409,  2631,   454,   412,  1570,   454,
     448,    43,   197,   423,    46,   422,   454,  2355,   425,  3087,
     418,   419,   420,   430,   434,   435,   436,  1570,   438,   439,
     440,   441,   442,   443,   422,   185,   241,   425,   223,  3182,
    1652,  1425,   430,   409,   448,   440,   441,   442,  1708,   142,
     454,  2543,    76,   238,   233,  3180,   122,  2433,   222,   447,
    3290,   246,  2554,   213,   315,   448,  2435,  2436,  1452,   200,
    1755,   454,   448,  1751,    98,  3200,   293,   422,   454,   103,
     425,  2260,  1466,  2262,  2263,   430,  2712,   218,  1751,  1701,
    1702,  1703,   448,   448,  3089,   196,  2384,  1709,   454,   454,
     371,  1713,  1714,  1751,   197,   448,   448,   109,  1720,  2601,
    3256,   454,   454,  2605,    99,   279,   448,  1729,  2774,  1731,
     284,   252,   454,   452,   450,   454,  1510,  2455,   454,  2417,
     223,   422,   448,  1745,   425,  1747,   168,   448,   454,   430,
     448,  1525,   375,   454,   377,   238,   454,   417,  1808,   313,
    2510,   336,  2512,   246,   448,   448,   447,   237,  1542,   323,
     454,   454,  1751,  2655,   449,  1751,   297,  2505,  1751,  1827,
    1827,   448,  1898,   296,   267,  1355,  1356,   454,  1358,  1827,
    1792,  1916,   332,  1567,   334,   293,  2678,   448,   448,  1751,
     381,   215,   142,   454,   454,  2533,   346,  1869,   111,  1871,
     450,  3326,   417,   450,   454,   293,  2245,   454,  1751,  2248,
     360,   235,   236,  2705,  2863,  2864,    99,   367,  2867,   417,
    2869,  1869,  2532,  1871,   237,    76,  1610,   448,   448,   375,
     394,   377,  1892,   454,   454,  1619,  1914,  2729,  1827,    90,
    2279,  2280,   422,   336,   375,   425,   377,   197,   352,   450,
     430,  1914,   422,   454,   385,   425,   448,   440,   282,   409,
     430,  2959,   454,   394,   448,  1827,  1914,   447,   412,   413,
     454,   295,   185,   223,  1886,   412,   413,   447,   422,   195,
    1869,   425,  1871,  3408,   450,  2621,   430,  1899,   238,  1901,
    2127,  1903,   179,   179,   565,   448,   246,  2989,  2990,   448,
     213,  3514,  2662,   447,   191,   191,    85,  1869,   422,  1871,
     109,   425,  2672,   440,   448,   422,   430,   267,   425,  1886,
     454,   412,   413,   430,    76,  1914,   451,   110,  1914,  2657,
     451,  1914,  1899,   447,  1901,  2623,  1903,   608,   609,   422,
     447,  2859,   425,   293,   231,   231,   381,   430,  2090,   229,
    2842,   157,  1914,   448,   448,  2643,   448,   423,   450,   454,
     454,   381,   249,   249,   447,  1749,   381,   150,   434,   435,
     436,  1914,   438,   439,   440,   441,   442,   443,   381,  1991,
    1355,  1356,   381,  1358,   235,   177,   336,  1999,    93,   422,
    2002,  2003,   425,   109,  2054,   448,   448,   430,   431,   423,
     433,   454,   454,   290,   290,   400,   439,   448,   412,   413,
    3478,   298,   298,   454,   438,   439,   440,   441,   442,   443,
     229,   334,   448,   448,   235,   450,   232,   943,   454,   945,
    2922,   447,  1999,   346,   217,  2002,  2003,    76,   381,  3247,
    2166,  2589,  2127,  2591,   295,  2282,   252,   360,  1195,  1196,
     400,    90,  2064,   447,   367,  2115,   447,  2069,   729,   730,
     731,   447,   733,   447,   735,   736,   737,   738,  2358,  2359,
     741,   742,   743,   744,  2360,  2361,   259,   449,   261,   304,
     988,   989,   447,   235,   327,   447,   449,   352,   271,   293,
     450,   247,   763,   447,   287,   766,   409,   768,  2158,   770,
    2318,  2319,   241,   774,   775,   776,   393,   393,   779,   412,
     781,   447,   783,   120,  3206,  3207,  3208,   412,    93,   412,
     303,   447,  2882,    99,   304,   796,   797,  2887,  2888,  2889,
    2890,  2891,    99,   241,   805,  2895,   455,   808,   400,   183,
     811,  3084,   183,   295,   454,   816,   817,   447,   331,   183,
     821,   822,   183,   824,   183,   183,   827,   295,   412,   413,
     183,   183,   447,  1947,  1948,   293,  3058,   183,   422,   183,
     293,   425,   423,   183,   845,   846,   430,   183,   361,   192,
     247,   852,   191,   434,   435,   436,   447,   438,   439,   440,
     441,   442,   443,   447,   447,   447,   235,  2282,    76,   447,
    2212,   447,   447,   874,   454,   876,   309,   447,   879,   447,
    2295,   447,    90,   447,   447,   421,   422,   447,   424,   425,
     447,   447,    93,   447,   430,   431,   447,   433,    76,  2314,
     447,   447,   447,   439,   905,   906,   247,   447,  2323,   910,
    2679,   235,    90,  2682,  2683,  2684,  2685,  2686,  2687,  2688,
    2689,  2690,  2691,   447,    76,   422,   295,   928,   425,  3351,
     447,  2045,   191,   430,   431,   191,   433,   440,   229,   345,
     263,   423,   439,   454,   156,   399,    98,    41,  2062,    17,
     454,   103,   434,   435,   436,   423,   438,   439,   440,   441,
     442,   443,  2731,  2732,   447,   381,   434,   435,   436,   447,
     438,   439,   440,   441,   442,   443,   447,   381,   381,   449,
    2998,   381,   381,  3205,   293,   986,   987,   438,   439,   440,
     441,   442,  2334,   381,  2336,   346,  2338,   448,   284,   381,
     381,  3091,   454,   399,   381,  1006,   400,   127,  1009,   381,
     343,  1012,   293,  3235,  3104,   381,   220,   385,   385,  3087,
     454,   381,   343,  3495,   381,   381,   178,   235,   438,   439,
     440,   441,   442,   381,   447,  1036,   446,   235,   293,   291,
     447,  2338,   447,   406,    93,   447,   447,    83,   157,   255,
     191,   293,   447,   408,   423,   447,    93,   235,   449,   211,
     344,   411,   183,   215,   183,   434,   435,   436,   400,   438,
     439,   440,   441,   442,   443,    17,   454,   381,   454,   404,
    3098,  1082,  3100,   235,   236,   434,  1087,   295,  2577,   333,
    1091,  2433,   283,   196,  3193,   410,   248,  1098,    76,   379,
     447,   152,   379,   352,  3203,  1106,   379,  2449,  3312,  2574,
     381,   196,   454,   447,  2456,  2457,   447,   295,   434,  1120,
    1121,  2577,  1123,  1124,  2532,   454,   383,  2505,   454,   448,
     282,   434,   231,   294,  2524,   288,   454,   249,   445,  2532,
     448,    38,  2911,   295,   381,  1146,  2561,   448,  1149,   381,
    2561,   343,  2449,   132,  2532,  2533,   239,   447,   209,  2456,
    2457,   239,  2577,  2505,   447,   293,  2577,   284,  2510,  2584,
    2512,   284,  2739,  2588,   284,  1176,  2566,  2567,   381,   381,
     343,  2523,   454,   299,  1185,  1186,   448,   454,   249,  1190,
     397,  2533,  1193,  2741,  2742,  2743,  2744,   109,  3216,   306,
    1201,   306,   109,  1204,   356,  1206,   235,    93,  2505,   260,
     235,   319,   263,  2532,  2629,   423,  2532,   235,  2629,  2532,
     400,   327,   235,    81,  3290,   434,   434,   435,   436,    87,
     438,   439,   440,   441,   442,   443,  2533,   381,  3460,   381,
    2532,  3340,   249,   191,   434,   423,   445,   434,   293,   297,
      93,   205,   293,   441,   191,   208,   434,   435,   436,  2532,
     438,   439,   440,   441,   442,   443,   124,  3325,   208,  2383,
     454,   423,    93,   447,   293,   448,   293,    11,   454,    82,
     202,   262,   293,  3052,  3053,   454,   438,   439,   440,   441,
     442,   443,  3514,   109,   345,   196,   454,  2411,  2412,   448,
    2414,   448,   448,   448,   196,   448,   417,   447,   166,  1310,
    1311,   448,    81,   171,   448,  2429,   174,  2431,    87,   448,
    2662,   448,   448,  1324,  2739,   417,  2716,   417,  1329,  1330,
    2672,   381,   455,   448,   448,    34,   454,   225,   249,  1340,
     284,  1342,   304,   381,   448,  2459,   448,   448,   448,   447,
    1097,  3409,   448,   450,   447,   124,   235,   448,   381,   447,
     235,   450,   220,   445,   448,   416,   293,   448,  3458,  3459,
     421,   422,   263,   424,   425,  2489,   448,   329,   390,   430,
     447,   454,   448,   291,   293,   381,   400,   293,   448,   447,
    1391,  2505,  1393,   238,   238,   300,   400,   166,   454,   434,
     447,   296,   171,   180,   180,   174,   445,   177,   454,   196,
    3478,  3477,    76,   271,   448,   448,   191,  1418,   448,  2533,
     448,   118,   196,   447,   204,   434,   448,   454,   448,  2543,
     431,   434,   447,   225,   434,   390,   381,   235,   381,   235,
    2554,  2245,    84,   381,  2248,  3511,   304,   164,   446,   448,
     447,   220,   412,  2795,  2568,  3224,   239,    93,  3227,   191,
     297,   221,   129,   447,   374,   454,  1467,  3236,  3237,   327,
     403,   447,   330,   115,   423,  2279,  2280,   238,   447,   201,
     448,   448,   196,   448,   448,   127,   196,  2601,   109,   448,
     448,  2605,   448,   135,   352,   206,   447,   400,   284,   284,
     235,   159,   271,   284,   222,   446,    84,   198,   198,   151,
     196,   400,  1513,    91,   182,   400,  1517,   172,   448,   447,
      93,   120,   120,   296,   240,   196,   447,   169,   381,   447,
     191,   296,  2874,   196,   447,   304,    93,   454,   284,   323,
    2882,  2655,   218,   258,   448,  2887,  2888,  2889,  2890,  2891,
     317,   340,   130,  2895,   296,  2970,   198,   296,   340,  2949,
    2975,   330,    96,  2978,  2678,   191,   293,   374,    93,   172,
     148,   149,   390,  1574,   293,  1576,   218,  2874,   156,   447,
     293,   168,   160,   352,  3353,  3354,  1587,   339,  1589,   398,
     162,  2705,   454,   182,    80,   447,   317,   448,   322,   232,
     242,  2338,   180,  2089,   182,  2024,  2460,  1330,  3114,  2054,
    1611,  2933,  2936,  1614,  1615,  2729,  3143,  1618,  2011,   197,
    1621,  1622,  2395,  1624,  1625,  2945,  1627,  3449,  3469,  1630,
    2839,  3432,  1633,  3431,  3452,  1584,  2938,  1638,  3174,  2072,
    3526,  3499,  3127,  3126,  2532,  2504,  2533,  3480,  3527,  1569,
     182,  1630,  2998,   295,  1186,  1656,  2950,  1658,  1659,  2185,
    3326,  1662,  3408,  2411,  1948,  1947,  3373,  1668,  2957,  3489,
    3525,   921,  3302,  2079,   316,  1837,   158,  2630,  1425,  2344,
    1168,  2164,  1683,  2992,  2352,  1686,  1363,  2362,  1362,  1364,
    1831,  1852,  3082,  2127,  2323,   337,  2590,  3201,  2931,   341,
    2355,   343,    76,  2715,  3058,  1452,   348,  2214,   803,  2293,
    2295,  2190,  1779,  1127,  1599,   565,    90,  2574,  2120,  1466,
    1892,  1722,  1373,    76,    98,  3115,  3116,   329,  2842,   103,
    3120,   373,   374,   704,  1867,  1192,   989,  1016,  3153,  3081,
    1899,  2333,  3153,   385,  2172,  2993,  3080,  3089,   390,  3091,
    2173,  2994,  2778,  1371,   364,  1308,  2167,  1903,  1651,   990,
       2,    -1,  3104,  1510,    -1,    -1,   408,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1525,    -1,
      -1,    -1,    -1,  1784,  3081,  3200,    -1,    -1,    -1,    -1,
      -1,  3181,  3089,   371,    -1,  1542,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2922,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1567,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1830,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   211,    -1,  1840,
      -1,   215,  2956,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   235,   236,  1610,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1619,    -1,   248,  2679,    -1,    -1,  2682,  2683,
    2684,  2685,  2686,  2687,  2688,  2689,  2690,  2691,    -1,    -1,
      -1,  1892,    -1,    -1,    -1,    -1,    -1,  1898,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   279,    -1,    -1,   282,  3251,
    1911,  1912,    -1,    -1,  1915,  1916,    -1,    -1,    -1,  1920,
      -1,   295,    -1,   297,    -1,  1926,    -1,  2731,  2732,    -1,
    1931,  1932,    -1,  3323,  3349,  3502,    -1,    -1,  3349,    -1,
      -1,    -1,    -1,    76,  3058,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3251,    -1,    -1,    -1,    -1,  1960,
    1961,  1962,  1963,    -1,  1965,    98,    -1,  1968,  1969,    -1,
     103,    -1,    -1,    -1,  1975,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   356,    -1,    -1,  3400,    -1,   565,  1989,  3400,
      -1,    -1,  1993,    -1,    -1,  1996,  1997,  1998,    -1,    -1,
      -1,    -1,  1749,    -1,    -1,    -1,    -1,    -1,    76,    -1,
    2011,  2012,  2013,  2014,  2015,  2016,  2017,    -1,    -1,  2020,
    2021,  2022,    90,  1097,  2025,  2026,    -1,  2028,  2029,  2030,
      98,    -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   178,  2047,  2048,    -1,   423,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     434,   435,   436,  2064,   438,   439,   440,   441,   442,   443,
      -1,    -1,   446,    -1,  3489,    -1,    -1,    -1,   211,    -1,
      -1,   455,   215,    -1,    -1,    -1,    -1,  3502,    -1,    -1,
    2091,  3205,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   235,   236,    -1,  2106,    -1,  2911,    -1,  2110,
    3525,  2112,    -1,    -1,    -1,   248,  3458,  3459,    -1,  2120,
      -1,  3235,    -1,    -1,    -1,    -1,    -1,  2128,    -1,    -1,
      -1,  2132,  2133,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    76,   211,    -1,  2146,  2147,   215,    -1,   282,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,   295,    -1,    98,  2166,    -1,   235,   236,   103,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   757,
     248,    -1,  2183,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2200,
    1947,  1948,  2203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   279,    -1,    -1,   282,    -1,    -1,   795,   796,   797,
      -1,    -1,    -1,   356,    -1,    -1,    -1,   295,    -1,   297,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3052,  3053,
      -1,   829,    -1,    -1,    -1,   833,    -1,   835,    -1,   837,
      -1,    -1,    -1,    -1,    -1,   843,   844,    -1,    -1,  2270,
      -1,    -1,    -1,    -1,   852,    -1,    -1,   211,    -1,    -1,
      -1,   215,    -1,    -1,    -1,    -1,    -1,    -1,   356,    -1,
     423,    -1,    -1,   871,    -1,    -1,    -1,  2298,  2045,    -1,
      -1,   235,   236,    -1,    -1,   438,   439,   440,   441,   442,
     443,    -1,    -1,    -1,   248,  2062,    -1,    -1,   140,    -1,
     898,    -1,    -1,    -1,    -1,    -1,    -1,   905,   906,    -1,
      -1,   909,   910,    -1,    -1,    -1,    -1,  2338,    -1,    -1,
      -1,    -1,    -1,  2344,    -1,   279,  3460,    -1,   282,    -1,
      -1,  1425,    -1,    -1,    -1,   423,  2357,   179,    -1,    -1,
      -1,   295,    -1,   297,    -1,   187,   434,   435,   436,    -1,
     438,   439,   440,   441,   442,   443,    -1,    -1,  1452,    -1,
      -1,    -1,    -1,  2384,  2385,  2386,   454,    -1,    -1,    -1,
      -1,   969,  1466,    -1,    -1,    -1,    -1,  2398,    -1,    -1,
    3514,   223,    -1,    -1,    -1,    -1,    -1,    -1,   986,   987,
      -1,    -1,    -1,    -1,    -1,    -1,  2417,  2418,  2419,    82,
    3224,    -1,   356,  3227,    -1,    76,    -1,    -1,    -1,    -1,
      -1,    -1,  3236,  3237,  2435,  2436,  1510,    -1,    -1,    90,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
      -1,  1525,   103,    -1,  2455,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1542,   132,
      -1,    -1,    -1,    -1,    -1,    -1,   139,   140,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   423,
      -1,  2492,    -1,  1567,    -1,    -1,    -1,    -1,    -1,    -1,
     434,   435,   436,    -1,   438,   439,   440,   441,   442,   443,
      -1,  2512,    -1,   176,   448,    -1,  1094,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2525,  2526,  2527,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1610,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1619,    -1,    -1,    -1,  3353,
    3354,    -1,   215,    -1,    -1,    -1,    76,   220,    -1,    -1,
     211,  2562,    -1,    -1,   215,    -1,  2567,    -1,    -1,    -1,
      90,    -1,    -1,  2574,    -1,    -1,  2577,  2578,    98,    -1,
    2581,    -1,  1160,   103,   235,   236,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2594,   257,    -1,    -1,   248,    -1,    -1,
      -1,  1179,    -1,    -1,  1182,    -1,    -1,    -1,    -1,   272,
     273,    -1,   275,   276,  1192,   278,    -1,    -1,    -1,    -1,
      -1,    -1,  2623,    -1,    -1,    -1,    -1,    -1,   279,  2630,
      -1,   282,    -1,    -1,    -1,    -1,  2383,    -1,    -1,    -1,
      -1,    -1,  2643,   306,   295,    -1,   297,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2657,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2411,  2412,    76,  2414,    -1,    -1,
      -1,    -1,    -1,    -1,   337,  1749,    -1,    -1,    -1,    -1,
      90,    -1,  2429,    -1,  2431,    -1,    -1,    -1,    98,    -1,
    1268,   211,    -1,   103,    -1,   215,    -1,    -1,    -1,    -1,
      -1,  1279,    -1,    -1,    -1,   356,   369,    -1,   371,    -1,
      -1,    -1,  2459,    -1,    -1,   235,   236,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1305,   248,   392,
      -1,    -1,  1310,  1311,    -1,    -1,   399,    -1,    -1,   402,
      -1,    -1,  2489,    -1,    -1,    -1,  1324,    -1,    -1,  1327,
      -1,  1329,  1330,    -1,    -1,    -1,    -1,    -1,  2505,   279,
      -1,    -1,   282,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   423,    -1,    -1,   295,    -1,   297,    -1,  2780,
      -1,    -1,    -1,   434,   435,   436,  2533,   438,   439,   440,
     441,   442,   443,    -1,    -1,    -1,  2543,   448,    -1,    -1,
      -1,   211,    -1,    -1,    -1,   215,    -1,  2554,    -1,  2810,
    2811,    -1,    -1,  1391,    -1,  1393,    -1,    -1,    -1,    -1,
      -1,  2568,    -1,    -1,    -1,   235,   236,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   356,    -1,   248,    -1,
      -1,    -1,    -1,    -1,    -1,  2846,  2847,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2601,    -1,    -1,    -1,  2605,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   279,
      -1,    -1,   282,  1947,  1948,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   295,  2887,  2888,  2889,  2890,
    2891,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   423,    -1,    -1,    -1,    -1,  2655,  2910,
      -1,    -1,    -1,    -1,   434,   435,   436,   739,   438,   439,
     440,   441,   442,   443,    -1,    -1,    -1,    -1,   448,    -1,
    2931,  2678,  2933,    -1,  1512,  2936,    -1,  2938,   760,    -1,
      -1,    -1,    -1,    -1,  2945,    -1,   356,    -1,    -1,    -1,
    2951,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2705,    -1,
      -1,    -1,    -1,    -1,    -1,  2966,    -1,  2968,    -1,    -1,
      -1,  2045,    -1,    -1,    -1,    -1,    76,    -1,  2979,    79,
    2981,    -1,  2729,    -1,  2985,    -1,    -1,    -1,  2062,    -1,
      -1,    -1,    92,    -1,    -1,    -1,    -1,  2998,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1587,
      -1,    -1,    -1,   423,   114,    -1,    -1,    -1,    -1,  1597,
      -1,    -1,    -1,    -1,   434,   435,   436,    -1,   438,   439,
     440,   441,   442,   443,    -1,    76,    -1,    -1,    -1,   861,
      -1,    -1,    -1,    -1,    -1,   867,    -1,    -1,   148,    90,
      -1,    -1,    -1,    -1,    -1,    -1,   878,    98,    -1,    -1,
      -1,    -1,   103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1651,  1652,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   907,  3087,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2842,    -1,  3098,  3099,  3100,
     922,    -1,   202,    -1,  3105,   927,    -1,    -1,    -1,   209,
      -1,   211,    -1,    -1,    -1,    -1,    -1,    -1,  3119,   941,
      -1,    -1,   222,  1701,  1702,  1703,    -1,    -1,    -1,    -1,
    1708,  1709,    -1,    -1,    -1,  1713,  1714,    -1,    -1,    -1,
      -1,    -1,  1720,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1729,    -1,  1731,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3167,  1745,    -1,  1747,
     211,    -1,    -1,  3174,   215,  2922,    -1,    -1,    -1,  3180,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3190,
      -1,    -1,  3193,    -1,   235,   236,    -1,    -1,    -1,    -1,
    1778,    -1,  3203,    -1,    -1,    -1,  1784,   248,    -1,  2956,
      -1,    -1,    -1,    -1,  1792,  3216,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   328,    -1,
    1808,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   279,    -1,
      -1,   282,    -1,    -1,    -1,    -1,    84,    -1,  1070,    -1,
      -1,    -1,    -1,    -1,   295,    -1,   297,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   365,    -1,    -1,   368,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3280,
      -1,    -1,    -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1116,  1117,  1118,   135,    -1,    -1,
    3301,    -1,  3303,    -1,    -1,    98,    -1,    -1,  1886,  2383,
     103,  3058,    -1,   151,  1892,   356,    -1,    -1,    -1,    -1,
    1898,    -1,    -1,    -1,  3325,  3326,    -1,    -1,    -1,  3330,
    3331,   169,    -1,    -1,    -1,    -1,    -1,  2411,  2412,  3340,
    2414,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2429,    -1,  2431,    -1,    -1,
     198,    -1,  1184,    -1,    -1,    -1,   204,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1097,    -1,    -1,    -1,    -1,    -1,
     218,  1203,   423,    -1,    -1,  2459,    -1,  3388,    -1,    -1,
      -1,    -1,    -1,   434,   435,   436,  1097,   438,   439,   440,
     441,   442,   443,   241,    -1,   446,    -1,  3408,  3409,    -1,
      -1,    -1,    -1,  1991,    -1,  2489,    -1,    -1,   211,    76,
      -1,  1999,   215,    -1,  2002,  2003,    -1,    -1,    -1,    -1,
      -1,  2505,  3433,    90,    -1,    -1,    -1,    -1,    -1,    -1,
    3441,    98,   235,   236,    -1,    -1,   103,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   248,    -1,   295,  3205,  2533,
      -1,    -1,  3463,    -1,    -1,   565,    -1,    -1,  2046,  2543,
      -1,    -1,  2050,    -1,    -1,    -1,  2054,  3478,    -1,    -1,
    2554,    -1,    -1,    -1,    -1,    -1,  2064,    -1,  3235,   282,
      -1,  2069,    -1,    -1,  2568,    -1,    -1,    -1,  3499,   337,
      -1,    -1,   295,    -1,    -1,   343,    -1,    -1,    -1,    -1,
     348,    -1,    -1,    -1,    -1,    -1,  1338,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3526,    -1,  2601,    -1,    -1,
      -1,  2605,    -1,    -1,    -1,   373,   374,  2115,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   385,    -1,    -1,
      -1,    -1,   390,    -1,   211,    -1,    -1,    -1,   215,    -1,
      -1,   399,    -1,   356,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,
    2158,  2655,    -1,    -1,    -1,    -1,    -1,    -1,  2166,  2167,
      -1,   248,  2170,    -1,  2172,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2678,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     720,    -1,   279,    -1,   724,   282,    -1,    -1,   728,    -1,
     423,  2705,   732,    -1,  2212,    -1,    -1,    -1,   295,    -1,
     297,   434,   435,   436,    -1,   438,   439,   440,   441,   442,
     443,    -1,    -1,    -1,    -1,  2729,    -1,    -1,    -1,  1481,
      -1,    -1,   762,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,    -1,    -1,   103,   356,
      -1,   801,  1425,    -1,   804,    -1,    -1,    -1,    -1,    -1,
     810,    -1,    -1,  3460,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1425,    76,    -1,    -1,    -1,  1452,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1466,    -1,    -1,    -1,    98,    -1,    -1,
      -1,  1452,   103,    -1,    -1,    -1,  2334,    -1,  2336,    -1,
    2338,    -1,    -1,    -1,    -1,  1466,   423,  3514,  2842,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   434,   435,   436,
      -1,   438,   439,   440,   441,   442,   443,  1510,    -1,    -1,
      76,   448,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1623,  1525,   903,  1626,    -1,   211,    -1,   908,  1510,
     215,   911,    98,    -1,    -1,    -1,    -1,   103,    -1,  1542,
      -1,    -1,    -1,   923,  1525,    -1,    -1,   178,    -1,    -1,
     235,   236,    -1,   933,    -1,    -1,    -1,    -1,  1660,  1661,
      -1,  1542,    -1,   248,  1567,    -1,    -1,    -1,  2922,    -1,
    1672,    -1,    -1,    -1,    -1,  2433,    -1,    -1,    -1,    -1,
     211,    -1,    -1,    -1,   215,    -1,  1567,    -1,    -1,    -1,
      -1,  2449,    -1,    -1,   279,    -1,    -1,   282,  2456,  2457,
      -1,    -1,  2956,    -1,   235,   236,    -1,  1610,    -1,    -1,
     295,    -1,   297,    -1,    -1,    -1,  1619,   248,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1610,
    2488,    -1,  2490,  2491,    -1,    -1,    -1,    -1,  1619,    -1,
      -1,  2499,    -1,    -1,    -1,   211,    -1,  2505,    -1,   215,
      -1,   282,  2510,    -1,  2512,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   295,  2523,  2524,    -1,    -1,   235,
     236,   356,    -1,    -1,    -1,  2533,  1778,    -1,    -1,    -1,
      -1,    -1,   248,    -1,    -1,    -1,  1066,  1067,    -1,    -1,
      -1,  1071,    -1,    -1,    -1,    -1,    -1,  1077,    -1,    -1,
      -1,    -1,    -1,    -1,  3058,    -1,    -1,    -1,  2566,  2567,
      -1,    -1,    -1,   279,    -1,    -1,   282,  1097,    -1,  2577,
      -1,    -1,    -1,    -1,    -1,   356,    -1,    -1,    -1,   295,
      -1,    -1,    -1,    -1,    -1,  1837,    -1,    -1,   423,    -1,
      -1,    -1,  1122,    -1,    -1,    -1,  1749,    -1,    -1,   434,
     435,   436,    -1,   438,   439,   440,   441,   442,   443,    -1,
      -1,    -1,    -1,   448,    -1,    -1,    -1,    -1,  1749,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     356,    -1,   423,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2662,    -1,    -1,   438,   439,   440,
     441,   442,   443,    -1,  2672,     3,    76,    -1,    -1,    -1,
      -1,     9,    -1,    -1,    -1,    -1,    -1,    -1,    16,    -1,
      18,    -1,  1212,    21,    -1,    -1,    -1,    -1,    98,    -1,
      -1,    -1,    -1,   103,    32,    -1,    -1,    -1,    -1,    -1,
      -1,  3205,    -1,    -1,    -1,    -1,    -1,   423,  2716,  1239,
      -1,    -1,    50,    51,    -1,    -1,    -1,    -1,   434,   435,
     436,    -1,   438,   439,   440,   441,   442,   443,    -1,    -1,
      -1,  3235,    -1,  1263,  1264,    -1,  1266,    -1,    -1,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,
      88,    89,    -1,    -1,  1284,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   102,    -1,    -1,  2019,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   121,    -1,   123,   124,    -1,    -1,    -1,
     128,   129,    -1,    -1,  1947,  1948,    -1,  1327,    -1,   137,
     138,   211,    -1,    -1,    -1,   215,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   151,    -1,   153,  1947,  1948,   156,    -1,
      -1,    -1,    -1,    -1,   162,   235,   236,  1357,    -1,    -1,
    1360,  1361,    -1,   171,    -1,  2087,    -1,    -1,   248,   177,
      84,  1371,  1372,  1373,   182,    -1,   184,  2855,  2856,    -1,
     188,    95,    -1,    -1,    -1,    -1,    -1,  2109,    -1,    -1,
      -1,   199,    -1,   201,    -1,  2117,    -1,    -1,    -1,    -1,
      -1,   115,   282,    -1,  2882,    -1,    -1,    -1,    -1,  2887,
    2888,  2889,  2890,  2891,    -1,   295,  1416,  2895,    -1,   227,
      -1,   135,  2045,  1423,    -1,  1425,    -1,    -1,    -1,  1429,
      -1,    -1,    -1,  1433,    -1,    -1,    -1,   151,    -1,  2062,
      -1,    -1,   250,   251,  2045,    -1,    -1,    -1,   256,    -1,
      -1,    -1,  1452,    -1,    -1,   169,   264,    -1,    -1,    -1,
      -1,  2062,    -1,    -1,    -1,    -1,  1466,    -1,  1468,    -1,
      -1,  2949,    -1,   281,    -1,    -1,   356,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   198,    -1,  3460,    -1,    -1,    -1,
     204,    -1,    -1,    -1,  1494,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   311,   218,    -1,    -1,    -1,    -1,    -1,
    1510,    -1,    -1,   321,    -1,  2993,   324,    -1,   326,    -1,
      -1,    -1,   330,    -1,    -1,  1525,    -1,   335,    -1,    -1,
     338,    -1,    -1,    -1,   342,    -1,    -1,    -1,    -1,   347,
    3514,    -1,  1542,   423,   352,    -1,    -1,   355,    -1,    -1,
      -1,    -1,    -1,   361,    -1,   435,   436,    -1,   438,   439,
     440,   441,   442,   443,    -1,    -1,    -1,  1567,    -1,    -1,
    1570,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     388,   295,   390,    -1,    -1,    -1,    -1,    -1,   396,   303,
     398,    -1,    -1,   401,    -1,  2317,   404,    -1,    -1,    -1,
      -1,    -1,   316,  3081,  3082,  1605,    -1,  1607,    -1,    -1,
    1610,    -1,  1612,  3091,    -1,    -1,    -1,    -1,    -1,  1619,
      -1,    -1,    -1,   337,    -1,    -1,  3104,   341,    -1,   343,
      -1,    -1,  3110,  3111,   348,    -1,    -1,  3115,  3116,   447,
      -1,    -1,  3120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1657,    -1,   373,
     374,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   385,    -1,    -1,    -1,    -1,   390,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   399,    -1,    -1,  1688,  1689,
      -1,    -1,    -1,    -1,   408,    -1,  1696,    -1,    -1,  1699,
    1700,    -1,    -1,  3181,    -1,    -1,    -1,    -1,  1708,    -1,
      -1,  1711,  1712,    -1,    -1,    -1,    -1,    -1,    -1,  1719,
      -1,    -1,    -1,  1723,  1724,  1725,  1726,    -1,    -1,    -1,
      -1,    -1,    -1,  1733,  1734,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1749,
    1750,  1751,    -1,    -1,  1754,    -1,    -1,    -1,  1758,    -1,
    2383,    -1,  1762,    -1,    -1,  1765,  1766,  1767,  1768,  1769,
    1770,  1771,  1772,  1773,    -1,  1775,    -1,    -1,    -1,  1779,
      -1,    -1,  2383,  1783,    -1,    -1,    -1,    -1,  2411,  2412,
      -1,  2414,    -1,    -1,    -1,  3273,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    76,    -1,  2429,    -1,  2431,    -1,
    2411,  2412,    -1,  2414,    -1,    -1,    92,  2539,    -1,    -1,
      -1,    -1,    -1,  2545,    -1,    -1,    98,  1827,  2429,    -1,
    2431,   103,    -1,    -1,    -1,    -1,  2459,    -1,   114,  1839,
      -1,    -1,  2564,    -1,    -1,  3323,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2459,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2489,    -1,    -1,  1869,
      76,  1871,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2505,    -1,    90,  2607,    -1,  2609,  2489,    -1,
      -1,    -1,    98,    -1,    -1,    -1,    -1,   103,    -1,    -1,
      -1,    -1,    -1,    -1,  2505,    -1,   178,    -1,    -1,    -1,
    2533,    -1,    -1,    -1,  1914,    -1,    -1,    -1,    -1,  2641,
    2543,    -1,    -1,    -1,    -1,    -1,   202,    -1,    -1,  1929,
      -1,  2554,  2533,   209,    -1,   211,    -1,    -1,    -1,   211,
      -1,    -1,  2543,   215,    -1,  2568,   222,  1947,  1948,    -1,
      -1,    -1,    -1,  2554,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   235,   236,    -1,    -1,  2568,    -1,    -1,
      -1,    -1,    76,    -1,    -1,    -1,   248,    -1,  2601,    -1,
    3458,  3459,  2605,    -1,    -1,  3463,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,    -1,   103,
    2601,    -1,    -1,   138,  2605,   211,    -1,    -1,    -1,   215,
     282,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3499,    -1,   295,  2746,  2747,    -1,    -1,    -1,   235,
     236,    -1,  2655,    -1,    -1,    -1,    -1,    -1,    -1,  2039,
      -1,    -1,   248,    -1,   179,  2045,    -1,    -1,  3526,    -1,
      -1,    -1,    -1,    -1,  2655,  2678,   191,    -1,    -1,    -1,
    2060,   196,  2062,    -1,    -1,    -1,   201,    -1,    -1,   204,
      -1,   206,    -1,   279,    -1,    -1,   282,  2678,    -1,    -1,
      -1,    -1,  2705,    -1,   356,    -1,    -1,    -1,    -1,   295,
      -1,   297,    -1,    -1,    -1,    -1,   231,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2705,    -1,  2729,   211,    -1,    -1,
      -1,   215,    -1,    -1,   249,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2127,  2729,    -1,
      -1,   235,   236,    -1,    -1,    -1,  2136,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   248,    -1,    -1,    -1,    -1,    -1,
     356,   423,    76,    -1,    -1,   290,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   298,    -1,    -1,   438,   439,   440,   441,
     442,   443,  2894,    -1,    98,   279,    -1,    -1,   282,   103,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2190,   295,    -1,   297,    -1,  2917,    -1,    -1,   333,    -1,
      -1,    -1,    -1,    -1,    -1,  2927,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2213,    -1,    -1,    -1,   423,    -1,  2842,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   434,   435,
     436,    -1,   438,   439,   440,   441,   442,   443,   373,    -1,
      -1,  2842,   448,    -1,    -1,  2245,    -1,    -1,  2248,    -1,
      -1,    -1,   356,    -1,   178,    -1,    -1,    -1,   393,    -1,
    2260,  2261,  2262,  2263,    -1,    -1,    -1,    -1,    -1,  2269,
      -1,    -1,    -1,    -1,    -1,    -1,   411,    -1,    -1,  2279,
    2280,    -1,  2282,   418,   419,   420,    -1,   211,    -1,    -1,
      -1,   215,    -1,    -1,  2294,    -1,  2296,    -1,    -1,  2922,
    2300,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   235,   236,   448,   449,   450,    -1,    -1,    -1,   423,
      -1,  2922,    -1,  2323,   248,  2325,  2326,    -1,    -1,    -1,
     434,   435,   436,  2956,   438,   439,   440,   441,   442,   443,
      -1,    -1,    -1,    -1,   448,    -1,  2346,    -1,  3070,  3071,
    3072,  3073,  2352,    -1,    -1,  2956,    -1,    -1,   282,    -1,
    2360,  2361,  2362,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   295,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2383,    -1,    -1,    -1,    -1,    76,    -1,
      -1,    -1,    -1,    -1,  2394,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,  2411,  2412,    -1,  2414,   103,    -1,    -1,    -1,    -1,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2429,
      -1,  2431,   356,    -1,    90,  3058,    -1,    -1,    94,    -1,
      -1,    -1,    98,    -1,   720,    -1,    -1,   103,    -1,    -1,
      -1,    -1,   728,    -1,    -1,    -1,   732,  3058,    -1,  2459,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   762,    -1,    -1,  2489,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   423,
      -1,    -1,    -1,    -1,  2504,  2505,    -1,    -1,    -1,   165,
      -1,    -1,    -1,    -1,   438,   439,   440,   441,   442,   443,
      -1,    -1,    -1,   211,    -1,    -1,    -1,   215,   804,    -1,
      -1,    -1,  2532,  2533,   810,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2543,    -1,    -1,    -1,   235,   236,    -1,
      -1,    -1,    -1,    -1,  2554,   211,    -1,    -1,    -1,   215,
     248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2568,    -1,
    3292,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   235,
     236,    -1,  3205,    -1,  2584,    -1,    -1,    -1,  2588,    -1,
    3312,   279,   248,    -1,   282,    -1,    -1,    -1,    -1,    -1,
      -1,  2601,    -1,    -1,  3205,  2605,    -1,   295,    -1,   297,
      -1,    -1,  3235,  3335,    -1,    -1,    84,    -1,    -1,    -1,
      -1,  2621,    -1,   279,    -1,    -1,   282,   903,    -1,    -1,
      -1,    -1,   908,    -1,  3235,   911,    -1,    -1,    -1,   295,
      -1,   297,    -1,    -1,    -1,  3367,  2646,    -1,    -1,    -1,
      -1,    -1,  2652,    -1,    76,  2655,    -1,   933,    -1,    -1,
      -1,    -1,    -1,    -1,  2664,    -1,    -1,    -1,   356,    -1,
    2670,    -1,    -1,    -1,  2674,    -1,    98,    -1,  2678,  2679,
      76,   103,  2682,  2683,  2684,  2685,  2686,  2687,  2688,  2689,
    2690,  2691,   160,    -1,    90,    -1,  2696,  2697,    -1,    -1,
     356,    -1,    98,    -1,    -1,  2705,    -1,   103,    -1,    -1,
    2710,    -1,   180,    -1,   182,    -1,    -1,  2717,    -1,    -1,
    2720,    -1,  2722,    -1,    -1,    -1,    -1,    -1,    -1,  2729,
    2730,  2731,  2732,    -1,    -1,   423,  2736,    -1,    -1,  2739,
      -1,    -1,    -1,    76,   400,    -1,   434,   435,   436,    -1,
     438,   439,   440,   441,   442,   443,   178,    90,    -1,    -1,
     448,    -1,    -1,    -1,    -1,    98,    -1,   423,    -1,    -1,
     103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   434,   435,
     436,    -1,   438,   439,   440,   441,   442,   443,    -1,   211,
    1066,  1067,    -1,   215,    -1,  1071,    -1,    -1,    -1,    -1,
      -1,  1077,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   235,   236,   211,    -1,    -1,    -1,   215,
      -1,  1097,    -1,    -1,    -1,    -1,   248,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3460,    -1,   235,
     236,    -1,  2842,    -1,    -1,    -1,  1122,    -1,    -1,    -1,
      -1,    -1,   248,    -1,    -1,    -1,    -1,    -1,   191,  3460,
     282,    -1,    -1,   196,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   295,    -1,    -1,    -1,    -1,   211,    -1,
      -1,    -1,   215,   279,    -1,    -1,   282,    -1,    -1,    -1,
      -1,  3514,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   295,
      -1,   297,   235,   236,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2911,    -1,  3514,    -1,   248,    -1,    -1,    -1,    -1,
      -1,    -1,  2922,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   356,    -1,  1212,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   279,    -1,    -1,   282,
      -1,    -1,    76,    -1,    -1,    -1,  2956,    -1,    -1,    -1,
     356,    -1,   295,  1239,   297,    -1,    90,    -1,    -1,    93,
    2970,    -1,    -1,    -1,    98,  2975,    -1,    -1,  2978,   103,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1263,  1264,    -1,
    1266,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   423,    -1,    -1,   400,    -1,    -1,    -1,  1284,    -1,
      -1,  3011,    -1,    -1,    -1,    -1,   438,   439,   440,   441,
     442,   443,    -1,   356,    -1,    -1,    -1,   423,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   434,   435,
     436,    -1,   438,   439,   440,   441,   442,   443,    -1,    -1,
      -1,    -1,  3052,  3053,    -1,    -1,    -1,  3057,  3058,    -1,
      -1,    -1,    -1,    -1,  3064,  3065,    -1,    -1,  3068,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1357,    -1,    -1,  1360,  1361,    -1,   211,    -1,    -1,
     423,   215,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   434,   435,   436,    -1,   438,   439,   440,   441,   442,
     443,   235,   236,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   248,    -1,    -1,    -1,   140,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3142,    -1,    -1,    -1,    -1,    -1,    -1,  1425,
      -1,    -1,    -1,  1429,    -1,   279,    -1,  1433,   282,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   179,    -1,    -1,
      -1,   295,    -1,   297,    -1,   187,  1452,    -1,    -1,    -1,
    3180,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1466,    -1,  1468,    -1,    -1,    -1,  3196,    -1,    -1,    -1,
    3200,    -1,    -1,    -1,    -1,  3205,    -1,    -1,    -1,    -1,
      -1,   223,   224,    -1,    -1,    -1,    -1,    -1,  1494,    -1,
      -1,    -1,    -1,    -1,  3224,    -1,    -1,  3227,    -1,    -1,
      -1,    -1,   356,    -1,  1510,  3235,  3236,  3237,    -1,    -1,
    3240,    -1,    -1,    -1,    -1,    -1,    -1,  3247,  3248,  1525,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1542,    -1,    -1,    -1,
      -1,  3271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   757,
    3290,  1567,    -1,    -1,  1570,    -1,    -1,    -1,    -1,   423,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     434,   435,   436,    -1,   438,   439,   440,   441,   442,   443,
      -1,    -1,    -1,    -1,    -1,    -1,  3326,  3327,    -1,  1605,
      -1,  1607,    -1,    -1,  1610,    -1,  1612,    -1,    -1,    -1,
      -1,    -1,    -1,  1619,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3353,  3354,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   833,    -1,   835,    -1,   837,
      -1,    -1,    -1,    -1,    76,   843,   844,    -1,    -1,    -1,
      -1,  1657,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,
      -1,    93,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,
      -1,   103,    -1,   871,    -1,    -1,    -1,    -1,  3408,    -1,
      -1,    -1,  1688,  1689,    -1,    -1,    -1,    -1,    -1,    -1,
    1696,    -1,    -1,  1699,  1700,    -1,    -1,    -1,    -1,    -1,
     898,    -1,    -1,    -1,    -1,  1711,  1712,    -1,    -1,    -1,
      -1,   909,   910,  1719,    -1,    -1,    -1,  1723,  1724,  1725,
    1726,    -1,    -1,    -1,    -1,    -1,    -1,  1733,  1734,    -1,
    3460,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1749,  1750,  1751,    -1,  3477,  1754,    -1,
      -1,    -1,  1758,    -1,    -1,    -1,  1762,    -1,    -1,  1765,
    1766,  1767,  1768,  1769,  1770,  1771,  1772,  1773,    -1,  1775,
      -1,   969,    -1,  1779,    -1,    -1,    -1,  1783,    -1,   211,
      -1,  3511,    -1,   215,  3514,    -1,    -1,    -1,   986,   987,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     998,    -1,    -1,   235,   236,    -1,    -1,    -1,    -1,    76,
      -1,    -1,    -1,    -1,    -1,    -1,   248,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,  1839,    -1,    -1,   103,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   279,    -1,    -1,
     282,    -1,    -1,     2,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   295,    -1,   297,    -1,    -1,    90,    -1,
      -1,    93,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,
      -1,   103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1094,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1914,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1929,   356,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    -1,
      -1,  1947,  1948,    -1,   211,    76,    -1,    -1,   215,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      -1,    -1,  1160,    -1,    -1,    -1,    -1,    98,   235,   236,
      -1,    -1,   103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   248,    -1,    -1,    -1,    -1,   728,    -1,    -1,   211,
     732,   423,   734,   215,    -1,    -1,    -1,   739,   740,   148,
      -1,    -1,   434,   435,   436,    -1,   438,   439,   440,   441,
     442,   443,   279,   235,   236,   282,    -1,    -1,   760,    -1,
     762,    -1,    -1,    -1,    -1,    -1,   248,    -1,   295,    -1,
     297,   180,    -1,  2039,    -1,    -1,    -1,    -1,    -1,  2045,
     307,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2060,    -1,  2062,   279,    -1,    -1,
     282,   803,   804,    -1,    -1,   196,    -1,    -1,   810,    -1,
    1268,    -1,    -1,   295,    -1,   297,    -1,    -1,    -1,    -1,
     211,  1279,    -1,    -1,   215,    -1,    -1,    -1,    -1,   356,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   235,   236,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   248,    -1,   861,
      -1,  2127,    -1,    -1,    -1,   867,  1324,    -1,    -1,  1327,
    2136,  1329,  1330,    -1,   356,    -1,   878,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   279,    -1,
      -1,   282,    -1,    -1,    -1,    -1,   423,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   295,   907,   297,   434,   435,   436,
      -1,   438,   439,   440,   441,   442,   443,    -1,    -1,    -1,
     922,    -1,    -1,    -1,  2190,   927,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1393,    -1,    -1,    -1,   941,
      -1,   423,    -1,    -1,    -1,    -1,    -1,  2213,    -1,    -1,
      -1,    -1,   434,   435,   436,    -1,   438,   439,   440,   441,
     442,   443,    -1,    -1,    -1,   356,    76,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2245,
      90,    -1,  2248,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,    -1,    -1,   103,  2260,  2261,  2262,  2263,    -1,    -1,
      -1,    -1,    -1,  2269,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2279,  2280,    -1,  2282,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2294,    -1,
    2296,    -1,   423,    -1,  2300,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   434,   435,   436,    -1,   438,   439,   440,
     441,   442,   443,    -1,  1512,    -1,    -1,  2323,    -1,  2325,
    2326,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1070,  1071,
      -1,    -1,    -1,    -1,    -1,  1077,    -1,    -1,    -1,    -1,
    2346,    -1,    -1,    -1,    -1,    -1,  2352,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2360,  2361,  2362,    -1,    -1,    -1,
      -1,   211,    -1,    -1,    -1,   215,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1116,  1117,  1118,  2383,    -1,    -1,
    1122,    -1,    -1,    -1,    -1,   235,   236,    -1,  2394,  1587,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   248,  1597,
      -1,    -1,    -1,    -1,    -1,  2411,  2412,    -1,  2414,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   565,    -1,    -1,    -1,
      -1,    -1,    -1,  2429,    -1,  2431,    -1,    -1,    -1,   279,
      -1,    -1,   282,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1184,    -1,    -1,   295,    -1,   297,    -1,    -1,
      -1,    -1,    -1,  2459,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2489,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2505,
      -1,    -1,    -1,  1701,  1702,  1703,   356,    -1,    -1,    -1,
    1708,  1709,    -1,   179,    -1,  1713,  1714,    -1,    -1,    -1,
      -1,    -1,  1720,    -1,    -1,   191,  2532,  2533,   378,    -1,
     196,  1729,    -1,  1731,    -1,   201,    -1,  2543,   204,    -1,
     206,    -1,    -1,    -1,    -1,    -1,    -1,  1745,  2554,  1747,
      -1,   700,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2568,    -1,    -1,   231,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   423,    -1,    -1,    -1,    -1,  2584,    -1,
      -1,    -1,  2588,   249,   434,   435,   436,    -1,   438,   439,
     440,   441,   442,   443,    -1,  2601,  1338,    -1,    -1,  2605,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   757,    -1,
    1808,    -1,    -1,    -1,    -1,  2621,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   290,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   298,    -1,    -1,  1097,    -1,    -1,    -1,    -1,
    2646,    -1,    -1,    -1,    -1,    -1,  2652,    -1,    -1,  2655,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2664,    -1,
      -1,    -1,    -1,    -1,  2670,    -1,    -1,   333,  2674,    -1,
      -1,    -1,  2678,  2679,    -1,    -1,  2682,  2683,  2684,  2685,
    2686,  2687,  2688,  2689,  2690,  2691,    -1,    -1,  1886,    -1,
    2696,  2697,    -1,    -1,  1892,    -1,    -1,    -1,    -1,  2705,
      -1,  1899,    -1,    -1,  2710,    -1,    -1,   373,    -1,    -1,
      -1,  2717,    -1,    -1,  2720,    -1,  2722,    -1,    -1,    -1,
      -1,    -1,   871,  2729,  2730,  2731,  2732,   393,    -1,    -1,
    2736,    -1,    -1,  2739,    -1,    -1,    -1,    -1,    -1,  1481,
      -1,    -1,    -1,    -1,    -1,   411,    -1,    -1,  1490,   898,
      -1,    -1,   418,   419,   420,    -1,    -1,    -1,    -1,    -1,
     909,   910,    -1,    -1,    -1,    94,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   104,    -1,    -1,    -1,   445,
      -1,    -1,   448,   449,   450,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1991,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1999,    -1,    -1,  2002,  2003,    -1,    -1,    -1,    -1,
     139,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     149,    -1,    -1,   152,    -1,    -1,    -1,   156,    -1,    -1,
      -1,   160,    -1,    -1,    -1,    -1,  2842,   986,   987,    -1,
      -1,   990,   991,    -1,   993,    -1,    -1,    -1,  2046,   998,
      -1,    -1,  2050,   182,    -1,    -1,  2054,    -1,    -1,    -1,
      -1,    -1,    -1,  1605,    -1,  1607,  2064,    -1,   197,    -1,
    1612,  2069,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1623,    -1,    -1,  1626,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2911,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1657,  2922,  2115,  1660,  1661,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1672,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1094,    -1,    -1,    -1,    -1,
    2956,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2158,    -1,    -1,  1425,  2970,    -1,    -1,    -1,    -1,  2975,
      -1,    -1,  2978,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1452,    -1,    -1,    -1,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1466,  3011,    -1,    -1,    90,    -1,
      -1,  1160,    -1,    -1,  2212,    -1,    98,    -1,    -1,    -1,
      -1,   103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1778,    -1,    -1,    -1,
      -1,    -1,   371,    -1,    -1,    -1,  3052,  3053,  1510,    -1,
      -1,  3057,  3058,    -1,    -1,    -1,    -1,    -1,  3064,  3065,
      -1,    -1,  3068,  1525,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1542,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1837,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1567,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1268,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   211,
    1279,    -1,    -1,   215,    -1,    -1,  3142,    -1,  2336,    -1,
    2338,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1610,    -1,
      -1,    -1,    -1,   235,   236,    -1,    -1,  1619,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   248,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3180,  1324,    -1,    -1,  1327,    -1,
    1329,  1330,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3196,    -1,    -1,    -1,  3200,    -1,    -1,   279,    -1,  3205,
     282,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   295,    -1,   297,    -1,    -1,  3224,    -1,
      -1,  3227,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3235,
    3236,  3237,    -1,    -1,  3240,  2433,    -1,    -1,    -1,    -1,
      -1,  3247,  3248,    -1,  1393,    -1,    -1,    -1,    -1,    -1,
      -1,  2449,    -1,  1402,    -1,    -1,    -1,  1406,  2456,  2457,
      -1,    -1,    -1,    -1,    -1,  3271,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   356,    -1,    -1,  2019,    -1,   608,
     609,    -1,    -1,    -1,  3290,    -1,    -1,  1749,    -1,    -1,
    2488,    -1,  2490,  2491,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2499,    -1,    -1,    -1,    -1,    -1,  2505,    -1,    -1,
      -1,    -1,  2510,    -1,  2512,    -1,    -1,    -1,    -1,    -1,
    3326,  3327,    -1,    -1,    -1,  2523,  2524,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2533,    -1,    -1,    -1,    -1,
      -1,   423,    -1,    -1,    -1,  2087,    -1,  3353,  3354,    -1,
      -1,    -1,   434,   435,   436,    -1,   438,   439,   440,   441,
     442,   443,    -1,    -1,    -1,    -1,    -1,  2109,  2566,  2567,
      -1,    -1,    -1,    -1,    -1,  2117,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2127,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3408,    -1,    -1,    -1,   735,    -1,    -1,   738,
      -1,    -1,   741,   742,    84,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   763,    -1,    -1,    -1,  1587,    -1,
      -1,    -1,    -1,    -1,    -1,   115,    -1,   776,    -1,    -1,
     779,    -1,    -1,    -1,  3460,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   133,  2662,   135,    -1,   796,   797,    -1,
      -1,  3477,    -1,    -1,  2672,    -1,   805,    -1,    -1,    -1,
      -1,   151,    -1,    -1,    -1,  1947,  1948,   157,   817,    -1,
      -1,    -1,   821,   822,    -1,   202,    -1,    -1,    -1,   169,
      -1,    -1,   209,    -1,   211,  3511,    -1,    -1,  3514,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   845,   846,  2716,    -1,
      -1,    -1,    -1,   852,    -1,    -1,    -1,    -1,   198,    -1,
     200,    -1,    -1,    -1,   204,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   874,    -1,   876,   218,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1708,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,    -1,    -1,  2317,   905,    -1,    -1,    -1,
      -1,  2323,   252,  2045,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2062,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   295,    -1,   297,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   316,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2855,  2856,  1808,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   337,    -1,    -1,
      -1,   341,    -1,   343,    -1,    -1,    -1,  1006,    -1,    -1,
    1009,    -1,    -1,  1012,  2882,    -1,    -1,    -1,    -1,  2887,
    2888,  2889,  2890,  2891,    -1,    -1,    -1,  2895,    -1,    -1,
      -1,    -1,    -1,    -1,   374,   375,    -1,   377,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   385,    -1,    -1,    -1,   389,
     390,    -1,    -1,    -1,   394,    -1,    -1,    -1,    -1,   399,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1892,    -1,    -1,    -1,    -1,    -1,    -1,
    1899,  2949,  1901,  1082,  1903,    -1,    -1,    -1,  1087,    -1,
      -1,    -1,  1091,    -1,    -1,    -1,    -1,    -1,    -1,  1098,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1123,    -1,    -1,  2539,    -1,    -1,
      -1,    -1,    -1,  2545,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2564,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1988,
      -1,    -1,  2584,    -1,    -1,    -1,  2588,  1176,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1190,    -1,    -1,    -1,  2607,    -1,  2609,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2621,
      -1,    -1,    -1,    -1,  3082,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3091,    -1,    -1,    -1,  2046,    -1,  2641,
      -1,  2050,    -1,    -1,    -1,  2054,  3104,    -1,    -1,    -1,
      -1,    -1,  3110,  3111,    -1,  2064,    -1,  3115,  3116,    -1,
      -1,  2383,  3120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2411,
    2412,  2100,  2414,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2115,  2429,    -1,  2431,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3181,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2459,    -1,    -1,
      -1,    -1,    -1,    -1,  2746,  2747,    -1,    -1,    -1,  2158,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   728,    -1,    -1,    -1,   732,    -1,  2489,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2505,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   762,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2533,    -1,    -1,    -1,  3273,    -1,    -1,    -1,    -1,
      -1,  2543,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1418,
      -1,    -1,  2554,    -1,    -1,    -1,    -1,   804,    -1,    -1,
      -1,    -1,    -1,   810,    -1,    -1,  2568,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3323,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2601,
      -1,    -1,    -1,  2605,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2894,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2917,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2927,    -1,    -1,    -1,  2338,
      -1,    -1,    -1,  2655,    -1,    -1,   903,    -1,    -1,    -1,
      -1,   908,    -1,    -1,   911,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2678,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   933,    -1,  2970,    -1,
      -1,    -1,    -1,  2975,    -1,    -1,  2978,    -1,    -1,    -1,
      -1,    -1,    -1,  2705,    -1,    -1,    -1,  1576,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3458,  3459,    -1,    -1,    -1,    -1,    -1,  2729,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2434,  1615,    -1,    -1,    -1,
      -1,    -1,  2441,  1622,  2443,  1624,  1625,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1638,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3070,  3071,
    3072,  3073,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2488,
      -1,  2490,  2491,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2499,    -1,    -1,    -1,  1097,    -1,  2505,    -1,    -1,  1066,
      -1,    -1,    -1,  2512,  1071,    -1,    -1,    -1,    -1,    -1,
    1077,    -1,    -1,    -1,  2523,  2524,    -1,    -1,    -1,    -1,
    2842,    -1,    -1,    -1,  2533,    -1,    -1,    -1,    -1,    -1,
    1097,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1122,    -1,  2566,  2567,    -1,
      -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    19,    -1,  3180,    -1,
      -1,    -1,    -1,    -1,    -1,    28,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1784,    39,    40,  3200,    -1,
    2922,  1097,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,  2956,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1212,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1239,    -1,   117,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3290,    -1,
    3292,    -1,    -1,    -1,    -1,    -1,  1263,  1264,    -1,  1266,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2716,    -1,  1898,
    3312,    -1,    -1,    -1,    -1,    -1,    -1,  1284,    -1,    -1,
      -1,    -1,    -1,  1912,  3326,    -1,    -1,    -1,    -1,    -1,
      -1,  1920,    -1,  3335,    -1,    -1,  3058,  1926,    -1,    -1,
      -1,    -1,  1931,    -1,    -1,    -1,    -1,   190,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3367,   209,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1963,    -1,  1965,    -1,    -1,  1968,
      -1,    -1,    -1,    -1,    -1,    -1,   229,    -1,    -1,    -1,
    1357,    -1,    -1,  1360,  1361,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3408,    -1,  1997,  1998,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   260,    -1,    -1,
     263,    -1,  1425,    -1,  2013,  2014,  2015,    -1,  2017,    -1,
      -1,  2020,  2021,  2022,    -1,    -1,    -1,  2026,    -1,    -1,
    2029,   284,    -1,    -1,    -1,    -1,  2855,  2856,    -1,  1452,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1425,    -1,
      -1,    -1,    -1,  1466,    -1,    -1,  1433,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3477,    -1,    -1,  2887,  2888,
    2889,  2890,  2891,  3205,    -1,  1452,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1466,
      -1,  1468,   345,    -1,    -1,    -1,    -1,  1510,    -1,  3511,
      -1,    -1,    -1,  3235,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1525,    -1,    -1,    -1,    -1,  1494,    -1,  1425,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   381,  1542,
    2949,    -1,    -1,  1510,    -1,    -1,    -1,    -1,    -1,    -1,
     393,    -1,    -1,    -1,    -1,    -1,  1452,    -1,  1525,    -1,
      -1,    -1,   405,    -1,  1567,    -1,    -1,    -1,    -1,    -1,
    1466,    -1,    -1,   416,    -1,  1542,    -1,  2166,   421,   422,
      -1,   424,    -1,    -1,    -1,    -1,    -1,   430,   431,    -1,
     433,   434,    -1,    -1,    -1,   438,   439,   440,   441,   442,
    1567,    -1,   445,   446,   447,    -1,    -1,  1610,   451,    -1,
      -1,  2200,   455,    -1,  1510,    -1,  1619,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1525,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1605,    -1,
    1607,    -1,    -1,  1610,    -1,  1612,  1542,    -1,    -1,    -1,
      -1,    -1,  1619,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1567,  3081,  3082,    -1,    -1,    -1,    -1,    -1,    -1,
    3089,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1657,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3110,  3111,    -1,    -1,    -1,  3115,  3116,  3117,    -1,
      -1,  3120,  3121,    -1,  1610,    -1,    -1,    -1,    -1,    -1,
      -1,  1688,  1689,  1619,    -1,    -1,    -1,    -1,    -1,  1696,
      -1,    -1,  1699,  1700,    -1,    -1,    -1,    -1,  3460,    -1,
      -1,    -1,    -1,    -1,  1711,  1712,  1749,    -1,    -1,    -1,
      -1,    -1,  1719,    -1,    -1,    -1,  1723,  1724,  1725,  1726,
      -1,    -1,    -1,    -1,    -1,    -1,  1733,  1734,    -1,    -1,
      -1,    -1,  3181,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1749,  1750,    -1,    -1,    -1,  1754,    -1,    -1,
      -1,  1758,  3514,    -1,    -1,  1762,  2385,  2386,  1765,  1766,
    1767,  1768,  1769,  1770,  1771,  1772,  1773,    -1,  1775,    -1,
      -1,    -1,  1779,    -1,    -1,    -1,  1783,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2418,
    2419,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1749,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3273,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1839,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   728,    -1,    -1,    -1,   732,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3323,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   762,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2525,  2526,  2527,    -1,
      -1,    -1,    -1,    -1,  1947,  1948,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1929,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     804,    -1,    -1,  2562,    -1,    -1,   810,    -1,    -1,    -1,
    1947,  1948,    -1,    -1,    -1,    -1,    -1,    -1,  2577,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2045,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1947,  1948,    -1,    -1,    -1,    -1,    -1,    -1,  2062,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   903,
      -1,    -1,  2039,    -1,    -1,    -1,    -1,    -1,  2045,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2060,    -1,  2062,    -1,    -1,    -1,   933,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2045,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2127,    -1,    -1,    -1,    -1,    -1,  2062,    -1,    -1,  2136,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2190,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1066,    -1,    -1,    -1,    -1,  1071,    -1,    -1,
      -1,    -1,    -1,  1077,    -1,    -1,  2213,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2846,  2847,    -1,
      -1,    -1,    -1,  1097,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2245,    -1,
      -1,  2248,    -1,    -1,    -1,    -1,    -1,    -1,  1122,    -1,
      -1,    -1,    -1,  2260,  2261,  2262,  2263,    -1,    -1,    -1,
      -1,    -1,  2269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2279,  2280,    -1,  2282,    -1,    -1,    -1,    -1,
      -1,  2910,    -1,    -1,    -1,    -1,    -1,  2294,    -1,  2296,
      -1,    -1,    -1,  2300,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2323,    -1,  2325,  2326,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1212,  2346,
    2383,    -1,    -1,    -1,    -1,  2352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2360,  2361,  2362,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1239,    -1,    -1,  2411,  2412,
      -1,  2414,    -1,    -1,    -1,    -1,  2383,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2429,  2394,  2431,  1263,
    1264,    -1,  1266,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2411,  2412,    -1,  2414,    -1,    -1,
    1284,    -1,    -1,    -1,    -1,    -1,  2459,    -1,    -1,    -1,
      -1,    -1,  2429,    -1,  2431,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2489,  2383,    -1,    -1,
      -1,    -1,  2459,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2505,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3099,    -1,    -1,    -1,    -1,  2411,  2412,    -1,  2414,    -1,
      -1,    -1,  2489,  1357,    -1,    -1,  1360,  1361,    -1,    -1,
    2533,    -1,    -1,  2429,    -1,  2431,    -1,    -1,  2505,    -1,
    2543,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2554,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2459,    -1,  2568,  2533,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2543,    -1,  3167,    -1,
      -1,    -1,    -1,    -1,    -1,  3174,    -1,  2554,    -1,    -1,
      -1,  1425,    -1,  2489,    -1,    -1,    -1,    -1,  2601,    -1,
      -1,  2568,  2605,    -1,    -1,    -1,    -1,    -1,    -1,  2505,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2584,  1452,    -1,
      -1,  2588,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1466,    -1,  2601,    -1,    -1,  2533,  2605,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2543,    -1,    -1,
      -1,    -1,  2655,    -1,  2621,    -1,    -1,    -1,  2554,    -1,
      -1,    -1,    -1,    -1,  1097,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2568,    -1,    -1,  2678,  1510,    -1,    -1,  2646,
      -1,    -1,    -1,    -1,    -1,  2652,    -1,    -1,  2655,    -1,
      -1,  1525,    -1,    -1,    -1,    -1,    -1,  2664,    -1,    -1,
      -1,    -1,  2705,  2670,    -1,  2601,    -1,  2674,  1542,  2605,
      -1,  2678,  2679,    -1,    -1,  2682,  2683,  2684,  2685,  2686,
    2687,  2688,  2689,  2690,  2691,    -1,  2729,    -1,    -1,  2696,
    2697,    -1,    -1,  1567,    -1,    -1,    -1,    -1,  2705,    -1,
      -1,    -1,    -1,  2710,    -1,    -1,    -1,    -1,    -1,    -1,
    2717,    -1,    -1,  2720,    -1,  2722,    -1,    -1,    -1,  2655,
      -1,    -1,  2729,  2730,  2731,  2732,    -1,    -1,    -1,  2736,
      -1,  1605,  2739,  1607,    -1,    -1,  1610,    -1,  1612,    -1,
      -1,    -1,  2678,    -1,    -1,  1619,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   903,    -1,  3388,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2705,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1657,    -1,    -1,    -1,   933,    -1,    -1,
      -1,    -1,    -1,  2729,    -1,    -1,    -1,    -1,    -1,  2842,
      -1,    -1,    -1,    -1,  3433,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1688,  1689,    -1,    -1,    -1,    -1,
      -1,    -1,  1696,    -1,    -1,  1699,  1700,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2842,    -1,  1711,  1712,    -1,
      -1,    -1,    -1,    -1,    -1,  1719,    -1,    -1,    -1,  1723,
    1724,  1725,  1726,    -1,    -1,    -1,    -1,    -1,    -1,  1733,
    1734,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1749,  1750,    -1,    -1,  2922,
    1754,    -1,    -1,    -1,  1758,    -1,    -1,    -1,  1762,    -1,
      -1,  1765,  1766,  1767,  1768,  1769,  1770,  1771,  1772,  1773,
      -1,  1775,    -1,    -1,  2911,  1779,  2842,    -1,    -1,  1783,
      -1,    -1,    -1,  2956,    -1,  2922,    -1,    -1,    -1,    -1,
    1066,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2956,
      -1,    -1,  1425,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2970,    -1,  1839,    -1,    -1,  2975,    -1,
      -1,  2978,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1452,
      -1,    -1,    -1,    -1,    -1,    -1,  2922,    -1,    -1,    -1,
      -1,    -1,    -1,  1466,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3011,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3058,    -1,    -1,    -1,    -1,
    2956,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1510,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3052,  3053,    -1,    -1,    -1,
    3057,  3058,  1525,    -1,    -1,  1929,    -1,  3064,  3065,    -1,
      -1,  3068,    -1,    -1,    -1,    -1,  1212,    -1,    -1,  1542,
      -1,    -1,    -1,  1947,  1948,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1239,  1567,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1263,  1264,    -1,
    1266,    -1,  3058,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3142,    -1,  1610,  1284,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1619,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3205,    -1,    -1,  2039,    -1,    -1,    -1,    -1,
      -1,  2045,    -1,  3180,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2060,    -1,  2062,  3196,
      -1,    -1,  3235,  3200,    -1,    -1,    -1,    -1,  3205,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1357,    -1,    -1,  1360,  1361,    -1,  3224,    -1,    -1,
    3227,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3235,  3236,
    3237,    -1,    -1,  3240,    -1,    -1,    -1,    -1,    -1,    -1,
    3247,  3248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2127,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2136,    -1,  3271,    -1,    -1,    -1,    -1,  3205,
      -1,    -1,    -1,    -1,    -1,    -1,  1749,    -1,    -1,    -1,
      -1,    -1,    -1,  3290,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3235,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2190,    -1,    -1,  3326,
    3327,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2213,
      -1,    -1,    -1,    -1,    -1,    -1,  3353,  3354,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2245,    -1,    -1,  2248,    -1,    -1,    -1,    -1,    -1,
    1280,    -1,    -1,    -1,    -1,    -1,  2260,  2261,  2262,  2263,
      -1,    -1,    -1,    -1,    -1,  2269,    -1,    -1,    -1,    -1,
      -1,  3408,    -1,    -1,    -1,  2279,  2280,    -1,  2282,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3460,    -1,    -1,
    2294,    -1,  2296,    -1,    -1,    -1,  2300,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1347,    -1,  2323,
      -1,  2325,  2326,  3460,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3477,  3514,  2346,    -1,  1947,  1948,    -1,    -1,  2352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2360,  2361,  2362,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3511,    -1,    -1,  3514,    -1,  2383,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2394,    -1,    -1,    -1,  3460,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2411,  2412,    -1,
    2414,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1696,    -1,    -1,    -1,  1700,  2429,    -1,  2431,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2045,  1719,    -1,    -1,    -1,  1723,  3514,    -1,
    1726,    -1,    -1,    -1,    -1,  2459,    -1,  1733,  1734,  2062,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1503,  1750,    -1,    -1,    -1,  1754,    -1,
      -1,    -1,  1758,    -1,    -1,  2489,  1762,    -1,    -1,  1765,
    1766,  1767,  1768,  1769,  1770,  1771,  1772,  1773,    -1,  1775,
      -1,  2505,    -1,  1779,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2533,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2543,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2554,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1839,  2568,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2584,    -1,    -1,    -1,  2588,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2601,    -1,    -1,
      -1,  2605,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2621,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2646,    -1,    -1,    -1,    -1,    -1,  2652,    -1,
      -1,  2655,    -1,  1929,    -1,    -1,    -1,    -1,    -1,    -1,
    2664,    -1,    -1,    -1,  1694,    -1,  2670,    -1,    -1,    -1,
    2674,    -1,    -1,    -1,  2678,  2679,    -1,    -1,  2682,  2683,
    2684,  2685,  2686,  2687,  2688,  2689,  2690,  2691,  1718,    -1,
      -1,    -1,  2696,  2697,  1724,    -1,    -1,    -1,    -1,    -1,
      -1,  2705,    -1,    -1,    -1,    -1,  2710,  1737,  1738,    -1,
      -1,  1741,    -1,  2717,    -1,    -1,  2720,    -1,  2722,    -1,
      -1,    -1,    -1,    -1,    -1,  2729,  2730,  2731,  2732,    -1,
      -1,    -1,  2736,    -1,    -1,  2739,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1777,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2039,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2383,    -1,    -1,    -1,  2060,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2411,  2412,
      -1,  2414,    -1,    -1,    -1,    -1,    -1,    -1,  1848,    -1,
      -1,    -1,    -1,    -1,    -1,  1855,  2429,  1857,  2431,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2842,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2459,    -1,    -1,    -1,
    2136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2489,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2505,    -1,    -1,    -1,    -1,  2911,    -1,    -1,
      -1,    -1,    -1,    -1,  2190,    -1,    -1,    -1,  2922,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2533,    -1,    -1,    -1,    -1,    -1,    -1,  2213,    -1,    -1,
    2543,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2554,  2956,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2568,  2970,    -1,    -1,    -1,
      -1,  2975,    -1,    -1,  2978,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2260,    -1,  2262,  2263,    -1,    -1,
      -1,    -1,    -1,  2269,    -1,    -1,    -1,    -1,  2601,    -1,
      -1,    -1,  2605,    -1,    -1,    -1,    -1,  3011,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2294,    -1,
    2296,    -1,    -1,    -1,  2300,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3052,  3053,
      -1,    -1,  2655,  3057,  3058,    -1,    -1,    -1,    -1,    -1,
    3064,  3065,    -1,    -1,  3068,    -1,    -1,    -1,    -1,    -1,
    2346,    -1,    -1,    -1,    -1,  2678,  2352,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2360,  2361,  2362,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2705,    -1,    -1,     5,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2394,    19,
      -1,    -1,    -1,    -1,    -1,    -1,  2729,    -1,    28,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3142,    39,
      40,    -1,    -1,    -1,    -1,    45,    -1,    47,    48,    -1,
      -1,    -1,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,  3180,  2207,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2216,    -1,  2218,    -1,
      -1,    -1,  3196,    -1,    -1,    -1,  3200,    -1,    -1,    -1,
      -1,  3205,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2240,    -1,    -1,  2243,    -1,  2245,  2246,   117,  2248,    -1,
    3224,    -1,  2252,  3227,    -1,    -1,    -1,    -1,    -1,  2259,
      -1,  3235,  3236,  3237,  2264,    -1,  3240,    -1,    -1,  2842,
      -1,    -1,    -1,  3247,  3248,  2275,    -1,    -1,    -1,  2279,
    2280,  2281,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2292,    -1,    -1,    -1,    -1,  3271,    -1,  2299,
      -1,  2301,  2302,  2303,  2304,  2305,  2306,  2307,  2308,  2309,
    2310,    -1,    -1,    -1,    -1,    -1,  3290,    -1,    -1,    -1,
     190,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   209,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2922,
      -1,    -1,  3326,  3327,    -1,    -1,    -1,    -1,    -1,   229,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3353,
    3354,    -1,    -1,  2956,    -1,    -1,    -1,    -1,    -1,    -1,
     260,    -1,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
    2646,  2401,    -1,    -1,    -1,    -1,  2652,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   284,    -1,    -1,    -1,  2664,    -1,
      -1,    -1,    -1,    -1,  2670,    -1,    -1,    -1,  2674,    -1,
      -1,    -1,    -1,    -1,  3408,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2696,  2697,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2717,    -1,    -1,  2720,   345,  2722,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2730,  3058,  3460,  2487,    -1,    -1,
    2736,    -1,    -1,  2739,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3477,    -1,    -1,  2506,    -1,    -1,    -1,
      -1,   381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   405,    -1,  3511,    -1,    -1,
    3514,    -1,    -1,    -1,    -1,    -1,   416,    -1,    -1,    -1,
      -1,   421,   422,    -1,   424,    -1,   426,    -1,    -1,    -1,
     430,   431,    -1,   433,   434,    -1,    -1,    -1,   438,   439,
     440,   441,   442,    -1,    -1,   445,   446,   447,   448,    -1,
     450,   451,   452,    -1,   454,   455,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2598,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3205,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2651,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2677,    -1,  2679,
      -1,    -1,  2682,  2683,  2684,  2685,  2686,  2687,  2688,  2689,
    2690,  2691,    -1,  2693,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2713,    -1,    -1,    -1,    -1,  2718,  2719,
       5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2731,  2732,  2733,    19,  2735,    -1,    -1,  2738,    -1,
      -1,    -1,    -1,    28,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    39,    40,    -1,    -1,    -1,    -1,
      -1,    -1,    47,    48,    -1,  3011,    -1,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2808,    -1,
      -1,  3057,    -1,    -1,    -1,    -1,    -1,    -1,  3064,  3065,
      -1,    -1,  3068,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   117,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3460,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3142,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   190,    -1,    -1,    -1,    -1,
      -1,  2911,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   209,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3514,    -1,    -1,   229,    -1,    -1,    -1,    -1,    -1,
    3196,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   260,    -1,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3240,    -1,    -1,    -1,    -1,   284,
      -1,    -1,  3248,    -1,    -1,    -1,    -1,    -1,  3008,    -1,
      -1,    -1,  3012,    -1,    -1,    -1,    -1,  3017,  3018,    -1,
    3020,    -1,    -1,  3023,    -1,  3271,    -1,  3027,  3028,  3029,
    3030,  3031,  3032,  3033,  3034,  3035,  3036,  3037,  3038,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3051,  3052,  3053,  3054,    -1,  3056,    -1,    -1,    -1,
     345,  3061,  3062,  3063,    -1,    -1,  3066,    -1,    -1,  3069,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3327,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   381,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     405,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   416,    -1,    -1,    -1,    -1,   421,   422,    -1,   424,
      -1,    -1,    -1,    -1,  3144,   430,   431,    -1,   433,   434,
      -1,    -1,    -1,   438,   439,   440,   441,   442,    -1,    -1,
     445,   446,   447,   448,    -1,    -1,    -1,    -1,    -1,    -1,
     455,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    19,    -1,    -1,  3217,    -1,    -1,
      -1,    -1,    -1,    28,  3224,    -1,    -1,  3227,    -1,    -1,
    3230,  3231,  3232,    -1,    39,    40,  3236,  3237,  3238,  3239,
      -1,  3241,    47,    48,    -1,    -1,    -1,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3294,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   117,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3339,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3352,  3353,  3354,  3355,    -1,    -1,  3358,  3359,
    3360,    -1,  3362,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   190,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   209,    -1,  3406,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3419,
    3420,    -1,    -1,    -1,   229,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   260,    19,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    28,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    39,    40,    -1,   284,
      -1,    -1,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     345,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   117,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   381,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     405,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   416,    -1,    -1,    -1,    -1,   421,   422,    -1,   424,
      -1,    -1,    -1,    -1,    -1,   430,   431,   190,   433,   434,
      -1,    -1,    -1,   438,   439,   440,   441,   442,    -1,    -1,
     445,   446,   447,   448,    -1,    -1,   209,    -1,    -1,    -1,
     455,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   229,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   260,    -1,    -1,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   284,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   345,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   381,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   405,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   416,    -1,    -1,    -1,    -1,   421,   422,
      -1,   424,    -1,    -1,    -1,    -1,    -1,   430,   431,    -1,
     433,   434,    -1,    -1,    -1,   438,   439,   440,   441,   442,
      -1,    -1,   445,   446,   447,     5,     6,     7,     8,     9,
      10,    11,   455,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,   108,   109,
     110,    -1,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,    -1,   162,   163,   164,   165,   166,   167,   168,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     180,   181,   182,   183,   184,    -1,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,   197,   198,    -1,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,   225,   226,   227,   228,   229,
     230,   231,   232,   233,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,    -1,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,   396,   397,   398,   399,
     400,   401,   402,    -1,    -1,   405,   406,   407,   408,    -1,
     410,   411,   412,   413,   414,   415,   416,   417,     6,     7,
       8,   421,    10,    11,   424,    13,    14,    15,    -1,    -1,
      -1,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    -1,    -1,    -1,    35,    36,    37,
      38,   451,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    -1,    -1,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    99,    -1,    -1,    -1,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     118,    -1,    -1,    -1,    -1,    -1,    -1,   125,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,    -1,
      -1,    -1,    -1,    -1,   142,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   154,   155,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   183,    -1,    -1,   186,    -1,
      -1,    -1,   190,    -1,    -1,    -1,    -1,   195,    -1,   197,
      -1,    -1,    -1,    -1,    -1,   203,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   211,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   223,   224,    -1,    -1,    -1,
      -1,    -1,   230,    -1,   232,    -1,    -1,   235,   236,    -1,
     238,    -1,    -1,    -1,    -1,    -1,    -1,   245,   246,    -1,
     248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   266,   267,
     268,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,
      -1,    -1,    -1,    -1,   282,    -1,    -1,   285,   286,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   299,   300,   301,   302,    -1,    -1,    -1,    -1,    -1,
     308,   309,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   320,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   336,    -1,
      -1,   339,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   353,    -1,    -1,   356,    -1,
     358,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     368,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   379,   380,    -1,    -1,    -1,   384,    -1,   386,    -1,
      -1,    -1,    -1,    -1,    -1,   393,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   405,    -1,   407,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   421,    -1,    -1,   424,     6,     7,     8,
      -1,    10,    11,    -1,    13,    14,    15,    -1,    -1,    -1,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    -1,   452,    -1,    35,    36,    37,    38,
      -1,    40,    -1,    42,    43,    44,    -1,    46,    47,    48,
      49,    -1,    -1,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      99,    -1,    -1,    -1,   103,   104,   105,   106,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,
      -1,    -1,    -1,    -1,    -1,    -1,   125,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,    -1,    -1,
      -1,    -1,    -1,   142,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   154,   155,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   183,    -1,    -1,   186,    -1,    -1,
      -1,   190,    -1,    -1,    -1,    -1,   195,    -1,   197,    -1,
      -1,    -1,    -1,    -1,   203,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   211,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   223,   224,    -1,    -1,    -1,    -1,
      -1,   230,    -1,   232,    -1,    -1,   235,   236,    -1,   238,
      -1,    -1,    -1,    -1,    -1,    -1,   245,   246,    -1,   248,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   266,   267,   268,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,    -1,
      -1,    -1,    -1,   282,    -1,    -1,   285,   286,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     299,   300,   301,   302,    -1,    -1,    -1,    -1,    -1,   308,
     309,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   320,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   336,    -1,    -1,
     339,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   353,    -1,    -1,   356,    -1,   358,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,    -1,    -1,    -1,   384,    -1,   386,    -1,    -1,
      -1,    -1,    -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   405,    -1,   407,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   421,     3,    -1,   424,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,   452,    -1,    35,    36,    37,    38,    -1,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,    88,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,
      -1,    -1,   102,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,    -1,
      -1,   121,    -1,   123,   124,   125,    -1,    -1,   128,   129,
      -1,    -1,    -1,    -1,    -1,    -1,   136,   137,   138,    -1,
      -1,    -1,   142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   151,    -1,   153,   154,   155,   156,    -1,    -1,    -1,
      -1,    -1,   162,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   171,    -1,    -1,    -1,    -1,    -1,   177,    -1,    -1,
      -1,    -1,   182,   183,   184,    -1,   186,    -1,   188,    -1,
     190,    -1,    -1,    -1,    -1,   195,    -1,   197,    -1,   199,
      -1,   201,    -1,   203,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   211,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   223,   224,    -1,    -1,   227,    -1,    -1,
     230,    -1,   232,    -1,    -1,   235,   236,    -1,   238,    -1,
      -1,    -1,    -1,    -1,    -1,   245,   246,    -1,   248,    -1,
     250,   251,    -1,    -1,    -1,    -1,   256,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   264,    -1,   266,   267,   268,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,    -1,    -1,
      -1,   281,   282,    -1,    -1,   285,   286,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   299,
     300,   301,   302,    -1,    -1,    -1,    -1,    -1,   308,   309,
      -1,   311,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     320,   321,    -1,    -1,   324,    -1,   326,    -1,    -1,    -1,
     330,    -1,    -1,    -1,    -1,   335,   336,    -1,   338,   339,
      -1,    -1,   342,    -1,    -1,    -1,    -1,   347,    -1,    -1,
      -1,    -1,   352,   353,    -1,   355,   356,    -1,   358,    -1,
      -1,   361,    -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,    -1,    -1,    -1,   384,    -1,   386,    -1,   388,    -1,
     390,    -1,    -1,   393,    -1,    -1,   396,    -1,   398,    -1,
      -1,   401,    -1,    -1,   404,   405,    -1,   407,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   421,    -1,    -1,   424,    -1,    -1,    -1,    -1,    -1,
      -1,     5,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,   447,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      -1,    35,    36,    37,    38,    39,    40,    -1,    42,    43,
      44,    -1,    46,    47,    48,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,
      -1,    95,    96,    -1,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,    -1,   109,   110,    -1,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,   121,   122,   123,
     124,   125,    -1,    -1,   128,   129,   130,   131,   132,    -1,
     134,   135,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,    -1,   158,    -1,   160,    -1,   162,   163,
     164,    -1,   166,   167,    -1,   169,   170,   171,   172,    -1,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,   183,
     184,    -1,   186,   187,   188,   189,   190,    -1,   192,    -1,
     194,   195,    -1,   197,   198,    -1,   200,    -1,   202,   203,
      -1,   205,    -1,   207,   208,   209,   210,   211,   212,   213,
     214,    -1,   216,   217,   218,   219,   220,   221,    -1,   223,
     224,    -1,   226,   227,   228,   229,   230,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
      -1,   245,   246,   247,   248,    -1,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,    -1,   291,   292,    -1,
      -1,   295,   296,    -1,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,    -1,   308,   309,   310,   311,   312,    -1,
     314,   315,   316,   317,   318,   319,   320,   321,   322,    -1,
     324,   325,   326,   327,   328,   329,   330,   331,   332,    -1,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,   345,    -1,    -1,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,    -1,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
     374,   375,   376,   377,    -1,   379,   380,    -1,    -1,   383,
     384,   385,   386,   387,   388,   389,   390,   391,   392,    -1,
     394,   395,   396,   397,   398,   399,    -1,   401,   402,    -1,
     404,   405,   406,   407,   408,    -1,    -1,    -1,   412,   413,
     414,   415,   416,   417,    -1,    -1,    -1,   421,   422,   423,
     424,   425,    -1,    -1,   428,   429,   430,   431,   432,   433,
      -1,    -1,    -1,    -1,   438,   439,   440,    -1,    -1,    -1,
      -1,    -1,    -1,   447,   448,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,    -1,   109,
     110,    -1,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,   183,   184,    -1,   186,   187,   188,   189,
     190,    -1,   192,    -1,   194,   195,    -1,   197,   198,    -1,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,   209,
     210,   211,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,   223,   224,    -1,   226,   227,   228,   229,
     230,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,    -1,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
      -1,   291,   292,    -1,    -1,   295,   296,    -1,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,   308,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,   384,   385,   386,   387,   388,   389,
     390,   391,   392,    -1,   394,   395,   396,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,   407,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,   422,   423,   424,   425,    -1,    -1,   428,   429,
     430,   431,   432,   433,    -1,    -1,    -1,    -1,   438,   439,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   447,   448,     5,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    -1,    35,
      36,    37,    38,    39,    40,    -1,    42,    43,    44,    -1,
      46,    47,    48,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,    -1,   109,   110,    -1,   112,   113,    -1,    -1,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,    -1,
      -1,    -1,   128,   129,   130,   131,   132,    -1,   134,   135,
      -1,   137,    -1,   139,   140,   141,   142,   143,    -1,    -1,
      -1,    -1,    -1,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,    -1,    -1,   169,   170,   171,   172,    -1,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,
      -1,    -1,   188,   189,   190,    -1,   192,    -1,   194,   195,
      -1,   197,   198,    -1,   200,    -1,   202,    -1,    -1,   205,
      -1,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   219,   220,   221,    -1,   223,   224,    -1,
     226,   227,   228,   229,   230,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,    -1,    -1,
     246,   247,   248,    -1,   250,   251,   252,    -1,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,    -1,   270,   271,   272,   273,   274,   275,
     276,    -1,   278,    -1,   280,   281,   282,   283,    -1,    -1,
     286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,   295,
     296,    -1,    -1,   299,   300,   301,    -1,   303,   304,   305,
     306,    -1,    -1,    -1,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,    -1,   340,   341,   342,   343,   344,   345,
      -1,    -1,   348,   349,   350,    -1,   352,   353,   354,   355,
     356,   357,   358,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,    -1,   369,    -1,   371,   372,    -1,   374,   375,
     376,   377,    -1,   379,   380,    -1,    -1,   383,    -1,   385,
      -1,    -1,   388,   389,   390,   391,   392,    -1,    -1,   395,
     396,   397,   398,    -1,    -1,   401,   402,    -1,    -1,   405,
     406,   407,   408,    -1,    -1,    -1,   412,   413,   414,   415,
     416,   417,    -1,    -1,    -1,   421,    -1,    -1,   424,    -1,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,   448,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,    -1,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,   132,    -1,   134,   135,
     136,   137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,
      -1,    -1,    -1,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,    -1,    -1,   169,   170,   171,   172,    -1,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,   183,   184,    -1,
     186,    -1,   188,   189,   190,    -1,   192,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,   209,   210,    -1,   212,   213,   214,    -1,
     216,   217,   218,   219,   220,   221,    -1,    -1,   224,    -1,
     226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,    -1,
      -1,   237,    -1,   239,   240,   241,   242,   243,    -1,   245,
      -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,    -1,   268,    -1,   270,   271,   272,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,    -1,   283,    -1,   285,
     286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,   295,
     296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,   305,
     306,    -1,   308,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
      -1,   337,   338,   339,   340,   341,   342,   343,   344,   345,
      -1,    -1,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,   357,   358,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,   374,   375,
     376,   377,    -1,   379,   380,    -1,    -1,   383,   384,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,    -1,   395,
     396,   397,   398,    -1,   400,   401,   402,    -1,   404,   405,
     406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,
     416,   417,    -1,    -1,    -1,   421,    -1,    -1,   424,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,   445,
      18,    -1,    20,   449,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,    -1,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,    -1,   112,   113,   114,   115,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,   184,    -1,   186,   187,
     188,   189,   190,    -1,   192,    -1,   194,   195,   196,   197,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,   211,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,   223,   224,    -1,   226,   227,
     228,   229,   230,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,    -1,   291,   292,    -1,    -1,   295,   296,    -1,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,    -1,   394,   395,   396,   397,
     398,   399,    -1,   401,   402,    -1,   404,   405,   406,   407,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,
     428,   429,   430,   431,   432,   433,    -1,    -1,    -1,    -1,
     438,   439,     5,     6,     7,     8,     9,    10,    11,   447,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    -1,    35,    36,    37,    38,    39,    40,    -1,    42,
      43,    44,    -1,    46,    47,    48,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    -1,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,   132,
      -1,   134,   135,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,    -1,    -1,   169,   170,   171,   172,
      -1,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
     183,   184,    -1,   186,   187,   188,   189,   190,    -1,   192,
      -1,   194,   195,    -1,   197,   198,    -1,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,   209,   210,   211,   212,
     213,   214,    -1,   216,   217,   218,   219,   220,   221,    -1,
     223,   224,    -1,   226,   227,   228,   229,   230,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,    -1,   245,   246,   247,   248,    -1,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,    -1,   291,   292,
      -1,    -1,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,    -1,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,    -1,    -1,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,   374,   375,   376,   377,    -1,   379,   380,    -1,    -1,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
      -1,   394,   395,   396,   397,   398,   399,    -1,   401,   402,
      -1,   404,   405,   406,   407,   408,    -1,    -1,    -1,   412,
     413,   414,   415,   416,   417,    -1,    -1,    -1,   421,   422,
     423,   424,   425,    -1,    -1,   428,   429,   430,   431,   432,
     433,    -1,    -1,    -1,    -1,   438,   439,   440,    -1,    -1,
      -1,    -1,    -1,    -1,   447,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,    -1,   109,
     110,    -1,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,   183,   184,    -1,   186,   187,   188,   189,
     190,    -1,   192,    -1,   194,   195,    -1,   197,   198,    -1,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,   209,
     210,   211,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,   223,   224,    -1,   226,   227,   228,   229,
     230,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,    -1,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
      -1,   291,   292,    -1,    -1,   295,   296,    -1,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,   308,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,   384,   385,   386,   387,   388,   389,
     390,   391,   392,    -1,   394,   395,   396,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,   407,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,   422,   423,   424,   425,    -1,    -1,   428,   429,
     430,   431,   432,   433,    -1,    -1,    -1,    -1,   438,   439,
       5,     6,     7,     8,     9,    10,    11,   447,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    -1,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      -1,    46,    47,    48,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    -1,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,    -1,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,   183,   184,
      -1,   186,   187,   188,   189,   190,    -1,   192,    -1,   194,
     195,    -1,   197,   198,    -1,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,   209,   210,   211,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,   223,   224,
      -1,   226,   227,   228,   229,   230,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,    -1,
     245,   246,   247,   248,    -1,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,    -1,   291,   292,    -1,    -1,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,    -1,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,    -1,    -1,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,    -1,   394,
     395,   396,   397,   398,   399,    -1,   401,   402,    -1,   404,
     405,   406,   407,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,    -1,    -1,    -1,   421,   422,   423,   424,
     425,    -1,    -1,   428,   429,   430,   431,   432,   433,    -1,
      -1,    -1,    -1,   438,   439,     5,     6,     7,     8,     9,
      10,    11,   447,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    -1,
      -1,    -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,    -1,   109,
     110,    -1,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,   183,   184,    -1,   186,   187,   188,   189,
     190,    -1,   192,    -1,   194,   195,    -1,   197,   198,    -1,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,   209,
     210,   211,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,   223,   224,    -1,   226,   227,   228,   229,
     230,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,    -1,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
      -1,   291,   292,    -1,    -1,   295,   296,    -1,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,   308,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,   384,   385,   386,   387,   388,   389,
     390,   391,   392,    -1,   394,   395,   396,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,   407,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,   422,   423,   424,   425,    -1,    -1,   428,   429,
     430,   431,   432,   433,    -1,    -1,    -1,    -1,   438,   439,
       5,     6,     7,     8,     9,    10,    11,   447,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    -1,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      -1,    46,    47,    48,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    -1,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,    -1,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,   183,   184,
      -1,   186,   187,   188,   189,   190,    -1,   192,    -1,   194,
     195,    -1,   197,   198,    -1,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,   209,   210,   211,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,   223,   224,
      -1,   226,   227,   228,   229,   230,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,    -1,
     245,   246,   247,   248,    -1,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,    -1,   291,   292,    -1,    -1,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,    -1,    -1,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,    -1,    -1,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,    -1,   394,
     395,   396,   397,   398,   399,    -1,   401,   402,    -1,   404,
     405,   406,   407,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,    -1,    -1,    -1,   421,   422,   423,   424,
     425,    -1,    -1,   428,   429,   430,   431,   432,   433,    -1,
      -1,    -1,    -1,   438,   439,    -1,    -1,    -1,    -1,    -1,
     445,    -1,   447,     5,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    -1,    35,    36,    37,    38,    39,    40,    -1,
      42,    43,    44,    -1,    46,    47,    48,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      92,    -1,    -1,    95,    96,    -1,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,    -1,   109,   110,    -1,
     112,   113,   114,   115,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
     132,    -1,   134,   135,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,    -1,    -1,   169,   170,   171,
     172,    -1,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,   183,   184,    -1,   186,   187,   188,   189,   190,    -1,
     192,    -1,   194,   195,   196,   197,   198,    -1,   200,    -1,
     202,   203,    -1,   205,    -1,   207,   208,   209,   210,   211,
     212,   213,   214,    -1,   216,   217,   218,   219,   220,   221,
      -1,   223,   224,    -1,   226,   227,   228,   229,   230,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,    -1,   245,   246,   247,   248,    -1,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,    -1,   291,
     292,    -1,    -1,   295,   296,    -1,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,    -1,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,    -1,    -1,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,    -1,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,   374,   375,   376,   377,    -1,   379,   380,    -1,
      -1,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,    -1,   394,   395,   396,   397,   398,   399,    -1,   401,
     402,    -1,   404,   405,   406,   407,   408,    -1,    -1,    -1,
     412,   413,   414,   415,   416,   417,    -1,    -1,    -1,   421,
     422,   423,   424,   425,    -1,    -1,   428,   429,   430,   431,
     432,   433,    -1,    -1,    -1,    -1,   438,   439,     5,     6,
       7,     8,     9,    10,    11,   447,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    -1,    35,    36,
      37,    38,    39,    40,    -1,    42,    43,    44,    -1,    46,
      47,    48,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      -1,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,    -1,   109,   110,    -1,   112,   113,   114,   115,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,   125,    -1,
      -1,   128,   129,   130,   131,   132,    -1,   134,   135,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
      -1,    -1,   169,   170,   171,   172,    -1,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,   183,   184,    -1,   186,
     187,   188,   189,   190,    -1,   192,    -1,   194,   195,    -1,
     197,   198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,
     207,   208,   209,   210,   211,   212,   213,   214,    -1,   216,
     217,   218,   219,   220,   221,    -1,   223,   224,    -1,   226,
     227,   228,   229,   230,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,    -1,   245,   246,
     247,   248,    -1,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,   296,
      -1,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
      -1,   308,   309,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,    -1,
      -1,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,    -1,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,   374,   375,   376,
     377,    -1,   379,   380,    -1,    -1,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,    -1,   394,   395,   396,
     397,   398,   399,    -1,   401,   402,    -1,   404,   405,   406,
     407,   408,    -1,    -1,    -1,   412,   413,   414,   415,   416,
     417,    -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,
      -1,   428,   429,   430,   431,   432,   433,    -1,    -1,    -1,
      -1,   438,   439,     5,     6,     7,     8,     9,    10,    11,
     447,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    -1,    35,    36,    37,    38,    39,    40,    -1,
      42,    43,    44,    -1,    46,    47,    48,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      92,    -1,    -1,    95,    96,    -1,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,    -1,   109,   110,    -1,
     112,   113,   114,   115,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
     132,    -1,   134,   135,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,    -1,    -1,   169,   170,   171,
     172,    -1,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,   183,   184,    -1,   186,   187,   188,   189,   190,    -1,
     192,    -1,   194,   195,    -1,   197,   198,    -1,   200,    -1,
     202,   203,    -1,   205,    -1,   207,   208,   209,   210,   211,
     212,   213,   214,    -1,   216,   217,   218,   219,   220,   221,
      -1,   223,   224,    -1,   226,   227,   228,   229,   230,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,    -1,   245,   246,   247,   248,    -1,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,    -1,   291,
     292,    -1,    -1,   295,   296,    -1,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,    -1,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,    -1,    -1,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,    -1,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,   374,   375,   376,   377,    -1,   379,   380,    -1,
      -1,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,    -1,    -1,   395,   396,   397,   398,   399,    -1,   401,
     402,    -1,   404,   405,   406,   407,   408,    -1,    -1,    -1,
     412,   413,   414,   415,   416,   417,    -1,    -1,    -1,   421,
     422,   423,   424,   425,    -1,    -1,   428,   429,   430,   431,
     432,   433,    -1,    -1,    -1,    -1,    -1,   439,     5,     6,
       7,     8,     9,    10,    11,   447,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    -1,    35,    36,
      37,    38,    39,    40,    -1,    42,    43,    44,    -1,    46,
      47,    48,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      -1,    98,    99,   100,   101,   102,    -1,   104,   105,   106,
     107,    -1,   109,   110,    -1,   112,   113,   114,   115,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,   125,    -1,
      -1,   128,   129,   130,   131,   132,    -1,   134,   135,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
      -1,    -1,   169,   170,   171,   172,    -1,   174,   175,   176,
      -1,    -1,    -1,   180,   181,   182,   183,   184,    -1,   186,
     187,   188,   189,   190,    -1,   192,    -1,   194,   195,    -1,
     197,   198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,
     207,   208,   209,   210,    -1,   212,   213,   214,    -1,   216,
     217,   218,   219,   220,   221,    -1,   223,   224,    -1,   226,
     227,   228,   229,   230,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,    -1,   245,   246,
     247,    -1,    -1,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,   296,
      -1,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
      -1,   308,   309,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,    -1,
      -1,   348,   349,   350,   351,   352,   353,   354,   355,    -1,
     357,   358,    -1,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,   374,   375,   376,
     377,    -1,   379,   380,    -1,    -1,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,    -1,   394,   395,   396,
     397,   398,   399,    -1,   401,   402,    -1,   404,   405,   406,
     407,   408,    -1,    -1,    -1,   412,   413,   414,   415,   416,
     417,    -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,
      -1,   428,   429,   430,   431,   432,   433,    -1,    -1,    -1,
      -1,   438,   439,     5,     6,     7,     8,     9,    10,    11,
     447,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    -1,    35,    36,    37,    38,    39,    40,    -1,
      42,    43,    44,    -1,    46,    47,    48,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      92,    -1,    -1,    95,    96,    -1,    98,    99,   100,   101,
     102,    -1,   104,   105,   106,   107,    -1,   109,   110,    -1,
     112,   113,   114,   115,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
     132,    -1,   134,   135,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,    -1,    -1,   169,   170,   171,
     172,    -1,   174,   175,   176,    -1,    -1,    -1,   180,   181,
     182,   183,   184,    -1,   186,   187,   188,   189,   190,    -1,
     192,    -1,   194,   195,    -1,   197,   198,    -1,   200,    -1,
     202,   203,    -1,   205,    -1,   207,   208,   209,   210,    -1,
     212,   213,   214,    -1,   216,   217,   218,   219,   220,   221,
      -1,   223,   224,    -1,   226,   227,   228,   229,   230,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,    -1,   245,   246,   247,    -1,    -1,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,    -1,   291,
     292,    -1,    -1,    -1,   296,    -1,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,    -1,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,    -1,    -1,   348,   349,   350,   351,
     352,   353,   354,   355,    -1,   357,   358,    -1,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,   374,   375,   376,   377,    -1,   379,   380,    -1,
      -1,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,    -1,    -1,   395,   396,   397,   398,   399,    -1,   401,
     402,    -1,   404,   405,   406,   407,   408,    -1,    -1,    -1,
     412,   413,   414,   415,   416,   417,    -1,    -1,    -1,   421,
     422,    -1,   424,   425,    -1,    -1,   428,   429,   430,   431,
     432,   433,    -1,    -1,    -1,    -1,    -1,   439,    -1,     6,
       7,     8,     9,    10,    11,   447,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    93,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,   125,    -1,
      -1,   128,   129,   130,   131,   132,    -1,   134,   135,   136,
     137,    -1,   139,   140,   141,   142,   143,    -1,    -1,    -1,
      -1,    -1,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
      -1,    -1,   169,   170,   171,   172,    -1,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,   183,   184,    -1,   186,
      -1,   188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,
     197,   198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,
     207,   208,   209,   210,    -1,   212,   213,   214,    -1,   216,
     217,   218,   219,   220,   221,    -1,   223,   224,    -1,   226,
     227,   228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,
     237,   238,   239,   240,   241,   242,   243,    -1,   245,   246,
     247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,    -1,   270,   271,   272,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,    -1,   283,    -1,   285,   286,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,
      -1,    -1,   299,    -1,    -1,   302,   303,   304,   305,   306,
      -1,   308,   309,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,    -1,
      -1,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
     357,   358,    -1,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,   374,   375,   376,
     377,    -1,   379,   380,    -1,    -1,   383,   384,   385,   386,
      -1,   388,   389,   390,   391,   392,    -1,    -1,   395,   396,
     397,   398,    -1,    -1,   401,   402,    -1,   404,   405,   406,
      -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,   416,
     417,    -1,    -1,    -1,   421,    -1,    -1,   424,    -1,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,   448,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,   109,   110,    -1,   112,   113,    -1,   115,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,   125,    -1,
      -1,   128,   129,   130,   131,   132,    -1,   134,   135,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
      -1,    -1,   169,   170,   171,   172,    -1,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,   183,   184,    -1,   186,
      -1,   188,   189,   190,    -1,   192,    -1,   194,   195,    -1,
     197,   198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,
     207,   208,   209,   210,   211,   212,   213,   214,    -1,   216,
     217,   218,   219,   220,   221,    -1,   223,   224,    -1,   226,
     227,   228,    -1,   230,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,    -1,   245,   246,
     247,   248,    -1,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,    -1,   291,   292,    -1,   294,   295,   296,
      -1,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
      -1,   308,   309,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,    -1,
     347,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,    -1,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,   374,   375,   376,
     377,    -1,   379,   380,    -1,    -1,   383,   384,   385,   386,
      -1,   388,   389,   390,   391,   392,    -1,    -1,   395,   396,
     397,   398,   399,    -1,   401,   402,    -1,   404,   405,   406,
     407,   408,    -1,    -1,    -1,   412,   413,   414,   415,   416,
     417,    -1,    -1,    -1,   421,    -1,    -1,   424,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
     447,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,   109,   110,    -1,   112,   113,    -1,   115,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,   184,    -1,   186,    -1,
     188,   189,   190,    -1,   192,    -1,   194,   195,    -1,   197,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,   211,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,   223,   224,    -1,   226,   227,
     228,    -1,   230,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,    -1,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,    -1,   285,   286,   287,
     288,    -1,    -1,   291,   292,    -1,   294,   295,   296,    -1,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,   384,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,   399,    -1,   401,   402,    -1,   404,   405,   406,   407,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,    -1,    -1,   424,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,   447,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,    -1,
     109,   110,    -1,   112,   113,    -1,   115,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,   132,    -1,   134,   135,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,
     169,   170,   171,   172,    -1,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,   183,   184,    -1,   186,    -1,   188,
     189,   190,    -1,   192,    -1,   194,   195,    -1,   197,   198,
      -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,   208,
     209,   210,   211,   212,   213,   214,    -1,   216,   217,   218,
     219,   220,   221,    -1,   223,   224,    -1,   226,   227,   228,
      -1,   230,    -1,   232,    -1,    -1,   235,   236,   237,   238,
     239,   240,   241,   242,   243,    -1,   245,   246,   247,   248,
      -1,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,    -1,   285,   286,   287,   288,
      -1,    -1,   291,   292,    -1,    -1,   295,   296,    -1,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,    -1,   334,   335,   336,   337,   338,
     339,   340,   341,   342,   343,   344,   345,    -1,    -1,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,   374,   375,   376,   377,    -1,
     379,   380,    -1,    -1,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,    -1,    -1,   395,   396,   397,   398,
     399,    -1,   401,   402,    -1,   404,   405,   406,   407,   408,
      -1,    -1,    -1,   412,   413,   414,   415,   416,   417,    -1,
      -1,    -1,   421,    -1,    -1,   424,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,   447,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,   136,   137,    -1,   139,
     140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,   183,   184,    -1,   186,    -1,   188,   189,
     190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,   209,
     210,    -1,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,    -1,   224,    -1,   226,   227,   228,    -1,
     230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,
     240,   241,   242,   243,    -1,   245,    -1,   247,    -1,    -1,
     250,   251,   252,    -1,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,   268,    -1,
     270,   271,   272,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,    -1,   283,    -1,   285,   286,   287,   288,    -1,
      -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,   299,
      -1,    -1,   302,   303,   304,   305,   306,    -1,   308,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,    -1,   337,   338,   339,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,   384,   385,   386,    -1,   388,   389,
     390,   391,   392,    -1,    -1,   395,   396,   397,   398,    -1,
      -1,   401,   402,    -1,   404,   405,   406,    -1,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,   422,    -1,   424,   425,    -1,    -1,    -1,    -1,
     430,   431,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   446,   447,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,   184,    -1,   186,    -1,
     188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,    -1,   224,    -1,   226,   227,
     228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,
      -1,   239,   240,   241,   242,   243,    -1,   245,    -1,   247,
      -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,    -1,   283,    -1,   285,   286,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,
      -1,   299,    -1,    -1,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,    -1,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,   384,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,    -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,   422,    -1,   424,   425,    -1,    -1,
      -1,    -1,   430,   431,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,   447,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
     132,    -1,   134,   135,   136,   137,    -1,   139,   140,   141,
      -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,    -1,    -1,   169,   170,   171,
     172,    -1,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,   183,   184,    -1,   186,    -1,   188,   189,   190,    -1,
     192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,   203,    -1,   205,    -1,   207,   208,   209,   210,    -1,
     212,   213,   214,    -1,   216,   217,   218,   219,   220,   221,
      -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,
     232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,
     242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,
     252,    -1,    -1,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
      -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,   291,
     292,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,
     302,   303,   304,   305,   306,    -1,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,    -1,   337,   338,   339,   340,   341,
     342,   343,   344,   345,    -1,    -1,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,   357,   358,    -1,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,   374,   375,   376,   377,    -1,   379,   380,    -1,
      -1,   383,   384,   385,   386,    -1,   388,   389,   390,   391,
     392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,
     402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,
     412,   413,   414,   415,   416,   417,    -1,    -1,    -1,   421,
      -1,    -1,   424,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,   447,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
     113,    -1,    -1,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,   132,
      -1,   134,   135,   136,   137,    -1,   139,   140,   141,    -1,
     143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,    -1,    -1,   169,   170,   171,   172,
      -1,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
     183,   184,    -1,   186,    -1,   188,   189,   190,    -1,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,   209,   210,    -1,   212,
     213,   214,    -1,   216,   217,   218,   219,   220,   221,    -1,
      -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,   232,
      -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,   242,
     243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,   252,
      -1,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,    -1,   268,    -1,   270,   271,   272,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,    -1,
     283,    -1,   285,   286,   287,   288,    -1,    -1,   291,    -1,
      -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,   302,
     303,   304,   305,   306,    -1,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,    -1,   337,   338,   339,   340,   341,   342,
     343,   344,   345,    -1,   347,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,   357,   358,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,   374,   375,   376,   377,    -1,   379,   380,    -1,    -1,
     383,   384,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,   402,
      -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,   412,
     413,   414,   415,   416,   417,    -1,    -1,    -1,   421,    -1,
      -1,   424,   425,    -1,    -1,    -1,    -1,    -1,    -1,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,   447,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,   125,    -1,
      -1,   128,   129,   130,   131,   132,    -1,   134,   135,   136,
     137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,
      -1,    -1,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
      -1,    -1,   169,   170,   171,   172,    -1,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,   183,   184,    -1,   186,
      -1,   188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,
     207,   208,   209,   210,    -1,   212,   213,   214,    -1,   216,
     217,   218,   219,   220,   221,    -1,    -1,   224,    -1,   226,
     227,   228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,
     237,    -1,   239,   240,   241,   242,   243,    -1,   245,    -1,
     247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
      -1,   268,    -1,   270,   271,   272,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,    -1,   283,    -1,   285,   286,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,
      -1,    -1,   299,    -1,    -1,   302,   303,   304,   305,   306,
      -1,   308,   309,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,    -1,
     337,   338,   339,   340,   341,   342,   343,   344,   345,    -1,
     347,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
     357,   358,    -1,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,   374,   375,   376,
     377,    -1,   379,   380,    -1,    -1,   383,   384,   385,   386,
      -1,   388,   389,   390,   391,   392,    -1,    -1,   395,   396,
     397,   398,    -1,    -1,   401,   402,    -1,   404,   405,   406,
      -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,   416,
     417,    -1,    -1,    -1,   421,    -1,    -1,   424,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
     447,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,   184,    -1,   186,    -1,
     188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,    -1,   224,    -1,   226,   227,
     228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,
      -1,   239,   240,   241,   242,   243,    -1,   245,    -1,   247,
      -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,    -1,   283,    -1,   285,   286,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,
      -1,   299,    -1,    -1,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,    -1,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,   384,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,    -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,    -1,    -1,   424,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,   447,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,   113,    -1,    -1,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,   132,    -1,   134,   135,   136,   137,    -1,
     139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,
     169,   170,   171,   172,    -1,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,   183,   184,    -1,   186,    -1,   188,
     189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,   208,
     209,   210,    -1,   212,   213,   214,    -1,   216,   217,   218,
     219,   220,   221,    -1,    -1,   224,    -1,   226,   227,   228,
      -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,
     239,   240,   241,   242,   243,    -1,   245,    -1,   247,    -1,
      -1,   250,   251,   252,    -1,    -1,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,   268,
      -1,   270,   271,   272,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,    -1,   283,    -1,   285,   286,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,
     299,    -1,    -1,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,    -1,   334,   335,    -1,   337,   338,
     339,   340,   341,   342,   343,   344,   345,    -1,    -1,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,   357,   358,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,   374,   375,   376,   377,    -1,
     379,   380,    -1,    -1,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,    -1,    -1,   395,   396,   397,   398,
      -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,   408,
      -1,    -1,    -1,   412,   413,   414,   415,   416,   417,    -1,
      -1,    -1,   421,    -1,    -1,   424,    -1,    -1,    -1,    -1,
      -1,    -1,     5,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,   447,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    -1,    35,    36,    37,    38,    39,    40,    -1,    42,
      43,    44,    -1,    46,    47,    48,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,   122,
     123,   124,    -1,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,    -1,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,   164,   165,   166,   167,   168,   169,   170,   171,   172,
     173,   174,   175,   176,   177,   178,   179,   180,   181,   182,
      -1,   184,    -1,    -1,   187,   188,   189,   190,   191,   192,
     193,   194,   195,   196,   197,   198,    -1,   200,   201,   202,
      -1,   204,   205,   206,   207,   208,   209,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,    -1,    -1,   226,   227,   228,   229,   230,   231,   232,
     233,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,    -1,   246,   247,   248,   249,   250,   251,   252,
      -1,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,    -1,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,    -1,   300,   301,    -1,
     303,   304,   305,   306,    -1,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,   340,   341,   342,
     343,   344,   345,    -1,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,    -1,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,   380,    -1,   382,
     383,    -1,   385,    -1,   387,   388,   389,   390,   391,   392,
      -1,   394,   395,   396,   397,   398,   399,   400,   401,   402,
      -1,    -1,   405,   406,   407,   408,    -1,   410,   411,   412,
     413,   414,   415,   416,   417,    -1,    -1,    -1,   421,   422,
     423,   424,   425,    -1,    -1,    -1,    -1,   430,   431,    -1,
     433,   434,   435,   436,    -1,   438,   439,   440,   441,   442,
     443,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,   136,   137,    -1,   139,   140,   141,    -1,   143,    -1,
      -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,   183,   184,
      -1,   186,    -1,   188,   189,   190,    -1,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,    -1,   224,
      -1,   226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,
      -1,    -1,   237,    -1,   239,   240,   241,   242,   243,    -1,
     245,    -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    -1,   268,    -1,   270,   271,   272,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,    -1,   283,    -1,
     285,   286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
     295,   296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,    -1,   337,   338,   339,   340,   341,   342,   343,   344,
     345,    -1,    -1,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,    -1,    -1,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,    -1,
     395,   396,   397,   398,    -1,    -1,   401,   402,    -1,   404,
     405,   406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,    -1,    -1,    -1,   421,    -1,   423,   424,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   434,
     435,   436,    -1,   438,   439,   440,   441,   442,   443,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,   125,    -1,
      -1,   128,   129,   130,   131,   132,    -1,   134,   135,   136,
     137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,
      -1,    -1,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
      -1,    -1,   169,   170,   171,   172,    -1,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,   183,   184,    -1,   186,
      -1,   188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,
     207,   208,   209,   210,    -1,   212,   213,   214,    -1,   216,
     217,   218,   219,   220,   221,    -1,    -1,   224,    -1,   226,
     227,   228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,
     237,    -1,   239,   240,   241,   242,   243,    -1,   245,    -1,
     247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
      -1,   268,    -1,   270,   271,   272,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,    -1,   283,    -1,   285,   286,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,
      -1,    -1,   299,    -1,    -1,   302,   303,   304,   305,   306,
      -1,   308,   309,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,    -1,
     337,   338,   339,   340,   341,   342,   343,   344,   345,    -1,
      -1,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
     357,   358,    -1,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,   374,   375,   376,
     377,    -1,   379,   380,    -1,    -1,   383,   384,   385,   386,
      -1,   388,   389,   390,   391,   392,    -1,    -1,   395,   396,
     397,   398,    -1,    -1,   401,   402,    -1,   404,   405,   406,
      -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,   416,
     417,    -1,    -1,    -1,   421,    -1,   423,   424,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   434,   435,   436,
      -1,   438,   439,   440,   441,   442,   443,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
     108,   109,   110,    -1,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   160,    -1,   162,   163,   164,   165,   166,   167,
     168,   169,   170,   171,   172,   173,   174,   175,   176,   177,
     178,   179,   180,   181,   182,   183,   184,    -1,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,   197,
     198,    -1,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,   397,
     398,   399,   400,   401,   402,    -1,    -1,   405,   406,   407,
     408,    -1,   410,   411,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,    -1,    -1,   424,    -1,     5,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,   440,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    -1,    35,    36,
      37,    38,    39,    40,    -1,    42,    43,    44,    -1,    46,
      47,    48,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
     107,    -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,   129,   130,   131,   132,    -1,   134,   135,    -1,
     137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,
      -1,    -1,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
      -1,    -1,   169,   170,   171,   172,    -1,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,    -1,   184,    -1,    -1,
      -1,   188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,    -1,    -1,   205,    -1,
     207,   208,   209,   210,    -1,   212,   213,   214,    -1,   216,
     217,   218,   219,   220,   221,    -1,    -1,    -1,    -1,   226,
     227,   228,   229,   230,    -1,   232,    -1,    -1,    -1,    -1,
     237,    -1,   239,   240,   241,   242,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
      -1,   268,    -1,   270,   271,   272,   273,   274,   275,   276,
      -1,   278,    -1,   280,   281,    -1,   283,    -1,    -1,   286,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,
      -1,    -1,    -1,    -1,    -1,    -1,   303,   304,   305,   306,
      -1,    -1,    -1,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,    -1,
     337,   338,    -1,   340,   341,   342,   343,   344,   345,    -1,
      -1,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
     357,   358,    -1,   360,   361,   362,   363,   364,   365,   366,
     367,    -1,   369,    -1,   371,   372,    -1,   374,   375,   376,
     377,    -1,   379,   380,    -1,    -1,   383,    -1,   385,    -1,
      -1,   388,   389,   390,   391,   392,    -1,    -1,   395,   396,
     397,   398,    -1,    -1,   401,   402,    -1,    -1,   405,   406,
      -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,   416,
     417,    -1,    -1,    -1,   421,    -1,    -1,   424,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,   440,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,   184,    -1,   186,    -1,
     188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,    -1,   224,    -1,   226,   227,
     228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,
      -1,   239,   240,   241,   242,   243,    -1,   245,    -1,   247,
      -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,    -1,   283,    -1,   285,   286,   287,
     288,    -1,    -1,   291,   292,    -1,    -1,   295,   296,    -1,
      -1,   299,    -1,    -1,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,    -1,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,   384,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,    -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,    -1,    -1,   424,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,   440,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,   113,    -1,    -1,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,   132,    -1,   134,   135,   136,   137,    -1,
     139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,
     149,   150,   151,   152,   153,   154,   155,   156,   157,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,
     169,   170,   171,   172,    -1,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,   183,   184,    -1,   186,   187,   188,
     189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,   208,
     209,   210,    -1,   212,   213,   214,    -1,   216,   217,   218,
     219,   220,   221,    -1,    -1,   224,    -1,   226,   227,   228,
      -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,
     239,   240,   241,   242,   243,    -1,   245,    -1,   247,    -1,
      -1,   250,   251,   252,    -1,    -1,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,   268,
      -1,   270,   271,   272,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,    -1,   283,    -1,   285,   286,   287,   288,
     289,    -1,   291,    -1,   293,    -1,   295,   296,    -1,    -1,
     299,    -1,    -1,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,    -1,   334,   335,    -1,   337,   338,
     339,   340,   341,   342,   343,   344,   345,    -1,    -1,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,   357,   358,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,   374,   375,   376,   377,    -1,
     379,   380,    -1,    -1,   383,   384,   385,   386,   387,   388,
     389,   390,   391,   392,    -1,    -1,   395,   396,   397,   398,
      -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,   408,
      -1,    -1,    -1,   412,   413,   414,   415,   416,   417,    -1,
      -1,    -1,   421,   422,    -1,   424,   425,    -1,    -1,    -1,
      -1,   430,   431,    -1,   433,    -1,    -1,    -1,    -1,    -1,
     439,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,   136,   137,    -1,   139,   140,   141,    -1,   143,    -1,
      -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,   183,   184,
      -1,   186,   187,   188,   189,   190,    -1,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,    -1,   224,
      -1,   226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,
      -1,    -1,   237,    -1,   239,   240,   241,   242,   243,    -1,
     245,    -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    -1,   268,    -1,   270,   271,   272,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,    -1,   283,    -1,
     285,   286,   287,   288,   289,    -1,   291,    -1,   293,    -1,
     295,   296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,    -1,   337,   338,   339,   340,   341,   342,   343,   344,
     345,    -1,    -1,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,    -1,    -1,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,    -1,    -1,
     395,   396,   397,   398,    -1,    -1,   401,   402,    -1,   404,
     405,   406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,    -1,    -1,    -1,   421,   422,    -1,   424,
     425,    -1,    -1,    -1,    -1,   430,   431,    -1,   433,    -1,
      -1,    -1,    -1,    -1,   439,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,   136,   137,    -1,   139,   140,
     141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,   183,   184,    -1,   186,    -1,   188,   189,   190,
      -1,   192,    -1,   194,    -1,   196,    -1,   198,    -1,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,   209,   210,
      -1,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,    -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,
      -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,
     241,   242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,   268,    -1,   270,
     271,   272,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,    -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,
      -1,   302,   303,   304,   305,   306,    -1,   308,   309,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,    -1,   337,   338,   339,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,
     401,   402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,    -1,    -1,   424,   425,    -1,    -1,    -1,    -1,    -1,
     431,    -1,     6,     7,     8,     9,    10,    11,   439,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    -1,    29,    30,    31,    32,    -1,
      -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,    43,
      44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,   113,
      -1,    -1,   116,   117,   118,   119,    -1,   121,   122,   123,
     124,   125,    -1,    -1,   128,   129,   130,   131,   132,    -1,
     134,   135,   136,   137,    -1,   139,   140,   141,    -1,   143,
      -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,
     154,   155,   156,    -1,   158,    -1,   160,    -1,   162,   163,
     164,    -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,   183,
     184,    -1,   186,    -1,   188,   189,   190,    -1,   192,    -1,
     194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,   203,
      -1,   205,    -1,   207,   208,   209,   210,    -1,   212,   213,
     214,    -1,   216,   217,   218,   219,   220,   221,    -1,    -1,
     224,    -1,   226,   227,   228,    -1,   230,    -1,   232,    -1,
      -1,    -1,    -1,   237,    -1,   239,   240,   241,   242,   243,
      -1,   245,    -1,   247,    -1,    -1,   250,   251,   252,    -1,
      -1,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,    -1,   268,    -1,   270,   271,   272,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,    -1,   283,
      -1,   285,   286,   287,   288,    -1,    -1,   291,    -1,    -1,
      -1,   295,   296,    -1,    -1,   299,    -1,    -1,   302,   303,
     304,   305,   306,    -1,   308,   309,   310,   311,   312,    -1,
     314,   315,   316,   317,   318,   319,   320,   321,   322,    -1,
     324,   325,   326,   327,   328,   329,   330,   331,   332,    -1,
     334,   335,    -1,   337,   338,   339,   340,   341,   342,   343,
     344,   345,    -1,    -1,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,   357,   358,    -1,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
     374,   375,   376,   377,    -1,   379,   380,    -1,    -1,   383,
     384,   385,   386,    -1,   388,   389,   390,   391,   392,    -1,
      -1,   395,   396,   397,   398,    -1,    -1,   401,   402,    -1,
     404,   405,   406,    -1,   408,    -1,    -1,    -1,   412,   413,
     414,   415,   416,   417,    -1,    -1,    -1,   421,    -1,    -1,
     424,   425,    -1,    -1,    -1,    -1,    -1,   431,    -1,     6,
       7,     8,     9,    10,    11,   439,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,   125,    -1,
      -1,   128,   129,   130,   131,   132,    -1,   134,   135,   136,
     137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,
      -1,    -1,   149,   150,   151,   152,   153,   154,   155,   156,
     157,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
      -1,    -1,   169,   170,   171,   172,    -1,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,   183,   184,    -1,   186,
      -1,   188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,
     207,   208,   209,   210,    -1,   212,   213,   214,    -1,   216,
     217,   218,   219,   220,   221,    -1,    -1,   224,    -1,   226,
     227,   228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,
     237,    -1,   239,   240,   241,   242,   243,    -1,   245,    -1,
     247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
      -1,   268,    -1,   270,   271,   272,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,    -1,   283,    -1,   285,   286,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,
      -1,    -1,   299,    -1,    -1,   302,   303,   304,   305,   306,
      -1,   308,   309,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,    -1,
     337,   338,   339,   340,   341,   342,   343,   344,   345,    -1,
      -1,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
     357,   358,    -1,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,   374,   375,   376,
     377,    -1,   379,   380,   381,    -1,   383,   384,   385,   386,
      -1,   388,   389,   390,   391,   392,    -1,    -1,   395,   396,
     397,   398,    -1,    -1,   401,   402,    -1,   404,   405,   406,
      -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,   416,
     417,    -1,    -1,    -1,   421,    -1,    -1,   424,   425,    -1,
      -1,     6,     7,     8,     9,    10,    11,   434,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,   136,   137,    -1,   139,   140,   141,    -1,   143,    -1,
      -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,   183,   184,
      -1,   186,    -1,   188,   189,   190,    -1,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,    -1,   224,
      -1,   226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,
      -1,    -1,   237,    -1,   239,   240,   241,   242,   243,    -1,
     245,    -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    -1,   268,    -1,   270,   271,   272,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,    -1,   283,    -1,
     285,   286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
     295,   296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,    -1,   337,   338,   339,   340,   341,   342,   343,   344,
     345,    -1,    -1,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,    -1,    -1,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,    -1,
     395,   396,   397,   398,    -1,    -1,   401,   402,    -1,   404,
     405,   406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,    -1,    -1,    -1,   421,   422,    -1,   424,
     425,    -1,    -1,   428,   429,   430,   431,    -1,   433,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,   125,    -1,
      -1,   128,   129,   130,   131,   132,    -1,   134,   135,   136,
     137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,
      -1,    -1,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
      -1,    -1,   169,   170,   171,   172,    -1,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,   183,   184,    -1,   186,
      -1,   188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,
     207,   208,   209,   210,    -1,   212,   213,   214,    -1,   216,
     217,   218,   219,   220,   221,    -1,    -1,   224,    -1,   226,
     227,   228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,
     237,    -1,   239,   240,   241,   242,   243,    -1,   245,    -1,
     247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
      -1,   268,    -1,   270,   271,   272,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,    -1,   283,    -1,   285,   286,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,
      -1,    -1,   299,    -1,    -1,   302,   303,   304,   305,   306,
      -1,   308,   309,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,    -1,
     337,   338,   339,   340,   341,   342,   343,   344,   345,    -1,
      -1,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
     357,   358,    -1,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,   374,   375,   376,
     377,    -1,   379,   380,   381,    -1,   383,   384,   385,   386,
      -1,   388,   389,   390,   391,   392,    -1,    -1,   395,   396,
     397,   398,    -1,    -1,   401,   402,    -1,   404,   405,   406,
      -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,   416,
     417,    -1,    -1,    -1,   421,   422,    -1,   424,   425,    -1,
      -1,    -1,    -1,   430,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
     132,    -1,   134,   135,   136,   137,    -1,   139,   140,   141,
      -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,
     152,   153,   154,   155,   156,   157,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,    -1,    -1,   169,   170,   171,
     172,    -1,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,   183,   184,    -1,   186,    -1,   188,   189,   190,    -1,
     192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,   203,    -1,   205,    -1,   207,   208,   209,   210,    -1,
     212,   213,   214,    -1,   216,   217,   218,   219,   220,   221,
      -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,
     232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,
     242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,
     252,    -1,    -1,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,   268,    -1,   270,   271,
     272,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
      -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,   291,
      -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,
     302,   303,   304,   305,   306,    -1,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,    -1,   337,   338,   339,   340,   341,
     342,   343,   344,   345,    -1,    -1,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,   357,   358,    -1,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,   374,   375,   376,   377,    -1,   379,   380,    -1,
      -1,   383,   384,   385,   386,    -1,   388,   389,   390,   391,
     392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,
     402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,
     412,   413,   414,   415,   416,   417,    -1,    -1,    -1,   421,
     422,    -1,   424,   425,    -1,    -1,    -1,    -1,   430,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,   125,    -1,
      -1,   128,   129,   130,   131,   132,    -1,   134,   135,   136,
     137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,
      -1,    -1,   149,   150,   151,   152,   153,   154,   155,   156,
     157,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
      -1,    -1,   169,   170,   171,   172,    -1,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,   183,   184,    -1,   186,
      -1,   188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,
     207,   208,   209,   210,    -1,   212,   213,   214,    -1,   216,
     217,   218,   219,   220,   221,    -1,    -1,   224,    -1,   226,
     227,   228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,
     237,    -1,   239,   240,   241,   242,   243,    -1,   245,    -1,
     247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
      -1,   268,    -1,   270,   271,   272,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,    -1,   283,    -1,   285,   286,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,
      -1,    -1,   299,    -1,    -1,   302,   303,   304,   305,   306,
      -1,   308,   309,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,    -1,
     337,   338,   339,   340,   341,   342,   343,   344,   345,    -1,
      -1,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
     357,   358,    -1,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,   374,   375,   376,
     377,    -1,   379,   380,    -1,    -1,   383,   384,   385,   386,
      -1,   388,   389,   390,   391,   392,    -1,    -1,   395,   396,
     397,   398,    -1,    -1,   401,   402,    -1,   404,   405,   406,
      -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,   416,
     417,    -1,    -1,    -1,   421,   422,    -1,   424,   425,    -1,
      -1,    -1,    -1,   430,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
     132,    -1,   134,   135,   136,   137,    -1,   139,   140,   141,
      -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,    -1,    -1,   169,   170,   171,
     172,    -1,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,   183,   184,    -1,   186,    -1,   188,   189,   190,    -1,
     192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,   203,    -1,   205,    -1,   207,   208,   209,   210,    -1,
     212,   213,   214,    -1,   216,   217,   218,   219,   220,   221,
      -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,
     232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,
     242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,
     252,    -1,    -1,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,   268,    -1,   270,   271,
     272,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
      -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,   291,
      -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,
     302,   303,   304,   305,   306,    -1,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,    -1,   337,   338,   339,   340,   341,
     342,   343,   344,   345,    -1,    -1,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,   357,   358,    -1,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,   374,   375,   376,   377,    -1,   379,   380,    -1,
      -1,   383,   384,   385,   386,    -1,   388,   389,   390,   391,
     392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,
     402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,
     412,   413,   414,   415,   416,   417,    -1,    -1,    -1,   421,
     422,    -1,   424,   425,    -1,    -1,    -1,    -1,   430,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,   125,    -1,
      -1,   128,   129,   130,   131,   132,    -1,   134,   135,   136,
     137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,
      -1,    -1,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
      -1,    -1,   169,   170,   171,   172,    -1,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,   183,   184,    -1,   186,
      -1,   188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,
     207,   208,   209,   210,    -1,   212,   213,   214,    -1,   216,
     217,   218,   219,   220,   221,    -1,    -1,   224,    -1,   226,
     227,   228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,
     237,    -1,   239,   240,   241,   242,   243,    -1,   245,    -1,
     247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
      -1,   268,    -1,   270,   271,   272,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,    -1,   283,    -1,   285,   286,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,
      -1,    -1,   299,    -1,    -1,   302,   303,   304,   305,   306,
      -1,   308,   309,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,    -1,
     337,   338,   339,   340,   341,   342,   343,   344,   345,    -1,
      -1,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
     357,   358,    -1,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,   374,   375,   376,
     377,    -1,   379,   380,    -1,    -1,   383,   384,   385,   386,
      -1,   388,   389,   390,   391,   392,    -1,    -1,   395,   396,
     397,   398,    -1,    -1,   401,   402,    -1,   404,   405,   406,
      -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,   416,
     417,    -1,    -1,    -1,   421,    -1,    -1,   424,    -1,     4,
     427,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    17,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,   136,   137,    -1,   139,   140,   141,    -1,   143,    -1,
      -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,   183,   184,
      -1,   186,    -1,   188,   189,   190,    -1,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,    -1,   224,
      -1,   226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,
      -1,    -1,   237,    -1,   239,   240,   241,   242,   243,    -1,
     245,    -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    -1,   268,    -1,   270,   271,   272,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,    -1,   283,    -1,
     285,   286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
     295,   296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,    -1,   337,   338,   339,   340,   341,   342,   343,   344,
     345,    -1,    -1,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,    -1,    -1,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,    -1,
     395,   396,   397,   398,    -1,    -1,   401,   402,    -1,   404,
     405,   406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,     6,     7,     8,   421,    10,    11,   424,
      13,    14,    15,    -1,    -1,    -1,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    -1,
      -1,    -1,    35,    36,    37,    38,    -1,    40,    -1,    42,
      43,    44,    45,    46,    47,    48,    49,    -1,    -1,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,    -1,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,   125,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   136,    -1,    -1,    -1,    -1,    -1,   142,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   154,   155,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     183,    -1,    -1,   186,    -1,    -1,    -1,   190,    -1,    -1,
      -1,    -1,   195,    -1,   197,    -1,    -1,    -1,    -1,    -1,
     203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   211,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     223,   224,    -1,    -1,    -1,    -1,    -1,   230,    -1,   232,
      -1,    -1,   235,   236,    -1,   238,    -1,    -1,    -1,    -1,
      -1,    -1,   245,   246,    -1,   248,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   266,   267,   268,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   277,    -1,    -1,    -1,    -1,   282,
      -1,    -1,   285,   286,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   299,   300,   301,   302,
      -1,    -1,    -1,    -1,    -1,   308,   309,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   320,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   336,    -1,    -1,   339,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     353,    -1,    -1,   356,    -1,   358,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,    -1,    -1,
      -1,   384,    -1,   386,    -1,    -1,    -1,    -1,    -1,    -1,
     393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   405,    -1,   407,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   421,    -1,
      -1,   424,    -1,   426,     6,     7,     8,    -1,    10,    11,
      -1,    13,    14,    15,    -1,    -1,    -1,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      -1,    -1,    -1,    35,    36,    37,    38,    -1,    40,    -1,
      42,    43,    44,    45,    46,    47,    48,    49,    -1,    -1,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,
      -1,   103,   104,   105,   106,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   118,    -1,    -1,    -1,
      -1,    -1,    -1,   125,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   136,    -1,    -1,    -1,    -1,    -1,
     142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   154,   155,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   183,    -1,    -1,   186,    -1,    -1,    -1,   190,    -1,
      -1,    -1,    -1,   195,    -1,   197,    -1,    -1,    -1,    -1,
      -1,   203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   211,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   223,   224,    -1,    -1,    -1,    -1,    -1,   230,    -1,
     232,    -1,    -1,   235,   236,    -1,   238,    -1,    -1,    -1,
      -1,    -1,    -1,   245,   246,    -1,   248,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   266,   267,   268,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   277,    -1,    -1,    -1,    -1,
     282,    -1,    -1,   285,   286,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   299,   300,   301,
     302,    -1,    -1,    -1,    -1,    -1,   308,   309,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   320,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   336,    -1,    -1,   339,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   353,    -1,    -1,   356,    -1,   358,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,    -1,
      -1,    -1,   384,    -1,   386,    -1,    -1,    -1,    -1,    -1,
      -1,   393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   405,    -1,   407,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   421,
      -1,    -1,   424,    -1,   426,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,   108,   109,
     110,    -1,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,    -1,   162,   163,   164,   165,   166,   167,   168,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     180,   181,   182,   183,   184,    -1,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,   197,   198,    -1,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,   225,   226,   227,   228,   229,
     230,   231,   232,   233,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,    -1,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,   396,   397,   398,   399,
     400,   401,   402,    -1,    -1,   405,   406,   407,   408,    -1,
     410,   411,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,    -1,    -1,   424,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,    -1,   109,
     110,    -1,   112,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,    -1,   137,    -1,   139,
     140,   141,   142,   143,    -1,    -1,    -1,    -1,    -1,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,    -1,    -1,   188,   189,
     190,    -1,   192,    -1,   194,   195,    -1,   197,   198,    -1,
     200,    -1,   202,    -1,    -1,   205,    -1,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,    -1,   223,   224,    -1,   226,   227,   228,   229,
     230,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,    -1,    -1,   246,   247,   248,    -1,
     250,   251,   252,    -1,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,    -1,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,    -1,
     280,   281,   282,   283,    -1,    -1,   286,   287,   288,    -1,
      -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,   299,
     300,   301,    -1,   303,   304,   305,   306,    -1,    -1,    -1,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,    -1,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,    -1,   352,   353,   354,   355,   356,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,    -1,   385,    -1,    -1,   388,   389,
     390,   391,   392,    -1,    -1,   395,   396,   397,   398,    -1,
      -1,   401,   402,    -1,    -1,   405,   406,   407,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,    -1,    -1,   424,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,    -1,   109,
     110,    -1,   112,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,    -1,   137,    -1,   139,
     140,   141,   142,   143,    -1,    -1,    -1,    -1,    -1,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,    -1,    -1,   188,   189,
     190,    -1,   192,    -1,   194,   195,    -1,   197,   198,    -1,
     200,    -1,   202,    -1,    -1,   205,    -1,   207,   208,   209,
     210,   211,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,   223,    -1,    -1,   226,   227,   228,   229,
     230,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,    -1,    -1,   246,   247,   248,    -1,
     250,   251,   252,    -1,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,    -1,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,    -1,
     280,   281,   282,   283,    -1,    -1,   286,   287,   288,    -1,
      -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,    -1,
     300,   301,    -1,   303,   304,   305,   306,    -1,    -1,    -1,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,    -1,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,    -1,   352,   353,   354,   355,   356,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,    -1,   385,    -1,    -1,   388,   389,
     390,   391,   392,    -1,    -1,   395,   396,   397,   398,    -1,
      -1,   401,   402,    -1,    -1,   405,   406,   407,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,    -1,    -1,   424,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      41,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,   136,   137,    -1,   139,   140,
     141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,   183,   184,    -1,   186,    -1,   188,   189,   190,
      -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,   209,   210,
      -1,   212,   213,   214,    -1,   216,   217,   218,   219,   220,
     221,    -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,
      -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,
     241,   242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,    -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,
     291,   292,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,
      -1,   302,   303,   304,   305,   306,    -1,   308,   309,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,    -1,   337,   338,   339,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,    -1,
     371,   372,   373,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,
     401,   402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,    -1,    -1,   424,   425,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,   136,   137,    -1,   139,   140,
     141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,   183,   184,    -1,   186,    -1,   188,   189,   190,
      -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,   209,   210,
      -1,   212,   213,   214,    -1,   216,   217,   218,   219,   220,
     221,    -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,
      -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,
     241,   242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,   268,    -1,   270,
     271,   272,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,    -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,
      -1,   302,   303,   304,   305,   306,    -1,   308,   309,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,    -1,   337,   338,   339,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,
     401,   402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,    -1,    -1,   424,   425,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,   136,   137,    -1,   139,   140,
     141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,   183,   184,    -1,   186,    -1,   188,   189,   190,
      -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,   209,   210,
      -1,   212,   213,   214,    -1,   216,   217,   218,   219,   220,
     221,    -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,
      -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,
     241,   242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,   268,    -1,   270,
     271,   272,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,    -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,
      -1,   302,   303,   304,   305,   306,    -1,   308,   309,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,    -1,   337,   338,   339,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,
     401,   402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,    -1,    -1,   424,   425,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    17,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,   136,   137,    -1,   139,   140,
     141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,   183,   184,    -1,   186,    -1,   188,   189,   190,
      -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,   209,   210,
      -1,   212,   213,   214,    -1,   216,   217,   218,   219,   220,
     221,    -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,
      -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,
     241,   242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,   268,    -1,   270,
     271,   272,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,    -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,
      -1,   302,   303,   304,   305,   306,    -1,   308,   309,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,    -1,   337,   338,   339,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,
     401,   402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,    -1,    -1,   424,   425,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,   136,   137,    -1,   139,   140,
     141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,   183,   184,    -1,   186,    -1,   188,   189,   190,
      -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,   209,   210,
      -1,   212,   213,   214,    -1,   216,   217,   218,   219,   220,
     221,    -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,
      -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,
     241,   242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,   268,    -1,   270,
     271,   272,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,    -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,
      -1,   302,   303,   304,   305,   306,    -1,   308,   309,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,    -1,   337,   338,   339,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,
     401,   402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,    -1,    -1,   424,   425,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,   136,   137,    -1,   139,   140,
     141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,   183,   184,    -1,   186,    -1,   188,   189,   190,
      -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,   209,   210,
      -1,   212,   213,   214,    -1,   216,   217,   218,   219,   220,
     221,    -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,
      -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,
     241,   242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,   268,    -1,   270,
     271,   272,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,    -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,
      -1,   302,   303,   304,   305,   306,    -1,   308,   309,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,    -1,   337,   338,   339,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,
     401,   402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,    -1,    -1,   424,   425,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,   136,   137,    -1,   139,   140,
     141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,   183,   184,    -1,   186,    -1,   188,   189,   190,
      -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,   209,   210,
      -1,   212,   213,   214,    -1,   216,   217,   218,   219,   220,
     221,    -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,
      -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,
     241,   242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,   268,    -1,   270,
     271,   272,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,    -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,
      -1,   302,   303,   304,   305,   306,    -1,   308,   309,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,    -1,   337,   338,   339,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,
     401,   402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,    -1,    -1,   424,   425,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,   107,    -1,   109,
     110,    -1,   112,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,    -1,   137,    -1,   139,
     140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,    -1,    -1,   188,   189,
     190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,    -1,    -1,   205,    -1,   207,   208,   209,
     210,    -1,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,    -1,    -1,   224,    -1,   226,   227,   228,   229,
     230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,
     240,   241,   242,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,   252,    -1,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,   268,    -1,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,    -1,
     280,   281,    -1,   283,    -1,    -1,   286,   287,   288,    -1,
      -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,   299,
      -1,    -1,    -1,   303,   304,   305,   306,    -1,    -1,    -1,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,    -1,   337,   338,    -1,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,    -1,   385,    -1,    -1,   388,   389,
     390,   391,   392,    -1,    -1,   395,   396,   397,   398,    -1,
      -1,   401,   402,    -1,    -1,   405,   406,    -1,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,    -1,    -1,   424,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,   107,    -1,   109,
     110,    -1,   112,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,    -1,   137,    -1,   139,
     140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,    -1,    -1,   188,   189,
     190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,    -1,    -1,   205,    -1,   207,   208,   209,
     210,    -1,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,    -1,    -1,    -1,   226,   227,   228,   229,
     230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,
     240,   241,   242,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,   252,    -1,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,   268,    -1,
     270,   271,   272,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,    -1,   283,    -1,    -1,   286,   287,   288,    -1,
      -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,    -1,
      -1,    -1,    -1,   303,   304,   305,   306,    -1,    -1,    -1,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,    -1,   337,   338,    -1,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,    -1,   385,    -1,    -1,   388,   389,
     390,   391,   392,    -1,    -1,   395,   396,   397,   398,    -1,
      -1,   401,   402,    -1,    -1,   405,   406,    -1,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,    -1,    -1,   424,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,   107,    -1,   109,
     110,    -1,   112,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,    -1,   137,    -1,   139,
     140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,    -1,    -1,   188,   189,
     190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,    -1,    -1,   205,    -1,   207,   208,   209,
     210,    -1,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,    -1,    -1,    -1,   226,   227,   228,   229,
     230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,
     240,   241,   242,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,   252,    -1,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,   268,    -1,
     270,   271,   272,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,    -1,   283,    -1,    -1,   286,   287,   288,    -1,
      -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,    -1,
      -1,    -1,    -1,   303,   304,   305,   306,    -1,    -1,    -1,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,    -1,   337,   338,    -1,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,    -1,   385,    -1,    -1,   388,   389,
     390,   391,   392,    -1,    -1,   395,   396,   397,   398,    -1,
      -1,   401,   402,    -1,    -1,   405,   406,    -1,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,    -1,    -1,   424,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,   107,    -1,   109,
     110,    -1,   112,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,    -1,   137,    -1,   139,
     140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,    -1,    -1,   188,   189,
     190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,    -1,    -1,   205,    -1,   207,   208,   209,
     210,    -1,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,    -1,    -1,    -1,   226,   227,   228,   229,
     230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,
     240,   241,   242,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,   252,    -1,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,   268,    -1,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,    -1,
     280,   281,    -1,   283,   284,    -1,   286,   287,   288,    -1,
      -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,    -1,
      -1,    -1,    -1,   303,   304,   305,   306,    -1,    -1,    -1,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,    -1,   337,   338,    -1,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,    -1,   385,    -1,    -1,   388,   389,
     390,   391,   392,    -1,    -1,   395,   396,   397,   398,    -1,
      -1,   401,   402,    -1,    -1,   405,   406,    -1,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,    -1,    -1,   424,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,   107,    -1,   109,
     110,    -1,   112,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,    -1,   137,    -1,   139,
     140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,    -1,    -1,   188,   189,
     190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,    -1,    -1,   205,    -1,   207,   208,   209,
     210,    -1,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,    -1,    -1,    -1,   226,   227,   228,   229,
     230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,
     240,   241,   242,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,   252,    -1,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,   268,    -1,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,    -1,
     280,   281,    -1,   283,    -1,    -1,   286,   287,   288,    -1,
      -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,    -1,
      -1,    -1,    -1,   303,   304,   305,   306,    -1,    -1,    -1,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,    -1,   337,   338,    -1,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,    -1,   385,    -1,    -1,   388,   389,
     390,   391,   392,    -1,    -1,   395,   396,   397,   398,    -1,
      -1,   401,   402,    -1,    -1,   405,   406,    -1,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,    -1,    -1,   424,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,   107,    -1,   109,
     110,    -1,   112,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,    -1,   137,    -1,   139,
     140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,    -1,   184,    -1,    -1,    -1,   188,   189,
     190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,    -1,    -1,   205,    -1,   207,   208,   209,
     210,    -1,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,    -1,    -1,    -1,   226,   227,   228,   229,
     230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,
     240,   241,   242,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,   252,    -1,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,   268,    -1,
     270,   271,   272,   273,   274,   275,   276,    -1,   278,    -1,
     280,   281,    -1,   283,    -1,    -1,   286,   287,   288,    -1,
      -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,    -1,
      -1,    -1,    -1,   303,   304,   305,   306,    -1,    -1,    -1,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,    -1,   337,   338,    -1,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,    -1,   352,    -1,   354,   355,    -1,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,    -1,   385,    -1,    -1,   388,   389,
     390,   391,   392,    -1,    -1,   395,   396,   397,   398,    -1,
      -1,   401,   402,    -1,    -1,   405,   406,    -1,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,    -1,    -1,   424,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,    -1,   108,   109,   110,
      -1,   112,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,    -1,   153,   154,   155,   156,   157,   158,   159,   160,
      -1,   162,   163,   164,   165,   166,   167,   168,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   180,
     181,   182,   183,   184,    -1,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,   196,   197,   198,    -1,   200,
     201,   202,   203,   204,   205,   206,   207,   208,    -1,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,    -1,   226,   227,   228,    -1,   230,
     231,   232,   233,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,    -1,
     26