/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONTINUE = 265,
     SQL_COUNT = 266,
     SQL_CURRENT = 267,
     SQL_DATA = 268,
     SQL_DATETIME_INTERVAL_CODE = 269,
     SQL_DATETIME_INTERVAL_PRECISION = 270,
     SQL_DESCRIBE = 271,
     SQL_DESCRIPTOR = 272,
     SQL_DISCONNECT = 273,
     SQL_ENUM = 274,
     SQL_FOUND = 275,
     SQL_FREE = 276,
     SQL_GO = 277,
     SQL_GOTO = 278,
     SQL_IDENTIFIED = 279,
     SQL_INDICATOR = 280,
     SQL_KEY_MEMBER = 281,
     SQL_LENGTH = 282,
     SQL_LONG = 283,
     SQL_NAME = 284,
     SQL_NULLABLE = 285,
     SQL_OCTET_LENGTH = 286,
     SQL_OPEN = 287,
     SQL_OUTPUT = 288,
     SQL_REFERENCE = 289,
     SQL_RETURNED_LENGTH = 290,
     SQL_RETURNED_OCTET_LENGTH = 291,
     SQL_SCALE = 292,
     SQL_SECTION = 293,
     SQL_SHORT = 294,
     SQL_SIGNED = 295,
     SQL_SQL = 296,
     SQL_SQLERROR = 297,
     SQL_SQLPRINT = 298,
     SQL_SQLWARNING = 299,
     SQL_START = 300,
     SQL_STOP = 301,
     SQL_STRUCT = 302,
     SQL_UNSIGNED = 303,
     SQL_VALUE = 304,
     SQL_VAR = 305,
     SQL_WHENEVER = 306,
     S_ADD = 307,
     S_AND = 308,
     S_ANYTHING = 309,
     S_AUTO = 310,
     S_CONST = 311,
     S_DEC = 312,
     S_DIV = 313,
     S_DOTPOINT = 314,
     S_EQUAL = 315,
     S_EXTERN = 316,
     S_INC = 317,
     S_LSHIFT = 318,
     S_MEMPOINT = 319,
     S_MEMBER = 320,
     S_MOD = 321,
     S_MUL = 322,
     S_NEQUAL = 323,
     S_OR = 324,
     S_REGISTER = 325,
     S_RSHIFT = 326,
     S_STATIC = 327,
     S_SUB = 328,
     S_VOLATILE = 329,
     S_TYPEDEF = 330,
     TYPECAST = 331,
     ABORT_P = 332,
     ABSOLUTE_P = 333,
     ACCESS = 334,
     ACTION = 335,
     ADD = 336,
     ADMIN = 337,
     AFTER = 338,
     AGGREGATE = 339,
     ALL = 340,
     ALSO = 341,
     ALTER = 342,
     ANALYSE = 343,
     ANALYZE = 344,
     AND = 345,
     ANY = 346,
     ARRAY = 347,
     AS = 348,
     ASC = 349,
     ASSERTION = 350,
     ASSIGNMENT = 351,
     ASYMMETRIC = 352,
     AT = 353,
     AUTHORIZATION = 354,
     BACKWARD = 355,
     BEFORE = 356,
     BEGIN_P = 357,
     BETWEEN = 358,
     BIGINT = 359,
     BINARY = 360,
     BIT = 361,
     BOOLEAN_P = 362,
     BOTH = 363,
     BY = 364,
     CACHE = 365,
     CALLED = 366,
     CASCADE = 367,
     CASE = 368,
     CAST = 369,
     CHAIN = 370,
     CHAR_P = 371,
     CHARACTER = 372,
     CHARACTERISTICS = 373,
     CHECK = 374,
     CHECKPOINT = 375,
     CLASS = 376,
     CLOSE = 377,
     CLUSTER = 378,
     COALESCE = 379,
     COLLATE = 380,
     COLUMN = 381,
     COMMENT = 382,
     COMMIT = 383,
     COMMITTED = 384,
     CONNECTION = 385,
     CONSTRAINT = 386,
     CONSTRAINTS = 387,
     CONVERSION_P = 388,
     CONVERT = 389,
     COPY = 390,
     CREATE = 391,
     CREATEDB = 392,
     CREATEROLE = 393,
     CREATEUSER = 394,
     CROSS = 395,
     CSV = 396,
     CURRENT_DATE = 397,
     CURRENT_ROLE = 398,
     CURRENT_TIME = 399,
     CURRENT_TIMESTAMP = 400,
     CURRENT_USER = 401,
     CURSOR = 402,
     CYCLE = 403,
     DATABASE = 404,
     DAY_P = 405,
     DEALLOCATE = 406,
     DEC = 407,
     DECIMAL_P = 408,
     DECLARE = 409,
     DEFAULT = 410,
     DEFAULTS = 411,
     DEFERRABLE = 412,
     DEFERRED = 413,
     DEFINER = 414,
     DELETE_P = 415,
     DELIMITER = 416,
     DELIMITERS = 417,
     DESC = 418,
     DISABLE_P = 419,
     DISTINCT = 420,
     DO = 421,
     DOMAIN_P = 422,
     DOUBLE_P = 423,
     DROP = 424,
     EACH = 425,
     ELSE = 426,
     ENABLE_P = 427,
     ENCODING = 428,
     ENCRYPTED = 429,
     END_P = 430,
     ESCAPE = 431,
     EXCEPT = 432,
     EXCLUSIVE = 433,
     EXCLUDING = 434,
     EXECUTE = 435,
     EXISTS = 436,
     EXPLAIN = 437,
     EXTERNAL = 438,
     EXTRACT = 439,
     FALSE_P = 440,
     FETCH = 441,
     FIRST_P = 442,
     FLOAT_P = 443,
     FOR = 444,
     FORCE = 445,
     FOREIGN = 446,
     FORWARD = 447,
     FREEZE = 448,
     FROM = 449,
     FULL = 450,
     FUNCTION = 451,
     GET = 452,
     GLOBAL = 453,
     GRANT = 454,
     GRANTED = 455,
     GREATEST = 456,
     GROUP_P = 457,
     HANDLER = 458,
     HAVING = 459,
     HEADER = 460,
     HOLD = 461,
     HOUR_P = 462,
     ILIKE = 463,
     IMMEDIATE = 464,
     IMMUTABLE = 465,
     IMPLICIT_P = 466,
     IN_P = 467,
     INCLUDING = 468,
     INCREMENT = 469,
     INDEX = 470,
     INHERIT = 471,
     INHERITS = 472,
     INITIALLY = 473,
     INNER_P = 474,
     INOUT = 475,
     INPUT_P = 476,
     INSENSITIVE = 477,
     INSERT = 478,
     INSTEAD = 479,
     INT_P = 480,
     INTEGER = 481,
     INTERSECT = 482,
     INTERVAL = 483,
     INTO = 484,
     INVOKER = 485,
     IS = 486,
     ISNULL = 487,
     ISOLATION = 488,
     JOIN = 489,
     KEY = 490,
     LANCOMPILER = 491,
     LANGUAGE = 492,
     LARGE_P = 493,
     LAST_P = 494,
     LEADING = 495,
     LEAST = 496,
     LEFT = 497,
     LEVEL = 498,
     LIKE = 499,
     LIMIT = 500,
     LISTEN = 501,
     LOAD = 502,
     LOCAL = 503,
     LOCALTIME = 504,
     LOCALTIMESTAMP = 505,
     LOCATION = 506,
     LOCK_P = 507,
     LOGIN_P = 508,
     MATCH = 509,
     MAXVALUE = 510,
     MINUTE_P = 511,
     MINVALUE = 512,
     MODE = 513,
     MONTH_P = 514,
     MOVE = 515,
     NAMES = 516,
     NATIONAL = 517,
     NATURAL = 518,
     NCHAR = 519,
     NEW = 520,
     NEXT = 521,
     NO = 522,
     NOCREATEDB = 523,
     NOCREATEROLE = 524,
     NOCREATEUSER = 525,
     NOINHERIT = 526,
     NOLOGIN_P = 527,
     NONE = 528,
     NOSUPERUSER = 529,
     NOT = 530,
     NOTHING = 531,
     NOTIFY = 532,
     NOTNULL = 533,
     NOWAIT = 534,
     NULL_P = 535,
     NULLIF = 536,
     NUMERIC = 537,
     OBJECT_P = 538,
     OF = 539,
     OFF = 540,
     OFFSET = 541,
     OIDS = 542,
     OLD = 543,
     ON = 544,
     ONLY = 545,
     OPERATOR = 546,
     OPTION = 547,
     OR = 548,
     ORDER = 549,
     OUT_P = 550,
     OUTER_P = 551,
     OVERLAPS = 552,
     OVERLAY = 553,
     OWNER = 554,
     PARTIAL = 555,
     PASSWORD = 556,
     PLACING = 557,
     POSITION = 558,
     PRECISION = 559,
     PRESERVE = 560,
     PREPARE = 561,
     PREPARED = 562,
     PRIMARY = 563,
     PRIOR = 564,
     PRIVILEGES = 565,
     PROCEDURAL = 566,
     PROCEDURE = 567,
     QUOTE = 568,
     READ = 569,
     REAL = 570,
     RECHECK = 571,
     REFERENCES = 572,
     REINDEX = 573,
     RELATIVE_P = 574,
     RELEASE = 575,
     RENAME = 576,
     REPEATABLE = 577,
     REPLACE = 578,
     RESET = 579,
     RESTART = 580,
     RESTRICT = 581,
     RETURNS = 582,
     REVOKE = 583,
     RIGHT = 584,
     ROLE = 585,
     ROLLBACK = 586,
     ROW = 587,
     ROWS = 588,
     RULE = 589,
     SAVEPOINT = 590,
     SCHEMA = 591,
     SCROLL = 592,
     SECOND_P = 593,
     SECURITY = 594,
     SELECT = 595,
     SEQUENCE = 596,
     SERIALIZABLE = 597,
     SESSION = 598,
     SESSION_USER = 599,
     SET = 600,
     SETOF = 601,
     SHARE = 602,
     SHOW = 603,
     SIMILAR = 604,
     SIMPLE = 605,
     SMALLINT = 606,
     SOME = 607,
     STABLE = 608,
     START = 609,
     STATEMENT = 610,
     STATISTICS = 611,
     STDIN = 612,
     STDOUT = 613,
     STORAGE = 614,
     STRICT_P = 615,
     SUBSTRING = 616,
     SUPERUSER_P = 617,
     SYMMETRIC = 618,
     SYSID = 619,
     SYSTEM_P = 620,
     TABLE = 621,
     TABLESPACE = 622,
     TEMP = 623,
     TEMPLATE = 624,
     TEMPORARY = 625,
     THEN = 626,
     TIME = 627,
     TIMESTAMP = 628,
     TO = 629,
     TOAST = 630,
     TRAILING = 631,
     TRANSACTION = 632,
     TREAT = 633,
     TRIGGER = 634,
     TRIM = 635,
     TRUE_P = 636,
     TRUNCATE = 637,
     TRUSTED = 638,
     TYPE_P = 639,
     UNCOMMITTED = 640,
     UNENCRYPTED = 641,
     UNION = 642,
     UNIQUE = 643,
     UNKNOWN = 644,
     UNLISTEN = 645,
     UNTIL = 646,
     UPDATE = 647,
     USER = 648,
     USING = 649,
     VACUUM = 650,
     VALID = 651,
     VALIDATOR = 652,
     VALUES = 653,
     VARCHAR = 654,
     VARYING = 655,
     VERBOSE = 656,
     VIEW = 657,
     VOLATILE = 658,
     WHEN = 659,
     WHERE = 660,
     WITH = 661,
     WITHOUT = 662,
     WORK = 663,
     WRITE = 664,
     YEAR_P = 665,
     ZONE = 666,
     UNIONJOIN = 667,
     IDENT = 668,
     SCONST = 669,
     Op = 670,
     CSTRING = 671,
     CVARIABLE = 672,
     CPP_LINE = 673,
     IP = 674,
     BCONST = 675,
     XCONST = 676,
     ICONST = 677,
     PARAM = 678,
     FCONST = 679,
     POSTFIXOP = 680,
     UMINUS = 681
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONTINUE 265
#define SQL_COUNT 266
#define SQL_CURRENT 267
#define SQL_DATA 268
#define SQL_DATETIME_INTERVAL_CODE 269
#define SQL_DATETIME_INTERVAL_PRECISION 270
#define SQL_DESCRIBE 271
#define SQL_DESCRIPTOR 272
#define SQL_DISCONNECT 273
#define SQL_ENUM 274
#define SQL_FOUND 275
#define SQL_FREE 276
#define SQL_GO 277
#define SQL_GOTO 278
#define SQL_IDENTIFIED 279
#define SQL_INDICATOR 280
#define SQL_KEY_MEMBER 281
#define SQL_LENGTH 282
#define SQL_LONG 283
#define SQL_NAME 284
#define SQL_NULLABLE 285
#define SQL_OCTET_LENGTH 286
#define SQL_OPEN 287
#define SQL_OUTPUT 288
#define SQL_REFERENCE 289
#define SQL_RETURNED_LENGTH 290
#define SQL_RETURNED_OCTET_LENGTH 291
#define SQL_SCALE 292
#define SQL_SECTION 293
#define SQL_SHORT 294
#define SQL_SIGNED 295
#define SQL_SQL 296
#define SQL_SQLERROR 297
#define SQL_SQLPRINT 298
#define SQL_SQLWARNING 299
#define SQL_START 300
#define SQL_STOP 301
#define SQL_STRUCT 302
#define SQL_UNSIGNED 303
#define SQL_VALUE 304
#define SQL_VAR 305
#define SQL_WHENEVER 306
#define S_ADD 307
#define S_AND 308
#define S_ANYTHING 309
#define S_AUTO 310
#define S_CONST 311
#define S_DEC 312
#define S_DIV 313
#define S_DOTPOINT 314
#define S_EQUAL 315
#define S_EXTERN 316
#define S_INC 317
#define S_LSHIFT 318
#define S_MEMPOINT 319
#define S_MEMBER 320
#define S_MOD 321
#define S_MUL 322
#define S_NEQUAL 323
#define S_OR 324
#define S_REGISTER 325
#define S_RSHIFT 326
#define S_STATIC 327
#define S_SUB 328
#define S_VOLATILE 329
#define S_TYPEDEF 330
#define TYPECAST 331
#define ABORT_P 332
#define ABSOLUTE_P 333
#define ACCESS 334
#define ACTION 335
#define ADD 336
#define ADMIN 337
#define AFTER 338
#define AGGREGATE 339
#define ALL 340
#define ALSO 341
#define ALTER 342
#define ANALYSE 343
#define ANALYZE 344
#define AND 345
#define ANY 346
#define ARRAY 347
#define AS 348
#define ASC 349
#define ASSERTION 350
#define ASSIGNMENT 351
#define ASYMMETRIC 352
#define AT 353
#define AUTHORIZATION 354
#define BACKWARD 355
#define BEFORE 356
#define BEGIN_P 357
#define BETWEEN 358
#define BIGINT 359
#define BINARY 360
#define BIT 361
#define BOOLEAN_P 362
#define BOTH 363
#define BY 364
#define CACHE 365
#define CALLED 366
#define CASCADE 367
#define CASE 368
#define CAST 369
#define CHAIN 370
#define CHAR_P 371
#define CHARACTER 372
#define CHARACTERISTICS 373
#define CHECK 374
#define CHECKPOINT 375
#define CLASS 376
#define CLOSE 377
#define CLUSTER 378
#define COALESCE 379
#define COLLATE 380
#define COLUMN 381
#define COMMENT 382
#define COMMIT 383
#define COMMITTED 384
#define CONNECTION 385
#define CONSTRAINT 386
#define CONSTRAINTS 387
#define CONVERSION_P 388
#define CONVERT 389
#define COPY 390
#define CREATE 391
#define CREATEDB 392
#define CREATEROLE 393
#define CREATEUSER 394
#define CROSS 395
#define CSV 396
#define CURRENT_DATE 397
#define CURRENT_ROLE 398
#define CURRENT_TIME 399
#define CURRENT_TIMESTAMP 400
#define CURRENT_USER 401
#define CURSOR 402
#define CYCLE 403
#define DATABASE 404
#define DAY_P 405
#define DEALLOCATE 406
#define DEC 407
#define DECIMAL_P 408
#define DECLARE 409
#define DEFAULT 410
#define DEFAULTS 411
#define DEFERRABLE 412
#define DEFERRED 413
#define DEFINER 414
#define DELETE_P 415
#define DELIMITER 416
#define DELIMITERS 417
#define DESC 418
#define DISABLE_P 419
#define DISTINCT 420
#define DO 421
#define DOMAIN_P 422
#define DOUBLE_P 423
#define DROP 424
#define EACH 425
#define ELSE 426
#define ENABLE_P 427
#define ENCODING 428
#define ENCRYPTED 429
#define END_P 430
#define ESCAPE 431
#define EXCEPT 432
#define EXCLUSIVE 433
#define EXCLUDING 434
#define EXECUTE 435
#define EXISTS 436
#define EXPLAIN 437
#define EXTERNAL 438
#define EXTRACT 439
#define FALSE_P 440
#define FETCH 441
#define FIRST_P 442
#define FLOAT_P 443
#define FOR 444
#define FORCE 445
#define FOREIGN 446
#define FORWARD 447
#define FREEZE 448
#define FROM 449
#define FULL 450
#define FUNCTION 451
#define GET 452
#define GLOBAL 453
#define GRANT 454
#define GRANTED 455
#define GREATEST 456
#define GROUP_P 457
#define HANDLER 458
#define HAVING 459
#define HEADER 460
#define HOLD 461
#define HOUR_P 462
#define ILIKE 463
#define IMMEDIATE 464
#define IMMUTABLE 465
#define IMPLICIT_P 466
#define IN_P 467
#define INCLUDING 468
#define INCREMENT 469
#define INDEX 470
#define INHERIT 471
#define INHERITS 472
#define INITIALLY 473
#define INNER_P 474
#define INOUT 475
#define INPUT_P 476
#define INSENSITIVE 477
#define INSERT 478
#define INSTEAD 479
#define INT_P 480
#define INTEGER 481
#define INTERSECT 482
#define INTERVAL 483
#define INTO 484
#define INVOKER 485
#define IS 486
#define ISNULL 487
#define ISOLATION 488
#define JOIN 489
#define KEY 490
#define LANCOMPILER 491
#define LANGUAGE 492
#define LARGE_P 493
#define LAST_P 494
#define LEADING 495
#define LEAST 496
#define LEFT 497
#define LEVEL 498
#define LIKE 499
#define LIMIT 500
#define LISTEN 501
#define LOAD 502
#define LOCAL 503
#define LOCALTIME 504
#define LOCALTIMESTAMP 505
#define LOCATION 506
#define LOCK_P 507
#define LOGIN_P 508
#define MATCH 509
#define MAXVALUE 510
#define MINUTE_P 511
#define MINVALUE 512
#define MODE 513
#define MONTH_P 514
#define MOVE 515
#define NAMES 516
#define NATIONAL 517
#define NATURAL 518
#define NCHAR 519
#define NEW 520
#define NEXT 521
#define NO 522
#define NOCREATEDB 523
#define NOCREATEROLE 524
#define NOCREATEUSER 525
#define NOINHERIT 526
#define NOLOGIN_P 527
#define NONE 528
#define NOSUPERUSER 529
#define NOT 530
#define NOTHING 531
#define NOTIFY 532
#define NOTNULL 533
#define NOWAIT 534
#define NULL_P 535
#define NULLIF 536
#define NUMERIC 537
#define OBJECT_P 538
#define OF 539
#define OFF 540
#define OFFSET 541
#define OIDS 542
#define OLD 543
#define ON 544
#define ONLY 545
#define OPERATOR 546
#define OPTION 547
#define OR 548
#define ORDER 549
#define OUT_P 550
#define OUTER_P 551
#define OVERLAPS 552
#define OVERLAY 553
#define OWNER 554
#define PARTIAL 555
#define PASSWORD 556
#define PLACING 557
#define POSITION 558
#define PRECISION 559
#define PRESERVE 560
#define PREPARE 561
#define PREPARED 562
#define PRIMARY 563
#define PRIOR 564
#define PRIVILEGES 565
#define PROCEDURAL 566
#define PROCEDURE 567
#define QUOTE 568
#define READ 569
#define REAL 570
#define RECHECK 571
#define REFERENCES 572
#define REINDEX 573
#define RELATIVE_P 574
#define RELEASE 575
#define RENAME 576
#define REPEATABLE 577
#define REPLACE 578
#define RESET 579
#define RESTART 580
#define RESTRICT 581
#define RETURNS 582
#define REVOKE 583
#define RIGHT 584
#define ROLE 585
#define ROLLBACK 586
#define ROW 587
#define ROWS 588
#define RULE 589
#define SAVEPOINT 590
#define SCHEMA 591
#define SCROLL 592
#define SECOND_P 593
#define SECURITY 594
#define SELECT 595
#define SEQUENCE 596
#define SERIALIZABLE 597
#define SESSION 598
#define SESSION_USER 599
#define SET 600
#define SETOF 601
#define SHARE 602
#define SHOW 603
#define SIMILAR 604
#define SIMPLE 605
#define SMALLINT 606
#define SOME 607
#define STABLE 608
#define START 609
#define STATEMENT 610
#define STATISTICS 611
#define STDIN 612
#define STDOUT 613
#define STORAGE 614
#define STRICT_P 615
#define SUBSTRING 616
#define SUPERUSER_P 617
#define SYMMETRIC 618
#define SYSID 619
#define SYSTEM_P 620
#define TABLE 621
#define TABLESPACE 622
#define TEMP 623
#define TEMPLATE 624
#define TEMPORARY 625
#define THEN 626
#define TIME 627
#define TIMESTAMP 628
#define TO 629
#define TOAST 630
#define TRAILING 631
#define TRANSACTION 632
#define TREAT 633
#define TRIGGER 634
#define TRIM 635
#define TRUE_P 636
#define TRUNCATE 637
#define TRUSTED 638
#define TYPE_P 639
#define UNCOMMITTED 640
#define UNENCRYPTED 641
#define UNION 642
#define UNIQUE 643
#define UNKNOWN 644
#define UNLISTEN 645
#define UNTIL 646
#define UPDATE 647
#define USER 648
#define USING 649
#define VACUUM 650
#define VALID 651
#define VALIDATOR 652
#define VALUES 653
#define VARCHAR 654
#define VARYING 655
#define VERBOSE 656
#define VIEW 657
#define VOLATILE 658
#define WHEN 659
#define WHERE 660
#define WITH 661
#define WITHOUT 662
#define WORK 663
#define WRITE 664
#define YEAR_P 665
#define ZONE 666
#define UNIONJOIN 667
#define IDENT 668
#define SCONST 669
#define Op 670
#define CSTRING 671
#define CVARIABLE 672
#define CPP_LINE 673
#define IP 674
#define BCONST 675
#define XCONST 676
#define ICONST 677
#define PARAM 678
#define FCONST 679
#define POSTFIXOP 680
#define UMINUS 681




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, 0L, NULL, {NULL}};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, 0L, NULL, {NULL}};

static struct inf_compat_col
{
	char *name;
	char *indirection;
	struct inf_compat_col *next;
} *informix_col;

static struct inf_compat_val
{
	char *val;
	struct inf_compat_val *next;
} *informix_val;

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error, ...)
{
	va_list ap;
	
	fprintf(stderr, "%s:%d: ", input_filename, yylineno);
	
	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "WARNING: ");
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, "ERROR: ");
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);
	
	fprintf(stderr, "\n");
	
	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct 
	 * An array is only allowed together with an element argument 
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else 
	 * so we don't have to worry here. */
	
	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
		result = cat2_str(result, make_str("? , "));

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * { 
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming. 
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable 
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;
		
	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);
		
		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1")), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}
		
		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		
		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);
			
			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "trying to access an undeclared cursor %s\n", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier 
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);
	
	return ptr;
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 312 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1249 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1261 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   56278

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  447
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  528
/* YYNRULES -- Number of rules. */
#define YYNRULES  2025
/* YYNRULES -- Number of states. */
#define YYNSTATES  3360

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   682

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   433,     2,     2,
     438,   439,   431,   429,   445,   430,   440,   432,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   446,   441,
     426,   425,   427,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   436,     2,   437,   434,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   442,     2,   443,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     428,   435,   444
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   212,   214,   216,   218,   220,   222,   224,
     226,   228,   230,   232,   234,   240,   242,   243,   246,   250,
     254,   256,   258,   260,   262,   264,   266,   268,   270,   272,
     274,   278,   282,   285,   288,   291,   294,   298,   302,   308,
     314,   320,   325,   331,   337,   342,   346,   350,   356,   363,
     365,   367,   371,   378,   383,   385,   386,   389,   390,   392,
     394,   396,   398,   400,   402,   405,   409,   413,   417,   421,
     425,   428,   434,   437,   440,   444,   448,   450,   454,   456,
     458,   460,   464,   467,   470,   473,   475,   477,   479,   481,
     483,   485,   487,   489,   491,   493,   497,   504,   506,   508,
     510,   512,   513,   515,   517,   520,   524,   529,   533,   536,
     539,   543,   548,   552,   555,   560,   562,   564,   566,   568,
     570,   575,   580,   582,   586,   590,   595,   602,   609,   616,
     623,   628,   635,   638,   643,   647,   651,   655,   659,   663,
     667,   671,   675,   679,   683,   685,   689,   693,   697,   701,
     704,   706,   708,   709,   712,   713,   716,   726,   728,   730,
     732,   734,   736,   739,   740,   742,   744,   748,   752,   754,
     756,   760,   764,   768,   773,   775,   776,   779,   780,   784,
     785,   787,   788,   800,   813,   815,   817,   820,   823,   826,
     829,   830,   832,   833,   835,   839,   841,   843,   845,   849,
     852,   853,   857,   859,   861,   864,   866,   869,   873,   878,
     881,   887,   889,   892,   895,   898,   902,   905,   908,   909,
     913,   915,   920,   926,   933,   945,   949,   950,   954,   956,
     958,   961,   964,   965,   967,   969,   972,   975,   976,   980,
     984,   987,   989,   991,   994,   997,  1002,  1003,  1006,  1009,
    1010,  1014,  1019,  1024,  1025,  1028,  1029,  1034,  1035,  1036,
    1045,  1049,  1053,  1055,  1059,  1060,  1064,  1066,  1068,  1074,
    1079,  1082,  1083,  1086,  1088,  1091,  1095,  1098,  1101,  1104,
    1107,  1111,  1115,  1117,  1118,  1124,  1134,  1136,  1137,  1139,
    1142,  1145,  1146,  1149,  1150,  1156,  1158,  1159,  1166,  1169,
    1170,  1174,  1189,  1209,  1211,  1213,  1215,  1219,  1225,  1227,
    1229,  1231,  1235,  1236,  1238,  1239,  1241,  1243,  1245,  1249,
    1250,  1252,  1254,  1255,  1258,  1260,  1263,  1265,  1268,  1271,
    1273,  1276,  1279,  1286,  1295,  1299,  1304,  1309,  1314,  1320,
    1324,  1328,  1330,  1334,  1338,  1340,  1342,  1344,  1346,  1359,
    1361,  1365,  1370,  1378,  1383,  1386,  1388,  1389,  1391,  1392,
    1400,  1405,  1407,  1409,  1411,  1413,  1415,  1417,  1419,  1421,
    1423,  1427,  1429,  1432,  1435,  1439,  1443,  1449,  1454,  1459,
    1463,  1468,  1472,  1476,  1479,  1484,  1487,  1489,  1491,  1493,
    1495,  1498,  1501,  1503,  1505,  1507,  1510,  1513,  1515,  1518,
    1521,  1523,  1525,  1532,  1542,  1550,  1560,  1569,  1578,  1585,
    1595,  1603,  1614,  1622,  1624,  1626,  1628,  1630,  1632,  1634,
    1636,  1638,  1640,  1642,  1644,  1646,  1654,  1662,  1673,  1676,
    1678,  1680,  1682,  1686,  1688,  1690,  1692,  1694,  1696,  1699,
    1702,  1705,  1708,  1711,  1714,  1716,  1720,  1722,  1725,  1729,
    1730,  1732,  1736,  1739,  1746,  1753,  1757,  1758,  1762,  1763,
    1776,  1778,  1779,  1782,  1783,  1785,  1789,  1792,  1795,  1800,
    1802,  1805,  1806,  1816,  1824,  1827,  1828,  1832,  1835,  1837,
    1841,  1845,  1849,  1852,  1855,  1857,  1859,  1861,  1863,  1866,
    1868,  1872,  1874,  1876,  1878,  1883,  1885,  1888,  1893,  1899,
    1901,  1903,  1905,  1907,  1911,  1915,  1918,  1921,  1924,  1927,
    1929,  1932,  1933,  1939,  1941,  1944,  1946,  1947,  1953,  1961,
    1963,  1965,  1973,  1975,  1979,  1983,  1987,  1989,  1993,  2005,
    2016,  2019,  2020,  2029,  2034,  2039,  2044,  2046,  2048,  2050,
    2051,  2061,  2068,  2075,  2083,  2090,  2097,  2107,  2114,  2121,
    2128,  2137,  2146,  2153,  2160,  2162,  2163,  2173,  2180,  2188,
    2195,  2202,  2209,  2219,  2226,  2233,  2240,  2248,  2258,  2268,
    2275,  2282,  2289,  2290,  2305,  2307,  2309,  2313,  2317,  2319,
    2321,  2323,  2325,  2327,  2329,  2331,  2332,  2334,  2336,  2338,
    2340,  2342,  2344,  2345,  2352,  2355,  2358,  2361,  2364,  2367,
    2371,  2375,  2378,  2381,  2384,  2387,  2391,  2394,  2400,  2405,
    2409,  2413,  2417,  2419,  2421,  2422,  2426,  2429,  2432,  2434,
    2438,  2441,  2443,  2444,  2452,  2462,  2465,  2471,  2475,  2477,
    2480,  2484,  2488,  2492,  2496,  2500,  2504,  2508,  2512,  2517,
    2521,  2525,  2527,  2528,  2534,  2540,  2545,  2548,  2549,  2554,
    2558,  2565,  2570,  2577,  2584,  2590,  2598,  2600,  2601,  2612,
    2617,  2620,  2622,  2627,  2633,  2639,  2642,  2647,  2649,  2651,
    2653,  2654,  2656,  2657,  2659,  2660,  2664,  2665,  2670,  2672,
    2674,  2676,  2678,  2680,  2682,  2683,  2688,  2693,  2696,  2698,
    2706,  2711,  2715,  2717,  2720,  2726,  2729,  2730,  2736,  2740,
    2741,  2744,  2747,  2750,  2754,  2756,  2760,  2762,  2765,  2767,
    2768,  2775,  2783,  2784,  2787,  2790,  2793,  2797,  2798,  2801,
    2804,  2806,  2808,  2812,  2816,  2818,  2821,  2826,  2831,  2833,
    2835,  2844,  2849,  2854,  2859,  2862,  2864,  2865,  2869,  2873,
    2878,  2883,  2888,  2893,  2896,  2898,  2900,  2901,  2903,  2904,
    2906,  2912,  2914,  2915,  2917,  2918,  2922,  2924,  2928,  2932,
    2935,  2938,  2940,  2945,  2950,  2953,  2956,  2961,  2963,  2964,
    2966,  2968,  2970,  2974,  2975,  2978,  2979,  2984,  2989,  2993,
    2995,  2996,  2999,  3000,  3003,  3004,  3008,  3010,  3012,  3015,
    3017,  3020,  3026,  3033,  3039,  3041,  3044,  3046,  3051,  3055,
    3060,  3064,  3070,  3075,  3081,  3086,  3092,  3095,  3100,  3102,
    3105,  3108,  3111,  3113,  3115,  3116,  3121,  3124,  3126,  3129,
    3132,  3137,  3139,  3142,  3143,  3145,  3149,  3152,  3155,  3159,
    3165,  3172,  3176,  3181,  3182,  3184,  3188,  3192,  3196,  3200,
    3204,  3208,  3210,  3212,  3214,  3216,  3218,  3220,  3222,  3225,
    3231,  3234,  3236,  3238,  3240,  3242,  3244,  3246,  3248,  3250,
    3252,  3254,  3256,  3259,  3262,  3265,  3268,  3271,  3273,  3277,
    3278,  3284,  3288,  3289,  3295,  3299,  3300,  3302,  3304,  3306,
    3308,  3314,  3317,  3319,  3321,  3323,  3325,  3331,  3334,  3337,
    3340,  3342,  3346,  3350,  3353,  3355,  3356,  3360,  3361,  3367,
    3370,  3376,  3379,  3381,  3385,  3389,  3390,  3392,  3394,  3396,
    3398,  3400,  3402,  3406,  3410,  3414,  3418,  3422,  3426,  3430,
    3431,  3433,  3437,  3443,  3446,  3449,  3453,  3457,  3461,  3465,
    3469,  3473,  3477,  3481,  3485,  3489,  3492,  3495,  3499,  3503,
    3506,  3510,  3516,  3521,  3528,  3532,  3538,  3543,  3550,  3555,
    3562,  3568,  3576,  3579,  3583,  3586,  3591,  3595,  3600,  3604,
    3609,  3613,  3618,  3624,  3631,  3639,  3646,  3654,  3661,  3669,
    3673,  3678,  3683,  3690,  3693,  3695,  3699,  3702,  3706,  3710,
    3714,  3718,  3722,  3726,  3730,  3734,  3738,  3742,  3745,  3748,
    3754,  3761,  3769,  3771,  3773,  3776,  3781,  3783,  3785,  3787,
    3790,  3793,  3796,  3798,  3802,  3807,  3813,  3819,  3824,  3826,
    3828,  3833,  3835,  3840,  3842,  3847,  3849,  3854,  3856,  3858,
    3860,  3862,  3869,  3874,  3879,  3884,  3889,  3896,  3902,  3908,
    3914,  3919,  3926,  3931,  3938,  3943,  3948,  3953,  3958,  3962,
    3968,  3970,  3972,  3974,  3976,  3978,  3980,  3982,  3984,  3986,
    3988,  3990,  3992,  3994,  3996,  3998,  4003,  4005,  4010,  4012,
    4017,  4019,  4022,  4024,  4027,  4029,  4033,  4037,  4038,  4042,
    4044,  4046,  4050,  4054,  4058,  4060,  4062,  4064,  4066,  4068,
    4070,  4072,  4074,  4079,  4083,  4086,  4090,  4091,  4095,  4099,
    4102,  4105,  4107,  4108,  4111,  4114,  4118,  4121,  4123,  4125,
    4129,  4135,  4138,  4140,  4145,  4148,  4149,  4151,  4152,  4154,
    4157,  4160,  4163,  4167,  4173,  4175,  4178,  4179,  4182,  4184,
    4185,  4189,  4191,  4195,  4197,  4199,  4203,  4211,  4213,  4216,
    4221,  4223,  4227,  4232,  4237,  4241,  4243,  4245,  4247,  4249,
    4251,  4253,  4257,  4259,  4262,  4264,  4268,  4270,  4272,  4274,
    4276,  4278,  4280,  4282,  4285,  4287,  4290,  4294,  4301,  4303,
    4305,  4307,  4309,  4311,  4313,  4315,  4317,  4319,  4321,  4323,
    4325,  4328,  4330,  4332,  4334,  4336,  4339,  4342,  4344,  4346,
    4348,  4350,  4352,  4354,  4356,  4358,  4361,  4364,  4366,  4368,
    4370,  4372,  4374,  4376,  4378,  4380,  4382,  4384,  4386,  4388,
    4394,  4398,  4401,  4404,  4408,  4416,  4418,  4421,  4424,  4426,
    4427,  4429,  4433,  4435,  4438,  4439,  4442,  4443,  4446,  4447,
    4449,  4453,  4458,  4462,  4464,  4466,  4468,  4471,  4472,  4480,
    4484,  4487,  4489,  4491,  4493,  4494,  4500,  4501,  4506,  4509,
    4511,  4514,  4515,  4517,  4521,  4525,  4529,  4533,  4534,  4539,
    4545,  4551,  4552,  4554,  4556,  4558,  4560,  4563,  4566,  4569,
    4571,  4574,  4575,  4583,  4584,  4590,  4591,  4596,  4599,  4602,
    4604,  4606,  4608,  4610,  4612,  4614,  4616,  4618,  4620,  4622,
    4624,  4630,  4633,  4635,  4639,  4642,  4645,  4649,  4650,  4656,
    4658,  4659,  4665,  4668,  4671,  4673,  4675,  4677,  4680,  4683,
    4687,  4689,  4692,  4695,  4699,  4703,  4708,  4711,  4713,  4716,
    4718,  4720,  4723,  4726,  4730,  4732,  4734,  4736,  4738,  4739,
    4741,  4745,  4750,  4751,  4754,  4755,  4757,  4760,  4764,  4767,
    4769,  4771,  4773,  4774,  4776,  4778,  4782,  4783,  4788,  4791,
    4794,  4796,  4798,  4799,  4801,  4803,  4805,  4807,  4810,  4814,
    4815,  4817,  4820,  4822,  4827,  4832,  4833,  4835,  4838,  4840,
    4842,  4846,  4848,  4850,  4855,  4860,  4865,  4870,  4872,  4873,
    4877,  4881,  4886,  4888,  4892,  4896,  4901,  4903,  4907,  4911,
    4913,  4920,  4922,  4926,  4930,  4937,  4939,  4943,  4947,  4949,
    4951,  4953,  4955,  4957,  4959,  4961,  4963,  4965,  4967,  4969,
    4971,  4973,  4975,  4977,  4982,  4987,  4989,  4991,  4996,  5001,
    5005,  5006,  5014,  5016,  5017,  5018,  5026,  5030,  5035,  5039,
    5041,  5043,  5045,  5048,  5052,  5058,  5061,  5067,  5070,  5072,
    5074,  5076,  5078,  5080,  5082,  5084,  5086,  5088,  5090,  5092,
    5094,  5096,  5098,  5100,  5102,  5104,  5106,  5108,  5110,  5112,
    5114,  5116,  5118,  5120,  5122,  5124,  5126,  5128,  5130,  5132,
    5134,  5136,  5138,  5140,  5142,  5144,  5146,  5148,  5150,  5152,
    5154,  5156,  5158,  5160,  5162,  5164,  5166,  5168,  5170,  5172,
    5174,  5176,  5178,  5180,  5182,  5184,  5186,  5188,  5190,  5192,
    5194,  5196,  5198,  5200,  5202,  5204,  5206,  5208,  5210,  5212,
    5214,  5216,  5218,  5220,  5222,  5224,  5226,  5228,  5230,  5232,
    5234,  5236,  5238,  5240,  5242,  5244,  5246,  5248,  5250,  5252,
    5254,  5256,  5258,  5260,  5262,  5264,  5266,  5268,  5270,  5272,
    5274,  5276,  5278,  5280,  5282,  5284,  5286,  5288,  5290,  5292,
    5294,  5296,  5298,  5300,  5302,  5304,  5306,  5308,  5310,  5312,
    5314,  5316,  5318,  5320,  5322,  5324,  5326,  5328,  5330,  5332,
    5334,  5336,  5338,  5340,  5342,  5344,  5346,  5348,  5350,  5352,
    5354,  5356,  5358,  5360,  5362,  5364,  5366,  5368,  5370,  5372,
    5374,  5376,  5378,  5380,  5382,  5384,  5386,  5388,  5390,  5392,
    5394,  5396,  5398,  5400,  5402,  5404,  5406,  5408,  5410,  5412,
    5414,  5416,  5418,  5420,  5422,  5424,  5426,  5428,  5430,  5432,
    5434,  5436,  5438,  5440,  5442,  5444,  5446,  5448,  5450,  5452,
    5454,  5456,  5458,  5460,  5462,  5464,  5466,  5468,  5470,  5472,
    5474,  5476,  5478,  5480,  5482,  5484,  5486,  5488,  5490,  5492,
    5494,  5496,  5498,  5500,  5502,  5504,  5506,  5508,  5510,  5512,
    5514,  5516,  5518,  5520,  5522,  5524,  5526,  5528,  5530,  5532,
    5534,  5536,  5538,  5540,  5542,  5544,  5546,  5548,  5550,  5552,
    5554,  5556,  5558,  5560,  5562,  5564,  5566,  5568,  5570,  5572,
    5574,  5576,  5578,  5580,  5582,  5584,  5586,  5588,  5590,  5592,
    5594,  5596,  5598,  5600,  5602,  5604,  5606,  5608,  5610,  5612,
    5614,  5616,  5618,  5620,  5622,  5624,  5626,  5628,  5630,  5632,
    5634,  5636,  5638,  5640,  5642,  5644,  5646,  5648,  5650,  5652,
    5654,  5656,  5658,  5660,  5662,  5664,  5666,  5668,  5670,  5672,
    5674,  5676,  5678,  5680,  5682,  5684,  5686,  5688,  5690,  5692,
    5694,  5696,  5698,  5700,  5702,  5704,  5706,  5708,  5710,  5712,
    5714,  5716,  5718,  5720,  5722,  5724,  5726,  5728,  5730,  5732,
    5734,  5736,  5738,  5740,  5742,  5744,  5746,  5748,  5750,  5752,
    5754,  5756,  5758,  5760,  5762,  5764,  5766,  5768,  5770,  5772,
    5774,  5776,  5778,  5780,  5782,  5784,  5786,  5788,  5790,  5792,
    5794,  5796,  5798,  5800,  5802,  5804,  5806,  5808,  5810,  5812,
    5814,  5816,  5818,  5820,  5822,  5824,  5826,  5828,  5830,  5832,
    5834,  5836,  5838,  5840,  5842,  5844,  5846,  5848,  5850,  5852,
    5854,  5856,  5858,  5860,  5862,  5864,  5866,  5868,  5870,  5872,
    5874,  5876,  5878,  5880,  5882,  5884,  5886,  5888,  5890,  5892,
    5894,  5898,  5900,  5901,  5903,  5906,  5908,  5911,  5913,  5915,
    5918,  5921,  5923,  5925,  5927,  5929,  5931,  5933,  5936,  5940,
    5942,  5945,  5947,  5951,  5953,  5957,  5959,  5961,  5963,  5965,
    5967,  5969,  5971,  5973,  5975,  5977,  5979,  5981,  5983,  5985,
    5987,  5989,  5991,  5993,  5995,  5997,  5999,  6001,  6003,  6005,
    6007,  6009,  6011,  6013,  6015,  6017,  6019,  6021,  6023,  6025,
    6027,  6029,  6031,  6033,  6035,  6037,  6039,  6041,  6043,  6045,
    6047,  6049,  6051,  6053,  6055,  6057,  6059,  6061,  6063,  6065,
    6067,  6069,  6071,  6073,  6075,  6077
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     448,     0,    -1,   449,    -1,    -1,   449,   450,    -1,   960,
     451,   452,   441,    -1,   960,   452,   441,    -1,   960,   851,
      -1,   859,    -1,   973,    -1,   418,    -1,   442,    -1,   443,
      -1,    98,   837,    -1,   670,    -1,   671,    -1,   676,    -1,
     628,    -1,   463,    -1,   645,    -1,   646,    -1,   539,    -1,
     487,    -1,   458,    -1,   457,    -1,   459,    -1,   681,    -1,
     486,    -1,   495,    -1,   679,    -1,   590,    -1,   483,    -1,
     496,    -1,   532,    -1,   567,    -1,   637,    -1,   678,    -1,
     675,    -1,   614,    -1,   462,    -1,   543,    -1,   575,    -1,
     453,    -1,   466,    -1,   538,    -1,   505,    -1,   550,    -1,
     553,    -1,   456,    -1,   666,    -1,   701,    -1,   569,    -1,
     694,    -1,   568,    -1,   639,    -1,   465,    -1,   580,    -1,
     548,    -1,   460,    -1,   655,    -1,   581,    -1,   552,    -1,
     566,    -1,   461,    -1,   674,    -1,   687,    -1,   587,    -1,
     593,    -1,   604,    -1,   608,    -1,   690,    -1,   657,    -1,
     665,    -1,   696,    -1,   656,    -1,   640,    -1,   632,    -1,
     634,    -1,   631,    -1,   643,    -1,   594,    -1,   605,    -1,
     647,    -1,   704,    -1,   659,    -1,   586,    -1,   658,    -1,
     700,    -1,   680,    -1,   470,    -1,   481,    -1,   482,    -1,
     664,    -1,   913,    -1,   836,    -1,   849,    -1,   850,    -1,
     914,    -1,   891,    -1,   911,    -1,   892,    -1,   895,    -1,
     900,    -1,   922,    -1,   915,    -1,   901,    -1,   910,    -1,
     929,    -1,   931,    -1,   925,    -1,   918,    -1,   932,    -1,
     935,    -1,   937,    -1,   136,   330,   834,   454,   455,    -1,
     406,    -1,    -1,   301,   824,    -1,   174,   301,   824,    -1,
     386,   301,   824,    -1,   362,    -1,   274,    -1,   216,    -1,
     271,    -1,   137,    -1,   268,    -1,   138,    -1,   269,    -1,
     253,    -1,   272,    -1,   130,   245,   826,    -1,   396,   391,
     824,    -1,   393,   811,    -1,   364,   825,    -1,    82,   811,
      -1,   330,   811,    -1,   212,   330,   811,    -1,   212,   202,
     811,    -1,   136,   393,   834,   454,   455,    -1,    87,   330,
     834,   454,   455,    -1,    87,   330,   834,   345,   471,    -1,
      87,   330,   834,   482,    -1,    87,   393,   834,   454,   455,
      -1,    87,   393,   834,   345,   471,    -1,    87,   393,   834,
     482,    -1,   169,   330,   811,    -1,   169,   393,   811,    -1,
     136,   202,   834,   454,   455,    -1,    87,   202,   834,   464,
     393,   811,    -1,    81,    -1,   169,    -1,   169,   202,   811,
      -1,   136,   336,   467,    99,   834,   468,    -1,   136,   336,
     945,   468,    -1,   945,    -1,    -1,   468,   469,    -1,    -1,
     505,    -1,   608,    -1,   538,    -1,   553,    -1,   593,    -1,
     664,    -1,   345,   471,    -1,   345,   248,   471,    -1,   345,
     343,   471,    -1,   472,   374,   473,    -1,   472,   444,   473,
      -1,   372,   411,   478,    -1,   377,   662,    -1,   343,   118,
      93,   377,   662,    -1,   261,   479,    -1,   330,   480,    -1,
     343,    99,   480,    -1,   343,    99,   155,    -1,   944,    -1,
     472,   440,   945,    -1,   474,    -1,   155,    -1,   476,    -1,
     474,   445,   476,    -1,   314,   385,    -1,   314,   129,    -1,
     322,   314,    -1,   342,    -1,   477,    -1,   832,    -1,   945,
      -1,   381,    -1,   185,    -1,   289,    -1,   285,    -1,   832,
      -1,   967,    -1,   762,   829,   764,    -1,   762,   438,   825,
     439,   829,   764,    -1,   155,    -1,   248,    -1,   829,    -1,
     155,    -1,    -1,   945,    -1,   829,    -1,   348,   472,    -1,
     348,   372,   411,    -1,   348,   377,   233,   243,    -1,   348,
     343,    99,    -1,   348,    85,    -1,   324,   472,    -1,   324,
     372,   411,    -1,   324,   377,   233,   243,    -1,   324,   343,
      99,    -1,   324,    85,    -1,   345,   132,   484,   485,    -1,
      85,    -1,   811,    -1,   158,    -1,   209,    -1,   120,    -1,
      87,   366,   735,   488,    -1,    87,   215,   735,   490,    -1,
     489,    -1,   488,   445,   489,    -1,    81,   644,   510,    -1,
      87,   644,   945,   492,    -1,    87,   644,   945,   169,   275,
     280,    -1,    87,   644,   945,   345,   275,   280,    -1,    87,
     644,   945,   345,   356,   825,    -1,    87,   644,   945,   345,
     359,   945,    -1,   169,   644,   945,   493,    -1,    87,   644,
     945,   384,   740,   494,    -1,    81,   517,    -1,   169,   131,
     812,   493,    -1,   345,   407,   287,    -1,   136,   375,   366,
      -1,   123,   289,   812,    -1,   345,   407,   123,    -1,   172,
     379,   812,    -1,   172,   379,    85,    -1,   172,   379,   393,
      -1,   164,   379,   812,    -1,   164,   379,    85,    -1,   164,
     379,   393,    -1,   491,    -1,   490,   445,   491,    -1,   299,
     374,   834,    -1,   345,   367,   812,    -1,   345,   155,   765,
      -1,   169,   155,    -1,   112,    -1,   326,    -1,    -1,   394,
     765,    -1,    -1,   122,   812,    -1,   135,   501,   810,   502,
     497,   498,   503,   454,   499,    -1,   374,    -1,   194,    -1,
     829,    -1,   357,    -1,   358,    -1,   499,   500,    -1,    -1,
     105,    -1,   287,    -1,   161,   677,   829,    -1,   280,   677,
     829,    -1,   141,    -1,   205,    -1,   313,   677,   824,    -1,
     176,   677,   824,    -1,   190,   313,   520,    -1,   190,   275,
     280,   520,    -1,   105,    -1,    -1,   406,   287,    -1,    -1,
     504,   162,   829,    -1,    -1,   394,    -1,    -1,   136,   506,
     366,   810,   438,   507,   439,   527,   528,   529,   530,    -1,
     136,   506,   366,   810,   284,   810,   438,   507,   439,   528,
     529,   530,    -1,   370,    -1,   368,    -1,   248,   370,    -1,
     248,   368,    -1,   198,   370,    -1,   198,   368,    -1,    -1,
     508,    -1,    -1,   509,    -1,   508,   445,   509,    -1,   510,
      -1,   515,    -1,   517,    -1,   945,   740,   511,    -1,   511,
     512,    -1,    -1,   131,   812,   513,    -1,   513,    -1,   514,
      -1,   275,   280,    -1,   280,    -1,   388,   531,    -1,   308,
     235,   531,    -1,   119,   438,   765,   439,    -1,   155,   766,
      -1,   317,   810,   519,   522,   523,    -1,   157,    -1,   275,
     157,    -1,   218,   158,    -1,   218,   209,    -1,   244,   810,
     516,    -1,   213,   156,    -1,   179,   156,    -1,    -1,   131,
     812,   518,    -1,   518,    -1,   119,   438,   765,   439,    -1,
     388,   438,   520,   439,   531,    -1,   308,   235,   438,   520,
     439,   531,    -1,   191,   235,   438,   520,   439,   317,   810,
     519,   522,   523,   563,    -1,   438,   520,   439,    -1,    -1,
     520,   445,   521,    -1,   521,    -1,   945,    -1,   254,   195,
      -1,   254,   300,    -1,    -1,   524,    -1,   525,    -1,   524,
     525,    -1,   525,   524,    -1,    -1,   289,   160,   526,    -1,
     289,   392,   526,    -1,   267,    80,    -1,   326,    -1,   112,
      -1,   345,   155,    -1,   345,   280,    -1,   217,   438,   809,
     439,    -1,    -1,   406,   287,    -1,   407,   287,    -1,    -1,
     289,   128,   169,    -1,   289,   128,   160,   333,    -1,   289,
     128,   305,   333,    -1,    -1,   367,   812,    -1,    -1,   394,
     215,   367,   812,    -1,    -1,    -1,   136,   506,   366,   810,
     535,   534,   533,   704,    -1,   406,   287,    93,    -1,   407,
     287,    93,    -1,    93,    -1,   438,   536,   439,    -1,    -1,
     536,   445,   537,    -1,   537,    -1,   945,    -1,   136,   506,
     341,   810,   540,    -1,    87,   341,   810,   540,    -1,   540,
     541,    -1,    -1,   110,   831,    -1,   148,    -1,   267,   148,
      -1,   214,   542,   831,    -1,   255,   831,    -1,   257,   831,
      -1,   267,   255,    -1,   267,   257,    -1,   354,   454,   831,
      -1,   325,   454,   831,    -1,   109,    -1,    -1,   136,   544,
     549,   237,   480,    -1,   136,   544,   549,   237,   480,   203,
     545,   546,   547,    -1,   383,    -1,    -1,   812,    -1,   812,
     585,    -1,   397,   545,    -1,    -1,   236,   829,    -1,    -1,
     169,   549,   237,   829,   493,    -1,   311,    -1,    -1,   136,
     367,   812,   551,   251,   824,    -1,   299,   812,    -1,    -1,
     169,   367,   812,    -1,   136,   379,   812,   554,   555,   289,
     810,   557,   180,   312,   812,   438,   560,   439,    -1,   136,
     131,   379,   812,    83,   555,   289,   810,   562,   563,   189,
     170,   332,   180,   312,   818,   438,   560,   439,    -1,   101,
      -1,    83,    -1,   556,    -1,   556,   293,   556,    -1,   556,
     293,   556,   293,   556,    -1,   223,    -1,   160,    -1,   392,
      -1,   189,   558,   559,    -1,    -1,   170,    -1,    -1,   332,
      -1,   355,    -1,   561,    -1,   560,   445,   561,    -1,    -1,
     833,    -1,   945,    -1,    -1,   194,   810,    -1,   564,    -1,
     564,   565,    -1,   565,    -1,   565,   564,    -1,   275,   157,
      -1,   157,    -1,   218,   209,    -1,   218,   158,    -1,   169,
     379,   812,   289,   810,   493,    -1,   136,    95,   812,   119,
     438,   765,   439,   563,    -1,   169,    95,   812,    -1,   136,
      84,   818,   571,    -1,   136,   291,   771,   571,    -1,   136,
     384,   584,   571,    -1,   136,   384,   584,    93,   570,    -1,
     438,   738,   439,    -1,   438,   572,   439,    -1,   573,    -1,
     572,   445,   573,    -1,   948,   425,   574,    -1,   948,    -1,
     623,    -1,   774,    -1,   832,    -1,   136,   291,   121,   584,
     578,   189,   384,   740,   394,   814,    93,   576,    -1,   577,
      -1,   576,   445,   577,    -1,   291,   825,   636,   579,    -1,
     291,   825,   636,   438,   635,   439,   579,    -1,   196,   825,
     818,   616,    -1,   359,   740,    -1,   155,    -1,    -1,   316,
      -1,    -1,   169,   291,   121,   584,   394,   814,   493,    -1,
     169,   582,   583,   493,    -1,   366,    -1,   341,    -1,   402,
      -1,   215,    -1,   384,    -1,   167,    -1,   133,    -1,   336,
      -1,   584,    -1,   583,   445,   584,    -1,   945,    -1,   945,
     585,    -1,   440,   815,    -1,   585,   440,   815,    -1,   382,
     711,   809,    -1,   186,   588,   589,   812,   907,    -1,   186,
     588,   812,   907,    -1,   186,   589,   812,   907,    -1,   186,
     812,   907,    -1,   186,   588,   589,   812,    -1,   186,   588,
     812,    -1,   186,   589,   812,    -1,   186,   812,    -1,   260,
     588,   589,   812,    -1,   260,   812,    -1,   266,    -1,   309,
      -1,   187,    -1,   239,    -1,    78,   826,    -1,   319,   826,
      -1,   826,    -1,    85,    -1,   192,    -1,   192,   826,    -1,
     192,    85,    -1,   100,    -1,   100,   826,    -1,   100,    85,
      -1,   212,    -1,   194,    -1,   127,   289,   591,   812,   231,
     592,    -1,   127,   289,    84,   818,   438,   633,   439,   231,
     592,    -1,   127,   289,   196,   818,   616,   231,   592,    -1,
     127,   289,   291,   771,   438,   635,   439,   231,   592,    -1,
     127,   289,   379,   812,   289,   584,   231,   592,    -1,   127,
     289,   334,   812,   289,   584,   231,   592,    -1,   127,   289,
     334,   812,   231,   592,    -1,   127,   289,   291,   121,   584,
     394,   814,   231,   592,    -1,   127,   289,   238,   283,   831,
     231,   592,    -1,   127,   289,   114,   438,   740,    93,   740,
     439,   231,   592,    -1,   127,   289,   549,   237,   584,   231,
     592,    -1,   126,    -1,   149,    -1,   336,    -1,   215,    -1,
     341,    -1,   366,    -1,   167,    -1,   384,    -1,   402,    -1,
     133,    -1,   829,    -1,   280,    -1,   199,   595,   289,   598,
     374,   599,   601,    -1,   328,   595,   289,   598,   194,   599,
     493,    -1,   328,   199,   292,   189,   595,   289,   598,   194,
     599,   493,    -1,    85,   310,    -1,    85,    -1,   596,    -1,
     597,    -1,   596,   445,   597,    -1,   340,    -1,   317,    -1,
     136,    -1,   945,    -1,   809,    -1,   366,   809,    -1,   196,
     602,    -1,   149,   811,    -1,   237,   811,    -1,   336,   811,
      -1,   367,   811,    -1,   600,    -1,   599,   445,   600,    -1,
     834,    -1,   202,   834,    -1,   406,   199,   292,    -1,    -1,
     603,    -1,   602,   445,   603,    -1,   818,   616,    -1,   199,
     596,   374,   811,   606,   607,    -1,   328,   596,   194,   811,
     607,   493,    -1,   406,    82,   292,    -1,    -1,   200,   109,
     834,    -1,    -1,   136,   609,   215,   816,   289,   810,   610,
     438,   611,   439,   530,   737,    -1,   388,    -1,    -1,   394,
     814,    -1,    -1,   612,    -1,   611,   445,   612,    -1,   945,
     613,    -1,   768,   613,    -1,   438,   765,   439,   613,    -1,
     584,    -1,   394,   584,    -1,    -1,   136,   615,   196,   818,
     616,   327,   622,   624,   627,    -1,   136,   615,   196,   818,
     616,   624,   627,    -1,   293,   323,    -1,    -1,   438,   617,
     439,    -1,   438,   439,    -1,   618,    -1,   617,   445,   618,
      -1,   619,   621,   623,    -1,   621,   619,   623,    -1,   621,
     623,    -1,   619,   623,    -1,   623,    -1,   212,    -1,   295,
      -1,   220,    -1,   212,   295,    -1,   829,    -1,   829,   445,
     829,    -1,   947,    -1,   623,    -1,   740,    -1,   946,   585,
     433,   384,    -1,   626,    -1,   624,   626,    -1,   111,   289,
     280,   221,    -1,   327,   280,   289,   280,   221,    -1,   360,
      -1,   210,    -1,   353,    -1,   403,    -1,   183,   339,   159,
      -1,   183,   339,   230,    -1,   339,   159,    -1,   339,   230,
      -1,    93,   620,    -1,   237,   480,    -1,   625,    -1,   406,
     571,    -1,    -1,    87,   196,   603,   629,   630,    -1,   625,
      -1,   629,   625,    -1,   326,    -1,    -1,   169,   196,   818,
     616,   493,    -1,   169,    84,   818,   438,   633,   439,   493,
      -1,   740,    -1,   431,    -1,   169,   291,   771,   438,   635,
     439,   493,    -1,   740,    -1,   740,   445,   740,    -1,   273,
     445,   740,    -1,   740,   445,   273,    -1,   771,    -1,   945,
     440,   636,    -1,   136,   114,   438,   740,    93,   740,   439,
     406,   196,   603,   638,    -1,   136,   114,   438,   740,    93,
     740,   439,   407,   196,   638,    -1,    93,    96,    -1,    -1,
     169,   114,   438,   740,    93,   740,   439,   493,    -1,   318,
     641,   810,   642,    -1,   318,   365,   812,   642,    -1,   318,
     149,   812,   642,    -1,   215,    -1,   366,    -1,   190,    -1,
      -1,    87,    84,   818,   438,   633,   439,   321,   374,   812,
      -1,    87,   133,   584,   321,   374,   812,    -1,    87,   149,
     813,   321,   374,   813,    -1,    87,   196,   818,   616,   321,
     374,   812,    -1,    87,   202,   834,   321,   374,   834,    -1,
      87,   237,   812,   321,   374,   812,    -1,    87,   291,   121,
     584,   394,   814,   321,   374,   812,    -1,    87,   336,   812,
     321,   374,   812,    -1,    87,   366,   735,   321,   374,   812,
      -1,    87,   215,   735,   321,   374,   812,    -1,    87,   366,
     735,   321,   644,   812,   374,   812,    -1,    87,   379,   812,
     289,   735,   321,   374,   812,    -1,    87,   393,   834,   321,
     374,   834,    -1,    87,   367,   812,   321,   374,   812,    -1,
     126,    -1,    -1,    87,    84,   818,   438,   633,   439,   345,
     336,   812,    -1,    87,   167,   584,   345,   336,   812,    -1,
      87,   196,   818,   616,   345,   336,   812,    -1,    87,   341,
     735,   345,   336,   812,    -1,    87,   366,   735,   345,   336,
     812,    -1,    87,   384,   584,   345,   336,   812,    -1,    87,
      84,   818,   438,   633,   439,   299,   374,   834,    -1,    87,
     133,   584,   299,   374,   834,    -1,    87,   149,   813,   299,
     374,   834,    -1,    87,   167,   813,   299,   374,   834,    -1,
      87,   196,   818,   616,   299,   374,   834,    -1,    87,   291,
     636,   438,   635,   439,   299,   374,   834,    -1,    87,   291,
     121,   584,   394,   814,   299,   374,   834,    -1,    87,   336,
     812,   299,   374,   834,    -1,    87,   384,   584,   299,   374,
     834,    -1,    87,   367,   812,   299,   374,   834,    -1,    -1,
     136,   615,   334,   812,    93,   648,   289,   653,   374,   810,
     737,   166,   654,   649,    -1,   276,    -1,   651,    -1,   438,
     650,   439,    -1,   650,   441,   652,    -1,   652,    -1,   704,
      -1,   690,    -1,   700,    -1,   694,    -1,   656,    -1,   651,
      -1,    -1,   340,    -1,   392,    -1,   160,    -1,   223,    -1,
     224,    -1,    86,    -1,    -1,   169,   334,   812,   289,   810,
     493,    -1,   277,   810,    -1,   246,   810,    -1,   390,   810,
      -1,   390,   431,    -1,    77,   660,    -1,   102,   660,   663,
      -1,   354,   377,   663,    -1,   128,   660,    -1,   175,   660,
      -1,   331,   660,    -1,   335,   945,    -1,   320,   335,   945,
      -1,   320,   945,    -1,   331,   660,   374,   335,   945,    -1,
     331,   660,   374,   945,    -1,   306,   377,   829,    -1,   128,
     307,   829,    -1,   331,   307,   829,    -1,   408,    -1,   377,
      -1,    -1,   233,   243,   475,    -1,   314,   290,    -1,   314,
     409,    -1,   661,    -1,   662,   445,   661,    -1,   662,   661,
      -1,   662,    -1,    -1,   136,   506,   402,   810,   519,    93,
     704,    -1,   136,   293,   323,   506,   402,   810,   519,    93,
     704,    -1,   247,   817,    -1,   136,   149,   813,   406,   667,
      -1,   136,   149,   813,    -1,   668,    -1,   667,   668,    -1,
     367,   669,   812,    -1,   367,   669,   155,    -1,   251,   669,
     829,    -1,   251,   669,   155,    -1,   369,   669,   812,    -1,
     369,   669,   155,    -1,   173,   669,   830,    -1,   173,   669,
     155,    -1,   130,   245,   669,   825,    -1,   299,   669,   812,
      -1,   299,   669,   155,    -1,   425,    -1,    -1,    87,   149,
     813,   454,   672,    -1,    87,   149,   813,   345,   471,    -1,
      87,   149,   813,   482,    -1,   672,   673,    -1,    -1,   130,
     245,   669,   825,    -1,   169,   149,   813,    -1,   136,   167,
     584,   677,   740,   511,    -1,    87,   167,   584,   492,    -1,
      87,   167,   584,   169,   275,   280,    -1,    87,   167,   584,
     345,   275,   280,    -1,    87,   167,   584,    81,   517,    -1,
      87,   167,   584,   169,   131,   812,   493,    -1,    93,    -1,
      -1,   136,   578,   133,   584,   189,   829,   374,   829,   194,
     584,    -1,   123,   816,   289,   810,    -1,   123,   810,    -1,
     123,    -1,   395,   684,   685,   683,    -1,   395,   684,   685,
     683,   810,    -1,   395,   684,   685,   683,   681,    -1,   682,
     683,    -1,   682,   683,   810,   686,    -1,    89,    -1,    88,
      -1,   401,    -1,    -1,   195,    -1,    -1,   193,    -1,    -1,
     438,   811,   439,    -1,    -1,   182,   689,   683,   688,    -1,
     704,    -1,   690,    -1,   700,    -1,   694,    -1,   701,    -1,
     682,    -1,    -1,   223,   229,   810,   691,    -1,   398,   438,
     806,   439,    -1,   155,   398,    -1,   704,    -1,   438,   692,
     439,   398,   438,   806,   439,    -1,   438,   692,   439,   704,
      -1,   692,   445,   693,    -1,   693,    -1,   945,   798,    -1,
     160,   194,   735,   695,   737,    -1,   394,   728,    -1,    -1,
     252,   711,   809,   697,   699,    -1,   212,   698,   258,    -1,
      -1,    79,   347,    -1,   332,   347,    -1,   332,   178,    -1,
     347,   392,   178,    -1,   347,    -1,   347,   332,   178,    -1,
     178,    -1,    79,   178,    -1,   279,    -1,    -1,   392,   735,
     345,   802,   727,   737,    -1,   154,   812,   702,   147,   703,
     189,   704,    -1,    -1,   702,   105,    -1,   702,   222,    -1,
     702,   337,    -1,   702,   267,   337,    -1,    -1,   406,   206,
      -1,   407,   206,    -1,   706,    -1,   705,    -1,   438,   706,
     439,    -1,   438,   705,   439,    -1,   708,    -1,   707,   715,
      -1,   707,   714,   724,   719,    -1,   707,   714,   718,   725,
      -1,   708,    -1,   705,    -1,   340,   713,   800,   709,   727,
     737,   722,   723,    -1,   707,   387,   712,   707,    -1,   707,
     227,   712,   707,    -1,   707,   177,   712,   707,    -1,   229,
     710,    -1,   907,    -1,    -1,   370,   711,   810,    -1,   368,
     711,   810,    -1,   248,   370,   711,   810,    -1,   248,   368,
     711,   810,    -1,   198,   370,   711,   810,    -1,   198,   368,
     711,   810,    -1,   366,   810,    -1,   810,    -1,   366,    -1,
      -1,    85,    -1,    -1,   165,    -1,   165,   289,   438,   776,
     439,    -1,    85,    -1,    -1,   715,    -1,    -1,   294,   109,
     716,    -1,   717,    -1,   716,   445,   717,    -1,   765,   394,
     774,    -1,   765,    94,    -1,   765,   163,    -1,   765,    -1,
     245,   720,   286,   721,    -1,   286,   721,   245,   720,    -1,
     245,   720,    -1,   286,   721,    -1,   245,   720,   445,   721,
      -1,   718,    -1,    -1,   765,    -1,    85,    -1,   765,    -1,
     202,   109,   776,    -1,    -1,   204,   765,    -1,    -1,   189,
     392,   726,   699,    -1,   189,   347,   726,   699,    -1,   189,
     314,   290,    -1,   724,    -1,    -1,   284,   811,    -1,    -1,
     194,   728,    -1,    -1,   728,   445,   729,    -1,   729,    -1,
     735,    -1,   735,   731,    -1,   736,    -1,   736,   731,    -1,
     736,    93,   438,   738,   439,    -1,   736,    93,   945,   438,
     738,   439,    -1,   736,   945,   438,   738,   439,    -1,   705,
      -1,   705,   731,    -1,   730,    -1,   438,   730,   439,   731,
      -1,   438,   730,   439,    -1,   729,   140,   234,   729,    -1,
     729,   412,   729,    -1,   729,   732,   234,   729,   734,    -1,
     729,   234,   729,   734,    -1,   729,   263,   732,   234,   729,
      -1,   729,   263,   234,   729,    -1,    93,   945,   438,   811,
     439,    -1,    93,   945,    -1,   945,   438,   811,   439,    -1,
     945,    -1,   195,   733,    -1,   242,   733,    -1,   329,   733,
      -1,   219,    -1,   296,    -1,    -1,   394,   438,   811,   439,
      -1,   289,   765,    -1,   810,    -1,   810,   431,    -1,   290,
     810,    -1,   290,   438,   810,   439,    -1,   768,    -1,   405,
     765,    -1,    -1,   739,    -1,   738,   445,   739,    -1,   945,
     740,    -1,   743,   741,    -1,   346,   743,   741,    -1,   743,
      92,   436,   825,   437,    -1,   346,   743,    92,   436,   825,
     437,    -1,   436,   437,   741,    -1,   436,   742,   437,   741,
      -1,    -1,   825,    -1,   438,   742,   439,    -1,   742,   429,
     742,    -1,   742,   430,   742,    -1,   742,   431,   742,    -1,
     742,   432,   742,    -1,   742,   433,   742,    -1,   824,    -1,
     945,    -1,   745,    -1,   761,    -1,   746,    -1,   750,    -1,
     754,    -1,   762,   764,    -1,   762,   438,   825,   439,   764,
      -1,   946,   585,    -1,   745,    -1,   761,    -1,   746,    -1,
     751,    -1,   755,    -1,   946,    -1,   225,    -1,   226,    -1,
     351,    -1,   104,    -1,   315,    -1,   188,   747,    -1,   168,
     304,    -1,   153,   749,    -1,   152,   749,    -1,   282,   748,
      -1,   107,    -1,   438,   825,   439,    -1,    -1,   438,   825,
     445,   825,   439,    -1,   438,   825,   439,    -1,    -1,   438,
     825,   445,   825,   439,    -1,   438,   825,   439,    -1,    -1,
     752,    -1,   753,    -1,   752,    -1,   753,    -1,   106,   759,
     438,   825,   439,    -1,   106,   759,    -1,   756,    -1,   757,
      -1,   756,    -1,   757,    -1,   758,   438,   825,   439,   760,
      -1,   758,   760,    -1,   117,   759,    -1,   116,   759,    -1,
     399,    -1,   262,   117,   759,    -1,   262,   116,   759,    -1,
     264,   759,    -1,   400,    -1,    -1,   117,   345,   945,    -1,
      -1,   373,   438,   825,   439,   763,    -1,   373,   763,    -1,
     372,   438,   825,   439,   763,    -1,   372,   763,    -1,   228,
      -1,   406,   372,   411,    -1,   407,   372,   411,    -1,    -1,
     410,    -1,   259,    -1,   150,    -1,   207,    -1,   256,    -1,
     338,    -1,   410,   374,   259,    -1,   150,   374,   207,    -1,
     150,   374,   256,    -1,   150,   374,   338,    -1,   207,   374,
     256,    -1,   256,   374,   338,    -1,   207,   374,   338,    -1,
      -1,   767,    -1,   765,    76,   740,    -1,   765,    98,   372,
     411,   765,    -1,   429,   765,    -1,   430,   765,    -1,   765,
     429,   765,    -1,   765,   430,   765,    -1,   765,   431,   765,
      -1,   765,   432,   765,    -1,   765,   433,   765,    -1,   765,
     434,   765,    -1,   765,   426,   765,    -1,   765,   427,   765,
      -1,   765,   425,   765,    -1,   765,   773,   765,    -1,   773,
     765,    -1,   765,   773,    -1,   765,    90,   765,    -1,   765,
     293,   765,    -1,   275,   765,    -1,   765,   244,   765,    -1,
     765,   244,   765,   176,   765,    -1,   765,   275,   244,   765,
      -1,   765,   275,   244,   765,   176,   765,    -1,   765,   208,
     765,    -1,   765,   208,   765,   176,   765,    -1,   765,   275,
     208,   765,    -1,   765,   275,   208,   765,   176,   765,    -1,
     765,   349,   374,   765,    -1,   765,   349,   374,   765,   176,
     765,    -1,   765,   275,   349,   374,   765,    -1,   765,   275,
     349,   374,   765,   176,   765,    -1,   765,   232,    -1,   765,
     231,   280,    -1,   765,   278,    -1,   765,   231,   275,   280,
      -1,   765,   231,   381,    -1,   765,   231,   275,   381,    -1,
     765,   231,   185,    -1,   765,   231,   275,   185,    -1,   765,
     231,   389,    -1,   765,   231,   275,   389,    -1,   765,   231,
     165,   194,   765,    -1,   765,   231,   284,   438,   778,   439,
      -1,   765,   231,   275,   284,   438,   778,   439,    -1,   765,
     103,   799,   766,    90,   766,    -1,   765,   275,   103,   799,
     766,    90,   766,    -1,   765,   103,   363,   766,    90,   766,
      -1,   765,   275,   103,   363,   766,    90,   766,    -1,   765,
     212,   789,    -1,   765,   275,   212,   789,    -1,   765,   775,
     770,   705,    -1,   765,   775,   770,   438,   765,   439,    -1,
     388,   705,    -1,   767,    -1,   766,    76,   740,    -1,   430,
     766,    -1,   766,   429,   766,    -1,   766,   430,   766,    -1,
     766,   431,   766,    -1,   766,   432,   766,    -1,   766,   433,
     766,    -1,   766,   434,   766,    -1,   766,   426,   766,    -1,
     766,   427,   766,    -1,   766,   425,   766,    -1,   766,   415,
     766,    -1,   773,   766,    -1,   766,   773,    -1,   766,   231,
     165,   194,   766,    -1,   766,   231,   284,   438,   766,   439,
      -1,   766,   231,   275,   284,   438,   766,   439,    -1,   795,
      -1,   819,    -1,   423,   798,    -1,   438,   765,   439,   798,
      -1,   790,    -1,   768,    -1,   705,    -1,   181,   705,    -1,
      92,   705,    -1,    92,   780,    -1,   769,    -1,   818,   438,
     439,    -1,   818,   438,   776,   439,    -1,   818,   438,    85,
     776,   439,    -1,   818,   438,   165,   776,   439,    -1,   818,
     438,   431,   439,    -1,   142,    -1,   144,    -1,   144,   438,
     825,   439,    -1,   145,    -1,   145,   438,   825,   439,    -1,
     249,    -1,   249,   438,   825,   439,    -1,   250,    -1,   250,
     438,   825,   439,    -1,   143,    -1,   146,    -1,   344,    -1,
     393,    -1,   114,   438,   765,    93,   740,   439,    -1,   184,
     438,   777,   439,    -1,   298,   438,   782,   439,    -1,   303,
     438,   784,   439,    -1,   361,   438,   785,   439,    -1,   378,
     438,   765,    93,   740,   439,    -1,   380,   438,   108,   788,
     439,    -1,   380,   438,   240,   788,   439,    -1,   380,   438,
     376,   788,   439,    -1,   380,   438,   788,   439,    -1,   134,
     438,   765,   394,   584,   439,    -1,   134,   438,   776,   439,
      -1,   281,   438,   765,   445,   765,   439,    -1,   124,   438,
     776,   439,    -1,   201,   438,   776,   439,    -1,   241,   438,
     776,   439,    -1,   332,   438,   776,   439,    -1,   332,   438,
     439,    -1,   438,   776,   445,   765,   439,    -1,    91,    -1,
     352,    -1,    85,    -1,   415,    -1,   772,    -1,   429,    -1,
     430,    -1,   431,    -1,   433,    -1,   434,    -1,   432,    -1,
     426,    -1,   427,    -1,   425,    -1,   415,    -1,   291,   438,
     636,   439,    -1,   771,    -1,   291,   438,   636,   439,    -1,
     771,    -1,   291,   438,   636,   439,    -1,   244,    -1,   275,
     244,    -1,   208,    -1,   275,   208,    -1,   765,    -1,   776,
     445,   765,    -1,   781,   194,   765,    -1,    -1,   778,   445,
     740,    -1,   740,    -1,   780,    -1,   779,   445,   780,    -1,
     436,   776,   437,    -1,   436,   779,   437,    -1,   967,    -1,
     410,    -1,   259,    -1,   150,    -1,   207,    -1,   256,    -1,
     338,    -1,   829,    -1,   765,   783,   786,   787,    -1,   765,
     783,   786,    -1,   302,   765,    -1,   766,   212,   766,    -1,
      -1,   765,   786,   787,    -1,   765,   787,   786,    -1,   765,
     786,    -1,   765,   787,    -1,   776,    -1,    -1,   194,   765,
      -1,   189,   765,    -1,   765,   194,   776,    -1,   194,   776,
      -1,   776,    -1,   705,    -1,   438,   776,   439,    -1,   113,
     794,   791,   793,   175,    -1,   791,   792,    -1,   792,    -1,
     404,   765,   371,   765,    -1,   171,   765,    -1,    -1,   765,
      -1,    -1,   808,    -1,   808,   797,    -1,   440,   815,    -1,
     440,   431,    -1,   436,   765,   437,    -1,   436,   765,   446,
     765,   437,    -1,   796,    -1,   797,   796,    -1,    -1,   798,
     796,    -1,    97,    -1,    -1,   800,   445,   801,    -1,   801,
      -1,   765,    93,   948,    -1,   765,    -1,   431,    -1,   802,
     445,   805,    -1,   438,   803,   439,   425,   438,   804,   439,
      -1,   805,    -1,   945,   798,    -1,   945,   798,   445,   803,
      -1,   765,    -1,   765,   445,   804,    -1,   945,   798,   425,
     765,    -1,   945,   798,   425,   155,    -1,   806,   445,   807,
      -1,   807,    -1,   765,    -1,   155,    -1,   835,    -1,   945,
      -1,   810,    -1,   809,   445,   810,    -1,   808,    -1,   808,
     797,    -1,   812,    -1,   811,   445,   812,    -1,   945,    -1,
     945,    -1,   945,    -1,   948,    -1,   945,    -1,   829,    -1,
     947,    -1,   808,   797,    -1,   833,    -1,   744,   829,    -1,
     762,   829,   764,    -1,   762,   438,   825,   439,   829,   764,
      -1,   381,    -1,   185,    -1,   280,    -1,   963,    -1,   422,
      -1,   424,    -1,   420,    -1,   421,    -1,   414,    -1,   820,
      -1,   964,    -1,   825,    -1,   430,   825,    -1,   820,    -1,
     966,    -1,   821,    -1,   827,    -1,   430,   821,    -1,   430,
     820,    -1,   824,    -1,   824,    -1,   964,    -1,   820,    -1,
     824,    -1,   964,    -1,   821,    -1,   820,    -1,   430,   821,
      -1,   430,   820,    -1,   964,    -1,   824,    -1,   831,    -1,
     824,    -1,   821,    -1,   820,    -1,   822,    -1,   823,    -1,
     964,    -1,   945,    -1,   288,    -1,   265,    -1,     9,   374,
     837,   843,   844,    -1,     9,   374,   155,    -1,     9,   845,
      -1,   149,   837,    -1,   813,   840,   842,    -1,   838,   446,
     839,   842,   432,   813,   848,    -1,   847,    -1,   967,   966,
      -1,   415,   841,    -1,   839,    -1,    -1,   945,    -1,   945,
     440,   841,    -1,   419,    -1,   446,   825,    -1,    -1,    93,
     837,    -1,    -1,   393,   845,    -1,    -1,   846,    -1,   846,
     432,   846,    -1,   846,    24,   109,   846,    -1,   846,   394,
     846,    -1,   834,    -1,   829,    -1,   966,    -1,   415,   945,
      -1,    -1,   154,   812,   702,   147,   703,   189,   899,    -1,
     151,   306,   899,    -1,   151,   899,    -1,   852,    -1,   866,
      -1,   853,    -1,    -1,   871,   874,   854,   887,   441,    -1,
      -1,   874,   855,   887,   441,    -1,   877,   441,    -1,   831,
      -1,   445,   831,    -1,    -1,   764,    -1,   410,   374,   256,
      -1,   410,   374,   338,    -1,   150,   374,   150,    -1,   259,
     374,   259,    -1,    -1,   861,   860,   863,   862,    -1,   960,
     102,   154,    38,   441,    -1,   960,   175,   154,    38,   441,
      -1,    -1,   864,    -1,   418,    -1,   868,    -1,   866,    -1,
     864,   868,    -1,   864,   866,    -1,   864,   418,    -1,   868,
      -1,   865,   868,    -1,    -1,    75,   867,   874,   890,   949,
     741,   441,    -1,    -1,   871,   874,   869,   887,   441,    -1,
      -1,   874,   870,   887,   441,    -1,   877,   441,    -1,   872,
     873,    -1,   872,    -1,   873,    -1,    61,    -1,    72,    -1,
      70,    -1,    55,    -1,    56,    -1,    74,    -1,   883,    -1,
     879,    -1,   875,    -1,   949,   438,   856,   857,   439,    -1,
     949,   858,    -1,   881,    -1,    19,   943,   876,    -1,    19,
     876,    -1,    19,   943,    -1,   442,   971,   443,    -1,    -1,
     881,   878,   442,   865,   443,    -1,   877,    -1,    -1,   882,
     880,   442,   865,   443,    -1,    47,   943,    -1,   387,   943,
      -1,    47,    -1,   387,    -1,   884,    -1,   886,   885,    -1,
      48,    39,    -1,    48,    39,   225,    -1,    48,    -1,    48,
     225,    -1,    48,    28,    -1,    48,    28,   225,    -1,    48,
      28,    28,    -1,    48,    28,    28,   225,    -1,    48,   116,
      -1,    39,    -1,    39,   225,    -1,   225,    -1,    28,    -1,
      28,   225,    -1,    28,    28,    -1,    28,    28,   225,    -1,
       5,    -1,   116,    -1,   168,    -1,    40,    -1,    -1,   888,
      -1,   887,   445,   888,    -1,   890,   950,   741,   889,    -1,
      -1,   425,   972,    -1,    -1,   431,    -1,   431,   431,    -1,
     154,   355,   967,    -1,    18,   893,    -1,   894,    -1,    12,
      -1,    85,    -1,    -1,   837,    -1,   155,    -1,   180,   209,
     898,    -1,    -1,   180,   899,   896,   897,    -1,   903,   907,
      -1,   907,   903,    -1,   903,    -1,   907,    -1,    -1,   847,
      -1,   416,    -1,   812,    -1,   847,    -1,    21,   812,    -1,
      32,   812,   902,    -1,    -1,   903,    -1,   394,   908,    -1,
     904,    -1,   394,   906,    17,   968,    -1,   229,   906,    17,
     968,    -1,    -1,    41,    -1,   229,   959,    -1,   905,    -1,
     909,    -1,   909,   445,   908,    -1,   832,    -1,   963,    -1,
     306,   899,   194,   898,    -1,    16,   221,   812,   904,    -1,
      16,   912,   812,   904,    -1,    16,   912,   812,   905,    -1,
      33,    -1,    -1,     3,    17,   968,    -1,   151,    17,   968,
      -1,   197,    17,   968,   916,    -1,   917,    -1,   916,   445,
     917,    -1,   966,   425,   921,    -1,   345,    17,   968,   919,
      -1,   920,    -1,   919,   445,   920,    -1,   921,   425,   827,
      -1,    11,    -1,   197,    17,   968,    49,   827,   923,    -1,
     924,    -1,   923,   445,   924,    -1,   966,   425,   928,    -1,
     345,    17,   968,    49,   827,   926,    -1,   927,    -1,   926,
     445,   927,    -1,   928,   425,   828,    -1,     8,    -1,    13,
      -1,    14,    -1,    15,    -1,    25,    -1,    26,    -1,    27,
      -1,    29,    -1,    30,    -1,    31,    -1,   304,    -1,    35,
      -1,    36,    -1,    37,    -1,   384,    -1,   345,     4,   425,
     930,    -1,   345,     4,   374,   930,    -1,   289,    -1,   285,
      -1,   345,   130,   374,   894,    -1,   345,   130,   425,   894,
      -1,   345,   130,   894,    -1,    -1,   384,   933,   949,   231,
     874,   741,   934,    -1,    34,    -1,    -1,    -1,    50,   936,
     948,   231,   874,   741,   934,    -1,    51,    42,   938,    -1,
      51,   275,    20,   938,    -1,    51,    44,   938,    -1,    10,
      -1,    43,    -1,    46,    -1,    23,   812,    -1,    22,   374,
     812,    -1,   166,   812,   438,   961,   439,    -1,   166,     6,
      -1,     7,   812,   438,   961,   439,    -1,     7,   812,    -1,
     940,    -1,   941,    -1,     6,    -1,     7,    -1,     8,    -1,
      10,    -1,    11,    -1,    13,    -1,    14,    -1,    15,    -1,
      20,    -1,    22,    -1,    23,    -1,    24,    -1,    25,    -1,
      26,    -1,    27,    -1,    29,    -1,    30,    -1,    31,    -1,
      35,    -1,    36,    -1,    37,    -1,    38,    -1,    42,    -1,
      43,    -1,    44,    -1,    46,    -1,    49,    -1,     9,    -1,
      16,    -1,    18,    -1,    32,    -1,    50,    -1,    51,    -1,
       5,    -1,    28,    -1,    33,    -1,    39,    -1,    47,    -1,
      40,    -1,    48,    -1,   948,    -1,   967,    -1,   953,    -1,
     955,    -1,   956,    -1,   939,    -1,   951,    -1,   116,    -1,
     967,    -1,   952,    -1,   956,    -1,   939,    -1,   951,    -1,
     116,    -1,   967,    -1,   952,    -1,   939,    -1,   942,    -1,
     951,    -1,   967,    -1,   952,    -1,   957,    -1,   939,    -1,
     951,    -1,   950,    -1,   942,    -1,   116,    -1,   221,    -1,
     225,    -1,   387,    -1,   374,    -1,   951,    -1,   953,    -1,
     967,    -1,   956,    -1,   957,    -1,   940,    -1,   949,    -1,
     958,    -1,   954,    -1,   941,    -1,    55,    -1,    56,    -1,
      61,    -1,    70,    -1,    72,    -1,    75,    -1,    74,    -1,
     953,    -1,   954,    -1,   150,    -1,   207,    -1,   256,    -1,
     259,    -1,   338,    -1,   410,    -1,   955,    -1,   130,    -1,
      77,    -1,    78,    -1,    79,    -1,    80,    -1,    81,    -1,
      82,    -1,    83,    -1,    84,    -1,    86,    -1,    87,    -1,
      95,    -1,    96,    -1,    98,    -1,   100,    -1,   101,    -1,
     102,    -1,   109,    -1,   110,    -1,   112,    -1,   115,    -1,
     118,    -1,   120,    -1,   121,    -1,   122,    -1,   123,    -1,
     127,    -1,   128,    -1,   129,    -1,   132,    -1,   133,    -1,
     135,    -1,   137,    -1,   138,    -1,   139,    -1,   141,    -1,
     147,    -1,   148,    -1,   149,    -1,   151,    -1,   154,    -1,
     156,    -1,   158,    -1,   160,    -1,   161,    -1,   162,    -1,
     164,    -1,   167,    -1,   168,    -1,   169,    -1,   170,    -1,
     172,    -1,   173,    -1,   174,    -1,   176,    -1,   179,    -1,
     178,    -1,   180,    -1,   182,    -1,   186,    -1,   187,    -1,
     190,    -1,   192,    -1,   196,    -1,   198,    -1,   200,    -1,
     203,    -1,   205,    -1,   206,    -1,   209,    -1,   210,    -1,
     211,    -1,   213,    -1,   214,    -1,   215,    -1,   216,    -1,
     217,    -1,   222,    -1,   223,    -1,   224,    -1,   233,    -1,
     235,    -1,   236,    -1,   237,    -1,   238,    -1,   239,    -1,
     243,    -1,   246,    -1,   247,    -1,   248,    -1,   251,    -1,
     252,    -1,   253,    -1,   254,    -1,   255,    -1,   257,    -1,
     258,    -1,   260,    -1,   261,    -1,   266,    -1,   267,    -1,
     268,    -1,   269,    -1,   270,    -1,   271,    -1,   272,    -1,
     274,    -1,   276,    -1,   277,    -1,   279,    -1,   283,    -1,
     284,    -1,   287,    -1,   291,    -1,   292,    -1,   299,    -1,
     300,    -1,   301,    -1,   306,    -1,   307,    -1,   305,    -1,
     309,    -1,   310,    -1,   311,    -1,   312,    -1,   313,    -1,
     314,    -1,   316,    -1,   318,    -1,   319,    -1,   320,    -1,
     321,    -1,   322,    -1,   323,    -1,   324,    -1,   325,    -1,
     326,    -1,   327,    -1,   328,    -1,   330,    -1,   331,    -1,
     333,    -1,   334,    -1,   335,    -1,   336,    -1,   337,    -1,
     341,    -1,   342,    -1,   343,    -1,   345,    -1,   347,    -1,
     348,    -1,   350,    -1,   353,    -1,   354,    -1,   355,    -1,
     356,    -1,   357,    -1,   358,    -1,   359,    -1,   362,    -1,
     360,    -1,   365,    -1,   364,    -1,   367,    -1,   368,    -1,
     369,    -1,   370,    -1,   375,    -1,   377,    -1,   379,    -1,
     382,    -1,   383,    -1,   384,    -1,   385,    -1,   386,    -1,
     389,    -1,   390,    -1,   391,    -1,   392,    -1,   395,    -1,
     396,    -1,   398,    -1,   400,    -1,   402,    -1,   406,    -1,
     407,    -1,   408,    -1,   409,    -1,   411,    -1,   104,    -1,
     106,    -1,   117,    -1,   124,    -1,   134,    -1,   152,    -1,
     153,    -1,   181,    -1,   184,    -1,   188,    -1,   201,    -1,
     220,    -1,   226,    -1,   228,    -1,   241,    -1,   262,    -1,
     264,    -1,   273,    -1,   281,    -1,   282,    -1,   295,    -1,
     298,    -1,   303,    -1,   304,    -1,   315,    -1,   332,    -1,
     346,    -1,   351,    -1,   361,    -1,   372,    -1,   373,    -1,
     378,    -1,   380,    -1,   399,    -1,    99,    -1,   103,    -1,
     105,    -1,   140,    -1,   193,    -1,   195,    -1,   208,    -1,
     219,    -1,   231,    -1,   232,    -1,   234,    -1,   242,    -1,
     244,    -1,   263,    -1,   278,    -1,   296,    -1,   297,    -1,
     329,    -1,   349,    -1,   401,    -1,    85,    -1,    88,    -1,
      89,    -1,    90,    -1,    91,    -1,    92,    -1,    93,    -1,
      94,    -1,    97,    -1,   108,    -1,   113,    -1,   114,    -1,
     119,    -1,   125,    -1,   126,    -1,   131,    -1,   136,    -1,
     142,    -1,   144,    -1,   145,    -1,   143,    -1,   146,    -1,
     155,    -1,   157,    -1,   163,    -1,   165,    -1,   166,    -1,
     171,    -1,   175,    -1,   177,    -1,   185,    -1,   189,    -1,
     191,    -1,   194,    -1,   199,    -1,   202,    -1,   204,    -1,
     212,    -1,   218,    -1,   227,    -1,   229,    -1,   240,    -1,
     245,    -1,   265,    -1,   275,    -1,   280,    -1,   285,    -1,
     286,    -1,   288,    -1,   289,    -1,   290,    -1,   293,    -1,
     294,    -1,   308,    -1,   317,    -1,   340,    -1,   344,    -1,
     352,    -1,   363,    -1,   366,    -1,   371,    -1,   376,    -1,
     381,    -1,   388,    -1,   393,    -1,   394,    -1,   404,    -1,
     405,    -1,   962,    -1,   959,   445,   962,    -1,    45,    -1,
      -1,   971,    -1,   966,   965,    -1,   966,    -1,   966,   965,
      -1,   966,    -1,   966,    -1,    25,   966,    -1,    25,   812,
      -1,   417,    -1,   413,    -1,   416,    -1,   812,    -1,   847,
      -1,   974,    -1,   438,   439,    -1,   438,   970,   439,    -1,
     969,    -1,   970,   969,    -1,   972,    -1,   971,   445,   972,
      -1,   970,    -1,   442,   971,   443,    -1,   974,    -1,   438,
      -1,   439,    -1,   445,    -1,   441,    -1,   413,    -1,   416,
      -1,   820,    -1,   821,    -1,   824,    -1,   431,    -1,   429,
      -1,   430,    -1,   432,    -1,   433,    -1,   280,    -1,    52,
      -1,    53,    -1,    54,    -1,    55,    -1,    56,    -1,    57,
      -1,    58,    -1,    59,    -1,    60,    -1,    61,    -1,    62,
      -1,    63,    -1,    65,    -1,    64,    -1,    66,    -1,    67,
      -1,    68,    -1,    69,    -1,    70,    -1,    71,    -1,    72,
      -1,    73,    -1,    75,    -1,    74,    -1,     5,    -1,    19,
      -1,   207,    -1,   225,    -1,    28,    -1,   256,    -1,   259,
      -1,   338,    -1,    39,    -1,    40,    -1,    47,    -1,    48,
      -1,   410,    -1,   116,    -1,   188,    -1,   374,    -1,   387,
      -1,   399,    -1,   436,    -1,   437,    -1,   425,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   604,   604,   606,   607,   610,   611,   612,   618,   619,
     620,   621,   622,   625,   637,   638,   639,   640,   641,   642,
     643,   644,   645,   646,   647,   648,   649,   650,   651,   673,
     674,   675,   676,   677,   678,   679,   680,   681,   682,   683,
     684,   685,   686,   687,   688,   689,   690,   691,   692,   693,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   712,   713,   714,   715,
     716,   717,   718,   719,   720,   722,   723,   724,   725,   726,
     727,   728,   729,   730,   731,   737,   738,   739,   740,   741,
     742,   743,   744,   745,   751,   761,   765,   773,   781,   785,
     796,   806,   810,   817,   824,   830,   840,   850,   856,   865,
     872,   878,   887,   894,   915,   919,   920,   929,   930,   931,
     932,   933,   934,   935,   936,   937,   938,   939,   940,   941,
     942,   943,   944,   945,   946,   947,   948,   949,   959,   973,
     977,   979,   989,   992,   994,  1004,  1014,  1024,  1034,  1038,
    1039,  1048,  1059,  1061,  1065,  1066,  1069,  1070,  1077,  1078,
    1079,  1080,  1081,  1082,  1095,  1097,  1099,  1103,  1105,  1107,
    1109,  1111,  1113,  1115,  1117,  1119,  1123,  1124,  1128,  1130,
    1134,  1136,  1140,  1141,  1142,  1143,  1146,  1147,  1148,  1151,
    1152,  1153,  1154,  1164,  1165,  1166,  1168,  1170,  1172,  1176,
    1177,  1178,  1181,  1182,  1185,  1187,  1189,  1191,  1193,  1197,
    1199,  1201,  1203,  1205,  1209,  1213,  1215,  1219,  1220,  1226,
    1237,  1239,  1245,  1246,  1250,  1254,  1257,  1260,  1263,  1266,
    1269,  1272,  1275,  1278,  1281,  1284,  1287,  1290,  1293,  1296,
    1299,  1302,  1305,  1308,  1312,  1313,  1319,  1322,  1327,  1328,
    1331,  1332,  1333,  1336,  1337,  1347,  1361,  1366,  1367,  1375,
    1376,  1377,  1380,  1381,  1384,  1385,  1386,  1388,  1390,  1391,
    1392,  1394,  1396,  1398,  1403,  1404,  1407,  1408,  1415,  1418,
    1421,  1422,  1432,  1435,  1445,  1446,  1447,  1448,  1449,  1450,
    1451,  1455,  1458,  1460,  1462,  1466,  1467,  1468,  1471,  1477,
    1478,  1481,  1483,  1484,  1498,  1500,  1502,  1504,  1506,  1508,
    1510,  1525,  1526,  1527,  1528,  1531,  1538,  1539,  1540,  1547,
    1549,  1553,  1555,  1557,  1559,  1564,  1565,  1568,  1570,  1574,
    1577,  1579,  1585,  1588,  1589,  1590,  1591,  1592,  1595,  1599,
    1603,  1604,  1605,  1606,  1607,  1610,  1613,  1616,  1617,  1618,
    1621,  1622,  1623,  1624,  1627,  1628,  1631,  1632,  1641,  1640,
    1658,  1659,  1660,  1664,  1667,  1670,  1672,  1676,  1687,  1691,
    1695,  1696,  1699,  1701,  1703,  1705,  1707,  1709,  1711,  1713,
    1715,  1717,  1721,  1722,  1733,  1735,  1740,  1741,  1748,  1749,
    1752,  1755,  1757,  1760,  1763,  1767,  1768,  1778,  1782,  1783,
    1797,  1808,  1813,  1821,  1822,  1825,  1827,  1829,  1833,  1834,
    1835,  1838,  1841,  1844,  1845,  1848,  1849,  1852,  1854,  1857,
    1860,  1861,  1864,  1865,  1868,  1869,  1876,  1877,  1886,  1888,
    1892,  1894,  1898,  1909,  1917,  1932,  1934,  1936,  1938,  1942,
    1946,  1950,  1951,  1954,  1955,  1959,  1960,  1961,  1964,  1971,
    1972,  1975,  1977,  1979,  1981,  1985,  1986,  1989,  1990,  1993,
    2005,  2009,  2010,  2011,  2012,  2013,  2014,  2015,  2016,  2019,
    2021,  2025,  2026,  2029,  2030,  2039,  2054,  2059,  2064,  2069,
    2074,  2079,  2084,  2089,  2094,  2096,  2100,  2101,  2102,  2103,
    2104,  2105,  2106,  2107,  2108,  2109,  2110,  2111,  2112,  2113,
    2116,  2117,  2120,  2122,  2124,  2126,  2128,  2130,  2132,  2134,
    2136,  2138,  2140,  2144,  2145,  2146,  2147,  2148,  2149,  2150,
    2151,  2152,  2153,  2156,  2157,  2167,  2171,  2175,  2182,  2183,
    2184,  2187,  2189,  2193,  2194,  2195,  2196,  2199,  2201,  2203,
    2205,  2207,  2209,  2211,  2215,  2217,  2221,  2222,  2225,  2230,
    2233,  2235,  2239,  2248,  2253,  2257,  2258,  2261,  2262,  2274,
    2279,  2280,  2283,  2286,  2289,  2290,  2293,  2295,  2297,  2301,
    2302,  2303,  2306,  2309,  2314,  2315,  2318,  2320,  2324,  2326,
    2330,  2331,  2332,  2333,  2334,  2337,  2338,  2339,  2340,  2343,
    2345,  2349,  2351,  2361,  2363,  2368,  2370,  2375,  2377,  2379,
    2381,  2383,  2385,  2387,  2389,  2391,  2393,  2396,  2398,  2400,
    2404,  2405,  2409,  2413,  2414,  2417,  2418,  2431,  2435,  2439,
    2440,  2444,  2448,  2450,  2452,  2454,  2459,  2461,  2465,  2468,
    2473,  2474,  2478,  2489,  2491,  2493,  2497,  2498,  2501,  2502,
    2513,  2515,  2517,  2519,  2521,  2523,  2525,  2527,  2529,  2531,
    2533,  2535,  2537,  2539,  2543,  2544,  2554,  2556,  2558,  2560,
    2562,  2564,  2574,  2576,  2578,  2580,  2582,  2584,  2586,  2588,
    2590,  2592,  2604,  2603,  2613,  2614,  2615,  2619,  2621,  2625,
    2626,  2627,  2628,  2629,  2632,  2633,  2637,  2638,  2639,  2640,
    2643,  2644,  2645,  2648,  2660,  2664,  2668,  2670,  2683,  2684,
    2685,  2686,  2687,  2688,  2689,  2690,  2691,  2692,  2693,  2694,
    2695,  2696,  2699,  2700,  2701,  2705,  2707,  2708,  2712,  2713,
    2714,  2718,  2719,  2729,  2731,  2743,  2755,  2757,  2761,  2763,
    2767,  2769,  2771,  2773,  2775,  2777,  2779,  2781,  2783,  2785,
    2787,  2791,  2792,  2803,  2807,  2809,  2814,  2815,  2819,  2829,
    2840,  2847,  2849,  2851,  2853,  2855,  2859,  2860,  2864,  2878,
    2880,  2882,  2895,  2897,  2899,  2903,  2905,  2909,  2910,  2913,
    2914,  2917,  2918,  2921,  2922,  2925,  2928,  2939,  2944,  2945,
    2946,  2947,  2948,  2952,  2953,  3002,  3006,  3008,  3010,  3012,
    3014,  3018,  3020,  3024,  3036,  3040,  3041,  3044,  3048,  3051,
    3054,  3055,  3056,  3057,  3058,  3059,  3060,  3061,  3064,  3065,
    3075,  3089,  3120,  3121,  3122,  3123,  3124,  3127,  3131,  3132,
    3142,  3144,  3148,  3150,  3154,  3156,  3158,  3160,  3164,  3165,
    3168,  3172,  3174,  3176,  3180,  3185,  3186,  3196,  3198,  3200,
    3202,  3204,  3206,  3208,  3210,  3214,  3215,  3218,  3219,  3222,
    3224,  3226,  3229,  3232,  3233,  3236,  3240,  3241,  3244,  3246,
    3248,  3250,  3254,  3256,  3258,  3260,  3262,  3266,  3267,  3270,
    3271,  3274,  3284,  3287,  3290,  3293,  3296,  3298,  3300,  3304,
    3305,  3309,  3310,  3321,  3322,  3325,  3326,  3336,  3338,  3340,
    3342,  3344,  3346,  3348,  3350,  3352,  3354,  3356,  3377,  3379,
    3381,  3383,  3385,  3387,  3389,  3393,  3395,  3397,  3399,  3403,
    3404,  3405,  3406,  3410,  3411,  3421,  3423,  3427,  3429,  3431,
    3433,  3437,  3440,  3441,  3444,  3446,  3450,  3463,  3465,  3467,
    3469,  3474,  3480,  3487,  3494,  3495,  3496,  3497,  3498,  3499,
    3500,  3501,  3502,  3505,  3506,  3507,  3508,  3509,  3510,  3512,
    3514,  3518,  3519,  3520,  3521,  3522,  3525,  3533,  3535,  3537,
    3539,  3541,  3543,  3545,  3547,  3549,  3551,  3553,  3557,  3560,
    3563,  3565,  3568,  3571,  3573,  3576,  3584,  3585,  3588,  3589,
    3592,  3596,  3605,  3606,  3609,  3610,  3613,  3617,  3621,  3623,
    3625,  3627,  3629,  3631,  3635,  3638,  3641,  3644,  3647,  3649,
    3651,  3653,  3657,  3661,  3663,  3666,  3669,  3670,  3671,  3672,
    3673,  3674,  3675,  3676,  3677,  3678,  3679,  3680,  3681,  3682,
    3708,  3710,  3712,  3723,  3725,  3727,  3729,  3731,  3733,  3735,
    3737,  3739,  3741,  3743,  3745,  3747,  3749,  3751,  3753,  3755,
    3757,  3759,  3761,  3763,  3765,  3767,  3769,  3771,  3773,  3775,
    3777,  3779,  3781,  3783,  3785,  3787,  3798,  3800,  3802,  3804,
    3806,  3808,  3810,  3812,  3814,  3816,  3818,  3820,  3822,  3824,
    3826,  3828,  3830,  3832,  3844,  3846,  3848,  3850,  3852,  3854,
    3856,  3858,  3860,  3862,  3864,  3866,  3868,  3870,  3872,  3874,
    3876,  3878,  3890,  3892,  3894,  3896,  3898,  3900,  3902,  3904,
    3906,  3908,  3910,  3922,  3924,  3926,  3928,  3930,  3932,  3934,
    3936,  3938,  3940,  3942,  3944,  3946,  3948,  3950,  3952,  3954,
    3956,  3958,  3960,  3962,  3964,  3966,  3968,  3971,  3973,  3975,
    3977,  3979,  3981,  3983,  3985,  3987,  3989,  3994,  3996,  3998,
    4002,  4003,  4004,  4007,  4008,  4011,  4012,  4013,  4014,  4015,
    4016,  4017,  4018,  4019,  4022,  4023,  4026,  4027,  4030,  4031,
    4032,  4033,  4034,  4035,  4038,  4040,  4044,  4047,  4050,  4052,
    4056,  4057,  4061,  4062,  4068,  4069,  4070,  4071,  4072,  4073,
    4074,  4075,  4079,  4081,  4086,  4090,  4093,  4096,  4098,  4100,
    4102,  4104,  4107,  4110,  4114,  4118,  4120,  4122,  4126,  4128,
    4135,  4139,  4141,  4145,  4149,  4152,  4155,  4156,  4159,  4160,
    4164,  4165,  4166,  4167,  4170,  4171,  4175,  4176,  4179,  4180,
    4189,  4191,  4196,  4198,  4200,  4205,  4207,  4231,  4235,  4244,
    4255,  4263,  4273,  4275,  4279,  4281,  4285,  4286,  4296,  4297,
    4300,  4302,  4306,  4308,  4312,  4314,  4319,  4320,  4321,  4322,
    4323,  4325,  4327,  4329,  4337,  4339,  4341,  4343,  4345,  4347,
    4349,  4351,  4355,  4356,  4357,  4358,  4359,  4370,  4371,  4374,
    4375,  4378,  4386,  4389,  4397,  4398,  4407,  4416,  4428,  4429,
    4432,  4433,  4434,  4437,  4438,  4439,  4440,  4441,  4444,  4445,
    4448,  4449,  4450,  4451,  4452,  4453,  4456,  4458,  4465,  4481,
    4483,  4486,  4488,  4492,  4504,  4520,  4526,  4538,  4547,  4548,
    4551,  4552,  4553,  4556,  4557,  4560,  4561,  4564,  4565,  4568,
    4570,  4572,  4574,  4578,  4585,  4608,  4640,  4650,  4657,  4697,
    4699,  4706,  4708,  4709,  4714,  4712,  4727,  4726,  4739,  4745,
    4747,  4748,  4751,  4752,  4753,  4754,  4755,  4762,  4761,  4771,
    4773,  4775,  4776,  4777,  4780,  4781,  4782,  4783,  4784,  4787,
    4788,  4792,  4791,  4852,  4850,  4865,  4864,  4877,  4883,  4887,
    4891,  4897,  4898,  4899,  4900,  4903,  4904,  4907,  4915,  4932,
    4940,  4963,  5057,  5091,  5093,  5095,  5099,  5103,  5102,  5153,
    5155,  5154,  5169,  5175,  5182,  5187,  5190,  5191,  5194,  5195,
    5196,  5197,  5198,  5199,  5200,  5208,  5216,  5219,  5220,  5221,
    5222,  5223,  5224,  5232,  5240,  5241,  5242,  5245,  5246,  5249,
    5251,  5255,  5326,  5327,  5334,  5335,  5336,  5342,  5351,  5354,
    5355,  5356,  5357,  5360,  5361,  5367,  5381,  5380,  5398,  5399,
    5400,  5401,  5402,  5405,  5407,  5411,  5412,  5419,  5424,  5426,
    5427,  5430,  5431,  5434,  5441,  5448,  5448,  5450,  5451,  5454,
    5454,  5456,  5466,  5475,  5481,  5487,  5493,  5501,  5502,  5514,
    5524,  5535,  5539,  5540,  5543,  5548,  5552,  5553,  5556,  5563,
    5570,  5574,  5575,  5578,  5581,  5585,  5586,  5589,  5596,  5597,
    5598,  5599,  5600,  5601,  5602,  5603,  5604,  5605,  5606,  5607,
    5608,  5609,  5610,  5640,  5641,  5644,  5645,  5652,  5653,  5654,
    5661,  5660,  5719,  5720,  5727,  5726,  5795,  5801,  5807,  5815,
    5821,  5827,  5833,  5839,  5845,  5851,  5857,  5863,  5874,  5875,
    5878,  5879,  5880,  5881,  5882,  5883,  5884,  5885,  5886,  5887,
    5888,  5889,  5890,  5891,  5892,  5893,  5894,  5895,  5896,  5897,
    5898,  5899,  5900,  5901,  5902,  5903,  5904,  5907,  5908,  5909,
    5910,  5911,  5912,  5916,  5917,  5918,  5919,  5920,  5921,  5922,
    5925,  5939,  5940,  5941,  5942,  5943,  5944,  5945,  5949,  5950,
    5951,  5952,  5953,  5954,  5959,  5960,  5961,  5962,  5963,  5968,
    5969,  5970,  5971,  5972,  5978,  5979,  5980,  5981,  5982,  5983,
    5984,  5985,  5986,  5989,  5990,  5991,  5992,  5995,  5996,  5997,
    5998,  6001,  6002,  6003,  6004,  6005,  6006,  6007,  6025,  6025,
    6027,  6028,  6029,  6030,  6031,  6032,  6039,  6040,  6043,  6044,
    6045,  6046,  6047,  6048,  6049,  6050,  6051,  6052,  6053,  6054,
    6055,  6056,  6057,  6058,  6059,  6060,  6061,  6062,  6063,  6064,
    6065,  6066,  6067,  6068,  6069,  6070,  6072,  6073,  6074,  6075,
    6076,  6077,  6078,  6079,  6080,  6081,  6083,  6084,  6085,  6086,
    6087,  6088,  6089,  6090,  6091,  6092,  6093,  6094,  6095,  6096,
    6097,  6098,  6099,  6100,  6101,  6102,  6103,  6104,  6105,  6106,
    6107,  6108,  6109,  6110,  6111,  6112,  6114,  6115,  6116,  6117,
    6118,  6119,  6120,  6121,  6122,  6123,  6124,  6125,  6126,  6127,
    6128,  6129,  6130,  6131,  6132,  6133,  6134,  6135,  6136,  6137,
    6138,  6139,  6141,  6142,  6144,  6145,  6146,  6147,  6148,  6149,
    6150,  6151,  6152,  6153,  6154,  6155,  6156,  6157,  6158,  6159,
    6160,  6161,  6162,  6163,  6164,  6165,  6166,  6167,  6168,  6169,
    6170,  6171,  6172,  6173,  6174,  6175,  6176,  6177,  6178,  6179,
    6180,  6181,  6182,  6183,  6184,  6185,  6186,  6187,  6188,  6189,
    6190,  6191,  6192,  6194,  6195,  6196,  6197,  6198,  6199,  6200,
    6201,  6202,  6203,  6204,  6205,  6206,  6207,  6208,  6209,  6210,
    6211,  6212,  6213,  6214,  6215,  6216,  6217,  6218,  6219,  6220,
    6221,  6222,  6223,  6224,  6225,  6226,  6227,  6228,  6229,  6230,
    6231,  6232,  6233,  6234,  6235,  6236,  6238,  6252,  6253,  6257,
    6258,  6259,  6260,  6261,  6262,  6263,  6264,  6265,  6266,  6270,
    6271,  6272,  6273,  6274,  6275,  6276,  6277,  6278,  6279,  6280,
    6281,  6282,  6283,  6284,  6285,  6286,  6287,  6288,  6289,  6290,
    6291,  6305,  6306,  6307,  6308,  6309,  6310,  6311,  6312,  6313,
    6314,  6315,  6316,  6317,  6318,  6319,  6320,  6321,  6322,  6323,
    6324,  6334,  6335,  6336,  6337,  6338,  6339,  6340,  6341,  6342,
    6343,  6344,  6345,  6346,  6347,  6348,  6349,  6350,  6351,  6352,
    6353,  6354,  6355,  6356,  6357,  6358,  6359,  6360,  6361,  6362,
    6363,  6364,  6365,  6366,  6367,  6368,  6369,  6370,  6371,  6372,
    6373,  6374,  6375,  6376,  6377,  6378,  6379,  6380,  6381,  6382,
    6383,  6384,  6385,  6386,  6387,  6388,  6389,  6390,  6391,  6392,
    6393,  6394,  6398,  6399,  6403,  6404,  6405,  6406,  6407,  6411,
    6411,  6414,  6417,  6418,  6421,  6423,  6428,  6438,  6445,  6446,
    6447,  6450,  6479,  6480,  6483,  6485,  6493,  6494,  6495,  6499,
    6500,  6504,  6505,  6508,  6509,  6512,  6513,  6514,  6515,  6516,
    6519,  6520,  6521,  6522,  6523,  6524,  6525,  6526,  6527,  6528,
    6529,  6530,  6531,  6532,  6533,  6534,  6535,  6536,  6537,  6538,
    6539,  6540,  6541,  6542,  6543,  6544,  6545,  6546,  6547,  6548,
    6549,  6550,  6551,  6552,  6553,  6554,  6555,  6556,  6557,  6558,
    6559,  6560,  6561,  6562,  6563,  6564,  6565,  6566,  6567,  6568,
    6569,  6570,  6571,  6572,  6573,  6574
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONTINUE", "SQL_COUNT", "SQL_CURRENT", "SQL_DATA", 
  "SQL_DATETIME_INTERVAL_CODE", "SQL_DATETIME_INTERVAL_PRECISION", 
  "SQL_DESCRIBE", "SQL_DESCRIPTOR", "SQL_DISCONNECT", "SQL_ENUM", 
  "SQL_FOUND", "SQL_FREE", "SQL_GO", "SQL_GOTO", "SQL_IDENTIFIED", 
  "SQL_INDICATOR", "SQL_KEY_MEMBER", "SQL_LENGTH", "SQL_LONG", "SQL_NAME", 
  "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN", "SQL_OUTPUT", 
  "SQL_REFERENCE", "SQL_RETURNED_LENGTH", "SQL_RETURNED_OCTET_LENGTH", 
  "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", "SQL_SIGNED", "SQL_SQL", 
  "SQL_SQLERROR", "SQL_SQLPRINT", "SQL_SQLWARNING", "SQL_START", 
  "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", "SQL_VALUE", "SQL_VAR", 
  "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", "S_CONST", 
  "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", "S_INC", 
  "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", "S_NEQUAL", 
  "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", "S_VOLATILE", 
  "S_TYPEDEF", "TYPECAST", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", 
  "ADD", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", "ANALYSE", 
  "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION", 
  "ASSIGNMENT", "ASYMMETRIC", "AT", "AUTHORIZATION", "BACKWARD", "BEFORE", 
  "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT", "BOOLEAN_P", "BOTH", 
  "BY", "CACHE", "CALLED", "CASCADE", "CASE", "CAST", "CHAIN", "CHAR_P", 
  "CHARACTER", "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", 
  "CLUSTER", "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMIT", 
  "COMMITTED", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONVERSION_P", 
  "CONVERT", "COPY", "CREATE", "CREATEDB", "CREATEROLE", "CREATEUSER", 
  "CROSS", "CSV", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", 
  "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATABASE", 
  "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE", "DEFAULT", 
  "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P", 
  "DELIMITER", "DELIMITERS", "DESC", "DISABLE_P", "DISTINCT", "DO", 
  "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", "ENABLE_P", "ENCODING", 
  "ENCRYPTED", "END_P", "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXCLUDING", 
  "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P", 
  "FETCH", "FIRST_P", "FLOAT_P", "FOR", "FORCE", "FOREIGN", "FORWARD", 
  "FREEZE", "FROM", "FULL", "FUNCTION", "GET", "GLOBAL", "GRANT", 
  "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING", "HEADER", "HOLD", 
  "HOUR_P", "ILIKE", "IMMEDIATE", "IMMUTABLE", "IMPLICIT_P", "IN_P", 
  "INCLUDING", "INCREMENT", "INDEX", "INHERIT", "INHERITS", "INITIALLY", 
  "INNER_P", "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", 
  "INT_P", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", 
  "ISNULL", "ISOLATION", "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", 
  "LARGE_P", "LAST_P", "LEADING", "LEAST", "LEFT", "LEVEL", "LIKE", 
  "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", 
  "LOCATION", "LOCK_P", "LOGIN_P", "MATCH", "MAXVALUE", "MINUTE_P", 
  "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAMES", "NATIONAL", "NATURAL", 
  "NCHAR", "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEROLE", 
  "NOCREATEUSER", "NOINHERIT", "NOLOGIN_P", "NONE", "NOSUPERUSER", "NOT", 
  "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OR", "ORDER", "OUT_P", "OUTER_P", "OVERLAPS", 
  "OVERLAY", "OWNER", "PARTIAL", "PASSWORD", "PLACING", "POSITION", 
  "PRECISION", "PRESERVE", "PREPARE", "PREPARED", "PRIMARY", "PRIOR", 
  "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "QUOTE", "READ", "REAL", 
  "RECHECK", "REFERENCES", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME", 
  "REPEATABLE", "REPLACE", "RESET", "RESTART", "RESTRICT", "RETURNS", 
  "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", 
  "SAVEPOINT", "SCHEMA", "SCROLL", "SECOND_P", "SECURITY", "SELECT", 
  "SEQUENCE", "SERIALIZABLE", "SESSION", "SESSION_USER", "SET", "SETOF", 
  "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", "STABLE", 
  "START", "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE", 
  "STRICT_P", "SUBSTRING", "SUPERUSER_P", "SYMMETRIC", "SYSID", 
  "SYSTEM_P", "TABLE", "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY", 
  "THEN", "TIME", "TIMESTAMP", "TO", "TOAST", "TRAILING", "TRANSACTION", 
  "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P", 
  "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", 
  "UNTIL", "UPDATE", "USER", "USING", "VACUUM", "VALID", "VALIDATOR", 
  "VALUES", "VARCHAR", "VARYING", "VERBOSE", "VIEW", "VOLATILE", "WHEN", 
  "WHERE", "WITH", "WITHOUT", "WORK", "WRITE", "YEAR_P", "ZONE", 
  "UNIONJOIN", "IDENT", "SCONST", "Op", "CSTRING", "CVARIABLE", 
  "CPP_LINE", "IP", "BCONST", "XCONST", "ICONST", "PARAM", "FCONST", 
  "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'", 
  "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "';'", "'{'", "'}'", 
  "\"=\"", "','", "':'", "$accept", "prog", "statements", "statement", 
  "opt_at", "stmt", "CreateRoleStmt", "opt_with", "OptRoleList", 
  "CreateUserStmt", "AlterRoleStmt", "AlterRoleSetStmt", "AlterUserStmt", 
  "DropRoleStmt", "DropUserStmt", "CreateGroupStmt", "AlterGroupStmt", 
  "add_drop", "DropGroupStmt", "CreateSchemaStmt", "OptSchemaName", 
  "OptSchemaEltList", "schema_stmt", "VariableSetStmt", "set_rest", 
  "var_name", "var_list_or_default", "var_list", "iso_level", "var_value", 
  "opt_boolean", "zone_value", "opt_encoding", "ColId_or_Sconst", 
  "VariableShowStmt", "VariableResetStmt", "ConstraintsSetStmt", 
  "constraints_set_list", "constraints_set_mode", "CheckPointStmt", 
  "AlterTableStmt", "alter_table_cmds", "alter_table_cmd", 
  "alter_rel_cmds", "alter_rel_cmd", "alter_column_default", 
  "opt_drop_behavior", "alter_using", "ClosePortalStmt", "CopyStmt", 
  "copy_from", "copy_file_name", "copy_opt_list", "copy_opt_item", 
  "opt_binary", "opt_oids", "copy_delimiter", "opt_using", "CreateStmt", 
  "OptTemp", "OptTableElementList", "TableElementList", "TableElement", 
  "columnDef", "ColQualList", "ColConstraint", "ColConstraintElem", 
  "ConstraintAttr", "TableLikeClause", "like_including_defaults", 
  "TableConstraint", "ConstraintElem", "opt_column_list", "columnList", 
  "columnElem", "key_match", "key_actions", "key_delete", "key_update", 
  "key_action", "OptInherit", "OptWithOids", "OnCommitOption", 
  "OptTableSpace", "OptConsTableSpace", "CreateAsStmt", "@1", 
  "WithOidsAs", "OptCreateAs", "CreateAsList", "CreateAsElement", 
  "CreateSeqStmt", "AlterSeqStmt", "OptSeqList", "OptSeqElem", "opt_by", 
  "CreatePLangStmt", "opt_trusted", "handler_name", "opt_validator", 
  "opt_lancompiler", "DropPLangStmt", "opt_procedural", 
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt", 
  "CreateTrigStmt", "TriggerActionTime", "TriggerEvents", 
  "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", "TriggerForType", 
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable", 
  "ConstraintAttributeSpec", "ConstraintDeferrabilitySpec", 
  "ConstraintTimeSpec", "DropTrigStmt", "CreateAssertStmt", 
  "DropAssertStmt", "DefineStmt", "rowdefinition", "definition", 
  "def_list", "def_elem", "def_arg", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_recheck", 
  "DropOpClassStmt", "DropStmt", "drop_type", "any_name_list", "any_name", 
  "attrs", "TruncateStmt", "FetchStmt", "fetch_direction", "from_in", 
  "CommentStmt", "comment_type", "comment_text", "GrantStmt", 
  "RevokeStmt", "privileges", "privilege_list", "privilege", 
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option", 
  "function_with_argtypes_list", "function_with_argtypes", 
  "GrantRoleStmt", "RevokeRoleStmt", "opt_grant_admin_option", 
  "opt_granted_by", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "arg_class", "func_as", "param_name", "func_return", 
  "func_type", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "opt_definition", "AlterFunctionStmt", 
  "alterfunc_opt_list", "opt_restrict", "RemoveFuncStmt", 
  "RemoveAggrStmt", "aggr_argtype", "RemoveOperStmt", "oper_argtypes", 
  "any_operator", "CreateCastStmt", "cast_context", "DropCastStmt", 
  "ReindexStmt", "reindex_type", "opt_force", "RenameStmt", "opt_column", 
  "AlterObjectSchemaStmt", "AlterOwnerStmt", "RuleStmt", "@2", 
  "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "LoadStmt", 
  "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", "opt_equal", 
  "AlterDatabaseStmt", "AlterDatabaseSetStmt", "alterdb_opt_list", 
  "alterdb_opt_item", "DropdbStmt", "CreateDomainStmt", "AlterDomainStmt", 
  "opt_as", "CreateConversionStmt", "ClusterStmt", "VacuumStmt", 
  "AnalyzeStmt", "analyze_keyword", "opt_verbose", "opt_full", 
  "opt_freeze", "opt_name_list", "ExplainStmt", "ExplainableStmt", 
  "opt_analyze", "InsertStmt", "insert_rest", "insert_column_list", 
  "insert_column_item", "DeleteStmt", "using_clause", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", 
  "DeclareCursorStmt", "cursor_options", "opt_hold", "SelectStmt", 
  "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "select_limit_value", "select_offset_value", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "locked_rels_list", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "func_table", "where_clause", "TableFuncElementList", 
  "TableFuncElement", "Typename", "opt_array_bounds", "Iresult", 
  "SimpleTypename", "ConstTypename", "GenericType", "Numeric", 
  "opt_float", "opt_numeric", "opt_decimal", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "a_expr", "b_expr", "c_expr", 
  "func_expr", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "extract_list", "type_list", 
  "array_expr_list", "array_expr", "extract_arg", "overlay_list", 
  "overlay_placing", "position_list", "substr_list", "substr_from", 
  "substr_for", "trim_list", "in_expr", "case_expr", "when_clause_list", 
  "when_clause", "case_default", "case_arg", "columnref", 
  "indirection_el", "indirection", "opt_indirection", "opt_asymmetric", 
  "target_list", "target_el", "update_target_list", "inf_col_list", 
  "inf_val_list", "update_target_el", "insert_target_list", 
  "insert_target_el", "relation_name", "qualified_name_list", 
  "qualified_name", "name_list", "name", "database_name", "access_method", 
  "attr_name", "index_name", "file_name", "func_name", "AexprConst", 
  "Iconst", "Fconst", "Bconst", "Xconst", "Sconst", "PosIntConst", 
  "IntConst", "IntConstVar", "AllConstVar", "StringConst", 
  "PosIntStringConst", "NumConst", "AllConst", "PosAllConst", "RoleId", 
  "SpecialRuleRelation", "ECPGConnect", "connection_target", "db_prefix", 
  "server", "opt_server", "server_name", "opt_port", 
  "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "ECPGCursorStmt", "ECPGDeallocate", 
  "ECPGVarDeclaration", "single_vt_declaration", "single_var_declaration", 
  "@3", "@4", "precision", "opt_scale", "ecpg_interval", 
  "ECPGDeclaration", "@5", "sql_startdeclare", "sql_enddeclare", 
  "var_type_declarations", "vt_declarations", "variable_declarations", 
  "type_declaration", "@6", "var_declaration", "@7", "@8", 
  "storage_declaration", "storage_clause", "storage_modifier", "var_type", 
  "enum_type", "enum_definition", "struct_union_type_with_symbol", "@9", 
  "struct_union_type", "@10", "s_struct_union_symbol", "s_struct_union", 
  "simple_type", "unsigned_type", "signed_type", "opt_signed", 
  "variable_list", "variable", "opt_initializer", "opt_pointer", 
  "ECPGDeclare", "ECPGDisconnect", "dis_name", "connection_object", 
  "ECPGExecute", "@11", "execute_rest", "execstring", "prepared_name", 
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using", 
  "using_descriptor", "into_descriptor", "opt_sql", "ecpg_into", 
  "using_list", "UsingConst", "ECPGPrepare", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "desc_header_item", "ECPGGetDescriptor", 
  "ECPGGetDescItems", "ECPGGetDescItem", "ECPGSetDescriptor", 
  "ECPGSetDescItems", "ECPGSetDescItem", "descriptor_item", 
  "ECPGSetAutocommit", "on_off", "ECPGSetConnection", "ECPGTypedef", 
  "@12", "opt_reference", "ECPGVar", "@13", "ECPGWhenever", "action", 
  "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ECPGColId", "ColId", "type_name", 
  "function_name", "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", 
  "ECPGCKeywords", "unreserved_keyword", "ECPGunreserved_interval", 
  "ECPGunreserved", "ECPGunreserved_con", "col_name_keyword", 
  "func_name_keyword", "reserved_keyword", "into_list", "ecpgstart", 
  "c_args", "coutputvariable", "civarind", "civar", "indicator", 
  "cvariable", "ident", "quoted_ident_stringvar", "c_stuff_item", 
  "c_stuff", "c_list", "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,    61,    60,    62,   680,    43,
      45,    42,    47,    37,    94,   681,    91,    93,    40,    41,
      46,    59,   123,   125,   682,    44,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   447,   448,   449,   449,   450,   450,   450,   450,   450,
     450,   450,   450,   451,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   453,   454,   454,   455,   455,   455,
     455,   455,   455,   455,   455,   455,   455,   455,   455,   455,
     455,   455,   455,   455,   455,   455,   455,   455,   456,   457,
     458,   458,   459,   458,   458,   460,   461,   462,   463,   464,
     464,   465,   466,   466,   467,   467,   468,   468,   469,   469,
     469,   469,   469,   469,   470,   470,   470,   471,   471,   471,
     471,   471,   471,   471,   471,   471,   472,   472,   473,   473,
     474,   474,   475,   475,   475,   475,   476,   476,   476,   477,
     477,   477,   477,   478,   478,   478,   478,   478,   478,   479,
     479,   479,   480,   480,   481,   481,   481,   481,   481,   482,
     482,   482,   482,   482,   483,   484,   484,   485,   485,   486,
     487,   487,   488,   488,   489,   489,   489,   489,   489,   489,
     489,   489,   489,   489,   489,   489,   489,   489,   489,   489,
     489,   489,   489,   489,   490,   490,   491,   491,   492,   492,
     493,   493,   493,   494,   494,   495,   496,   497,   497,   498,
     498,   498,   499,   499,   500,   500,   500,   500,   500,   500,
     500,   500,   500,   500,   501,   501,   502,   502,   503,   503,
     504,   504,   505,   505,   506,   506,   506,   506,   506,   506,
     506,   507,   507,   508,   508,   509,   509,   509,   510,   511,
     511,   512,   512,   512,   513,   513,   513,   513,   513,   513,
     513,   514,   514,   514,   514,   515,   516,   516,   516,   517,
     517,   518,   518,   518,   518,   519,   519,   520,   520,   521,
     522,   522,   522,   523,   523,   523,   523,   523,   524,   525,
     526,   526,   526,   526,   526,   527,   527,   528,   528,   528,
     529,   529,   529,   529,   530,   530,   531,   531,   533,   532,
     534,   534,   534,   535,   535,   536,   536,   537,   538,   539,
     540,   540,   541,   541,   541,   541,   541,   541,   541,   541,
     541,   541,   542,   542,   543,   543,   544,   544,   545,   545,
     546,   546,   547,   547,   548,   549,   549,   550,   551,   551,
     552,   553,   553,   554,   554,   555,   555,   555,   556,   556,
     556,   557,   557,   558,   558,   559,   559,   560,   560,   560,
     561,   561,   562,   562,   563,   563,   563,   563,   564,   564,
     565,   565,   566,   567,   568,   569,   569,   569,   569,   570,
     571,   572,   572,   573,   573,   574,   574,   574,   575,   576,
     576,   577,   577,   577,   577,   578,   578,   579,   579,   580,
     581,   582,   582,   582,   582,   582,   582,   582,   582,   583,
     583,   584,   584,   585,   585,   586,   587,   587,   587,   587,
     587,   587,   587,   587,   587,   587,   588,   588,   588,   588,
     588,   588,   588,   588,   588,   588,   588,   588,   588,   588,
     589,   589,   590,   590,   590,   590,   590,   590,   590,   590,
     590,   590,   590,   591,   591,   591,   591,   591,   591,   591,
     591,   591,   591,   592,   592,   593,   594,   594,   595,   595,
     595,   596,   596,   597,   597,   597,   597,   598,   598,   598,
     598,   598,   598,   598,   599,   599,   600,   600,   601,   601,
     602,   602,   603,   604,   605,   606,   606,   607,   607,   608,
     609,   609,   610,   610,   611,   611,   612,   612,   612,   613,
     613,   613,   614,   614,   615,   615,   616,   616,   617,   617,
     618,   618,   618,   618,   618,   619,   619,   619,   619,   620,
     620,   621,   622,   623,   623,   624,   624,   625,   625,   625,
     625,   625,   625,   625,   625,   625,   625,   626,   626,   626,
     627,   627,   628,   629,   629,   630,   630,   631,   632,   633,
     633,   634,   635,   635,   635,   635,   636,   636,   637,   637,
     638,   638,   639,   640,   640,   640,   641,   641,   642,   642,
     643,   643,   643,   643,   643,   643,   643,   643,   643,   643,
     643,   643,   643,   643,   644,   644,   645,   645,   645,   645,
     645,   645,   646,   646,   646,   646,   646,   646,   646,   646,
     646,   646,   648,   647,   649,   649,   649,   650,   650,   651,
     651,   651,   651,   651,   652,   652,   653,   653,   653,   653,
     654,   654,   654,   655,   656,   657,   658,   658,   659,   659,
     659,   659,   659,   659,   659,   659,   659,   659,   659,   659,
     659,   659,   660,   660,   660,   661,   661,   661,   662,   662,
     662,   663,   663,   664,   664,   665,   666,   666,   667,   667,
     668,   668,   668,   668,   668,   668,   668,   668,   668,   668,
     668,   669,   669,   670,   671,   671,   672,   672,   673,   674,
     675,   676,   676,   676,   676,   676,   677,   677,   678,   679,
     679,   679,   680,   680,   680,   681,   681,   682,   682,   683,
     683,   684,   684,   685,   685,   686,   686,   687,   688,   688,
     688,   688,   688,   689,   689,   690,   691,   691,   691,   691,
     691,   692,   692,   693,   694,   695,   695,   696,   697,   697,
     698,   698,   698,   698,   698,   698,   698,   698,   699,   699,
     700,   701,   702,   702,   702,   702,   702,   703,   703,   703,
     704,   704,   705,   705,   706,   706,   706,   706,   707,   707,
     708,   708,   708,   708,   709,   709,   709,   710,   710,   710,
     710,   710,   710,   710,   710,   711,   711,   712,   712,   713,
     713,   713,   713,   714,   714,   715,   716,   716,   717,   717,
     717,   717,   718,   718,   718,   718,   718,   719,   719,   720,
     720,   721,   722,   722,   723,   723,   724,   724,   724,   725,
     725,   726,   726,   727,   727,   728,   728,   729,   729,   729,
     729,   729,   729,   729,   729,   729,   729,   729,   730,   730,
     730,   730,   730,   730,   730,   731,   731,   731,   731,   732,
     732,   732,   732,   733,   733,   734,   734,   735,   735,   735,
     735,   736,   737,   737,   738,   738,   739,   740,   740,   740,
     740,   741,   741,   741,   742,   742,   742,   742,   742,   742,
     742,   742,   742,   743,   743,   743,   743,   743,   743,   743,
     743,   744,   744,   744,   744,   744,   745,   746,   746,   746,
     746,   746,   746,   746,   746,   746,   746,   746,   747,   747,
     748,   748,   748,   749,   749,   749,   750,   750,   751,   751,
     752,   753,   754,   754,   755,   755,   756,   757,   758,   758,
     758,   758,   758,   758,   759,   759,   760,   760,   761,   761,
     761,   761,   762,   763,   763,   763,   764,   764,   764,   764,
     764,   764,   764,   764,   764,   764,   764,   764,   764,   764,
     765,   765,   765,   765,   765,   765,   765,   765,   765,   765,
     765,   765,   765,   765,   765,   765,   765,   765,   765,   765,
     765,   765,   765,   765,   765,   765,   765,   765,   765,   765,
     765,   765,   765,   765,   765,   765,   765,   765,   765,   765,
     765,   765,   765,   765,   765,   765,   765,   765,   765,   765,
     765,   765,   765,   765,   766,   766,   766,   766,   766,   766,
     766,   766,   766,   766,   766,   766,   766,   766,   766,   766,
     766,   766,   767,   767,   767,   767,   767,   767,   767,   767,
     767,   767,   767,   768,   768,   768,   768,   768,   768,   768,
     768,   768,   768,   768,   768,   768,   768,   768,   768,   768,
     768,   768,   768,   768,   768,   768,   768,   768,   768,   768,
     768,   768,   768,   768,   768,   768,   768,   769,   769,   769,
     770,   770,   770,   771,   771,   772,   772,   772,   772,   772,
     772,   772,   772,   772,   773,   773,   774,   774,   775,   775,
     775,   775,   775,   775,   776,   776,   777,   777,   778,   778,
     779,   779,   780,   780,   781,   781,   781,   781,   781,   781,
     781,   781,   782,   782,   783,   784,   784,   785,   785,   785,
     785,   785,   785,   786,   787,   788,   788,   788,   789,   789,
     790,   791,   791,   792,   793,   793,   794,   794,   795,   795,
     796,   796,   796,   796,   797,   797,   798,   798,   799,   799,
     800,   800,   801,   801,   801,   802,   802,   802,   803,   803,
     804,   804,   805,   805,   806,   806,   807,   807,   808,   808,
     809,   809,   810,   810,   811,   811,   812,   813,   814,   815,
     816,   817,   818,   818,   819,   819,   819,   819,   819,   819,
     819,   819,   820,   821,   822,   823,   824,   825,   825,   826,
     826,   827,   827,   828,   828,   828,   828,   828,   829,   829,
     830,   830,   830,   831,   831,   831,   831,   831,   832,   832,
     833,   833,   833,   833,   833,   833,   834,   835,   835,   836,
     836,   836,   836,   837,   837,   837,   838,   839,   840,   840,
     841,   841,   841,   842,   842,   843,   843,   844,   844,   845,
     845,   845,   845,   846,   846,   847,   848,   848,   849,   850,
     850,   851,   852,   852,   854,   853,   855,   853,   853,   856,
     857,   857,   858,   858,   858,   858,   858,   860,   859,   861,
     862,   863,   863,   863,   864,   864,   864,   864,   864,   865,
     865,   867,   866,   869,   868,   870,   868,   868,   871,   871,
     871,   872,   872,   872,   872,   873,   873,   874,   874,   874,
     874,   874,   874,   875,   875,   875,   876,   878,   877,   879,
     880,   879,   881,   881,   882,   882,   883,   883,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   885,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   886,   886,   887,
     887,   888,   889,   889,   890,   890,   890,   891,   892,   893,
     893,   893,   893,   894,   894,   895,   896,   895,   897,   897,
     897,   897,   897,   898,   898,   899,   899,   900,   901,   902,
     902,   903,   903,   904,   905,   906,   906,   907,   907,   908,
     908,   909,   909,   910,   911,   911,   911,   912,   912,   913,
     914,   915,   916,   916,   917,   918,   919,   919,   920,   921,
     922,   923,   923,   924,   925,   926,   926,   927,   928,   928,
     928,   928,   928,   928,   928,   928,   928,   928,   928,   928,
     928,   928,   928,   929,   929,   930,   930,   931,   931,   931,
     933,   932,   934,   934,   936,   935,   937,   937,   937,   938,
     938,   938,   938,   938,   938,   938,   938,   938,   939,   939,
     940,   940,   940,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   940,   940,   940,   941,   941,   941,
     941,   941,   941,   942,   942,   942,   942,   942,   942,   942,
     943,   944,   944,   944,   944,   944,   944,   944,   945,   945,
     945,   945,   945,   945,   946,   946,   946,   946,   946,   947,
     947,   947,   947,   947,   948,   948,   948,   948,   948,   948,
     948,   948,   948,   949,   949,   949,   949,   950,   950,   950,
     950,   951,   951,   951,   951,   951,   951,   951,   952,   952,
     953,   953,   953,   953,   953,   953,   954,   954,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   956,   956,   956,
     956,   956,   956,   956,   956,   956,   956,   956,   956,   956,
     956,   956,   956,   956,   956,   956,   956,   956,   956,   956,
     956,   956,   956,   956,   956,   956,   956,   956,   956,   956,
     956,   957,   957,   957,   957,   957,   957,   957,   957,   957,
     957,   957,   957,   957,   957,   957,   957,   957,   957,   957,
     957,   958,   958,   958,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   958,   958,   958,   959,
     959,   960,   961,   961,   962,   962,   963,   964,   965,   965,
     965,   966,   967,   967,   968,   968,   969,   969,   969,   970,
     970,   971,   971,   972,   972,   973,   973,   973,   973,   973,
     974,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     5,     1,     0,     2,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     3,     2,     2,     2,     2,     3,     3,     5,     5,
       5,     4,     5,     5,     4,     3,     3,     5,     6,     1,
       1,     3,     6,     4,     1,     0,     2,     0,     1,     1,
       1,     1,     1,     1,     2,     3,     3,     3,     3,     3,
       2,     5,     2,     2,     3,     3,     1,     3,     1,     1,
       1,     3,     2,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     6,     1,     1,     1,
       1,     0,     1,     1,     2,     3,     4,     3,     2,     2,
       3,     4,     3,     2,     4,     1,     1,     1,     1,     1,
       4,     4,     1,     3,     3,     4,     6,     6,     6,     6,
       4,     6,     2,     4,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     1,     3,     3,     3,     3,     2,
       1,     1,     0,     2,     0,     2,     9,     1,     1,     1,
       1,     1,     2,     0,     1,     1,     3,     3,     1,     1,
       3,     3,     3,     4,     1,     0,     2,     0,     3,     0,
       1,     0,    11,    12,     1,     1,     2,     2,     2,     2,
       0,     1,     0,     1,     3,     1,     1,     1,     3,     2,
       0,     3,     1,     1,     2,     1,     2,     3,     4,     2,
       5,     1,     2,     2,     2,     3,     2,     2,     0,     3,
       1,     4,     5,     6,    11,     3,     0,     3,     1,     1,
       2,     2,     0,     1,     1,     2,     2,     0,     3,     3,
       2,     1,     1,     2,     2,     4,     0,     2,     2,     0,
       3,     4,     4,     0,     2,     0,     4,     0,     0,     8,
       3,     3,     1,     3,     0,     3,     1,     1,     5,     4,
       2,     0,     2,     1,     2,     3,     2,     2,     2,     2,
       3,     3,     1,     0,     5,     9,     1,     0,     1,     2,
       2,     0,     2,     0,     5,     1,     0,     6,     2,     0,
       3,    14,    19,     1,     1,     1,     3,     5,     1,     1,
       1,     3,     0,     1,     0,     1,     1,     1,     3,     0,
       1,     1,     0,     2,     1,     2,     1,     2,     2,     1,
       2,     2,     6,     8,     3,     4,     4,     4,     5,     3,
       3,     1,     3,     3,     1,     1,     1,     1,    12,     1,
       3,     4,     7,     4,     2,     1,     0,     1,     0,     7,
       4,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     2,     2,     3,     3,     5,     4,     4,     3,
       4,     3,     3,     2,     4,     2,     1,     1,     1,     1,
       2,     2,     1,     1,     1,     2,     2,     1,     2,     2,
       1,     1,     6,     9,     7,     9,     8,     8,     6,     9,
       7,    10,     7,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     7,     7,    10,     2,     1,
       1,     1,     3,     1,     1,     1,     1,     1,     2,     2,
       2,     2,     2,     2,     1,     3,     1,     2,     3,     0,
       1,     3,     2,     6,     6,     3,     0,     3,     0,    12,
       1,     0,     2,     0,     1,     3,     2,     2,     4,     1,
       2,     0,     9,     7,     2,     0,     3,     2,     1,     3,
       3,     3,     2,     2,     1,     1,     1,     1,     2,     1,
       3,     1,     1,     1,     4,     1,     2,     4,     5,     1,
       1,     1,     1,     3,     3,     2,     2,     2,     2,     1,
       2,     0,     5,     1,     2,     1,     0,     5,     7,     1,
       1,     7,     1,     3,     3,     3,     1,     3,    11,    10,
       2,     0,     8,     4,     4,     4,     1,     1,     1,     0,
       9,     6,     6,     7,     6,     6,     9,     6,     6,     6,
       8,     8,     6,     6,     1,     0,     9,     6,     7,     6,
       6,     6,     9,     6,     6,     6,     7,     9,     9,     6,
       6,     6,     0,    14,     1,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     1,     1,
       1,     1,     0,     6,     2,     2,     2,     2,     2,     3,
       3,     2,     2,     2,     2,     3,     2,     5,     4,     3,
       3,     3,     1,     1,     0,     3,     2,     2,     1,     3,
       2,     1,     0,     7,     9,     2,     5,     3,     1,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     4,     3,
       3,     1,     0,     5,     5,     4,     2,     0,     4,     3,
       6,     4,     6,     6,     5,     7,     1,     0,    10,     4,
       2,     1,     4,     5,     5,     2,     4,     1,     1,     1,
       0,     1,     0,     1,     0,     3,     0,     4,     1,     1,
       1,     1,     1,     1,     0,     4,     4,     2,     1,     7,
       4,     3,     1,     2,     5,     2,     0,     5,     3,     0,
       2,     2,     2,     3,     1,     3,     1,     2,     1,     0,
       6,     7,     0,     2,     2,     2,     3,     0,     2,     2,
       1,     1,     3,     3,     1,     2,     4,     4,     1,     1,
       8,     4,     4,     4,     2,     1,     0,     3,     3,     4,
       4,     4,     4,     2,     1,     1,     0,     1,     0,     1,
       5,     1,     0,     1,     0,     3,     1,     3,     3,     2,
       2,     1,     4,     4,     2,     2,     4,     1,     0,     1,
       1,     1,     3,     0,     2,     0,     4,     4,     3,     1,
       0,     2,     0,     2,     0,     3,     1,     1,     2,     1,
       2,     5,     6,     5,     1,     2,     1,     4,     3,     4,
       3,     5,     4,     5,     4,     5,     2,     4,     1,     2,
       2,     2,     1,     1,     0,     4,     2,     1,     2,     2,
       4,     1,     2,     0,     1,     3,     2,     2,     3,     5,
       6,     3,     4,     0,     1,     3,     3,     3,     3,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     2,     5,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     2,     1,     3,     0,
       5,     3,     0,     5,     3,     0,     1,     1,     1,     1,
       5,     2,     1,     1,     1,     1,     5,     2,     2,     2,
       1,     3,     3,     2,     1,     0,     3,     0,     5,     2,
       5,     2,     1,     3,     3,     0,     1,     1,     1,     1,
       1,     1,     3,     3,     3,     3,     3,     3,     3,     0,
       1,     3,     5,     2,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     2,     3,     3,     2,
       3,     5,     4,     6,     3,     5,     4,     6,     4,     6,
       5,     7,     2,     3,     2,     4,     3,     4,     3,     4,
       3,     4,     5,     6,     7,     6,     7,     6,     7,     3,
       4,     4,     6,     2,     1,     3,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     2,     2,     5,
       6,     7,     1,     1,     2,     4,     1,     1,     1,     2,
       2,     2,     1,     3,     4,     5,     5,     4,     1,     1,
       4,     1,     4,     1,     4,     1,     4,     1,     1,     1,
       1,     6,     4,     4,     4,     4,     6,     5,     5,     5,
       4,     6,     4,     6,     4,     4,     4,     4,     3,     5,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     1,     4,     1,     4,
       1,     2,     1,     2,     1,     3,     3,     0,     3,     1,
       1,     3,     3,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     4,     3,     2,     3,     0,     3,     3,     2,
       2,     1,     0,     2,     2,     3,     2,     1,     1,     3,
       5,     2,     1,     4,     2,     0,     1,     0,     1,     2,
       2,     2,     3,     5,     1,     2,     0,     2,     1,     0,
       3,     1,     3,     1,     1,     3,     7,     1,     2,     4,
       1,     3,     4,     4,     3,     1,     1,     1,     1,     1,
       1,     3,     1,     2,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     2,     3,     6,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     5,
       3,     2,     2,     3,     7,     1,     2,     2,     1,     0,
       1,     3,     1,     2,     0,     2,     0,     2,     0,     1,
       3,     4,     3,     1,     1,     1,     2,     0,     7,     3,
       2,     1,     1,     1,     0,     5,     0,     4,     2,     1,
       2,     0,     1,     3,     3,     3,     3,     0,     4,     5,
       5,     0,     1,     1,     1,     1,     2,     2,     2,     1,
       2,     0,     7,     0,     5,     0,     4,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       5,     2,     1,     3,     2,     2,     3,     0,     5,     1,
       0,     5,     2,     2,     1,     1,     1,     2,     2,     3,
       1,     2,     2,     3,     3,     4,     2,     1,     2,     1,
       1,     2,     2,     3,     1,     1,     1,     1,     0,     1,
       3,     4,     0,     2,     0,     1,     2,     3,     2,     1,
       1,     1,     0,     1,     1,     3,     0,     4,     2,     2,
       1,     1,     0,     1,     1,     1,     1,     2,     3,     0,
       1,     2,     1,     4,     4,     0,     1,     2,     1,     1,
       3,     1,     1,     4,     4,     4,     4,     1,     0,     3,
       3,     4,     1,     3,     3,     4,     1,     3,     3,     1,
       6,     1,     3,     3,     6,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     4,     1,     1,     4,     4,     3,
       0,     7,     1,     0,     0,     7,     3,     4,     3,     1,
       1,     1,     2,     3,     5,     2,     5,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     0,     1,     2,     1,     2,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     2,     3,     1,
       2,     1,     3,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  2005,  2006,  2009,  2013,  2014,  1941,
    2015,  2016,  1981,  1982,  1983,  1984,  1985,  1986,  1987,  1988,
    1989,  1990,  1991,  1992,  1994,  1993,  1995,  1996,  1997,  1998,
    1999,  2000,  2001,  2002,  2004,  2003,  2018,  2019,  2007,  2008,
    2010,  2011,  1980,  2012,  2020,  2021,  2022,  2017,  1970,  1266,
    1971,    10,  1262,  1263,  2025,  1976,  1977,  1975,  1978,  1979,
    2023,  2024,  1966,  1967,  1969,    11,    12,  1968,     4,  1972,
    1973,  1974,     8,  1347,  1418,     9,  1965,  1418,     0,  1530,
    1531,  1532,     0,  1533,  1534,  1535,  1536,  1537,  1468,  1432,
       0,  1538,     0,  1539,  1540,  1541,  1542,  1543,  1544,  1545,
    1546,  1547,     0,  1548,  1549,  1550,  1551,  1417,  1552,  1553,
    1554,  1555,  1394,  1400,  1556,  1514,     0,  1374,  1375,  1371,
    1373,  1372,  1376,  1361,   714,     0,   768,   767,     0,  1851,
     714,  1852,  1817,  1853,  1818,  1819,   219,     0,   761,  1820,
       0,   714,  1821,   275,   290,  1854,     0,     0,  1822,  1823,
       0,     0,   396,   714,     0,  1824,   784,  1825,     0,  1826,
    1855,  1856,     0,     0,  1827,  1857,  1858,  1828,     0,  1829,
    1830,  1859,  1860,  1861,  1831,  1862,  1863,     0,     0,   846,
       0,  1832,  1864,  1833,  1834,     0,  1865,  1835,  1836,  1837,
    1866,  1867,  1838,  1839,  1840,     0,  1841,     0,     0,     0,
       0,  1868,   714,  1842,     0,   852,     0,  1843,     0,  1869,
    1844,     0,  1845,  1846,  1847,  1848,  1849,   846,  1510,  1395,
       0,     0,   772,  1850,  1870,  1952,  1953,     0,     0,     0,
      42,    48,    24,    23,    25,    58,    63,    39,    18,    55,
      43,    89,    90,    91,    31,    27,    22,    28,    32,    45,
      33,    44,    21,    40,    57,    46,    61,    47,    62,    34,
      53,    51,    41,    56,    60,    85,    66,    30,    67,    80,
      68,    81,    69,    38,    17,    78,    76,    77,    35,    54,
      75,    79,    19,    20,    82,    59,    74,    71,    86,    84,
      92,    72,    49,    14,    15,    64,    37,    16,    36,    29,
      88,    26,   770,    65,    70,    52,    73,    87,    50,    83,
     829,   820,   854,   828,    94,    95,    96,     7,  1331,  1333,
    1332,  1418,  1369,  1370,  1336,  1379,  1389,  1378,  1382,  1390,
    1377,  1396,     0,    98,   100,   101,   102,   105,   106,    99,
      93,    97,   104,   110,   103,   109,   107,   108,   111,   112,
     113,  1606,  1019,  1604,  1605,  1603,  1353,     0,  1418,  1355,
    1354,  1418,  1365,  1389,     0,  1557,  1558,  1559,  1560,  1561,
    1562,  1611,  1612,  1613,  1614,  1615,  1617,  1616,  1628,  1629,
    1630,  1631,  1632,  1633,  1634,  1635,  1636,  1637,  1638,  1639,
    1640,  1641,  1642,  1643,  1644,  1645,  1646,  1647,  1583,  1648,
    1649,  1650,  1651,  1652,  1653,  1654,  1655,  1627,  1656,  1657,
    1658,  1659,  1660,  1661,  1662,  1663,  1664,  1665,  1620,  1666,
    1667,  1668,  1669,  1670,  1671,  1672,  1673,  1674,  1675,  1676,
    1677,  1678,  1679,  1680,  1681,  1683,  1682,  1684,  1685,  1686,
    1687,  1688,  1689,  1690,  1691,  1692,  1693,  1694,  1695,  1621,
    1696,  1697,  1698,  1699,  1700,  1701,  1702,  1703,  1704,  1705,
    1706,  1707,  1708,  1709,  1710,  1711,  1712,  1713,  1714,  1715,
    1716,  1717,  1718,  1719,  1720,  1721,  1622,  1722,  1723,  1623,
    1724,  1725,  1726,  1727,  1728,  1729,  1730,  1731,  1732,  1733,
    1734,  1735,  1736,  1737,  1738,  1739,  1740,  1741,  1742,  1743,
    1744,  1747,  1745,  1746,  1748,  1749,  1750,  1751,  1752,  1753,
    1754,  1755,  1756,  1757,  1758,  1759,  1760,  1761,  1762,  1763,
    1764,  1765,  1766,  1767,  1768,  1769,  1770,  1771,  1772,  1624,
    1773,  1774,  1775,  1776,  1777,  1778,  1779,  1780,  1781,  1782,
    1783,  1784,  1785,  1786,  1788,  1787,  1790,  1789,  1791,  1792,
    1793,  1794,     0,  1795,  1796,  1797,  1798,  1799,  1800,  1801,
    1802,  1803,  1804,  1805,  1806,  1807,  1808,  1809,  1810,  1811,
    1812,  1813,  1814,  1815,  1625,  1816,  1951,  1278,  1324,  1323,
    1301,  1319,  1581,  1528,  1529,  1296,  1582,  1579,  1618,  1619,
    1626,  1580,  1279,  1947,  1578,  1467,     0,     0,  1430,  1431,
    1434,  1309,  1433,     0,  1305,  1428,  1429,  1247,  1325,  1578,
    1563,  1564,  1565,  1566,  1568,  1567,  1569,  1871,  1872,  1873,
    1874,  1875,  1876,  1877,  1878,  1879,  1880,  1881,  1882,  1596,
    1883,  1884,  1885,  1886,  1887,  1888,  1891,  1889,  1890,  1892,
    1893,  1894,  1895,  1896,  1897,  1898,  1899,  1900,  1901,  1902,
    1903,  1904,  1905,  1906,  1907,  1908,  1909,  1597,  1598,  1910,
    1911,  1912,  1913,  1914,  1915,  1916,  1917,  1918,  1919,  1920,
    1921,  1922,  1923,  1924,  1925,  1926,  1927,  1928,  1929,  1930,
    1931,  1600,  1932,  1933,  1599,  1934,  1935,  1936,  1937,  1938,
       0,  1384,  1610,  1595,  1385,  1570,  1607,  1594,  1601,  1602,
    1609,  1608,  1447,  1246,  1449,  1392,  1402,  1398,  1406,  1401,
       0,     0,     0,     0,  1418,   713,   712,   698,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    13,     0,   722,   255,  1298,
    1297,  1242,   760,     0,  1238,  1239,   396,     0,   701,   274,
       0,     0,     0,     0,     0,     0,   455,     0,     0,     0,
       0,     0,     0,     0,   155,     0,   285,   284,     0,   386,
       0,   560,     0,     0,   396,     0,     0,     0,  1302,     0,
    1745,  1445,  1446,  1330,  1782,   812,     0,     0,     0,     0,
     467,     0,   466,     0,     0,   464,     0,   395,     0,     0,
     468,   462,   461,     0,     0,   465,     0,   463,     0,     0,
     702,  1696,  1436,   783,   770,  1629,   493,   497,   488,   494,
     501,   500,   489,   486,   487,  1756,     0,     0,     0,   483,
    1267,  1269,   492,  1268,     0,   529,   535,   534,   533,     0,
     530,   531,   536,     0,   695,  1239,   725,  1251,   845,     0,
       0,   485,   694,  1796,     0,     0,   636,     0,   637,     0,
    1770,   706,   213,  1577,  1775,  1846,  1796,   209,  1575,   176,
    1576,  1572,  1573,  1574,  1571,     0,     0,   530,     0,   703,
     704,   851,   849,     0,     0,     0,     0,  1656,  1716,  1725,
    1766,  1775,  1846,  1796,   164,     0,   208,  1775,  1846,  1796,
     204,   722,     0,     0,  1393,   697,   696,     0,     0,   917,
     771,   774,   829,     0,   714,     0,     6,   769,   765,   848,
     848,     0,   848,     0,   825,  1334,  1389,  1368,  1424,  1338,
       0,     0,  1414,  1410,  1407,  1415,  1416,  1409,  1397,  1008,
    1009,  1010,  1007,  1011,  1006,     0,  1342,  1381,  1348,     0,
    1358,  1357,  1356,  1363,  1424,  1367,  1954,  1955,  1469,  1300,
    1316,     0,     0,     0,     0,     0,     0,  1308,  1314,     0,
    1306,     0,     0,  1959,  1963,     0,  1961,  1956,  1383,  1455,
    1448,  1450,  1452,  1404,  1403,  1399,     0,     0,  1519,     0,
       0,  1520,  1521,     0,  1516,  1518,     0,  1424,     0,     0,
    1581,  1252,  1582,  1579,  1591,  1578,     0,   471,   116,     0,
       0,   471,     0,     0,     0,     0,     0,  1650,  1143,  1153,
    1151,  1152,  1145,  1146,  1147,  1150,  1148,  1149,     0,   626,
    1144,     0,   116,     0,     0,   371,     0,     0,     0,     0,
     116,     0,     0,     0,   718,   721,   699,     0,     0,  1214,
    1243,     0,     0,     0,   513,   522,   514,   519,     0,   516,
       0,     0,     0,   515,   517,   518,     0,   520,   521,     0,
       0,   710,   277,     0,     0,     0,     0,   727,   757,   289,
     288,   116,   287,   286,     0,     0,   574,   116,     0,   157,
     399,     0,     0,   116,     0,     0,     0,     0,     0,     0,
       0,     0,  1470,  1329,  1427,     0,   796,     0,   434,     0,
     749,     0,   151,  1244,     0,     0,   145,     0,   400,     0,
     146,     0,   252,   469,  1444,  1443,  1435,  1442,     0,   490,
     499,   498,   496,   495,   491,  1270,     0,   481,   482,  1455,
    1458,   479,     0,   528,     0,     0,     0,     0,   799,  1240,
       0,   709,     0,   639,   639,   639,   705,   212,   210,     0,
       0,     0,     0,     0,   711,     0,     0,     0,  1817,  1818,
     967,  1207,     0,  1583,  1819,  1820,  1821,  1108,  1117,  1109,
    1111,  1118,  1822,  1823,  1675,  1824,  1825,  1259,  1826,  1827,
     957,  1829,  1830,  1831,  1113,  1115,  1832,  1833,     0,  1260,
    1835,  1836,  1740,  1838,  1839,  1841,  1842,  1119,  1844,  1845,
    1846,  1847,  1848,  1849,  1258,     0,  1120,  1850,  1154,  1264,
    1265,  1216,     0,     0,  1224,     0,  1098,     0,   951,   953,
     954,   978,   979,   955,   984,   985,   997,   952,     0,  1223,
    1020,  1097,  1102,     0,  1096,  1092,   836,  1221,  1208,     0,
    1093,  1292,  1291,  1293,  1294,  1290,  1254,  1581,  1587,   956,
    1582,  1579,  1261,  1295,  1947,  1578,     0,     0,     0,     0,
       0,  1509,   215,     0,   216,  1775,   165,   200,   172,   199,
     173,   203,   202,     0,  1648,   166,     0,   170,     0,     0,
     207,   205,     0,   700,   475,     0,     0,   919,     0,   918,
     773,   770,   823,   822,     5,   776,   847,     0,     0,     0,
       0,     0,     0,     0,   880,   868,  1424,  1425,     0,  1419,
       0,  1418,  1418,  1412,  1411,  1408,     0,     0,     0,     0,
       0,     0,  1284,  1283,  1339,  1341,  1287,     0,  1424,     0,
       0,  1318,     0,  1322,  1320,  1455,  1464,  1455,  1465,  1466,
    1312,  1307,  1310,     0,  1303,  1314,  1957,     0,     0,  1960,
    1386,     0,  1456,  1288,  1289,  1461,     0,  1451,  1459,  1462,
    1405,  1418,  1527,     0,  1522,  1525,     0,  1517,     0,  1253,
       0,     0,     0,     0,   472,     0,     0,     0,   115,   747,
     745,     0,     0,     0,   751,     0,     0,     0,   600,     0,
       0,   601,   599,   602,   613,   616,     0,   552,   149,   150,
       0,     0,     0,     0,     0,   221,   244,     0,     0,     0,
       0,     0,     0,   141,     0,     0,     0,   369,   655,   655,
       0,     0,     0,   655,     0,   655,     0,   220,   222,     0,
       0,     0,     0,     0,     0,     0,     0,   144,  1349,     0,
     716,   717,     0,   720,     0,  1211,  1210,  1249,  1215,   759,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   435,     0,   960,   995,   995,   995,   975,
     975,   969,   958,  1002,     0,   995,   972,   961,     0,   959,
    1005,  1005,   990,     0,   933,   943,   945,   946,   976,   977,
     947,   982,   983,   944,  1019,  1586,   956,  1588,  1585,  1584,
       0,     0,   756,     0,     0,   456,   436,     0,     0,     0,
     153,     0,     0,   404,   403,     0,     0,   437,     0,   371,
     364,   326,     0,     0,     0,  1250,     0,     0,   813,   817,
     814,     0,   815,     0,   923,     0,     0,   252,     0,     0,
       0,     0,     0,   252,   250,   251,     0,   460,  1437,  1440,
    1441,     0,   777,   779,   781,   780,   782,   778,   480,   477,
     478,     0,  1457,  1939,  1945,     0,  1471,  1472,     0,  1665,
    1690,  1710,  1771,     0,  1791,     0,   537,   556,   532,     0,
       0,     0,   785,   788,     0,     0,   809,   484,  1463,   638,
     635,   634,   633,   211,   177,     0,     0,   558,  1770,   708,
       0,     0,  1100,  1101,   994,   981,  1206,     0,     0,   989,
     988,     0,     0,     0,     0,     0,   965,   964,   963,  1099,
    1167,     0,   962,     0,     0,     0,     0,   995,   995,   993,
    1039,     0,     0,   966,     0,     0,  1186,     0,  1192,     0,
       0,     0,  1001,     0,   999,     0,     0,  1073,  1094,  1023,
    1024,  1098,  1164,     0,  1255,     0,     0,   987,     0,  1019,
       0,     0,     0,     0,  1219,  1162,     0,     0,  1052,  1160,
       0,  1054,     0,     0,     0,  1154,  1153,  1151,  1152,  1145,
    1146,  1147,  1150,  1148,  1149,  1158,  1036,     0,  1035,  1455,
       0,   884,   835,  1209,     0,     0,  1946,  1948,  1506,  1505,
    1504,  1503,  1479,     0,  1475,  1476,     0,  1507,  1508,   217,
     218,   214,     0,   175,   174,     0,   197,   198,   169,     0,
     193,   194,   179,   190,   192,   191,   189,   167,   178,   180,
     186,   187,   188,   168,   206,  1418,     0,     0,   884,  1227,
    1216,   762,     0,   766,   829,   833,   828,   832,   855,   856,
     861,   831,     0,   882,   882,   870,   864,   869,   865,   871,
     879,   827,   867,   826,     0,  1426,  1337,  1424,   933,  1418,
    1359,  1418,  1413,  1345,  1013,  1014,  1015,  1016,  1018,  1017,
    1346,  1343,  1012,  1344,  1286,  1285,     0,     0,     0,     0,
    1366,  1315,     0,  1299,  1321,     0,  1313,     0,  1958,  1964,
    1962,     0,     0,   933,  1942,  1523,  1942,   933,   620,     0,
     619,     0,     0,   473,     0,     0,     0,   744,   743,     0,
       0,     0,     0,     0,   754,   320,     0,   249,     0,     0,
       0,     0,     0,     0,     0,     0,   605,   606,   615,   614,
     612,   585,   587,   586,   577,     0,   578,     0,     0,   584,
     593,  1592,   956,   591,  1593,  1590,  1589,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     622,   627,   140,     0,     0,   124,   126,     0,     0,   122,
     128,   125,   127,   123,   129,   121,     0,     0,   120,     0,
       0,     0,     0,   139,     0,     0,     0,     0,   373,   383,
       0,     0,     0,   116,   116,   370,   654,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   143,   142,     0,
       0,   185,   715,   719,  1212,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   276,   258,   257,
       0,     0,   441,   444,     0,   933,     0,     0,     0,   927,
    1008,  1007,  1006,     0,   948,   950,     0,     0,   742,   742,
     742,   742,   742,   726,   728,   300,   147,     0,     0,   114,
     157,   290,     0,   156,   158,   160,   161,   162,   159,   163,
     398,     0,   409,   408,   410,     0,   405,     0,   438,   138,
     368,     0,   292,     0,     0,     0,   384,     0,     0,     0,
     672,     0,     0,     0,   816,     0,   894,   795,   886,   896,
     887,   889,   921,  1242,     0,   794,     0,     0,   617,  1245,
       0,     0,   252,   252,   394,   470,  1438,  1439,   812,   476,
       0,     0,  1944,  1271,     0,  1272,     0,     0,   540,   539,
     550,     0,   541,   542,   538,   543,     0,     0,   558,   787,
       0,     0,   792,  1216,     0,   806,     0,   804,     0,  1241,
     808,   797,     0,   530,     0,     0,   252,   707,  1164,     0,
       0,     0,  1170,     0,     0,  1205,  1202,     0,     0,  1164,
       0,     0,     0,     0,  1177,  1178,  1179,  1176,  1180,  1175,
       0,     0,  1181,  1174,     0,     0,     0,     0,     0,   992,
     991,     0,     0,     0,     0,     0,     0,     0,  1074,     0,
       0,  1138,     0,  1164,  1191,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1164,  1197,     0,  1217,  1216,
       0,     0,     0,     0,  1256,  1021,  1037,  1222,     0,  1218,
       0,     0,  1044,     0,  1198,  1069,     0,  1058,     0,  1053,
       0,  1056,  1060,  1040,  1219,  1163,     0,  1161,     0,     0,
    1038,     0,  1033,  1031,  1032,  1025,  1026,  1027,  1028,  1029,
    1030,  1034,  1142,  1140,  1141,     0,  1691,  1716,     0,   846,
     846,   834,   844,  1220,     0,   923,     0,     0,     0,  1103,
       0,  1950,  1949,     0,     0,     0,     0,     0,  1019,     0,
     933,   920,     0,  1216,     0,   923,     0,   764,   763,     0,
       0,   859,   860,     0,   878,     0,   809,   809,     0,     0,
       0,  1335,  1420,  1422,  1388,  1360,  1391,  1340,  1380,     0,
    1364,  1317,  1311,     0,  1453,  1460,  1513,     0,  1943,     0,
       0,     0,   663,   641,   474,   664,   642,     0,   746,     0,
       0,     0,     0,     0,   252,   752,   248,   753,   657,   665,
       0,   603,   604,     0,   588,   576,     0,     0,   583,     0,
     582,   950,     0,     0,     0,   644,   148,   246,   649,   247,
     245,   645,     0,  1248,     0,     0,     0,   134,     0,     0,
       0,     0,   117,   135,   133,     0,   132,     0,   669,   647,
     659,   372,   382,     0,   376,   377,   374,   378,   379,     0,
       0,   224,     0,     0,   236,   235,   242,   243,   241,   252,
     252,   239,   240,   238,   648,     0,   660,   237,   234,     0,
     223,   671,   653,     0,   670,   661,   652,   183,   182,   184,
       0,     0,     0,     0,     0,     0,     0,   524,   508,   523,
       0,     0,     0,   502,   260,   261,   279,   259,   440,     0,
       0,     0,     0,   928,     0,     0,   933,     0,     0,   941,
     934,   942,     0,     0,     0,     0,   742,   741,     0,     0,
       0,     0,     0,   729,   750,     0,   326,   152,     0,     0,
     397,     0,     0,     0,   924,     0,     0,     0,     0,   291,
     293,   295,   296,   297,     0,   366,   367,   362,     0,     0,
     358,     0,   328,   329,     0,     0,     0,   563,     0,     0,
       0,   611,   609,   595,     0,   818,   819,     0,   894,     0,
     896,     0,   895,   908,     0,     0,   914,   912,     0,   914,
       0,   914,     0,     0,   888,     0,   890,   908,  1243,   922,
     252,     0,   252,   252,   693,   432,     0,  1454,  1940,  1480,
    1481,     0,  1473,  1474,     0,   552,     0,   549,   544,   546,
       0,   553,  1237,  1236,     0,  1235,     0,     0,   793,   807,
     800,   802,   801,     0,     0,   798,     0,   252,     0,   554,
     850,     0,  1172,  1173,     0,     0,     0,     0,  1201,     0,
       0,  1134,     0,  1132,  1110,  1112,   974,     0,  1122,     0,
     968,  1135,  1136,  1114,  1116,     0,   971,     0,  1155,     0,
       0,  1123,  1076,     0,     0,     0,     0,  1154,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1088,  1087,  1124,
    1137,     0,     0,  1189,  1190,  1125,  1003,  1004,  1005,  1005,
       0,     0,  1196,     0,     0,     0,  1130,  1095,  1165,   996,
     997,     0,     0,     0,     0,     0,     0,     0,  1059,  1055,
       0,  1057,  1061,     0,     0,     0,     0,  1046,  1070,  1042,
       0,     0,  1048,     0,  1071,   846,   846,   846,   846,   843,
       0,     0,   883,   873,     0,     0,  1107,  1104,  1488,  1489,
    1490,  1491,  1492,  1493,  1494,  1495,  1496,  1497,  1499,  1500,
    1501,  1498,  1502,  1484,  1485,     0,  1477,  1478,   171,     0,
     195,   181,  1513,     0,  1228,  1225,   810,     0,   775,   857,
       0,  1156,   858,   881,   877,   876,   862,   866,   863,     0,
    1421,  1350,  1327,  1512,  1515,  1526,  1524,  1362,     0,     0,
       0,   742,     0,   319,     0,     0,     0,   755,   597,     0,
     579,   580,   581,     0,   666,   643,   658,     0,     0,   624,
       0,   625,   623,   130,   118,   137,   136,   119,   131,   375,
     381,   380,   300,     0,     0,     0,   225,   233,   230,     0,
       0,  1213,     0,     0,   504,   510,     0,     0,     0,     0,
     512,   280,   116,     0,   442,  1740,  1146,   443,   445,   446,
     447,     0,     0,     0,     0,   931,     0,     0,     0,     0,
       0,     0,   933,  1019,     0,     0,   737,  1280,  1281,   736,
    1282,   733,   732,   740,   739,   731,   730,   735,   734,     0,
       0,     0,   311,     0,     0,   305,     0,     0,   357,   299,
     302,   303,     0,     0,   290,     0,   412,   406,   439,     0,
     926,   292,   318,   346,     0,   363,     0,     0,     0,     0,
     325,     0,   723,   391,   388,     0,     0,     0,   607,   589,
     608,     0,   592,     0,   596,   573,     0,   811,  1328,   898,
     906,     0,   885,     0,   913,   909,     0,   910,     0,     0,
     911,   900,     0,     0,   906,     0,   618,   252,   459,   621,
     817,     0,     0,   551,   547,     0,     0,   525,   555,   786,
       0,     0,   790,   791,   805,   803,     0,   526,   557,  1165,
    1171,   980,     0,  1204,  1200,     0,     0,     0,  1166,     0,
       0,  1184,  1183,  1075,  1185,     0,     0,     0,  1086,  1085,
    1083,  1084,  1077,  1078,  1079,  1080,  1081,  1082,  1194,  1193,
    1187,  1188,  1000,   998,     0,  1127,  1128,  1129,  1195,  1139,
     986,  1019,  1022,     0,     0,  1045,  1199,  1062,     0,  1169,
       0,  1041,     0,     0,     0,     0,  1050,  1155,     0,     0,
       0,     0,     0,     0,   838,   837,     0,   875,  1105,  1106,
       0,     0,     0,  1511,     0,     0,  1233,  1232,     0,  1423,
       0,  1304,     0,     0,     0,     0,   321,     0,     0,   357,
     598,   594,     0,     0,     0,   298,     0,     0,     0,     0,
     254,   650,   651,     0,     0,     0,     0,   507,   506,   263,
       0,   429,     0,     0,   433,   424,   426,     0,     0,     0,
     929,   935,   936,   937,   938,   939,   940,   932,   949,   422,
     738,     0,     0,   309,   313,   314,   312,   304,   357,   326,
       0,   306,     0,     0,     0,   414,     0,     0,   925,     0,
       0,     0,   315,     0,   349,   294,   365,   367,   360,   361,
     359,   327,     0,   393,   389,     0,   562,     0,     0,   611,
     610,   688,   689,   686,   687,     0,   897,     0,     0,   899,
       0,     0,   902,   904,     0,     0,     0,     0,     0,  1246,
     632,     0,  1482,  1483,     0,   545,  1234,     0,     0,  1203,
    1121,  1131,   973,  1133,   970,  1182,     0,     0,     0,  1126,
    1257,  1067,  1065,     0,  1063,     0,     0,     0,  1047,  1043,
       0,  1049,  1072,   842,   841,   840,   839,     0,     0,   830,
    1486,     0,  1273,  1277,  1274,  1487,  1019,     0,  1229,     0,
    1326,   662,   640,   656,   748,     0,   357,   322,   668,   646,
     667,   226,   227,   228,   229,     0,   231,   503,     0,   509,
     505,   256,   278,   431,   430,   428,   425,   427,   930,     0,
     631,     0,     0,     0,     0,   301,   307,   332,     0,     0,
     724,   292,   413,     0,     0,   407,   349,   317,   316,     0,
       0,     0,   353,   390,     0,   385,     0,     0,     0,   564,
     571,   571,   590,   572,     0,     0,   907,   916,     0,   903,
     901,   891,     0,   893,     0,   548,     0,   252,  1089,     0,
       0,  1064,  1168,  1068,  1066,  1051,   872,   874,  1276,  1275,
     196,  1230,     0,  1157,     0,   323,   253,   511,   264,   268,
     757,   757,     0,   269,   757,   265,   757,   262,   631,     0,
     629,   423,     0,   308,     0,   337,     0,     0,   415,   416,
     411,     0,   353,     0,   347,   348,     0,   355,   392,   758,
       0,   355,     0,     0,   569,   567,   566,   923,   905,     0,
     892,   789,   527,     0,  1090,     0,  1226,   326,     0,     0,
       0,     0,     0,     0,   628,   630,     0,   330,   331,     0,
     310,   333,   334,   356,     0,     0,   355,   345,     0,     0,
     282,   571,   923,   565,   570,     0,   915,  1091,  1231,   332,
     266,   271,     0,   272,   267,   270,     0,     0,     0,     0,
     335,     0,   336,     0,     0,     0,   448,   449,   419,   283,
       0,   350,     0,   354,   568,   559,   692,   337,   273,     0,
     342,     0,   341,     0,   338,   339,     0,     0,   454,     0,
       0,   417,   420,   421,   351,   352,   691,   690,     0,     0,
       0,   340,   343,   344,     0,   458,   450,   401,     0,   674,
     685,   673,   675,   683,   680,   682,   681,   679,   324,     0,
     453,   457,     0,   451,   418,     0,   684,   678,   829,   820,
       0,     0,   676,   685,   419,   458,   677,     0,   452,   402
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    68,   228,   229,   230,  1389,  1903,   231,
     232,   233,   234,   235,   236,   237,   238,  1411,   239,   240,
    1088,  1520,  1993,   241,   894,   895,  1737,  1738,  1942,  1739,
    1740,  1728,  1278,  1280,   242,   243,   244,  1273,  1721,   245,
     246,  1437,  1438,  1415,  1416,  1394,  1557,  3106,   247,   248,
    1960,  2376,  3111,  3197,   750,  1471,  2722,  2723,   249,  1517,
    2418,  2419,  2420,  2421,  2404,  2769,  2770,  2771,  2422,  3002,
    2423,  1835,  2015,  2431,  2432,  3205,  3250,  3251,  3252,  3304,
    3004,  3142,  3217,  3260,  2991,   250,  2789,  2430,  2013,  2424,
    2425,   251,   252,  1427,  1915,  2323,   253,   774,  2793,  3013,
    3145,   254,   808,   255,  1522,   256,   257,  1525,  2005,  2006,
    2996,  3133,  3210,  3310,  3311,  3122,  2964,  2965,  2966,   258,
     259,   260,   261,  2008,  1473,  1961,  1962,  2727,   262,  3286,
    3287,   775,  3343,   263,   264,   809,  1122,  3224,  1384,   265,
     266,   827,   828,   267,  1070,  2368,   268,   269,   839,  2083,
     841,  1585,  2487,  2488,  2837,  2059,  1012,   270,   271,  2068,
    2086,   272,   776,  2797,  3148,  3149,  3225,   273,   777,  1407,
    1855,  1856,  1857,  2798,  1858,  2801,  1859,  2441,  2442,  2443,
    2805,   274,  1405,  1850,   275,   276,  1819,   277,  1879,  1028,
     278,  3200,   279,   280,   859,  1600,   281,  1918,   282,   283,
     284,  2444,  3331,  3345,  3346,  3347,  3025,  3318,   285,  3333,
     287,   288,   289,   737,  1044,  1045,  1046,   290,   291,   292,
    1983,  1984,  2398,   293,   294,  1828,  2268,   295,   296,   297,
    1513,   298,   299,   300,   301,   302,   918,   911,  1301,  1753,
     303,  1562,   814,  3334,  1592,  2071,  2072,  3335,  1544,   306,
    1596,  2078,  2081,  3336,   308,  1105,  2023,  3337,  1226,   311,
     312,   313,  1701,  2201,   849,  1307,   883,   923,   924,  1758,
    1759,  1314,  1773,  1766,  1768,  2917,  3079,  1315,  1771,  2236,
    2205,  2027,  2028,  2029,  2452,  2463,  2815,  3032,  2030,  2031,
    2035,  2413,  2414,  1860,  1969,  2388,  1494,  1227,  1228,  1229,
    1632,  1643,  1626,  1497,  1230,  1231,  1232,  1500,  1233,  1234,
    1235,  1236,  1615,  1667,  1237,  1238,  1652,   946,  2088,  2127,
    1240,  1241,  1242,  2195,  1695,  1030,  1243,  2652,  1697,  2146,
    2110,  2900,  2091,  1613,  2111,  2125,  2540,  2130,  2135,  2563,
    2564,  2147,  2165,  1244,  2095,  2096,  2519,  1617,  1245,  2148,
    1050,  1658,  2161,  1246,  1247,  1748,  2222,  3182,  1749,  2494,
    2495,  1248,  1586,   909,  3028,  1113,   601,  2302,  1456,   743,
     846,  1249,  1250,  1251,  1252,  1253,  1254,  1255,   831,   832,
    2054,  3085,  2369,  2749,  1364,  1741,  1256,   579,   744,   314,
     602,   603,   967,   968,  1351,  1354,  1341,  1803,   580,   581,
     604,  2931,   315,   316,   317,   318,   319,  1316,   928,  1335,
    1797,   947,    72,    77,    73,   948,   357,   358,  1779,   320,
     714,  1780,  1338,   954,   361,   322,   323,   362,   325,   691,
     363,   930,   327,   931,   328,   329,   330,   331,   938,   332,
    1318,  1319,  2660,  1320,   333,   334,   605,   606,   335,  1127,
    1558,  1126,   783,   336,   337,   980,   981,   982,  1140,  1571,
    1141,  1367,  1368,   338,   339,   597,   340,   341,   342,  1576,
    1577,   343,  1714,  1715,  1716,   344,  2479,  2480,   345,  2633,
    2634,  2635,   346,  1710,   347,   348,   903,  2664,   349,   710,
     350,   994,   582,   583,   584,  1258,   694,   869,   845,  1259,
    1001,   695,   352,   697,   586,   587,   588,   589,   590,   591,
    1004,   701,  1572,    74,  2257,  1573,  1262,  1263,  1706,  1264,
     594,   958,   973,   974,  2258,   976,    75,   977
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -2915
static const int yypact[] =
{
   -2915,   339, 12770, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, 15050, -2915, -2915, 33665,   628, -2915,
   -2915, -2915, 36551, -2915, -2915, -2915, -2915, -2915,   559, 36139,
   13403, -2915, 51362, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, 51362, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, 34492,   709, -2915, -2915,   142, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915,   509,  4094, -2915, -2915, 39023, -2915,
      49, -2915, -2915, -2915, -2915, -2915, -2915, 51362, 46430, -2915,
      62,   -45, -2915,   688, 10114, -2915, 39023, 37375, -2915, -2915,
   51773,   771,  5702,   509, 39435, -2915,   816, -2915, 31172, -2915,
   -2915, -2915,   721, 44375, -2915, -2915, -2915, -2915,   689, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, 46430,   662,   592,
   31590, -2915, -2915, -2915, -2915, 46430, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, 39847, -2915,   530, 52184, 52595,
   43964, -2915,   498, -2915, 51362,   175, 33254, -2915, 53006, -2915,
   -2915,   630, -2915, -2915, -2915, -2915, -2915,   592, -2915, 34492,
   29910, 45197,   848, -2915, -2915, -2915, -2915,   -93, 11260,   718,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915,   772, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
      28, -2915,   423,    41, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, 55465,   978, -2915, -2915, -2915,   747, -2915,   779, -2915,
   -2915, -2915,  1122, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915,    68, -2915, -2915, -2915, -2915,  1201, 34078, -2915,
   -2915, 55465, -2915,   813, 39023, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, 37787, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915,    92, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, 51362, 51362, -2915, -2915,
   -2915,   912, -2915,   903, -2915, -2915, -2915, -2915, -2915,   864,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   14613, -2915, -2915, -2915,   923, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915,  1045, -2915,   168,  1129, -2915, -2915,
   34492,  1187,  1187,  1393, 55465, -2915, -2915, -2915, 43142, 51362,
   51362, 51362, 43142, 51362, 45197, 51362, 28227, 51362, 51362, 45197,
   45197, 51362, 51362, 51362, 51362, -2915,  1411,    60, -2915, -2915,
   -2915,   878, -2915,  1204, -2915,  1215,  2692,   662, -2915, -2915,
   46430, 43142, 51362,  1074,  1156, 51362, -2915, 51362,   994, 51362,
    1104,  1054,  1249, 51362, 51362, 51362, -2915, -2915, 51362, -2915,
   51362, -2915, 51362,   -38,  1216,  1447,  1370,    45, -2915, 39023,
   39023, -2915, -2915, -2915,  1009, -2915, 45197, 43142, 51362,  1178,
   -2915, 51362, -2915, 43142, 51362, -2915,  1550, -2915, 51362, 51362,
   -2915, -2915, -2915, 51362, 51362, -2915, 51362, -2915,  1416, 51362,
   -2915,   309, -2915, -2915,   772,   843, -2915,   173,   -37,   231,
   -2915, -2915,   -23,   -18,   160,   843,   866, 46841, 51362,  1399,
   -2915, -2915, -2915, -2915, 39023,  1338, -2915, -2915, -2915,  1371,
     411, -2915, -2915, 46430, -2915, -2915, -2915, -2915, -2915, 46430,
     901, -2915, -2915,   662,  1471, 51362, -2915, 51362, -2915, 46430,
   51362, -2915, -2915, -2915,  1588,  1283,  1469,  1274, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915,  1427,  1454,   -11,   662,  1421,
   -2915, -2915,  1468, 18081,  -121, 39023, 32008, 48074, 54650,   127,
   38199, 53417,  1374,    60, -2915,   666, -2915,  1714,  1407,  1599,
    1274,    60, 46430, 55862, -2915, -2915, -2915, 25713,  1494,  1418,
   -2915,  1659,  1420,  1438,   509,  1441, -2915, -2915, 46430,  1806,
    1806,  1785,  1806,   633,   643, -2915, -2915, -2915,  1475, -2915,
    1486,  1501, -2915,   174,  1674, -2915, -2915, -2915, -2915,  1595,
    1596,  1598,  1600, -2915,  1604,  1036, -2915, -2915, -2915,  1810,
   -2915, -2915, -2915, -2915,  1475, -2915, -2915, -2915, -2915, -2915,
    1893,  1878, 38199, 38199,  1594,   -29, 32840, -2915,  1545,   912,
   -2915, 17146, 14613, -2915, 23179,  1099, -2915, -2915, -2915,    93,
   -2915, -2915, -2915,  1767, -2915, -2915,  1763, 51362, -2915,  1621,
   51362, -2915, -2915, 53828, -2915, -2915,  1187,  1475,   878,  1558,
    1559, -2915,  1560,  1561, -2915,  1566,   935,  1565,  1011,   152,
    1708,   -49,   436,  1570,   118,   835,  1688, 51362, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,  1573, -2915,
   -2915,  1572,   514,   940,  1668,   -94,  1331,   949,  1725,   -14,
     696,  1575,  1774,   -41, -2915,    53, -2915, 21079, 29086, -2915,
     878, 46430, 43142,  1580, -2915, -2915, -2915, -2915, 43142, -2915,
    1736,  1635, 51362, -2915, -2915, -2915, 51362, -2915, -2915,  1783,
   51362, -2915,  1616,  1583,  1904, 41908, 51362,  1619,  1933, -2915,
   -2915,  1624, -2915, -2915, 51362,  1583,   817,  1624,  1932,  1934,
    1733,  1063,    51,  1624, 46430, 46430, 46430,  1800, 51362, 51362,
   43142, 51362, -2915, -2915, -2915,   869,  1657,  1617, -2915, 41908,
   -2915,  1570,  1608, -2915, 51362,  1618,  1608,  1765, -2915,  1769,
    1608,   662,    34, -2915, -2915, -2915, -2915,     6,   406, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, 51362,  1399,  1399,   121,
   -2915, -2915,    79, -2915, 45608, 51362, 46019,    15,   -25, -2915,
   51362, -2915,   309,  1869,  1869,  1869, -2915, -2915, -2915,  1828,
   51362,  1883, 45608, 51362, -2915, 54239,  1636,  1334,  1198,   879,
   -2915, 21079,  1638,   344,   344,  1644,  1645, -2915, -2915,  1646,
    1649, -2915,   711,   711,  1788,  1651,  1655, -2915,   960,  1661,
   -2915,  1309,   983,  1662,  1663,  1666,  1275,   344, 21079, -2915,
    1670,  1010,  1673,  1680,  1681,  1325,  1682, -2915,  1383,  1683,
    1170,  1172,  1685,  1686, -2915,  1651, -2915,    33, -2915, -2915,
   -2915, -2915, 21079, 21079, -2915, 18515, -2915,   662, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915,    35, -2915,  1014,  8183,
   -2915, -2915, -2915, 21079, -2915, -2915,   -31, -2915,   878,  1687,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915,  1019, -2915, -2915,
    1144,  1152, -2915, -2915,   105,  1153,  1207,  1207,   277, 38611,
   38611, -2915, -2915,   716,  1608,   223, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, 36963,  1980, -2915,  1664,    53, 30322, 30322,
   -2915, -2915,  1852, -2915,  1667,  1871, 46430, -2915, 26964, -2915,
   -2915,   772, -2915, -2915, -2915,  1694, -2915,   -93,   -93, 21079,
     -93,   552, 18941, 21079,  1917,   479,  1475,  1702,  1064, -2915,
   42731, 55061, 55061,  1909, -2915, -2915,   614,   382,  1798,  1879,
     417,  1306, -2915, -2915, -2915,  1695, -2915,  1985,  1475,  1078,
   39023,  1749, 38199, -2915, -2915,  2103, -2915,  2103, -2915, -2915,
   -2915, -2915,  1705,   866, -2915,  1545, -2915, 17220,  1229, -2915,
   -2915, 14613, -2915, -2915, -2915, -2915,  2131, -2915,  1704, -2915,
   -2915, 55465,  1713, 51362, -2915,  1717,  1718, -2915, 55862,   878,
   29498,  1778,  1786, 34492,  1721,  1799,  1809, 54650, -2915, -2915,
   -2915,   616,   534,    50, -2915,  1811,  1868,  1841, -2915,  1906,
     776, -2915, -2915, -2915, -2915,  1448, 16337,   921, -2915, -2915,
    1813,  1796,  1816,  1817,  1825,  1750, -2915,  1820,  1803, 40672,
   28656, 54650,  7083, -2915,  1827,  1830,  1872,   573,   228,  2081,
    1923,  1839,  1837,  1200,  1843,    71,   466,  1775, -2915,  1860,
    1861, 45197,  1870,  1890,  1873, 54650,  7083, -2915, -2915,   857,
   -2915, -2915,    60, -2915,  3254, -2915, -2915, -2915, -2915, -2915,
    1805, 41908,  1570,  1036, 51362,  1807,   724,  1957, 51362,  2017,
    1962,    18, 34492, -2915,  1812, -2915,  1851,  1851,  1851,  1814,
    1814,  1815, -2915, -2915,  1275,  1851,  1819, -2915, 42320, -2915,
     821,   871, -2915,  2161,    89, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915,   452, -2915,  1565, -2915, -2915, -2915,
    2172,  1489, -2915, 41908,  7083,  2105, -2915,  1862,  7083, 51362,
     764, 51362,  2011, -2915, -2915,   107,  1829, -2915,  7083, -2915,
     -68,  1831, 38199,  2074,  1977, -2915,  1570,  2177, -2915,  1057,
   -2915,  1935, -2915, 24029,  1866, 29498,  2181,   241, 51362,  1881,
   40672, 46430, 46430,   241, -2915, -2915, 51362, -2915, -2915,  1399,
    1045, 51362, -2915, -2915, -2915, -2915, -2915, -2915,  1399, -2915,
   -2915,  2259,  1832, -2915,   105,   866,  1835, -2915,  1856, 51362,
   43142, 51362, 51362, 46430, 51362,  1912,  1667,   245, -2915,  1889,
    1850, 26547, -2915, -2915,   130, 46430,  2010, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, 44375,  2096,   -15, 51362, -2915,
   21079, 19367, -2915, -2915, -2915,  1853,  9659,  1888, 21079, -2915,
   -2915, 21079, 21079,   866,   866,   866, -2915, -2915, -2915, -2915,
    1287,   866, -2915, 21079, 21079,   866,   866,  1851,  1851, -2915,
    9259, 21079,   866, -2915, 28656, 21079, 21505, 15902, 21079,  1924,
    1926,   866, -2915,   866, -2915, 21079, 17655, -2915,   878,  2219,
    2219,  1058,  3930,  1855, -2915,  1956,   866, -2915,   866,   577,
   41908, 21079, 34492,  1930,   113, 21079,  1865,  1136, -2915, 21079,
     583, -2915,  1867, 21079,  1937,   122, 21079, 21079, 21079, 21079,
   21079, 21079, 21079, 21079, 21079, -2915, 21931,   129,  1615, 35727,
   18081,  2113, -2915,  1035, 15467, 39023, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915,   866,  1863, -2915,  1884, -2915, -2915, -2915,
   -2915, -2915,  1980, -2915, -2915,  1936, -2915, -2915, -2915,  1154,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,  1877, -2915,
   -2915, -2915, -2915, -2915, -2915, 55465,  1875, 51362,    -5, -2915,
   -2915, 44786, 51362, -2915, -2915,  2088, -2915, -2915,  1880, -2915,
    4952,  2088,  2026,  2040,  2040, -2915,   -55,  9659,  2087,  9659,
   -2915, -2915, -2915, -2915,  1085, -2915, -2915,  1475,  1898, 13817,
   -2915, 14221, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915,  1036,  1887,  2299,  1112,
   -2915, -2915, 38199, -2915, -2915, 32840, -2915,  1911, -2915, -2915,
   -2915, 39023,  1213,  1898, 14613, -2915, 14613,  1898, -2915,  1899,
   -2915, 51362, 51362, -2915, 34492, 51362, 51362, -2915,  2211,  1908,
   51362,  2109,  2115,  1914, -2915, -2915, 51362, -2915,  2076, 21079,
    2077, 51362, 51362,  2078,   788,  2065, -2915, -2915, -2915, -2915,
   -2915,  2064, -2915, -2915, -2915,   819, -2915, 35316, 40260, -2915,
   -2915,   146,  1565, -2915,   218,   242,   274,  1988,  1989,  2029,
   51362, 51362, 51362, 51362, 51362,    -1, 51362, 51362,  1921,  1931,
    1927, -2915, -2915, 51362,  2132, -2915, -2915,  2089,    32, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915,  1965, 51362, -2915,   866,
    2091, 51362,  1991, -2915, 51362, 51362, 51362,  1036, -2915,  2279,
    1036,  1036,   603,  1624,  1624, -2915, -2915, -2915, 51362, 51362,
   51362,  2027, 47252, 51362, 51362, 47663, 51362, 51362, 51362,    94,
     790, 51362, 51362,  2080, 51362, 51362, 51362, -2915, -2915,    42,
    2083, -2915, -2915, -2915, -2915, 21079, 29498,  2301,  2167,  2173,
    2012, 40672,   335, 51362, 51362,  2174,   335, -2915, -2915, -2915,
     812,   895, -2915,  1990, 21079,    96, 41908,  1986, 24863, -2915,
    2039, -2915,  2049,   866, -2915,  1721,   107,  2180,  2002,  2002,
    2002,  2002,  2002,  1489, -2915, -2915, -2915,  2239, 46430, -2915,
   -2915,   844, 44375, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915,  1965, -2915, -2915, -2915,  2141,  2139, 51362, -2915, -2915,
     573, 46430, 43553,    58, 51362,  2345,  2236,   662, 46430,  2073,
   -2915,  2234,  2235,  2253, -2915, 23612, 48485,  2000,   793, -2915,
   48485, 48896, -2915,   878, 21079, -2915,  2008, 41908, -2915, -2915,
   51362,  2009,   241,   241, -2915, -2915, -2915, -2915, -2915, -2915,
   39023,   864, -2915, -2915,   864, -2915,   864,  2439,  1608,  2006,
   -2915,  1570,  1608,  1608,  1667,  1608, 49307,  2370,  2254, -2915,
   19801,   933, -2915, -2915,    74, -2915,   429,   312,  2197, -2915,
   -2915, -2915,  2168,  2013, 49307,  2350,   241, -2915,  9659,   934,
     381,   626, -2915,   866, 21079,    83, -2915,  8552,   948,  8641,
    1062,  2021,  2023,  1069, -2915, -2915, -2915, -2915, -2915, -2915,
    2025,  2271, -2915, -2915,  2030,  1092,  1117,  2034,  2035, -2915,
   -2915,  3971,  1197,  2036,  8890,  2042, 21505,  1333, -2915, 21505,
    2047, -2915,  1205,  8090,  2033,  2048,  2057,  2079,  2050,  2052,
    8938, 20227, 21079, 20227, 20227,  9148,  2033,  2053, -2915, -2915,
   21079, 51362,  2054,  2055, -2915, -2915,  9259, -2915,  2084, -2915,
   21505, 21505,  2451, 18515, -2915, -2915,  2294, -2915,   931, -2915,
    2058, -2915, -2915,  3294,   125, 21079,  1865, 21079,  2123, 28656,
    4569, 21079,  4314,  3347,  3347,   208,   208,    67,    67,    67,
     947,  1615, -2915, -2915, -2915,  2061,  1434,  1457, 46430,  3886,
    4147, -2915, -2915, -2915, 24029,  1866, 21079, 21079,  2062, -2915,
    1222, -2915, -2915,   265,  2439,   866,    60,   866,   577, 30747,
    1898, -2915,  2067, -2915, 51362,  1866,   753, -2915, -2915,  1224,
   21079, -2915, -2915,  1738, -2915, 51362,  2010,  2010, 21079, 21079,
   18941, -2915, -2915,  2075, -2915, -2915, -2915, -2915, -2915,  2068,
   -2915, -2915, -2915, 51362, -2915, -2915,  2474,  2071,  2069,  2094,
    2082,   970, -2915, -2915, -2915, -2915, -2915,  2267, -2915, 21079,
     480,  2090,  2092, 51362,   241, -2915,  9659, -2915, -2915, -2915,
    2297, -2915, -2915,  2242, -2915, -2915, 34904, 41908, -2915, 41908,
   -2915,   520, 51362, 51362, 51362, -2915,  1608, -2915, -2915, -2915,
   -2915, -2915,  1024, -2915, 41908,  2216, 41084,  1608,   843,  1965,
   51362, 51362, -2915,  1608, -2915,  1965,  1608,  1965, -2915, -2915,
   -2915, -2915, -2915,  1036, -2915, -2915, -2915, -2915, -2915,  1036,
    1036, -2915, 41908,    11, -2915, -2915, -2915, -2915, -2915,   241,
     241, -2915, -2915, -2915, -2915,  2152, -2915, -2915, -2915,  2127,
   -2915, -2915, -2915,  2163, -2915, -2915, -2915, -2915, -2915, -2915,
    7821,  2099, 41908,   335,   335, 51362,  2100, -2915, -2915, -2915,
    2311,  2312,   335, -2915, -2915, -2915,   143, -2915, -2915, 34492,
   27798,  4524,  2108, -2915,  2106,   866,  1898, 25296,  1502, -2915,
   -2915, -2915,    63,  2288,  2111,  2262,  2002, -2915,    27,   203,
   49718, 50129, 50540, -2915,  2043,  2169,  1831,   764,  2229,   800,
   -2915, 46430,   107,  1236, -2915, 41908,  2119, 46430,  2120,  2116,
   -2915, -2915, -2915, -2915,  1247, -2915, 41908, -2915,  2275,  2276,
   -2915,  1250, -2915, -2915,   -93, 51362,  2190,  2171,   662, 38199,
   41496,  1790, -2915, -2915,  2277, -2915, -2915, 26130, 22783,   793,
    2128, 51362, -2915,  2130, 24029,  2335,  2274, -2915, 24029,  2274,
     982,  2274, 24029,  2338, -2915, 27381, -2915,  2135,  1035,  9659,
     241,  2138,   241,   241, -2915, -2915,   996, -2915, -2915,  2129,
   -2915,  2155, -2915, -2915, 43142, -2915, 51362,   367, -2915, -2915,
    2289, -2915, -2915,  9659,  1270, -2915,   471, 51362,   878, -2915,
   -2915, -2915, -2915,  2404,  2407, -2915, 45608,    46, 51362, -2915,
   -2915, 21079, -2915, -2915,  2151,  2149,  9486, 21079, -2915,  2414,
   41908, -2915, 51362, -2915, -2915, -2915, -2915,   866, -2915, 21079,
   -2915, -2915, -2915, -2915, -2915, 21079, -2915,   866, -2915, 21079,
    2397, -2915,  2516, 41908, 21505,   495,  1673, 22357, 21505, 21505,
   21505, 21505, 21505, 21505, 21505, 21505, 21505, -2915,   201, -2915,
   -2915, 21079, 21079,  2405,  2397, -2915, -2915, -2915,  1148,  1148,
   41908,  2156,  2033,  2157,  2162, 21079, -2915,   878,  5215, -2915,
    2485,   662, 21079,  1320,  1530, 21079,  1292, 21079, -2915, -2915,
    2165, -2915, -2915, 41908, 21079, 21505, 21505,  3553, -2915,  5504,
   21079,  2166,  6330, 18515, -2915,   592,   592,   592,   592, -2915,
   46430, 46430,  2000,  2402,  1299,  1332, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915,  2164, -2915,  2182, -2915, -2915,    53,  2175,
   -2915, -2915,  2474,  2183,   998, -2915, -2915, 20653, -2915, -2915,
    2184, -2915, -2915,  1608, -2915, -2915, -2915, -2915, -2915, 14613,
   -2915, -2915,  2191, -2915, -2915, -2915, -2915, -2915,  2237,  2238,
    2283,  2002,  5943, -2915, 51362, 51362,  1337, -2915, -2915,  2389,
   -2915, -2915, -2915,  2240, -2915, -2915, -2915,  2246,  2251, -2915,
    2256, -2915, -2915, -2915, -2915,  1608,  1608, -2915, -2915, -2915,
   -2915, -2915, -2915,    82,   441, 41908, -2915, -2915, -2915, 51362,
   51362, -2915,  2382,  2192, -2915, -2915,  2401,  2408,   335,   335,
   -2915, -2915,  1624,  2471, -2915,  2184,  1306, -2915, -2915, -2915,
   -2915,   539,   866,  1189,  2203, -2915,  1360, 25296, 25296, 25296,
   25296, 25296,  1898,   577, 46430,   866, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,  2205,
   51362, 21505, -2915,   722,   549, -2915,  2406, 46430,  2250, -2915,
   -2915, -2915, 41908,  2554,   751, 46430,  2456,  2355, -2915, 51362,
   -2915, 43553,   787,  2432, 43553, -2915, 51362,  2557,  2558,   -93,
   -2915, 51362, -2915,  2255,  1565,   662, 51362,  2215, -2915,  2210,
   -2915,  2110, -2915,  1583, -2915, -2915,   750, -2915, -2915, 48485,
    2218, 51362,   793, 24029, -2915, -2915,  2337, -2915, 24029,  2424,
   -2915, -2915, 24029, 51362,  2222, 51362, -2915,   241, -2915, -2915,
    1057,   864,   265, -2915, -2915,  2462, 49307, -2915, -2915, -2915,
   19801,  2224, -2915, -2915, -2915, -2915,  2470, -2915, -2915,  9659,
   -2915, -2915, 21079,  9659, -2915,  2226,  2228,  2230,  9659,  6032,
    2232,  9659,  2405, -2915,  1442,  2478,  2384,  2241,   201,  1442,
     147,   147,   192,   192,    61,    61,    61,  2516,  9659,  9659,
   -2915, -2915, -2915, -2915,  2245, -2915, -2915, -2915,  2033, -2915,
   -2915,   577,  2219, 21505, 21505,  1987, -2915,   300, 41908, -2915,
    1366,  1987,  1609,  2285, 21079, 21079,  9492,   141, 21079,  6288,
   46430, 46430, 46430, 46430, -2915, -2915,  2564,  2472, -2915, -2915,
     265,  1266,   662, -2915,  2243, 51362, -2915,  9659, 28656, -2915,
   51362, -2915, 51362, 51362, 51362,   866, -2915,  1377,  1378,  2250,
   -2915, -2915, 51362, 51362, 51362,  2043,  2394,  2395,   866, 51362,
    2286, -2915, -2915,   335,  2446,   335,   335, -2915, -2915, -2915,
     662, -2915,   920,  2528, -2915,  2468,   140,  2257,  2491,  2492,
   -2915, -2915,  1431,  1431, -2915, -2915, -2915, -2915, -2915,  2496,
   -2915, 21079,   928,  1442, -2915, -2915, -2915, -2915,  2250,  1831,
    2476, -2915,  2302,   -93,   -65,  2523,  2519,   107, -2915,  2263,
    2545,  2547, -2915,  2266,  1300, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, 51362,  2473,  1721,  2514, -2915, 24446,   662,  1790,
   -2915, -2915, -2915, -2915, -2915,  2346, -2915, 51362,  1389, -2915,
   21079,  2295, -2915, -2915, 24029,  2337,  1391, 51362,  1403, 41908,
   -2915,  2532, -2915, -2915,  2431, -2915, -2915, 19801, 49307,  9659,
   -2915, -2915, -2915, -2915, -2915, -2915, 21505,  2296, 21505, -2915,
   -2915,  1168,  1168,  1405, -2915, 41908, 21505, 21505,  1987,  1987,
   21079,  1987, -2915, -2915, -2915, -2915, -2915, 21079, 21079, -2915,
   -2915,  1306, -2915, -2915, -2915, -2915,   577, 21079, -2915,  2287,
   -2915, -2915, -2915, -2915, -2915,  2410,  2250, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, 21079, -2915, -2915,   335, -2915,
   -2915,  2341, -2915, -2915, -2915, -2915, -2915, -2915, -2915, 43142,
    2639, 46430,   539,  6841,  2461, -2915, -2915,  2493,  2381, 51362,
   -2915, 43553, -2915,   373,  2438, -2915,  1300, -2915, -2915, 46430,
    2467,  2475,  2469, -2915,   662, -2915, 51362, 21079,  1415, -2915,
   50951, 16748, -2915, -2915, 46430,  1440, -2915,  9659, 51362, -2915,
   -2915, -2915,  1459, -2915,   -93, -2915,  1472,    46,   508, 21505,
     179, -2915, -2915,  1168,  1168,  1987,  2033,  9659, -2915, -2915,
   -2915,  4136,  2318, -2915, 46430, -2915,  9659, -2915, -2915, -2915,
    1933,  1933,   637, -2915,  1933, -2915,  1933, -2915,  2639,  2663,
   -2915, -2915,  2571, -2915,   565,  2477, 51362,  2668, -2915, -2915,
   -2915, 51362,  2469,  1477, -2915, -2915,  2635,  2398, -2915, -2915,
    7282,  2398, 24446, 51362, -2915, -2915, -2915,  1866, -2915,  1480,
   -2915, -2915, -2915,   416, -2915, 21079, -2915,  1831,   662,  1965,
    2484, 51362,   662,  1965, -2915, -2915,  2597, -2915, -2915,   151,
   -2915,  2479,  2480, -2915,   544,  2333,  2398, -2915,    70, 51362,
   -2915, 50951,  1866, -2915, -2915,  2606, -2915, -2915, -2915,  2493,
   -2915, -2915, 51362,  2328, -2915, -2915,  2442,   427,   427,  2383,
   -2915,  2617, -2915,   866,   866, 41908,  2334, -2915, 32421, -2915,
    2445, -2915,  2447, -2915, -2915, -2915,   580,  2477,  2328,  2601,
   -2915,  2702, -2915,   442, -2915, -2915, 43142, 28656, -2915,   544,
    1482, -2915, -2915, -2915, -2915, -2915, -2915, -2915,   734,   539,
    2481, -2915, -2915, -2915,  1570,   -88, -2915, -2915, 32421, -2915,
     576, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, 43142,
   -2915, -2915, 40672, -2915, -2915,  1439, -2915, -2915,  1505,  1438,
    2347,  2344, -2915,   576, 32421,  2482, -2915,  1497, -2915, -2915
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -2915, -2915, -2915, -2915, -2915,  2556, -2915, -1006, -1185, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915,   796, -2915, -2915,  -765,   999,  1498, -2915, -2915,   569,
   -2915, -2915, -2915, -1243, -2915,   144, -2915, -2915, -2915, -2915,
   -2915, -2915,   859, -2915,   917,   461, -1488, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -1451,  -136,
      14, -2915,    12,   881,    95, -2915,  -181, -2915, -2915, -2915,
   -1079,   533, -2314, -2191,    13,  -464,  -490,  -444,  -442,  -468,
   -2915,  -325,  -398, -2450, -2185, -2915, -2915, -2915, -2915, -2915,
      29, -1436, -2915,  1288, -2915, -2915, -2915, -2915,  -196, -2915,
   -2915, -2915,  -428, -2915, -2915, -2915, -1427, -2915,   845, -2312,
   -2915, -2915, -2915,  -535,  -508, -2915, -2914,  -144,  -142, -2915,
   -2915, -2915, -2915, -2915, -1069, -2915,   445, -2915, -2915, -2915,
    -483,  1313,  -525, -2915, -2915, -2915, -2915,  -702, -1453, -2915,
   -2915,  2653,   313, -2915, -2915, -1595, -1426, -2915,  -175,   728,
    1689, -1116, -1999,     0, -2915, -2915, -1570, -2915, -2915, -2915,
     766, -1424, -2915, -2915, -2915,  -385, -2909, -2915, -2915, -1082,
   -2915,   553,   984, -2915,   986, -2915, -1737,    39,  -885, -2326,
    -173, -2915, -2915, -2915, -2915, -2915, -1432, -2915, -1535, -1387,
   -2915,  -354, -2915, -2915, -2915,   748, -2915,   -87, -2915, -2915,
   -2915, -2915, -2915, -2915,  -471,  -505, -2915, -2915, -2915,   155,
   -2915, -2915, -2915,   905, -1021,  -846,  1948, -1421, -2915, -2915,
   -2915,   867, -1877, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -1789, -2915, -2915, -2915,  1102,  2699,  -708, -2915, -2915, -2915,
   -2915, -2915, -2915,   -13, -2915, -2915,   359,    16, -2915, -2915,
   -2915, -2915,  -313,    17,  1729,   810,    30,   -61,   -67,  -222,
     297,   473, -2915, -2915,  -197,  1031, -2915, -2915, -2915, -2915,
     631,  1548, -2915,   624,  -301, -2915, -2915,  1551, -2915,  1103,
    1120,   665, -1946,   847, -1920,   410,  -507,  -162,  -165, -2915,
   -2145, -2454,    97,  1410, -1645, -2039,  1386, -2915,  1432,  2552,
   -2915, -2915, -1008, -2915, -2915,  2767,  3599, -2915, -2915,  4111,
    6132, -2915, -1049,   295,  6594,   609, -1174, -1468,  9629,   862,
     457, -1307, -2915, -2915,  -723, -2915, 10204,   499, -2915, -1076,
   -2915,   -20, -2915, -1553, -2915, -2915, -2915, -2915, -2915, -1543,
   -2406,  -844,   710, -2915, -2915,   792, -2915, -2915, -2915,  -727,
    -935, -1636,   715, -2915,  1191, -2915,   -33,  -341,   673,  -148,
      65,  3098,  -840,    87,  -697,  6896,  -672, -1962, -1261,  1801,
   -2915,  -716, -2915,    -2,    19, -2915, -2915,  4851,  -103,  -774,
   -1659, -2915,   -70, -2915,  -915,  -951, -2234,  -568, -2915, -2915,
     -58, -2915,  1939, -2915,  1096,  1547, -2915, -2915,  1101,  -831,
    -143, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,  1582,   117,
   -2915,   -59, -2915, -2915,  2832, -2915,  2587,   -52, -2915,  2217,
     -47, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
    -812,  1133, -2915,  1915, -2915, -2915, -2915,  -741, -2915, -2915,
   -2915,  1762,  -153, -2915, -2915, -2915, -1009,  1003,  1951,  -843,
    -998,  1105, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
     865, -2915, -2915,   704,   868, -2915, -2915,    91, -2915, -2915,
       4,    99, -2915,  1660, -2915, -2915, -2915,   286, -2915, -2915,
   -2915,  -538,  7839,    64,   -26,   -46,   562, -2915,   305,  7255,
   -1308,  -671,   -40,  1622,  5279,  9400,    57,     5,  -132,   334,
     169, -2915, -2915,  2572,  1119,   885,  -890,  6314,  1363,  2325,
    3718,  -722,  -839,  1967,  -537, -1329, -2915,  2937
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1795
static const short yytable[] =
{
      69,   812,   999,  1029,   782,   913,  1013,   310,   773,  1148,
    2060,   782,   578,   309,  1049,  2041,  1516,  1006,   360,  1009,
     902,    70,   324,  1527,  1453,   876,  1422,   326,  1365,  1547,
    1334,  1039,  1810,  1881,  1446,  1073,  1974,  1654,  1085,   986,
    1724,  1129,   854,  1131,   693,  1133,  1606,  1287,  1008,  1010,
     696,  1134,   782,  1975,  2213,  1078,   908,  1102,  2092,  2038,
    2613,   304,  1294,  1379,   692,  2044,   693,   872,  1092,  1994,
     735,  1107,   696,  1115,   872,  1514,   872,  1111,  2472,  2449,
    2646,  1518,  2676,  1077,  1995,  2507,   692,  1528,   778,  1369,
     305,   307,  2773,  1996,  1997,   700,  1998,  1112,  1863,  1999,
    2777,  1116,  2399,  2400,  2401,  2402,  1128,  1123,   847,  1120,
    2464,  2466,  1142,  2036,  2226,  2804,   961,   700,  1559,  1110,
    2288,  2290,  1823,  1276,  1619,  1620,  1285,  1404,  1575,  1560,
    1705,  1343,  1344,  2243,  1362,  1359,  1366,  2543,   351,  1569,
    1570,   351,  1339,  1670,  1526,  1271,  1554,   699,  1639,  1663,
    -990,  2427,  1665,   975,   351,  1014,   830,  2880,  1554,  1032,
     912,   310,  1362,  1268,  -821,  1673,  1040,   309,  2256,   699,
    1589,  2357,  2260,   693,   995,  1627,   351,  -824,   830,   696,
    2703,  1967,  2746,  1163,   711,  2085,   712,  1594,  2382,  2204,
    1274,  1081, -1687,   692,   359,  1087,   983,  1916,  1699,  1408,
    1347,  2154,  1323,   736,  1093,  1839, -1712, -1143,  3202,  2074,
    2159, -1726,  1958, -1143,  2192,   304,  2011,  2347,   939,  2011,
    2193,   957,  2159,  2543,   700,   742, -1159,  -821,  3341,   286,
    3290,  2238, -1159,  1391,  2310,  1139,  2032,  1837, -1586,  3291,
    -824,  1100,  3226,   354,   305,   307,   354,   205,  1702,  1450,
   -1247,  -917,  2499,  1266,  2517,  2543,   871,  2123,  1130,   354,
     881,  1938,   747,   871,   844,   871,  1453,  2002,  2543,   925,
    1784,  1049,   852,  2618,   926,   940,   699,  2543,  2619,  2620,
    2621,   354,  1277,   351,  1670,  1442,  1042,  1409,  1712,  2016,
    2622,  2623,  2624,  1042,  2625,  2626,  2627,  2961,  1412,   952,
    2628,  2629,  2630,  1094,  1267,  -281,  1673,   906,  2075,   953,
   -1588,  3277,  1834,  1703,   926,  1418,  1132,  1654,  1069,  1785,
    2383,  1392,  1283,  1458,   941,  1840,  1713,   942,  1095,  1986,
    2003,  1443,   715,  1989, -1585,  1730,  1460,  1299,  1465,     3,
     882,  1722,  1462,  2009,  1414,   227,  1097,  1829,  2736,  1917,
    3342,   746,  3294,  1554,  1916,   205,  2704,  2946,  2751,  1830,
    1555,  2373,  2311,   716,  1096,  1345, -1584,  1043,  1451,  3036,
    2012,  3038,  1555,  3131,  1043,  3292,  1670,  1457,  2545,  1101,
    1948,  2348,  1515,   286,  1536,   351,  1841,   585,   354, -1748,
    2239,  1383,  1959,   984,   607,  2705,  1533,   703,  1673,  1324,
     979,  1786, -1641,  2716, -1687,  3338,   943,   703,   353,  2291,
    2545,   353,  1549,  1590,  1700,  2963,  2366,   713, -1712,  1831,
    1595,  2500,   351, -1726,   353,   351,   715,  2358,  1619,  1620,
    1548,  1943,  2545,   607,  1146,  1358,  1639,  2498,  2546,  1410,
    2224,    49,   703,   745,   576,  1926,   353,  -990,  1587,    52,
    -990,   607,   703,  1591,  2019,   703,  3055,   716,  1377,   703,
   -1689,  -995,  2076,   703,  2428,  2429,  1607,  -821,   842,  -821,
    2546,  -990,  1627,  1666, -1143,   951,  2160,  2077,   944,  1556,
    -824,  2194,  -824,  2937,  2938,   703,   962,  2094,  2595,  1472,
     354,  2836,  2543, -1159,   960,  2556,   576,  1393,  1452,  2004,
     703,  1694,  1366,   861,  1774,   842,   945,    49,  2812,   880,
     576,  1804,  2816,  2577,  2361,    52,  2821,    53,  1359,  2745,
    1849,  1049,   576,  1331,   963,  1968,  1799,   354,  1717,  1718,
     354, -1795,  1968,   873,  2089,  2090,  1832,  2721,   576,  3300,
     873,    49,   873,  3278,   576,  2098,  2100,  1396,  1949,  1863,
    2681,  2047,  2682,   353,  2474,  2475,  2637,  2115,  2116,  1015,
    1561,  2046,  2547,  2264,  1034,  1036,   151,  1555,  -201,  2631,
    2049,  2132,  2134, -1795, -1795,  2642,  2551,  2552,  2553,  2554,
    2555,  2556, -1586,  3162,  2543, -1586, -1586,  2644,  2119,  2120,
     576, -1586,   595,  1751,  2547,    52,  1839,  3322,  2509,  1829,
     919, -1748,  1970,   826,  2548,  2549,  2550,  2501,  2551,  2552,
    2553,  2554,  2555,  2556, -1641,  2367,  1833,    49,  3234,  1397,
     576,  1106,  1827,  2553,  2554,  2555,  2556,  1103,  2210,   168,
    2551,  2552,  2553,  2554,  2555,  2556,   957,   782,  1787,  1691,
    1692,  1693,  1694,  2728,  2503,   364,  1398,  2545,   576,  2632,
     920,  2067,  1458,    52, -1588,   353,  1882, -1588, -1588,   940,
    2865,   826,   997, -1588,   693,  1836,  3316,   926,  1125,   703,
     696,  1831, -1689,  1791,   705,  3127,  1792,  1071, -1585,   855,
    1937, -1585, -1585,  1907,   692,  3135,  2174, -1585,    69,  1837,
    1548,   957,   353,  2804,  3301,   353,  2961,  1029,  2972,  2973,
    2974,  2975,  2976,  2802,  2504,  3208,  2986,  2546,   941,    70,
   -1584,  1971,  1457, -1584, -1584,   700,  2947,   921,  2032, -1584,
    1788,  1908,  3323,  1135,  1312,  1124,   576,  1970,  3209,  1689,
    1690,  1691,  1692,  1693,  1694,  1829,   151,   706,   834, -1795,
    3283,  2735,   957,  2064,  1614,   856,   205,  1830,   707,    49,
    2640,  2326,   576,  3302,  3097,  1793,   872,  2962,  -995,   872,
    3247,  -995,  1950,  1399,  1783,  1313,  1955,   699,  2714,  2715,
    2866,  3262,  3303,  2835,   351,  1400,  2502,  2720,   351,  2867,
     596,   904,  -995,  1151,   940,  1145,  2677,  1909,  1832,  1401,
     943,  2175,  2601,   749,  2935,  2176,  1402,  2948,   221,   168,
    2949,  1963,  1928,  3126,  3317,   878,  3289,  1831,  1164,  1838,
     922,   205,  2836,   830,  2963,   830,  1035,   830,  2512,  1279,
    1281,  1784,  1311,   830,   830,   708,  2511,  2177,  1910,  2987,
    1911,  2547,  -853,   941,  3016,  3284,  1971,  1072,   199,  1403,
    1912,  2548,  2549,  2550,   227,  2551,  2552,  2553,  2554,  2555,
    2556,  2707,  2708,   185,  2045,  3267,  1146,   607,  2327,  1421,
    2328,  1365,  1972,  1295,  2061,  3248,  1762,  3029,  1833,  2841,
    1785,  1428,  3033,  1929,  1719,   715,  3035,  1429,  1312,   354,
    2984,  2247,  2058,   354,  2062,  2063,   715,  2065,  -853,  3026,
    1973,   840,   578,   578,   151,   857,   858,  2032,  1913,  1763,
    1991,   703,   703,  3285,   126,   127,   716,  2329,  2330,   227,
    3021,  3185,  3240,  1430,  2833,   943,   205,   716,   843,  1313,
    1388,  1029,  1369,  3269,  1832,  1720,  1431,  1914,   877,  -853,
    1147,  2985,  2178,  2455,   709,  1846,  1149,  2551,  2552,  2553,
    2554,  2555,  2556,  1332,  1764,   871,  1155,  2281,   871,   758,
    3241,  1990,  1786,  2683,  1432,  1952,  1994,   168,   848,  1433,
    1824,  2850,  1434,  1992,  1333,   786,  3000,   351,   221,    69,
      69,  1995,    69,  3022,  1538,   754,  1458,  1332,  1863,  2485,
    1996,  1997,  2826,  1998,  2828,  2829,  1999,  1972,  2456,  1149,
      70,    70,  2321,    70,  1297,  2324,  2325,  2862,  1333,   760,
    3001,  2157,   693,   913,  1833,  1305,  1847,   901,   696,  1125,
    3329,   185,  2457,  1953,   227,   758,  1539,  1444,  2282,  2847,
     199,  2881,   692,  1670,  1007,   607,  1011,  2458,   585,   717,
     703,  1031,   585,   703,   118,  2459,   703,   703,  1007,   585,
    1288,  1445,   758,   910,   353,  1673,   748,  2759,   353,  3167,
    3273,  1553,   122,   700,  3312,  2229,  2460,   703,   810,  -561,
     607,   310,  1007,  2513,   585,   760,  2572,  1567,   585,  1089,
     703,  2514,   354,   703,   205,  1007,    49,   585,  3113,   576,
     310,  3298,  3265,  2761,   703,   703,  1593,  2586,  3159,  2254,
    3023,  1540,   760,   703,  3312,   820,   607,  2977,  2468,   703,
    1612,  1538,  1388,   703,   703,   699,  1160,   879,   703,   703,
    1289,   703,   351,   821,  1007,  1563,  2588,  3295,  1629,   766,
    3312,   767,  2461,  2957,  2958,  -975,   221,   932,  -975,  3114,
    2614,  2615,   703,   703,  1412,  2349,  1541,  2408,  1459,   703,
    1136,  1094,  3024,  2830,  1564,  1565,  1523,  2032,  1657,  1625,
     933,  2032,  1390,  1457,  2266,  2032,  1413,  1664,  1661,   916,
     703,   934,   703,  1150,  1524,  1156,  2775,  3207,  1669,  2374,
    2375,  1939,  3330,   917,  2296,  1084,  1423,  2456,  2647,  1940,
    1414,  1529,  1530,  1531,  1447,   766,  2307,   767,   929,  1047,
     703,   607,   703,  1048,   987,  1282,  2800,   988,   867,  1941,
    2313,  2457,  1096,  3124,  2316,  2462,  1542,   900,  2765,   989,
     990,  2589,   766,  1281,   767,  2590,  2818,   354,  1540,  -290,
    1867, -1387,   873,   768,  2459,   873,    49,  1649,  1650,   576,
     991,  1149,   771,   992,  1381,  -829,  2766,   353,   935,  1424,
    1754,  1754,  1868,  1754,  2543,  2767,     9,  -829,  1439,  1149,
    1806,  2370,  2371,  2262,   955,   872,  1382,  2265,  2285,  1651,
     576,  1425,  3084,  1541,  2286,    52,  1869,   585,   585,  2668,
    1440,  1352,   578,   826,  2279,  2978,  1933,  1649,  1650,  1614,
     696,   576,  1801,   576,  1332,  -829,  1332,  1332,    52,   872,
     936,  2669,   703,  -995,   692,   703,  -995,  2571,   703,  2573,
    2574,  2166,  2295,  -829,  2297,  1333,  1049,  1333,  1333,  1653,
    1385,  2461,  2591,   872,  1047,  2670,  2768,  -995,  1048,  1813,
    2592,  2167,  1007,  2687,   926,   700,  1916,   966,  2477,  1794,
    2929,  1923,  1386,  1542,  2378,   199,  2318,   693,  1817,  3040,
    2379,  3014,  1919,   696,  -829,  2688,  1924,   937,  1927,   969,
    1795,   830,  -829,   993,   985,    69,  1387,   692,  3107,    69,
    3109,  3110,  1079,  2351,  1080,   690,  2354,   703,  2356,   913,
    2638,   703,  2496,  2510,  -969,   703,    70,  -969,  2497,  2511,
      70,   703,   353,  1746,   351,   351,   351,  2521,   700,  1007,
    2846,  1637,  1638,  2511,  2882,  2883,  2543, -1002,  1631,  2545,
   -1002,  3238,  3239,  1007,  1535,  3242,   703,  3243,  2699,  2543,
    2893,  2168,  1428,   996,  2700,  2701,  2169,  1388,  1429,  1007,
    2170, -1002,   225,  3060,  -972,   226,   693,  -972,    49,  2730,
    2082,   576,   696, -1586,  1047,   351, -1586,  2104,  1048,   979,
     699,   703,   351,  2925,   871,  -829,   692,   351,  1642,  1041,
     703,   842,  1668,   576,  1430,   703,  1029, -1592,    52,  2546,
      53,  1332,  1281,  2021,  2022,  1604,  1331,  1431,   703,  1018,
    1609,  1047,  1082, -1253,  1083,  1048,  2026,   700,   871,  1019,
    1020,  1021,  1333,  1022,  1023,  1024,  1025,  1026,  1027,   354,
     354,   354,  1708,  1051,  2105,  1432,  1709,  1302,  2489,  2888,
    1433,  2523,   871,  1434, -1250,  1776,  2032,  2511,  2526,  1777,
    2651,  2032,  1075,  3187,  2527,  2032,  2489,  2171,  2543,  1800,
    2101,  2102,  2103,  1777,   912,  2172,  2241,   797,  2114,   699,
    1777,  2531,  2117,  2118,  2693,  1076,   351,  2511,  2653,  2122,
     354,  3089,  1360,  2106,  1361,  2544,  2107,   354,  2138,  3198,
    2139,  2545,   354,  2250,  1649,  1650,  2532,  1777, -1588,  1396,
    2112, -1588,  2511,  2152,  2545,  2153, -1585, -1584,    49, -1585,
   -1584,   576,  1086,  2053,   607,   607,  1649,  1650,  1649,  1650,
    1098,  2662, -1593,  2547, -1005,  1099, -1005, -1005,  1282, -1005,
   -1590, -1589,  2217,  1742,  1742,  2968,  2969,  2551,  2552,  2553,
    2554,  2555,  2556,  1750,  1755,  1757,  2543,  1761,  1651,  2164,
    1653,  2546,  -960,  2695,  2696,  -960,  1109,  1453,  3180,  1977,
    2894,   830,   830,   830,  2546,  2108,   693,    49,  1139,   830,
     576,  1397,   696,   830,   830,    52,  2536,    53,  2042,  2043,
     830,   354,  2537,  1331,  2560,   607,   692,   585,  1143,   830,
    2511,   830,  1435,  1121,   353,   353,   353,  2651,  1398,  2218,
    1144,  2617,  1978,  2648,   830,  1152,   830,  2511,   957,  1548,
    1149,  1114,  1809,  2545,  1361,  2778,  1436,   700,   703,  3232,
      49,  2779,  2079,   576,  1504,  2543,  2785,  1157,    52,  2790,
      53,  1670,  2786,  2220,  1158,  2791,  3081,  2109,   926,  3066,
     225,    49,  1159,   226,   576,   353,  3140,  3141,  1963,  2839,
    3150,  2053,   353,  1673,  1160,  2840,  2959,   353,  1504,  1161,
    2245,   873,  2245,  -958,  2684,  1031,  -958,  2032,    52,   699,
      53,  2896,   578,  2546,  3020,  2547,   351,  2511,  2918,  -961,
    1979,  1458,  -961,  1162,  2511,  2548,  2549,  2550,  2547,  2551,
    2552,  2553,  2554,  2555,  2556,   873,  1464,  1166,  2548,  2549,
    2550,  2545,  2551,  2552,  2553,  2554,  2555,  2556,  2061,  1007,
    1611,  2919,   227,  1007,  1848,  1399,  2939,  2511,   693,   873,
    1756,  1756,  2791,  1756,   696,  1286,  2202,  1400,  1980,  2737,
    2738,  2739,  2740,  2741,  1332,  1165,  2314,  -959,   692,  2971,
    -959,  1401,  2605,   913,  2606,  3064,   353,  3351,  1402,   351,
    1332,  3065,    69,  1290,    69,  1333,  3095,  3096,  1291,  1726,
    2856,  2546,  2791,  2791,   585,  2607,   703,  2608,  3156,   700,
    3161,  1333,  1292,    70,  1548,    70,  2779,  1282,  2228,  1298,
    2545,   354,  3163,   351,  3171,   351,  1677,  1678,  2779,  1299,
    3065,  1403,  1300,   703,  3221,  2409,  1981,  2547,  1982,  1302,
    3222,  1007,  2739,  2740,  2741,  2390,   703,  2548,  2549,  2550,
    2394,  2551,  2552,  2553,  2554,  2555,  2556,  1303,  3352,  3228,
    3353,   699,  1304,  2438,   703,  1548,   703,   703,   351,   703,
    2377,  1306,  1483,  1681,  1309,  1729,  2073,   830,  3230,  1325,
    2546,  1396,  1601,  1602,  2779,  1332,  1317,   957,  1332,  1332,
     842,  3231,  1727,  2087,   354,  3150,  3257,  2840,  2834,  3266,
    3325,  3327,  1595,  2654,  2655,  1548,  1333,  3328,  1321,  1333,
    1333,  2737,  2738,  2739,  2740,  2741,  3359,  2656,  2657,  2742,
    2848,   913,  3328,  1322,  1302,  2547,  -821,  2436,   354,  1031,
     354,  1308,  2817,  1310,  2820,  2548,  2549,  2550,  2448,  2551,
    2552,  2553,  2554,  2555,  2556,  1018,   830,  1346,  1348,  1326,
    1327,   830,  1328,  1397,  1329,  1019,  1020,  1021,  1330,  1022,
    1023,  1024,  1025,  1026,  1027,  1337,  1340,  1342,  1345,  1504,
    2515,  1353,  1370,   354,  1371,  1373,  1380, -1592, -1593, -1590,
    1398,  3176,  2610,  2611, -1589,  1383,   353,  1395,  1406,  1417,
     703,  1419,  1420,  1426,  1441,  1504,  1448,  1449,  1461,  1463,
    1468,  1472,  1470,  1474,  2547,  1511,  1512,  2439,  1504,  2650,
    1388,  1519,  1521,  -154,  2548,  2549,  2550,  1532,  2551,  2552,
    2553,  2554,  2555,  2556,  1689,  1690,  1691,  1692,  1693,  1694,
    1018,  1543,  2223,  1548,  1551,  1545,  1550,   703,  1552,  1599,
    1019,  1020,  1021,  1670,  1022,  1023,  1024,  1025,  1026,  1027,
    1504,  1603,  1605,  1725,  1610,  2406,  1618,   225,    49,   353,
     226,   576,  1621,  1622,  1623,  1673,    52,  1624,    53,   227,
    1674,   830,  1628,  1630,  1331,  1744,  1661,  1504,  2416,  1633,
    1634,  1635,  1745,  2128,  1636,  2437,  1311,   585,  1641,  2164,
    1352,  1644,  1595,   353,  2639,   353,   703,  1399,  1645,  1646,
    1647,  1648,  1504,  1655,  1656,  1704,   585,   703,  2604,  1400,
     585,   607,  1752,  1775,  1782,   703,  1789,  2026,  1790,  1798,
    1796,   703,  1802,  1401,  1362,  1805,   703,   585,  1811,  1812,
    1402,  1814,  1821,  1018,  1504, -1530,  1816,  1843,   353,  1504,
    1822,  1824,  2759,  1019,  1020,  1021,  2438,  1022,  1023,  1024,
    1025,  1026,  1027,  1825,  2760,   585,   703,   585,   703,   703,
    1844,   703,  2303,  1826,  1396,  1842,  1845,  1870,   703,  1871,
    1872,  1873,  1874,  1403,  1876,  1875,  2803,  1877,  2761,  1676,
    2762,  1904,   703,  2438,  1905,  1029,   703,  1916,  1906,   585,
     703,   703,  1920,  2053,  1921,   830,  1922,  1332,  1677,  1678,
    1930,  1396,  1925,  2332,  2333,   703,  1935,   703,   703,  2340,
     703,   703,   703,   703,  1931,  1932,   585,   703,  1333,   585,
     703,   585,  3340,  1946,  1934,  1951,  1954,  1936,  1956,  1957,
    1964,  1614,  1625,  1631,  1966,  1976,  1397,  1642,  1007,  1007,
     756,  2763,  2001,  2017,  1988,  1681,  2018,  2007,  2489,  2014,
    2020,  2034,  2024,  2391,  2037,  2040,  2050,  2051,  1682,  1504,
    2056,  2057,  2734,  1398,  2390,  2609,  2066,  2069,  2070,  2080,
    2084,  2093,  2094,  1397,  2808,  1670,  2136,   842,  2137,  3213,
    2150,  2151,  2158,  2163,   782,  2179,   830,  2204,  2214,  2215,
    2439,  2181,  2415,  2216,  2221,   920,  2234,  2426,  2764,  2433,
    1398,  1332,  2219,  2765,  2235,  2230,  2248,  1332,  1332,  2752,
    3155,  2453,  2240,   693,  1968,  2453,  2467,  2249,  2261,   696,
    3155,  2267,  1333,  2253,  2271,  2303,  2269,  2439,  1333,  1333,
    2272,  2766,  2273,   692,  2283,   703,  2275,  2277,  2280,  2284,
    2767,  2543,  2292,  2293,  3091,  2294,  2304,   310,  2799,  1281,
    2305,   585,  2306,  2792,  3098,  3067,  3100,  2308,  1332,    49,
     310,   913,  2317,   830,   700,   830,  2807,  2026,  2322,   585,
    2309,  2026,  2315,  2335,  2362,  2026,  2747,  2359,  2363,  1333,
    2440,  2353,  1685,  2061,  2364,  2372,  2365,   593,  2910,  2911,
    2912,  2913,  1400,  2392,   608,  2380,  1689,  1690,  1691,  1692,
    1693,  1694,  2385,  2393,  2857,  2396,  1401,  2397,  2405,   310,
    2411,  2768,  2412,  1402,  2860,  2842,   699,  1399,  2434,  2435,
    2445,  2446,  2447,   351,  3219,  2454,  3188,  2470,  2473,  1400,
    1712,  2484,  2490,   608,  2085,  2505,  2579,  2506,  1146,  2508,
    2524,  3229,  2525,  1401,  2528,  2529,  1504,  1504,  2566,  2530,
    1402,   608,   608,  2533,  2534,  2538,  1403,  2455,  2511,   608,
    2489,  2541,  3189,   593,  1031,  1493,  2559,  2565,  2587,  2568,
    2567,  2569,  2576,  2580,  2581,  2582,  2593,  2600,  2776,  2603,
    2659,  2616,  3190,   593,  2782,   593,  2643,  1495,  2663,  2661,
    2665,  2891,  2671,  1403,  1361,  2690,  2545,  3191,  2678,  1546,
     608,  3264,  2679,  2667,  1742,   830,  2709,  1670,  2674,  1750,
    2675,  3192,  2456,  2666,  1929,   830,  1661,  2710,  2712,  2717,
     703,  1495,  2718,  2719,  2732,  2733,  3193,  1792,   354,  1673,
    2743,  2744,  2774,  2772,  1674,  1504,  2457,  2781,   607,  2783,
    1504,  2784,  2787,  2788,  2795,  2796,  2806,  2809,  2811,  2813,
    2814,  2458,  2822,  2825,  2831,  1504,  2546,  2827,  2433,  2459,
    2832,  2838,  2844,  2128,  1029,  2845,  2128,  1611,  2851,  2854,
    3324,  2562,  2543,  1149,  2561,  2885,  2886,   585,   703,   703,
    2460,  2887,  1665,  2898,  2916,  2907,  2930,  2921,  2924,  2920,
    2940,  2932,  2933,  2953,  2922,   703,   703,  2128,  2128,  2934,
    2942,  3194,  2928,  3350,  2941,  2943,  3030,  2585,  3195,  2967,
    2944,  2954,  2955,  2960,  2390,  2390,  2390,  2390,  2390,  2956,
    2970,  2988,  2980,  2981,  2990,  2995,  1504,  2993,  2997,  3003,
    3008,  3009,  3012,  3017,  3196,  3018,  3027,    69,  3034, -1795,
    3037,  3044,  3047,  1676,  3048,  3050,  2461,  3051,  3057,  3052,
    2303,  3054,  3056,  3077,  3101,  3102,  3078,  3108,    70,  3058,
    3105,  3087,  1677,  1678,  3059,  3115,  2962,  3119,  3120,   608,
    3121,  3128,  2391,  3132,  3118, -1795,  3129,  2914,  2915,  3134,
    2547,  3137,  3136,  3138,  3139,   703,   703,   703,  3146,  3144,
    2548,  2549,  2550,   353,  2551,  2552,  2553,  2554,  2555,  2556,
    3154,  3164,   310,  3165,  1794,  3015,  3183,  3184,  3010,  1681,
     830,  3031,  3199,  3158,  3169,   830,   830,   830,   830,   830,
     703,  2987,  1682,   830,  1282,  1795,  2026,  3204,  3206,  2462,
    3211,  2026,   703,  2453,  3214,  2026,  2810,  3236,  3216,  3245,
    3246,  3254,  3215,  3258,  3272,  3259,  3249,  3276,  3279,  3281,
    2824,  3288,  3296,  2791,  3299,  3278,  1052,  3277,  3314,  3309,
    3315,  3320,  3321,  3355,   915,  3354,  2407,  1743,  2641,  2350,
    1820,   585,  2300,  3339,  2706,  2999,  3005,  2945,  3341,  2331,
   -1795,  3125,  2073,  2673,  3011,  3297,  1053,  3319,  3282,  3280,
    3305,  3212,  1495,   585,  3256,  3006,  3143,  2010,  1054,  3357,
    3344,  2395,  3117,  3116,  2724,  1055,  3326,  1007,  1987,  1880,
    3358,  2979,  3094,   850,  2491,  1588,  3045,  3263,  1495,  2680,
    3019,  1056,  2289,  2287,  3244,  3103,  3153,  3332,  3356,  1293,
    2403,  1495,  3086,  2227,  2989,   813,  2843,  1566,  2476,  1057,
    3041,  2649,  2994,  1772,  2658,  1770,  1685,  2237,  2225,  2612,
    2819,  1947,  2450,  3160,  1965,  2890,  2998,   608,  3063,  2729,
    1689,  1690,  1691,  1692,  1693,  1694,  2598,  2518,  1058,  2596,
    3112,  2203,  3088,  1495,  3268,  1504,  1504,  2645,  1504,  3166,
    1534,  2252,  1807,  2251,  1781,  3046,   321,  1059,  1355,   927,
    2242,   978,  1378,  1504,  1598,  1504,  1349,  2255,  2636,  2053,
    1495,  2482,  3042,  1985,  3080,  2483,   310,  1711,  2923,   949,
    1060,  3043,  3130,   830,   970,  2259,  2478,  2052,  1357,    76,
    3082,  1504,  1778,     0,     0,  1495,   830,     0,  3152,     0,
       0,     0,     0,     0,     0,  1820,     0,     0,     0,     0,
    1880,     0,     0,     0,     0,     0,     0,  2026,     0,     0,
       0,  1504,     0,     0,     0,     0,     0,  1495,     0,  2433,
    2433,     0,  1495,  1061,     0,     0,     0,     0,  2542,  1504,
       0,  2558,     0,     0,     0,     0,     0,  3073,  3074,  3075,
    3076,  2128,     0,   797,  2128,  2128,  2128,  2128,  2128,  2128,
    2128,  2128,  2128,  2128,   703,   703,     0,     0,     0,     0,
       0,     0,  2583,  2584,  1504,     0,  1062,     0,  1063,     0,
       0,     0,     0,  1064,     0,  1504,     0,     0,     0,     0,
       0,     0,  2391,  2391,  2391,  2391,  2391,     0,     0,  1504,
       0,     0,  2128,  2128,     0,     0,     0,     0,  1065,     0,
       0,     0,     0,     0,     0,   703,     0,     0,     0,     0,
       0,  1066,   593,     0,  3218,     0,  1067,     0,     0,  3178,
    2155,     0,     0,     0,  2415,     0,  2332,     0,     0,  2332,
       0,  3007,     0,     0,  1068,     0,  2433,   310,     0,     0,
    3179,  2303,  1495,  2807,   608,   608,     0,     0,  3349,     0,
       0,     0,     0,     0,  2453,     0,   703,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2415,  1504,
    3039,     0,     0,     0,     0,     0,   608,     0,     0,     0,
     593,   585,   593,     0,   593,     0,     0,     0,     0,     0,
     593,   593,  1504,     0,     0,     0,     0,     0,     0,   608,
       0,     0,     0,     0,     0,     0,     0,     0,  3270,     0,
       0,     0,  3274,     0,     0,     0,     0,     0,   593,  1504,
    3306,  3307,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1504,   593,     0,     0,     0,     0,  3201,     0,
     608,   608,     0,     0,   593,   593,     0,     0,  2128,     0,
       0,     0,     0,     0,     0,     0,  1149,     0,     0,     0,
    2223,     0,     0,  1031,     0,  3090,   741,   585,   703,   703,
       0,  3227,     0,     0,     0,     0,     0,   585,   703,   585,
       0,   310,     0,     0,  3104,     0,     0,     0,     0,     0,
       0,     0,     0,  3348,     0,     0,     0,     0,     0,     0,
     593,  3237,     0,     0,     0,   741,     0,     0,     0,     0,
       0,   830,   830,   741,     0,     0,   310,   593,   593,  1495,
    1495,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1504,     0,     0,   703,   741,   741,
       0,     0,  3151,     0,     0,     0,     0,     0,     0,     0,
    1670,     0,   703,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3039,     0,  1671,     0,     0,     0,     0,     0,
    2128,  2128,  1673,   585,     0,     0,  1820,  1674,     0,     0,
       0,  1880,     0,     0,     0,     0,     0,     0,     0,     0,
    1670,     0,     0,     0,     0,     0,  2384,     0,  1495,     0,
       0,  1504,     0,  1495,     0,     0,     0,     0,     0,     0,
       0,     0,  1673,     0,     0,     0,     0,  1674,  1495,     0,
       0,     0,     0,     0,     0,     0,  2864,     0,     0,  2868,
    2869,  2870,  2871,  2872,  2873,  2874,  2875,  2876,  2877,     0,
       0,     0,     0,  1670,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2303,     0,  2332,     0,     0,     0,
       0,     0,     0,     0,     0,  1673,   593,  2471,     0,     0,
    1674,  1007,     0,     0,     0,  1007,  1007,  2902,  2903,     0,
       0,     0,  1675,   703,  1574,     0,  1676,  1578,     0,  1495,
    2594,     0,     0,     0,     0,     0,     0,   608,     0,     0,
       0,     0,     0,     0,     0,  1677,  1678,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1679,     0,
       0,     0, -1795,     0,     0,     0,  1676,  1504,     0,     0,
       0,   703,     0,  2128,     0,  2128,   703,     0,     0,     0,
       0,     0,     0,  2128,  2128,  1677,  1678,  3151,  1007,  1680,
       0,     0,  1681,     0,     0,     0,     0,     0, -1795,     0,
       0,     0,     0,     0,     0,  1682,  2433,  1683,     0,     0,
       0,     0,   593,     0,     0,  1675,     0,     0,     0,  1676,
       0,     0,     0,   593,   703,     0,  1007,     0,     0,     0,
       0,     0,  1681,     0,     0,     0,     0,  2433,  1677,  1678,
       0,     0,     0,     0,     0,  1682,     0,     0,     0,  1707,
       0,  1679,     0,  3313,   608,   608,     0,     0,     0,     0,
       0,     0,     0,  1684,     0,     0,     0,     0,   593,     0,
       0,   593,  1031,   593,   593,     0,     0,     0,     0,     0,
       0,     0,     0,  2983,     0,  1681,  2128,  1496,     0,  1670,
       0,     0,     0,  3313,     0,     0,     0,     0,  1682,     0,
       0,     0,     0, -1795,     0,     0,     0,     0,  1504,     0,
       0,  1673,     0,     0,     0,     0,  1674,     0,     0,  3313,
       0,  1496,     0,     0,     0,   608,     0,   593,     0,  1685,
       0,     0,     0,     0,  1504,     0,     0,     0,   593,  1686,
    1687,  1688,     0,  1689,  1690,  1691,  1692,  1693,  1694,     0,
       0,  1944,     0,     0,     0,     0,  1684,     0,     0,     0,
    1945,     0,     0,     0,     0,     0,     0,     0,     0,  1685,
       0,     0,     0,     0,  2689,     0,  2692,     0,  1495,  1495,
       0,  1495,     0,  1689,  1690,  1691,  1692,  1693,  1694,  2904,
       0,     0,     0,     0,     0,     0,  1495,     0,  1495,     0,
       0,     0,  2702,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3061,  3062,     0,     0,     0,
       0, -1795,  1685,     0,  1495,  1676,     0,     0,     0,     0,
       0,     0,  2713, -1795, -1795,     0,  1689,  1690,  1691,  1692,
    1693,  1694,     0,     0,  1677,  1678,     0,     0,   593,     0,
       0,     0,   355,     0,  1495,   355,     0, -1795,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   609,   355,     0,
       0,     0,  1495,     0,     0,     0,   998,     0,     0,     0,
     998,     0,   741,     0,     0,  2780,     0,   741,   741,     0,
     355,  1681,     0,     0,     0,     0,  2702,     0,     0,     0,
       0,     0,  1498,     0,  1682,     0,   609,  1495,   741,   998,
       0,     0,     0,     0,     0,     0,     0,   593,  1495,     0,
       0,     0,     0,     0,   609,     0,     0,     0,     0,     0,
       0,     0,  1495,     0,     0,     0,  1498,     0,     0,     0,
       0,     0,     0,     0,   741,   998,     0,     0,     0,     0,
       0,   998,     0,     0,  1504,     0,     0,     0,     0,  1707,
    2055,     0, -1795,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   874,  3168,     0,
    3170,     0,     0,     0,   874,     0,   874,     0,  3173,  3174,
    2855,     0,  1496,     0,     0,     0,     0,   355,     0,     0,
       0,   741,     0,     0,     0,     0,     0,   741,   593,   593,
     593,  1504,  1495,  2863,     0,   593,   593,   741,  1496,     0,
     593,   593,     0,     0,     0,     0,     0,   593,  1685,     0,
       0,  1496,     0,     0,     0,  1495,   593,     0,   593,     0,
    2884,     0,  1689,  1690,  1691,  1692,  1693,  1694,     0,     0,
       0,   593,     0,   593,     0,     0,     0,     0,     0,     0,
     741,     0,  1495,  2899,     0,   741,  1670,     0,     0,     0,
       0,     0,     0,  1496,     0,     0,   741,     0,     0,     0,
    1671,     0, -1792,     0,  1574,  1495,     0,     0,  1673,     0,
    2212,  3233,     0,  1674,     0,     0,     0,     0,  2055,   355,
    1496,     0,     0,     0,     0,     0,     0,  1670,     0,     0,
       0,     0,     0,     0,   593,     0,     0,     0,     0,     0,
       0,  1671,     0, -1792,     0,  1496,     0,     0,     0,  1673,
       0,     0,     0,     0,  1674, -1792,   355,     0,     0,   355,
   -1792,     0,     0,     0,     0, -1792,     0,     0, -1792,     0,
   -1792,     0,     0,     0,     0,     0,     0,  1496,     0,     0,
       0,     0,  1496,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -1792,     0,  2950,     0,     0,     0,     0,
       0,   593,     0,     0,     0,     0,     0,   593,     0,     0,
       0, -1792,     0,     0,     0,     0,   608,  1495,  1675,     0,
       0,     0,  1676,     0,     0,     0,     0,  1498,     0,   741,
     998,     0,     0,     0,     0,     0,   998,     0,     0,     0,
       0,  1677,  1678,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1792,  1498,  1679,     0,     0,     0,   718,  1675,
   -1792,     0,  2992,  1676,     0,     0,  1498,     0,     0,     0,
       0,     0,   741,   741,   741,     0,     0,     0,   998,     0,
       0,     0,  1677,  1678,  1495,  1680,     0,     0,  1681,     0,
       0,     0,  1670,     0,     0,  1679,     0,     0,     0,     0,
       0,  1682,  1496,  1683,   593,     0,  1671,   719,  1498,     0,
       0,     0,   593,     0,  1673,   593,   593,     0,     0,  1674,
       0,     0,   741,   720,     0,     0,  1680,     0,     0,  1681,
       0,     0,   848,     0,     0,  1498,     0,     0,     0,     0,
     741,   721,  1682,     0,  1683,     0,     0,     0,     0,     0,
     609,     0,     0, -1792,     0,     0,     0,   593,     0,  1684,
    1498,   593,     0, -1794,     0,   593,     0,     0,     0,     0,
     722, -1792,     0,   593,     0,     0,   723,     0,   593,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2899,   724,
       0,     0,  1498,     0,     0,     0,     0,  1498,     0,     0,
    1684,     0, -1792,     0, -1794, -1792, -1792, -1792,     0,     0,
    1495,   725,     0,     0,     0,     0, -1794,     0,     0,     0,
       0, -1794,   593,     0,  1675,  1685, -1794,     0,  1676, -1794,
       0, -1794,     0,     0,     0,  1686,  1687,  1688,     0,  1689,
    1690,  1691,  1692,  1693,  1694,     0,     0,  1677,  1678,  2149,
       0,     0,     0,     0, -1794,   608,  1574,     0,     0,  2481,
    1679,  1578,     0,     0,     0,   726,  1685,     0,     0,     0,
    1670,     0, -1794,     0,   741,     0,  1686,  1687,  1688,     0,
    1689,  1690,  1691,  1692,  1693,  1694,     0,     0,     0,  1496,
    1496,  1680,  1673,     0,  1681,     0,  2535,  1674,   593,     0,
       0,     0,     0,     0,   727,     0,     0,  1682,   355,  1683,
     728,     0,   355, -1794,     0,   729,  1005,  1498,     0,     0,
    1005, -1794,     0,     0,     0,     0,     0,     0,     0,  2780,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     730,   731,     0,     0,     0,     0,     0,     0,     0,  1005,
       0,  1495,     0,   732,     0,  3172,     0,     0,   733,     0,
       0,     0,     0,     0,     0,  1684,     0,   734,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1495,  1496,     0,
       0,     0,  1104,  1496,     0,  1005,     0,     0,     0,     0,
       0,  1005,     0,   848,     0,     0,     0,     0,  1496,     0,
       0,     0,  1675,     0,     0,     0,  1676,     0,     0,     0,
       0,     0,     0,     0, -1794,     0,     0,     0,     0,   741,
    2055,     0,   593,     0,   593,  1677,  1678,     0,     0,     0,
       0,  1685, -1794,     0,     0,     0,     0,     0,  1679,     0,
       0,  1686,  1687,  1688,     0,  1689,  1690,  1691,  1692,  1693,
    1694,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3235,     0, -1794,     0,     0, -1794, -1794, -1794,  1496,
       0,     0,  1681,     0,     0,     0,     0,     0,     0,     0,
    1670,  1265,     0,     0,   609,  1682,   874,     0,     0,   874,
       0,     0,     0,     0,  1671,     0,     0,     0,     0,     0,
       0,   355,  1673,     0,  1498,  1498,     0,  1674,     0,     0,
       0,     0,     0,   593,     0,     0,     0,     0,     0,     0,
       0,  2033,     0,     0,     0,  1670,     0,     0,   593,   741,
     741,     0,     0,     0,   593,   593,     0,     0,     0,  1671,
       0,     0,     0,  1684,     0,     0,     0,  1673,     0,     0,
       0,     0,  1674,     0,  1499,     0,     0,     0,   998,     0,
       0,   741,     0,     0,     0,     0,     0,     0,   593,   593,
       0,     0,     0,   741,     0,  3308,     0,   593,     0,     0,
       0,     0,     0,     0,     0,   593,     0,     0,  1499,     0,
     593,     0,   593,  1498,     0,     0,     0,  1495,  1498,     0,
       0,     0,     0,   593,   593,     0,     0,     0,     0,  1685,
       0,     0,  1675,  1498,     0,     0,  1676,     0,     0,  1686,
    1687,  1688,     0,  1689,  1690,  1691,  1692,  1693,  1694,     0,
       0,     0,  1880,     0,     0,  1677,  1678,     0,     0,     0,
       0,     0,     0,   593,   593,  1265,   355,     0,  1679,     0,
    1005,     0,   608,     0,  1495,     0,  1005,  1675,     0,     0,
       0,  1676,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1509,     0,     0,     0,   741,     0,  1680,
    1677,  1678,  1681,     0,  1498,     0,     0,     0,     0,     0,
       0,     0,     0,  1679,     0,  1682,     0,  1683,  1005,     0,
       0,     0,     0,     0,     0,     0,     0,  1509,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1496,  1496,
       0,  1496,     0,     0,  1680,     0,     0,  1681,     0,   741,
       0,     0,   593,    71,     0,     0,  1496,     0,  1496,     0,
    1682,     0,   593,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1684,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1496,     0,     0,     0,     0,  1265,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   593,     0,     0,     0,
       0,     0,     0,     0,  1496,     0,  1265,     0,  1684,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1496,   577,     0,     0,     0,     0,     0,  1685,
    1265,  1265,     0,  1265,     0,     0,     0,     0,     0,  1686,
    1687,  1688,     0,  1689,  1690,  1691,  1692,  1693,  1694,     0,
       0,  1265,     0,  2731,     0,     0,     0,  1496,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1496,  1499,
       0,     0,     0,     0,  1685,     0,     0,   609,   609,     0,
       0,     0,  1496,     0,  1686,  1687,  1688,     0,  1689,  1690,
    1691,  1692,  1693,  1694,  1731,  1499,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1499,     0,
       0,     0,     0,     0,     0,     0,     0,  1265,  1670,   577,
    1265,  1265,     0,     0,     0,     0,     0,     0,   355,   355,
     355,     0,  1671,   593,   593,     0,  2231,     0,     0,     0,
    1673,     0,     0,  1498,  1498,  1674,  1498,   593,   609,     0,
    1499,     0,   593,   593,   593,   593,   593,     0,     0,     0,
     593,  1498,  1496,  1498,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   741,  1499,     0,   355,
       0,     0,     0,     0,     0,  1496,   355,     0,  1509,  1498,
       0,   355,     0,     0,     0,   874,     0,     0,     0,   741,
       0,     0,  1499,     0,     0,  2232,   741,     0,     0,     0,
     593,     0,  1496,  2033,  1866,     0,     0,     0,     0,  1498,
       0,     0,     0,     0,     0,     0,     0,  1509,     0,   874,
       0,     0,     0,     0,  1499,  1496,     0,  1498,     0,  1499,
       0,     0,     0,     0,     0,     0,  2481,     0,     0,     0,
    1675,     0,     0,   874,  1676,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1509,
       0,     0,  1498,  1677,  1678,     0,  1501,     0,     0,     0,
     355,     0,     0,  1498,     0,     0,  1679,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1509,  1498,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1501,     0,     0,     0,     0,     0,     0,  1680,     0,     0,
    1681,  1509,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1682,     0,  1683,  2055,   593,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1496,     0,     0,
     593,  1005,     0,  1509,     0,     0,     0,     0,  1509,  1499,
       0,     0,     0,   593,     0,     0,     0,     0,   593,     0,
     593,   593,     0,     0,     0,   593,     0,  1498,     0,     0,
       0,  1670,     0,     0,     0,     0,   741,     0,  1005,     0,
       0,  1684,  2033,     0,     0,  1671,     0,     0,     0,     0,
    1498,     0,     0,  1673,     0,     0,     0,     0,  1674,     0,
       0,     0,     0,     0,  1496,     0,     0,     0,  1265,  1265,
       0,     0,     0,     0,     0,     0,  1265,  1498,     0,  1265,
    1265,     0,     0,   593,     0,     0,  2233,     0,  2113,     0,
       0,  1265,  1265,     0,     0,     0,     0,     0,     0,  1265,
    1498,     0,     0,  1265,  1265,  1265,  1265,  1685,     0,   698,
       0,     0,     0,  1265,  1265,     0,     0,  1686,  1687,  1688,
       0,  1689,  1690,  1691,  1692,  1693,  1694,     0,  1509,  1265,
     355,   698,     0,  1265,     0,     0,     0,  1265,     0,     0,
       0,  1265,     0,     0,  1265,  1265,  1265,  1265,  1265,  1265,
    1265,  1265,  1265,     0,  1265,     0,     0,     0,  1265,     0,
       0,     0,  1265,  1675,     0,     0,     0,  1676,     0,     0,
       0,     0,     0,   593,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1677,  1678,     0,     0,
    1496,     0,     0,     0,     0,     0,  1499,  1499,     0,  1679,
       0,     0,     0,   355,     0,     0,     0,     0,     0,   593,
       0,     0,  1498,     0,     0,     0,     0,     0,   870,     0,
       0,     0,     0,     0,     0,   870,     0,   870,     0,     0,
    1680,  1501,     0,  1681,     0,     0,     0,   355,   698,   355,
       0,     0,     0,     0,     0,     0,  1682,     0,  1683,   741,
       0,     0,     0,     0,     0,   741,     0,  1501,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1501,     0,     0,     0,     0,     0,     0,     0,     0,  1498,
       0,    71,   355,     0,     0,  1499,     0,     0,     0,     0,
    1499,     0,  2033,     0,     0,     0,  2033,  1265,     0,     0,
    2033,     0,     0,   593,  1684,  1499,     0,   593,     0,     0,
       0,     0,  1501,     0,     0,  1866,  1509,     0,     0,     0,
    1670,     0,   998,     0,     0,     0,     0,     0,     0,     0,
       0,  1496,     0,     0,     0,     0,     0,     0,   577,  1501,
       0,     0,  1673,     0,   741,     0,     0,  1674,   593,   593,
       0,     0,     0,   593,     0,     0,     0,  1496,     0,     0,
       0,     0,     0,     0,  1501,     0,     0,     0,     0,     0,
    1685,     0,     0,     0,     0,     0,  1499,     0,     0,     0,
    1686,  1687,  1688,     0,  1689,  1690,  1691,  1692,  1693,  1694,
       0,     0,     0,   593,  2889,     0,  1501,     0,     0,     0,
       0,  1501,     0,  1265,  1509,  1498,     0,     0,     0,  1509,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   593,
    2905,     0,  1265,     0,  1509,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   577,     0,     0,     0,   741,   741,
       0,     0, -1795,     0,     0,     0,  1676,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   577,
       0,     0,     0,     0,     0,  1677,  1678,     0,     0,     0,
     577,   577,     0,  1005,     0,     0,     0,     0, -1795,     0,
       0,     0,  1265,     0,     0,  1509,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1501,  1681,     0,     0,     0,   787,     0,  1265,     0,
       0,     0,     0,     0,     0,  1682,     0,   788,     0,     0,
       0,     0,     0,     0,     0,     0,  1498,     0,     0,     0,
       0,     0,  1265,   577,   577,     0,   789,     0,     0,     0,
       0,     0,    71,    71,     0,    71,     0,     0,     0,     0,
    1363,     0,  1498,     0,     0,   790,     0,  1496,     0,     0,
       0,     0,   741,     0,  1265,     0,     0,  1265,     0,     0,
       0,   791,     0, -1795,     0,     0,     0,     0,     0,  1265,
    1265,  1265,  1265,     0,     0,   741,     0,     0,  1265,   792,
       0,     0,     0,   741,     0,     0,     0,     0,  1265,  1265,
       0,  1265,     0,     0,     0,  1499,  1499,     0,  1499,     0,
       0,     0,     0,  1265,  1496,  1265,     0,     0,   793,  1265,
       0,     0,     0,  1499,   794,  1499,     0,     0,     0,     0,
       0,  2033,     0,     0,     0,     0,  2033,   795,     0,  1685,
    2033,     0,  1005,     0,  1265,  1265,     0,     0,     0,     0,
       0,  1499,     0,  1689,  1690,  1691,  1692,  1693,  1694,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1265,     0,
       0,     0,     0,     0,     0,     0,  1265,  1265,  1265,     0,
       0,  1499,     0,     0,     0,     0,     0,     0,  1501,  1501,
       0,     0,   577,     0,     0,     0,     0,     0,     0,  1499,
       0,     0,     0,     0,     0,     0,     0,  1265,     0,   698,
       0,     0,     0,   796,     0,     0,     0,  1002,     0,     0,
       0,  1002,     0,     0,  1866,  1509,     0,  1509,   741,   741,
     741,   741,     0,   797,  1499,     0,     0,     0,     0,  1670,
       0,     0,  1509,     0,  1509,  1499,     0,     0,     0,     0,
    1002,     0,   798,  1671,     0,     0,   799,     0,   800,  1499,
       0,  1673,     0,   801,     0,     0,  1674,     0,     0,     0,
    1509,     0,  1498,     0,     0,     0,     0,  1501,     0,     0,
       0,     0,  1501,     0,     0,     0,  1002,     0,   802,   803,
       0,     0,  1002,     0,     0,     0,     0,  1501,   577,     0,
    1509,   804,     0,     0,     0,     0,   805,     0,     0,   577,
       0,     0,     0,     0,     0,   806,     0,   355,  1509,     0,
       0,     0,     0,     0,   807,     0,     0,     0,  1670,  1498,
       0,     0,     0,     0,     0,   998,     0,     0,     0,  1499,
       0,     0,  1671,     0,     0,     0,     0,     0,     0,     0,
    1673,     0,  2033,  1509,   577,  1674,     0,  1363,     0,  1363,
    1363,     0,  1499,     0,  1509,     0,     0,     0,  1501,     0,
       0,  1675,     0,     0,     0,  1676,     0,     0,  1509,     0,
       0,     0,  1260,     0,     0,     0,     0,   870,     0,  1499,
     870,     0,  1005,     0,  1677,  1678,  1005,     0,     0,     0,
    1005,     0,     0,     0,     0,     0,     0,  1679,     0,     0,
       0,     0,  1499,   577,     0,     0,     0,     0,     0,     0,
       0,     0,  1005,     0,     0,     0,     0,     0,    71,     0,
       0,     0,    71,     0,     0,     0,     0,   998,  1680,   741,
       0,  1681,     0,     0,     0,     0,     0,     0,     0,  1265,
       0,     0,     0,     0,  1682,  1265,  1683,   741,  1509,     0,
    1675,     0,     0,     0,  1676,     0,     0,  1265,     0,     0,
       0,     0,   741,  1265,     0,     0,     0,  1265,     0,     0,
       0,  1509,  1265,  1677,  1678,  1265,  1265,  1265,  1265,  1265,
    1265,  1265,  1265,  1265,  1265,     0,  1679,     0,     0,  1265,
    1265,     0,   741,     0,     0,     0,     0,     0,  1509,     0,
       0,     0,  1684,  1265,     0,     0,     0,     0,     0,     0,
    1265,     0,     0,  1265,  1499,  1265,     0,  1680,     0,     0,
    1681,  1509,  1265,  1265,  1265,     0,     0,     0,  1265,     0,
     998,  1265,     0,  1682,     0,  1683,  1260,   698,     0,     0,
       0,  1002,     0,     0,     0,     0,     0,  1002,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1507,     0,     0,     0,  1685,     0,
       0,     0,     0,     0,  1670,  1265,     0,     0,  1686,  1687,
    1688,  1499,  1689,  1690,  1691,  1692,  1693,  1694,  1671,  1002,
       0,  1684,  2936,   577,     0,     0,  1673,     0,  1507,     0,
       0,  1674,     0,     0,     0,     0,   592,  1501,  1501,     0,
    1501,     0,     0,     0,   998,     0,  1670,     0,     0,     0,
       0,     0,     0,     0,     0,  1501,     0,  1501,     0,     0,
       0,     0,     0,  1509,     0,     0,     0,     0,  1673,     0,
       0,     0,     0,  1674,     0,     0,     0,   998,     0,     0,
       0,     0,     0,  1501,     0,     0,     0,  1685,     0,     0,
    1260,     0,     0,     0,     0,     0,     0,  1686,  1687,  1688,
       0,  1689,  1690,  1691,  1692,  1693,  1694,     0,     0,     0,
       0,  3053,   833,  1501,     0,     0,     0,  1260,     0,  1265,
       0,   577,     0,     0,     0,     0,     0,     0,     0,     0,
    1509,  1501,   592,     0,   833,     0,  1675,  1499,     0,     0,
    1676,  1260,  1260,     0,  1260,     0,  2908,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1677,
    1678,     0,  1260,     0,     0,     0,  1501,     0,     0,     0,
       0,  1005,  1679,     0,     0,     0,  1005,  1501, -1795,     0,
    1005,     0,  1676,     0,     0,     0,     0,     0,     0,     0,
       0,  1501,     0,     0,     0,     0,     0,     0,  1265,     0,
       0,  1677,  1678,  1680,     0,     0,  1681,     0,     0,     0,
    1265,     0,     0,     0, -1795,     0,     0,     0,     0,  1682,
     577,  1683,     0,     0,     0,     0,     0,     0,  1260,     0,
       0,  1260,  1260,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1681,     0,
       0,  1265,  1265,     0,     0,     0,  1509,     0,     0,     0,
       0,  1682,  1265,  1265,     0,     0,  1265,     0,     0,     0,
       0,  1501,     0,     0,     0,     0,     0,  1684,  1499,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   577,  1501,     0,     0,     0,     0,  1507,
       0,     0,   698,  1363,  1499,    71,   870,    71,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1795,
       0,  1501,     0,     0,     0,  1864,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1507,  1265,
     870,     0,     0,  1685,  1501,     0,     0,     0,     0,     0,
       0,     0,     0,  1686,  1687,  1688,     0,  1689,  1690,  1691,
    1692,  1693,  1694,     0,   870,     0,     0,  3072,     0,     0,
       0,     0,     0,     0,     0,  1005,     0,     0,     0,     0,
    1507,     0,     0,     0,     0,  1685,     0,  2312,  1265,     0,
       0,   698,  1005,     0,     0,     0,     0,  1509,     0,  1689,
    1690,  1691,  1692,  1693,  1694,  1265,     0,  1507,     0,     0,
       0,     0,     0,     0,  1265,     0,  1265,     0,     0,     0,
       0,     0,     0,  1509,  1265,  1265,     0,     0,  1265,     0,
       0,     0,  1507,     0,     0,  1265,  1265,     0,     0,     0,
       0,     0,     0,   577,     0,  1265,     0,   577,     0,     0,
       0,   577,     0,     0,     0,     0,  1501,     0,     0,  2389,
       0,     0,  1002,  1265,  1507,     0,     0,     0,     0,  1507,
       0,     0,     0,     0,     0,     0,     0,  1005,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2410,     0,     0,     0,     0,     0,     0,  1002,
       0,     0,     0,     0,     0,  1265,     0,     0,   577,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1501,  1499,     0,     0,  1265,     0,  1260,
    1260,     0,     0,     0,     0,     0,     0,  1260,     0,     0,
    1260,  1260,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1260,  1260,     0,     0,     0,  1670,     0,     0,
    1260,     0,     0,     0,  1260,  1260,  1260,  1260,     0,     0,
       0,  1671,     0,     0,  1260,  1260,     0,     0,     0,  1673,
    1005,  1499,     0,     0,  1674,     0,     0,     0,     0,  1507,
    1260,   698,     0,  1265,  1260,     0,     0,     0,  1260,     0,
       0,     0,  1260,     0,     0,  1260,  1260,  1260,  1260,  1260,
    1260,  1260,  1260,  1260,     0,  1260,     0,     0,     0,  1260,
       0,     0,     0,  1260,     0,     0,     0,     0,   702,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   704,     0,
       0,     0,     0,  1509,     0,     0,     0,     0,     0,  1501,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1005,     0,     0,     0,     0,     0,
       0,     0,     0,   738,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   781,     0,     0,   785,     0,     0,  1675,
     781,     0,     0,  1676,   829,     0,     0,  1005,     0,     0,
    1509,   592,     0,     0,     0,     0,     0,     0,     0,     0,
    1363,     0,  1677,  1678,     0,     0,   851,     0,     0,     0,
       0,     0,     0,     0,     0,  1679,     0,     0,     0,     0,
       0,   781,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   698,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1680,     0,  1260,  1681,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   833,
       0,   833,  1682,   833,  1683,     0,  1864,  1507,     0,   833,
     833,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1501,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2694,     0,     0,     0,     0,  1883,  2697,   592,  2698,     0,
       0,     0,     0,     0,     0,     0,  1501,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1684,     0,   592,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   592,   592,     0,     0,  1502,     0,     0,
       0,     0,     0,  1884,   577,   577,     0,     0,     0,     0,
    1885,  1886,     0,   577,  1260,  1507,     0,     0,     0,     0,
    1507,  1363,     0,     0,     0,     0,     0,     0,  2389,     0,
       0,  1502,     0,  1260,     0,  1507,     0,     0,     0,  2748,
     577,     0,     0,     0,     0,     0,  1685,  1887,     0,  1336,
     956,     0,     0,     0,     0,     0,  1686,  1687,  1688,     0,
    1689,  1690,  1691,  1692,  1693,  1694,   592,   592,     0,     0,
    3203,     0,     0,     0,     0,     0,     0,     0,     0,   577,
     577,     0,     0,  1336,     0,  1888,     0,     0,     0,  1889,
       0,     0,     0,     0,  1002,     0,     0,     0,     0,     0,
       0,     0,     0,  1260,     0,     0,  1507,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1890,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1260,
       0,  1891,  1892,     0,  1893,  1894,     0,  1895,  1670,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1671,  1260,     0,     0,     0,     0,     0,     0,
    1673,     0,     0,     0,  1896,  1674,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1501,     0,     0,     0,
       0,     0,     0,     0,     0,  1260,     0,     0,  1260,     0,
       0,     0,     0,  1897,     0,     0,     0,     0,     0,     0,
    1260,  1260,  1260,  1260,     0,     0,     0,     0,     0,  1260,
       0,     0,   577,     0,     0,   592,     0,     0,     0,  1260,
    1260,     0,  1260,     0,     0,  1898,     0,  1899,     0,     0,
       0,     0,     0,  1501,  1260,     0,  1260,     0,     0,     0,
    1260,     0,     0,     0,     0,     0,     0,     0,     0,  1900,
       0,     0,     0,     0,     0,     0,  1901,     0,     0,  1902,
       0,     0,     0,  1002,     0,  1260,  1260,     0,     0,     0,
    1675,     0,   964,   965,  1676,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1260,
      71,     0,  1502,  1677,  1678,     0,     0,  1260,  1260,  1260,
       0,     0,     0,     0,     0,     0,  1679,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1502,     0,
       0,   592,     0,     0,     0,     0,     0,     0,  1260,     0,
       0,  1502,   592,     0,     0,     0,     0,  1680,     0,     0,
    1681,     0,     0,     0,     0,  1864,  1507,     0,  1507,   577,
     577,     0,     0,  1682,     0,  1683,     0,     0,     0,     0,
       0,     0,     0,  1507,     0,  1507,     0,     0,  2389,  2389,
    2389,  2389,  2389,  1502,     0,     0,     0,   592,     0,     0,
    1336,     0,  1336,  1336,     0,     0,     0,     0,     0,     0,
       0,  1507,     0,     0,     0,     0,     0,     0,     0,     0,
    1502,  1016,     0,     0,  1033,     0,     0,  1037,  1038,     0,
       0,  1684,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1507,     0,     0,     0,  1502,   577,     0,  1074,     0,
       0,     0,     0,     0,     0,     0,   592,     0,   698,  1507,
       0,  1090,     0,     0,  1091,     0,     0,   833,     0,  1503,
       0,     0,     0,     0,     0,   956,   781,  1502,     0,     0,
       0,     0,  1502,     0,  1108,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1507,  1117,     0,  1685,     0,  1118,
    1119,     0,     0,  1503,     0,  1507,     0,  1686,  1687,  1688,
       0,  1689,  1690,  1691,  1692,  1693,  1694,     0,     0,  1507,
       0,  3261,     0,  1137,  1138,     0,     0,     0,     0,     0,
     956,     0,     0,  1002,     0,     0,     0,  1002,     0,     0,
       0,  1002,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1153,     0,  1154,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1002,     0,     0,     0,     0,     0,     0,
       0,     0,  3083,   577,     0,     0,     0,  1336,     0,     0,
       0,   956,     0,     0,     0,     0,     0,     0,     0,     0,
    1260,     0,     0,     0,     0,     0,  1260,     0,     0,  1507,
       0,     0,  1502,     0,   577,     0,   577,   577,  1260,     0,
       0,   577,     0,     0,  1260,     0,     0,     0,  1260,     0,
       0,     0,  1507,  1260,     0,     0,  1260,  1260,  1260,  1260,
    1260,  1260,  1260,  1260,  1260,  1260,     0,     0,     0,     0,
    1260,  1260,     0,     0,     0,     0,   592,     0,     0,  1507,
       0,     0,     0,     0,  1260,     0,     0,     0,     0,     0,
       0,  1260,     0,     0,  1260,     0,  1260,     0,     0,   577,
       0,     0,  1507,  1260,  1260,  1260,     0,     0,     0,  1260,
       0,     0,  1260,  1372,     0,     0,  1374,     0,     0,  1376,
       0,     0,     0,     0,     0,     0,     0,  1670,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1671,     0,     0,     0,     0,     0,     0,     0,  1673,
       0,     0,     0,     0,  1674,     0,  1260,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   833,   833,   833,
       0,     0,     0,     0,   592,   833,     0,     0,     0,   833,
     833,     0,     0,     0,     0,     0,   833,     0,  1466,   577,
       0,     0,  1467,     0,     0,   833,  1469,   833,     0,     0,
       0,     0,  1510,     0,  1503,     0,     0,     0,     0,     0,
     833,     0,   833,     0,  1507,     0,     0,     0,     0,  1502,
    1502,     0,     0,     0,     0,   577,     0,  1537,     0,     0,
    1503,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1503,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1675,
       0,     0,  1568,  1676,     0,     0,     0,     0,   868,     0,
    1260,     0,     0,   592,     0,   868,  1597,   868,     0,     0,
       0,  1507,  1677,  1678,     0,  1503,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1679,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1502,     0,
       0,     0,  1503,  1502,     0,     0,     0,     0,     0,   577,
    3271,     0,  1002,   577,  3275,     0,  1680,  1002,  1502,  1681,
       0,  1002,     0,     0,     0,     0,     0,  1503,     0,     0,
    1336,     0,  1682,     0,  1683,     0,   592,     0,     0,  1260,
       0,     0,     0,     0,     0,     0,  1336,     0,     0,     0,
       0,  1260,     0,     0,     0,     0,     0,     0,     0,  1503,
       0,     0,     0,     0,  1503,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1670,     0,     0,  1502,
    1684,     0,  1260,  1260,     0,     0,     0,  1507,     0,     0,
    1671,     0,     0,  1260,  1260,     0,     0,  1260,  1673,     0,
       0,     0,     0,  1674,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   833,     0,     0,     0,     0,     0,     0,
       0,  1336,     0,     0,  1336,  1336,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1685,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1686,  1687,  1688,     0,
    1689,  1690,  1691,  1692,  1693,  1694,     0,     0,  2711,  1670,
    1260,     0,     0,     0,  1503,     0,   592,     0,     0,  1815,
     592,     0,     0,  1671,   592,     0,  1672,     0,     0,  2561,
       0,  1673,   833,     0,  2562,     0,  1674,   833,     0,     0,
       0,     0,     0,     0,     0,     0,  1002,     0,  1675,     0,
       0,     0,  1676,     0,     0,     0,     0,     0,     0,  1260,
       0,     0,     0,  1002,     0,     0,     0,     0,  1507,     0,
       0,  1677,  1678,     0,     0,     0,  1260,     0,     0,     0,
    1506,   592,     0,     0,  1679,  1260,     0,  1260,     0,     0,
       0,     0,     0,     0,  1507,  1260,  1260,     0,     0,  1260,
       0,     0,     0,     0,     0,     0,  1260,  1260,     0,     0,
       0,     0,     0,     0,  1506,  1680,  1260,     0,  1681,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1682,     0,  1683,  1260,     0,     0,     0,     0,     0,
       0,  1675,     0,     0,     0,  1676,     0,     0,  1002,     0,
       0,     0,     0,     0,     0,     0,     0,   833,     0,     0,
       0,     0,     0,     0,  1677,  1678,     0,  2000,  1502,  1502,
       0,  1502,     0,     0,     0,     0,  1260,  1679,     0,     0,
       0,     0,     0,     0,     0,     0,  1502,     0,  1502,  1684,
       0,     0,     0,     0,  2039,     0,     0,     0,  1260,     0,
       0,  1503,  1503,     0,     0,     0,     0,  2048,  1680,     0,
       0,  1681,     0,     0,  1502,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1682,     0,  1683,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1502,     0,     0,     0,     0,     0,
       0,  1002,     0,     0,     0,  1685,     0,     0,     0,     0,
       0,     0,  1502,     0,  1260,  1686,  1687,  1688,     0,  1689,
    1690,  1691,  1692,  1693,  1694,     0,     0,     0,     0,     0,
       0,   833,  1684,  1336,     0,     0,     0,     0,     0,     0,
    1503,     0,     0,     0,     0,  1503,     0,  1502,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1000,  1502,     0,
    1503,  1000,     0,     0,  1507,     0,     0,     0,     0,     0,
       0,     0,  1502,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1002,     0,     0,     0,     0,
    1000,     0,     0,     0,     0,     0,     0,     0,  1685,     0,
       0,  2211,     0,     0,     0,     0,     0,     0,  1686,  1687,
    1688,     0,  1689,  1690,  1691,  1692,  1693,  1694,  1002,     0,
       0,  1507,   833,     0,     0,     0,  1000,     0,  1670,     0,
       0,  1503,  1000,     0,     0,  1506,     0,  1336,     0,     0,
       0,     0,  1671,  1336,  1336,  2520,     0,     0,     0,     0,
    1673,     0,  1502,     0,     0,  1674,     0,     0,     0,     0,
       0,  1862,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1506,  1502,     0,   592,   592,     0,
       0,     0,     0,     0,     0,     0,   592,     0,     0,     0,
       0,     0,     0,     0,  1336,     0,     0,     0,     0,   833,
       0,   833,  1502,     0,     0,     0,     0,   956,     0,     0,
       0,     0,  2750,   592,     0,     0,  1506,  1670,  2263,     0,
       0,     0,  1257,     0,     0,  1502,  2270,   868,     0,     0,
     868,  1671,  2274,     0,     0,     0,     0,  2278,     0,  1673,
       0,     0,     0,  1506,  1674,     0,     0,     0,     0,     0,
       0,     0,   592,   592,     0,     0,     0,     0,     0,     0,
    1675,     0,     0,     0,  1676,     0,     0,     0,  1506,  2298,
    2299,     0,  2301,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1677,  1678,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1679,     0,     0,     0,
    1506,  2319,  2320,     0,     0,  1506,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2334,     0,  2338,  2339,
       0,  2343,  2344,  2345,  2346,     0,     0,  1680,  2352,     0,
    1681,  2355,     0,     0,     0,     0,     0,  1502,     0,     0,
       0,   833,     0,  1682,     0,  1683,     0,     0,     0,  1675,
       0,   833,     0,  1676,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1677,  1678,     0,     0,     0,     0,     0,     0,
    1503,  1503,     0,  1503,     0,  1679,  1257,     0,     0,     0,
       0,  1000,     0,     0,     0,   592,     0,  1000,  1503,     0,
    1503,  1684,     0,     0,  1502,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1505,     0,  1680,     0,     0,  1681,
       0,     0,     0,     0,     0,  1506,  1503,     0,     0,     0,
       0,     0,  1682,     0,  1683,     0,     0,     0,     0,  1000,
       0,     0,     0,     0,     0,     0,   956,     0,  1505,     0,
       0,     0,     0,     0,     0,     0,  1503,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1670,  1685,     0,     0,
       0,     0,     0,     0,  1503,     0,     0,  1686,  1687,  1688,
    1671,  1689,  1690,  1691,  1692,  1693,  1694,     0,  1673,     0,
    1684,     0,     0,  1674,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1503,
    1257,     0,     0,     0,  1670,     0,     0,     0,     0,     0,
    1503,     0,     0,     0,     0,     0,     0,     0,  1671,     0,
    1502,  2570,   592,   592,  1503,  2522,  1673,  1257,     0,     0,
       0,  1674,     0,     0,     0,     0,   833,     0,     0,     0,
       0,   833,   833,   833,   833,   833,  1685,     0,     0,   833,
       0,  1257,  1257,     0,  1257,     0,  1686,  1687,  1688,     0,
    1689,  1690,  1691,  1692,  1693,  1694,     0,     0,     0,     0,
       0,     0,  1257,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1675,     0,
       0,     0,  1676,     0,     0,     0,     0,     0,     0,   592,
       0,     0,  1862,  1862,  1503,     0,     0,     0,     0,     0,
       0,  1677,  1678,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1679,     0,     0,  1503,     0,     0,
       0,     0,     0,     0,     0,     0,  1675,     0,  1257,     0,
    1676,  1257,  1257,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1503,  1680,     0,     0,  1681,  1677,
    1678,  1502,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1682,  1679,  1683,     0,     0,     0,  1503,     0,  2685,
    2686,     0,  2539,     0,     0,     0,     0,  1502,     0,     0,
       0,  1506,     0,     0,     0,     0,  1506,     0,     0,     0,
       0,     0,     0,  1680,     0,     0,  1681,     0,     0,  1505,
       0,  1506,     0,     0,  1670,     0,   868,     0,     0,  1682,
       0,  1683,     0,     0,     0,     0,   592,     0,  1671,  1684,
       0,     0,     0,     0,     0,  1861,  1673,     0,     0,   833,
       0,  1674,     0,     0,     0,     0,     0,     0,  1505,     0,
     868,     0,   833,     0,     0,     0,     0,   592,     0,   592,
     592,     0,     0,     0,   592,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   868,     0,     0,  1684,     0,     0,
       0,     0,  1506,     0,     0,     0,  2754,  2756,  2758,  1503,
    1505,     0,     0,     0,     0,  1685,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1686,  1687,  1688,     0,  1689,
    1690,  1691,  1692,  1693,  1694,     0,     0,  1505,     0,     0,
       0,  2794,   592,     0,     0,  1670,     0,     0,     0,     0,
       0,     0,  2575,   781,     0,     0,     0,     0,     0,     0,
       0,     0,  1505,  1685,     0,     0,  1675,  1673,     0,     0,
    1676,     0,  1674,  1686,  1687,  1688,  1503,  1689,  1690,  1691,
    1692,  1693,  1694,     0,     0,     0,     0,     0,     0,  1677,
    1678,     0,  1000,     0,  1505,     0,     0,     0,     0,  1505,
       0,     0,  1679,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1502,     0,  1000,
       0,     0,   592,  1680,     0,     0,  1681,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1682,
       0,  1683,     0,     0,     0,     0,     0,     0,     0,  1257,
    1257,     0,     0,     0,     0,     0,     0,  1257,   592,     0,
    1257,  1257,     0,     0,     0,     0,     0,  1675,     0,     0,
       0,  1676,  1257,  1257,  1502,     0,     0,     0,     0,     0,
    1257,     0,     0,     0,  1257,  1257,  1257,  1257,     0,     0,
    1677,  1678,  1503,     0,  1257,  1257,     0,  1684,     0,     0,
       0,     0,     0,  1679,     0,     0,     0,     0,     0,  1505,
    1257,     0,     0,     0,  1257,     0,     0,     0,  1257,     0,
       0,     0,  1257,     0,     0,  1257,  1257,  1257,  1257,  1257,
    1257,  1257,  1257,  1257,  1680,  1257,     0,  1681,     0,  1257,
       0,  1862,  1862,  1257,  1862,     0,     0,     0,     0,     0,
    1682,     0,   592,     0,     0,     0,   592,     0,     0,  1506,
       0,  1506,  1670,  1685,     0,     0,     0,     0,  1670,     0,
       0,     0,     0,  1686,  1687,  1688,  1671,  1689,  1690,  1691,
    1692,  1693,  1694,     0,  1673,     0,     0,  1506,     0,  1674,
    1673,     0,     0,     0,     0,  1674,     0,   833,   833,     0,
       0,     0,     0,     0,     0,  2951,  2952,     0,  1684,     0,
       0,     0,     0,     0,     0,     0,     0,  1506,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1503,     0,  1862,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2982,     0,     0,  1503,
       0,     0,     0,     0,     0,     0,     0,     0,  3070,     0,
    1506,     0,     0,     0,  1685,     0,     0,     0,  1257,     0,
       0,  1506,     0,     0,  1686,  1687,  1688,     0,  1689,  1690,
    1691,  1692,  1693,  1694,  1675,  1862,  1861,  1505,  1676,     0,
   -1795,     0,     0,     0,  1676,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1677,  1678,     0,
       0,     0,     0,  1677,  1678,     0,     0,     0,     0,     0,
    1679,     0,     0,     0,     0,  1670, -1795,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1671,
       0,     0,     0,     0,     0,     0,     0,  1673,     0,     0,
       0,  1680,  1674,     0,  1681,     0,     0,     0,     0,     0,
    1681,     0,     0,     0,     0,  1506,     0,  1682,     0,  1683,
       0,     0,     0,  1682,  1257,  1505,     0,     0,     0,     0,
    1505,     0,     0,     0,     0,     0,     0,     0,  1506,     0,
       0,     0,     0,  1257,     0,  1505,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1506,     0,     0,     0,  3092,
    3093,     0,     0,     0,     0,  1684,     0,     0,     0,  3099,
       0, -1795,     0,     0,     0,     0,     0,     0,  1506,     0,
       0,     0,     0,     0,     0,     0,     0,  2852,     0,     0,
       0,     0,     0,     0,  1000,     0,     0,  1675,     0,     0,
       0,  1676,     0,  1257,     0,     0,  1505,     0,     0,  1503,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1677,  1678,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1685,     0,  1679,     0,     0,     0,  1685,  2794,  1257,
       0,  1686,  1687,  1688,     0,  1689,  1690,  1691,  1692,  1693,
    1694,  1689,  1690,  1691,  1692,  1693,  1694,     0,     0,     0,
       0,     0,     0,  1257,  1680,     0,  1503,  1681,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1682,     0,  1683,     0,     0,     0,     0,     0,     0,     0,
    1506,     0,     0,     0,     0,  1257,     0,     0,  1257,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1257,  1257,  1257,  1257,     0,     0,     0,     0,     0,  1257,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1257,
    1257,     0,  1257,     0,     0,     0,     0,     0,  1684,     0,
       0,     0,     0,     0,  1257,     0,  1257,     0,     0,     0,
    1257,     0,     0,     0,     0,     0,     0,  1506,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1000,     0,  1257,  1257,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1257,
       0,     0,     0,     0,  1685,     0,     0,  1257,  1257,  1257,
       0,     0,     0,     0,  1686,  1687,  1688,     0,  1689,  1690,
    1691,  1692,  1693,  1694,     0,     0,     0,     0,     0,     0,
       0,     0,  3253,     0,     0,     0,     0,  3255,  1257,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1003,     0,
       0,     0,  1003,     0,     0,  1861,  1505,     0,  1505,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1505,     0,  1505,     0,     0,     0,     0,
       0,  1003,     0,  1506,     0,  3293,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1505,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1003,     0,     0,
       0,     0,     0,  1003,     0,     0,     0,     0,   751,     0,
       0,  1505,     0,     0,     0,     0,     0,     0,     0,   752,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1505,
       0,     0,     0,     0,     0,     0,     0,     0,   753,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   754,     0,  -456,     0,     0,
       0,     0,     0,     0,  1505,     0,     0,     0,     0,     0,
       0,     0,     0,   755,     0,  1505,     0,     0,     0,   756,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1505,
       0,   757,     0,  1261,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1000,  1506,     0,     0,  1000,     0,     0,
       0,  1000,     0,     0,     0,     0,     0,     0,     0,     0,
    -575,     0,   758,     0,     0,     0,   759,     0,     0,     0,
    1506,     0,     0,  1000,     0,     0,     0,     0,     0,  -561,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1257,  -387,     0,     0,     0,     0,  1257,     0,     0,  1505,
       0,     0,   760,     0,     0,     0,     0,     0,  1257,     0,
       0,     0,     0,     0,  1257,     0,     0,     0,  1257,     0,
       0,     0,  1505,  1257,     0,     0,  1257,  1257,  1257,  1257,
    1257,  1257,  1257,  1257,  1257,  1257,     0,     0,     0,     0,
    1257,  1257,     0,     0,     0,   761,     0,   762,     0,  1505,
       0,     0,     0,     0,  1257,     0,     0,     0,     0,     0,
       0,  1257,     0,     0,  1257,  -387,  1257,     0,     0,     0,
       0,     0,  1505,  1257,  1257,  1257,     0,     0,     0,  1257,
       0,     0,  1257,     0,   763,     0,     0,  1261,  -575,     0,
     764,     0,  1003,     0,     0,     0,     0,     0,  1003,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1508,     0,     0,     0,     0,
       0,   765,   766,     0,   767,     0,  1257,     0,     0,     0,
       0,     0,     0,   768,     0,     0,     0,   769,   770,     0,
    1003,     0,   771,     0,     0,     0,     0,   772,     0,  1508,
       0,     0,  1239,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1506,     0,     0,     0,  1505,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1261,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1506,  1261,     0,
    1257,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1505,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1261,  1261,     0,  1261,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1261,     0,     0,     0,     0,     0,     0,
       0,     0,  1000,     0,     0,     0,     0,  1000,     0,     0,
       0,  1000,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1454,     0,     0,  1257,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1257,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1261,
       0,     0,  1261,  1261,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1257,  1257,     0,     0,     0,  1505,     0,     0,
       0,     0,     0,  1257,  1257,     0,     0,  1257,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1508,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1616,     0,     0,     0,     0,     0,  1865,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1508,
    1257,     0,     0,     0,     0,     0,     0,  1640,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1659,  1660,     0,  1662,     0,  1000,     0,     0,     0,
       0,  1508,     0,     0,     0,     0,     0,     0,     0,  1257,
       0,     0,  1698,  1000,     0,     0,     0,     0,  1505,     0,
       0,     0,     0,     0,     0,     0,  1257,     0,  1508,     0,
       0,     0,     0,     0,     0,  1257,     0,  1257,     0,     0,
       0,     0,     0,     0,  1505,  1257,  1257,     0,     0,  1257,
       0,     0,     0,  1508,     0,     0,  1257,  1257,     0,     0,
       0,     0,     0,     0,     0,     0,  1257,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1760,     0,
       0,  1767,  1769,  1003,  1257,  1508,     0,     0,     0,     0,
    1508,     0,     0,     0,     0,     0,     0,     0,  1000,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1003,     0,     0,     0,     0,     0,  1257,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1257,     0,
    1261,  1261,     0,     0,     0,     0,     0,     0,  1261,     0,
       0,  1261,  1261,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1261,  1261,     0,     0,     0,     0,     0,
       0,  1261,     0,     0,     0,  1261,  1261,  1261,  1261,     0,
       0,     0,     0,     0,     0,  1261,  1261,     0,     0,     0,
       0,  1000,     0,     0,     0,     0,     0,     0,     0,     0,
    1508,  1261,     0,     0,  1257,  1261,     0,     0,     0,  1261,
       0,     0,     0,  1261,     0,     0,  1261,  1261,  1261,  1261,
    1261,  1261,  1261,  1261,  1261,     0,  1261,     0,     0,     0,
    1261,     0,     0,     0,  1261,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1505,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1000,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1000,     0,
       0,  1505,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1261,
       0,     0,     0,     0,     0,     0,     0,  2097,     0,     0,
       0,  2099,     0,     0,     0,     0,     0,  1865,  1508,     0,
       0,     0,     0,    78,     0,     0,     0,     0,     0,    82,
    2121,     0,     0,     0,  2124,     0,    88,  2133,    89,     0,
       0,    92,     0,     0,  2140,  2145,     0,     0,     0,     0,
       0,     0,   102,     0,     0,     0,     0,     0,     0,     0,
    2156,     0,     0,     0,  2162,     0,     0,     0,  2173,     0,
     115,   116,  2180,     0,     0,  2182,  2183,  2184,  2185,  2186,
    2187,  2188,  2189,  2190,     0,  2191,     0,     0,     0,  1239,
       0,     0,     0,     0,     0,     0,     0,   124,     0,     0,
       0,     0,     0,     0,     0,  1261,  1508,   125,   126,   127,
       0,  1508,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   914,     0,  1261,     0,  1508,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     136,     0,   137,   138,     0,     0,     0,   140,   141,     0,
       0,     0,     0,     0,     0,   143,   144,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   146,
       0,   147,     0,     0,   150,     0,     0,     0,     0,     0,
     151,     0,     0,     0,     0,  1003,     0,     0,     0,   152,
       0,     0,     0,     0,  1261,   153,     0,  1508,     0,     0,
     154,     0,   156,  1696,     0,     0,   158,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   162,     0,   163,
       0,     0,     0,     0,     0,     0,     0,     0,  2276,     0,
    1261,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   168,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1261,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   177,   178,     0,     0,
       0,     0,   179,     0,     0,     0,     0,     0,     0,     0,
     180,     0,     0,     0,     0,     0,  1261,     0,     0,  1261,
       0,     0,     0,     0,     0,     0,     0,   185,     0,     0,
       0,  1261,  1261,  1261,  1261,     0,     0,     0,     0,     0,
    1261,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1261,  1261,     0,  1261,     0,     0,   195,     0,     0,     0,
       0,     0,     0,     0,  2360,  1261,     0,  1261,   197,     0,
     198,  1261,     0,     0,   199,     0,     0,     0,   200,     0,
       0,   202,     0,  2381,     0,   204,     0,     0,     0,     0,
     205,     0,     0,     0,  1003,   206,  1261,  1261,   208,     0,
       0,     0,     0,     0,   211,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1261,     0,     0,     0,     0,     0,     0,     0,  1261,  1261,
    1261,     0,   217,     0,   218,     0,     0,     0,     0,     0,
     220,     0,   221,     0,     0,   222,     0,     0,  1696,     0,
       0,     0,     0,  2469,     0,     0,     0,     0,     0,  1261,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1865,  1508,     0,  1508,
       0,     0,     0,     0,     0,     0,     0,     0,   227,  2493,
       0,     0,     0,     0,  1508,     0,  1508,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2516,     0,     0,     0,     0,     0,     0,
       0,     0,  1508,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1508,     0,     0,     0,     0,     0,     0,     0,
    2145,     0,  2145,  2145,     0,     0,     0,     0,     0,  2578,
    1508,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2597,     0,  2599,     0,     0,     0,
    2602,     0,     0,     0,     0,  1508,     0,     0,     0,     0,
    1696,     0,     0,     0,     0,     0,  1508,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1508,     0,     0,     0,  1696,     0,     0,     0,     0,     0,
    2129,     0,     0,     0,  1003,     0,     0,     0,  1003,  1760,
       0,     0,  1003,  1696,  1696,     0,  1696,  1769,  1769,  1767,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1003,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2672,     0,
       0,     0,  1696,     0,     0,     0,     0,     0,     0,     0,
       0,  1261,     0,     0,     0,     0,     0,  1261,     0,     0,
    1508,     0,     0,     0,     0,     0,     0,     0,     0,  1261,
       0,     0,     0,     0,     0,  1261,     0,     0,     0,  1261,
       0,     0,     0,  1508,  1261,     0,     0,  1261,  1261,  1261,
    1261,  1261,  1261,  1261,  1261,  1261,  1261,     0,     0,     0,
       0,  1261,  1261,     0,  1696,     0,     0,     0,     0,     0,
    1508,  1696,     0,  1696,     0,  1261,     0,     0,     0,     0,
       0,     0,  1261,     0,     0,  1261,     0,  1261,     0,     0,
       0,     0,     0,  1508,  1261,  1261,  1261,     0,     0,     0,
    1261,     0,     0,  1261,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1261,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1508,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2849,     0,     0,     0,     0,     0,  2853,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2858,     0,
       0,  1261,     0,     0,  2859,     0,     0,     0,  2861,     0,
       0,     0,  1508,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2878,  2879,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2892,     0,  1003,  2895,     0,  2897,     0,  1003,     0,
       0,     0,  1003,  2901,     0,     0,     0,     0,     0,  2906,
       0,     0,  2909,     0,     0,     0,     0,     0,     0,     0,
    1261,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1261,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2927,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1696,  1261,  1261,     0,     0,     0,  1508,     0,
       0,  1696,     0,  1696,  1261,  1261,     0,     0,  1261,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1696,     0,     0,  1696,     0,
    2129,  2557,     0,  2129,     0,     0,     0,  1696,     0,     0,
       0,     0,     0,     0,  1696,     0,     0,     0,     0,  1696,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1696,     0,     0,     0,  2129,  2129,  1696,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1696,     0,     0,
       0,  1261,     0,     0,  1696,     0,  1696,  1696,  1696,  1696,
    1696,  1696,  1696,  1696,  1696,  1696,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1003,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1261,     0,     0,     0,  1003,     0,     0,     0,     0,  1508,
       0,     0,     0,     0,     0,     0,     0,  1261,     0,     0,
       0,     0,     0,     0,     0,     0,  1261,     0,  1261,     0,
       0,     0,     0,     0,     0,  1508,  1261,  1261,     0,  2493,
    1261,     0,     0,     0,     0,     0,     0,  1261,  1261,     0,
    1696,  3049,     0,     0,     0,     0,     0,  1261,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1261,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1003,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3068,  3069,     0,     0,  3071,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1261,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1696,     0,     0,     0,     0,  1261,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1696,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3123,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1003,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1261,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3157,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1696,     0,     0,  2493,     0,     0,     0,
       0,     0,     0,     0,     0,  1508,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1696,     0,  3175,
       0,     0,     0,     0,     0,     0,  1003,  3177,     0,     0,
       0,     0,     0,     0,     0,     0,  3181,     0,     0,     0,
    1696,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3186,     0,     0,     0,     0,  1003,
       0,     0,  1508,     0,     0,     0,  2557,     0,  2129,     0,
       0,  2129,  2129,  2129,  2129,  2129,  2129,  2129,  2129,  2129,
    2129,     0,  2557,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     4,  3220,     0,     0,     0,
       0,     0,  1696,     0,     0,     0,     0,  2557,  2557,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     6,  2129,
    2129,  1696,     0,  1696,     0,     0,  1696,     0,     0,     7,
       8,     0,     0,     0,     0,     9,     0,    10,    11,     0,
       0,     0,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1696,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    36,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,     0,
       0,     0,     0,     0,     0,  2129,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    38,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    39,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    40,     0,     0,    41,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      42,     0,     0,  1696,     0,     0,     0,  1696,     0,     0,
       0,     0,  1696,  1696,     0,  1696,     0,     0,  2557,     0,
       0,     0,  2557,  2557,  2557,  2557,  2557,  2557,  2557,  2557,
    2557,  2557,  1696,  1696,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1696,  2129,  2129,  1696,
       0,  1696,     0,     0,     0,  1696,  2557,  2557,    43,     0,
    1696,     0,     0,  1696,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1696,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,    48,    49,     0,    50,  2557,    51,     0,
       0,     0,    52,     0,    53,    54,     0,     0,     0,    55,
      56,    57,    58,    59,     0,     0,    60,    61,    62,    63,
       0,    64,    65,    66,     0,    67,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1696,     0,     0,     0,     0,     0,     0,
    2129,     0,  2129,     0,     0,  2557,  2557,     0,     0,     0,
    2129,  2129,  1696,  1696,     0,  1696,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1696,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1696,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2557,  2129,  2557,     0,     0,  2557,  2557,  1696,
       0,  1696,     0,     0,     0,  1696,     0,     0,     0,     0,
    1696,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   610,    79,
      80,    81,   365,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,  1696,    93,    94,    95,    96,    97,
      98,   611,    99,   100,   101,   368,   612,  2557,   103,   104,
     105,   106,   613,   614,     0,   108,   109,   110,     0,   111,
     615,   616,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,   617,   386,
     387,   618,   619,   620,   621,   622,   623,   624,   388,   389,
     625,   390,   129,   391,   392,   393,   131,   132,   133,   134,
       0,   626,   394,   395,     0,   396,   627,   628,   397,   629,
     135,   399,   630,   400,   401,   402,   403,   139,   631,   632,
     404,   405,   406,   407,   633,   408,   409,   142,   410,   634,
     411,   412,   413,   145,   414,   635,   636,   637,   638,   639,
     415,   416,   417,   418,   419,   148,   149,   420,   640,   421,
     641,   422,     0,   423,   424,   425,   642,   426,   643,   644,
     427,   428,   429,   430,   645,   431,   432,   433,   646,   434,
     647,   435,   436,   437,   155,   438,     0,   157,   648,   439,
     440,   159,   649,   441,   650,   442,   160,   651,   161,   443,
       0,   444,   652,   445,   164,   653,   446,   654,   447,   448,
     449,   165,   450,   451,   452,   655,   453,   454,   455,   456,
     457,   656,   166,   167,   657,   458,   459,   460,   658,   169,
     659,   170,   660,     0,   171,   172,   461,   173,   462,   463,
     464,   465,   466,   661,   174,   175,   467,   176,   662,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,   182,   183,   663,   482,
     483,   484,   485,   486,   487,   488,   184,   489,   664,   490,
     491,   186,   492,   665,   187,   188,   493,   494,   666,   667,
     495,   668,   669,   670,   496,   497,   671,   672,   189,   190,
     191,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,   673,   504,   505,   506,   507,   508,   509,   196,   510,
     674,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,   201,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,   675,   530,   531,   532,   676,   533,   207,
     534,   535,   209,   536,   210,   677,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,   678,   546,   547,   679,
     548,   549,   550,   551,   680,   213,   214,   681,   553,   682,
     554,   215,   555,   216,   683,   556,   557,   558,   559,   560,
     684,   685,   561,   562,   563,   564,   686,   687,   565,   566,
       0,   567,   223,   568,   224,   569,     0,   688,   689,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
       0,     0,     0,    79,    80,    81,     0,    83,    84,     0,
      85,    86,    87,     0,     0,     0,    90,    91,     0,    93,
      94,    95,    96,    97,    98,   690,    99,   100,   101,     0,
       0,     0,   103,   104,   105,   106,     0,   107,     0,   108,
     109,   110,     0,   111,   112,   113,   114,     0,     0,     0,
       0,     0,   117,   118,     0,     0,     0,     0,   119,     0,
       0,     0,     0,     0,     0,     0,     0,   120,     0,   121,
       0,   122,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   129,     0,     0,     0,
     131,   132,   133,   134,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   135,     0,     0,     0,     0,     0,
       0,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   142,     0,     0,     0,     0,     0,   145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   148,
     149,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   155,     0,
       0,   157,     0,     0,     0,   159,     0,     0,     0,     0,
     160,     0,   161,     0,     0,     0,     0,     0,   164,     0,
       0,     0,     0,     0,     0,   165,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   166,   167,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,   171,   172,
       0,   173,     0,     0,     0,     0,     0,     0,   174,   175,
       0,   176,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   181,
     182,   183,     0,     0,     0,     0,     0,     0,     0,     0,
     184,     0,     0,     0,     0,   186,     0,     0,   187,   188,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   189,   190,   191,   192,     0,     0,     0,     0,
     193,   194,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   201,     0,     0,   203,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   207,     0,     0,   209,     0,   210,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   212,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   213,
     214,     0,     0,     0,     0,   215,     0,   216,     0,     0,
       0,     0,     0,     0,   219,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,     0,     0,     0,     0,     0,     0,    79,    80,    81,
     225,    83,    84,   226,    85,    86,    87,     0,     0,     0,
      90,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,     0,     0,     0,   103,   104,   105,   106,
    2244,   107,     0,   108,   109,   110,     0,   111,   112,   113,
     114,     0,     0,     0,     0,     0,   117,   118,     0,     0,
       0,     0,   119,     0,     0,     0,     0,     0,     0,     0,
       0,   120,     0,   121,     0,   122,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     129,     0,     0,     0,   131,   132,   133,   134,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   135,     0,
       0,     0,     0,     0,     0,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   142,     0,     0,     0,     0,
       0,   145,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   148,   149,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   155,     0,     0,   157,     0,     0,     0,   159,
       0,     0,     0,     0,   160,     0,   161,     0,     0,     0,
       0,     0,   164,     0,     0,     0,     0,     0,     0,   165,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     166,   167,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,   171,   172,     0,   173,     0,     0,     0,     0,
       0,     0,   174,   175,     0,   176,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   181,   182,   183,     0,     0,     0,     0,
       0,     0,     0,     0,   184,     0,     0,     0,     0,   186,
       0,     0,   187,   188,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   189,   190,   191,   192,
       0,     0,     0,     0,   193,   194,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   196,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     201,     0,     0,   203,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   207,     0,     0,
     209,     0,   210,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   212,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   213,   214,     0,     0,     0,     0,   215,
       0,   216,     0,     0,     0,     0,     0,     0,   219,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     4,     0,
     223,     0,   224,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     5,     0,   225,     0,     0,   226,     0,     0,
       0,     6,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     7,     8,     0,     0,     0,     0,     0,     0,
      10,    11,     0,     0,  2246,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      38,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    39,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    40,
       0,     0,    41,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    43,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    44,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,     0,     0,    48,    49,     0,    50,
       0,     0,     0,     0,     0,    52,     0,    53,    54,     0,
       0,     0,    55,    56,    57,    58,    59,     0,     0,    60,
      61,   971,     0,    78,     0,   972,    79,    80,    81,    82,
      83,    84,     0,    85,    86,    87,    88,     0,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   102,     0,     0,   103,   104,   105,   106,     0,
     107,     0,   108,   109,   110,     0,   111,   112,   113,   114,
     115,   116,     0,     0,     0,   117,   118,     0,     0,     0,
       0,   119,     0,     0,     0,     0,     0,     0,     0,     0,
     120,     0,   121,     0,   122,   123,     0,   124,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   125,   126,   127,
       0,     0,     0,     0,     0,     0,     0,     0,   128,   129,
       0,     0,   130,   131,   132,   133,   134,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   135,     0,     0,
     136,     0,   137,   138,   139,     0,     0,   140,   141,     0,
       0,     0,     0,     0,   142,   143,   144,     0,     0,     0,
     145,     0,     0,     0,     0,     0,     0,     0,     0,   146,
       0,   147,   148,   149,   150,     0,     0,     0,     0,     0,
     151,     0,     0,     0,     0,     0,     0,     0,     0,   152,
       0,     0,     0,     0,     0,   153,     0,     0,     0,     0,
     154,   155,   156,     0,   157,     0,   158,     0,   159,     0,
       0,     0,     0,   160,     0,   161,     0,   162,     0,   163,
       0,   164,     0,     0,     0,     0,     0,     0,   165,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,   168,     0,     0,   169,     0,   170,     0,
       0,   171,   172,     0,   173,     0,     0,     0,     0,     0,
       0,   174,   175,     0,   176,     0,   177,   178,     0,     0,
       0,     0,   179,     0,     0,     0,     0,     0,     0,     0,
     180,     0,   181,   182,   183,     0,     0,     0,     0,     0,
       0,     0,     0,   184,     0,     0,     0,   185,   186,     0,
       0,   187,   188,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   189,   190,   191,   192,     0,
       0,     0,     0,   193,   194,     0,   195,     0,     0,     0,
       0,     0,     0,     0,     0,   196,     0,     0,   197,     0,
     198,     0,     0,     0,   199,     0,     0,     0,   200,   201,
       0,   202,   203,     0,     0,   204,     0,     0,     0,     0,
     205,     0,     0,     0,     0,   206,   207,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,     0,     0,
       0,   212,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   213,   214,     0,     0,     0,     0,   215,     0,
     216,     0,   217,     0,   218,     0,     0,   219,     0,     0,
     220,     0,   221,     0,     0,   222,     0,     0,     0,   223,
       0,   224,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   225,     0,     0,   226,     0,     0,     0,
       0,     0,   610,    79,    80,    81,   365,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,   227,    93,
      94,    95,    96,    97,    98,   611,    99,   100,   101,   368,
     612,     0,   103,   104,   105,   106,   613,   614,     0,   108,
     109,   110,     0,   111,   615,   616,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,  2206,   386,   387,     0,     0,     0,     0,  1167,
       0,     0,   388,   389,     0,   390,   129,   391,   392,   393,
     131,  1168,   133,  1169,  1170,     0,   394,   395,     0,   396,
    1171,  1172,   397,  1173,  1174,   399,     0,   400,   401,   402,
     403,  1175,     0,     0,   404,   405,   406,   407,     0,   408,
     409,  1176,   410,     0,   411,   412,   413,   145,   414,  1177,
    1178,  1179,  1180,  1181,   415,   416,   417,   418,   419,  1182,
    1183,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,  2207,     0,   427,  1184,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,  1185,   438,
       0,  1186,  1187,   439,   440,  1188,     0,   441,     0,   442,
     160,     0,   161,   443,     0,   444,     0,   445,  1189,     0,
     446,     0,   447,   448,   449,   165,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,   166,   167,     0,   458,
     459,   460,  1190,  1191,     0,  1192,     0,     0,   171,   172,
     461,   173,   462,   463,   464,   465,   466,     0,  1193,   175,
     467,   176,     0,   468,   469,   470,  1194,  1195,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,  1196,
     182,  1197,   739,   482,   483,   484,   485,   486,   487,   488,
     184,   489,  1198,   490,   491,   186,   492,  1199,  1200,  1201,
     493,   494,     0,     0,   495,   740,     0,     0,  1202,   497,
       0,     0,   189,   190,   191,  1203,   498,   499,   500,     0,
    1204,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,  1205,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   201,   522,   523,  1206,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,  1207,   533,   207,   534,   535,   209,   536,  1208,     0,
     537,   538,   539,   540,   541,   542,   543,   544,  1209,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,  1210,
    1211,     0,   553,     0,   554,  1212,   555,  1213,  1214,   556,
     557,   558,   559,   560,     0,  1215,   561,   562,   563,   564,
    1216,     0,   565,   566,     0,   567,  1217,   568,   224,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,    49,  1218,   226,   576,     0,     0,  1219,  1220,    52,
    1221,    53,     0,     0,     0,     0,  1222,  1223,  2208,     0,
       0,     0,     0,     0,     0,  1225,  2209,   610,    79,    80,
      81,   365,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     611,    99,   100,   101,   368,   612,     0,   103,   104,   105,
     106,   613,   614,     0,   108,   109,   110,     0,   111,   615,
     616,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,     0,   386,   387,
       0,     0,     0,     0,  1167,     0,     0,   388,   389,     0,
     390,   129,   391,   392,   393,   131,  1168,   133,  1169,  1170,
       0,   394,   395,     0,   396,  1171,  1172,   397,  1173,  1174,
     399,     0,   400,   401,   402,   403,  1175,     0,     0,   404,
     405,   406,   407,     0,   408,   409,  1176,   410,     0,   411,
     412,   413,   145,   414,  1177,  1178,  1179,  1180,  1181,   415,
     416,   417,   418,   419,  1182,  1183,   420,     0,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
    1184,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,  1185,   438,     0,  1186,  1187,   439,   440,
    1188,     0,   441,     0,   442,   160,     0,   161,   443,     0,
     444,     0,   445,  1189,     0,   446,     0,   447,   448,   449,
     165,   450,   451,   452,     0,   453,   454,   455,   456,   457,
       0,   166,   167,     0,   458,   459,   460,  1190,  1191,     0,
    1192,     0,     0,   171,   172,   461,   173,   462,   463,   464,
     465,   466,     0,  1193,   175,   467,   176,     0,   468,   469,
     470,  1194,  1195,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,  1196,   182,  1197,   739,   482,   483,
     484,   485,   486,   487,   488,   184,   489,  1198,   490,   491,
     186,   492,  1199,  1200,  1201,   493,   494,     0,     0,   495,
     740,     0,     0,  1202,   497,     0,     0,   189,   190,   191,
    1203,   498,   499,   500,     0,  1204,   194,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,  1205,   510,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   201,   522,   523,  1206,   524,   525,   526,   527,   528,
     529,     0,     0,   530,   531,   532,  1207,   533,   207,   534,
     535,   209,   536,  1208,     0,   537,   538,   539,   540,   541,
     542,   543,   544,  1209,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,  1210,  1211,     0,   553,     0,   554,
    1212,   555,  1213,  1214,   556,   557,   558,   559,   560,     0,
    1215,   561,   562,   563,   564,  1216,     0,   565,   566,     0,
     567,  1217,   568,   224,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,    49,  1218,   226,   576,
       0,     0,  1219,  1220,    52,  1221,    53,     0,     0,     0,
       0,  1222,  1223,     0,     0,     0,     0,     0,     0,     0,
    1225,  2131,   610,    79,    80,    81,   365,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   611,    99,   100,   101,   368,
     612,     0,   103,   104,   105,   106,   613,   614,     0,   108,
     109,   110,     0,   111,   615,   616,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,   129,   391,   392,   393,
     131,  1475,   133,  1476,  1170,     0,   394,   395,     0,   396,
       0,     0,   397,  1477,  1478,   399,     0,   400,   401,   402,
     403,     0,     0,     0,   404,   405,   406,   407,     0,   408,
     409,     0,   410,     0,   411,   412,   413,   145,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,  1479,
    1480,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,  1184,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,     0,   438,
       0,     0,     0,   439,   440,  1481,     0,   441,     0,   442,
     160,     0,   161,   443,     0,   444,     0,   445,     0,     0,
     446,     0,   447,   448,   449,   165,   450,   451,   452,  1851,
     453,   454,   455,   456,   457,     0,   166,  1852,     0,   458,
     459,   460,  1190,  1482,     0,  1483,     0,     0,   171,   172,
     461,   173,   462,   463,   464,   465,   466,     0,     0,   175,
     467,   176,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,  1484,
     182,  1485,     0,   482,   483,   484,   485,   486,   487,   488,
       0,   489,     0,   490,   491,   186,   492,     0,     0,  1486,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,  1853,   190,   191,     0,   498,   499,   500,     0,
       0,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,  1487,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   201,   522,   523,     0,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,     0,   533,  1488,   534,   535,   209,   536,  1489,     0,
     537,   538,   539,   540,   541,   542,   543,   544,     0,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,  1490,
    1491,     0,   553,     0,   554,     0,   555,     0,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,  1492,   568,   224,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,    79,    80,    81,   365,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,  1854,    99,   100,   101,
     368,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,   132,     0,   134,     0,     0,   394,   395,     0,
     396,     0,     0,   397,   398,   135,   399,     0,   400,   401,
     402,   403,   139,     0,     0,   404,   405,   406,   407,     0,
     408,   409,   142,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
     148,   149,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,   428,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,   155,
     438,     0,   157,     0,   439,   440,   159,     0,   441,     0,
     442,     0,     0,     0,   443,     0,   444,     0,   445,   164,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,   167,     0,
     458,   459,   460,     0,   169,     0,   170,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   174,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     181,     0,   183,     0,   482,   483,   484,   485,   486,   487,
     488,   184,   489,     0,   490,   491,     0,   492,     0,   187,
     188,   493,   494,     0,     0,   495,     0,     0,     0,   496,
     497,     0,     0,   189,     0,     0,   192,   498,   499,   500,
       0,   193,   194,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,   196,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
     203,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,     0,   533,   207,   534,   535,     0,   536,   210,
       0,   537,   538,   539,   540,   541,   542,   543,   544,   212,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
     213,   214,     0,   553,     0,   554,   215,   555,   216,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,  3223,   565,   566,     0,   567,   223,   568,     0,
     569,     4,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     6,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1239,     7,     8,     0, -1239,     0,
       0,     0,     0,    10,    11,     0,     0,     0,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,     0,     0,     0,     4,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     5,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     7,
       8,     0,    36,     0,     0,     0,     0,    10,    11,     0,
       0,     0,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,     0,    36,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    38,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    39,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    40,     0,     0,    41,     0,     0,    37,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    42,    38,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    39,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    40,     0,     0,    41,
       0,     0,     0,     0,    43,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    45,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,    43,    48,
      49,     0,    50,     0,     0,     0,     0,     0,    52,     0,
      53,    54,     0,     0,     0,    55,    56,    57,    58,    59,
       0,     0,    60,    61,   971,  1356,     0,     0,     0,     0,
       0,     0,     0,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,    48,    49,     0,    50,     0,     0,     0,
       0,     0,    52,     0,    53,    54,     0,     0,     0,    55,
      56,    57,    58,    59,     0,     0,    60,    61,   971,  1808,
     610,    79,    80,    81,   365,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   611,    99,   100,   101,   368,   612,     0,
     103,   104,   105,   106,   613,   614,     0,   108,   109,   110,
       0,   111,   615,   616,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,  1167,     0,     0,
     388,   389,     0,   390,   129,   391,   392,   393,   131,  1168,
     133,  1169,  1170,  2141,   394,   395,     0,   396,  1171,  1172,
     397,  1173,  1174,   399,     0,   400,   401,   402,   403,  1175,
       0,     0,   404,   405,   406,   407,     0,   408,   409,  1176,
     410,     0,   411,   412,   413,   145,   414,  1177,  1178,  1179,
    1180,  1181,   415,   416,   417,   418,   419,  1182,  1183,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,  1184,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,  1185,   438,     0,  1186,
    1187,   439,   440,  1188,     0,   441,     0,   442,   160,  2142,
     161,   443,     0,   444,     0,   445,  1189,     0,   446,     0,
     447,   448,   449,   165,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,   166,   167,     0,   458,   459,   460,
    1190,  1191,     0,  1192,     0,     0,   171,   172,   461,   173,
     462,   463,   464,   465,   466,  2143,  1193,   175,   467,   176,
       0,   468,   469,   470,  1194,  1195,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,  1196,   182,  1197,
     739,   482,   483,   484,   485,   486,   487,   488,   184,   489,
    1198,   490,   491,   186,   492,  1199,  1200,  1201,   493,   494,
       0,     0,   495,   740,     0,     0,  1202,   497,     0,     0,
     189,   190,   191,  1203,   498,   499,   500,     0,  1204,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
    1205,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   201,   522,   523,  1206,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,  1207,
     533,   207,   534,   535,   209,   536,  1208,     0,   537,   538,
     539,   540,   541,   542,   543,   544,  1209,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,  1210,  1211,     0,
     553,  2144,   554,  1212,   555,  1213,  1214,   556,   557,   558,
     559,   560,     0,  1215,   561,   562,   563,   564,  1216,     0,
     565,   566,     0,   567,  1217,   568,   224,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,    49,
    1218,   226,   576,     0,     0,  1219,  1220,    52,  1221,    53,
       0,     0,     0,     0,  1222,  1223,   610,    79,    80,    81,
     365,    83,    84,  1225,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   611,
      99,   100,   101,   368,   612,     0,   103,   104,   105,   106,
     613,   614,     0,   108,   109,   110,     0,   111,   615,   616,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,  1167,     0,     0,   388,   389,     0,   390,
     129,   391,   392,   393,   131,  1168,   133,  1169,  1170,     0,
     394,   395,     0,   396,  1171,  1172,   397,  1173,  1174,   399,
       0,   400,   401,   402,   403,  1175,     0,     0,   404,   405,
     406,   407,     0,   408,   409,  1176,   410,     0,   411,   412,
     413,   145,   414,  1177,  1178,  1179,  1180,  1181,   415,   416,
     417,   418,   419,  1182,  1183,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,  1184,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,  1185,   438,     0,  1186,  1187,   439,   440,  1188,
       0,   441,     0,   442,   160,     0,   161,   443,     0,   444,
       0,   445,  1189,     0,   446,     0,   447,   448,   449,   165,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
     166,   167,     0,   458,   459,   460,  1190,  1191,     0,  1192,
       0,     0,   171,   172,   461,   173,   462,   463,   464,   465,
     466,     0,  1193,   175,   467,   176,     0,   468,   469,   470,
    1194,  1195,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,  1196,   182,  1197,   739,   482,   483,   484,
     485,   486,   487,   488,   184,   489,  1198,   490,   491,   186,
     492,  1199,  1200,  1201,   493,   494,     0,     0,   495,   740,
       0,     0,  1202,   497,     0,     0,   189,   190,   191,  1203,
     498,   499,   500,     0,  1204,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,  1205,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     201,   522,   523,  1206,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,  1207,   533,   207,   534,   535,
     209,   536,  1208,     0,   537,   538,   539,   540,   541,   542,
     543,   544,  1209,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,  1210,  1211,     0,   553,     0,   554,  1212,
     555,  1213,  1214,   556,   557,   558,   559,   560,     0,  1215,
     561,   562,   563,   564,  1216,     0,   565,   566,     0,   567,
    1217,   568,   224,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,    49,  1218,   226,   576,     0,
       0,  1219,  1220,    52,  1221,    53,     0,     0,     0,     0,
    1222,  1223,  1224,     0,     0,     0,     0,     0,     0,  1225,
     610,    79,    80,    81,   365,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   611,    99,   100,   101,   368,   612,     0,
     103,   104,   105,   106,   613,   614,     0,   108,   109,   110,
       0,   111,   615,   616,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,  1167,     0,     0,
     388,   389,     0,   390,   129,   391,   392,   393,   131,  1168,
     133,  1169,  1170,     0,   394,   395,     0,   396,  1171,  1172,
     397,  1173,  1174,   399,     0,   400,   401,   402,   403,  1175,
       0,     0,   404,   405,   406,   407,     0,   408,   409,  1176,
     410,     0,   411,   412,   413,   145,   414,  1177,  1178,  1179,
    1180,  1181,   415,   416,   417,   418,   419,  1182,  1183,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,  1184,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,  1185,   438,     0,  1186,
    1187,   439,   440,  1188,     0,   441,     0,   442,   160,     0,
     161,   443,     0,   444,     0,   445,  1189,     0,   446,     0,
     447,   448,   449,   165,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,   166,   167,     0,   458,   459,   460,
    1190,  1191,     0,  1192,     0,     0,   171,   172,   461,   173,
     462,   463,   464,   465,   466,     0,  1193,   175,   467,   176,
       0,   468,   469,   470,  1194,  1195,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,  1196,   182,  1197,
     739,   482,   483,   484,   485,   486,   487,   488,   184,   489,
    1198,   490,   491,   186,   492,  1199,  1200,  1201,   493,   494,
       0,     0,   495,   740,     0,     0,  1202,   497,     0,     0,
     189,   190,   191,  1203,   498,   499,   500,     0,  1204,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
    1205,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   201,   522,   523,  1206,   524,   525,
     526,   527,   528,   529,     0,   205,   530,   531,   532,  1207,
     533,   207,   534,   535,   209,   536,  1208,     0,   537,   538,
     539,   540,   541,   542,   543,   544,  1209,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,  1210,  1211,     0,
     553,     0,   554,  1212,   555,  1213,  1214,   556,   557,   558,
     559,   560,     0,  1215,   561,   562,   563,   564,  1216,     0,
     565,   566,     0,   567,  1217,   568,   224,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,    49,
    1218,   226,   576,     0,     0,  1219,  1220,    52,  1221,    53,
       0,     0,     0,     0,  1222,  1223,   610,    79,    80,    81,
     365,    83,    84,  1225,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   611,
      99,   100,   101,   368,   612,     0,   103,   104,   105,   106,
     613,   614,     0,   108,   109,   110,     0,   111,   615,   616,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,  1765,   386,   387,     0,
       0,     0,     0,  1167,     0,     0,   388,   389,     0,   390,
     129,   391,   392,   393,   131,  1168,   133,  1169,  1170,     0,
     394,   395,     0,   396,  1171,  1172,   397,  1173,  1174,   399,
       0,   400,   401,   402,   403,  1175,     0,     0,   404,   405,
     406,   407,     0,   408,   409,  1176,   410,     0,   411,   412,
     413,   145,   414,  1177,  1178,  1179,  1180,  1181,   415,   416,
     417,   418,   419,  1182,  1183,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,  1184,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,  1185,   438,     0,  1186,  1187,   439,   440,  1188,
       0,   441,     0,   442,   160,     0,   161,   443,     0,   444,
       0,   445,  1189,     0,   446,     0,   447,   448,   449,   165,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
     166,   167,     0,   458,   459,   460,  1190,  1191,     0,  1192,
       0,     0,   171,   172,   461,   173,   462,   463,   464,   465,
     466,     0,  1193,   175,   467,   176,     0,   468,   469,   470,
    1194,  1195,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,  1196,   182,  1197,   739,   482,   483,   484,
     485,   486,   487,   488,   184,   489,  1198,   490,   491,   186,
     492,  1199,  1200,  1201,   493,   494,     0,     0,   495,   740,
       0,     0,  1202,   497,     0,     0,   189,   190,   191,  1203,
     498,   499,   500,     0,  1204,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,  1205,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     201,   522,   523,  1206,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,  1207,   533,   207,   534,   535,
     209,   536,  1208,     0,   537,   538,   539,   540,   541,   542,
     543,   544,  1209,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,  1210,  1211,     0,   553,     0,   554,  1212,
     555,  1213,  1214,   556,   557,   558,   559,   560,     0,  1215,
     561,   562,   563,   564,  1216,     0,   565,   566,     0,   567,
    1217,   568,   224,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,    49,  1218,   226,   576,     0,
       0,  1219,  1220,    52,  1221,    53,     0,     0,     0,     0,
    1222,  1223,   610,    79,    80,    81,   365,    83,    84,  1225,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   611,    99,   100,   101,   368,
     612,     0,   103,   104,   105,   106,   613,   614,     0,   108,
     109,   110,     0,   111,   615,   616,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,  1167,
       0,     0,   388,   389,     0,   390,   129,   391,   392,   393,
     131,  1168,   133,  1169,  1170,     0,   394,   395,     0,   396,
    1171,  1172,   397,  1173,  1174,   399,     0,   400,   401,   402,
     403,  1175,     0,     0,   404,   405,   406,   407,     0,   408,
     409,  1176,   410,     0,   411,   412,   413,   145,   414,  1177,
    1178,  1179,  1180,  1181,   415,   416,   417,   418,   419,  1182,
    1183,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,  1184,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,  1185,   438,
       0,  1186,  1187,   439,   440,  1188,     0,   441,     0,   442,
     160,     0,   161,   443,     0,   444,     0,   445,  1189,     0,
     446,     0,   447,   448,   449,   165,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,   166,   167,     0,   458,
     459,   460,  1190,  1191,     0,  1192,     0,     0,   171,   172,
     461,   173,   462,   463,   464,   465,   466,     0,  1193,   175,
     467,   176,     0,   468,   469,   470,  1194,  1195,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,  1196,
     182,  1197,   739,   482,   483,   484,   485,   486,   487,   488,
     184,   489,  1198,   490,   491,   186,   492,  1199,  1200,  1201,
     493,   494,     0,     0,   495,   740,     0,     0,  1202,   497,
       0,     0,   189,   190,   191,  1203,   498,   499,   500,     0,
    1204,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,  1205,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   201,   522,   523,  1206,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,  1207,   533,   207,   534,   535,   209,   536,  1208,     0,
     537,   538,   539,   540,   541,   542,   543,   544,  1209,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,  1210,
    1211,     0,   553,     0,   554,  1212,   555,  1213,  1214,   556,
     557,   558,   559,   560,     0,  1215,   561,   562,   563,   564,
    1216,     0,   565,   566,     0,   567,  1217,   568,   224,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,    49,  1218,   226,   576,     0,     0,  1219,  1220,    52,
    1221,    53,     0,     0,     0,     0,  1222,  1223,     0,     0,
       0,     0,     0,  1611,     0,  1225,   610,    79,    80,    81,
     365,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   611,
      99,   100,   101,   368,   612,     0,   103,   104,   105,   106,
     613,   614,     0,   108,   109,   110,     0,   111,   615,   616,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,  1167,     0,     0,   388,   389,     0,   390,
     129,   391,   392,   393,   131,  1168,   133,  1169,  1170,     0,
     394,   395,     0,   396,  1171,  1172,   397,  1173,  1174,   399,
       0,   400,   401,   402,   403,  1175,     0,     0,   404,   405,
     406,   407,     0,   408,   409,  1176,   410,     0,   411,   412,
     413,   145,   414,  1177,  1178,  1179,  1180,  1181,   415,   416,
     417,   418,   419,  1182,  1183,   420,  2492,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,  1184,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,  1185,   438,     0,  1186,  1187,   439,   440,  1188,
       0,   441,     0,   442,   160,     0,   161,   443,     0,   444,
       0,   445,  1189,     0,   446,     0,   447,   448,   449,   165,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
     166,   167,     0,   458,   459,   460,  1190,  1191,     0,  1192,
       0,     0,   171,   172,   461,   173,   462,   463,   464,   465,
     466,     0,  1193,   175,   467,   176,     0,   468,   469,   470,
    1194,  1195,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,  1196,   182,  1197,   739,   482,   483,   484,
     485,   486,   487,   488,   184,   489,  1198,   490,   491,   186,
     492,  1199,  1200,  1201,   493,   494,     0,     0,   495,   740,
       0,     0,  1202,   497,     0,     0,   189,   190,   191,  1203,
     498,   499,   500,     0,  1204,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,  1205,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     201,   522,   523,  1206,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,  1207,   533,   207,   534,   535,
     209,   536,  1208,     0,   537,   538,   539,   540,   541,   542,
     543,   544,  1209,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,  1210,  1211,     0,   553,     0,   554,  1212,
     555,  1213,  1214,   556,   557,   558,   559,   560,     0,  1215,
     561,   562,   563,   564,  1216,     0,   565,   566,     0,   567,
    1217,   568,   224,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,    49,  1218,   226,   576,     0,
       0,  1219,  1220,    52,  1221,    53,     0,     0,     0,     0,
    1222,  1223,   610,    79,    80,    81,   365,    83,    84,  1225,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   611,    99,   100,   101,   368,
     612,     0,   103,   104,   105,   106,   613,   614,     0,   108,
     109,   110,     0,   111,   615,   616,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,  1167,
       0,     0,   388,   389,     0,   390,   129,   391,   392,   393,
     131,  1168,   133,  1169,  1170,     0,   394,   395,     0,   396,
    1171,  1172,   397,  1173,  1174,   399,     0,   400,   401,   402,
     403,  1175,     0,     0,   404,   405,   406,   407,     0,   408,
     409,  1176,   410,     0,   411,   412,   413,   145,   414,  1177,
    1178,  1179,  1180,  1181,   415,   416,   417,   418,   419,  1182,
    1183,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,  1184,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,  1185,   438,
       0,  1186,  1187,   439,   440,  1188,     0,   441,     0,   442,
     160,  2142,   161,   443,     0,   444,     0,   445,  1189,     0,
     446,     0,   447,   448,   449,   165,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,   166,   167,     0,   458,
     459,   460,  1190,  1191,     0,  1192,     0,     0,   171,   172,
     461,   173,   462,   463,   464,   465,   466,     0,  1193,   175,
     467,   176,     0,   468,   469,   470,  1194,  1195,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,  1196,
     182,  1197,   739,   482,   483,   484,   485,   486,   487,   488,
     184,   489,  1198,   490,   491,   186,   492,  1199,  1200,  1201,
     493,   494,     0,     0,   495,   740,     0,     0,  1202,   497,
       0,     0,   189,   190,   191,  1203,   498,   499,   500,     0,
    1204,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,  1205,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   201,   522,   523,  1206,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,  1207,   533,   207,   534,   535,   209,   536,  1208,     0,
     537,   538,   539,   540,   541,   542,   543,   544,  1209,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,  1210,
    1211,     0,   553,     0,   554,  1212,   555,  1213,  1214,   556,
     557,   558,   559,   560,     0,  1215,   561,   562,   563,   564,
    1216,     0,   565,   566,     0,   567,  1217,   568,   224,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,    49,  1218,   226,   576,     0,     0,  1219,  1220,    52,
    1221,    53,     0,     0,     0,     0,  1222,  1223,   610,    79,
      80,    81,   365,    83,    84,  1225,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   611,    99,   100,   101,   368,   612,     0,   103,   104,
     105,   106,   613,   614,     0,   108,   109,   110,     0,   111,
     615,   616,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,  1167,     0,     0,   388,   389,
       0,   390,   129,   391,   392,   393,   131,  1168,   133,  1169,
    1170,     0,   394,   395,     0,   396,  1171,  1172,   397,  1173,
    1174,   399,     0,   400,   401,   402,   403,  1175,     0,     0,
     404,   405,   406,   407,     0,   408,   409,  1176,   410,     0,
     411,   412,   413,   145,   414,  1177,  1178,  1179,  1180,  1181,
     415,   416,   417,   418,   419,  1182,  1183,   420,  2926,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,  1184,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,  1185,   438,     0,  1186,  1187,   439,
     440,  1188,     0,   441,     0,   442,   160,     0,   161,   443,
       0,   444,     0,   445,  1189,     0,   446,     0,   447,   448,
     449,   165,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,   166,   167,     0,   458,   459,   460,  1190,  1191,
       0,  1192,     0,     0,   171,   172,   461,   173,   462,   463,
     464,   465,   466,     0,  1193,   175,   467,   176,     0,   468,
     469,   470,  1194,  1195,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,  1196,   182,  1197,   739,   482,
     483,   484,   485,   486,   487,   488,   184,   489,  1198,   490,
     491,   186,   492,  1199,  1200,  1201,   493,   494,     0,     0,
     495,   740,     0,     0,  1202,   497,     0,     0,   189,   190,
     191,  1203,   498,   499,   500,     0,  1204,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,  1205,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,   201,   522,   523,  1206,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,  1207,   533,   207,
     534,   535,   209,   536,  1208,     0,   537,   538,   539,   540,
     541,   542,   543,   544,  1209,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,  1210,  1211,     0,   553,     0,
     554,  1212,   555,  1213,  1214,   556,   557,   558,   559,   560,
       0,  1215,   561,   562,   563,   564,  1216,     0,   565,   566,
       0,   567,  1217,   568,   224,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,    49,  1218,   226,
     576,     0,     0,  1219,  1220,    52,  1221,    53,     0,     0,
       0,     0,  1222,  1223,   610,    79,    80,    81,   365,    83,
      84,  1225,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   611,    99,   100,
     101,   368,   612,     0,   103,   104,   105,   106,   613,   614,
       0,   108,   109,   110,     0,   111,   615,   616,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,  1167,     0,     0,   388,   389,     0,   390,   129,   391,
     392,   393,   131,  1168,   133,  1169,  1170,     0,   394,   395,
       0,   396,  1171,  1172,   397,  1173,  1174,   399,     0,   400,
     401,   402,   403,  1175,     0,     0,   404,   405,   406,   407,
       0,   408,   409,  1176,   410,     0,   411,   412,   413,   145,
     414,  1177,  1178,  1179,  1180,  1181,   415,   416,   417,   418,
     419,  1182,  1183,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,  1184,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
    1185,   438,     0,  1186,  1187,   439,   440,  1188,     0,   441,
       0,   442,   160,     0,   161,   443,     0,   444,     0,   445,
    1189,     0,   446,     0,   447,   448,   449,   165,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,   166,   167,
       0,   458,   459,   460,  1190,  1191,     0,  1192,     0,     0,
     171,   172,   461,   173,   462,   463,   464,   465,   466,     0,
    1193,   175,   467,   176,     0,   468,   469,   470,  1194,  1195,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,  1196,   182,  1197,   739,   482,   483,   484,   485,   486,
     487,   488,   184,   489,  1198,   490,   491,   186,   492,  1199,
    1200,  1201,   493,   494,     0,     0,   495,   740,     0,     0,
    1202,   497,     0,     0,   189,   190,   191,  1203,   498,   499,
     500,     0,  1204,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,  1205,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   201,   522,
     523,  1206,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,  1207,   533,   207,   534,   535,   209,   536,
    1208,     0,   537,   538,   539,   540,   541,   542,   543,   544,
    1209,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,  1210,  1211,     0,   553,     0,   554,  1212,   555,  1213,
    1214,   556,   557,   558,   559,   560,     0,  1215,   561,   562,
     563,   564,  1216,     0,   565,   566,     0,   567,  1217,   568,
     224,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,    49,  1218,   226,   576,     0,     0,  1219,
    1220,    52,  1221,    53,     0,     0,     0,     0,  1222,  1223,
     610,    79,    80,    81,   365,    83,    84,  1225,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   611,    99,   100,   101,   368,   612,     0,
     103,   104,   105,   106,   613,   614,     0,   108,   109,   110,
       0,   111,   615,   616,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,  1167,     0,     0,
     388,   389,     0,   390,   129,   391,   392,   393,   131,  1168,
     133,  1169,  1170,     0,   394,   395,     0,   396,  1171,  1172,
     397,  1173,  1174,   399,     0,   400,   401,   402,   403,  1175,
       0,     0,   404,   405,   406,   407,     0,   408,   409,  1176,
     410,     0,   411,   412,   413,   145,   414,  1177,  1178,  1179,
    1180,  1181,   415,   416,   417,   418,   419,  1182,  1183,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,  1184,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,  1185,   438,     0,  1186,
    1187,   439,   440,  1188,     0,   441,     0,   442,   160,     0,
     161,   443,     0,   444,     0,   445,  1189,     0,   446,     0,
     447,   448,   449,   165,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,   166,   167,     0,   458,   459,   460,
    1190,  1191,     0,  1192,     0,     0,   171,   172,   461,   173,
     462,   463,   464,   465,   466,     0,  1193,   175,   467,   176,
       0,   468,   469,   470,  1194,  1195,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,  1196,   182,  1197,
     739,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,   186,   492,  1199,  1200,  1201,   493,   494,
       0,     0,   495,   740,     0,     0,  1202,   497,     0,     0,
     189,   190,   191,  1203,   498,   499,   500,     0,  1204,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
    1205,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   201,   522,   523,  1206,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,  1207,
     533,   207,   534,   535,   209,   536,  1208,     0,   537,   538,
     539,   540,   541,   542,   543,   544,  1209,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,  1210,  1211,     0,
     553,     0,   554,  1212,   555,  1213,  1214,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,  1216,     0,
     565,   566,     0,   567,  1217,   568,   224,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,    49,
    1218,   226,   576,     0,     0,  1219,  1220,    52,  1221,    53,
       0,     0,     0,     0,     0,  2126,   610,    79,    80,    81,
     365,    83,    84,  1225,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   611,
      99,   100,   101,   368,   612,     0,   103,   104,   105,   106,
     613,   614,     0,   108,   109,   110,     0,   111,   615,   616,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,  1167,     0,     0,   388,   389,     0,   390,
     129,   391,   392,   393,     0,  1168,   133,  1169,  1170,     0,
     394,   395,     0,   396,  1171,  1172,   397,  1173,  1174,   399,
       0,   400,   401,   402,   403,  1175,     0,     0,   404,   405,
     406,   407,     0,   408,   409,  1176,   410,     0,   411,   412,
     413,   145,   414,  1177,  1178,  1179,  1180,  1181,   415,   416,
     417,   418,   419,  1182,  1183,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,  1184,
     429,   430,     0,   431,   432,   433,     0,     0,     0,   435,
     436,   437,  1185,   438,     0,  1186,  1187,   439,   440,  1188,
       0,   441,     0,   442,   160,     0,   161,   443,     0,   444,
       0,   445,  1189,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
     166,   167,     0,   458,   459,   460,  1190,  1191,     0,  1192,
       0,     0,   171,   172,   461,   173,   462,   463,   464,   465,
     466,     0,  1193,   175,   467,     0,     0,   468,   469,   470,
    1194,  1195,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,  1196,   182,  1197,   739,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,   186,
     492,  1199,  1200,  1201,   493,   494,     0,     0,   495,   740,
       0,     0,  1202,   497,     0,     0,   189,   190,   191,  1203,
     498,   499,   500,     0,  1204,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,  1205,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     201,   522,   523,  1206,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,  1207,   533,   207,   534,   535,
       0,   536,  1208,     0,   537,   538,   539,   540,   541,   542,
     543,   544,  1209,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,  1210,  1211,     0,   553,     0,   554,  1212,
     555,  1213,  1214,   556,   557,   558,   559,   560,     0,  1215,
     561,   562,   563,   564,  1216,     0,   565,   566,     0,   567,
    1217,   568,   224,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,    49,  1218,   226,   576,     0,
       0,  1219,  1220,    52,  1221,    53,     0,     0,     0,     0,
    1222,  1223,   610,    79,    80,    81,   365,    83,    84,  1225,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   611,    99,   100,   101,   368,
     612,     0,   103,   104,   105,   106,   613,   614,     0,   108,
     109,   110,     0,   111,   615,   616,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,  1167,
       0,     0,   388,   389,     0,   390,   129,   391,   392,   393,
       0,  1168,   133,  1169,  1170,     0,   394,   395,     0,   396,
    1171,  1172,   397,  1173,  1174,   399,     0,   400,   401,   402,
     403,  1175,     0,     0,   404,   405,   406,   407,     0,   408,
     409,  1176,   410,     0,   411,   412,   413,   145,   414,  1177,
    1178,  1179,  1180,  1181,   415,   416,   417,   418,   419,  1182,
    1183,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,  1184,   429,   430,     0,   431,
     432,   433,     0,     0,     0,   435,   436,   437,  1185,   438,
       0,  1186,  1187,   439,   440,  1188,     0,   441,     0,   442,
     160,     0,   161,   443,     0,   444,     0,   445,  1189,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,   166,   167,     0,   458,
     459,   460,  1190,  1191,     0,  1192,     0,     0,   171,   172,
     461,   173,   462,   463,   464,   465,   466,     0,  1193,   175,
     467,     0,     0,   468,   469,   470,  1194,  1195,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,  1196,
     182,  1197,   739,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,   186,   492,  1199,  1200,  1201,
     493,   494,     0,     0,   495,   740,     0,     0,     0,   497,
       0,     0,   189,   190,   191,  1203,   498,   499,   500,     0,
    1204,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,  1205,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   201,   522,   523,  1206,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,  1207,   533,   207,   534,   535,     0,   536,  1208,     0,
     537,   538,   539,   540,   541,   542,   543,   544,  1209,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,  1210,
    1211,     0,   553,     0,   554,  1212,   555,  1213,  1214,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
    1216,     0,   565,   566,     0,   567,  1217,   568,   224,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,    49,     0,   226,   576,     0,     0,  1219,  1220,    52,
    1221,    53,     0,     0,     0,     0,     0,  2126,     0,    79,
      80,    81,   365,    83,    84,  1225,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,  2451,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
    -829,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,  -829,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
    -829,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,  -829,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,     0,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,  -829,
     495,     0,     0,     0,   496,   497,     0,  -829,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,     0,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
    -829,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     4,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     5,   226,
       0,     0,     0,     0,     0,     0,     0,     6,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     7,     8,
       0,     0,  1302,     0,     0,     0,    10,    11,     0,     0,
       0,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    36,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    37,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    38,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    39,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    40,     0,     0,    41,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    43,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    44,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,    48,    49,     0,    50,     0,     0,     0,     0,
       0,    52,     0,    53,    54,     0,     0,     0,    55,    56,
      57,    58,    59,     0,     0,    60,    61,   971,    79,    80,
      81,   365,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   368,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,     0,   386,   387,
       0,     0,     0,     0,     0,     0,     0,   388,   389,     0,
     390,   129,   391,   392,   393,   131,   132,   133,   134,     0,
       0,   394,   395,     0,   396,     0,  1172,   397,   398,   135,
     399,     0,   400,   401,   402,   403,  1175,     0,     0,   404,
     405,   406,   407,     0,   408,   409,  1176,   410,     0,   411,
     412,   413,   145,   414,  1177,  1178,  1179,  1180,  1181,   415,
     416,   417,   418,   419,   148,   149,   420,     0,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
     428,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,   155,   438,     0,  1186,     0,   439,   440,
     159,     0,   441,     0,   442,   160,     0,   161,   443,     0,
     444,     0,   445,  1189,     0,   446,     0,   447,   448,   449,
     165,   450,   451,   452,     0,   453,   454,   455,   456,   457,
       0,   166,   167,     0,   458,   459,   460,     0,   169,     0,
     170,     0,     0,   171,   172,   461,   173,   462,   463,   464,
     465,   466,     0,  1193,   175,   467,   176,     0,   468,   469,
     470,  1194,  1195,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   181,   182,   183,   739,   482,   483,
     484,   485,   486,   487,   488,   184,   489,     0,   490,   491,
     186,   492,     0,  1200,   188,   493,   494,     0,     0,   495,
     740,     0,   907,   496,   497,     0,     0,   189,   190,   191,
    1203,   498,   499,   500,     0,  1204,   194,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,   196,   510,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   201,   522,   523,   203,   524,   525,   526,   527,   528,
     529,     0,   205,   530,   531,   532,  1207,   533,   207,   534,
     535,   209,   536,   210,     0,   537,   538,   539,   540,   541,
     542,   543,   544,  1209,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,   213,   214,     0,   553,     0,   554,
    1212,   555,  1213,     0,   556,   557,   558,   559,   560,     0,
       0,   561,   562,   563,   564,  1216,     0,   565,   566,     0,
     567,   223,   568,   224,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,     0,     0,   226,     0,
       0,     0,     0,     0,     0,    79,    80,    81,   365,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
    2025,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,   129,   391,
     392,   393,   131,   132,   133,   134,     0,     0,   394,   395,
       0,   396,     0,  1172,   397,   398,   135,   399,     0,   400,
     401,   402,   403,  1175,     0,     0,   404,   405,   406,   407,
       0,   408,   409,  1176,   410,     0,   411,   412,   413,   145,
     414,  1177,  1178,  1179,  1180,  1181,   415,   416,   417,   418,
     419,   148,   149,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,  1186,     0,   439,   440,   159,     0,   441,
       0,   442,   160,     0,   161,   443,     0,   444,     0,   445,
    1189,     0,   446,     0,   447,   448,   449,   165,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,   166,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
     171,   172,   461,   173,   462,   463,   464,   465,   466,     0,
    1193,   175,   467,   176,     0,   468,   469,   470,  1194,  1195,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,   182,   183,   739,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,   186,   492,     0,
    1200,   188,   493,   494,     0,     0,   495,   740,     0,   907,
     496,   497,     0,     0,   189,   190,   191,  1203,   498,   499,
     500,     0,  1204,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   201,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,  1207,   533,   207,   534,   535,   209,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
    1209,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,  1212,   555,  1213,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,  1216,     0,   565,   566,     0,   567,   223,   568,
     224,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,     0,     0,     0,     0,
       0,     0,    79,    80,    81,   365,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,  2025,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   368,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,   129,   391,   392,   393,   131,
     132,   133,   134,     0,     0,   394,   395,     0,   396,     0,
    1172,   397,   398,   135,   399,     0,   400,   401,   402,   403,
    1175,     0,     0,   404,   405,   406,   407,     0,   408,   409,
    1176,   410,     0,   411,   412,   413,   145,   414,  1177,  1178,
    1179,  1180,  1181,   415,   416,   417,   418,   419,   148,   149,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,   428,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,   155,   438,     0,
    1186,     0,   439,   440,   159,     0,   441,     0,   442,   160,
       0,   161,   443,     0,   444,     0,   445,  1189,     0,   446,
       0,   447,   448,   449,   165,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,   166,   167,     0,   458,   459,
     460,     0,   169,     0,   170,     0,     0,   171,   172,   461,
     173,   462,   463,   464,   465,   466,     0,  1193,   175,   467,
     176,     0,   468,   469,   470,  1194,  1195,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   181,   182,
     183,   739,   482,   483,   484,   485,   486,   487,   488,   184,
     489,     0,   490,   491,   186,   492,     0,  1200,   188,   493,
     494,     0,     0,   495,   740,     0,     0,   496,   497,     0,
       0,   189,   190,   191,  1203,   498,   499,   500,     0,  1204,
     194,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,   196,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   201,   522,   523,   203,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
    1207,   533,   207,   534,   535,   209,   536,   210,     0,   537,
     538,   539,   540,   541,   542,   543,   544,  1209,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,   213,   214,
       0,   553,     0,   554,  1212,   555,  1213,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,  1216,
       0,   565,   566,     0,   567,   223,   568,   224,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
       0,     0,   226,     0,     0,     0,     0,     0,     0,    79,
      80,    81,   365,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,  3147,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,     0,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,     0,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,     0,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,    49,     0,   226,
     576,     0,     0,     0,     0,    52,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2386,  2387,    79,    80,    81,   365,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   368,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
     132,     0,   134,     0,     0,   394,   395,     0,   396,     0,
       0,   397,   398,   135,   399,     0,   400,   401,   402,   403,
     139,     0,     0,   404,   405,   406,   407,     0,   408,   409,
     142,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,   148,   149,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,   428,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,   155,   438,     0,
     157,     0,   439,   440,   159,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,   164,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,   167,     0,   458,   459,
     460,     0,   169,     0,   170,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   174,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   181,     0,
     183,     0,   482,   483,   484,   485,   486,   487,   488,   184,
     489,     0,   490,   491,     0,   492,     0,   187,   188,   493,
     494,     0,     0,   495,     0,     0,     0,   496,   497,     0,
       0,   189,     0,     0,   192,   498,   499,   500,     0,   193,
     194,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,   196,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,   203,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,   207,   534,   535,     0,   536,   210,     0,   537,
     538,   539,   540,   541,   542,   543,   544,   212,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,   213,   214,
       0,   553,     0,   554,   215,   555,   216,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,   223,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
      49,     0,   226,   576,     0,     0,     0,     0,    52,    79,
      80,    81,   365,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,  2387,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,   739,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,   740,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,     0,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
       0,     0,     0,     0,     0,     0,    79,    80,    81,   365,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,  1296,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   368,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,     0,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     391,   392,   393,     0,   132,     0,   134,     0,     0,   394,
     395,     0,   396,     0,     0,   397,   398,   135,   399,     0,
     400,   401,   402,   403,   139,     0,     0,   404,   405,   406,
     407,     0,   408,   409,   142,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,   148,   149,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,   428,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,   155,   438,     0,   157,     0,   439,   440,   159,     0,
     441,     0,   442,     0,     0,     0,   443,     0,   444,     0,
     445,   164,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,     0,
     167,     0,   458,   459,   460,     0,   169,     0,   170,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   174,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   181,     0,   183,     0,   482,   483,   484,   485,
     486,   487,   488,   184,   489,     0,   490,   491,     0,   492,
       0,   187,   188,   493,   494,     0,     0,   495,     0,     0,
       0,   496,   497,     0,     0,   189,     0,     0,   192,   498,
     499,   500,     0,   193,   194,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,   196,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   523,   203,   524,   525,   526,   527,   528,   529,     0,
     205,   530,   531,   532,     0,   533,   207,   534,   535,     0,
     536,   210,     0,   537,   538,   539,   540,   541,   542,   543,
     544,   212,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,   213,   214,     0,   553,     0,   554,   215,   555,
     216,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,     0,   565,   566,     0,   567,   223,
     568,     0,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,   576,     0,     0,
       0,     0,     0,    79,    80,    81,   365,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,   227,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,     0,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,   205,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   554,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,     0,     0,     0,     0,     0,     0,
      79,    80,    81,   365,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,   227,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   368,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,     0,
     386,   387,     0,     0,     0,     0,     0,     0,     0,   388,
     389,     0,   390,     0,   391,   392,   393,     0,   132,     0,
     134,     0,     0,   394,   395,     0,   396,     0,     0,   397,
     398,   135,   399,     0,   400,   401,   402,   403,   139,     0,
       0,   404,   405,   406,   407,     0,   408,   409,   142,   410,
       0,   411,   412,   413,     0,   414,     0,     0,     0,     0,
       0,   415,   416,   417,   418,   419,   148,   149,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,   428,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,   155,   438,     0,   157,     0,
     439,   440,   159,     0,   441,     0,   442,     0,     0,     0,
     443,     0,   444,     0,   445,   164,     0,   446,     0,   447,
     448,   449,     0,   450,   451,   452,     0,   453,   454,   455,
     456,   457,     0,     0,   167,     0,   458,   459,   460,     0,
     169,     0,   170,     0,     0,     0,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   174,     0,   467,     0,     0,
     468,   469,   470,     0,     0,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   181,     0,   183,     0,
     482,   483,   484,   485,   486,   487,   488,   184,   489,     0,
     490,   491,     0,   492,     0,   187,   188,   493,   494,     0,
       0,   495,     0,     0,     0,   496,   497,     0,     0,   189,
       0,     0,   192,   498,   499,   500,     0,   193,   194,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,   196,
     510,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,   523,   203,   524,   525,   526,
     527,   528,   529,     0,     0,   530,   531,   532,     0,   533,
     207,   534,   535,     0,   536,   210,     0,   537,   538,   539,
     540,   541,   542,   543,   544,   212,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,   213,   214,     0,   553,
       0,   554,   215,   555,   216,     0,   556,   557,   558,   559,
     560,     0,     0,   561,   562,   563,   564,     0,     0,   565,
     566,     0,   567,   223,   568,     0,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,     0,     0,
     226,     0,     0,     0,     0,     0,     0,    79,    80,    81,
     365,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,  1747,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,     0,     0,
       0,     0,     0,   610,    79,    80,    81,   365,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,  2823,
      93,    94,    95,    96,    97,    98,   611,    99,   100,   101,
     368,   612,     0,   103,   104,   105,   106,   613,   614,     0,
     108,   109,   110,     0,   111,   615,   616,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,  1475,     0,  1476,  1170,     0,   394,   395,     0,
     396,     0,     0,   397,  1477,  1478,   399,     0,   400,   401,
     402,   403,     0,     0,     0,   404,   405,   406,   407,     0,
     408,   409,     0,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
    1479,  1480,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,  1184,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,     0,
     438,     0,     0,     0,   439,   440,  1481,     0,   441,     0,
     442,     0,     0,     0,   443,     0,   444,     0,   445,     0,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,     0,     0,
     458,   459,   460,  1190,  1482,     0,  1483,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   466,     0,     0,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
    1484,     0,  1485,     0,   482,   483,   484,   485,   486,   487,
     488,     0,   489,     0,   490,   491,     0,   492,     0,     0,
    1486,   493,   494,     0,     0,   495,     0,     0,     0,  2725,
     497,     0,     0,     0,     0,     0,     0,   498,   499,   500,
       0,     0,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,  1487,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
       0,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,     0,   533,  1488,   534,   535,     0,   536,  1489,
       0,   537,   538,   539,   540,   541,   542,   543,   544,     0,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
    1490,  1491,     0,   553,     0,   554,     0,   555,     0,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,  1492,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,    49,  1018,   226,   576,     0,     0,     0,     0,
      52,     0,    53,  1019,  1020,  1021,     0,  1022,  2726,  1024,
    1025,  1026,  1027,    79,    80,    81,   365,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,  1017,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,     0,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   554,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,  1018,   226,     0,     0,     0,     0,     0,     0,
       0,     0,  1019,  1020,  1021,     0,  1022,  1023,  1024,  1025,
    1026,  1027,    79,    80,    81,   365,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   368,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
     132,     0,   134,     0,     0,   394,   395,     0,   396,     0,
       0,   397,   398,   135,   399,     0,   400,   401,   402,   403,
     139,     0,     0,   404,   405,   406,   407,     0,   408,   409,
     142,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,   148,   149,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,   428,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,   155,   438,     0,
     157,     0,   439,   440,   159,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,   164,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,   167,     0,   458,   459,
     460,     0,   169,     0,   170,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   174,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   181,     0,
     183,     0,   482,   483,   484,   485,   486,   487,   488,   184,
     489,     0,   490,   491,     0,   492,     0,   187,   188,   493,
     494,     0,     0,   495,     0,     0,     0,   496,   497,     0,
       0,   189,     0,     0,   192,   498,   499,   500,     0,   193,
     194,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,   196,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,   203,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,   207,   534,   535,     0,   536,   210,     0,   537,
     538,   539,   540,   541,   542,   543,   544,   212,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,   213,   214,
       0,   553,     0,   554,   215,   555,   216,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,   223,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
       0,  1018,   226,     0,     0,     0,     0,     0,     0,     0,
       0,  1019,  1020,  1021,     0,  1022,  1023,  1024,  1025,  1026,
    1027,   610,    79,    80,    81,   365,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   611,    99,   100,   101,   368,   612,
       0,   103,   104,   105,   106,   613,   614,     0,   108,   109,
     110,     0,   111,   615,   616,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,   617,   386,   387,   618,   619,   620,   621,   622,   623,
     624,   388,   389,   625,   390,   129,   391,   392,   393,   131,
     132,   133,   134,     0,   626,   394,   395,     0,   396,   627,
     628,   397,   629,   135,   399,   630,   400,   401,   402,   403,
     139,   631,   632,   404,   405,   406,   407,   633,   408,   409,
     142,   410,   634,   411,   412,   413,   145,   414,   635,   636,
     637,   638,   639,   415,   416,   417,   418,   419,   148,   149,
     420,   640,   421,   641,   422,     0,   423,   424,   425,   642,
     426,   643,   644,   427,   428,   429,   430,   645,   431,   432,
     433,   646,   434,   647,   435,   436,   437,   155,   438,     0,
     157,   648,   439,   440,   159,   649,   441,   650,   442,   160,
     651,   161,   443,     0,   444,   652,   445,   164,   653,   446,
     654,   447,   448,   449,   165,   450,   451,   452,   655,   453,
     454,   455,   456,   457,   656,   166,   167,   657,   458,   459,
     460,   658,   169,   659,   170,   660,     0,   171,   172,   461,
     173,   462,   463,   464,   465,   466,   661,   174,   175,   467,
     176,   662,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   181,   182,
     183,   663,   482,   483,   484,   485,   486,   487,   488,   184,
     489,   664,   490,   491,   186,   492,   665,   187,   188,   493,
     494,   666,   667,   495,   668,   669,   670,   496,   497,   671,
     672,   189,   190,   191,   192,   498,   499,   500,     0,   193,
     194,   501,   502,   503,   673,   504,   505,   506,   507,   508,
     509,   196,   510,   674,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   201,   522,   523,   203,   524,
     525,   526,   527,   528,   529,     0,   675,   530,   531,   532,
     676,   533,   207,   534,   535,   209,   536,   210,   677,   537,
     538,   539,   540,   541,   542,   543,   544,   212,   545,   678,
     546,   547,   679,   548,   549,   550,   551,   680,   213,   214,
     681,   553,   682,   554,   215,   555,   216,   683,   556,   557,
     558,   559,   560,   684,   685,   561,   562,   563,   564,   686,
     687,   565,   566,     0,   567,   223,   568,   224,   569,     0,
     688,   689,   570,   571,   572,   573,   574,   575,     0,   225,
       0,     0,   226,   610,    79,    80,    81,   365,    83,    84,
       0,    85,    86,    87,   366,     0,   367,  1455,    91,     0,
      93,    94,    95,    96,    97,    98,   611,    99,   100,   101,
     368,   612,     0,   103,   104,   105,   106,   613,   614,     0,
     108,   109,   110,     0,   111,   615,   616,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,  1475,     0,  1476,  1170,     0,   394,   395,     0,
     396,     0,     0,   397,  1477,  1478,   399,     0,   400,   401,
     402,   403,     0,     0,     0,   404,   405,   406,   407,     0,
     408,   409,     0,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
    1479,  1480,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,  1184,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,     0,
     438,     0,     0,     0,   439,   440,  1481,     0,   441,     0,
     442,     0,     0,     0,   443,     0,   444,     0,   445,     0,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,     0,     0,
     458,   459,   460,  1190,  1482,     0,  1483,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   466,     0,     0,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
    1484,     0,  1485,     0,   482,   483,   484,   485,   486,   487,
     488,     0,   489,     0,   490,   491,     0,   492,     0,     0,
    1486,   493,   494,     0,     0,   495,     0,     0,     0,   496,
     497,     0,     0,     0,     0,     0,     0,   498,   499,   500,
       0,     0,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,  1487,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
       0,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,     0,   533,  1488,   534,   535,     0,   536,  1489,
       0,   537,   538,   539,   540,   541,   542,   543,   544,     0,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
    1490,  1491,     0,   553,     0,   554,     0,   555,     0,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,  1492,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,     0,    79,    80,    81,   365,
      83,    84,     0,    85,    86,    87,   366,     0,   367,  1818,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   368,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,     0,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     391,   392,   393,     0,   132,     0,   134,     0,     0,   394,
     395,     0,   396,     0,     0,   397,   398,   135,   399,     0,
     400,   401,   402,   403,   139,     0,     0,   404,   405,   406,
     407,     0,   408,   409,   142,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,   148,   149,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,   428,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,   155,   438,     0,   157,     0,   439,   440,   159,     0,
     441,     0,   442,     0,     0,     0,   443,     0,   444,     0,
     445,   164,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,     0,
     167,     0,   458,   459,   460,     0,   169,     0,   170,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   174,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   181,     0,   183,   739,   482,   483,   484,   485,
     486,   487,   488,   184,   489,     0,   490,   491,     0,   492,
       0,   187,   188,   493,   494,     0,     0,   495,   740,     0,
       0,   496,   497,     0,     0,   189,     0,     0,   192,   498,
     499,   500,     0,   193,   194,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,   196,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   523,   203,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,     0,   533,   207,   534,   535,     0,
     536,   210,     0,   537,   538,   539,   540,   541,   542,   543,
     544,   212,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,   213,   214,     0,   553,     0,   554,   215,   555,
     216,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,     0,   565,   566,     0,   567,   223,
     568,     0,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,     0,    79,    80,
      81,   365,    83,    84,     0,    85,    86,    87,   366,     0,
     367,   905,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   368,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,     0,   386,   387,
       0,     0,     0,     0,     0,     0,     0,   388,   389,     0,
     390,     0,   391,   392,   393,     0,   132,     0,   134,     0,
       0,   394,   395,     0,   396,     0,     0,   397,   398,   135,
     399,     0,   400,   401,   402,   403,   139,     0,     0,   404,
     405,   406,   407,     0,   408,   409,   142,   410,     0,   411,
     412,   413,     0,   414,     0,     0,     0,     0,     0,   415,
     416,   417,   418,   419,   148,   149,   420,  1732,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
     428,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,   155,   438,     0,   157,  1733,   439,   440,
     159,     0,   441,     0,   442,     0,     0,     0,   443,     0,
     444,     0,   445,   164,     0,   446,     0,   447,   448,   449,
       0,   450,   451,   452,     0,   453,   454,   455,   456,   457,
       0,     0,   167,     0,   458,   459,   460,     0,   169,     0,
     170,     0,     0,     0,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   174,     0,   467,     0,     0,   468,   469,
     470,     0,     0,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   181,     0,   183,     0,   482,   483,
     484,   485,   486,   487,   488,   184,   489,     0,   490,   491,
       0,   492,     0,   187,   188,   493,   494,  1734,     0,   495,
       0,  1735,     0,   496,   497,     0,     0,   189,     0,     0,
     192,   498,   499,   500,     0,   193,   194,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,   196,   510,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,     0,   522,   523,   203,   524,   525,   526,   527,   528,
     529,     0,     0,   530,   531,   532,     0,   533,   207,   534,
     535,     0,   536,   210,     0,   537,   538,   539,   540,   541,
     542,   543,   544,   212,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,   213,   214,     0,   553,     0,   554,
     215,   555,   216,  1736,   556,   557,   558,   559,   560,     0,
       0,   561,   562,   563,   564,     0,     0,   565,   566,     0,
     567,   223,   568,     0,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,    49,     0,   226,   576,
       0,     0,     0,     0,    52,     0,    53,     0,     0,     0,
       0,     0,  1331,    79,    80,    81,   365,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,  1733,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,     0,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,  1734,     0,   495,     0,  1735,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   554,   215,   555,   216,  1736,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,    49,     0,   226,   576,     0,     0,     0,     0,    52,
       0,    53,     0,     0,     0,     0,     0,  1331,    79,    80,
      81,   365,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   368,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     815,   380,   381,   382,   383,   384,   385,   816,   386,   387,
       0,     0,     0,     0,     0,     0,     0,   388,   389,     0,
     390,     0,   817,   392,   393,     0,   132,     0,   134,     0,
       0,   394,   395,     0,   396,     0,     0,   397,   398,   135,
     399,     0,   400,   401,   402,   403,   139,     0,     0,   404,
     405,   406,   407,     0,   408,   409,   142,   410,     0,   411,
     412,   413,     0,   414,     0,     0,     0,     0,     0,   415,
     416,   417,   418,   419,   148,   149,   420,     0,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
     428,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,   155,   438,     0,   157,     0,   439,   818,
     159,     0,   441,     0,   819,     0,   820,     0,   443,     0,
     444,     0,   445,   164,     0,   446,     0,   447,   448,   449,
       0,   450,   451,   452,   821,   453,   454,   455,   456,   457,
       0,     0,   167,     0,   458,   459,   460,     0,   169,     0,
     170,     0,     0,     0,     0,   461,     0,   462,   463,   464,
     465,   822,     0,   174,     0,   467,     0,     0,   468,   469,
     470,     0,     0,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   181,     0,   183,     0,   823,   483,
     484,   485,   486,   487,   488,   184,   489,     0,   490,   491,
       0,   492,     0,   187,   188,   493,   494,     0,     0,   495,
       0,     0,     0,   496,   497,     0,     0,   189,     0,     0,
     192,   498,   499,   500,     0,   193,   194,   501,   502,   503,
       0,   824,   505,   506,   507,   508,   509,   196,   510,     0,
     511,   825,   513,   514,   515,   516,   517,   518,   519,   520,
     521,     0,   522,   523,   203,   524,   525,   526,   527,   528,
     529,     0,     0,   530,   531,   532,     0,   533,   207,   534,
     535,     0,   536,   210,     0,   537,   538,   539,   540,   541,
     542,   543,   544,   212,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,   213,   214,     0,   553,     0,   554,
     215,   555,   216,     0,   556,   557,   558,   559,   560,     0,
       0,   561,   562,   563,   564,     0,     0,   565,   566,     0,
     567,   223,   568,     0,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,     0,     0,   226,   576,
       0,     0,     0,     0,    52,     0,    79,    80,    81,   365,
      83,    84,   826,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   368,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   815,   380,
     381,   382,   383,   384,   385,   816,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     817,   392,   393,     0,   132,     0,   134,     0,     0,   394,
     395,     0,   396,     0,     0,   397,   398,   135,   399,     0,
     400,   401,   402,   403,   139,     0,     0,   404,   405,   406,
     407,     0,   408,   409,   142,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,   148,   149,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,   428,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,   155,   438,     0,   157,     0,   439,   818,   159,     0,
     441,     0,   819,     0,     0,     0,   443,     0,   444,     0,
     445,   164,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,     0,
     167,     0,   458,   459,   460,     0,   169,     0,   170,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   822,
       0,   174,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   181,     0,   183,     0,   823,   483,   484,   485,
     486,   487,   488,   184,   489,     0,   490,   491,     0,   492,
       0,   187,   188,   493,   494,     0,     0,   495,     0,     0,
       0,   496,   497,     0,     0,   189,     0,     0,   192,   498,
     499,   500,     0,   193,   194,   501,   502,   503,     0,   824,
     505,   506,   507,   508,   509,   196,   510,     0,   511,   825,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   523,   203,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,     0,   533,   207,   534,   535,     0,
     536,   210,     0,   537,   538,   539,   540,   541,   542,   543,
     544,   212,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,   213,   214,     0,   553,     0,   554,   215,   555,
     216,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,     0,   565,   566,     0,   567,   223,
     568,     0,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,   576,     0,     0,
       0,     0,    52,     0,    79,    80,    81,   365,    83,    84,
     826,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     368,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,   132,     0,   134,     0,     0,   394,   395,     0,
     396,     0,     0,   397,   398,   135,   399,     0,   400,   401,
     402,   403,   139,     0,     0,   404,   405,   406,   407,     0,
     408,   409,   142,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
     148,   149,   420,   600,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,   428,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,   155,
     438,     0,   157,     0,   439,   440,   159,     0,   441,     0,
     442,     0,     0,     0,   443,     0,   444,     0,   445,   164,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,   167,     0,
     458,   459,   460,     0,   169,     0,   170,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   174,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     181,     0,   183,     0,   482,   483,   484,   485,   486,   487,
     488,   184,   489,     0,   490,   491,     0,   492,     0,   187,
     188,   493,   494,     0,     0,   495,     0,     0,     0,   496,
     497,     0,     0,   189,     0,     0,   192,   498,   499,   500,
       0,   193,   194,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,   196,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
     203,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,     0,   533,   207,   534,   535,     0,   536,   210,
       0,   537,   538,   539,   540,   541,   542,   543,   544,   212,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
     213,   214,  1269,   553,     0,   554,   215,   555,   216,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,   223,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,   576,     0,    79,    80,    81,
     365,    83,    84,  1270,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,    49,     0,   226,   576,     0,
       0,  1219,  1220,    52,     0,    53,    79,    80,    81,   365,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   368,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,     0,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     391,   392,   393,     0,   132,     0,   134,     0,     0,   394,
     395,     0,   396,     0,     0,   397,   398,   135,   399,     0,
     400,   401,   402,   403,   139,     0,     0,   404,   405,   406,
     407,     0,   408,   409,   142,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,   148,   149,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,   428,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,   155,   438,     0,   157,     0,   439,   440,   159,     0,
     441,     0,   442,     0,     0,     0,   443,     0,   444,     0,
     445,   164,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,     0,
     167,     0,   458,   459,   460,     0,   169,     0,   170,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   174,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   181,     0,   183,     0,   482,   483,   484,   485,
     486,   487,   488,   184,   489,     0,   490,   491,     0,   492,
       0,   187,   188,   493,   494,     0,     0,   495,     0,     0,
       0,   496,   497,     0,     0,   189,     0,     0,   192,   498,
     499,   500,     0,   193,   194,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,   196,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   523,   203,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,     0,   533,   207,   534,   535,     0,
     536,   210,     0,   537,   538,   539,   540,   541,   542,   543,
     544,   212,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,   213,   214,     0,   553,     0,   554,   215,   555,
     216,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,     0,   565,   566,     0,   567,   223,
     568,     0,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,     0,   884,  1350,
      79,    80,    81,   365,    83,    84,     0,    85,    86,    87,
     366,   885,   367,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   368,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,     0,
     386,   387,     0,     0,     0,     0,     0,     0,     0,   388,
     389,     0,   390,     0,   391,   392,   393,     0,   132,     0,
     134,     0,     0,   394,   395,     0,   396,     0,     0,   397,
     863,   135,   399,     0,   400,   401,   402,   403,   139,     0,
       0,   404,   405,   406,   886,     0,   887,   409,   142,   410,
       0,   411,   412,   413,     0,   414,     0,     0,     0,     0,
       0,   415,   416,   417,   418,   419,   148,   149,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,   428,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,   155,   438,     0,   157,     0,
     439,   440,   159,     0,   441,     0,   442,     0,     0,     0,
     443,     0,   444,     0,   445,   164,     0,   446,     0,   447,
     448,   449,     0,   450,   451,   452,     0,   453,   454,   455,
     456,   457,     0,     0,   167,     0,   458,   459,   460,     0,
     169,     0,   170,     0,     0,     0,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   174,     0,   467,     0,     0,
     468,   469,   888,     0,     0,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   889,   181,     0,   183,     0,
     482,   483,   484,   485,   486,   487,   488,   184,   489,     0,
     490,   491,     0,   492,     0,   187,   188,   493,   494,     0,
       0,   495,     0,     0,     0,   496,   497,     0,     0,   189,
       0,     0,   192,   498,   499,   500,     0,   193,   194,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,   196,
     510,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   890,   523,   203,   524,   525,   526,
     527,   528,   529,     0,     0,   530,   531,   891,     0,   533,
     207,   534,   535,     0,   536,   210,     0,   537,   538,   539,
     540,   541,   542,   543,   544,   212,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,   892,   214,     0,   553,
       0,   893,   215,   555,   216,     0,   556,   557,   558,   559,
     560,     0,     0,   561,   562,   563,   564,     0,     0,   565,
     566,     0,   567,   223,   568,     0,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,     0,     0,
     226,    79,    80,    81,     0,    83,    84,     0,    85,    86,
      87,     0,     0,     0,    90,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,     0,     0,     0,
     103,   104,   105,   106,     0,   107,     0,   108,   109,   110,
   -1351,   111,   112,   113,   114,     0,     0,     0,     0,     0,
     117,   118,     0,     0,     0,     0,   119,     0,     0,     0,
       0,     0,     0,     0,     0,   120,     0,   121,     0,   122,
     123,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   129,     0,     0,     0,   131,   132,
     133,   134,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   135,     0,     0,     0,     0,     0,     0,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   142,
       0,     0,     0,     0,     0,   145,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   148,   149,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   155,     0,     0,   157,
       0,     0,     0,   159,     0,     0,     0,     0,   160,     0,
     161,     0,     0,     0,     0,     0,   164,     0,     0,     0,
       0,     0,     0,   165,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   166,   167,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,   171,   172,     0,   173,
       0,     0,     0,     0,     0,     0,   174,   175,     0,   176,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   181,   182,   183,
       0,     0,     0,     0,     0,     0,     0,     0,   184,     0,
       0,     0,     0,   186,     0,     0,   187,   188,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     189,   190,   191,   192,     0,     0,     0,     0,   193,   194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   201,     0,     0,   203,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   207,     0,     0,   209,     0,   210,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   212,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   213,   214,     0,
       0,     0,     0,   215,     0,   216,     0,     0,     0,     0,
       0,     0,   219,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   225,     0,
       0,   226,     0,   356,    79,    80,    81,     0,    83,    84,
       0,    85,    86,    87,     0,     0,     0,    90,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
       0,     0,     0,   103,   104,   105,   106,     0,   107,     0,
     108,   109,   110, -1352,   111,   112,   113,   114,     0,     0,
       0,     0,     0,   117,   118,     0,     0,     0,     0,   119,
       0,     0,     0,     0,     0,     0,     0,     0,   120,     0,
     121,     0,   122,   123,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   129,     0,     0,
       0,   131,   132,   133,   134,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   135,     0,     0,     0,     0,
       0,     0,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   142,     0,     0,     0,     0,     0,   145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     148,   149,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   155,
       0,     0,   157,     0,     0,     0,   159,     0,     0,     0,
       0,   160,     0,   161,     0,     0,     0,     0,     0,   164,
       0,     0,     0,     0,     0,     0,   165,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   166,   167,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,   171,
     172,     0,   173,     0,     0,     0,     0,     0,     0,   174,
     175,     0,   176,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     181,   182,   183,     0,     0,     0,     0,     0,     0,     0,
       0,   184,     0,     0,     0,     0,   186,     0,     0,   187,
     188,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   189,   190,   191,   192,     0,     0,     0,
       0,   193,   194,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   196,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   201,     0,     0,
     203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   207,     0,     0,   209,     0,   210,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   212,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     213,   214,     0,     0,     0,     0,   215,     0,   216,     0,
       0,     0,     0,     0,     0,   219,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   225,     0,     0,   226,     0,   950,   610,    79,    80,
      81,   365,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     611,    99,   100,   101,   368,   612,     0,   103,   104,   105,
     106,   613,   614,     0,   108,   109,   110,     0,   111,   615,
     616,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,   617,   386,   387,
     618,   619,   620,   621,   622,   623,   624,   388,   389,   625,
     390,   129,   391,   392,   393,   131,   132,   133,   134,     0,
     626,   394,   395,     0,   396,   627,   628,   397,   629,   135,
     399,   630,   400,   401,   402,   403,   139,   631,   632,   404,
     405,   406,   407,   633,   408,   409,   142,   410,   634,   411,
     412,   413,   145,   414,   635,   636,   637,   638,   639,   415,
     416,   417,   418,   419,   148,   149,   420,   640,   421,   641,
     422,     0,   423,   424,   425,   642,   426,   643,   644,   427,
     428,   429,   430,   645,   431,   432,   433,   646,   434,   647,
     435,   436,   437,   155,   438,     0,   157,   648,   439,   440,
     159,   649,   441,   650,   442,   160,   651,   161,   443,     0,
     444,   652,   445,   164,   653,   446,   654,   447,   448,   449,
     165,   450,   451,   452,   655,   453,   454,   455,   456,   457,
     656,   166,   167,   657,   458,   459,   460,   658,   169,   659,
     170,   660,     0,   171,   172,   461,   173,   462,   463,   464,
     465,   466,   661,   174,   175,   467,   176,   662,   468,   469,
     470,     0,     0,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   181,   182,   183,   663,   482,   483,
     484,   485,   486,   487,   488,   184,   489,   664,   490,   491,
     186,   492,   665,   187,   188,   493,   494,   666,   667,   495,
     668,   669,   670,   496,   497,   671,   672,   189,   190,   191,
     192,   498,   499,   500,     0,   193,   194,   501,   502,   503,
     673,   504,   505,   506,   507,   508,   509,   196,   510,   674,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   201,   522,   523,   203,   524,   525,   526,   527,   528,
     529,     0,   675,   530,   531,   532,   676,   533,   207,   534,
     535,   209,   536,   210,   677,   537,   538,   539,   540,   541,
     542,   543,   544,   212,   545,   678,   546,   547,   679,   548,
     549,   550,   551,   680,   213,   214,   681,   553,   682,   554,
     215,   555,   216,   683,   556,   557,   558,   559,   560,   684,
     685,   561,   562,   563,   564,   686,   687,   565,   566,     0,
     567,   223,   568,   224,   569,     0,   688,   689,   570,   571,
     572,   573,   574,   575,     0,   225,     0,     0,   226,   610,
      79,    80,    81,   365,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   611,    99,   100,   101,   368,   612,     0,   103,
     104,   105,   106,   613,   614,     0,   108,   109,   110,     0,
     111,   615,   616,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,     0,
     386,   387,     0,     0,     0,     0,     0,     0,     0,   388,
     389,     0,   390,   129,   391,   392,   393,   131,  1475,   133,
    1476,  1170,     0,   394,   395,     0,   396,     0,     0,   397,
    1477,  1478,   399,     0,   400,   401,   402,   403,     0,     0,
       0,   404,   405,   406,   407,     0,   408,   409,     0,   410,
       0,   411,   412,   413,   145,   414,     0,     0,     0,     0,
       0,   415,   416,   417,   418,   419,  1479,  1480,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,  1184,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,     0,   438,     0,     0,     0,
     439,   440,  1481,     0,   441,     0,   442,   160,     0,   161,
     443,     0,   444,     0,   445,     0,     0,   446,     0,   447,
     448,   449,   165,   450,   451,   452,  1851,   453,   454,   455,
     456,   457,     0,   166,  1852,     0,   458,   459,   460,  1190,
    1482,     0,  1483,     0,     0,   171,   172,   461,   173,   462,
     463,   464,   465,   466,     0,     0,   175,   467,   176,     0,
     468,   469,   470,     0,     0,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,  1484,   182,  1485,     0,
     482,   483,   484,   485,   486,   487,   488,     0,   489,     0,
     490,   491,   186,   492,     0,     0,  1486,   493,   494,     0,
       0,   495,     0,     0,     0,   496,   497,     0,     0,  1853,
     190,   191,     0,   498,   499,   500,     0,     0,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,  1487,
     510,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   201,   522,   523,     0,   524,   525,   526,
     527,   528,   529,     0,     0,   530,   531,   532,     0,   533,
    1488,   534,   535,   209,   536,  1489,     0,   537,   538,   539,
     540,   541,   542,   543,   544,     0,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,  1490,  1491,     0,   553,
       0,   554,     0,   555,     0,     0,   556,   557,   558,   559,
     560,     0,     0,   561,   562,   563,   564,     0,     0,   565,
     566,     0,   567,  1492,   568,   224,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,     0,     0,
     226,   610,    79,    80,    81,   365,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   611,    99,   100,   101,   368,   612,
       0,   103,   104,   105,   106,   613,   614,     0,   108,   109,
     110,     0,   111,   615,   616,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,   129,   391,   392,   393,   131,
    1475,   133,  1476,  1170,     0,   394,   395,     0,   396,     0,
       0,   397,  1477,  1478,   399,     0,   400,   401,   402,   403,
       0,     0,     0,   404,   405,   406,   407,     0,   408,   409,
       0,   410,     0,   411,   412,   413,   145,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,  1479,  1480,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,  1184,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,     0,   438,     0,
       0,     0,   439,   440,  1481,     0,   441,     0,   442,   160,
       0,   161,   443,     0,   444,     0,   445,     0,     0,   446,
       0,   447,   448,   449,   165,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,   166,     0,     0,   458,   459,
     460,  1190,  1482,     0,  1483,     0,     0,   171,   172,   461,
     173,   462,   463,   464,   465,   466,     0,     0,   175,   467,
     176,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,  1484,   182,
    1485,     0,   482,   483,   484,   485,   486,   487,   488,     0,
     489,     0,   490,   491,   186,   492,     0,     0,  1486,   493,
     494,     0,     0,   495,     0,     0,     0,   496,   497,     0,
       0,     0,   190,   191,     0,   498,   499,   500,     0,     0,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,  1487,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   201,   522,   523,     0,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,  1488,   534,   535,   209,   536,  1489,     0,   537,
     538,   539,   540,   541,   542,   543,   544,     0,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,  1490,  1491,
       0,   553,     0,   554,     0,   555,     0,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,  1492,   568,   224,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
       0,     0,   226,    79,    80,    81,   365,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,  1362,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,  2196,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,  2197,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,   739,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,   740,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,  2198,   548,  2199,   550,  2200,     0,   213,
     214,     0,   553,     0,   554,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,   576,    79,    80,    81,   365,    83,
      84,   598,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,   599,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,   600,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,   576,    79,    80,    81,
     365,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,   552,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,    49,     0,   226,   576,    79,
      80,    81,   365,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,  1723,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,     0,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,     0,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,     0,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,    49,     0,   226,
     576,    79,    80,    81,   365,    83,    84,     0,    85,    86,
      87,   366,   779,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   780,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
       0,   226,   576,    79,    80,    81,   365,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,   959,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,     0,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   554,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,   576,    79,    80,    81,   365,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,    49,     0,   226,   576,    79,    80,    81,
     365,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,   600,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,   576,    79,
      80,    81,   365,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,     0,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,     0,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,     0,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
     576,    79,    80,    81,   365,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   811,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
       0,   226,   576,    79,    80,    81,   365,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,     0,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   853,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,   576,   610,    79,    80,    81,   365,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   611,    99,
     100,   101,   368,   612,     0,   103,   104,   105,   106,   613,
     614,     0,   108,   109,   110,     0,   111,   615,   616,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,     0,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     391,   392,   393,     0,  1475,     0,  1476,  1170,     0,   394,
     395,     0,   396,     0,     0,   397,  1477,  1478,   399,     0,
     400,   401,   402,   403,     0,     0,     0,   404,   405,   406,
     407,     0,   408,   409,     0,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,  1479,  1480,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,  1184,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,     0,   438,     0,     0,     0,   439,   440,  1481,     0,
     441,     0,   442,     0,     0,     0,   443,     0,   444,     0,
     445,     0,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,  1851,   453,   454,   455,   456,   457,     0,     0,
    1852,     0,   458,   459,   460,  1190,  1482,     0,  1483,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   466,
       0,     0,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,  1484,     0,  1485,     0,   482,   483,   484,   485,
     486,   487,   488,     0,   489,     0,   490,   491,     0,   492,
       0,     0,  1486,   493,   494,     0,     0,   495,     0,     0,
       0,   496,   497,     0,     0,  1853,     0,     0,     0,   498,
     499,   500,     0,     0,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,  1487,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   523,     0,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,     0,   533,  1488,   534,   535,     0,
     536,  1489,     0,   537,   538,   539,   540,   541,   542,   543,
     544,     0,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,  1490,  1491,     0,   553,     0,   554,     0,   555,
       0,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,     0,   565,   566,     0,   567,  1492,
     568,     0,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,   610,    79,    80,
      81,   365,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     611,    99,   100,   101,   368,   612,     0,   103,   104,   105,
     106,   613,   614,     0,   108,   109,   110,     0,   111,   615,
     616,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,     0,   386,   387,
       0,     0,     0,     0,     0,     0,     0,   388,   389,     0,
     390,     0,   391,   392,   393,     0,  1475,     0,  1476,  1170,
       0,   394,   395,     0,   396,     0,     0,   397,  1477,  1478,
     399,     0,   400,   401,   402,   403,     0,     0,     0,   404,
     405,   406,   407,     0,   408,   409,     0,   410,     0,   411,
     412,   413,     0,   414,     0,     0,     0,     0,     0,   415,
     416,   417,   418,   419,  1479,  1480,   420,     0,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
    1184,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,     0,   438,     0,     0,     0,   439,   440,
    1481,     0,   441,     0,   442,     0,     0,     0,   443,     0,
     444,     0,   445,     0,     0,   446,     0,   447,   448,   449,
       0,   450,   451,   452,     0,   453,   454,   455,   456,   457,
       0,     0,     0,     0,   458,   459,   460,  1190,  1482,     0,
    1483,     0,     0,     0,     0,   461,     0,   462,   463,   464,
     465,   466,     0,     0,     0,   467,     0,     0,   468,   469,
     470,     0,     0,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,  1484,     0,  1485,     0,   482,   483,
     484,   485,   486,   487,   488,  1878,   489,     0,   490,   491,
       0,   492,     0,     0,  1486,   493,   494,     0,     0,   495,
       0,     0,     0,   496,   497,     0,     0,     0,     0,     0,
       0,   498,   499,   500,     0,     0,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,  1487,   510,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,     0,   522,   523,     0,   524,   525,   526,   527,   528,
     529,     0,     0,   530,   531,   532,     0,   533,  1488,   534,
     535,     0,   536,  1489,     0,   537,   538,   539,   540,   541,
     542,   543,   544,     0,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,  1490,  1491,     0,   553,     0,   554,
       0,   555,     0,     0,   556,   557,   558,   559,   560,     0,
       0,   561,   562,   563,   564,     0,     0,   565,   566,     0,
     567,  1492,   568,     0,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,     0,     0,   226,   610,
      79,    80,    81,   365,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   611,    99,   100,   101,   368,   612,     0,   103,
     104,   105,   106,   613,   614,     0,   108,   109,   110,     0,
     111,   615,   616,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,     0,
     386,   387,     0,     0,     0,     0,     0,     0,     0,   388,
     389,     0,   390,     0,   391,   392,   393,     0,  1475,     0,
    1476,  1170,     0,   394,   395,     0,   396,     0,     0,   397,
    1477,  1478,   399,     0,   400,   401,   402,   403,     0,     0,
       0,   404,   405,   406,   407,     0,   408,   409,     0,   410,
       0,   411,   412,   413,     0,   414,     0,     0,     0,     0,
       0,   415,   416,   417,   418,   419,  1479,  1480,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,  1184,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,     0,   438,     0,     0,     0,
     439,   440,  1481,     0,   441,     0,   442,     0,     0,     0,
     443,     0,   444,     0,   445,     0,     0,   446,     0,   447,
     448,   449,     0,   450,   451,   452,     0,   453,   454,   455,
     456,   457,     0,     0,     0,     0,   458,   459,   460,  1190,
    1482,     0,  1483,     0,     0,     0,     0,   461,     0,   462,
     463,   464,   465,   466,     0,     0,     0,   467,     0,     0,
     468,   469,   470,     0,     0,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,  1484,     0,  1485,     0,
     482,   483,   484,   485,   486,   487,   488,  2691,   489,     0,
     490,   491,     0,   492,     0,     0,  1486,   493,   494,     0,
       0,   495,     0,     0,     0,   496,   497,     0,     0,     0,
       0,     0,     0,   498,   499,   500,     0,     0,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,  1487,
     510,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,   523,     0,   524,   525,   526,
     527,   528,   529,     0,     0,   530,   531,   532,     0,   533,
    1488,   534,   535,     0,   536,  1489,     0,   537,   538,   539,
     540,   541,   542,   543,   544,     0,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,  1490,  1491,     0,   553,
       0,   554,     0,   555,     0,     0,   556,   557,   558,   559,
     560,     0,     0,   561,   562,   563,   564,     0,     0,   565,
     566,     0,   567,  1492,   568,     0,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,     0,     0,
     226,   610,    79,    80,    81,   365,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   611,    99,   100,   101,   368,   612,
       0,   103,   104,   105,   106,   613,   614,     0,   108,   109,
     110,     0,   111,   615,   616,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
    1475,     0,  1476,  1170,     0,   394,   395,     0,   396,     0,
       0,   397,  1477,  1478,   399,     0,   400,   401,   402,   403,
       0,     0,     0,   404,   405,   406,   407,     0,   408,   409,
       0,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,  1479,  1480,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,  1184,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,     0,   438,     0,
       0,     0,   439,   440,  1481,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,     0,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,     0,     0,   458,   459,
     460,  1190,  1482,     0,  1483,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,     0,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,  1484,     0,
    1485,     0,   482,   483,   484,   485,   486,   487,   488,     0,
     489,     0,   490,   491,     0,   492,  1845,     0,  1486,   493,
     494,     0,     0,   495,     0,     0,     0,   496,   497,     0,
       0,     0,     0,     0,     0,   498,   499,   500,     0,     0,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,  1487,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,     0,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,  1488,   534,   535,     0,   536,  1489,     0,   537,
     538,   539,   540,   541,   542,   543,   544,     0,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,  1490,  1491,
       0,   553,     0,   554,     0,   555,     0,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,  1492,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
       0,     0,   226,   610,    79,    80,    81,   365,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   611,    99,   100,   101,
     368,   612,     0,   103,   104,   105,   106,   613,   614,     0,
     108,   109,   110,     0,   111,   615,   616,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,  1475,     0,  1476,  1170,     0,   394,   395,     0,
     396,     0,     0,   397,  1477,  1478,   399,     0,   400,   401,
     402,   403,     0,     0,     0,   404,   405,   406,   407,     0,
     408,   409,     0,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
    1479,  1480,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,  1184,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,     0,
     438,     0,     0,     0,   439,   440,  1481,     0,   441,     0,
     442,     0,     0,     0,   443,     0,   444,     0,   445,     0,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,     0,     0,
     458,   459,   460,  1190,  1482,     0,  1483,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   466,     0,     0,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
    1484,     0,  1485,     0,   482,   483,   484,   485,   486,   487,
     488,     0,   489,     0,   490,   491,     0,   492,     0,     0,
    1486,   493,   494,     0,     0,   495,     0,     0,     0,   496,
     497,     0,     0,     0,     0,     0,     0,   498,   499,   500,
       0,     0,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,  1487,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
       0,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,     0,   533,  1488,   534,   535,     0,   536,  1489,
       0,   537,   538,   539,   540,   541,   542,   543,   544,     0,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
    1490,  1491,     0,   553,     0,   554,     0,   555,     0,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,  1492,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,   610,    79,    80,    81,   365,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   611,    99,
     100,   101,   368,   612,     0,   103,   104,   105,   106,   613,
     614,     0,   108,   109,   110,     0,   111,   615,   616,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,     0,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     391,   392,   393,     0,  1475,     0,  1476,  1170,     0,   394,
     395,     0,   396,     0,     0,   397,  1477,  1478,   399,     0,
     400,   401,   402,   403,     0,     0,     0,   404,   405,   406,
     407,     0,   408,   409,     0,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,  1479,  1480,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,  1184,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,     0,   438,     0,     0,     0,   439,   440,  1481,     0,
     441,     0,   442,     0,     0,     0,   443,     0,   444,     0,
     445,     0,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,     0,
       0,     0,   458,   459,   460,  1190,  1482,     0,  1483,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   466,
       0,     0,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,  1484,     0,  1485,     0,   482,   483,   484,   485,
     486,   487,   488,     0,   489,     0,   490,   491,     0,   492,
       0,     0,  1486,   493,   494,     0,     0,   495,     0,     0,
       0,   496,   497,     0,     0,     0,     0,     0,     0,   498,
     499,   500,     0,     0,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,  1487,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   523,     0,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,     0,   533,     0,   534,   535,     0,
     536,  1489,     0,   537,   538,   539,   540,   541,   542,   543,
     544,     0,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,  1490,  1491,     0,   553,     0,   554,     0,   555,
       0,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,     0,   565,   566,     0,   567,  1492,
     568,     0,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,    79,    80,    81,
     365,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   378,   379,
     380,   381,   382,   383,   384,   385,   617,   386,   387,   618,
     619,   620,   621,   622,   623,   624,   388,   389,   625,   390,
     129,   391,   392,   393,   131,   132,   133,   134,     0,   626,
     394,   395,     0,   396,   627,   628,   397,     0,   135,   399,
     630,   400,   401,   402,   403,   139,   631,   632,   404,   405,
     406,   407,   633,   408,   409,   142,   410,   634,   411,   412,
     413,   145,   414,   635,   636,   637,   638,   639,   415,   416,
     417,     0,   419,   148,   149,   420,   640,   421,   641,   422,
       0,   423,   424,   425,   642,   426,   643,   644,   427,   428,
     429,   430,   645,   431,   432,   433,   646,   434,   647,   435,
     436,   437,   155,   438,     0,   157,   648,   439,   440,   159,
     649,   441,   650,   442,   160,   651,   161,   443,     0,   444,
     652,   445,   164,   653,   446,   654,   447,   448,     0,   165,
     450,   451,   452,   655,   453,   454,   455,   456,   457,   656,
     166,   167,     0,   458,   459,   460,     0,   169,   659,   170,
     660,     0,   171,   172,   461,   173,   462,   463,   464,   465,
     466,   661,   174,   175,   467,   176,   662,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,     0,   477,   478,
       0,   480,   481,   181,   182,   183,   663,   482,   483,   484,
     485,   486,   487,   488,   184,   489,   664,   490,   491,   186,
     492,   665,   187,   188,   493,   494,   666,   667,   495,   668,
     669,   670,   496,   497,   671,   672,   189,   190,   191,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,   673,
     504,   505,   506,   507,   508,   509,   196,   510,   674,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     201,   522,   523,   203,   524,   525,   526,   527,   528,     0,
       0,   675,   530,   531,   532,   676,   533,   207,   534,   535,
     209,   536,   210,   677,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,   678,   546,   547,   679,   548,   549,
     550,   551,   680,   213,   214,     0,   553,   682,   554,   215,
     555,   216,   683,   556,   557,   558,   559,   560,     0,   685,
     561,   562,   563,   564,   686,   687,   565,   566,     0,   567,
     223,   568,   224,   569,     0,   688,   689,   570,   571,   572,
     573,     0,   575,     0,   225,     0,     0,   226,    79,    80,
      81,   365,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   368,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,     0,   386,   387,
       0,     0,     0,     0,     0,     0,     0,   388,   389,     0,
     390,   129,   391,   392,   393,   131,   132,   133,   134,     0,
       0,   394,   395,     0,   396,     0,     0,   397,   398,   135,
     399,     0,   400,   401,   402,   403,   139,     0,     0,   404,
     405,   406,   407,     0,   408,   409,   142,   410,     0,   411,
     412,   413,   145,   414,     0,     0,     0,     0,     0,   415,
     416,   417,   418,   419,   148,   149,   420,     0,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
     428,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,   155,   438,     0,   157,     0,   439,   440,
     159,     0,   441,     0,   442,   160,     0,   161,   443,     0,
     444,     0,   445,   164,     0,   446,     0,   447,   448,   449,
     165,   450,   451,   452,     0,   453,   454,   455,   456,   457,
       0,   166,   167,     0,   458,   459,   460,     0,   169,     0,
     170,     0,     0,   171,   172,   461,   173,   462,   463,   464,
     465,   466,     0,   174,   175,   467,   176,     0,   468,   469,
     470,     0,     0,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   181,   182,   183,   739,   482,   483,
     484,   485,   486,   487,   488,   184,   489,     0,   490,   491,
     186,   492,     0,   187,   188,   493,   494,     0,     0,   495,
     740,     0,     0,   496,   497,     0,     0,   189,   190,   191,
     192,   498,   499,   500,     0,   193,   194,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,   196,   510,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   201,   522,   523,   203,   524,   525,   526,   527,   528,
     529,     0,     0,   530,   531,   532,     0,   533,   207,   534,
     535,   209,   536,   210,     0,   537,   538,   539,   540,   541,
     542,   543,   544,   212,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,   213,   214,     0,   553,     0,   554,
     215,   555,   216,     0,   556,   557,   558,   559,   560,     0,
       0,   561,   562,   563,   564,     0,     0,   565,   566,     0,
     567,   223,   568,   224,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,     0,     0,   226,    79,
      80,    81,   365,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,  1829,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,  1830,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,  1831,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,  2417,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,     0,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,     0,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,  1832,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,     0,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,  1833,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
      79,    80,    81,   365,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   368,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,   835,
     386,   387,     0,     0,     0,     0,     0,     0,     0,   388,
     389,     0,   390,     0,   391,   392,   393,     0,   132,     0,
     134,     0,     0,   394,   395,     0,   396,     0,     0,   397,
     398,   135,   399,     0,   400,   401,   402,   403,   139,     0,
       0,   404,   405,   406,   407,     0,   408,   409,   142,   410,
     836,   411,   412,   413,     0,   414,     0,     0,     0,     0,
       0,   415,   416,   417,   418,   419,   148,   149,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,   428,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,   155,   438,     0,   157,     0,
     439,   440,   159,     0,   441,     0,   442,     0,     0,     0,
     443,     0,   444,   875,   445,   164,     0,   446,     0,   447,
     448,   449,     0,   450,   451,   452,     0,   453,   454,   455,
     456,   457,     0,     0,   167,     0,   458,   459,   460,     0,
     169,     0,   170,     0,     0,     0,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   174,     0,   467,     0,     0,
     468,   469,   470,     0,     0,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   181,     0,   183,     0,
     482,   483,   484,   485,   486,   487,   488,   184,   489,     0,
     490,   491,     0,   492,     0,   187,   188,   493,   494,     0,
       0,   495,     0,     0,     0,   496,   497,     0,     0,   189,
       0,     0,   192,   498,   499,   500,     0,   193,   194,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,   196,
     510,   837,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,   523,   203,   524,   525,   526,
     527,   528,   529,     0,   838,   530,   531,   532,     0,   533,
     207,   534,   535,     0,   536,   210,     0,   537,   538,   539,
     540,   541,   542,   543,   544,   212,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,   213,   214,     0,   553,
       0,   554,   215,   555,   216,     0,   556,   557,   558,   559,
     560,     0,     0,   561,   562,   563,   564,     0,     0,   565,
     566,     0,   567,   223,   568,     0,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,     0,     0,
     226,    79,    80,    81,   365,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
     835,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,   836,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,   837,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,   838,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
       0,   226,    79,    80,    81,   365,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   368,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,   126,   127,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
     132,     0,   134,     0,     0,   394,   395,     0,   396,     0,
       0,   397,   398,   135,   399,     0,   400,   401,   402,   403,
     139,     0,     0,   404,   405,   406,   407,     0,   408,   409,
     142,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,   148,   149,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,   428,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,   155,   438,     0,
     157,     0,   439,   440,   159,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,   164,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,   167,     0,   458,   459,
     460,     0,   169,     0,   170,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   174,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   181,     0,
     183,   739,   482,   483,   484,   485,   486,   487,   488,   184,
     489,     0,   490,   491,     0,   492,     0,   187,   188,   493,
     494,     0,     0,   495,   740,     0,     0,   496,   497,     0,
       0,   189,     0,     0,   192,   498,   499,   500,     0,   193,
     194,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,   196,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,   203,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,   207,   534,   535,     0,   536,   210,     0,   537,
     538,   539,   540,   541,   542,   543,   544,   212,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,   213,   214,
       0,   553,     0,   554,   215,   555,   216,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,   223,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
       0,     0,   226,    79,    80,    81,   365,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,   739,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,   740,     0,   907,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   554,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,    79,    80,    81,   365,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     368,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,   132,     0,   134,     0,     0,   394,   395,     0,
     396,     0,     0,   397,   398,   135,   399,     0,   400,   401,
     402,   403,   139,     0,     0,   404,   405,   406,   407,     0,
     408,   409,   142,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,  1579,   418,   419,
     148,   149,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,   428,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,   155,
     438,     0,   157,     0,   439,   440,   159,     0,   441,     0,
     442,     0,     0,     0,  1580,     0,   444,     0,   445,   164,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,   167,     0,
     458,   459,   460,     0,   169,     0,   170,     0,     0,     0,
       0,   461,     0,   462,   463,  1581,   465,   466,     0,   174,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     181,     0,   183,   739,   482,   483,   484,   485,   486,   487,
     488,   184,   489,     0,   490,   491,     0,   492,     0,   187,
     188,   493,   494,     0,     0,   495,   740,     0,     0,   496,
     497,     0,     0,   189,     0,     0,   192,   498,   499,   500,
       0,   193,   194,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,   196,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
     203,   524,   525,   526,  1582,   528,   529,     0,     0,   530,
     531,   532,     0,   533,   207,   534,   535,     0,   536,   210,
       0,   537,   538,   539,   540,   541,   542,   543,   544,   212,
     545,     0,   546,   547,  1583,  1584,   549,   550,   551,     0,
     213,   214,     0,   553,     0,   554,   215,   555,   216,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,   223,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,    79,    80,    81,   365,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,   836,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,   837,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,   838,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,    79,    80,    81,   365,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   368,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,     0,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     391,   392,   393,     0,   132,     0,   134,     0,     0,   394,
     395,     0,   396,     0,     0,   397,   398,   135,   399,     0,
     400,   401,   402,   403,   139,     0,     0,   404,   405,   406,
     407,     0,   408,   409,   142,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,   148,   149,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,   428,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,   155,   438,     0,   157,     0,   439,   440,   159,     0,
     441,     0,   442,     0,     0,     0,   443,     0,   444,     0,
     445,   164,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,     0,
     167,     0,   458,   459,   460,     0,   169,     0,   170,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   174,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   181,     0,   183,   739,   482,   483,   484,   485,
     486,   487,   488,   184,   489,     0,   490,   491,     0,   492,
       0,   187,   188,   493,   494,     0,     0,   495,   740,     0,
       0,   496,   497,     0,     0,   189,     0,     0,   192,   498,
     499,   500,     0,   193,   194,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,   196,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   523,   203,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,     0,   533,   207,   534,   535,     0,
     536,   210,     0,   537,   538,   539,   540,   541,   542,   543,
     544,   212,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,   213,   214,     0,   553,     0,   554,   215,   555,
     216,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,     0,   565,   566,     0,   567,   223,
     568,     0,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,    79,    80,    81,
     365,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,   820,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,   821,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,    79,    80,
      81,   365,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   368,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,  2336,   386,   387,
       0,     0,     0,     0,     0,     0,     0,   388,   389,     0,
     390,     0,   391,   392,   393,     0,   132,     0,   134,     0,
       0,   394,   395,     0,   396,     0,     0,   397,   398,   135,
     399,     0,   400,   401,   402,   403,   139,     0,     0,   404,
     405,   406,   407,     0,   408,   409,   142,   410,     0,   411,
     412,   413,     0,   414,     0,     0,     0,     0,     0,   415,
     416,   417,   418,   419,   148,   149,   420,     0,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
     428,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,   155,   438,     0,   157,     0,   439,   440,
     159,     0,   441,     0,   442,     0,     0,     0,   443,     0,
     444,     0,   445,   164,     0,   446,     0,   447,   448,   449,
       0,   450,   451,   452,     0,   453,   454,   455,   456,   457,
       0,     0,   167,     0,   458,   459,   460,     0,   169,     0,
     170,     0,     0,     0,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   174,     0,   467,     0,     0,   468,   469,
     470,     0,     0,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   181,     0,   183,     0,   482,   483,
     484,   485,   486,   487,   488,   184,   489,     0,   490,   491,
       0,   492,     0,   187,   188,   493,   494,     0,     0,   495,
       0,     0,     0,   496,   497,     0,     0,   189,     0,     0,
     192,   498,   499,   500,     0,   193,   194,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,   196,   510,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,     0,   522,   523,   203,   524,   525,   526,   527,   528,
     529,     0,     0,   530,   531,   532,     0,   533,   207,   534,
     535,     0,   536,   210,     0,   537,   538,   539,   540,   541,
     542,   543,   544,   212,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,   213,   214,     0,   553,     0,   554,
     215,   555,   216,     0,   556,   557,   558,   559,   560,     0,
       0,   561,   562,   563,   564,  2337,     0,   565,   566,     0,
     567,   223,   568,     0,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,     0,     0,   226,    79,
      80,    81,   365,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,  2341,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,     0,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,     0,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,     0,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,  2342,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
      79,    80,    81,   365,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   368,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,  1272,
     386,   387,     0,     0,     0,     0,     0,     0,     0,   388,
     389,     0,   390,     0,   391,   392,   393,     0,   132,     0,
     134,     0,     0,   394,   395,     0,   396,     0,     0,   397,
     398,   135,   399,     0,   400,   401,   402,   403,   139,     0,
       0,   404,   405,   406,   407,     0,   408,   409,   142,   410,
       0,   411,   412,   413,     0,   414,     0,     0,     0,     0,
       0,   415,   416,   417,   418,   419,   148,   149,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,   428,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,   155,   438,     0,   157,     0,
     439,   440,   159,     0,   441,     0,   442,     0,     0,     0,
     443,     0,   444,     0,   445,   164,     0,   446,     0,   447,
     448,   449,     0,   450,   451,   452,     0,   453,   454,   455,
     456,   457,     0,     0,   167,     0,   458,   459,   460,     0,
     169,     0,   170,     0,     0,     0,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   174,     0,   467,     0,     0,
     468,   469,   470,     0,     0,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   181,     0,   183,     0,
     482,   483,   484,   485,   486,   487,   488,   184,   489,     0,
     490,   491,     0,   492,     0,   187,   188,   493,   494,     0,
       0,   495,     0,     0,     0,   496,   497,     0,     0,   189,
       0,     0,   192,   498,   499,   500,     0,   193,   194,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,   196,
     510,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,   523,   203,   524,   525,   526,
     527,   528,   529,     0,     0,   530,   531,   532,     0,   533,
     207,   534,   535,     0,   536,   210,     0,   537,   538,   539,
     540,   541,   542,   543,   544,   212,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,   213,   214,     0,   553,
       0,   554,   215,   555,   216,     0,   556,   557,   558,   559,
     560,     0,     0,   561,   562,   563,   564,     0,     0,   565,
     566,     0,   567,   223,   568,     0,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,     0,     0,
     226,    79,    80,    81,   365,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,  2451,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
       0,   226,    79,    80,    81,   365,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   368,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,  2465,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
     132,     0,   134,     0,     0,   394,   395,     0,   396,     0,
       0,   397,   398,   135,   399,     0,   400,   401,   402,   403,
     139,     0,     0,   404,   405,   406,   407,     0,   408,   409,
     142,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,   148,   149,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,   428,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,   155,   438,     0,
     157,     0,   439,   440,   159,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,   164,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,   167,     0,   458,   459,
     460,     0,   169,     0,   170,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   174,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   181,     0,
     183,     0,   482,   483,   484,   485,   486,   487,   488,   184,
     489,     0,   490,   491,     0,   492,     0,   187,   188,   493,
     494,     0,     0,   495,     0,     0,     0,   496,   497,     0,
       0,   189,     0,     0,   192,   498,   499,   500,     0,   193,
     194,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,   196,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,   203,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,   207,   534,   535,     0,   536,   210,     0,   537,
     538,   539,   540,   541,   542,   543,   544,   212,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,   213,   214,
       0,   553,     0,   554,   215,   555,   216,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,   223,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
       0,     0,   226,    79,    80,    81,   365,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,   164,  2486,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,     0,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   554,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,    79,    80,    81,   365,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     368,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,   132,     0,   134,     0,     0,   394,   395,     0,
     396,     0,     0,   397,   398,   135,   399,     0,   400,   401,
     402,   403,   139,     0,     0,   404,   405,   406,   407,     0,
     408,   409,   142,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
     148,   149,   420,  2753,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,   428,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,   155,
     438,     0,   157,     0,   439,   440,   159,     0,   441,     0,
     442,     0,     0,     0,   443,     0,   444,     0,   445,   164,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,   167,     0,
     458,   459,   460,     0,   169,     0,   170,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   174,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     181,     0,   183,     0,   482,   483,   484,   485,   486,   487,
     488,   184,   489,     0,   490,   491,     0,   492,     0,   187,
     188,   493,   494,     0,     0,   495,     0,     0,     0,   496,
     497,     0,     0,   189,     0,     0,   192,   498,   499,   500,
       0,   193,   194,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,   196,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
     203,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,     0,   533,   207,   534,   535,     0,   536,   210,
       0,   537,   538,   539,   540,   541,   542,   543,   544,   212,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
     213,   214,     0,   553,     0,   554,   215,   555,   216,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,   223,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,    79,    80,    81,   365,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,  2755,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,    79,    80,    81,   365,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   368,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,     0,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     391,   392,   393,     0,   132,     0,   134,     0,     0,   394,
     395,     0,   396,     0,     0,   397,   398,   135,   399,     0,
     400,   401,   402,   403,   139,     0,     0,   404,   405,   406,
     407,     0,   408,   409,   142,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,   148,   149,   420,  2757,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,   428,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,   155,   438,     0,   157,     0,   439,   440,   159,     0,
     441,     0,   442,     0,     0,     0,   443,     0,   444,     0,
     445,   164,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,     0,
     167,     0,   458,   459,   460,     0,   169,     0,   170,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   174,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   181,     0,   183,     0,   482,   483,   484,   485,
     486,   487,   488,   184,   489,     0,   490,   491,     0,   492,
       0,   187,   188,   493,   494,     0,     0,   495,     0,     0,
       0,   496,   497,     0,     0,   189,     0,     0,   192,   498,
     499,   500,     0,   193,   194,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,   196,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   523,   203,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,     0,   533,   207,   534,   535,     0,
     536,   210,     0,   537,   538,   539,   540,   541,   542,   543,
     544,   212,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,   213,   214,     0,   553,     0,   554,   215,   555,
     216,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,     0,   565,   566,     0,   567,   223,
     568,     0,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,    79,    80,    81,
     365,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,  3223,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,    79,    80,
      81,   365,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   368,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,     0,   386,   387,
       0,     0,     0,     0,     0,     0,     0,   388,   389,     0,
     390,     0,   391,   392,   393,     0,   132,     0,   134,     0,
       0,   394,   395,     0,   396,     0,     0,   397,   398,   135,
     399,     0,   400,   401,   402,   403,   139,     0,     0,   404,
     405,   406,   407,     0,   408,   409,   142,   410,     0,   411,
     412,   413,     0,   414,     0,     0,     0,     0,     0,   415,
     416,   417,   418,   419,   148,   149,   420,     0,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
     428,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,   155,   438,     0,   157,     0,   439,   440,
     159,     0,   441,     0,   442,     0,     0,     0,   443,     0,
     444,     0,   445,   164,     0,   446,     0,   447,   448,   449,
       0,   450,   451,   452,     0,   453,   454,   455,   456,   457,
       0,     0,   167,     0,   458,   459,   460,     0,   169,     0,
     170,     0,     0,     0,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   174,     0,   467,     0,     0,   468,   469,
     470,     0,     0,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   181,     0,   183,     0,   482,   483,
     484,   485,   486,   487,   488,   184,   489,     0,   490,   491,
       0,   492,     0,   187,   188,   493,   494,     0,     0,   495,
       0,     0,     0,   496,   497,     0,     0,   189,     0,     0,
     192,   498,   499,   500,     0,   193,   194,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,   196,   510,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,     0,   522,   523,   203,   524,   525,   526,   527,   528,
     529,     0,     0,   530,   531,   532,     0,   533,   207,   534,
     535,     0,   536,   210,     0,   537,   538,   539,   540,   541,
     542,   543,   544,   212,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,   213,   214,     0,   553,     0,   554,
     215,   555,   216,     0,   556,   557,   558,   559,   560,     0,
       0,   561,   562,   563,   564,     0,     0,   565,   566,     0,
     567,   223,   568,     0,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,     0,     0,   226,    79,
      80,    81,   365,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,     0,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,     0,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   784,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,     0,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
      79,    80,    81,   365,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   368,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,     0,
     386,   387,     0,     0,     0,     0,     0,     0,     0,   388,
     389,     0,   390,     0,   391,   392,   393,     0,   132,     0,
     134,     0,     0,   394,   395,     0,   396,     0,     0,   397,
     398,   135,   399,     0,   400,   401,   402,   403,   139,     0,
       0,   404,   405,   406,   407,     0,   408,   409,   142,   410,
       0,   411,   412,   413,     0,   414,     0,     0,     0,     0,
       0,   415,   416,   417,   418,   419,   148,   149,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,   428,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,   155,   438,     0,   157,     0,
     439,   440,   159,     0,   441,     0,   442,     0,     0,     0,
     443,     0,   444,     0,   445,   164,     0,   446,     0,   447,
     448,   449,     0,   450,   451,   452,     0,   453,   454,   455,
     456,   457,     0,     0,   167,     0,   458,   459,   460,     0,
     169,     0,   170,     0,     0,     0,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   174,     0,   467,     0,     0,
     468,   469,   470,     0,     0,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   181,     0,   183,     0,
     482,   483,   484,   485,   486,   487,   488,   184,   489,     0,
     490,   491,     0,   492,     0,   187,   188,   493,   494,     0,
       0,   495,     0,     0,     0,   496,   497,     0,     0,   189,
       0,     0,   192,   498,   499,   500,     0,   193,   194,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,   196,
     510,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,   523,   203,   524,   525,   860,
     527,   528,   529,     0,     0,   530,   531,   532,     0,   533,
     207,   534,   535,     0,   536,   210,     0,   537,   538,   539,
     540,   541,   542,   543,   544,   212,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,   213,   214,     0,   553,
       0,   554,   215,   555,   216,     0,   556,   557,   558,   559,
     560,     0,     0,   561,   562,   563,   564,     0,     0,   565,
     566,     0,   567,   223,   568,     0,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,     0,     0,
     226,    79,    80,    81,   365,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
     862,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   863,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,     0,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   864,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   865,   214,     0,
     553,     0,   866,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
       0,   226,    79,    80,    81,   365,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   368,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,   896,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
     132,     0,   134,     0,     0,   394,   395,     0,   396,     0,
       0,   397,   863,   135,   399,     0,   400,   401,   402,   403,
     139,     0,     0,   404,   405,   406,     0,     0,   408,   409,
     142,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,   148,   149,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,   428,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,   155,   438,     0,
     157,     0,   439,   440,   159,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,   164,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,   167,     0,   458,   459,
     460,     0,   169,     0,   170,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   174,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   181,     0,
     183,     0,   482,   483,   484,   485,   486,   487,   488,   184,
     489,     0,   490,   491,     0,   492,     0,   187,   188,   493,
     494,     0,     0,   495,     0,     0,     0,   496,   497,     0,
       0,   189,     0,     0,   192,   498,   499,   500,     0,   193,
     194,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,   196,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,   203,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   897,
       0,   533,   207,   534,   535,     0,   536,   210,     0,   537,
     538,   539,   540,   541,   542,   543,   544,   212,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,   898,   214,
       0,   553,     0,   899,   215,   555,   216,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,   223,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
       0,     0,   226,    79,    80,    81,   365,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,  1283,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   863,   135,  1284,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,     0,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   889,   181,
       0,   183,     0,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   890,   523,   203,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
    1275,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   892,
     214,     0,   553,     0,   893,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,  1375,    80,    81,   365,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     368,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,   132,     0,   134,     0,     0,   394,   395,     0,
     396,     0,     0,   397,   398,   135,   399,     0,   400,   401,
     402,   403,   139,     0,     0,   404,   405,   406,   407,     0,
     408,   409,   142,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
     148,   149,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,   428,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,   155,
     438,     0,   157,     0,   439,   440,   159,     0,   441,     0,
     442,     0,     0,     0,   443,     0,   444,     0,   445,   164,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,   167,     0,
     458,   459,   460,     0,   169,     0,   170,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   174,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     181,     0,   183,     0,   482,   483,   484,   485,   486,   487,
     488,   184,   489,     0,   490,   491,     0,   492,     0,   187,
     188,   493,   494,     0,     0,   495,     0,     0,     0,   496,
     497,     0,     0,   189,     0,     0,   192,   498,   499,   500,
       0,   193,   194,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,   196,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
     203,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,     0,   533,   207,   534,   535,     0,   536,   210,
       0,   537,   538,   539,   540,   541,   542,   543,   544,   212,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
     213,   214,     0,   553,     0,   554,   215,   555,   216,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,   223,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,    79,    80,    81,   365,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,  1608,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,    79,    80,    81,   365,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   368,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,     0,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     391,   392,   393,     0,   132,     0,   134,     0,     0,   394,
     395,     0,   396,     0,     0,   397,   863,   135,   399,     0,
     400,   401,   402,   403,   139,     0,     0,   404,   405,   406,
       0,     0,   408,   409,   142,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,   148,   149,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,   428,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,   155,   438,     0,   157,     0,   439,   440,   159,     0,
     441,     0,   442,     0,     0,     0,   443,     0,   444,     0,
     445,   164,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,     0,
     167,     0,   458,   459,   460,     0,   169,     0,   170,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   174,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   889,   181,     0,   183,     0,   482,   483,   484,   485,
     486,   487,   488,   184,   489,     0,   490,   491,     0,   492,
       0,   187,   188,   493,   494,     0,     0,   495,     0,     0,
       0,   496,   497,     0,     0,   189,     0,     0,   192,   498,
     499,   500,     0,   193,   194,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,   196,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     890,   523,   203,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,  1275,     0,   533,   207,   534,   535,     0,
     536,   210,     0,   537,   538,   539,   540,   541,   542,   543,
     544,   212,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,   892,   214,     0,   553,     0,   893,   215,   555,
     216,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,     0,   565,   566,     0,   567,   223,
     568,     0,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,    79,    80,    81,
       0,    83,    84,     0,    85,    86,    87,     0,     0,     0,
      90,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,     0,     0,     0,   103,   104,   105,   106,
       0,   107,     0,   108,   109,   110,     0,   111,   112,   113,
     114,     0,     0,     0,     0,     0,   117,   118,     0,     0,
       0,     0,   119,     0,     0,     0,     0,     0,     0,     0,
       0,   120,     0,   121,     0,   122,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     129,     0,     0,     0,   131,   132,   133,   134,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   135,     0,
       0,     0,     0,     0,     0,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   142,     0,     0,     0,     0,
       0,   145,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   148,   149,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   155,     0,     0,   157,     0,     0,     0,   159,
       0,     0,     0,     0,   160,     0,   161,     0,     0,     0,
       0,     0,   164,     0,     0,     0,     0,     0,     0,   165,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     166,   167,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,   171,   172,     0,   173,     0,     0,     0,     0,
       0,     0,   174,   175,     0,   176,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   181,   182,   183,     0,     0,     0,     0,
       0,     0,     0,     0,   184,     0,     0,     0,     0,   186,
       0,     0,   187,   188,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   189,   190,   191,   192,
       0,     0,     0,     0,   193,   194,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   196,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     201,     0,     0,   203,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   207,     0,     0,
     209,     0,   210,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   212,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   213,   214,     0,     0,     0,     0,   215,
       0,   216,     0,     0,     0,     0,     0,     0,   219,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,     0,     0,     0,     0,     0,
       0,    79,    80,    81,   225,    83,    84,   226,    85,    86,
      87,     0,     0,     0,    90,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,     0,     0,     0,
     103,   104,   105,   106,     0,   107,     0,   108,   109,   110,
       0,   111,   112,   113,   114,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   129,     0,     0,     0,   131,   132,
     133,   134,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   135,     0,     0,     0,     0,     0,     0,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   142,
       0,     0,     0,     0,     0,   145,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   148,   149,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   155,     0,     0,   157,
       0,     0,     0,   159,     0,     0,     0,     0,   160,     0,
     161,     0,     0,     0,     0,     0,   164,     0,     0,     0,
       0,     0,     0,   165,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   166,   167,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,   171,   172,     0,   173,
       0,     0,     0,     0,     0,     0,   174,   175,     0,   176,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   181,   182,   183,
       0,     0,     0,     0,     0,     0,     0,     0,   184,     0,
       0,     0,     0,   186,     0,     0,   187,   188,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     189,   190,   191,   192,     0,     0,     0,     0,   193,   194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   201,     0,     0,   203,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   207,     0,     0,   209,     0,   210,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   212,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   213,   214,     0,
       0,     0,     0,   215,     0,   216,     0,     0,     0,     0,
       0,     0,   219,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   223,     0,   224,     0,    79,    80,
      81,     0,    83,    84,     0,    85,    86,    87,   225,     0,
       0,   226,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,     0,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   129,     0,     0,     0,   131,   132,   133,   134,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   135,
       0,     0,     0,     0,     0,     0,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   142,     0,     0,     0,
       0,     0,   145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   148,   149,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   155,     0,     0,   157,     0,     0,     0,
     159,     0,     0,     0,     0,   160,     0,   161,     0,     0,
       0,     0,     0,   164,     0,     0,     0,     0,     0,     0,
     165,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   166,   167,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,   171,   172,     0,   173,     0,     0,     0,
       0,     0,     0,   174,   175,     0,   176,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   181,   182,   183,     0,     0,     0,
       0,     0,     0,     0,     0,   184,     0,     0,     0,     0,
     186,     0,     0,   187,   188,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   189,   190,   191,
     192,     0,     0,     0,     0,   193,   194,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   196,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   201,     0,     0,   203,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   207,     0,
       0,   209,     0,   210,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   212,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   213,   214,     0,     0,     0,     0,
     215,     0,   216,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   225,     0,     0,   226
};

static const short yycheck[] =
{
       2,   154,   718,   726,   147,   227,   722,    74,   144,   849,
    1580,   154,    82,    74,   741,  1550,  1085,   719,    77,   721,
     217,     2,    74,  1092,  1045,   200,  1032,    74,   979,  1111,
     945,   733,  1361,  1420,  1040,   751,  1504,  1211,   761,   710,
    1283,   815,   195,   817,    90,   819,  1162,   893,   720,   721,
      90,   825,   195,  1506,  1713,   757,   221,   779,  1611,  1547,
    2205,    74,   902,   998,    90,  1553,   112,   199,   770,  1520,
     128,   787,   112,   796,   206,  1081,   208,   793,  2040,  2025,
    2225,  1087,  2273,   755,  1520,  2084,   112,  1093,   146,   979,
      74,    74,  2406,  1520,  1520,    90,  1520,   794,  1406,  1520,
    2412,   798,  1979,  1980,  1981,  1982,   814,   809,   178,   806,
    2030,  2031,   834,  1545,  1750,  2441,    24,   112,  1127,   791,
    1857,  1858,  1383,   888,  1173,  1174,   891,  1012,    49,  1127,
      25,   962,   963,  1778,    41,   974,   979,    76,    74,  1137,
    1138,    77,   954,    76,    93,   886,   112,    90,  1197,  1225,
     117,    93,   117,   690,    90,   723,   158,  2563,   112,   727,
     227,   228,    41,   885,   136,    98,   734,   228,  1813,   112,
     155,   129,  1817,   219,   712,  1183,   112,   136,   180,   219,
     169,    92,   155,   194,    42,   200,    44,   212,    92,   194,
     887,   759,   229,   219,    77,   763,    28,   126,   229,    81,
     229,  1669,    28,   154,   772,   155,   229,    85,  3122,    79,
      97,   229,   194,    91,    85,   228,   284,   123,   150,   284,
      91,   364,    97,    76,   219,   138,    85,   199,   316,    74,
     160,   286,    91,    81,   202,   229,  1543,   155,    92,   169,
     199,   196,  3151,    74,   228,   228,    77,   340,  1246,   290,
     299,   345,   178,   374,   171,    76,   199,  1644,    85,    90,
      85,  1446,   307,   206,   177,   208,  1287,   160,    76,   321,
     207,   998,   185,     8,   321,   207,   219,    76,    13,    14,
      15,   112,   155,   219,    76,   299,   233,   169,    11,  1532,
      25,    26,    27,   233,    29,    30,    31,   157,   299,   358,
      35,    36,    37,   341,   425,   162,    98,   220,   178,   361,
      92,   160,  1391,  1248,   361,  1017,    85,  1491,   746,   256,
    1965,   169,    99,  1050,   256,   275,    49,   259,   366,  1514,
     223,   345,   377,  1518,    92,  1286,  1052,   431,  1061,     0,
     165,   118,  1058,  1528,   345,   438,   774,   119,  2387,  1428,
     438,   289,  3261,   112,   126,   340,   345,   275,   155,   131,
     326,  1956,   330,   408,   402,   394,    92,   314,   409,  2823,
     438,  2825,   326,   438,   314,   305,    76,  1048,   231,   334,
    1462,   287,  1084,   228,  1100,   321,   336,    82,   219,   229,
     445,   440,   374,   225,    89,   384,  1098,    92,    98,   225,
     394,   338,   229,  2365,   441,  3319,   338,   102,    74,  1862,
     231,    77,  1114,   398,   445,   275,  1951,   275,   441,   191,
     445,   347,   358,   441,    90,   361,   377,   385,  1477,  1478,
     445,  1452,   231,   128,   445,   972,  1485,  2073,   291,   321,
     445,   414,   137,   138,   417,   374,   112,   414,  1145,   422,
     417,   146,   147,   438,  1536,   150,  2862,   408,   996,   154,
     229,   117,   332,   158,   406,   407,  1163,   439,   163,   441,
     291,   438,  1480,   438,   352,   358,   363,   347,   410,   445,
     439,   352,   441,  2674,  2675,   180,   394,   404,   363,   438,
     321,   445,    76,   352,   552,   434,   417,   345,   445,   392,
     195,   434,  1345,   198,  1316,   200,   438,   414,  2454,   204,
     417,  1342,  2458,  2149,  1946,   422,  2462,   424,  1357,  2396,
    1405,  1248,   417,   430,   432,   436,  1338,   358,  1269,  1270,
     361,   231,   436,   199,  1610,  1611,   308,   394,   417,   112,
     206,   414,   208,   392,   417,  1621,  1622,   111,  1463,  1857,
    2287,  1560,  2289,   219,  2042,  2043,  2215,  1633,  1634,   724,
     154,  1559,   415,  1824,   729,   730,   160,   326,   441,   304,
    1568,  1647,  1648,   426,   427,  2220,   429,   430,   431,   432,
     433,   434,   436,  3037,    76,   439,   440,  2223,  1637,  1638,
     417,   445,    33,  1301,   415,   422,   155,   155,  2086,   119,
     177,   441,   150,   430,   425,   426,   427,   178,   429,   430,
     431,   432,   433,   434,   441,   280,   388,   414,   439,   183,
     417,   786,  1387,   431,   432,   433,   434,   780,  1704,   223,
     429,   430,   431,   432,   433,   434,   779,   780,   256,   431,
     432,   433,   434,  2380,   332,    17,   210,   231,   417,   384,
     227,   406,  1379,   422,   436,   321,  1421,   439,   440,   207,
     165,   430,   714,   445,   710,   131,    86,   714,   811,   364,
     710,   191,   441,   256,   112,  2989,   259,   747,   436,   149,
    1445,   439,   440,   110,   710,  2997,   103,   445,   690,   155,
     445,   834,   358,  3019,   267,   361,   157,  1420,  2737,  2738,
    2739,  2740,  2741,  2440,   392,   332,   157,   291,   256,   690,
     436,   259,  1383,   439,   440,   710,   275,   294,  2025,   445,
     338,   148,   280,   826,   245,   416,   417,   150,   355,   429,
     430,   431,   432,   433,   434,   119,   160,    28,    17,   231,
     196,  2386,   885,  1583,   400,   215,   340,   131,    39,   414,
    2218,   148,   417,   326,  2939,   338,   888,   218,   414,   891,
     195,   417,  1464,   327,   150,   286,  1468,   710,  2363,  2364,
     275,  3221,   345,   406,   710,   339,   347,  2372,   714,   284,
     221,   219,   438,   853,   207,   374,  2274,   214,   308,   353,
     338,   208,  2179,   105,  2671,   212,   360,   356,   392,   223,
     359,  1472,   336,  2988,   224,   307,  3256,   191,   878,   275,
     387,   340,   445,   815,   275,   817,   729,   819,   437,   889,
     890,   207,   189,   825,   826,   116,   445,   244,   255,   280,
     257,   415,   189,   256,  2796,   291,   259,   750,   324,   403,
     267,   425,   426,   427,   438,   429,   430,   431,   432,   433,
     434,  2339,  2340,   277,  1556,   439,   445,   552,   255,   345,
     257,  1812,   410,   903,  1580,   300,   314,  2813,   388,   398,
     256,    81,  2818,   407,   158,   377,  2822,    87,   245,   710,
     158,  1796,  1579,   714,  1581,  1582,   377,  1584,   245,  2809,
     438,   163,   962,   963,   160,   365,   366,  2204,   325,   347,
     136,   596,   597,   359,    88,    89,   408,  1913,  1914,   438,
     160,  3096,   275,   123,  2484,   338,   340,   408,   229,   286,
     406,  1644,  1812,  3237,   308,   209,   136,   354,   200,   286,
     843,   209,   349,   140,   225,   159,   849,   429,   430,   431,
     432,   433,   434,   945,   392,   888,   859,   159,   891,   198,
     313,  1519,   338,   433,   164,   231,  2407,   223,   366,   169,
     440,  2514,   172,   199,   945,   194,   179,   903,   392,   971,
     972,  2407,   974,   223,   105,   131,  1703,   979,  2286,  2061,
    2407,  2407,  2470,  2407,  2472,  2473,  2407,   410,   195,   902,
     971,   972,  1907,   974,   907,  1910,  1911,  2540,   979,   248,
     213,  1672,  1048,  1225,   388,   918,   230,   377,  1048,  1152,
     276,   277,   219,   289,   438,   198,   147,   321,   230,  2507,
     324,  2564,  1048,    76,   719,   720,   721,   234,   723,   124,
     725,   726,   727,   728,    56,   242,   731,   732,   733,   734,
     374,   345,   198,   195,   710,    98,   141,   119,   714,  3048,
    3241,  1121,    74,  1048,  3288,  1752,   263,   752,   153,   215,
     755,  1128,   757,   437,   759,   248,  2142,  1128,   763,   764,
     765,   445,   903,   768,   340,   770,   414,   772,   158,   417,
    1147,  3272,  3227,   155,   779,   780,  1147,  2163,  3034,  1811,
     340,   222,   248,   788,  3328,   194,   791,  2742,  2033,   794,
    1167,   105,   406,   798,   799,  1048,   440,   202,   803,   804,
     444,   806,  1048,   212,   809,  1128,   185,  3262,  1185,   368,
    3354,   370,   329,  2718,  2719,   414,   392,     5,   417,   209,
    2206,  2207,   827,   828,   299,   345,   267,   293,  1051,   834,
     827,   341,   392,   147,  1128,  1128,    83,  2454,  1215,   438,
      28,  2458,  1008,  1824,  1826,  2462,   321,  1227,  1225,   441,
     855,    39,   857,   850,   101,   860,   366,  3129,  1238,   357,
     358,   314,   438,   401,  1871,   121,  1032,   195,   425,   322,
     345,  1094,  1095,  1096,  1040,   368,  1883,   370,   441,   436,
     885,   886,   887,   440,     7,   890,  2439,    10,   199,   342,
    1897,   219,   402,   275,  1901,   412,   337,   208,   280,    22,
      23,   280,   368,  1283,   370,   284,   234,  1048,   222,   402,
     299,   442,   888,   379,   242,   891,   414,   406,   407,   417,
      43,  1144,   388,    46,   299,   177,   308,   903,   116,   299,
    1307,  1308,   321,  1310,    76,   317,    45,   189,   299,  1162,
    1353,  1953,  1954,  1821,   441,  1387,   321,  1825,   439,   438,
     417,   321,  2921,   267,   445,   422,   345,   962,   963,   299,
     321,   966,  1342,   430,  1842,  2743,  1441,   406,   407,   400,
    1320,   417,  1340,   417,  1286,   227,  1288,  1289,   422,  1421,
     168,   321,   987,   414,  1320,   990,   417,  2141,   993,  2143,
    2144,   165,  1870,   245,  1872,  1286,  2033,  1288,  1289,   438,
     299,   329,   381,  1445,   436,   345,   388,   438,   440,  1371,
     389,   185,  1017,   299,  1371,  1320,   126,   415,  2050,  1331,
    2659,   131,   321,   337,   439,   324,  1904,  1383,  1378,  2827,
     445,  2794,  1429,  1383,   286,   321,  1433,   225,  1435,   446,
    1331,  1353,   294,   166,   225,  1357,   345,  1383,  2953,  1361,
    2955,  2956,   368,  1931,   370,   442,  1934,  1062,  1936,  1591,
    2216,  1066,   439,   439,   414,  1070,  1357,   417,   445,   445,
    1361,  1076,  1048,  1296,  1320,  1321,  1322,   439,  1383,  1084,
    2506,   116,   117,   445,  2568,  2569,    76,   414,   438,   231,
     417,  3190,  3191,  1098,  1099,  3194,  1101,  3196,  2323,    76,
      90,   275,    81,    20,  2329,  2330,   280,   406,    87,  1114,
     284,   438,   413,  2891,   414,   416,  1472,   417,   414,  2380,
    1605,   417,  1472,   414,   436,  1371,   417,   150,   440,   394,
    1383,  1136,  1378,   445,  1387,   387,  1472,  1383,   438,    38,
    1145,  1146,   438,   417,   123,  1150,  2179,   438,   422,   291,
     424,  1463,  1532,   406,   407,  1160,   430,   136,  1163,   415,
    1165,   436,   368,   438,   370,   440,  1543,  1472,  1421,   425,
     426,   427,  1463,   429,   430,   431,   432,   433,   434,  1320,
    1321,  1322,   285,   289,   207,   164,   289,   439,  2066,  2575,
     169,   439,  1445,   172,   289,   441,  2813,   445,   439,   445,
    2233,  2818,   438,  3108,   445,  2822,  2084,   381,    76,   441,
    1623,  1624,  1625,   445,  1591,   389,   441,   311,  1631,  1472,
     445,   439,  1635,  1636,  2308,   379,  1472,   445,  2235,  1642,
    1371,  2928,   443,   256,   445,   212,   259,  1378,  1651,  3119,
    1653,   231,  1383,   441,   406,   407,   439,   445,   414,   111,
    1630,   417,   445,  1666,   231,  1668,   414,   414,   414,   417,
     417,   417,   323,  1575,  1269,  1270,   406,   407,   406,   407,
     133,  2253,   438,   415,   414,   215,   414,   417,  1283,   417,
     438,   438,   438,  1288,  1289,   406,   407,   429,   430,   431,
     432,   433,   434,  1298,  1307,  1308,    76,  1310,   438,  1676,
     438,   291,   414,  2310,  2311,   417,   438,  2638,  3086,   130,
      90,  1623,  1624,  1625,   291,   338,  1672,   414,   229,  1631,
     417,   183,  1672,  1635,  1636,   422,   439,   424,  1551,  1552,
    1642,  1472,   445,   430,   439,  1340,  1672,  1342,   310,  1651,
     445,  1653,   321,   237,  1320,  1321,  1322,  2380,   210,  1729,
     289,   439,   173,   439,  1666,   194,  1668,   445,  1811,   445,
    1583,   121,   443,   231,   445,   439,   345,  1672,  1373,  3167,
     414,   445,  1595,   417,  1075,    76,   439,    99,   422,   439,
     424,    76,   445,  1745,   411,   445,   430,   410,  1745,    90,
     413,   414,   233,   416,   417,  1371,   406,   407,  2379,   439,
    3017,  1713,  1378,    98,   440,   445,  2722,  1383,  1109,   292,
    1779,  1387,  1781,   414,  2292,  1420,   417,  3034,   422,  1672,
     424,   439,  1802,   291,  2803,   415,  1672,   445,   439,   414,
     251,  2468,   417,   289,   445,   425,   426,   427,   415,   429,
     430,   431,   432,   433,   434,  1421,   121,   289,   425,   426,
     427,   231,   429,   430,   431,   432,   433,   434,  2484,  1464,
     436,   439,   438,  1468,   326,   327,   439,   445,  1824,  1445,
    1307,  1308,   445,  1310,  1824,   411,  1699,   339,   299,   429,
     430,   431,   432,   433,  1796,   374,  1899,   414,  1824,   439,
     417,   353,   368,  2025,   370,   439,  1472,  3342,   360,  1745,
    1812,   445,  1814,    99,  1816,  1796,   439,   439,   411,   155,
    2522,   291,   445,   445,  1519,   368,  1521,   370,   439,  1824,
     439,  1812,   233,  1814,   445,  1816,   445,  1532,  1751,   345,
     231,  1672,   439,  1779,   439,  1781,   231,   232,   445,   431,
     445,   403,   193,  1548,   439,  1991,   367,   415,   369,   439,
     445,  1556,   431,   432,   433,  1968,  1561,   425,   426,   427,
    1973,   429,   430,   431,   432,   433,   434,   439,   439,   439,
     441,  1824,   441,    93,  1579,   445,  1581,  1582,  1824,  1584,
    1960,    85,   228,   278,   109,  1286,  1591,  1899,   439,   225,
     291,   111,  1154,  1155,   445,  1907,   431,  2050,  1910,  1911,
    1605,   439,   248,  1608,  1745,  3222,   439,   445,  2486,   439,
    3307,   439,   445,  2236,  2237,   445,  1907,   445,   442,  1910,
    1911,   429,   430,   431,   432,   433,   439,  2238,  2239,   437,
    2508,  2163,   445,   442,   439,   415,   441,  2017,  1779,  1644,
    1781,   920,  2459,   922,  2461,   425,   426,   427,  2025,   429,
     430,   431,   432,   433,   434,   415,  1968,   964,   965,   374,
     374,  1973,   374,   183,   374,   425,   426,   427,   374,   429,
     430,   431,   432,   433,   434,   175,    93,   109,   394,  1380,
    2093,   446,   225,  1824,   231,   374,   438,   438,   438,   438,
     210,  3077,  2199,  2200,   438,   440,  1672,   299,   438,   321,
    1705,   438,   440,   345,   289,  1406,   441,   243,   438,   283,
     237,   438,   406,   119,   415,   406,    93,   237,  1419,   291,
     406,    99,   299,    99,   425,   426,   427,   237,   429,   430,
     431,   432,   433,   434,   429,   430,   431,   432,   433,   434,
     415,   394,  1747,   445,   289,   438,   438,  1752,   289,   190,
     425,   426,   427,    76,   429,   430,   431,   432,   433,   434,
    1461,   243,   189,    93,   438,  1988,   438,   413,   414,  1745,
     416,   417,   438,   438,   438,    98,   422,   438,   424,   438,
     103,  2093,   304,   438,   430,   243,  2163,  1488,  2011,   438,
     438,   438,   231,  1646,   438,  2018,   189,  1802,   438,  2176,
    1805,   438,   445,  1779,  2217,  1781,  1811,   327,   438,   438,
     438,   438,  1513,   438,   438,   438,  1821,  1822,  2195,   339,
    1825,  1826,   438,   431,   225,  1830,   338,  2204,   259,   154,
     445,  1836,   393,   353,    41,   440,  1841,  1842,    17,   445,
     360,   438,   374,   415,  1545,   438,   438,   289,  1824,  1550,
     374,   440,   119,   425,   426,   427,    93,   429,   430,   431,
     432,   433,   434,   374,   131,  1870,  1871,  1872,  1873,  1874,
     339,  1876,  1877,   374,   111,   374,   280,   374,  1883,   393,
     374,   374,   367,   403,   374,   445,   406,   394,   155,   212,
     157,   374,  1897,    93,   374,  2928,  1901,   126,   336,  1904,
    1905,  1906,   289,  2215,   375,  2217,   379,  2219,   231,   232,
     445,   111,   379,  1918,  1919,  1920,   336,  1922,  1923,  1924,
    1925,  1926,  1927,  1928,   374,   374,  1931,  1932,  2219,  1934,
    1935,  1936,  3324,   438,   374,   438,   289,   374,   231,   287,
     438,   400,   438,   438,    93,    83,   183,   438,  1953,  1954,
     155,   218,   251,   189,   402,   278,   289,   438,  2836,   438,
      93,   405,   337,  1968,    93,   394,    17,   445,   291,  1670,
     445,   425,  2385,   210,  2387,  2198,   374,   398,   438,   279,
     194,   438,   404,   183,  2447,    76,   372,  1992,   372,  3139,
     445,   345,   372,   438,  2447,   438,  2308,   194,   445,   425,
     237,   374,  2007,   377,   439,   227,   290,  2012,   275,  2014,
     210,  2323,   445,   280,   284,   445,   439,  2329,  2330,  2399,
    3027,  2026,   245,  2379,   436,  2030,  2031,    38,   439,  2379,
    3037,   130,  2323,   432,   235,  2040,   438,   237,  2329,  2330,
     235,   308,   438,  2379,   289,  2050,   280,   280,   280,   295,
     317,    76,   374,   374,  2932,   336,   445,  2434,  2438,  2439,
     439,  2066,   445,  2434,  2942,    90,  2944,   245,  2380,   414,
    2447,  2603,   391,  2385,  2379,  2387,  2447,  2454,   109,  2084,
     301,  2458,   301,   366,    93,  2462,  2398,   314,   231,  2380,
     327,   321,   415,  3119,   231,   231,   394,    82,  2605,  2606,
    2607,  2608,   339,   374,    89,   425,   429,   430,   431,   432,
     433,   434,   436,   374,  2527,   245,   353,   425,   189,  2496,
     289,   388,   293,   360,  2537,  2496,  2379,   327,    93,   203,
     206,   206,   189,  2379,  3146,   445,   105,   439,   439,   339,
      11,   445,    82,   128,   200,   258,  2151,   289,   445,   109,
     439,  3158,   439,   353,   439,   194,  1857,  1858,   411,   439,
     360,   146,   147,   439,   439,   439,   403,   140,   445,   154,
    3048,   439,   141,   158,  2179,  1075,   439,   439,   194,   439,
     411,   439,   439,   439,   439,   411,   438,   374,  2411,   438,
     425,   439,   161,   178,  2417,   180,   439,  1075,    34,   441,
     439,  2581,   245,   403,   445,   299,   231,   176,   221,  1109,
     195,  3223,   280,   441,  2219,  2527,   374,    76,   438,  2224,
     438,   190,   195,   439,   407,  2537,  2603,   374,   439,   439,
    2235,  1109,   231,   231,   436,   439,   205,   259,  2379,    98,
     439,   289,   323,   384,   103,  1946,   219,   438,  2253,   439,
    1951,   445,   287,   287,   374,   394,   289,   439,   438,   234,
     296,   234,   234,   438,   445,  1966,   291,   439,  2273,   242,
     425,   292,   178,  2126,  3307,   178,  2129,   436,   439,   175,
    3306,   194,    76,  2506,   189,   439,   439,  2292,  2293,  2294,
     263,   439,   117,   438,   202,   439,   415,   425,   425,   445,
     221,   374,   374,   231,   439,  2310,  2311,  2160,  2161,   336,
     374,   280,   438,  3339,   384,   374,   289,   176,   287,  2732,
     374,   439,   231,   162,  2737,  2738,  2739,  2740,  2741,   231,
     437,   235,  2745,   438,   394,   189,  2037,    93,   293,   217,
      93,    93,   397,   438,   313,   445,   438,  2659,   234,   208,
     438,   199,   438,   212,   194,   439,   329,   439,   284,   439,
    2365,   439,   194,   109,   280,   280,   204,   231,  2659,   438,
     394,   438,   231,   232,   439,   157,   218,   196,   196,   364,
     194,   215,  2387,   170,   437,   244,   394,  2610,  2611,   180,
     415,   156,   439,   156,   438,  2400,  2401,  2402,   194,   236,
     425,   426,   427,  2379,   429,   430,   431,   432,   433,   434,
     374,   189,  2789,   292,  2726,  2795,   439,   317,  2789,   278,
    2732,   394,    93,   438,   438,  2737,  2738,  2739,  2740,  2741,
    2435,   280,   291,  2745,  2439,  2726,  2813,   254,   367,   412,
     312,  2818,  2447,  2448,   287,  2822,  2451,   439,   289,    96,
     189,    93,   287,   128,   280,   367,   289,   170,   289,   289,
    2465,   438,   166,   445,   332,   392,    84,   160,   333,   445,
     333,   180,    80,   439,   228,   438,  1990,  1289,  2219,  1930,
    1380,  2486,  1875,   312,  2333,  2781,  2784,  2702,   316,  1918,
     349,  2982,  2497,  2270,  2791,  3269,   114,  3297,  3252,  3251,
    3278,  3136,  1380,  2508,  3212,  2786,  3012,  1529,   126,  3354,
    3328,  1976,  2966,  2965,  2379,   133,  3309,  2522,  1515,  1419,
    3355,  2744,  2935,   180,  2068,  1146,  2836,  3222,  1406,  2286,
    2801,   149,  1858,  1857,  3198,  2948,  3019,  3318,  3353,   901,
    1983,  1419,  2922,  1751,  2767,   156,  2497,  1128,  2048,   167,
    2830,  2230,  2775,  1315,  2240,  1314,   415,  1764,  1748,  2204,
    2460,  1461,  2025,  3035,  1488,  2580,  2779,   552,  2898,  2380,
     429,   430,   431,   432,   433,   434,  2176,  2095,   196,  2174,
    2960,  1700,  2925,  1461,  3235,  2286,  2287,  2224,  2289,  3047,
    1099,  1805,  1355,  1802,  1322,  2840,    74,   215,   969,   322,
    1777,   694,   997,  2304,  1152,  2306,   965,  1812,  2214,  2921,
    1488,  2056,  2831,  1513,  2920,  2057,  2993,  1267,  2642,   357,
     238,  2832,  2993,  2935,   609,  1816,  2051,  1574,   971,     2,
    2921,  2332,  1320,    -1,    -1,  1513,  2948,    -1,  3018,    -1,
      -1,    -1,    -1,    -1,    -1,  1545,    -1,    -1,    -1,    -1,
    1550,    -1,    -1,    -1,    -1,    -1,    -1,  3034,    -1,    -1,
      -1,  2362,    -1,    -1,    -1,    -1,    -1,  1545,    -1,  2674,
    2675,    -1,  1550,   291,    -1,    -1,    -1,    -1,  2126,  2380,
      -1,  2129,    -1,    -1,    -1,    -1,    -1,  2910,  2911,  2912,
    2913,  2544,    -1,   311,  2547,  2548,  2549,  2550,  2551,  2552,
    2553,  2554,  2555,  2556,  2709,  2710,    -1,    -1,    -1,    -1,
      -1,    -1,  2160,  2161,  2415,    -1,   334,    -1,   336,    -1,
      -1,    -1,    -1,   341,    -1,  2426,    -1,    -1,    -1,    -1,
      -1,    -1,  2737,  2738,  2739,  2740,  2741,    -1,    -1,  2440,
      -1,    -1,  2595,  2596,    -1,    -1,    -1,    -1,   366,    -1,
      -1,    -1,    -1,    -1,    -1,  2760,    -1,    -1,    -1,    -1,
      -1,   379,   747,    -1,  3144,    -1,   384,    -1,    -1,  3081,
    1670,    -1,    -1,    -1,  2779,    -1,  2781,    -1,    -1,  2784,
      -1,  2786,    -1,    -1,   402,    -1,  2791,  3164,    -1,    -1,
    3081,  2796,  1670,  3164,   779,   780,    -1,    -1,  3330,    -1,
      -1,    -1,    -1,    -1,  2809,    -1,  2811,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2823,  2520,
    2825,    -1,    -1,    -1,    -1,    -1,   811,    -1,    -1,    -1,
     815,  2836,   817,    -1,   819,    -1,    -1,    -1,    -1,    -1,
     825,   826,  2543,    -1,    -1,    -1,    -1,    -1,    -1,   834,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3238,    -1,
      -1,    -1,  3242,    -1,    -1,    -1,    -1,    -1,   853,  2570,
    3283,  3284,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2593,   878,    -1,    -1,    -1,    -1,  3121,    -1,
     885,   886,    -1,    -1,   889,   890,    -1,    -1,  2761,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3139,    -1,    -1,    -1,
    2925,    -1,    -1,  2928,    -1,  2930,   138,  2932,  2933,  2934,
      -1,  3154,    -1,    -1,    -1,    -1,    -1,  2942,  2943,  2944,
      -1,  3318,    -1,    -1,  2949,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3330,    -1,    -1,    -1,    -1,    -1,    -1,
     945,  3184,    -1,    -1,    -1,   177,    -1,    -1,    -1,    -1,
      -1,  3283,  3284,   185,    -1,    -1,  3353,   962,   963,  1857,
    1858,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2705,    -1,    -1,  3012,   220,   221,
      -1,    -1,  3017,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      76,    -1,  3027,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3037,    -1,    90,    -1,    -1,    -1,    -1,    -1,
    2893,  2894,    98,  3048,    -1,    -1,  1946,   103,    -1,    -1,
      -1,  1951,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      76,    -1,    -1,    -1,    -1,    -1,  1966,    -1,  1946,    -1,
      -1,  2772,    -1,  1951,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    -1,    -1,    -1,   103,  1966,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2544,    -1,    -1,  2547,
    2548,  2549,  2550,  2551,  2552,  2553,  2554,  2555,  2556,    -1,
      -1,    -1,    -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3129,    -1,  3131,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    98,  1121,  2037,    -1,    -1,
     103,  3146,    -1,    -1,    -1,  3150,  3151,  2595,  2596,    -1,
      -1,    -1,   208,  3158,  1139,    -1,   212,  1142,    -1,  2037,
     176,    -1,    -1,    -1,    -1,    -1,    -1,  1152,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   231,   232,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   244,    -1,
      -1,    -1,   208,    -1,    -1,    -1,   212,  2898,    -1,    -1,
      -1,  3206,    -1,  3056,    -1,  3058,  3211,    -1,    -1,    -1,
      -1,    -1,    -1,  3066,  3067,   231,   232,  3222,  3223,   275,
      -1,    -1,   278,    -1,    -1,    -1,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,    -1,   291,  3241,   293,    -1,    -1,
      -1,    -1,  1227,    -1,    -1,   208,    -1,    -1,    -1,   212,
      -1,    -1,    -1,  1238,  3259,    -1,  3261,    -1,    -1,    -1,
      -1,    -1,   278,    -1,    -1,    -1,    -1,  3272,   231,   232,
      -1,    -1,    -1,    -1,    -1,   291,    -1,    -1,    -1,  1264,
      -1,   244,    -1,  3288,  1269,  1270,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   349,    -1,    -1,    -1,    -1,  1283,    -1,
      -1,  1286,  3307,  1288,  1289,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2761,    -1,   278,  3169,  1075,    -1,    76,
      -1,    -1,    -1,  3328,    -1,    -1,    -1,    -1,   291,    -1,
      -1,    -1,    -1,   349,    -1,    -1,    -1,    -1,  3039,    -1,
      -1,    98,    -1,    -1,    -1,    -1,   103,    -1,    -1,  3354,
      -1,  1109,    -1,    -1,    -1,  1340,    -1,  1342,    -1,   415,
      -1,    -1,    -1,    -1,  3065,    -1,    -1,    -1,  1353,   425,
     426,   427,    -1,   429,   430,   431,   432,   433,   434,    -1,
      -1,   437,    -1,    -1,    -1,    -1,   349,    -1,    -1,    -1,
     446,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   415,
      -1,    -1,    -1,    -1,  2304,    -1,  2306,    -1,  2286,  2287,
      -1,  2289,    -1,   429,   430,   431,   432,   433,   434,   176,
      -1,    -1,    -1,    -1,    -1,    -1,  2304,    -1,  2306,    -1,
      -1,    -1,  2332,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2893,  2894,    -1,    -1,    -1,
      -1,   208,   415,    -1,  2332,   212,    -1,    -1,    -1,    -1,
      -1,    -1,  2362,   426,   427,    -1,   429,   430,   431,   432,
     433,   434,    -1,    -1,   231,   232,    -1,    -1,  1463,    -1,
      -1,    -1,    74,    -1,  2362,    77,    -1,   244,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    90,    -1,
      -1,    -1,  2380,    -1,    -1,    -1,   718,    -1,    -1,    -1,
     722,    -1,   724,    -1,    -1,  2415,    -1,   729,   730,    -1,
     112,   278,    -1,    -1,    -1,    -1,  2426,    -1,    -1,    -1,
      -1,    -1,  1075,    -1,   291,    -1,   128,  2415,   750,   751,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1532,  2426,    -1,
      -1,    -1,    -1,    -1,   146,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2440,    -1,    -1,    -1,  1109,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   786,   787,    -1,    -1,    -1,    -1,
      -1,   793,    -1,    -1,  3285,    -1,    -1,    -1,    -1,  1574,
    1575,    -1,   349,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   199,  3056,    -1,
    3058,    -1,    -1,    -1,   206,    -1,   208,    -1,  3066,  3067,
    2520,    -1,  1380,    -1,    -1,    -1,    -1,   219,    -1,    -1,
      -1,   843,    -1,    -1,    -1,    -1,    -1,   849,  1623,  1624,
    1625,  3342,  2520,  2543,    -1,  1630,  1631,   859,  1406,    -1,
    1635,  1636,    -1,    -1,    -1,    -1,    -1,  1642,   415,    -1,
      -1,  1419,    -1,    -1,    -1,  2543,  1651,    -1,  1653,    -1,
    2570,    -1,   429,   430,   431,   432,   433,   434,    -1,    -1,
      -1,  1666,    -1,  1668,    -1,    -1,    -1,    -1,    -1,    -1,
     902,    -1,  2570,  2593,    -1,   907,    76,    -1,    -1,    -1,
      -1,    -1,    -1,  1461,    -1,    -1,   918,    -1,    -1,    -1,
      90,    -1,   136,    -1,  1699,  2593,    -1,    -1,    98,    -1,
    1705,  3169,    -1,   103,    -1,    -1,    -1,    -1,  1713,   321,
    1488,    -1,    -1,    -1,    -1,    -1,    -1,    76,    -1,    -1,
      -1,    -1,    -1,    -1,  1729,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    -1,   177,    -1,  1513,    -1,    -1,    -1,    98,
      -1,    -1,    -1,    -1,   103,   189,   358,    -1,    -1,   361,
     194,    -1,    -1,    -1,    -1,   199,    -1,    -1,   202,    -1,
     204,    -1,    -1,    -1,    -1,    -1,    -1,  1545,    -1,    -1,
      -1,    -1,  1550,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   227,    -1,  2705,    -1,    -1,    -1,    -1,
      -1,  1796,    -1,    -1,    -1,    -1,    -1,  1802,    -1,    -1,
      -1,   245,    -1,    -1,    -1,    -1,  1811,  2705,   208,    -1,
      -1,    -1,   212,    -1,    -1,    -1,    -1,  1380,    -1,  1051,
    1052,    -1,    -1,    -1,    -1,    -1,  1058,    -1,    -1,    -1,
      -1,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   286,  1406,   244,    -1,    -1,    -1,    84,   208,
     294,    -1,  2772,   212,    -1,    -1,  1419,    -1,    -1,    -1,
      -1,    -1,  1094,  1095,  1096,    -1,    -1,    -1,  1100,    -1,
      -1,    -1,   231,   232,  2772,   275,    -1,    -1,   278,    -1,
      -1,    -1,    76,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   291,  1670,   293,  1899,    -1,    90,   133,  1461,    -1,
      -1,    -1,  1907,    -1,    98,  1910,  1911,    -1,    -1,   103,
      -1,    -1,  1144,   149,    -1,    -1,   275,    -1,    -1,   278,
      -1,    -1,   366,    -1,    -1,  1488,    -1,    -1,    -1,    -1,
    1162,   167,   291,    -1,   293,    -1,    -1,    -1,    -1,    -1,
     552,    -1,    -1,   387,    -1,    -1,    -1,  1952,    -1,   349,
    1513,  1956,    -1,   136,    -1,  1960,    -1,    -1,    -1,    -1,
     196,   405,    -1,  1968,    -1,    -1,   202,    -1,  1973,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2898,   215,
      -1,    -1,  1545,    -1,    -1,    -1,    -1,  1550,    -1,    -1,
     349,    -1,   436,    -1,   177,   439,   440,   441,    -1,    -1,
    2898,   237,    -1,    -1,    -1,    -1,   189,    -1,    -1,    -1,
      -1,   194,  2017,    -1,   208,   415,   199,    -1,   212,   202,
      -1,   204,    -1,    -1,    -1,   425,   426,   427,    -1,   429,
     430,   431,   432,   433,   434,    -1,    -1,   231,   232,   439,
      -1,    -1,    -1,    -1,   227,  2050,  2051,    -1,    -1,  2054,
     244,  2056,    -1,    -1,    -1,   291,   415,    -1,    -1,    -1,
      76,    -1,   245,    -1,  1296,    -1,   425,   426,   427,    -1,
     429,   430,   431,   432,   433,   434,    -1,    -1,    -1,  1857,
    1858,   275,    98,    -1,   278,    -1,   445,   103,  2093,    -1,
      -1,    -1,    -1,    -1,   330,    -1,    -1,   291,   710,   293,
     336,    -1,   714,   286,    -1,   341,   718,  1670,    -1,    -1,
     722,   294,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3039,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     366,   367,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   751,
      -1,  3039,    -1,   379,    -1,  3065,    -1,    -1,   384,    -1,
      -1,    -1,    -1,    -1,    -1,   349,    -1,   393,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3065,  1946,    -1,
      -1,    -1,   784,  1951,    -1,   787,    -1,    -1,    -1,    -1,
      -1,   793,    -1,   366,    -1,    -1,    -1,    -1,  1966,    -1,
      -1,    -1,   208,    -1,    -1,    -1,   212,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   387,    -1,    -1,    -1,    -1,  1441,
    2215,    -1,  2217,    -1,  2219,   231,   232,    -1,    -1,    -1,
      -1,   415,   405,    -1,    -1,    -1,    -1,    -1,   244,    -1,
      -1,   425,   426,   427,    -1,   429,   430,   431,   432,   433,
     434,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   445,    -1,   436,    -1,    -1,   439,   440,   441,  2037,
      -1,    -1,   278,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      76,   883,    -1,    -1,   886,   291,   888,    -1,    -1,   891,
      -1,    -1,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,
      -1,   903,    98,    -1,  1857,  1858,    -1,   103,    -1,    -1,
      -1,    -1,    -1,  2308,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1543,    -1,    -1,    -1,    76,    -1,    -1,  2323,  1551,
    1552,    -1,    -1,    -1,  2329,  2330,    -1,    -1,    -1,    90,
      -1,    -1,    -1,   349,    -1,    -1,    -1,    98,    -1,    -1,
      -1,    -1,   103,    -1,  1075,    -1,    -1,    -1,  1580,    -1,
      -1,  1583,    -1,    -1,    -1,    -1,    -1,    -1,  2363,  2364,
      -1,    -1,    -1,  1595,    -1,  3285,    -1,  2372,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2380,    -1,    -1,  1109,    -1,
    2385,    -1,  2387,  1946,    -1,    -1,    -1,  3285,  1951,    -1,
      -1,    -1,    -1,  2398,  2399,    -1,    -1,    -1,    -1,   415,
      -1,    -1,   208,  1966,    -1,    -1,   212,    -1,    -1,   425,
     426,   427,    -1,   429,   430,   431,   432,   433,   434,    -1,
      -1,    -1,  3342,    -1,    -1,   231,   232,    -1,    -1,    -1,
      -1,    -1,    -1,  2438,  2439,  1047,  1048,    -1,   244,    -1,
    1052,    -1,  2447,    -1,  3342,    -1,  1058,   208,    -1,    -1,
      -1,   212,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1075,    -1,    -1,    -1,  1699,    -1,   275,
     231,   232,   278,    -1,  2037,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   244,    -1,   291,    -1,   293,  1100,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1109,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2286,  2287,
      -1,  2289,    -1,    -1,   275,    -1,    -1,   278,    -1,  1751,
      -1,    -1,  2527,     2,    -1,    -1,  2304,    -1,  2306,    -1,
     291,    -1,  2537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   349,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2332,    -1,    -1,    -1,    -1,  1171,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2581,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2362,    -1,  1198,    -1,   349,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2380,    82,    -1,    -1,    -1,    -1,    -1,   415,
    1222,  1223,    -1,  1225,    -1,    -1,    -1,    -1,    -1,   425,
     426,   427,    -1,   429,   430,   431,   432,   433,   434,    -1,
      -1,  1243,    -1,   439,    -1,    -1,    -1,  2415,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2426,  1380,
      -1,    -1,    -1,    -1,   415,    -1,    -1,  1269,  1270,    -1,
      -1,    -1,  2440,    -1,   425,   426,   427,    -1,   429,   430,
     431,   432,   433,   434,  1286,  1406,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1419,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1309,    76,   178,
    1312,  1313,    -1,    -1,    -1,    -1,    -1,    -1,  1320,  1321,
    1322,    -1,    90,  2718,  2719,    -1,    94,    -1,    -1,    -1,
      98,    -1,    -1,  2286,  2287,   103,  2289,  2732,  1340,    -1,
    1461,    -1,  2737,  2738,  2739,  2740,  2741,    -1,    -1,    -1,
    2745,  2304,  2520,  2306,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1988,  1488,    -1,  1371,
      -1,    -1,    -1,    -1,    -1,  2543,  1378,    -1,  1380,  2332,
      -1,  1383,    -1,    -1,    -1,  1387,    -1,    -1,    -1,  2011,
      -1,    -1,  1513,    -1,    -1,   163,  2018,    -1,    -1,    -1,
    2795,    -1,  2570,  2025,  1406,    -1,    -1,    -1,    -1,  2362,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1419,    -1,  1421,
      -1,    -1,    -1,    -1,  1545,  2593,    -1,  2380,    -1,  1550,
      -1,    -1,    -1,    -1,    -1,    -1,  2831,    -1,    -1,    -1,
     208,    -1,    -1,  1445,   212,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1461,
      -1,    -1,  2415,   231,   232,    -1,  1075,    -1,    -1,    -1,
    1472,    -1,    -1,  2426,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1488,  2440,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1109,    -1,    -1,    -1,    -1,    -1,    -1,   275,    -1,    -1,
     278,  1513,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   291,    -1,   293,  2921,  2922,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2705,    -1,    -1,
    2935,  1543,    -1,  1545,    -1,    -1,    -1,    -1,  1550,  1670,
      -1,    -1,    -1,  2948,    -1,    -1,    -1,    -1,  2953,    -1,
    2955,  2956,    -1,    -1,    -1,  2960,    -1,  2520,    -1,    -1,
      -1,    76,    -1,    -1,    -1,    -1,  2198,    -1,  1580,    -1,
      -1,   349,  2204,    -1,    -1,    90,    -1,    -1,    -1,    -1,
    2543,    -1,    -1,    98,    -1,    -1,    -1,    -1,   103,    -1,
      -1,    -1,    -1,    -1,  2772,    -1,    -1,    -1,  1610,  1611,
      -1,    -1,    -1,    -1,    -1,    -1,  1618,  2570,    -1,  1621,
    1622,    -1,    -1,  3018,    -1,    -1,   394,    -1,  1630,    -1,
      -1,  1633,  1634,    -1,    -1,    -1,    -1,    -1,    -1,  1641,
    2593,    -1,    -1,  1645,  1646,  1647,  1648,   415,    -1,    90,
      -1,    -1,    -1,  1655,  1656,    -1,    -1,   425,   426,   427,
      -1,   429,   430,   431,   432,   433,   434,    -1,  1670,  1671,
    1672,   112,    -1,  1675,    -1,    -1,    -1,  1679,    -1,    -1,
      -1,  1683,    -1,    -1,  1686,  1687,  1688,  1689,  1690,  1691,
    1692,  1693,  1694,    -1,  1696,    -1,    -1,    -1,  1700,    -1,
      -1,    -1,  1704,   208,    -1,    -1,    -1,   212,    -1,    -1,
      -1,    -1,    -1,  3108,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   231,   232,    -1,    -1,
    2898,    -1,    -1,    -1,    -1,    -1,  1857,  1858,    -1,   244,
      -1,    -1,    -1,  1745,    -1,    -1,    -1,    -1,    -1,  3144,
      -1,    -1,  2705,    -1,    -1,    -1,    -1,    -1,   199,    -1,
      -1,    -1,    -1,    -1,    -1,   206,    -1,   208,    -1,    -1,
     275,  1380,    -1,   278,    -1,    -1,    -1,  1779,   219,  1781,
      -1,    -1,    -1,    -1,    -1,    -1,   291,    -1,   293,  2411,
      -1,    -1,    -1,    -1,    -1,  2417,    -1,  1406,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1419,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2772,
      -1,   690,  1824,    -1,    -1,  1946,    -1,    -1,    -1,    -1,
    1951,    -1,  2454,    -1,    -1,    -1,  2458,  1839,    -1,    -1,
    2462,    -1,    -1,  3238,   349,  1966,    -1,  3242,    -1,    -1,
      -1,    -1,  1461,    -1,    -1,  1857,  1858,    -1,    -1,    -1,
      76,    -1,  2484,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3039,    -1,    -1,    -1,    -1,    -1,    -1,   747,  1488,
      -1,    -1,    98,    -1,  2506,    -1,    -1,   103,  3283,  3284,
      -1,    -1,    -1,  3288,    -1,    -1,    -1,  3065,    -1,    -1,
      -1,    -1,    -1,    -1,  1513,    -1,    -1,    -1,    -1,    -1,
     415,    -1,    -1,    -1,    -1,    -1,  2037,    -1,    -1,    -1,
     425,   426,   427,    -1,   429,   430,   431,   432,   433,   434,
      -1,    -1,    -1,  3328,   439,    -1,  1545,    -1,    -1,    -1,
      -1,  1550,    -1,  1945,  1946,  2898,    -1,    -1,    -1,  1951,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3354,
     176,    -1,  1964,    -1,  1966,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   853,    -1,    -1,    -1,  2610,  2611,
      -1,    -1,   208,    -1,    -1,    -1,   212,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   878,
      -1,    -1,    -1,    -1,    -1,   231,   232,    -1,    -1,    -1,
     889,   890,    -1,  2025,    -1,    -1,    -1,    -1,   244,    -1,
      -1,    -1,  2034,    -1,    -1,  2037,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1670,   278,    -1,    -1,    -1,    84,    -1,  2070,    -1,
      -1,    -1,    -1,    -1,    -1,   291,    -1,    95,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3039,    -1,    -1,    -1,
      -1,    -1,  2094,   962,   963,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   971,   972,    -1,   974,    -1,    -1,    -1,    -1,
     979,    -1,  3065,    -1,    -1,   133,    -1,  3285,    -1,    -1,
      -1,    -1,  2744,    -1,  2126,    -1,    -1,  2129,    -1,    -1,
      -1,   149,    -1,   349,    -1,    -1,    -1,    -1,    -1,  2141,
    2142,  2143,  2144,    -1,    -1,  2767,    -1,    -1,  2150,   167,
      -1,    -1,    -1,  2775,    -1,    -1,    -1,    -1,  2160,  2161,
      -1,  2163,    -1,    -1,    -1,  2286,  2287,    -1,  2289,    -1,
      -1,    -1,    -1,  2175,  3342,  2177,    -1,    -1,   196,  2181,
      -1,    -1,    -1,  2304,   202,  2306,    -1,    -1,    -1,    -1,
      -1,  2813,    -1,    -1,    -1,    -1,  2818,   215,    -1,   415,
    2822,    -1,  2204,    -1,  2206,  2207,    -1,    -1,    -1,    -1,
      -1,  2332,    -1,   429,   430,   431,   432,   433,   434,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2230,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2238,  2239,  2240,    -1,
      -1,  2362,    -1,    -1,    -1,    -1,    -1,    -1,  1857,  1858,
      -1,    -1,  1121,    -1,    -1,    -1,    -1,    -1,    -1,  2380,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2269,    -1,   710,
      -1,    -1,    -1,   291,    -1,    -1,    -1,   718,    -1,    -1,
      -1,   722,    -1,    -1,  2286,  2287,    -1,  2289,  2910,  2911,
    2912,  2913,    -1,   311,  2415,    -1,    -1,    -1,    -1,    76,
      -1,    -1,  2304,    -1,  2306,  2426,    -1,    -1,    -1,    -1,
     751,    -1,   330,    90,    -1,    -1,   334,    -1,   336,  2440,
      -1,    98,    -1,   341,    -1,    -1,   103,    -1,    -1,    -1,
    2332,    -1,  3285,    -1,    -1,    -1,    -1,  1946,    -1,    -1,
      -1,    -1,  1951,    -1,    -1,    -1,   787,    -1,   366,   367,
      -1,    -1,   793,    -1,    -1,    -1,    -1,  1966,  1227,    -1,
    2362,   379,    -1,    -1,    -1,    -1,   384,    -1,    -1,  1238,
      -1,    -1,    -1,    -1,    -1,   393,    -1,  2379,  2380,    -1,
      -1,    -1,    -1,    -1,   402,    -1,    -1,    -1,    76,  3342,
      -1,    -1,    -1,    -1,    -1,  3017,    -1,    -1,    -1,  2520,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,  3034,  2415,  1283,   103,    -1,  1286,    -1,  1288,
    1289,    -1,  2543,    -1,  2426,    -1,    -1,    -1,  2037,    -1,
      -1,   208,    -1,    -1,    -1,   212,    -1,    -1,  2440,    -1,
      -1,    -1,   883,    -1,    -1,    -1,    -1,   888,    -1,  2570,
     891,    -1,  2454,    -1,   231,   232,  2458,    -1,    -1,    -1,
    2462,    -1,    -1,    -1,    -1,    -1,    -1,   244,    -1,    -1,
      -1,    -1,  2593,  1342,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2484,    -1,    -1,    -1,    -1,    -1,  1357,    -1,
      -1,    -1,  1361,    -1,    -1,    -1,    -1,  3119,   275,  3121,
      -1,   278,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2511,
      -1,    -1,    -1,    -1,   291,  2517,   293,  3139,  2520,    -1,
     208,    -1,    -1,    -1,   212,    -1,    -1,  2529,    -1,    -1,
      -1,    -1,  3154,  2535,    -1,    -1,    -1,  2539,    -1,    -1,
      -1,  2543,  2544,   231,   232,  2547,  2548,  2549,  2550,  2551,
    2552,  2553,  2554,  2555,  2556,    -1,   244,    -1,    -1,  2561,
    2562,    -1,  3184,    -1,    -1,    -1,    -1,    -1,  2570,    -1,
      -1,    -1,   349,  2575,    -1,    -1,    -1,    -1,    -1,    -1,
    2582,    -1,    -1,  2585,  2705,  2587,    -1,   275,    -1,    -1,
     278,  2593,  2594,  2595,  2596,    -1,    -1,    -1,  2600,    -1,
    3222,  2603,    -1,   291,    -1,   293,  1047,  1048,    -1,    -1,
      -1,  1052,    -1,    -1,    -1,    -1,    -1,  1058,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1075,    -1,    -1,    -1,   415,    -1,
      -1,    -1,    -1,    -1,    76,  2647,    -1,    -1,   425,   426,
     427,  2772,   429,   430,   431,   432,   433,   434,    90,  1100,
      -1,   349,   439,  1532,    -1,    -1,    98,    -1,  1109,    -1,
      -1,   103,    -1,    -1,    -1,    -1,    82,  2286,  2287,    -1,
    2289,    -1,    -1,    -1,  3306,    -1,    76,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2304,    -1,  2306,    -1,    -1,
      -1,    -1,    -1,  2705,    -1,    -1,    -1,    -1,    98,    -1,
      -1,    -1,    -1,   103,    -1,    -1,    -1,  3339,    -1,    -1,
      -1,    -1,    -1,  2332,    -1,    -1,    -1,   415,    -1,    -1,
    1171,    -1,    -1,    -1,    -1,    -1,    -1,   425,   426,   427,
      -1,   429,   430,   431,   432,   433,   434,    -1,    -1,    -1,
      -1,   439,   158,  2362,    -1,    -1,    -1,  1198,    -1,  2761,
      -1,  1630,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2772,  2380,   178,    -1,   180,    -1,   208,  2898,    -1,    -1,
     212,  1222,  1223,    -1,  1225,    -1,   176,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   231,
     232,    -1,  1243,    -1,    -1,    -1,  2415,    -1,    -1,    -1,
      -1,  2813,   244,    -1,    -1,    -1,  2818,  2426,   208,    -1,
    2822,    -1,   212,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2440,    -1,    -1,    -1,    -1,    -1,    -1,  2840,    -1,
      -1,   231,   232,   275,    -1,    -1,   278,    -1,    -1,    -1,
    2852,    -1,    -1,    -1,   244,    -1,    -1,    -1,    -1,   291,
    1729,   293,    -1,    -1,    -1,    -1,    -1,    -1,  1309,    -1,
      -1,  1312,  1313,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   278,    -1,
      -1,  2893,  2894,    -1,    -1,    -1,  2898,    -1,    -1,    -1,
      -1,   291,  2904,  2905,    -1,    -1,  2908,    -1,    -1,    -1,
      -1,  2520,    -1,    -1,    -1,    -1,    -1,   349,  3039,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1802,  2543,    -1,    -1,    -1,    -1,  1380,
      -1,    -1,  1383,  1812,  3065,  1814,  1387,  1816,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   349,
      -1,  2570,    -1,    -1,    -1,  1406,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1419,  2981,
    1421,    -1,    -1,   415,  2593,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   425,   426,   427,    -1,   429,   430,   431,
     432,   433,   434,    -1,  1445,    -1,    -1,   439,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3017,    -1,    -1,    -1,    -1,
    1461,    -1,    -1,    -1,    -1,   415,    -1,  1896,  3030,    -1,
      -1,  1472,  3034,    -1,    -1,    -1,    -1,  3039,    -1,   429,
     430,   431,   432,   433,   434,  3047,    -1,  1488,    -1,    -1,
      -1,    -1,    -1,    -1,  3056,    -1,  3058,    -1,    -1,    -1,
      -1,    -1,    -1,  3065,  3066,  3067,    -1,    -1,  3070,    -1,
      -1,    -1,  1513,    -1,    -1,  3077,  3078,    -1,    -1,    -1,
      -1,    -1,    -1,  1952,    -1,  3087,    -1,  1956,    -1,    -1,
      -1,  1960,    -1,    -1,    -1,    -1,  2705,    -1,    -1,  1968,
      -1,    -1,  1543,  3105,  1545,    -1,    -1,    -1,    -1,  1550,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3119,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2001,    -1,    -1,    -1,    -1,    -1,    -1,  1580,
      -1,    -1,    -1,    -1,    -1,  3147,    -1,    -1,  2017,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2772,  3285,    -1,    -1,  3169,    -1,  1610,
    1611,    -1,    -1,    -1,    -1,    -1,    -1,  1618,    -1,    -1,
    1621,  1622,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1633,  1634,    -1,    -1,    -1,    76,    -1,    -1,
    1641,    -1,    -1,    -1,  1645,  1646,  1647,  1648,    -1,    -1,
      -1,    90,    -1,    -1,  1655,  1656,    -1,    -1,    -1,    98,
    3222,  3342,    -1,    -1,   103,    -1,    -1,    -1,    -1,  1670,
    1671,  1672,    -1,  3235,  1675,    -1,    -1,    -1,  1679,    -1,
      -1,    -1,  1683,    -1,    -1,  1686,  1687,  1688,  1689,  1690,
    1691,  1692,  1693,  1694,    -1,  1696,    -1,    -1,    -1,  1700,
      -1,    -1,    -1,  1704,    -1,    -1,    -1,    -1,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,    -1,
      -1,    -1,    -1,  3285,    -1,    -1,    -1,    -1,    -1,  2898,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3306,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   147,    -1,    -1,   150,    -1,    -1,   208,
     154,    -1,    -1,   212,   158,    -1,    -1,  3339,    -1,    -1,
    3342,   747,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2219,    -1,   231,   232,    -1,    -1,   180,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   195,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1824,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   275,    -1,  1839,   278,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   815,
      -1,   817,   291,   819,   293,    -1,  1857,  1858,    -1,   825,
     826,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3039,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2309,    -1,    -1,    -1,    -1,    82,  2315,   853,  2317,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3065,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     349,    -1,   878,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   889,   890,    -1,    -1,  1075,    -1,    -1,
      -1,    -1,    -1,   130,  2363,  2364,    -1,    -1,    -1,    -1,
     137,   138,    -1,  2372,  1945,  1946,    -1,    -1,    -1,    -1,
    1951,  2380,    -1,    -1,    -1,    -1,    -1,    -1,  2387,    -1,
      -1,  1109,    -1,  1964,    -1,  1966,    -1,    -1,    -1,  2398,
    2399,    -1,    -1,    -1,    -1,    -1,   415,   174,    -1,   945,
     364,    -1,    -1,    -1,    -1,    -1,   425,   426,   427,    -1,
     429,   430,   431,   432,   433,   434,   962,   963,    -1,    -1,
     439,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2438,
    2439,    -1,    -1,   979,    -1,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,    -1,  2025,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2034,    -1,    -1,  2037,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   253,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2070,
      -1,   268,   269,    -1,   271,   272,    -1,   274,    76,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    90,  2094,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    -1,    -1,   301,   103,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3285,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2126,    -1,    -1,  2129,    -1,
      -1,    -1,    -1,   330,    -1,    -1,    -1,    -1,    -1,    -1,
    2141,  2142,  2143,  2144,    -1,    -1,    -1,    -1,    -1,  2150,
      -1,    -1,  2581,    -1,    -1,  1121,    -1,    -1,    -1,  2160,
    2161,    -1,  2163,    -1,    -1,   362,    -1,   364,    -1,    -1,
      -1,    -1,    -1,  3342,  2175,    -1,  2177,    -1,    -1,    -1,
    2181,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   386,
      -1,    -1,    -1,    -1,    -1,    -1,   393,    -1,    -1,   396,
      -1,    -1,    -1,  2204,    -1,  2206,  2207,    -1,    -1,    -1,
     208,    -1,   596,   597,   212,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2230,
    2659,    -1,  1380,   231,   232,    -1,    -1,  2238,  2239,  2240,
      -1,    -1,    -1,    -1,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1406,    -1,
      -1,  1227,    -1,    -1,    -1,    -1,    -1,    -1,  2269,    -1,
      -1,  1419,  1238,    -1,    -1,    -1,    -1,   275,    -1,    -1,
     278,    -1,    -1,    -1,    -1,  2286,  2287,    -1,  2289,  2718,
    2719,    -1,    -1,   291,    -1,   293,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2304,    -1,  2306,    -1,    -1,  2737,  2738,
    2739,  2740,  2741,  1461,    -1,    -1,    -1,  1283,    -1,    -1,
    1286,    -1,  1288,  1289,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2332,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1488,   725,    -1,    -1,   728,    -1,    -1,   731,   732,    -1,
      -1,   349,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2362,    -1,    -1,    -1,  1513,  2795,    -1,   752,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1342,    -1,  2379,  2380,
      -1,   765,    -1,    -1,   768,    -1,    -1,  1353,    -1,  1075,
      -1,    -1,    -1,    -1,    -1,   779,   780,  1545,    -1,    -1,
      -1,    -1,  1550,    -1,   788,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2415,   799,    -1,   415,    -1,   803,
     804,    -1,    -1,  1109,    -1,  2426,    -1,   425,   426,   427,
      -1,   429,   430,   431,   432,   433,   434,    -1,    -1,  2440,
      -1,   439,    -1,   827,   828,    -1,    -1,    -1,    -1,    -1,
     834,    -1,    -1,  2454,    -1,    -1,    -1,  2458,    -1,    -1,
      -1,  2462,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   855,    -1,   857,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2484,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2921,  2922,    -1,    -1,    -1,  1463,    -1,    -1,
      -1,   885,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2511,    -1,    -1,    -1,    -1,    -1,  2517,    -1,    -1,  2520,
      -1,    -1,  1670,    -1,  2953,    -1,  2955,  2956,  2529,    -1,
      -1,  2960,    -1,    -1,  2535,    -1,    -1,    -1,  2539,    -1,
      -1,    -1,  2543,  2544,    -1,    -1,  2547,  2548,  2549,  2550,
    2551,  2552,  2553,  2554,  2555,  2556,    -1,    -1,    -1,    -1,
    2561,  2562,    -1,    -1,    -1,    -1,  1532,    -1,    -1,  2570,
      -1,    -1,    -1,    -1,  2575,    -1,    -1,    -1,    -1,    -1,
      -1,  2582,    -1,    -1,  2585,    -1,  2587,    -1,    -1,  3018,
      -1,    -1,  2593,  2594,  2595,  2596,    -1,    -1,    -1,  2600,
      -1,    -1,  2603,   987,    -1,    -1,   990,    -1,    -1,   993,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,    -1,    -1,   103,    -1,  2647,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1623,  1624,  1625,
      -1,    -1,    -1,    -1,  1630,  1631,    -1,    -1,    -1,  1635,
    1636,    -1,    -1,    -1,    -1,    -1,  1642,    -1,  1062,  3108,
      -1,    -1,  1066,    -1,    -1,  1651,  1070,  1653,    -1,    -1,
      -1,    -1,  1076,    -1,  1380,    -1,    -1,    -1,    -1,    -1,
    1666,    -1,  1668,    -1,  2705,    -1,    -1,    -1,    -1,  1857,
    1858,    -1,    -1,    -1,    -1,  3144,    -1,  1101,    -1,    -1,
    1406,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1419,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   208,
      -1,    -1,  1136,   212,    -1,    -1,    -1,    -1,   199,    -1,
    2761,    -1,    -1,  1729,    -1,   206,  1150,   208,    -1,    -1,
      -1,  2772,   231,   232,    -1,  1461,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1946,    -1,
      -1,    -1,  1488,  1951,    -1,    -1,    -1,    -1,    -1,  3238,
    3239,    -1,  2813,  3242,  3243,    -1,   275,  2818,  1966,   278,
      -1,  2822,    -1,    -1,    -1,    -1,    -1,  1513,    -1,    -1,
    1796,    -1,   291,    -1,   293,    -1,  1802,    -1,    -1,  2840,
      -1,    -1,    -1,    -1,    -1,    -1,  1812,    -1,    -1,    -1,
      -1,  2852,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1545,
      -1,    -1,    -1,    -1,  1550,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    76,    -1,    -1,  2037,
     349,    -1,  2893,  2894,    -1,    -1,    -1,  2898,    -1,    -1,
      90,    -1,    -1,  2904,  2905,    -1,    -1,  2908,    98,    -1,
      -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1899,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1907,    -1,    -1,  1910,  1911,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   415,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   425,   426,   427,    -1,
     429,   430,   431,   432,   433,   434,    -1,    -1,   437,    76,
    2981,    -1,    -1,    -1,  1670,    -1,  1952,    -1,    -1,  1373,
    1956,    -1,    -1,    90,  1960,    -1,    93,    -1,    -1,   189,
      -1,    98,  1968,    -1,   194,    -1,   103,  1973,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3017,    -1,   208,    -1,
      -1,    -1,   212,    -1,    -1,    -1,    -1,    -1,    -1,  3030,
      -1,    -1,    -1,  3034,    -1,    -1,    -1,    -1,  3039,    -1,
      -1,   231,   232,    -1,    -1,    -1,  3047,    -1,    -1,    -1,
    1075,  2017,    -1,    -1,   244,  3056,    -1,  3058,    -1,    -1,
      -1,    -1,    -1,    -1,  3065,  3066,  3067,    -1,    -1,  3070,
      -1,    -1,    -1,    -1,    -1,    -1,  3077,  3078,    -1,    -1,
      -1,    -1,    -1,    -1,  1109,   275,  3087,    -1,   278,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   291,    -1,   293,  3105,    -1,    -1,    -1,    -1,    -1,
      -1,   208,    -1,    -1,    -1,   212,    -1,    -1,  3119,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2093,    -1,    -1,
      -1,    -1,    -1,    -1,   231,   232,    -1,  1521,  2286,  2287,
      -1,  2289,    -1,    -1,    -1,    -1,  3147,   244,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2304,    -1,  2306,   349,
      -1,    -1,    -1,    -1,  1548,    -1,    -1,    -1,  3169,    -1,
      -1,  1857,  1858,    -1,    -1,    -1,    -1,  1561,   275,    -1,
      -1,   278,    -1,    -1,  2332,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   291,    -1,   293,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2362,    -1,    -1,    -1,    -1,    -1,
      -1,  3222,    -1,    -1,    -1,   415,    -1,    -1,    -1,    -1,
      -1,    -1,  2380,    -1,  3235,   425,   426,   427,    -1,   429,
     430,   431,   432,   433,   434,    -1,    -1,    -1,    -1,    -1,
      -1,  2217,   349,  2219,    -1,    -1,    -1,    -1,    -1,    -1,
    1946,    -1,    -1,    -1,    -1,  1951,    -1,  2415,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   718,  2426,    -1,
    1966,   722,    -1,    -1,  3285,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2440,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3306,    -1,    -1,    -1,    -1,
     751,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   415,    -1,
      -1,  1705,    -1,    -1,    -1,    -1,    -1,    -1,   425,   426,
     427,    -1,   429,   430,   431,   432,   433,   434,  3339,    -1,
      -1,  3342,  2308,    -1,    -1,    -1,   787,    -1,    76,    -1,
      -1,  2037,   793,    -1,    -1,  1380,    -1,  2323,    -1,    -1,
      -1,    -1,    90,  2329,  2330,    93,    -1,    -1,    -1,    -1,
      98,    -1,  2520,    -1,    -1,   103,    -1,    -1,    -1,    -1,
      -1,  1406,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1419,  2543,    -1,  2363,  2364,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2372,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2380,    -1,    -1,    -1,    -1,  2385,
      -1,  2387,  2570,    -1,    -1,    -1,    -1,  1811,    -1,    -1,
      -1,    -1,  2398,  2399,    -1,    -1,  1461,    76,  1822,    -1,
      -1,    -1,   883,    -1,    -1,  2593,  1830,   888,    -1,    -1,
     891,    90,  1836,    -1,    -1,    -1,    -1,  1841,    -1,    98,
      -1,    -1,    -1,  1488,   103,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2438,  2439,    -1,    -1,    -1,    -1,    -1,    -1,
     208,    -1,    -1,    -1,   212,    -1,    -1,    -1,  1513,  1873,
    1874,    -1,  1876,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   231,   232,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   244,    -1,    -1,    -1,
    1545,  1905,  1906,    -1,    -1,  1550,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1920,    -1,  1922,  1923,
      -1,  1925,  1926,  1927,  1928,    -1,    -1,   275,  1932,    -1,
     278,  1935,    -1,    -1,    -1,    -1,    -1,  2705,    -1,    -1,
      -1,  2527,    -1,   291,    -1,   293,    -1,    -1,    -1,   208,
      -1,  2537,    -1,   212,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,
    2286,  2287,    -1,  2289,    -1,   244,  1047,    -1,    -1,    -1,
      -1,  1052,    -1,    -1,    -1,  2581,    -1,  1058,  2304,    -1,
    2306,   349,    -1,    -1,  2772,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1075,    -1,   275,    -1,    -1,   278,
      -1,    -1,    -1,    -1,    -1,  1670,  2332,    -1,    -1,    -1,
      -1,    -1,   291,    -1,   293,    -1,    -1,    -1,    -1,  1100,
      -1,    -1,    -1,    -1,    -1,    -1,  2050,    -1,  1109,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2362,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    76,   415,    -1,    -1,
      -1,    -1,    -1,    -1,  2380,    -1,    -1,   425,   426,   427,
      90,   429,   430,   431,   432,   433,   434,    -1,    98,    -1,
     349,    -1,    -1,   103,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2415,
    1171,    -1,    -1,    -1,    76,    -1,    -1,    -1,    -1,    -1,
    2426,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,
    2898,    93,  2718,  2719,  2440,   394,    98,  1198,    -1,    -1,
      -1,   103,    -1,    -1,    -1,    -1,  2732,    -1,    -1,    -1,
      -1,  2737,  2738,  2739,  2740,  2741,   415,    -1,    -1,  2745,
      -1,  1222,  1223,    -1,  1225,    -1,   425,   426,   427,    -1,
     429,   430,   431,   432,   433,   434,    -1,    -1,    -1,    -1,
      -1,    -1,  1243,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   208,    -1,
      -1,    -1,   212,    -1,    -1,    -1,    -1,    -1,    -1,  2795,
      -1,    -1,  1857,  1858,  2520,    -1,    -1,    -1,    -1,    -1,
      -1,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   244,    -1,    -1,  2543,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   208,    -1,  1309,    -1,
     212,  1312,  1313,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2570,   275,    -1,    -1,   278,   231,
     232,  3039,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   291,   244,   293,    -1,    -1,    -1,  2593,    -1,  2293,
    2294,    -1,   302,    -1,    -1,    -1,    -1,  3065,    -1,    -1,
      -1,  1946,    -1,    -1,    -1,    -1,  1951,    -1,    -1,    -1,
      -1,    -1,    -1,   275,    -1,    -1,   278,    -1,    -1,  1380,
      -1,  1966,    -1,    -1,    76,    -1,  1387,    -1,    -1,   291,
      -1,   293,    -1,    -1,    -1,    -1,  2922,    -1,    90,   349,
      -1,    -1,    -1,    -1,    -1,  1406,    98,    -1,    -1,  2935,
      -1,   103,    -1,    -1,    -1,    -1,    -1,    -1,  1419,    -1,
    1421,    -1,  2948,    -1,    -1,    -1,    -1,  2953,    -1,  2955,
    2956,    -1,    -1,    -1,  2960,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1445,    -1,    -1,   349,    -1,    -1,
      -1,    -1,  2037,    -1,    -1,    -1,  2400,  2401,  2402,  2705,
    1461,    -1,    -1,    -1,    -1,   415,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   425,   426,   427,    -1,   429,
     430,   431,   432,   433,   434,    -1,    -1,  1488,    -1,    -1,
      -1,  2435,  3018,    -1,    -1,    76,    -1,    -1,    -1,    -1,
      -1,    -1,   194,  2447,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1513,   415,    -1,    -1,   208,    98,    -1,    -1,
     212,    -1,   103,   425,   426,   427,  2772,   429,   430,   431,
     432,   433,   434,    -1,    -1,    -1,    -1,    -1,    -1,   231,
     232,    -1,  1543,    -1,  1545,    -1,    -1,    -1,    -1,  1550,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3285,    -1,  1580,
      -1,    -1,  3108,   275,    -1,    -1,   278,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   291,
      -1,   293,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1610,
    1611,    -1,    -1,    -1,    -1,    -1,    -1,  1618,  3144,    -1,
    1621,  1622,    -1,    -1,    -1,    -1,    -1,   208,    -1,    -1,
      -1,   212,  1633,  1634,  3342,    -1,    -1,    -1,    -1,    -1,
    1641,    -1,    -1,    -1,  1645,  1646,  1647,  1648,    -1,    -1,
     231,   232,  2898,    -1,  1655,  1656,    -1,   349,    -1,    -1,
      -1,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,  1670,
    1671,    -1,    -1,    -1,  1675,    -1,    -1,    -1,  1679,    -1,
      -1,    -1,  1683,    -1,    -1,  1686,  1687,  1688,  1689,  1690,
    1691,  1692,  1693,  1694,   275,  1696,    -1,   278,    -1,  1700,
      -1,  2286,  2287,  1704,  2289,    -1,    -1,    -1,    -1,    -1,
     291,    -1,  3238,    -1,    -1,    -1,  3242,    -1,    -1,  2304,
      -1,  2306,    76,   415,    -1,    -1,    -1,    -1,    76,    -1,
      -1,    -1,    -1,   425,   426,   427,    90,   429,   430,   431,
     432,   433,   434,    -1,    98,    -1,    -1,  2332,    -1,   103,
      98,    -1,    -1,    -1,    -1,   103,    -1,  3283,  3284,    -1,
      -1,    -1,    -1,    -1,    -1,  2709,  2710,    -1,   349,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2362,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3039,    -1,  2380,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2760,    -1,    -1,  3065,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   176,    -1,
    2415,    -1,    -1,    -1,   415,    -1,    -1,    -1,  1839,    -1,
      -1,  2426,    -1,    -1,   425,   426,   427,    -1,   429,   430,
     431,   432,   433,   434,   208,  2440,  1857,  1858,   212,    -1,
     208,    -1,    -1,    -1,   212,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   231,   232,    -1,
      -1,    -1,    -1,   231,   232,    -1,    -1,    -1,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    76,   244,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
      -1,   275,   103,    -1,   278,    -1,    -1,    -1,    -1,    -1,
     278,    -1,    -1,    -1,    -1,  2520,    -1,   291,    -1,   293,
      -1,    -1,    -1,   291,  1945,  1946,    -1,    -1,    -1,    -1,
    1951,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2543,    -1,
      -1,    -1,    -1,  1964,    -1,  1966,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2570,    -1,    -1,    -1,  2933,
    2934,    -1,    -1,    -1,    -1,   349,    -1,    -1,    -1,  2943,
      -1,   349,    -1,    -1,    -1,    -1,    -1,    -1,  2593,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   371,    -1,    -1,
      -1,    -1,    -1,    -1,  2025,    -1,    -1,   208,    -1,    -1,
      -1,   212,    -1,  2034,    -1,    -1,  2037,    -1,    -1,  3285,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     231,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   415,    -1,   244,    -1,    -1,    -1,   415,  3012,  2070,
      -1,   425,   426,   427,    -1,   429,   430,   431,   432,   433,
     434,   429,   430,   431,   432,   433,   434,    -1,    -1,    -1,
      -1,    -1,    -1,  2094,   275,    -1,  3342,   278,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     291,    -1,   293,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2705,    -1,    -1,    -1,    -1,  2126,    -1,    -1,  2129,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2141,  2142,  2143,  2144,    -1,    -1,    -1,    -1,    -1,  2150,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2160,
    2161,    -1,  2163,    -1,    -1,    -1,    -1,    -1,   349,    -1,
      -1,    -1,    -1,    -1,  2175,    -1,  2177,    -1,    -1,    -1,
    2181,    -1,    -1,    -1,    -1,    -1,    -1,  2772,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2204,    -1,  2206,  2207,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2230,
      -1,    -1,    -1,    -1,   415,    -1,    -1,  2238,  2239,  2240,
      -1,    -1,    -1,    -1,   425,   426,   427,    -1,   429,   430,
     431,   432,   433,   434,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3206,    -1,    -1,    -1,    -1,  3211,  2269,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   718,    -1,
      -1,    -1,   722,    -1,    -1,  2286,  2287,    -1,  2289,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2304,    -1,  2306,    -1,    -1,    -1,    -1,
      -1,   751,    -1,  2898,    -1,  3259,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2332,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   787,    -1,    -1,
      -1,    -1,    -1,   793,    -1,    -1,    -1,    -1,    84,    -1,
      -1,  2362,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2380,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   114,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   131,    -1,   133,    -1,    -1,
      -1,    -1,    -1,    -1,  2415,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   149,    -1,  2426,    -1,    -1,    -1,   155,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2440,
      -1,   167,    -1,   883,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2454,  3039,    -1,    -1,  2458,    -1,    -1,
      -1,  2462,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     196,    -1,   198,    -1,    -1,    -1,   202,    -1,    -1,    -1,
    3065,    -1,    -1,  2484,    -1,    -1,    -1,    -1,    -1,   215,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2511,   237,    -1,    -1,    -1,    -1,  2517,    -1,    -1,  2520,
      -1,    -1,   248,    -1,    -1,    -1,    -1,    -1,  2529,    -1,
      -1,    -1,    -1,    -1,  2535,    -1,    -1,    -1,  2539,    -1,
      -1,    -1,  2543,  2544,    -1,    -1,  2547,  2548,  2549,  2550,
    2551,  2552,  2553,  2554,  2555,  2556,    -1,    -1,    -1,    -1,
    2561,  2562,    -1,    -1,    -1,   291,    -1,   293,    -1,  2570,
      -1,    -1,    -1,    -1,  2575,    -1,    -1,    -1,    -1,    -1,
      -1,  2582,    -1,    -1,  2585,   311,  2587,    -1,    -1,    -1,
      -1,    -1,  2593,  2594,  2595,  2596,    -1,    -1,    -1,  2600,
      -1,    -1,  2603,    -1,   330,    -1,    -1,  1047,   334,    -1,
     336,    -1,  1052,    -1,    -1,    -1,    -1,    -1,  1058,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1075,    -1,    -1,    -1,    -1,
      -1,   367,   368,    -1,   370,    -1,  2647,    -1,    -1,    -1,
      -1,    -1,    -1,   379,    -1,    -1,    -1,   383,   384,    -1,
    1100,    -1,   388,    -1,    -1,    -1,    -1,   393,    -1,  1109,
      -1,    -1,   883,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3285,    -1,    -1,    -1,  2705,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1171,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3342,  1198,    -1,
    2761,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2772,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1222,  1223,    -1,  1225,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1243,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2813,    -1,    -1,    -1,    -1,  2818,    -1,    -1,
      -1,  2822,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1047,    -1,    -1,  2840,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2852,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1309,
      -1,    -1,  1312,  1313,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2893,  2894,    -1,    -1,    -1,  2898,    -1,    -1,
      -1,    -1,    -1,  2904,  2905,    -1,    -1,  2908,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1380,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1171,    -1,    -1,    -1,    -1,    -1,  1406,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1419,
    2981,    -1,    -1,    -1,    -1,    -1,    -1,  1198,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1222,  1223,    -1,  1225,    -1,  3017,    -1,    -1,    -1,
      -1,  1461,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3030,
      -1,    -1,  1243,  3034,    -1,    -1,    -1,    -1,  3039,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3047,    -1,  1488,    -1,
      -1,    -1,    -1,    -1,    -1,  3056,    -1,  3058,    -1,    -1,
      -1,    -1,    -1,    -1,  3065,  3066,  3067,    -1,    -1,  3070,
      -1,    -1,    -1,  1513,    -1,    -1,  3077,  3078,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3087,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1309,    -1,
      -1,  1312,  1313,  1543,  3105,  1545,    -1,    -1,    -1,    -1,
    1550,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3119,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1580,    -1,    -1,    -1,    -1,    -1,  3147,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3169,    -1,
    1610,  1611,    -1,    -1,    -1,    -1,    -1,    -1,  1618,    -1,
      -1,  1621,  1622,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1633,  1634,    -1,    -1,    -1,    -1,    -1,
      -1,  1641,    -1,    -1,    -1,  1645,  1646,  1647,  1648,    -1,
      -1,    -1,    -1,    -1,    -1,  1655,  1656,    -1,    -1,    -1,
      -1,  3222,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1670,  1671,    -1,    -1,  3235,  1675,    -1,    -1,    -1,  1679,
      -1,    -1,    -1,  1683,    -1,    -1,  1686,  1687,  1688,  1689,
    1690,  1691,  1692,  1693,  1694,    -1,  1696,    -1,    -1,    -1,
    1700,    -1,    -1,    -1,  1704,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3285,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3306,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3339,    -1,
      -1,  3342,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1839,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1618,    -1,    -1,
      -1,  1622,    -1,    -1,    -1,    -1,    -1,  1857,  1858,    -1,
      -1,    -1,    -1,     3,    -1,    -1,    -1,    -1,    -1,     9,
    1641,    -1,    -1,    -1,  1645,    -1,    16,  1648,    18,    -1,
      -1,    21,    -1,    -1,  1655,  1656,    -1,    -1,    -1,    -1,
      -1,    -1,    32,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1671,    -1,    -1,    -1,  1675,    -1,    -1,    -1,  1679,    -1,
      50,    51,  1683,    -1,    -1,  1686,  1687,  1688,  1689,  1690,
    1691,  1692,  1693,  1694,    -1,  1696,    -1,    -1,    -1,  1700,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1945,  1946,    87,    88,    89,
      -1,  1951,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   102,    -1,  1964,    -1,  1966,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,    -1,    -1,    -1,   127,   128,    -1,
      -1,    -1,    -1,    -1,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,
      -1,   151,    -1,    -1,   154,    -1,    -1,    -1,    -1,    -1,
     160,    -1,    -1,    -1,    -1,  2025,    -1,    -1,    -1,   169,
      -1,    -1,    -1,    -1,  2034,   175,    -1,  2037,    -1,    -1,
     180,    -1,   182,  1239,    -1,    -1,   186,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   197,    -1,   199,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1839,    -1,
    2070,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   223,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2094,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   246,   247,    -1,    -1,
      -1,    -1,   252,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     260,    -1,    -1,    -1,    -1,    -1,  2126,    -1,    -1,  2129,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,    -1,    -1,
      -1,  2141,  2142,  2143,  2144,    -1,    -1,    -1,    -1,    -1,
    2150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2160,  2161,    -1,  2163,    -1,    -1,   306,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1945,  2175,    -1,  2177,   318,    -1,
     320,  2181,    -1,    -1,   324,    -1,    -1,    -1,   328,    -1,
      -1,   331,    -1,  1964,    -1,   335,    -1,    -1,    -1,    -1,
     340,    -1,    -1,    -1,  2204,   345,  2206,  2207,   348,    -1,
      -1,    -1,    -1,    -1,   354,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2230,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2238,  2239,
    2240,    -1,   382,    -1,   384,    -1,    -1,    -1,    -1,    -1,
     390,    -1,   392,    -1,    -1,   395,    -1,    -1,  1454,    -1,
      -1,    -1,    -1,  2034,    -1,    -1,    -1,    -1,    -1,  2269,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2286,  2287,    -1,  2289,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   438,  2070,
      -1,    -1,    -1,    -1,  2304,    -1,  2306,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2094,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2332,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2362,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2141,    -1,  2143,  2144,    -1,    -1,    -1,    -1,    -1,  2150,
    2380,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2175,    -1,  2177,    -1,    -1,    -1,
    2181,    -1,    -1,    -1,    -1,  2415,    -1,    -1,    -1,    -1,
    1616,    -1,    -1,    -1,    -1,    -1,  2426,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2440,    -1,    -1,    -1,  1640,    -1,    -1,    -1,    -1,    -1,
    1646,    -1,    -1,    -1,  2454,    -1,    -1,    -1,  2458,  2230,
      -1,    -1,  2462,  1659,  1660,    -1,  1662,  2238,  2239,  2240,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2484,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2269,    -1,
      -1,    -1,  1698,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2511,    -1,    -1,    -1,    -1,    -1,  2517,    -1,    -1,
    2520,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2529,
      -1,    -1,    -1,    -1,    -1,  2535,    -1,    -1,    -1,  2539,
      -1,    -1,    -1,  2543,  2544,    -1,    -1,  2547,  2548,  2549,
    2550,  2551,  2552,  2553,  2554,  2555,  2556,    -1,    -1,    -1,
      -1,  2561,  2562,    -1,  1760,    -1,    -1,    -1,    -1,    -1,
    2570,  1767,    -1,  1769,    -1,  2575,    -1,    -1,    -1,    -1,
      -1,    -1,  2582,    -1,    -1,  2585,    -1,  2587,    -1,    -1,
      -1,    -1,    -1,  2593,  2594,  2595,  2596,    -1,    -1,    -1,
    2600,    -1,    -1,  2603,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2647,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2705,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2511,    -1,    -1,    -1,    -1,    -1,  2517,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2529,    -1,
      -1,  2761,    -1,    -1,  2535,    -1,    -1,    -1,  2539,    -1,
      -1,    -1,  2772,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2561,  2562,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2582,    -1,  2813,  2585,    -1,  2587,    -1,  2818,    -1,
      -1,    -1,  2822,  2594,    -1,    -1,    -1,    -1,    -1,  2600,
      -1,    -1,  2603,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2840,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2852,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2647,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2088,  2893,  2894,    -1,    -1,    -1,  2898,    -1,
      -1,  2097,    -1,  2099,  2904,  2905,    -1,    -1,  2908,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2121,    -1,    -1,  2124,    -1,
    2126,  2127,    -1,  2129,    -1,    -1,    -1,  2133,    -1,    -1,
      -1,    -1,    -1,    -1,  2140,    -1,    -1,    -1,    -1,  2145,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2156,    -1,    -1,    -1,  2160,  2161,  2162,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2173,    -1,    -1,
      -1,  2981,    -1,    -1,  2180,    -1,  2182,  2183,  2184,  2185,
    2186,  2187,  2188,  2189,  2190,  2191,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3017,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3030,    -1,    -1,    -1,  3034,    -1,    -1,    -1,    -1,  3039,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3047,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3056,    -1,  3058,    -1,
      -1,    -1,    -1,    -1,    -1,  3065,  3066,  3067,    -1,  2840,
    3070,    -1,    -1,    -1,    -1,    -1,    -1,  3077,  3078,    -1,
    2276,  2852,    -1,    -1,    -1,    -1,    -1,  3087,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3105,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3119,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2904,  2905,    -1,    -1,  2908,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3147,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2360,    -1,    -1,    -1,    -1,  3169,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2381,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2981,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3222,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3235,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3030,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2469,    -1,    -1,  3047,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3285,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2493,    -1,  3070,
      -1,    -1,    -1,    -1,    -1,    -1,  3306,  3078,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3087,    -1,    -1,    -1,
    2516,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3105,    -1,    -1,    -1,    -1,  3339,
      -1,    -1,  3342,    -1,    -1,    -1,  2542,    -1,  2544,    -1,
      -1,  2547,  2548,  2549,  2550,  2551,  2552,  2553,  2554,  2555,
    2556,    -1,  2558,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     5,  3147,    -1,    -1,    -1,
      -1,    -1,  2578,    -1,    -1,    -1,    -1,  2583,  2584,    19,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    28,  2595,
    2596,  2597,    -1,  2599,    -1,    -1,  2602,    -1,    -1,    39,
      40,    -1,    -1,    -1,    -1,    45,    -1,    47,    48,    -1,
      -1,    -1,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2672,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,
      -1,    -1,    -1,    -1,    -1,  2761,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   207,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   225,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   256,    -1,    -1,   259,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     280,    -1,    -1,  2849,    -1,    -1,    -1,  2853,    -1,    -1,
      -1,    -1,  2858,  2859,    -1,  2861,    -1,    -1,  2864,    -1,
      -1,    -1,  2868,  2869,  2870,  2871,  2872,  2873,  2874,  2875,
    2876,  2877,  2878,  2879,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2892,  2893,  2894,  2895,
      -1,  2897,    -1,    -1,    -1,  2901,  2902,  2903,   338,    -1,
    2906,    -1,    -1,  2909,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2927,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   374,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   399,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     410,    -1,    -1,   413,   414,    -1,   416,  2983,   418,    -1,
      -1,    -1,   422,    -1,   424,   425,    -1,    -1,    -1,   429,
     430,   431,   432,   433,    -1,    -1,   436,   437,   438,   439,
      -1,   441,   442,   443,    -1,   445,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3049,    -1,    -1,    -1,    -1,    -1,    -1,
    3056,    -1,  3058,    -1,    -1,  3061,  3062,    -1,    -1,    -1,
    3066,  3067,  3068,  3069,    -1,  3071,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3123,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3157,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3168,  3169,  3170,    -1,    -1,  3173,  3174,  3175,
      -1,  3177,    -1,    -1,    -1,  3181,    -1,    -1,    -1,    -1,
    3186,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,  3220,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,  3233,    35,    36,
      37,    38,    39,    40,    -1,    42,    43,    44,    -1,    46,
      47,    48,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,   108,   109,   110,    -1,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,   155,   156,
     157,   158,    -1,   160,   161,   162,   163,   164,   165,   166,
     167,   168,   169,   170,   171,   172,   173,   174,   175,   176,
     177,   178,   179,   180,   181,   182,    -1,   184,   185,   186,
     187,   188,   189,   190,   191,   192,   193,   194,   195,   196,
      -1,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   209,   210,   211,   212,   213,   214,   215,   216,
     217,   218,   219,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,    -1,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,    -1,    -1,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,   340,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,   401,   402,    -1,   404,   405,   406,
     407,   408,   409,   410,   411,    -1,   413,    -1,    -1,   416,
      -1,    -1,    -1,     6,     7,     8,    -1,    10,    11,    -1,
      13,    14,    15,    -1,    -1,    -1,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,   442,    29,    30,    31,    -1,
      -1,    -1,    35,    36,    37,    38,    -1,    40,    -1,    42,
      43,    44,    -1,    46,    47,    48,    49,    -1,    -1,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,    -1,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   117,    -1,    -1,    -1,    -1,    -1,
      -1,   124,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   134,    -1,    -1,    -1,    -1,    -1,   140,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   152,
     153,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   181,    -1,
      -1,   184,    -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,
     193,    -1,   195,    -1,    -1,    -1,    -1,    -1,   201,    -1,
      -1,    -1,    -1,    -1,    -1,   208,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   219,   220,    -1,    -1,
      -1,    -1,    -1,   226,    -1,   228,    -1,    -1,   231,   232,
      -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
      -1,   244,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   262,
     263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,    -1,    -1,    -1,    -1,   278,    -1,    -1,   281,   282,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   295,   296,   297,   298,    -1,    -1,    -1,    -1,
     303,   304,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   315,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   329,    -1,    -1,   332,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   346,    -1,    -1,   349,    -1,   351,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   361,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   372,
     373,    -1,    -1,    -1,    -1,   378,    -1,   380,    -1,    -1,
      -1,    -1,    -1,    -1,   387,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   399,    -1,   401,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,
     413,    10,    11,   416,    13,    14,    15,    -1,    -1,    -1,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    -1,    -1,    -1,    35,    36,    37,    38,
     443,    40,    -1,    42,    43,    44,    -1,    46,    47,    48,
      49,    -1,    -1,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      99,    -1,    -1,    -1,   103,   104,   105,   106,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,
      -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   134,    -1,    -1,    -1,    -1,
      -1,   140,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   152,   153,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   181,    -1,    -1,   184,    -1,    -1,    -1,   188,
      -1,    -1,    -1,    -1,   193,    -1,   195,    -1,    -1,    -1,
      -1,    -1,   201,    -1,    -1,    -1,    -1,    -1,    -1,   208,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     219,   220,    -1,    -1,    -1,    -1,    -1,   226,    -1,   228,
      -1,    -1,   231,   232,    -1,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,    -1,   244,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   262,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,    -1,    -1,    -1,    -1,   278,
      -1,    -1,   281,   282,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   295,   296,   297,   298,
      -1,    -1,    -1,    -1,   303,   304,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   315,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     329,    -1,    -1,   332,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   346,    -1,    -1,
     349,    -1,   351,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   361,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   372,   373,    -1,    -1,    -1,    -1,   378,
      -1,   380,    -1,    -1,    -1,    -1,    -1,    -1,   387,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,
     399,    -1,   401,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    19,    -1,   413,    -1,    -1,   416,    -1,    -1,
      -1,    28,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    39,    40,    -1,    -1,    -1,    -1,    -1,    -1,
      47,    48,    -1,    -1,   443,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     207,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   225,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   256,
      -1,    -1,   259,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   280,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   338,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   374,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     387,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   399,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   410,    -1,    -1,   413,   414,    -1,   416,
      -1,    -1,    -1,    -1,    -1,   422,    -1,   424,   425,    -1,
      -1,    -1,   429,   430,   431,   432,   433,    -1,    -1,   436,
     437,   438,    -1,     3,    -1,   442,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,    88,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    99,
      -1,    -1,   102,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,   127,   128,    -1,
      -1,    -1,    -1,    -1,   134,   135,   136,    -1,    -1,    -1,
     140,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,
      -1,   151,   152,   153,   154,    -1,    -1,    -1,    -1,    -1,
     160,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,
      -1,    -1,    -1,    -1,    -1,   175,    -1,    -1,    -1,    -1,
     180,   181,   182,    -1,   184,    -1,   186,    -1,   188,    -1,
      -1,    -1,    -1,   193,    -1,   195,    -1,   197,    -1,   199,
      -1,   201,    -1,    -1,    -1,    -1,    -1,    -1,   208,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   219,
     220,    -1,    -1,   223,    -1,    -1,   226,    -1,   228,    -1,
      -1,   231,   232,    -1,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,   242,    -1,   244,    -1,   246,   247,    -1,    -1,
      -1,    -1,   252,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     260,    -1,   262,   263,   264,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,    -1,
      -1,   281,   282,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   295,   296,   297,   298,    -1,
      -1,    -1,    -1,   303,   304,    -1,   306,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   315,    -1,    -1,   318,    -1,
     320,    -1,    -1,    -1,   324,    -1,    -1,    -1,   328,   329,
      -1,   331,   332,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,    -1,    -1,    -1,    -1,   345,   346,    -1,   348,   349,
      -1,   351,    -1,    -1,   354,    -1,    -1,    -1,    -1,    -1,
      -1,   361,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   372,   373,    -1,    -1,    -1,    -1,   378,    -1,
     380,    -1,   382,    -1,   384,    -1,    -1,   387,    -1,    -1,
     390,    -1,   392,    -1,    -1,   395,    -1,    -1,    -1,   399,
      -1,   401,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   413,    -1,    -1,   416,    -1,    -1,    -1,
      -1,    -1,     5,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,   438,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    -1,    35,    36,    37,    38,    39,    40,    -1,    42,
      43,    44,    -1,    46,    47,    48,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    -1,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,   165,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,   185,   186,   187,   188,    -1,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,   208,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,   220,    -1,   222,
     223,   224,   225,   226,    -1,   228,    -1,    -1,   231,   232,
     233,   234,   235,   236,   237,   238,   239,    -1,   241,   242,
     243,   244,    -1,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,    -1,    -1,   287,   288,    -1,    -1,   291,   292,
      -1,    -1,   295,   296,   297,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,   381,   382,
     383,   384,   385,   386,    -1,   388,   389,   390,   391,   392,
     393,    -1,   395,   396,    -1,   398,   399,   400,   401,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,   414,   415,   416,   417,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,    -1,    -1,   429,   430,   431,    -1,
      -1,    -1,    -1,    -1,    -1,   438,   439,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,    -1,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
      -1,   109,   110,    -1,   112,   113,   114,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,    -1,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,   185,   186,   187,
     188,    -1,   190,    -1,   192,   193,    -1,   195,   196,    -1,
     198,    -1,   200,   201,    -1,   203,    -1,   205,   206,   207,
     208,   209,   210,   211,    -1,   213,   214,   215,   216,   217,
      -1,   219,   220,    -1,   222,   223,   224,   225,   226,    -1,
     228,    -1,    -1,   231,   232,   233,   234,   235,   236,   237,
     238,   239,    -1,   241,   242,   243,   244,    -1,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,    -1,    -1,   287,
     288,    -1,    -1,   291,   292,    -1,    -1,   295,   296,   297,
     298,   299,   300,   301,    -1,   303,   304,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,    -1,    -1,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
     378,   379,   380,   381,   382,   383,   384,   385,   386,    -1,
     388,   389,   390,   391,   392,   393,    -1,   395,   396,    -1,
     398,   399,   400,   401,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,   414,   415,   416,   417,
      -1,    -1,   420,   421,   422,   423,   424,    -1,    -1,    -1,
      -1,   429,   430,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     438,   439,     5,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    -1,    35,    36,    37,    38,    39,    40,    -1,    42,
      43,    44,    -1,    46,    47,    48,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,    -1,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,    -1,   135,    -1,   137,   138,   139,   140,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,    -1,   182,
      -1,    -1,    -1,   186,   187,   188,    -1,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,    -1,   200,    -1,    -1,
     203,    -1,   205,   206,   207,   208,   209,   210,   211,   212,
     213,   214,   215,   216,   217,    -1,   219,   220,    -1,   222,
     223,   224,   225,   226,    -1,   228,    -1,    -1,   231,   232,
     233,   234,   235,   236,   237,   238,   239,    -1,    -1,   242,
     243,   244,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,    -1,   266,   267,   268,   269,   270,   271,   272,
      -1,   274,    -1,   276,   277,   278,   279,    -1,    -1,   282,
     283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,
      -1,    -1,   295,   296,   297,    -1,   299,   300,   301,    -1,
      -1,    -1,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,    -1,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,    -1,   345,   346,   347,   348,   349,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,    -1,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,    -1,   379,    -1,    -1,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,   401,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,    -1,    -1,   416,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,   439,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,   220,    -1,
     222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,   241,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,    -1,   276,   277,    -1,   279,    -1,   281,
     282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,
     292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,
      -1,   303,   304,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
     332,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,   394,   395,   396,    -1,   398,   399,   400,    -1,
     402,     5,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,    19,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    28,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   436,    39,    40,    -1,   440,    -1,
      -1,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    -1,    -1,     5,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    28,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    39,
      40,    -1,   116,    -1,    -1,    -1,    -1,    47,    48,    -1,
      -1,    -1,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   188,    -1,   116,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   207,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   225,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   256,    -1,    -1,   259,    -1,    -1,   188,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   280,   207,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   225,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   256,    -1,    -1,   259,
      -1,    -1,    -1,    -1,   338,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     280,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     374,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   387,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   399,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   410,    -1,   338,   413,
     414,    -1,   416,    -1,    -1,    -1,    -1,    -1,   422,    -1,
     424,   425,    -1,    -1,    -1,   429,   430,   431,   432,   433,
      -1,    -1,   436,   437,   438,   439,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   374,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   399,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     410,    -1,    -1,   413,   414,    -1,   416,    -1,    -1,    -1,
      -1,    -1,   422,    -1,   424,   425,    -1,    -1,    -1,   429,
     430,   431,   432,   433,    -1,    -1,   436,   437,   438,   439,
       5,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    -1,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      -1,    46,    47,    48,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    -1,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,    -1,   112,   113,   114,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
     185,   186,   187,   188,    -1,   190,    -1,   192,   193,   194,
     195,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,   208,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,   219,   220,    -1,   222,   223,   224,
     225,   226,    -1,   228,    -1,    -1,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
      -1,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      -1,    -1,   287,   288,    -1,    -1,   291,   292,    -1,    -1,
     295,   296,   297,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,   393,    -1,
     395,   396,    -1,   398,   399,   400,   401,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
     415,   416,   417,    -1,    -1,   420,   421,   422,   423,   424,
      -1,    -1,    -1,    -1,   429,   430,     5,     6,     7,     8,
       9,    10,    11,   438,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    -1,    35,    36,    37,    38,
      39,    40,    -1,    42,    43,    44,    -1,    46,    47,    48,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    -1,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,    -1,   112,   113,   114,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,   185,   186,   187,   188,
      -1,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,   208,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
     219,   220,    -1,   222,   223,   224,   225,   226,    -1,   228,
      -1,    -1,   231,   232,   233,   234,   235,   236,   237,   238,
     239,    -1,   241,   242,   243,   244,    -1,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,    -1,   287,   288,
      -1,    -1,   291,   292,    -1,    -1,   295,   296,   297,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,   393,    -1,   395,   396,    -1,   398,
     399,   400,   401,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,   416,   417,    -1,
      -1,   420,   421,   422,   423,   424,    -1,    -1,    -1,    -1,
     429,   430,   431,    -1,    -1,    -1,    -1,    -1,    -1,   438,
       5,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    -1,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      -1,    46,    47,    48,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    -1,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,    -1,   112,   113,   114,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
     185,   186,   187,   188,    -1,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,   208,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,   219,   220,    -1,   222,   223,   224,
     225,   226,    -1,   228,    -1,    -1,   231,   232,   233,   234,
     235,   236,   237,   238,   239,    -1,   241,   242,   243,   244,
      -1,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      -1,    -1,   287,   288,    -1,    -1,   291,   292,    -1,    -1,
     295,   296,   297,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,   393,    -1,
     395,   396,    -1,   398,   399,   400,   401,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
     415,   416,   417,    -1,    -1,   420,   421,   422,   423,   424,
      -1,    -1,    -1,    -1,   429,   430,     5,     6,     7,     8,
       9,    10,    11,   438,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    -1,    35,    36,    37,    38,
      39,    40,    -1,    42,    43,    44,    -1,    46,    47,    48,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    -1,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,    -1,   112,   113,   114,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,   185,   186,   187,   188,
      -1,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,   208,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
     219,   220,    -1,   222,   223,   224,   225,   226,    -1,   228,
      -1,    -1,   231,   232,   233,   234,   235,   236,   237,   238,
     239,    -1,   241,   242,   243,   244,    -1,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,    -1,   287,   288,
      -1,    -1,   291,   292,    -1,    -1,   295,   296,   297,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,   393,    -1,   395,   396,    -1,   398,
     399,   400,   401,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,   416,   417,    -1,
      -1,   420,   421,   422,   423,   424,    -1,    -1,    -1,    -1,
     429,   430,     5,     6,     7,     8,     9,    10,    11,   438,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    -1,    35,    36,    37,    38,    39,    40,    -1,    42,
      43,    44,    -1,    46,    47,    48,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    -1,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,   185,   186,   187,   188,    -1,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,   208,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,   220,    -1,   222,
     223,   224,   225,   226,    -1,   228,    -1,    -1,   231,   232,
     233,   234,   235,   236,   237,   238,   239,    -1,   241,   242,
     243,   244,    -1,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,    -1,    -1,   287,   288,    -1,    -1,   291,   292,
      -1,    -1,   295,   296,   297,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,   381,   382,
     383,   384,   385,   386,    -1,   388,   389,   390,   391,   392,
     393,    -1,   395,   396,    -1,   398,   399,   400,   401,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,   414,   415,   416,   417,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,    -1,    -1,   429,   430,    -1,    -1,
      -1,    -1,    -1,   436,    -1,   438,     5,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    -1,    35,    36,    37,    38,
      39,    40,    -1,    42,    43,    44,    -1,    46,    47,    48,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    -1,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,    -1,   112,   113,   114,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,   185,   186,   187,   188,
      -1,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,   208,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
     219,   220,    -1,   222,   223,   224,   225,   226,    -1,   228,
      -1,    -1,   231,   232,   233,   234,   235,   236,   237,   238,
     239,    -1,   241,   242,   243,   244,    -1,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,    -1,   287,   288,
      -1,    -1,   291,   292,    -1,    -1,   295,   296,   297,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,   393,    -1,   395,   396,    -1,   398,
     399,   400,   401,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,   416,   417,    -1,
      -1,   420,   421,   422,   423,   424,    -1,    -1,    -1,    -1,
     429,   430,     5,     6,     7,     8,     9,    10,    11,   438,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    -1,    35,    36,    37,    38,    39,    40,    -1,    42,
      43,    44,    -1,    46,    47,    48,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    -1,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,   185,   186,   187,   188,    -1,   190,    -1,   192,
     193,   194,   195,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,   208,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,   220,    -1,   222,
     223,   224,   225,   226,    -1,   228,    -1,    -1,   231,   232,
     233,   234,   235,   236,   237,   238,   239,    -1,   241,   242,
     243,   244,    -1,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,    -1,    -1,   287,   288,    -1,    -1,   291,   292,
      -1,    -1,   295,   296,   297,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,   381,   382,
     383,   384,   385,   386,    -1,   388,   389,   390,   391,   392,
     393,    -1,   395,   396,    -1,   398,   399,   400,   401,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,   414,   415,   416,   417,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,    -1,    -1,   429,   430,     5,     6,
       7,     8,     9,    10,    11,   438,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    -1,    35,    36,
      37,    38,    39,    40,    -1,    42,    43,    44,    -1,    46,
      47,    48,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      -1,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,    -1,   109,   110,    -1,   112,   113,   114,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,    -1,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,   185,   186,
     187,   188,    -1,   190,    -1,   192,   193,    -1,   195,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,   208,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,   219,   220,    -1,   222,   223,   224,   225,   226,
      -1,   228,    -1,    -1,   231,   232,   233,   234,   235,   236,
     237,   238,   239,    -1,   241,   242,   243,   244,    -1,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,    -1,
     287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,   296,
     297,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,    -1,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
      -1,   388,   389,   390,   391,   392,   393,    -1,   395,   396,
      -1,   398,   399,   400,   401,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,   414,   415,   416,
     417,    -1,    -1,   420,   421,   422,   423,   424,    -1,    -1,
      -1,    -1,   429,   430,     5,     6,     7,     8,     9,    10,
      11,   438,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
      -1,   112,   113,   114,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,   185,   186,   187,   188,    -1,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,   208,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,   219,   220,
      -1,   222,   223,   224,   225,   226,    -1,   228,    -1,    -1,
     231,   232,   233,   234,   235,   236,   237,   238,   239,    -1,
     241,   242,   243,   244,    -1,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,    -1,    -1,   287,   288,    -1,    -1,
     291,   292,    -1,    -1,   295,   296,   297,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
     381,   382,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,    -1,   395,   396,    -1,   398,   399,   400,
     401,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,   414,   415,   416,   417,    -1,    -1,   420,
     421,   422,   423,   424,    -1,    -1,    -1,    -1,   429,   430,
       5,     6,     7,     8,     9,    10,    11,   438,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    -1,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      -1,    46,    47,    48,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    -1,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,    -1,   112,   113,   114,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
     185,   186,   187,   188,    -1,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,   208,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,   219,   220,    -1,   222,   223,   224,
     225,   226,    -1,   228,    -1,    -1,   231,   232,   233,   234,
     235,   236,   237,   238,   239,    -1,   241,   242,   243,   244,
      -1,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      -1,    -1,   287,   288,    -1,    -1,   291,   292,    -1,    -1,
     295,   296,   297,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,   393,    -1,
     395,   396,    -1,   398,   399,   400,   401,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
     415,   416,   417,    -1,    -1,   420,   421,   422,   423,   424,
      -1,    -1,    -1,    -1,    -1,   430,     5,     6,     7,     8,
       9,    10,    11,   438,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    -1,    35,    36,    37,    38,
      39,    40,    -1,    42,    43,    44,    -1,    46,    47,    48,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    -1,    98,
      99,   100,   101,   102,    -1,   104,   105,   106,   107,    -1,
     109,   110,    -1,   112,   113,   114,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,    -1,    -1,   178,
     179,   180,   181,   182,    -1,   184,   185,   186,   187,   188,
      -1,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
     219,   220,    -1,   222,   223,   224,   225,   226,    -1,   228,
      -1,    -1,   231,   232,   233,   234,   235,   236,   237,   238,
     239,    -1,   241,   242,   243,    -1,    -1,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,    -1,   287,   288,
      -1,    -1,   291,   292,    -1,    -1,   295,   296,   297,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,   344,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,   393,    -1,   395,   396,    -1,   398,
     399,   400,   401,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,   416,   417,    -1,
      -1,   420,   421,   422,   423,   424,    -1,    -1,    -1,    -1,
     429,   430,     5,     6,     7,     8,     9,    10,    11,   438,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    -1,    35,    36,    37,    38,    39,    40,    -1,    42,
      43,    44,    -1,    46,    47,    48,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    -1,    98,    99,   100,   101,   102,
      -1,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,    -1,    -1,   178,   179,   180,   181,   182,
      -1,   184,   185,   186,   187,   188,    -1,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,   220,    -1,   222,
     223,   224,   225,   226,    -1,   228,    -1,    -1,   231,   232,
     233,   234,   235,   236,   237,   238,   239,    -1,   241,   242,
     243,    -1,    -1,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,   278,   279,   280,   281,   282,
     283,   284,    -1,    -1,   287,   288,    -1,    -1,    -1,   292,
      -1,    -1,   295,   296,   297,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,   344,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,   381,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
     393,    -1,   395,   396,    -1,   398,   399,   400,   401,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,   414,    -1,   416,   417,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,    -1,    -1,    -1,   430,    -1,     6,
       7,     8,     9,    10,    11,   438,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    93,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,    -1,
     137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
     177,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,   188,   189,   190,    -1,   192,    -1,    -1,    -1,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,    -1,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,
     227,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,
     237,   238,   239,    -1,   241,    -1,   243,    -1,   245,   246,
     247,   248,    -1,    -1,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,   264,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,    -1,   276,
     277,    -1,   279,    -1,   281,   282,   283,   284,    -1,   286,
     287,    -1,    -1,    -1,   291,   292,    -1,   294,   295,    -1,
      -1,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,    -1,   341,   342,   343,    -1,   345,   346,
     347,   348,    -1,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,   384,   385,   386,
     387,    -1,   389,   390,   391,   392,    -1,    -1,   395,   396,
      -1,   398,   399,   400,     5,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,    -1,    19,   416,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    28,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    39,    40,
      -1,    -1,   439,    -1,    -1,    -1,    47,    48,    -1,    -1,
      -1,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   116,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   207,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   225,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   256,    -1,    -1,   259,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   280,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   338,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   374,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   399,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   410,
      -1,    -1,   413,   414,    -1,   416,    -1,    -1,    -1,    -1,
      -1,   422,    -1,   424,   425,    -1,    -1,    -1,   429,   430,
     431,   432,   433,    -1,    -1,   436,   437,   438,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,   114,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,    -1,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
     188,    -1,   190,    -1,   192,   193,    -1,   195,   196,    -1,
     198,    -1,   200,   201,    -1,   203,    -1,   205,   206,   207,
     208,   209,   210,   211,    -1,   213,   214,   215,   216,   217,
      -1,   219,   220,    -1,   222,   223,   224,    -1,   226,    -1,
     228,    -1,    -1,   231,   232,   233,   234,   235,   236,   237,
     238,   239,    -1,   241,   242,   243,   244,    -1,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,    -1,   276,   277,
     278,   279,    -1,   281,   282,   283,   284,    -1,    -1,   287,
     288,    -1,   290,   291,   292,    -1,    -1,   295,   296,   297,
     298,   299,   300,   301,    -1,   303,   304,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,    -1,   340,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,   393,    -1,   395,   396,    -1,
     398,   399,   400,   401,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,    -1,    -1,   416,    -1,
      -1,    -1,    -1,    -1,    -1,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
     438,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    99,   100,
     101,   102,   103,   104,   105,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,   114,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,   188,    -1,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,   208,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,   219,   220,
      -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,
     231,   232,   233,   234,   235,   236,   237,   238,   239,    -1,
     241,   242,   243,   244,    -1,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,    -1,   276,   277,   278,   279,    -1,
     281,   282,   283,   284,    -1,    -1,   287,   288,    -1,   290,
     291,   292,    -1,    -1,   295,   296,   297,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,   384,   385,   386,    -1,    -1,   389,   390,
     391,   392,   393,    -1,   395,   396,    -1,   398,   399,   400,
     401,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,    -1,    -1,   416,    -1,    -1,    -1,    -1,
      -1,    -1,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,   438,    22,    23,
      24,    25,    26,    27,    -1,    29,    30,    31,    32,    -1,
      -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,    43,
      44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    99,   100,   101,   102,   103,
     104,   105,   106,    -1,    -1,   109,   110,    -1,   112,    -1,
     114,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,    -1,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,   188,    -1,   190,    -1,   192,   193,
      -1,   195,   196,    -1,   198,    -1,   200,   201,    -1,   203,
      -1,   205,   206,   207,   208,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,   219,   220,    -1,   222,   223,
     224,    -1,   226,    -1,   228,    -1,    -1,   231,   232,   233,
     234,   235,   236,   237,   238,   239,    -1,   241,   242,   243,
     244,    -1,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,    -1,   276,   277,   278,   279,    -1,   281,   282,   283,
     284,    -1,    -1,   287,   288,    -1,    -1,   291,   292,    -1,
      -1,   295,   296,   297,   298,   299,   300,   301,    -1,   303,
     304,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,   393,
      -1,   395,   396,    -1,   398,   399,   400,   401,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
      -1,    -1,   416,    -1,    -1,    -1,    -1,    -1,    -1,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,   438,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,    -1,
     137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,    -1,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,
      -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,
     237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,
     247,   248,    -1,    -1,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,   264,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,    -1,   276,
     277,    -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,
     287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,
      -1,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,    -1,   341,   342,   343,    -1,   345,   346,
     347,   348,    -1,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,   384,   385,   386,
      -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,   414,    -1,   416,
     417,    -1,    -1,    -1,    -1,   422,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     437,   438,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    -1,    29,    30,    31,    32,    -1,
      -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,    43,
      44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,
      -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,
      -1,   205,   206,   207,    -1,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,    -1,   220,    -1,   222,   223,
     224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,
      -1,   235,   236,   237,   238,   239,    -1,   241,    -1,   243,
      -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
     264,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,    -1,   276,   277,    -1,   279,    -1,   281,   282,   283,
     284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,
      -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,   303,
     304,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,   332,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
      -1,   345,   346,   347,   348,    -1,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,    -1,
      -1,   395,   396,    -1,   398,   399,   400,    -1,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
     414,    -1,   416,   417,    -1,    -1,    -1,    -1,   422,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,   438,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,    -1,
     137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,    -1,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,
      -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,
     237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,
     247,   248,    -1,    -1,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,    -1,   276,
     277,    -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,
     287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,
      -1,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,    -1,   341,   342,   343,    -1,   345,   346,
     347,   348,    -1,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,   384,   385,   386,
      -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,    -1,    -1,   416,
      -1,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,   438,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,    -1,   137,   138,   139,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,   188,    -1,
     190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,
     200,   201,    -1,   203,    -1,   205,   206,   207,    -1,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,    -1,
     220,    -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,
      -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,   239,
      -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,   264,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,    -1,   276,   277,    -1,   279,
      -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,
      -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
     340,   341,   342,   343,    -1,   345,   346,   347,   348,    -1,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,    -1,   395,   396,    -1,   398,   399,
     400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,   417,    -1,    -1,
      -1,    -1,    -1,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,   438,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,
      -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,   340,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,    -1,    -1,   416,    -1,    -1,    -1,    -1,    -1,    -1,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,   438,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
      -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,
     196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,
     206,   207,    -1,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,
     226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,
     236,   237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,   264,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,    -1,
     276,   277,    -1,   279,    -1,   281,   282,   283,   284,    -1,
      -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,
      -1,    -1,   298,   299,   300,   301,    -1,   303,   304,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,   332,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,    -1,   345,
     346,   347,   348,    -1,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,    -1,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,   438,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,
      -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,    -1,    -1,   416,    -1,    -1,
      -1,    -1,    -1,     5,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,   438,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    -1,    35,    36,    37,    38,    39,    40,    -1,
      42,    43,    44,    -1,    46,    47,    48,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,   107,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,    -1,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,    -1,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,    -1,
     182,    -1,    -1,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,    -1,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,    -1,    -1,
     222,   223,   224,   225,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,    -1,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,    -1,   266,   267,   268,   269,   270,   271,
     272,    -1,   274,    -1,   276,   277,    -1,   279,    -1,    -1,
     282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,
     292,    -1,    -1,    -1,    -1,    -1,    -1,   299,   300,   301,
      -1,    -1,    -1,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,    -1,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,    -1,   379,    -1,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,   414,   415,   416,   417,    -1,    -1,    -1,    -1,
     422,    -1,   424,   425,   426,   427,    -1,   429,   430,   431,
     432,   433,   434,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,
      -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,    -1,   415,   416,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   425,   426,   427,    -1,   429,   430,   431,   432,
     433,   434,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    -1,    29,    30,    31,    32,    -1,
      -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,    43,
      44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,
      -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,
      -1,   205,   206,   207,    -1,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,    -1,   220,    -1,   222,   223,
     224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,
      -1,   235,   236,   237,   238,   239,    -1,   241,    -1,   243,
      -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
     264,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,    -1,   276,   277,    -1,   279,    -1,   281,   282,   283,
     284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,
      -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,   303,
     304,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,   332,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
      -1,   345,   346,   347,   348,    -1,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,    -1,
      -1,   395,   396,    -1,   398,   399,   400,    -1,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
      -1,   415,   416,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   425,   426,   427,    -1,   429,   430,   431,   432,   433,
     434,     5,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      -1,    35,    36,    37,    38,    39,    40,    -1,    42,    43,
      44,    -1,    46,    47,    48,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,    -1,   108,   109,   110,    -1,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,   157,   158,    -1,   160,   161,   162,   163,
     164,   165,   166,   167,   168,   169,   170,   171,   172,   173,
     174,   175,   176,   177,   178,   179,   180,   181,   182,    -1,
     184,   185,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,    -1,   198,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,   225,   226,   227,   228,   229,    -1,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,    -1,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,    -1,   340,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,   380,   381,   382,   383,
     384,   385,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,   396,    -1,   398,   399,   400,   401,   402,    -1,
     404,   405,   406,   407,   408,   409,   410,   411,    -1,   413,
      -1,    -1,   416,     5,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,   431,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    -1,    35,    36,    37,    38,    39,    40,    -1,
      42,    43,    44,    -1,    46,    47,    48,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,   107,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,    -1,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,    -1,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,    -1,
     182,    -1,    -1,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,    -1,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,    -1,    -1,
     222,   223,   224,   225,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,    -1,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,    -1,   266,   267,   268,   269,   270,   271,
     272,    -1,   274,    -1,   276,   277,    -1,   279,    -1,    -1,
     282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,
     292,    -1,    -1,    -1,    -1,    -1,    -1,   299,   300,   301,
      -1,    -1,    -1,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,    -1,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,    -1,   379,    -1,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,    -1,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,   431,
      20,    -1,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,    -1,   137,   138,   139,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,   188,    -1,
     190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,
     200,   201,    -1,   203,    -1,   205,   206,   207,    -1,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,    -1,
     220,    -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,
      -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,   239,
      -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,    -1,   276,   277,    -1,   279,
      -1,   281,   282,   283,   284,    -1,    -1,   287,   288,    -1,
      -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,   346,   347,   348,    -1,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,    -1,   395,   396,    -1,   398,   399,
     400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,    -1,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,   431,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,    -1,   137,
     138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,   185,   186,   187,
     188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,
     198,    -1,   200,   201,    -1,   203,    -1,   205,   206,   207,
      -1,   209,   210,   211,    -1,   213,   214,   215,   216,   217,
      -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,
     228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,
     238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,    -1,   264,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,    -1,   276,   277,
      -1,   279,    -1,   281,   282,   283,   284,   285,    -1,   287,
      -1,   289,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,
     298,   299,   300,   301,    -1,   303,   304,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,   332,   333,   334,   335,   336,   337,
     338,    -1,    -1,   341,   342,   343,    -1,   345,   346,   347,
     348,    -1,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
     378,   379,   380,   381,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,    -1,    -1,   395,   396,    -1,
     398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,   414,    -1,   416,   417,
      -1,    -1,    -1,    -1,   422,    -1,   424,    -1,    -1,    -1,
      -1,    -1,   430,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,   185,   186,   187,   188,    -1,   190,    -1,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,   285,    -1,   287,    -1,   289,    -1,   291,   292,
      -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,   381,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,   414,    -1,   416,   417,    -1,    -1,    -1,    -1,   422,
      -1,   424,    -1,    -1,    -1,    -1,    -1,   430,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,    -1,   137,
     138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
     188,    -1,   190,    -1,   192,    -1,   194,    -1,   196,    -1,
     198,    -1,   200,   201,    -1,   203,    -1,   205,   206,   207,
      -1,   209,   210,   211,   212,   213,   214,   215,   216,   217,
      -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,
     228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,
     238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,    -1,   264,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,    -1,   276,   277,
      -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,   287,
      -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,
     298,   299,   300,   301,    -1,   303,   304,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,   332,   333,   334,   335,   336,   337,
     338,    -1,    -1,   341,   342,   343,    -1,   345,   346,   347,
     348,    -1,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,    -1,    -1,   395,   396,    -1,
     398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,    -1,    -1,   416,   417,
      -1,    -1,    -1,    -1,   422,    -1,     6,     7,     8,     9,
      10,    11,   430,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,    -1,   137,   138,   139,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,   188,    -1,
     190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,
     200,   201,    -1,   203,    -1,   205,   206,   207,    -1,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,    -1,
     220,    -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,
      -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,   239,
      -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,   264,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,    -1,   276,   277,    -1,   279,
      -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,
      -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,   346,   347,   348,    -1,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,    -1,   395,   396,    -1,   398,   399,
     400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,   417,    -1,    -1,
      -1,    -1,   422,    -1,     6,     7,     8,     9,    10,    11,
     430,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,   220,    -1,
     222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,   241,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,    -1,   276,   277,    -1,   279,    -1,   281,
     282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,
     292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,
      -1,   303,   304,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
     332,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,   374,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,   417,    -1,     6,     7,     8,
       9,    10,    11,   425,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,
      -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,    -1,   416,   417,    -1,
      -1,   420,   421,   422,    -1,   424,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,    -1,   137,   138,   139,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,   188,    -1,
     190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,
     200,   201,    -1,   203,    -1,   205,   206,   207,    -1,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,    -1,
     220,    -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,
      -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,   239,
      -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,   264,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,    -1,   276,   277,    -1,   279,
      -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,
      -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,   346,   347,   348,    -1,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,    -1,   395,   396,    -1,   398,   399,
     400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,    -1,     4,   419,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    17,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
      -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,
     196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,
     206,   207,    -1,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,
     226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,
     236,   237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,   264,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,    -1,
     276,   277,    -1,   279,    -1,   281,   282,   283,   284,    -1,
      -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,
      -1,    -1,   298,   299,   300,   301,    -1,   303,   304,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,   332,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,    -1,   345,
     346,   347,   348,    -1,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,     6,     7,     8,    -1,    10,    11,    -1,    13,    14,
      15,    -1,    -1,    -1,    19,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    -1,    -1,    -1,
      35,    36,    37,    38,    -1,    40,    -1,    42,    43,    44,
      45,    46,    47,    48,    49,    -1,    -1,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    99,    -1,    -1,    -1,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   117,    -1,    -1,    -1,    -1,    -1,    -1,   124,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   134,
      -1,    -1,    -1,    -1,    -1,   140,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   152,   153,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   181,    -1,    -1,   184,
      -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,   193,    -1,
     195,    -1,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,
      -1,    -1,    -1,   208,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   219,   220,    -1,    -1,    -1,    -1,
      -1,   226,    -1,   228,    -1,    -1,   231,   232,    -1,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,    -1,   244,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   262,   263,   264,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,    -1,
      -1,    -1,    -1,   278,    -1,    -1,   281,   282,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     295,   296,   297,   298,    -1,    -1,    -1,    -1,   303,   304,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     315,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   329,    -1,    -1,   332,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   346,    -1,    -1,   349,    -1,   351,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   361,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   372,   373,    -1,
      -1,    -1,    -1,   378,    -1,   380,    -1,    -1,    -1,    -1,
      -1,    -1,   387,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   399,    -1,   401,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   413,    -1,
      -1,   416,    -1,   418,     6,     7,     8,    -1,    10,    11,
      -1,    13,    14,    15,    -1,    -1,    -1,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      -1,    -1,    -1,    35,    36,    37,    38,    -1,    40,    -1,
      42,    43,    44,    45,    46,    47,    48,    49,    -1,    -1,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,
      -1,   103,   104,   105,   106,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,    -1,    -1,
      -1,    -1,   124,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   134,    -1,    -1,    -1,    -1,    -1,   140,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     152,   153,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   181,
      -1,    -1,   184,    -1,    -1,    -1,   188,    -1,    -1,    -1,
      -1,   193,    -1,   195,    -1,    -1,    -1,    -1,    -1,   201,
      -1,    -1,    -1,    -1,    -1,    -1,   208,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   219,   220,    -1,
      -1,    -1,    -1,    -1,   226,    -1,   228,    -1,    -1,   231,
     232,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
     242,    -1,   244,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     262,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,    -1,    -1,    -1,    -1,   278,    -1,    -1,   281,
     282,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   295,   296,   297,   298,    -1,    -1,    -1,
      -1,   303,   304,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   315,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   329,    -1,    -1,
     332,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   346,    -1,    -1,   349,    -1,   351,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   361,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     372,   373,    -1,    -1,    -1,    -1,   378,    -1,   380,    -1,
      -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   399,    -1,   401,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   413,    -1,    -1,   416,    -1,   418,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
     108,   109,   110,    -1,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,    -1,   160,   161,   162,   163,   164,   165,   166,   167,
     168,   169,   170,   171,   172,   173,   174,   175,   176,   177,
     178,   179,   180,   181,   182,    -1,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,    -1,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,   229,    -1,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,    -1,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,    -1,   340,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,    -1,
     398,   399,   400,   401,   402,    -1,   404,   405,   406,   407,
     408,   409,   410,   411,    -1,   413,    -1,    -1,   416,     5,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    -1,    35,
      36,    37,    38,    39,    40,    -1,    42,    43,    44,    -1,
      46,    47,    48,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,    -1,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,    -1,   135,
      -1,   137,   138,   139,   140,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,    -1,   182,    -1,    -1,    -1,
     186,   187,   188,    -1,   190,    -1,   192,   193,    -1,   195,
     196,    -1,   198,    -1,   200,    -1,    -1,   203,    -1,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,   217,    -1,   219,   220,    -1,   222,   223,   224,   225,
     226,    -1,   228,    -1,    -1,   231,   232,   233,   234,   235,
     236,   237,   238,   239,    -1,    -1,   242,   243,   244,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,    -1,
     266,   267,   268,   269,   270,   271,   272,    -1,   274,    -1,
     276,   277,   278,   279,    -1,    -1,   282,   283,   284,    -1,
      -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,
     296,   297,    -1,   299,   300,   301,    -1,    -1,    -1,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,    -1,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,    -1,   379,    -1,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,   401,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,     5,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      -1,    35,    36,    37,    38,    39,    40,    -1,    42,    43,
      44,    -1,    46,    47,    48,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
      -1,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
      -1,   135,    -1,   137,   138,   139,   140,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,    -1,   182,    -1,
      -1,    -1,   186,   187,   188,    -1,   190,    -1,   192,   193,
      -1,   195,   196,    -1,   198,    -1,   200,    -1,    -1,   203,
      -1,   205,   206,   207,   208,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,   219,    -1,    -1,   222,   223,
     224,   225,   226,    -1,   228,    -1,    -1,   231,   232,   233,
     234,   235,   236,   237,   238,   239,    -1,    -1,   242,   243,
     244,    -1,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,    -1,   266,   267,   268,   269,   270,   271,   272,    -1,
     274,    -1,   276,   277,   278,   279,    -1,    -1,   282,   283,
     284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,
      -1,    -1,   296,   297,    -1,   299,   300,   301,    -1,    -1,
      -1,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
      -1,   345,   346,   347,   348,   349,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,    -1,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,    -1,   379,    -1,    -1,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,    -1,
      -1,   395,   396,    -1,   398,   399,   400,   401,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
      -1,    -1,   416,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,    -1,    -1,   287,   288,    -1,    -1,   291,   292,
      -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,    -1,    -1,   416,   417,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,    -1,
     141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,   188,    -1,   190,
      -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,    -1,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,    -1,   220,
      -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,
      -1,    -1,   233,    -1,   235,   236,   237,   238,   239,    -1,
     241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,    -1,   264,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,    -1,   276,   277,    -1,   279,    -1,
     281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,
     291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,    -1,   345,   346,   347,   348,    -1,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,   384,   385,   386,    -1,    -1,   389,   390,
     391,   392,    -1,    -1,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,    -1,    -1,   416,   417,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,
      -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,   374,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,    -1,   416,   417,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,    -1,
     137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,    -1,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,
      -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,
     237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,
     247,   248,    -1,    -1,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,   264,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,    -1,   276,
     277,    -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,
     287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,
      -1,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,    -1,   341,   342,   343,    -1,   345,   346,
     347,   348,    -1,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,   384,   385,   386,
      -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,   414,    -1,   416,
     417,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    17,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,
      -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,    -1,   220,    -1,   222,   223,   224,
      -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,    -1,   241,    -1,   243,    -1,
      -1,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,   264,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,    -1,   279,    -1,   281,   282,   283,   284,
      -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,
     295,    -1,    -1,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,    -1,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,    -1,
      -1,   416,   417,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,
      -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,    -1,    -1,   416,   417,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,    -1,
     141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,   188,    -1,   190,
      -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,    -1,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,    -1,   220,
      -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,
      -1,    -1,   233,    -1,   235,   236,   237,   238,   239,    -1,
     241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,    -1,   264,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,    -1,   276,   277,    -1,   279,    -1,
     281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,
     291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,    -1,   345,   346,   347,   348,    -1,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,   384,   385,   386,    -1,    -1,   389,   390,
     391,   392,    -1,    -1,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,   414,    -1,   416,   417,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,
      -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,    -1,    -1,   416,   417,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,    -1,
     137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,    -1,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,
      -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,
     237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,
     247,   248,    -1,    -1,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,   264,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,    -1,   276,
     277,    -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,
     287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,
      -1,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,    -1,   341,   342,   343,    -1,   345,   346,
     347,   348,    -1,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,   384,   385,   386,
      -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,    -1,    -1,   416,
     417,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,
      -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,    -1,   220,    -1,   222,   223,   224,
      -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,    -1,   241,    -1,   243,    -1,
      -1,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,   264,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,    -1,   279,    -1,   281,   282,   283,   284,
      -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,
     295,    -1,    -1,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,    -1,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,    -1,
      -1,   416,   417,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,
      -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,    -1,    -1,   416,   417,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,   107,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,    -1,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,    -1,   135,    -1,   137,   138,   139,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,    -1,   182,    -1,    -1,    -1,   186,   187,   188,    -1,
     190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,
     200,    -1,    -1,   203,    -1,   205,   206,   207,    -1,   209,
     210,   211,   212,   213,   214,   215,   216,   217,    -1,    -1,
     220,    -1,   222,   223,   224,   225,   226,    -1,   228,    -1,
      -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,   239,
      -1,    -1,    -1,   243,    -1,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,   264,    -1,   266,   267,   268,   269,
     270,   271,   272,    -1,   274,    -1,   276,   277,    -1,   279,
      -1,    -1,   282,   283,   284,    -1,    -1,   287,    -1,    -1,
      -1,   291,   292,    -1,    -1,   295,    -1,    -1,    -1,   299,
     300,   301,    -1,    -1,    -1,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,   346,   347,   348,    -1,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,    -1,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,    -1,   379,
      -1,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,    -1,   395,   396,    -1,   398,   399,
     400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,   107,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,    -1,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,    -1,   135,    -1,   137,
     138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,    -1,   182,    -1,    -1,    -1,   186,   187,
     188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,
     198,    -1,   200,    -1,    -1,   203,    -1,   205,   206,   207,
      -1,   209,   210,   211,    -1,   213,   214,   215,   216,   217,
      -1,    -1,    -1,    -1,   222,   223,   224,   225,   226,    -1,
     228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,
     238,   239,    -1,    -1,    -1,   243,    -1,    -1,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,    -1,   264,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,    -1,   276,   277,
      -1,   279,    -1,    -1,   282,   283,   284,    -1,    -1,   287,
      -1,    -1,    -1,   291,   292,    -1,    -1,    -1,    -1,    -1,
      -1,   299,   300,   301,    -1,    -1,    -1,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,    -1,    -1,   341,   342,   343,    -1,   345,   346,   347,
     348,    -1,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,    -1,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
      -1,   379,    -1,    -1,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,    -1,    -1,   395,   396,    -1,
     398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,    -1,    -1,   416,     5,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    -1,    35,
      36,    37,    38,    39,    40,    -1,    42,    43,    44,    -1,
      46,    47,    48,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,   107,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,    -1,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,    -1,   135,
      -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,    -1,   182,    -1,    -1,    -1,
     186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,
     196,    -1,   198,    -1,   200,    -1,    -1,   203,    -1,   205,
     206,   207,    -1,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,    -1,    -1,    -1,   222,   223,   224,   225,
     226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,
     236,   237,   238,   239,    -1,    -1,    -1,   243,    -1,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,   264,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,    -1,
     276,   277,    -1,   279,    -1,    -1,   282,   283,   284,    -1,
      -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,    -1,
      -1,    -1,    -1,   299,   300,   301,    -1,    -1,    -1,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,    -1,   345,
     346,   347,   348,    -1,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,    -1,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,    -1,   379,    -1,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,     5,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      -1,    35,    36,    37,    38,    39,    40,    -1,    42,    43,
      44,    -1,    46,    47,    48,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,   107,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
      -1,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
      -1,   135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,    -1,   182,    -1,
      -1,    -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,
      -1,    -1,   196,    -1,   198,    -1,   200,    -1,    -1,   203,
      -1,   205,   206,   207,    -1,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,    -1,    -1,    -1,   222,   223,
     224,   225,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,
      -1,   235,   236,   237,   238,   239,    -1,    -1,    -1,   243,
      -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
     264,    -1,   266,   267,   268,   269,   270,   271,   272,    -1,
     274,    -1,   276,   277,    -1,   279,   280,    -1,   282,   283,
     284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,
      -1,    -1,    -1,    -1,    -1,   299,   300,   301,    -1,    -1,
      -1,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
      -1,   345,   346,   347,   348,    -1,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,    -1,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,    -1,   379,    -1,    -1,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,    -1,
      -1,   395,   396,    -1,   398,   399,   400,    -1,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
      -1,    -1,   416,     5,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    -1,    35,    36,    37,    38,    39,    40,    -1,
      42,    43,    44,    -1,    46,    47,    48,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,   107,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,    -1,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,    -1,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,    -1,
     182,    -1,    -1,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,    -1,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,    -1,    -1,
     222,   223,   224,   225,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,    -1,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,    -1,   266,   267,   268,   269,   270,   271,
     272,    -1,   274,    -1,   276,   277,    -1,   279,    -1,    -1,
     282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,
     292,    -1,    -1,    -1,    -1,    -1,    -1,   299,   300,   301,
      -1,    -1,    -1,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,    -1,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,    -1,   379,    -1,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,   107,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,    -1,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,    -1,   135,    -1,   137,   138,   139,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,    -1,   182,    -1,    -1,    -1,   186,   187,   188,    -1,
     190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,
     200,    -1,    -1,   203,    -1,   205,   206,   207,    -1,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,    -1,
      -1,    -1,   222,   223,   224,   225,   226,    -1,   228,    -1,
      -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,   239,
      -1,    -1,    -1,   243,    -1,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,   264,    -1,   266,   267,   268,   269,
     270,   271,   272,    -1,   274,    -1,   276,   277,    -1,   279,
      -1,    -1,   282,   283,   284,    -1,    -1,   287,    -1,    -1,
      -1,   291,   292,    -1,    -1,    -1,    -1,    -1,    -1,   299,
     300,   301,    -1,    -1,    -1,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,    -1,   347,   348,    -1,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,    -1,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,    -1,   379,
      -1,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,    -1,   395,   396,    -1,   398,   399,
     400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,   108,
     109,   110,    -1,   112,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,   152,   153,   154,   155,   156,   157,   158,
      -1,   160,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,    -1,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,    -1,   198,
     199,   200,   201,   202,   203,   204,   205,   206,    -1,   208,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,   220,    -1,   222,   223,   224,    -1,   226,   227,   228,
     229,    -1,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,    -1,   257,   258,
      -1,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,    -1,
      -1,   340,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,   371,   372,   373,    -1,   375,   376,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,   401,   402,    -1,   404,   405,   406,   407,   408,
     409,    -1,   411,    -1,   413,    -1,    -1,   416,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,    -1,   137,
     138,   139,   140,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
     188,    -1,   190,    -1,   192,   193,    -1,   195,   196,    -1,
     198,    -1,   200,   201,    -1,   203,    -1,   205,   206,   207,
     208,   209,   210,   211,    -1,   213,   214,   215,   216,   217,
      -1,   219,   220,    -1,   222,   223,   224,    -1,   226,    -1,
     228,    -1,    -1,   231,   232,   233,   234,   235,   236,   237,
     238,   239,    -1,   241,   242,   243,   244,    -1,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,    -1,   276,   277,
     278,   279,    -1,   281,   282,   283,   284,    -1,    -1,   287,
     288,    -1,    -1,   291,   292,    -1,    -1,   295,   296,   297,
     298,   299,   300,   301,    -1,   303,   304,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,    -1,    -1,   341,   342,   343,    -1,   345,   346,   347,
     348,   349,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,    -1,    -1,   395,   396,    -1,
     398,   399,   400,   401,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,    -1,    -1,   416,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,   131,   132,   133,   134,   135,    -1,
     137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,   188,    -1,   190,   191,   192,    -1,    -1,    -1,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,    -1,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,
      -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,
     237,   238,   239,    -1,   241,    -1,   243,   244,    -1,   246,
     247,   248,    -1,    -1,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,   264,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,    -1,   276,
     277,    -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,
     287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,
      -1,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,    -1,   341,   342,   343,    -1,   345,   346,
     347,   348,    -1,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,   384,   385,   386,
      -1,   388,   389,   390,   391,   392,    -1,    -1,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,    -1,    -1,   416,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,   137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,
     196,    -1,   198,   199,   200,   201,    -1,   203,    -1,   205,
     206,   207,    -1,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,
     226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,
     236,   237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,   264,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,    -1,
     276,   277,    -1,   279,    -1,   281,   282,   283,   284,    -1,
      -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,
      -1,    -1,   298,   299,   300,   301,    -1,   303,   304,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,   332,   333,   334,   335,
     336,   337,   338,    -1,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,    -1,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,   136,   137,   138,   139,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,
      -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,    -1,   220,    -1,   222,   223,   224,
      -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,    -1,   241,    -1,   243,    -1,
      -1,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,   264,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,    -1,   279,    -1,   281,   282,   283,   284,
      -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,
     295,    -1,    -1,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,   340,   341,   342,   343,    -1,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,    -1,
      -1,   416,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    -1,    29,    30,    31,    32,    -1,
      -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,    43,
      44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    88,    89,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,
      -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,
      -1,   205,   206,   207,    -1,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,    -1,   220,    -1,   222,   223,
     224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,
      -1,   235,   236,   237,   238,   239,    -1,   241,    -1,   243,
      -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,    -1,   276,   277,    -1,   279,    -1,   281,   282,   283,
     284,    -1,    -1,   287,   288,    -1,    -1,   291,   292,    -1,
      -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,   303,
     304,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,   332,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
      -1,   345,   346,   347,   348,    -1,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,    -1,
      -1,   395,   396,    -1,   398,   399,   400,    -1,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
      -1,    -1,   416,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,    -1,    -1,   287,   288,    -1,   290,   291,   292,
      -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,    -1,    -1,   416,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,   220,    -1,
     222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,   241,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,    -1,   276,   277,    -1,   279,    -1,   281,
     282,   283,   284,    -1,    -1,   287,   288,    -1,    -1,   291,
     292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,
      -1,   303,   304,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
     332,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,    -1,   364,   365,   366,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,   137,   138,   139,    -1,
     141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,   188,    -1,   190,
      -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,    -1,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,    -1,   220,
      -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,
      -1,    -1,   233,    -1,   235,   236,   237,   238,   239,    -1,
     241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,    -1,   264,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,    -1,   276,   277,    -1,   279,    -1,
     281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,
     291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,    -1,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,   384,   385,   386,    -1,    -1,   389,   390,
     391,   392,    -1,    -1,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,    -1,    -1,   416,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,    -1,   137,   138,   139,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,   188,    -1,
     190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,
     200,   201,    -1,   203,    -1,   205,   206,   207,    -1,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,    -1,
     220,    -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,
      -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,   239,
      -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,    -1,   276,   277,    -1,   279,
      -1,   281,   282,   283,   284,    -1,    -1,   287,   288,    -1,
      -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,   346,   347,   348,    -1,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,    -1,   395,   396,    -1,   398,   399,
     400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
      -1,   190,    -1,   192,    -1,   194,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,   212,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,
      -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,    -1,    -1,   416,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,    -1,   137,
     138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
     188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,
     198,    -1,   200,   201,    -1,   203,    -1,   205,   206,   207,
      -1,   209,   210,   211,    -1,   213,   214,   215,   216,   217,
      -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,
     228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,
     238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,    -1,   264,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,    -1,   276,   277,
      -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,   287,
      -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,
     298,   299,   300,   301,    -1,   303,   304,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,   332,   333,   334,   335,   336,   337,
     338,    -1,    -1,   341,   342,   343,    -1,   345,   346,   347,
     348,    -1,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,   393,    -1,   395,   396,    -1,
     398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,    -1,    -1,   416,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,    -1,
     137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,    -1,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,
      -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,
     237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,
     247,   248,    -1,    -1,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,   264,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,    -1,   276,
     277,    -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,
     287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,
      -1,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,    -1,   341,   342,   343,    -1,   345,   346,
     347,   348,    -1,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,   384,   385,   386,
      -1,    -1,   389,   390,   391,   392,   393,    -1,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,    -1,    -1,   416,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
      -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,
     196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,
     206,   207,    -1,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,
     226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,
     236,   237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,   264,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,    -1,
     276,   277,    -1,   279,    -1,   281,   282,   283,   284,    -1,
      -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,
      -1,    -1,   298,   299,   300,   301,    -1,   303,   304,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,   332,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,    -1,   345,
     346,   347,   348,    -1,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    93,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,
      -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,    -1,   220,    -1,   222,   223,   224,
      -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,    -1,   241,    -1,   243,    -1,
      -1,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,   264,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,    -1,   279,    -1,   281,   282,   283,   284,
      -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,
     295,    -1,    -1,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,    -1,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,    -1,
      -1,   416,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    -1,    29,    30,    31,    32,    -1,
      -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,    43,
      44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    93,
      -1,    95,    96,    -1,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,
      -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,
      -1,   205,   206,   207,    -1,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,    -1,   220,    -1,   222,   223,
     224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,
      -1,   235,   236,   237,   238,   239,    -1,   241,    -1,   243,
      -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
     264,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,    -1,   276,   277,    -1,   279,    -1,   281,   282,   283,
     284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,
      -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,   303,
     304,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,   332,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
      -1,   345,   346,   347,   348,    -1,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,    -1,
      -1,   395,   396,    -1,   398,   399,   400,    -1,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
      -1,    -1,   416,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,   202,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,
      -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,    -1,    -1,   416,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,   220,    -1,
     222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,   241,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,    -1,   276,   277,    -1,   279,    -1,   281,
     282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,
     292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,
      -1,   303,   304,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
     332,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,    -1,
     141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,   188,    -1,   190,
      -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,    -1,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,    -1,   220,
      -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,
      -1,    -1,   233,    -1,   235,   236,   237,   238,   239,    -1,
     241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,    -1,   264,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,    -1,   276,   277,    -1,   279,    -1,
     281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,
     291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,    -1,   345,   346,   347,   348,    -1,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,   384,   385,   386,    -1,    -1,   389,   390,
     391,   392,    -1,    -1,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,    -1,    -1,   416,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,    -1,   137,   138,   139,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,   188,    -1,
     190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,
     200,   201,    -1,   203,    -1,   205,   206,   207,    -1,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,    -1,
     220,    -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,
      -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,   239,
      -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,   264,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,    -1,   276,   277,    -1,   279,
      -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,
      -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,   346,   347,   348,    -1,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,    -1,   395,   396,    -1,   398,   399,
     400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    8