.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER GROUP" "" "2008-01-03" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER GROUP \- change a user group

.SH SYNOPSIS
.sp
.nf
ALTER GROUP \fIgroupname\fR ADD USER \fIusername\fR [, ... ]
ALTER GROUP \fIgroupname\fR DROP USER \fIusername\fR [, ... ]

ALTER GROUP \fIgroupname\fR RENAME TO \fInewname\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER GROUP\fR is used to change a user group. The
first two variants add or remove users from a group. Only database
superusers can use this command. Adding a user to a group does not
create the user. Similarly, removing a user from a group does not
drop the user itself.
.PP
The third variant changes the name of the group. Only a database
superuser can rename groups.
.SH "PARAMETERS"
.TP
\fB\fIgroupname\fB\fR
The name of the group to modify.
.TP
\fB\fIusername\fB\fR
Users which are to be added or removed from the group. The users
must exist.
.TP
\fB\fInewname\fB\fR
The new name of the group.
.SH "EXAMPLES"
.PP
Add users to a group:
.sp
.nf
ALTER GROUP staff ADD USER karl, john;
.sp
.fi
Remove a user from a group:
.sp
.nf
ALTER GROUP workers DROP USER beth;
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBALTER GROUP\fR statement in the SQL
standard. The concept of roles is similar.
.SH "SEE ALSO"
CREATE GROUP [\fBcreate_group\fR(l)], DROP GROUP [\fBdrop_group\fR(l)]
