.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "DROP OPERATOR CLASS" "l" "2002-11-06" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP OPERATOR CLASS \- remove a user-defined operator class
.SH SYNOPSIS
.sp
.nf
DROP OPERATOR CLASS \fIname\fR USING \fIaccess_method\fR [ CASCADE | RESTRICT ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing operator class.
.TP
\fB\fIaccess_method\fB\fR
The name of the index access method the operator class is for.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the operator class.
.TP
\fBRESTRICT\fR
Refuse to drop the operator class if there are any dependent objects.
This is the default.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP OPERATOR CLASS\fR
The message returned if the command is successful.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP OPERATOR CLASS\fR drops an existing operator class
from the database.
To execute this command you must be the owner of the operator class.
.SS "NOTES"
.PP
The \fBDROP OPERATOR CLASS\fR statement is a 
PostgreSQL
language extension.
.PP
Refer to
CREATE OPERATOR CLASS [\fBcreate_operator_class\fR(l)]
for information on how to create operator classes.
.SH "USAGE"
.PP
Remove B-tree operator class widget_ops:
.sp
.nf
DROP OPERATOR CLASS widget_ops USING btree;
   
.sp
.fi
This command will not execute if there are any existing indexes
that use the operator class. Add CASCADE to drop
such indexes along with the operator class.
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBDROP OPERATOR CLASS\fR in
SQL92.
