.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE TABLE AS" "l" "2002-11-06" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE TABLE AS \- create a new table from the results of a query
.SH SYNOPSIS
.sp
.nf
CREATE [ [ LOCAL ] { TEMPORARY | TEMP } ] TABLE \fItable_name\fR [ (\fIcolumn_name\fR [, ...] ) ]
    AS \fIquery\fR
  
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE TABLE AS\fR creates a table and fills it
with data computed by a \fBSELECT\fR command. The
table columns have the names and data types associated with the
output columns of the \fBSELECT\fR (except that you
can override the column names by giving an explicit list of new
column names).
.PP
\fBCREATE TABLE AS\fR bears some resemblance to
creating a view, but it is really quite different: it creates a new
table and evaluates the query just once to fill the new table
initially. The new table will not track subsequent changes to the
source tables of the query. In contrast, a view re-evaluates its
defining \fBSELECT\fR statement whenever it is
queried.
.SH "PARAMETERS"
.TP
\fB[LOCAL] TEMPORARY or [LOCAL] TEMP\fR
If specified, the table is created as a temporary table.
Refer to \fBcreate_table\fR(l) for details.
.TP
\fB\fItable_name\fB\fR
The name (optionally schema-qualified) of the table to be created.
.TP
\fB\fIcolumn_name\fB\fR
The name of a column in the new table. Multiple column names can
be specified using a comma-delimited list of column names. If
column names are not provided, they are taken from the output
column names of the query.
.TP
\fB\fIquery\fB\fR
A query statement (that is, a \fBSELECT\fR
command). Refer to
\fBselect\fR(l)
for a description of the allowed syntax.
.SH "DIAGNOSTICS"
.PP
Refer to \fBcreate_table\fR(l) and
\fBselect\fR(l)
for a summary of possible output messages.
.SH "NOTES"
.PP
This command is functionally equivalent to \fBselect_into\fR(l), but it is preferred since it is less
likely to be confused with other uses of the \fBSELECT
\&... INTO\fR syntax.
.SH "COMPATIBILITY"
.PP
This command is modeled after an Oracle
feature. There is no command with equivalent functionality in
SQL92 or SQL99. However, a combination of CREATE
TABLE and INSERT ... SELECT can
accomplish the same thing with little more effort.
.SH "HISTORY"
.PP
The \fBCREATE TABLE AS\fR command has been available
since PostgreSQL 6.3.
.SH "SEE ALSO"
\fBcreate_table\fR(l), \fBcreate_view\fR(l), \fBselect\fR(l), \fBselect_into\fR(l)

