.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "DROP TRIGGER" "l" "2002-11-06" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP TRIGGER \- remove a trigger
.SH SYNOPSIS
.sp
.nf
DROP TRIGGER \fIname\fR ON \fItable\fR [ CASCADE | RESTRICT ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing trigger.
.TP
\fB\fItable\fB\fR
The name (optionally schema-qualified) of a table.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the trigger.
.TP
\fBRESTRICT\fR
Refuse to drop the trigger if there are any dependent objects.
This is the default.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP TRIGGER\fR
The message returned if the trigger is successfully dropped.
.TP
\fBERROR: DropTrigger: there is no trigger \fIname\fB on relation "\fItable\fB"\fR
This message occurs if the trigger specified does not exist.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP TRIGGER\fR will remove an existing
trigger definition. To execute this command the current
user must be the owner of the table for which the trigger is defined.
.SH "EXAMPLES"
.PP
Destroy the if_dist_exists trigger
on table films:
.sp
.nf
DROP TRIGGER if_dist_exists ON films;
.sp
.fi
.SH "COMPATIBILITY"
.TP
\fBSQL92\fR
There is no \fBDROP TRIGGER\fR statement in
SQL92.
.TP
\fBSQL99\fR
The \fBDROP TRIGGER\fR statement in
PostgreSQL is incompatible with
SQL99. In SQL99, trigger names are not local to tables, so the
command is simply DROP TRIGGER
\fIname\fR.
.SH "SEE ALSO"
\fBcreate_trigger\fR(l)

