.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE USER" "l" "2002-11-06" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE USER \- define a new database user account
.SH SYNOPSIS
.sp
.nf
CREATE USER \fIusername\fR [ [ WITH ] \fIoption\fR [ ... ] ]

where \fIoption\fR can be:
    
      SYSID \fIuid\fR 
    | [ ENCRYPTED | UNENCRYPTED ] PASSWORD '\fIpassword\fR'
    | CREATEDB | NOCREATEDB
    | CREATEUSER | NOCREATEUSER
    | IN GROUP \fIgroupname\fR [, ...]
    | VALID UNTIL '\fIabstime\fR' 
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE USER\fR will add a new user to an instance
of PostgreSQL. Refer to the
\fIAdministrator's Guide\fR for information about
managing users and authentication. You must be a database
superuser to use this command.
.SS "PARAMETERS"
.PP
.TP
\fB\fIusername\fB\fR
The name of the user.
.TP
\fB\fIuid\fB\fR
The SYSID clause can be used to choose the
PostgreSQL user ID of the user that
is being created. It is not at all necessary that those match
the Unix user IDs, but some people choose to keep the numbers
the same.

If this is not specified, the highest assigned user ID plus one
(with a minimum of 100) will be used as default.
.TP
\fB\fIpassword\fB\fR
Sets the user's password. If you do not plan to use password
authentication you can omit this option, but the user
won't be able to connect to a password-authenticated server.
The password can be set or changed later, using
ALTER USER [\fBalter_user\fR(l)].
.TP
\fBENCRYPTED\fR
.TP
\fBUNENCRYPTED\fR
These keywords control whether the password is stored
encrypted in pg_shadow. (If neither is specified,
the default behavior is determined by the
PASSWORD_ENCRYPTION server parameter.) If
the presented string is already in MD5-encrypted format, then
it is stored as-is, regardless of whether
ENCRYPTED or UNENCRYPTED is specified.
This allows reloading of encrypted passwords during
dump/restore.

See the chapter on client authentication in the
\fIAdministrator's Guide\fR for details on
how to set up authentication mechanisms. Note that older
clients may lack support for the MD5 authentication mechanism
that is needed to work with passwords that are stored
encrypted.
.TP
\fBCREATEDB\fR
.TP
\fBNOCREATEDB\fR
These clauses define a user's ability to create databases. If
CREATEDB is specified, the user being
defined will be allowed to create his own databases. Using
NOCREATEDB will deny a user the ability to
create databases. If this clause is omitted,
NOCREATEDB is used by default.
.TP
\fBCREATEUSER\fR
.TP
\fBNOCREATEUSER\fR
These clauses determine whether a user will be permitted to
create new users himself. This option will also make the user
a superuser who can override all access restrictions.
Omitting this clause will set the user's value of this
attribute to be NOCREATEUSER.
.TP
\fB\fIgroupname\fB\fR
A name of a group into which to insert the user as a new member.
Multiple group names may be listed.
.TP
\fB\fIabstime\fB\fR
The VALID UNTIL clause sets an absolute
time after which the user's password is no longer valid. If
this clause is omitted the login will be valid for all time.
.PP
.SH "DIAGNOSTICS"
.PP
.TP
\fBCREATE USER\fR
Message returned if the command completes successfully.
.PP
.SH "NOTES"
.PP
Use ALTER USER [\fBalter_user\fR(l)] to
change the attributes of a user, and DROP USER [\fBdrop_user\fR(l)] to remove a user. Use ALTER GROUP [\fBalter_group\fR(l)] to add the
user to groups or remove the user from groups.
PostgreSQL includes a program createuser [\fBcreateuser\fR(1)] that has
the same functionality as this command (in fact, it calls this
command) but can be run from the command shell.
.SH "EXAMPLES"
.PP
Create a user with no password:
.sp
.nf
CREATE USER jonathan;
.sp
.fi
.PP
Create a user with a password:
.sp
.nf
CREATE USER davide WITH PASSWORD 'jw8s0F4';
.sp
.fi
.PP
Create a user with a password, whose account is valid until the end of 2001.
Note that after one second has ticked in 2002, the account is not
valid:
.sp
.nf
CREATE USER miriam WITH PASSWORD 'jw8s0F4' VALID UNTIL 'Jan 1 2002';
.sp
.fi
.PP
Create an account where the user can create databases:
.sp
.nf
CREATE USER manuel WITH PASSWORD 'jw8s0F4' CREATEDB;
.sp
.fi
.SH "COMPATIBILITY"
.PP
The \fBCREATE USER\fR statement is a
PostgreSQL extension. The SQL standard
leaves the definition of users to the implementation.
.SH "SEE ALSO"
ALTER USER [\fBalter_user\fR(l)], DROP USER [\fBdrop_user\fR(l)], \fBcreateuser\fR(1)

