.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE DOMAIN" "l" "2002-11-06" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE DOMAIN \- define a new domain
.SH SYNOPSIS
.sp
.nf
CREATE DOMAIN \fIdomainname\fR [AS] \fIdata_type\fR
    [ DEFAULT \fIdefault_expr\fR ]
    [ \fIconstraint\fR [, ... ] ]

where \fIconstraint\fR is:

[ CONSTRAINT \fIconstraint_name\fR ]
{ NOT NULL | NULL }
  
.sp
.fi
.SS "PARAMETERS"
.PP
.TP
\fB\fIdomainname\fB\fR
The name (optionally schema-qualified) of a domain to be created.
.TP
\fB\fIdata_type\fB\fR
The underlying data type of the domain. This may include array
specifiers.
Refer to the \fIUser's Guide\fR for further
information about data types and arrays.
.TP
\fBDEFAULT\fR
The DEFAULT clause specifies a default value for
columns of the domain data type. The value
is any variable-free expression (but subselects are not allowed).
The
data type of the default expression must match the data type of the
domain.

The default expression will be used in any insert operation that
does not specify a value for the column. If there is no default
for a domain, then the default is NULL.
.sp
.RS
.B "Note:"
If a default value is specified for a particular column, it
overrides any default associated with the domain. In turn,
the domain default overrides any default value associated with
the underlying data type.
.RE
.sp
.TP
\fBCONSTRAINT \fIconstraint_name\fB\fR
An optional name for a constraint. If not specified,
the system generates a name.
.TP
\fBNOT NULL\fR
Values of this domain are not allowed to be NULL. 
.TP
\fBNULL\fR
Values of this domain are allowed to be NULL. This is the default.

This clause is only available for compatibility with
non-standard SQL databases. Its use is discouraged in new
applications.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE DOMAIN\fR
Message returned if the domain is successfully created.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE DOMAIN\fR allows the user to register a new
data domain with PostgreSQL for use in the
current data base. The user who defines a domain becomes its owner.
.PP
If a schema name is given (for example, CREATE DOMAIN
myschema.mydomain ...) then the domain is created in the
specified schema. Otherwise it is created in the current schema (the one
at the front of the search path; see CURRENT_SCHEMA()).
The domain name must be unique among the types and domains existing
in its schema.
.PP
Domains are useful for abstracting common fields between tables into
a single location for maintenance. An email address column may be used
in several tables, all with the same properties. Define a domain and
use that rather than setting up each table's constraints individually.
.SH "EXAMPLES"
.PP
This example creates the \fBcountry_code\fR data type and then uses the
type in a table definition:
.sp
.nf
CREATE DOMAIN country_code char(2) NOT NULL;
CREATE TABLE countrylist (id INT4, country country_code);
.sp
.fi
.SH "COMPATIBILITY"
.PP
SQL99 defines CREATE DOMAIN, but says that the only allowed constraint
type is CHECK constraints. CHECK constraints for domains are not yet
supported by PostgreSQL.
.SH "SEE ALSO"
\fBdrop_domain\fR(l), \fIPostgreSQL Programmer's Guide\fR

