.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "REVOKE" "l" "2001-12-28" "SQL - Language Statements" "SQL Commands"
.SH NAME
REVOKE \- remove access privileges
.SH SYNOPSIS
.sp
.nf
REVOKE { { SELECT | INSERT | UPDATE | DELETE | RULE | REFERENCES | TRIGGER } [,...] | ALL [ PRIVILEGES ] }
    ON [ TABLE ] \fIobject\fR [, ...]
    FROM { \fIusername\fR | GROUP \fIgroupname\fR | PUBLIC } [, ...]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBREVOKE\fR allows the creator of an object to revoke
previously granted permissions from one or more users or groups of users.
The key word PUBLIC refers to the implicitly defined
group of all users.
.PP
Note that any particular user will have the sum
of privileges granted directly to him, privileges granted to any group he
is presently a member of, and privileges granted to
PUBLIC. Thus, for example, revoking SELECT privilege
from PUBLIC does not necessarily mean that all users
have lost SELECT privilege on the object: those who have it granted
directly or via a group will still have it.
.PP
See the description of the GRANT [\fBgrant\fR(l)] command for
the meaning of the privilege types.
.SH "NOTES"
.PP
Use \fBpsql\fR(1)'s \fB\\z\fR command to
display the privileges granted on existing objects. See also \fBgrant\fR(l) for information about the format.
.SH "EXAMPLES"
.PP
Revoke insert privilege for the public on table
films:
.sp
.nf
REVOKE INSERT ON films FROM PUBLIC;
.sp
.fi
.PP
Revoke all privileges from user manuel on view kinds:
.sp
.nf
  
REVOKE ALL PRIVILEGES ON kinds FROM manuel;
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
The compatibility notes of the GRANT [\fBgrant\fR(l)] command
apply analogously to \fBREVOKE\fR. The syntax summary is:
.sp
.nf
REVOKE [ GRANT OPTION FOR ] { SELECT | INSERT | UPDATE | DELETE | REFERENCES }
    ON \fIobject\fR [ ( \fIcolumn\fR [, ...] ) ]
    FROM { PUBLIC | \fIusername\fR [, ...] }
    { RESTRICT | CASCADE }
.sp
.fi
.PP
If user1 gives a privilege WITH GRANT OPTION to user2,
and user2 gives it to user3 then user1 can revoke
this privilege in cascade using the CASCADE keyword.
If user1 gives a privilege WITH GRANT OPTION to user2,
and user2 gives it to user3, then if user1 tries to revoke
this privilege it fails if he specifies the RESTRICT
keyword.
.SH "SEE ALSO"
.PP
\fBgrant\fR(l)
