.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "SET SESSION AUTHORIZATION" "l" "2001-04-21" "SQL - Language Statements" "SQL Commands"
.SH NAME
SET SESSION AUTHORIZATION \- set the session user identifier and the current user identifier of the current session
.SH SYNOPSIS
.sp
.nf
SET SESSION AUTHORIZATION '\fIusername\fR'
.sp
.fi
.SH "DESCRIPTION"
.PP
This command sets the session user identifier and the current user
identifer of the current SQL-session context to be
\fIusername\fR.
.PP
The session user identifier is initially set to be the (possibly
authenticated) user name provided by the client. The current user
identifier is normally equal to the session user identifier, but
may change temporarily in the context of ``setuid''
functions and similar mechanisms. The current user identifer is
relevant for permission checking.
.PP
Execution of this command is only permitted if the initial session
user (the \fIauthenticated user\fR) had the
superuser privilege. This permission is kept for the duration of a
connection; for example, it is possible to temporarily become an
unprivileged user and later switch back to become a superuser.
.SH "EXAMPLES"
.sp
.nf
\fBSELECT SESSION_USER, CURRENT_USER;\fR
 current_user | session_user
--------------+--------------
 peter        | peter

\fBSET SESSION AUTHORIZATION 'paul';\fR

\fBSELECT SESSION_USER, CURRENT_USER;\fR
 current_user | session_user
--------------+--------------
 paul         | paul
.sp
.fi
.SH "COMPATIBILITY"
.PP
SQL99
.PP
SQL99 allows some other expressions to appear in place of the
literal \fIusername\fR which are not important in
practice. \fBPostgreSQL\fR allows identifier
syntax ("username"), which SQL does not. SQL
does not allow this command during a transaction;
\fBPostgreSQL\fR does not make
this restriction because there is no reason to. The
privileges necessary to execute this command are left
implementation-defined by the standard.
