.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "MOVE" "l" "2001-11-29" "SQL - Language Statements" "SQL Commands"
.SH NAME
MOVE \- position a cursor on a specified row of a table
.SH SYNOPSIS
.sp
.nf
MOVE [ \fIdirection\fR ] [ \fIcount\fR ] 
    { IN | FROM } \fIcursor\fR
  
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBMOVE\fR allows a user to move cursor position a specified
number of rows.
\fBMOVE\fR works like the \fBFETCH\fR command,
but only positions the cursor and does
not return rows.
.PP
Refer to 
FETCH [\fBfetch\fR(l)]
for details on syntax and usage.
.SS "NOTES"
.PP
\fBMOVE\fR is a Postgres
language extension.
.PP
Refer to
FETCH [\fBfetch\fR(l)]
for a description of valid arguments.
Refer to 
DECLARE [\fBdeclare\fR(l)]
to define a cursor.
Refer to 
BEGIN [\fBbegin\fR(l)], 
COMMIT [\fBcommit\fR(l)],
and
ROLLBACK [\fBrollback\fR(l)]
for further information about transactions.
.SH "USAGE"
.PP
Set up and use a cursor:
.sp
.nf
BEGIN WORK;
DECLARE liahona CURSOR  FOR SELECT * FROM films;
-- Skip first 5 rows:
MOVE FORWARD 5 IN liahona;
MOVE
-- Fetch 6th row in the cursor liahona:
FETCH 1 IN liahona;
FETCH

 code  | title  | did | date_prod | kind   | len
-------+--------+-----+-----------+--------+-------
 P_303 | 48 Hrs | 103 | 1982-10-22| Action | 01:37
(1 row)
-- close the cursor liahona and commit work:
CLOSE liahona;
COMMIT WORK;
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no SQL92 \fBMOVE\fR statement. 
Instead, SQL92 allows
one to \fBFETCH\fR rows from an absolute cursor position,
implicitly moving the cursor to the correct position.
