.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "DELETE" "l" "2001-11-29" "SQL - Language Statements" "SQL Commands"
.SH NAME
DELETE \- delete rows of a table
.SH SYNOPSIS
.sp
.nf
DELETE FROM [ ONLY ] \fItable\fR [ WHERE \fIcondition\fR ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fItable\fB\fR
The name of an existing table.
.TP
\fB\fIcondition\fB\fR
This is an SQL selection query which returns the rows which
are to be deleted.

Refer to the SELECT statement for further description
of the WHERE clause.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDELETE \fIcount\fB\fR
Message returned if items are successfully deleted. The
\fIcount\fR is the number
of rows deleted.

If \fIcount\fR is 0,
no rows were deleted.
.PP
.SH "DESCRIPTION"
.PP
\fBDELETE\fR removes rows which satisfy the WHERE
clause from the specified table.
.PP
If the \fIcondition\fR (WHERE clause) is absent,
the effect is to delete all rows in the table.
The result is a valid, but empty table.
.sp
.RS
.B "Tip:"
TRUNCATE [\fBtruncate\fR(l)] is a
Postgres extension which provides a
faster mechanism to remove all rows from a table.
.RE
.sp
.PP
By default DELETE will delete tuples in the table specified 
and all its sub-tables. If you wish to only update the
specific table mentioned, you should use the ONLY clause.
.PP
You must have write access to the table in order to modify
it, as well as read access to any table whose values are
read in the \fIcondition\fR.
.SH "USAGE"
.PP
Remove all films but musicals:
.sp
.nf
DELETE FROM films WHERE kind <> 'Musical';
SELECT * FROM films;

 code  |           title           | did | date_prod  |  kind   | len
-------+---------------------------+-----+------------+---------+-------
 UA501 | West Side Story           | 105 | 1961-01-03 | Musical | 02:32
 TC901 | The King and I            | 109 | 1956-08-11 | Musical | 02:13
 WD101 | Bed Knobs and Broomsticks | 111 |            | Musical | 01:57
(3 rows)
.sp
.fi
.PP
Clear the table films:
.sp
.nf
DELETE FROM films;
SELECT * FROM films;

 code | title | did | date_prod | kind | len
------+-------+-----+-----------+------+-----
(0 rows)
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
SQL92 allows a positioned DELETE statement:
.sp
.nf
DELETE FROM \fItable\fR WHERE
    CURRENT OF \fIcursor\fR
    
.sp
.fi
where \fIcursor\fR
identifies an open cursor.
Interactive cursors in Postgres are read-only.
