.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "COMMENT" "l" "2001-11-29" "SQL - Language Statements" "SQL Commands"
.SH NAME
COMMENT \- define or change the comment of an object
.SH SYNOPSIS
.sp
.nf
COMMENT ON
[
  [ DATABASE | INDEX | RULE | SEQUENCE | TABLE | TYPE | VIEW ] \fIobject_name\fR |
  COLUMN \fItable_name\fR.\fIcolumn_name\fR |
  AGGREGATE \fIagg_name\fR (\fIagg_type\fR) |
  FUNCTION \fIfunc_name\fR (\fIarg1\fR, \fIarg2\fR, ...) |
  OPERATOR \fIop\fR (\fIleftoperand_type\fR \fIrightoperand_type\fR) |
  TRIGGER \fItrigger_name\fR ON \fItable_name\fR
] IS \fI'text'\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIobject_name, table_name,\fR
The name of the object to be be commented.
.TP
\fB\fItext\fB\fR
The comment to add.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCOMMENT\fR
Message returned if the table is successfully commented.
.PP
.SH "DESCRIPTION"
.PP
\fBCOMMENT\fR adds a comment to an object that can be 
easily retrieved with \fBpsql\fR's
\fB\\dd\fR, \fB\\d+\fR, or \fB\\l+\fR commands.
To remove a comment, write NULL.
Comments are automatically dropped when the object is dropped.
.SH "USAGE"
.PP
Comment the table mytable:
.sp
.nf
COMMENT ON mytable IS 'This is my table.';
   
.sp
.fi
.PP
Some more examples:
.sp
.nf
COMMENT ON DATABASE my_database IS 'Development Database';
COMMENT ON INDEX my_index IS 'Enforces uniqueness on employee id';
COMMENT ON RULE my_rule IS 'Logs UPDATES of employee records';
COMMENT ON SEQUENCE my_sequence IS 'Used to generate primary keys';
COMMENT ON TABLE my_table IS 'Employee Information';
COMMENT ON TYPE my_type IS 'Complex Number support';
COMMENT ON VIEW my_view IS 'View of departmental costs';
COMMENT ON COLUMN my_table.my_field IS 'Employee ID number';
COMMENT ON AGGREGATE my_aggregate (double precision) IS 'Computes sample variance';
COMMENT ON FUNCTION my_function (timestamp) IS 'Returns Roman Numeral';
COMMENT ON OPERATOR ^ (text, text) IS 'Performs intersection of two text';
COMMENT ON TRIGGER my_trigger ON my_table IS 'Used for R.I.';
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBCOMMENT\fR in SQL92.
