.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE TABLE AS" "" "29 March 2001" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE TABLE AS \- Creates a new table from the results of a SELECT
.SH SYNOPSIS
.sp
.nf
CREATE [ TEMPORARY | TEMP ] TABLE \fItable\fR [ (\fIcolumn\fR [, ...] ) ]
     AS \fIselect_clause\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBTEMPORARY or TEMP\fR
If specified, the table is created only within this session, and is
automatically dropped on session exit.
Existing permanent tables with the same name are not visible
(in this session) while the temporary table exists.
Any indexes created on a temporary table are automatically
temporary as well.
.TP
\fB\fItable\fB\fR
The name of the new table to be created.
This table must not already exist. However, a temporary table
can be created that has the same name as an existing permanent
table.
.TP
\fB\fIcolumn\fB\fR
The name of a column. Multiple column names can be specified using
a comma-delimited list of column names. If column names are not
provided, they are taken from the output column names of the
SELECT query.
.TP
\fB\fIselect_clause\fB\fR
A valid query statement. Refer to
SELECT [\fBselect\fR(l)]
for a description of the allowed syntax.
.PP
.SS "OUTPUTS"
.PP
Refer to
CREATE TABLE [\fBcreate_table\fR(l)]
and
SELECT [\fBselect\fR(l)]
for a summary of possible output messages.
.SH "DESCRIPTION"
.PP
\fBCREATE TABLE AS\fR creates a table and fills it
with data computed by a \fBSELECT\fR command. The
table columns have the names and datatypes associated with the
output columns of the \fBSELECT\fR (except that you
can override the \fBSELECT\fR column names by giving
an explicit list of column names).
.PP
\fBCREATE TABLE AS\fR bears some resemblance to creating
a view, but it is really quite different: it creates a new table and
evaluates the \fBSELECT\fR just once to fill the new table
initially. The new table will not track subsequent changes to
the source tables of the \fBSELECT\fR. In contrast,
a view re-evaluates the given \fBSELECT\fR whenever queried.
.PP
This command is functionally equivalent to
SELECT INTO [\fBselect_into\fR(l)],
but it is preferred since it is less likely to be confused with
other uses of the \fBSELECT ... INTO\fR syntax.
