.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE DATABASE" "" "29 March 2001" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE DATABASE \- Creates a new database
.SH SYNOPSIS
.sp
.nf
CREATE DATABASE \fIname\fR
    [ WITH [ LOCATION = '\fIdbpath\fR' ]
           [ TEMPLATE = \fItemplate\fR ]
           [ ENCODING = \fIencoding\fR ] ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of a database to create.
.TP
\fB\fIdbpath\fB\fR
An alternate filesystem location in which to store the new database,
specified as a string literal;
or DEFAULT to use the default location.
.TP
\fB\fItemplate\fB\fR
Name of template from which to create the new database,
or DEFAULT to use the default template
(template1).
.TP
\fB\fIencoding\fB\fR
Multibyte encoding method to use in the new database. Specify
a string literal name (e.g., 'SQL_ASCII'),
or an integer encoding number, or DEFAULT
to use the default encoding.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE DATABASE\fR
Message returned if the command completes successfully.
.TP
\fBERROR: user '\fIusername\fB' is not allowed to create/drop databases\fR
You must have the special CREATEDB privilege to create databases.
See CREATE USER [\fBcreate_user\fR(l)].
.TP
\fBERROR: createdb: database "\fIname\fB" already exists\fR
This occurs if a database with the \fIname\fR
specified already exists.
.TP
\fBERROR: database path may not contain single quotes\fR
The database location
\fIdbpath\fR cannot contain
single quotes. This is required so that the shell commands that
create the database directory can execute safely.
.TP
\fBERROR: CREATE DATABASE: may not be called in a transaction block\fR
If you have an explicit transaction block in progress you cannot call
\fBCREATE DATABASE\fR. You must finish the transaction first.
.TP
\fBERROR: Unable to create database directory '\fIpath\fB'.\fR
.TP
\fBERROR: Could not initialize database directory.\fR
These are most likely related to insufficient permissions on the data
directory, a full disk, or other file system problems. The user under
which the database server is running must have access to the location.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE DATABASE\fR creates a new
Postgres database.
The creator becomes the owner of the new database.
.PP
An alternate location can be specified in order to,
for example, store the database on a different disk.
The path must have been prepared with the 
initlocation [\fBinitlocation\fR(1)]
command.
.PP
If the path name does not contain a slash, it is interpreted
as an environment variable name, which must be known to the
server process. This way the database administrator can
exercise control over locations in which databases can be created.
(A customary choice is, e.g., '\fBPGDATA2\fR'.)
If the server is compiled with ALLOW_ABSOLUTE_DBPATHS
(not so by default), absolute path names, as identified by
a leading slash
(e.g., '\fI/usr/local/pgsql/data\fR'),
are allowed as well.
.PP
By default, the new database will be created by cloning the standard
system database template1. A different template can be
specified by writing TEMPLATE =
\fIname\fR. In particular,
by writing TEMPLATE = template0, you can create a virgin
database containing only the standard objects predefined by your
version of Postgres. This is useful if you wish to avoid copying
any installation-local objects that may have been added to template1.
.PP
The optional encoding parameter allows selection of the database encoding,
if your server was compiled with multibyte encoding support. When not
specified, it defaults to the encoding used by the selected template
database.
.PP
Optional parameters can be written in any order, not only the order
illustrated above.
.SS "NOTES"
.PP
\fBCREATE DATABASE\fR is a Postgres
language extension.
.PP
Use DROP DATABASE [\fBdrop_database\fR(l)] to remove a database.
.PP
The program createdb [\fBcreatedb [createdb\fR(1)] is a
shell script wrapper around this command, provided for convenience.
.PP
There are security and data integrity issues
involved with using alternate database locations
specified with absolute path names, and by default
only an environment variable known to the backend may be
specified for an alternate location.
See the Administrator's Guide for more information.
.PP
Although it is possible to copy a database other than template1 by
specifying its name as the template, this is not (yet) intended as
a general-purpose COPY DATABASE facility. In particular, it is
essential that the source database be idle (no data-altering transactions
in progress)
for the duration of the copying operation. CREATE DATABASE will check
that no backend processes (other than itself) are connected to
the source database at the start of the operation, but this does not
guarantee that changes cannot be made while the copy proceeds. Therefore,
we recommend that databases used as templates be treated as read-only.
.PP
Two useful flags exist in pg_database for each
database: datistemplate and
datallowconn. datistemplate
may be set to indicate that a database is intended as a template for
CREATE DATABASE. If this flag is set, the database may be cloned by
any user with CREATEDB privileges; if it is not set, only superusers
and the owner of the database may clone it.
If datallowconn is false, then no new connections
to that database will be allowed (but existing sessions are not killed
simply by setting the flag false). The template0
database is normally marked this way to prevent modification of it.
.SH "USAGE"
.PP
To create a new database:
.sp
.nf
olly=> \fBcreate database lusiadas;\fR
   
.sp
.fi
.PP
To create a new database in an alternate area \fI~/private_db\fR:
.sp
.nf
$ \fBmkdir private_db\fR
$ \fBinitlocation ~/private_db\fR
Creating Postgres database system directory /home/olly/private_db/base
   
$ \fBpsql olly\fR
Welcome to psql, the PostgreSQL interactive terminal.
 
Type:  \\copyright for distribution terms
       \\h for help with SQL commands
       \\? for help on internal slash commands
       \\g or terminate with semicolon to execute query
       \\q to quit

olly=> \fBCREATE DATABASE elsewhere WITH LOCATION = '/home/olly/private_db';\fR
CREATE DATABASE
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBCREATE DATABASE\fR statement in SQL92.
Databases are equivalent to catalogs whose creation is implementation-defined.
