/* include/config.h.  Generated automatically by configure.  */


/* the purpose of this file is to reduce the use of #ifdef's through
 * the code base by those porting the software, and to facilitate the
 * eventual use of autoconf to build the server 
 */

#ifndef CONFIG_H
#define CONFIG_H

/*
 * Default runtime limit on number of backend server processes per postmaster;
 * this is just the default setting for the postmaster's -N switch.
 * (Actual value is set by configure script.)
 */
#define DEF_MAXBACKENDS 32

/*
 * Hard limit on number of backend server processes per postmaster.
 * Increasing this costs about 32 bytes per process slot as of v 6.5.
 */
#define MAXBACKENDS	(DEF_MAXBACKENDS > 1024 ? DEF_MAXBACKENDS : 1024)

/*
 * Default number of buffers in shared buffer pool (each of size BLCKSZ).
 * This is just the default setting for the postmaster's -B switch.
 * Perhaps it ought to be configurable from a configure switch.
 * NOTE: default setting corresponds to the minimum number of buffers
 * that postmaster.c will allow for the default MaxBackends value.
 */
#define DEF_NBUFFERS (DEF_MAXBACKENDS > 8 ? DEF_MAXBACKENDS * 2 : 16)

/*
 * Size of a disk block --- currently, this limits the size of a tuple.
 * You can set it bigger if you need bigger tuples.
 */
#define BLCKSZ	8192

/*
 * RELSEG_SIZE is the maximum number of blocks allowed in one disk file.
 * Thus, the maximum size of a single file is RELSEG_SIZE * BLCKSZ;
 * relations bigger than that are divided into multiple files.
 *
 * CAUTION: RELSEG_SIZE * BLCKSZ must be less than your OS' limit on file
 * size.  This is typically 2Gb or 4Gb in a 32-bit operating system.  By
 * default, we make the limit 1Gb to avoid any possible integer-overflow
 * problems within the OS.  A limit smaller than necessary only means we
 * divide a large relation into more chunks than necessary, so it seems
 * best to err in the direction of a small limit.  (Besides, a power-of-2
 * value saves a few cycles in md.c.)
 *
 * CAUTION: you had best do an initdb if you change either BLCKSZ or
 * RELSEG_SIZE.
 */
#define RELSEG_SIZE	(0x40000000 / BLCKSZ)

/* 
 * The following is set using configure.  
 */

/* Set to 1 if you have <string.h> */
#define HAVE_STRING_H 1

/* Set to 1 if you have <strings.h> */
#define HAVE_STRINGS_H 1

/* Set to 1 if you have <getopt.h> */
#define HAVE_GETOPT_H 1

/* Set to 1 if you have <fp_class.h> */
/* #undef HAVE_FP_CLASS_H */

/* Set to 1 if you have <netinet/in.h> */
#define HAVE_NETINET_IN_H 1

/* Set to 1 if you have <ieeefp.h> */
/* #undef HAVE_IEEEFP_H */

/* Set to 1 if you have <arpa/inet.h> */
#define HAVE_ARPA_INET_H 1

/* Set to 1 if you have <netdb.h> */
#define HAVE_NETDB_H 1

/* Set to 1 if you have <endian.h> */
#define HAVE_ENDIAN_H 1

/* Set to 1 if you have <crypt.h> */
#define HAVE_CRYPT_H 1

/* Set to 1 if you have <termios.h> */
#define HAVE_TERMIOS_H 1

/* Set to 1 if you have <float.h> */
#define HAVE_FLOAT_H 1

/* Set to 1 if you have <limits.h> */
#define HAVE_LIMITS_H 1

/* Set to 1 if  you have <values.h> */
#define HAVE_VALUES_H 1

/* Set to 1 if  you have <sys/select.h> */
#define HAVE_SYS_SELECT_H 1

/* Set to 1 if you have <readline.h> */
/* #undef HAVE_READLINE_H */

/* Set to 1 if you have <history.h> */
/* #undef HAVE_HISTORY_H */

/* Set to 1 if you have <readline/history.h> */
#define HAVE_READLINE_HISTORY_H 1

/* Set to 1 if you have <readline/readline.h> */
#define HAVE_READLINE_READLINE_H 1

/* Set to 1 if you have libreadline and it includes history functions */
#define HAVE_HISTORY 1

/* Set to 1 if you have <dld.h> */
/* #undef HAVE_DLD_H */

/* Define if you have the ANSI C header files.  */
#define STDC_HEADERS 1

/* default path for the location of the odbcinst.ini file */
/* #undef ODBCINST */

/* Define if you have the stricmp function.  */
/* #undef HAVE_STRICMP */

/*
 * Block of parameters for the ODBC code.
 */

/* Set to 1 if you have <pwd.h> */
#define HAVE_PWD_H 1

/* Define if you have the <sys/param.h> header file.  */
#define HAVE_SYS_PARAM_H 1

/* Define if you have the c library (-lc).  */
/* #undef HAVE_LIBC */

/* Define if you have the dl library (-ldl).  */
#define HAVE_LIBDL 1

/* Define if you have the m library (-lm).  */
#define HAVE_LIBM 1

/*
 * End parameters for ODBC code.
 */

/* Set to 1 if you gettimeofday(a,b) vs gettimeofday(a) */
#define HAVE_GETTIMEOFDAY_2_ARGS 1
#ifndef HAVE_GETTIMEOFDAY_2_ARGS
# define gettimeofday(a,b) gettimeofday(a)
#endif

/* Set to 1 if you have snprintf() */
#define HAVE_SNPRINTF 1

/* Set to 1 if you have vsnprintf() */
#define HAVE_VSNPRINTF 1

/* Set to 1 if you have fp_class() */
/* #undef HAVE_FP_CLASS */

/* Set to 1 if you have class() */
/* #undef HAVE_CLASS */

/* Set to 1 if you have fp_class_d() */
/* #undef HAVE_FP_CLASS_D */

/* Set to 1 if you have fpclass() */
/* #undef HAVE_FPCLASS */

/* Set to 1 if you have isinf() */
#define HAVE_ISINF 1
#ifndef HAVE_ISINF
int isinf(double x);
#endif

/* Set to 1 if you have tzset() */
#define HAVE_TZSET 1

/* Set to 1 if you have gethostname() */
#define HAVE_GETHOSTNAME 1
#ifndef HAVE_GETHOSTNAME
int  gethostname(char *name, int namelen);
#endif

/* Set to 1 if struct tm has a tm_zone member */
#define HAVE_TM_ZONE 1

/* Set to 1 if you have int timezone.
 * NOTE: if both tm_zone and a global timezone variable exist,
 * using the tm_zone field should probably be preferred,
 * since global variables are inherently not thread-safe.
 */
#define HAVE_INT_TIMEZONE 1

/* Set to 1 if you have cbrt() */
#define HAVE_CBRT 1

/* Set to 1 if you have inet_aton() */
#define HAVE_INET_ATON 1
#ifndef HAVE_INET_ATON
# ifdef HAVE_ARPA_INET_H
#  ifdef HAVE_NETINET_IN_H
#   include <sys/types.h>
#   include <netinet/in.h>
#  endif
#  include <arpa/inet.h>
# endif
extern int  inet_aton(const char *cp, struct in_addr * addr);
#endif

/* Set to 1 if you have fcvt() */
#define HAVE_FCVT 1

/* Set to 1 if you have strerror() */
#define HAVE_STRERROR 1

/* Set to 1 if you have rint() */
#define HAVE_RINT 1 

/* Set to 1 if you have memmove() */
#define HAVE_MEMMOVE 1

/* Set to 1 if you have sigsetjmp() */
/* #undef HAVE_SIGSETJMP */

/* Set to 1 if you have kill() */
#define HAVE_KILL 1

/* Set to 1 if you have vfork() */
/* #undef HAVE_VFORK */

/* Set to 1 if you have sysconf() */
#define HAVE_SYSCONF 1

/* Set to 1 if you have getrusage() */
#define HAVE_GETRUSAGE 1

/* Set to 1 if you have waitpid() */
#define HAVE_WAITPID 1

/* Set to 1 if you have setsid() */
#define HAVE_SETSID 1

/* Set to 1 if you have sigprocmask() */
#define HAVE_SIGPROCMASK 1

/* Set to 1 if you have sigprocmask() */
#define HAVE_STRCASECMP 1
#ifndef HAVE_STRCASECMP
extern int  strcasecmp(char *s1, char *s2);
#endif

/* Set to 1 if you have strtol() */
#define HAVE_STRTOL 1

/* Set to 1 if you have strtoul() */
#define HAVE_STRTOUL 1

/* Set to 1 if you have strdup() */
#define HAVE_STRDUP 1
#ifndef HAVE_STRDUP
extern char *strdup(char const *);
#endif

/* Set to 1 if you have random() */
#define HAVE_RANDOM 1
#ifndef HAVE_RANDOM
extern long random(void);
#endif

/* Set to 1 if you have srandom() */
#define HAVE_SRANDOM 1
#ifndef HAVE_SRANDOM
extern void srandom(unsigned int seed);
#endif

/* Set to 1 if you have libreadline.a */
#define HAVE_LIBREADLINE 1

/* Set to 1 if you have libhistory.a */
#define HAVE_LIBHISTORY 1

/* Set to 1 if you have union semun */
#define HAVE_UNION_SEMUN 1

/* Set to 1 if you have F_SETLK option for fcntl() */
/* #undef HAVE_FCNTL_SETLK */

/* Set to 1 if you want to USE_LOCALE */
/* #undef USE_LOCALE */

/* Set to 1 if you want CYR_RECODE (cyrillic recode) */
/* #undef CYR_RECODE */

/* Set to 1 if you want to Enable ASSERT CHECKING */
/* #undef USE_ASSERT_CHECKING */

/* Set to 1 if your DBL_MIN is problematic */
/* #undef HAVE_DBL_MIN_PROBLEM */

/* Set to 1 if type "long int" works and is 64 bits */
/* #undef HAVE_LONG_INT_64 */

/* Set to 1 if type "long long int" works and is 64 bits */
#define HAVE_LONG_LONG_INT_64 1

/* Define this as the appropriate snprintf format for 64-bit ints, if any */
#define INT64_FORMAT "%lld"

/* These must be defined as the alignment requirement (NOT the size) of
 * each of the basic C data types (except char, which we assume has align 1).
 * MAXIMUM_ALIGNOF is the largest alignment requirement for any C data type.
 * ALIGNOF_LONG_LONG_INT need only be defined if HAVE_LONG_LONG_INT_64 is.
 */
#define ALIGNOF_SHORT 2
#define ALIGNOF_INT 4
#define ALIGNOF_LONG 4
#define ALIGNOF_LONG_LONG_INT 8
#define ALIGNOF_DOUBLE 8
#define MAXIMUM_ALIGNOF 8

/* Define const as empty if your compiler doesn't grok const. */
/* #undef const */

/* Define as your compiler's spelling of "inline", or empty if no inline. */
/* #undef inline */

/* Define signed as empty if your compiler doesn't grok "signed char" etc */
/* #undef signed */

/* Define volatile as empty if your compiler doesn't grok volatile. */
/* #undef volatile */

/* Define if your cpp understands the ANSI stringizing operators in macros */
#define HAVE_STRINGIZE 1

/* Define as the base type of the last arg to accept */
#define SOCKET_SIZE_TYPE size_t

/* Define if POSIX signal interface is available */
#define USE_POSIX_SIGNALS 1

/*
 * Pull in OS-specific declarations (using link created by configure)
 */

#include "os.h"

/*
 * The following is used as the arg list for signal handlers.  Any ports
 * that take something other than an int argument should change this in
 * the port specific makefile.  Note that variable names are required
 * because it is used in both the prototypes as well as the definitions.
 * Note also the long name.  We expect that this won't collide with
 * other names causing compiler warnings.
 */ 

#ifndef       SIGNAL_ARGS
#  define SIGNAL_ARGS int postgres_signal_arg
#endif

/* 
 * DEF_PGPORT is the TCP port number on which the Postmaster listens by
 * default.  This can be overriden by command options, environment variables,
 * and the postconfig hook. (set by configure script)
 */ 

#define DEF_PGPORT "5432" 

/*
 * If you do not plan to use Host based authentication,
 * comment out the following line (set by build script)
 */
/* #undef HBA */

/*
 * On architectures for which we have not implemented spinlocks (or
 * cannot do so), we use System V semaphores.  We also use them for
 * long locks.  For some reason union semun is never defined in the
 * System V header files so we must do it ourselves.
 */

/*  Debug and various "defines" that should be documented */

/* found in function aclparse() in src/backend/utils/adt/acl.c */
/* #define ACLDEBUG */

/* found in src/backend/utils/adt/arrayfuncs.c
   code seems broken without it, Bruce Momjian */
/* #define LOARRAY */

/*
 * As soon as the backend blocks on a lock, it waits this number of seconds
 * before checking for a deadlock.
 * We don't check for deadlocks just before sleeping because a deadlock is
 * a rare event, and checking is an expensive operation.
 */
#define DEADLOCK_CHECK_TIMER 1

/*
 * This flag enables the use of indexes in plans generated for function
 * executions which normally are always executed with sequential scans.
 */
#define INDEXSCAN_PATCH 

/*
 * Enables debugging print statements in the date/time support routines.
 * Particularly useful for porting to a new platform/OS combination.
 */
/* #define DATEDEBUG */

/*
 * defining unsafe floats's will make float4 and float8
 * ops faster at the cost of safety, of course!        
 */
/* #define UNSAFE_FLOATS */

/*
 * There is a bug in the function executor. The backend crashes while trying to
 * execute an sql function containing an utility command (create, notify, ...).
 * The bug is part in the planner, which returns a number of plans different
 * than the number of commands if there are utility commands in the query, and
 * in part in the function executor which assumes that all commands are normal
 * query commands and causes a SIGSEGV trying to execute commands without plan.
 */
#define FUNC_UTIL_PATCH

/*
 * Define this to make libpgtcl's "pg_result -assign" command process C-style
 * backslash sequences in returned tuple data and convert Postgres array
 * attributes into Tcl lists.  CAUTION: this conversion is *wrong* unless
 * you install the routines in contrib/string/string_io to make the backend
 * produce C-style backslash sequences in the first place.
 */
/* #define TCL_ARRAYS */

/*
 * The following flag allows limiting the number of rows returned by a query.
 * You will need the loadable module utils.c to use this feature.
 */
#define QUERY_LIMIT

/*
 * The following flag allows copying tables from files with number of columns
 * different than the number of attributes setting missing attributes to NULL
 * and ignoring extra columns.  This also avoids the shift of the attributes
 * of the rest of the file if one line has a wrong column count.
 */
#define COPY_PATCH

/*
 * User locks are handled totally on the application side as long term
 * cooperative locks which extend beyond the normal transaction boundaries.
 * Their purpose is to indicate to an application that someone is `working'
 * on an item.  Define this flag to enable user locks.  You will need the
 * loadable module user-locks.c to use this feature.
 */
#define USER_LOCKS

/* Debug #defines */
/* #define IPORTAL_DEBUG  */
/* #define HEAPDEBUGALL  */
/* #define ISTRATDEBUG  */
/* #define FASTBUILD_DEBUG */
#define RTDEBUG 
#define GISTDEBUG 
/* #define DEBUG_RECIPE */

/* The following don't have any apparent purpose, but are in the
 * code.  someday, will take them out altogether, but for now, 
 * document them here
 */
/* #define OMIT_PARTIAL_INDEX */
/* #define NO_BUFFERISVALID   */
/* #define NO_SECURITY        */
/* #define TIOGA              */
/* #define OLD_REWRITE        */
/* #define NOTYET             */

/* Genetic Query Optimization (GEQO):
 * 
 * The GEQO module in PostgreSQL is intended for the solution of the
 * query optimization problem by means of a Genetic Algorithm (GA).
 * It allows the handling of large JOIN queries through non-exhaustive
 * search.
 * For further information see README.GEQO <utesch@aut.tu-freiberg.de>.
 */
#define GEQO /* backend/optimizer/path/allpaths.c */

/*
 * Define this if you want psql to _always_ ask for a username and a password
 * for password authentication.
 */
/* #define PSQL_ALWAYS_GET_PASSWORDS */

/*
 * Define this if you want to allow the lo_import and lo_export SQL functions
 * to be executed by ordinary users.  By default these functions are only
 * available to the Postgres superuser.  CAUTION: these functions are
 * SECURITY HOLES since they can read and write any file that the Postgres
 * backend has permission to access.  If you turn this on, don't say we
 * didn't warn you.
 */
/* #define ALLOW_DANGEROUS_LO_FUNCTIONS */

/*
 * Use btree bulkload code: 
 * this code is moderately slow (~10% slower) compared to the regular
 * btree (insertion) build code on sorted or well-clustered data.  on
 * random data, however, the insertion build code is unusable -- the
 * difference on a 60MB heap is a factor of 15 because the random
 * probes into the btree thrash the buffer pool.
 *
 * Great thanks to Paul M. Aoki (aoki@CS.Berkeley.EDU)
 */
#define FASTBUILD /* access/nbtree/nbtsort.c */

/*
 * TBL_FREE_CMD_MEMORY: free memory allocated for an user query inside
 * transaction block after this query is done. 
 */
#define TBL_FREE_CMD_MEMORY

/*
 * ELOG_TIMESTAMPS: adds a timestamp with the following format to elog
 * messages:  yymmdd.hh:mm:ss.mmm [pid] message
 */
/* #define ELOG_TIMESTAMPS */

/*
 * USE_SYSLOG: use syslog for elog and error messages printed by tprintf
 * and eprintf. This must be activated with the syslog flag in pg_options
 * (syslog=0 for stdio, syslog=1 for stdio+syslog, syslog=2 for syslog).
 * For information see backend/utils/misc/trace.c (Massimo Dal Zotto).
 */
/* #define USE_SYSLOG */

#endif /* CONFIG_H */
