/*
 * Decompiled with CFR 0.152.
 */
package postgresql.largeobject;

import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import postgresql.Connection;
import postgresql.fastpath.Fastpath;
import postgresql.fastpath.FastpathArg;
import postgresql.largeobject.LargeObject;
import postgresql.util.PSQLException;

public class LargeObjectManager {
    private Fastpath fp;
    public static final int WRITE = 131072;
    public static final int READ = 262144;
    public static final int READWRITE = 393216;

    private LargeObjectManager() {
    }

    public LargeObjectManager(Connection connection) throws SQLException {
        this.fp = connection.getFastpathAPI();
        ResultSet resultSet = connection.createStatement().executeQuery("select proname, oid from pg_proc where proname = 'lo_open'    or proname = 'lo_close'    or proname = 'lo_creat'    or proname = 'lo_unlink'    or proname = 'lo_lseek'    or proname = 'lo_tell'    or proname = 'loread'    or proname = 'lowrite'");
        if (resultSet == null) {
            throw new PSQLException("postgresql.lo.init");
        }
        this.fp.addFunctions(resultSet);
        resultSet.close();
        DriverManager.println("Large Object initialised");
    }

    public LargeObject open(int n) throws SQLException {
        return new LargeObject(this.fp, n, 393216);
    }

    public LargeObject open(int n, int n2) throws SQLException {
        return new LargeObject(this.fp, n, n2);
    }

    public int create() throws SQLException {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(393216)};
        return this.fp.getInteger("lo_creat", fastpathArgArray);
    }

    public int create(int n) throws SQLException {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(n)};
        return this.fp.getInteger("lo_creat", fastpathArgArray);
    }

    public void delete(int n) throws SQLException {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(n)};
        this.fp.fastpath("lo_unlink", false, fastpathArgArray);
    }

    public void unlink(int n) throws SQLException {
        this.delete(n);
    }
}

