/*
 * Decompiled with CFR 0.152.
 */
package postgresql.jdbc1;

import java.sql.SQLException;
import java.util.Vector;
import postgresql.Field;
import postgresql.util.PSQLException;

public class ResultSetMetaData
implements java.sql.ResultSetMetaData {
    Vector rows;
    Field[] fields;

    public ResultSetMetaData(Vector vector, Field[] fieldArray) {
        this.rows = vector;
        this.fields = fieldArray;
    }

    public int getColumnCount() throws SQLException {
        return this.fields.length;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        int n2 = this.getField(n).getSQLType();
        switch (n2) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return true;
    }

    public boolean isSearchable(int n) throws SQLException {
        int n2 = this.getField(n).getSQLType();
        switch (n2) {
            case 1111: {
                return true;
            }
        }
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        String string = this.getField(n).getTypeName();
        return string.equals("cash") || string.equals("money");
    }

    public int isNullable(int n) throws SQLException {
        return 1;
    }

    public boolean isSigned(int n) throws SQLException {
        int n2 = this.getField(n).getSQLType();
        switch (n2) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return false;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        int n2 = this.getColumnLabel(n).length();
        int n3 = 0;
        while (n3 < this.rows.size()) {
            int n4;
            byte[][] byArray = (byte[][])this.rows.elementAt(n3);
            if (byArray[n - 1] != null && (n4 = byArray[n - 1].length) > n2) {
                n2 = n4;
            }
            ++n3;
        }
        return n2;
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnName(n);
    }

    public String getColumnName(int n) throws SQLException {
        Field field = this.getField(n);
        if (field != null) {
            return field.name;
        }
        return "field" + n;
    }

    public String getSchemaName(int n) throws SQLException {
        return "";
    }

    public int getPrecision(int n) throws SQLException {
        int n2 = this.getField(n).getSQLType();
        switch (n2) {
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case 7: {
                return 8;
            }
            case 6: {
                return 16;
            }
            case 8: {
                return 16;
            }
            case 12: {
                return 0;
            }
        }
        return 0;
    }

    public int getScale(int n) throws SQLException {
        int n2 = this.getField(n).getSQLType();
        switch (n2) {
            case 5: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 7: {
                return 8;
            }
            case 6: {
                return 16;
            }
            case 8: {
                return 16;
            }
            case 12: {
                return 0;
            }
        }
        return 0;
    }

    public String getTableName(int n) throws SQLException {
        return "";
    }

    public String getCatalogName(int n) throws SQLException {
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        return this.getField(n).getSQLType();
    }

    public String getColumnTypeName(int n) throws SQLException {
        return this.getField(n).getTypeName();
    }

    public boolean isReadOnly(int n) throws SQLException {
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        return this.isReadOnly(n);
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return this.isWritable(n);
    }

    private Field getField(int n) throws SQLException {
        if (n < 1 || n > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange");
        }
        return this.fields[n - 1];
    }
}

