/*
 * Decompiled with CFR 0.152.
 */
package postgresql.jdbc1;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.Vector;
import postgresql.Field;
import postgresql.jdbc1.Connection;
import postgresql.jdbc1.ResultSetMetaData;
import postgresql.largeobject.LargeObject;
import postgresql.largeobject.LargeObjectManager;
import postgresql.util.PSQLException;

public class ResultSet
extends postgresql.ResultSet
implements java.sql.ResultSet {
    public ResultSet(Connection connection, Field[] fieldArray, Vector vector, String string, int n) {
        super(connection, fieldArray, vector, string, n);
    }

    public boolean next() throws SQLException {
        if (++this.current_row >= this.rows.size()) {
            return false;
        }
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        return true;
    }

    public void close() throws SQLException {
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullFlag;
    }

    public String getString(int n) throws SQLException {
        if (n < 1 || n > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange");
        }
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        return new String(this.this_row[n - 1]);
    }

    public boolean getBoolean(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            char c = string.charAt(0);
            return c == 't' || c == 'T';
        }
        return false;
    }

    public byte getByte(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            try {
                return Byte.parseByte(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badbyte", (Object)string);
            }
        }
        return 0;
    }

    public short getShort(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            try {
                return Short.parseShort(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badshort", (Object)string);
            }
        }
        return 0;
    }

    public int getInt(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.badint", (Object)string);
            }
        }
        return 0;
    }

    public long getLong(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badlong", (Object)string);
            }
        }
        return 0L;
    }

    public float getFloat(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            try {
                return Float.valueOf(string).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badfloat", (Object)string);
            }
        }
        return 0.0f;
    }

    public double getDouble(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.baddouble", (Object)string);
            }
        }
        return 0.0;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            BigDecimal bigDecimal;
            try {
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badbigdec", (Object)string);
            }
            try {
                return bigDecimal.setScale(n2);
            }
            catch (ArithmeticException arithmeticException) {
                throw new PSQLException("postgresql.res.badbigdec", (Object)string);
            }
        }
        return null;
    }

    public byte[] getBytes(int n) throws SQLException {
        if (n < 1 || n > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange");
        }
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (!this.wasNullFlag && this.fields[n - 1].getOID() == 26) {
            LargeObjectManager largeObjectManager = this.connection.getLargeObjectAPI();
            LargeObject largeObject = largeObjectManager.open(this.getInt(n));
            byte[] byArray = largeObject.read(largeObject.size());
            largeObject.close();
            return byArray;
        }
        return this.this_row[n - 1];
    }

    public Date getDate(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return new Date(simpleDateFormat.parse(string).getTime());
        }
        catch (ParseException parseException) {
            throw new PSQLException("postgresql.res.baddate", new Integer(parseException.getErrorOffset()), string);
        }
    }

    public Time getTime(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            try {
                if (string.length() != 5 && string.length() != 8) {
                    throw new NumberFormatException("Wrong Length!");
                }
                int n2 = Integer.parseInt(string.substring(0, 2));
                int n3 = Integer.parseInt(string.substring(3, 5));
                int n4 = string.length() == 5 ? 0 : Integer.parseInt(string.substring(6));
                return new Time(n2, n3, n4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badtime", (Object)string);
            }
        }
        return null;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        String string = this.getString(n);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:sszzz");
        if (string != null) {
            int n2 = new Float(string.substring(19)).intValue();
            n2 = n2 * 60 * 60 * 1000;
            TimeZone timeZone = TimeZone.getDefault();
            timeZone.setRawOffset(n2);
            String string2 = timeZone.getID();
            string = String.valueOf(string.substring(0, 19)) + string2;
            try {
                java.util.Date date = simpleDateFormat.parse(string);
                return new Timestamp(date.getTime());
            }
            catch (ParseException parseException) {
                throw new PSQLException("postgresql.res.badtimestamp", new Integer(parseException.getErrorOffset()), string);
            }
        }
        return null;
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this.getBinaryStream(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.getBinaryStream(n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public String getCursorName() throws SQLException {
        return this.connection.getCursorName();
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        return new ResultSetMetaData(this.rows, this.fields);
    }

    public Object getObject(int n) throws SQLException {
        if (n < 1 || n > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange");
        }
        Field field = this.fields[n - 1];
        if (field == null) {
            this.wasNullFlag = true;
            return null;
        }
        switch (field.getSQLType()) {
            case -7: {
                return new Boolean(this.getBoolean(n));
            }
            case 5: {
                return new Integer(this.getInt(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 2: {
                return this.getBigDecimal(n, 0);
            }
            case 7: {
                return new Float(this.getFloat(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 1: 
            case 12: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
        }
        return this.connection.getObject(field.getTypeName(), this.getString(n));
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        int n = 0;
        while (n < this.fields.length) {
            if (this.fields[n].name.equalsIgnoreCase(string)) {
                return n + 1;
            }
            ++n;
        }
        throw new PSQLException("postgresql.res.colname", (Object)string);
    }
}

