/*
 * Decompiled with CFR 0.152.
 */
package postgresql.jdbc1;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Vector;
import postgresql.Driver;
import postgresql.jdbc1.Connection;
import postgresql.jdbc1.Statement;
import postgresql.largeobject.LargeObject;
import postgresql.largeobject.LargeObjectManager;
import postgresql.util.PGobject;
import postgresql.util.PSQLException;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    String sql;
    String[] templateStrings;
    String[] inStrings;
    Connection connection;

    public PreparedStatement(Connection connection, String string) throws SQLException {
        super(connection);
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        int n = 0;
        this.sql = string;
        this.connection = connection;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '\'') {
                boolean bl2 = bl = !bl;
            }
            if (c == '?' && !bl) {
                vector.addElement(string.substring(n, n2));
                n = n2 + 1;
            }
            ++n2;
        }
        vector.addElement(string.substring(n, string.length()));
        this.templateStrings = new String[vector.size()];
        this.inStrings = new String[vector.size() - 1];
        this.clearParameters();
        n2 = 0;
        while (n2 < this.templateStrings.length) {
            this.templateStrings[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
    }

    public ResultSet executeQuery() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.inStrings.length) {
            if (this.inStrings[n] == null) {
                throw new PSQLException("postgresql.prep.param", new Integer(n + 1));
            }
            stringBuffer.append(this.templateStrings[n]);
            stringBuffer.append(this.inStrings[n]);
            ++n;
        }
        stringBuffer.append(this.templateStrings[this.inStrings.length]);
        return super.executeQuery(stringBuffer.toString());
    }

    public int executeUpdate() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.inStrings.length) {
            if (this.inStrings[n] == null) {
                throw new PSQLException("postgresql.prep.param", new Integer(n + 1));
            }
            stringBuffer.append(this.templateStrings[n]);
            stringBuffer.append(this.inStrings[n]);
            ++n;
        }
        stringBuffer.append(this.templateStrings[this.inStrings.length]);
        return super.executeUpdate(stringBuffer.toString());
    }

    public void setNull(int n, int n2) throws SQLException {
        this.set(n, "null");
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.set(n, bl ? "'t'" : "'f'");
    }

    public void setByte(int n, byte by) throws SQLException {
        this.set(n, new Integer(by).toString());
    }

    public void setShort(int n, short s) throws SQLException {
        this.set(n, new Integer(s).toString());
    }

    public void setInt(int n, int n2) throws SQLException {
        this.set(n, new Integer(n2).toString());
    }

    public void setLong(int n, long l) throws SQLException {
        this.set(n, new Long(l).toString());
    }

    public void setFloat(int n, float f) throws SQLException {
        this.set(n, new Float(f).toString());
    }

    public void setDouble(int n, double d) throws SQLException {
        this.set(n, new Double(d).toString());
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.set(n, bigDecimal.toString());
    }

    public void setString(int n, String string) throws SQLException {
        if (string == null) {
            this.set(n, "null");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\'');
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '\\' || c == '\'') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n2;
        }
        stringBuffer.append('\'');
        this.set(n, stringBuffer.toString());
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        LargeObjectManager largeObjectManager = this.connection.getLargeObjectAPI();
        int n2 = largeObjectManager.create();
        LargeObject largeObject = largeObjectManager.open(n2);
        largeObject.write(byArray);
        largeObject.close();
        this.setInt(n, n2);
    }

    public void setDate(int n, Date date) throws SQLException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("''yyyy-MM-dd''");
        this.set(n, simpleDateFormat.format(date));
    }

    public void setTime(int n, Time time) throws SQLException {
        this.set(n, "'" + time.toString() + "'");
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.set(n, "'" + timestamp.toString() + "'");
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStream(n, inputStream, n2);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStream(n, inputStream, n2);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw Driver.notImplemented();
    }

    public void clearParameters() throws SQLException {
        int n = 0;
        while (n < this.inStrings.length) {
            this.inStrings[n] = null;
            ++n;
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        switch (n2) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (object instanceof Boolean) {
                    this.set(n, (Boolean)object != false ? "1" : "0");
                    return;
                }
                this.set(n, object.toString());
                return;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(n, object.toString());
                return;
            }
            case 91: {
                this.setDate(n, (Date)object);
                return;
            }
            case 92: {
                this.setTime(n, (Time)object);
                return;
            }
            case 93: {
                this.setTimestamp(n, (Timestamp)object);
                return;
            }
            case 1111: {
                this.setString(n, ((PGobject)object).getValue());
                return;
            }
        }
        throw new PSQLException("postgresql.prep.type");
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    public void setObject(int n, Object object) throws SQLException {
        if (object instanceof String) {
            this.setString(n, (String)object);
            return;
        }
        if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
            return;
        }
        if (object instanceof Short) {
            this.setShort(n, (Short)object);
            return;
        }
        if (object instanceof Integer) {
            this.setInt(n, (Integer)object);
            return;
        }
        if (object instanceof Long) {
            this.setLong(n, (Long)object);
            return;
        }
        if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
            return;
        }
        if (object instanceof Double) {
            this.setDouble(n, (Double)object);
            return;
        }
        if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
            return;
        }
        if (object instanceof Date) {
            this.setDate(n, (Date)object);
            return;
        }
        if (object instanceof Time) {
            this.setTime(n, (Time)object);
            return;
        }
        if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
            return;
        }
        if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
            return;
        }
        if (object instanceof PGobject) {
            this.setString(n, ((PGobject)object).getValue());
            return;
        }
        this.setLong(n, this.connection.putObject(object));
    }

    public boolean execute() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.inStrings.length) {
            if (this.inStrings[n] == null) {
                throw new PSQLException("postgresql.prep.param", new Integer(n + 1));
            }
            stringBuffer.append(this.templateStrings[n]);
            stringBuffer.append(this.inStrings[n]);
            ++n;
        }
        stringBuffer.append(this.templateStrings[this.inStrings.length]);
        return super.execute(stringBuffer.toString());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.inStrings.length) {
            if (this.inStrings[n] == null) {
                stringBuffer.append('?');
            } else {
                stringBuffer.append(this.templateStrings[n]);
            }
            stringBuffer.append(this.inStrings[n]);
            ++n;
        }
        stringBuffer.append(this.templateStrings[this.inStrings.length]);
        return stringBuffer.toString();
    }

    private void set(int n, String string) throws SQLException {
        if (n < 1 || n > this.inStrings.length) {
            throw new PSQLException("postgresql.prep.range");
        }
        this.inStrings[n - 1] = string;
    }
}

