/*
 * Decompiled with CFR 0.152.
 */
package postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import postgresql.geometric.PGpoint;
import postgresql.util.PGobject;
import postgresql.util.PGtokenizer;
import postgresql.util.PSQLException;

public class PGcircle
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint center;
    double radius;

    public PGcircle(double d, double d2, double d3) {
        this(new PGpoint(d, d2), d3);
    }

    public PGcircle(PGpoint pGpoint, double d) {
        this();
        this.center = pGpoint;
        this.radius = d;
    }

    public PGcircle(String string) throws SQLException {
        this();
        this.setValue(string);
    }

    public PGcircle() {
        this.setType("circle");
    }

    public void setValue(String string) throws SQLException {
        PGtokenizer pGtokenizer = new PGtokenizer(PGtokenizer.removeAngle(string), ',');
        if (pGtokenizer.getSize() != 2) {
            throw new PSQLException("postgresql.geo.circle", (Object)string);
        }
        try {
            this.center = new PGpoint(pGtokenizer.getToken(0));
            this.radius = Double.valueOf(pGtokenizer.getToken(1));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSQLException("postgresql.geo.circle", (Object)numberFormatException);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof PGcircle) {
            PGcircle pGcircle = (PGcircle)object;
            return pGcircle.center.equals(this.center) && pGcircle.radius == this.radius;
        }
        return false;
    }

    public Object clone() {
        return new PGcircle((PGpoint)this.center.clone(), this.radius);
    }

    public String getValue() {
        return "<" + this.center + "," + this.radius + ">";
    }
}

