/*
 * Decompiled with CFR 0.152.
 */
package postgresql;

import java.io.IOException;
import java.net.ConnectException;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import postgresql.Driver;
import postgresql.Field;
import postgresql.PG_Stream;
import postgresql.fastpath.Fastpath;
import postgresql.largeobject.LargeObjectManager;
import postgresql.util.PGobject;
import postgresql.util.PSQLException;
import postgresql.util.Serialize;
import postgresql.util.UnixCrypt;

public abstract class Connection {
    public PG_Stream pg_stream;
    public int maxrows;
    private String PG_HOST;
    private int PG_PORT;
    private String PG_USER;
    private String PG_PASSWORD;
    private String PG_DATABASE;
    private boolean PG_STATUS;
    public boolean CONNECTION_OK = true;
    public boolean CONNECTION_BAD = false;
    public boolean autoCommit = true;
    public boolean readOnly = false;
    public Driver this_driver;
    private String this_url;
    private String cursor;
    protected static final int PG_PROTOCOL_LATEST_MAJOR = 1;
    protected static final int PG_PROTOCOL_LATEST_MINOR = 0;
    private static final int SM_DATABASE = 64;
    private static final int SM_USER = 32;
    private static final int SM_OPTIONS = 64;
    private static final int SM_UNUSED = 64;
    private static final int SM_TTY = 64;
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private String salt;
    public Hashtable fieldCache = new Hashtable();
    public SQLWarning firstWarning;
    private Fastpath fastpath;
    private LargeObjectManager largeobject;
    private Hashtable objectTypes = new Hashtable();
    private static final String[][] defaultObjectTypes = new String[][]{{"box", "postgresql.geometric.PGbox"}, {"circle", "postgresql.geometric.PGcircle"}, {"line", "postgresql.geometric.PGline"}, {"lseg", "postgresql.geometric.PGlseg"}, {"path", "postgresql.geometric.PGpath"}, {"point", "postgresql.geometric.PGpoint"}, {"polygon", "postgresql.geometric.PGpolygon"}, {"money", "postgresql.util.PGmoney"}};

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void openConnection(String var1_1, int var2_2, Properties var3_3, String var4_4, String var5_5, Driver var6_6) throws SQLException {
        if (var3_3.getProperty("user") == null) {
            throw new PSQLException("postgresql.con.user");
        }
        if (var3_3.getProperty("password") == null) {
            throw new PSQLException("postgresql.con.pass");
        }
        this.this_driver = var6_6;
        this.this_url = new String(var5_5);
        this.PG_DATABASE = new String(var4_4);
        this.PG_PASSWORD = new String(var3_3.getProperty("password"));
        this.PG_USER = new String(var3_3.getProperty("user"));
        this.PG_PORT = var2_2;
        this.PG_HOST = new String(var1_1);
        this.PG_STATUS = this.CONNECTION_BAD;
        try {
            this.pg_stream = new PG_Stream(var1_1, var2_2);
        }
        catch (ConnectException v0) {
            throw new PSQLException("postgresql.con.refused");
        }
        catch (IOException var7_7) {
            throw new PSQLException("postgresql.con.failed", (Object)var7_7);
        }
        try {
            this.pg_stream.SendInteger(296, 4);
            this.pg_stream.SendInteger(1, 2);
            this.pg_stream.SendInteger(0, 2);
            this.pg_stream.Send(var4_4.getBytes(), 64);
            this.pg_stream.Send(this.PG_USER.getBytes(), 224);
            this.pg_stream.flush();
            var7_8 = -1;
            block16: while (true) lbl-1000:
            // 3 sources

            {
                var8_10 = this.pg_stream.ReceiveChar();
                switch (var8_10) {
                    case 69: {
                        throw new SQLException(this.pg_stream.ReceiveString(4096));
                    }
                    case 82: {
                        var7_8 = this.pg_stream.ReceiveIntegerR(4);
                        if (var7_8 == 4) {
                            var9_11 /* !! */  = new byte[]{(byte)this.pg_stream.ReceiveChar(), (byte)this.pg_stream.ReceiveChar()};
                            this.salt = new String(var9_11 /* !! */ , 0, 2);
                            DriverManager.println("Salt=" + this.salt);
                        }
                        switch (var7_8) {
                            case 1: {
                                DriverManager.println("postgresql: KRB4");
                                throw new PSQLException("postgresql.con.kerb4");
                            }
                            case 2: {
                                DriverManager.println("postgresql: KRB5");
                                throw new PSQLException("postgresql.con.kerb5");
                            }
                            case 3: {
                                DriverManager.println("postgresql: PASSWORD");
                                this.pg_stream.SendInteger(5 + this.PG_PASSWORD.length(), 4);
                                this.pg_stream.Send(this.PG_PASSWORD.getBytes());
                                this.pg_stream.SendInteger(0, 1);
                                this.pg_stream.flush();
                                ** break;
                            }
                            case 4: {
                                DriverManager.println("postgresql: CRYPT");
                                var9_11 /* !! */  = (byte[])UnixCrypt.crypt(this.salt, this.PG_PASSWORD);
                                this.pg_stream.SendInteger(5 + var9_11 /* !! */ .length(), 4);
                                this.pg_stream.Send(var9_11 /* !! */ .getBytes());
                                this.pg_stream.SendInteger(0, 1);
                                this.pg_stream.flush();
                                ** break;
                            }
                            default: {
                                throw new PSQLException("postgresql.con.auth", new Integer(var7_8));
                            }
                            case 0: {
                                if (var7_8 != 0) continue block16;
                            }
                        }
                    }
                    default: {
                        throw new PSQLException("postgresql.con.authfail");
                    }
                }
lbl67:
                // 2 sources

                if (var7_8 != 0) ** GOTO lbl-1000
                break;
            }
        }
        catch (IOException var7_9) {
            throw new PSQLException("postgresql.con.failed", (Object)var7_9);
        }
        this.firstWarning = null;
        this.ExecSQL("set datestyle to 'ISO'");
        this.initObjectTypes();
        this.firstWarning = null;
        this.PG_STATUS = this.CONNECTION_OK;
    }

    public void addWarning(String string) {
        DriverManager.println(string);
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(new SQLWarning(string));
            return;
        }
        this.firstWarning = new SQLWarning(string);
    }

    /*
     * Unable to fully structure code
     */
    public ResultSet ExecSQL(String var1_1) throws SQLException {
        var3_2 = this.pg_stream;
        synchronized (var3_2) {
            var5_3 = null;
            var6_4 = new Vector<byte[][]>();
            var7_5 = new byte[var1_1.length()];
            var8_6 = 0;
            var9_7 = false;
            var10_8 = null;
            var12_9 = 1;
            var13_10 = null;
            if (var1_1.length() > 8192) {
                throw new PSQLException("postgresql.con.toolong", (Object)var1_1);
            }
            try {
                this.pg_stream.SendChar(81);
                var7_5 = var1_1.getBytes();
                this.pg_stream.Send(var7_5);
                this.pg_stream.SendChar(0);
                this.pg_stream.flush();
                if (true) ** GOTO lbl95
            }
            catch (IOException var14_11) {
                throw new PSQLException("postgresql.con.ioerror", (Object)var14_11);
            }
            block20: do {
                var14_12 = null;
                var15_14 = this.pg_stream.ReceiveChar();
                switch (var15_14) {
                    case 65: {
                        this.pg_stream.ReceiveInteger(4);
                        var11_13 = this.pg_stream.ReceiveString(8192);
                        break;
                    }
                    case 66: {
                        if (var5_3 == null) {
                            throw new PSQLException("postgresql.con.tuple");
                        }
                        var14_12 = this.pg_stream.ReceiveTuple(var5_3.length, true);
                        if (this.maxrows != 0 && var6_4.size() >= this.maxrows) continue block20;
                        var6_4.addElement(var14_12);
                        break;
                    }
                    case 67: {
                        var10_8 = this.pg_stream.ReceiveString(8192);
                        if (var10_8.startsWith("INSERT") || var10_8.startsWith("UPDATE")) {
                            try {
                                var12_9 = Integer.parseInt(var10_8.substring(1 + var10_8.lastIndexOf(32)));
                            }
                            catch (NumberFormatException v0) {
                                throw new PSQLException("postgresql.con.fathom", (Object)var10_8);
                            }
                        }
                        if (var5_3 != null) {
                            var9_7 = true;
                            break;
                        }
                        try {
                            this.pg_stream.SendChar(81);
                            this.pg_stream.SendChar(32);
                            this.pg_stream.SendChar(0);
                            this.pg_stream.flush();
                        }
                        catch (IOException var16_16) {
                            throw new PSQLException("postgresql.con.ioerror", (Object)var16_16);
                        }
                        ++var8_6;
                        break;
                    }
                    case 68: {
                        if (var5_3 == null) {
                            throw new PSQLException("postgresql.con.tuple");
                        }
                        var14_12 = this.pg_stream.ReceiveTuple(var5_3.length, false);
                        if (this.maxrows != 0 && var6_4.size() >= this.maxrows) continue block20;
                        var6_4.addElement(var14_12);
                        break;
                    }
                    case 69: {
                        var11_13 = this.pg_stream.ReceiveString(4096);
                        var13_10 = new SQLException(var11_13);
                        var9_7 = true;
                        break;
                    }
                    case 73: {
                        var16_15 = this.pg_stream.ReceiveChar();
                        if (var16_15 != 0) {
                            throw new PSQLException("postgresql.con.garbled");
                        }
                        if (var8_6 > 0) {
                            --var8_6;
                        }
                        if (var8_6 != 0) continue block20;
                        var9_7 = true;
                        break;
                    }
                    case 78: {
                        this.addWarning(this.pg_stream.ReceiveString(4096));
                        break;
                    }
                    case 80: {
                        this.pg_stream.ReceiveString(8192);
                        break;
                    }
                    case 84: {
                        if (var5_3 != null) {
                            throw new PSQLException("postgresql.con.multres");
                        }
                        var5_3 = this.ReceiveFields();
                        break;
                    }
                    default: {
                        throw new PSQLException("postgresql.con.type", new Character((char)var15_14));
                    }
                }
lbl95:
                // 14 sources

            } while (!var9_7 || var8_6 > 0);
            if (var13_10 != null) {
                throw var13_10;
            }
            var2_17 = this.getResultSet(this, var5_3, var6_4, var10_8, var12_9);
            var4_18 = null;
            return var2_17;
        }
    }

    private Field[] ReceiveFields() throws SQLException {
        int n = this.pg_stream.ReceiveIntegerR(2);
        Field[] fieldArray = new Field[n];
        int n2 = 0;
        while (n2 < n) {
            String string = this.pg_stream.ReceiveString(8192);
            int n3 = this.pg_stream.ReceiveIntegerR(4);
            int n4 = this.pg_stream.ReceiveIntegerR(2);
            fieldArray[n2] = new Field(this, string, n3, n4);
            ++n2;
        }
        return fieldArray;
    }

    public void setCursorName(String string) throws SQLException {
        this.cursor = string;
    }

    public String getCursorName() throws SQLException {
        return this.cursor;
    }

    public String getURL() throws SQLException {
        return this.this_url;
    }

    public String getUserName() throws SQLException {
        return this.PG_USER;
    }

    public Fastpath getFastpathAPI() throws SQLException {
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this, this.pg_stream);
        }
        return this.fastpath;
    }

    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        if (this.largeobject == null) {
            this.largeobject = new LargeObjectManager(this);
        }
        return this.largeobject;
    }

    public Object getObject(String string, String string2) throws SQLException {
        try {
            Object v = this.objectTypes.get(string);
            if (v == null) {
                Serialize serialize = new Serialize(this, string);
                this.objectTypes.put(string, serialize);
                return serialize.fetch(Integer.parseInt(string2));
            }
            if (v instanceof String) {
                PGobject pGobject = null;
                pGobject = (PGobject)Class.forName((String)v).newInstance();
                pGobject.setType(string);
                pGobject.setValue(string2);
                return pGobject;
            }
            if (v instanceof Serialize) {
                return ((Serialize)v).fetch(Integer.parseInt(string2));
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (Exception exception) {
            throw new PSQLException("postgresql.con.creobj", (Object)string, (Object)exception);
        }
        return null;
    }

    public int putObject(Object object) throws SQLException {
        try {
            String string = object.getClass().getName();
            Object v = this.objectTypes.get(string);
            if (v == null) {
                Serialize serialize = new Serialize(this, string);
                this.objectTypes.put(string, serialize);
                return serialize.store(object);
            }
            if (v instanceof Serialize) {
                return ((Serialize)v).store(object);
            }
            throw new PSQLException("postgresql.con.strobj");
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (Exception exception) {
            throw new PSQLException("postgresql.con.strobjex", (Object)exception);
        }
    }

    public void addDataType(String string, String string2) {
        this.objectTypes.put(string, string2);
    }

    private void initObjectTypes() {
        int n = 0;
        while (n < defaultObjectTypes.length) {
            this.objectTypes.put(defaultObjectTypes[n][0], defaultObjectTypes[n][1]);
            ++n;
        }
    }

    public abstract Statement createStatement() throws SQLException;

    protected abstract ResultSet getResultSet(Connection var1, Field[] var2, Vector var3, String var4, int var5) throws SQLException;
}

