// $ANTLR 2.7.3 (20040901-1): "Scigol.tree.g" -> "ScigolTreeParser.java"$

  package scigol;
  
  import java.util.*;
  import java.lang.annotation.*;

import antlr.TreeParser;
import antlr.Token;
import antlr.collections.AST;
import antlr.RecognitionException;
import antlr.ANTLRException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.collections.impl.BitSet;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;

  //  


public class ScigolTreeParser extends antlr.TreeParser       implements ScigolTreeParserTokenTypes
 {

  public ScigolTreeParser(Scope initialScope, boolean interactive)
  {
    super();
    this.interactive = interactive;
    globalScope = initialScope.getGlobalScope();
    scope = initialScope;
  }
 
 

  public static void semanticError(String msg) 
  {
    throw new ScigolException(msg);
  }
  
  public static void semanticError(String msg, Exception inner)
  {
    throw new ScigolException(msg, inner);
  }
 

 public static void semanticError(Location l, String msg) 
 {
   if ((l != null) && (l.isKnown()))
    throw new ScigolException("["+l+"] "+msg);
   else
     throw new ScigolException(msg);
 }
 
 
 public static Location locationOf(AST near)
 {
    if (near instanceof CommonASTWithLocation) 
      return ((CommonASTWithLocation)near).loc;
    else
      return new Location();
 }
 
 
 public static void semanticError(AST near, String msg) 
  {
    String loc = "";
    if (near instanceof CommonASTWithLocation) {
      CommonASTWithLocation locAST = (CommonASTWithLocation)near;
      if (locAST.loc.isKnown())
        loc += "["+locAST.loc.toString()+"] ";
    }
    throw new ScigolException(loc+msg);
  }
 
 
  public Scope globalScope;
  public boolean  interactive; // are we being run interactively?
  public Scope scope; // current scope 

public ScigolTreeParser() {
	tokenNames = _tokenNames;
}

	public final Value  program(AST _t) throws RecognitionException {
		Value v=null;
		
		AST program_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case DOT:
		case DOTDOT:
		case UNARY_MINUS:
		case UNARY_PLUS:
		case EXPRLIST:
		case MATRIX:
		case LIST:
		case MAP:
		case FUNC:
		case POST_INC:
		case POST_DEC:
		case APPLICATION:
		case LIT_TRUE:
		case LIT_FALSE:
		case LIT_NULL:
		case LIT_FUNC:
		case BUILTIN_TYPE:
		case LITERAL_namespace:
		case IDENT:
		case STRING_LITERAL:
		case LITERAL_typeof:
		case LITERAL_logger:
		case ASSIGN:
		case LITERAL_or:
		case LITERAL_and:
		case NOT_EQUAL:
		case EQUAL:
		case LITERAL_is:
		case LITERAL_isnt:
		case LTHAN:
		case GTHAN:
		case LTE:
		case GTE:
		case PLUS:
		case MINUS:
		case STAR:
		case DIV:
		case MOD:
		case HAT:
		case INC:
		case DEC:
		case LNOT:
		case LITERAL_not:
		case HASH:
		case PRIME:
		case BAR:
		case SCOPE_ESCAPE:
		case LITERAL_try:
		case NUM_INT:
		case NUM_DINT:
		case NUM_REAL:
		case NUM_SREAL:
		case CHAR_LITERAL:
		case LITERAL_let:
		case LITERAL_class:
		case LITERAL_interface:
		case LITERAL_if:
		case LITERAL_do:
		case LITERAL_while:
		case LITERAL_for:
		case LITERAL_foreach:
		case LITERAL_throw:
		{
			v=expr(_t);
			_t = _retTree;
			break;
		}
		case LCURLY:
		{
			v=namespaceBody(_t);
			_t = _retTree;
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
		return v;
	}
	
	public final Value  expr(AST _t) throws RecognitionException {
		Value v=null;
		
		AST expr_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case EXPRLIST:
		{
			v=expressionList(_t,true);
			_t = _retTree;
			break;
		}
		case LIST:
		{
			v=listLiteral(_t);
			_t = _retTree;
			break;
		}
		case MAP:
		{
			v=mapLiteral(_t);
			_t = _retTree;
			break;
		}
		case LITERAL_namespace:
		{
			v=namespaceScope(_t);
			_t = _retTree;
			break;
		}
		case MATRIX:
		case FUNC:
		case LIT_TRUE:
		case LIT_FALSE:
		case LIT_NULL:
		case LIT_FUNC:
		case BUILTIN_TYPE:
		case STRING_LITERAL:
		case NUM_INT:
		case NUM_DINT:
		case NUM_REAL:
		case NUM_SREAL:
		case CHAR_LITERAL:
		case LITERAL_class:
		case LITERAL_interface:
		{
			v=literal(_t);
			_t = _retTree;
			break;
		}
		case DOTDOT:
		case UNARY_MINUS:
		case UNARY_PLUS:
		case POST_INC:
		case POST_DEC:
		case LITERAL_or:
		case LITERAL_and:
		case NOT_EQUAL:
		case EQUAL:
		case LITERAL_is:
		case LITERAL_isnt:
		case LTHAN:
		case GTHAN:
		case LTE:
		case GTE:
		case PLUS:
		case MINUS:
		case STAR:
		case DIV:
		case MOD:
		case HAT:
		case INC:
		case DEC:
		case LNOT:
		case LITERAL_not:
		case HASH:
		case PRIME:
		case BAR:
		{
			v=arithmeticExpression(_t);
			_t = _retTree;
			break;
		}
		case LITERAL_logger:
		{
			v=logCall(_t);
			_t = _retTree;
			break;
		}
		case LITERAL_let:
		{
			v=declaration(_t);
			_t = _retTree;
			break;
		}
		case ASSIGN:
		{
			v=assignmentExpression(_t);
			_t = _retTree;
			break;
		}
		case LITERAL_typeof:
		{
			v=typeofExpression(_t);
			_t = _retTree;
			break;
		}
		case IDENT:
		case SCOPE_ESCAPE:
		{
			v=symbol(_t);
			_t = _retTree;
			break;
		}
		case APPLICATION:
		{
			v=applicationExpression(_t);
			_t = _retTree;
			break;
		}
		case DOT:
		{
			v=selectionExpression(_t);
			_t = _retTree;
			break;
		}
		case LITERAL_if:
		{
			v=ifExpression(_t);
			_t = _retTree;
			break;
		}
		case LITERAL_do:
		case LITERAL_while:
		{
			v=whileExpression(_t);
			_t = _retTree;
			break;
		}
		case LITERAL_for:
		{
			v=forExpression(_t);
			_t = _retTree;
			break;
		}
		case LITERAL_foreach:
		{
			v=forEachExpression(_t);
			_t = _retTree;
			break;
		}
		case LITERAL_try:
		{
			v=exceptionBlock(_t);
			_t = _retTree;
			break;
		}
		case LITERAL_throw:
		{
			v=throwExpression(_t);
			_t = _retTree;
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
		return v;
	}
	
	public final Value  namespaceBody(AST _t) throws RecognitionException {
		Value v=null;
		
		AST namespaceBody_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		AST tmp1_AST_in = (AST)_t;
		match(_t,LCURLY);
		_t = _t.getNextSibling();
		{
		_loop45:
		do {
			if (_t==null) _t=ASTNULL;
			if ((_t.getType()==LITERAL_using)) {
				usingDecl(_t);
				_t = _retTree;
			}
			else {
				break _loop45;
			}
			
		} while (true);
		}
		{
		_loop47:
		do {
			if (_t==null) _t=ASTNULL;
			if ((_tokenSet_0.member(_t.getType()))) {
				v=expr(_t);
				_t = _retTree;
			}
			else {
				break _loop47;
			}
			
		} while (true);
		}
		_retTree = _t;
		return v;
	}
	
	public final Value  expressionList(AST _t,
		boolean inNewScope
	) throws RecognitionException {
		Value v=null;
		
		AST expressionList_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST el = null;
		Value a = null;
		
		AST __t35 = _t;
		el = _t==ASTNULL ? null :(AST)_t;
		match(_t,EXPRLIST);
		_t = _t.getFirstChild();
		
		if (inNewScope) { 
		scope = new LocalScope(scope);
		scope.setDefinitionLocation( locationOf(el) );
		}
		
		{
		_loop37:
		do {
			if (_t==null) _t=ASTNULL;
			if ((_tokenSet_0.member(_t.getType()))) {
				a=expr(_t);
				_t = _retTree;
				if (a!=null) v=a;
			}
			else {
				break _loop37;
			}
			
		} while (true);
		}
		
		if (inNewScope) scope = scope.getOuter(); // exit scope 
		
		_t = __t35;
		_t = _t.getNextSibling();
		_retTree = _t;
		return v;
	}
	
	public final Value  listLiteral(AST _t) throws RecognitionException {
		Value v=null;
		
		AST listLiteral_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		List l = new List();
		
		AST __t4 = _t;
		AST tmp2_AST_in = (AST)_t;
		match(_t,LIST);
		_t = _t.getFirstChild();
		{
		_loop6:
		do {
			if (_t==null) _t=ASTNULL;
			if ((_tokenSet_0.member(_t.getType()))) {
				v=expr(_t);
				_t = _retTree;
				l.add(v.getValue());
			}
			else {
				break _loop6;
			}
			
		} while (true);
		}
		_t = __t4;
		_t = _t.getNextSibling();
		v = new Value(l);
		_retTree = _t;
		return v;
	}
	
	public final Value  mapLiteral(AST _t) throws RecognitionException {
		Value v=null;
		
		AST mapLiteral_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		Map m = new Map(); Value key=null; Value val=null;
		
		AST __t8 = _t;
		AST tmp3_AST_in = (AST)_t;
		match(_t,MAP);
		_t = _t.getFirstChild();
		{
		_loop10:
		do {
			if (_t==null) _t=ASTNULL;
			if ((_tokenSet_0.member(_t.getType()))) {
				key=expr(_t);
				_t = _retTree;
				AST tmp4_AST_in = (AST)_t;
				match(_t,GIVES);
				_t = _t.getNextSibling();
				val=expr(_t);
				_t = _retTree;
				m.set_Item(key.getValue(), new Any(val.getValue()));
			}
			else {
				break _loop10;
			}
			
		} while (true);
		}
		_t = __t8;
		_t = _t.getNextSibling();
		v = new Value(m);
		_retTree = _t;
		return v;
	}
	
	public final Value  namespaceScope(AST _t) throws RecognitionException {
		Value v=null;
		
		AST namespaceScope_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST ns = null;
		String id; Scope savedOuterScope;
		
		AST __t42 = _t;
		ns = _t==ASTNULL ? null :(AST)_t;
		match(_t,LITERAL_namespace);
		_t = _t.getFirstChild();
		id=namespaceName(_t);
		_t = _retTree;
		
		if (!scope.isNamespaceScope())
		ScigolTreeParser.semanticError(locationOf(ns),"can't define namespace '"+id+
		"' within current scope (namespaces can only be nested directly within other namespaces)");
		
		savedOuterScope = scope;
		scope = NamespaceScope.newOrExistingNamespaceScope(id, scope);
		scope.setDefinitionLocation( locationOf(ns) );
		
		v=namespaceBody(_t);
		_t = _retTree;
		
		scope = savedOuterScope; // exit back to enclosing scope
		
		_t = __t42;
		_t = _t.getNextSibling();
		_retTree = _t;
		return v;
	}
	
	public final Value  literal(AST _t) throws RecognitionException {
		Value v=null;
		
		AST literal_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		TypeSpec t; Func f;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case MATRIX:
		case LIT_TRUE:
		case LIT_FALSE:
		case LIT_NULL:
		case NUM_INT:
		case NUM_DINT:
		case NUM_REAL:
		case NUM_SREAL:
		{
			v=number(_t);
			_t = _retTree;
			break;
		}
		case STRING_LITERAL:
		{
			v=stringLit(_t);
			_t = _retTree;
			break;
		}
		case CHAR_LITERAL:
		{
			v=charLit(_t);
			_t = _retTree;
			break;
		}
		case FUNC:
		case BUILTIN_TYPE:
		case LITERAL_class:
		case LITERAL_interface:
		{
			t=typeLiteral(_t);
			_t = _retTree;
			v = new Value(t);
			break;
		}
		case LIT_FUNC:
		{
			f=functionLiteral(_t);
			_t = _retTree;
			v = new Value(f);
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
		return v;
	}
	
	public final Value  arithmeticExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST arithmeticExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		Value lhs = null,rhs;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case PLUS:
		{
			AST __t53 = _t;
			AST tmp5_AST_in = (AST)_t;
			match(_t,PLUS);
			_t = _t.getFirstChild();
			lhs=expr(_t);
			_t = _retTree;
			rhs=expr(_t);
			_t = _retTree;
			_t = __t53;
			_t = _t.getNextSibling();
			v = Math.performOverloadedOperation("operator+", lhs, rhs);
			break;
		}
		case MINUS:
		{
			AST __t54 = _t;
			AST tmp6_AST_in = (AST)_t;
			match(_t,MINUS);
			_t = _t.getFirstChild();
			lhs=expr(_t);
			_t = _retTree;
			rhs=expr(_t);
			_t = _retTree;
			_t = __t54;
			_t = _t.getNextSibling();
			v = Math.performOverloadedOperation("operator-", lhs, rhs);
			break;
		}
		case UNARY_PLUS:
		{
			AST __t55 = _t;
			AST tmp7_AST_in = (AST)_t;
			match(_t,UNARY_PLUS);
			_t = _t.getFirstChild();
			rhs=expr(_t);
			_t = _retTree;
			_t = __t55;
			_t = _t.getNextSibling();
			v = Math.performOverloadedOperation("operator+", null, rhs);
			break;
		}
		case UNARY_MINUS:
		{
			AST __t56 = _t;
			AST tmp8_AST_in = (AST)_t;
			match(_t,UNARY_MINUS);
			_t = _t.getFirstChild();
			rhs=expr(_t);
			_t = _retTree;
			_t = __t56;
			_t = _t.getNextSibling();
			v = Math.performOverloadedOperation("operator-", null, rhs);
			break;
		}
		case STAR:
		{
			AST __t57 = _t;
			AST tmp9_AST_in = (AST)_t;
			match(_t,STAR);
			_t = _t.getFirstChild();
			lhs=expr(_t);
			_t = _retTree;
			rhs=expr(_t);
			_t = _retTree;
			_t = __t57;
			_t = _t.getNextSibling();
			v = Math.performOverloadedOperation("operator*", lhs, rhs);
			break;
		}
		case DIV:
		{
			AST __t58 = _t;
			AST tmp10_AST_in = (AST)_t;
			match(_t,DIV);
			_t = _t.getFirstChild();
			lhs=expr(_t);
			_t = _retTree;
			rhs=expr(_t);
			_t = _retTree;
			_t = __t58;
			_t = _t.getNextSibling();
			v = Math.performOverloadedOperation("operator/", lhs, rhs);
			break;
		}
		case MOD:
		{
			AST __t59 = _t;
			AST tmp11_AST_in = (AST)_t;
			match(_t,MOD);
			_t = _t.getFirstChild();
			lhs=expr(_t);
			_t = _retTree;
			rhs=expr(_t);
			_t = _retTree;
			_t = __t59;
			_t = _t.getNextSibling();
			v = Math.performOverloadedOperation("operator%", lhs, rhs);
			break;
		}
		case HAT:
		{
			AST __t60 = _t;
			AST tmp12_AST_in = (AST)_t;
			match(_t,HAT);
			_t = _t.getFirstChild();
			lhs=expr(_t);
			_t = _retTree;
			rhs=expr(_t);
			_t = _retTree;
			_t = __t60;
			_t = _t.getNextSibling();
			v = Math.performOverloadedOperation("operator^", lhs, rhs);
			break;
		}
		case EQUAL:
		{
			AST __t61 = _t;
			AST tmp13_AST_in = (AST)_t;
			match(_t,EQUAL);
			_t = _t.getFirstChild();
			lhs=expr(_t);
			_t = _retTree;
			rhs=expr(_t);
			_t = _retTree;
			_t = __t61;
			_t = _t.getNextSibling();
			v = Math.performOverloadedOperation("operator==", lhs, rhs);
			break;
		}
		case NOT_EQUAL:
		{
			AST __t62 = _t;
			AST tmp14_AST_in = (AST)_t;
			match(_t,NOT_EQUAL);
			_t = _t.getFirstChild();
			lhs=expr(_t);
			_t = _retTree;
			rhs=expr(_t);
			_t = _retTree;
			_t = __t62;
			_t = _t.getNextSibling();
			v = Math.performOverloadedOperation("operator!=", lhs, rhs);
			break;
		}
		case LTHAN:
		{
			AST __t63 = _t;
			AST tmp15_AST_in = (AST)_t;
			match(_t,LTHAN);
			_t = _t.getFirstChild();
			lhs=expr(_t);
			_t = _retTree;
			rhs=expr(_t);
			_t = _retTree;
			_t = __t63;
			_t = _t.getNextSibling();
			v = Math.performOverloadedOperation("operator<", lhs, rhs);
			break;
		}
		case GTHAN:
		{
			AST __t64 = _t;
			AST tmp16_AST_in = (AST)_t;
			match(_t,GTHAN);
			_t = _t.getFirstChild();
			lhs=expr(_t);
			_t = _retTree;
			rhs=expr(_t);
			_t = _retTree;
			_t = __t64;
			_t = _t.getNextSibling();
			v = Math.performOverloadedOperation("operator>", lhs, rhs);
			break;
		}
		case LTE:
		{
			AST __t65 = _t;
			AST tmp17_AST_in = (AST)_t;
			match(_t,LTE);
			_t = _t.getFirstChild();
			lhs=expr(_t);
			_t = _retTree;
			rhs=expr(_t);
			_t = _retTree;
			_t = __t65;
			_t = _t.getNextSibling();
			v = Math.performOverloadedOperation("operator<=", lhs, rhs);
			break;
		}
		case GTE:
		{
			AST __t66 = _t;
			AST tmp18_AST_in = (AST)_t;
			match(_t,GTE);
			_t = _t.getFirstChild();
			lhs=expr(_t);
			_t = _retTree;
			rhs=expr(_t);
			_t = _retTree;
			_t = __t66;
			_t = _t.getNextSibling();
			v = Math.performOverloadedOperation("operator>=", lhs, rhs);
			break;
		}
		case INC:
		case DEC:
		{
			v=prefixExpression(_t);
			_t = _retTree;
			break;
		}
		case POST_INC:
		case POST_DEC:
		case PRIME:
		{
			v=postfixExpression(_t);
			_t = _retTree;
			break;
		}
		case LITERAL_and:
		{
			v=logicalAndExpression(_t);
			_t = _retTree;
			break;
		}
		case LITERAL_or:
		{
			v=logicalOrExpression(_t);
			_t = _retTree;
			break;
		}
		case LNOT:
		case LITERAL_not:
		{
			v=logicalNotExpression(_t);
			_t = _retTree;
			break;
		}
		case LITERAL_is:
		case LITERAL_isnt:
		{
			v=isExpression(_t);
			_t = _retTree;
			break;
		}
		case DOTDOT:
		{
			v=rangeExpression(_t);
			_t = _retTree;
			break;
		}
		case BAR:
		{
			v=normExpression(_t);
			_t = _retTree;
			break;
		}
		case HASH:
		{
			v=cardinalityExpression(_t);
			_t = _retTree;
			
			Debug.Assert(v != null, "Value is null"); 
			
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
		return v;
	}
	
	public final Value  logCall(AST _t) throws RecognitionException {
		Value v=null;
		
		AST logCall_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST i = null;
		
		AST __t183 = _t;
		AST tmp19_AST_in = (AST)_t;
		match(_t,LITERAL_logger);
		_t = _t.getFirstChild();
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case COMMA:
		{
			AST __t185 = _t;
			AST tmp20_AST_in = (AST)_t;
			match(_t,COMMA);
			_t = _t.getFirstChild();
			i = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			_t = __t185;
			_t = _t.getNextSibling();
			break;
		}
		case DOT:
		case DOTDOT:
		case UNARY_MINUS:
		case UNARY_PLUS:
		case EXPRLIST:
		case MATRIX:
		case LIST:
		case MAP:
		case FUNC:
		case POST_INC:
		case POST_DEC:
		case APPLICATION:
		case LIT_TRUE:
		case LIT_FALSE:
		case LIT_NULL:
		case LIT_FUNC:
		case BUILTIN_TYPE:
		case LITERAL_namespace:
		case IDENT:
		case STRING_LITERAL:
		case LITERAL_typeof:
		case LITERAL_logger:
		case ASSIGN:
		case LITERAL_or:
		case LITERAL_and:
		case NOT_EQUAL:
		case EQUAL:
		case LITERAL_is:
		case LITERAL_isnt:
		case LTHAN:
		case GTHAN:
		case LTE:
		case GTE:
		case PLUS:
		case MINUS:
		case STAR:
		case DIV:
		case MOD:
		case HAT:
		case INC:
		case DEC:
		case LNOT:
		case LITERAL_not:
		case HASH:
		case PRIME:
		case BAR:
		case SCOPE_ESCAPE:
		case LITERAL_try:
		case NUM_INT:
		case NUM_DINT:
		case NUM_REAL:
		case NUM_SREAL:
		case CHAR_LITERAL:
		case LITERAL_let:
		case LITERAL_class:
		case LITERAL_interface:
		case LITERAL_if:
		case LITERAL_do:
		case LITERAL_while:
		case LITERAL_for:
		case LITERAL_foreach:
		case LITERAL_throw:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		v=expr(_t);
		_t = _retTree;
		_t = __t183;
		_t = _t.getNextSibling();
		
		if(i!=null) System.out.print(i.getText()+": ");
		System.out.println(v.toString()); 
		
		_retTree = _t;
		return v;
	}
	
	public final Value  declaration(AST _t) throws RecognitionException {
		Value v=null;
		
		AST declaration_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST i = null;
		AST tt = null;
		AST at = null;
		TypeSpec t = null; 
		Value e=null;
		Annotation annot=null; 
		LinkedList<Annotation> annotations = new LinkedList<Annotation>();
		EnumSet<TypeSpec.Modifier> modifiers = EnumSet.of(TypeSpec.Modifier.Public);
		
		
		AST __t124 = _t;
		AST tmp21_AST_in = (AST)_t;
		match(_t,LITERAL_let);
		_t = _t.getFirstChild();
		{
		_loop126:
		do {
			if (_t==null) _t=ASTNULL;
			if ((_t.getType()==ANNOT_START)) {
				annot=annotation(_t);
				_t = _retTree;
				annotations.add(annot);
			}
			else {
				break _loop126;
			}
			
		} while (true);
		}
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case MODIFIERS:
		{
			modifiers=classModifiers(_t);
			_t = _retTree;
			break;
		}
		case IDENT:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		i = (AST)_t;
		match(_t,IDENT);
		_t = _t.getNextSibling();
		scope.pushDeclarationIdent(i.getText());
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case COLON:
		{
			tt = (AST)_t;
			match(_t,COLON);
			_t = _t.getNextSibling();
			t=typeExpression(_t);
			_t = _retTree;
			break;
		}
		case 3:
		case ASSIGN:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case ASSIGN:
		{
			at = (AST)_t;
			match(_t,ASSIGN);
			_t = _t.getNextSibling();
			e=expr(_t);
			_t = _retTree;
			break;
		}
		case 3:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		_t = __t124;
		_t = _t.getNextSibling();
		
		//!!! do something with the modifiers
		
		scope.popDeclarationIdent();
		
		String id = i.getText();
		
		boolean typeSupplied = (t!=null);
		boolean initializerSupplied = (e!=null);
		
		if (!typeSupplied) { 
		if (!initializerSupplied) {
		// no initializer or type supplied
		ScigolTreeParser.semanticError("must supply either a type or an initializer in let declaration of identifier '"+id+"'");
		//e = new Value(new Any()); // null
		//t = new TypeSpec(e.GetType()); //huh?
		}
		else {
		// deduce type from type of initializer
		t = e.getType();
		}
		}
		else { // type supplied
		if (!initializerSupplied) {
		// construct default
		FuncInfo callSig = new FuncInfo();
		callSig.setDefinitionLocation( locationOf(i) );
		e = t.constructValue(callSig, null, this);
		
		//...!!! if is a class, call empty constructor
		
		if (e == null)
		ScigolTreeParser.semanticError(tt,"type "+t.typeName()+" doesn't have an accessible no-argument constructor");
		}
		else {
		// check that the type of the initializer is equals to (or convertable to)
		//  the specified type
		
		TypeSpec etype = e.getType();
		if (!TypeManager.existsImplicitConversion(etype, t, e))
		ScigolTreeParser.semanticError(at,"cannot declare variable '"+id+"' of type '"+t+"' with an incompatible initializer of type '"+etype.typeName()+"'");
		
		// convert e to type t
		e = TypeManager.performImplicitConversion(etype, t, e);
		
		}
		}
		
		
		//!!! make this check appropriately for duplicate ident (considering allowable overloading, etc.)      
		
		// check if id is already defined in the current scope (ignore enclosing scopes)
		if (!t.isFunc() && scope.contains(id))
		ScigolTreeParser.semanticError(i,"variable "+id+" already declared in this scope");
		
		scope.addEntry(id, t, e.getValue(), null, modifiers).addAnnotations(annotations);
		
		// return an LValue for the declared symbol rather than just the initializer rvalue
		v = new Value(new LValue(new Symbol(scope,id,null)));
		
		_retTree = _t;
		return v;
	}
	
	public final Value  assignmentExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST assignmentExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST a = null;
		Value lhs=null, rhs=null;
		
		AST __t30 = _t;
		a = _t==ASTNULL ? null :(AST)_t;
		match(_t,ASSIGN);
		_t = _t.getFirstChild();
		lhs=expr(_t);
		_t = _retTree;
		rhs=expr(_t);
		_t = _retTree;
		_t = __t30;
		_t = _t.getNextSibling();
		
		if (lhs.isLValue()) {
		//        Debug.WriteLine("assigning:"+lhs.getLValue());
		//        Debug.WriteLine("  to value:"+rhs);
		
		// check type & convert if necessary
		LValue l = lhs.getLValue();
		TypeSpec tlhs = l.getType(); 
		TypeSpec trhs = TypeSpec.typeOf(rhs);
		if (TypeManager.existsImplicitConversion(trhs, tlhs, rhs)) 
		lhs.setValue( TypeManager.performImplicitConversion(trhs, tlhs, rhs).getValue() );
		else
		ScigolTreeParser.semanticError(a,"incompatible right-hand-side (RHS) in assignment, value of type '"+trhs+"' is incompatible with LHS type '"+tlhs+"'");
		
		v = lhs;
		}
		else { // not assignable
		if (lhs.isNamespaceComponent()) {
		
		if (interactive) {
		// If we're in interactive mode, we allow undefined identifiers to be assigned to.
		// In this case, we declare the symbol as type 'any' or type 'num' depending on the
		//  type of the initializer
		String name = lhs.getNamespaceComponentString();
		int dotIndex = name.indexOf('.');
		if (dotIndex == -1) { // only auto declare simple names (not compound names like a.b)
		TypeSpec trhs = TypeSpec.typeOf(rhs.getValue()); 
		TypeSpec tlhs = new TypeSpec(TypeSpec.anyType);// default to 'any'
		
		if (trhs.isANum()) {
		tlhs = new TypeSpec(TypeSpec.numType);
		if (!(rhs.getValue() instanceof Num))
		rhs = new Value(new Num(rhs.getValue())); // wrap rhs in Num
		}
		else
		rhs = new Value(new Any(rhs.getValue())); // wrap rhs in Any
		
		scope.addEntry(name, tlhs, rhs.getValue(), null, EnumSet.of(TypeSpec.Modifier.Public));
		v = new Value(new LValue(new Symbol(scope, name, null)));
		}
		else
		ScigolTreeParser.semanticError(a,"unknown name '"+lhs.getNamespaceComponentString()+"' on left-hand-side (LHS) of assignment expression");
		}
		else
		ScigolTreeParser.semanticError(a,"unknown name '"+lhs.getNamespaceComponentString()+"' on left-hand-side (LHS) of assignment expression");
		}
		else
		ScigolTreeParser.semanticError(a,"left-hand-side (LHS) of assignment expression is not assignable (not an lvalue)");
		}
		
		_retTree = _t;
		return v;
	}
	
	public final Value  typeofExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST typeofExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		Value e=null;
		
		AST __t32 = _t;
		AST tmp22_AST_in = (AST)_t;
		match(_t,LITERAL_typeof);
		_t = _t.getFirstChild();
		e=expr(_t);
		_t = _retTree;
		_t = __t32;
		_t = _t.getNextSibling();
		
		if (e==null)
		v = new Value(TypeSpec.anyTypeSpec);
		else {
		if (!TypeSpec.typeOf(e).isType()) {
		// as a special case, if the value is null & it's an LValue, use the symbol's type
		boolean isNull = (e.getValue() == null) || ((e.getValue() instanceof Any) && (((Any)e.getValue()).value == null));
		if (e.isLValue() && isNull) {
		v = new Value( e.getLValue().getSymbol().getType() );
		}
		else {
		if (e.getValue() instanceof Any) // extract from Any
		e = new Value(((Any)e.getValue()).value);
		}
		
		if (v==null) // still no type
		v = new Value(TypeSpec.typeOf(e)); // deduce type from value
		}
		else // is a type, so it's type is type (!)
		v = new Value(TypeSpec.typeTypeSpec);
		}
		
		_retTree = _t;
		return v;
	}
	
	public final Value  symbol(AST _t) throws RecognitionException {
		Value v=null;
		
		AST symbol_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		int esc=0;
		
		{
		_loop28:
		do {
			if (_t==null) _t=ASTNULL;
			if ((_t.getType()==SCOPE_ESCAPE)) {
				AST tmp23_AST_in = (AST)_t;
				match(_t,SCOPE_ESCAPE);
				_t = _t.getNextSibling();
				esc++;
			}
			else {
				break _loop28;
			}
			
		} while (true);
		}
		id = (AST)_t;
		match(_t,IDENT);
		_t = _t.getNextSibling();
		
		String ident = id.getText();
		Scope searchScope = scope;
		int numEscs = esc;
		while (esc-- > 0) if (searchScope.getOuter() != null) searchScope =  searchScope.getOuter();
		//Debug.WriteLine("#esc="+ numEscs+" id="+ident);
		//Debug.WriteLine("current scope:\n"+scope);
		//Debug.WriteLine("current scope.outer=\n"+scope.outer);
		//Debug.WriteLine("search scope:\n"+searchScope);
		// get instance if applicable
		Symbol thiss = new Symbol(scope, "this", null);
		Object instance = thiss.exists()?thiss.getValue():null;
		
		Symbol s = new Symbol(searchScope, ident, instance);
		s.setDefinitionLocation( locationOf(id) );
		
		// check is this is a symbol that refers to a class instance member and complain if
		//  no instance is available (can only do this sucessfully here for non-ambiguous symbols)
		if ((instance == null) && s.exists() && (!s.isAmbiguous())) {
		Entry entry = s.getEntry();
		if (entry.isClassMember() && !entry.isStatic()) {
		TypeSpec declaringClass = ((ClassScope)entry.scope).getClassType();
		ScigolTreeParser.semanticError(id,"the instance member named '"+ident+"' of class '"+declaringClass+"' cannot be accessed without an instance object");
		}
		}
		
		//if (s.exists()) {
		//  Debug.WriteLine("got symbol "+ident);
		//  Debug.WriteLine(" in scope:"+s.scope);
		//  Debug.WriteLine("  having type "+s.type);
		//}
		if (!s.exists()) { // still haven't found anything
		
		if (numEscs == 0) {
		
		// perhaps this is a global fully-qualified name (i.e. with namespace)
		//  then create a special 'Value' with the component which will be used
		//  via selection '.' to build the full name and then the top level
		//  namespace can be checked
		v = new Value(ident);
		v.setValueIsNamespaceComponent(locationOf(id));
		}
		else
		ScigolTreeParser.semanticError(id,"undefined identifier '"+ident+"' in the specified scope:\n"+searchScope);
		}
		else
		v = new Value(new LValue(s));
		
		_retTree = _t;
		return v;
	}
	
	public final Value  applicationExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST applicationExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST app = null;
		
		Value f;
		ArrayList args=null;
		
		
		AST __t14 = _t;
		app = _t==ASTNULL ? null :(AST)_t;
		match(_t,APPLICATION);
		_t = _t.getFirstChild();
		f=expr(_t);
		_t = _retTree;
		args=applicationArgs(_t);
		_t = _retTree;
		_t = __t14;
		_t = _t.getNextSibling();
		
		FuncInfo callSig = new FuncInfo(args);
		callSig.setDefinitionLocation( locationOf(app) );
		
		// first, if we have an lvalue that refers to an overloaded symbol, we need
		//  to resolve it to a single method based on the call signature
		boolean isFunc = false;
		Func func = null;
		
		// if f is either an rvalue, or an lvalue that isn't ambiguous
		if (!f.isLValue() || (f.isLValue() && !f.getLValue().getSymbol().isAmbiguous())) {
		
		// property?
		boolean isProperty = false;
		if (f.isLValue()) {
		Symbol s = f.getLValue().getSymbol();
		isProperty = s.getEntry().isProperty();
		}
		
		if (isProperty) {
		isFunc = false;
		}
		else {
		Object fo = f.getValue();
		if (fo != null) {
		isFunc = f.getType().isFunc();
		if (isFunc)
		func = (Func)fo;
		}
		else
		isFunc = true; // null is a no-op function that returns null, by definition
		}
		}
		else { // overloaded lvalue
		
		//!!! this doesn't work if the lhs if an overloaded lvalue that is a bound property.
		// it is assuming a func, but we can't know that.        
		
		Symbol s = f.getLValue().getSymbol();
		//Debug.WriteLine("application of overloaded lvalue");
		s.disambiguate(callSig, args);
		// now we can go ahead and retrieve the func value
		isFunc = true;
		Object fo = f.getValue();
		if (fo != null)
		func = (Func)fo;
		}
		
		
		if (isFunc) { // function call
		
		if (func==null) {
		//Debug.WriteLine("applicationExpression: call no-op");  
		v = null; // a null Func is a no-op
		}
		else { // call it
		
		Object[] convertedArgs = func.getInfo().convertParameters(callSig, args, func.isExternal());
		//Debug.WriteLine("applicationExpression: call "+func.toStringArgs(convertedArgs));
		
		// retrieve instance
		Object instance = null;
		if (f.isLValue())
		instance = f.getLValue().getSymbol().getInstance();
		
		v = new Value(func.call(instance, convertedArgs));   
		
		}
		
		}
		else if (f.getType().isType()) {  // construction or explicit conversion? (looks like call of a type)
		TypeSpec t = (TypeSpec)f.getValue();
		
		//Debug.WriteLine("constructing a "+t);
		
		// if there is a single argument, treat it like an explicit conversion (which will also
		//  call any compatible single argument constructors of t)
		v=null;
		if (callSig.numArgs() == 1) 
		v = TypeManager.performExplicitConversion(callSig.getParamTypes()[0],t,new Value(args.get(0)));
		
		if (v == null) // conversion failed, try other constructors matched via callSig
		v = new Value(t.constructValue(callSig,args,this));
		
		Debug.Assert(v!=null, "construction/conversion failed");
		}
		else { // assume property access
		
		Symbol s = f.getLValue().getSymbol();
		
		boolean isProperty = s.getEntry().isProperty();
		
		if (isProperty) {
		// we have an LValue that refers to a property member
		//  turn it into an property LValue with bound property arguments
		//!!! if the property is already arg bound, evaluate it and treat this as another application!
		if (f.getLValue().isBoundProperty())
		Debug.Unimplemented("property already bound");
		v = new Value(new LValue(f.getLValue().getSymbol(),callSig,FuncInfo.toArray(args)));
		}
		else {
		// perhaps we have a class, which has an operator() property (an indexer)?
		TypeSpec ftype = f.getType();
		boolean isClass = false;
		if (ftype.isClass() || ftype.isBuiltinClass()) 
		isClass = true;
		else if (ftype.isAny() || ftype.isNum()) {
		f = TypeSpec.unwrapAnyOrNumValue(f);
		ftype = f.getType();
		isClass = (ftype.isClass() || ftype.isBuiltinClass());
		}
		
		if (isClass) {
		
		// create an LValue for operator() (if it exists), bound with the arguments
		Scope classScope = new ClassScope(ftype); // create scope for class
		Symbol pSymbol = new Symbol(classScope, "operator()", f.getValue());
		
		if (!pSymbol.exists())
		ScigolTreeParser.semanticError(locationOf(app),"object of type '"+ftype+"' has no indexer ('operator()' property) defined, hence cannot be called (with call signature "+callSig+")");
		
		v = new Value(new LValue(pSymbol,callSig,FuncInfo.toArray(args)));
		}
		else
		ScigolTreeParser.semanticError(locationOf(app),"cannot call an object of type '"+f.getType()+"'.  To be `called` it must be either a type (construction), a func (call), or an object with an 'operator()' property (indexing).");
		}
		}
		
		
		_retTree = _t;
		return v;
	}
	
	public final Value  selectionExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST selectionExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		
		Value f;
		
		
		AST __t12 = _t;
		AST tmp24_AST_in = (AST)_t;
		match(_t,DOT);
		_t = _t.getFirstChild();
		f=expr(_t);
		_t = _retTree;
		id = (AST)_t;
		match(_t,IDENT);
		_t = _t.getNextSibling();
		_t = __t12;
		_t = _t.getNextSibling();
		
		String name = id.getText();
		
		String fid = "";
		// if there is any information regarding the identity of f, capture it to use
		//  as extra information in error messages
		if (f.isLValue()) fid = "'"+f.getLValue().getSymbol().getName()+"' ";
		
		if (f.isNamespaceComponent()) {
		// handle 'selection' of partially or fully qualified name
		//  if still partial, keep as a potential namespace component that can continue
		//  to have selection applied, or if fully qualified type name, retrieve the type
		
		// see if we have a complete qually-qualified name yet
		String component = f.getNamespaceComponentString();
		
		NamespaceScope nsScope = scope.getGlobalScope().getNamespaceScope(component);
		if ((nsScope != null) && nsScope.contains(name)) { // yes, we found something
		Symbol s = new Symbol(nsScope, name, null);
		LValue lv = new LValue(s);
		v = new Value(lv);
		}
		else { // nope, keep as potential qualified name component
		String qualifiedName = component+"."+name;
		
		//!!! temporary way to access external Java type, if there is a type matching
		// the full name loaded, use it
		java.lang.reflect.Type javaType = NamespaceScope.loadedLibrariesGetType(qualifiedName);
		TypeSpec gt = (javaType != null)?new TypeSpec(javaType):null;
		
		if (gt != null) { // yes, found a type
		v = new Value(gt);
		}
		else {
		v = new Value(qualifiedName);
		v.setValueIsNamespaceComponent(locationOf(id));
		}
		}
		}
		else {
		TypeSpec t = TypeSpec.typeOf(f.getValue());
		if (t.isAny()) {
		f = new Value(((Any)f.getValue()).value); // unwrap Any
		t = TypeSpec.typeOf(f.getValue());
		}
		
		if (t.isClass() || t.isBuiltinClass()) {
		// try to select a member
		//Debug.WL("selecting member "+name+" from type "+f.getType());  //!!!        
		Scope classScope = new ClassScope(t); // create scope for existing class
		Symbol s = new Symbol(classScope, name, f.getValue());
		
		if (!s.exists())
		ScigolTreeParser.semanticError(id,"object "+fid+"of type '"+t+"' has no member named '"+name+"'");
		
		v = new Value(new LValue(s));
		}
		else if (t.isType()) {
		// try to select static field of class type
		
		TypeSpec typeExpr = (TypeSpec)f.getValue();
		if (!typeExpr.isClass()) 
		ScigolTreeParser.semanticError(id,"cannot select a member of object "+fid+"of non-class type '"+t+"'");
		
		Scope classScope = new ClassScope(typeExpr);
		Symbol s = new Symbol(classScope, name, null);
		
		if (!s.exists())
		ScigolTreeParser.semanticError(id,"object "+fid+"of type '"+typeExpr+"' has no member named '"+name+"'");
		
		v = new Value(new LValue(s));
		}
		else
		ScigolTreeParser.semanticError(id,"cannot select member '"+name+"' from object "+fid+"of type '"+t+"'");
		}
		
		_retTree = _t;
		return v;
	}
	
	public final Value  ifExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST ifExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST ift = null;
		Value test = null;
		
		AST __t103 = _t;
		ift = _t==ASTNULL ? null :(AST)_t;
		match(_t,LITERAL_if);
		_t = _t.getFirstChild();
		test=expr(_t);
		_t = _retTree;
		_t = __t103;
		_t = _t.getNextSibling();
		
		TypeSpec t = TypeSpec.typeOf(test);
		if (!TypeManager.existsImplicitConversion(t,TypeSpec.boolTypeSpec,test))
		ScigolTreeParser.semanticError(ift,"'if' test expression must be of type 'bool'");
		boolean btest = ((Boolean)TypeManager.performImplicitConversion(t, TypeSpec.boolTypeSpec, test).getValue()).booleanValue();
		AST ifAST = ifExpression_AST_in;
		AST thenAST = ifAST.getFirstChild().getNextSibling(); // skip over test
		AST elseAST = thenAST.getNextSibling();
		
		// conditionally walk either the then or else tree
		if (btest)
		v = expr(thenAST);
		else {
		if (elseAST != null)
		v = expr(elseAST);
		}
		
		_retTree = _t;
		return v;
	}
	
	public final Value  whileExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST whileExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST w = null;
		AST d = null;
		Value test = null;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case LITERAL_while:
		{
			AST __t105 = _t;
			w = _t==ASTNULL ? null :(AST)_t;
			match(_t,LITERAL_while);
			_t = _t.getFirstChild();
			test=expr(_t);
			_t = _retTree;
			_t = __t105;
			_t = _t.getNextSibling();
			
			AST whileAST = whileExpression_AST_in;
			AST testAST = whileAST.getFirstChild();
			AST bodyAST = whileAST.getFirstChild().getNextSibling(); // skip over test
			
			TypeSpec t = TypeSpec.typeOf(test);
			if (!TypeManager.existsImplicitConversion(t,TypeSpec.boolTypeSpec,test))
			ScigolTreeParser.semanticError(w,"'while' test expression must be of type 'bool'");
			boolean btest = ((Boolean)TypeManager.performImplicitConversion(t, TypeSpec.boolTypeSpec, test).getValue()).booleanValue();
			
			// keep executing the body tree while the test is true
			while (btest) {
			v = expr(bodyAST);
			
			// re-evaluate test
			test = expr(testAST); // execute test
			t = TypeSpec.typeOf(test);
			if (!TypeManager.existsImplicitConversion(t,TypeSpec.boolTypeSpec, test))
			ScigolTreeParser.semanticError(w,"'while' test expression must be of type 'bool'");
			btest = ((Boolean)TypeManager.performImplicitConversion(t, TypeSpec.boolTypeSpec, test).getValue()).booleanValue();
			}
			
			break;
		}
		case LITERAL_do:
		{
			AST __t106 = _t;
			d = _t==ASTNULL ? null :(AST)_t;
			match(_t,LITERAL_do);
			_t = _t.getFirstChild();
			v=expr(_t);
			_t = _retTree;
			test=expr(_t);
			_t = _retTree;
			_t = __t106;
			_t = _t.getNextSibling();
			
			AST whileAST = whileExpression_AST_in;
			AST bodyAST = whileAST.getFirstChild();
			AST testAST = whileAST.getFirstChild().getNextSibling(); // skip over body
			
			TypeSpec t = TypeSpec.typeOf(test);
			if (!TypeManager.existsImplicitConversion(t,TypeSpec.boolTypeSpec,test))
			ScigolTreeParser.semanticError(d,"'do...while' test expression must be of type 'bool'");
			boolean btest = ((Boolean)TypeManager.performImplicitConversion(t, TypeSpec.boolTypeSpec, test).getValue()).booleanValue();
			
			// body & test have already been executed once automatically, now
			//  re-execute them again so long as test is true
			if (btest)
			do {
			v = expr(bodyAST);
			
			// re-evaluate test
			test = expr(testAST); // execute test
			t = TypeSpec.typeOf(test);
			if (!TypeManager.existsImplicitConversion(t,TypeSpec.boolTypeSpec,test))
			ScigolTreeParser.semanticError(d,"'do...while' test expression must be of type 'bool'");
			btest = ((Boolean)TypeManager.performImplicitConversion(t, TypeSpec.boolTypeSpec, test).getValue()).booleanValue();
			
			} while (btest);
			
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
		return v;
	}
	
	public final Value  forExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST forExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		Value first = null; Value test = null; Value third=null;
		
		AST __t108 = _t;
		AST tmp25_AST_in = (AST)_t;
		match(_t,LITERAL_for);
		_t = _t.getFirstChild();
		first=expr(_t);
		_t = _retTree;
		test=expr(_t);
		_t = _retTree;
		third=expr(_t);
		_t = _retTree;
		_t = __t108;
		_t = _t.getNextSibling();
		
		Debug.Unimplemented();
		
		_retTree = _t;
		return v;
	}
	
	public final Value  forEachExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST forEachExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST i = null;
		
		Value t=null; 
		Value from=null; Value to=null; Value by=null;
		Value container=null;
		
		
		AST __t110 = _t;
		AST tmp26_AST_in = (AST)_t;
		match(_t,LITERAL_foreach);
		_t = _t.getFirstChild();
		i = (AST)_t;
		match(_t,IDENT);
		_t = _t.getNextSibling();
		t=expr(_t);
		_t = _retTree;
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case COLON:
		{
			AST __t112 = _t;
			AST tmp27_AST_in = (AST)_t;
			match(_t,COLON);
			_t = _t.getFirstChild();
			from=expr(_t);
			_t = _retTree;
			to=expr(_t);
			_t = _retTree;
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case DOT:
			case DOTDOT:
			case UNARY_MINUS:
			case UNARY_PLUS:
			case EXPRLIST:
			case MATRIX:
			case LIST:
			case MAP:
			case FUNC:
			case POST_INC:
			case POST_DEC:
			case APPLICATION:
			case LIT_TRUE:
			case LIT_FALSE:
			case LIT_NULL:
			case LIT_FUNC:
			case BUILTIN_TYPE:
			case LITERAL_namespace:
			case IDENT:
			case STRING_LITERAL:
			case LITERAL_typeof:
			case LITERAL_logger:
			case ASSIGN:
			case LITERAL_or:
			case LITERAL_and:
			case NOT_EQUAL:
			case EQUAL:
			case LITERAL_is:
			case LITERAL_isnt:
			case LTHAN:
			case GTHAN:
			case LTE:
			case GTE:
			case PLUS:
			case MINUS:
			case STAR:
			case DIV:
			case MOD:
			case HAT:
			case INC:
			case DEC:
			case LNOT:
			case LITERAL_not:
			case HASH:
			case PRIME:
			case BAR:
			case SCOPE_ESCAPE:
			case LITERAL_try:
			case NUM_INT:
			case NUM_DINT:
			case NUM_REAL:
			case NUM_SREAL:
			case CHAR_LITERAL:
			case LITERAL_let:
			case LITERAL_class:
			case LITERAL_interface:
			case LITERAL_if:
			case LITERAL_do:
			case LITERAL_while:
			case LITERAL_for:
			case LITERAL_foreach:
			case LITERAL_throw:
			{
				by=expr(_t);
				_t = _retTree;
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			_t = __t112;
			_t = _t.getNextSibling();
			break;
		}
		case DOT:
		case DOTDOT:
		case UNARY_MINUS:
		case UNARY_PLUS:
		case EXPRLIST:
		case MATRIX:
		case LIST:
		case MAP:
		case FUNC:
		case POST_INC:
		case POST_DEC:
		case APPLICATION:
		case LIT_TRUE:
		case LIT_FALSE:
		case LIT_NULL:
		case LIT_FUNC:
		case BUILTIN_TYPE:
		case LITERAL_namespace:
		case IDENT:
		case STRING_LITERAL:
		case LITERAL_typeof:
		case LITERAL_logger:
		case ASSIGN:
		case LITERAL_or:
		case LITERAL_and:
		case NOT_EQUAL:
		case EQUAL:
		case LITERAL_is:
		case LITERAL_isnt:
		case LTHAN:
		case GTHAN:
		case LTE:
		case GTE:
		case PLUS:
		case MINUS:
		case STAR:
		case DIV:
		case MOD:
		case HAT:
		case INC:
		case DEC:
		case LNOT:
		case LITERAL_not:
		case HASH:
		case PRIME:
		case BAR:
		case SCOPE_ESCAPE:
		case LITERAL_try:
		case NUM_INT:
		case NUM_DINT:
		case NUM_REAL:
		case NUM_SREAL:
		case CHAR_LITERAL:
		case LITERAL_let:
		case LITERAL_class:
		case LITERAL_interface:
		case LITERAL_if:
		case LITERAL_do:
		case LITERAL_while:
		case LITERAL_for:
		case LITERAL_foreach:
		case LITERAL_throw:
		{
			container=expr(_t);
			_t = _retTree;
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		_t = __t110;
		_t = _t.getNextSibling();
		
		Debug.Unimplemented();
		
		_retTree = _t;
		return v;
	}
	
	public final Value  exceptionBlock(AST _t) throws RecognitionException {
		Value v=null;
		
		AST exceptionBlock_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		Value a=null;
		
		AST tmp28_AST_in = (AST)_t;
		match(_t,LITERAL_try);
		_t = _t.getNextSibling();
		
		AST blockAST = exceptionBlock_AST_in;
		AST tryBlockAST = blockAST.getFirstChild().getFirstChild();
		AST ast = blockAST.getFirstChild().getNextSibling();
		
		
		Debug.WriteLine("blockAST=\n"+blockAST.toStringTree());
		Debug.WriteLine("\nast=\n"+ast.toStringTree());
		//...
		
		_retTree = _t;
		return v;
	}
	
	public final Value  throwExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST throwExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST th = null;
		Value e=null;
		
		AST __t116 = _t;
		th = _t==ASTNULL ? null :(AST)_t;
		match(_t,LITERAL_throw);
		_t = _t.getFirstChild();
		e=expr(_t);
		_t = _retTree;
		_t = __t116;
		_t = _t.getNextSibling();
		
		Object o = e.getValue();
		if (o instanceof Any) o = ((Any)o).value;
		if (!(o instanceof Exception))
		ScigolTreeParser.semanticError(th,"only exceptions can be thrown (not objects of type '"+TypeSpec.typeOf(e)+"')");
		
		// throw it
		Debug.Unimplemented();     
		//throw ((Exception)o);
		
		_retTree = _t;
		return v;
	}
	
	public final ArrayList  applicationArgs(AST _t) throws RecognitionException {
		ArrayList args=new ArrayList();
		
		AST applicationArgs_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST c = null;
		Value e; boolean sawNamedArg = false;
		
		AST __t16 = _t;
		AST tmp29_AST_in = (AST)_t;
		match(_t,LPAREN);
		_t = _t.getFirstChild();
		e=null;
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case DOT:
		case DOTDOT:
		case UNARY_MINUS:
		case UNARY_PLUS:
		case EXPRLIST:
		case MATRIX:
		case LIST:
		case MAP:
		case FUNC:
		case POST_INC:
		case POST_DEC:
		case APPLICATION:
		case LIT_TRUE:
		case LIT_FALSE:
		case LIT_NULL:
		case LIT_FUNC:
		case BUILTIN_TYPE:
		case LITERAL_namespace:
		case IDENT:
		case STRING_LITERAL:
		case LITERAL_typeof:
		case LITERAL_logger:
		case ASSIGN:
		case LITERAL_or:
		case LITERAL_and:
		case NOT_EQUAL:
		case EQUAL:
		case LITERAL_is:
		case LITERAL_isnt:
		case LTHAN:
		case GTHAN:
		case LTE:
		case GTE:
		case PLUS:
		case MINUS:
		case STAR:
		case DIV:
		case MOD:
		case HAT:
		case INC:
		case DEC:
		case LNOT:
		case LITERAL_not:
		case HASH:
		case PRIME:
		case BAR:
		case SCOPE_ESCAPE:
		case LITERAL_try:
		case NUM_INT:
		case NUM_DINT:
		case NUM_REAL:
		case NUM_SREAL:
		case CHAR_LITERAL:
		case LITERAL_let:
		case LITERAL_class:
		case LITERAL_interface:
		case LITERAL_if:
		case LITERAL_do:
		case LITERAL_while:
		case LITERAL_for:
		case LITERAL_foreach:
		case LITERAL_throw:
		{
			e=expr(_t);
			_t = _retTree;
			break;
		}
		case NAMED_ARG:
		{
			e=namedArg(_t);
			_t = _retTree;
			sawNamedArg=true;
			break;
		}
		case 3:
		case COMMA:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		if (e!=null) args.add(e); else args.add(FuncInfo.defaultArg);
		{
		_loop22:
		do {
			if (_t==null) _t=ASTNULL;
			if ((_t.getType()==COMMA)) {
				e=null;
				c = (AST)_t;
				match(_t,COMMA);
				_t = _t.getNextSibling();
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case NAMED_ARG:
				{
					{
					e=namedArg(_t);
					_t = _retTree;
					sawNamedArg=true;
					}
					break;
				}
				case DOT:
				case DOTDOT:
				case UNARY_MINUS:
				case UNARY_PLUS:
				case EXPRLIST:
				case MATRIX:
				case LIST:
				case MAP:
				case FUNC:
				case POST_INC:
				case POST_DEC:
				case APPLICATION:
				case LIT_TRUE:
				case LIT_FALSE:
				case LIT_NULL:
				case LIT_FUNC:
				case BUILTIN_TYPE:
				case LITERAL_namespace:
				case IDENT:
				case STRING_LITERAL:
				case LITERAL_typeof:
				case LITERAL_logger:
				case ASSIGN:
				case LITERAL_or:
				case LITERAL_and:
				case NOT_EQUAL:
				case EQUAL:
				case LITERAL_is:
				case LITERAL_isnt:
				case LTHAN:
				case GTHAN:
				case LTE:
				case GTE:
				case PLUS:
				case MINUS:
				case STAR:
				case DIV:
				case MOD:
				case HAT:
				case INC:
				case DEC:
				case LNOT:
				case LITERAL_not:
				case HASH:
				case PRIME:
				case BAR:
				case SCOPE_ESCAPE:
				case LITERAL_try:
				case NUM_INT:
				case NUM_DINT:
				case NUM_REAL:
				case NUM_SREAL:
				case CHAR_LITERAL:
				case LITERAL_let:
				case LITERAL_class:
				case LITERAL_interface:
				case LITERAL_if:
				case LITERAL_do:
				case LITERAL_while:
				case LITERAL_for:
				case LITERAL_foreach:
				case LITERAL_throw:
				{
					{
					e=expr(_t);
					_t = _retTree;
					
					if (sawNamedArg)
					ScigolTreeParser.semanticError(locationOf(c),"a positional argument cannot follow a named argument in an application");
					
					}
					break;
				}
				case 3:
				case COMMA:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				if (e!=null) args.add(e); else args.add(FuncInfo.defaultArg);
			}
			else {
				break _loop22;
			}
			
		} while (true);
		}
		_t = __t16;
		_t = _t.getNextSibling();
		
		if ((args.size()==1) && (args.get(0)==FuncInfo.defaultArg))
		args.clear();
		
		_retTree = _t;
		return args;
	}
	
	public final Value  namedArg(AST _t) throws RecognitionException {
		Value v=null;
		
		AST namedArg_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		FuncInfo.NamedArgument na; Value e;
		
		AST __t24 = _t;
		AST tmp30_AST_in = (AST)_t;
		match(_t,NAMED_ARG);
		_t = _t.getFirstChild();
		id = (AST)_t;
		match(_t,IDENT);
		_t = _t.getNextSibling();
		{
		e=expr(_t);
		_t = _retTree;
		}
		_t = __t24;
		_t = _t.getNextSibling();
		
		na = new FuncInfo.NamedArgument(id.getText(),e); 
		v = new Value(na);
		
		_retTree = _t;
		return v;
	}
	
	public final Value  number(AST _t) throws RecognitionException {
		Value v=null;
		
		AST number_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST i = null;
		AST d = null;
		AST r = null;
		AST s = null;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case NUM_INT:
		{
			i = (AST)_t;
			match(_t,NUM_INT);
			_t = _t.getNextSibling();
			v = new Value(new Integer(i.getText()));
			break;
		}
		case NUM_DINT:
		{
			d = (AST)_t;
			match(_t,NUM_DINT);
			_t = _t.getNextSibling();
			v = new Value(new Long(d.getText()));
			break;
		}
		case NUM_REAL:
		{
			r = (AST)_t;
			match(_t,NUM_REAL);
			_t = _t.getNextSibling();
			v = new Value(new Double(r.getText()));
			break;
		}
		case NUM_SREAL:
		{
			s = (AST)_t;
			match(_t,NUM_SREAL);
			_t = _t.getNextSibling();
			v = new Value(new Float(s.getText()));
			break;
		}
		case LIT_TRUE:
		{
			AST tmp31_AST_in = (AST)_t;
			match(_t,LIT_TRUE);
			_t = _t.getNextSibling();
			v = new Value(new Boolean(true));
			break;
		}
		case LIT_FALSE:
		{
			AST tmp32_AST_in = (AST)_t;
			match(_t,LIT_FALSE);
			_t = _t.getNextSibling();
			v = new Value(new Boolean(false));
			break;
		}
		case LIT_NULL:
		{
			AST tmp33_AST_in = (AST)_t;
			match(_t,LIT_NULL);
			_t = _t.getNextSibling();
			v = new Value(new Any(null));
			break;
		}
		case MATRIX:
		{
			v=matrixexpr(_t);
			_t = _retTree;
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
		return v;
	}
	
	public final Value  stringLit(AST _t) throws RecognitionException {
		Value v=null;
		
		AST stringLit_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST s = null;
		
		s = (AST)_t;
		match(_t,STRING_LITERAL);
		_t = _t.getNextSibling();
		
		String str = new String(s.getText()); 
		if (str.charAt(0) == '\"')
		str = str.substring(1,str.length()-1); // remove surrouding double quotes
		else
		str = str.substring(2,str.length()-2); // remove surrouding back quote paris quotes
		v = new Value(str); // String
		
		_retTree = _t;
		return v;
	}
	
	public final Value  charLit(AST _t) throws RecognitionException {
		Value v=null;
		
		AST charLit_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST c = null;
		
		c = (AST)_t;
		match(_t,CHAR_LITERAL);
		_t = _t.getNextSibling();
		
		String str = new String(c.getText()); 
		if (str.charAt(0) == '\"')
		str = str.substring(1,str.length()-2); // remove surrouding double quotes & suffix
		if (str.length() != 1)
		ScigolTreeParser.semanticError(locationOf(c),"character literals must contain a single character within the quotes");
		v = new Value(str.charAt(0)); // char
		
		_retTree = _t;
		return v;
	}
	
	public final TypeSpec  typeLiteral(AST _t) throws RecognitionException {
		TypeSpec t=null;
		
		AST typeLiteral_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST b = null;
		FuncInfo fi=null;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case BUILTIN_TYPE:
		{
			b = (AST)_t;
			match(_t,BUILTIN_TYPE);
			_t = _t.getNextSibling();
			
			t=new TypeSpec(b.getText());
			if (t==null)
			ScigolTreeParser.semanticError(b,"undefined type "+b.getText());
			
			break;
		}
		case FUNC:
		{
			fi=funcType(_t);
			_t = _retTree;
			t=new TypeSpec(fi);
			break;
		}
		case LITERAL_class:
		{
			t=classType(_t);
			_t = _retTree;
			break;
		}
		case LITERAL_interface:
		{
			t=interfaceType(_t);
			_t = _retTree;
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
		return t;
	}
	
	public final Func  functionLiteral(AST _t) throws RecognitionException {
		Func v=null;
		
		AST functionLiteral_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		FuncInfo sig;
		
		AST __t179 = _t;
		AST tmp34_AST_in = (AST)_t;
		match(_t,LIT_FUNC);
		_t = _t.getFirstChild();
		sig=funcSignature(_t);
		_t = _retTree;
		v=functionLiteralBody(_t,sig);
		_t = _retTree;
		_t = __t179;
		_t = _t.getNextSibling();
		_retTree = _t;
		return v;
	}
	
	public final String  namespaceName(AST _t) throws RecognitionException {
		String name="";
		
		AST namespaceName_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST i = null;
		AST i2 = null;
		
		i = (AST)_t;
		match(_t,IDENT);
		_t = _t.getNextSibling();
		name += i.getText();
		{
		_loop40:
		do {
			if (_t==null) _t=ASTNULL;
			if ((_t.getType()==DOT)) {
				AST tmp35_AST_in = (AST)_t;
				match(_t,DOT);
				_t = _t.getNextSibling();
				i2 = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				name += "."+i2.getText();
			}
			else {
				break _loop40;
			}
			
		} while (true);
		}
		_retTree = _t;
		return name;
	}
	
	public final void usingDecl(AST _t) throws RecognitionException {
		
		AST usingDecl_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST ul = null;
		AST aliasId = null;
		String id=null; Value source=null;
		
		AST __t49 = _t;
		ul = _t==ASTNULL ? null :(AST)_t;
		match(_t,LITERAL_using);
		_t = _t.getFirstChild();
		id=namespaceName(_t);
		_t = _retTree;
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case LITERAL_as:
		{
			AST tmp36_AST_in = (AST)_t;
			match(_t,LITERAL_as);
			_t = _t.getNextSibling();
			aliasId = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			break;
		}
		case 3:
		case LITERAL_from:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case LITERAL_from:
		{
			AST tmp37_AST_in = (AST)_t;
			match(_t,LITERAL_from);
			_t = _t.getNextSibling();
			source=stringLit(_t);
			_t = _retTree;
			break;
		}
		case 3:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		_t = __t49;
		_t = _t.getNextSibling();
		
		if (source != null) Debug.WriteLine("using ... from is not implemented!");
		Debug.Assert(scope.isNamespaceScope(), "using can only appear in namespace scope!");
		
		NamespaceScope nsscope = (NamespaceScope)scope;
		String alias = (aliasId!=null)?aliasId.getText():null;
		String aliased = null;
		String nsName = id;
		
		// if nsName isn't the name of a namespace, perhaps we have 'namespace.name' instead
		if (nsscope.getNamespaceScope(nsName) == null) {
		
		// remove the last . component to separate the namespace (if any) from the name
		int lastDot = id.lastIndexOf('.');
		if (lastDot != -1) {
		nsName = id.substring(0,lastDot);
		aliased = id.substring(lastDot+1);
		//Debug.WL("nsName="+nsName);
		//Debug.WL("aliased="+aliased);          
		}
		}
		
		if (alias==null) { // using namespace[.name]
		if (aliased == null) {
		nsscope.addUsingNamespace(nsName);
		//Debug.WriteLine("using namespace="+nsName);
		}
		else {
		nsscope.addUsingName(aliased, nsName);
		//Debug.WriteLine("using namespace="+nsName+" name="+aliased);
		}
		}
		else { // using alias
		if (aliased == null) {
		aliased = nsName;
		nsName = nsscope.fullNamespaceName();
		}
		
		nsscope.addUsingAlias(alias, aliased, nsName);
		//Debug.WriteLine("using alias="+alias+" aliased="+aliased+" namespace="+  nsName);
		}
		
		_retTree = _t;
	}
	
	public final Value  prefixExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST prefixExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		Value e=null; boolean dec=false;
		
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case INC:
		{
			AST __t88 = _t;
			AST tmp38_AST_in = (AST)_t;
			match(_t,INC);
			_t = _t.getFirstChild();
			e=expr(_t);
			_t = _retTree;
			_t = __t88;
			_t = _t.getNextSibling();
			break;
		}
		case DEC:
		{
			AST __t89 = _t;
			AST tmp39_AST_in = (AST)_t;
			match(_t,DEC);
			_t = _t.getFirstChild();
			e=expr(_t);
			_t = _retTree;
			dec=true;
			_t = __t89;
			_t = _t.getNextSibling();
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		
		Debug.Unimplemented("prefix");
		
		_retTree = _t;
		return v;
	}
	
	public final Value  postfixExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST postfixExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		Value e=null; boolean dec=false; boolean prime=false;
		
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case POST_INC:
		{
			AST __t92 = _t;
			AST tmp40_AST_in = (AST)_t;
			match(_t,POST_INC);
			_t = _t.getFirstChild();
			e=expr(_t);
			_t = _retTree;
			_t = __t92;
			_t = _t.getNextSibling();
			break;
		}
		case POST_DEC:
		{
			AST __t93 = _t;
			AST tmp41_AST_in = (AST)_t;
			match(_t,POST_DEC);
			_t = _t.getFirstChild();
			e=expr(_t);
			_t = _retTree;
			dec=true;
			_t = __t93;
			_t = _t.getNextSibling();
			break;
		}
		case PRIME:
		{
			AST __t94 = _t;
			AST tmp42_AST_in = (AST)_t;
			match(_t,PRIME);
			_t = _t.getFirstChild();
			e=expr(_t);
			_t = _retTree;
			prime=true;
			_t = __t94;
			_t = _t.getNextSibling();
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		
		if (prime) 
		v = Math.performOverloadedOperation("operator'", e, null);
		else {
		// call appropriate operator (++/--)
		Debug.Unimplemented("post ++/--");
		}
		
		_retTree = _t;
		return v;
	}
	
	public final Value  logicalAndExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST logicalAndExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		Value lhs;
		
		AST __t81 = _t;
		AST tmp43_AST_in = (AST)_t;
		match(_t,LITERAL_and);
		_t = _t.getFirstChild();
		lhs=expr(_t);
		_t = _retTree;
		_t = __t81;
		_t = _t.getNextSibling();
		
		if (!Math.isLogicalTrue(lhs)) 
		v = new Value(new Boolean(false));
		else {
		AST logAndAST = logicalAndExpression_AST_in;
		AST rhsAST = logAndAST.getFirstChild().getNextSibling(); // skip over lhs
		Value rhs = expr(rhsAST);
		v = new Value(Math.isLogicalTrue(rhs));
		}
		
		_retTree = _t;
		return v;
	}
	
	public final Value  logicalOrExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST logicalOrExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		Value lhs;
		
		AST __t75 = _t;
		AST tmp44_AST_in = (AST)_t;
		match(_t,LITERAL_or);
		_t = _t.getFirstChild();
		lhs=expr(_t);
		_t = _retTree;
		_t = __t75;
		_t = _t.getNextSibling();
		
		if (Math.isLogicalTrue(lhs)) 
		v = new Value(true);
		else {
		AST logOrAST = logicalOrExpression_AST_in;
		AST rhsAST = logOrAST.getFirstChild().getNextSibling(); // skip over lhs
		Value rhs = expr(rhsAST);
		v = new Value(Math.isLogicalTrue(rhs));
		}
		
		_retTree = _t;
		return v;
	}
	
	public final Value  logicalNotExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST logicalNotExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		Value rhs;
		
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case LNOT:
		{
			AST __t84 = _t;
			AST tmp45_AST_in = (AST)_t;
			match(_t,LNOT);
			_t = _t.getFirstChild();
			rhs=expr(_t);
			_t = _retTree;
			_t = __t84;
			_t = _t.getNextSibling();
			break;
		}
		case LITERAL_not:
		{
			AST __t85 = _t;
			AST tmp46_AST_in = (AST)_t;
			match(_t,LITERAL_not);
			_t = _t.getFirstChild();
			rhs=expr(_t);
			_t = _retTree;
			_t = __t85;
			_t = _t.getNextSibling();
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		
		if (Math.isLogicalTrue(rhs))
		v = new Value(new Boolean(false));
		else
		v = new Value(new Boolean(true));
		
		_retTree = _t;
		return v;
	}
	
	public final Value  isExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST isExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		Value lhs = null,rhs; boolean neg=false;
		
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case LITERAL_is:
		{
			AST __t72 = _t;
			AST tmp47_AST_in = (AST)_t;
			match(_t,LITERAL_is);
			_t = _t.getFirstChild();
			lhs=expr(_t);
			_t = _retTree;
			rhs=expr(_t);
			_t = _retTree;
			_t = __t72;
			_t = _t.getNextSibling();
			break;
		}
		case LITERAL_isnt:
		{
			AST __t73 = _t;
			AST tmp48_AST_in = (AST)_t;
			match(_t,LITERAL_isnt);
			_t = _t.getFirstChild();
			lhs=expr(_t);
			_t = _retTree;
			rhs=expr(_t);
			_t = _retTree;
			neg=true;
			_t = __t73;
			_t = _t.getNextSibling();
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		
		//!!! may be able to do away with much of this any logic if Value (or something) takes care
		//  of Any extraction automatically
		
		TypeSpec anyType = new TypeSpec(TypeSpec.anyType);
		
		// if lhs is null it can only be identical with a null rhs
		if ((lhs.getValue() == null) || (TypeSpec.typeOf(lhs).equals(anyType) && (((Any)lhs.getValue()).value == null))) {
		// if rhs is not null, check if it is an Any and if so, look inside for a null value
		if (rhs != null) {
		TypeSpec trhs = TypeSpec.typeOf(rhs);
		if (trhs.equals(anyType)) { // extract from Any
		rhs = new Value(((Any)rhs.getValue()).value);
		trhs = TypeSpec.typeOf(rhs);
		}
		if (trhs.isType() && rhs.getValue().equals(anyType)) // 'is any'
		v = new Value(true);
		else
		v = new Value(rhs.getValue() == null); // lhs & rhs null (rhs was Any(null))
		}
		else
		v = new Value(true); // lhs & rhs null
		}
		else {
		// similarly, a null rhs can only be identical with a null lhs
		if ((rhs.getValue() == null) || (TypeSpec.typeOf(rhs).equals(anyType) && (((Any)rhs.getValue()).value == null))) {
		v = new Value(   (lhs.getValue() == null) 
		|| (   TypeSpec.typeOf(lhs).equals(anyType) 
		&& (((Any)lhs.getValue()).value == null)) );
		}
		else {
		// OK, both sides are non-null (but may be Any's, if so extract their values)
		TypeSpec tlhs = TypeSpec.typeOf(lhs);
		TypeSpec trhs = TypeSpec.typeOf(rhs);
		
		if (tlhs.equals(anyType)) {
		lhs = new Value(((Any)lhs.getValue()).value);
		tlhs = TypeSpec.typeOf(lhs);
		}
		if (trhs.equals(anyType)) {
		rhs = new Value(((Any)rhs.getValue()).value);
		trhs = TypeSpec.typeOf(rhs);
		}
		
		// finally, if rhs is of type 'type', do a type comparison, else do identity
		if (trhs.isType()) {
		if (rhs.getValue().equals(anyType))
		v = new Value(true); // 'is any'
		else
		v = new Value(TypeSpec.typeOf(lhs).equals(rhs.getValue())); // lhs is-a rhs?
		}
		else 
		v = new Value(lhs.getValue() == rhs.getValue()); // is lhs the same object instance as rhs? i.e. identity, not equality
		}
		}
		
		if (neg)
		v = new Value( new Boolean((!((Boolean)v.getValue()).booleanValue())) ); // flip sense for isnt
		
		Debug.Assert(v.getValue() instanceof Boolean);
		
		_retTree = _t;
		return v;
	}
	
	public final Value  rangeExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST rangeExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST dd = null;
		Value lhs=null; Value rhs=null;
		
		AST __t68 = _t;
		dd = _t==ASTNULL ? null :(AST)_t;
		match(_t,DOTDOT);
		_t = _t.getFirstChild();
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case DOT:
		case DOTDOT:
		case UNARY_MINUS:
		case UNARY_PLUS:
		case EXPRLIST:
		case MATRIX:
		case LIST:
		case MAP:
		case FUNC:
		case POST_INC:
		case POST_DEC:
		case APPLICATION:
		case LIT_TRUE:
		case LIT_FALSE:
		case LIT_NULL:
		case LIT_FUNC:
		case BUILTIN_TYPE:
		case LITERAL_namespace:
		case IDENT:
		case STRING_LITERAL:
		case LITERAL_typeof:
		case LITERAL_logger:
		case ASSIGN:
		case LITERAL_or:
		case LITERAL_and:
		case NOT_EQUAL:
		case EQUAL:
		case LITERAL_is:
		case LITERAL_isnt:
		case LTHAN:
		case GTHAN:
		case LTE:
		case GTE:
		case PLUS:
		case MINUS:
		case STAR:
		case DIV:
		case MOD:
		case HAT:
		case INC:
		case DEC:
		case LNOT:
		case LITERAL_not:
		case HASH:
		case PRIME:
		case BAR:
		case SCOPE_ESCAPE:
		case LITERAL_try:
		case NUM_INT:
		case NUM_DINT:
		case NUM_REAL:
		case NUM_SREAL:
		case CHAR_LITERAL:
		case LITERAL_let:
		case LITERAL_class:
		case LITERAL_interface:
		case LITERAL_if:
		case LITERAL_do:
		case LITERAL_while:
		case LITERAL_for:
		case LITERAL_foreach:
		case LITERAL_throw:
		{
			lhs=expr(_t);
			_t = _retTree;
			rhs=expr(_t);
			_t = _retTree;
			break;
		}
		case 3:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		_t = __t68;
		_t = _t.getNextSibling();
		
		if (lhs==null) lhs = new Value(0);
		if (rhs==null) rhs = new Value(-1);
		
		lhs.rvalue();
		rhs.rvalue();
		
		TypeSpec tlhs = TypeSpec.typeOf(lhs);
		TypeSpec trhs = TypeSpec.typeOf(rhs);
		TypeSpec intType = new TypeSpec(TypeSpec.intType);
		
		if (   !TypeManager.existsImplicitConversion(tlhs, intType, lhs)
		|| !TypeManager.existsImplicitConversion(trhs, intType, rhs) )
		ScigolTreeParser.semanticError(locationOf(dd),"both the RHS and LHS of the range operator '..' must be compatible with type 'int'");
		
		int from = ((Integer)TypeManager.performImplicitConversion(tlhs, intType, lhs).getValue()).intValue();
		int to   = ((Integer)TypeManager.performImplicitConversion(trhs, intType, rhs).getValue()).intValue();
		
		if (  ((from<0) && (to<0) && !(from<=to))
		||((from>0) && (to>0) && !(from<=to)) )
		ScigolTreeParser.semanticError(locationOf(dd),"invalid range '"+from+".."+to+"'");
		
		v = new Value(new Range(from, to));
		
		_retTree = _t;
		return v;
	}
	
	public final Value  normExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST normExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST bl = null;
		Value e=null;
		
		AST __t77 = _t;
		bl = _t==ASTNULL ? null :(AST)_t;
		match(_t,BAR);
		_t = _t.getFirstChild();
		e=expr(_t);
		_t = _retTree;
		_t = __t77;
		_t = _t.getNextSibling();
		
		if (e.getValue() == null)
		ScigolTreeParser.semanticError(locationOf(bl),"null value in operator|| (norm)");
		
		v = Math.performOverloadedOperation("operator||", e, null);
		
		_retTree = _t;
		return v;
	}
	
	public final Value  cardinalityExpression(AST _t) throws RecognitionException {
		Value v=null;
		
		AST cardinalityExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		Value e=null;
		
		AST __t79 = _t;
		AST tmp49_AST_in = (AST)_t;
		match(_t,HASH);
		_t = _t.getFirstChild();
		e=expr(_t);
		_t = _retTree;
		_t = __t79;
		_t = _t.getNextSibling();
		
		if (e.getValue() == null) 
		v = new Value(new Integer(0));
		else
		v = Math.performOverloadedOperation("operator#", null, e);
		
		_retTree = _t;
		return v;
	}
	
	public final ArrayList  indexing(AST _t) throws RecognitionException {
		ArrayList indexValues=null;
		
		AST indexing_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		Range r1=null; Range r2=null;
		
		AST __t96 = _t;
		AST tmp50_AST_in = (AST)_t;
		match(_t,LPAREN);
		_t = _t.getFirstChild();
		r1=eltRange(_t);
		_t = _retTree;
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case COLON:
		{
			r2=eltRange(_t);
			_t = _retTree;
			break;
		}
		case 3:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		_t = __t96;
		_t = _t.getNextSibling();
		_retTree = _t;
		return indexValues;
	}
	
	public final Range  eltRange(AST _t) throws RecognitionException {
		Range r=new Range();
		
		AST eltRange_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		Value e=null;
		
		AST __t99 = _t;
		AST tmp51_AST_in = (AST)_t;
		match(_t,COLON);
		_t = _t.getFirstChild();
		{
		_loop101:
		do {
			if (_t==null) _t=ASTNULL;
			if ((_tokenSet_0.member(_t.getType()))) {
				e=expr(_t);
				_t = _retTree;
			}
			else {
				break _loop101;
			}
			
		} while (true);
		}
		_t = __t99;
		_t = _t.getNextSibling();
		_retTree = _t;
		return r;
	}
	
	public final String  qualifiedIdent(AST _t) throws RecognitionException {
		String name="";
		
		AST qualifiedIdent_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST i = null;
		AST i2 = null;
		
		i = (AST)_t;
		match(_t,IDENT);
		_t = _t.getNextSibling();
		name = i.getText();
		{
		_loop119:
		do {
			if (_t==null) _t=ASTNULL;
			if ((_t.getType()==IDENT)) {
				i2 = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				name += "."+i2.getText();
			}
			else {
				break _loop119;
			}
			
		} while (true);
		}
		_retTree = _t;
		return name;
	}
	
	public final ScigolAnnotation  annotation(AST _t) throws RecognitionException {
		ScigolAnnotation a=null;
		
		AST annotation_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		String annotName = null;
		ArrayList args = null; 
		
		
		AST __t121 = _t;
		AST tmp52_AST_in = (AST)_t;
		match(_t,ANNOT_START);
		_t = _t.getFirstChild();
		annotName=qualifiedIdent(_t);
		_t = _retTree;
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case LPAREN:
		{
			args=applicationArgs(_t);
			_t = _retTree;
			break;
		}
		case 3:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		_t = __t121;
		_t = _t.getNextSibling();
		
			
			  java.lang.reflect.Type javaType = NamespaceScope.loadedLibrariesGetType(annotName);
			  TypeSpec annotType = (javaType!=null)?new TypeSpec(javaType):null;
			  
			  if (annotType==null) 
			    ScigolTreeParser.semanticError("the annotation type '"+annotName+"' could not be found in the current scope");
			  else if (!annotType.isInterface() || !annotType.isA(new TypeSpec(Annotation.class)))
			    ScigolTreeParser.semanticError("the type '"+annotName+"' specified as an annotation must implement 'Annotation'");
		
		// now construct a ScigolAnnotation to hold the parameters
		a = new ScigolAnnotation(annotType);
		a.setMembers(args);
			
		_retTree = _t;
		return a;
	}
	
	public final EnumSet<TypeSpec.Modifier>  classModifiers(AST _t) throws RecognitionException {
		EnumSet<TypeSpec.Modifier> modifiers;
		
		AST classModifiers_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		modifiers = EnumSet.noneOf(TypeSpec.Modifier.class);
		
		AST __t162 = _t;
		AST tmp53_AST_in = (AST)_t;
		match(_t,MODIFIERS);
		_t = _t.getFirstChild();
		{
		_loop164:
		do {
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case LITERAL_public:
			{
				AST tmp54_AST_in = (AST)_t;
				match(_t,LITERAL_public);
				_t = _t.getNextSibling();
				modifiers.add(TypeSpec.Modifier.Public);
				break;
			}
			case LITERAL_protected:
			{
				AST tmp55_AST_in = (AST)_t;
				match(_t,LITERAL_protected);
				_t = _t.getNextSibling();
				modifiers.add(TypeSpec.Modifier.Protected);
				break;
			}
			case LITERAL_private:
			{
				AST tmp56_AST_in = (AST)_t;
				match(_t,LITERAL_private);
				_t = _t.getNextSibling();
				modifiers.add(TypeSpec.Modifier.Private);
				break;
			}
			case LITERAL_static:
			{
				AST tmp57_AST_in = (AST)_t;
				match(_t,LITERAL_static);
				_t = _t.getNextSibling();
				modifiers.add(TypeSpec.Modifier.Static);
				break;
			}
			case LITERAL_override:
			{
				AST tmp58_AST_in = (AST)_t;
				match(_t,LITERAL_override);
				_t = _t.getNextSibling();
				modifiers.add(TypeSpec.Modifier.Override);
				break;
			}
			case LITERAL_final:
			{
				AST tmp59_AST_in = (AST)_t;
				match(_t,LITERAL_final);
				_t = _t.getNextSibling();
				modifiers.add(TypeSpec.Modifier.Final);
				break;
			}
			default:
			{
				break _loop164;
			}
			}
		} while (true);
		}
		_t = __t162;
		_t = _t.getNextSibling();
		_retTree = _t;
		return modifiers;
	}
	
	public final TypeSpec  typeExpression(AST _t) throws RecognitionException {
		TypeSpec t=null;
		
		AST typeExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		Value v=null;
		
		v=expr(_t);
		_t = _retTree;
		
		if (v.getValue() == null)
		ScigolTreeParser.semanticError("found null where type expression was required");
		TypeSpec vtype = TypeSpec.typeOf(v);
		if (!vtype.isType()) {
		// as a special convenience, if we have a func(->type) value, call it (so the user can omit the ()'s to call the 'type generator function')
		if (vtype.isFunc() && vtype.getFuncInfo().getReturnType().isType() && (vtype.getFuncInfo().numRequiredArgs() == 0)) {
		Func f = (Func)v.getValue();
		FuncInfo callSig = new FuncInfo(new TypeSpec[0], new TypeSpec(TypeSpec.typeType)); // func(->type)
		callSig.setDefinitionLocation( new Location() );
		
		Object[] convertedArgs = f.getInfo().convertParameters(callSig, new Object[0], f.isExternal());
		
		// retrieve instance
		Object instance = null;
		if (v.isLValue())
		instance = v.getLValue().getSymbol().getInstance();
		
		Object ret = f.call(null, convertedArgs); // call it
		
		Debug.Assert(TypeSpec.typeOf(ret).isType(),"expected type return");
		
		t = (TypeSpec)ret;
		}
		else
		ScigolTreeParser.semanticError("an expression of type '"+TypeSpec.typeOf(v)+"' was found where type expression was required");
		}
		else
		t = (TypeSpec)v.getValue();
		
		_retTree = _t;
		return t;
	}
	
	public final FuncInfo  funcType(AST _t) throws RecognitionException {
		FuncInfo v=null;
		
		AST funcType_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST fl = null;
		TypeSpec rt=null; FuncInfo fi=null;
		
		AST __t166 = _t;
		fl = _t==ASTNULL ? null :(AST)_t;
		match(_t,FUNC);
		_t = _t.getFirstChild();
		fi=paramTypeList(_t);
		_t = _retTree;
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case GIVES:
		{
			AST tmp60_AST_in = (AST)_t;
			match(_t,GIVES);
			_t = _t.getNextSibling();
			rt=typeExpression(_t);
			_t = _retTree;
			break;
		}
		case 3:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		_t = __t166;
		_t = _t.getNextSibling();
		
		if (rt != null)
		fi.setReturnType( rt );
		fi.setDefinitionLocation( locationOf(fl) );
		v=fi;
		
		_retTree = _t;
		return v;
	}
	
	public final TypeSpec  classType(AST _t) throws RecognitionException {
		TypeSpec t=null;
		
		AST classType_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST ct = null;
		AST i = null;
		
		EnumSet<TypeSpec.Modifier> modifiers = EnumSet.noneOf(TypeSpec.Modifier.class);
		ArrayList baseTypes = new ArrayList();
		Object memberValue = null;
		
		
		AST __t133 = _t;
		ct = _t==ASTNULL ? null :(AST)_t;
		match(_t,LITERAL_class);
		_t = _t.getFirstChild();
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case MODIFIERS:
		{
			modifiers=classModifiers(_t);
			_t = _retTree;
			break;
		}
		case 3:
		case CTOR:
		case IDENT:
		case COLON:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case COLON:
		{
			baseTypes=classBase(_t);
			_t = _retTree;
			break;
		}
		case 3:
		case CTOR:
		case IDENT:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		
		// start new class declaration & add interfaces
		TypeSpec baseType = TypeSpec.objectTypeSpec;
		int firstInterface=0;
		if (baseTypes != null) {
		if (baseTypes.size() > 0) {
		TypeSpec firstType = (TypeSpec)baseTypes.get(0); 
		if (!firstType.isInterface()) {
		baseType = firstType; // super class
		firstInterface++;
		}
		}
		}
		ClassInfo info = new ClassInfo(scope, baseType);
		info.setModifiers( modifiers );
		if (ct instanceof CommonASTWithLocation)
		info.setDefinitionLocation( ((CommonASTWithLocation)ct).loc );
		if (baseTypes.size() > 1) {
		for(int ii=firstInterface; ii<baseTypes.size(); ii++) {
		TypeSpec iType = (TypeSpec)baseTypes.get(ii);
		info.addInterface(iType);   
		}
		}
		
		if (scope.topDeclarationIdent() != null)
		info.setIdentityHint(scope.topDeclarationIdent());
		
		// create a new scope for the class
		scope = new ClassScope(new TypeSpec(info));
		scope.setDefinitionLocation( locationOf(ct) );
		
		{
		_loop141:
		do {
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case CTOR:
			{
				{
				AST __t138 = _t;
				AST tmp61_AST_in = (AST)_t;
				match(_t,CTOR);
				_t = _t.getFirstChild();
				classConstructor(_t,info);
				_t = _retTree;
				_t = __t138;
				_t = _t.getNextSibling();
				
				
				}
				break;
			}
			case IDENT:
			{
				{
				AST __t140 = _t;
				i = _t==ASTNULL ? null :(AST)_t;
				match(_t,IDENT);
				_t = _t.getFirstChild();
				scope.pushDeclarationIdent(i.getText());
				classMember(_t,i, false);
				_t = _retTree;
				_t = __t140;
				_t = _t.getNextSibling();
				
				scope.popDeclarationIdent();
				
				}
				break;
			}
			default:
			{
				break _loop141;
			}
			}
		} while (true);
		}
		
		info.completeDefinition();
		t = ((ClassScope)scope).getClassType();
		
		scope = scope.getOuter(); // exit class scope
		
		_t = __t133;
		_t = _t.getNextSibling();
		_retTree = _t;
		return t;
	}
	
	public final TypeSpec  interfaceType(AST _t) throws RecognitionException {
		TypeSpec t=null;
		
		AST interfaceType_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST it = null;
		AST i = null;
		
		EnumSet<TypeSpec.Modifier> modifiers = EnumSet.noneOf(TypeSpec.Modifier.class);
		ArrayList baseTypes = new ArrayList();
		Object memberValue = null;
		
		
		AST __t143 = _t;
		it = _t==ASTNULL ? null :(AST)_t;
		match(_t,LITERAL_interface);
		_t = _t.getFirstChild();
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case MODIFIERS:
		{
			modifiers=classModifiers(_t);
			_t = _retTree;
			break;
		}
		case 3:
		case IDENT:
		case COLON:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case COLON:
		{
			baseTypes=classBase(_t);
			_t = _retTree;
			break;
		}
		case 3:
		case IDENT:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		
		// start new class declaration & add interfaces
		ClassInfo info = new ClassInfo(scope, null); // interface
		info.setModifiers( modifiers );
		if (it instanceof CommonASTWithLocation)
		info.setDefinitionLocation( ((CommonASTWithLocation)it).loc );
		if (baseTypes == null) baseTypes = new ArrayList();
		if (baseTypes.size() > 0) {
		for(int ii=0; ii<baseTypes.size(); ii++) {
		TypeSpec iType = (TypeSpec)baseTypes.get(ii);
		if (!iType.isBuiltinObject()) { // don't add object again
		if (!iType.isInterface()) // complain if not an interface
		ScigolTreeParser.semanticError(locationOf(it), "interfaces can only inherit other interfaces (and 'object')");
		info.addInterface(iType);   
		}
		}
		}
		
		if (scope.topDeclarationIdent() != null)
		info.setIdentityHint(scope.topDeclarationIdent());
		
		// create a new scope for the class
		scope = new ClassScope(new TypeSpec(info));
		scope.setDefinitionLocation( locationOf(it) );
		
		{
		_loop149:
		do {
			if (_t==null) _t=ASTNULL;
			if ((_t.getType()==IDENT)) {
				{
				AST __t148 = _t;
				i = _t==ASTNULL ? null :(AST)_t;
				match(_t,IDENT);
				_t = _t.getFirstChild();
				scope.pushDeclarationIdent(i.getText());
				classMember(_t,i, true);
				_t = _retTree;
				_t = __t148;
				_t = _t.getNextSibling();
				
				scope.popDeclarationIdent();
				
				}
			}
			else {
				break _loop149;
			}
			
		} while (true);
		}
		
		info.completeDefinition();
		t = ((ClassScope)scope).getClassType();
		
		scope = scope.getOuter(); // exit class scope
		
		_t = __t143;
		_t = _t.getNextSibling();
		_retTree = _t;
		return t;
	}
	
	public final ArrayList  classBase(AST _t) throws RecognitionException {
		ArrayList baseTypes=new ArrayList();
		
		AST classBase_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		TypeSpec baseType;
		
		AST __t158 = _t;
		AST tmp62_AST_in = (AST)_t;
		match(_t,COLON);
		_t = _t.getFirstChild();
		{
		_loop160:
		do {
			if (_t==null) _t=ASTNULL;
			if ((_tokenSet_0.member(_t.getType()))) {
				baseType=typeExpression(_t);
				_t = _retTree;
				baseTypes.add(baseType);
			}
			else {
				break _loop160;
			}
			
		} while (true);
		}
		_t = __t158;
		_t = _t.getNextSibling();
		_retTree = _t;
		return baseTypes;
	}
	
	public final void classConstructor(AST _t,
		ClassInfo declaringClass
	) throws RecognitionException {
		
		AST classConstructor_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		EnumSet<TypeSpec.Modifier> modifiers = EnumSet.noneOf(TypeSpec.Modifier.class);
		Func func=null;
		
		
		{
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case MODIFIERS:
		{
			modifiers=classModifiers(_t);
			_t = _retTree;
			break;
		}
		case LIT_FUNC:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		func=functionLiteral(_t);
		_t = _retTree;
		}
		
		Debug.Assert(func.getOuterScope().isClassScope(),"members can only be in class scope");
		
		// if not Protected or Private, then default to Public
		if (   (!modifiers.contains(TypeSpec.Modifier.Private))
		&& (!modifiers.contains(TypeSpec.Modifier.Protected)) )
		modifiers.add(TypeSpec.Modifier.Public);
		
		modifiers.add(TypeSpec.Modifier.Static); // constructors are always Static
		
		func.setIsConstructor( true );
		
		if (    (func.getInfo().getReturnType() == null)
		|| (!func.getInfo().getReturnType().equals(new TypeSpec(declaringClass))) )
		ScigolTreeParser.semanticError(func.getInfo().getDefinitionLocation(),"class constructors must return the declaring class type (i.e. 'self')");
		
		scope.addEntry(".ctor", TypeSpec.typeOf(func), func, null, modifiers);
		
		_retTree = _t;
	}
	
	public final void classMember(AST _t,
		AST memberName, boolean declaringInInterface
	) throws RecognitionException {
		
		AST classMember_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST m = null;
		AST t = null;
		AST a = null;
		AST p = null;
		
		EnumSet<TypeSpec.Modifier> modifiers = EnumSet.noneOf(TypeSpec.Modifier.class);
		TypeSpec dt=null; 
		Value e=null;
		
		
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case MODIFIERS:
		{
			m = _t==ASTNULL ? null : (AST)_t;
			modifiers=classModifiers(_t);
			_t = _retTree;
			break;
		}
		case 3:
		case PROP:
		case ASSIGN:
		case COLON:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case COLON:
		{
			t = (AST)_t;
			match(_t,COLON);
			_t = _t.getNextSibling();
			dt=typeExpression(_t);
			_t = _retTree;
			break;
		}
		case 3:
		case PROP:
		case ASSIGN:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case ASSIGN:
		{
			a = (AST)_t;
			match(_t,ASSIGN);
			_t = _t.getNextSibling();
			break;
		}
		case PROP:
		{
			p = (AST)_t;
			match(_t,PROP);
			_t = _t.getNextSibling();
			break;
		}
		case 3:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		
		
		//!!! use  declaringInInterface appropriately
		
		boolean propertyDecl = (p != null);
		
		boolean isConst  = modifiers.contains(TypeSpec.Modifier.Const);
		boolean isStatic = modifiers.contains(TypeSpec.Modifier.Static);
		boolean staticOrConst = isStatic || isConst;
		
		// if not Protected or Private, then default to Public
		if (   (!modifiers.contains(TypeSpec.Modifier.Private))
		&& (!modifiers.contains(TypeSpec.Modifier.Protected)) )
		modifiers.add(TypeSpec.Modifier.Public);
		
		
		if (propertyDecl) {   
		//
		// handle a property declaration
		
		String ident = memberName.getText();
		
		if (dt==null) 
		ScigolTreeParser.semanticError(locationOf(memberName),"property member '"+ident+"' must explicitly declare a type");
		
		if (isStatic && (ident.equals("operator()")))
		ScigolTreeParser.semanticError(locationOf(memberName),"property member 'operator()' - an indexer - cannot be static");
		
		
		// Check for existing property with the same name (properties cannot be overloaded based on call signature)
		//....!!!
		
		
		FuncInfo propSig = new FuncInfo(); // *explicit* argument of property (with no return)
		boolean gotGetAccessor = false;
		boolean gotSetAccessor = false;
		Entry getterEntry = null;
		Entry setterEntry = null;
		
		// do some manual tree 'parsing' to get what we want without actually
		//  walking/executing the accessor bodies
		AST propAST = p.getFirstChild();
		AST nextAST = propAST.getFirstChild();
		if (nextAST.getType() == LPAREN) { // a formal param list (possibly empty) was supplied
		AST paramListAST = nextAST.getFirstChild();
		propSig = formalParamList(paramListAST);
		
		nextAST = nextAST.getNextSibling();
		}
		
		
		// while more accessors (max of two - get & set)
		while ((nextAST != null) && (nextAST.getType() == IDENT)) { 
		
		AST initializerAST = null;
		Object staticValue = null; 
		
		String accessorName = nextAST.getText();
		CommonASTWithLocation astWithLoc = (CommonASTWithLocation)nextAST;
		Location loc = (astWithLoc!=null)?astWithLoc.loc:new Location();
		
		if ( (!accessorName.equals("set")) && (!accessorName.equals("get")) ) {
		ScigolTreeParser.semanticError(loc,"the only valid property accessor names are 'get' and 'set'");
		}
		
		if (accessorName.equals("set")) {
		if (gotSetAccessor)
		ScigolTreeParser.semanticError(loc,"a property can only have one 'set' accessor");
		gotSetAccessor = true;
		}
		else if (accessorName.equals("get")) {
		if (gotGetAccessor)
		ScigolTreeParser.semanticError(loc,"a property can only have one 'get' accessor");
		gotGetAccessor = true;
		}
		
		AST accessorBodyAST = nextAST.getFirstChild();
		
		// make appropriate accessor signature
		FuncInfo accessorSig = propSig.accessorSig(accessorName, dt);
		
		if ((accessorBodyAST.getType() == LITERAL_pre) || (accessorBodyAST.getType() == LITERAL_post) || (accessorBodyAST.getType() == EXPRLIST)) {
		staticValue = functionLiteralBody(accessorBodyAST,accessorSig);
		}
		else { // accessor is initialized with an expression
		initializerAST = accessorBodyAST;
		
		// if static or const, evaluate it now, otherwise it will be evaluated at instantiation time
		if (staticOrConst) {
		Value v = expr(initializerAST);
		staticValue=v.getValue();
		initializerAST=null; // don't need it again
		}
		
		}
		
		
		// now enter the appropriate accessor func into the current class scope
		String funcName = FuncInfo.accessorName(ident, (accessorName.equals("get")));
		
		Entry accessorEntry = new Entry(funcName, new TypeSpec(accessorSig), staticValue, initializerAST, modifiers, EnumSet.of(Entry.Flags.Method,Entry.Flags.Accessor), -1, scope, loc);
		if (accessorName.equals("get"))
		getterEntry = accessorEntry;
		else
		setterEntry = accessorEntry;
		scope.addEntry(accessorEntry);
		
		
		nextAST = nextAST.getNextSibling();
		
		} // while
		
		
		// in addition to the accessor func members, we also add an Entry for the property itself
		EnumSet<Entry.Flags> flags = EnumSet.of(Entry.Flags.Property);
		if (gotGetAccessor) flags.add(Entry.Flags.HasGetter);
		if (gotSetAccessor) flags.add(Entry.Flags.HasSetter);
		Entry propEntry = new Entry(ident, dt, null, null, modifiers, flags, -1, scope, locationOf(memberName));
		
		// put a reference to the accessors into the property Entry (as it's staticValue)
		Entry.EntryPair accessors = new Entry.EntryPair();
		accessors.setter = setterEntry;
		accessors.getter = getterEntry;
		propEntry.setStaticValue( accessors );
		
		scope.addEntry(propEntry);
		
		// Also, put a reference to the propEntry in each accessor entry
		if (gotGetAccessor) getterEntry.propertyEntry = propEntry;
		if (gotSetAccessor) setterEntry.propertyEntry = propEntry;
		
		}
		else { 
		
		//
		// member is a regular (non-property) declaration
		
		boolean typeSupplied = (t != null);
		boolean initializerSupplied = (a != null);
		
		if (!typeSupplied && !initializerSupplied)
		ScigolTreeParser.semanticError(t,"member declaration must include a type or an initializer (or both)");
		
		// get initializer expr AST, if supplied
		AST initializerAST = null;
		if (initializerSupplied) initializerAST=a.getNextSibling();
		
		//      if (initializerSupplied) //!!!
		//        Debug.WriteLine("initializerAST="+initializerAST.toStringTree());
		//      else
		//        Debug.WriteLine("no initializer");
		
		
		// if this is a is static or const, the initializer is evaluated now,
		//  otherwise it is evaluated as instantiation time (in which case the type must be specified here)
		//  (NB: methods are a special case as for convenience they don't need to have their type
		//   specified *if* the initializer is a func literal - which specifies the signature/type)
		
		Object staticValue = null; 
		boolean typeKnown = typeSupplied;
		
		if (initializerSupplied) {
		
		if (staticOrConst) {
		Value v=expr(initializerAST); // eval initializer now
		staticValue=v.getValue();
		initializerAST = null; // don't need it again
		if (!typeSupplied) {
		dt = TypeSpec.typeOf(staticValue); // deduce type from initializer
		typeKnown = true;
		}
		}
		else {
		//!!! is it possible to have consistient behaviour and deduce the type too.  But we need
		//another rule that can tree parse the signature WITHOUT evaluating the default params (!) 
		//  (this has the problem that the signature will be different! - without defaults)
		
		// as a special convenience, if the initializer is a func literal and the type wasn't
		//  explicitly supplied, we can evaluate it now, saving the user from having 
		//  to specify it in this case (avoiding the member type being 'any')
		//  (i.e. we can deduce the func type by evaluating the literal).
		// NB: this has the side-effect that any parameter default expressions will be 
		//  evaluated now, rather than at initialization time!
		if ((!typeSupplied) && (initializerAST.getType() == ScigolLexer.LIT_FUNC)) {
		Value v = expr(initializerAST);
		staticValue=v.getValue();
		initializerAST = null; // don't need it again
		
		dt = TypeSpec.typeOf(staticValue);
		typeKnown = true;
		}
		
		}
		}
		else { // no initializer, instantiate default from type (either now or at instantiation)
		Debug.Assert(typeSupplied);
		
		if (staticOrConst) {
		Value v = dt.constructValue(null, null, this);
		staticValue = v.getValue();
		}
		else { // instance
		staticValue = null;
		}
		
		}
		
		
		if (!typeKnown)
		dt = new TypeSpec(TypeSpec.anyType);
		
		String name = scope.topDeclarationIdent();
		if (scope.contains(name)) { // does this scope already define a member named 'name'?
		// yes, that is only OK if it is a func (overloading) that isn't ambiguous in its call signature
		if (!typeKnown || (typeKnown && !dt.isFunc()))
		ScigolTreeParser.semanticError(t,"class already has a member named '"+name+"'");
		}
		
		// add to scope (will thow in the case of ambiguous func overloading)
		scope.addEntry(name, dt, staticValue, initializerAST, modifiers, locationOf(memberName));
		
		}
		
		
		_retTree = _t;
	}
	
	public final FuncInfo  paramTypeList(AST _t) throws RecognitionException {
		FuncInfo fi=null;
		
		AST paramTypeList_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		TypeSpec t; 
		ArrayList ptypes = new ArrayList();
		
		
		{
		_loop173:
		do {
			if (_t==null) _t=ASTNULL;
			if ((_tokenSet_0.member(_t.getType()))) {
				t=typeExpression(_t);
				_t = _retTree;
				
				ptypes.add(t);
				
			}
			else {
				break _loop173;
			}
			
		} while (true);
		}
		
		int numArgs = ptypes.size();
		// convert the ArrayLists to arrays
		TypeSpec[] ptypesa = new TypeSpec[numArgs];
		
		for(int p=0; p<numArgs;p++) 
		ptypesa[p] = (TypeSpec)ptypes.get(p);
		
		// return a partially filled-out FuncInfo
		fi = new FuncInfo(ptypesa, null);
		
		_retTree = _t;
		return fi;
	}
	
	public final FuncInfo  funcSignature(AST _t) throws RecognitionException {
		FuncInfo v=null;
		
		AST funcSignature_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST fl = null;
		TypeSpec rt=null; FuncInfo fi=null;
		
		AST __t169 = _t;
		fl = _t==ASTNULL ? null :(AST)_t;
		match(_t,FUNC);
		_t = _t.getFirstChild();
		fi=formalParamList(_t);
		_t = _retTree;
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case GIVES:
		{
			AST tmp63_AST_in = (AST)_t;
			match(_t,GIVES);
			_t = _t.getNextSibling();
			rt=typeExpression(_t);
			_t = _retTree;
			break;
		}
		case 3:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		_t = __t169;
		_t = _t.getNextSibling();
		
		if (rt != null)
		fi.setReturnType( rt );
		fi.setDefinitionLocation( locationOf(fl) );
		v=fi;
		
		_retTree = _t;
		return v;
	}
	
	public final FuncInfo  formalParamList(AST _t) throws RecognitionException {
		FuncInfo fi=null;
		
		AST formalParamList_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST i = null;
		
		TypeSpec t;
		Value e=null; 
		ArrayList pnames = new ArrayList();
		ArrayList ptypes = new ArrayList();
		ArrayList pdefaults = new ArrayList();
		ArrayList phasdefault = new ArrayList();
		
		
		{
		_loop177:
		do {
			if (_t==null) _t=ASTNULL;
			if ((_t.getType()==IDENT)) {
				i = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				t=typeExpression(_t);
				_t = _retTree;
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case ASSIGN:
				{
					AST tmp64_AST_in = (AST)_t;
					match(_t,ASSIGN);
					_t = _t.getNextSibling();
					e=expr(_t);
					_t = _retTree;
					break;
				}
				case 3:
				case IDENT:
				case GIVES:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				
				String paramName = i.getText();
				TypeSpec paramType = t;
				pnames.add(paramName);
				ptypes.add(paramType);
				phasdefault.add( (e != null) );
				if (e != null)
				pdefaults.add(e.getValue());
				else
				pdefaults.add(null);
				e=null;
				
			}
			else {
				break _loop177;
			}
			
		} while (true);
		}
		
		// convert the ArrayLists to arrays
		String[] pnamesa = new String[pnames.size()];
		TypeSpec[] ptypesa = new TypeSpec[ptypes.size()];
		Object[] pdefaultsa = new Object[pdefaults.size()];
		boolean[] phasdefaulta = new boolean[phasdefault.size()];
		
		for(int p=0; p<pnamesa.length;p++) {
		pnamesa[p] = (String)(String)pnames.get(p);
		ptypesa[p] = (TypeSpec)ptypes.get(p);
		pdefaultsa[p] = pdefaults.get(p);
		phasdefaulta[p] = ((Boolean)phasdefault.get(p)).booleanValue();
		}
		
		// return a partially filled-out FuncInfo
		fi = new FuncInfo(pnamesa, ptypesa, pdefaultsa, phasdefaulta, null);
		fi.setDefinitionLocation( locationOf(i) );
		
		_retTree = _t;
		return fi;
	}
	
	public final Func  functionLiteralBody(AST _t,
		FuncInfo sig
	) throws RecognitionException {
		Func v=null;
		
		AST functionLiteralBody_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST pre = null;
		AST post = null;
		AST exprList = null;
		
		{
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case LITERAL_pre:
		{
			pre = (AST)_t;
			match(_t,LITERAL_pre);
			_t = _t.getNextSibling();
			break;
		}
		case LITERAL_post:
		{
			post = (AST)_t;
			match(_t,LITERAL_post);
			_t = _t.getNextSibling();
			break;
		}
		case EXPRLIST:
		{
			exprList = (AST)_t;
			match(_t,EXPRLIST);
			_t = _t.getNextSibling();
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		}
		
		AST funcBodyAST = null;
		AST preBodyAST = null;
		AST postBodyAST = null;
		
		AST funcAST = functionLiteralBody_AST_in;
		//      funcAST = (funcAST.getFirstChild()).getNextSibling(); // skip to after signature
		
		// if funcAST has an EXPRLIST token type, it is the start of the func body, else if it has pre or post
		//  it is a pre/postcondition expression
		
		if (funcAST.getType() == EXPRLIST) {
		//Debug.WL("found func body first - no pre/post");        
		funcBodyAST = funcAST;
		}
		else {
		if ((funcAST.getType() == LITERAL_pre) || (funcAST.getType() == LITERAL_post)) {
		//Debug.WL("got first pre/post");
		int type = funcAST.getType();        
		funcAST = funcAST.getNextSibling(); // skip over "pre"/"post"
		if (type == LITERAL_pre)
		preBodyAST = funcAST;
		else
		postBodyAST = funcAST;
		funcAST = funcAST.getNextSibling(); // skip over condition body
		}
		
		if (funcAST.getType() == EXPRLIST) {
		//Debug.WL("got func body after first pre/post");          
		funcBodyAST = funcAST;
		}
		else {
		if ((funcAST.getType() == LITERAL_pre) || (funcAST.getType() == LITERAL_post)) {
		//Debug.WL("got second pre/post");          
		int type = funcAST.getType();
		funcAST = funcAST.getNextSibling(); // skip over "pre"/"post"
		if (type == LITERAL_post) {
		if (postBodyAST != null) 
		ScigolTreeParser.semanticError(sig.getDefinitionLocation(), "a func can only define a 'pre' expression, a 'post' expression or both (but not multiple of either)");
		postBodyAST = funcAST;
		}
		else {
		if (preBodyAST != null) 
		ScigolTreeParser.semanticError(sig.getDefinitionLocation(), "a func can only define a 'pre' expression, a 'post' expression or both (but not multiple of either)");
		preBodyAST = funcAST;
		}
		funcAST = funcAST.getNextSibling(); // skip over condition body
		funcBodyAST = funcAST;
		}
		else
		Debug.Assert(false, "couldn't match pre/post or body");
		}
		}
		
		Debug.Assert(funcBodyAST!=null,"no func body!?");
		
		//!!!
		//      if (preBodyAST!=null)
		//        Debug.WL("preBodyAST:"+preBodyAST.toStringTree());
		//      if (postBodyAST!=null)
		//        Debug.WL("postBodyAST:"+postBodyAST.toStringTree());
		
		v = new Func(sig, scope, this, funcBodyAST, preBodyAST, postBodyAST);
		//      Debug.WriteLine("funcBody:"+v+"AST:"+funcBodyAST.toStringTree()); 
		
		_retTree = _t;
		return v;
	}
	
	public final Value  matrixexpr(AST _t) throws RecognitionException {
		Value v=null;
		
		AST matrixexpr_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		Vector r;
		
		AST __t190 = _t;
		AST tmp65_AST_in = (AST)_t;
		match(_t,MATRIX);
		_t = _t.getFirstChild();
		r=matrixrow(_t);
		_t = _retTree;
		v=new Value(r);
		{
		_loop194:
		do {
			if (_t==null) _t=ASTNULL;
			if ((_t.getType()==SEMI)) {
				{
				int _cnt193=0;
				_loop193:
				do {
					if (_t==null) _t=ASTNULL;
					if ((_t.getType()==SEMI)) {
						AST tmp66_AST_in = (AST)_t;
						match(_t,SEMI);
						_t = _t.getNextSibling();
					}
					else {
						if ( _cnt193>=1 ) { break _loop193; } else {throw new NoViableAltException(_t);}
					}
					
					_cnt193++;
				} while (true);
				}
				r=matrixrow(_t);
				_t = _retTree;
				
				if (v.getValue() instanceof Vector)
				v = new Value(new Matrix((Vector)v.getValue()));
				((Matrix)v.getValue()).appendRowVector(r); 
				
			}
			else {
				break _loop194;
			}
			
		} while (true);
		}
		_t = __t190;
		_t = _t.getNextSibling();
		_retTree = _t;
		return v;
	}
	
	public final Vector  matrixrow(AST _t) throws RecognitionException {
		 Vector v=new Vector() ;
		
		AST matrixrow_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		Value e;
		
		{
		int _cnt197=0;
		_loop197:
		do {
			if (_t==null) _t=ASTNULL;
			if ((_tokenSet_0.member(_t.getType()))) {
				e=expr(_t);
				_t = _retTree;
				v.appendElement(e.getValue());
			}
			else {
				if ( _cnt197>=1 ) { break _loop197; } else {throw new NoViableAltException(_t);}
			}
			
			_cnt197++;
		} while (true);
		}
		_retTree = _t;
		return v;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"DOT",
		"DOTDOT",
		"UNARY_MINUS",
		"UNARY_PLUS",
		"EXPRLIST",
		"INITLIST",
		"MATRIX",
		"LIST",
		"MAP",
		"FUNC",
		"POST_INC",
		"POST_DEC",
		"APPLICATION",
		"NAMED_ARG",
		"\"true\"",
		"\"false\"",
		"\"null\"",
		"LIT_FUNC",
		"MODIFIERS",
		"BUILTIN_TYPE",
		"CTOR",
		"PROP",
		"LCURLY",
		";",
		"\"namespace\"",
		"}",
		"an identifier",
		"\"using\"",
		"\"as\"",
		"\"from\"",
		"a string literal",
		"\"pre\"",
		"\"post\"",
		"\"typeof\"",
		"LPAREN",
		"RPAREN",
		"\"assert\"",
		"COMMA",
		"\"debug\"",
		"\"logger\"",
		"ASSIGN",
		"\"or\"",
		"\"and\"",
		"NOT_EQUAL",
		"EQUAL",
		"\"is\"",
		"\"isnt\"",
		"LTHAN",
		"GTHAN",
		"LTE",
		"GTE",
		"PLUS",
		"MINUS",
		"STAR",
		"DIV",
		"MOD",
		"HAT",
		"INC",
		"DEC",
		"LNOT",
		"\"not\"",
		"HASH",
		"PRIME",
		"BAR",
		"SCOPE_ESCAPE",
		"'(",
		"\"try\"",
		"\"catch\"",
		"COLON",
		"a numeric literal",
		"NUM_DINT",
		"NUM_REAL",
		"NUM_SREAL",
		"a char literal",
		"LBRACK",
		"RBRACK",
		"->",
		"ANNOT_START",
		"\"let\"",
		"\"const\"",
		"\"static\"",
		"\"final\"",
		"\"class\"",
		"\"interface\"",
		"\"property\"",
		"\"override\"",
		"\"implicit\"",
		"\"public\"",
		"\"private\"",
		"\"protected\"",
		"\"func\"",
		"\"vector\"",
		"\"matrix\"",
		"\"range\"",
		"\"list\"",
		"\"map\"",
		"\"bool\"",
		"\"byte\"",
		"\"char\"",
		"\"int\"",
		"\"dint\"",
		"\"real\"",
		"\"sreal\"",
		"\"string\"",
		"\"type\"",
		"\"num\"",
		"\"any\"",
		"\"object\"",
		"\"if\"",
		"\"then\"",
		"\"else\"",
		"\"do\"",
		"\"while\"",
		"\"for\"",
		"\"foreach\"",
		"\"in\"",
		"\"by\"",
		"\"throw\"",
		"QUESTION",
		"SL",
		"BAND",
		"FROM",
		"LINE_BREAK",
		"NON_LINE_BREAK_WS",
		"WS",
		"SL_COMMENT",
		"ML_COMMENT",
		"STRING_OR_CHAR_LITERAL",
		"a string literal",
		"a multi-line string literal",
		"NON_BACKQUOTE_STRING",
		"CHAR_LIT_SUFFIX",
		"ESC",
		"HEX_DIGIT",
		"VOCAB",
		"DOT_FLOAT_EXP",
		"EXPONENT",
		"REAL_SUFFIX"
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { -8640119570960L, 178173660270706271L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	}
	
