/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.ontology;

import java.io.Serializable;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.SmallAnnotation;
import org.biojava.ontology.AbstractTerm;
import org.biojava.ontology.Ontology;
import org.biojava.utils.ChangeType;

public interface Term
extends Annotatable {
    public static final ChangeType ONTOLOGY = new ChangeType("This term's ontology has been changed", "org.biojava.ontology.Term", "ONTOLOGY");

    public String getName();

    public String getDescription();

    public Ontology getOntology();

    public static class Impl
    extends AbstractTerm
    implements Term,
    Serializable {
        private final String name;
        private final String description;
        private final Ontology ontology;
        private Annotation annotation;

        public Impl(Ontology ontology, String name, String description) {
            if (name == null) {
                throw new NullPointerException("Name must not be null");
            }
            if (description == null) {
                throw new NullPointerException("Description must not be null");
            }
            if (ontology == null) {
                throw new NullPointerException("Ontology must not be null");
            }
            this.name = name;
            this.description = description;
            this.ontology = ontology;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Ontology getOntology() {
            return this.ontology;
        }

        public String toString() {
            return this.name;
        }

        public Annotation getAnnotation() {
            if (this.annotation == null) {
                this.annotation = new SmallAnnotation();
            }
            return this.annotation;
        }

        public int hashCode() {
            int value = 17;
            if (this.getName() != null) {
                value *= 31 * this.getName().hashCode();
            }
            return 17 * value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Term)) {
                return false;
            }
            Term that = (Term)obj;
            return this.getOntology() == that.getOntology() && this.getName() == that.getName();
        }
    }
}

