/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.seq.db.biosql.BioSQLFeatureAnnotationChangeHub;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

class BioSQLFeatureAnnotation
implements Annotation {
    private BioSQLSequenceDB seqDB;
    private int feature_id;
    private Annotation underlyingAnnotation;

    BioSQLFeatureAnnotation(BioSQLSequenceDB seqDB, int feature_id) {
        this.seqDB = seqDB;
        this.feature_id = feature_id;
    }

    int getFeatureID() {
        return this.feature_id;
    }

    private void initAnnotations() {
        try {
            Connection conn = this.seqDB.getDataSource().getConnection();
            PreparedStatement get_annotations = conn.prepareStatement("select term.name, seqfeature_qualifier_value.value   from term, seqfeature_qualifier_value  where seqfeature_qualifier_value.seqfeature_id = ? and        term.term_id = seqfeature_qualifier_value.term_id");
            get_annotations.setInt(1, this.feature_id);
            ResultSet rs = get_annotations.executeQuery();
            this.underlyingAnnotation = new SmallAnnotation();
            while (rs.next()) {
                String key = rs.getString(1).trim();
                String value = rs.getString(2);
                try {
                    this.initProperty(key, value);
                }
                catch (ChangeVetoException ex) {
                    throw new BioError(ex);
                }
            }
            rs.close();
            get_annotations.close();
            conn.close();
        }
        catch (SQLException ex) {
            throw new BioRuntimeException("Error fetching annotations", ex);
        }
    }

    public Object getProperty(Object key) {
        if (this.underlyingAnnotation == null) {
            this.initAnnotations();
        }
        return this.underlyingAnnotation.getProperty(key);
    }

    void initProperty(Object key, Object value) throws ChangeVetoException {
        if (this.underlyingAnnotation == null) {
            this.underlyingAnnotation = new SmallAnnotation();
        }
        if (this.underlyingAnnotation.containsProperty(key)) {
            Object oldVal = this.underlyingAnnotation.getProperty(key);
            if (oldVal instanceof Collection) {
                ((Collection)oldVal).add(value);
            } else {
                ArrayList<Object> newList = new ArrayList<Object>();
                newList.add(oldVal);
                newList.add(value);
                this.underlyingAnnotation.setProperty(key, newList);
            }
        } else {
            this.underlyingAnnotation.setProperty(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(Object key, Object value) throws ChangeVetoException {
        BioSQLFeatureAnnotationChangeHub featureAnnotationHub;
        BioSQLFeatureAnnotationChangeHub bioSQLFeatureAnnotationChangeHub = featureAnnotationHub = this.seqDB.getFeatureAnnotationChangeHub();
        synchronized (bioSQLFeatureAnnotationChangeHub) {
            ChangeEvent cev = new ChangeEvent(this, Annotation.PROPERTY, key);
            featureAnnotationHub.firePreChange(cev);
            this._setProperty(key, value);
            featureAnnotationHub.firePostChange(cev);
        }
    }

    private void _setProperty(Object key, Object value) throws ChangeVetoException {
        if (this.underlyingAnnotation != null) {
            this.underlyingAnnotation.setProperty(key, value);
        }
        this.persistProperty(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProperty(Object key) throws ChangeVetoException {
        BioSQLFeatureAnnotationChangeHub featureAnnotationHub;
        if (this.underlyingAnnotation == null) {
            this.initAnnotations();
        }
        if (!this.underlyingAnnotation.containsProperty(key)) {
            throw new NoSuchElementException("Annotation doesn't contain property " + key.toString());
        }
        BioSQLFeatureAnnotationChangeHub bioSQLFeatureAnnotationChangeHub = featureAnnotationHub = this.seqDB.getFeatureAnnotationChangeHub();
        synchronized (bioSQLFeatureAnnotationChangeHub) {
            ChangeEvent cev = new ChangeEvent(this, Annotation.PROPERTY, key);
            featureAnnotationHub.firePreChange(cev);
            this.underlyingAnnotation.removeProperty(key);
            this.persistProperty(key, null);
            featureAnnotationHub.firePostChange(cev);
        }
    }

    private void persistProperty(Object key, Object value) throws ChangeVetoException {
        Connection conn = null;
        try {
            conn = this.seqDB.getDataSource().getConnection();
            conn.setAutoCommit(false);
            this.seqDB.getFeaturesSQL().persistProperty(conn, this.feature_id, key, value, true);
            conn.commit();
            conn.close();
        }
        catch (SQLException ex) {
            boolean rolledback = false;
            if (conn != null) {
                try {
                    conn.rollback();
                    rolledback = true;
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
            }
            throw new BioRuntimeException("Error adding BioSQL tables" + (rolledback ? " (rolled back successfully)" : ""), ex);
        }
    }

    public boolean containsProperty(Object key) {
        if (this.underlyingAnnotation == null) {
            this.initAnnotations();
        }
        return this.underlyingAnnotation.containsProperty(key);
    }

    public Set keys() {
        if (this.underlyingAnnotation == null) {
            this.initAnnotations();
        }
        return this.underlyingAnnotation.keys();
    }

    public Map asMap() {
        if (this.underlyingAnnotation == null) {
            this.initAnnotations();
        }
        return Collections.unmodifiableMap(this.underlyingAnnotation.asMap());
    }

    public void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        this.seqDB.getFeatureAnnotationChangeHub().addListener(new Integer(this.feature_id), cl, ct);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        this.seqDB.getFeatureAnnotationChangeHub().removeListener(new Integer(this.feature_id), cl, ct);
    }

    public boolean isUnchanging(ChangeType ct) {
        return false;
    }
}

