/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import org.biojava.bio.search.BioMatcher;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

class MaxMissmatchMatcher
implements BioMatcher {
    private final SymbolList pattern;
    private final SymbolList seq;
    private final int[] matches;
    private int pos;

    MaxMissmatchMatcher(SymbolList seq, SymbolList pattern, int missmatches) {
        this.seq = seq;
        this.pattern = pattern;
        this.matches = new int[pattern.length()];
        for (int i = 0; i < this.matches.length; ++i) {
            this.matches[i] = missmatches;
        }
        this.pos = 0;
    }

    public boolean find() {
        int length = this.matches.length;
        if (this.pos >= this.seq.length()) {
            return false;
        }
        if (this.pos == 0) {
            if (this.seq.length() < length) {
                return false;
            }
            this.pos = 1;
            while (this.pos <= length) {
                Symbol sym = this.seq.symbolAt(this.pos);
                for (int i = 0; i < length; ++i) {
                    int indx = (i + this.pos) % length + 1;
                    if (sym != this.pattern.symbolAt(indx)) continue;
                    int n = i;
                    this.matches[n] = this.matches[n] + 1;
                }
                ++this.pos;
            }
            if (this.matches[this.matches.length - 1] >= length) {
                return true;
            }
        }
        ++this.pos;
        while (this.pos <= this.seq.length()) {
            Symbol newSym = this.seq.symbolAt(this.pos);
            Symbol oldSym = this.seq.symbolAt(this.pos - length + 1);
            for (int i = 0; i < length; ++i) {
                int indx = (i + this.pos) % length;
                if (oldSym == this.pattern.symbolAt(indx)) {
                    int n = i;
                    this.matches[n] = this.matches[n] - 1;
                }
                if (newSym != this.pattern.symbolAt(indx)) continue;
                int n = i;
                this.matches[n] = this.matches[n] + 1;
            }
            if (this.matches[this.pos % length] >= length) {
                return true;
            }
            ++this.pos;
        }
        this.pos = this.seq.length() + 1;
        return false;
    }

    public int start() {
        return this.pos - this.matches.length + 1;
    }

    public int end() {
        return this.pos;
    }

    public SymbolList group() {
        return this.seq.subList(this.start(), this.end());
    }
}

