/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.unigene;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.program.indexdb.BioStore;
import org.biojava.bio.program.indexdb.Record;
import org.biojava.bio.program.tagvalue.AnnotationBuilder;
import org.biojava.bio.program.tagvalue.Parser;
import org.biojava.bio.program.tagvalue.ParserListener;
import org.biojava.bio.program.unigene.UnigeneCluster;
import org.biojava.bio.program.unigene.UnigeneDB;
import org.biojava.bio.program.unigene.UnigeneTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.AbstractSequenceDB;
import org.biojava.bio.seq.db.CachingSequenceDB;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.ParserException;
import org.biojava.utils.Unchangeable;
import org.biojava.utils.cache.WeakValueHashMap;
import org.biojava.utils.io.RandomAccessReader;

class FlatFileUnigeneDB
extends Unchangeable
implements UnigeneDB {
    private final BioStore dataStore;
    private final BioStore liStore;
    private final BioStore uniqueStore;
    private final BioStore allStore;
    private final Map clusterCache;
    private final Map allCache;
    private final SequenceDB uniqueDB;
    private final ParserListener dataPL;
    private final Parser dataParser;
    private final AnnotationBuilder dataBuilder;

    public FlatFileUnigeneDB(BioStore dataStore, BioStore liStore, BioStore uniqueStore, BioStore allStore) throws BioException {
        this.dataStore = dataStore;
        this.liStore = liStore;
        this.uniqueStore = uniqueStore;
        this.allStore = allStore;
        try {
            this.clusterCache = new WeakValueHashMap();
            this.allCache = new WeakValueHashMap();
            FastaFormat fasta = new FastaFormat();
            this.uniqueDB = new CachingSequenceDB(new BioIndexSequenceDB(uniqueStore, fasta));
            this.dataBuilder = new AnnotationBuilder(UnigeneTools.UNIGENE_ANNOTATION);
            this.dataPL = UnigeneTools.buildDataParser(this.dataBuilder);
            this.dataParser = new Parser();
        }
        catch (ParserException pe) {
            throw new BioException("Could not initialize unigene DB", pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnigeneCluster getCluster(String clusterID) throws BioException {
        UnigeneCluster cluster = (UnigeneCluster)this.clusterCache.get(clusterID);
        if (cluster == null) {
            Parser parser = this.dataParser;
            synchronized (parser) {
                cluster = (UnigeneCluster)this.clusterCache.get(clusterID);
                if (cluster == null) {
                    try {
                        Record rec = this.dataStore.get(clusterID);
                        RandomAccessReader rar = new RandomAccessReader(rec.getFile());
                        rar.seek(rec.getOffset());
                        BufferedReader reader = new BufferedReader(rar);
                        this.dataParser.read(reader, this.dataPL.getParser(), this.dataPL.getListener());
                    }
                    catch (IOException ioe) {
                        throw new BioException("Failed to load cluster: " + clusterID, ioe);
                    }
                    catch (ParserException pe) {
                        throw new BioException("Failed to parse cluster: " + clusterID, pe);
                    }
                }
                cluster = new AnnotationCluster(this.dataBuilder.getLast());
                this.clusterCache.put(clusterID, cluster);
            }
        }
        return cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceDB getAll(String clusterID) throws BioException {
        SequenceDB db = (SequenceDB)this.allCache.get(clusterID);
        if (db == null) {
            SequenceDB sequenceDB = db;
            synchronized (sequenceDB) {
                db = (SequenceDB)this.allCache.get(clusterID);
                if (db == null) {
                    db = new AllDB(this.getCluster(clusterID), this.allStore);
                    this.allCache.put(clusterID, db);
                }
            }
        }
        return db;
    }

    public UnigeneCluster addCluster(UnigeneCluster cluster) throws BioException, ChangeVetoException {
        throw new ChangeVetoException("Can't alter a file-based unigene installation");
    }

    public Sequence getUnique(String clusterID) throws IllegalIDException, BioException {
        return this.uniqueDB.getSequence(clusterID);
    }

    private static class AllDB
    extends AbstractSequenceDB {
        private final Set ids;
        private final BioStore store;
        private final String name;

        public AllDB(UnigeneCluster cluster, BioStore store) {
            this.name = "All:" + cluster.getID();
            this.ids = new HashSet();
            this.store = store;
            Annotation ann = cluster.getAnnotation();
            Set seqs = (Set)ann.getProperty("SEQUENCES");
            Iterator i = seqs.iterator();
            while (i.hasNext()) {
                Annotation sa = (Annotation)i.next();
                this.ids.add(sa.getProperty("ACC"));
            }
        }

        public Set ids() {
            return this.ids;
        }

        public String getName() {
            return this.name;
        }

        public Sequence getSequence(String id) throws BioException {
            try {
                Record rec = this.store.get(id);
                RandomAccessReader rar = new RandomAccessReader(rec.getFile());
                rar.seek(rec.getOffset());
                BufferedReader reader = new BufferedReader(rar);
                return SeqIOTools.readFastaDNA(reader).nextSequence();
            }
            catch (IOException ioe) {
                throw new BioException(ioe);
            }
        }
    }

    private static class BioIndexSequenceDB
    extends AbstractSequenceDB {
        private final BioStore store;
        private final SequenceFormat format;
        private Set ids = null;

        public BioIndexSequenceDB(BioStore store, SequenceFormat format) {
            this.store = store;
            this.format = format;
        }

        public Set ids() {
            if (this.ids == null) {
                this.ids = new AbstractSet(this){
                    private final /* synthetic */ BioIndexSequenceDB this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public int size() {
                        return BioIndexSequenceDB.access$000(this.this$0).getRecordList().size();
                    }

                    public boolean contains(Object o) {
                        return BioIndexSequenceDB.access$000(this.this$0).get((String)o) != null;
                    }

                    public Iterator iterator() {
                        return BioIndexSequenceDB.access$000(this.this$0).getRecordList().iterator();
                    }
                };
            }
            return this.ids;
        }

        public String getName() {
            return "UniqueStore";
        }

        public Sequence getSequence(String id) throws BioException {
            try {
                Record rec = this.store.get(id);
                RandomAccessReader rar = new RandomAccessReader(rec.getFile());
                rar.seek(rec.getOffset());
                BufferedReader reader = new BufferedReader(rar);
                return SeqIOTools.readFastaDNA(reader).nextSequence();
            }
            catch (IOException ioe) {
                throw new BioException(ioe);
            }
        }

        static /* synthetic */ BioStore access$000(BioIndexSequenceDB x0) {
            return x0.store;
        }
    }

    private class AnnotationCluster
    extends Unchangeable
    implements UnigeneCluster {
        private Annotation ann;

        public AnnotationCluster(Annotation ann) {
            this.ann = ann;
        }

        public String getID() {
            return (String)this.ann.getProperty("ID");
        }

        public String getTitle() {
            return (String)this.ann.getProperty("TITLE");
        }

        public SequenceDB getAll() {
            try {
                return FlatFileUnigeneDB.this.getAll(this.getID());
            }
            catch (BioException be) {
                throw new BioError(be);
            }
        }

        public Sequence getUnique() {
            try {
                return FlatFileUnigeneDB.this.getUnique(this.getID());
            }
            catch (BioException be) {
                throw new BioError(be);
            }
        }

        public Annotation getAnnotation() {
            return this.ann;
        }
    }
}

